/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.tasks.Nested;
import org.gradle.caching.configuration.AbstractBuildCache;
import org.gradle.caching.http.HttpBuildCacheCredentials;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;

public abstract class HttpBuildCache
extends AbstractBuildCache {
    private final HttpBuildCacheCredentials credentials = new HttpBuildCacheCredentials();
    private URI url;
    private boolean allowUntrustedServer;
    private boolean allowInsecureProtocol;
    private boolean useExpectContinue;

    @Nullable
    @Nested
    public URI getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.setUrl(URI.create(url));
    }

    public void setUrl(URL url) throws URISyntaxException {
        this.setUrl(url.toURI());
    }

    public void setUrl(@Nullable URI url) {
        this.url = url;
    }

    @Nested
    public HttpBuildCacheCredentials getCredentials() {
        return this.credentials;
    }

    public void credentials(Action<? super HttpBuildCacheCredentials> configuration) {
        configuration.execute((Object)this.credentials);
    }

    @ToBeReplacedByLazyProperty
    public boolean isAllowUntrustedServer() {
        return this.allowUntrustedServer;
    }

    public void setAllowUntrustedServer(boolean allowUntrustedServer) {
        this.allowUntrustedServer = allowUntrustedServer;
    }

    @ToBeReplacedByLazyProperty
    public boolean isAllowInsecureProtocol() {
        return this.allowInsecureProtocol;
    }

    public void setAllowInsecureProtocol(boolean allowInsecureProtocol) {
        this.allowInsecureProtocol = allowInsecureProtocol;
    }

    public void setUseExpectContinue(boolean useExpectContinue) {
        this.useExpectContinue = useExpectContinue;
    }

    @ToBeReplacedByLazyProperty
    public boolean isUseExpectContinue() {
        return this.useExpectContinue;
    }
}

