/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import java.util.List;
import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.objdetect.CharucoBoard;
import org.opencv.objdetect.CharucoParameters;
import org.opencv.objdetect.DetectorParameters;
import org.opencv.objdetect.RefineParameters;
import org.opencv.utils.Converters;

public class CharucoDetector
extends Algorithm {
    protected CharucoDetector(long l) {
        super(l);
    }

    public static CharucoDetector __fromPtr__(long l) {
        return new CharucoDetector(l);
    }

    public CharucoDetector(CharucoBoard charucoBoard, CharucoParameters charucoParameters, DetectorParameters detectorParameters, RefineParameters refineParameters) {
        super(CharucoDetector.CharucoDetector_0(charucoBoard.nativeObj, charucoParameters.nativeObj, detectorParameters.nativeObj, refineParameters.nativeObj));
    }

    public CharucoDetector(CharucoBoard charucoBoard, CharucoParameters charucoParameters, DetectorParameters detectorParameters) {
        super(CharucoDetector.CharucoDetector_1(charucoBoard.nativeObj, charucoParameters.nativeObj, detectorParameters.nativeObj));
    }

    public CharucoDetector(CharucoBoard charucoBoard, CharucoParameters charucoParameters) {
        super(CharucoDetector.CharucoDetector_2(charucoBoard.nativeObj, charucoParameters.nativeObj));
    }

    public CharucoDetector(CharucoBoard charucoBoard) {
        super(CharucoDetector.CharucoDetector_3(charucoBoard.nativeObj));
    }

    public CharucoBoard getBoard() {
        return new CharucoBoard(CharucoDetector.getBoard_0(this.nativeObj));
    }

    public void setBoard(CharucoBoard charucoBoard) {
        CharucoDetector.setBoard_0(this.nativeObj, charucoBoard.nativeObj);
    }

    public CharucoParameters getCharucoParameters() {
        return new CharucoParameters(CharucoDetector.getCharucoParameters_0(this.nativeObj));
    }

    public void setCharucoParameters(CharucoParameters charucoParameters) {
        CharucoDetector.setCharucoParameters_0(this.nativeObj, charucoParameters.nativeObj);
    }

    public DetectorParameters getDetectorParameters() {
        return new DetectorParameters(CharucoDetector.getDetectorParameters_0(this.nativeObj));
    }

    public void setDetectorParameters(DetectorParameters detectorParameters) {
        CharucoDetector.setDetectorParameters_0(this.nativeObj, detectorParameters.nativeObj);
    }

    public RefineParameters getRefineParameters() {
        return new RefineParameters(CharucoDetector.getRefineParameters_0(this.nativeObj));
    }

    public void setRefineParameters(RefineParameters refineParameters) {
        CharucoDetector.setRefineParameters_0(this.nativeObj, refineParameters.nativeObj);
    }

    public void detectBoard(Mat mat, Mat mat2, Mat mat3, List<Mat> list, Mat mat4) {
        Mat mat5 = Converters.vector_Mat_to_Mat(list);
        CharucoDetector.detectBoard_0(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat5.nativeObj, mat4.nativeObj);
        Converters.Mat_to_vector_Mat(mat5, list);
        mat5.release();
    }

    public void detectBoard(Mat mat, Mat mat2, Mat mat3, List<Mat> list) {
        Mat mat4 = Converters.vector_Mat_to_Mat(list);
        CharucoDetector.detectBoard_1(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj, mat4.nativeObj);
        Converters.Mat_to_vector_Mat(mat4, list);
        mat4.release();
    }

    public void detectBoard(Mat mat, Mat mat2, Mat mat3) {
        CharucoDetector.detectBoard_2(this.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public void detectDiamonds(Mat mat, List<Mat> list, Mat mat2, List<Mat> list2, Mat mat3) {
        Mat mat4 = new Mat();
        Mat mat5 = Converters.vector_Mat_to_Mat(list2);
        CharucoDetector.detectDiamonds_0(this.nativeObj, mat.nativeObj, mat4.nativeObj, mat2.nativeObj, mat5.nativeObj, mat3.nativeObj);
        Converters.Mat_to_vector_Mat(mat4, list);
        mat4.release();
        Converters.Mat_to_vector_Mat(mat5, list2);
        mat5.release();
    }

    public void detectDiamonds(Mat mat, List<Mat> list, Mat mat2, List<Mat> list2) {
        Mat mat3 = new Mat();
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        CharucoDetector.detectDiamonds_1(this.nativeObj, mat.nativeObj, mat3.nativeObj, mat2.nativeObj, mat4.nativeObj);
        Converters.Mat_to_vector_Mat(mat3, list);
        mat3.release();
        Converters.Mat_to_vector_Mat(mat4, list2);
        mat4.release();
    }

    public void detectDiamonds(Mat mat, List<Mat> list, Mat mat2) {
        Mat mat3 = new Mat();
        CharucoDetector.detectDiamonds_2(this.nativeObj, mat.nativeObj, mat3.nativeObj, mat2.nativeObj);
        Converters.Mat_to_vector_Mat(mat3, list);
        mat3.release();
    }

    @Override
    protected void finalize() throws Throwable {
        CharucoDetector.delete(this.nativeObj);
    }

    private static native long CharucoDetector_0(long var0, long var2, long var4, long var6);

    private static native long CharucoDetector_1(long var0, long var2, long var4);

    private static native long CharucoDetector_2(long var0, long var2);

    private static native long CharucoDetector_3(long var0);

    private static native long getBoard_0(long var0);

    private static native void setBoard_0(long var0, long var2);

    private static native long getCharucoParameters_0(long var0);

    private static native void setCharucoParameters_0(long var0, long var2);

    private static native long getDetectorParameters_0(long var0);

    private static native void setDetectorParameters_0(long var0, long var2);

    private static native long getRefineParameters_0(long var0);

    private static native void setRefineParameters_0(long var0, long var2);

    private static native void detectBoard_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void detectBoard_1(long var0, long var2, long var4, long var6, long var8);

    private static native void detectBoard_2(long var0, long var2, long var4, long var6);

    private static native void detectDiamonds_0(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native void detectDiamonds_1(long var0, long var2, long var4, long var6, long var8);

    private static native void detectDiamonds_2(long var0, long var2, long var4, long var6);

    private static native void delete(long var0);
}

