/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.face;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfPoint2f;
import org.opencv.core.Scalar;
import org.opencv.face.Facemark;
import org.opencv.utils.Converters;

public class Face {
    public static Facemark createFacemarkAAM() {
        return Facemark.__fromPtr__(Face.createFacemarkAAM_0());
    }

    public static Facemark createFacemarkLBF() {
        return Facemark.__fromPtr__(Face.createFacemarkLBF_0());
    }

    public static Facemark createFacemarkKazemi() {
        return Facemark.__fromPtr__(Face.createFacemarkKazemi_0());
    }

    public static boolean getFacesHAAR(Mat mat, Mat mat2, String string) {
        return Face.getFacesHAAR_0(mat.nativeObj, mat2.nativeObj, string);
    }

    public static boolean loadDatasetList(String string, String string2, List<String> list, List<String> list2) {
        return Face.loadDatasetList_0(string, string2, list, list2);
    }

    public static boolean loadTrainingData(String string, List<String> list, Mat mat, char c, float f) {
        return Face.loadTrainingData_0(string, list, mat.nativeObj, c, f);
    }

    public static boolean loadTrainingData(String string, List<String> list, Mat mat, char c) {
        return Face.loadTrainingData_1(string, list, mat.nativeObj, c);
    }

    public static boolean loadTrainingData(String string, List<String> list, Mat mat) {
        return Face.loadTrainingData_2(string, list, mat.nativeObj);
    }

    public static boolean loadTrainingData(String string, String string2, List<String> list, Mat mat, float f) {
        return Face.loadTrainingData_3(string, string2, list, mat.nativeObj, f);
    }

    public static boolean loadTrainingData(String string, String string2, List<String> list, Mat mat) {
        return Face.loadTrainingData_4(string, string2, list, mat.nativeObj);
    }

    public static boolean loadTrainingData(List<String> list, List<MatOfPoint2f> list2, List<String> list3) {
        ArrayList<Mat> arrayList = new ArrayList<Mat>(list2 != null ? list2.size() : 0);
        Mat mat = Converters.vector_vector_Point2f_to_Mat(list2, arrayList);
        return Face.loadTrainingData_5(list, mat.nativeObj, list3);
    }

    public static boolean loadFacePoints(String string, Mat mat, float f) {
        return Face.loadFacePoints_0(string, mat.nativeObj, f);
    }

    public static boolean loadFacePoints(String string, Mat mat) {
        return Face.loadFacePoints_1(string, mat.nativeObj);
    }

    public static void drawFacemarks(Mat mat, Mat mat2, Scalar scalar) {
        Face.drawFacemarks_0(mat.nativeObj, mat2.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public static void drawFacemarks(Mat mat, Mat mat2) {
        Face.drawFacemarks_1(mat.nativeObj, mat2.nativeObj);
    }

    private static native long createFacemarkAAM_0();

    private static native long createFacemarkLBF_0();

    private static native long createFacemarkKazemi_0();

    private static native boolean getFacesHAAR_0(long var0, long var2, String var4);

    private static native boolean loadDatasetList_0(String var0, String var1, List<String> var2, List<String> var3);

    private static native boolean loadTrainingData_0(String var0, List<String> var1, long var2, char var4, float var5);

    private static native boolean loadTrainingData_1(String var0, List<String> var1, long var2, char var4);

    private static native boolean loadTrainingData_2(String var0, List<String> var1, long var2);

    private static native boolean loadTrainingData_3(String var0, String var1, List<String> var2, long var3, float var5);

    private static native boolean loadTrainingData_4(String var0, String var1, List<String> var2, long var3);

    private static native boolean loadTrainingData_5(List<String> var0, long var1, List<String> var3);

    private static native boolean loadFacePoints_0(String var0, long var1, float var3);

    private static native boolean loadFacePoints_1(String var0, long var1);

    private static native void drawFacemarks_0(long var0, long var2, double var4, double var6, double var8, double var10);

    private static native void drawFacemarks_1(long var0, long var2);
}

