/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import java.util.ArrayList;
import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfPoint3f;
import org.opencv.core.Point3;
import org.opencv.core.Size;
import org.opencv.objdetect.Dictionary;
import org.opencv.utils.Converters;

public class Board {
    protected final long nativeObj;

    protected Board(long l) {
        this.nativeObj = l;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Board __fromPtr__(long l) {
        return new Board(l);
    }

    public Board(List<Mat> list, Dictionary dictionary, Mat mat) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        this.nativeObj = Board.Board_0(mat2.nativeObj, dictionary.nativeObj, mat.nativeObj);
    }

    public Dictionary getDictionary() {
        return new Dictionary(Board.getDictionary_0(this.nativeObj));
    }

    public List<MatOfPoint3f> getObjPoints() {
        ArrayList<MatOfPoint3f> arrayList = new ArrayList<MatOfPoint3f>();
        Mat mat = new Mat(Board.getObjPoints_0(this.nativeObj));
        Converters.Mat_to_vector_vector_Point3f(mat, arrayList);
        return arrayList;
    }

    public MatOfInt getIds() {
        return MatOfInt.fromNativeAddr(Board.getIds_0(this.nativeObj));
    }

    public Point3 getRightBottomCorner() {
        return new Point3(Board.getRightBottomCorner_0(this.nativeObj));
    }

    public void matchImagePoints(List<Mat> list, Mat mat, Mat mat2, Mat mat3) {
        Mat mat4 = Converters.vector_Mat_to_Mat(list);
        Board.matchImagePoints_0(this.nativeObj, mat4.nativeObj, mat.nativeObj, mat2.nativeObj, mat3.nativeObj);
    }

    public void generateImage(Size size, Mat mat, int n, int n2) {
        Board.generateImage_0(this.nativeObj, size.width, size.height, mat.nativeObj, n, n2);
    }

    public void generateImage(Size size, Mat mat, int n) {
        Board.generateImage_1(this.nativeObj, size.width, size.height, mat.nativeObj, n);
    }

    public void generateImage(Size size, Mat mat) {
        Board.generateImage_2(this.nativeObj, size.width, size.height, mat.nativeObj);
    }

    protected void finalize() throws Throwable {
        Board.delete(this.nativeObj);
    }

    private static native long Board_0(long var0, long var2, long var4);

    private static native long getDictionary_0(long var0);

    private static native long getObjPoints_0(long var0);

    private static native long getIds_0(long var0);

    private static native double[] getRightBottomCorner_0(long var0);

    private static native void matchImagePoints_0(long var0, long var2, long var4, long var6, long var8);

    private static native void generateImage_0(long var0, double var2, double var4, long var6, int var8, int var9);

    private static native void generateImage_1(long var0, double var2, double var4, long var6, int var8);

    private static native void generateImage_2(long var0, double var2, double var4, long var6);

    private static native void delete(long var0);
}

