/**
 * @file
 * @brief Header file that includes the version number of libopenshot
 * @author Jonathan Thomas <jonathan@openshot.org>
 *
 * @ref License
 */

// Copyright (c) 2008-2019 OpenShot Studios, LLC
//
// SPDX-License-Identifier: LGPL-3.0-or-later

#ifndef OPENSHOT_VERSION_H
#define OPENSHOT_VERSION_H

#define OPENSHOT_VERSION_ALL "0.4.0"        /// A string of the entire version "Major.Minor.Build"
#define OPENSHOT_VERSION_FULL "0.4.0"   /// A string of the full version identifier, including suffixes (e.g. "0.0.0-dev0")
#define OPENSHOT_VERSION_MAJOR_MINOR "0.4"  /// A string of the "Major.Minor" version

#define OPENSHOT_VERSION_MAJOR 0   /// Major version number is incremented when huge features are added or improved.
#define OPENSHOT_VERSION_MINOR 4   /// Minor version is incremented when smaller (but still very important) improvements are added.
#define OPENSHOT_VERSION_BUILD 0   /// Build number is incremented when minor bug fixes and less important improvements are added.
#define OPENSHOT_VERSION_SO 27         /// Shared object version number. This increments any time the API and ABI changes (so old apps will no longer link)

// Useful dependency versioning / feature availability
#define QT_VERSION_STR "5.15.16"
#define AVCODEC_VERSION_STR "61.19.100"
#define AVFORMAT_VERSION_STR "61.7.100"
#define AVUTIL_VERSION_STR "59.39.100"
/* #undef OPENCV_VERSION_STR */
#define HAVE_BABL 0
#define HAVE_IMAGEMAGICK 0
#define HAVE_RESVG 0
#define HAVE_OPENCV 0
#define FFMPEG_USE_SWRESAMPLE 1
#define APPIMAGE_BUILD 0

#include <sstream>

namespace openshot
{
	/// This struct holds version number information. Use the GetVersion() method to access the current version of libopenshot.
	struct OpenShotVersion {
		static const int Major = OPENSHOT_VERSION_MAJOR; /// Major version number
		static const int Minor = OPENSHOT_VERSION_MINOR; /// Minor version number
		static const int Build = OPENSHOT_VERSION_BUILD; /// Build number
		static const int So = OPENSHOT_VERSION_SO; /// Shared Object Number (incremented when API or ABI changes)

		/// Get a string version of the version (i.e. "Major.Minor.Build")
		inline static const std::string ToString() {
			std::stringstream version_string;
			version_string << Major << "." << Minor << "." << Build;
			return version_string.str();
		}
	};

	static const openshot::OpenShotVersion Version;

	/// Get the current version number of libopenshot (major, minor, and build number)
	openshot::OpenShotVersion GetVersion();
}

#endif // OPENSHOT_VERSION_H
