// Global icons for all applications

#include "config.h"
#include "i18n.h"

#include <fx.h>
#include <FXPNGIcon.h>

#include "xfedefs.h"
#include "xfeutils.h"
#include "icons.h"
#include "MessageBox.h"

// Icons (global variables)

FXIcon* bigattribicon;
FXIcon* bigblockdevicon;
FXIcon* bigbrokenlinkicon;
FXIcon* bigcdromicon;
FXIcon* bigchardevicon;
FXIcon* bigcompareicon;
FXIcon* bigdocicon;
FXIcon* bigexecicon;
FXIcon* bigfileopenicon;
FXIcon* bigfiltericon;
FXIcon* bigfloppyicon;
FXIcon* bigfoldericon;
FXIcon* bigfolderopenicon;
FXIcon* bigfolderlinkicon;
FXIcon* bigfolderupicon;
FXIcon* bigfoldernewicon;
FXIcon* bigfolderlockedicon;
FXIcon* bigfolderremoteicon;
FXIcon* bigharddriveicon;
FXIcon* bignewfileicon;
FXIcon* bignewlinkicon;
FXIcon* bignetdriveicon;
FXIcon* bignetdriveumticon;
FXIcon* bigpipeicon;
FXIcon* bigsocketicon;
FXIcon* bigzipdiskicon;
FXIcon* bigrenameicon;
FXIcon* bigbookmarkicon;
FXIcon* bigaddbookicon;
FXIcon* bigeditbookicon;
FXIcon* bigremovebookicon;
FXIcon* bigcopyicon;
FXIcon* bigdeletepermicon;
FXIcon* bigdeleteicon;
FXIcon* bigerroricon;
FXIcon* biggotoicon;
FXIcon* biglinktoicon;
FXIcon* biglinkicon;
FXIcon* biginfoicon;
FXIcon* bigmoveicon;
FXIcon* bigprinticon;
FXIcon* bigquestionicon;
FXIcon* bigtrashfullicon;
FXIcon* bigwarningicon;
FXIcon* bigrestoreicon;
FXIcon* bigarchaddicon;
FXIcon* bigarchexticon;
FXIcon* bigkeybindingsicon;
FXIcon* bigsearchicon;
FXIcon* bigreplaceicon;
FXIcon* bigrunicon;
FXIcon* biglinkbadgeicon;

FXIcon* miniarchaddicon;
FXIcon* miniarchexticon;
FXIcon* miniattribicon;
FXIcon* minibigiconsicon;
FXIcon* minicdromicon;
FXIcon* minicharticon;
FXIcon* miniclosefileicon;
FXIcon* minicolltreeicon;
FXIcon* minicopyicon;
FXIcon* minicuticon;
FXIcon* miniunselicon;
FXIcon* minidetailsicon;
FXIcon* minidirupicon;
FXIcon* miniediticon;
FXIcon* miniexptreeicon;
FXIcon* minideletepermicon;
FXIcon* minideleteicon;
FXIcon* minifileopenicon;
FXIcon* miniviewicon;
FXIcon* minifiltericon;
FXIcon* minicompareicon;
FXIcon* minifindagainicon;
FXIcon* minifliplricon;
FXIcon* miniflipudicon;
FXIcon* minifloppyicon;
FXIcon* minifontsicon;
FXIcon* minigotodiricon;
FXIcon* minigotoicon;
FXIcon* miniharddriveicon;
FXIcon* minihelpicon;
FXIcon* minihidehiddenicon;
FXIcon* minihidenumbersicon;
FXIcon* minihidethumbicon;
FXIcon* minihomeicon;
FXIcon* minidesktopicon;
FXIcon* miniinvselicon;
FXIcon* minilowercaseicon;
FXIcon* minimounticon;
FXIcon* miniappicon;
FXIcon* miniblockdevicon;
FXIcon* minibrokenlinkicon;
FXIcon* minichardevicon;
FXIcon* minidocicon;
FXIcon* miniexecicon;
FXIcon* minifoldericon;
FXIcon* minifolderopenicon;
FXIcon* minifolderlockedicon;
FXIcon* minifolderlinkicon;
FXIcon* minifolderupicon;
FXIcon* minifolderremoteicon;
FXIcon* minifolderdownloadicon;
FXIcon* minifoldernewicon;
FXIcon* minifolderhomeicon;
FXIcon* minifolderdocumentsicon;
FXIcon* minifolderimagesicon;
FXIcon* minifoldermusicicon;
FXIcon* minifoldervideosicon;
FXIcon* minilinktoicon;
FXIcon* minilinkicon;
FXIcon* minipipeicon;
FXIcon* minishellicon;
FXIcon* minisocketicon;
FXIcon* minimoveicon;
FXIcon* mininewfileicon;
FXIcon* mininetdriveicon;
FXIcon* mininetdriveumticon;
FXIcon* minionepanelicon;
FXIcon* minipackageicon;
FXIcon* minipasteicon;
FXIcon* miniprefsicon;
FXIcon* miniprinticon;
FXIcon* miniquiticon;
FXIcon* miniredoicon;
FXIcon* minireloadicon;
FXIcon* minirenameicon;
FXIcon* minireplaceicon;
FXIcon* minireverticon;
FXIcon* minirotatelefticon;
FXIcon* minirotaterighticon;
FXIcon* minirunicon;
FXIcon* minisaveasicon;
FXIcon* minisavefileicon;
FXIcon* minisearchnexticon;
FXIcon* minisearchicon;
FXIcon* minisearchprevicon;
FXIcon* miniselallicon;
FXIcon* minibookmarkicon;
FXIcon* miniaddbookicon;
FXIcon* minieditbookicon;
FXIcon* miniremovebookicon;
FXIcon* minishowhiddenicon;
FXIcon* minishownumbersicon;
FXIcon* minishowthumbicon;
FXIcon* minismalliconsicon;
FXIcon* minitrashfullicon;
FXIcon* minitreeonepanelicon;
FXIcon* minitreetwopanelsicon;
FXIcon* minitwopanelsicon;
FXIcon* miniundoicon;
FXIcon* miniunmounticon;
FXIcon* miniuppercaseicon;
FXIcon* miniworkicon;
FXIcon* miniwrapofficon;
FXIcon* miniwraponicon;
FXIcon* minizipdiskicon;
FXIcon* minizoom100icon;
FXIcon* minizoominicon;
FXIcon* minizoomouticon;
FXIcon* minizoomwinicon;
FXIcon* minitotrashicon;
FXIcon* minidirbackicon;
FXIcon* minidirforwardicon;
FXIcon* minixferooticon;
FXIcon* minixfeicon;
FXIcon* minifiledialogicon;
FXIcon* miniswitchpanelsicon;
FXIcon* minisyncpanelsicon;
FXIcon* mininewlinkicon;
FXIcon* minigreenbuttonicon;
FXIcon* minigraybuttonicon;
FXIcon* minikeybindingsicon;
FXIcon* minirestoreicon;
FXIcon* minihorzpanelsicon;
FXIcon* minivertpanelsicon;
FXIcon* minitreeicon;
FXIcon* miniplacesicon;
FXIcon* miniupicon;
FXIcon* minidownicon;
FXIcon* miniremovabledeviceicon;
FXIcon* miniclosefiltericon;
FXIcon* minilinkbadgeicon;

FXIcon* xfeicon;
FXIcon* xfaicon;
FXIcon* xfiicon;
FXIcon* xfpicon;
FXIcon* xfwicon;

FXIcon* cmymodeicon;
FXIcon* dialmodeicon;
FXIcon* eyedropicon;
FXIcon* hsvmodeicon;
FXIcon* listmodeicon;
FXIcon* rgbmodeicon;


// Load all application icons as global variables
FXbool loadAppIcons(FXApp* app, FXbool* iconpathfound)
{
	*iconpathfound = true;
	FXbool success = true;

    // Set icon path if it exists, otherwise set icon path to default
    FXString iconpath = app->reg().readStringEntry("SETTINGS", "iconpath", DEFAULTICONPATH);
	if (iconpath[0] == '~')
	{
        iconpath = FXSystem::getHomeDirectory() + iconpath.after('~');
	}

    if ( !existFile(iconpath) )
    {
        iconpath = DEFAULTICONPATH;
        *iconpathfound = false;
    }

    // Colors for blending
    FXColor baseColor = app->getBaseColor();
    FXColor backColor = app->getBackColor();

	// Load icons and set the success flag
	
    // Big icons with base color background
    success = ((bigattribicon = loadiconfile(app, iconpath, "bigattrib.png", baseColor)) != NULL) & success;
	success = ((bigcompareicon = loadiconfile(app, iconpath, "bigcompare.png", baseColor)) != NULL) & success;
	success = ((bigfiltericon = loadiconfile(app, iconpath, "bigfilter.png", baseColor)) != NULL) & success;
	success = ((bigfoldernewicon = loadiconfile(app, iconpath, "bigfoldernew.png", baseColor)) != NULL) & success;
	success = ((bigfolderlinkicon = loadiconfile(app, iconpath, "bigfolderlink.png", baseColor)) != NULL) & success;
	success = ((bignewfileicon = loadiconfile(app, iconpath, "bignewfile.png", baseColor)) != NULL) & success;
	success = ((bignewlinkicon = loadiconfile(app, iconpath, "bignewlink.png", baseColor)) != NULL) & success;
	success = ((bigcopyicon = loadiconfile(app, iconpath, "bigcopy.png", baseColor)) != NULL) & success;
	success = ((bigdeletepermicon = loadiconfile(app, iconpath, "bigdeleteperm.png", baseColor)) != NULL) & success;
	success = ((bigdeleteicon = loadiconfile(app, iconpath, "bigdelete.png", baseColor)) != NULL) & success;
	success = ((bigerroricon = loadiconfile(app, iconpath, "bigerror.png", baseColor)) != NULL) & success;
	success = ((bigfileopenicon = loadiconfile(app, iconpath, "bigfileopen.png", baseColor)) != NULL) & success;
	success = ((biggotoicon = loadiconfile(app, iconpath, "biggoto.png", baseColor)) != NULL) & success;
	success = ((biglinktoicon = loadiconfile(app, iconpath, "biglinkto.png", baseColor)) != NULL) & success;
	success = ((bigmoveicon = loadiconfile(app, iconpath, "bigmove.png", baseColor)) != NULL) & success;
	success = ((bigquestionicon = loadiconfile(app, iconpath, "bigquestion.png", baseColor)) != NULL) & success;
	success = ((bigprinticon = loadiconfile(app, iconpath, "bigprint.png", baseColor)) != NULL) & success;
	success = ((biginfoicon = loadiconfile(app, iconpath, "biginfo.png", baseColor)) != NULL) & success;
	success = ((bigrenameicon = loadiconfile(app, iconpath, "bigrename.png", baseColor)) != NULL) & success;
	success = ((bigbookmarkicon = loadiconfile(app, iconpath, "bigbookmark.png", baseColor)) != NULL) & success;
	success = ((bigaddbookicon = loadiconfile(app, iconpath, "bigaddbook.png", baseColor)) != NULL) & success;
	success = ((bigeditbookicon = loadiconfile(app, iconpath, "bigeditbook.png", baseColor)) != NULL) & success;
	success = ((bigremovebookicon = loadiconfile(app, iconpath, "bigremovebook.png", baseColor)) != NULL) & success;
	success = ((bigwarningicon = loadiconfile(app, iconpath, "bigwarning.png", baseColor)) != NULL) & success;
	success = ((bigtrashfullicon = loadiconfile(app, iconpath, "bigtrashfull.png", baseColor)) != NULL) & success;
	success = ((bigrestoreicon = loadiconfile(app, iconpath, "bigrestore.png", baseColor)) != NULL) & success;
	success = ((bigarchaddicon = loadiconfile(app, iconpath, "bigarchadd.png", baseColor)) != NULL) & success;
	success = ((bigarchexticon = loadiconfile(app, iconpath, "bigarchext.png", baseColor)) != NULL) & success;
	success = ((bigkeybindingsicon = loadiconfile(app, iconpath, "bigkeybindings.png", baseColor)) != NULL) & success;
	success = ((bigsearchicon = loadiconfile(app, iconpath, "bigsearch.png", baseColor)) != NULL) & success;
	success = ((bigreplaceicon = loadiconfile(app, iconpath, "bigreplace.png", baseColor)) != NULL) & success;
	success = ((bigrunicon = loadiconfile(app, iconpath, "bigrun.png", baseColor)) != NULL) & success;
    success = ((biglinkbadgeicon = loadiconfile(app, iconpath, "biglinkbadge.png", baseColor)) != NULL) & success;

    // Big icons with back color background
	success = ((bigblockdevicon = loadiconfile(app, iconpath, "bigblockdev.png", backColor)) != NULL) & success;
	success = ((bigbrokenlinkicon = loadiconfile(app, iconpath, "bigbrokenlink.png", backColor)) != NULL) & success;
	success = ((bigcdromicon = loadiconfile(app, iconpath, "bigcdrom.png", backColor)) != NULL) & success;
	success = ((bigchardevicon = loadiconfile(app, iconpath, "bigchardev.png", backColor)) != NULL) & success;
	success = ((bigdocicon = loadiconfile(app, iconpath, "bigdoc.png", backColor)) != NULL) & success;
	success = ((bigexecicon = loadiconfile(app, iconpath, "bigexec.png", backColor)) != NULL) & success;
	success = ((bigfloppyicon = loadiconfile(app, iconpath, "bigfloppy.png", backColor)) != NULL) & success;
	success = ((bigfolderlockedicon = loadiconfile(app, iconpath, "bigfolderlocked.png", backColor)) != NULL) & success;
	success = ((bigfoldericon = loadiconfile(app, iconpath, "bigfolder.png", backColor)) != NULL) & success;
	success = ((bigfolderopenicon = loadiconfile(app, iconpath, "bigfolderopen.png", backColor)) != NULL) & success;
	success = ((bigfolderupicon = loadiconfile(app, iconpath, "bigfolderup.png", backColor)) != NULL) & success;
	success = ((bigfolderremoteicon = loadiconfile(app, iconpath, "bigfolderremote.png", backColor)) != NULL) & success;
	success = ((bigharddriveicon = loadiconfile(app, iconpath, "bigharddrive.png", backColor)) != NULL) & success;
	success = ((bignetdriveicon = loadiconfile(app, iconpath, "bignetdrive.png", backColor)) != NULL) & success;
	success = ((bignetdriveumticon = loadiconfile(app, iconpath, "bignetdriveumt.png", backColor)) != NULL) & success;
	success = ((bigpipeicon = loadiconfile(app, iconpath, "bigpipe.png", backColor)) != NULL) & success;
	success = ((bigsocketicon = loadiconfile(app, iconpath, "bigsocket.png", backColor)) != NULL) & success;
	success = ((bigzipdiskicon = loadiconfile(app, iconpath, "bigzipdisk.png", backColor)) != NULL) & success;
	success = ((biglinkicon = loadiconfile(app, iconpath, "biglink.png", backColor)) != NULL) & success;

    // Mini icons with base color background
	success = ((miniarchaddicon = loadiconfile(app, iconpath, "miniarchadd.png", baseColor)) != NULL) & success;
	success = ((miniarchexticon = loadiconfile(app, iconpath, "miniarchext.png", baseColor)) != NULL) & success;
	success = ((miniattribicon = loadiconfile(app, iconpath, "miniattrib.png", baseColor)) != NULL) & success;
	success = ((minibigiconsicon = loadiconfile(app, iconpath, "minibigicons.png", baseColor)) != NULL) & success;
	success = ((minicharticon = loadiconfile(app, iconpath, "minichart.png", baseColor)) != NULL) & success;
	success = ((miniclosefileicon = loadiconfile(app, iconpath, "miniclosefile.png", baseColor)) != NULL) & success;
	success = ((miniaddbookicon = loadiconfile(app, iconpath, "miniaddbook.png", baseColor)) != NULL) & success;
	success = ((minieditbookicon = loadiconfile(app, iconpath, "minieditbook.png", baseColor)) != NULL) & success;
	success = ((miniremovebookicon = loadiconfile(app, iconpath, "miniremovebook.png", baseColor)) != NULL) & success;
	success = ((minicolltreeicon = loadiconfile(app, iconpath, "minicolltree.png", baseColor)) != NULL) & success;
	success = ((minicopyicon = loadiconfile(app, iconpath, "minicopy.png", baseColor)) != NULL) & success;
	success = ((minicuticon = loadiconfile(app, iconpath, "minicut.png", baseColor)) != NULL) & success;
	success = ((miniunselicon = loadiconfile(app, iconpath, "miniunsel.png", baseColor)) != NULL) & success;
	success = ((minidetailsicon = loadiconfile(app, iconpath, "minidetails.png", baseColor)) != NULL) & success;
	success = ((minidirupicon = loadiconfile(app, iconpath, "minidirup.png", baseColor)) != NULL) & success;
	success = ((miniediticon = loadiconfile(app, iconpath, "miniedit.png", baseColor)) != NULL) & success;
	success = ((miniexptreeicon = loadiconfile(app, iconpath, "miniexptree.png", baseColor)) != NULL) & success;
	success = ((minicompareicon = loadiconfile(app, iconpath, "minicompare.png", baseColor)) != NULL) & success;
	success = ((minideletepermicon = loadiconfile(app, iconpath, "minideleteperm.png", baseColor)) != NULL) & success;
	success = ((minideleteicon = loadiconfile(app, iconpath, "minidelete.png", baseColor)) != NULL) & success;
	success = ((minifileopenicon = loadiconfile(app, iconpath, "minifileopen.png", baseColor)) != NULL) & success;
	success = ((miniviewicon = loadiconfile(app, iconpath, "miniview.png", baseColor)) != NULL) & success;
	success = ((minifiltericon = loadiconfile(app, iconpath, "minifilter.png", baseColor)) != NULL) & success;
	success = ((minifindagainicon = loadiconfile(app, iconpath, "minifindagain.png", baseColor)) != NULL) & success;
	success = ((minifliplricon = loadiconfile(app, iconpath, "minifliplr.png", baseColor)) != NULL) & success;
	success = ((miniflipudicon = loadiconfile(app, iconpath, "miniflipud.png", baseColor)) != NULL) & success;
	success = ((minifontsicon = loadiconfile(app, iconpath, "minifonts.png", baseColor)) != NULL) & success;
	success = ((minigotodiricon = loadiconfile(app, iconpath, "minigotodir.png", baseColor)) != NULL) & success;
	success = ((minigotoicon = loadiconfile(app, iconpath, "minigoto.png", baseColor)) != NULL) & success;
	success = ((minihelpicon = loadiconfile(app, iconpath, "minihelp.png", baseColor)) != NULL) & success;
	success = ((minihidehiddenicon = loadiconfile(app, iconpath, "minihidehidden.png", baseColor)) != NULL) & success;
	success = ((minihidenumbersicon = loadiconfile(app, iconpath, "minihidenumbers.png", baseColor)) != NULL) & success;
	success = ((minihidethumbicon = loadiconfile(app, iconpath, "minihidethumb.png", baseColor)) != NULL) & success;
	success = ((minihomeicon = loadiconfile(app, iconpath, "minihome.png", baseColor)) != NULL) & success;
	success = ((miniinvselicon = loadiconfile(app, iconpath, "miniinvsel.png", baseColor)) != NULL) & success;
	success = ((minilowercaseicon = loadiconfile(app, iconpath, "minilowercase.png", baseColor)) != NULL) & success;
	success = ((minimounticon = loadiconfile(app, iconpath, "minimount.png", baseColor)) != NULL) & success;
	success = ((minifoldernewicon = loadiconfile(app, iconpath, "minifoldernew.png", baseColor)) != NULL) & success;
	success = ((minilinktoicon = loadiconfile(app, iconpath, "minilinkto.png", baseColor)) != NULL) & success;
	success = ((minishellicon = loadiconfile(app, iconpath, "minishell.png", baseColor)) != NULL) & success;
	success = ((minimoveicon = loadiconfile(app, iconpath, "minimove.png", baseColor)) != NULL) & success;
	success = ((mininewfileicon = loadiconfile(app, iconpath, "mininewfile.png", baseColor)) != NULL) & success;
	success = ((minionepanelicon = loadiconfile(app, iconpath, "minionepanel.png", baseColor)) != NULL) & success;
	success = ((minipackageicon = loadiconfile(app, iconpath, "minipackage.png", baseColor)) != NULL) & success;
	success = ((minipasteicon = loadiconfile(app, iconpath, "minipaste.png", baseColor)) != NULL) & success;
	success = ((miniprefsicon = loadiconfile(app, iconpath, "miniprefs.png", baseColor)) != NULL) & success;
	success = ((miniprinticon = loadiconfile(app, iconpath, "miniprint.png", baseColor)) != NULL) & success;
	success = ((miniquiticon = loadiconfile(app, iconpath, "miniquit.png", baseColor)) != NULL) & success;
	success = ((miniredoicon = loadiconfile(app, iconpath, "miniredo.png", baseColor)) != NULL) & success;
	success = ((minireloadicon = loadiconfile(app, iconpath, "minireload.png", baseColor)) != NULL) & success;
	success = ((minirenameicon = loadiconfile(app, iconpath, "minirename.png", baseColor)) != NULL) & success;
	success = ((minireplaceicon = loadiconfile(app, iconpath, "minireplace.png", baseColor)) != NULL) & success;
	success = ((minireverticon = loadiconfile(app, iconpath, "minirevert.png", baseColor)) != NULL) & success;
	success = ((minirotatelefticon = loadiconfile(app, iconpath, "minirotateleft.png", baseColor)) != NULL) & success;
	success = ((minirotaterighticon = loadiconfile(app, iconpath, "minirotateright.png", baseColor)) != NULL) & success;
	success = ((minirunicon = loadiconfile(app, iconpath, "minirun.png", baseColor)) != NULL) & success;
	success = ((minisaveasicon = loadiconfile(app, iconpath, "minisaveas.png", baseColor)) != NULL) & success;
	success = ((minisavefileicon = loadiconfile(app, iconpath, "minisavefile.png", baseColor)) != NULL) & success;
	success = ((minisearchnexticon = loadiconfile(app, iconpath, "minisearchnext.png", baseColor)) != NULL) & success;
	success = ((minisearchicon = loadiconfile(app, iconpath, "minisearch.png", baseColor)) != NULL) & success;
	success = ((minisearchprevicon = loadiconfile(app, iconpath, "minisearchprev.png", baseColor)) != NULL) & success;
	success = ((miniselallicon = loadiconfile(app, iconpath, "miniselall.png", baseColor)) != NULL) & success;
	success = ((minishowhiddenicon = loadiconfile(app, iconpath, "minishowhidden.png", baseColor)) != NULL) & success;
	success = ((minishownumbersicon = loadiconfile(app, iconpath, "minishownumbers.png", baseColor)) != NULL) & success;
	success = ((minishowthumbicon = loadiconfile(app, iconpath, "minishowthumb.png", baseColor)) != NULL) & success;
	success = ((minismalliconsicon = loadiconfile(app, iconpath, "minismallicons.png", baseColor)) != NULL) & success;
	success = ((minitrashfullicon = loadiconfile(app, iconpath, "minitrashfull.png", baseColor)) != NULL) & success;
	success = ((minitreeonepanelicon = loadiconfile(app, iconpath, "minitreeonepanel.png", baseColor)) != NULL) & success;
	success = ((minitreetwopanelsicon = loadiconfile(app, iconpath, "minitreetwopanels.png", baseColor)) != NULL) & success;
	success = ((minitwopanelsicon = loadiconfile(app, iconpath, "minitwopanels.png", baseColor)) != NULL) & success;
	success = ((miniundoicon = loadiconfile(app, iconpath, "miniundo.png", baseColor)) != NULL) & success;
	success = ((miniunmounticon = loadiconfile(app, iconpath, "miniunmount.png", baseColor)) != NULL) & success;
	success = ((miniuppercaseicon = loadiconfile(app, iconpath, "miniuppercase.png", baseColor)) != NULL) & success;
	success = ((miniworkicon = loadiconfile(app, iconpath, "miniwork.png", baseColor)) != NULL) & success;
	success = ((miniwrapofficon = loadiconfile(app, iconpath, "miniwrapoff.png", baseColor)) != NULL) & success;
	success = ((miniwraponicon = loadiconfile(app, iconpath, "miniwrapon.png", baseColor)) != NULL) & success;
	success = ((minizoom100icon = loadiconfile(app, iconpath, "minizoom100.png", baseColor)) != NULL) & success;
	success = ((minizoominicon = loadiconfile(app, iconpath, "minizoomin.png", baseColor)) != NULL) & success;
	success = ((minizoomouticon = loadiconfile(app, iconpath, "minizoomout.png", baseColor)) != NULL) & success;
	success = ((minizoomwinicon = loadiconfile(app, iconpath, "minizoomwin.png", baseColor)) != NULL) & success;
	success = ((minitotrashicon = loadiconfile(app, iconpath, "minitotrash.png", baseColor)) != NULL) & success;
	success = ((minidirbackicon = loadiconfile(app, iconpath, "minidirback.png", baseColor)) != NULL) & success;
	success = ((minidirforwardicon = loadiconfile(app, iconpath, "minidirforward.png", baseColor)) != NULL) & success;
	success = ((minixferooticon = loadiconfile(app, iconpath, "minixferoot.png", baseColor)) != NULL) & success;
	success = ((minixfeicon = loadiconfile(app, iconpath, "minixfe.png", baseColor)) != NULL) & success;
	success = ((minifiledialogicon = loadiconfile(app, iconpath, "minifiledialog.png", baseColor)) != NULL) & success;
	success = ((miniswitchpanelsicon = loadiconfile(app, iconpath, "miniswitchpanels.png", baseColor)) != NULL) & success;
	success = ((minisyncpanelsicon = loadiconfile(app, iconpath, "minisyncpanels.png", baseColor)) != NULL) & success;
	success = ((mininewlinkicon = loadiconfile(app, iconpath, "mininewlink.png", baseColor)) != NULL) & success;
	success = ((minigreenbuttonicon = loadiconfile(app, iconpath, "minigreenbutton.png", baseColor)) != NULL) & success;
	success = ((minigraybuttonicon = loadiconfile(app, iconpath, "minigraybutton.png", baseColor)) != NULL) & success;
	success = ((minikeybindingsicon = loadiconfile(app, iconpath, "minikeybindings.png", baseColor)) != NULL) & success;
	success = ((minikeybindingsicon = loadiconfile(app, iconpath, "minikeybindings.png", baseColor)) != NULL) & success;
	success = ((minirestoreicon = loadiconfile(app, iconpath, "minirestore.png", baseColor)) != NULL) & success;
	success = ((minihorzpanelsicon = loadiconfile(app, iconpath, "minihorzpanels.png", baseColor)) != NULL) & success;
	success = ((minivertpanelsicon = loadiconfile(app, iconpath, "minivertpanels.png", baseColor)) != NULL) & success;
	success = ((minitreeicon = loadiconfile(app, iconpath, "minitree.png", baseColor)) != NULL) & success;
	success = ((miniplacesicon = loadiconfile(app, iconpath, "miniplaces.png", baseColor)) != NULL) & success;
	success = ((miniupicon = loadiconfile(app, iconpath, "miniup.png", baseColor)) != NULL) & success;
	success = ((minidownicon = loadiconfile(app, iconpath, "minidown.png", baseColor)) != NULL) & success;
	success = ((miniremovabledeviceicon = loadiconfile(app, iconpath, "miniremovabledevice.png", baseColor)) != NULL) & success;
	success = ((miniclosefiltericon = loadiconfile(app, iconpath, "miniclosefilter.png", baseColor)) != NULL) & success;
    success = ((minilinkbadgeicon = loadiconfile(app, iconpath, "minilinkbadge.png", baseColor)) != NULL) & success;

    // Mini icons with back color background
	success = ((minicdromicon = loadiconfile(app, iconpath, "minicdrom.png", backColor)) != NULL) & success;
	success = ((minibookmarkicon = loadiconfile(app, iconpath, "minibookmark.png", backColor)) != NULL) & success;
	success = ((minifloppyicon = loadiconfile(app, iconpath, "minifloppy.png", backColor)) != NULL) & success;
	success = ((miniharddriveicon = loadiconfile(app, iconpath, "miniharddrive.png", backColor)) != NULL) & success;
	success = ((minidesktopicon = loadiconfile(app, iconpath, "minidesktop.png", backColor)) != NULL) & success;
	success = ((miniblockdevicon = loadiconfile(app, iconpath, "miniblockdev.png", backColor)) != NULL) & success;
	success = ((minibrokenlinkicon = loadiconfile(app, iconpath, "minibrokenlink.png", backColor)) != NULL) & success;
	success = ((minichardevicon = loadiconfile(app, iconpath, "minichardev.png", backColor)) != NULL) & success;
	success = ((minidocicon = loadiconfile(app, iconpath, "minidoc.png", backColor)) != NULL) & success;
	success = ((miniexecicon = loadiconfile(app, iconpath, "miniexec.png", backColor)) != NULL) & success;
	success = ((minifolderlockedicon = loadiconfile(app, iconpath, "minifolderlocked.png", backColor)) != NULL) & success;
	success = ((minifolderopenicon = loadiconfile(app, iconpath, "minifolderopen.png", backColor)) != NULL) & success;
	success = ((minifoldericon = loadiconfile(app, iconpath, "minifolder.png", backColor)) != NULL) & success;
	success = ((minifolderlinkicon = loadiconfile(app, iconpath, "minifolderlink.png", backColor)) != NULL) & success;
	success = ((minifolderupicon = loadiconfile(app, iconpath, "minifolderup.png", backColor)) != NULL) & success;
	success = ((minifolderremoteicon = loadiconfile(app, iconpath, "minifolderremote.png", backColor)) != NULL) & success;
	success = ((minifolderhomeicon = loadiconfile(app, iconpath, "minifolderhome.png", backColor)) != NULL) & success;
	success = ((miniappicon = loadiconfile(app, iconpath, "miniapp.png", backColor)) != NULL) & success;
	success = ((minifolderdownloadicon = loadiconfile(app, iconpath, "minifolderdownload.png", backColor)) != NULL) & success;
	success = ((minifolderdocumentsicon = loadiconfile(app, iconpath, "minifolderdocuments.png", backColor)) != NULL) & success;
	success = ((minifoldermusicicon = loadiconfile(app, iconpath, "minifoldermusic.png", backColor)) != NULL) & success;
	success = ((minifolderimagesicon = loadiconfile(app, iconpath, "minifolderimages.png", backColor)) != NULL) & success;
	success = ((minifoldervideosicon = loadiconfile(app, iconpath, "minifoldervideos.png", backColor)) != NULL) & success;
	success = ((minilinkicon = loadiconfile(app, iconpath, "minilink.png", backColor)) != NULL) & success;
	success = ((minipipeicon = loadiconfile(app, iconpath, "minipipe.png", backColor)) != NULL) & success;
	success = ((minisocketicon = loadiconfile(app, iconpath, "minisocket.png", backColor)) != NULL) & success;
	success = ((mininetdriveicon = loadiconfile(app, iconpath, "mininetdrive.png", backColor)) != NULL) & success;
	success = ((mininetdriveumticon = loadiconfile(app, iconpath, "mininetdriveumt.png", backColor)) != NULL) & success;
	success = ((minizipdiskicon = loadiconfile(app, iconpath, "minizipdisk.png", backColor)) != NULL) & success;

    // Mini icons with base color background
	success = ((xfeicon = loadiconfile(app, iconpath, "xfe.png", baseColor)) != NULL) & success;
	success = ((xfaicon = loadiconfile(app, iconpath, "xfa.png", baseColor)) != NULL) & success;
	success = ((xfiicon = loadiconfile(app, iconpath, "xfi.png", baseColor)) != NULL) & success;
	success = ((xfpicon = loadiconfile(app, iconpath, "xfp.png", baseColor)) != NULL) & success;
	success = ((xfwicon = loadiconfile(app, iconpath, "xfw.png", baseColor)) != NULL) & success;

    // Mini icons with base color background
	success = ((cmymodeicon = loadiconfile(app, iconpath, "cmymode.png", baseColor)) != NULL) & success;
	success = ((dialmodeicon = loadiconfile(app, iconpath, "dialmode.png", baseColor)) != NULL) & success;
	success = ((eyedropicon = loadiconfile(app, iconpath, "eyedrop.png", baseColor)) != NULL) & success;
	success = ((hsvmodeicon = loadiconfile(app, iconpath, "hsvmode.png", baseColor)) != NULL) & success;
	success = ((listmodeicon = loadiconfile(app, iconpath, "listmode.png", baseColor)) != NULL) & success;
	success = ((rgbmodeicon = loadiconfile(app, iconpath, "rgbmode.png", baseColor)) != NULL) & success;

	return success;
}
