#ifndef _IPXE_ERRNO_PCBIOS_H
#define _IPXE_ERRNO_PCBIOS_H

/**
 * @file
 *
 * PC-BIOS platform error codes
 *
 * We use the PXE-specified error codes as the platform error codes
 * for the PC-BIOS platform.
 */

FILE_LICENCE ( GPL2_OR_LATER_OR_UBDL );

#include <pxe_error.h>

/**
 * Convert platform error code to platform component of iPXE error code
 *
 * @v platform		Platform error code
 * @ret errno		Platform component of iPXE error code
 */
#define PLATFORM_TO_ERRNO( platform ) ( (platform) & 0xff )

/**
 * Convert iPXE error code to platform error code
 *
 * @v errno		iPXE error code
 * @ret platform	Platform error code
 */
#define ERRNO_TO_PLATFORM( errno ) ( (errno) & 0xff )

/* Platform-specific error codes */
#define PLATFORM_ENOERR		PXENV_STATUS_SUCCESS
#define PLATFORM_E2BIG		PXENV_STATUS_BAD_FUNC
#define PLATFORM_EACCES		PXENV_STATUS_TFTP_ACCESS_VIOLATION
#define PLATFORM_EADDRINUSE	PXENV_STATUS_UDP_OPEN
#define PLATFORM_EADDRNOTAVAIL	PXENV_STATUS_UDP_OPEN
#define PLATFORM_EAFNOSUPPORT	PXENV_STATUS_UNSUPPORTED
#define PLATFORM_EAGAIN		PXENV_STATUS_FAILURE
#define PLATFORM_EALREADY	PXENV_STATUS_UDP_OPEN
#define PLATFORM_EBADF		PXENV_STATUS_TFTP_CLOSED
#define PLATFORM_EBADMSG	PXENV_STATUS_FAILURE
#define PLATFORM_EBUSY		PXENV_STATUS_OUT_OF_RESOURCES
#define PLATFORM_ECANCELED	PXENV_STATUS_BINL_CANCELED_BY_KEYSTROKE
#define PLATFORM_ECHILD		PXENV_STATUS_TFTP_FILE_NOT_FOUND
#define PLATFORM_ECONNABORTED	PXENV_STATUS_TFTP_CANNOT_READ_FROM_CONNECTION
#define PLATFORM_ECONNREFUSED	PXENV_STATUS_TFTP_CANNOT_OPEN_CONNECTION
#define PLATFORM_ECONNRESET	PXENV_STATUS_TFTP_CANNOT_READ_FROM_CONNECTION
#define PLATFORM_EDEADLK	PXENV_STATUS_FAILURE
#define PLATFORM_EDESTADDRREQ	PXENV_STATUS_BAD_FUNC
#define PLATFORM_EDOM		PXENV_STATUS_FAILURE
#define PLATFORM_EDQUOT		PXENV_STATUS_FAILURE
#define PLATFORM_EEXIST		PXENV_STATUS_FAILURE
#define PLATFORM_EFAULT		PXENV_STATUS_MCOPY_PROBLEM
#define PLATFORM_EFBIG		PXENV_STATUS_MCOPY_PROBLEM
#define PLATFORM_EHOSTUNREACH	PXENV_STATUS_ARP_TIMEOUT
#define PLATFORM_EIDRM		PXENV_STATUS_FAILURE
#define PLATFORM_EILSEQ		PXENV_STATUS_FAILURE
#define PLATFORM_EINPROGRESS	PXENV_STATUS_FAILURE
#define PLATFORM_EINTR		PXENV_STATUS_FAILURE
#define PLATFORM_EINVAL		PXENV_STATUS_BAD_FUNC
#define PLATFORM_EIO		PXENV_STATUS_TFTP_CANNOT_READ_FROM_CONNECTION
#define PLATFORM_EISCONN	PXENV_STATUS_UDP_OPEN
#define PLATFORM_EISDIR		PXENV_STATUS_FAILURE
#define PLATFORM_ELOOP		PXENV_STATUS_FAILURE
#define PLATFORM_EMFILE		PXENV_STATUS_OUT_OF_RESOURCES
#define PLATFORM_EMLINK		PXENV_STATUS_FAILURE
#define PLATFORM_EMSGSIZE	PXENV_STATUS_BAD_FUNC
#define PLATFORM_EMULTIHOP	PXENV_STATUS_FAILURE
#define PLATFORM_ENAMETOOLONG	PXENV_STATUS_FAILURE
#define PLATFORM_ENETDOWN	PXENV_STATUS_ARP_TIMEOUT
#define PLATFORM_ENETRESET	PXENV_STATUS_FAILURE
#define PLATFORM_ENETUNREACH	PXENV_STATUS_ARP_TIMEOUT
#define PLATFORM_ENFILE		PXENV_STATUS_OUT_OF_RESOURCES
#define PLATFORM_ENOBUFS	PXENV_STATUS_OUT_OF_RESOURCES
#define PLATFORM_ENODATA	PXENV_STATUS_FAILURE
#define PLATFORM_ENODEV		PXENV_STATUS_TFTP_FILE_NOT_FOUND
#define PLATFORM_ENOENT		PXENV_STATUS_TFTP_FILE_NOT_FOUND
#define PLATFORM_ENOEXEC	PXENV_STATUS_FAILURE
#define PLATFORM_ENOLCK		PXENV_STATUS_FAILURE
#define PLATFORM_ENOLINK	PXENV_STATUS_FAILURE
#define PLATFORM_ENOMEM		PXENV_STATUS_OUT_OF_RESOURCES
#define PLATFORM_ENOMSG		PXENV_STATUS_FAILURE
#define PLATFORM_ENOPROTOOPT	PXENV_STATUS_UNSUPPORTED
#define PLATFORM_ENOSPC		PXENV_STATUS_OUT_OF_RESOURCES
#define PLATFORM_ENOSR		PXENV_STATUS_OUT_OF_RESOURCES
#define PLATFORM_ENOSTR		PXENV_STATUS_FAILURE
#define PLATFORM_ENOSYS		PXENV_STATUS_UNSUPPORTED
#define PLATFORM_ENOTCONN	PXENV_STATUS_FAILURE
#define PLATFORM_ENOTDIR	PXENV_STATUS_FAILURE
#define PLATFORM_ENOTEMPTY	PXENV_STATUS_FAILURE
#define PLATFORM_ENOTSOCK	PXENV_STATUS_FAILURE
#define PLATFORM_ENOTSUP	PXENV_STATUS_UNSUPPORTED
#define PLATFORM_ENOTTY		PXENV_STATUS_FAILURE
#define PLATFORM_ENXIO		PXENV_STATUS_TFTP_FILE_NOT_FOUND
#define PLATFORM_EOPNOTSUPP	PXENV_STATUS_UNSUPPORTED
#define PLATFORM_EOVERFLOW	PXENV_STATUS_FAILURE
#define PLATFORM_EPERM		PXENV_STATUS_TFTP_ACCESS_VIOLATION
#define PLATFORM_EPIPE		PXENV_STATUS_FAILURE
#define PLATFORM_EPROTO		PXENV_STATUS_FAILURE
#define PLATFORM_EPROTONOSUPPORT PXENV_STATUS_UNSUPPORTED
#define PLATFORM_EPROTOTYPE	PXENV_STATUS_FAILURE
#define PLATFORM_ERANGE		PXENV_STATUS_FAILURE
#define PLATFORM_EROFS		PXENV_STATUS_FAILURE
#define PLATFORM_ESPIPE		PXENV_STATUS_FAILURE
#define PLATFORM_ESRCH		PXENV_STATUS_TFTP_FILE_NOT_FOUND
#define PLATFORM_ESTALE		PXENV_STATUS_FAILURE
#define PLATFORM_ETIME		PXENV_STATUS_FAILURE
#define PLATFORM_ETIMEDOUT	PXENV_STATUS_TFTP_READ_TIMEOUT
#define PLATFORM_ETXTBSY	PXENV_STATUS_FAILURE
#define PLATFORM_EWOULDBLOCK	PXENV_STATUS_TFTP_OPEN
#define PLATFORM_EXDEV		PXENV_STATUS_FAILURE

#endif /* _IPXE_ERRNO_PCBIOS_H */
