/*
 * Decompiled with CFR 0.152.
 */
package com.qualeed.qbackup;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.spi.ContextAwareBase;
import com.qualeed.qbackup.e.e;
import com.qualeed.qbackup.h;
import com.qualeed.qbackup.m.i;
import java.io.IOException;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;

public class LoggingConfigurator
extends ContextAwareBase
implements Configurator {
    private static final Level a = Level.OFF;

    public void configure(LoggerContext loggerContext) {
        Logger logger = loggerContext.getLogger("ROOT");
        logger.setLevel(a);
    }

    public static void setLevel(String string2) {
        if (i.a(string2)) {
            return;
        }
        Level level = Level.toLevel((String)string2, (Level)a);
        Logger logger = (Logger)LoggerFactory.getLogger((String)"ROOT");
        LoggerContext loggerContext = logger.getLoggerContext();
        loggerContext.reset();
        PatternLayoutEncoder patternLayoutEncoder = new PatternLayoutEncoder();
        patternLayoutEncoder.setContext((Context)loggerContext);
        patternLayoutEncoder.setPattern("%d{yyyy-MM-dd'T'HH:mm:ss.SSSZ} %-5level [%thread] %logger{36}.%method - %msg%n");
        patternLayoutEncoder.start();
        FileAppender<ILoggingEvent> fileAppender = LoggingConfigurator.getFileAppender();
        if (fileAppender == null) {
            fileAppender = LoggingConfigurator.getConsoleAppender();
        }
        fileAppender.setContext((Context)loggerContext);
        fileAppender.setEncoder((Encoder)patternLayoutEncoder);
        fileAppender.start();
        logger.addAppender(fileAppender);
        logger.setLevel(level);
        if (!level.isGreaterOrEqual(Level.WARN)) {
            Stream.of("com.amazonaws", "org.apache.http", "org.hibernate.validator").forEach(string -> {
                Logger logger = (Logger)LoggerFactory.getLogger((String)string);
                logger.setLevel(Level.WARN);
            });
        }
    }

    private static FileAppender<ILoggingEvent> getFileAppender() {
        Path path = h.c;
        try {
            e.g(path);
        }
        catch (IOException iOException) {
            return null;
        }
        Path path2 = path.resolve("debug.log");
        FileAppender fileAppender = new FileAppender();
        fileAppender.setName("file");
        fileAppender.setFile(path2.toString());
        return fileAppender;
    }

    private static ConsoleAppender<ILoggingEvent> getConsoleAppender() {
        ConsoleAppender consoleAppender = new ConsoleAppender();
        consoleAppender.setName("console");
        return consoleAppender;
    }
}

