/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.tracing.ApiTracer;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.threeten.bp.Duration;

@BetaApi(value="Surface for tracing is not yet stable")
public class OpencensusTracer
implements ApiTracer {
    private final Tracer tracer;
    private final Span span;
    private volatile long currentAttemptId;
    private AtomicLong attemptSentMessages = new AtomicLong(0L);
    private long attemptReceivedMessages = 0L;
    private AtomicLong totalSentMessages = new AtomicLong(0L);
    private long totalReceivedMessages = 0L;

    OpencensusTracer(@Nonnull Tracer tracer, @Nonnull Span span) {
        this.tracer = (Tracer)Preconditions.checkNotNull((Object)tracer, (Object)"tracer can't be null");
        this.span = (Span)Preconditions.checkNotNull((Object)span, (Object)"span can't be null");
    }

    @Override
    public ApiTracer.Scope inScope() {
        final Scope scope = this.tracer.withSpan(this.span);
        return new ApiTracer.Scope(){

            @Override
            public void close() {
                scope.close();
            }
        };
    }

    @Override
    public void operationSucceeded() {
        Map<String, AttributeValue> attributes = this.baseOperationAttributes();
        this.span.putAttributes(attributes);
        this.span.end();
    }

    @Override
    public void operationCancelled() {
        Map<String, AttributeValue> attributes = this.baseOperationAttributes();
        this.span.putAttributes(attributes);
        this.span.end(EndSpanOptions.builder().setStatus(Status.CANCELLED.withDescription("Cancelled by caller")).build());
    }

    @Override
    public void operationFailed(Throwable error) {
        Map<String, AttributeValue> attributes = this.baseOperationAttributes();
        this.span.putAttributes(attributes);
        this.span.end(EndSpanOptions.builder().setStatus(OpencensusTracer.convertErrorToStatus(error)).build());
    }

    @Override
    public void connectionSelected(int id) {
        this.span.addAnnotation("Connection selected", (Map)ImmutableMap.of((Object)"id", (Object)AttributeValue.longAttributeValue((long)id)));
    }

    @Override
    public void attemptStarted(int attemptNumber) {
        this.currentAttemptId = attemptNumber;
        this.attemptSentMessages.set(0L);
        this.attemptReceivedMessages = 0L;
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        this.populateAttemptNumber(attributes);
        this.span.addAnnotation("Attempt started", attributes);
    }

    @Override
    public void attemptSucceeded() {
        Map<String, AttributeValue> attributes = this.baseAttemptAttributes();
        this.span.addAnnotation("Attempt succeeded", attributes);
    }

    @Override
    public void attemptCancelled() {
        Map<String, AttributeValue> attributes = this.baseAttemptAttributes();
        this.span.addAnnotation("Attempt cancelled", attributes);
    }

    @Override
    public void attemptFailed(Throwable error, Duration delay) {
        Map<String, AttributeValue> attributes = this.baseAttemptAttributes();
        attributes.put("delay ms", AttributeValue.longAttributeValue((long)delay.toMillis()));
        this.populateError(attributes, error);
        String msg = error != null ? "Attempt failed" : "Operation incomplete";
        this.span.addAnnotation(msg + ", scheduling next attempt", attributes);
    }

    @Override
    public void attemptFailedRetriesExhausted(Throwable error) {
        Map<String, AttributeValue> attributes = this.baseAttemptAttributes();
        this.populateError(attributes, error);
        this.span.addAnnotation("Attempts exhausted", attributes);
    }

    @Override
    public void attemptPermanentFailure(Throwable error) {
        Map<String, AttributeValue> attributes = this.baseAttemptAttributes();
        this.populateError(attributes, error);
        this.span.addAnnotation("Attempt failed, error not retryable", attributes);
    }

    @Override
    public void responseReceived() {
        ++this.attemptReceivedMessages;
        ++this.totalReceivedMessages;
    }

    @Override
    public void requestSent() {
        this.attemptSentMessages.incrementAndGet();
        this.totalSentMessages.incrementAndGet();
    }

    @Override
    public void batchRequestSent(long elementCount, long requestSize) {
        this.span.putAttribute("batch count", AttributeValue.longAttributeValue((long)elementCount));
        this.span.putAttribute("batch size", AttributeValue.longAttributeValue((long)requestSize));
    }

    private Map<String, AttributeValue> baseOperationAttributes() {
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        attributes.put("attempt count", AttributeValue.longAttributeValue((long)(this.currentAttemptId + 1L)));
        long localTotalSentMessages = this.totalSentMessages.get();
        if (localTotalSentMessages > 0L) {
            attributes.put("total request count", AttributeValue.longAttributeValue((long)localTotalSentMessages));
        }
        if (this.totalReceivedMessages > 0L) {
            attributes.put("total response count", AttributeValue.longAttributeValue((long)this.totalReceivedMessages));
        }
        return attributes;
    }

    private Map<String, AttributeValue> baseAttemptAttributes() {
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        this.populateAttemptNumber(attributes);
        long localAttemptSentMessages = this.attemptSentMessages.get();
        if (localAttemptSentMessages > 0L) {
            attributes.put("attempt request count", AttributeValue.longAttributeValue((long)localAttemptSentMessages));
        }
        if (this.attemptReceivedMessages > 0L) {
            attributes.put("attempt response count", AttributeValue.longAttributeValue((long)this.attemptReceivedMessages));
        }
        return attributes;
    }

    private void populateAttemptNumber(Map<String, AttributeValue> attributes) {
        attributes.put("attempt", AttributeValue.longAttributeValue((long)this.currentAttemptId));
    }

    private void populateError(Map<String, AttributeValue> attributes, Throwable error) {
        if (error == null) {
            attributes.put("status", null);
            return;
        }
        Status status = OpencensusTracer.convertErrorToStatus(error);
        attributes.put("status", AttributeValue.stringAttributeValue((String)status.getCanonicalCode().toString()));
    }

    @InternalApi(value="Visible for testing")
    static Status convertErrorToStatus(Throwable error) {
        Status.CanonicalCode code;
        if (!(error instanceof ApiException)) {
            return Status.UNKNOWN.withDescription(error.getMessage());
        }
        ApiException apiException = (ApiException)error;
        try {
            code = Status.CanonicalCode.valueOf((String)apiException.getStatusCode().getCode().name());
        }
        catch (IllegalArgumentException e) {
            code = Status.CanonicalCode.UNKNOWN;
        }
        return code.toStatus().withDescription(error.getMessage());
    }
}

