// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: openfga/v1/openfga_service.proto

package openfgav1

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on ListObjectsRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ListObjectsRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListObjectsRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ListObjectsRequestMultiError, or nil if none found.
func (m *ListObjectsRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *ListObjectsRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_ListObjectsRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := ListObjectsRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetAuthorizationModelId() != "" {

		if !_ListObjectsRequest_AuthorizationModelId_Pattern.MatchString(m.GetAuthorizationModelId()) {
			err := ListObjectsRequestValidationError{
				field:  "AuthorizationModelId",
				reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if !_ListObjectsRequest_Type_Pattern.MatchString(m.GetType()) {
		err := ListObjectsRequestValidationError{
			field:  "Type",
			reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,254}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_ListObjectsRequest_Relation_Pattern.MatchString(m.GetRelation()) {
		err := ListObjectsRequestValidationError{
			field:  "Relation",
			reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if l := len(m.GetUser()); l < 1 || l > 512 {
		err := ListObjectsRequestValidationError{
			field:  "User",
			reason: "value length must be between 1 and 512 bytes, inclusive",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetContextualTuples()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListObjectsRequestValidationError{
					field:  "ContextualTuples",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListObjectsRequestValidationError{
					field:  "ContextualTuples",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContextualTuples()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListObjectsRequestValidationError{
				field:  "ContextualTuples",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListObjectsRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListObjectsRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListObjectsRequestValidationError{
				field:  "Context",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := ConsistencyPreference_name[int32(m.GetConsistency())]; !ok {
		err := ListObjectsRequestValidationError{
			field:  "Consistency",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ListObjectsRequestMultiError(errors)
	}

	return nil
}

// ListObjectsRequestMultiError is an error wrapping multiple validation errors
// returned by ListObjectsRequest.ValidateAll() if the designated constraints
// aren't met.
type ListObjectsRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListObjectsRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListObjectsRequestMultiError) AllErrors() []error { return m }

// ListObjectsRequestValidationError is the validation error returned by
// ListObjectsRequest.Validate if the designated constraints aren't met.
type ListObjectsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListObjectsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListObjectsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListObjectsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListObjectsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListObjectsRequestValidationError) ErrorName() string {
	return "ListObjectsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListObjectsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListObjectsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListObjectsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListObjectsRequestValidationError{}

var _ListObjectsRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _ListObjectsRequest_AuthorizationModelId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _ListObjectsRequest_Type_Pattern = regexp.MustCompile("^[^:#@\\s]{1,254}$")

var _ListObjectsRequest_Relation_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

// Validate checks the field values on ListObjectsResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ListObjectsResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListObjectsResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ListObjectsResponseMultiError, or nil if none found.
func (m *ListObjectsResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *ListObjectsResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return ListObjectsResponseMultiError(errors)
	}

	return nil
}

// ListObjectsResponseMultiError is an error wrapping multiple validation
// errors returned by ListObjectsResponse.ValidateAll() if the designated
// constraints aren't met.
type ListObjectsResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListObjectsResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListObjectsResponseMultiError) AllErrors() []error { return m }

// ListObjectsResponseValidationError is the validation error returned by
// ListObjectsResponse.Validate if the designated constraints aren't met.
type ListObjectsResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListObjectsResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListObjectsResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListObjectsResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListObjectsResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListObjectsResponseValidationError) ErrorName() string {
	return "ListObjectsResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ListObjectsResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListObjectsResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListObjectsResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListObjectsResponseValidationError{}

// Validate checks the field values on ListUsersRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ListUsersRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListUsersRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ListUsersRequestMultiError, or nil if none found.
func (m *ListUsersRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *ListUsersRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_ListUsersRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := ListUsersRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetAuthorizationModelId() != "" {

		if !_ListUsersRequest_AuthorizationModelId_Pattern.MatchString(m.GetAuthorizationModelId()) {
			err := ListUsersRequestValidationError{
				field:  "AuthorizationModelId",
				reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.GetObject() == nil {
		err := ListUsersRequestValidationError{
			field:  "Object",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetObject()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListUsersRequestValidationError{
					field:  "Object",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListUsersRequestValidationError{
					field:  "Object",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetObject()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListUsersRequestValidationError{
				field:  "Object",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if !_ListUsersRequest_Relation_Pattern.MatchString(m.GetRelation()) {
		err := ListUsersRequestValidationError{
			field:  "Relation",
			reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetUserFilters()) != 1 {
		err := ListUsersRequestValidationError{
			field:  "UserFilters",
			reason: "value must contain exactly 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetUserFilters() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListUsersRequestValidationError{
						field:  fmt.Sprintf("UserFilters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListUsersRequestValidationError{
						field:  fmt.Sprintf("UserFilters[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListUsersRequestValidationError{
					field:  fmt.Sprintf("UserFilters[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetContextualTuples()) > 100 {
		err := ListUsersRequestValidationError{
			field:  "ContextualTuples",
			reason: "value must contain no more than 100 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetContextualTuples() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListUsersRequestValidationError{
						field:  fmt.Sprintf("ContextualTuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListUsersRequestValidationError{
						field:  fmt.Sprintf("ContextualTuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListUsersRequestValidationError{
					field:  fmt.Sprintf("ContextualTuples[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ListUsersRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ListUsersRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ListUsersRequestValidationError{
				field:  "Context",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := ConsistencyPreference_name[int32(m.GetConsistency())]; !ok {
		err := ListUsersRequestValidationError{
			field:  "Consistency",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ListUsersRequestMultiError(errors)
	}

	return nil
}

// ListUsersRequestMultiError is an error wrapping multiple validation errors
// returned by ListUsersRequest.ValidateAll() if the designated constraints
// aren't met.
type ListUsersRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListUsersRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListUsersRequestMultiError) AllErrors() []error { return m }

// ListUsersRequestValidationError is the validation error returned by
// ListUsersRequest.Validate if the designated constraints aren't met.
type ListUsersRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListUsersRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListUsersRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListUsersRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListUsersRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListUsersRequestValidationError) ErrorName() string { return "ListUsersRequestValidationError" }

// Error satisfies the builtin error interface
func (e ListUsersRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListUsersRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListUsersRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListUsersRequestValidationError{}

var _ListUsersRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _ListUsersRequest_AuthorizationModelId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _ListUsersRequest_Relation_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

// Validate checks the field values on ListUsersResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ListUsersResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListUsersResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ListUsersResponseMultiError, or nil if none found.
func (m *ListUsersResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *ListUsersResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetUsers() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListUsersResponseValidationError{
						field:  fmt.Sprintf("Users[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListUsersResponseValidationError{
						field:  fmt.Sprintf("Users[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListUsersResponseValidationError{
					field:  fmt.Sprintf("Users[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ListUsersResponseMultiError(errors)
	}

	return nil
}

// ListUsersResponseMultiError is an error wrapping multiple validation errors
// returned by ListUsersResponse.ValidateAll() if the designated constraints
// aren't met.
type ListUsersResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListUsersResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListUsersResponseMultiError) AllErrors() []error { return m }

// ListUsersResponseValidationError is the validation error returned by
// ListUsersResponse.Validate if the designated constraints aren't met.
type ListUsersResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListUsersResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListUsersResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListUsersResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListUsersResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListUsersResponseValidationError) ErrorName() string {
	return "ListUsersResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ListUsersResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListUsersResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListUsersResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListUsersResponseValidationError{}

// Validate checks the field values on StreamedListObjectsRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *StreamedListObjectsRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on StreamedListObjectsRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// StreamedListObjectsRequestMultiError, or nil if none found.
func (m *StreamedListObjectsRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *StreamedListObjectsRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_StreamedListObjectsRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := StreamedListObjectsRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetAuthorizationModelId() != "" {

		if !_StreamedListObjectsRequest_AuthorizationModelId_Pattern.MatchString(m.GetAuthorizationModelId()) {
			err := StreamedListObjectsRequestValidationError{
				field:  "AuthorizationModelId",
				reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if !_StreamedListObjectsRequest_Type_Pattern.MatchString(m.GetType()) {
		err := StreamedListObjectsRequestValidationError{
			field:  "Type",
			reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,254}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_StreamedListObjectsRequest_Relation_Pattern.MatchString(m.GetRelation()) {
		err := StreamedListObjectsRequestValidationError{
			field:  "Relation",
			reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if l := len(m.GetUser()); l < 1 || l > 512 {
		err := StreamedListObjectsRequestValidationError{
			field:  "User",
			reason: "value length must be between 1 and 512 bytes, inclusive",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetContextualTuples()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, StreamedListObjectsRequestValidationError{
					field:  "ContextualTuples",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, StreamedListObjectsRequestValidationError{
					field:  "ContextualTuples",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContextualTuples()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return StreamedListObjectsRequestValidationError{
				field:  "ContextualTuples",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, StreamedListObjectsRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, StreamedListObjectsRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return StreamedListObjectsRequestValidationError{
				field:  "Context",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := ConsistencyPreference_name[int32(m.GetConsistency())]; !ok {
		err := StreamedListObjectsRequestValidationError{
			field:  "Consistency",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return StreamedListObjectsRequestMultiError(errors)
	}

	return nil
}

// StreamedListObjectsRequestMultiError is an error wrapping multiple
// validation errors returned by StreamedListObjectsRequest.ValidateAll() if
// the designated constraints aren't met.
type StreamedListObjectsRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m StreamedListObjectsRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m StreamedListObjectsRequestMultiError) AllErrors() []error { return m }

// StreamedListObjectsRequestValidationError is the validation error returned
// by StreamedListObjectsRequest.Validate if the designated constraints aren't met.
type StreamedListObjectsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e StreamedListObjectsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e StreamedListObjectsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e StreamedListObjectsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e StreamedListObjectsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e StreamedListObjectsRequestValidationError) ErrorName() string {
	return "StreamedListObjectsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e StreamedListObjectsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sStreamedListObjectsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = StreamedListObjectsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = StreamedListObjectsRequestValidationError{}

var _StreamedListObjectsRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _StreamedListObjectsRequest_AuthorizationModelId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _StreamedListObjectsRequest_Type_Pattern = regexp.MustCompile("^[^:#@\\s]{1,254}$")

var _StreamedListObjectsRequest_Relation_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

// Validate checks the field values on StreamedListObjectsResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *StreamedListObjectsResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on StreamedListObjectsResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// StreamedListObjectsResponseMultiError, or nil if none found.
func (m *StreamedListObjectsResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *StreamedListObjectsResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Object

	if len(errors) > 0 {
		return StreamedListObjectsResponseMultiError(errors)
	}

	return nil
}

// StreamedListObjectsResponseMultiError is an error wrapping multiple
// validation errors returned by StreamedListObjectsResponse.ValidateAll() if
// the designated constraints aren't met.
type StreamedListObjectsResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m StreamedListObjectsResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m StreamedListObjectsResponseMultiError) AllErrors() []error { return m }

// StreamedListObjectsResponseValidationError is the validation error returned
// by StreamedListObjectsResponse.Validate if the designated constraints
// aren't met.
type StreamedListObjectsResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e StreamedListObjectsResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e StreamedListObjectsResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e StreamedListObjectsResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e StreamedListObjectsResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e StreamedListObjectsResponseValidationError) ErrorName() string {
	return "StreamedListObjectsResponseValidationError"
}

// Error satisfies the builtin error interface
func (e StreamedListObjectsResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sStreamedListObjectsResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = StreamedListObjectsResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = StreamedListObjectsResponseValidationError{}

// Validate checks the field values on ReadRequest with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ReadRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReadRequest with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ReadRequestMultiError, or
// nil if none found.
func (m *ReadRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *ReadRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_ReadRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := ReadRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetTupleKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ReadRequestValidationError{
					field:  "TupleKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ReadRequestValidationError{
					field:  "TupleKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTupleKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ReadRequestValidationError{
				field:  "TupleKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if wrapper := m.GetPageSize(); wrapper != nil {

		if val := wrapper.GetValue(); val < 1 || val > 100 {
			err := ReadRequestValidationError{
				field:  "PageSize",
				reason: "value must be inside range [1, 100]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(m.GetContinuationToken()) > 5120 {
		err := ReadRequestValidationError{
			field:  "ContinuationToken",
			reason: "value length must be at most 5120 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if _, ok := ConsistencyPreference_name[int32(m.GetConsistency())]; !ok {
		err := ReadRequestValidationError{
			field:  "Consistency",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ReadRequestMultiError(errors)
	}

	return nil
}

// ReadRequestMultiError is an error wrapping multiple validation errors
// returned by ReadRequest.ValidateAll() if the designated constraints aren't met.
type ReadRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReadRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReadRequestMultiError) AllErrors() []error { return m }

// ReadRequestValidationError is the validation error returned by
// ReadRequest.Validate if the designated constraints aren't met.
type ReadRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReadRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReadRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReadRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReadRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReadRequestValidationError) ErrorName() string { return "ReadRequestValidationError" }

// Error satisfies the builtin error interface
func (e ReadRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReadRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReadRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReadRequestValidationError{}

var _ReadRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

// Validate checks the field values on ReadRequestTupleKey with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ReadRequestTupleKey) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReadRequestTupleKey with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ReadRequestTupleKeyMultiError, or nil if none found.
func (m *ReadRequestTupleKey) ValidateAll() error {
	return m.validate(true)
}

func (m *ReadRequestTupleKey) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetUser()) > 512 {
		err := ReadRequestTupleKeyValidationError{
			field:  "User",
			reason: "value length must be at most 512 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetRelation() != "" {

		if !_ReadRequestTupleKey_Relation_Pattern.MatchString(m.GetRelation()) {
			err := ReadRequestTupleKeyValidationError{
				field:  "Relation",
				reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.GetObject() != "" {

		if !_ReadRequestTupleKey_Object_Pattern.MatchString(m.GetObject()) {
			err := ReadRequestTupleKeyValidationError{
				field:  "Object",
				reason: "value does not match regex pattern \"^[^\\\\s]{2,256}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return ReadRequestTupleKeyMultiError(errors)
	}

	return nil
}

// ReadRequestTupleKeyMultiError is an error wrapping multiple validation
// errors returned by ReadRequestTupleKey.ValidateAll() if the designated
// constraints aren't met.
type ReadRequestTupleKeyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReadRequestTupleKeyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReadRequestTupleKeyMultiError) AllErrors() []error { return m }

// ReadRequestTupleKeyValidationError is the validation error returned by
// ReadRequestTupleKey.Validate if the designated constraints aren't met.
type ReadRequestTupleKeyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReadRequestTupleKeyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReadRequestTupleKeyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReadRequestTupleKeyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReadRequestTupleKeyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReadRequestTupleKeyValidationError) ErrorName() string {
	return "ReadRequestTupleKeyValidationError"
}

// Error satisfies the builtin error interface
func (e ReadRequestTupleKeyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReadRequestTupleKey.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReadRequestTupleKeyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReadRequestTupleKeyValidationError{}

var _ReadRequestTupleKey_Relation_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

var _ReadRequestTupleKey_Object_Pattern = regexp.MustCompile("^[^\\s]{2,256}$")

// Validate checks the field values on ReadResponse with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ReadResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReadResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ReadResponseMultiError, or
// nil if none found.
func (m *ReadResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *ReadResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetTuples() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ReadResponseValidationError{
						field:  fmt.Sprintf("Tuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ReadResponseValidationError{
						field:  fmt.Sprintf("Tuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ReadResponseValidationError{
					field:  fmt.Sprintf("Tuples[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetContinuationToken()) > 5120 {
		err := ReadResponseValidationError{
			field:  "ContinuationToken",
			reason: "value length must be at most 5120 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ReadResponseMultiError(errors)
	}

	return nil
}

// ReadResponseMultiError is an error wrapping multiple validation errors
// returned by ReadResponse.ValidateAll() if the designated constraints aren't met.
type ReadResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReadResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReadResponseMultiError) AllErrors() []error { return m }

// ReadResponseValidationError is the validation error returned by
// ReadResponse.Validate if the designated constraints aren't met.
type ReadResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReadResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReadResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReadResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReadResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReadResponseValidationError) ErrorName() string { return "ReadResponseValidationError" }

// Error satisfies the builtin error interface
func (e ReadResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReadResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReadResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReadResponseValidationError{}

// Validate checks the field values on WriteRequestWrites with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *WriteRequestWrites) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on WriteRequestWrites with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// WriteRequestWritesMultiError, or nil if none found.
func (m *WriteRequestWrites) ValidateAll() error {
	return m.validate(true)
}

func (m *WriteRequestWrites) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTupleKeys()) < 1 {
		err := WriteRequestWritesValidationError{
			field:  "TupleKeys",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetTupleKeys() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, WriteRequestWritesValidationError{
						field:  fmt.Sprintf("TupleKeys[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, WriteRequestWritesValidationError{
						field:  fmt.Sprintf("TupleKeys[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WriteRequestWritesValidationError{
					field:  fmt.Sprintf("TupleKeys[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return WriteRequestWritesMultiError(errors)
	}

	return nil
}

// WriteRequestWritesMultiError is an error wrapping multiple validation errors
// returned by WriteRequestWrites.ValidateAll() if the designated constraints
// aren't met.
type WriteRequestWritesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WriteRequestWritesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WriteRequestWritesMultiError) AllErrors() []error { return m }

// WriteRequestWritesValidationError is the validation error returned by
// WriteRequestWrites.Validate if the designated constraints aren't met.
type WriteRequestWritesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WriteRequestWritesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WriteRequestWritesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WriteRequestWritesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WriteRequestWritesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WriteRequestWritesValidationError) ErrorName() string {
	return "WriteRequestWritesValidationError"
}

// Error satisfies the builtin error interface
func (e WriteRequestWritesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWriteRequestWrites.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WriteRequestWritesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WriteRequestWritesValidationError{}

// Validate checks the field values on WriteRequestDeletes with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *WriteRequestDeletes) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on WriteRequestDeletes with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// WriteRequestDeletesMultiError, or nil if none found.
func (m *WriteRequestDeletes) ValidateAll() error {
	return m.validate(true)
}

func (m *WriteRequestDeletes) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(m.GetTupleKeys()) < 1 {
		err := WriteRequestDeletesValidationError{
			field:  "TupleKeys",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetTupleKeys() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, WriteRequestDeletesValidationError{
						field:  fmt.Sprintf("TupleKeys[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, WriteRequestDeletesValidationError{
						field:  fmt.Sprintf("TupleKeys[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WriteRequestDeletesValidationError{
					field:  fmt.Sprintf("TupleKeys[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return WriteRequestDeletesMultiError(errors)
	}

	return nil
}

// WriteRequestDeletesMultiError is an error wrapping multiple validation
// errors returned by WriteRequestDeletes.ValidateAll() if the designated
// constraints aren't met.
type WriteRequestDeletesMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WriteRequestDeletesMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WriteRequestDeletesMultiError) AllErrors() []error { return m }

// WriteRequestDeletesValidationError is the validation error returned by
// WriteRequestDeletes.Validate if the designated constraints aren't met.
type WriteRequestDeletesValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WriteRequestDeletesValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WriteRequestDeletesValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WriteRequestDeletesValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WriteRequestDeletesValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WriteRequestDeletesValidationError) ErrorName() string {
	return "WriteRequestDeletesValidationError"
}

// Error satisfies the builtin error interface
func (e WriteRequestDeletesValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWriteRequestDeletes.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WriteRequestDeletesValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WriteRequestDeletesValidationError{}

// Validate checks the field values on WriteRequest with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *WriteRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on WriteRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in WriteRequestMultiError, or
// nil if none found.
func (m *WriteRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *WriteRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_WriteRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := WriteRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetWrites()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, WriteRequestValidationError{
					field:  "Writes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, WriteRequestValidationError{
					field:  "Writes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetWrites()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WriteRequestValidationError{
				field:  "Writes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDeletes()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, WriteRequestValidationError{
					field:  "Deletes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, WriteRequestValidationError{
					field:  "Deletes",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDeletes()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return WriteRequestValidationError{
				field:  "Deletes",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetAuthorizationModelId() != "" {

		if !_WriteRequest_AuthorizationModelId_Pattern.MatchString(m.GetAuthorizationModelId()) {
			err := WriteRequestValidationError{
				field:  "AuthorizationModelId",
				reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return WriteRequestMultiError(errors)
	}

	return nil
}

// WriteRequestMultiError is an error wrapping multiple validation errors
// returned by WriteRequest.ValidateAll() if the designated constraints aren't met.
type WriteRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WriteRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WriteRequestMultiError) AllErrors() []error { return m }

// WriteRequestValidationError is the validation error returned by
// WriteRequest.Validate if the designated constraints aren't met.
type WriteRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WriteRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WriteRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WriteRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WriteRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WriteRequestValidationError) ErrorName() string { return "WriteRequestValidationError" }

// Error satisfies the builtin error interface
func (e WriteRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWriteRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WriteRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WriteRequestValidationError{}

var _WriteRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _WriteRequest_AuthorizationModelId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

// Validate checks the field values on WriteResponse with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *WriteResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on WriteResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in WriteResponseMultiError, or
// nil if none found.
func (m *WriteResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *WriteResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return WriteResponseMultiError(errors)
	}

	return nil
}

// WriteResponseMultiError is an error wrapping multiple validation errors
// returned by WriteResponse.ValidateAll() if the designated constraints
// aren't met.
type WriteResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WriteResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WriteResponseMultiError) AllErrors() []error { return m }

// WriteResponseValidationError is the validation error returned by
// WriteResponse.Validate if the designated constraints aren't met.
type WriteResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WriteResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WriteResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WriteResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WriteResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WriteResponseValidationError) ErrorName() string { return "WriteResponseValidationError" }

// Error satisfies the builtin error interface
func (e WriteResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWriteResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WriteResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WriteResponseValidationError{}

// Validate checks the field values on CheckRequest with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *CheckRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CheckRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in CheckRequestMultiError, or
// nil if none found.
func (m *CheckRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *CheckRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_CheckRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := CheckRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetTupleKey() == nil {
		err := CheckRequestValidationError{
			field:  "TupleKey",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetTupleKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CheckRequestValidationError{
					field:  "TupleKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CheckRequestValidationError{
					field:  "TupleKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTupleKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CheckRequestValidationError{
				field:  "TupleKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetContextualTuples()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CheckRequestValidationError{
					field:  "ContextualTuples",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CheckRequestValidationError{
					field:  "ContextualTuples",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContextualTuples()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CheckRequestValidationError{
				field:  "ContextualTuples",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetAuthorizationModelId() != "" {

		if !_CheckRequest_AuthorizationModelId_Pattern.MatchString(m.GetAuthorizationModelId()) {
			err := CheckRequestValidationError{
				field:  "AuthorizationModelId",
				reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	// no validation rules for Trace

	if all {
		switch v := interface{}(m.GetContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CheckRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CheckRequestValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CheckRequestValidationError{
				field:  "Context",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if _, ok := ConsistencyPreference_name[int32(m.GetConsistency())]; !ok {
		err := CheckRequestValidationError{
			field:  "Consistency",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return CheckRequestMultiError(errors)
	}

	return nil
}

// CheckRequestMultiError is an error wrapping multiple validation errors
// returned by CheckRequest.ValidateAll() if the designated constraints aren't met.
type CheckRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CheckRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CheckRequestMultiError) AllErrors() []error { return m }

// CheckRequestValidationError is the validation error returned by
// CheckRequest.Validate if the designated constraints aren't met.
type CheckRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CheckRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CheckRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CheckRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CheckRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CheckRequestValidationError) ErrorName() string { return "CheckRequestValidationError" }

// Error satisfies the builtin error interface
func (e CheckRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCheckRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CheckRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CheckRequestValidationError{}

var _CheckRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _CheckRequest_AuthorizationModelId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

// Validate checks the field values on CheckRequestTupleKey with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *CheckRequestTupleKey) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CheckRequestTupleKey with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// CheckRequestTupleKeyMultiError, or nil if none found.
func (m *CheckRequestTupleKey) ValidateAll() error {
	return m.validate(true)
}

func (m *CheckRequestTupleKey) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_CheckRequestTupleKey_User_Pattern.MatchString(m.GetUser()) {
		err := CheckRequestTupleKeyValidationError{
			field:  "User",
			reason: "value does not match regex pattern \"^[^\\\\s]{2,512}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_CheckRequestTupleKey_Relation_Pattern.MatchString(m.GetRelation()) {
		err := CheckRequestTupleKeyValidationError{
			field:  "Relation",
			reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_CheckRequestTupleKey_Object_Pattern.MatchString(m.GetObject()) {
		err := CheckRequestTupleKeyValidationError{
			field:  "Object",
			reason: "value does not match regex pattern \"^[^\\\\s]{2,256}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return CheckRequestTupleKeyMultiError(errors)
	}

	return nil
}

// CheckRequestTupleKeyMultiError is an error wrapping multiple validation
// errors returned by CheckRequestTupleKey.ValidateAll() if the designated
// constraints aren't met.
type CheckRequestTupleKeyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CheckRequestTupleKeyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CheckRequestTupleKeyMultiError) AllErrors() []error { return m }

// CheckRequestTupleKeyValidationError is the validation error returned by
// CheckRequestTupleKey.Validate if the designated constraints aren't met.
type CheckRequestTupleKeyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CheckRequestTupleKeyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CheckRequestTupleKeyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CheckRequestTupleKeyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CheckRequestTupleKeyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CheckRequestTupleKeyValidationError) ErrorName() string {
	return "CheckRequestTupleKeyValidationError"
}

// Error satisfies the builtin error interface
func (e CheckRequestTupleKeyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCheckRequestTupleKey.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CheckRequestTupleKeyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CheckRequestTupleKeyValidationError{}

var _CheckRequestTupleKey_User_Pattern = regexp.MustCompile("^[^\\s]{2,512}$")

var _CheckRequestTupleKey_Relation_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

var _CheckRequestTupleKey_Object_Pattern = regexp.MustCompile("^[^\\s]{2,256}$")

// Validate checks the field values on CheckResponse with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *CheckResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CheckResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in CheckResponseMultiError, or
// nil if none found.
func (m *CheckResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *CheckResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Allowed

	// no validation rules for Resolution

	if len(errors) > 0 {
		return CheckResponseMultiError(errors)
	}

	return nil
}

// CheckResponseMultiError is an error wrapping multiple validation errors
// returned by CheckResponse.ValidateAll() if the designated constraints
// aren't met.
type CheckResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CheckResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CheckResponseMultiError) AllErrors() []error { return m }

// CheckResponseValidationError is the validation error returned by
// CheckResponse.Validate if the designated constraints aren't met.
type CheckResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CheckResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CheckResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CheckResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CheckResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CheckResponseValidationError) ErrorName() string { return "CheckResponseValidationError" }

// Error satisfies the builtin error interface
func (e CheckResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCheckResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CheckResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CheckResponseValidationError{}

// Validate checks the field values on BatchCheckRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *BatchCheckRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BatchCheckRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BatchCheckRequestMultiError, or nil if none found.
func (m *BatchCheckRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *BatchCheckRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_BatchCheckRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := BatchCheckRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetChecks()) < 1 {
		err := BatchCheckRequestValidationError{
			field:  "Checks",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetChecks() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, BatchCheckRequestValidationError{
						field:  fmt.Sprintf("Checks[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, BatchCheckRequestValidationError{
						field:  fmt.Sprintf("Checks[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return BatchCheckRequestValidationError{
					field:  fmt.Sprintf("Checks[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if m.GetAuthorizationModelId() != "" {

		if !_BatchCheckRequest_AuthorizationModelId_Pattern.MatchString(m.GetAuthorizationModelId()) {
			err := BatchCheckRequestValidationError{
				field:  "AuthorizationModelId",
				reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if _, ok := ConsistencyPreference_name[int32(m.GetConsistency())]; !ok {
		err := BatchCheckRequestValidationError{
			field:  "Consistency",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return BatchCheckRequestMultiError(errors)
	}

	return nil
}

// BatchCheckRequestMultiError is an error wrapping multiple validation errors
// returned by BatchCheckRequest.ValidateAll() if the designated constraints
// aren't met.
type BatchCheckRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BatchCheckRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BatchCheckRequestMultiError) AllErrors() []error { return m }

// BatchCheckRequestValidationError is the validation error returned by
// BatchCheckRequest.Validate if the designated constraints aren't met.
type BatchCheckRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BatchCheckRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BatchCheckRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BatchCheckRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BatchCheckRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BatchCheckRequestValidationError) ErrorName() string {
	return "BatchCheckRequestValidationError"
}

// Error satisfies the builtin error interface
func (e BatchCheckRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBatchCheckRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BatchCheckRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BatchCheckRequestValidationError{}

var _BatchCheckRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _BatchCheckRequest_AuthorizationModelId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

// Validate checks the field values on BatchCheckItem with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *BatchCheckItem) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BatchCheckItem with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in BatchCheckItemMultiError,
// or nil if none found.
func (m *BatchCheckItem) ValidateAll() error {
	return m.validate(true)
}

func (m *BatchCheckItem) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetTupleKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BatchCheckItemValidationError{
					field:  "TupleKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BatchCheckItemValidationError{
					field:  "TupleKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTupleKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BatchCheckItemValidationError{
				field:  "TupleKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetContextualTuples()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BatchCheckItemValidationError{
					field:  "ContextualTuples",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BatchCheckItemValidationError{
					field:  "ContextualTuples",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContextualTuples()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BatchCheckItemValidationError{
				field:  "ContextualTuples",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, BatchCheckItemValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, BatchCheckItemValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return BatchCheckItemValidationError{
				field:  "Context",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if !_BatchCheckItem_CorrelationId_Pattern.MatchString(m.GetCorrelationId()) {
		err := BatchCheckItemValidationError{
			field:  "CorrelationId",
			reason: "value does not match regex pattern \"^[\\\\w\\\\d-]{1,36}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return BatchCheckItemMultiError(errors)
	}

	return nil
}

// BatchCheckItemMultiError is an error wrapping multiple validation errors
// returned by BatchCheckItem.ValidateAll() if the designated constraints
// aren't met.
type BatchCheckItemMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BatchCheckItemMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BatchCheckItemMultiError) AllErrors() []error { return m }

// BatchCheckItemValidationError is the validation error returned by
// BatchCheckItem.Validate if the designated constraints aren't met.
type BatchCheckItemValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BatchCheckItemValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BatchCheckItemValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BatchCheckItemValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BatchCheckItemValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BatchCheckItemValidationError) ErrorName() string { return "BatchCheckItemValidationError" }

// Error satisfies the builtin error interface
func (e BatchCheckItemValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBatchCheckItem.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BatchCheckItemValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BatchCheckItemValidationError{}

var _BatchCheckItem_CorrelationId_Pattern = regexp.MustCompile("^[\\w\\d-]{1,36}$")

// Validate checks the field values on BatchCheckResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *BatchCheckResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BatchCheckResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BatchCheckResponseMultiError, or nil if none found.
func (m *BatchCheckResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *BatchCheckResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	{
		sorted_keys := make([]string, len(m.GetResult()))
		i := 0
		for key := range m.GetResult() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetResult()[key]
			_ = val

			// no validation rules for Result[key]

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, BatchCheckResponseValidationError{
							field:  fmt.Sprintf("Result[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, BatchCheckResponseValidationError{
							field:  fmt.Sprintf("Result[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return BatchCheckResponseValidationError{
						field:  fmt.Sprintf("Result[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if len(errors) > 0 {
		return BatchCheckResponseMultiError(errors)
	}

	return nil
}

// BatchCheckResponseMultiError is an error wrapping multiple validation errors
// returned by BatchCheckResponse.ValidateAll() if the designated constraints
// aren't met.
type BatchCheckResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BatchCheckResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BatchCheckResponseMultiError) AllErrors() []error { return m }

// BatchCheckResponseValidationError is the validation error returned by
// BatchCheckResponse.Validate if the designated constraints aren't met.
type BatchCheckResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BatchCheckResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BatchCheckResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BatchCheckResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BatchCheckResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BatchCheckResponseValidationError) ErrorName() string {
	return "BatchCheckResponseValidationError"
}

// Error satisfies the builtin error interface
func (e BatchCheckResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBatchCheckResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BatchCheckResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BatchCheckResponseValidationError{}

// Validate checks the field values on BatchCheckSingleResult with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *BatchCheckSingleResult) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on BatchCheckSingleResult with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// BatchCheckSingleResultMultiError, or nil if none found.
func (m *BatchCheckSingleResult) ValidateAll() error {
	return m.validate(true)
}

func (m *BatchCheckSingleResult) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	switch v := m.CheckResult.(type) {
	case *BatchCheckSingleResult_Allowed:
		if v == nil {
			err := BatchCheckSingleResultValidationError{
				field:  "CheckResult",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for Allowed
	case *BatchCheckSingleResult_Error:
		if v == nil {
			err := BatchCheckSingleResultValidationError{
				field:  "CheckResult",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

		if all {
			switch v := interface{}(m.GetError()).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, BatchCheckSingleResultValidationError{
						field:  "Error",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, BatchCheckSingleResultValidationError{
						field:  "Error",
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(m.GetError()).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return BatchCheckSingleResultValidationError{
					field:  "Error",
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return BatchCheckSingleResultMultiError(errors)
	}

	return nil
}

// BatchCheckSingleResultMultiError is an error wrapping multiple validation
// errors returned by BatchCheckSingleResult.ValidateAll() if the designated
// constraints aren't met.
type BatchCheckSingleResultMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m BatchCheckSingleResultMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m BatchCheckSingleResultMultiError) AllErrors() []error { return m }

// BatchCheckSingleResultValidationError is the validation error returned by
// BatchCheckSingleResult.Validate if the designated constraints aren't met.
type BatchCheckSingleResultValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e BatchCheckSingleResultValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e BatchCheckSingleResultValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e BatchCheckSingleResultValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e BatchCheckSingleResultValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e BatchCheckSingleResultValidationError) ErrorName() string {
	return "BatchCheckSingleResultValidationError"
}

// Error satisfies the builtin error interface
func (e BatchCheckSingleResultValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sBatchCheckSingleResult.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = BatchCheckSingleResultValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = BatchCheckSingleResultValidationError{}

// Validate checks the field values on CheckError with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *CheckError) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CheckError with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in CheckErrorMultiError, or
// nil if none found.
func (m *CheckError) ValidateAll() error {
	return m.validate(true)
}

func (m *CheckError) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Message

	switch v := m.Code.(type) {
	case *CheckError_InputError:
		if v == nil {
			err := CheckErrorValidationError{
				field:  "Code",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for InputError
	case *CheckError_InternalError:
		if v == nil {
			err := CheckErrorValidationError{
				field:  "Code",
				reason: "oneof value cannot be a typed-nil",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}
		// no validation rules for InternalError
	default:
		_ = v // ensures v is used
	}

	if len(errors) > 0 {
		return CheckErrorMultiError(errors)
	}

	return nil
}

// CheckErrorMultiError is an error wrapping multiple validation errors
// returned by CheckError.ValidateAll() if the designated constraints aren't met.
type CheckErrorMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CheckErrorMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CheckErrorMultiError) AllErrors() []error { return m }

// CheckErrorValidationError is the validation error returned by
// CheckError.Validate if the designated constraints aren't met.
type CheckErrorValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CheckErrorValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CheckErrorValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CheckErrorValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CheckErrorValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CheckErrorValidationError) ErrorName() string { return "CheckErrorValidationError" }

// Error satisfies the builtin error interface
func (e CheckErrorValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCheckError.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CheckErrorValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CheckErrorValidationError{}

// Validate checks the field values on ExpandRequest with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ExpandRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ExpandRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ExpandRequestMultiError, or
// nil if none found.
func (m *ExpandRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *ExpandRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_ExpandRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := ExpandRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetTupleKey() == nil {
		err := ExpandRequestValidationError{
			field:  "TupleKey",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetTupleKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ExpandRequestValidationError{
					field:  "TupleKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ExpandRequestValidationError{
					field:  "TupleKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTupleKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ExpandRequestValidationError{
				field:  "TupleKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if m.GetAuthorizationModelId() != "" {

		if !_ExpandRequest_AuthorizationModelId_Pattern.MatchString(m.GetAuthorizationModelId()) {
			err := ExpandRequestValidationError{
				field:  "AuthorizationModelId",
				reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if _, ok := ConsistencyPreference_name[int32(m.GetConsistency())]; !ok {
		err := ExpandRequestValidationError{
			field:  "Consistency",
			reason: "value must be one of the defined enum values",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetContextualTuples()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ExpandRequestValidationError{
					field:  "ContextualTuples",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ExpandRequestValidationError{
					field:  "ContextualTuples",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContextualTuples()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ExpandRequestValidationError{
				field:  "ContextualTuples",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ExpandRequestMultiError(errors)
	}

	return nil
}

// ExpandRequestMultiError is an error wrapping multiple validation errors
// returned by ExpandRequest.ValidateAll() if the designated constraints
// aren't met.
type ExpandRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ExpandRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ExpandRequestMultiError) AllErrors() []error { return m }

// ExpandRequestValidationError is the validation error returned by
// ExpandRequest.Validate if the designated constraints aren't met.
type ExpandRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ExpandRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ExpandRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ExpandRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ExpandRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ExpandRequestValidationError) ErrorName() string { return "ExpandRequestValidationError" }

// Error satisfies the builtin error interface
func (e ExpandRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sExpandRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ExpandRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ExpandRequestValidationError{}

var _ExpandRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _ExpandRequest_AuthorizationModelId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

// Validate checks the field values on ExpandRequestTupleKey with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ExpandRequestTupleKey) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ExpandRequestTupleKey with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ExpandRequestTupleKeyMultiError, or nil if none found.
func (m *ExpandRequestTupleKey) ValidateAll() error {
	return m.validate(true)
}

func (m *ExpandRequestTupleKey) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetRelation() != "" {

		if !_ExpandRequestTupleKey_Relation_Pattern.MatchString(m.GetRelation()) {
			err := ExpandRequestTupleKeyValidationError{
				field:  "Relation",
				reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if m.GetObject() != "" {

		if !_ExpandRequestTupleKey_Object_Pattern.MatchString(m.GetObject()) {
			err := ExpandRequestTupleKeyValidationError{
				field:  "Object",
				reason: "value does not match regex pattern \"^[^\\\\s]{2,256}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return ExpandRequestTupleKeyMultiError(errors)
	}

	return nil
}

// ExpandRequestTupleKeyMultiError is an error wrapping multiple validation
// errors returned by ExpandRequestTupleKey.ValidateAll() if the designated
// constraints aren't met.
type ExpandRequestTupleKeyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ExpandRequestTupleKeyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ExpandRequestTupleKeyMultiError) AllErrors() []error { return m }

// ExpandRequestTupleKeyValidationError is the validation error returned by
// ExpandRequestTupleKey.Validate if the designated constraints aren't met.
type ExpandRequestTupleKeyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ExpandRequestTupleKeyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ExpandRequestTupleKeyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ExpandRequestTupleKeyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ExpandRequestTupleKeyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ExpandRequestTupleKeyValidationError) ErrorName() string {
	return "ExpandRequestTupleKeyValidationError"
}

// Error satisfies the builtin error interface
func (e ExpandRequestTupleKeyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sExpandRequestTupleKey.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ExpandRequestTupleKeyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ExpandRequestTupleKeyValidationError{}

var _ExpandRequestTupleKey_Relation_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

var _ExpandRequestTupleKey_Object_Pattern = regexp.MustCompile("^[^\\s]{2,256}$")

// Validate checks the field values on ExpandResponse with the rules defined in
// the proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *ExpandResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ExpandResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in ExpandResponseMultiError,
// or nil if none found.
func (m *ExpandResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *ExpandResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetTree()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ExpandResponseValidationError{
					field:  "Tree",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ExpandResponseValidationError{
					field:  "Tree",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTree()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ExpandResponseValidationError{
				field:  "Tree",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ExpandResponseMultiError(errors)
	}

	return nil
}

// ExpandResponseMultiError is an error wrapping multiple validation errors
// returned by ExpandResponse.ValidateAll() if the designated constraints
// aren't met.
type ExpandResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ExpandResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ExpandResponseMultiError) AllErrors() []error { return m }

// ExpandResponseValidationError is the validation error returned by
// ExpandResponse.Validate if the designated constraints aren't met.
type ExpandResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ExpandResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ExpandResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ExpandResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ExpandResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ExpandResponseValidationError) ErrorName() string { return "ExpandResponseValidationError" }

// Error satisfies the builtin error interface
func (e ExpandResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sExpandResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ExpandResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ExpandResponseValidationError{}

// Validate checks the field values on ReadAuthorizationModelRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ReadAuthorizationModelRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReadAuthorizationModelRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// ReadAuthorizationModelRequestMultiError, or nil if none found.
func (m *ReadAuthorizationModelRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *ReadAuthorizationModelRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_ReadAuthorizationModelRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := ReadAuthorizationModelRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_ReadAuthorizationModelRequest_Id_Pattern.MatchString(m.GetId()) {
		err := ReadAuthorizationModelRequestValidationError{
			field:  "Id",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ReadAuthorizationModelRequestMultiError(errors)
	}

	return nil
}

// ReadAuthorizationModelRequestMultiError is an error wrapping multiple
// validation errors returned by ReadAuthorizationModelRequest.ValidateAll()
// if the designated constraints aren't met.
type ReadAuthorizationModelRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReadAuthorizationModelRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReadAuthorizationModelRequestMultiError) AllErrors() []error { return m }

// ReadAuthorizationModelRequestValidationError is the validation error
// returned by ReadAuthorizationModelRequest.Validate if the designated
// constraints aren't met.
type ReadAuthorizationModelRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReadAuthorizationModelRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReadAuthorizationModelRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReadAuthorizationModelRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReadAuthorizationModelRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReadAuthorizationModelRequestValidationError) ErrorName() string {
	return "ReadAuthorizationModelRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ReadAuthorizationModelRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReadAuthorizationModelRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReadAuthorizationModelRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReadAuthorizationModelRequestValidationError{}

var _ReadAuthorizationModelRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _ReadAuthorizationModelRequest_Id_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

// Validate checks the field values on ReadAuthorizationModelResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ReadAuthorizationModelResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReadAuthorizationModelResponse with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// ReadAuthorizationModelResponseMultiError, or nil if none found.
func (m *ReadAuthorizationModelResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *ReadAuthorizationModelResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if all {
		switch v := interface{}(m.GetAuthorizationModel()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, ReadAuthorizationModelResponseValidationError{
					field:  "AuthorizationModel",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, ReadAuthorizationModelResponseValidationError{
					field:  "AuthorizationModel",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetAuthorizationModel()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return ReadAuthorizationModelResponseValidationError{
				field:  "AuthorizationModel",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return ReadAuthorizationModelResponseMultiError(errors)
	}

	return nil
}

// ReadAuthorizationModelResponseMultiError is an error wrapping multiple
// validation errors returned by ReadAuthorizationModelResponse.ValidateAll()
// if the designated constraints aren't met.
type ReadAuthorizationModelResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReadAuthorizationModelResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReadAuthorizationModelResponseMultiError) AllErrors() []error { return m }

// ReadAuthorizationModelResponseValidationError is the validation error
// returned by ReadAuthorizationModelResponse.Validate if the designated
// constraints aren't met.
type ReadAuthorizationModelResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReadAuthorizationModelResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReadAuthorizationModelResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReadAuthorizationModelResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReadAuthorizationModelResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReadAuthorizationModelResponseValidationError) ErrorName() string {
	return "ReadAuthorizationModelResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ReadAuthorizationModelResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReadAuthorizationModelResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReadAuthorizationModelResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReadAuthorizationModelResponseValidationError{}

// Validate checks the field values on WriteAuthorizationModelRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *WriteAuthorizationModelRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on WriteAuthorizationModelRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// WriteAuthorizationModelRequestMultiError, or nil if none found.
func (m *WriteAuthorizationModelRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *WriteAuthorizationModelRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_WriteAuthorizationModelRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := WriteAuthorizationModelRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetTypeDefinitions()) < 1 {
		err := WriteAuthorizationModelRequestValidationError{
			field:  "TypeDefinitions",
			reason: "value must contain at least 1 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetTypeDefinitions() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, WriteAuthorizationModelRequestValidationError{
						field:  fmt.Sprintf("TypeDefinitions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, WriteAuthorizationModelRequestValidationError{
						field:  fmt.Sprintf("TypeDefinitions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WriteAuthorizationModelRequestValidationError{
					field:  fmt.Sprintf("TypeDefinitions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if _, ok := _WriteAuthorizationModelRequest_SchemaVersion_InLookup[m.GetSchemaVersion()]; !ok {
		err := WriteAuthorizationModelRequestValidationError{
			field:  "SchemaVersion",
			reason: "value must be in list [1.0 1.1 1.2]",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetConditions()) > 25 {
		err := WriteAuthorizationModelRequestValidationError{
			field:  "Conditions",
			reason: "value must contain no more than 25 pair(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	{
		sorted_keys := make([]string, len(m.GetConditions()))
		i := 0
		for key := range m.GetConditions() {
			sorted_keys[i] = key
			i++
		}
		sort.Slice(sorted_keys, func(i, j int) bool { return sorted_keys[i] < sorted_keys[j] })
		for _, key := range sorted_keys {
			val := m.GetConditions()[key]
			_ = val

			if !_WriteAuthorizationModelRequest_Conditions_Pattern.MatchString(key) {
				err := WriteAuthorizationModelRequestValidationError{
					field:  fmt.Sprintf("Conditions[%v]", key),
					reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

			if all {
				switch v := interface{}(val).(type) {
				case interface{ ValidateAll() error }:
					if err := v.ValidateAll(); err != nil {
						errors = append(errors, WriteAuthorizationModelRequestValidationError{
							field:  fmt.Sprintf("Conditions[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				case interface{ Validate() error }:
					if err := v.Validate(); err != nil {
						errors = append(errors, WriteAuthorizationModelRequestValidationError{
							field:  fmt.Sprintf("Conditions[%v]", key),
							reason: "embedded message failed validation",
							cause:  err,
						})
					}
				}
			} else if v, ok := interface{}(val).(interface{ Validate() error }); ok {
				if err := v.Validate(); err != nil {
					return WriteAuthorizationModelRequestValidationError{
						field:  fmt.Sprintf("Conditions[%v]", key),
						reason: "embedded message failed validation",
						cause:  err,
					}
				}
			}

		}
	}

	if len(errors) > 0 {
		return WriteAuthorizationModelRequestMultiError(errors)
	}

	return nil
}

// WriteAuthorizationModelRequestMultiError is an error wrapping multiple
// validation errors returned by WriteAuthorizationModelRequest.ValidateAll()
// if the designated constraints aren't met.
type WriteAuthorizationModelRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WriteAuthorizationModelRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WriteAuthorizationModelRequestMultiError) AllErrors() []error { return m }

// WriteAuthorizationModelRequestValidationError is the validation error
// returned by WriteAuthorizationModelRequest.Validate if the designated
// constraints aren't met.
type WriteAuthorizationModelRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WriteAuthorizationModelRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WriteAuthorizationModelRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WriteAuthorizationModelRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WriteAuthorizationModelRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WriteAuthorizationModelRequestValidationError) ErrorName() string {
	return "WriteAuthorizationModelRequestValidationError"
}

// Error satisfies the builtin error interface
func (e WriteAuthorizationModelRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWriteAuthorizationModelRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WriteAuthorizationModelRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WriteAuthorizationModelRequestValidationError{}

var _WriteAuthorizationModelRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _WriteAuthorizationModelRequest_SchemaVersion_InLookup = map[string]struct{}{
	"1.0": {},
	"1.1": {},
	"1.2": {},
}

var _WriteAuthorizationModelRequest_Conditions_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

// Validate checks the field values on WriteAuthorizationModelResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *WriteAuthorizationModelResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on WriteAuthorizationModelResponse with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// WriteAuthorizationModelResponseMultiError, or nil if none found.
func (m *WriteAuthorizationModelResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *WriteAuthorizationModelResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_WriteAuthorizationModelResponse_AuthorizationModelId_Pattern.MatchString(m.GetAuthorizationModelId()) {
		err := WriteAuthorizationModelResponseValidationError{
			field:  "AuthorizationModelId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return WriteAuthorizationModelResponseMultiError(errors)
	}

	return nil
}

// WriteAuthorizationModelResponseMultiError is an error wrapping multiple
// validation errors returned by WriteAuthorizationModelResponse.ValidateAll()
// if the designated constraints aren't met.
type WriteAuthorizationModelResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WriteAuthorizationModelResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WriteAuthorizationModelResponseMultiError) AllErrors() []error { return m }

// WriteAuthorizationModelResponseValidationError is the validation error
// returned by WriteAuthorizationModelResponse.Validate if the designated
// constraints aren't met.
type WriteAuthorizationModelResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WriteAuthorizationModelResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WriteAuthorizationModelResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WriteAuthorizationModelResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WriteAuthorizationModelResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WriteAuthorizationModelResponseValidationError) ErrorName() string {
	return "WriteAuthorizationModelResponseValidationError"
}

// Error satisfies the builtin error interface
func (e WriteAuthorizationModelResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWriteAuthorizationModelResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WriteAuthorizationModelResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WriteAuthorizationModelResponseValidationError{}

var _WriteAuthorizationModelResponse_AuthorizationModelId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

// Validate checks the field values on ReadAuthorizationModelsRequest with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ReadAuthorizationModelsRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReadAuthorizationModelsRequest with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// ReadAuthorizationModelsRequestMultiError, or nil if none found.
func (m *ReadAuthorizationModelsRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *ReadAuthorizationModelsRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_ReadAuthorizationModelsRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := ReadAuthorizationModelsRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if wrapper := m.GetPageSize(); wrapper != nil {

		if val := wrapper.GetValue(); val < 1 || val > 100 {
			err := ReadAuthorizationModelsRequestValidationError{
				field:  "PageSize",
				reason: "value must be inside range [1, 100]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(m.GetContinuationToken()) > 5120 {
		err := ReadAuthorizationModelsRequestValidationError{
			field:  "ContinuationToken",
			reason: "value length must be at most 5120 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ReadAuthorizationModelsRequestMultiError(errors)
	}

	return nil
}

// ReadAuthorizationModelsRequestMultiError is an error wrapping multiple
// validation errors returned by ReadAuthorizationModelsRequest.ValidateAll()
// if the designated constraints aren't met.
type ReadAuthorizationModelsRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReadAuthorizationModelsRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReadAuthorizationModelsRequestMultiError) AllErrors() []error { return m }

// ReadAuthorizationModelsRequestValidationError is the validation error
// returned by ReadAuthorizationModelsRequest.Validate if the designated
// constraints aren't met.
type ReadAuthorizationModelsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReadAuthorizationModelsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReadAuthorizationModelsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReadAuthorizationModelsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReadAuthorizationModelsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReadAuthorizationModelsRequestValidationError) ErrorName() string {
	return "ReadAuthorizationModelsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ReadAuthorizationModelsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReadAuthorizationModelsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReadAuthorizationModelsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReadAuthorizationModelsRequestValidationError{}

var _ReadAuthorizationModelsRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

// Validate checks the field values on ReadAuthorizationModelsResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ReadAuthorizationModelsResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReadAuthorizationModelsResponse with
// the rules defined in the proto definition for this message. If any rules
// are violated, the result is a list of violation errors wrapped in
// ReadAuthorizationModelsResponseMultiError, or nil if none found.
func (m *ReadAuthorizationModelsResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *ReadAuthorizationModelsResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetAuthorizationModels() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ReadAuthorizationModelsResponseValidationError{
						field:  fmt.Sprintf("AuthorizationModels[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ReadAuthorizationModelsResponseValidationError{
						field:  fmt.Sprintf("AuthorizationModels[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ReadAuthorizationModelsResponseValidationError{
					field:  fmt.Sprintf("AuthorizationModels[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetContinuationToken()) > 5120 {
		err := ReadAuthorizationModelsResponseValidationError{
			field:  "ContinuationToken",
			reason: "value length must be at most 5120 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ReadAuthorizationModelsResponseMultiError(errors)
	}

	return nil
}

// ReadAuthorizationModelsResponseMultiError is an error wrapping multiple
// validation errors returned by ReadAuthorizationModelsResponse.ValidateAll()
// if the designated constraints aren't met.
type ReadAuthorizationModelsResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReadAuthorizationModelsResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReadAuthorizationModelsResponseMultiError) AllErrors() []error { return m }

// ReadAuthorizationModelsResponseValidationError is the validation error
// returned by ReadAuthorizationModelsResponse.Validate if the designated
// constraints aren't met.
type ReadAuthorizationModelsResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReadAuthorizationModelsResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReadAuthorizationModelsResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReadAuthorizationModelsResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReadAuthorizationModelsResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReadAuthorizationModelsResponseValidationError) ErrorName() string {
	return "ReadAuthorizationModelsResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ReadAuthorizationModelsResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReadAuthorizationModelsResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReadAuthorizationModelsResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReadAuthorizationModelsResponseValidationError{}

// Validate checks the field values on WriteAssertionsRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *WriteAssertionsRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on WriteAssertionsRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// WriteAssertionsRequestMultiError, or nil if none found.
func (m *WriteAssertionsRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *WriteAssertionsRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_WriteAssertionsRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := WriteAssertionsRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_WriteAssertionsRequest_AuthorizationModelId_Pattern.MatchString(m.GetAuthorizationModelId()) {
		err := WriteAssertionsRequestValidationError{
			field:  "AuthorizationModelId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(m.GetAssertions()) > 100 {
		err := WriteAssertionsRequestValidationError{
			field:  "Assertions",
			reason: "value must contain no more than 100 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetAssertions() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, WriteAssertionsRequestValidationError{
						field:  fmt.Sprintf("Assertions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, WriteAssertionsRequestValidationError{
						field:  fmt.Sprintf("Assertions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return WriteAssertionsRequestValidationError{
					field:  fmt.Sprintf("Assertions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return WriteAssertionsRequestMultiError(errors)
	}

	return nil
}

// WriteAssertionsRequestMultiError is an error wrapping multiple validation
// errors returned by WriteAssertionsRequest.ValidateAll() if the designated
// constraints aren't met.
type WriteAssertionsRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WriteAssertionsRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WriteAssertionsRequestMultiError) AllErrors() []error { return m }

// WriteAssertionsRequestValidationError is the validation error returned by
// WriteAssertionsRequest.Validate if the designated constraints aren't met.
type WriteAssertionsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WriteAssertionsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WriteAssertionsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WriteAssertionsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WriteAssertionsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WriteAssertionsRequestValidationError) ErrorName() string {
	return "WriteAssertionsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e WriteAssertionsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWriteAssertionsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WriteAssertionsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WriteAssertionsRequestValidationError{}

var _WriteAssertionsRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _WriteAssertionsRequest_AuthorizationModelId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

// Validate checks the field values on WriteAssertionsResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *WriteAssertionsResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on WriteAssertionsResponse with the
// rules defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// WriteAssertionsResponseMultiError, or nil if none found.
func (m *WriteAssertionsResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *WriteAssertionsResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return WriteAssertionsResponseMultiError(errors)
	}

	return nil
}

// WriteAssertionsResponseMultiError is an error wrapping multiple validation
// errors returned by WriteAssertionsResponse.ValidateAll() if the designated
// constraints aren't met.
type WriteAssertionsResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m WriteAssertionsResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m WriteAssertionsResponseMultiError) AllErrors() []error { return m }

// WriteAssertionsResponseValidationError is the validation error returned by
// WriteAssertionsResponse.Validate if the designated constraints aren't met.
type WriteAssertionsResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e WriteAssertionsResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e WriteAssertionsResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e WriteAssertionsResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e WriteAssertionsResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e WriteAssertionsResponseValidationError) ErrorName() string {
	return "WriteAssertionsResponseValidationError"
}

// Error satisfies the builtin error interface
func (e WriteAssertionsResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sWriteAssertionsResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = WriteAssertionsResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = WriteAssertionsResponseValidationError{}

// Validate checks the field values on ReadAssertionsRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ReadAssertionsRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReadAssertionsRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ReadAssertionsRequestMultiError, or nil if none found.
func (m *ReadAssertionsRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *ReadAssertionsRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_ReadAssertionsRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := ReadAssertionsRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_ReadAssertionsRequest_AuthorizationModelId_Pattern.MatchString(m.GetAuthorizationModelId()) {
		err := ReadAssertionsRequestValidationError{
			field:  "AuthorizationModelId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ReadAssertionsRequestMultiError(errors)
	}

	return nil
}

// ReadAssertionsRequestMultiError is an error wrapping multiple validation
// errors returned by ReadAssertionsRequest.ValidateAll() if the designated
// constraints aren't met.
type ReadAssertionsRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReadAssertionsRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReadAssertionsRequestMultiError) AllErrors() []error { return m }

// ReadAssertionsRequestValidationError is the validation error returned by
// ReadAssertionsRequest.Validate if the designated constraints aren't met.
type ReadAssertionsRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReadAssertionsRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReadAssertionsRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReadAssertionsRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReadAssertionsRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReadAssertionsRequestValidationError) ErrorName() string {
	return "ReadAssertionsRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ReadAssertionsRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReadAssertionsRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReadAssertionsRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReadAssertionsRequestValidationError{}

var _ReadAssertionsRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _ReadAssertionsRequest_AuthorizationModelId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

// Validate checks the field values on ReadAssertionsResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ReadAssertionsResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReadAssertionsResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ReadAssertionsResponseMultiError, or nil if none found.
func (m *ReadAssertionsResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *ReadAssertionsResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_ReadAssertionsResponse_AuthorizationModelId_Pattern.MatchString(m.GetAuthorizationModelId()) {
		err := ReadAssertionsResponseValidationError{
			field:  "AuthorizationModelId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetAssertions() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ReadAssertionsResponseValidationError{
						field:  fmt.Sprintf("Assertions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ReadAssertionsResponseValidationError{
						field:  fmt.Sprintf("Assertions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ReadAssertionsResponseValidationError{
					field:  fmt.Sprintf("Assertions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return ReadAssertionsResponseMultiError(errors)
	}

	return nil
}

// ReadAssertionsResponseMultiError is an error wrapping multiple validation
// errors returned by ReadAssertionsResponse.ValidateAll() if the designated
// constraints aren't met.
type ReadAssertionsResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReadAssertionsResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReadAssertionsResponseMultiError) AllErrors() []error { return m }

// ReadAssertionsResponseValidationError is the validation error returned by
// ReadAssertionsResponse.Validate if the designated constraints aren't met.
type ReadAssertionsResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReadAssertionsResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReadAssertionsResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReadAssertionsResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReadAssertionsResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReadAssertionsResponseValidationError) ErrorName() string {
	return "ReadAssertionsResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ReadAssertionsResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReadAssertionsResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReadAssertionsResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReadAssertionsResponseValidationError{}

var _ReadAssertionsResponse_AuthorizationModelId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

// Validate checks the field values on ReadChangesRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ReadChangesRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReadChangesRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ReadChangesRequestMultiError, or nil if none found.
func (m *ReadChangesRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *ReadChangesRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_ReadChangesRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := ReadChangesRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if m.GetType() != "" {

		if !_ReadChangesRequest_Type_Pattern.MatchString(m.GetType()) {
			err := ReadChangesRequestValidationError{
				field:  "Type",
				reason: "value does not match regex pattern \"^[^:#\\\\s]{1,254}$\"",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if wrapper := m.GetPageSize(); wrapper != nil {

		if val := wrapper.GetValue(); val < 1 || val > 100 {
			err := ReadChangesRequestValidationError{
				field:  "PageSize",
				reason: "value must be inside range [1, 100]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(m.GetContinuationToken()) > 5120 {
		err := ReadChangesRequestValidationError{
			field:  "ContinuationToken",
			reason: "value length must be at most 5120 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if t := m.GetStartTime(); t != nil {
		ts, err := t.AsTime(), t.CheckValid()
		if err != nil {
			err = ReadChangesRequestValidationError{
				field:  "StartTime",
				reason: "value is not a valid timestamp",
				cause:  err,
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {

			now := time.Now()

			if ts.Sub(now) >= 0 {
				err := ReadChangesRequestValidationError{
					field:  "StartTime",
					reason: "value must be less than now",
				}
				if !all {
					return err
				}
				errors = append(errors, err)
			}

		}
	}

	if len(errors) > 0 {
		return ReadChangesRequestMultiError(errors)
	}

	return nil
}

// ReadChangesRequestMultiError is an error wrapping multiple validation errors
// returned by ReadChangesRequest.ValidateAll() if the designated constraints
// aren't met.
type ReadChangesRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReadChangesRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReadChangesRequestMultiError) AllErrors() []error { return m }

// ReadChangesRequestValidationError is the validation error returned by
// ReadChangesRequest.Validate if the designated constraints aren't met.
type ReadChangesRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReadChangesRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReadChangesRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReadChangesRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReadChangesRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReadChangesRequestValidationError) ErrorName() string {
	return "ReadChangesRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ReadChangesRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReadChangesRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReadChangesRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReadChangesRequestValidationError{}

var _ReadChangesRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _ReadChangesRequest_Type_Pattern = regexp.MustCompile("^[^:#\\s]{1,254}$")

// Validate checks the field values on ReadChangesResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ReadChangesResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ReadChangesResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ReadChangesResponseMultiError, or nil if none found.
func (m *ReadChangesResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *ReadChangesResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetChanges() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ReadChangesResponseValidationError{
						field:  fmt.Sprintf("Changes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ReadChangesResponseValidationError{
						field:  fmt.Sprintf("Changes[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ReadChangesResponseValidationError{
					field:  fmt.Sprintf("Changes[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetContinuationToken()) > 5120 {
		err := ReadChangesResponseValidationError{
			field:  "ContinuationToken",
			reason: "value length must be at most 5120 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ReadChangesResponseMultiError(errors)
	}

	return nil
}

// ReadChangesResponseMultiError is an error wrapping multiple validation
// errors returned by ReadChangesResponse.ValidateAll() if the designated
// constraints aren't met.
type ReadChangesResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ReadChangesResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ReadChangesResponseMultiError) AllErrors() []error { return m }

// ReadChangesResponseValidationError is the validation error returned by
// ReadChangesResponse.Validate if the designated constraints aren't met.
type ReadChangesResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ReadChangesResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ReadChangesResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ReadChangesResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ReadChangesResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ReadChangesResponseValidationError) ErrorName() string {
	return "ReadChangesResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ReadChangesResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sReadChangesResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ReadChangesResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ReadChangesResponseValidationError{}

// Validate checks the field values on CreateStoreRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *CreateStoreRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CreateStoreRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// CreateStoreRequestMultiError, or nil if none found.
func (m *CreateStoreRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *CreateStoreRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_CreateStoreRequest_Name_Pattern.MatchString(m.GetName()) {
		err := CreateStoreRequestValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[a-zA-Z0-9\\\\s\\\\.\\\\-\\\\/^_&@]{3,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return CreateStoreRequestMultiError(errors)
	}

	return nil
}

// CreateStoreRequestMultiError is an error wrapping multiple validation errors
// returned by CreateStoreRequest.ValidateAll() if the designated constraints
// aren't met.
type CreateStoreRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CreateStoreRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CreateStoreRequestMultiError) AllErrors() []error { return m }

// CreateStoreRequestValidationError is the validation error returned by
// CreateStoreRequest.Validate if the designated constraints aren't met.
type CreateStoreRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateStoreRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateStoreRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateStoreRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateStoreRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateStoreRequestValidationError) ErrorName() string {
	return "CreateStoreRequestValidationError"
}

// Error satisfies the builtin error interface
func (e CreateStoreRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateStoreRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateStoreRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateStoreRequestValidationError{}

var _CreateStoreRequest_Name_Pattern = regexp.MustCompile("^[a-zA-Z0-9\\s\\.\\-\\/^_&@]{3,64}$")

// Validate checks the field values on CreateStoreResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *CreateStoreResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on CreateStoreResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// CreateStoreResponseMultiError, or nil if none found.
func (m *CreateStoreResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *CreateStoreResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	// no validation rules for Name

	if all {
		switch v := interface{}(m.GetCreatedAt()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CreateStoreResponseValidationError{
					field:  "CreatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CreateStoreResponseValidationError{
					field:  "CreatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCreatedAt()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CreateStoreResponseValidationError{
				field:  "CreatedAt",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetUpdatedAt()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, CreateStoreResponseValidationError{
					field:  "UpdatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, CreateStoreResponseValidationError{
					field:  "UpdatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpdatedAt()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return CreateStoreResponseValidationError{
				field:  "UpdatedAt",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return CreateStoreResponseMultiError(errors)
	}

	return nil
}

// CreateStoreResponseMultiError is an error wrapping multiple validation
// errors returned by CreateStoreResponse.ValidateAll() if the designated
// constraints aren't met.
type CreateStoreResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m CreateStoreResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m CreateStoreResponseMultiError) AllErrors() []error { return m }

// CreateStoreResponseValidationError is the validation error returned by
// CreateStoreResponse.Validate if the designated constraints aren't met.
type CreateStoreResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e CreateStoreResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e CreateStoreResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e CreateStoreResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e CreateStoreResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e CreateStoreResponseValidationError) ErrorName() string {
	return "CreateStoreResponseValidationError"
}

// Error satisfies the builtin error interface
func (e CreateStoreResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sCreateStoreResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = CreateStoreResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = CreateStoreResponseValidationError{}

// Validate checks the field values on UpdateStoreRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *UpdateStoreRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UpdateStoreRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UpdateStoreRequestMultiError, or nil if none found.
func (m *UpdateStoreRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *UpdateStoreRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_UpdateStoreRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := UpdateStoreRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_UpdateStoreRequest_Name_Pattern.MatchString(m.GetName()) {
		err := UpdateStoreRequestValidationError{
			field:  "Name",
			reason: "value does not match regex pattern \"^[a-zA-Z0-9\\\\s\\\\.\\\\-\\\\/^_&@]{3,64}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return UpdateStoreRequestMultiError(errors)
	}

	return nil
}

// UpdateStoreRequestMultiError is an error wrapping multiple validation errors
// returned by UpdateStoreRequest.ValidateAll() if the designated constraints
// aren't met.
type UpdateStoreRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UpdateStoreRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UpdateStoreRequestMultiError) AllErrors() []error { return m }

// UpdateStoreRequestValidationError is the validation error returned by
// UpdateStoreRequest.Validate if the designated constraints aren't met.
type UpdateStoreRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdateStoreRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdateStoreRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdateStoreRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdateStoreRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdateStoreRequestValidationError) ErrorName() string {
	return "UpdateStoreRequestValidationError"
}

// Error satisfies the builtin error interface
func (e UpdateStoreRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdateStoreRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdateStoreRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdateStoreRequestValidationError{}

var _UpdateStoreRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

var _UpdateStoreRequest_Name_Pattern = regexp.MustCompile("^[a-zA-Z0-9\\s\\.\\-\\/^_&@]{3,64}$")

// Validate checks the field values on UpdateStoreResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *UpdateStoreResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on UpdateStoreResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// UpdateStoreResponseMultiError, or nil if none found.
func (m *UpdateStoreResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *UpdateStoreResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	// no validation rules for Name

	if all {
		switch v := interface{}(m.GetCreatedAt()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UpdateStoreResponseValidationError{
					field:  "CreatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UpdateStoreResponseValidationError{
					field:  "CreatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCreatedAt()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UpdateStoreResponseValidationError{
				field:  "CreatedAt",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetUpdatedAt()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, UpdateStoreResponseValidationError{
					field:  "UpdatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, UpdateStoreResponseValidationError{
					field:  "UpdatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpdatedAt()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return UpdateStoreResponseValidationError{
				field:  "UpdatedAt",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return UpdateStoreResponseMultiError(errors)
	}

	return nil
}

// UpdateStoreResponseMultiError is an error wrapping multiple validation
// errors returned by UpdateStoreResponse.ValidateAll() if the designated
// constraints aren't met.
type UpdateStoreResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m UpdateStoreResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m UpdateStoreResponseMultiError) AllErrors() []error { return m }

// UpdateStoreResponseValidationError is the validation error returned by
// UpdateStoreResponse.Validate if the designated constraints aren't met.
type UpdateStoreResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e UpdateStoreResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e UpdateStoreResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e UpdateStoreResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e UpdateStoreResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e UpdateStoreResponseValidationError) ErrorName() string {
	return "UpdateStoreResponseValidationError"
}

// Error satisfies the builtin error interface
func (e UpdateStoreResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sUpdateStoreResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = UpdateStoreResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = UpdateStoreResponseValidationError{}

// Validate checks the field values on DeleteStoreRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DeleteStoreRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DeleteStoreRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DeleteStoreRequestMultiError, or nil if none found.
func (m *DeleteStoreRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *DeleteStoreRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_DeleteStoreRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := DeleteStoreRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return DeleteStoreRequestMultiError(errors)
	}

	return nil
}

// DeleteStoreRequestMultiError is an error wrapping multiple validation errors
// returned by DeleteStoreRequest.ValidateAll() if the designated constraints
// aren't met.
type DeleteStoreRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DeleteStoreRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DeleteStoreRequestMultiError) AllErrors() []error { return m }

// DeleteStoreRequestValidationError is the validation error returned by
// DeleteStoreRequest.Validate if the designated constraints aren't met.
type DeleteStoreRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DeleteStoreRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DeleteStoreRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DeleteStoreRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DeleteStoreRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DeleteStoreRequestValidationError) ErrorName() string {
	return "DeleteStoreRequestValidationError"
}

// Error satisfies the builtin error interface
func (e DeleteStoreRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDeleteStoreRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DeleteStoreRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DeleteStoreRequestValidationError{}

var _DeleteStoreRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

// Validate checks the field values on DeleteStoreResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *DeleteStoreResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on DeleteStoreResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// DeleteStoreResponseMultiError, or nil if none found.
func (m *DeleteStoreResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *DeleteStoreResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if len(errors) > 0 {
		return DeleteStoreResponseMultiError(errors)
	}

	return nil
}

// DeleteStoreResponseMultiError is an error wrapping multiple validation
// errors returned by DeleteStoreResponse.ValidateAll() if the designated
// constraints aren't met.
type DeleteStoreResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m DeleteStoreResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m DeleteStoreResponseMultiError) AllErrors() []error { return m }

// DeleteStoreResponseValidationError is the validation error returned by
// DeleteStoreResponse.Validate if the designated constraints aren't met.
type DeleteStoreResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e DeleteStoreResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e DeleteStoreResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e DeleteStoreResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e DeleteStoreResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e DeleteStoreResponseValidationError) ErrorName() string {
	return "DeleteStoreResponseValidationError"
}

// Error satisfies the builtin error interface
func (e DeleteStoreResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sDeleteStoreResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = DeleteStoreResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = DeleteStoreResponseValidationError{}

// Validate checks the field values on GetStoreRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *GetStoreRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GetStoreRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GetStoreRequestMultiError, or nil if none found.
func (m *GetStoreRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *GetStoreRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_GetStoreRequest_StoreId_Pattern.MatchString(m.GetStoreId()) {
		err := GetStoreRequestValidationError{
			field:  "StoreId",
			reason: "value does not match regex pattern \"^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return GetStoreRequestMultiError(errors)
	}

	return nil
}

// GetStoreRequestMultiError is an error wrapping multiple validation errors
// returned by GetStoreRequest.ValidateAll() if the designated constraints
// aren't met.
type GetStoreRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GetStoreRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GetStoreRequestMultiError) AllErrors() []error { return m }

// GetStoreRequestValidationError is the validation error returned by
// GetStoreRequest.Validate if the designated constraints aren't met.
type GetStoreRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetStoreRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetStoreRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetStoreRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetStoreRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetStoreRequestValidationError) ErrorName() string { return "GetStoreRequestValidationError" }

// Error satisfies the builtin error interface
func (e GetStoreRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetStoreRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetStoreRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetStoreRequestValidationError{}

var _GetStoreRequest_StoreId_Pattern = regexp.MustCompile("^[ABCDEFGHJKMNPQRSTVWXYZ0-9]{26}$")

// Validate checks the field values on GetStoreResponse with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *GetStoreResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on GetStoreResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// GetStoreResponseMultiError, or nil if none found.
func (m *GetStoreResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *GetStoreResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Id

	// no validation rules for Name

	if all {
		switch v := interface{}(m.GetCreatedAt()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GetStoreResponseValidationError{
					field:  "CreatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GetStoreResponseValidationError{
					field:  "CreatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetCreatedAt()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GetStoreResponseValidationError{
				field:  "CreatedAt",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetUpdatedAt()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GetStoreResponseValidationError{
					field:  "UpdatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GetStoreResponseValidationError{
					field:  "UpdatedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetUpdatedAt()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GetStoreResponseValidationError{
				field:  "UpdatedAt",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if all {
		switch v := interface{}(m.GetDeletedAt()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, GetStoreResponseValidationError{
					field:  "DeletedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, GetStoreResponseValidationError{
					field:  "DeletedAt",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetDeletedAt()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return GetStoreResponseValidationError{
				field:  "DeletedAt",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return GetStoreResponseMultiError(errors)
	}

	return nil
}

// GetStoreResponseMultiError is an error wrapping multiple validation errors
// returned by GetStoreResponse.ValidateAll() if the designated constraints
// aren't met.
type GetStoreResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m GetStoreResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m GetStoreResponseMultiError) AllErrors() []error { return m }

// GetStoreResponseValidationError is the validation error returned by
// GetStoreResponse.Validate if the designated constraints aren't met.
type GetStoreResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e GetStoreResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e GetStoreResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e GetStoreResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e GetStoreResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e GetStoreResponseValidationError) ErrorName() string { return "GetStoreResponseValidationError" }

// Error satisfies the builtin error interface
func (e GetStoreResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sGetStoreResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = GetStoreResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = GetStoreResponseValidationError{}

// Validate checks the field values on ListStoresRequest with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *ListStoresRequest) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListStoresRequest with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ListStoresRequestMultiError, or nil if none found.
func (m *ListStoresRequest) ValidateAll() error {
	return m.validate(true)
}

func (m *ListStoresRequest) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if wrapper := m.GetPageSize(); wrapper != nil {

		if val := wrapper.GetValue(); val < 1 || val > 100 {
			err := ListStoresRequestValidationError{
				field:  "PageSize",
				reason: "value must be inside range [1, 100]",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(m.GetContinuationToken()) > 5120 {
		err := ListStoresRequestValidationError{
			field:  "ContinuationToken",
			reason: "value length must be at most 5120 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ListStoresRequestMultiError(errors)
	}

	return nil
}

// ListStoresRequestMultiError is an error wrapping multiple validation errors
// returned by ListStoresRequest.ValidateAll() if the designated constraints
// aren't met.
type ListStoresRequestMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListStoresRequestMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListStoresRequestMultiError) AllErrors() []error { return m }

// ListStoresRequestValidationError is the validation error returned by
// ListStoresRequest.Validate if the designated constraints aren't met.
type ListStoresRequestValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListStoresRequestValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListStoresRequestValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListStoresRequestValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListStoresRequestValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListStoresRequestValidationError) ErrorName() string {
	return "ListStoresRequestValidationError"
}

// Error satisfies the builtin error interface
func (e ListStoresRequestValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListStoresRequest.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListStoresRequestValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListStoresRequestValidationError{}

// Validate checks the field values on ListStoresResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *ListStoresResponse) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on ListStoresResponse with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// ListStoresResponseMultiError, or nil if none found.
func (m *ListStoresResponse) ValidateAll() error {
	return m.validate(true)
}

func (m *ListStoresResponse) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetStores() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, ListStoresResponseValidationError{
						field:  fmt.Sprintf("Stores[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, ListStoresResponseValidationError{
						field:  fmt.Sprintf("Stores[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return ListStoresResponseValidationError{
					field:  fmt.Sprintf("Stores[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(m.GetContinuationToken()) > 5120 {
		err := ListStoresResponseValidationError{
			field:  "ContinuationToken",
			reason: "value length must be at most 5120 bytes",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return ListStoresResponseMultiError(errors)
	}

	return nil
}

// ListStoresResponseMultiError is an error wrapping multiple validation errors
// returned by ListStoresResponse.ValidateAll() if the designated constraints
// aren't met.
type ListStoresResponseMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m ListStoresResponseMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m ListStoresResponseMultiError) AllErrors() []error { return m }

// ListStoresResponseValidationError is the validation error returned by
// ListStoresResponse.Validate if the designated constraints aren't met.
type ListStoresResponseValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e ListStoresResponseValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e ListStoresResponseValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e ListStoresResponseValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e ListStoresResponseValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e ListStoresResponseValidationError) ErrorName() string {
	return "ListStoresResponseValidationError"
}

// Error satisfies the builtin error interface
func (e ListStoresResponseValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sListStoresResponse.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = ListStoresResponseValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = ListStoresResponseValidationError{}

// Validate checks the field values on AssertionTupleKey with the rules defined
// in the proto definition for this message. If any rules are violated, the
// first error encountered is returned, or nil if there are no violations.
func (m *AssertionTupleKey) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on AssertionTupleKey with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// AssertionTupleKeyMultiError, or nil if none found.
func (m *AssertionTupleKey) ValidateAll() error {
	return m.validate(true)
}

func (m *AssertionTupleKey) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if !_AssertionTupleKey_Object_Pattern.MatchString(m.GetObject()) {
		err := AssertionTupleKeyValidationError{
			field:  "Object",
			reason: "value does not match regex pattern \"^[^\\\\s]{2,256}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_AssertionTupleKey_Relation_Pattern.MatchString(m.GetRelation()) {
		err := AssertionTupleKeyValidationError{
			field:  "Relation",
			reason: "value does not match regex pattern \"^[^:#@\\\\s]{1,50}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if !_AssertionTupleKey_User_Pattern.MatchString(m.GetUser()) {
		err := AssertionTupleKeyValidationError{
			field:  "User",
			reason: "value does not match regex pattern \"^[^\\\\s]{2,512}$\"",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if len(errors) > 0 {
		return AssertionTupleKeyMultiError(errors)
	}

	return nil
}

// AssertionTupleKeyMultiError is an error wrapping multiple validation errors
// returned by AssertionTupleKey.ValidateAll() if the designated constraints
// aren't met.
type AssertionTupleKeyMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AssertionTupleKeyMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AssertionTupleKeyMultiError) AllErrors() []error { return m }

// AssertionTupleKeyValidationError is the validation error returned by
// AssertionTupleKey.Validate if the designated constraints aren't met.
type AssertionTupleKeyValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AssertionTupleKeyValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AssertionTupleKeyValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AssertionTupleKeyValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AssertionTupleKeyValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AssertionTupleKeyValidationError) ErrorName() string {
	return "AssertionTupleKeyValidationError"
}

// Error satisfies the builtin error interface
func (e AssertionTupleKeyValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAssertionTupleKey.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AssertionTupleKeyValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AssertionTupleKeyValidationError{}

var _AssertionTupleKey_Object_Pattern = regexp.MustCompile("^[^\\s]{2,256}$")

var _AssertionTupleKey_Relation_Pattern = regexp.MustCompile("^[^:#@\\s]{1,50}$")

var _AssertionTupleKey_User_Pattern = regexp.MustCompile("^[^\\s]{2,512}$")

// Validate checks the field values on Assertion with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Assertion) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Assertion with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in AssertionMultiError, or nil
// if none found.
func (m *Assertion) ValidateAll() error {
	return m.validate(true)
}

func (m *Assertion) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	if m.GetTupleKey() == nil {
		err := AssertionValidationError{
			field:  "TupleKey",
			reason: "value is required",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	if all {
		switch v := interface{}(m.GetTupleKey()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AssertionValidationError{
					field:  "TupleKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AssertionValidationError{
					field:  "TupleKey",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetTupleKey()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AssertionValidationError{
				field:  "TupleKey",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	// no validation rules for Expectation

	if len(m.GetContextualTuples()) > 20 {
		err := AssertionValidationError{
			field:  "ContextualTuples",
			reason: "value must contain no more than 20 item(s)",
		}
		if !all {
			return err
		}
		errors = append(errors, err)
	}

	for idx, item := range m.GetContextualTuples() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AssertionValidationError{
						field:  fmt.Sprintf("ContextualTuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AssertionValidationError{
						field:  fmt.Sprintf("ContextualTuples[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AssertionValidationError{
					field:  fmt.Sprintf("ContextualTuples[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if all {
		switch v := interface{}(m.GetContext()).(type) {
		case interface{ ValidateAll() error }:
			if err := v.ValidateAll(); err != nil {
				errors = append(errors, AssertionValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		case interface{ Validate() error }:
			if err := v.Validate(); err != nil {
				errors = append(errors, AssertionValidationError{
					field:  "Context",
					reason: "embedded message failed validation",
					cause:  err,
				})
			}
		}
	} else if v, ok := interface{}(m.GetContext()).(interface{ Validate() error }); ok {
		if err := v.Validate(); err != nil {
			return AssertionValidationError{
				field:  "Context",
				reason: "embedded message failed validation",
				cause:  err,
			}
		}
	}

	if len(errors) > 0 {
		return AssertionMultiError(errors)
	}

	return nil
}

// AssertionMultiError is an error wrapping multiple validation errors returned
// by Assertion.ValidateAll() if the designated constraints aren't met.
type AssertionMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AssertionMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AssertionMultiError) AllErrors() []error { return m }

// AssertionValidationError is the validation error returned by
// Assertion.Validate if the designated constraints aren't met.
type AssertionValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AssertionValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AssertionValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AssertionValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AssertionValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AssertionValidationError) ErrorName() string { return "AssertionValidationError" }

// Error satisfies the builtin error interface
func (e AssertionValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAssertion.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AssertionValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AssertionValidationError{}

// Validate checks the field values on Assertions with the rules defined in the
// proto definition for this message. If any rules are violated, the first
// error encountered is returned, or nil if there are no violations.
func (m *Assertions) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on Assertions with the rules defined in
// the proto definition for this message. If any rules are violated, the
// result is a list of violation errors wrapped in AssertionsMultiError, or
// nil if none found.
func (m *Assertions) ValidateAll() error {
	return m.validate(true)
}

func (m *Assertions) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	for idx, item := range m.GetAssertions() {
		_, _ = idx, item

		if all {
			switch v := interface{}(item).(type) {
			case interface{ ValidateAll() error }:
				if err := v.ValidateAll(); err != nil {
					errors = append(errors, AssertionsValidationError{
						field:  fmt.Sprintf("Assertions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			case interface{ Validate() error }:
				if err := v.Validate(); err != nil {
					errors = append(errors, AssertionsValidationError{
						field:  fmt.Sprintf("Assertions[%v]", idx),
						reason: "embedded message failed validation",
						cause:  err,
					})
				}
			}
		} else if v, ok := interface{}(item).(interface{ Validate() error }); ok {
			if err := v.Validate(); err != nil {
				return AssertionsValidationError{
					field:  fmt.Sprintf("Assertions[%v]", idx),
					reason: "embedded message failed validation",
					cause:  err,
				}
			}
		}

	}

	if len(errors) > 0 {
		return AssertionsMultiError(errors)
	}

	return nil
}

// AssertionsMultiError is an error wrapping multiple validation errors
// returned by Assertions.ValidateAll() if the designated constraints aren't met.
type AssertionsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m AssertionsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m AssertionsMultiError) AllErrors() []error { return m }

// AssertionsValidationError is the validation error returned by
// Assertions.Validate if the designated constraints aren't met.
type AssertionsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e AssertionsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e AssertionsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e AssertionsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e AssertionsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e AssertionsValidationError) ErrorName() string { return "AssertionsValidationError" }

// Error satisfies the builtin error interface
func (e AssertionsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sAssertions.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = AssertionsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = AssertionsValidationError{}
