#!/usr/bin/env python3
"""Increase lightness"""

import inkex


class MoreLight(inkex.ColorExtension):
    """Lighten selected objects"""

    target_space = "hsl"

    def modify_color(self, name, color):
        color.lightness += int(0.05 * 100.0)
        return color


if __name__ == "__main__":
    MoreLight().run()
