#!/usr/bin/env python3
"""Reduce saturation"""

import inkex


class LessSaturation(inkex.ColorExtension):
    """Make colours less saturated"""

    target_space = "hsl"

    def modify_color(self, name, color):
        color.saturation -= int(0.05 * 100)
        return color


if __name__ == "__main__":
    LessSaturation().run()
