# Begin /etc/bashrc
# Written for Beyond Linux From Scratch
# by James Robertson <jameswrobertson@earthlink.net>
# updated by Bruce Dubbs <bdubbs@linuxfromscratch.org>

# System wide aliases and functions.

# System wide environment variables and startup programs should go into
# /etc/profile.  Personal environment variables and startup programs
# should go into ~/.bash_profile.  Personal aliases and functions should
# go into ~/.bashrc

# Provides a colored /bin/ls command.  Used in conjunction with code in
# /etc/profile.

alias ls='ls --color=auto'

# Provides prompt for non-login shells, specifically shells started
# in the X environment. [Review the LFS archive thread titled
# PS1 Environment Variable for a great case study behind this script
# addendum.]

NORMAL="\[\e[0m\]"
RED="\[\e[1;31m\]"
GREEN="\[\e[1;32m\]"
WHITE="\[\e[1;37m\]"
INFOMACHINE="$(date +%H:%M) $(uname -m) $(uname -r) $(whoami)@$(uname -n)"
prompt_command() {
# Sauvegarde de la pos courante
tput sc
# Calcul de la largeur
let backwash=$(tput cols)-$(echo $INFOMACHINE | wc -m)-2
# Pos des curseurs à la position Y=0, X=longueur calculée
tput cup 0 ${backwash}
# Spécifie la couleur et la casse de la police
tput setaf 4; tput bold
# Affiche le chemin entre crochets
echo -n "["
# Specifie la couleur du chemin
tput setaf 6
# Affiche le chemin complet
echo -n "$INFOMACHINE"
tput setaf 4; tput bold
# Affiche le crochet fermé
echo -n "]"
# Remet le curseur à sa place
tput rc
}

#PROMPT_COMMAND=prompt_command

export XZ_DEFAULTS="-T0"
export XZ_OPT="-T0"

case $TERM in
        xterm|rxvt*)
                TITLEBAR='\[\033]0;\u@\h \007\]'
                ;;
        *)
                TITLEBAR=''
                ;;
esac

export PS1="\u@\h:\w\\$ "

#if [[ $EUID == 0 ]] ; then
#  PS1="$TITLEBAR$RED\u [ $NORMAL\w$RED ]# $NORMAL"
#else
#  PS1="$TITLEBAR$GREEN\u [ $NORMAL\w$GREEN ]\$ $NORMAL"
#fi
# End /etc/bashrc
