GI-DocGen: Documentation tool for GObject-based libraries
-------------------------------------------------------------------------------

GI-DocGen is a document generator for GObject-based libraries. GObject is
the base type system of the GNOME project. GI-Docgen reuses the
introspection data generated by GObject-based libraries to generate the API
reference of these libraries, as well as other ancillary documentation.

## Installation

### Running GI-DocGen uninstalled

You can run GI-DocGen from its repository, by calling:

```
./gi-docgen.py
```

GI-DocGen will automatically detect this case.

### Installing GI-DocGen via pip

To install GI-DocGen, you will need to have the following pieces of software
available on your computer:

 - Python 3.6, or later
 - pip

Run the following command:

```
pip3 install --user gi-docgen
```

After running the command above, make sure to have the `~/.local/bin`
directory listed in your `$PATH` environment variable.

To update GI-DocGen, run the following command:

```
pip3 install --user --upgrade gi-docgen
```

## Usage

First, read [the GI-DocGen tutorial](https://gnome.pages.gitlab.gnome.org/gi-docgen/tutorial.html).

The documentation for GI-DocGen is [available online](https://gnome.pages.gitlab.gnome.org/gi-docgen/).

The `examples` directory in the repository contains simple project files for
various GNOME libraries.

## Disclaimer

GI-DocGen is **not** a general purpose documentation tool for C libraries.

While GI-DocGen can be used to generate API references for most GObject/C
libraries that expose introspection data, its main goal is to generate the
reference for GTK and its immediate dependencies. Any and all attempts at
making this tool more generic, or to cover more use cases, will be weighted
heavily against its primary goal.

GI-DocGen is still in development. The recommended use of GI-DocGen is to
add it as a sub-project to your [Meson build system](https://mesonbuild.com),
and vendor it when releasing dist archives.

You should **not** depend on a system-wide installation until GI-DocGen is
declared stable.

If you need a general purpose documentation tool, I strongly recommend:

 - [HotDoc](https://hotdoc.github.io/)
 - [Doxygen](https://www.doxygen.nl/index.html)
 - [GTK-Doc](https://gitlab.gnome.org/GNOME/gtk-doc/)

## Copyright and Licensing terms

Copyright 2021  GNOME Foundation

GI-DocGen is released under the terms of the Apache License, version 2.0, or
under the terms of the GNU General Public License, either version 3.0 or,
at your option, any later version.
