#include <asm/bitsperlong.h>
#if BITS_PER_LONG == 64
#define PTR .quad
#define ALGN .balign 8
#else
#define PTR .long
#define ALGN .balign 4
#endif
	.section .rodata, "a"
.globl kallsyms_num_syms
	ALGN
kallsyms_num_syms:
	.long	350225

.globl kallsyms_names
	ALGN
kallsyms_names:
	.byte 0x0b, 0x41, 0xb8, 0x78, 0x65, 0x64, 0xe7, 0xee, 0x92, 0x5f, 0x64, 0x0f	/* Afixed_percpu_data */
	.byte 0x09, 0x41, 0xff, 0x70, 0xcf, 0x92, 0xf6, 0xdb, 0x72, 0x74	/* A__per_cpu_start */
	.byte 0x09, 0x41, 0x92, 0x5f, 0xe6, 0xa2, 0x67, 0xf6, 0xac, 0xf8	/* Acpu_debug_store */
	.byte 0x0e, 0x41, 0xa7, 0x71, 0x2a, 0xeb, 0xd8, 0x62, 0xeb, 0x6b, 0xf0, 0x67, 0xf6, 0xac, 0xf8	/* Airq_stack_backing_store */
	.byte 0x08, 0x41, 0x92, 0x5f, 0x74, 0x73, 0xe0, 0x72, 0x77	/* Acpu_tss_rw */
	.byte 0x06, 0x41, 0x67, 0x64, 0xf9, 0x70, 0x03	/* Agdt_page */
	.byte 0x0c, 0x41, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0x2a, 0xeb, 0x6b, 0x73	/* Aexception_stacks */
	.byte 0x0a, 0x41, 0xe8, 0xea, 0x79, 0x2a, 0xeb, 0x6b, 0x2a, 0xce, 0x03	/* Aentry_stack_storage */
	.byte 0x08, 0x41, 0x3b, 0xef, 0x69, 0x1a, 0x77, 0x10, 0x72	/* Aespfix_waddr */
	.byte 0x08, 0x41, 0x3b, 0xef, 0x69, 0x78, 0x2a, 0xeb, 0x6b	/* Aespfix_stack */
	.byte 0x0c, 0x41, 0x92, 0x5f, 0x6c, 0x32, 0x63, 0xf6, 0x68, 0x61, 0xf8, 0xe5, 0x0a	/* Acpu_l2c_shared_map */
	.byte 0x0c, 0x41, 0x92, 0x5f, 0x6c, 0x6c, 0x63, 0xf6, 0x68, 0x61, 0xf8, 0xe5, 0x0a	/* Acpu_llc_shared_map */
	.byte 0x06, 0x41, 0x92, 0x5f, 0xf0, 0x66, 0x6f	/* Acpu_info */
	.byte 0x0d, 0x41, 0x78, 0x38, 0x36, 0x5f, 0x92, 0x5f, 0xac, 0x5f, 0xeb, 0x70, 0x69, 0x89	/* Ax86_cpu_to_acpiid */
	.byte 0x0d, 0x41, 0x78, 0x38, 0x36, 0x5f, 0x92, 0x5f, 0xac, 0x5f, 0x61, 0x70, 0xa3, 0x89	/* Ax86_cpu_to_apicid */
	.byte 0x0c, 0x41, 0x61, 0x6d, 0xe5, 0x64, 0x72, 0x5f, 0x10, 0x72, 0x5f, 0xdd, 0x16	/* Aamd_dr_addr_mask */
	.byte 0x0b, 0x41, 0x6d, 0x63, 0xfa, 0x62, 0xcc, 0x6b, 0xe0, 0xca, 0xb5, 0x79	/* Amce_banks_array */
	.byte 0x0b, 0x41, 0x6d, 0x63, 0xfa, 0x6e, 0x75, 0xcd, 0x62, 0xcc, 0x6b, 0x73	/* Amce_num_banks */
	.byte 0x0d, 0x41, 0x73, 0x6d, 0x63, 0x61, 0x5f, 0x62, 0xcc, 0xd8, 0xfe, 0xd4, 0x74, 0x73	/* Asmca_bank_counts */
	.byte 0x0a, 0x41, 0x73, 0x6d, 0x63, 0x61, 0x5f, 0x62, 0xcc, 0x6b, 0x73	/* Asmca_banks */
	.byte 0x07, 0x41, 0x92, 0x5f, 0x64, 0x69, 0xfa, 0x0a	/* Acpu_die_map */
	.byte 0x07, 0x41, 0x92, 0x5f, 0xfe, 0x72, 0xfa, 0x0a	/* Acpu_core_map */
	.byte 0x08, 0x41, 0x92, 0xf6, 0x69, 0x62, 0x88, 0xa6, 0x0a	/* Acpu_sibling_map */
	.byte 0x09, 0x41, 0x15, 0x69, 0xe0, 0x92, 0x5f, 0x6f, 0x66, 0x66	/* Athis_cpu_off */
	.byte 0x09, 0x41, 0x63, 0x6c, 0x75, 0xd6, 0xcf, 0xdd, 0x16, 0x73	/* Acluster_masks */
	.byte 0x0b, 0x41, 0x61, 0xc1, 0x6e, 0xd5, 0xef, 0x5f, 0xe8, 0x80, 0xd3, 0x64	/* Aasync_pf_enabled */
	.byte 0x0c, 0x41, 0x73, 0x7e, 0xe5, 0xfe, 0x72, 0xfa, 0x70, 0x72, 0xd9, 0x8a, 0x79	/* Asched_core_priority */
	.byte 0x0b, 0x41, 0x5f, 0x63, 0x65, 0x61, 0x5f, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* A_cea_offset */
	.byte 0x0a, 0x41, 0x6b, 0xd6, 0xeb, 0xd8, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* Akstack_offset */
	.byte 0x0d, 0x41, 0x92, 0x5f, 0xdf, 0x81, 0x73, 0xe7, 0xcf, 0x6a, 0x69, 0x66, 0x66, 0x79	/* Acpu_loops_per_jiffy */
	.byte 0x0a, 0x41, 0x73, 0x76, 0x73, 0xcd, 0x63, 0x61, 0x61, 0xe7, 0x61	/* Asvsm_caa_pa */
	.byte 0x08, 0x41, 0x73, 0x76, 0x73, 0xcd, 0x63, 0x61, 0x61	/* Asvsm_caa */
	.byte 0x07, 0x41, 0xc9, 0x76, 0x5f, 0x76, 0x20, 0x61	/* Asev_vmsa */
	.byte 0x08, 0x41, 0x72, 0xd4, 0xc2, 0x6d, 0xfa, 0x64, 0x0f	/* Aruntime_data */
	.byte 0x0b, 0x41, 0x70, 0x6d, 0x63, 0xe7, 0xf8, 0x76, 0x5f, 0xd3, 0x66, 0x74	/* Apmc_prev_left */
	.byte 0x08, 0x41, 0x92, 0x5f, 0x68, 0xaa, 0xbc, 0x1e, 0x73	/* Acpu_hw_events */
	.byte 0x0b, 0x41, 0x70, 0xee, 0xa0, 0x6e, 0x6d, 0xcb, 0x74, 0x73, 0xdb, 0xb0	/* Aperf_nmi_tstamp */
	.byte 0x06, 0x41, 0x62, 0x74, 0xe0, 0x7b, 0x78	/* Abts_ctx */
	.byte 0x08, 0x41, 0xf0, 0x73, 0x7c, 0xa2, 0x66, 0x66, 0xee	/* Ainsn_buffer */
	.byte 0x08, 0x41, 0x70, 0x5c, 0x72, 0xd4, 0x6e, 0xf0, 0x67	/* Ap4_running */
	.byte 0x05, 0x41, 0x70, 0xf9, 0x7b, 0x78	/* Apt_ctx */
	.byte 0x08, 0x41, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x5f, 0x89	/* Axen_vcpu_id */
	.byte 0x06, 0x41, 0x78, 0xe8, 0x5f, 0x76, 0x92	/* Axen_vcpu */
	.byte 0x0a, 0x41, 0x78, 0xe8, 0x5f, 0x63, 0xc0, 0xd8, 0xbc, 0x1e, 0x73	/* Axen_clock_events */
	.byte 0x08, 0x41, 0x73, 0x70, 0x65, 0xd5, 0x63, 0xea, 0x6c	/* Aspec_ctrl */
	.byte 0x0b, 0x41, 0x78, 0xe8, 0x70, 0x6d, 0x75, 0xf6, 0x68, 0x61, 0xf8, 0x64	/* Axenpmu_shared */
	.byte 0x0c, 0x41, 0x78, 0xe8, 0x5f, 0x63, 0x72, 0x30, 0x5f, 0x76, 0xe1, 0x75, 0x65	/* Axen_cr0_value */
	.byte 0x06, 0x41, 0x89, 0xf9, 0xe6, 0x73, 0x63	/* Aidt_desc */
	.byte 0x0c, 0x41, 0x73, 0x68, 0xc7, 0x6f, 0xaa, 0x74, 0x6c, 0xe0, 0xe6, 0x73, 0x63	/* Ashadow_tls_desc */
	.byte 0x0b, 0x41, 0x78, 0xe8, 0x5f, 0x1b, 0x7a, 0xc5, 0xb4, 0xd6, 0xf0, 0x67	/* Axen_lazy_nesting */
	.byte 0x09, 0x41, 0x78, 0xe8, 0x5f, 0x1b, 0x7a, 0xc5, 0xa5, 0xe6	/* Axen_lazy_mode */
	.byte 0x0c, 0x41, 0x78, 0xe8, 0x5f, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x63, 0x72, 0x33	/* Axen_current_cr3 */
	.byte 0x07, 0x41, 0x78, 0xe8, 0x5f, 0x63, 0x72, 0x33	/* Axen_cr3 */
	.byte 0x08, 0x41, 0x6d, 0xd5, 0xe6, 0xa2, 0xa6, 0x64, 0x0f	/* Amc_debug_data */
	.byte 0x07, 0x41, 0x6d, 0xd5, 0xa2, 0x66, 0x66, 0xee	/* Amc_buffer */
	.byte 0x0c, 0x41, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xa7, 0x93, 0x66, 0x1b, 0x67, 0x73	/* Axen_mc_irq_flags */
	.byte 0x09, 0x41, 0x78, 0xe8, 0x5f, 0xe6, 0xa2, 0xa6, 0xa7, 0x71	/* Axen_debug_irq */
	.byte 0x0e, 0x41, 0x78, 0xe8, 0x5f, 0x28, 0x6c, 0x2b, 0x63, 0x73, 0xf0, 0x67, 0xb3, 0xa7, 0x71	/* Axen_callfuncsingle_irq */
	.byte 0x0a, 0x41, 0x78, 0xe8, 0x5f, 0x28, 0x6c, 0x2b, 0xd5, 0xa7, 0x71	/* Axen_callfunc_irq */
	.byte 0x09, 0x41, 0x78, 0xe8, 0x5f, 0x3d, 0x7e, 0xe5, 0xa7, 0x71	/* Axen_resched_irq */
	.byte 0x08, 0x41, 0x78, 0xe8, 0xe7, 0x6d, 0x00, 0xa7, 0x71	/* Axen_pmu_irq */
	.byte 0x09, 0x41, 0x78, 0xe8, 0x5f, 0xa7, 0x93, 0x77, 0xce, 0x6b	/* Axen_irq_work */
	.byte 0x0b, 0x41, 0x78, 0xe8, 0x5f, 0x71, 0xc0, 0xd8, 0x13, 0x99, 0xb4, 0xd6	/* Axen_qlock_wait_nest */
	.byte 0x06, 0x41, 0xa7, 0x93, 0x6e, 0x61, 0xbd	/* Airq_name */
	.byte 0x09, 0x41, 0xc0, 0xd8, 0x6b, 0xa3, 0x6b, 0xcf, 0xa7, 0x71	/* Alock_kicker_irq */
	.byte 0x09, 0x41, 0x68, 0x76, 0xf6, 0xbc, 0x5f, 0x76, 0x20, 0x61	/* Ahv_sev_vmsa */
	.byte 0x07, 0x41, 0x6e, 0x6d, 0xcb, 0x64, 0x72, 0x37	/* Anmi_dr7 */
	.byte 0x07, 0x41, 0x6e, 0x6d, 0xcb, 0x63, 0x72, 0x32	/* Anmi_cr2 */
	.byte 0x06, 0x41, 0x6e, 0x6d, 0x69, 0x2a, 0x86	/* Anmi_state */
	.byte 0x09, 0x41, 0x6c, 0x96, 0xf9, 0x6e, 0x6d, 0xcb, 0x72, 0x0c	/* Alast_nmi_rip */
	.byte 0x08, 0x41, 0x73, 0x77, 0x08, 0xaa, 0x6e, 0x6d, 0x69	/* Aswallow_nmi */
	.byte 0x07, 0x41, 0x6e, 0x6d, 0x69, 0x2a, 0xe9, 0x73	/* Anmi_stats */
	.byte 0x08, 0x41, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xa7, 0x71	/* Avector_irq */
	.byte 0x06, 0x41, 0x62, 0x70, 0xe7, 0xcf, 0x9f	/* Abp_per_reg */
	.byte 0x07, 0x41, 0x92, 0x5f, 0xe6, 0xa2, 0x67, 0x9f	/* Acpu_debugreg */
	.byte 0x06, 0x41, 0x92, 0x5f, 0x64, 0x72, 0x37	/* Acpu_dr7 */
	.byte 0x06, 0x41, 0x73, 0x73, 0x62, 0x2a, 0x86	/* Assb_state */
	.byte 0x0d, 0x41, 0xff, 0x74, 0x73, 0xe0, 0x6c, 0x69, 0x6d, 0x99, 0xf0, 0x76, 0xe1, 0x89	/* A__tss_limit_invalid */
	.byte 0x11, 0x41, 0x20, 0x72, 0x5f, 0x6d, 0xab, 0xd5, 0x66, 0x65, 0xe9, 0x75, 0x3d, 0xf6, 0x68, 0xc7, 0x6f, 0x77	/* Amsr_misc_features_shadow */
	.byte 0x09, 0x41, 0xf0, 0x5f, 0x6b, 0xee, 0xb4, 0xc3, 0x66, 0xbe	/* Ain_kernel_fpu */
	.byte 0x06, 0x41, 0x78, 0x66, 0x64, 0x2a, 0x86	/* Axfd_state */
	.byte 0x0e, 0x41, 0x66, 0xbe, 0x5f, 0x66, 0x70, 0x9f, 0xe0, 0x6f, 0x77, 0x6e, 0xcf, 0x7b, 0x78	/* Afpu_fpregs_owner_ctx */
	.byte 0x10, 0x41, 0x78, 0x38, 0x36, 0xf6, 0x70, 0x65, 0xd5, 0x63, 0xea, 0xc3, 0x63, 0x1d, 0xf8, 0x6e, 0x74	/* Ax86_spec_ctrl_current */
	.byte 0x09, 0x41, 0xca, 0xd0, 0x5f, 0x87, 0x71, 0xf6, 0x28, 0x65	/* Aarch_freq_scale */
	.byte 0x09, 0x41, 0x73, 0x61, 0x76, 0x65, 0xe5, 0x65, 0x70, 0x62	/* Asaved_epb */
	.byte 0x07, 0x41, 0x6d, 0x63, 0xfa, 0xc2, 0x6d, 0xee	/* Amce_timer */
	.byte 0x0c, 0x41, 0x6d, 0x63, 0xfa, 0x6e, 0xd1, 0xf9, 0xf0, 0x74, 0xee, 0x76, 0xe1	/* Amce_next_interval */
	.byte 0x06, 0x41, 0x6d, 0x63, 0x3b, 0xba, 0xe8	/* Amces_seen */
	.byte 0x06, 0x41, 0xf0, 0x6a, 0x65, 0x7b, 0x6d	/* Ainjectm */
	.byte 0x0b, 0x41, 0x6d, 0x63, 0xfa, 0x70, 0x7f, 0xc3, 0x62, 0xcc, 0x6b, 0x73	/* Amce_poll_banks */
	.byte 0x0a, 0x41, 0x6d, 0x63, 0xfa, 0x70, 0x7f, 0xc3, 0xfe, 0xd4, 0x74	/* Amce_poll_count */
	.byte 0x0e, 0x41, 0x6d, 0x63, 0xfa, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x7c, 0xfe, 0xd4, 0x74	/* Amce_exception_count */
	.byte 0x06, 0x41, 0x6d, 0x63, 0xfa, 0x07, 0x65	/* Amce_device */
	.byte 0x0c, 0x41, 0x6d, 0x63, 0xfa, 0x62, 0xcc, 0x6b, 0xe0, 0x6f, 0x77, 0xb4, 0x64	/* Amce_banks_owned */
	.byte 0x0e, 0x41, 0x73, 0x6d, 0x63, 0x61, 0x5f, 0x6d, 0xab, 0xd5, 0x62, 0xcc, 0x6b, 0xe0, 0x0a	/* Asmca_misc_banks_map */
	.byte 0x05, 0x41, 0x62, 0xcc, 0xd8, 0x0a	/* Abank_map */
	.byte 0x0a, 0x41, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x62, 0xcc, 0x6b, 0x73	/* Athreshold_banks */
	.byte 0x07, 0x41, 0xd6, 0xce, 0xcd, 0xe6, 0x73, 0x63	/* Astorm_desc */
	.byte 0x06, 0x41, 0x70, 0x71, 0x72, 0x2a, 0x86	/* Apqr_state */
	.byte 0x08, 0x41, 0x74, 0x73, 0xd5, 0xc7, 0x6a, 0x75, 0xd6	/* Atsc_adjust */
	.byte 0x08, 0x41, 0x1b, 0x70, 0x69, 0xd5, 0xbc, 0x1e, 0x73	/* Alapic_events */
	.byte 0x0a, 0x41, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x63, 0xd3, 0xcc, 0xb9	/* Avector_cleanup */
	.byte 0x05, 0x41, 0x69, 0x85, 0xdd, 0x16	/* Aipi_mask */
	.byte 0x0a, 0x41, 0x6b, 0x9b, 0x62, 0xfa, 0x7b, 0x6c, 0x62, 0x6c, 0x6b	/* Akprobe_ctlblk */
	.byte 0x09, 0x41, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x6b, 0x9b, 0x17	/* Acurrent_kprobe */
	.byte 0x0b, 0x41, 0x92, 0x5f, 0x68, 0x70, 0x65, 0xf9, 0xd0, 0xcc, 0xb4, 0x6c	/* Acpu_hpet_channel */
	.byte 0x09, 0x41, 0xff, 0x70, 0x76, 0x5f, 0x92, 0x5f, 0xdd, 0x16	/* A__pv_cpu_mask */
	.byte 0x09, 0x41, 0x68, 0x76, 0x5f, 0x63, 0x3c, 0xe7, 0xcf, 0x92	/* Ahv_clock_per_cpu */
	.byte 0x08, 0x41, 0x6e, 0x6d, 0xcb, 0x5d, 0xcf, 0x9f, 0x73	/* Anmi_user_regs */
	.byte 0x10, 0x41, 0x63, 0x65, 0x61, 0x5f, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0x2a, 0xeb, 0x6b, 0x73	/* Acea_exception_stacks */
	.byte 0x07, 0x41, 0x6b, 0x6d, 0x6d, 0x3e, 0x7b, 0x78	/* Akmmio_ctx */
	.byte 0x04, 0x41, 0x92, 0x5f, 0x01	/* Acpu_trace */
	.byte 0x07, 0x41, 0xef, 0x5f, 0xf8, 0x96, 0x6f, 0x6e	/* Apf_reason */
	.byte 0x0d, 0x41, 0x78, 0x38, 0x36, 0x5f, 0x92, 0x5f, 0xac, 0x5f, 0xb6, 0x64, 0xfa, 0x0a	/* Ax86_cpu_to_node_map */
	.byte 0x0a, 0x41, 0x63, 0xeb, 0x68, 0x65, 0x64, 0x2a, 0xeb, 0x6b, 0x73	/* Acached_stacks */
	.byte 0x09, 0x41, 0x9b, 0x63, 0x3b, 0xe0, 0xfe, 0xd4, 0x74, 0x73	/* Aprocess_counts */
	.byte 0x14, 0x41, 0xff, 0x70, 0xee, 0x92, 0x5f, 0x72, 0x77, 0xc9, 0xcd, 0x72, 0xd5, 0x92, 0x5f, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0x3c	/* A__percpu_rwsem_rc_cpu_hotplug_lock */
	.byte 0x06, 0x41, 0x92, 0x68, 0x70, 0x2a, 0x86	/* Acpuhp_state */
	.byte 0x0a, 0x41, 0xdb, 0x16, 0xd3, 0xf9, 0x68, 0xcb, 0x76, 0x65, 0x63	/* Atasklet_hi_vec */
	.byte 0x08, 0x41, 0xdb, 0x16, 0xd3, 0xf9, 0x76, 0x65, 0x63	/* Atasklet_vec */
	.byte 0x09, 0x41, 0x6b, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71, 0x64	/* Aksoftirqd */
	.byte 0x0a, 0x41, 0x77, 0x93, 0x72, 0x72, 0x5f, 0x92, 0x5f, 0x1b, 0xd6	/* Awq_rr_cpu_last */
	.byte 0x0d, 0x41, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0x4e, 0x4d, 0x49, 0x5f, 0xf8, 0xb7, 0xbd	/* Airq_work_NMI_resume */
	.byte 0x07, 0x41, 0x89, 0xb3, 0x15, 0xf8, 0xc7, 0x73	/* Aidle_threads */
	.byte 0x07, 0x41, 0xbe, 0x73, 0x5b, 0x77, 0xce, 0x6b	/* Apush_work */
	.byte 0x08, 0x41, 0x6b, 0xee, 0xb4, 0xc3, 0x92, 0xd6, 0xe9	/* Akernel_cpustat */
	.byte 0x04, 0x41, 0x6b, 0xd6, 0xe9	/* Akstat */
	.byte 0x10, 0x41, 0x73, 0xad, 0x0b, 0xe5, 0x77, 0xfa, 0x62, 0xe1, 0xcc, 0x63, 0xfa, 0x74, 0xb0, 0xdd, 0x16	/* Ashould_we_balance_tmpmask */
	.byte 0x09, 0x41, 0xc9, 0xd3, 0x63, 0xf9, 0x72, 0x93, 0xdd, 0x16	/* Aselect_rq_mask */
	.byte 0x0a, 0x41, 0xdf, 0x05, 0x62, 0xe1, 0xcc, 0x63, 0xfa, 0xdd, 0x16	/* Aload_balance_mask */
	.byte 0x0b, 0x41, 0xc0, 0xe1, 0x5f, 0x92, 0x5f, 0xdd, 0x73, 0xd8, 0x64, 0x6c	/* Alocal_cpu_mask_dl */
	.byte 0x09, 0x41, 0x64, 0x6c, 0xe7, 0x0b, 0xc3, 0x68, 0x65, 0xc7	/* Adl_pull_head */
	.byte 0x09, 0x41, 0x64, 0x6c, 0xe7, 0x5d, 0x5b, 0x68, 0x65, 0xc7	/* Adl_push_head */
	.byte 0x08, 0x41, 0xc0, 0xe1, 0x5f, 0x92, 0x5f, 0xdd, 0x16	/* Alocal_cpu_mask */
	.byte 0x09, 0x41, 0x72, 0xf9, 0xbe, 0x6c, 0xc3, 0x68, 0x65, 0xc7	/* Art_pull_head */
	.byte 0x09, 0x41, 0x72, 0xf9, 0xbe, 0x73, 0x5b, 0x68, 0x65, 0xc7	/* Art_push_head */
	.byte 0x07, 0x41, 0x92, 0x5f, 0xa7, 0x71, 0xc2, 0xbd	/* Acpu_irqtime */
	.byte 0x09, 0x41, 0xc1, 0xd6, 0x65, 0xcd, 0x0d, 0xb9, 0xe7, 0x92	/* Asystem_group_pcpu */
	.byte 0x07, 0x41, 0xb7, 0x67, 0x6f, 0x76, 0x5f, 0x92	/* Asugov_cpu */
	.byte 0x0b, 0x41, 0xde, 0x6f, 0xf9, 0x92, 0xeb, 0x63, 0xf9, 0x92, 0x5d, 0x03	/* Aroot_cpuacct_cpuusage */
	.byte 0x0c, 0x41, 0x92, 0x87, 0x93, 0xb9, 0x64, 0xa1, 0x75, 0xc2, 0xc3, 0x64, 0x0f	/* Acpufreq_update_util_data */
	.byte 0x0d, 0x41, 0x73, 0xe5, 0x61, 0xc1, 0xcd, 0x92, 0x63, 0x61, 0x70, 0xeb, 0xe4, 0x79	/* Asd_asym_cpucapacity */
	.byte 0x0a, 0x41, 0x73, 0xe5, 0x61, 0xa4, 0xe7, 0xeb, 0x6b, 0xf0, 0x67	/* Asd_asym_packing */
	.byte 0x06, 0x41, 0x73, 0xe5, 0x6e, 0x75, 0xdd	/* Asd_numa */
	.byte 0x0b, 0x41, 0x73, 0xe5, 0x6c, 0x6c, 0x63, 0xf6, 0x68, 0x61, 0xf8, 0x64	/* Asd_llc_shared */
	.byte 0x08, 0x41, 0x73, 0x64, 0xf6, 0x68, 0xca, 0xfa, 0x89	/* Asd_share_id */
	.byte 0x07, 0x41, 0x73, 0xe5, 0x6c, 0x6c, 0xd5, 0x89	/* Asd_llc_id */
	.byte 0x0a, 0x41, 0x73, 0xe5, 0x6c, 0x6c, 0x63, 0xf6, 0x69, 0x7a, 0x65	/* Asd_llc_size */
	.byte 0x06, 0x41, 0x73, 0xe5, 0x6c, 0x6c, 0x63	/* Asd_llc */
	.byte 0x0c, 0x41, 0x13, 0x6b, 0xfa, 0x3a, 0x6b, 0xdf, 0x67, 0xe5, 0x77, 0xce, 0x6b	/* Awake_up_klogd_work */
	.byte 0x0b, 0x41, 0x70, 0x72, 0xf0, 0x74, 0x6b, 0xe7, 0xe8, 0x64, 0xf0, 0x67	/* Aprintk_pending */
	.byte 0x0c, 0x41, 0x70, 0x72, 0xf0, 0x74, 0xd8, 0xfe, 0xd4, 0xf9, 0x6e, 0x6d, 0x69	/* Aprintk_count_nmi */
	.byte 0x09, 0x41, 0x70, 0x72, 0xf0, 0x74, 0xd8, 0xfe, 0xd4, 0x74	/* Aprintk_count */
	.byte 0x0f, 0x41, 0x98, 0x73, 0x6f, 0xb3, 0x73, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x00, 0x64, 0x0f	/* Aconsole_srcu_srcu_data */
	.byte 0x09, 0x41, 0x70, 0x72, 0xf0, 0x74, 0xd8, 0x98, 0x74, 0x97	/* Aprintk_context */
	.byte 0x12, 0x41, 0x6e, 0x62, 0x98, 0xe7, 0x92, 0x5f, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0xc5, 0xb4, 0xd6, 0xf0, 0x67	/* Anbcon_pcpu_emergency_nesting */
	.byte 0x07, 0x41, 0xff, 0x74, 0x6d, 0xe2, 0xdd, 0x16	/* A__tmp_mask */
	.byte 0x0c, 0x41, 0x72, 0x63, 0x00, 0xdb, 0x16, 0xe0, 0x01, 0xff, 0x70, 0xee, 0x92	/* Arcu_tasks_trace__percpu */
	.byte 0x08, 0x41, 0xea, 0xd5, 0x69, 0x85, 0xac, 0x5f, 0x92	/* Atrc_ipi_to_cpu */
	.byte 0x0e, 0x41, 0x72, 0x63, 0x00, 0xdb, 0x16, 0xe0, 0x72, 0x75, 0xe6, 0xff, 0x70, 0xee, 0x92	/* Arcu_tasks_rude__percpu */
	.byte 0x0b, 0x41, 0x72, 0x63, 0x00, 0xdb, 0x16, 0x73, 0xff, 0x70, 0xee, 0x92	/* Arcu_tasks__percpu */
	.byte 0x04, 0x41, 0x6b, 0x72, 0x63	/* Akrc */
	.byte 0x08, 0x41, 0xc2, 0x6d, 0xcf, 0x62, 0x61, 0xc9, 0x73	/* Atimer_bases */
	.byte 0x0a, 0x41, 0x68, 0x72, 0xc2, 0x6d, 0xcf, 0x62, 0x61, 0xc9, 0x73	/* Ahrtimer_bases */
	.byte 0x09, 0x41, 0xc2, 0x63, 0x6b, 0xe7, 0xee, 0x92, 0x5f, 0xd2	/* Atick_percpu_dev */
	.byte 0x08, 0x41, 0xc2, 0x63, 0xd8, 0x92, 0x5f, 0x07, 0x65	/* Atick_cpu_device */
	.byte 0x0e, 0x41, 0xc2, 0x63, 0xd8, 0x6f, 0xb4, 0x73, 0xad, 0xf9, 0x13, 0x0e, 0x3a, 0x07, 0x65	/* Atick_oneshot_wakeup_device */
	.byte 0x0e, 0x41, 0xb6, 0x68, 0x7a, 0x5f, 0x66, 0x0b, 0xc3, 0x6b, 0xa3, 0xd8, 0x77, 0xce, 0x6b	/* Anohz_full_kick_work */
	.byte 0x08, 0x41, 0xc2, 0x63, 0xd8, 0x92, 0xf6, 0x7e, 0x64	/* Atick_cpu_sched */
	.byte 0x07, 0x41, 0x74, 0x6d, 0x2c, 0x72, 0x5f, 0x92	/* Atmigr_cpu */
	.byte 0x09, 0x41, 0xea, 0x2c, 0x67, 0xcf, 0x62, 0xeb, 0x6b, 0x01	/* Atrigger_backtrace */
	.byte 0x10, 0x41, 0x63, 0x67, 0x72, 0xe2, 0x64, 0x66, 0xc3, 0xde, 0x6f, 0xf9, 0x72, 0x73, 0xdb, 0xf9, 0x92	/* Acgrp_dfl_root_rstat_cpu */
	.byte 0x18, 0x41, 0xff, 0x70, 0xee, 0x92, 0x5f, 0x72, 0x77, 0xc9, 0xcd, 0x72, 0xd5, 0x63, 0x0d, 0x3a, 0x15, 0xf8, 0xc7, 0x0d, 0x3a, 0x72, 0x77, 0xc9, 0x6d	/* A__percpu_rwsem_rc_cgroup_threadgroup_rwsem */
	.byte 0x0b, 0x41, 0x63, 0x0d, 0x3a, 0x72, 0x73, 0xdb, 0xf9, 0x92, 0x5f, 0x3c	/* Acgroup_rstat_cpu_lock */
	.byte 0x07, 0x41, 0x92, 0xf6, 0xac, 0x70, 0x70, 0xee	/* Acpu_stopper */
	.byte 0x0b, 0x41, 0x6b, 0x9b, 0x62, 0xfa, 0xf0, 0x73, 0xdb, 0x6e, 0x63, 0x65	/* Akprobe_instance */
	.byte 0x0d, 0x41, 0x73, 0x6f, 0x66, 0x74, 0x3c, 0xb9, 0xf6, 0xac, 0xe2, 0x77, 0xce, 0x6b	/* Asoftlockup_stop_work */
	.byte 0x0c, 0x41, 0x73, 0x6f, 0x66, 0x74, 0x3c, 0x3a, 0x09, 0xd3, 0x74, 0xd9, 0x6e	/* Asoftlockup_completion */
	.byte 0x0d, 0x41, 0x73, 0x6f, 0x66, 0x74, 0x3c, 0x3a, 0xac, 0x75, 0xd0, 0x95, 0x6e, 0x63	/* Asoftlockup_touch_sync */
	.byte 0x0b, 0x41, 0x77, 0xe9, 0xd0, 0xa9, 0xa6, 0x68, 0x72, 0xc2, 0x6d, 0xee	/* Awatchdog_hrtimer */
	.byte 0x0c, 0x41, 0x77, 0xe9, 0xd0, 0xa9, 0xa6, 0xf8, 0x70, 0xce, 0xf9, 0x74, 0x73	/* Awatchdog_report_ts */
	.byte 0x0c, 0x41, 0x77, 0xe9, 0xd0, 0xa9, 0xa6, 0xac, 0x75, 0xd0, 0x5f, 0x74, 0x73	/* Awatchdog_touch_ts */
	.byte 0x0f, 0x41, 0x77, 0xe9, 0xd0, 0xa9, 0xa6, 0x68, 0xca, 0x64, 0x3c, 0x3a, 0xac, 0x75, 0x7e, 0x64	/* Awatchdog_hardlockup_touched */
	.byte 0x0f, 0x41, 0x77, 0xe9, 0xd0, 0xa9, 0xa6, 0x68, 0xca, 0x64, 0x3c, 0x3a, 0x77, 0xca, 0xb4, 0x64	/* Awatchdog_hardlockup_warned */
	.byte 0x12, 0x41, 0x68, 0x72, 0xc2, 0x6d, 0xcf, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74, 0x73, 0xf6, 0x61, 0x76, 0x65, 0x64	/* Ahrtimer_interrupts_saved */
	.byte 0x0d, 0x41, 0x68, 0x72, 0xc2, 0x6d, 0xcf, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74, 0x73	/* Ahrtimer_interrupts */
	.byte 0x08, 0x41, 0x6e, 0x6d, 0xcb, 0xf8, 0xca, 0xbd, 0x64	/* Anmi_rearmed */
	.byte 0x09, 0x41, 0x6c, 0x96, 0xf9, 0xc2, 0xbd, 0x73, 0xdb, 0xb0	/* Alast_timestamp */
	.byte 0x05, 0x41, 0xe6, 0x05, 0xbc, 0x1e	/* Adead_event */
	.byte 0x07, 0x41, 0x77, 0xe9, 0xd0, 0xa9, 0xa6, 0xbc	/* Awatchdog_ev */
	.byte 0x08, 0x41, 0x6c, 0x7d, 0xe8, 0xcf, 0xca, 0xb5, 0x79	/* Alistener_array */
	.byte 0x0b, 0x41, 0xdb, 0x16, 0xd6, 0xe9, 0x73, 0xba, 0x71, 0x6e, 0x75, 0x6d	/* Ataskstats_seqnum */
	.byte 0x10, 0x41, 0x01, 0x70, 0x6f, 0xf0, 0xf9, 0x73, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x00, 0x64, 0x0f	/* Atracepoint_srcu_srcu_data */
	.byte 0x09, 0x41, 0x66, 0xc8, 0x9b, 0xb8, 0xb3, 0xd6, 0xe9, 0x73	/* Aftrace_profile_stats */
	.byte 0x09, 0x41, 0x5d, 0xee, 0x2a, 0xeb, 0xd8, 0xfe, 0xd4, 0x74	/* Auser_stack_count */
	.byte 0x0a, 0x41, 0x66, 0xc8, 0xd6, 0xeb, 0xd8, 0x3d, 0xee, 0x76, 0x65	/* Aftrace_stack_reserve */
	.byte 0x07, 0x41, 0x66, 0xc8, 0xd6, 0xeb, 0x6b, 0x73	/* Aftrace_stacks */
	.byte 0x08, 0x41, 0x92, 0x5f, 0xeb, 0x63, 0x3b, 0xe0, 0x3c	/* Acpu_access_lock */
	.byte 0x0c, 0x41, 0xc8, 0xa2, 0x66, 0x66, 0x65, 0xf8, 0xe5, 0xaf, 0x63, 0x6e, 0x74	/* Atrace_buffered_event_cnt */
	.byte 0x0a, 0x41, 0xc8, 0xa2, 0x66, 0x66, 0x65, 0xf8, 0xe5, 0xbc, 0x1e	/* Atrace_buffered_event */
	.byte 0x0b, 0x41, 0xc8, 0xdb, 0x16, 0xf0, 0x66, 0x6f, 0xf6, 0x61, 0x76, 0x65	/* Atrace_taskinfo_save */
	.byte 0x0a, 0x41, 0x64, 0xab, 0x80, 0xb3, 0xd6, 0xeb, 0xd8, 0xd7, 0xee	/* Adisable_stack_tracer */
	.byte 0x08, 0x41, 0x89, 0xb3, 0xf8, 0xf9, 0xd6, 0xeb, 0x6b	/* Aidle_ret_stack */
	.byte 0x0c, 0x41, 0x40, 0x1c, 0x74, 0xe2, 0xb4, 0x73, 0xf9, 0xd3, 0x76, 0x65, 0x6c	/* Abpf_raw_tp_nest_level */
	.byte 0x07, 0x41, 0x40, 0x1c, 0x74, 0xe2, 0x9f, 0x73	/* Abpf_raw_tp_regs */
	.byte 0x0c, 0x41, 0x73, 0xe8, 0x64, 0xf6, 0x2c, 0x6e, 0xe1, 0x5f, 0x77, 0xce, 0x6b	/* Asend_signal_work */
	.byte 0x08, 0x41, 0x40, 0x6d, 0xab, 0x63, 0xf6, 0x64, 0x73	/* Abpf_misc_sds */
	.byte 0x06, 0x41, 0x91, 0xe7, 0xf9, 0x9f, 0x73	/* Abpf_pt_regs */
	.byte 0x0e, 0x41, 0x40, 0xaf, 0x6f, 0x5e, 0xbe, 0xf9, 0xb4, 0x73, 0xf9, 0xd3, 0x76, 0x65, 0x6c	/* Abpf_event_output_nest_level */
	.byte 0x0a, 0x41, 0x40, 0xc8, 0xb4, 0x73, 0xf9, 0xd3, 0x76, 0x65, 0x6c	/* Abpf_trace_nest_level */
	.byte 0x06, 0x41, 0x40, 0xc8, 0x73, 0x64, 0x73	/* Abpf_trace_sds */
	.byte 0x06, 0x41, 0x1b, 0x7a, 0xc5, 0x6c, 0x7d	/* Alazy_list */
	.byte 0x07, 0x41, 0xb5, 0x69, 0xc9, 0xe5, 0x6c, 0x7d	/* Araised_list */
	.byte 0x09, 0x41, 0x40, 0x5d, 0xcf, 0x72, 0x6e, 0x64, 0x2a, 0x86	/* Abpf_user_rnd_state */
	.byte 0x08, 0x41, 0x91, 0x25, 0xa6, 0xeb, 0xc2, 0x76, 0x65	/* Abpf_prog_active */
	.byte 0x0b, 0x41, 0x68, 0x72, 0xc2, 0x6d, 0xcf, 0x72, 0xd4, 0x6e, 0xf0, 0x67	/* Ahrtimer_running */
	.byte 0x0f, 0x41, 0x40, 0x62, 0x70, 0x72, 0xf0, 0x74, 0xa0, 0xb4, 0x73, 0xf9, 0xd3, 0x76, 0x65, 0x6c	/* Abpf_bprintf_nest_level */
	.byte 0x0b, 0x41, 0x40, 0x62, 0x70, 0x72, 0xf0, 0x74, 0xa0, 0xa2, 0x66, 0x73	/* Abpf_bprintf_bufs */
	.byte 0x0a, 0x41, 0xa7, 0x71, 0x73, 0x61, 0x22, 0x66, 0x1b, 0x67, 0x73	/* Airqsave_flags */
	.byte 0x09, 0x41, 0x6d, 0x84, 0xd4, 0xc0, 0xd8, 0x77, 0xce, 0x6b	/* Ammap_unlock_work */
	.byte 0x0a, 0x41, 0x40, 0xdb, 0x16, 0x2a, 0xce, 0x61, 0x21, 0xa2, 0xc1	/* Abpf_task_storage_busy */
	.byte 0x0c, 0x41, 0x40, 0x63, 0x67, 0x72, 0x70, 0x2a, 0xce, 0x61, 0x21, 0xa2, 0xc1	/* Abpf_cgrp_storage_busy */
	.byte 0x0a, 0x41, 0xb6, 0xe2, 0x74, 0x78, 0x7c, 0x66, 0x1b, 0x67, 0x73	/* Anop_txn_flags */
	.byte 0x08, 0x41, 0x73, 0x77, 0xaf, 0x68, 0xdb, 0x62, 0xd3	/* Aswevent_htable */
	.byte 0x0c, 0x41, 0x70, 0xee, 0xa0, 0x15, 0xde, 0x74, 0x74, 0xd3, 0x64, 0xba, 0x71	/* Aperf_throttled_seq */
	.byte 0x0d, 0x41, 0x70, 0xee, 0xa0, 0x15, 0xde, 0x74, 0x74, 0xd3, 0xe5, 0xfe, 0xd4, 0x74	/* Aperf_throttled_count */
	.byte 0x0c, 0x41, 0x70, 0xee, 0x66, 0xf6, 0x7e, 0xe5, 0x63, 0xdc, 0x5d, 0x03, 0x73	/* Aperf_sched_cb_usages */
	.byte 0x08, 0x41, 0x73, 0x7e, 0xe5, 0x63, 0xdc, 0x6c, 0x7d	/* Asched_cb_list */
	.byte 0x0e, 0x41, 0x72, 0xd4, 0x6e, 0xf0, 0x67, 0xf6, 0x61, 0xb0, 0xb3, 0x6c, 0xe8, 0x67, 0x15	/* Arunning_sample_length */
	.byte 0x09, 0x41, 0x70, 0x6d, 0x75, 0xf6, 0xdc, 0xbc, 0x1e, 0x73	/* Apmu_sb_events */
	.byte 0x09, 0x41, 0x70, 0xee, 0xa0, 0x92, 0x5f, 0x98, 0x74, 0x97	/* Aperf_cpu_context */
	.byte 0x07, 0x41, 0xff, 0x70, 0xee, 0xa0, 0x9f, 0x73	/* A__perf_regs */
	.byte 0x0d, 0x41, 0x28, 0x6c, 0xd0, 0x61, 0xf0, 0x5f, 0xf8, 0x63, 0x1d, 0x73, 0xd9, 0x6e	/* Acallchain_recursion */
	.byte 0x14, 0x41, 0xff, 0x70, 0xee, 0x92, 0x5f, 0x72, 0x77, 0xc9, 0xcd, 0x72, 0xd5, 0x62, 0xe2, 0x92, 0xf0, 0x66, 0x6f, 0xba, 0x6d	/* A__percpu_rwsem_rc_bp_cpuinfo_sem */
	.byte 0x07, 0x41, 0x62, 0xe2, 0x92, 0xf0, 0x66, 0x6f	/* Abp_cpuinfo */
	.byte 0x12, 0x41, 0xff, 0x70, 0xee, 0x92, 0x5f, 0x72, 0x77, 0xc9, 0xcd, 0x72, 0xd5, 0x64, 0x3a, 0x6d, 0x0a, 0xba, 0x6d	/* A__percpu_rwsem_rc_dup_mmap_sem */
	.byte 0x0f, 0x41, 0xb9, 0xde, 0x62, 0x3b, 0xf6, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x00, 0x64, 0x0f	/* Auprobes_srcu_srcu_data */
	.byte 0x0b, 0x41, 0xf8, 0x74, 0x1d, 0x7c, 0xb6, 0xc2, 0xb8, 0xcf, 0x6c, 0x7d	/* Areturn_notifier_list */
	.byte 0x09, 0x41, 0x98, 0x74, 0xd1, 0xf9, 0xd7, 0x6b, 0xf0, 0x67	/* Acontext_tracking */
	.byte 0x0b, 0x41, 0x62, 0x64, 0xe2, 0x72, 0x86, 0x6c, 0x69, 0x6d, 0xe4, 0x73	/* Abdp_ratelimits */
	.byte 0x0e, 0x41, 0x64, 0xa7, 0x74, 0xc5, 0x15, 0xde, 0x74, 0x74, 0xb3, 0xd3, 0x61, 0x6b, 0x73	/* Adirty_throttle_leaks */
	.byte 0x0d, 0x41, 0x6c, 0x72, 0x00, 0xc7, 0xe5, 0x64, 0xb5, 0xf0, 0x5f, 0x77, 0xce, 0x6b	/* Alru_add_drain_work */
	.byte 0x08, 0x41, 0x92, 0x5f, 0x66, 0x62, 0xe9, 0x7e, 0x73	/* Acpu_fbatches */
	.byte 0x08, 0x41, 0x76, 0x20, 0xdb, 0xf9, 0x77, 0xce, 0x6b	/* Avmstat_work */
	.byte 0x07, 0x41, 0x76, 0xcd, 0xaf, 0xd6, 0x86, 0x73	/* Avm_event_states */
	.byte 0x0a, 0x41, 0x62, 0x6f, 0x6f, 0xf9, 0xb6, 0xe6, 0xd6, 0xe9, 0x73	/* Aboot_nodestats */
	.byte 0x08, 0x41, 0x6d, 0xc0, 0xd8, 0x66, 0x62, 0xe9, 0xd0	/* Amlock_fbatch */
	.byte 0x09, 0x41, 0x76, 0x84, 0x62, 0xc0, 0xd8, 0x04, 0x75, 0x65	/* Avmap_block_queue */
	.byte 0x0b, 0x41, 0x6e, 0xfa, 0xb8, 0xf9, 0x70, 0xf8, 0xdf, 0x05, 0xb6, 0xe6	/* Ane_fit_preload_node */
	.byte 0x09, 0x41, 0x76, 0x87, 0xfa, 0xe6, 0x66, 0xee, 0xf8, 0x64	/* Avfree_deferred */
	.byte 0x0b, 0x41, 0x62, 0x6f, 0x6f, 0xf9, 0x7a, 0x6f, 0xb4, 0xd6, 0xe9, 0x73	/* Aboot_zonestats */
	.byte 0x09, 0x41, 0x62, 0x6f, 0x6f, 0xf9, 0x70, 0x03, 0xc9, 0x74	/* Aboot_pageset */
	.byte 0x07, 0x41, 0x6e, 0x75, 0xdd, 0x5f, 0xb6, 0xe6	/* Anuma_node */
	.byte 0x14, 0x41, 0xff, 0x70, 0xee, 0x92, 0x5f, 0x72, 0x77, 0xc9, 0xcd, 0x72, 0xd5, 0xbd, 0xcd, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0x3c	/* A__percpu_rwsem_rc_mem_hotplug_lock */
	.byte 0x09, 0x41, 0x73, 0x6c, 0x75, 0xdc, 0x66, 0x6c, 0x5d, 0x68	/* Aslub_flush */
	.byte 0x08, 0x41, 0x73, 0x77, 0x70, 0xf6, 0xdf, 0x74, 0x73	/* Aswp_slots */
	.byte 0x0b, 0x41, 0x73, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x00, 0x64, 0x0f	/* Asrcu_srcu_data */
	.byte 0x07, 0x41, 0x6d, 0x15, 0x70, 0x2a, 0xe9, 0x73	/* Amthp_stats */
	.byte 0x09, 0x41, 0xbd, 0x6d, 0x63, 0x67, 0xf6, 0xac, 0x63, 0x6b	/* Amemcg_stock */
	.byte 0x0a, 0x41, 0xf0, 0xf9, 0xeb, 0xc2, 0x22, 0xbd, 0x6d, 0x63, 0x67	/* Aint_active_memcg */
	.byte 0x0c, 0x41, 0xbd, 0x6d, 0xce, 0xc5, 0x66, 0x61, 0x69, 0x6c, 0x1d, 0xfa, 0x92	/* Amemory_failure_cpu */
	.byte 0x07, 0x41, 0x7a, 0xe0, 0x84, 0x61, 0xf8, 0x61	/* Azs_map_area */
	.byte 0x0e, 0x41, 0x6e, 0x72, 0x5f, 0x64, 0xe8, 0xea, 0xc5, 0xb4, 0x67, 0xe9, 0x69, 0x76, 0x65	/* Anr_dentry_negative */
	.byte 0x0c, 0x41, 0x6e, 0x72, 0x5f, 0x64, 0xe8, 0xea, 0xc5, 0xd4, 0x75, 0xc9, 0x64	/* Anr_dentry_unused */
	.byte 0x08, 0x41, 0x6e, 0x72, 0x5f, 0x64, 0xe8, 0xea, 0x79	/* Anr_dentry */
	.byte 0x06, 0x41, 0x6c, 0x96, 0xf9, 0xf0, 0x6f	/* Alast_ino */
	.byte 0x08, 0x41, 0x6e, 0x72, 0x5f, 0xd4, 0x75, 0xc9, 0x64	/* Anr_unused */
	.byte 0x08, 0x41, 0x6e, 0x72, 0x5f, 0xf0, 0x6f, 0xe6, 0x73	/* Anr_inodes */
	.byte 0x09, 0x41, 0x62, 0x5b, 0xeb, 0xfe, 0xd4, 0x74, 0xf0, 0x67	/* Abh_accounting */
	.byte 0x06, 0x41, 0x62, 0x5b, 0x6c, 0x72, 0x5d	/* Abh_lrus */
	.byte 0x12, 0x41, 0xff, 0x70, 0xee, 0x92, 0x5f, 0x72, 0x77, 0xc9, 0xcd, 0x72, 0xd5, 0xb8, 0xb3, 0x72, 0x77, 0xc9, 0x6d	/* A__percpu_rwsem_rc_file_rwsem */
	.byte 0x07, 0x41, 0xb8, 0xb3, 0xc0, 0xd8, 0x6c, 0x7d	/* Afile_lock_list */
	.byte 0x0f, 0x41, 0x64, 0x8e, 0x6f, 0xf9, 0x73, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x00, 0x64, 0x0f	/* Adquot_srcu_srcu_data */
	.byte 0x12, 0x41, 0x76, 0x6d, 0xfe, 0x72, 0xfa, 0x63, 0x62, 0xf6, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x00, 0x64, 0x0f	/* Avmcore_cb_srcu_srcu_data */
	.byte 0x0a, 0x41, 0x64, 0xab, 0x63, 0xca, 0x64, 0xe7, 0x61, 0xba, 0x71	/* Adiscard_pa_seq */
	.byte 0x0f, 0x41, 0xbc, 0x1e, 0x66, 0x73, 0xf6, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x00, 0x64, 0x0f	/* Aeventfs_srcu_srcu_data */
	.byte 0x08, 0x41, 0x73, 0x09, 0xf6, 0x63, 0x72, 0xe9, 0xd0	/* Ascomp_scratch */
	.byte 0x09, 0x41, 0x62, 0x6c, 0xd8, 0x92, 0x5f, 0x63, 0x73, 0x64	/* Ablk_cpu_csd */
	.byte 0x08, 0x41, 0x62, 0x6c, 0xd8, 0x92, 0x5f, 0xa9, 0xb4	/* Ablk_cpu_done */
	.byte 0x0a, 0x41, 0x62, 0x6c, 0xd8, 0x92, 0x5f, 0xd9, 0x70, 0x7f, 0x6c	/* Ablk_cpu_iopoll */
	.byte 0x10, 0x41, 0x67, 0x70, 0x3e, 0x07, 0x3b, 0xf6, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x00, 0x64, 0x0f	/* Agpio_devices_srcu_srcu_data */
	.byte 0x05, 0x41, 0x92, 0x5f, 0xea, 0x2c	/* Acpu_trig */
	.byte 0x0c, 0x41, 0x9b, 0x63, 0x3b, 0x73, 0xce, 0x5f, 0x07, 0xfa, 0xca, 0xb5, 0x79	/* Aprocessor_device_array */
	.byte 0x07, 0x41, 0x9b, 0x63, 0x3b, 0x73, 0xce, 0x73	/* Aprocessors */
	.byte 0x12, 0x41, 0x92, 0x87, 0x93, 0x15, 0xee, 0x6d, 0xe1, 0x5f, 0xf8, 0x64, 0x75, 0x7b, 0xd9, 0x6e, 0xf6, 0x9a, 0x70	/* Acpufreq_thermal_reduction_step */
	.byte 0x05, 0x41, 0x23, 0x63, 0xd6, 0x86	/* Aacpi_cstate */
	.byte 0x07, 0x41, 0x23, 0x92, 0x89, 0xb3, 0x07, 0x65	/* Aacpi_cpuidle_device */
	.byte 0x09, 0x41, 0x63, 0x70, 0xd5, 0xe6, 0x73, 0x63, 0xe7, 0xea	/* Acpc_desc_ptr */
	.byte 0x0e, 0x41, 0x92, 0xe7, 0x63, 0x63, 0xf6, 0x75, 0x62, 0x73, 0x70, 0xeb, 0xfa, 0x89, 0x78	/* Acpu_pcc_subspace_idx */
	.byte 0x09, 0x41, 0x7f, 0xe5, 0x72, 0xd4, 0xd6, 0xa1, 0xc2, 0xbd	/* Aold_runstate_time */
	.byte 0x08, 0x41, 0x78, 0xe8, 0x5f, 0x72, 0xd4, 0xd6, 0x86	/* Axen_runstate */
	.byte 0x06, 0x41, 0x6c, 0x86, 0x65, 0x6f, 0x69	/* Alateeoi */
	.byte 0x07, 0x41, 0xa7, 0x93, 0x65, 0x70, 0x6f, 0xd0	/* Airq_epoch */
	.byte 0x09, 0x41, 0x69, 0x85, 0xac, 0x5f, 0xbc, 0x74, 0xd0, 0x6e	/* Aipi_to_evtchn */
	.byte 0x07, 0x41, 0x69, 0x85, 0xac, 0x5f, 0xa7, 0x71	/* Aipi_to_irq */
	.byte 0x08, 0x41, 0x76, 0xa7, 0x93, 0xac, 0x5f, 0xa7, 0x71	/* Avirq_to_irq */
	.byte 0x0a, 0x41, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x62, 0x99, 0x89, 0x78	/* Acurrent_bit_idx */
	.byte 0x0b, 0x41, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x77, 0xce, 0xe5, 0x89, 0x78	/* Acurrent_word_idx */
	.byte 0x09, 0x41, 0x92, 0x5f, 0xbc, 0x74, 0xd0, 0x7c, 0xdd, 0x16	/* Acpu_evtchn_mask */
	.byte 0x06, 0x41, 0x92, 0x5f, 0x04, 0x75, 0x65	/* Acpu_queue */
	.byte 0x09, 0x41, 0x92, 0x5f, 0x98, 0xea, 0x6f, 0xc3, 0x62, 0x3c	/* Acpu_control_block */
	.byte 0x0a, 0x41, 0xa7, 0x93, 0x72, 0xcc, 0xa9, 0x6d, 0xb4, 0x73, 0x73	/* Airq_randomness */
	.byte 0x0c, 0x41, 0x62, 0xe9, 0x7e, 0xe5, 0xe8, 0xea, 0x81, 0xc5, 0x75, 0x36, 0x34	/* Abatched_entropy_u64 */
	.byte 0x0c, 0x41, 0x62, 0xe9, 0x7e, 0xe5, 0xe8, 0xea, 0x81, 0xc5, 0x75, 0x33, 0x32	/* Abatched_entropy_u32 */
	.byte 0x0c, 0x41, 0x62, 0xe9, 0x7e, 0xe5, 0xe8, 0xea, 0x81, 0xc5, 0x75, 0x31, 0x36	/* Abatched_entropy_u16 */
	.byte 0x0b, 0x41, 0x62, 0xe9, 0x7e, 0xe5, 0xe8, 0xea, 0x81, 0xc5, 0x75, 0x38	/* Abatched_entropy_u8 */
	.byte 0x06, 0x41, 0x63, 0x72, 0x6e, 0x67, 0x73	/* Acrngs */
	.byte 0x06, 0x41, 0xc0, 0xe1, 0x5f, 0xbc, 0x1e	/* Alocal_event */
	.byte 0x10, 0x41, 0x07, 0xfa, 0x88, 0x6b, 0x73, 0xf6, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x00, 0x64, 0x0f	/* Adevice_links_srcu_srcu_data */
	.byte 0x06, 0x41, 0x92, 0x95, 0xe0, 0x07, 0x3b	/* Acpu_sys_devices */
	.byte 0x05, 0x41, 0x92, 0x5f, 0x07, 0x3b	/* Acpu_devices */
	.byte 0x07, 0x41, 0x63, 0xcb, 0xf0, 0xe6, 0x1a, 0xd2	/* Aci_index_dev */
	.byte 0x08, 0x41, 0x63, 0xcb, 0x63, 0xeb, 0x68, 0xfa, 0xd2	/* Aci_cache_dev */
	.byte 0x0c, 0x41, 0x63, 0xcb, 0x92, 0x5f, 0x63, 0xeb, 0x68, 0x65, 0xf0, 0x66, 0x6f	/* Aci_cpu_cacheinfo */
	.byte 0x0e, 0x41, 0x13, 0x0e, 0xb9, 0xf6, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x00, 0x64, 0x0f	/* Awakeup_srcu_srcu_data */
	.byte 0x07, 0x41, 0x66, 0x6c, 0x5d, 0x5b, 0x89, 0x78	/* Aflush_idx */
	.byte 0x0e, 0x41, 0x64, 0x61, 0x78, 0xf6, 0x72, 0x63, 0x75, 0xf6, 0x72, 0x63, 0x00, 0x64, 0x0f	/* Adax_srcu_srcu_data */
	.byte 0x07, 0x41, 0x15, 0xee, 0x6d, 0xe1, 0x2a, 0x86	/* Athermal_state */
	.byte 0x1a, 0x41, 0x92, 0x87, 0x93, 0xea, 0xcc, 0x73, 0xe4, 0xd9, 0x7c, 0xb6, 0xc2, 0xb8, 0xcf, 0x6c, 0xab, 0xf9, 0x68, 0x65, 0xc7, 0xf6, 0x72, 0x63, 0x00, 0x64, 0x0f	/* Acpufreq_transition_notifier_list_head_srcu_data */
	.byte 0x08, 0x41, 0x92, 0x87, 0x93, 0x92, 0x5f, 0x64, 0x0f	/* Acpufreq_cpu_data */
	.byte 0x08, 0x41, 0x92, 0x87, 0x71, 0xe7, 0x3d, 0xb7, 0xf8	/* Acpufreq_pressure */
	.byte 0x06, 0x41, 0x92, 0x5f, 0x64, 0x62, 0x73	/* Acpu_dbs */
	.byte 0x05, 0x41, 0x92, 0x89, 0xb3, 0xd2	/* Acpuidle_dev */
	.byte 0x06, 0x41, 0x92, 0x89, 0xb3, 0x07, 0x3b	/* Acpuidle_devices */
	.byte 0x06, 0x41, 0x6c, 0x10, 0xcf, 0x07, 0x3b	/* Aladder_devices */
	.byte 0x06, 0x41, 0x6d, 0xe8, 0x00, 0x07, 0x3b	/* Amenu_devices */
	.byte 0x09, 0x41, 0xd6, 0x69, 0x6d, 0xee, 0x30, 0x5f, 0xbc, 0x74	/* Astimer0_evt */
	.byte 0x0a, 0x41, 0x89, 0xb3, 0xf0, 0x6a, 0x65, 0x63, 0xf9, 0x07, 0x65	/* Aidle_inject_device */
	.byte 0x0b, 0x41, 0x89, 0xb3, 0xf0, 0x6a, 0x65, 0x63, 0xf9, 0x15, 0xf8, 0xc7	/* Aidle_inject_thread */
	.byte 0x0a, 0x41, 0x6e, 0x61, 0x85, 0x08, 0xd5, 0x63, 0xeb, 0x68, 0x65	/* Anapi_alloc_cache */
	.byte 0x0a, 0x41, 0xb4, 0x74, 0x19, 0x08, 0xd5, 0x63, 0xeb, 0x68, 0x65	/* Anetdev_alloc_cache */
	.byte 0x09, 0x41, 0xff, 0xb4, 0xf9, 0xfe, 0x6f, 0x6b, 0x69, 0x65	/* A__net_cookie */
	.byte 0x09, 0x41, 0x66, 0x6c, 0x5d, 0x5b, 0x77, 0xce, 0x6b, 0x73	/* Aflush_works */
	.byte 0x0a, 0x41, 0x62, 0xeb, 0x6b, 0xdf, 0xa6, 0x6e, 0x61, 0x70, 0x69	/* Abacklog_napi */
	.byte 0x0b, 0x41, 0xc1, 0xd6, 0x65, 0x6d, 0xe7, 0x61, 0x21, 0x70, 0x6f, 0x7f	/* Asystem_page_pool */
	.byte 0x04, 0x41, 0x91, 0xf6, 0x70	/* Abpf_sp */
	.byte 0x0b, 0x41, 0xff, 0x73, 0x6f, 0x63, 0xd8, 0xfe, 0x6f, 0x6b, 0x69, 0x65	/* A__sock_cookie */
	.byte 0x0f, 0x41, 0x70, 0x70, 0x95, 0xd6, 0x65, 0xcd, 0xf8, 0x63, 0x79, 0x63, 0xb3, 0xd6, 0xe9, 0x73	/* App_system_recycle_stats */
	.byte 0x09, 0x41, 0x64, 0xcd, 0x68, 0xaa, 0x92, 0x5f, 0x64, 0x0f	/* Adm_hw_cpu_data */
	.byte 0x07, 0x41, 0x64, 0xcd, 0x92, 0x5f, 0x64, 0x0f	/* Adm_cpu_data */
	.byte 0x0c, 0x41, 0x73, 0xd0, 0x5f, 0x66, 0xb5, 0xa6, 0x64, 0x0f, 0x2a, 0xce, 0x03	/* Asch_frag_data_storage */
	.byte 0x0c, 0x41, 0x6e, 0x66, 0xf6, 0x6b, 0xdc, 0x64, 0xb9, 0x6c, 0xa3, 0x86, 0x64	/* Anf_skb_duplicated */
	.byte 0x09, 0x41, 0x72, 0xf9, 0x63, 0xeb, 0x68, 0xfa, 0xd6, 0xe9	/* Art_cache_stat */
	.byte 0x0f, 0x41, 0x2d, 0xe2, 0xbd, 0x6d, 0xce, 0x79, 0xe7, 0xcf, 0x92, 0x5f, 0x66, 0xaa, 0xe1, 0xc0	/* Atcp_memory_per_cpu_fw_alloc */
	.byte 0x07, 0x41, 0x2d, 0xe2, 0x74, 0xaa, 0xab, 0x6e	/* Atcp_tw_isn */
	.byte 0x0b, 0x41, 0x2d, 0xe2, 0xce, 0x70, 0x68, 0xcc, 0x5f, 0xfe, 0xd4, 0x74	/* Atcp_orphan_count */
	.byte 0x08, 0x41, 0x74, 0x73, 0x93, 0xdb, 0x16, 0xd3, 0x74	/* Atsq_tasklet */
	.byte 0x08, 0x41, 0x0c, 0x76, 0x5c, 0x2d, 0x70, 0xf6, 0x6b	/* Aipv4_tcp_sk */
	.byte 0x10, 0x41, 0x75, 0x64, 0xe2, 0xbd, 0x6d, 0xce, 0x79, 0xe7, 0xcf, 0x92, 0x5f, 0x66, 0xaa, 0xe1, 0xc0	/* Audp_memory_per_cpu_fw_alloc */
	.byte 0x08, 0x41, 0x0c, 0x76, 0x5c, 0xa3, 0xb0, 0xf6, 0x6b	/* Aipv4_icmp_sk */
	.byte 0x0b, 0x41, 0x73, 0x2c, 0x70, 0x6f, 0x7f, 0xf6, 0x63, 0x72, 0xe9, 0xd0	/* Asigpool_scratch */
	.byte 0x0c, 0x41, 0x78, 0x66, 0x72, 0xcd, 0xea, 0xcc, 0xe0, 0xdb, 0x16, 0xd3, 0x74	/* Axfrm_trans_tasklet */
	.byte 0x0f, 0x41, 0x6e, 0x61, 0xf9, 0x0e, 0x65, 0x70, 0xe1, 0x69, 0x22, 0x73, 0xd8, 0x0c, 0x76, 0x36	/* Anat_keepalive_sk_ipv6 */
	.byte 0x0f, 0x41, 0x6e, 0x61, 0xf9, 0x0e, 0x65, 0x70, 0xe1, 0x69, 0x22, 0x73, 0xd8, 0x0c, 0x76, 0x34	/* Anat_keepalive_sk_ipv4 */
	.byte 0x09, 0x41, 0x0c, 0x76, 0x36, 0x5f, 0xa3, 0xb0, 0xf6, 0x6b	/* Aipv6_icmp_sk */
	.byte 0x0c, 0x41, 0xc9, 0x67, 0x36, 0x5f, 0x91, 0xf6, 0x72, 0x68, 0x2a, 0x86, 0x73	/* Aseg6_bpf_srh_states */
	.byte 0x08, 0x41, 0x68, 0x6d, 0xeb, 0x5f, 0x72, 0xf0, 0x67	/* Ahmac_ring */
	.byte 0x0e, 0x41, 0xb0, 0x2d, 0xe2, 0xe6, 0xd3, 0x67, 0x86, 0xe5, 0xeb, 0x74, 0xd9, 0x6e, 0x73	/* Amptcp_delegated_actions */
	.byte 0x0f, 0x41, 0x64, 0xab, 0xea, 0x69, 0xa2, 0x74, 0xfa, 0x92, 0x5f, 0xdd, 0x16, 0xe7, 0xf8, 0x76	/* Adistribute_cpu_mask_prev */
	.byte 0x06, 0x41, 0xff, 0xa7, 0x93, 0x9f, 0x73	/* A__irq_regs */
	.byte 0x0d, 0x41, 0x72, 0xc7, 0x69, 0x1a, 0x74, 0xf8, 0xfa, 0x70, 0xf8, 0xdf, 0xc7, 0x73	/* Aradix_tree_preloads */
	.byte 0x0a, 0x41, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x5f, 0xf0, 0x66, 0x6f	/* Axen_vcpu_info */
	.byte 0x05, 0x41, 0xa7, 0x71, 0x2a, 0xe9	/* Airq_stat */
	.byte 0x07, 0x41, 0x63, 0x79, 0x63, 0x32, 0x6e, 0x73	/* Acyc2ns */
	.byte 0x09, 0x41, 0x98, 0x73, 0xf9, 0x70, 0x92, 0x5f, 0xad, 0x74	/* Aconst_pcpu_hot */
	.byte 0x06, 0x41, 0x70, 0x92, 0x5f, 0xad, 0x74	/* Apcpu_hot */
	.byte 0x07, 0x41, 0x92, 0xf6, 0x61, 0xb0, 0xd3, 0x73	/* Acpu_samples */
	.byte 0x08, 0x41, 0x6d, 0x13, 0x99, 0x92, 0x5f, 0xe6, 0xc7	/* Amwait_cpu_dead */
	.byte 0x08, 0x41, 0x92, 0x5f, 0x74, 0x6c, 0x62, 0xd6, 0x86	/* Acpu_tlbstate */
	.byte 0x0b, 0x41, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0xf0, 0x66, 0x6f	/* Aflush_tlb_info */
	.byte 0x0d, 0x41, 0x92, 0x5f, 0x74, 0x6c, 0x62, 0xd6, 0xa1, 0x73, 0x68, 0x61, 0xf8, 0x64	/* Acpu_tlbstate_shared */
	.byte 0x0b, 0x41, 0x92, 0x5f, 0x77, 0xce, 0x6b, 0xee, 0xe7, 0x6f, 0x7f, 0x73	/* Acpu_worker_pools */
	.byte 0x0b, 0x41, 0x62, 0x5b, 0x77, 0xce, 0x6b, 0xee, 0xe7, 0x6f, 0x7f, 0x73	/* Abh_worker_pools */
	.byte 0x0d, 0x41, 0x62, 0x68, 0xe7, 0x6f, 0x6f, 0xc3, 0xa7, 0x93, 0x77, 0xce, 0x6b, 0x73	/* Abh_pool_irq_works */
	.byte 0x06, 0x41, 0x72, 0xd4, 0x04, 0x75, 0x3b	/* Arunqueues */
	.byte 0x09, 0x41, 0x73, 0x7e, 0xe5, 0x63, 0xc0, 0xd8, 0x64, 0x0f	/* Asched_clock_data */
	.byte 0x06, 0x41, 0x6f, 0x73, 0x93, 0xb6, 0xe6	/* Aosq_node */
	.byte 0x05, 0x41, 0x71, 0xb6, 0xe6, 0x73	/* Aqnodes */
	.byte 0x06, 0x41, 0x72, 0x63, 0x00, 0x64, 0x0f	/* Arcu_data */
	.byte 0x06, 0x41, 0x63, 0x73, 0xe5, 0x64, 0x0f	/* Acsd_data */
	.byte 0x0a, 0x41, 0x28, 0x6c, 0xf6, 0xf0, 0x67, 0xb3, 0x04, 0x75, 0x65	/* Acall_single_queue */
	.byte 0x06, 0x41, 0x63, 0x66, 0xe5, 0x64, 0x0f	/* Acfd_data */
	.byte 0x09, 0x41, 0x73, 0x6f, 0x66, 0x74, 0xb4, 0xf9, 0x64, 0x0f	/* Asoftnet_data */
	.byte 0x0b, 0x41, 0x72, 0xf9, 0xd4, 0x63, 0xeb, 0x68, 0x65, 0xe5, 0x6c, 0x7d	/* Art_uncached_list */
	.byte 0x0d, 0x41, 0x72, 0x74, 0x36, 0x5f, 0xd4, 0x63, 0xeb, 0x68, 0x65, 0xe5, 0x6c, 0x7d	/* Art6_uncached_list */
	.byte 0x0a, 0x41, 0x76, 0x6d, 0x77, 0xf6, 0x9a, 0xe1, 0x5f, 0xc2, 0xbd	/* Avmw_steal_time */
	.byte 0x0b, 0x41, 0x6b, 0x76, 0xcd, 0x61, 0x70, 0x69, 0xd5, 0x65, 0x6f, 0x69	/* Akvm_apic_eoi */
	.byte 0x07, 0x41, 0xd6, 0x65, 0xe1, 0x5f, 0xc2, 0xbd	/* Asteal_time */
	.byte 0x08, 0x41, 0x61, 0xef, 0x5f, 0xf8, 0x96, 0x6f, 0x6e	/* Aapf_reason */
	.byte 0x08, 0x41, 0xff, 0x70, 0xcf, 0x92, 0x5f, 0xe8, 0x64	/* A__per_cpu_end */
	.byte 0x03, 0x54, 0x2a, 0x97	/* T_stext */
	.byte 0x04, 0x54, 0x5f, 0x74, 0x97	/* T_text */
	.byte 0x0b, 0xa8, 0xf6, 0xbc, 0x5f, 0x65, 0xe0, 0x74, 0xee, 0x6d, 0xf0, 0x86	/* t__pfx_sev_es_terminate */
	.byte 0x0b, 0x74, 0xc9, 0x76, 0x5f, 0x65, 0xe0, 0x74, 0xee, 0x6d, 0xf0, 0x86	/* tsev_es_terminate */
	.byte 0x06, 0xa8, 0xf6, 0x6e, 0xe2, 0x92, 0x89	/* t__pfx_snp_cpuid */
	.byte 0x06, 0x74, 0x73, 0x6e, 0xe2, 0x92, 0x89	/* tsnp_cpuid */
	.byte 0x0b, 0xc6, 0x65, 0xca, 0x6c, 0x79, 0x1f, 0x70, 0x03, 0x73, 0x2a, 0x86	/* t__pfx_early_set_pages_state */
	.byte 0x0a, 0x9a, 0xca, 0x6c, 0x79, 0x1f, 0x70, 0x03, 0x73, 0x2a, 0x86	/* tearly_set_pages_state */
	.byte 0x0b, 0xbf, 0xa9, 0x5f, 0x76, 0xd5, 0xb6, 0x5f, 0x67, 0x68, 0x63, 0x62	/* T__pfx_do_vc_no_ghcb */
	.byte 0x0b, 0x54, 0xa9, 0x5f, 0x76, 0xd5, 0xb6, 0x5f, 0x67, 0x68, 0x63, 0x62	/* Tdo_vc_no_ghcb */
	.byte 0x12, 0xbf, 0x65, 0xca, 0x6c, 0x79, 0xf6, 0x6e, 0x70, 0x1f, 0xbd, 0x6d, 0xce, 0x79, 0xe7, 0x72, 0x69, 0x76, 0x86	/* T__pfx_early_snp_set_memory_private */
	.byte 0x12, 0x54, 0x65, 0xca, 0x6c, 0x79, 0xf6, 0x6e, 0x70, 0x1f, 0xbd, 0x6d, 0xce, 0x79, 0xe7, 0x72, 0x69, 0x76, 0x86	/* Tearly_snp_set_memory_private */
	.byte 0x07, 0x3f, 0xf6, 0x6e, 0xe2, 0x80, 0xce, 0x74	/* T__pfx_snp_abort */
	.byte 0x07, 0x54, 0x73, 0x6e, 0xe2, 0x80, 0xce, 0x74	/* Tsnp_abort */
	.byte 0x05, 0x3f, 0xf6, 0x6e, 0xe2, 0x8d	/* T__pfx_snp_init */
	.byte 0x05, 0x54, 0x73, 0x6e, 0xe2, 0x8d	/* Tsnp_init */
	.byte 0x09, 0x06, 0x76, 0x68, 0xf6, 0xdb, 0x72, 0xf9, 0x78, 0xe8	/* tpvh_start_xen */
	.byte 0x08, 0x54, 0x73, 0xdb, 0x72, 0x74, 0x3a, 0x36, 0x34	/* Tstartup_64 */
	.byte 0x0c, 0xa8, 0xf6, 0xdb, 0x72, 0x74, 0x3a, 0x36, 0x5c, 0xdf, 0x05, 0x89, 0x74	/* t__pfx_startup_64_load_idt */
	.byte 0x0c, 0x74, 0x73, 0xdb, 0x72, 0x74, 0x3a, 0x36, 0x5c, 0xdf, 0x05, 0x89, 0x74	/* tstartup_64_load_idt */
	.byte 0x09, 0x3f, 0xff, 0xf6, 0xdb, 0x72, 0x74, 0x3a, 0x36, 0x34	/* T__pfx___startup_64 */
	.byte 0x08, 0x2f, 0x73, 0xdb, 0x72, 0x74, 0x3a, 0x36, 0x34	/* T__startup_64 */
	.byte 0x10, 0x3f, 0xf6, 0xdb, 0x72, 0x74, 0x3a, 0x36, 0x34, 0xba, 0x74, 0x3a, 0x67, 0x64, 0xf9, 0x89, 0x74	/* T__pfx_startup_64_setup_gdt_idt */
	.byte 0x10, 0x54, 0x73, 0xdb, 0x72, 0x74, 0x3a, 0x36, 0x34, 0xba, 0x74, 0x3a, 0x67, 0x64, 0xf9, 0x89, 0x74	/* Tstartup_64_setup_gdt_idt */
	.byte 0x0b, 0xa8, 0xf6, 0x6d, 0xfa, 0x70, 0x67, 0xdb, 0x62, 0xb3, 0x28, 0x63	/* t__pfx_sme_pgtable_calc */
	.byte 0x0b, 0x74, 0x73, 0x6d, 0xfa, 0x70, 0x67, 0xdb, 0x62, 0xb3, 0x28, 0x63	/* tsme_pgtable_calc */
	.byte 0x0a, 0xa8, 0xf6, 0x6d, 0xfa, 0x63, 0xd3, 0xca, 0xe7, 0x67, 0x64	/* t__pfx_sme_clear_pgd */
	.byte 0x0a, 0x74, 0x73, 0x6d, 0xfa, 0x63, 0xd3, 0xca, 0xe7, 0x67, 0x64	/* tsme_clear_pgd */
	.byte 0x0c, 0xa8, 0xf6, 0x6d, 0xfa, 0x70, 0xf8, 0x70, 0xca, 0xfa, 0x70, 0x67, 0x64	/* t__pfx_sme_prepare_pgd */
	.byte 0x0c, 0x74, 0x73, 0x6d, 0xfa, 0x70, 0xf8, 0x70, 0xca, 0xfa, 0x70, 0x67, 0x64	/* tsme_prepare_pgd */
	.byte 0x0a, 0x29, 0xf6, 0x6d, 0xfa, 0x84, 0x72, 0xcc, 0x21, 0x70, 0x9a	/* t__pfx___sme_map_range_pte */
	.byte 0x0b, 0x74, 0xff, 0x73, 0x6d, 0xfa, 0x84, 0x72, 0xcc, 0x21, 0x70, 0x9a	/* t__sme_map_range_pte */
	.byte 0x08, 0x29, 0xf6, 0x6d, 0xfa, 0x84, 0x72, 0xcc, 0xda	/* t__pfx___sme_map_range */
	.byte 0x09, 0x74, 0xff, 0x73, 0x6d, 0xfa, 0x84, 0x72, 0xcc, 0xda	/* t__sme_map_range */
	.byte 0x0d, 0x3f, 0xf6, 0x6d, 0xfa, 0xe8, 0x63, 0x72, 0x27, 0xf9, 0x6b, 0xee, 0xb4, 0x6c	/* T__pfx_sme_encrypt_kernel */
	.byte 0x0d, 0x54, 0x73, 0x6d, 0xfa, 0xe8, 0x63, 0x72, 0x27, 0xf9, 0x6b, 0xee, 0xb4, 0x6c	/* Tsme_encrypt_kernel */
	.byte 0x07, 0x3f, 0xf6, 0x6d, 0xfa, 0xe8, 0x80, 0xd3	/* T__pfx_sme_enable */
	.byte 0x07, 0x54, 0x73, 0x6d, 0xfa, 0xe8, 0x80, 0xd3	/* Tsme_enable */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x8d, 0x28, 0xc3, 0xd3, 0x76, 0x65, 0x6c	/* T__pfx___traceiter_initcall_level */
	.byte 0x0b, 0x2f, 0x01, 0xe4, 0xcf, 0x8d, 0x28, 0xc3, 0xd3, 0x76, 0x65, 0x6c	/* T__traceiter_initcall_level */
	.byte 0x0e, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x8d, 0x28, 0xc3, 0xd3, 0x76, 0x65, 0x6c	/* T__pfx___probestub_initcall_level */
	.byte 0x0d, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x8d, 0x28, 0xc3, 0xd3, 0x76, 0x65, 0x6c	/* T__probestub_initcall_level */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x8d, 0x28, 0x6c, 0xf6, 0xdb, 0x72, 0x74	/* T__pfx___traceiter_initcall_start */
	.byte 0x0b, 0x2f, 0x01, 0xe4, 0xcf, 0x8d, 0x28, 0x6c, 0xf6, 0xdb, 0x72, 0x74	/* T__traceiter_initcall_start */
	.byte 0x0e, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x8d, 0x28, 0x6c, 0xf6, 0xdb, 0x72, 0x74	/* T__pfx___probestub_initcall_start */
	.byte 0x0d, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x8d, 0x28, 0x6c, 0xf6, 0xdb, 0x72, 0x74	/* T__probestub_initcall_start */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* T__pfx___traceiter_initcall_finish */
	.byte 0x0b, 0x2f, 0x01, 0xe4, 0xcf, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* T__traceiter_initcall_finish */
	.byte 0x0e, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* T__pfx___probestub_initcall_finish */
	.byte 0x0d, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* T__probestub_initcall_finish */
	.byte 0x0b, 0xc6, 0xc8, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x5b, 0x63, 0x62	/* t__pfx_trace_initcall_finish_cb */
	.byte 0x0b, 0x74, 0xc8, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x5b, 0x63, 0x62	/* ttrace_initcall_finish_cb */
	.byte 0x0c, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* t__pfx_perf_trace_initcall_finish */
	.byte 0x0b, 0x06, 0xee, 0xa0, 0xc8, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* tperf_trace_initcall_finish */
	.byte 0x0c, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x8d, 0x28, 0x6c, 0xf6, 0xdb, 0x72, 0x74	/* t__pfx_perf_trace_initcall_start */
	.byte 0x0b, 0x06, 0xee, 0xa0, 0xc8, 0x8d, 0x28, 0x6c, 0xf6, 0xdb, 0x72, 0x74	/* tperf_trace_initcall_start */
	.byte 0x0c, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x8d, 0x28, 0xc3, 0xd3, 0x76, 0x65, 0x6c	/* t__pfx_perf_trace_initcall_level */
	.byte 0x0b, 0x06, 0xee, 0xa0, 0xc8, 0x8d, 0x28, 0xc3, 0xd3, 0x76, 0x65, 0x6c	/* tperf_trace_initcall_level */
	.byte 0x0c, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* t__pfx_trace_event_raw_event_initcall_finish */
	.byte 0x0c, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* ttrace_event_raw_event_initcall_finish */
	.byte 0x0c, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x8d, 0x28, 0x6c, 0xf6, 0xdb, 0x72, 0x74	/* t__pfx_trace_event_raw_event_initcall_start */
	.byte 0x0c, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x8d, 0x28, 0x6c, 0xf6, 0xdb, 0x72, 0x74	/* ttrace_event_raw_event_initcall_start */
	.byte 0x0e, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* t__pfx_trace_raw_output_initcall_finish */
	.byte 0x0e, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* ttrace_raw_output_initcall_finish */
	.byte 0x0e, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x8d, 0x28, 0x6c, 0xf6, 0xdb, 0x72, 0x74	/* t__pfx_trace_raw_output_initcall_start */
	.byte 0x0e, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x8d, 0x28, 0x6c, 0xf6, 0xdb, 0x72, 0x74	/* ttrace_raw_output_initcall_start */
	.byte 0x0e, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x8d, 0x28, 0xc3, 0xd3, 0x76, 0x65, 0x6c	/* t__pfx_trace_raw_output_initcall_level */
	.byte 0x0e, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x8d, 0x28, 0xc3, 0xd3, 0x76, 0x65, 0x6c	/* ttrace_raw_output_initcall_level */
	.byte 0x0b, 0x29, 0x5f, 0x40, 0xc8, 0x8d, 0x28, 0x6c, 0xf6, 0xdb, 0x72, 0x74	/* t__pfx___bpf_trace_initcall_start */
	.byte 0x0b, 0x74, 0xff, 0x40, 0xc8, 0x8d, 0x28, 0x6c, 0xf6, 0xdb, 0x72, 0x74	/* t__bpf_trace_initcall_start */
	.byte 0x0b, 0x29, 0x5f, 0x40, 0xc8, 0x8d, 0x28, 0xc3, 0xd3, 0x76, 0x65, 0x6c	/* t__pfx___bpf_trace_initcall_level */
	.byte 0x0b, 0x74, 0xff, 0x40, 0xc8, 0x8d, 0x28, 0xc3, 0xd3, 0x76, 0x65, 0x6c	/* t__bpf_trace_initcall_level */
	.byte 0x0b, 0x29, 0x5f, 0x40, 0xc8, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* t__pfx___bpf_trace_initcall_finish */
	.byte 0x0b, 0x74, 0xff, 0x40, 0xc8, 0x8d, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* t__bpf_trace_initcall_finish */
	.byte 0x0c, 0xc6, 0x8d, 0x28, 0xc3, 0x62, 0x6c, 0xeb, 0x6b, 0x6c, 0x7d, 0x65, 0x64	/* t__pfx_initcall_blacklisted */
	.byte 0x0c, 0x74, 0x8d, 0x28, 0xc3, 0x62, 0x6c, 0xeb, 0x6b, 0x6c, 0x7d, 0x65, 0x64	/* tinitcall_blacklisted */
	.byte 0x0c, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x8d, 0x28, 0xc3, 0xd3, 0x76, 0x65, 0x6c	/* t__pfx_trace_event_raw_event_initcall_level */
	.byte 0x0c, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x8d, 0x28, 0xc3, 0xd3, 0x76, 0x65, 0x6c	/* ttrace_event_raw_event_initcall_level */
	.byte 0x09, 0xbf, 0xa9, 0x5f, 0x6f, 0x6e, 0xfa, 0x8d, 0x28, 0x6c	/* T__pfx_do_one_initcall */
	.byte 0x09, 0x54, 0xa9, 0x5f, 0x6f, 0x6e, 0xfa, 0x8d, 0x28, 0x6c	/* Tdo_one_initcall */
	.byte 0x0d, 0xc6, 0xde, 0x6f, 0x74, 0x66, 0xe0, 0xf0, 0x99, 0x66, 0xe0, 0x98, 0x74, 0x97	/* t__pfx_rootfs_init_fs_context */
	.byte 0x0d, 0xea, 0x6f, 0x6f, 0x74, 0x66, 0xe0, 0xf0, 0x99, 0x66, 0xe0, 0x98, 0x74, 0x97	/* trootfs_init_fs_context */
	.byte 0x0d, 0xbf, 0x13, 0x99, 0x66, 0xce, 0x5f, 0xf0, 0x69, 0xea, 0x61, 0x6d, 0x66, 0x73	/* T__pfx_wait_for_initramfs */
	.byte 0x0d, 0x54, 0x13, 0x99, 0x66, 0xce, 0x5f, 0xf0, 0x69, 0xea, 0x61, 0x6d, 0x66, 0x73	/* Twait_for_initramfs */
	.byte 0x0e, 0x57, 0xe3, 0x28, 0x69, 0x62, 0x72, 0xe9, 0xd9, 0x7c, 0xe6, 0x1b, 0xc5, 0xa9, 0xb4	/* W__pfx_calibration_delay_done */
	.byte 0x0d, 0x57, 0x28, 0x69, 0x62, 0x72, 0xe9, 0xd9, 0x7c, 0xe6, 0x1b, 0xc5, 0xa9, 0xb4	/* Wcalibration_delay_done */
	.byte 0x09, 0xbf, 0x28, 0x69, 0x62, 0x72, 0xa1, 0xe6, 0x1b, 0x79	/* T__pfx_calibrate_delay */
	.byte 0x09, 0x54, 0x28, 0x69, 0x62, 0x72, 0xa1, 0xe6, 0x1b, 0x79	/* Tcalibrate_delay */
	.byte 0x07, 0xbf, 0x63, 0xd5, 0x6d, 0x6b, 0xe6, 0x63	/* T__pfx_cc_mkdec */
	.byte 0x07, 0x54, 0x63, 0xd5, 0x6d, 0x6b, 0xe6, 0x63	/* Tcc_mkdec */
	.byte 0x07, 0xbf, 0x63, 0xd5, 0x6d, 0x6b, 0xe8, 0x63	/* T__pfx_cc_mkenc */
	.byte 0x07, 0x54, 0x63, 0xd5, 0x6d, 0x6b, 0xe8, 0x63	/* Tcc_mkenc */
	.byte 0x0c, 0xbf, 0x63, 0x63, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x63, 0xd3, 0xca	/* T__pfx_cc_platform_clear */
	.byte 0x0c, 0x54, 0x63, 0x63, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x63, 0xd3, 0xca	/* Tcc_platform_clear */
	.byte 0x0b, 0xbf, 0x63, 0x63, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0x6d, 0xba, 0x74	/* T__pfx_cc_platform_set */
	.byte 0x0b, 0x54, 0x63, 0x63, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0x6d, 0xba, 0x74	/* Tcc_platform_set */
	.byte 0x10, 0xc6, 0x76, 0xee, 0x69, 0x66, 0xc5, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x7c, 0xf0, 0x66, 0x6f	/* t__pfx_verify_exception_info */
	.byte 0x10, 0x74, 0x76, 0xee, 0x69, 0x66, 0xc5, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x7c, 0xf0, 0x66, 0x6f	/* tverify_exception_info */
	.byte 0x0f, 0xa8, 0xf6, 0xbc, 0x5f, 0x65, 0xe0, 0x67, 0x68, 0x63, 0xdc, 0x68, 0x76, 0x5f, 0x28, 0x6c	/* t__pfx_sev_es_ghcb_hv_call */
	.byte 0x0f, 0x74, 0xc9, 0x76, 0x5f, 0x65, 0xe0, 0x67, 0x68, 0x63, 0xdc, 0x68, 0x76, 0x5f, 0x28, 0x6c	/* tsev_es_ghcb_hv_call */
	.byte 0x12, 0xa8, 0xf6, 0x76, 0x73, 0x6d, 0xe7, 0xee, 0x66, 0xce, 0xcd, 0x67, 0x68, 0x63, 0x62, 0x25, 0xac, 0xfe, 0x6c	/* t__pfx_svsm_perform_ghcb_protocol */
	.byte 0x12, 0x74, 0x73, 0x76, 0x73, 0x6d, 0xe7, 0xee, 0x66, 0xce, 0xcd, 0x67, 0x68, 0x63, 0x62, 0x25, 0xac, 0xfe, 0x6c	/* tsvsm_perform_ghcb_protocol */
	.byte 0x0a, 0xc6, 0x76, 0xd5, 0xf0, 0x99, 0x65, 0xcd, 0x7b, 0x78, 0x74	/* t__pfx_vc_init_em_ctxt */
	.byte 0x0a, 0x74, 0x76, 0xd5, 0xf0, 0x99, 0x65, 0xcd, 0x7b, 0x78, 0x74	/* tvc_init_em_ctxt */
	.byte 0x09, 0xc6, 0x76, 0xd5, 0xf0, 0x73, 0x7c, 0xb2, 0x72, 0x6d	/* t__pfx_vc_insn_get_rm */
	.byte 0x09, 0x74, 0x76, 0xd5, 0xf0, 0x73, 0x7c, 0xb2, 0x72, 0x6d	/* tvc_insn_get_rm */
	.byte 0x0d, 0xc6, 0x76, 0xd5, 0xf0, 0x73, 0x6e, 0xf6, 0xea, 0xf0, 0xa6, 0x7e, 0x63, 0x6b	/* t__pfx_vc_insn_string_check */
	.byte 0x0d, 0x74, 0x76, 0xd5, 0xf0, 0x73, 0x6e, 0xf6, 0xea, 0xf0, 0xa6, 0x7e, 0x63, 0x6b	/* tvc_insn_string_check */
	.byte 0x0a, 0x29, 0xe7, 0x76, 0xe1, 0x5f, 0x74, 0xee, 0x6d, 0xf0, 0x86	/* t__pfx___pval_terminate */
	.byte 0x0b, 0x74, 0xff, 0x70, 0x76, 0xe1, 0x5f, 0x74, 0xee, 0x6d, 0xf0, 0x86	/* t__pval_terminate */
	.byte 0x07, 0xc6, 0x76, 0xd5, 0xf8, 0x05, 0xbd, 0x6d	/* t__pfx_vc_read_mem */
	.byte 0x07, 0x74, 0x76, 0xd5, 0xf8, 0x05, 0xbd, 0x6d	/* tvc_read_mem */
	.byte 0x07, 0xc6, 0x76, 0xd5, 0x24, 0xfa, 0xbd, 0x6d	/* t__pfx_vc_write_mem */
	.byte 0x07, 0x74, 0x76, 0xd5, 0x24, 0xfa, 0xbd, 0x6d	/* tvc_write_mem */
	.byte 0x06, 0xc6, 0x76, 0xb0, 0x6c, 0xf6, 0x26	/* t__pfx_vmpl_show */
	.byte 0x06, 0x74, 0x76, 0xb0, 0x6c, 0xf6, 0x26	/* tvmpl_show */
	.byte 0x15, 0xa8, 0xf6, 0x76, 0x73, 0x6d, 0xe7, 0x76, 0xe1, 0x5f, 0x74, 0xee, 0x6d, 0xf0, 0x86, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_svsm_pval_terminate.constprop.0 */
	.byte 0x15, 0x74, 0x73, 0x76, 0x73, 0x6d, 0xe7, 0x76, 0xe1, 0x5f, 0x74, 0xee, 0x6d, 0xf0, 0x86, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tsvsm_pval_terminate.constprop.0 */
	.byte 0x0e, 0x3f, 0xf6, 0x6e, 0xe2, 0xab, 0xb7, 0xfa, 0x67, 0x75, 0x3b, 0xf9, 0xf8, 0x04, 0xd6	/* T__pfx_snp_issue_guest_request */
	.byte 0x0e, 0x54, 0x73, 0x6e, 0xe2, 0xab, 0xb7, 0xfa, 0x67, 0x75, 0x3b, 0xf9, 0xf8, 0x04, 0xd6	/* Tsnp_issue_guest_request */
	.byte 0x0a, 0xa8, 0xf6, 0xbc, 0x5f, 0x3b, 0xe7, 0x1b, 0xc5, 0xe6, 0xc7	/* t__pfx_sev_es_play_dead */
	.byte 0x0a, 0x74, 0xc9, 0x76, 0x5f, 0x3b, 0xe7, 0x1b, 0xc5, 0xe6, 0xc7	/* tsev_es_play_dead */
	.byte 0x09, 0x29, 0xf6, 0xbc, 0x5f, 0x92, 0x69, 0xe5, 0x68, 0x76	/* t__pfx___sev_cpuid_hv */
	.byte 0x0a, 0x74, 0xff, 0xc9, 0x76, 0x5f, 0x92, 0x69, 0xe5, 0x68, 0x76	/* t__sev_cpuid_hv */
	.byte 0x0c, 0x29, 0xf6, 0xbc, 0x5f, 0x92, 0x69, 0xe5, 0x68, 0x76, 0x5f, 0x20, 0x72	/* t__pfx___sev_cpuid_hv_msr */
	.byte 0x0d, 0x74, 0xff, 0xc9, 0x76, 0x5f, 0x92, 0x69, 0xe5, 0x68, 0x76, 0x5f, 0x20, 0x72	/* t__sev_cpuid_hv_msr */
	.byte 0x09, 0xa8, 0xf6, 0x6e, 0xe2, 0x92, 0x69, 0xe5, 0x68, 0x76	/* t__pfx_snp_cpuid_hv */
	.byte 0x09, 0x74, 0x73, 0x6e, 0xe2, 0x92, 0x69, 0xe5, 0x68, 0x76	/* tsnp_cpuid_hv */
	.byte 0x0e, 0xa8, 0xf6, 0x6e, 0xe2, 0x18, 0xcf, 0x67, 0x68, 0x63, 0xdc, 0x65, 0xca, 0x6c, 0x79	/* t__pfx_snp_register_ghcb_early */
	.byte 0x0e, 0x74, 0x73, 0x6e, 0xe2, 0x18, 0xcf, 0x67, 0x68, 0x63, 0xdc, 0x65, 0xca, 0x6c, 0x79	/* tsnp_register_ghcb_early */
	.byte 0x10, 0xa8, 0xf6, 0x76, 0x73, 0x6d, 0xe7, 0xee, 0x66, 0xce, 0xcd, 0x28, 0x6c, 0x25, 0xac, 0xfe, 0x6c	/* t__pfx_svsm_perform_call_protocol */
	.byte 0x10, 0x74, 0x73, 0x76, 0x73, 0x6d, 0xe7, 0xee, 0x66, 0xce, 0xcd, 0x28, 0x6c, 0x25, 0xac, 0xfe, 0x6c	/* tsvsm_perform_call_protocol */
	.byte 0x11, 0x3f, 0xf6, 0x6e, 0xe2, 0xab, 0xb7, 0xfa, 0x73, 0x76, 0x73, 0xcd, 0xe9, 0x9a, 0x73, 0xf9, 0xf8, 0x71	/* T__pfx_snp_issue_svsm_attest_req */
	.byte 0x11, 0x54, 0x73, 0x6e, 0xe2, 0xab, 0xb7, 0xfa, 0x73, 0x76, 0x73, 0xcd, 0xe9, 0x9a, 0x73, 0xf9, 0xf8, 0x71	/* Tsnp_issue_svsm_attest_req */
	.byte 0x08, 0xa8, 0xf6, 0x6e, 0x70, 0x1f, 0x76, 0x20, 0x61	/* t__pfx_snp_set_vmsa */
	.byte 0x08, 0x74, 0x73, 0x6e, 0x70, 0x1f, 0x76, 0x20, 0x61	/* tsnp_set_vmsa */
	.byte 0x0b, 0xa8, 0xf6, 0x6e, 0xe2, 0x63, 0xd3, 0xcc, 0x3a, 0x76, 0x20, 0x61	/* t__pfx_snp_cleanup_vmsa */
	.byte 0x0b, 0x74, 0x73, 0x6e, 0xe2, 0x63, 0xd3, 0xcc, 0x3a, 0x76, 0x20, 0x61	/* tsnp_cleanup_vmsa */
	.byte 0x0f, 0xc6, 0x13, 0x0e, 0x3a, 0x92, 0x5f, 0x76, 0x69, 0x61, 0x5f, 0x76, 0x6d, 0xda, 0x78, 0xe4	/* t__pfx_wakeup_cpu_via_vmgexit */
	.byte 0x0f, 0x74, 0x13, 0x0e, 0x3a, 0x92, 0x5f, 0x76, 0x69, 0x61, 0x5f, 0x76, 0x6d, 0xda, 0x78, 0xe4	/* twakeup_cpu_via_vmgexit */
	.byte 0x0b, 0xa8, 0xf6, 0x76, 0x73, 0x6d, 0xe7, 0x76, 0xe1, 0xe7, 0x03, 0x73	/* t__pfx_svsm_pval_pages */
	.byte 0x0b, 0x74, 0x73, 0x76, 0x73, 0x6d, 0xe7, 0x76, 0xe1, 0xe7, 0x03, 0x73	/* tsvsm_pval_pages */
	.byte 0x09, 0xa8, 0xe7, 0x76, 0xe1, 0x89, 0xa1, 0x70, 0x03, 0x73	/* t__pfx_pvalidate_pages */
	.byte 0x08, 0x06, 0x76, 0xe1, 0x89, 0xa1, 0x70, 0x03, 0x73	/* tpvalidate_pages */
	.byte 0x0a, 0xa8, 0xe7, 0x76, 0xe1, 0x89, 0xa1, 0x34, 0x6b, 0xe7, 0x03	/* t__pfx_pvalidate_4k_page */
	.byte 0x09, 0x06, 0x76, 0xe1, 0x89, 0xa1, 0x34, 0x6b, 0xe7, 0x03	/* tpvalidate_4k_page */
	.byte 0x07, 0xa8, 0x1f, 0x70, 0x03, 0x73, 0x2a, 0x86	/* t__pfx_set_pages_state */
	.byte 0x08, 0x74, 0xc9, 0xf9, 0x70, 0x03, 0x73, 0x2a, 0x86	/* tset_pages_state */
	.byte 0x08, 0xc6, 0x76, 0xd5, 0xa9, 0x5f, 0x6d, 0x6d, 0xd9	/* t__pfx_vc_do_mmio */
	.byte 0x08, 0x74, 0x76, 0xd5, 0xa9, 0x5f, 0x6d, 0x6d, 0xd9	/* tvc_do_mmio */
	.byte 0x0b, 0xc6, 0x76, 0xd5, 0x68, 0xcc, 0x64, 0xb3, 0xd1, 0xe4, 0xfe, 0xe6	/* t__pfx_vc_handle_exitcode */
	.byte 0x0b, 0x74, 0x76, 0xd5, 0x68, 0xcc, 0x64, 0xb3, 0xd1, 0xe4, 0xfe, 0xe6	/* tvc_handle_exitcode */
	.byte 0x0f, 0xc6, 0x76, 0xd5, 0x1c, 0x68, 0xcc, 0x64, 0xb3, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e	/* t__pfx_vc_raw_handle_exception */
	.byte 0x0f, 0x74, 0x76, 0xd5, 0x1c, 0x68, 0xcc, 0x64, 0xb3, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e	/* tvc_raw_handle_exception */
	.byte 0x0e, 0x3f, 0xf6, 0x6e, 0x70, 0x1f, 0xbd, 0x6d, 0xce, 0x79, 0xf6, 0x68, 0x61, 0xf8, 0x64	/* T__pfx_snp_set_memory_shared */
	.byte 0x0e, 0x54, 0x73, 0x6e, 0x70, 0x1f, 0xbd, 0x6d, 0xce, 0x79, 0xf6, 0x68, 0x61, 0xf8, 0x64	/* Tsnp_set_memory_shared */
	.byte 0x0e, 0x3f, 0xf6, 0x6e, 0x70, 0x1f, 0xbd, 0x6d, 0xce, 0x79, 0xe7, 0x72, 0x69, 0x76, 0x86	/* T__pfx_snp_set_memory_private */
	.byte 0x0e, 0x54, 0x73, 0x6e, 0x70, 0x1f, 0xbd, 0x6d, 0xce, 0x79, 0xe7, 0x72, 0x69, 0x76, 0x86	/* Tsnp_set_memory_private */
	.byte 0x0d, 0x3f, 0xf6, 0x6e, 0xe2, 0xeb, 0x63, 0x65, 0x70, 0xf9, 0xbd, 0x6d, 0xce, 0x79	/* T__pfx_snp_accept_memory */
	.byte 0x0d, 0x54, 0x73, 0x6e, 0xe2, 0xeb, 0x63, 0x65, 0x70, 0xf9, 0xbd, 0x6d, 0xce, 0x79	/* Tsnp_accept_memory */
	.byte 0x08, 0x3f, 0xba, 0x74, 0x3a, 0x67, 0x68, 0x63, 0x62	/* T__pfx_setup_ghcb */
	.byte 0x08, 0x54, 0xc9, 0x74, 0x3a, 0x67, 0x68, 0x63, 0x62	/* Tsetup_ghcb */
	.byte 0x0a, 0xbf, 0x77, 0xca, 0x7c, 0x15, 0xd4, 0xd8, 0x15, 0xd4, 0x6b	/* T__pfx_warn_thunk_thunk */
	.byte 0x0a, 0x54, 0x77, 0xca, 0x7c, 0x15, 0xd4, 0xd8, 0x15, 0xd4, 0x6b	/* Twarn_thunk_thunk */
	.byte 0x0b, 0x3f, 0xff, 0xf6, 0x77, 0xe4, 0xd0, 0x5f, 0xac, 0x5f, 0x96, 0x6d	/* T__pfx___switch_to_asm */
	.byte 0x0a, 0x2f, 0x73, 0x77, 0xe4, 0xd0, 0x5f, 0xac, 0x5f, 0x96, 0x6d	/* T__switch_to_asm */
	.byte 0x0b, 0x54, 0xf8, 0xf9, 0x66, 0xde, 0xcd, 0x66, 0xce, 0xd8, 0x96, 0x6d	/* Tret_from_fork_asm */
	.byte 0x0f, 0x54, 0xf8, 0x77, 0xf0, 0x64, 0x2a, 0xeb, 0xd8, 0xcc, 0xe5, 0xdd, 0x6b, 0xfa, 0xe6, 0xc7	/* Trewind_stack_and_make_dead */
	.byte 0x08, 0xbf, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x28, 0x6c	/* T__pfx_x64_sys_call */
	.byte 0x08, 0x54, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x28, 0x6c	/* Tx64_sys_call */
	.byte 0x0b, 0x29, 0x5f, 0xa9, 0x95, 0xe0, 0x6e, 0x69, 0x95, 0x73, 0x28, 0x6c	/* t__pfx___do_sys_ni_syscall */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x6e, 0x69, 0x95, 0x73, 0x28, 0x6c	/* T__pfx___ia32_sys_ni_syscall */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x6e, 0x69, 0x95, 0x73, 0x28, 0x6c	/* T__pfx___x64_sys_ni_syscall */
	.byte 0x0b, 0x74, 0xff, 0xa9, 0x95, 0xe0, 0x6e, 0x69, 0x95, 0x73, 0x28, 0x6c	/* t__do_sys_ni_syscall */
	.byte 0x0d, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x6e, 0x69, 0x95, 0x73, 0x28, 0x6c	/* T__ia32_sys_ni_syscall */
	.byte 0x0c, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x6e, 0x69, 0x95, 0x73, 0x28, 0x6c	/* T__x64_sys_ni_syscall */
	.byte 0x17, 0xc6, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x65, 0x6d, 0x0b, 0xe9, 0xd9, 0x7c, 0x6f, 0x76, 0xee, 0x72, 0x89, 0xfa, 0x63, 0x6d, 0x64, 0x88, 0x65	/* t__pfx_ia32_emulation_override_cmdline */
	.byte 0x16, 0xc2, 0x61, 0x33, 0x32, 0x5f, 0x65, 0x6d, 0x0b, 0xe9, 0xd9, 0x7c, 0x6f, 0x76, 0xee, 0x72, 0x89, 0xfa, 0x63, 0x6d, 0x64, 0x88, 0x65	/* tia32_emulation_override_cmdline */
	.byte 0x10, 0x29, 0x5f, 0x78, 0xe8, 0xe7, 0x76, 0x5f, 0xbc, 0x74, 0xd0, 0x7c, 0xa9, 0x5f, 0xb9, 0x28, 0x6c	/* t__pfx___xen_pv_evtchn_do_upcall */
	.byte 0x10, 0x74, 0xff, 0x78, 0xe8, 0xe7, 0x76, 0x5f, 0xbc, 0x74, 0xd0, 0x7c, 0xa9, 0x5f, 0xb9, 0x28, 0x6c	/* t__xen_pv_evtchn_do_upcall */
	.byte 0x09, 0xc6, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0x6d, 0xf8, 0x0a	/* t__pfx_vdso_mremap */
	.byte 0x09, 0x74, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0x6d, 0xf8, 0x0a	/* tvdso_mremap */
	.byte 0x09, 0xc6, 0x76, 0x76, 0xca, 0x5f, 0x66, 0x61, 0x0b, 0x74	/* t__pfx_vvar_fault */
	.byte 0x09, 0x74, 0x76, 0x76, 0xca, 0x5f, 0x66, 0x61, 0x0b, 0x74	/* tvvar_fault */
	.byte 0x0a, 0xc6, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0x66, 0x61, 0x0b, 0x74	/* t__pfx_vdso_fault */
	.byte 0x0a, 0x74, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0x66, 0x61, 0x0b, 0x74	/* tvdso_fault */
	.byte 0x06, 0xc6, 0x84, 0x76, 0x64, 0x73, 0x6f	/* t__pfx_map_vdso */
	.byte 0x06, 0x74, 0x84, 0x76, 0x64, 0x73, 0x6f	/* tmap_vdso */
	.byte 0x0c, 0xbf, 0xca, 0xd0, 0x5f, 0xb2, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0x64, 0x0f	/* T__pfx_arch_get_vdso_data */
	.byte 0x0c, 0x54, 0xca, 0xd0, 0x5f, 0xb2, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0x64, 0x0f	/* Tarch_get_vdso_data */
	.byte 0x0e, 0xbf, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0x6a, 0x6f, 0xf0, 0x5f, 0xc2, 0x6d, 0xe8, 0x73	/* T__pfx_vdso_join_timens */
	.byte 0x0e, 0x54, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0x6a, 0x6f, 0xf0, 0x5f, 0xc2, 0x6d, 0xe8, 0x73	/* Tvdso_join_timens */
	.byte 0x0b, 0xbf, 0x84, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0x6f, 0x6e, 0x63, 0x65	/* T__pfx_map_vdso_once */
	.byte 0x0b, 0x54, 0x84, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0x6f, 0x6e, 0x63, 0x65	/* Tmap_vdso_once */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0xba, 0x74, 0x3a, 0x10, 0xe4, 0xd9, 0x6e, 0xe1, 0xe7, 0x03, 0x73	/* T__pfx_arch_setup_additional_pages */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0xba, 0x74, 0x3a, 0x10, 0xe4, 0xd9, 0x6e, 0xe1, 0xe7, 0x03, 0x73	/* Tarch_setup_additional_pages */
	.byte 0x11, 0xbf, 0x09, 0x61, 0xf9, 0xca, 0xd0, 0xba, 0x74, 0x3a, 0x10, 0xe4, 0xd9, 0x6e, 0xe1, 0xe7, 0x03, 0x73	/* T__pfx_compat_arch_setup_additional_pages */
	.byte 0x11, 0x54, 0x09, 0x61, 0xf9, 0xca, 0xd0, 0xba, 0x74, 0x3a, 0x10, 0xe4, 0xd9, 0x6e, 0xe1, 0xe7, 0x03, 0x73	/* Tcompat_arch_setup_additional_pages */
	.byte 0x13, 0xbf, 0xca, 0xd0, 0x95, 0x73, 0x28, 0xc3, 0x69, 0xe0, 0x76, 0x64, 0x73, 0x6f, 0xf6, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* T__pfx_arch_syscall_is_vdso_sigreturn */
	.byte 0x13, 0x54, 0xca, 0xd0, 0x95, 0x73, 0x28, 0xc3, 0x69, 0xe0, 0x76, 0x64, 0x73, 0x6f, 0xf6, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* Tarch_syscall_is_vdso_sigreturn */
	.byte 0x10, 0xbf, 0xb8, 0x78, 0x3a, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e	/* T__pfx_fixup_vdso_exception */
	.byte 0x10, 0x54, 0xb8, 0x78, 0x3a, 0x76, 0x64, 0x73, 0x6f, 0x5f, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e	/* Tfixup_vdso_exception */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* T__pfx___traceiter_emulate_vsyscall */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xcf, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* T__traceiter_emulate_vsyscall */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* T__pfx___probestub_emulate_vsyscall */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* T__probestub_emulate_vsyscall */
	.byte 0x09, 0xc6, 0x67, 0xa1, 0x76, 0xdd, 0x5f, 0x6e, 0x61, 0xbd	/* t__pfx_gate_vma_name */
	.byte 0x09, 0x74, 0x67, 0xa1, 0x76, 0xdd, 0x5f, 0x6e, 0x61, 0xbd	/* tgate_vma_name */
	.byte 0x0e, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* t__pfx_perf_trace_emulate_vsyscall */
	.byte 0x0d, 0x06, 0xee, 0xa0, 0xc8, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* tperf_trace_emulate_vsyscall */
	.byte 0x0e, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* t__pfx_trace_event_raw_event_emulate_vsyscall */
	.byte 0x0e, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* ttrace_event_raw_event_emulate_vsyscall */
	.byte 0x10, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* t__pfx_trace_raw_output_emulate_vsyscall */
	.byte 0x10, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* ttrace_raw_output_emulate_vsyscall */
	.byte 0x0d, 0x29, 0x5f, 0x40, 0xc8, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* t__pfx___bpf_trace_emulate_vsyscall */
	.byte 0x0d, 0x74, 0xff, 0x40, 0xc8, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* t__bpf_trace_emulate_vsyscall */
	.byte 0x09, 0xc6, 0x24, 0xfa, 0x6f, 0xd8, 0xce, 0xba, 0x67, 0x76	/* t__pfx_write_ok_or_segv */
	.byte 0x09, 0x74, 0x24, 0xfa, 0x6f, 0xd8, 0xce, 0xba, 0x67, 0x76	/* twrite_ok_or_segv */
	.byte 0x0b, 0xc6, 0x77, 0xca, 0x7c, 0x62, 0x05, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* t__pfx_warn_bad_vsyscall */
	.byte 0x0b, 0x74, 0x77, 0xca, 0x7c, 0x62, 0x05, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* twarn_bad_vsyscall */
	.byte 0x0a, 0xbf, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* T__pfx_emulate_vsyscall */
	.byte 0x0a, 0x54, 0x65, 0x6d, 0x0b, 0xa1, 0x76, 0xc1, 0x73, 0x28, 0x6c	/* Temulate_vsyscall */
	.byte 0x06, 0xbf, 0xb2, 0x67, 0xa1, 0x76, 0xdd	/* T__pfx_get_gate_vma */
	.byte 0x06, 0x54, 0xb2, 0x67, 0xa1, 0x76, 0xdd	/* Tget_gate_vma */
	.byte 0x08, 0xbf, 0xf0, 0x5f, 0x67, 0xa1, 0x61, 0xf8, 0x61	/* T__pfx_in_gate_area */
	.byte 0x08, 0x54, 0xf0, 0x5f, 0x67, 0xa1, 0x61, 0xf8, 0x61	/* Tin_gate_area */
	.byte 0x0d, 0xbf, 0xf0, 0x5f, 0x67, 0xa1, 0x61, 0xf8, 0x61, 0x5f, 0xb6, 0x5f, 0x6d, 0x6d	/* T__pfx_in_gate_area_no_mm */
	.byte 0x0d, 0x54, 0xf0, 0x5f, 0x67, 0xa1, 0x61, 0xf8, 0x61, 0x5f, 0xb6, 0x5f, 0x6d, 0x6d	/* Tin_gate_area_no_mm */
	.byte 0x0e, 0x3f, 0xe7, 0xf8, 0x65, 0xb0, 0xf9, 0x73, 0x7e, 0x64, 0x75, 0xb3, 0x15, 0xd4, 0x6b	/* T__pfx_preempt_schedule_thunk */
	.byte 0x0e, 0x54, 0x70, 0xf8, 0x65, 0xb0, 0xf9, 0x73, 0x7e, 0x64, 0x75, 0xb3, 0x15, 0xd4, 0x6b	/* Tpreempt_schedule_thunk */
	.byte 0x10, 0x3f, 0xe7, 0xf8, 0x65, 0xb0, 0xf9, 0x73, 0x7e, 0x64, 0x75, 0xb3, 0xb6, 0xc8, 0x15, 0xd4, 0x6b	/* T__pfx_preempt_schedule_notrace_thunk */
	.byte 0x10, 0x54, 0x70, 0xf8, 0x65, 0xb0, 0xf9, 0x73, 0x7e, 0x64, 0x75, 0xb3, 0xb6, 0xc8, 0x15, 0xd4, 0x6b	/* Tpreempt_schedule_notrace_thunk */
	.byte 0x09, 0xbf, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x28, 0x6c	/* T__pfx_ia32_sys_call */
	.byte 0x09, 0x54, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x28, 0x6c	/* Tia32_sys_call */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* t__pfx_paravirt_read_msr */
	.byte 0x0a, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* tparavirt_read_msr */
	.byte 0x0f, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x6e, 0x75, 0xcd, 0xfe, 0xd4, 0x74, 0xee, 0x73	/* t__pfx_x86_pmu_num_counters */
	.byte 0x0f, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x6e, 0x75, 0xcd, 0xfe, 0xd4, 0x74, 0xee, 0x73	/* tx86_pmu_num_counters */
	.byte 0x0d, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xd1, 0xea, 0x61, 0x5f, 0x9f, 0x73	/* t__pfx_x86_pmu_extra_regs */
	.byte 0x0d, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xd1, 0xea, 0x61, 0x5f, 0x9f, 0x73	/* tx86_pmu_extra_regs */
	.byte 0x0d, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x92	/* t__pfx_x86_pmu_prepare_cpu */
	.byte 0x0d, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x92	/* tx86_pmu_prepare_cpu */
	.byte 0x0a, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xe6, 0x05, 0x92	/* t__pfx_x86_pmu_dead_cpu */
	.byte 0x0a, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xe6, 0x05, 0x92	/* tx86_pmu_dead_cpu */
	.byte 0x0e, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xf6, 0xdb, 0x72, 0x74, 0xf0, 0xa6, 0x92	/* t__pfx_x86_pmu_starting_cpu */
	.byte 0x0e, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xf6, 0xdb, 0x72, 0x74, 0xf0, 0xa6, 0x92	/* tx86_pmu_starting_cpu */
	.byte 0x0c, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x64, 0x79, 0xf0, 0xa6, 0x92	/* t__pfx_x86_pmu_dying_cpu */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x64, 0x79, 0xf0, 0xa6, 0x92	/* tx86_pmu_dying_cpu */
	.byte 0x08, 0xc6, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_is_visible */
	.byte 0x07, 0xc2, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* tis_visible */
	.byte 0x0a, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xaf, 0x89, 0x78	/* t__pfx_x86_pmu_event_idx */
	.byte 0x0a, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xaf, 0x89, 0x78	/* tx86_pmu_event_idx */
	.byte 0x0e, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x7e, 0x63, 0x6b, 0xe7, 0xee, 0xd9, 0x64	/* t__pfx_x86_pmu_check_period */
	.byte 0x0e, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x7e, 0x63, 0x6b, 0xe7, 0xee, 0xd9, 0x64	/* tx86_pmu_check_period */
	.byte 0x11, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x61, 0x75, 0x1a, 0x6f, 0x5e, 0xbe, 0xf9, 0x6d, 0xe9, 0xd0	/* t__pfx_x86_pmu_aux_output_match */
	.byte 0x11, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x61, 0x75, 0x1a, 0x6f, 0x5e, 0xbe, 0xf9, 0x6d, 0xe9, 0xd0	/* tx86_pmu_aux_output_match */
	.byte 0x09, 0xc6, 0xb2, 0xc9, 0x67, 0x6d, 0xbb, 0x62, 0x61, 0xc9	/* t__pfx_get_segment_base */
	.byte 0x09, 0x74, 0xb2, 0xc9, 0x67, 0x6d, 0xbb, 0x62, 0x61, 0xc9	/* tget_segment_base */
	.byte 0x0b, 0x3f, 0xe7, 0xee, 0xa0, 0xb2, 0x68, 0xaa, 0xaf, 0x98, 0xb8, 0x67	/* T__pfx_perf_get_hw_event_config */
	.byte 0x0b, 0x54, 0x70, 0xee, 0xa0, 0xb2, 0x68, 0xaa, 0xaf, 0x98, 0xb8, 0x67	/* Tperf_get_hw_event_config */
	.byte 0x0b, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xb8, 0x6c, 0x74, 0xee	/* t__pfx_x86_pmu_filter */
	.byte 0x0b, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xb8, 0x6c, 0x74, 0xee	/* tx86_pmu_filter */
	.byte 0x0f, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xf6, 0x13, 0xe2, 0xdb, 0x73, 0xd8, 0x7b, 0x78	/* t__pfx_x86_pmu_swap_task_ctx */
	.byte 0x0f, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xf6, 0x13, 0xe2, 0xdb, 0x73, 0xd8, 0x7b, 0x78	/* tx86_pmu_swap_task_ctx */
	.byte 0x0c, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xf6, 0x7e, 0xe5, 0xdb, 0x16	/* t__pfx_x86_pmu_sched_task */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xf6, 0x7e, 0xe5, 0xdb, 0x16	/* tx86_pmu_sched_task */
	.byte 0x0b, 0xbf, 0x78, 0x38, 0x36, 0xe7, 0xee, 0xa0, 0xaf, 0xb9, 0x64, 0x86	/* T__pfx_x86_perf_event_update */
	.byte 0x0b, 0x54, 0x78, 0x38, 0x36, 0xe7, 0xee, 0xa0, 0xaf, 0xb9, 0x64, 0x86	/* Tx86_perf_event_update */
	.byte 0x0f, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x63, 0xcc, 0x63, 0x65, 0xc3, 0x74, 0x78, 0x6e	/* t__pfx_x86_pmu_cancel_txn */
	.byte 0x0f, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x63, 0xcc, 0x63, 0x65, 0xc3, 0x74, 0x78, 0x6e	/* tx86_pmu_cancel_txn */
	.byte 0x0e, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xfe, 0x6d, 0x6d, 0x99, 0x74, 0x78, 0x6e	/* t__pfx_x86_pmu_commit_txn */
	.byte 0x0e, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xfe, 0x6d, 0x6d, 0x99, 0x74, 0x78, 0x6e	/* tx86_pmu_commit_txn */
	.byte 0x0e, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xf6, 0xdb, 0x72, 0xf9, 0x74, 0x78, 0x6e	/* t__pfx_x86_pmu_start_txn */
	.byte 0x0e, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xf6, 0xdb, 0x72, 0xf9, 0x74, 0x78, 0x6e	/* tx86_pmu_start_txn */
	.byte 0x09, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xf8, 0xc7	/* t__pfx_x86_pmu_read */
	.byte 0x09, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xf8, 0xc7	/* tx86_pmu_read */
	.byte 0x0b, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xf6, 0xdb, 0x72, 0x74	/* t__pfx_x86_pmu_start */
	.byte 0x0b, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xf6, 0xdb, 0x72, 0x74	/* tx86_pmu_start */
	.byte 0x0d, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xaf, 0xd4, 0x0a, 0x70, 0x65, 0x64	/* t__pfx_x86_pmu_event_unmapped */
	.byte 0x0d, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xaf, 0xd4, 0x0a, 0x70, 0x65, 0x64	/* tx86_pmu_event_unmapped */
	.byte 0x0c, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xaf, 0x0a, 0x70, 0x65, 0x64	/* t__pfx_x86_pmu_event_mapped */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xaf, 0x0a, 0x70, 0x65, 0x64	/* tx86_pmu_event_mapped */
	.byte 0x0c, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x6f, 0x6e, 0x88, 0xfa, 0x92	/* t__pfx_x86_pmu_online_cpu */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x6f, 0x6e, 0x88, 0xfa, 0x92	/* tx86_pmu_online_cpu */
	.byte 0x0b, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xd3	/* t__pfx_x86_pmu_disable */
	.byte 0x0b, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xd3	/* tx86_pmu_disable */
	.byte 0x0a, 0xc6, 0xb2, 0xe9, 0xea, 0x5f, 0x72, 0x64, 0x70, 0x6d, 0x63	/* t__pfx_get_attr_rdpmc */
	.byte 0x0a, 0x74, 0xb2, 0xe9, 0xea, 0x5f, 0x72, 0x64, 0x70, 0x6d, 0x63	/* tget_attr_rdpmc */
	.byte 0x0a, 0xa8, 0x1f, 0xe9, 0xea, 0x5f, 0x72, 0x64, 0x70, 0x6d, 0x63	/* t__pfx_set_attr_rdpmc */
	.byte 0x0b, 0x74, 0xc9, 0xf9, 0xe9, 0xea, 0x5f, 0x72, 0x64, 0x70, 0x6d, 0x63	/* tset_attr_rdpmc */
	.byte 0x0c, 0x3f, 0xe7, 0xee, 0xa0, 0x67, 0x75, 0x3b, 0xf9, 0xb2, 0x20, 0x72, 0x73	/* T__pfx_perf_guest_get_msrs */
	.byte 0x0c, 0x54, 0x70, 0xee, 0xa0, 0x67, 0x75, 0x3b, 0xf9, 0xb2, 0x20, 0x72, 0x73	/* Tperf_guest_get_msrs */
	.byte 0x0b, 0x3f, 0xe7, 0xee, 0xa0, 0x96, 0x73, 0x2c, 0x7c, 0xbc, 0x1e, 0x73	/* T__pfx_perf_assign_events */
	.byte 0x0b, 0x54, 0x70, 0xee, 0xa0, 0x96, 0x73, 0x2c, 0x7c, 0xbc, 0x1e, 0x73	/* Tperf_assign_events */
	.byte 0x09, 0x29, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xf8, 0xc7	/* t__pfx__x86_pmu_read */
	.byte 0x09, 0xf9, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xf8, 0xc7	/* t_x86_pmu_read */
	.byte 0x0a, 0xbf, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xf6, 0xac, 0x70	/* T__pfx_x86_pmu_stop */
	.byte 0x0a, 0x54, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x75, 0xf6, 0xac, 0x70	/* Tx86_pmu_stop */
	.byte 0x09, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xe6, 0x6c	/* t__pfx_x86_pmu_del */
	.byte 0x09, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xe6, 0x6c	/* tx86_pmu_del */
	.byte 0x0d, 0xa8, 0xe7, 0xee, 0xa0, 0xaf, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_perf_event_nmi_handler */
	.byte 0x0c, 0x06, 0xee, 0xa0, 0xaf, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* tperf_event_nmi_handler */
	.byte 0x0a, 0xbf, 0xbc, 0x1e, 0x73, 0x95, 0x73, 0x66, 0x73, 0xf6, 0x26	/* T__pfx_events_sysfs_show */
	.byte 0x0a, 0x54, 0xbc, 0x1e, 0x73, 0x95, 0x73, 0x66, 0x73, 0xf6, 0x26	/* Tevents_sysfs_show */
	.byte 0x0f, 0xbf, 0xbc, 0x1e, 0xe0, 0x68, 0x79, 0x62, 0x72, 0x89, 0x95, 0x73, 0x66, 0x73, 0xf6, 0x26	/* T__pfx_events_hybrid_sysfs_show */
	.byte 0x0f, 0x54, 0xbc, 0x1e, 0xe0, 0x68, 0x79, 0x62, 0x72, 0x89, 0x95, 0x73, 0x66, 0x73, 0xf6, 0x26	/* Tevents_hybrid_sysfs_show */
	.byte 0x0a, 0xc6, 0xe1, 0xc0, 0xa1, 0x66, 0x61, 0x6b, 0xfa, 0x92, 0x63	/* t__pfx_allocate_fake_cpuc */
	.byte 0x0a, 0x74, 0xe1, 0xc0, 0xa1, 0x66, 0x61, 0x6b, 0xfa, 0x92, 0x63	/* tallocate_fake_cpuc */
	.byte 0x13, 0xc6, 0x69, 0xe0, 0xb9, 0xde, 0x62, 0xfa, 0x61, 0xf9, 0x2b, 0xd5, 0xe8, 0xea, 0x79, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_is_uprobe_at_func_entry.isra.0 */
	.byte 0x12, 0xc2, 0xe0, 0xb9, 0xde, 0x62, 0xfa, 0x61, 0xf9, 0x2b, 0xd5, 0xe8, 0xea, 0x79, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tis_uprobe_at_func_entry.isra.0 */
	.byte 0x08, 0xc6, 0xfe, 0x6c, 0xd3, 0x63, 0xf9, 0xbc, 0x1e	/* t__pfx_collect_event */
	.byte 0x08, 0x74, 0xfe, 0x6c, 0xd3, 0x63, 0xf9, 0xbc, 0x1e	/* tcollect_event */
	.byte 0x09, 0xc6, 0xfe, 0x6c, 0xd3, 0x63, 0xf9, 0xbc, 0x1e, 0x73	/* t__pfx_collect_events */
	.byte 0x09, 0x74, 0xfe, 0x6c, 0xd3, 0x63, 0xf9, 0xbc, 0x1e, 0x73	/* tcollect_events */
	.byte 0x08, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x10	/* t__pfx_x86_pmu_add */
	.byte 0x08, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x10	/* tx86_pmu_add */
	.byte 0x13, 0x3f, 0xe7, 0xee, 0xa0, 0xb2, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x63, 0x61, 0x70, 0x80, 0x69, 0x6c, 0xe4, 0x79	/* T__pfx_perf_get_x86_pmu_capability */
	.byte 0x13, 0x54, 0x70, 0xee, 0xa0, 0xb2, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x63, 0x61, 0x70, 0x80, 0x69, 0x6c, 0xe4, 0x79	/* Tperf_get_x86_pmu_capability */
	.byte 0x0e, 0xbf, 0x78, 0x38, 0x36, 0xe7, 0xee, 0xa0, 0xaf, 0xc9, 0xf9, 0x70, 0xee, 0xd9, 0x64	/* T__pfx_x86_perf_event_set_period */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0xe7, 0xee, 0xa0, 0xaf, 0xc9, 0xf9, 0x70, 0xee, 0xd9, 0x64	/* Tx86_perf_event_set_period */
	.byte 0x09, 0xbf, 0x7e, 0x63, 0xd8, 0x68, 0xaa, 0xd1, 0x7d, 0x73	/* T__pfx_check_hw_exists */
	.byte 0x09, 0x54, 0x7e, 0x63, 0xd8, 0x68, 0xaa, 0xd1, 0x7d, 0x73	/* Tcheck_hw_exists */
	.byte 0x0d, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x3d, 0xee, 0x22, 0x68, 0xca, 0x64, 0x13, 0xf8	/* T__pfx_x86_reserve_hardware */
	.byte 0x0d, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x3d, 0xee, 0x22, 0x68, 0xca, 0x64, 0x13, 0xf8	/* Tx86_reserve_hardware */
	.byte 0x09, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xaf, 0x8d	/* t__pfx_x86_pmu_event_init */
	.byte 0x09, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xaf, 0x8d	/* tx86_pmu_event_init */
	.byte 0x0e, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0x68, 0xca, 0x64, 0x13, 0xf8	/* T__pfx_x86_release_hardware */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0x68, 0xca, 0x64, 0x13, 0xf8	/* Tx86_release_hardware */
	.byte 0x0c, 0xc6, 0x68, 0x77, 0xe7, 0xee, 0xa0, 0xaf, 0xe6, 0x73, 0xea, 0x6f, 0x79	/* t__pfx_hw_perf_event_destroy */
	.byte 0x0b, 0x15, 0x77, 0xe7, 0xee, 0xa0, 0xaf, 0xe6, 0x73, 0xea, 0x6f, 0x79	/* thw_perf_event_destroy */
	.byte 0x0e, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0xc7, 0xe5, 0xd1, 0x63, 0x6c, 0x5d, 0x69, 0x76, 0x65	/* T__pfx_x86_add_exclusive */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xc7, 0xe5, 0xd1, 0x63, 0x6c, 0x5d, 0x69, 0x76, 0x65	/* Tx86_add_exclusive */
	.byte 0x0e, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0xe6, 0xc3, 0xd1, 0x63, 0x6c, 0x5d, 0x69, 0x76, 0x65	/* T__pfx_x86_del_exclusive */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xe6, 0xc3, 0xd1, 0x63, 0x6c, 0x5d, 0x69, 0x76, 0x65	/* Tx86_del_exclusive */
	.byte 0x10, 0xbf, 0x68, 0x77, 0xe7, 0xee, 0xa0, 0x6c, 0x62, 0x72, 0x5f, 0xaf, 0xe6, 0x73, 0xea, 0x6f, 0x79	/* T__pfx_hw_perf_lbr_event_destroy */
	.byte 0x10, 0x54, 0x68, 0x77, 0xe7, 0xee, 0xa0, 0x6c, 0x62, 0x72, 0x5f, 0xaf, 0xe6, 0x73, 0xea, 0x6f, 0x79	/* Thw_perf_lbr_event_destroy */
	.byte 0x0c, 0xbf, 0x78, 0x38, 0x36, 0xba, 0x74, 0xb9, 0xe7, 0xee, 0x66, 0x63, 0xea	/* T__pfx_x86_setup_perfctr */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0xba, 0x74, 0xb9, 0xe7, 0xee, 0x66, 0x63, 0xea	/* Tx86_setup_perfctr */
	.byte 0x0e, 0xbf, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xdd, 0x78, 0xe7, 0xf8, 0x63, 0x69, 0xc9	/* T__pfx_x86_pmu_max_precise */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xdd, 0x78, 0xe7, 0xf8, 0x63, 0x69, 0xc9	/* Tx86_pmu_max_precise */
	.byte 0x0a, 0xc6, 0xdd, 0x78, 0xe7, 0xf8, 0x63, 0xab, 0xfa, 0x73, 0x26	/* t__pfx_max_precise_show */
	.byte 0x0a, 0x74, 0xdd, 0x78, 0xe7, 0xf8, 0x63, 0xab, 0xfa, 0x73, 0x26	/* tmax_precise_show */
	.byte 0x0c, 0xbf, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* T__pfx_x86_pmu_hw_config */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* Tx86_pmu_hw_config */
	.byte 0x0d, 0xbf, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* T__pfx_x86_pmu_disable_all */
	.byte 0x0d, 0x54, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* Tx86_pmu_disable_all */
	.byte 0x0c, 0xbf, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* T__pfx_x86_pmu_enable_all */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* Tx86_pmu_enable_all */
	.byte 0x09, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0xb2, 0x70, 0x6d, 0x75	/* T__pfx_x86_get_pmu */
	.byte 0x09, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xb2, 0x70, 0x6d, 0x75	/* Tx86_get_pmu */
	.byte 0x0c, 0xbf, 0x78, 0x38, 0x36, 0xf6, 0x7e, 0x64, 0x75, 0xb3, 0xbc, 0x1e, 0x73	/* T__pfx_x86_schedule_events */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0xf6, 0x7e, 0x64, 0x75, 0xb3, 0xbc, 0x1e, 0x73	/* Tx86_schedule_events */
	.byte 0x0f, 0xbf, 0x78, 0x38, 0x36, 0xe7, 0xee, 0xa0, 0x72, 0x64, 0x70, 0x6d, 0xd5, 0xf0, 0xe6, 0x78	/* T__pfx_x86_perf_rdpmc_index */
	.byte 0x0f, 0x54, 0x78, 0x38, 0x36, 0xe7, 0xee, 0xa0, 0x72, 0x64, 0x70, 0x6d, 0xd5, 0xf0, 0xe6, 0x78	/* Tx86_perf_rdpmc_index */
	.byte 0x0c, 0xbf, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* T__pfx_x86_pmu_enable_event */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* Tx86_pmu_enable_event */
	.byte 0x0c, 0x3f, 0xe7, 0xee, 0xa0, 0xaf, 0x70, 0x72, 0xf0, 0xf9, 0xe6, 0xa2, 0x67	/* T__pfx_perf_event_print_debug */
	.byte 0x0c, 0x54, 0x70, 0xee, 0xa0, 0xaf, 0x70, 0x72, 0xf0, 0xf9, 0xe6, 0xa2, 0x67	/* Tperf_event_print_debug */
	.byte 0x0d, 0xbf, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* T__pfx_x86_pmu_handle_irq */
	.byte 0x0d, 0x54, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* Tx86_pmu_handle_irq */
	.byte 0x0c, 0x3f, 0xe7, 0xee, 0xa0, 0xbc, 0x1e, 0xe0, 0x1b, 0x70, 0x69, 0xd5, 0x8d	/* T__pfx_perf_events_lapic_init */
	.byte 0x0c, 0x54, 0x70, 0xee, 0xa0, 0xbc, 0x1e, 0xe0, 0x1b, 0x70, 0x69, 0xd5, 0x8d	/* Tperf_events_lapic_init */
	.byte 0x0a, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xd3	/* t__pfx_x86_pmu_enable */
	.byte 0x0a, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xd3	/* tx86_pmu_enable */
	.byte 0x0c, 0xbf, 0xbc, 0x1e, 0xe0, 0x68, 0xf9, 0xc1, 0x73, 0x66, 0x73, 0xf6, 0x26	/* T__pfx_events_ht_sysfs_show */
	.byte 0x0c, 0x54, 0xbc, 0x1e, 0xe0, 0x68, 0xf9, 0xc1, 0x73, 0x66, 0x73, 0xf6, 0x26	/* Tevents_ht_sysfs_show */
	.byte 0x0c, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0xaf, 0xc1, 0x73, 0x66, 0x73, 0xf6, 0x26	/* T__pfx_x86_event_sysfs_show */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xaf, 0xc1, 0x73, 0x66, 0x73, 0xf6, 0x26	/* Tx86_event_sysfs_show */
	.byte 0x11, 0x3f, 0xe7, 0xee, 0xa0, 0x63, 0xd3, 0xca, 0x5f, 0x64, 0xa7, 0x74, 0xc5, 0xfe, 0xd4, 0x74, 0xee, 0x73	/* T__pfx_perf_clear_dirty_counters */
	.byte 0x11, 0x54, 0x70, 0xee, 0xa0, 0x63, 0xd3, 0xca, 0x5f, 0x64, 0xa7, 0x74, 0xc5, 0xfe, 0xd4, 0x74, 0xee, 0x73	/* Tperf_clear_dirty_counters */
	.byte 0x0c, 0x3f, 0xe7, 0xee, 0xa0, 0x7e, 0x63, 0xd8, 0x6d, 0xa3, 0xde, 0xfe, 0xe6	/* T__pfx_perf_check_microcode */
	.byte 0x0c, 0x54, 0x70, 0xee, 0xa0, 0x7e, 0x63, 0xd8, 0x6d, 0xa3, 0xde, 0xfe, 0xe6	/* Tperf_check_microcode */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0xe7, 0xee, 0xa0, 0xb9, 0x64, 0xa1, 0x5d, 0xee, 0x70, 0x03	/* T__pfx_arch_perf_update_userpage */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0xe7, 0xee, 0xa0, 0xb9, 0x64, 0xa1, 0x5d, 0xee, 0x70, 0x03	/* Tarch_perf_update_userpage */
	.byte 0x0e, 0x3f, 0xe7, 0xee, 0xa0, 0x28, 0x6c, 0xd0, 0x61, 0xf0, 0x5f, 0x6b, 0xee, 0xb4, 0x6c	/* T__pfx_perf_callchain_kernel */
	.byte 0x0e, 0x54, 0x70, 0xee, 0xa0, 0x28, 0x6c, 0xd0, 0x61, 0xf0, 0x5f, 0x6b, 0xee, 0xb4, 0x6c	/* Tperf_callchain_kernel */
	.byte 0x0c, 0x3f, 0xe7, 0xee, 0xa0, 0x28, 0x6c, 0xd0, 0x61, 0xf0, 0x5f, 0x5d, 0xee	/* T__pfx_perf_callchain_user */
	.byte 0x0c, 0x54, 0x70, 0xee, 0xa0, 0x28, 0x6c, 0xd0, 0x61, 0xf0, 0x5f, 0x5d, 0xee	/* Tperf_callchain_user */
	.byte 0x10, 0x3f, 0xe7, 0xee, 0xa0, 0xf0, 0x73, 0xea, 0x75, 0x7b, 0xd9, 0x6e, 0xe7, 0x6f, 0xf0, 0x74, 0xee	/* T__pfx_perf_instruction_pointer */
	.byte 0x10, 0x54, 0x70, 0xee, 0xa0, 0xf0, 0x73, 0xea, 0x75, 0x7b, 0xd9, 0x6e, 0xe7, 0x6f, 0xf0, 0x74, 0xee	/* Tperf_instruction_pointer */
	.byte 0x0b, 0x3f, 0xe7, 0xee, 0xa0, 0x6d, 0xab, 0xd5, 0x66, 0x1b, 0x67, 0x73	/* T__pfx_perf_misc_flags */
	.byte 0x0b, 0x54, 0x70, 0xee, 0xa0, 0x6d, 0xab, 0xd5, 0x66, 0x1b, 0x67, 0x73	/* Tperf_misc_flags */
	.byte 0x08, 0xc6, 0xb6, 0xf9, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_not_visible */
	.byte 0x08, 0x74, 0xb6, 0xf9, 0x76, 0xab, 0x69, 0x62, 0xd3	/* tnot_visible */
	.byte 0x08, 0x3f, 0xe7, 0xee, 0xa0, 0x20, 0x72, 0x25, 0x17	/* T__pfx_perf_msr_probe */
	.byte 0x08, 0x54, 0x70, 0xee, 0xa0, 0x20, 0x72, 0x25, 0x17	/* Tperf_msr_probe */
	.byte 0x0d, 0xc6, 0xe6, 0xfe, 0x64, 0xfa, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0x74, 0x27, 0x65	/* t__pfx_decode_branch_type */
	.byte 0x0d, 0x74, 0xe6, 0xfe, 0x64, 0xfa, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0x74, 0x27, 0x65	/* tdecode_branch_type */
	.byte 0x0a, 0xc6, 0xb2, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0x74, 0x27, 0x65	/* t__pfx_get_branch_type */
	.byte 0x0a, 0x74, 0xb2, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0x74, 0x27, 0x65	/* tget_branch_type */
	.byte 0x09, 0xbf, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0x74, 0x27, 0x65	/* T__pfx_branch_type */
	.byte 0x09, 0x54, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0x74, 0x27, 0x65	/* Tbranch_type */
	.byte 0x0d, 0xbf, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0x74, 0x27, 0xfa, 0x66, 0x75, 0xc9, 0x64	/* T__pfx_branch_type_fused */
	.byte 0x0d, 0x54, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0x74, 0x27, 0xfa, 0x66, 0x75, 0xc9, 0x64	/* Tbranch_type_fused */
	.byte 0x0d, 0xbf, 0xfe, 0x6d, 0xa5, 0x7c, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0x74, 0x27, 0x65	/* T__pfx_common_branch_type */
	.byte 0x0d, 0x54, 0xfe, 0x6d, 0xa5, 0x7c, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0x74, 0x27, 0x65	/* Tcommon_branch_type */
	.byte 0x0c, 0xc6, 0x61, 0x6d, 0xe5, 0x62, 0x72, 0xe0, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* t__pfx_amd_brs_hw_config */
	.byte 0x0b, 0xdb, 0x6d, 0xe5, 0x62, 0x72, 0xe0, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* tamd_brs_hw_config */
	.byte 0x0a, 0xc6, 0x61, 0x6d, 0xe5, 0x62, 0x72, 0xe0, 0xf8, 0xc9, 0x74	/* t__pfx_amd_brs_reset */
	.byte 0x09, 0xdb, 0x6d, 0xe5, 0x62, 0x72, 0xe0, 0xf8, 0xc9, 0x74	/* tamd_brs_reset */
	.byte 0x0b, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x62, 0x72, 0xe0, 0x10	/* t__pfx_amd_pmu_brs_add */
	.byte 0x0a, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x62, 0x72, 0xe0, 0x10	/* tamd_pmu_brs_add */
	.byte 0x0c, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x62, 0x72, 0xe0, 0xe6, 0x6c	/* t__pfx_amd_pmu_brs_del */
	.byte 0x0b, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x62, 0x72, 0xe0, 0xe6, 0x6c	/* tamd_pmu_brs_del */
	.byte 0x0f, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x62, 0x72, 0x73, 0xf6, 0x7e, 0xe5, 0xdb, 0x16	/* t__pfx_amd_pmu_brs_sched_task */
	.byte 0x0e, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x62, 0x72, 0x73, 0xf6, 0x7e, 0xe5, 0xdb, 0x16	/* tamd_pmu_brs_sched_task */
	.byte 0x09, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0xaf, 0x0a	/* t__pfx_amd_pmu_event_map */
	.byte 0x08, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0xaf, 0x0a	/* tamd_pmu_event_map */
	.byte 0x0f, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x10, 0x72, 0x5f, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* t__pfx_amd_pmu_addr_offset */
	.byte 0x0e, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x10, 0x72, 0x5f, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* tamd_pmu_addr_offset */
	.byte 0x13, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x75, 0xf9, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0xe0, 0x66, 0x31, 0x37, 0x68	/* t__pfx_amd_put_event_constraints_f17h */
	.byte 0x12, 0xdb, 0x6d, 0x64, 0xe7, 0x75, 0xf9, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0xe0, 0x66, 0x31, 0x37, 0x68	/* tamd_put_event_constraints_f17h */
	.byte 0x0f, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x69, 0x6d, 0x99, 0x70, 0xee, 0xd9, 0x64	/* t__pfx_amd_pmu_limit_period */
	.byte 0x0e, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x69, 0x6d, 0x99, 0x70, 0xee, 0xd9, 0x64	/* tamd_pmu_limit_period */
	.byte 0x10, 0xc6, 0x61, 0x6d, 0xe5, 0x62, 0x72, 0xcc, 0x7e, 0xe0, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_amd_branches_is_visible */
	.byte 0x0f, 0xdb, 0x6d, 0xe5, 0x62, 0x72, 0xcc, 0x7e, 0xe0, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* tamd_branches_is_visible */
	.byte 0x0b, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x92, 0x5f, 0xe6, 0xc7	/* t__pfx_amd_pmu_cpu_dead */
	.byte 0x0a, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x92, 0x5f, 0xe6, 0xc7	/* tamd_pmu_cpu_dead */
	.byte 0x11, 0xc6, 0x61, 0x6d, 0xe5, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0xe0, 0x66, 0x31, 0x35, 0x68	/* t__pfx_amd_get_event_constraints_f15h */
	.byte 0x10, 0xdb, 0x6d, 0xe5, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0xe0, 0x66, 0x31, 0x35, 0x68	/* tamd_get_event_constraints_f15h */
	.byte 0x0f, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x75, 0xf9, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_amd_put_event_constraints */
	.byte 0x0e, 0xdb, 0x6d, 0x64, 0xe7, 0x75, 0xf9, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* tamd_put_event_constraints */
	.byte 0x0d, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x92, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* t__pfx_amd_pmu_cpu_prepare */
	.byte 0x0c, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x92, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* tamd_pmu_cpu_prepare */
	.byte 0x0b, 0xc6, 0x61, 0x6d, 0xe5, 0xaf, 0xc1, 0x73, 0x66, 0x73, 0xf6, 0x26	/* t__pfx_amd_event_sysfs_show */
	.byte 0x0a, 0xdb, 0x6d, 0xe5, 0xaf, 0xc1, 0x73, 0x66, 0x73, 0xf6, 0x26	/* tamd_event_sysfs_show */
	.byte 0x06, 0xc6, 0x63, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx_cmask_show */
	.byte 0x05, 0x2d, 0xdd, 0x16, 0xf6, 0x26	/* tcmask_show */
	.byte 0x05, 0xc6, 0xf0, 0x76, 0xf6, 0x26	/* t__pfx_inv_show */
	.byte 0x05, 0x74, 0xf0, 0x76, 0xf6, 0x26	/* tinv_show */
	.byte 0x06, 0xc6, 0x65, 0x64, 0x21, 0x73, 0x26	/* t__pfx_edge_show */
	.byte 0x05, 0x9a, 0x64, 0x21, 0x73, 0x26	/* tedge_show */
	.byte 0x06, 0xc6, 0x75, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx_umask_show */
	.byte 0x06, 0x74, 0x75, 0xdd, 0x16, 0xf6, 0x26	/* tumask_show */
	.byte 0x04, 0xc6, 0xaf, 0x73, 0x26	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xaf, 0x73, 0x26	/* tevent_show */
	.byte 0x0c, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* t__pfx_amd_pmu_hw_config */
	.byte 0x0b, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* tamd_pmu_hw_config */
	.byte 0x0b, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0xe6, 0xc3, 0xbc, 0x1e	/* t__pfx_amd_pmu_del_event */
	.byte 0x0a, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0xe6, 0xc3, 0xbc, 0x1e	/* tamd_pmu_del_event */
	.byte 0x0b, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0xc7, 0xe5, 0xbc, 0x1e	/* t__pfx_amd_pmu_add_event */
	.byte 0x0a, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0xc7, 0xe5, 0xbc, 0x1e	/* tamd_pmu_add_event */
	.byte 0x11, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x13, 0x99, 0x6f, 0x7c, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0x77	/* t__pfx_amd_pmu_wait_on_overflow */
	.byte 0x10, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x13, 0x99, 0x6f, 0x7c, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0x77	/* tamd_pmu_wait_on_overflow */
	.byte 0x10, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x7e, 0x63, 0xd8, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0x77	/* t__pfx_amd_pmu_check_overflow */
	.byte 0x0f, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x7e, 0x63, 0xd8, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0x77	/* tamd_pmu_check_overflow */
	.byte 0x0c, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_amd_pmu_enable_all */
	.byte 0x0b, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* tamd_pmu_enable_all */
	.byte 0x0c, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_amd_pmu_enable_event */
	.byte 0x0b, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* tamd_pmu_enable_event */
	.byte 0x0d, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_amd_pmu_disable_all */
	.byte 0x0c, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* tamd_pmu_disable_all */
	.byte 0x08, 0xc6, 0x62, 0x72, 0xcc, 0x7e, 0x73, 0xf6, 0x26	/* t__pfx_branches_show */
	.byte 0x08, 0x74, 0x62, 0x72, 0xcc, 0x7e, 0x73, 0xf6, 0x26	/* tbranches_show */
	.byte 0x18, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xdd, 0x1a, 0x6e, 0x75, 0xcd, 0xfe, 0xd4, 0x74, 0xee, 0x73, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_x86_pmu_max_num_counters.constprop.0 */
	.byte 0x18, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xdd, 0x1a, 0x6e, 0x75, 0xcd, 0xfe, 0xd4, 0x74, 0xee, 0x73, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tx86_pmu_max_num_counters.constprop.0 */
	.byte 0x0d, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* t__pfx_amd_pmu_handle_irq */
	.byte 0x0c, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* tamd_pmu_handle_irq */
	.byte 0x11, 0xc6, 0x61, 0x6d, 0xe5, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0xe0, 0x66, 0x31, 0x37, 0x68	/* t__pfx_amd_get_event_constraints_f17h */
	.byte 0x10, 0xdb, 0x6d, 0xe5, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0xe0, 0x66, 0x31, 0x37, 0x68	/* tamd_get_event_constraints_f17h */
	.byte 0x11, 0xc6, 0x61, 0x6d, 0xe5, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0xe0, 0x66, 0x31, 0x39, 0x68	/* t__pfx_amd_get_event_constraints_f19h */
	.byte 0x10, 0xdb, 0x6d, 0xe5, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0xe0, 0x66, 0x31, 0x39, 0x68	/* tamd_get_event_constraints_f19h */
	.byte 0x0d, 0xc6, 0x61, 0x6d, 0xe5, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_amd_get_event_constraints */
	.byte 0x0c, 0xdb, 0x6d, 0xe5, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* tamd_get_event_constraints */
	.byte 0x13, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x9a, 0x73, 0xf9, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0x77, 0x2a, 0xe9, 0x5d	/* t__pfx_amd_pmu_test_overflow_status */
	.byte 0x12, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x9a, 0x73, 0xf9, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0x77, 0x2a, 0xe9, 0x5d	/* tamd_pmu_test_overflow_status */
	.byte 0x14, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x9a, 0x73, 0xf9, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0xaa, 0xac, 0x70, 0x62, 0xe4	/* t__pfx_amd_pmu_test_overflow_topbit */
	.byte 0x13, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x9a, 0x73, 0xf9, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0xaa, 0xac, 0x70, 0x62, 0xe4	/* tamd_pmu_test_overflow_topbit */
	.byte 0x0f, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x76, 0x32, 0x5f, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_amd_pmu_v2_enable_all */
	.byte 0x0e, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x76, 0x32, 0x5f, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* tamd_pmu_v2_enable_all */
	.byte 0x10, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x76, 0x32, 0x5f, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_amd_pmu_v2_disable_all */
	.byte 0x0f, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x76, 0x32, 0x5f, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* tamd_pmu_v2_disable_all */
	.byte 0x0d, 0xbf, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0x76, 0xa7, 0x74	/* T__pfx_amd_pmu_enable_virt */
	.byte 0x0d, 0x54, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0x76, 0xa7, 0x74	/* Tamd_pmu_enable_virt */
	.byte 0x0e, 0xbf, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0x76, 0xa7, 0x74	/* T__pfx_amd_pmu_disable_virt */
	.byte 0x0e, 0x54, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0x76, 0xa7, 0x74	/* Tamd_pmu_disable_virt */
	.byte 0x0e, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x92, 0xf6, 0xdb, 0x72, 0x74, 0xf0, 0x67	/* t__pfx_amd_pmu_cpu_starting */
	.byte 0x0d, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x92, 0xf6, 0xdb, 0x72, 0x74, 0xf0, 0x67	/* tamd_pmu_cpu_starting */
	.byte 0x0d, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_amd_pmu_disable_event */
	.byte 0x0c, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* tamd_pmu_disable_event */
	.byte 0x0f, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x76, 0x32, 0x5f, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_amd_pmu_v2_enable_event */
	.byte 0x0e, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x76, 0x32, 0x5f, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* tamd_pmu_v2_enable_event */
	.byte 0x10, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x76, 0x32, 0x5f, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* t__pfx_amd_pmu_v2_handle_irq */
	.byte 0x0f, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x76, 0x32, 0x5f, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* tamd_pmu_v2_handle_irq */
	.byte 0x17, 0xc6, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x76, 0x32, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0xad, 0xf9, 0x62, 0x72, 0xcc, 0xd0, 0x2a, 0xeb, 0x6b	/* t__pfx_amd_pmu_v2_snapshot_branch_stack */
	.byte 0x16, 0xdb, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x76, 0x32, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0xad, 0xf9, 0x62, 0x72, 0xcc, 0xd0, 0x2a, 0xeb, 0x6b	/* tamd_pmu_v2_snapshot_branch_stack */
	.byte 0x0d, 0xbf, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc7	/* T__pfx_amd_pmu_lbr_read */
	.byte 0x0d, 0x54, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc7	/* Tamd_pmu_lbr_read */
	.byte 0x10, 0xbf, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* T__pfx_amd_pmu_lbr_hw_config */
	.byte 0x10, 0x54, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* Tamd_pmu_lbr_hw_config */
	.byte 0x0e, 0xbf, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc9, 0x74	/* T__pfx_amd_pmu_lbr_reset */
	.byte 0x0e, 0x54, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc9, 0x74	/* Tamd_pmu_lbr_reset */
	.byte 0x0c, 0xbf, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0x10	/* T__pfx_amd_pmu_lbr_add */
	.byte 0x0c, 0x54, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0x10	/* Tamd_pmu_lbr_add */
	.byte 0x0d, 0xbf, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xe6, 0x6c	/* T__pfx_amd_pmu_lbr_del */
	.byte 0x0d, 0x54, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xe6, 0x6c	/* Tamd_pmu_lbr_del */
	.byte 0x0f, 0xbf, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0xf6, 0x7e, 0xe5, 0xdb, 0x16	/* T__pfx_amd_pmu_lbr_sched_task */
	.byte 0x0f, 0x54, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0xf6, 0x7e, 0xe5, 0xdb, 0x16	/* Tamd_pmu_lbr_sched_task */
	.byte 0x10, 0xbf, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* T__pfx_amd_pmu_lbr_enable_all */
	.byte 0x10, 0x54, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* Tamd_pmu_lbr_enable_all */
	.byte 0x11, 0xbf, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* T__pfx_amd_pmu_lbr_disable_all */
	.byte 0x11, 0x54, 0x61, 0x6d, 0x64, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* Tamd_pmu_lbr_disable_all */
	.byte 0x08, 0xa8, 0xe7, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0x8d	/* t__pfx_perf_ibs_init */
	.byte 0x07, 0x06, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0x8d	/* tperf_ibs_init */
	.byte 0x0d, 0xc6, 0xb2, 0x69, 0x62, 0xe0, 0x66, 0x65, 0x74, 0xd0, 0x5f, 0xfe, 0xd4, 0x74	/* t__pfx_get_ibs_fetch_count */
	.byte 0x0d, 0x74, 0xb2, 0x69, 0x62, 0xe0, 0x66, 0x65, 0x74, 0xd0, 0x5f, 0xfe, 0xd4, 0x74	/* tget_ibs_fetch_count */
	.byte 0x0a, 0xc6, 0xb2, 0x69, 0x62, 0xe0, 0x6f, 0xe2, 0xfe, 0xd4, 0x74	/* t__pfx_get_ibs_op_count */
	.byte 0x0a, 0x74, 0xb2, 0x69, 0x62, 0xe0, 0x6f, 0xe2, 0xfe, 0xd4, 0x74	/* tget_ibs_op_count */
	.byte 0x09, 0xa8, 0xe7, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0xf8, 0xc7	/* t__pfx_perf_ibs_read */
	.byte 0x08, 0x06, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0xf8, 0xc7	/* tperf_ibs_read */
	.byte 0x14, 0xc6, 0x7a, 0xe8, 0x5c, 0x69, 0x62, 0xe0, 0x97, 0xe8, 0x73, 0xd9, 0x6e, 0xe0, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_zen4_ibs_extensions_is_visible */
	.byte 0x14, 0x74, 0x7a, 0xe8, 0x5c, 0x69, 0x62, 0xe0, 0x97, 0xe8, 0x73, 0xd9, 0x6e, 0xe0, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* tzen4_ibs_extensions_is_visible */
	.byte 0x0d, 0xc6, 0x63, 0x6e, 0xf9, 0x7b, 0xc3, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_cnt_ctl_is_visible */
	.byte 0x0c, 0x2d, 0x6e, 0xf9, 0x7b, 0xc3, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* tcnt_ctl_is_visible */
	.byte 0x09, 0xbf, 0xb2, 0x69, 0x62, 0xe0, 0x63, 0x61, 0x70, 0x73	/* T__pfx_get_ibs_caps */
	.byte 0x09, 0x54, 0xb2, 0x69, 0x62, 0xe0, 0x63, 0x61, 0x70, 0x73	/* Tget_ibs_caps */
	.byte 0x08, 0xc6, 0x63, 0x6e, 0xf9, 0x7b, 0x6c, 0xf6, 0x26	/* t__pfx_cnt_ctl_show */
	.byte 0x07, 0x2d, 0x6e, 0xf9, 0x7b, 0x6c, 0xf6, 0x26	/* tcnt_ctl_show */
	.byte 0x07, 0xc6, 0x72, 0xcc, 0xe5, 0xe8, 0xf6, 0x26	/* t__pfx_rand_en_show */
	.byte 0x06, 0xea, 0xcc, 0xe5, 0xe8, 0xf6, 0x26	/* trand_en_show */
	.byte 0x12, 0xa8, 0xe7, 0xee, 0xa0, 0xaf, 0xc9, 0xf9, 0x70, 0xee, 0xd9, 0x64, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_perf_event_set_period.constprop.0 */
	.byte 0x11, 0x06, 0xee, 0xa0, 0xaf, 0xc9, 0xf9, 0x70, 0xee, 0xd9, 0x64, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tperf_event_set_period.constprop.0 */
	.byte 0x0b, 0xa8, 0xe7, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0xaf, 0xb9, 0x64, 0x86	/* t__pfx_perf_ibs_event_update */
	.byte 0x0a, 0x06, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0xaf, 0xb9, 0x64, 0x86	/* tperf_ibs_event_update */
	.byte 0x0b, 0xa8, 0xe7, 0xee, 0xa0, 0x69, 0x62, 0x73, 0xf6, 0xdb, 0x72, 0x74	/* t__pfx_perf_ibs_start */
	.byte 0x0a, 0x06, 0xee, 0xa0, 0x69, 0x62, 0x73, 0xf6, 0xdb, 0x72, 0x74	/* tperf_ibs_start */
	.byte 0x08, 0xa8, 0xe7, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0x10	/* t__pfx_perf_ibs_add */
	.byte 0x07, 0x06, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0x10	/* tperf_ibs_add */
	.byte 0x0d, 0xc6, 0x63, 0xd3, 0xca, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x69, 0x62, 0x73	/* t__pfx_clear_APIC_ibs */
	.byte 0x0c, 0x2d, 0xd3, 0xca, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x69, 0x62, 0x73	/* tclear_APIC_ibs */
	.byte 0x12, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x61, 0x6d, 0xe5, 0x69, 0x62, 0xe0, 0x64, 0x79, 0xf0, 0xa6, 0x92	/* t__pfx_x86_pmu_amd_ibs_dying_cpu */
	.byte 0x12, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x61, 0x6d, 0xe5, 0x69, 0x62, 0xe0, 0x64, 0x79, 0xf0, 0xa6, 0x92	/* tx86_pmu_amd_ibs_dying_cpu */
	.byte 0x0c, 0xa8, 0xe7, 0xee, 0xa0, 0x69, 0x62, 0x73, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* t__pfx_perf_ibs_suspend */
	.byte 0x0b, 0x06, 0xee, 0xa0, 0x69, 0x62, 0x73, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* tperf_ibs_suspend */
	.byte 0x0c, 0xa8, 0xba, 0x74, 0x3a, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x69, 0x62, 0x73	/* t__pfx_setup_APIC_ibs */
	.byte 0x0c, 0x74, 0xc9, 0x74, 0x3a, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x69, 0x62, 0x73	/* tsetup_APIC_ibs */
	.byte 0x14, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x61, 0x6d, 0xe5, 0x69, 0x62, 0x73, 0xf6, 0xdb, 0x72, 0x74, 0xf0, 0xa6, 0x92	/* t__pfx_x86_pmu_amd_ibs_starting_cpu */
	.byte 0x14, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x61, 0x6d, 0xe5, 0x69, 0x62, 0x73, 0xf6, 0xdb, 0x72, 0x74, 0xf0, 0xa6, 0x92	/* tx86_pmu_amd_ibs_starting_cpu */
	.byte 0x0c, 0xc6, 0x69, 0x62, 0xe0, 0x65, 0x69, 0x6c, 0x76, 0xf9, 0x76, 0xe1, 0x89	/* t__pfx_ibs_eilvt_valid */
	.byte 0x0b, 0xc2, 0x62, 0xe0, 0x65, 0x69, 0x6c, 0x76, 0xf9, 0x76, 0xe1, 0x89	/* tibs_eilvt_valid */
	.byte 0x10, 0xc6, 0x66, 0xce, 0x63, 0xfa, 0x69, 0x62, 0xe0, 0x65, 0x69, 0x6c, 0x76, 0xf9, 0xc9, 0x74, 0xb9	/* t__pfx_force_ibs_eilvt_setup */
	.byte 0x10, 0x74, 0x66, 0xce, 0x63, 0xfa, 0x69, 0x62, 0xe0, 0x65, 0x69, 0x6c, 0x76, 0xf9, 0xc9, 0x74, 0xb9	/* tforce_ibs_eilvt_setup */
	.byte 0x0a, 0xa8, 0xe7, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0xf8, 0xb7, 0xbd	/* t__pfx_perf_ibs_resume */
	.byte 0x09, 0x06, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0xf8, 0xb7, 0xbd	/* tperf_ibs_resume */
	.byte 0x0a, 0xa8, 0xe7, 0xee, 0xa0, 0x69, 0x62, 0x73, 0xf6, 0xac, 0x70	/* t__pfx_perf_ibs_stop */
	.byte 0x09, 0x06, 0xee, 0xa0, 0x69, 0x62, 0x73, 0xf6, 0xac, 0x70	/* tperf_ibs_stop */
	.byte 0x09, 0xa8, 0xe7, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0xe6, 0x6c	/* t__pfx_perf_ibs_del */
	.byte 0x08, 0x06, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0xe6, 0x6c	/* tperf_ibs_del */
	.byte 0x0d, 0xa8, 0xe7, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* t__pfx_perf_ibs_handle_irq */
	.byte 0x0c, 0x06, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* tperf_ibs_handle_irq */
	.byte 0x0f, 0xa8, 0xe7, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_perf_ibs_nmi_handler */
	.byte 0x0e, 0x06, 0xee, 0xa0, 0x69, 0x62, 0xe0, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* tperf_ibs_nmi_handler */
	.byte 0x0c, 0xbf, 0x66, 0xce, 0x77, 0xca, 0xe5, 0xaf, 0xac, 0x5f, 0x69, 0x62, 0x73	/* T__pfx_forward_event_to_ibs */
	.byte 0x0c, 0x54, 0x66, 0xce, 0x77, 0xca, 0xe5, 0xaf, 0xac, 0x5f, 0x69, 0x62, 0x73	/* Tforward_event_to_ibs */
	.byte 0x0a, 0xa8, 0xe7, 0xee, 0xa0, 0xd9, 0x6d, 0x6d, 0x00, 0xaf, 0x8d	/* t__pfx_perf_iommu_event_init */
	.byte 0x09, 0x06, 0xee, 0xa0, 0xd9, 0x6d, 0x6d, 0x00, 0xaf, 0x8d	/* tperf_iommu_event_init */
	.byte 0x08, 0x29, 0xd9, 0x6d, 0x6d, 0x00, 0xaf, 0x73, 0x26	/* t__pfx__iommu_event_show */
	.byte 0x08, 0xf9, 0xd9, 0x6d, 0x6d, 0x00, 0xaf, 0x73, 0x26	/* t_iommu_event_show */
	.byte 0x09, 0xa8, 0xe7, 0x96, 0x69, 0xe5, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx_pasid_mask_show */
	.byte 0x08, 0x06, 0x96, 0x69, 0xe5, 0xdd, 0x16, 0xf6, 0x26	/* tpasid_mask_show */
	.byte 0x09, 0xc6, 0xa9, 0x6d, 0x69, 0xe5, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx_domid_mask_show */
	.byte 0x09, 0x74, 0xa9, 0x6d, 0x69, 0xe5, 0xdd, 0x16, 0xf6, 0x26	/* tdomid_mask_show */
	.byte 0x08, 0xc6, 0xd2, 0x69, 0xe5, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx_devid_mask_show */
	.byte 0x08, 0x74, 0xd2, 0x69, 0xe5, 0xdd, 0x16, 0xf6, 0x26	/* tdevid_mask_show */
	.byte 0x06, 0xa8, 0xe7, 0x96, 0x89, 0xf6, 0x26	/* t__pfx_pasid_show */
	.byte 0x05, 0x06, 0x96, 0x89, 0xf6, 0x26	/* tpasid_show */
	.byte 0x06, 0xc6, 0xa9, 0x6d, 0x89, 0xf6, 0x26	/* t__pfx_domid_show */
	.byte 0x06, 0x74, 0xa9, 0x6d, 0x89, 0xf6, 0x26	/* tdomid_show */
	.byte 0x05, 0xc6, 0xd2, 0x89, 0xf6, 0x26	/* t__pfx_devid_show */
	.byte 0x05, 0x74, 0xd2, 0x89, 0xf6, 0x26	/* tdevid_show */
	.byte 0x09, 0xc6, 0x63, 0x73, 0x6f, 0x1d, 0x63, 0xfa, 0x73, 0x26	/* t__pfx_csource_show */
	.byte 0x08, 0x2d, 0x73, 0x6f, 0x1d, 0x63, 0xfa, 0x73, 0x26	/* tcsource_show */
	.byte 0x0a, 0xa8, 0xe7, 0xee, 0xa0, 0xd9, 0x6d, 0x6d, 0x00, 0xf8, 0xc7	/* t__pfx_perf_iommu_read */
	.byte 0x09, 0x06, 0xee, 0xa0, 0xd9, 0x6d, 0x6d, 0x00, 0xf8, 0xc7	/* tperf_iommu_read */
	.byte 0x0b, 0xa8, 0xe7, 0xee, 0xa0, 0xd9, 0x6d, 0x6d, 0x75, 0xf6, 0xac, 0x70	/* t__pfx_perf_iommu_stop */
	.byte 0x0a, 0x06, 0xee, 0xa0, 0xd9, 0x6d, 0x6d, 0x75, 0xf6, 0xac, 0x70	/* tperf_iommu_stop */
	.byte 0x0c, 0xa8, 0xe7, 0xee, 0xa0, 0xd9, 0x6d, 0x6d, 0x75, 0xf6, 0xdb, 0x72, 0x74	/* t__pfx_perf_iommu_start */
	.byte 0x0b, 0x06, 0xee, 0xa0, 0xd9, 0x6d, 0x6d, 0x75, 0xf6, 0xdb, 0x72, 0x74	/* tperf_iommu_start */
	.byte 0x0a, 0x29, 0xd9, 0x6d, 0x6d, 0x00, 0x92, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx__iommu_cpumask_show */
	.byte 0x0a, 0xf9, 0xd9, 0x6d, 0x6d, 0x00, 0x92, 0xdd, 0x16, 0xf6, 0x26	/* t_iommu_cpumask_show */
	.byte 0x09, 0xa8, 0xe7, 0xee, 0xa0, 0xd9, 0x6d, 0x6d, 0x00, 0x10	/* t__pfx_perf_iommu_add */
	.byte 0x08, 0x06, 0xee, 0xa0, 0xd9, 0x6d, 0x6d, 0x00, 0x10	/* tperf_iommu_add */
	.byte 0x0a, 0xa8, 0xe7, 0xee, 0xa0, 0xd9, 0x6d, 0x6d, 0x00, 0xe6, 0x6c	/* t__pfx_perf_iommu_del */
	.byte 0x09, 0x06, 0xee, 0xa0, 0xd9, 0x6d, 0x6d, 0x00, 0xe6, 0x6c	/* tperf_iommu_del */
	.byte 0x0b, 0xc6, 0x9a, 0x73, 0xf9, 0x61, 0x70, 0xee, 0x66, 0xb0, 0xee, 0x66	/* t__pfx_test_aperfmperf */
	.byte 0x0b, 0x74, 0x9a, 0x73, 0xf9, 0x61, 0x70, 0xee, 0x66, 0xb0, 0xee, 0x66	/* ttest_aperfmperf */
	.byte 0x08, 0xc6, 0x9a, 0x73, 0xf9, 0x70, 0x74, 0x73, 0x63	/* t__pfx_test_ptsc */
	.byte 0x08, 0x74, 0x9a, 0x73, 0xf9, 0x70, 0x74, 0x73, 0x63	/* ttest_ptsc */
	.byte 0x08, 0xc6, 0x9a, 0x73, 0xf9, 0xa7, 0x70, 0xee, 0x66	/* t__pfx_test_irperf */
	.byte 0x08, 0x74, 0x9a, 0x73, 0xf9, 0xa7, 0x70, 0xee, 0x66	/* ttest_irperf */
	.byte 0x0a, 0xc6, 0x9a, 0x73, 0xf9, 0x15, 0xee, 0x6d, 0x2a, 0xe9, 0x5d	/* t__pfx_test_therm_status */
	.byte 0x0a, 0x74, 0x9a, 0x73, 0xf9, 0x15, 0xee, 0x6d, 0x2a, 0xe9, 0x5d	/* ttest_therm_status */
	.byte 0x07, 0xc6, 0x9a, 0x73, 0xf9, 0xf0, 0x9a, 0x6c	/* t__pfx_test_intel */
	.byte 0x07, 0x74, 0x9a, 0x73, 0xf9, 0xf0, 0x9a, 0x6c	/* ttest_intel */
	.byte 0x06, 0xc6, 0x20, 0x72, 0x5f, 0xaf, 0x8d	/* t__pfx_msr_event_init */
	.byte 0x06, 0x74, 0x20, 0x72, 0x5f, 0xaf, 0x8d	/* tmsr_event_init */
	.byte 0x04, 0xc6, 0xaf, 0x73, 0x26	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xaf, 0x73, 0x26	/* tevent_show */
	.byte 0x0f, 0xc6, 0x20, 0x72, 0x5f, 0xf8, 0x05, 0xfe, 0xd4, 0x74, 0xee, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_msr_read_counter.isra.0 */
	.byte 0x0f, 0x74, 0x20, 0x72, 0x5f, 0xf8, 0x05, 0xfe, 0xd4, 0x74, 0xee, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tmsr_read_counter.isra.0 */
	.byte 0x08, 0xc6, 0x20, 0x72, 0x5f, 0xaf, 0xb9, 0x64, 0x86	/* t__pfx_msr_event_update */
	.byte 0x08, 0x74, 0x20, 0x72, 0x5f, 0xaf, 0xb9, 0x64, 0x86	/* tmsr_event_update */
	.byte 0x07, 0xc6, 0x20, 0x72, 0x5f, 0xaf, 0xe6, 0x6c	/* t__pfx_msr_event_del */
	.byte 0x07, 0x74, 0x20, 0x72, 0x5f, 0xaf, 0xe6, 0x6c	/* tmsr_event_del */
	.byte 0x07, 0xc6, 0x20, 0x72, 0x5f, 0xaf, 0xd6, 0x81	/* t__pfx_msr_event_stop */
	.byte 0x07, 0x74, 0x20, 0x72, 0x5f, 0xaf, 0xd6, 0x81	/* tmsr_event_stop */
	.byte 0x09, 0xc6, 0x20, 0x72, 0x5f, 0xaf, 0x73, 0xdb, 0x72, 0x74	/* t__pfx_msr_event_start */
	.byte 0x09, 0x74, 0x20, 0x72, 0x5f, 0xaf, 0x73, 0xdb, 0x72, 0x74	/* tmsr_event_start */
	.byte 0x06, 0xc6, 0x20, 0x72, 0x5f, 0xaf, 0x10	/* t__pfx_msr_event_add */
	.byte 0x06, 0x74, 0x20, 0x72, 0x5f, 0xaf, 0x10	/* tmsr_event_add */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* t__pfx_paravirt_read_msr */
	.byte 0x0a, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* tparavirt_read_msr */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72	/* t__pfx_paravirt_write_msr */
	.byte 0x0a, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72	/* tparavirt_write_msr */
	.byte 0x0f, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x6e, 0x75, 0xcd, 0xfe, 0xd4, 0x74, 0xee, 0x73	/* t__pfx_x86_pmu_num_counters */
	.byte 0x0f, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x6e, 0x75, 0xcd, 0xfe, 0xd4, 0x74, 0xee, 0x73	/* tx86_pmu_num_counters */
	.byte 0x09, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xaf, 0x0a	/* t__pfx_intel_pmu_event_map */
	.byte 0x09, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xaf, 0x0a	/* tintel_pmu_event_map */
	.byte 0x0e, 0x29, 0x5f, 0xa3, 0xc3, 0xb9, 0x64, 0xa1, 0xac, 0x70, 0xa9, 0x77, 0x7c, 0xbc, 0x1e	/* t__pfx___icl_update_topdown_event */
	.byte 0x0e, 0x74, 0xff, 0xa3, 0xc3, 0xb9, 0x64, 0xa1, 0xac, 0x70, 0xa9, 0x77, 0x7c, 0xbc, 0x1e	/* t__icl_update_topdown_event */
	.byte 0x14, 0x29, 0x5f, 0xf0, 0x9a, 0x6c, 0xf6, 0x68, 0x61, 0xf8, 0xe5, 0xf8, 0xa6, 0xb2, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx___intel_shared_reg_get_constraints */
	.byte 0x14, 0x74, 0xff, 0xf0, 0x9a, 0x6c, 0xf6, 0x68, 0x61, 0xf8, 0xe5, 0xf8, 0xa6, 0xb2, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__intel_shared_reg_get_constraints */
	.byte 0x15, 0x29, 0x5f, 0xf0, 0x9a, 0x6c, 0xf6, 0x68, 0x61, 0xf8, 0xe5, 0x9f, 0xe7, 0x75, 0xf9, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx___intel_shared_reg_put_constraints */
	.byte 0x15, 0x74, 0xff, 0xf0, 0x9a, 0x6c, 0xf6, 0x68, 0x61, 0xf8, 0xe5, 0x9f, 0xe7, 0x75, 0xf9, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__intel_shared_reg_put_constraints */
	.byte 0x10, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x65, 0x62, 0xe0, 0xe1, 0x69, 0x61, 0xc9, 0xe0, 0xfe, 0xf8, 0x32	/* t__pfx_intel_pebs_aliases_core2 */
	.byte 0x10, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x65, 0x62, 0xe0, 0xe1, 0x69, 0x61, 0xc9, 0xe0, 0xfe, 0xf8, 0x32	/* tintel_pebs_aliases_core2 */
	.byte 0x10, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x65, 0x62, 0xe0, 0xe1, 0x69, 0x61, 0xc9, 0x73, 0xf6, 0x6e, 0x62	/* t__pfx_intel_pebs_aliases_snb */
	.byte 0x10, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x65, 0x62, 0xe0, 0xe1, 0x69, 0x61, 0xc9, 0x73, 0xf6, 0x6e, 0x62	/* tintel_pebs_aliases_snb */
	.byte 0x10, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x65, 0x62, 0xe0, 0xe1, 0x69, 0x61, 0xc9, 0xe0, 0x69, 0x76, 0x62	/* t__pfx_intel_pebs_aliases_ivb */
	.byte 0x10, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x65, 0x62, 0xe0, 0xe1, 0x69, 0x61, 0xc9, 0xe0, 0x69, 0x76, 0x62	/* tintel_pebs_aliases_ivb */
	.byte 0x10, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x65, 0x62, 0xe0, 0xe1, 0x69, 0x61, 0xc9, 0x73, 0xf6, 0x6b, 0x6c	/* t__pfx_intel_pebs_aliases_skl */
	.byte 0x10, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x65, 0x62, 0xe0, 0xe1, 0x69, 0x61, 0xc9, 0x73, 0xf6, 0x6b, 0x6c	/* tintel_pebs_aliases_skl */
	.byte 0x0c, 0xc6, 0xf0, 0x9a, 0xc3, 0x67, 0x75, 0x3b, 0xf9, 0xb2, 0x20, 0x72, 0x73	/* t__pfx_intel_guest_get_msrs */
	.byte 0x0c, 0x74, 0xf0, 0x9a, 0xc3, 0x67, 0x75, 0x3b, 0xf9, 0xb2, 0x20, 0x72, 0x73	/* tintel_guest_get_msrs */
	.byte 0x0f, 0xc6, 0xc7, 0xc3, 0xb2, 0x68, 0x79, 0x62, 0x72, 0x69, 0xe5, 0x92, 0x5f, 0x74, 0x27, 0x65	/* t__pfx_adl_get_hybrid_cpu_type */
	.byte 0x0f, 0xdb, 0x64, 0xc3, 0xb2, 0x68, 0x79, 0x62, 0x72, 0x69, 0xe5, 0x92, 0x5f, 0x74, 0x27, 0x65	/* tadl_get_hybrid_cpu_type */
	.byte 0x0c, 0xc6, 0x68, 0x73, 0xaa, 0x6c, 0x69, 0x6d, 0x99, 0x70, 0xee, 0xd9, 0x64	/* t__pfx_hsw_limit_period */
	.byte 0x0b, 0x15, 0x73, 0xaa, 0x6c, 0x69, 0x6d, 0x99, 0x70, 0xee, 0xd9, 0x64	/* thsw_limit_period */
	.byte 0x0c, 0xc6, 0x62, 0x64, 0xaa, 0x6c, 0x69, 0x6d, 0x99, 0x70, 0xee, 0xd9, 0x64	/* t__pfx_bdw_limit_period */
	.byte 0x0c, 0x74, 0x62, 0x64, 0xaa, 0x6c, 0x69, 0x6d, 0x99, 0x70, 0xee, 0xd9, 0x64	/* tbdw_limit_period */
	.byte 0x0c, 0xc6, 0x6e, 0x68, 0xcd, 0x6c, 0x69, 0x6d, 0x99, 0x70, 0xee, 0xd9, 0x64	/* t__pfx_nhm_limit_period */
	.byte 0x0c, 0x74, 0x6e, 0x68, 0xcd, 0x6c, 0x69, 0x6d, 0x99, 0x70, 0xee, 0xd9, 0x64	/* tnhm_limit_period */
	.byte 0x0c, 0xc6, 0x67, 0x6c, 0xd5, 0x6c, 0x69, 0x6d, 0x99, 0x70, 0xee, 0xd9, 0x64	/* t__pfx_glc_limit_period */
	.byte 0x0c, 0x74, 0x67, 0x6c, 0xd5, 0x6c, 0x69, 0x6d, 0x99, 0x70, 0xee, 0xd9, 0x64	/* tglc_limit_period */
	.byte 0x0e, 0xc6, 0xbc, 0x74, 0xc9, 0xc3, 0xd1, 0xf9, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_evtsel_ext_is_visible */
	.byte 0x0e, 0x74, 0xbc, 0x74, 0xc9, 0xc3, 0xd1, 0xf9, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* tevtsel_ext_is_visible */
	.byte 0x0c, 0xc6, 0x6c, 0x62, 0x72, 0x5f, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_lbr_is_visible */
	.byte 0x0c, 0x74, 0x6c, 0x62, 0x72, 0x5f, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* tlbr_is_visible */
	.byte 0x0d, 0xc6, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_default_is_visible */
	.byte 0x0d, 0x74, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* tdefault_is_visible */
	.byte 0x0b, 0xc6, 0x74, 0x73, 0x1a, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_tsx_is_visible */
	.byte 0x0b, 0x74, 0x74, 0x73, 0x1a, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* ttsx_is_visible */
	.byte 0x0a, 0xc6, 0xbd, 0xcd, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_mem_is_visible */
	.byte 0x0a, 0x74, 0xbd, 0xcd, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* tmem_is_visible */
	.byte 0x0b, 0xc6, 0xd1, 0xb5, 0x5f, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_exra_is_visible */
	.byte 0x0b, 0x74, 0xd1, 0xb5, 0x5f, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* texra_is_visible */
	.byte 0x0a, 0xc6, 0x74, 0xe5, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_td_is_visible */
	.byte 0x0a, 0x74, 0x74, 0xe5, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* ttd_is_visible */
	.byte 0x11, 0xc6, 0x68, 0x79, 0x62, 0x72, 0x69, 0xe5, 0xbc, 0x1e, 0xe0, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_hybrid_events_is_visible */
	.byte 0x10, 0x15, 0x79, 0x62, 0x72, 0x69, 0xe5, 0xbc, 0x1e, 0xe0, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* thybrid_events_is_visible */
	.byte 0x10, 0xc6, 0x68, 0x79, 0x62, 0x72, 0x69, 0xe5, 0x74, 0xe5, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_hybrid_td_is_visible */
	.byte 0x0f, 0x15, 0x79, 0x62, 0x72, 0x69, 0xe5, 0x74, 0xe5, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* thybrid_td_is_visible */
	.byte 0x12, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x76, 0x36, 0x5f, 0x10, 0x72, 0x5f, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* t__pfx_intel_pmu_v6_addr_offset */
	.byte 0x12, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x76, 0x36, 0x5f, 0x10, 0x72, 0x5f, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* tintel_pmu_v6_addr_offset */
	.byte 0x0f, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x75, 0xf9, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_intel_put_event_constraints */
	.byte 0x0f, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x75, 0xf9, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* tintel_put_event_constraints */
	.byte 0x0a, 0xc6, 0x64, 0x79, 0x7c, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74	/* t__pfx_dyn_constraint */
	.byte 0x0a, 0x74, 0x64, 0x79, 0x7c, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74	/* tdyn_constraint */
	.byte 0x0d, 0xc6, 0xf0, 0x9a, 0x6c, 0xf6, 0xac, 0x70, 0xf6, 0x7e, 0x64, 0x75, 0x88, 0x67	/* t__pfx_intel_stop_scheduling */
	.byte 0x0d, 0x74, 0xf0, 0x9a, 0x6c, 0xf6, 0xac, 0x70, 0xf6, 0x7e, 0x64, 0x75, 0x88, 0x67	/* tintel_stop_scheduling */
	.byte 0x0e, 0xc6, 0xf0, 0x9a, 0xc3, 0xfe, 0x6d, 0x6d, 0x99, 0x73, 0x7e, 0x64, 0x75, 0x88, 0x67	/* t__pfx_intel_commit_scheduling */
	.byte 0x0e, 0x74, 0xf0, 0x9a, 0xc3, 0xfe, 0x6d, 0x6d, 0x99, 0x73, 0x7e, 0x64, 0x75, 0x88, 0x67	/* tintel_commit_scheduling */
	.byte 0x0e, 0xc6, 0xf0, 0x9a, 0x6c, 0xf6, 0xdb, 0x72, 0xf9, 0x73, 0x7e, 0x64, 0x75, 0x88, 0x67	/* t__pfx_intel_start_scheduling */
	.byte 0x0e, 0x74, 0xf0, 0x9a, 0x6c, 0xf6, 0xdb, 0x72, 0xf9, 0x73, 0x7e, 0x64, 0x75, 0x88, 0x67	/* tintel_start_scheduling */
	.byte 0x0b, 0xbf, 0xf0, 0x9a, 0xc3, 0xaf, 0xc1, 0x73, 0x66, 0x73, 0xf6, 0x26	/* T__pfx_intel_event_sysfs_show */
	.byte 0x0b, 0x54, 0xf0, 0x9a, 0xc3, 0xaf, 0xc1, 0x73, 0x66, 0x73, 0xf6, 0x26	/* Tintel_event_sysfs_show */
	.byte 0x0a, 0xc6, 0x87, 0xfa, 0xd1, 0x63, 0xc3, 0x63, 0x6e, 0xea, 0x73	/* t__pfx_free_excl_cntrs */
	.byte 0x0a, 0x74, 0x87, 0xfa, 0xd1, 0x63, 0xc3, 0x63, 0x6e, 0xea, 0x73	/* tfree_excl_cntrs */
	.byte 0x12, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x7e, 0x63, 0xd8, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_intel_pmu_check_event_constraints */
	.byte 0x12, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x7e, 0x63, 0xd8, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* tintel_pmu_check_event_constraints */
	.byte 0x0b, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xb8, 0x6c, 0x74, 0xee	/* t__pfx_intel_pmu_filter */
	.byte 0x0b, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xb8, 0x6c, 0x74, 0xee	/* tintel_pmu_filter */
	.byte 0x0a, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xb9, 0x64, 0x86	/* t__pfx_intel_pmu_update */
	.byte 0x0a, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xb9, 0x64, 0x86	/* tintel_pmu_update */
	.byte 0x0c, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0x1f, 0x70, 0xee, 0xd9, 0x64	/* t__pfx_intel_pmu_set_period */
	.byte 0x0c, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0x1f, 0x70, 0xee, 0xd9, 0x64	/* tintel_pmu_set_period */
	.byte 0x0f, 0xc6, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0xfe, 0xd4, 0x74, 0xcf, 0x77, 0x89, 0x15, 0xf6, 0x26	/* t__pfx_branch_counter_width_show */
	.byte 0x0f, 0x74, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0xfe, 0xd4, 0x74, 0xcf, 0x77, 0x89, 0x15, 0xf6, 0x26	/* tbranch_counter_width_show */
	.byte 0x08, 0xc6, 0x62, 0x72, 0xcc, 0x7e, 0x73, 0xf6, 0x26	/* t__pfx_branches_show */
	.byte 0x08, 0x74, 0x62, 0x72, 0xcc, 0x7e, 0x73, 0xf6, 0x26	/* tbranches_show */
	.byte 0x0a, 0xa8, 0xf6, 0x26, 0x95, 0x73, 0x7b, 0xc3, 0x74, 0x66, 0x61	/* t__pfx_show_sysctl_tfa */
	.byte 0x0a, 0x74, 0x73, 0x26, 0x95, 0x73, 0x7b, 0xc3, 0x74, 0x66, 0x61	/* tshow_sysctl_tfa */
	.byte 0x10, 0xc6, 0xf0, 0x9a, 0xc3, 0x68, 0x79, 0x62, 0x72, 0x69, 0xe5, 0xb2, 0xe9, 0xea, 0x5f, 0x92, 0x73	/* t__pfx_intel_hybrid_get_attr_cpus */
	.byte 0x10, 0x74, 0xf0, 0x9a, 0xc3, 0x68, 0x79, 0x62, 0x72, 0x69, 0xe5, 0xb2, 0xe9, 0xea, 0x5f, 0x92, 0x73	/* tintel_hybrid_get_attr_cpus */
	.byte 0x0a, 0xc6, 0xb9, 0x64, 0xa1, 0x74, 0x66, 0x61, 0xf6, 0x7e, 0x64	/* t__pfx_update_tfa_sched */
	.byte 0x0a, 0x74, 0xb9, 0x64, 0xa1, 0x74, 0x66, 0x61, 0xf6, 0x7e, 0x64	/* tupdate_tfa_sched */
	.byte 0x09, 0xa8, 0x1f, 0xc1, 0x73, 0x7b, 0xc3, 0x74, 0x66, 0x61	/* t__pfx_set_sysctl_tfa */
	.byte 0x0a, 0x74, 0xc9, 0xf9, 0xc1, 0x73, 0x7b, 0xc3, 0x74, 0x66, 0x61	/* tset_sysctl_tfa */
	.byte 0x09, 0xc6, 0x66, 0x6c, 0x0c, 0xf6, 0x6d, 0xcd, 0x62, 0xe4	/* t__pfx_flip_smm_bit */
	.byte 0x09, 0x74, 0x66, 0x6c, 0x0c, 0xf6, 0x6d, 0xcd, 0x62, 0xe4	/* tflip_smm_bit */
	.byte 0x0d, 0xc6, 0x87, 0x65, 0x7a, 0xfa, 0x6f, 0x6e, 0xf6, 0x6d, 0x69, 0xf6, 0xac, 0xf8	/* t__pfx_freeze_on_smi_store */
	.byte 0x0d, 0x74, 0x87, 0x65, 0x7a, 0xfa, 0x6f, 0x6e, 0xf6, 0x6d, 0x69, 0xf6, 0xac, 0xf8	/* tfreeze_on_smi_store */
	.byte 0x0c, 0xc6, 0x87, 0x65, 0x7a, 0xfa, 0x6f, 0x6e, 0xf6, 0x6d, 0x69, 0xf6, 0x26	/* t__pfx_freeze_on_smi_show */
	.byte 0x0c, 0x74, 0x87, 0x65, 0x7a, 0xfa, 0x6f, 0x6e, 0xf6, 0x6d, 0x69, 0xf6, 0x26	/* tfreeze_on_smi_show */
	.byte 0x0a, 0xa8, 0xf6, 0xb6, 0x6f, 0xe2, 0x72, 0x73, 0x70, 0xf6, 0x26	/* t__pfx_snoop_rsp_show */
	.byte 0x0a, 0x74, 0x73, 0xb6, 0x6f, 0xe2, 0x72, 0x73, 0x70, 0xf6, 0x26	/* tsnoop_rsp_show */
	.byte 0x09, 0xc6, 0x66, 0xde, 0x6e, 0x74, 0xe8, 0x64, 0xf6, 0x26	/* t__pfx_frontend_show */
	.byte 0x09, 0x74, 0x66, 0xde, 0x6e, 0x74, 0xe8, 0x64, 0xf6, 0x26	/* tfrontend_show */
	.byte 0x06, 0xc6, 0x02, 0x1b, 0xf9, 0x73, 0x26	/* t__pfx_ldlat_show */
	.byte 0x06, 0x74, 0x02, 0x1b, 0xf9, 0x73, 0x26	/* tldlat_show */
	.byte 0x0c, 0xc6, 0x6f, 0x66, 0x66, 0xfe, 0x72, 0xfa, 0x72, 0x73, 0x70, 0xf6, 0x26	/* t__pfx_offcore_rsp_show */
	.byte 0x0b, 0xac, 0x66, 0x66, 0xfe, 0x72, 0xfa, 0x72, 0x73, 0x70, 0xf6, 0x26	/* toffcore_rsp_show */
	.byte 0x07, 0xc6, 0x75, 0xdd, 0x16, 0x32, 0xf6, 0x26	/* t__pfx_umask2_show */
	.byte 0x07, 0x74, 0x75, 0xdd, 0x16, 0x32, 0xf6, 0x26	/* tumask2_show */
	.byte 0x05, 0xc6, 0x65, 0x71, 0xf6, 0x26	/* t__pfx_eq_show */
	.byte 0x04, 0x9a, 0x71, 0xf6, 0x26	/* teq_show */
	.byte 0x09, 0xc6, 0xf0, 0x5f, 0x74, 0x1a, 0x63, 0x70, 0xf6, 0x26	/* t__pfx_in_tx_cp_show */
	.byte 0x09, 0x74, 0xf0, 0x5f, 0x74, 0x1a, 0x63, 0x70, 0xf6, 0x26	/* tin_tx_cp_show */
	.byte 0x07, 0xc6, 0xf0, 0x5f, 0x74, 0x78, 0xf6, 0x26	/* t__pfx_in_tx_show */
	.byte 0x07, 0x74, 0xf0, 0x5f, 0x74, 0x78, 0xf6, 0x26	/* tin_tx_show */
	.byte 0x06, 0xc6, 0x63, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx_cmask_show */
	.byte 0x05, 0x2d, 0xdd, 0x16, 0xf6, 0x26	/* tcmask_show */
	.byte 0x05, 0xc6, 0xf0, 0x76, 0xf6, 0x26	/* t__pfx_inv_show */
	.byte 0x05, 0x74, 0xf0, 0x76, 0xf6, 0x26	/* tinv_show */
	.byte 0x05, 0xc6, 0xcc, 0x79, 0xf6, 0x26	/* t__pfx_any_show */
	.byte 0x05, 0xdb, 0x6e, 0x79, 0xf6, 0x26	/* tany_show */
	.byte 0x05, 0xa8, 0xe7, 0x63, 0xf6, 0x26	/* t__pfx_pc_show */
	.byte 0x04, 0x06, 0x63, 0xf6, 0x26	/* tpc_show */
	.byte 0x06, 0xc6, 0x65, 0x64, 0x21, 0x73, 0x26	/* t__pfx_edge_show */
	.byte 0x05, 0x9a, 0x64, 0x21, 0x73, 0x26	/* tedge_show */
	.byte 0x06, 0xc6, 0x75, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx_umask_show */
	.byte 0x06, 0x74, 0x75, 0xdd, 0x16, 0xf6, 0x26	/* tumask_show */
	.byte 0x04, 0xc6, 0xaf, 0x73, 0x26	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xaf, 0x73, 0x26	/* tevent_show */
	.byte 0x0e, 0xc6, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0xfe, 0xd4, 0x74, 0xcf, 0x6e, 0x72, 0xf6, 0x26	/* t__pfx_branch_counter_nr_show */
	.byte 0x0e, 0x74, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0xfe, 0xd4, 0x74, 0xcf, 0x6e, 0x72, 0xf6, 0x26	/* tbranch_counter_nr_show */
	.byte 0x11, 0xc6, 0x68, 0x79, 0x62, 0x72, 0x69, 0xe5, 0x74, 0x73, 0x1a, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_hybrid_tsx_is_visible */
	.byte 0x10, 0x15, 0x79, 0x62, 0x72, 0x69, 0xe5, 0x74, 0x73, 0x1a, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* thybrid_tsx_is_visible */
	.byte 0x10, 0xc6, 0xb9, 0x64, 0xa1, 0x73, 0x61, 0x76, 0x65, 0xe5, 0xac, 0x70, 0xa9, 0x77, 0x7c, 0x9f, 0x73	/* t__pfx_update_saved_topdown_regs */
	.byte 0x10, 0x74, 0xb9, 0x64, 0xa1, 0x73, 0x61, 0x76, 0x65, 0xe5, 0xac, 0x70, 0xa9, 0x77, 0x7c, 0x9f, 0x73	/* tupdate_saved_topdown_regs */
	.byte 0x11, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x61, 0x75, 0x1a, 0x6f, 0x5e, 0xbe, 0xf9, 0x6d, 0xe9, 0xd0	/* t__pfx_intel_pmu_aux_output_match */
	.byte 0x11, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x61, 0x75, 0x1a, 0x6f, 0x5e, 0xbe, 0xf9, 0x6d, 0xe9, 0xd0	/* tintel_pmu_aux_output_match */
	.byte 0x0f, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x13, 0xe2, 0xdb, 0x73, 0xd8, 0x7b, 0x78	/* t__pfx_intel_pmu_swap_task_ctx */
	.byte 0x0f, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x13, 0xe2, 0xdb, 0x73, 0xd8, 0x7b, 0x78	/* tintel_pmu_swap_task_ctx */
	.byte 0x0c, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x7e, 0xe5, 0xdb, 0x16	/* t__pfx_intel_pmu_sched_task */
	.byte 0x0c, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x7e, 0xe5, 0xdb, 0x16	/* tintel_pmu_sched_task */
	.byte 0x0b, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xf8, 0x05, 0xbc, 0x1e	/* t__pfx_intel_pmu_read_event */
	.byte 0x0b, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xf8, 0x05, 0xbc, 0x1e	/* tintel_pmu_read_event */
	.byte 0x0b, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xe6, 0xc3, 0xbc, 0x1e	/* t__pfx_intel_pmu_del_event */
	.byte 0x0b, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xe6, 0xc3, 0xbc, 0x1e	/* tintel_pmu_del_event */
	.byte 0x0b, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xc7, 0xe5, 0xbc, 0x1e	/* t__pfx_intel_pmu_add_event */
	.byte 0x0b, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xc7, 0xe5, 0xbc, 0x1e	/* tintel_pmu_add_event */
	.byte 0x0d, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x92, 0x5f, 0x64, 0x79, 0xf0, 0x67	/* t__pfx_intel_pmu_cpu_dying */
	.byte 0x0d, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x92, 0x5f, 0x64, 0x79, 0xf0, 0x67	/* tintel_pmu_cpu_dying */
	.byte 0x0c, 0xc6, 0xfe, 0x72, 0xfa, 0x70, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_core_pmu_enable_event */
	.byte 0x0c, 0x74, 0xfe, 0x72, 0xfa, 0x70, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* tcore_pmu_enable_event */
	.byte 0x11, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x7e, 0x63, 0xd8, 0xfe, 0xd4, 0x74, 0xee, 0xe0, 0xdd, 0x16	/* t__pfx_intel_pmu_check_counters_mask */
	.byte 0x11, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x7e, 0x63, 0xd8, 0xfe, 0xd4, 0x74, 0xee, 0xe0, 0xdd, 0x16	/* tintel_pmu_check_counters_mask */
	.byte 0x0d, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x96, 0x73, 0x2c, 0x7c, 0xbc, 0x1e	/* t__pfx_intel_pmu_assign_event */
	.byte 0x0d, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x96, 0x73, 0x2c, 0x7c, 0xbc, 0x1e	/* tintel_pmu_assign_event */
	.byte 0x0f, 0xc6, 0xf0, 0x9a, 0x6c, 0xf6, 0x6e, 0xdc, 0x7e, 0x63, 0xd8, 0x6d, 0xa3, 0xde, 0xfe, 0xe6	/* t__pfx_intel_snb_check_microcode */
	.byte 0x0f, 0x74, 0xf0, 0x9a, 0x6c, 0xf6, 0x6e, 0xdc, 0x7e, 0x63, 0xd8, 0x6d, 0xa3, 0xde, 0xfe, 0xe6	/* tintel_snb_check_microcode */
	.byte 0x10, 0xc6, 0xf0, 0x9a, 0xc3, 0x7e, 0x63, 0x6b, 0xe7, 0x65, 0x62, 0xe0, 0xab, 0x7f, 0xe9, 0xd9, 0x6e	/* t__pfx_intel_check_pebs_isolation */
	.byte 0x10, 0x74, 0xf0, 0x9a, 0xc3, 0x7e, 0x63, 0x6b, 0xe7, 0x65, 0x62, 0xe0, 0xab, 0x7f, 0xe9, 0xd9, 0x6e	/* tintel_check_pebs_isolation */
	.byte 0x0e, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x7e, 0x63, 0x6b, 0xe7, 0xee, 0xd9, 0x64	/* t__pfx_intel_pmu_check_period */
	.byte 0x0e, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x7e, 0x63, 0x6b, 0xe7, 0xee, 0xd9, 0x64	/* tintel_pmu_check_period */
	.byte 0x12, 0xc6, 0x68, 0x79, 0x62, 0x72, 0x69, 0xe5, 0x66, 0xce, 0xdd, 0xf9, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_hybrid_format_is_visible */
	.byte 0x11, 0x15, 0x79, 0x62, 0x72, 0x69, 0xe5, 0x66, 0xce, 0xdd, 0xf9, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* thybrid_format_is_visible */
	.byte 0x0d, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x62, 0x74, 0xe0, 0x98, 0xb8, 0x67	/* t__pfx_intel_pmu_bts_config */
	.byte 0x0d, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x62, 0x74, 0xe0, 0x98, 0xb8, 0x67	/* tintel_pmu_bts_config */
	.byte 0x0c, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* t__pfx_intel_pmu_hw_config */
	.byte 0x0c, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* tintel_pmu_hw_config */
	.byte 0x09, 0xc6, 0x68, 0x73, 0xaa, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* t__pfx_hsw_hw_config */
	.byte 0x08, 0x15, 0x73, 0xaa, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* thsw_hw_config */
	.byte 0x08, 0xc6, 0xc7, 0xc3, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* t__pfx_adl_hw_config */
	.byte 0x08, 0xdb, 0x64, 0xc3, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* tadl_hw_config */
	.byte 0x0c, 0xc6, 0xfe, 0x72, 0xfa, 0x70, 0x6d, 0x00, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* t__pfx_core_pmu_hw_config */
	.byte 0x0c, 0x74, 0xfe, 0x72, 0xfa, 0x70, 0x6d, 0x00, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* tcore_pmu_hw_config */
	.byte 0x0c, 0xc6, 0xfe, 0x72, 0xfa, 0x67, 0x75, 0x3b, 0xf9, 0xb2, 0x20, 0x72, 0x73	/* t__pfx_core_guest_get_msrs */
	.byte 0x0c, 0x74, 0xfe, 0x72, 0xfa, 0x67, 0x75, 0x3b, 0xf9, 0xb2, 0x20, 0x72, 0x73	/* tcore_guest_get_msrs */
	.byte 0x0d, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_intel_pmu_disable_all */
	.byte 0x0d, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* tintel_pmu_disable_all */
	.byte 0x08, 0xc6, 0xf0, 0x9a, 0x6c, 0x1f, 0x74, 0x66, 0x61	/* t__pfx_intel_set_tfa */
	.byte 0x08, 0x74, 0xf0, 0x9a, 0x6c, 0x1f, 0x74, 0x66, 0x61	/* tintel_set_tfa */
	.byte 0x12, 0xc6, 0xf0, 0x9a, 0xc3, 0x74, 0x66, 0x61, 0x5f, 0xfe, 0x6d, 0x6d, 0x99, 0x73, 0x7e, 0x64, 0x75, 0x88, 0x67	/* t__pfx_intel_tfa_commit_scheduling */
	.byte 0x12, 0x74, 0xf0, 0x9a, 0xc3, 0x74, 0x66, 0x61, 0x5f, 0xfe, 0x6d, 0x6d, 0x99, 0x73, 0x7e, 0x64, 0x75, 0x88, 0x67	/* tintel_tfa_commit_scheduling */
	.byte 0x12, 0x29, 0x5f, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx___intel_pmu_enable_all.isra.0 */
	.byte 0x12, 0x74, 0xff, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__intel_pmu_enable_all.isra.0 */
	.byte 0x0c, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_intel_pmu_enable_all */
	.byte 0x0c, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* tintel_pmu_enable_all */
	.byte 0x16, 0x29, 0x5f, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0xad, 0xf9, 0x62, 0x72, 0xcc, 0xd0, 0x2a, 0xeb, 0x6b	/* t__pfx___intel_pmu_snapshot_branch_stack */
	.byte 0x16, 0x74, 0xff, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0xad, 0xf9, 0x62, 0x72, 0xcc, 0xd0, 0x2a, 0xeb, 0x6b	/* t__intel_pmu_snapshot_branch_stack */
	.byte 0x18, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0xad, 0xf9, 0xca, 0xd0, 0x5f, 0x62, 0x72, 0xcc, 0xd0, 0x2a, 0xeb, 0x6b	/* t__pfx_intel_pmu_snapshot_arch_branch_stack */
	.byte 0x18, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0xad, 0xf9, 0xca, 0xd0, 0x5f, 0x62, 0x72, 0xcc, 0xd0, 0x2a, 0xeb, 0x6b	/* tintel_pmu_snapshot_arch_branch_stack */
	.byte 0x15, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0xad, 0xf9, 0x62, 0x72, 0xcc, 0xd0, 0x2a, 0xeb, 0x6b	/* t__pfx_intel_pmu_snapshot_branch_stack */
	.byte 0x15, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x6e, 0x61, 0x70, 0x73, 0xad, 0xf9, 0x62, 0x72, 0xcc, 0xd0, 0x2a, 0xeb, 0x6b	/* tintel_pmu_snapshot_branch_stack */
	.byte 0x0f, 0xc6, 0xf0, 0x9a, 0xc3, 0x74, 0x66, 0x61, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_intel_tfa_pmu_enable_all */
	.byte 0x0f, 0x74, 0xf0, 0x9a, 0xc3, 0x74, 0x66, 0x61, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* tintel_tfa_pmu_enable_all */
	.byte 0x0d, 0xc6, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_x86_pmu_disable_event */
	.byte 0x0d, 0x74, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* tx86_pmu_disable_event */
	.byte 0x0f, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6e, 0x68, 0xcd, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_intel_pmu_nhm_enable_all */
	.byte 0x0f, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6e, 0x68, 0xcd, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* tintel_pmu_nhm_enable_all */
	.byte 0x0d, 0x29, 0x5f, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx___x86_pmu_enable_event */
	.byte 0x0d, 0x74, 0xff, 0x78, 0x38, 0x36, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* t__x86_pmu_enable_event */
	.byte 0x0c, 0xc6, 0xfe, 0x72, 0xfa, 0x70, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_core_pmu_enable_all */
	.byte 0x0c, 0x74, 0xfe, 0x72, 0xfa, 0x70, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* tcore_pmu_enable_all */
	.byte 0x0c, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_intel_pmu_enable_event */
	.byte 0x0c, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* tintel_pmu_enable_event */
	.byte 0x0d, 0xc6, 0xa3, 0xc3, 0xb9, 0x64, 0xa1, 0xac, 0x70, 0xa9, 0x77, 0x7c, 0xbc, 0x1e	/* t__pfx_icl_update_topdown_event */
	.byte 0x0d, 0xc2, 0x63, 0xc3, 0xb9, 0x64, 0xa1, 0xac, 0x70, 0xa9, 0x77, 0x7c, 0xbc, 0x1e	/* ticl_update_topdown_event */
	.byte 0x0e, 0xc6, 0xa3, 0x6c, 0x1f, 0xac, 0x70, 0xa9, 0x77, 0x7c, 0xaf, 0x70, 0xee, 0xd9, 0x64	/* t__pfx_icl_set_topdown_event_period */
	.byte 0x0e, 0xc2, 0x63, 0x6c, 0x1f, 0xac, 0x70, 0xa9, 0x77, 0x7c, 0xaf, 0x70, 0xee, 0xd9, 0x64	/* ticl_set_topdown_event_period */
	.byte 0x06, 0xc6, 0x7e, 0x63, 0xd8, 0x20, 0x72	/* t__pfx_check_msr */
	.byte 0x06, 0x74, 0x7e, 0x63, 0xd8, 0x20, 0x72	/* tcheck_msr */
	.byte 0x10, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x7e, 0x63, 0xd8, 0xd1, 0xea, 0x61, 0x5f, 0x9f, 0x73	/* t__pfx_intel_pmu_check_extra_regs */
	.byte 0x10, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x7e, 0x63, 0xd8, 0xd1, 0xea, 0x61, 0x5f, 0x9f, 0x73	/* tintel_pmu_check_extra_regs */
	.byte 0x0d, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_intel_pmu_disable_event */
	.byte 0x0d, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* tintel_pmu_disable_event */
	.byte 0x0e, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x92, 0xf6, 0xdb, 0x72, 0x74, 0xf0, 0x67	/* t__pfx_intel_pmu_cpu_starting */
	.byte 0x0e, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x92, 0xf6, 0xdb, 0x72, 0x74, 0xf0, 0x67	/* tintel_pmu_cpu_starting */
	.byte 0x10, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x61, 0x22, 0xcc, 0xe5, 0x3d, 0xdb, 0x72, 0x74	/* T__pfx_intel_pmu_save_and_restart */
	.byte 0x10, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x61, 0x22, 0xcc, 0xe5, 0x3d, 0xdb, 0x72, 0x74	/* Tintel_pmu_save_and_restart */
	.byte 0x0c, 0xc6, 0x68, 0xcc, 0x64, 0xb3, 0x70, 0x6d, 0xcb, 0xfe, 0x6d, 0xa5, 0x6e	/* t__pfx_handle_pmi_common */
	.byte 0x0b, 0x15, 0xcc, 0x64, 0xb3, 0x70, 0x6d, 0xcb, 0xfe, 0x6d, 0xa5, 0x6e	/* thandle_pmi_common */
	.byte 0x0d, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* t__pfx_intel_pmu_handle_irq */
	.byte 0x0d, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* tintel_pmu_handle_irq */
	.byte 0x0e, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* T__pfx_x86_get_event_constraints */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* Tx86_get_event_constraints */
	.byte 0x0d, 0xc6, 0xf0, 0x9a, 0xc3, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_intel_get_event_constraints */
	.byte 0x0d, 0x74, 0xf0, 0x9a, 0xc3, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* tintel_get_event_constraints */
	.byte 0x0d, 0xc6, 0x63, 0x6d, 0xf9, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_cmt_get_event_constraints */
	.byte 0x0c, 0x2d, 0x6d, 0xf9, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* tcmt_get_event_constraints */
	.byte 0x0d, 0xc6, 0x74, 0x6e, 0xf9, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_tnt_get_event_constraints */
	.byte 0x0d, 0x74, 0x74, 0x6e, 0xf9, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* ttnt_get_event_constraints */
	.byte 0x0d, 0xc6, 0x67, 0x6c, 0xe2, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_glp_get_event_constraints */
	.byte 0x0d, 0x74, 0x67, 0x6c, 0xe2, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* tglp_get_event_constraints */
	.byte 0x0d, 0xc6, 0x68, 0x73, 0xaa, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_hsw_get_event_constraints */
	.byte 0x0c, 0x15, 0x73, 0xaa, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* thsw_get_event_constraints */
	.byte 0x0e, 0xc6, 0x74, 0x66, 0x61, 0x5f, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_tfa_get_event_constraints */
	.byte 0x0e, 0x74, 0x74, 0x66, 0x61, 0x5f, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* ttfa_get_event_constraints */
	.byte 0x0c, 0xc6, 0xa3, 0xc3, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_icl_get_event_constraints */
	.byte 0x0c, 0xc2, 0x63, 0xc3, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* ticl_get_event_constraints */
	.byte 0x0d, 0xc6, 0x67, 0x6c, 0xd5, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_glc_get_event_constraints */
	.byte 0x0d, 0x74, 0x67, 0x6c, 0xd5, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* tglc_get_event_constraints */
	.byte 0x0d, 0xc6, 0x6d, 0x74, 0xc3, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_mtl_get_event_constraints */
	.byte 0x0d, 0x74, 0x6d, 0x74, 0xc3, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* tmtl_get_event_constraints */
	.byte 0x0c, 0xc6, 0xc7, 0xc3, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_adl_get_event_constraints */
	.byte 0x0c, 0xdb, 0x64, 0xc3, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* tadl_get_event_constraints */
	.byte 0x0b, 0xbf, 0xf0, 0x9a, 0xc3, 0x92, 0x63, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* T__pfx_intel_cpuc_prepare */
	.byte 0x0b, 0x54, 0xf0, 0x9a, 0xc3, 0x92, 0x63, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* Tintel_cpuc_prepare */
	.byte 0x0d, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x92, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* t__pfx_intel_pmu_cpu_prepare */
	.byte 0x0d, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x92, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* tintel_pmu_cpu_prepare */
	.byte 0x0a, 0xbf, 0xf0, 0x9a, 0xc3, 0x92, 0xd5, 0x66, 0xf0, 0xab, 0x68	/* T__pfx_intel_cpuc_finish */
	.byte 0x0a, 0x54, 0xf0, 0x9a, 0xc3, 0x92, 0xd5, 0x66, 0xf0, 0xab, 0x68	/* Tintel_cpuc_finish */
	.byte 0x0b, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x92, 0x5f, 0xe6, 0xc7	/* t__pfx_intel_pmu_cpu_dead */
	.byte 0x0b, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x92, 0x5f, 0xe6, 0xc7	/* tintel_pmu_cpu_dead */
	.byte 0x07, 0xc6, 0x62, 0x74, 0xe0, 0xaf, 0xf8, 0xc7	/* t__pfx_bts_event_read */
	.byte 0x07, 0x74, 0x62, 0x74, 0xe0, 0xaf, 0xf8, 0xc7	/* tbts_event_read */
	.byte 0x0a, 0x29, 0x5f, 0x62, 0x74, 0xe0, 0xaf, 0x73, 0xdb, 0x72, 0x74	/* t__pfx___bts_event_start */
	.byte 0x0a, 0x74, 0xff, 0x62, 0x74, 0xe0, 0xaf, 0x73, 0xdb, 0x72, 0x74	/* t__bts_event_start */
	.byte 0x07, 0xc6, 0x62, 0x74, 0xe0, 0xb9, 0x64, 0x86	/* t__pfx_bts_update */
	.byte 0x07, 0x74, 0x62, 0x74, 0xe0, 0xb9, 0x64, 0x86	/* tbts_update */
	.byte 0x07, 0xc6, 0x62, 0x74, 0xe0, 0xaf, 0xd6, 0x81	/* t__pfx_bts_event_stop */
	.byte 0x07, 0x74, 0x62, 0x74, 0xe0, 0xaf, 0xd6, 0x81	/* tbts_event_stop */
	.byte 0x07, 0xc6, 0x62, 0x74, 0xe0, 0xaf, 0xe6, 0x6c	/* t__pfx_bts_event_del */
	.byte 0x07, 0x74, 0x62, 0x74, 0xe0, 0xaf, 0xe6, 0x6c	/* tbts_event_del */
	.byte 0x0b, 0xc6, 0x62, 0x74, 0xe0, 0xa2, 0x66, 0x66, 0xcf, 0xf8, 0xc9, 0x74	/* t__pfx_bts_buffer_reset */
	.byte 0x0b, 0x74, 0x62, 0x74, 0xe0, 0xa2, 0x66, 0x66, 0xcf, 0xf8, 0xc9, 0x74	/* tbts_buffer_reset */
	.byte 0x0d, 0xc6, 0x62, 0x74, 0xe0, 0xa2, 0x66, 0x66, 0xcf, 0x87, 0xfa, 0x61, 0x75, 0x78	/* t__pfx_bts_buffer_free_aux */
	.byte 0x0d, 0x74, 0x62, 0x74, 0xe0, 0xa2, 0x66, 0x66, 0xcf, 0x87, 0xfa, 0x61, 0x75, 0x78	/* tbts_buffer_free_aux */
	.byte 0x0e, 0xc6, 0x62, 0x74, 0xe0, 0xa2, 0x66, 0x66, 0xee, 0xba, 0x74, 0x3a, 0x61, 0x75, 0x78	/* t__pfx_bts_buffer_setup_aux */
	.byte 0x0e, 0x74, 0x62, 0x74, 0xe0, 0xa2, 0x66, 0x66, 0xee, 0xba, 0x74, 0x3a, 0x61, 0x75, 0x78	/* tbts_buffer_setup_aux */
	.byte 0x09, 0xc6, 0x62, 0x74, 0xe0, 0xaf, 0x73, 0xdb, 0x72, 0x74	/* t__pfx_bts_event_start */
	.byte 0x09, 0x74, 0x62, 0x74, 0xe0, 0xaf, 0x73, 0xdb, 0x72, 0x74	/* tbts_event_start */
	.byte 0x06, 0xc6, 0x62, 0x74, 0xe0, 0xaf, 0x10	/* t__pfx_bts_event_add */
	.byte 0x06, 0x74, 0x62, 0x74, 0xe0, 0xaf, 0x10	/* tbts_event_add */
	.byte 0x06, 0xc6, 0x62, 0x74, 0xe0, 0xaf, 0x8d	/* t__pfx_bts_event_init */
	.byte 0x06, 0x74, 0x62, 0x74, 0xe0, 0xaf, 0x8d	/* tbts_event_init */
	.byte 0x0a, 0xc6, 0x62, 0x74, 0xe0, 0xaf, 0xe6, 0x73, 0xea, 0x6f, 0x79	/* t__pfx_bts_event_destroy */
	.byte 0x0a, 0x74, 0x62, 0x74, 0xe0, 0xaf, 0xe6, 0x73, 0xea, 0x6f, 0x79	/* tbts_event_destroy */
	.byte 0x0c, 0xbf, 0xf0, 0x9a, 0xc3, 0x62, 0x74, 0xe0, 0xe8, 0x80, 0xb3, 0xc0, 0xe1	/* T__pfx_intel_bts_enable_local */
	.byte 0x0c, 0x54, 0xf0, 0x9a, 0xc3, 0x62, 0x74, 0xe0, 0xe8, 0x80, 0xb3, 0xc0, 0xe1	/* Tintel_bts_enable_local */
	.byte 0x0d, 0xbf, 0xf0, 0x9a, 0xc3, 0x62, 0x74, 0xe0, 0x64, 0xab, 0x80, 0xb3, 0xc0, 0xe1	/* T__pfx_intel_bts_disable_local */
	.byte 0x0d, 0x54, 0xf0, 0x9a, 0xc3, 0x62, 0x74, 0xe0, 0x64, 0xab, 0x80, 0xb3, 0xc0, 0xe1	/* Tintel_bts_disable_local */
	.byte 0x0d, 0xbf, 0xf0, 0x9a, 0xc3, 0x62, 0x74, 0xe0, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* T__pfx_intel_bts_interrupt */
	.byte 0x0d, 0x54, 0xf0, 0x9a, 0xc3, 0x62, 0x74, 0xe0, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* Tintel_bts_interrupt */
	.byte 0x12, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xb5, 0xf0, 0xe7, 0x65, 0x62, 0xe0, 0xa2, 0x66, 0x66, 0xee	/* t__pfx_intel_pmu_drain_pebs_buffer */
	.byte 0x12, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xb5, 0xf0, 0xe7, 0x65, 0x62, 0xe0, 0xa2, 0x66, 0x66, 0xee	/* tintel_pmu_drain_pebs_buffer */
	.byte 0x0a, 0xc6, 0x64, 0xe0, 0x63, 0xd3, 0xca, 0x5f, 0x63, 0x65, 0x61	/* t__pfx_ds_clear_cea */
	.byte 0x0a, 0x74, 0x64, 0xe0, 0x63, 0xd3, 0xca, 0x5f, 0x63, 0x65, 0x61	/* tds_clear_cea */
	.byte 0x09, 0xc6, 0x64, 0xe0, 0xb9, 0x64, 0xa1, 0x63, 0x65, 0x61	/* t__pfx_ds_update_cea */
	.byte 0x09, 0x74, 0x64, 0xe0, 0xb9, 0x64, 0xa1, 0x63, 0x65, 0x61	/* tds_update_cea */
	.byte 0x0c, 0xc6, 0xf8, 0xd3, 0x96, 0xfa, 0x62, 0x74, 0xe0, 0xa2, 0x66, 0x66, 0xee	/* t__pfx_release_bts_buffer */
	.byte 0x0c, 0x74, 0xf8, 0xd3, 0x96, 0xfa, 0x62, 0x74, 0xe0, 0xa2, 0x66, 0x66, 0xee	/* trelease_bts_buffer */
	.byte 0x08, 0xc6, 0x64, 0x73, 0x87, 0xfa, 0x70, 0x03, 0x73	/* t__pfx_dsfree_pages */
	.byte 0x08, 0x74, 0x64, 0x73, 0x87, 0xfa, 0x70, 0x03, 0x73	/* tdsfree_pages */
	.byte 0x0d, 0xc6, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x65, 0x62, 0xe0, 0xa2, 0x66, 0x66, 0xee	/* t__pfx_release_pebs_buffer */
	.byte 0x0d, 0x74, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x65, 0x62, 0xe0, 0xa2, 0x66, 0x66, 0xee	/* trelease_pebs_buffer */
	.byte 0x0a, 0xa8, 0xe7, 0x65, 0x62, 0xe0, 0xb9, 0x64, 0xa1, 0xd6, 0x86	/* t__pfx_pebs_update_state */
	.byte 0x09, 0x06, 0x65, 0x62, 0xe0, 0xb9, 0x64, 0xa1, 0xd6, 0x86	/* tpebs_update_state */
	.byte 0x0a, 0xa8, 0xba, 0x74, 0xb9, 0xe7, 0x65, 0x62, 0xe0, 0xc2, 0xbd	/* t__pfx_setup_pebs_time */
	.byte 0x0a, 0x74, 0xc9, 0x74, 0xb9, 0xe7, 0x65, 0x62, 0xe0, 0xc2, 0xbd	/* tsetup_pebs_time */
	.byte 0x0f, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0xb8, 0x78, 0x3a, 0x0c	/* t__pfx_intel_pmu_pebs_fixup_ip */
	.byte 0x0f, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0xb8, 0x78, 0x3a, 0x0c	/* tintel_pmu_pebs_fixup_ip */
	.byte 0x18, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x61, 0x22, 0xcc, 0xe5, 0x3d, 0xdb, 0x72, 0xf9, 0xf8, 0xdf, 0xc7, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_intel_pmu_save_and_restart_reload.isra.0 */
	.byte 0x18, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xf6, 0x61, 0x22, 0xcc, 0xe5, 0x3d, 0xdb, 0x72, 0xf9, 0xf8, 0xdf, 0xc7, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tintel_pmu_save_and_restart_reload.isra.0 */
	.byte 0x14, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0xaf, 0xb9, 0x64, 0xa1, 0xb6, 0x5f, 0x64, 0xb5, 0xf0	/* t__pfx_intel_pmu_pebs_event_update_no_drain */
	.byte 0x14, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0xaf, 0xb9, 0x64, 0xa1, 0xb6, 0x5f, 0x64, 0xb5, 0xf0	/* tintel_pmu_pebs_event_update_no_drain */
	.byte 0x11, 0x29, 0x5f, 0x67, 0x72, 0xf9, 0x6c, 0xe9, 0xe8, 0x63, 0xc5, 0x64, 0x0f, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx___grt_latency_data.isra.0 */
	.byte 0x10, 0x74, 0xfd, 0x72, 0xf9, 0x6c, 0xe9, 0xe8, 0x63, 0xc5, 0x64, 0x0f, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__grt_latency_data.isra.0 */
	.byte 0x07, 0xc6, 0xb2, 0x64, 0x0f, 0xf6, 0x72, 0x63	/* t__pfx_get_data_src */
	.byte 0x07, 0x74, 0xb2, 0x64, 0x0f, 0xf6, 0x72, 0x63	/* tget_data_src */
	.byte 0x13, 0xa8, 0xba, 0x74, 0xb9, 0xe7, 0x65, 0x62, 0xe0, 0xc7, 0x61, 0x70, 0xc2, 0x22, 0x73, 0x61, 0xb0, 0xb3, 0x64, 0x0f	/* t__pfx_setup_pebs_adaptive_sample_data */
	.byte 0x13, 0x74, 0xc9, 0x74, 0xb9, 0xe7, 0x65, 0x62, 0xe0, 0xc7, 0x61, 0x70, 0xc2, 0x22, 0x73, 0x61, 0xb0, 0xb3, 0x64, 0x0f	/* tsetup_pebs_adaptive_sample_data */
	.byte 0x08, 0xc6, 0x64, 0x73, 0xe1, 0xc0, 0xe7, 0x03, 0x73	/* t__pfx_dsalloc_pages */
	.byte 0x08, 0x74, 0x64, 0x73, 0xe1, 0xc0, 0xe7, 0x03, 0x73	/* tdsalloc_pages */
	.byte 0x12, 0xa8, 0xba, 0x74, 0xb9, 0xe7, 0x65, 0x62, 0xe0, 0xb8, 0x78, 0x65, 0x64, 0xf6, 0x61, 0xb0, 0xb3, 0x64, 0x0f	/* t__pfx_setup_pebs_fixed_sample_data */
	.byte 0x12, 0x74, 0xc9, 0x74, 0xb9, 0xe7, 0x65, 0x62, 0xe0, 0xb8, 0x78, 0x65, 0x64, 0xf6, 0x61, 0xb0, 0xb3, 0x64, 0x0f	/* tsetup_pebs_fixed_sample_data */
	.byte 0x10, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xb5, 0xf0, 0xe7, 0x65, 0x62, 0xe0, 0xa3, 0x6c	/* t__pfx_intel_pmu_drain_pebs_icl */
	.byte 0x10, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xb5, 0xf0, 0xe7, 0x65, 0x62, 0xe0, 0xa3, 0x6c	/* tintel_pmu_drain_pebs_icl */
	.byte 0x10, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xb5, 0xf0, 0xe7, 0x65, 0x62, 0xe0, 0xfe, 0xf8	/* t__pfx_intel_pmu_drain_pebs_core */
	.byte 0x10, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xb5, 0xf0, 0xe7, 0x65, 0x62, 0xe0, 0xfe, 0xf8	/* tintel_pmu_drain_pebs_core */
	.byte 0x11, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xb5, 0xf0, 0xe7, 0x65, 0x62, 0xe0, 0x6e, 0x68, 0x6d	/* t__pfx_intel_pmu_drain_pebs_nhm */
	.byte 0x11, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xb5, 0xf0, 0xe7, 0x65, 0x62, 0xe0, 0x6e, 0x68, 0x6d	/* tintel_pmu_drain_pebs_nhm */
	.byte 0x0b, 0xbf, 0x67, 0x72, 0xf9, 0x6c, 0xe9, 0xe8, 0x63, 0xc5, 0x64, 0x0f	/* T__pfx_grt_latency_data */
	.byte 0x0b, 0x54, 0x67, 0x72, 0xf9, 0x6c, 0xe9, 0xe8, 0x63, 0xc5, 0x64, 0x0f	/* Tgrt_latency_data */
	.byte 0x0b, 0xbf, 0x63, 0x6d, 0xf9, 0x6c, 0xe9, 0xe8, 0x63, 0xc5, 0x64, 0x0f	/* T__pfx_cmt_latency_data */
	.byte 0x0b, 0x54, 0x63, 0x6d, 0xf9, 0x6c, 0xe9, 0xe8, 0x63, 0xc5, 0x64, 0x0f	/* Tcmt_latency_data */
	.byte 0x0b, 0xbf, 0x6c, 0x6e, 0xc3, 0x6c, 0xe9, 0xe8, 0x63, 0xc5, 0x64, 0x0f	/* T__pfx_lnl_latency_data */
	.byte 0x0b, 0x54, 0x6c, 0x6e, 0xc3, 0x6c, 0xe9, 0xe8, 0x63, 0xc5, 0x64, 0x0f	/* Tlnl_latency_data */
	.byte 0x0c, 0xbf, 0xf0, 0x99, 0xe6, 0xa2, 0x67, 0x2a, 0xce, 0xfa, 0x6f, 0x7c, 0x92	/* T__pfx_init_debug_store_on_cpu */
	.byte 0x0c, 0x54, 0xf0, 0x99, 0xe6, 0xa2, 0x67, 0x2a, 0xce, 0xfa, 0x6f, 0x7c, 0x92	/* Tinit_debug_store_on_cpu */
	.byte 0x0d, 0xbf, 0x66, 0xf0, 0xcb, 0xe6, 0xa2, 0x67, 0x2a, 0xce, 0xfa, 0x6f, 0x7c, 0x92	/* T__pfx_fini_debug_store_on_cpu */
	.byte 0x0d, 0x54, 0x66, 0xf0, 0xcb, 0xe6, 0xa2, 0x67, 0x2a, 0xce, 0xfa, 0x6f, 0x7c, 0x92	/* Tfini_debug_store_on_cpu */
	.byte 0x0c, 0xbf, 0xf8, 0xd3, 0x96, 0xfa, 0x64, 0xe0, 0xa2, 0x66, 0x66, 0xee, 0x73	/* T__pfx_release_ds_buffers */
	.byte 0x0c, 0x54, 0xf8, 0xd3, 0x96, 0xfa, 0x64, 0xe0, 0xa2, 0x66, 0x66, 0xee, 0x73	/* Trelease_ds_buffers */
	.byte 0x0b, 0xbf, 0x3d, 0xee, 0x22, 0x64, 0xe0, 0xa2, 0x66, 0x66, 0xee, 0x73	/* T__pfx_reserve_ds_buffers */
	.byte 0x0b, 0x54, 0x3d, 0xee, 0x22, 0x64, 0xe0, 0xa2, 0x66, 0x66, 0xee, 0x73	/* Treserve_ds_buffers */
	.byte 0x0d, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0x62, 0x74, 0x73	/* T__pfx_intel_pmu_enable_bts */
	.byte 0x0d, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0x62, 0x74, 0x73	/* Tintel_pmu_enable_bts */
	.byte 0x0e, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0x62, 0x74, 0x73	/* T__pfx_intel_pmu_disable_bts */
	.byte 0x0e, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0x62, 0x74, 0x73	/* Tintel_pmu_disable_bts */
	.byte 0x12, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xb5, 0xf0, 0x5f, 0x62, 0x74, 0xe0, 0xa2, 0x66, 0x66, 0xee	/* T__pfx_intel_pmu_drain_bts_buffer */
	.byte 0x12, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x64, 0xb5, 0xf0, 0x5f, 0x62, 0x74, 0xe0, 0xa2, 0x66, 0x66, 0xee	/* Tintel_pmu_drain_bts_buffer */
	.byte 0x0f, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x65, 0x62, 0xe0, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* T__pfx_intel_pebs_constraints */
	.byte 0x0f, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x65, 0x62, 0xe0, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* Tintel_pebs_constraints */
	.byte 0x10, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0x73, 0xf6, 0x7e, 0xe5, 0xdb, 0x16	/* T__pfx_intel_pmu_pebs_sched_task */
	.byte 0x10, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0x73, 0xf6, 0x7e, 0xe5, 0xdb, 0x16	/* Tintel_pmu_pebs_sched_task */
	.byte 0x0c, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0x10	/* T__pfx_intel_pmu_pebs_add */
	.byte 0x0c, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0x10	/* Tintel_pmu_pebs_add */
	.byte 0x0e, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0xe8, 0x80, 0xd3	/* T__pfx_intel_pmu_pebs_enable */
	.byte 0x0e, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0xe8, 0x80, 0xd3	/* Tintel_pmu_pebs_enable */
	.byte 0x0d, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0xe6, 0x6c	/* T__pfx_intel_pmu_pebs_del */
	.byte 0x0d, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0xe6, 0x6c	/* Tintel_pmu_pebs_del */
	.byte 0x0f, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0x64, 0xab, 0x80, 0xd3	/* T__pfx_intel_pmu_pebs_disable */
	.byte 0x0f, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0x64, 0xab, 0x80, 0xd3	/* Tintel_pmu_pebs_disable */
	.byte 0x10, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* T__pfx_intel_pmu_pebs_enable_all */
	.byte 0x10, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* Tintel_pmu_pebs_enable_all */
	.byte 0x11, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* T__pfx_intel_pmu_pebs_disable_all */
	.byte 0x11, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xe7, 0x65, 0x62, 0xe0, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* Tintel_pmu_pebs_disable_all */
	.byte 0x10, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x61, 0x75, 0xac, 0x5f, 0xf8, 0xdf, 0x05, 0xf8, 0xc7	/* T__pfx_intel_pmu_auto_reload_read */
	.byte 0x10, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x61, 0x75, 0xac, 0x5f, 0xf8, 0xdf, 0x05, 0xf8, 0xc7	/* Tintel_pmu_auto_reload_read */
	.byte 0x0e, 0x3f, 0xe7, 0xee, 0xa0, 0xf8, 0xd6, 0xce, 0xfa, 0xe6, 0xa2, 0x67, 0xf6, 0xac, 0xf8	/* T__pfx_perf_restore_debug_store */
	.byte 0x0e, 0x54, 0x70, 0xee, 0xa0, 0xf8, 0xd6, 0xce, 0xfa, 0xe6, 0xa2, 0x67, 0xf6, 0xac, 0xf8	/* Tperf_restore_debug_store */
	.byte 0x09, 0xc6, 0x6b, 0x6e, 0x63, 0xe7, 0x6d, 0x00, 0xaf, 0x0a	/* t__pfx_knc_pmu_event_map */
	.byte 0x09, 0x74, 0x6b, 0x6e, 0x63, 0xe7, 0x6d, 0x00, 0xaf, 0x0a	/* tknc_pmu_event_map */
	.byte 0x06, 0xc6, 0x63, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx_cmask_show */
	.byte 0x05, 0x2d, 0xdd, 0x16, 0xf6, 0x26	/* tcmask_show */
	.byte 0x05, 0xc6, 0xf0, 0x76, 0xf6, 0x26	/* t__pfx_inv_show */
	.byte 0x05, 0x74, 0xf0, 0x76, 0xf6, 0x26	/* tinv_show */
	.byte 0x06, 0xc6, 0x65, 0x64, 0x21, 0x73, 0x26	/* t__pfx_edge_show */
	.byte 0x05, 0x9a, 0x64, 0x21, 0x73, 0x26	/* tedge_show */
	.byte 0x06, 0xc6, 0x75, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx_umask_show */
	.byte 0x06, 0x74, 0x75, 0xdd, 0x16, 0xf6, 0x26	/* tumask_show */
	.byte 0x04, 0xc6, 0xaf, 0x73, 0x26	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xaf, 0x73, 0x26	/* tevent_show */
	.byte 0x0d, 0xc6, 0x6b, 0x6e, 0x63, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_knc_pmu_disable_event */
	.byte 0x0d, 0x74, 0x6b, 0x6e, 0x63, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* tknc_pmu_disable_event */
	.byte 0x0c, 0xc6, 0x6b, 0x6e, 0x63, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_knc_pmu_enable_event */
	.byte 0x0c, 0x74, 0x6b, 0x6e, 0x63, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* tknc_pmu_enable_event */
	.byte 0x0d, 0xc6, 0x6b, 0x6e, 0x63, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_knc_pmu_disable_all */
	.byte 0x0d, 0x74, 0x6b, 0x6e, 0x63, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* tknc_pmu_disable_all */
	.byte 0x0c, 0xc6, 0x6b, 0x6e, 0x63, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_knc_pmu_enable_all */
	.byte 0x0c, 0x74, 0x6b, 0x6e, 0x63, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* tknc_pmu_enable_all */
	.byte 0x0d, 0xc6, 0x6b, 0x6e, 0x63, 0xe7, 0x6d, 0x00, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* t__pfx_knc_pmu_handle_irq */
	.byte 0x0d, 0x74, 0x6b, 0x6e, 0x63, 0xe7, 0x6d, 0x00, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* tknc_pmu_handle_irq */
	.byte 0x0b, 0xbf, 0x78, 0x38, 0x36, 0xe7, 0xee, 0xa0, 0xb2, 0x6c, 0x62, 0x72	/* T__pfx_x86_perf_get_lbr */
	.byte 0x0b, 0x54, 0x78, 0x38, 0x36, 0xe7, 0xee, 0xa0, 0xb2, 0x6c, 0x62, 0x72	/* Tx86_perf_get_lbr */
	.byte 0x0f, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xb8, 0x6c, 0x74, 0xee	/* t__pfx_intel_pmu_lbr_filter */
	.byte 0x0f, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xb8, 0x6c, 0x74, 0xee	/* tintel_pmu_lbr_filter */
	.byte 0x13, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0x78, 0x73, 0x61, 0x76, 0x3b	/* t__pfx_intel_pmu_arch_lbr_xsaves */
	.byte 0x13, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0x78, 0x73, 0x61, 0x76, 0x3b	/* tintel_pmu_arch_lbr_xsaves */
	.byte 0x13, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0x78, 0x72, 0xd6, 0xce, 0x73	/* t__pfx_intel_pmu_arch_lbr_xrstors */
	.byte 0x13, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0x78, 0x72, 0xd6, 0xce, 0x73	/* tintel_pmu_arch_lbr_xrstors */
	.byte 0x13, 0x29, 0x5f, 0x6b, 0xbd, 0xcd, 0x63, 0xeb, 0x68, 0xfa, 0x63, 0xf8, 0x86, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx___kmem_cache_create.constprop.0 */
	.byte 0x12, 0x74, 0xae, 0xbd, 0xcd, 0x63, 0xeb, 0x68, 0xfa, 0x63, 0xf8, 0x86, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__kmem_cache_create.constprop.0 */
	.byte 0x19, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xfe, 0xd4, 0x74, 0xee, 0xe0, 0xf8, 0xce, 0x64, 0xee, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_intel_pmu_lbr_counters_reorder.isra.0 */
	.byte 0x19, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xfe, 0xd4, 0x74, 0xee, 0xe0, 0xf8, 0xce, 0x64, 0xee, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tintel_pmu_lbr_counters_reorder.isra.0 */
	.byte 0x11, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc9, 0x74	/* t__pfx_intel_pmu_arch_lbr_reset */
	.byte 0x11, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc9, 0x74	/* tintel_pmu_arch_lbr_reset */
	.byte 0x11, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0x61, 0x76, 0x65	/* t__pfx_intel_pmu_arch_lbr_save */
	.byte 0x11, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0xf6, 0x61, 0x76, 0x65	/* tintel_pmu_arch_lbr_save */
	.byte 0x0d, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0x2a, 0xce, 0xfa, 0x6c, 0x62, 0x72	/* t__pfx_intel_pmu_store_lbr */
	.byte 0x0d, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0x2a, 0xce, 0xfa, 0x6c, 0x62, 0x72	/* tintel_pmu_store_lbr */
	.byte 0x15, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0x05, 0x78, 0x73, 0x61, 0x76, 0x65	/* t__pfx_intel_pmu_arch_lbr_read_xsave */
	.byte 0x15, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0x05, 0x78, 0x73, 0x61, 0x76, 0x65	/* tintel_pmu_arch_lbr_read_xsave */
	.byte 0x10, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc7	/* t__pfx_intel_pmu_arch_lbr_read */
	.byte 0x10, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc7	/* tintel_pmu_arch_lbr_read */
	.byte 0x12, 0xc6, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xd6, 0x6f, 0xf8	/* t__pfx_intel_pmu_arch_lbr_restore */
	.byte 0x12, 0x74, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0xca, 0xd0, 0x5f, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xd6, 0x6f, 0xf8	/* tintel_pmu_arch_lbr_restore */
	.byte 0x10, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc9, 0xf9, 0x33, 0x32	/* T__pfx_intel_pmu_lbr_reset_32 */
	.byte 0x10, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc9, 0xf9, 0x33, 0x32	/* Tintel_pmu_lbr_reset_32 */
	.byte 0x10, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc9, 0xf9, 0x36, 0x34	/* T__pfx_intel_pmu_lbr_reset_64 */
	.byte 0x10, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc9, 0xf9, 0x36, 0x34	/* Tintel_pmu_lbr_reset_64 */
	.byte 0x0e, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc9, 0x74	/* T__pfx_intel_pmu_lbr_reset */
	.byte 0x0e, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc9, 0x74	/* Tintel_pmu_lbr_reset */
	.byte 0x12, 0xbf, 0x6c, 0x62, 0x72, 0x5f, 0x66, 0xde, 0x6d, 0xf6, 0x2c, 0x6e, 0xd1, 0xf9, 0x8e, 0xa7, 0xd8, 0x77, 0x72	/* T__pfx_lbr_from_signext_quirk_wr */
	.byte 0x12, 0x54, 0x6c, 0x62, 0x72, 0x5f, 0x66, 0xde, 0x6d, 0xf6, 0x2c, 0x6e, 0xd1, 0xf9, 0x8e, 0xa7, 0xd8, 0x77, 0x72	/* Tlbr_from_signext_quirk_wr */
	.byte 0x0f, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xd6, 0x6f, 0xf8	/* T__pfx_intel_pmu_lbr_restore */
	.byte 0x0f, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xd6, 0x6f, 0xf8	/* Tintel_pmu_lbr_restore */
	.byte 0x0e, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0xf6, 0x61, 0x76, 0x65	/* T__pfx_intel_pmu_lbr_save */
	.byte 0x0e, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0xf6, 0x61, 0x76, 0x65	/* Tintel_pmu_lbr_save */
	.byte 0x12, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0xf6, 0x13, 0xe2, 0xdb, 0x73, 0xd8, 0x7b, 0x78	/* T__pfx_intel_pmu_lbr_swap_task_ctx */
	.byte 0x12, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0xf6, 0x13, 0xe2, 0xdb, 0x73, 0xd8, 0x7b, 0x78	/* Tintel_pmu_lbr_swap_task_ctx */
	.byte 0x0f, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0xf6, 0x7e, 0xe5, 0xdb, 0x16	/* T__pfx_intel_pmu_lbr_sched_task */
	.byte 0x0f, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0xf6, 0x7e, 0xe5, 0xdb, 0x16	/* Tintel_pmu_lbr_sched_task */
	.byte 0x0c, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0x10	/* T__pfx_intel_pmu_lbr_add */
	.byte 0x0c, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0x10	/* Tintel_pmu_lbr_add */
	.byte 0x0e, 0xbf, 0xf8, 0xd3, 0x96, 0xfa, 0x6c, 0x62, 0x72, 0x5f, 0xa2, 0x66, 0x66, 0xee, 0x73	/* T__pfx_release_lbr_buffers */
	.byte 0x0e, 0x54, 0xf8, 0xd3, 0x96, 0xfa, 0x6c, 0x62, 0x72, 0x5f, 0xa2, 0x66, 0x66, 0xee, 0x73	/* Trelease_lbr_buffers */
	.byte 0x0d, 0xbf, 0x3d, 0xee, 0x22, 0x6c, 0x62, 0x72, 0x5f, 0xa2, 0x66, 0x66, 0xee, 0x73	/* T__pfx_reserve_lbr_buffers */
	.byte 0x0d, 0x54, 0x3d, 0xee, 0x22, 0x6c, 0x62, 0x72, 0x5f, 0xa2, 0x66, 0x66, 0xee, 0x73	/* Treserve_lbr_buffers */
	.byte 0x0d, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xe6, 0x6c	/* T__pfx_intel_pmu_lbr_del */
	.byte 0x0d, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xe6, 0x6c	/* Tintel_pmu_lbr_del */
	.byte 0x10, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* T__pfx_intel_pmu_lbr_enable_all */
	.byte 0x10, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* Tintel_pmu_lbr_enable_all */
	.byte 0x11, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* T__pfx_intel_pmu_lbr_disable_all */
	.byte 0x11, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* Tintel_pmu_lbr_disable_all */
	.byte 0x0f, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0x05, 0x33, 0x32	/* T__pfx_intel_pmu_lbr_read_32 */
	.byte 0x0f, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0x05, 0x33, 0x32	/* Tintel_pmu_lbr_read_32 */
	.byte 0x0f, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0x05, 0x36, 0x34	/* T__pfx_intel_pmu_lbr_read_64 */
	.byte 0x0f, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0x05, 0x36, 0x34	/* Tintel_pmu_lbr_read_64 */
	.byte 0x12, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0xf6, 0x61, 0x22, 0x62, 0x72, 0xd6, 0xeb, 0x6b	/* T__pfx_intel_pmu_lbr_save_brstack */
	.byte 0x12, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0xf6, 0x61, 0x22, 0x62, 0x72, 0xd6, 0xeb, 0x6b	/* Tintel_pmu_lbr_save_brstack */
	.byte 0x0d, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc7	/* T__pfx_intel_pmu_lbr_read */
	.byte 0x0d, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf8, 0xc7	/* Tintel_pmu_lbr_read */
	.byte 0x12, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xba, 0x74, 0x3a, 0x6c, 0x62, 0x72, 0x5f, 0xb8, 0x6c, 0x74, 0xee	/* T__pfx_intel_pmu_setup_lbr_filter */
	.byte 0x12, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0xba, 0x74, 0x3a, 0x6c, 0x62, 0x72, 0x5f, 0xb8, 0x6c, 0x74, 0xee	/* Tintel_pmu_setup_lbr_filter */
	.byte 0x12, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0x2a, 0xce, 0xfa, 0x70, 0x65, 0x62, 0xe0, 0x6c, 0x62, 0x72, 0x73	/* T__pfx_intel_pmu_store_pebs_lbrs */
	.byte 0x12, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x75, 0x2a, 0xce, 0xfa, 0x70, 0x65, 0x62, 0xe0, 0x6c, 0x62, 0x72, 0x73	/* Tintel_pmu_store_pebs_lbrs */
	.byte 0x10, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf0, 0x99, 0x68, 0x73, 0x77	/* T__pfx_intel_pmu_lbr_init_hsw */
	.byte 0x10, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf0, 0x99, 0x68, 0x73, 0x77	/* Tintel_pmu_lbr_init_hsw */
	.byte 0x10, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf0, 0x99, 0x6b, 0x6e, 0x6c	/* T__pfx_intel_pmu_lbr_init_knl */
	.byte 0x10, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0xf0, 0x99, 0x6b, 0x6e, 0x6c	/* Tintel_pmu_lbr_init_knl */
	.byte 0x0c, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0x8d	/* T__pfx_intel_pmu_lbr_init */
	.byte 0x0c, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0x6d, 0x00, 0x6c, 0x62, 0x72, 0x5f, 0x8d	/* Tintel_pmu_lbr_init */
	.byte 0x08, 0xa8, 0xe7, 0x34, 0xe7, 0x6d, 0x00, 0xaf, 0x0a	/* t__pfx_p4_pmu_event_map */
	.byte 0x07, 0x06, 0x34, 0xe7, 0x6d, 0x00, 0xaf, 0x0a	/* tp4_pmu_event_map */
	.byte 0x05, 0xc6, 0x68, 0xf9, 0x73, 0x26	/* t__pfx_ht_show */
	.byte 0x04, 0x15, 0xf9, 0x73, 0x26	/* tht_show */
	.byte 0x06, 0xc6, 0x3b, 0x63, 0x72, 0xf6, 0x26	/* t__pfx_escr_show */
	.byte 0x06, 0x9a, 0x73, 0x63, 0x72, 0xf6, 0x26	/* tescr_show */
	.byte 0x07, 0xc6, 0x63, 0x63, 0x63, 0x72, 0xf6, 0x26	/* t__pfx_cccr_show */
	.byte 0x06, 0x2d, 0x63, 0x63, 0x72, 0xf6, 0x26	/* tcccr_show */
	.byte 0x0b, 0xa8, 0xe7, 0x34, 0xe7, 0x6d, 0x75, 0x1f, 0x70, 0xee, 0xd9, 0x64	/* t__pfx_p4_pmu_set_period */
	.byte 0x0a, 0x06, 0x34, 0xe7, 0x6d, 0x75, 0x1f, 0x70, 0xee, 0xd9, 0x64	/* tp4_pmu_set_period */
	.byte 0x0c, 0xa8, 0xe7, 0x34, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_p4_pmu_disable_event */
	.byte 0x0b, 0x06, 0x34, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* tp4_pmu_disable_event */
	.byte 0x0c, 0xa8, 0xe7, 0x34, 0xe7, 0x6d, 0x00, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* t__pfx_p4_pmu_handle_irq */
	.byte 0x0b, 0x06, 0x34, 0xe7, 0x6d, 0x00, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* tp4_pmu_handle_irq */
	.byte 0x0c, 0xa8, 0xe7, 0x34, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_p4_pmu_disable_all */
	.byte 0x0b, 0x06, 0x34, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* tp4_pmu_disable_all */
	.byte 0x0b, 0x29, 0xe7, 0x34, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx___p4_pmu_enable_event */
	.byte 0x0c, 0x74, 0xff, 0x70, 0x34, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* t__p4_pmu_enable_event */
	.byte 0x0b, 0xa8, 0xe7, 0x34, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_p4_pmu_enable_all */
	.byte 0x0a, 0x06, 0x34, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* tp4_pmu_enable_all */
	.byte 0x0b, 0xa8, 0xe7, 0x34, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_p4_pmu_enable_event */
	.byte 0x0a, 0x06, 0x34, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* tp4_pmu_enable_event */
	.byte 0x08, 0xa8, 0xe7, 0x5c, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* t__pfx_p4_hw_config */
	.byte 0x07, 0x06, 0x5c, 0x68, 0xaa, 0x98, 0xb8, 0x67	/* tp4_hw_config */
	.byte 0x0e, 0xa8, 0xe7, 0x34, 0xe7, 0x6d, 0x75, 0xf6, 0x7e, 0x64, 0x75, 0xb3, 0xbc, 0x1e, 0x73	/* t__pfx_p4_pmu_schedule_events */
	.byte 0x0d, 0x06, 0x34, 0xe7, 0x6d, 0x75, 0xf6, 0x7e, 0x64, 0x75, 0xb3, 0xbc, 0x1e, 0x73	/* tp4_pmu_schedule_events */
	.byte 0x08, 0xa8, 0xe7, 0x36, 0xe7, 0x6d, 0x00, 0xaf, 0x0a	/* t__pfx_p6_pmu_event_map */
	.byte 0x07, 0x06, 0x36, 0xe7, 0x6d, 0x00, 0xaf, 0x0a	/* tp6_pmu_event_map */
	.byte 0x06, 0xc6, 0x63, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx_cmask_show */
	.byte 0x05, 0x2d, 0xdd, 0x16, 0xf6, 0x26	/* tcmask_show */
	.byte 0x05, 0xc6, 0xf0, 0x76, 0xf6, 0x26	/* t__pfx_inv_show */
	.byte 0x05, 0x74, 0xf0, 0x76, 0xf6, 0x26	/* tinv_show */
	.byte 0x05, 0xa8, 0xe7, 0x63, 0xf6, 0x26	/* t__pfx_pc_show */
	.byte 0x04, 0x06, 0x63, 0xf6, 0x26	/* tpc_show */
	.byte 0x06, 0xc6, 0x65, 0x64, 0x21, 0x73, 0x26	/* t__pfx_edge_show */
	.byte 0x05, 0x9a, 0x64, 0x21, 0x73, 0x26	/* tedge_show */
	.byte 0x06, 0xc6, 0x75, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx_umask_show */
	.byte 0x06, 0x74, 0x75, 0xdd, 0x16, 0xf6, 0x26	/* tumask_show */
	.byte 0x04, 0xc6, 0xaf, 0x73, 0x26	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xaf, 0x73, 0x26	/* tevent_show */
	.byte 0x0b, 0xa8, 0xe7, 0x36, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_p6_pmu_enable_event */
	.byte 0x0a, 0x06, 0x36, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* tp6_pmu_enable_event */
	.byte 0x0c, 0xa8, 0xe7, 0x36, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_p6_pmu_disable_event */
	.byte 0x0b, 0x06, 0x36, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* tp6_pmu_disable_event */
	.byte 0x0b, 0xa8, 0xe7, 0x36, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_p6_pmu_enable_all */
	.byte 0x0a, 0x06, 0x36, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* tp6_pmu_enable_all */
	.byte 0x0c, 0xa8, 0xe7, 0x36, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_p6_pmu_disable_all */
	.byte 0x0b, 0x06, 0x36, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* tp6_pmu_disable_all */
	.byte 0x0f, 0xa8, 0xe7, 0xf9, 0xaf, 0x10, 0x72, 0x5f, 0xb8, 0x6c, 0x74, 0xee, 0x73, 0x95, 0x6e, 0x63	/* t__pfx_pt_event_addr_filters_sync */
	.byte 0x0e, 0x06, 0xf9, 0xaf, 0x10, 0x72, 0x5f, 0xb8, 0x6c, 0x74, 0xee, 0x73, 0x95, 0x6e, 0x63	/* tpt_event_addr_filters_sync */
	.byte 0x06, 0xa8, 0xe7, 0xf9, 0xaf, 0xf8, 0xc7	/* t__pfx_pt_event_read */
	.byte 0x05, 0x06, 0xf9, 0xaf, 0xf8, 0xc7	/* tpt_event_read */
	.byte 0x0d, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0xf9, 0x76, 0xe1, 0x89, 0xa1, 0x63, 0x61, 0x70	/* T__pfx_intel_pt_validate_cap */
	.byte 0x0d, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0xf9, 0x76, 0xe1, 0x89, 0xa1, 0x63, 0x61, 0x70	/* Tintel_pt_validate_cap */
	.byte 0x0d, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0xf9, 0x68, 0xcc, 0x64, 0xb3, 0x76, 0x6d, 0x78	/* T__pfx_intel_pt_handle_vmx */
	.byte 0x0d, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0xf9, 0x68, 0xcc, 0x64, 0xb3, 0x76, 0x6d, 0x78	/* Tintel_pt_handle_vmx */
	.byte 0x0e, 0xa8, 0xe7, 0xf9, 0xac, 0x70, 0x61, 0x5f, 0xe8, 0xea, 0xc5, 0x66, 0xce, 0xe7, 0x03	/* t__pfx_pt_topa_entry_for_page */
	.byte 0x0d, 0x06, 0xf9, 0xac, 0x70, 0x61, 0x5f, 0xe8, 0xea, 0xc5, 0x66, 0xce, 0xe7, 0x03	/* tpt_topa_entry_for_page */
	.byte 0x10, 0xa8, 0xe7, 0xf9, 0xa2, 0x66, 0x66, 0xcf, 0xf8, 0xc9, 0xf9, 0x6f, 0x66, 0x66, 0xc9, 0x74, 0x73	/* t__pfx_pt_buffer_reset_offsets */
	.byte 0x0f, 0x06, 0xf9, 0xa2, 0x66, 0x66, 0xcf, 0xf8, 0xc9, 0xf9, 0x6f, 0x66, 0x66, 0xc9, 0x74, 0x73	/* tpt_buffer_reset_offsets */
	.byte 0x09, 0xa8, 0xe7, 0xf9, 0xb9, 0x64, 0xa1, 0x68, 0x65, 0xc7	/* t__pfx_pt_update_head */
	.byte 0x08, 0x06, 0xf9, 0xb9, 0x64, 0xa1, 0x68, 0x65, 0xc7	/* tpt_update_head */
	.byte 0x0d, 0xa8, 0xe7, 0xf9, 0xa2, 0x66, 0x66, 0xcf, 0x66, 0xf0, 0xcb, 0xac, 0x70, 0x61	/* t__pfx_pt_buffer_fini_topa */
	.byte 0x0c, 0x06, 0xf9, 0xa2, 0x66, 0x66, 0xcf, 0x66, 0xf0, 0xcb, 0xac, 0x70, 0x61	/* tpt_buffer_fini_topa */
	.byte 0x0c, 0xa8, 0xe7, 0xf9, 0xa2, 0x66, 0x66, 0xcf, 0x87, 0xfa, 0x61, 0x75, 0x78	/* t__pfx_pt_buffer_free_aux */
	.byte 0x0b, 0x06, 0xf9, 0xa2, 0x66, 0x66, 0xcf, 0x87, 0xfa, 0x61, 0x75, 0x78	/* tpt_buffer_free_aux */
	.byte 0x09, 0xa8, 0xe7, 0xf9, 0xaf, 0xe6, 0x73, 0xea, 0x6f, 0x79	/* t__pfx_pt_event_destroy */
	.byte 0x08, 0x06, 0xf9, 0xaf, 0xe6, 0x73, 0xea, 0x6f, 0x79	/* tpt_event_destroy */
	.byte 0x0b, 0xa8, 0xe7, 0xf9, 0xc2, 0x6d, 0xf0, 0xa6, 0xe9, 0xea, 0xf6, 0x26	/* t__pfx_pt_timing_attr_show */
	.byte 0x0a, 0x06, 0xf9, 0xc2, 0x6d, 0xf0, 0xa6, 0xe9, 0xea, 0xf6, 0x26	/* tpt_timing_attr_show */
	.byte 0x0a, 0xa8, 0xe7, 0x73, 0x62, 0xe7, 0xee, 0xd9, 0x64, 0xf6, 0x26	/* t__pfx_psb_period_show */
	.byte 0x09, 0x06, 0x73, 0x62, 0xe7, 0xee, 0xd9, 0x64, 0xf6, 0x26	/* tpsb_period_show */
	.byte 0x09, 0xc6, 0x63, 0x79, 0xd5, 0x15, 0x3d, 0x68, 0xf6, 0x26	/* t__pfx_cyc_thresh_show */
	.byte 0x08, 0x2d, 0x79, 0xd5, 0x15, 0x3d, 0x68, 0xf6, 0x26	/* tcyc_thresh_show */
	.byte 0x09, 0xc6, 0x6d, 0x2d, 0xe7, 0xee, 0xd9, 0x64, 0xf6, 0x26	/* t__pfx_mtc_period_show */
	.byte 0x09, 0x74, 0x6d, 0x2d, 0xe7, 0xee, 0xd9, 0x64, 0xf6, 0x26	/* tmtc_period_show */
	.byte 0x07, 0xc6, 0xb6, 0x74, 0x6e, 0xf9, 0x73, 0x26	/* t__pfx_notnt_show */
	.byte 0x07, 0x74, 0xb6, 0x74, 0x6e, 0xf9, 0x73, 0x26	/* tnotnt_show */
	.byte 0x04, 0xc6, 0xaf, 0x73, 0x26	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xaf, 0x73, 0x26	/* tevent_show */
	.byte 0x07, 0xc6, 0x62, 0x72, 0xcc, 0xd0, 0xf6, 0x26	/* t__pfx_branch_show */
	.byte 0x07, 0x74, 0x62, 0x72, 0xcc, 0xd0, 0xf6, 0x26	/* tbranch_show */
	.byte 0x06, 0xa8, 0xe7, 0x74, 0x77, 0xf6, 0x26	/* t__pfx_ptw_show */
	.byte 0x05, 0x06, 0x74, 0x77, 0xf6, 0x26	/* tptw_show */
	.byte 0x07, 0xc6, 0xb6, 0xf8, 0x74, 0x09, 0xf6, 0x26	/* t__pfx_noretcomp_show */
	.byte 0x07, 0x74, 0xb6, 0xf8, 0x74, 0x09, 0xf6, 0x26	/* tnoretcomp_show */
	.byte 0x06, 0xc6, 0x74, 0x73, 0x63, 0xf6, 0x26	/* t__pfx_tsc_show */
	.byte 0x06, 0x74, 0x74, 0x73, 0x63, 0xf6, 0x26	/* ttsc_show */
	.byte 0x05, 0xc6, 0x6d, 0x2d, 0xf6, 0x26	/* t__pfx_mtc_show */
	.byte 0x05, 0x74, 0x6d, 0x2d, 0xf6, 0x26	/* tmtc_show */
	.byte 0x0a, 0xc6, 0x66, 0x3a, 0x6f, 0x6e, 0xe7, 0x74, 0x77, 0xf6, 0x26	/* t__pfx_fup_on_ptw_show */
	.byte 0x0a, 0x74, 0x66, 0x3a, 0x6f, 0x6e, 0xe7, 0x74, 0x77, 0xf6, 0x26	/* tfup_on_ptw_show */
	.byte 0x09, 0xa8, 0xe7, 0x77, 0x72, 0x5f, 0xbc, 0xf9, 0x73, 0x26	/* t__pfx_pwr_evt_show */
	.byte 0x08, 0x06, 0x77, 0x72, 0x5f, 0xbc, 0xf9, 0x73, 0x26	/* tpwr_evt_show */
	.byte 0x06, 0xc6, 0x63, 0x79, 0x63, 0xf6, 0x26	/* t__pfx_cyc_show */
	.byte 0x05, 0x2d, 0x79, 0x63, 0xf6, 0x26	/* tcyc_show */
	.byte 0x05, 0xa8, 0xe7, 0xf9, 0x73, 0x26	/* t__pfx_pt_show */
	.byte 0x04, 0x06, 0xf9, 0x73, 0x26	/* tpt_show */
	.byte 0x08, 0xa8, 0xe7, 0xf9, 0x63, 0x61, 0x70, 0xf6, 0x26	/* t__pfx_pt_cap_show */
	.byte 0x07, 0x06, 0xf9, 0x63, 0x61, 0x70, 0xf6, 0x26	/* tpt_cap_show */
	.byte 0x0a, 0xa8, 0xe7, 0xf9, 0xac, 0x70, 0x61, 0x5f, 0x64, 0x75, 0xb0	/* t__pfx_pt_topa_dump */
	.byte 0x09, 0x06, 0xf9, 0xac, 0x70, 0x61, 0x5f, 0x64, 0x75, 0xb0	/* tpt_topa_dump */
	.byte 0x10, 0xa8, 0xe7, 0xf9, 0xaf, 0x10, 0x72, 0x5f, 0xb8, 0x6c, 0x74, 0xee, 0xe0, 0x76, 0xe1, 0x89, 0x86	/* t__pfx_pt_event_addr_filters_validate */
	.byte 0x0f, 0x06, 0xf9, 0xaf, 0x10, 0x72, 0x5f, 0xb8, 0x6c, 0x74, 0xee, 0xe0, 0x76, 0xe1, 0x89, 0x86	/* tpt_event_addr_filters_validate */
	.byte 0x0a, 0xa8, 0xe7, 0xf9, 0xf8, 0x05, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* t__pfx_pt_read_offset */
	.byte 0x09, 0x06, 0xf9, 0xf8, 0x05, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* tpt_read_offset */
	.byte 0x0a, 0xa8, 0xe7, 0xf9, 0x98, 0xb8, 0x67, 0xf6, 0xdb, 0x72, 0x74	/* t__pfx_pt_config_start */
	.byte 0x09, 0x06, 0xf9, 0x98, 0xb8, 0x67, 0xf6, 0xdb, 0x72, 0x74	/* tpt_config_start */
	.byte 0x0f, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0xf9, 0x76, 0xe1, 0x89, 0xa1, 0x68, 0xaa, 0x63, 0x61, 0x70	/* T__pfx_intel_pt_validate_hw_cap */
	.byte 0x0f, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0xf9, 0x76, 0xe1, 0x89, 0xa1, 0x68, 0xaa, 0x63, 0x61, 0x70	/* Tintel_pt_validate_hw_cap */
	.byte 0x0a, 0xa8, 0xe7, 0xf9, 0x98, 0xb8, 0xa6, 0xa2, 0x66, 0x66, 0xee	/* t__pfx_pt_config_buffer */
	.byte 0x09, 0x06, 0xf9, 0x98, 0xb8, 0xa6, 0xa2, 0x66, 0x66, 0xee	/* tpt_config_buffer */
	.byte 0x09, 0xa8, 0xe7, 0xf9, 0x98, 0xb8, 0x67, 0xf6, 0xac, 0x70	/* t__pfx_pt_config_stop */
	.byte 0x08, 0x06, 0xf9, 0x98, 0xb8, 0x67, 0xf6, 0xac, 0x70	/* tpt_config_stop */
	.byte 0x0e, 0xa8, 0xe7, 0xf9, 0xaf, 0x73, 0x6e, 0x61, 0x70, 0x73, 0xad, 0xf9, 0x61, 0x75, 0x78	/* t__pfx_pt_event_snapshot_aux */
	.byte 0x0d, 0x06, 0xf9, 0xaf, 0x73, 0x6e, 0x61, 0x70, 0x73, 0xad, 0xf9, 0x61, 0x75, 0x78	/* tpt_event_snapshot_aux */
	.byte 0x0e, 0xc6, 0xac, 0x70, 0x61, 0x5f, 0xe1, 0xc0, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_topa_alloc.constprop.0 */
	.byte 0x0e, 0x74, 0xac, 0x70, 0x61, 0x5f, 0xe1, 0xc0, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* ttopa_alloc.constprop.0 */
	.byte 0x0c, 0xc6, 0xac, 0x70, 0x61, 0x5f, 0xf0, 0x73, 0xee, 0xf9, 0xdb, 0x62, 0xd3	/* t__pfx_topa_insert_table */
	.byte 0x0c, 0x74, 0xac, 0x70, 0x61, 0x5f, 0xf0, 0x73, 0xee, 0xf9, 0xdb, 0x62, 0xd3	/* ttopa_insert_table */
	.byte 0x0f, 0xa8, 0xe7, 0xf9, 0xa2, 0x66, 0x66, 0xcf, 0xf8, 0xc9, 0xf9, 0xdd, 0x72, 0x6b, 0xee, 0x73	/* t__pfx_pt_buffer_reset_markers */
	.byte 0x0e, 0x06, 0xf9, 0xa2, 0x66, 0x66, 0xcf, 0xf8, 0xc9, 0xf9, 0xdd, 0x72, 0x6b, 0xee, 0x73	/* tpt_buffer_reset_markers */
	.byte 0x08, 0xa8, 0xe7, 0xf9, 0xaf, 0x73, 0xdb, 0x72, 0x74	/* t__pfx_pt_event_start */
	.byte 0x07, 0x06, 0xf9, 0xaf, 0x73, 0xdb, 0x72, 0x74	/* tpt_event_start */
	.byte 0x05, 0xa8, 0xe7, 0xf9, 0xaf, 0x10	/* t__pfx_pt_event_add */
	.byte 0x04, 0x06, 0xf9, 0xaf, 0x10	/* tpt_event_add */
	.byte 0x0d, 0xa8, 0xe7, 0xf9, 0xa2, 0x66, 0x66, 0xee, 0xba, 0x74, 0x3a, 0x61, 0x75, 0x78	/* t__pfx_pt_buffer_setup_aux */
	.byte 0x0c, 0x06, 0xf9, 0xa2, 0x66, 0x66, 0xee, 0xba, 0x74, 0x3a, 0x61, 0x75, 0x78	/* tpt_buffer_setup_aux */
	.byte 0x0a, 0xa8, 0xe7, 0xf9, 0x68, 0xcc, 0x64, 0xb3, 0xd6, 0xe9, 0x5d	/* t__pfx_pt_handle_status */
	.byte 0x09, 0x06, 0xf9, 0x68, 0xcc, 0x64, 0xb3, 0xd6, 0xe9, 0x5d	/* tpt_handle_status */
	.byte 0x06, 0xa8, 0xe7, 0xf9, 0xaf, 0xd6, 0x81	/* t__pfx_pt_event_stop */
	.byte 0x05, 0x06, 0xf9, 0xaf, 0xd6, 0x81	/* tpt_event_stop */
	.byte 0x06, 0xa8, 0xe7, 0xf9, 0xaf, 0xe6, 0x6c	/* t__pfx_pt_event_del */
	.byte 0x05, 0x06, 0xf9, 0xaf, 0xe6, 0x6c	/* tpt_event_del */
	.byte 0x05, 0xa8, 0xe7, 0xf9, 0xaf, 0x8d	/* t__pfx_pt_event_init */
	.byte 0x04, 0x06, 0xf9, 0xaf, 0x8d	/* tpt_event_init */
	.byte 0x0c, 0xbf, 0xf0, 0x9a, 0x6c, 0xe7, 0xf9, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* T__pfx_intel_pt_interrupt */
	.byte 0x0c, 0x54, 0xf0, 0x9a, 0x6c, 0xe7, 0xf9, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* Tintel_pt_interrupt */
	.byte 0x0f, 0xbf, 0x92, 0x5f, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0x79, 0xf6, 0xac, 0x70, 0xe7, 0x74	/* T__pfx_cpu_emergency_stop_pt */
	.byte 0x0f, 0x54, 0x92, 0x5f, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0x79, 0xf6, 0xac, 0x70, 0xe7, 0x74	/* Tcpu_emergency_stop_pt */
	.byte 0x0a, 0xbf, 0x69, 0xe0, 0xf0, 0x9a, 0x6c, 0xe7, 0xf9, 0xbc, 0x1e	/* T__pfx_is_intel_pt_event */
	.byte 0x0a, 0x54, 0x69, 0xe0, 0xf0, 0x9a, 0x6c, 0xe7, 0xf9, 0xbc, 0x1e	/* Tis_intel_pt_event */
	.byte 0x0c, 0xc6, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0xe7, 0x6d, 0x00, 0xaf, 0x0a	/* t__pfx_zhaoxin_pmu_event_map */
	.byte 0x0c, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0xe7, 0x6d, 0x00, 0xaf, 0x0a	/* tzhaoxin_pmu_event_map */
	.byte 0x11, 0xc6, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0x5f, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* t__pfx_zhaoxin_get_event_constraints */
	.byte 0x11, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0x5f, 0xb2, 0xaf, 0x98, 0x73, 0xea, 0x61, 0xf0, 0x74, 0x73	/* tzhaoxin_get_event_constraints */
	.byte 0x0f, 0xc6, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0x5f, 0xaf, 0xc1, 0x73, 0x66, 0x73, 0xf6, 0x26	/* t__pfx_zhaoxin_event_sysfs_show */
	.byte 0x0f, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0x5f, 0xaf, 0xc1, 0x73, 0x66, 0x73, 0xf6, 0x26	/* tzhaoxin_event_sysfs_show */
	.byte 0x06, 0xc6, 0x63, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx_cmask_show */
	.byte 0x05, 0x2d, 0xdd, 0x16, 0xf6, 0x26	/* tcmask_show */
	.byte 0x05, 0xc6, 0xf0, 0x76, 0xf6, 0x26	/* t__pfx_inv_show */
	.byte 0x05, 0x74, 0xf0, 0x76, 0xf6, 0x26	/* tinv_show */
	.byte 0x06, 0xc6, 0x65, 0x64, 0x21, 0x73, 0x26	/* t__pfx_edge_show */
	.byte 0x05, 0x9a, 0x64, 0x21, 0x73, 0x26	/* tedge_show */
	.byte 0x06, 0xc6, 0x75, 0xdd, 0x16, 0xf6, 0x26	/* t__pfx_umask_show */
	.byte 0x06, 0x74, 0x75, 0xdd, 0x16, 0xf6, 0x26	/* tumask_show */
	.byte 0x04, 0xc6, 0xaf, 0x73, 0x26	/* t__pfx_event_show */
	.byte 0x04, 0x74, 0xaf, 0x73, 0x26	/* tevent_show */
	.byte 0x10, 0xc6, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_zhaoxin_pmu_disable_all */
	.byte 0x10, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xe1, 0x6c	/* tzhaoxin_pmu_disable_all */
	.byte 0x0f, 0xc6, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* t__pfx_zhaoxin_pmu_enable_all */
	.byte 0x0f, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xe1, 0x6c	/* tzhaoxin_pmu_enable_all */
	.byte 0x10, 0xc6, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0xe7, 0x6d, 0x00, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* t__pfx_zhaoxin_pmu_handle_irq */
	.byte 0x10, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0xe7, 0x6d, 0x00, 0x68, 0xcc, 0x64, 0xb3, 0xa7, 0x71	/* tzhaoxin_pmu_handle_irq */
	.byte 0x0f, 0xc6, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_zhaoxin_pmu_enable_event */
	.byte 0x0f, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0xe7, 0x6d, 0x00, 0xe8, 0x80, 0xb3, 0xbc, 0x1e	/* tzhaoxin_pmu_enable_event */
	.byte 0x10, 0xc6, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* t__pfx_zhaoxin_pmu_disable_event */
	.byte 0x10, 0x74, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0, 0xe7, 0x6d, 0x00, 0x64, 0xab, 0x80, 0xb3, 0xbc, 0x1e	/* tzhaoxin_pmu_disable_event */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x3a, 0x6f, 0x6e, 0x88, 0x65	/* t__pfx_xen_cpu_up_online */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x3a, 0x6f, 0x6e, 0x88, 0x65	/* txen_cpu_up_online */
	.byte 0x0a, 0xbf, 0x78, 0xe8, 0x5f, 0xca, 0xd0, 0x5f, 0x18, 0xcf, 0x92	/* T__pfx_xen_arch_register_cpu */
	.byte 0x0a, 0x54, 0x78, 0xe8, 0x5f, 0xca, 0xd0, 0x5f, 0x18, 0xcf, 0x92	/* Txen_arch_register_cpu */
	.byte 0x0b, 0xbf, 0x78, 0xe8, 0x5f, 0xca, 0xd0, 0x5f, 0xd4, 0x18, 0xcf, 0x92	/* T__pfx_xen_arch_unregister_cpu */
	.byte 0x0b, 0x54, 0x78, 0xe8, 0x5f, 0xca, 0xd0, 0x5f, 0xd4, 0x18, 0xcf, 0x92	/* Txen_arch_unregister_cpu */
	.byte 0x0d, 0xbf, 0x78, 0xe8, 0x5f, 0x68, 0x27, 0xee, 0x28, 0x6c, 0xba, 0x74, 0x2b, 0x63	/* T__pfx_xen_hypercall_setfunc */
	.byte 0x0d, 0x54, 0x78, 0xe8, 0x5f, 0x68, 0x27, 0xee, 0x28, 0x6c, 0xba, 0x74, 0x2b, 0x63	/* Txen_hypercall_setfunc */
	.byte 0x0a, 0xbf, 0x78, 0xe8, 0x5f, 0x92, 0x68, 0x70, 0xba, 0x74, 0xb9	/* T__pfx_xen_cpuhp_setup */
	.byte 0x0a, 0x54, 0x78, 0xe8, 0x5f, 0x92, 0x68, 0x70, 0xba, 0x74, 0xb9	/* Txen_cpuhp_setup */
	.byte 0x0e, 0xbf, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x5f, 0xf0, 0x66, 0x6f, 0x5f, 0xf8, 0xc9, 0x74	/* T__pfx_xen_vcpu_info_reset */
	.byte 0x0e, 0x54, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x5f, 0xf0, 0x66, 0x6f, 0x5f, 0xf8, 0xc9, 0x74	/* Txen_vcpu_info_reset */
	.byte 0x09, 0xbf, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0xba, 0x74, 0xb9	/* T__pfx_xen_vcpu_setup */
	.byte 0x09, 0x54, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0xba, 0x74, 0xb9	/* Txen_vcpu_setup */
	.byte 0x0b, 0xbf, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x5f, 0xf8, 0xd6, 0x6f, 0xf8	/* T__pfx_xen_vcpu_restore */
	.byte 0x0b, 0x54, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x5f, 0xf8, 0xd6, 0x6f, 0xf8	/* Txen_vcpu_restore */
	.byte 0x15, 0xbf, 0x78, 0xe8, 0x5f, 0x72, 0xd4, 0x6e, 0xf0, 0xa6, 0x6f, 0x7c, 0x76, 0xee, 0x73, 0xd9, 0x7c, 0xce, 0x5f, 0x6c, 0xe9, 0xee	/* T__pfx_xen_running_on_version_or_later */
	.byte 0x15, 0x54, 0x78, 0xe8, 0x5f, 0x72, 0xd4, 0x6e, 0xf0, 0xa6, 0x6f, 0x7c, 0x76, 0xee, 0x73, 0xd9, 0x7c, 0xce, 0x5f, 0x6c, 0xe9, 0xee	/* Txen_running_on_version_or_later */
	.byte 0x09, 0xbf, 0x78, 0xe8, 0x5f, 0xf8, 0x62, 0x6f, 0x6f, 0x74	/* T__pfx_xen_reboot */
	.byte 0x09, 0x54, 0x78, 0xe8, 0x5f, 0xf8, 0x62, 0x6f, 0x6f, 0x74	/* Txen_reboot */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0xe7, 0xcc, 0x69, 0xd5, 0xbc, 0x1e	/* t__pfx_xen_panic_event */
	.byte 0x09, 0x74, 0x78, 0xe8, 0xe7, 0xcc, 0x69, 0xd5, 0xbc, 0x1e	/* txen_panic_event */
	.byte 0x0f, 0xbf, 0x78, 0xe8, 0x5f, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0xc5, 0x3d, 0xdb, 0x72, 0x74	/* T__pfx_xen_emergency_restart */
	.byte 0x0f, 0x54, 0x78, 0xe8, 0x5f, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0xc5, 0x3d, 0xdb, 0x72, 0x74	/* Txen_emergency_restart */
	.byte 0x0d, 0xbf, 0x78, 0xe8, 0xe7, 0xcc, 0x69, 0xd5, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0x8d	/* T__pfx_xen_panic_handler_init */
	.byte 0x0d, 0x54, 0x78, 0xe8, 0xe7, 0xcc, 0x69, 0xd5, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0x8d	/* Txen_panic_handler_init */
	.byte 0x08, 0xbf, 0x78, 0xe8, 0xe7, 0xf0, 0x5f, 0x76, 0x92	/* T__pfx_xen_pin_vcpu */
	.byte 0x08, 0x54, 0x78, 0xe8, 0xe7, 0xf0, 0x5f, 0x76, 0x92	/* Txen_pin_vcpu */
	.byte 0x11, 0xbf, 0xca, 0x62, 0x69, 0xea, 0xca, 0xc5, 0x76, 0xa7, 0xf9, 0xac, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0x65	/* T__pfx_arbitrary_virt_to_machine */
	.byte 0x11, 0x54, 0xca, 0x62, 0x69, 0xea, 0xca, 0xc5, 0x76, 0xa7, 0xf9, 0xac, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0x65	/* Tarbitrary_virt_to_machine */
	.byte 0x10, 0xbf, 0x78, 0xe8, 0x5f, 0xd4, 0x84, 0xa9, 0xdd, 0xf0, 0x5f, 0x67, 0x66, 0x7c, 0x72, 0xcc, 0xda	/* T__pfx_xen_unmap_domain_gfn_range */
	.byte 0x10, 0x54, 0x78, 0xe8, 0x5f, 0xd4, 0x84, 0xa9, 0xdd, 0xf0, 0x5f, 0x67, 0x66, 0x7c, 0x72, 0xcc, 0xda	/* Txen_unmap_domain_gfn_range */
	.byte 0x0f, 0xbf, 0xca, 0x62, 0x69, 0xea, 0xca, 0xc5, 0x76, 0xa7, 0xf9, 0xac, 0x5f, 0x6d, 0x66, 0x6e	/* T__pfx_arbitrary_virt_to_mfn */
	.byte 0x0f, 0x54, 0xca, 0x62, 0x69, 0xea, 0xca, 0xc5, 0x76, 0xa7, 0xf9, 0xac, 0x5f, 0x6d, 0x66, 0x6e	/* Tarbitrary_virt_to_mfn */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x1f, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* t__pfx_xen_set_wallclock */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x1f, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* txen_set_wallclock */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0x63, 0xe0, 0xe8, 0x80, 0xd3	/* t__pfx_xen_cs_enable */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0x63, 0xe0, 0xe8, 0x80, 0xd3	/* txen_cs_enable */
	.byte 0x0e, 0xc6, 0x78, 0xe8, 0x5f, 0xc2, 0x6d, 0xee, 0x81, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_xen_timerop_shutdown */
	.byte 0x0e, 0x74, 0x78, 0xe8, 0x5f, 0xc2, 0x6d, 0xee, 0x81, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* txen_timerop_shutdown */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0xc2, 0x6d, 0xcf, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx_xen_timer_interrupt */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0xc2, 0x6d, 0xcf, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* txen_timer_interrupt */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x81, 0x1f, 0x6f, 0xb4, 0x73, 0xad, 0x74	/* t__pfx_xen_vcpuop_set_oneshot */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x81, 0x1f, 0x6f, 0xb4, 0x73, 0xad, 0x74	/* txen_vcpuop_set_oneshot */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x81, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_xen_vcpuop_shutdown */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x81, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* txen_vcpuop_shutdown */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0x63, 0x3c, 0x73, 0x6f, 0x1d, 0x63, 0xfa, 0xf8, 0xc7	/* t__pfx_xen_clocksource_read */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0x63, 0x3c, 0x73, 0x6f, 0x1d, 0x63, 0xfa, 0xf8, 0xc7	/* txen_clocksource_read */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x81, 0x1f, 0x6e, 0xd1, 0xf9, 0xbc, 0x1e	/* t__pfx_xen_vcpuop_set_next_event */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x81, 0x1f, 0x6e, 0xd1, 0xf9, 0xbc, 0x1e	/* txen_vcpuop_set_next_event */
	.byte 0x0e, 0xc6, 0x78, 0xe8, 0x5f, 0xc2, 0x6d, 0xee, 0x81, 0x1f, 0x6e, 0xd1, 0xf9, 0xbc, 0x1e	/* t__pfx_xen_timerop_set_next_event */
	.byte 0x0e, 0x74, 0x78, 0xe8, 0x5f, 0xc2, 0x6d, 0xee, 0x81, 0x1f, 0x6e, 0xd1, 0xf9, 0xbc, 0x1e	/* txen_timerop_set_next_event */
	.byte 0x0f, 0xc6, 0x78, 0xe8, 0xe7, 0x76, 0x63, 0xc0, 0xd8, 0x67, 0xac, 0xe5, 0xb6, 0xc2, 0x66, 0x79	/* t__pfx_xen_pvclock_gtod_notify */
	.byte 0x0f, 0x74, 0x78, 0xe8, 0xe7, 0x76, 0x63, 0xc0, 0xd8, 0x67, 0xac, 0xe5, 0xb6, 0xc2, 0x66, 0x79	/* txen_pvclock_gtod_notify */
	.byte 0x11, 0xc6, 0x78, 0xe8, 0x5f, 0x63, 0x3c, 0x73, 0x6f, 0x1d, 0x63, 0xfa, 0xb2, 0x63, 0x79, 0x63, 0xd3, 0x73	/* t__pfx_xen_clocksource_get_cycles */
	.byte 0x11, 0x74, 0x78, 0xe8, 0x5f, 0x63, 0x3c, 0x73, 0x6f, 0x1d, 0x63, 0xfa, 0xb2, 0x63, 0x79, 0x63, 0xd3, 0x73	/* txen_clocksource_get_cycles */
	.byte 0x11, 0xc6, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0x6d, 0xba, 0x74, 0x3a, 0x92, 0x5f, 0x63, 0x3c, 0xbc, 0x1e, 0x73	/* t__pfx_xen_hvm_setup_cpu_clockevents */
	.byte 0x11, 0x74, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0x6d, 0xba, 0x74, 0x3a, 0x92, 0x5f, 0x63, 0x3c, 0xbc, 0x1e, 0x73	/* txen_hvm_setup_cpu_clockevents */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0x5f, 0xf8, 0x05, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* t__pfx_xen_read_wallclock */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0x5f, 0xf8, 0x05, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* txen_read_wallclock */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0xb2, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* t__pfx_xen_get_wallclock */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0xb2, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* txen_get_wallclock */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0x74, 0x73, 0xd5, 0x6b, 0x68, 0x7a	/* t__pfx_xen_tsc_khz */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0x74, 0x73, 0xd5, 0x6b, 0x68, 0x7a	/* txen_tsc_khz */
	.byte 0x0c, 0xbf, 0x78, 0xe8, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x7c, 0xc2, 0x6d, 0xee	/* T__pfx_xen_teardown_timer */
	.byte 0x0c, 0x54, 0x78, 0xe8, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x7c, 0xc2, 0x6d, 0xee	/* Txen_teardown_timer */
	.byte 0x09, 0xbf, 0x78, 0xe8, 0xba, 0x74, 0x3a, 0xc2, 0x6d, 0xee	/* T__pfx_xen_setup_timer */
	.byte 0x09, 0x54, 0x78, 0xe8, 0xba, 0x74, 0x3a, 0xc2, 0x6d, 0xee	/* Txen_setup_timer */
	.byte 0x0d, 0xbf, 0x78, 0xe8, 0xba, 0x74, 0x3a, 0x92, 0x5f, 0x63, 0x3c, 0xbc, 0x1e, 0x73	/* T__pfx_xen_setup_cpu_clockevents */
	.byte 0x0d, 0x54, 0x78, 0xe8, 0xba, 0x74, 0x3a, 0x92, 0x5f, 0x63, 0x3c, 0xbc, 0x1e, 0x73	/* Txen_setup_cpu_clockevents */
	.byte 0x0a, 0xbf, 0x78, 0xe8, 0x5f, 0xc2, 0x6d, 0xcf, 0xf8, 0xb7, 0xbd	/* T__pfx_xen_timer_resume */
	.byte 0x0a, 0x54, 0x78, 0xe8, 0x5f, 0xc2, 0x6d, 0xcf, 0xf8, 0xb7, 0xbd	/* Txen_timer_resume */
	.byte 0x10, 0xbf, 0x78, 0xe8, 0xf6, 0x61, 0x22, 0xc2, 0x6d, 0xfa, 0xbd, 0x6d, 0xce, 0xc5, 0x61, 0xf8, 0x61	/* T__pfx_xen_save_time_memory_area */
	.byte 0x10, 0x54, 0x78, 0xe8, 0xf6, 0x61, 0x22, 0xc2, 0x6d, 0xfa, 0xbd, 0x6d, 0xce, 0xc5, 0x61, 0xf8, 0x61	/* Txen_save_time_memory_area */
	.byte 0x12, 0xbf, 0x78, 0xe8, 0x5f, 0xf8, 0xd6, 0xce, 0xfa, 0xc2, 0x6d, 0xfa, 0xbd, 0x6d, 0xce, 0xc5, 0x61, 0xf8, 0x61	/* T__pfx_xen_restore_time_memory_area */
	.byte 0x12, 0x54, 0x78, 0xe8, 0x5f, 0xf8, 0xd6, 0xce, 0xfa, 0xc2, 0x6d, 0xfa, 0xbd, 0x6d, 0xce, 0xc5, 0x61, 0xf8, 0x61	/* Txen_restore_time_memory_area */
	.byte 0x0b, 0xc6, 0x67, 0x6e, 0x74, 0xdb, 0xdc, 0x61, 0x70, 0x70, 0x6c, 0x79	/* t__pfx_gnttab_apply */
	.byte 0x0b, 0x74, 0x67, 0x6e, 0x74, 0xdb, 0xdc, 0x61, 0x70, 0x70, 0x6c, 0x79	/* tgnttab_apply */
	.byte 0x0c, 0xc6, 0xca, 0xd0, 0x5f, 0x67, 0x6e, 0x74, 0xdb, 0xdc, 0x76, 0xe1, 0xc0	/* t__pfx_arch_gnttab_valloc */
	.byte 0x0c, 0xdb, 0x72, 0xd0, 0x5f, 0x67, 0x6e, 0x74, 0xdb, 0xdc, 0x76, 0xe1, 0xc0	/* tarch_gnttab_valloc */
	.byte 0x0c, 0xa8, 0x1f, 0x70, 0x9a, 0x73, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_set_ptes.constprop.0 */
	.byte 0x0d, 0x74, 0xc9, 0xf9, 0x70, 0x9a, 0x73, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tset_ptes.constprop.0 */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0x67, 0x6e, 0x74, 0xdb, 0xdc, 0x0a, 0xf6, 0x68, 0x61, 0xf8, 0x64	/* T__pfx_arch_gnttab_map_shared */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0x67, 0x6e, 0x74, 0xdb, 0xdc, 0x0a, 0xf6, 0x68, 0x61, 0xf8, 0x64	/* Tarch_gnttab_map_shared */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0x5f, 0x67, 0x6e, 0x74, 0xdb, 0xdc, 0x0a, 0x2a, 0xe9, 0x5d	/* T__pfx_arch_gnttab_map_status */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0x5f, 0x67, 0x6e, 0x74, 0xdb, 0xdc, 0x0a, 0x2a, 0xe9, 0x5d	/* Tarch_gnttab_map_status */
	.byte 0x0b, 0xbf, 0xca, 0xd0, 0x5f, 0x67, 0x6e, 0x74, 0xdb, 0xdc, 0xd4, 0x0a	/* T__pfx_arch_gnttab_unmap */
	.byte 0x0b, 0x54, 0xca, 0xd0, 0x5f, 0x67, 0x6e, 0x74, 0xdb, 0xdc, 0xd4, 0x0a	/* Tarch_gnttab_unmap */
	.byte 0x0a, 0xbf, 0xca, 0xd0, 0x5f, 0x67, 0x6e, 0x74, 0xdb, 0xdc, 0x8d	/* T__pfx_arch_gnttab_init */
	.byte 0x0a, 0x54, 0xca, 0xd0, 0x5f, 0x67, 0x6e, 0x74, 0xdb, 0xdc, 0x8d	/* Tarch_gnttab_init */
	.byte 0x10, 0xc6, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x5f, 0xb6, 0xc2, 0x66, 0x79, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* t__pfx_xen_vcpu_notify_suspend */
	.byte 0x10, 0x74, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x5f, 0xb6, 0xc2, 0x66, 0x79, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* txen_vcpu_notify_suspend */
	.byte 0x0f, 0xc6, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x5f, 0xb6, 0xc2, 0x66, 0xc5, 0xf8, 0xd6, 0x6f, 0xf8	/* t__pfx_xen_vcpu_notify_restore */
	.byte 0x0f, 0x74, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0x5f, 0xb6, 0xc2, 0x66, 0xc5, 0xf8, 0xd6, 0x6f, 0xf8	/* txen_vcpu_notify_restore */
	.byte 0x0e, 0xbf, 0x78, 0xe8, 0x5f, 0xca, 0xd0, 0xe7, 0x72, 0xfa, 0xb7, 0x73, 0x70, 0xe8, 0x64	/* T__pfx_xen_arch_pre_suspend */
	.byte 0x0e, 0x54, 0x78, 0xe8, 0x5f, 0xca, 0xd0, 0xe7, 0x72, 0xfa, 0xb7, 0x73, 0x70, 0xe8, 0x64	/* Txen_arch_pre_suspend */
	.byte 0x0f, 0xbf, 0x78, 0xe8, 0x5f, 0xca, 0xd0, 0xe7, 0x6f, 0x73, 0xf9, 0xb7, 0x73, 0x70, 0xe8, 0x64	/* T__pfx_xen_arch_post_suspend */
	.byte 0x0f, 0x54, 0x78, 0xe8, 0x5f, 0xca, 0xd0, 0xe7, 0x6f, 0x73, 0xf9, 0xb7, 0x73, 0x70, 0xe8, 0x64	/* Txen_arch_post_suspend */
	.byte 0x0a, 0xbf, 0x78, 0xe8, 0x5f, 0xca, 0xd0, 0x5f, 0xf8, 0xb7, 0xbd	/* T__pfx_xen_arch_resume */
	.byte 0x0a, 0x54, 0x78, 0xe8, 0x5f, 0xca, 0xd0, 0x5f, 0xf8, 0xb7, 0xbd	/* Txen_arch_resume */
	.byte 0x0b, 0xbf, 0x78, 0xe8, 0x5f, 0xca, 0xd0, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* T__pfx_xen_arch_suspend */
	.byte 0x0b, 0x54, 0x78, 0xe8, 0x5f, 0xca, 0xd0, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* Txen_arch_suspend */
	.byte 0x11, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0xcd, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx___sysvec_xen_hvm_callback */
	.byte 0x12, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0xcd, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__sysvec_xen_hvm_callback */
	.byte 0x11, 0xc6, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0xcd, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_xen_hvm_crash_shutdown */
	.byte 0x11, 0x74, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0xcd, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* txen_hvm_crash_shutdown */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0x6d, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_xen_hvm_shutdown */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0x6d, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* txen_hvm_shutdown */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xe6, 0x05, 0x68, 0x76, 0x6d	/* t__pfx_xen_cpu_dead_hvm */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xe6, 0x05, 0x68, 0x76, 0x6d	/* txen_cpu_dead_hvm */
	.byte 0x0f, 0xc6, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xb9, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x68, 0x76, 0x6d	/* t__pfx_xen_cpu_up_prepare_hvm */
	.byte 0x0f, 0x74, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xb9, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x68, 0x76, 0x6d	/* txen_cpu_up_prepare_hvm */
	.byte 0x11, 0xbf, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0xcd, 0xf0, 0x99, 0x73, 0x68, 0x61, 0xf8, 0xe5, 0xf0, 0x66, 0x6f	/* T__pfx_xen_hvm_init_shared_info */
	.byte 0x11, 0x54, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0xcd, 0xf0, 0x99, 0x73, 0x68, 0x61, 0xf8, 0xe5, 0xf0, 0x66, 0x6f	/* Txen_hvm_init_shared_info */
	.byte 0x13, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0xcd, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* T__pfx_fred_sysvec_xen_hvm_callback */
	.byte 0x13, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0xcd, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* Tfred_sysvec_xen_hvm_callback */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0xcd, 0xd1, 0x99, 0x6d, 0x0a	/* t__pfx_xen_hvm_exit_mmap */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0xcd, 0xd1, 0x99, 0x6d, 0x0a	/* txen_hvm_exit_mmap */
	.byte 0x0f, 0xc6, 0x78, 0xe8, 0x5f, 0x76, 0x6d, 0xfe, 0x72, 0xfa, 0xef, 0x7c, 0x69, 0xe0, 0xb5, 0x6d	/* t__pfx_xen_vmcore_pfn_is_ram */
	.byte 0x0f, 0x74, 0x78, 0xe8, 0x5f, 0x76, 0x6d, 0xfe, 0x72, 0xfa, 0xef, 0x7c, 0x69, 0xe0, 0xb5, 0x6d	/* txen_vmcore_pfn_is_ram */
	.byte 0x10, 0xbf, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0x6d, 0xe7, 0x6f, 0x73, 0xf9, 0xb7, 0x73, 0x70, 0xe8, 0x64	/* T__pfx_xen_hvm_post_suspend */
	.byte 0x10, 0x54, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0x6d, 0xe7, 0x6f, 0x73, 0xf9, 0xb7, 0x73, 0x70, 0xe8, 0x64	/* Txen_hvm_post_suspend */
	.byte 0x0b, 0xbf, 0x78, 0xe8, 0x5f, 0x68, 0x96, 0xe7, 0x76, 0x5f, 0x07, 0x3b	/* T__pfx_xen_has_pv_devices */
	.byte 0x0b, 0x54, 0x78, 0xe8, 0x5f, 0x68, 0x96, 0xe7, 0x76, 0x5f, 0x07, 0x3b	/* Txen_has_pv_devices */
	.byte 0x14, 0xbf, 0x78, 0xe8, 0x5f, 0x68, 0x96, 0xe7, 0x76, 0x5f, 0xcc, 0xe5, 0xd3, 0x67, 0xeb, 0xc5, 0x64, 0xab, 0xd8, 0x07, 0x3b	/* T__pfx_xen_has_pv_and_legacy_disk_devices */
	.byte 0x14, 0x54, 0x78, 0xe8, 0x5f, 0x68, 0x96, 0xe7, 0x76, 0x5f, 0xcc, 0xe5, 0xd3, 0x67, 0xeb, 0xc5, 0x64, 0xab, 0xd8, 0x07, 0x3b	/* Txen_has_pv_and_legacy_disk_devices */
	.byte 0x0e, 0xbf, 0x78, 0xe8, 0x5f, 0x68, 0x96, 0xe7, 0x76, 0x5f, 0x6e, 0x69, 0xd5, 0x07, 0x3b	/* T__pfx_xen_has_pv_nic_devices */
	.byte 0x0e, 0x54, 0x78, 0xe8, 0x5f, 0x68, 0x96, 0xe7, 0x76, 0x5f, 0x6e, 0x69, 0xd5, 0x07, 0x3b	/* Txen_has_pv_nic_devices */
	.byte 0x0e, 0xbf, 0x78, 0xe8, 0x5f, 0x68, 0x96, 0xe7, 0x76, 0x5f, 0x64, 0xab, 0xd8, 0x07, 0x3b	/* T__pfx_xen_has_pv_disk_devices */
	.byte 0x0e, 0x54, 0x78, 0xe8, 0x5f, 0x68, 0x96, 0xe7, 0x76, 0x5f, 0x64, 0xab, 0xd8, 0x07, 0x3b	/* Txen_has_pv_disk_devices */
	.byte 0x10, 0xbf, 0x78, 0xe8, 0x5f, 0xd4, 0x70, 0x6c, 0x75, 0xa6, 0x65, 0x6d, 0x0b, 0x86, 0xe5, 0x07, 0x3b	/* T__pfx_xen_unplug_emulated_devices */
	.byte 0x10, 0x54, 0x78, 0xe8, 0x5f, 0xd4, 0x70, 0x6c, 0x75, 0xa6, 0x65, 0x6d, 0x0b, 0x86, 0xe5, 0x07, 0x3b	/* Txen_unplug_emulated_devices */
	.byte 0x08, 0xc6, 0x18, 0xcf, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_register_callback */
	.byte 0x08, 0x74, 0x18, 0xcf, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tregister_callback */
	.byte 0x0b, 0xbf, 0x78, 0xe8, 0x5f, 0xe8, 0x80, 0xb3, 0xc1, 0x73, 0x1e, 0xee	/* T__pfx_xen_enable_sysenter */
	.byte 0x0b, 0x54, 0x78, 0xe8, 0x5f, 0xe8, 0x80, 0xb3, 0xc1, 0x73, 0x1e, 0xee	/* Txen_enable_sysenter */
	.byte 0x0b, 0xbf, 0x78, 0xe8, 0x5f, 0xe8, 0x80, 0xb3, 0xc1, 0x73, 0x28, 0x6c	/* T__pfx_xen_enable_syscall */
	.byte 0x0b, 0x54, 0x78, 0xe8, 0x5f, 0xe8, 0x80, 0xb3, 0xc1, 0x73, 0x28, 0x6c	/* Txen_enable_syscall */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0xb2, 0x61, 0x70, 0x69, 0xd5, 0x89	/* t__pfx_xen_get_apic_id */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0xb2, 0x61, 0x70, 0x69, 0xd5, 0x89	/* txen_get_apic_id */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0xc7	/* t__pfx_xen_apic_read */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0xc7	/* txen_apic_read */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0x65, 0x6f, 0x69	/* t__pfx_xen_apic_eoi */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0x65, 0x6f, 0x69	/* txen_apic_eoi */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0xf8, 0xc7	/* t__pfx_xen_apic_icr_read */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0xf8, 0xc7	/* txen_apic_icr_read */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0x24, 0x65	/* t__pfx_xen_apic_icr_write */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0x24, 0x65	/* txen_apic_icr_write */
	.byte 0x0c, 0xc6, 0x78, 0xe8, 0x5f, 0x61, 0x70, 0xa3, 0x25, 0x62, 0xfa, 0x70, 0x76	/* t__pfx_xen_apic_probe_pv */
	.byte 0x0c, 0x74, 0x78, 0xe8, 0x5f, 0x61, 0x70, 0xa3, 0x25, 0x62, 0xfa, 0x70, 0x76	/* txen_apic_probe_pv */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0xdd, 0x64, 0xf9, 0x6f, 0x65, 0xcd, 0x7e, 0x63, 0x6b	/* t__pfx_xen_madt_oem_check */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0xdd, 0x64, 0xf9, 0x6f, 0x65, 0xcd, 0x7e, 0x63, 0x6b	/* txen_madt_oem_check */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0x5f, 0x3e, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0xc7	/* t__pfx_xen_io_apic_read */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0x5f, 0x3e, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0xc7	/* txen_io_apic_read */
	.byte 0x0e, 0xc6, 0x78, 0xe8, 0x5f, 0x92, 0xe7, 0x3d, 0xbb, 0xac, 0x5f, 0x61, 0x70, 0xa3, 0x89	/* t__pfx_xen_cpu_present_to_apicid */
	.byte 0x0e, 0x74, 0x78, 0xe8, 0x5f, 0x92, 0xe7, 0x3d, 0xbb, 0xac, 0x5f, 0x61, 0x70, 0xa3, 0x89	/* txen_cpu_present_to_apicid */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0x24, 0x65	/* t__pfx_xen_apic_write */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0x24, 0x65	/* txen_apic_write */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0xb2, 0x67, 0x75, 0x3b, 0xf9, 0x0c	/* t__pfx_xen_get_guest_ip */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0xb2, 0x67, 0x75, 0x3b, 0xf9, 0x0c	/* txen_get_guest_ip */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0x67, 0x75, 0x3b, 0xf9, 0xd6, 0x86	/* t__pfx_xen_guest_state */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0x67, 0x75, 0x3b, 0xf9, 0xd6, 0x86	/* txen_guest_state */
	.byte 0x0e, 0xa8, 0xe7, 0x6d, 0x00, 0x20, 0x72, 0x5f, 0xd0, 0xd8, 0x65, 0x6d, 0x0b, 0x86, 0x64	/* t__pfx_pmu_msr_chk_emulated */
	.byte 0x0d, 0x06, 0x6d, 0x00, 0x20, 0x72, 0x5f, 0xd0, 0xd8, 0x65, 0x6d, 0x0b, 0x86, 0x64	/* tpmu_msr_chk_emulated */
	.byte 0x09, 0x3f, 0xe7, 0x6d, 0x00, 0x20, 0x72, 0x5f, 0xf8, 0xc7	/* T__pfx_pmu_msr_read */
	.byte 0x09, 0x54, 0x70, 0x6d, 0x00, 0x20, 0x72, 0x5f, 0xf8, 0xc7	/* Tpmu_msr_read */
	.byte 0x09, 0x3f, 0xe7, 0x6d, 0x00, 0x20, 0x72, 0x5f, 0x24, 0x65	/* T__pfx_pmu_msr_write */
	.byte 0x09, 0x54, 0x70, 0x6d, 0x00, 0x20, 0x72, 0x5f, 0x24, 0x65	/* Tpmu_msr_write */
	.byte 0x09, 0xbf, 0x78, 0xe8, 0x5f, 0xf8, 0xc7, 0xe7, 0x6d, 0x63	/* T__pfx_xen_read_pmc */
	.byte 0x09, 0x54, 0x78, 0xe8, 0x5f, 0xf8, 0xc7, 0xe7, 0x6d, 0x63	/* Txen_read_pmc */
	.byte 0x0b, 0x3f, 0xe7, 0x6d, 0x00, 0x61, 0x70, 0x69, 0xd5, 0xb9, 0x64, 0x86	/* T__pfx_pmu_apic_update */
	.byte 0x0b, 0x54, 0x70, 0x6d, 0x00, 0x61, 0x70, 0x69, 0xd5, 0xb9, 0x64, 0x86	/* Tpmu_apic_update */
	.byte 0x0d, 0xbf, 0x78, 0xe8, 0xe7, 0x6d, 0x00, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_xen_pmu_irq_handler */
	.byte 0x0d, 0x54, 0x78, 0xe8, 0xe7, 0x6d, 0x00, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Txen_pmu_irq_handler */
	.byte 0x07, 0xbf, 0x78, 0xe8, 0xe7, 0x6d, 0x00, 0x8d	/* T__pfx_xen_pmu_init */
	.byte 0x07, 0x54, 0x78, 0xe8, 0xe7, 0x6d, 0x00, 0x8d	/* Txen_pmu_init */
	.byte 0x0a, 0xbf, 0x78, 0xe8, 0xe7, 0x6d, 0x00, 0x66, 0xf0, 0xab, 0x68	/* T__pfx_xen_pmu_finish */
	.byte 0x0a, 0x54, 0x78, 0xe8, 0xe7, 0x6d, 0x00, 0x66, 0xf0, 0xab, 0x68	/* Txen_pmu_finish */
	.byte 0x08, 0xc6, 0x6d, 0x66, 0x7c, 0xac, 0x5f, 0xef, 0x6e	/* t__pfx_mfn_to_pfn */
	.byte 0x08, 0x74, 0x6d, 0x66, 0x7c, 0xac, 0x5f, 0xef, 0x6e	/* tmfn_to_pfn */
	.byte 0x0d, 0xbf, 0x78, 0xe8, 0xe7, 0x76, 0xe7, 0x72, 0xfa, 0xb7, 0x73, 0x70, 0xe8, 0x64	/* T__pfx_xen_pv_pre_suspend */
	.byte 0x0d, 0x54, 0x78, 0xe8, 0xe7, 0x76, 0xe7, 0x72, 0xfa, 0xb7, 0x73, 0x70, 0xe8, 0x64	/* Txen_pv_pre_suspend */
	.byte 0x0e, 0xbf, 0x78, 0xe8, 0xe7, 0x76, 0xe7, 0x6f, 0x73, 0xf9, 0xb7, 0x73, 0x70, 0xe8, 0x64	/* T__pfx_xen_pv_post_suspend */
	.byte 0x0e, 0x54, 0x78, 0xe8, 0xe7, 0x76, 0xe7, 0x6f, 0x73, 0xf9, 0xb7, 0x73, 0x70, 0xe8, 0x64	/* Txen_pv_post_suspend */
	.byte 0x04, 0xa8, 0x1f, 0x70, 0x9a	/* t__pfx_set_pte */
	.byte 0x05, 0x74, 0xc9, 0xf9, 0x70, 0x9a	/* tset_pte */
	.byte 0x06, 0xa8, 0xe7, 0x74, 0xfa, 0xef, 0x6e	/* t__pfx_pte_pfn */
	.byte 0x05, 0x06, 0x74, 0xfa, 0xef, 0x6e	/* tpte_pfn */
	.byte 0x05, 0xc6, 0xef, 0x6e, 0xe7, 0x9a	/* t__pfx_pfn_pte */
	.byte 0x05, 0x74, 0xef, 0x6e, 0xe7, 0x9a	/* tpfn_pte */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0x23, 0x6f, 0xe0, 0xd9, 0xf8, 0x0a	/* t__pfx_xen_acpi_os_ioremap */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0x23, 0x6f, 0xe0, 0xd9, 0xf8, 0x0a	/* txen_acpi_os_ioremap */
	.byte 0x0d, 0xbf, 0xb2, 0x70, 0x68, 0x79, 0xe0, 0xac, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0x65	/* T__pfx_get_phys_to_machine */
	.byte 0x0d, 0x54, 0xb2, 0x70, 0x68, 0x79, 0xe0, 0xac, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0x65	/* Tget_phys_to_machine */
	.byte 0x12, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xe1, 0xc0, 0xe7, 0x9a, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_paravirt_alloc_pte.constprop.0 */
	.byte 0x11, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xe1, 0xc0, 0xe7, 0x9a, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tparavirt_alloc_pte.constprop.0 */
	.byte 0x0b, 0xa8, 0xe7, 0x32, 0xcd, 0x6d, 0x69, 0xe5, 0x6d, 0x66, 0x7c, 0x8d	/* t__pfx_p2m_mid_mfn_init */
	.byte 0x0a, 0x06, 0x32, 0xcd, 0x6d, 0x69, 0xe5, 0x6d, 0x66, 0x7c, 0x8d	/* tp2m_mid_mfn_init */
	.byte 0x08, 0xc6, 0x6d, 0x66, 0x7c, 0xac, 0x5f, 0xef, 0x6e	/* t__pfx_mfn_to_pfn */
	.byte 0x08, 0x74, 0x6d, 0x66, 0x7c, 0xac, 0x5f, 0xef, 0x6e	/* tmfn_to_pfn */
	.byte 0x0c, 0xbf, 0x78, 0xe8, 0x5f, 0xe1, 0xc0, 0xe7, 0x32, 0xcd, 0xe8, 0xea, 0x79	/* T__pfx_xen_alloc_p2m_entry */
	.byte 0x0c, 0x54, 0x78, 0xe8, 0x5f, 0xe1, 0xc0, 0xe7, 0x32, 0xcd, 0xe8, 0xea, 0x79	/* Txen_alloc_p2m_entry */
	.byte 0x0e, 0xbf, 0x78, 0xe8, 0xba, 0x74, 0x3a, 0x6d, 0x66, 0x7c, 0x6c, 0xab, 0xf9, 0x6c, 0x7d	/* T__pfx_xen_setup_mfn_list_list */
	.byte 0x0e, 0x54, 0x78, 0xe8, 0xba, 0x74, 0x3a, 0x6d, 0x66, 0x7c, 0x6c, 0xab, 0xf9, 0x6c, 0x7d	/* Txen_setup_mfn_list_list */
	.byte 0x0e, 0x3f, 0xff, 0x1f, 0x70, 0x68, 0x79, 0xe0, 0xac, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0x65	/* T__pfx___set_phys_to_machine */
	.byte 0x0e, 0x2f, 0xc9, 0xf9, 0x70, 0x68, 0x79, 0xe0, 0xac, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0x65	/* T__set_phys_to_machine */
	.byte 0x0d, 0x3f, 0x1f, 0x70, 0x68, 0x79, 0xe0, 0xac, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0x65	/* T__pfx_set_phys_to_machine */
	.byte 0x0e, 0x54, 0xc9, 0xf9, 0x70, 0x68, 0x79, 0xe0, 0xac, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0x65	/* Tset_phys_to_machine */
	.byte 0x0e, 0x3f, 0x1f, 0x66, 0x6f, 0xf8, 0x2c, 0x6e, 0xe7, 0x32, 0xcd, 0x0a, 0x70, 0xf0, 0x67	/* T__pfx_set_foreign_p2m_mapping */
	.byte 0x0f, 0x54, 0xc9, 0xf9, 0x66, 0x6f, 0xf8, 0x2c, 0x6e, 0xe7, 0x32, 0xcd, 0x0a, 0x70, 0xf0, 0x67	/* Tset_foreign_p2m_mapping */
	.byte 0x11, 0xbf, 0x63, 0xd3, 0xca, 0x5f, 0x66, 0x6f, 0xf8, 0x2c, 0x6e, 0xe7, 0x32, 0xcd, 0x0a, 0x70, 0xf0, 0x67	/* T__pfx_clear_foreign_p2m_mapping */
	.byte 0x11, 0x54, 0x63, 0xd3, 0xca, 0x5f, 0x66, 0x6f, 0xf8, 0x2c, 0x6e, 0xe7, 0x32, 0xcd, 0x0a, 0x70, 0xf0, 0x67	/* Tclear_foreign_p2m_mapping */
	.byte 0x06, 0xa8, 0xe7, 0x74, 0xfa, 0xef, 0x6e	/* t__pfx_pte_pfn */
	.byte 0x05, 0x06, 0x74, 0xfa, 0xef, 0x6e	/* tpte_pfn */
	.byte 0x05, 0xc6, 0xef, 0x6e, 0xe7, 0x9a	/* t__pfx_pfn_pte */
	.byte 0x05, 0x74, 0xef, 0x6e, 0xe7, 0x9a	/* tpfn_pte */
	.byte 0x06, 0xc6, 0x78, 0xe8, 0x5f, 0x92, 0x89	/* t__pfx_xen_cpuid */
	.byte 0x06, 0x74, 0x78, 0xe8, 0x5f, 0x92, 0x89	/* txen_cpuid */
	.byte 0x07, 0xc6, 0x78, 0xe8, 0x2a, 0xce, 0xfa, 0xea	/* t__pfx_xen_store_tr */
	.byte 0x07, 0x74, 0x78, 0xe8, 0x2a, 0xce, 0xfa, 0xea	/* txen_store_tr */
	.byte 0x0b, 0xc6, 0x63, 0x76, 0xf9, 0x67, 0xa1, 0xac, 0x5f, 0xea, 0x61, 0x70	/* t__pfx_cvt_gate_to_trap */
	.byte 0x0a, 0x2d, 0x76, 0xf9, 0x67, 0xa1, 0xac, 0x5f, 0xea, 0x61, 0x70	/* tcvt_gate_to_trap */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0x3e, 0x62, 0xe4, 0x0a	/* t__pfx_xen_invalidate_io_bitmap */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0x3e, 0x62, 0xe4, 0x0a	/* txen_invalidate_io_bitmap */
	.byte 0x08, 0xc6, 0x78, 0xe8, 0x5f, 0x3e, 0xe6, 0x1b, 0x79	/* t__pfx_xen_io_delay */
	.byte 0x08, 0x74, 0x78, 0xe8, 0x5f, 0x3e, 0xe6, 0x1b, 0x79	/* txen_io_delay */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0x5f, 0xdf, 0x05, 0x67, 0xe0, 0xf0, 0xe6, 0x78	/* t__pfx_xen_load_gs_index */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0x5f, 0xdf, 0x05, 0x67, 0xe0, 0xf0, 0xe6, 0x78	/* txen_load_gs_index */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0xf8, 0x05, 0x63, 0x72, 0x30	/* t__pfx_xen_read_cr0 */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0xf8, 0x05, 0x63, 0x72, 0x30	/* txen_read_cr0 */
	.byte 0x0e, 0xc6, 0x78, 0xe8, 0x5f, 0x98, 0x76, 0xee, 0xf9, 0xea, 0x61, 0xe2, 0xf0, 0x66, 0x6f	/* t__pfx_xen_convert_trap_info */
	.byte 0x0e, 0x74, 0x78, 0xe8, 0x5f, 0x98, 0x76, 0xee, 0xf9, 0xea, 0x61, 0xe2, 0xf0, 0x66, 0x6f	/* txen_convert_trap_info */
	.byte 0x0f, 0xc6, 0x78, 0xe8, 0xf6, 0xdb, 0x72, 0xf9, 0x98, 0x74, 0xd1, 0xf9, 0x73, 0x77, 0xe4, 0xd0	/* t__pfx_xen_start_context_switch */
	.byte 0x0f, 0x74, 0x78, 0xe8, 0xf6, 0xdb, 0x72, 0xf9, 0x98, 0x74, 0xd1, 0xf9, 0x73, 0x77, 0xe4, 0xd0	/* txen_start_context_switch */
	.byte 0x0c, 0xc6, 0x78, 0xe8, 0x5f, 0xb2, 0x6e, 0x6d, 0xcb, 0xf8, 0x96, 0x6f, 0x6e	/* t__pfx_xen_get_nmi_reason */
	.byte 0x0c, 0x74, 0x78, 0xe8, 0x5f, 0xb2, 0x6e, 0x6d, 0xcb, 0xf8, 0x96, 0x6f, 0x6e	/* txen_get_nmi_reason */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xe6, 0xc7, 0xe7, 0x76	/* t__pfx_xen_cpu_dead_pv */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xe6, 0xc7, 0xe7, 0x76	/* txen_cpu_dead_pv */
	.byte 0x04, 0xa8, 0x1f, 0xc9, 0x67	/* t__pfx_set_seg */
	.byte 0x05, 0x74, 0xc9, 0xf9, 0xc9, 0x67	/* tset_seg */
	.byte 0x0e, 0xc6, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xb9, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x70, 0x76	/* t__pfx_xen_cpu_up_prepare_pv */
	.byte 0x0e, 0x74, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xb9, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x70, 0x76	/* txen_cpu_up_prepare_pv */
	.byte 0x0e, 0xc6, 0x78, 0xe8, 0x5f, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_xen_crash_shutdown */
	.byte 0x0e, 0x74, 0x78, 0xe8, 0x5f, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* txen_crash_shutdown */
	.byte 0x0c, 0xc6, 0x78, 0xe8, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x68, 0xe1, 0x74	/* t__pfx_xen_machine_halt */
	.byte 0x0c, 0x74, 0x78, 0xe8, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x68, 0xe1, 0x74	/* txen_machine_halt */
	.byte 0x08, 0xc6, 0x78, 0xe8, 0x5f, 0x3d, 0xdb, 0x72, 0x74	/* t__pfx_xen_restart */
	.byte 0x08, 0x74, 0x78, 0xe8, 0x5f, 0x3d, 0xdb, 0x72, 0x74	/* txen_restart */
	.byte 0x10, 0xc6, 0x78, 0xe8, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x70, 0x6f, 0x77, 0xcf, 0x6f, 0x66, 0x66	/* t__pfx_xen_machine_power_off */
	.byte 0x10, 0x74, 0x78, 0xe8, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x70, 0x6f, 0x77, 0xcf, 0x6f, 0x66, 0x66	/* txen_machine_power_off */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0xa9, 0x5f, 0x24, 0xfa, 0x20, 0x72	/* t__pfx_xen_do_write_msr */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0xa9, 0x5f, 0x24, 0xfa, 0x20, 0x72	/* txen_do_write_msr */
	.byte 0x08, 0xc6, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x20, 0x72	/* t__pfx_xen_write_msr */
	.byte 0x08, 0x74, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x20, 0x72	/* txen_write_msr */
	.byte 0x0c, 0xc6, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x20, 0x72, 0xf6, 0x61, 0x66, 0x65	/* t__pfx_xen_write_msr_safe */
	.byte 0x0c, 0x74, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x20, 0x72, 0xf6, 0x61, 0x66, 0x65	/* txen_write_msr_safe */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0xa9, 0x5f, 0xf8, 0x05, 0x20, 0x72	/* t__pfx_xen_do_read_msr */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0xa9, 0x5f, 0xf8, 0x05, 0x20, 0x72	/* txen_do_read_msr */
	.byte 0x08, 0xc6, 0x78, 0xe8, 0x5f, 0xf8, 0x05, 0x20, 0x72	/* t__pfx_xen_read_msr */
	.byte 0x08, 0x74, 0x78, 0xe8, 0x5f, 0xf8, 0x05, 0x20, 0x72	/* txen_read_msr */
	.byte 0x0c, 0xc6, 0x78, 0xe8, 0x5f, 0xf8, 0x05, 0x20, 0x72, 0xf6, 0x61, 0x66, 0x65	/* t__pfx_xen_read_msr_safe */
	.byte 0x0c, 0x74, 0x78, 0xe8, 0x5f, 0xf8, 0x05, 0x20, 0x72, 0xf6, 0x61, 0x66, 0x65	/* txen_read_msr_safe */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0x5f, 0xb9, 0x64, 0xa1, 0x3e, 0x62, 0xe4, 0x0a	/* t__pfx_xen_update_io_bitmap */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0x5f, 0xb9, 0x64, 0xa1, 0x3e, 0x62, 0xe4, 0x0a	/* txen_update_io_bitmap */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x62, 0xe9, 0xd0	/* t__pfx_xen_mc_batch */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x62, 0xe9, 0xd0	/* txen_mc_batch */
	.byte 0x0a, 0xc6, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* t__pfx_trace_xen_mc_entry */
	.byte 0x0a, 0x74, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* ttrace_xen_mc_entry */
	.byte 0x09, 0xa8, 0x1f, 0xe1, 0x69, 0x61, 0xc9, 0x64, 0x25, 0x74	/* t__pfx_set_aliased_prot */
	.byte 0x0a, 0x74, 0xc9, 0xf9, 0xe1, 0x69, 0x61, 0xc9, 0x64, 0x25, 0x74	/* tset_aliased_prot */
	.byte 0x08, 0xc6, 0x78, 0xe8, 0x5f, 0x87, 0xfa, 0x02, 0x74	/* t__pfx_xen_free_ldt */
	.byte 0x08, 0x74, 0x78, 0xe8, 0x5f, 0x87, 0xfa, 0x02, 0x74	/* txen_free_ldt */
	.byte 0x08, 0xc6, 0x78, 0xe8, 0x5f, 0x08, 0xd5, 0x02, 0x74	/* t__pfx_xen_alloc_ldt */
	.byte 0x08, 0x74, 0x78, 0xe8, 0x5f, 0x08, 0xd5, 0x02, 0x74	/* txen_alloc_ldt */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_xen_write_idt_entry */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* txen_write_idt_entry */
	.byte 0x0f, 0xc6, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_trace_xen_cpu_write_gdt_entry */
	.byte 0x0f, 0x74, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* ttrace_xen_cpu_write_gdt_entry */
	.byte 0x0c, 0xc6, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_xen_write_gdt_entry */
	.byte 0x0c, 0x74, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* txen_write_gdt_entry */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_xen_write_ldt_entry */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* txen_write_ldt_entry */
	.byte 0x0e, 0xc6, 0xdf, 0x05, 0x54, 0x4c, 0x53, 0x5f, 0xe6, 0x73, 0x63, 0x72, 0x0c, 0x74, 0xce	/* t__pfx_load_TLS_descriptor */
	.byte 0x0e, 0x74, 0xdf, 0x05, 0x54, 0x4c, 0x53, 0x5f, 0xe6, 0x73, 0x63, 0x72, 0x0c, 0x74, 0xce	/* tload_TLS_descriptor */
	.byte 0x08, 0xc6, 0x78, 0xe8, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* t__pfx_xen_load_idt */
	.byte 0x08, 0x74, 0x78, 0xe8, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* txen_load_idt */
	.byte 0x08, 0xc6, 0xef, 0x7c, 0xac, 0x5f, 0x6d, 0x66, 0x6e	/* t__pfx_pfn_to_mfn */
	.byte 0x08, 0x74, 0xef, 0x7c, 0xac, 0x5f, 0x6d, 0x66, 0x6e	/* tpfn_to_mfn */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x63, 0x72, 0x34	/* t__pfx_xen_write_cr4 */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x63, 0x72, 0x34	/* txen_write_cr4 */
	.byte 0x12, 0xc6, 0x78, 0xe8, 0x5f, 0xeb, 0x70, 0x69, 0xf6, 0x5d, 0x70, 0xe8, 0xe5, 0xdf, 0x77, 0xd3, 0x76, 0x65, 0x6c	/* t__pfx_xen_acpi_suspend_lowlevel */
	.byte 0x12, 0x74, 0x78, 0xe8, 0x5f, 0xeb, 0x70, 0x69, 0xf6, 0x5d, 0x70, 0xe8, 0xe5, 0xdf, 0x77, 0xd3, 0x76, 0x65, 0x6c	/* txen_acpi_suspend_lowlevel */
	.byte 0x10, 0xc6, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xab, 0xb7, 0x65, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_xen_mc_issue.constprop.0 */
	.byte 0x10, 0x74, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xab, 0xb7, 0x65, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* txen_mc_issue.constprop.0 */
	.byte 0x06, 0xc6, 0x78, 0xe8, 0x1f, 0x02, 0x74	/* t__pfx_xen_set_ldt */
	.byte 0x06, 0x74, 0x78, 0xe8, 0x1f, 0x02, 0x74	/* txen_set_ldt */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0xdf, 0xc7, 0xf6, 0x70, 0x30	/* t__pfx_xen_load_sp0 */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0xdf, 0xc7, 0xf6, 0x70, 0x30	/* txen_load_sp0 */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x63, 0x72, 0x30	/* t__pfx_xen_write_cr0 */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x63, 0x72, 0x30	/* txen_write_cr0 */
	.byte 0x0e, 0xc6, 0x78, 0xe8, 0x5f, 0xe8, 0xe5, 0x98, 0x74, 0xd1, 0xf9, 0x73, 0x77, 0xe4, 0xd0	/* t__pfx_xen_end_context_switch */
	.byte 0x0e, 0x74, 0x78, 0xe8, 0x5f, 0xe8, 0xe5, 0x98, 0x74, 0xd1, 0xf9, 0x73, 0x77, 0xe4, 0xd0	/* txen_end_context_switch */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0xdf, 0x05, 0x74, 0x6c, 0x73	/* t__pfx_xen_load_tls */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0xdf, 0x05, 0x74, 0x6c, 0x73	/* txen_load_tls */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0xdf, 0x05, 0x67, 0x64, 0x74	/* t__pfx_xen_load_gdt */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0xdf, 0x05, 0x67, 0x64, 0x74	/* txen_load_gdt */
	.byte 0x0a, 0xbf, 0x78, 0xe8, 0x5f, 0xb2, 0x1b, 0x7a, 0xc5, 0xa5, 0xe6	/* T__pfx_xen_get_lazy_mode */
	.byte 0x0a, 0x54, 0x78, 0xe8, 0x5f, 0xb2, 0x1b, 0x7a, 0xc5, 0xa5, 0xe6	/* Txen_get_lazy_mode */
	.byte 0x0d, 0xbf, 0x78, 0xe8, 0x5f, 0xfe, 0x70, 0xc5, 0xea, 0x61, 0xe2, 0xf0, 0x66, 0x6f	/* T__pfx_xen_copy_trap_info */
	.byte 0x0d, 0x54, 0x78, 0xe8, 0x5f, 0xfe, 0x70, 0xc5, 0xea, 0x61, 0xe2, 0xf0, 0x66, 0x6f	/* Txen_copy_trap_info */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0xe7, 0x74, 0xfa, 0x76, 0xe1	/* T__pfx___raw_callee_save_xen_pte_val */
	.byte 0x0f, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0xe7, 0x74, 0xfa, 0x76, 0xe1	/* T__raw_callee_save_xen_pte_val */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0xe7, 0x67, 0xe5, 0x76, 0xe1	/* T__pfx___raw_callee_save_xen_pgd_val */
	.byte 0x0f, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0xe7, 0x67, 0xe5, 0x76, 0xe1	/* T__raw_callee_save_xen_pgd_val */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x9a	/* T__pfx___raw_callee_save_xen_make_pte */
	.byte 0x10, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x9a	/* T__raw_callee_save_xen_make_pte */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x67, 0x64	/* T__pfx___raw_callee_save_xen_make_pgd */
	.byte 0x11, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x67, 0x64	/* T__raw_callee_save_xen_make_pgd */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0xe7, 0x6d, 0xe5, 0x76, 0xe1	/* T__pfx___raw_callee_save_xen_pmd_val */
	.byte 0x0f, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0xe7, 0x6d, 0xe5, 0x76, 0xe1	/* T__raw_callee_save_xen_pmd_val */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x6d, 0x64	/* T__pfx___raw_callee_save_xen_make_pmd */
	.byte 0x11, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x6d, 0x64	/* T__raw_callee_save_xen_make_pmd */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0xe7, 0x75, 0xe5, 0x76, 0xe1	/* T__pfx___raw_callee_save_xen_pud_val */
	.byte 0x0f, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0xe7, 0x75, 0xe5, 0x76, 0xe1	/* T__raw_callee_save_xen_pud_val */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0xbe, 0x64	/* T__pfx___raw_callee_save_xen_make_pud */
	.byte 0x10, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0xbe, 0x64	/* T__raw_callee_save_xen_make_pud */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0xe7, 0x34, 0xe5, 0x76, 0xe1	/* T__pfx___raw_callee_save_xen_p4d_val */
	.byte 0x0f, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0xe7, 0x34, 0xe5, 0x76, 0xe1	/* T__raw_callee_save_xen_p4d_val */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x34, 0x64	/* T__pfx___raw_callee_save_xen_make_p4d */
	.byte 0x11, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x34, 0x64	/* T__raw_callee_save_xen_make_p4d */
	.byte 0x14, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x74, 0xfa, 0x8d	/* T__pfx___raw_callee_save_xen_make_pte_init */
	.byte 0x12, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x74, 0xfa, 0x8d	/* T__raw_callee_save_xen_make_pte_init */
	.byte 0x04, 0x29, 0xe7, 0x67, 0x64	/* t__pfx___pgd */
	.byte 0x05, 0x74, 0xff, 0x70, 0x67, 0x64	/* t__pgd */
	.byte 0x06, 0xa8, 0xe7, 0x6d, 0xe5, 0x76, 0xe1	/* t__pfx_pmd_val */
	.byte 0x05, 0x06, 0x6d, 0xe5, 0x76, 0xe1	/* tpmd_val */
	.byte 0x06, 0xa8, 0xe7, 0x75, 0xe5, 0x76, 0xe1	/* t__pfx_pud_val */
	.byte 0x05, 0x74, 0xbe, 0xe5, 0x76, 0xe1	/* tpud_val */
	.byte 0x05, 0xc6, 0xef, 0x6e, 0xe7, 0x9a	/* t__pfx_pfn_pte */
	.byte 0x05, 0x74, 0xef, 0x6e, 0xe7, 0x9a	/* tpfn_pte */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0xe7, 0x61, 0x21, 0x70, 0xf0, 0xb4, 0x64	/* t__pfx_xen_page_pinned */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0xe7, 0x61, 0x21, 0x70, 0xf0, 0xb4, 0x64	/* txen_page_pinned */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0xb2, 0x5d, 0xee, 0xe7, 0x67, 0x64	/* t__pfx_xen_get_user_pgd */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0xb2, 0x5d, 0xee, 0xe7, 0x67, 0x64	/* txen_get_user_pgd */
	.byte 0x08, 0xc6, 0x78, 0xe8, 0xe7, 0x74, 0xfa, 0xd4, 0x3c	/* t__pfx_xen_pte_unlock */
	.byte 0x08, 0x74, 0x78, 0xe8, 0xe7, 0x74, 0xfa, 0xd4, 0x3c	/* txen_pte_unlock */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0xf8, 0x05, 0x63, 0x72, 0x33	/* t__pfx_xen_read_cr3 */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0xf8, 0x05, 0x63, 0x72, 0x33	/* txen_read_cr3 */
	.byte 0x0a, 0xa8, 0x1f, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x63, 0x72, 0x33	/* t__pfx_set_current_cr3 */
	.byte 0x0b, 0x74, 0xc9, 0xf9, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x63, 0x72, 0x33	/* tset_current_cr3 */
	.byte 0x0c, 0xc6, 0x78, 0xe8, 0x5f, 0xd1, 0xd0, 0xcc, 0x21, 0xbd, 0x6d, 0xce, 0x79	/* t__pfx_xen_exchange_memory */
	.byte 0x0c, 0x74, 0x78, 0xe8, 0x5f, 0xd1, 0xd0, 0xcc, 0x21, 0xbd, 0x6d, 0xce, 0x79	/* txen_exchange_memory */
	.byte 0x0c, 0xc6, 0x78, 0xe8, 0x5f, 0x1e, 0xcf, 0x1b, 0x7a, 0xc5, 0x6d, 0x6d, 0x75	/* t__pfx_xen_enter_lazy_mmu */
	.byte 0x0c, 0x74, 0x78, 0xe8, 0x5f, 0x1e, 0xcf, 0x1b, 0x7a, 0xc5, 0x6d, 0x6d, 0x75	/* txen_enter_lazy_mmu */
	.byte 0x0e, 0xc6, 0x78, 0xe8, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x1b, 0x7a, 0xc5, 0x6d, 0x6d, 0x75	/* t__pfx_xen_flush_lazy_mmu */
	.byte 0x0e, 0x74, 0x78, 0xe8, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x1b, 0x7a, 0xc5, 0x6d, 0x6d, 0x75	/* txen_flush_lazy_mmu */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x62, 0xe9, 0xd0	/* t__pfx_xen_mc_batch */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x62, 0xe9, 0xd0	/* txen_mc_batch */
	.byte 0x0a, 0xc6, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* t__pfx_trace_xen_mc_entry */
	.byte 0x0a, 0x74, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* ttrace_xen_mc_entry */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0x97, 0xe8, 0xe5, 0x6d, 0x6d, 0x75, 0xd1, 0xf9, 0x81	/* t__pfx_xen_extend_mmuext_op */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0x97, 0xe8, 0xe5, 0x6d, 0x6d, 0x75, 0xd1, 0xf9, 0x81	/* txen_extend_mmuext_op */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0x97, 0xe8, 0xe5, 0x6d, 0x6d, 0x00, 0xb9, 0x64, 0x86	/* t__pfx_xen_extend_mmu_update */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0x97, 0xe8, 0xe5, 0x6d, 0x6d, 0x00, 0xb9, 0x64, 0x86	/* txen_extend_mmu_update */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xab, 0xb7, 0x65	/* t__pfx_xen_mc_issue */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xab, 0xb7, 0x65	/* txen_mc_issue */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0xe1, 0x6c	/* t__pfx_xen_flush_tlb_all */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0xe1, 0x6c	/* txen_flush_tlb_all */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0x62	/* t__pfx_xen_flush_tlb */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0x62	/* txen_flush_tlb */
	.byte 0x07, 0xc6, 0x78, 0xe8, 0x1f, 0xb8, 0x78, 0x0a	/* t__pfx_xen_set_fixmap */
	.byte 0x07, 0x74, 0x78, 0xe8, 0x1f, 0xb8, 0x78, 0x0a	/* txen_set_fixmap */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x1f, 0xbe, 0xe5, 0x68, 0x27, 0xee	/* t__pfx_xen_set_pud_hyper */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x1f, 0xbe, 0xe5, 0x68, 0x27, 0xee	/* txen_set_pud_hyper */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x1f, 0x70, 0x6d, 0xe5, 0x68, 0x27, 0xee	/* t__pfx_xen_set_pmd_hyper */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x1f, 0x70, 0x6d, 0xe5, 0x68, 0x27, 0xee	/* txen_set_pmd_hyper */
	.byte 0x11, 0xc6, 0x78, 0xe8, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0x73, 0xdb, 0x72, 0x74	/* t__pfx_xen_ptep_modify_prot_start */
	.byte 0x11, 0x74, 0x78, 0xe8, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0x73, 0xdb, 0x72, 0x74	/* txen_ptep_modify_prot_start */
	.byte 0x08, 0xc6, 0x78, 0xe8, 0xe7, 0x67, 0xe5, 0x87, 0x65	/* t__pfx_xen_pgd_free */
	.byte 0x08, 0x74, 0x78, 0xe8, 0xe7, 0x67, 0xe5, 0x87, 0x65	/* txen_pgd_free */
	.byte 0x0c, 0xc6, 0x64, 0xde, 0xe2, 0x6d, 0xcd, 0xf8, 0xa0, 0x15, 0x69, 0xe0, 0x92	/* t__pfx_drop_mm_ref_this_cpu */
	.byte 0x0c, 0x74, 0x64, 0xde, 0xe2, 0x6d, 0xcd, 0xf8, 0xa0, 0x15, 0x69, 0xe0, 0x92	/* tdrop_mm_ref_this_cpu */
	.byte 0x0e, 0xc6, 0x78, 0xe8, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* t__pfx_xen_flush_tlb_multi */
	.byte 0x0e, 0x74, 0x78, 0xe8, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* txen_flush_tlb_multi */
	.byte 0x10, 0xc6, 0x78, 0xe8, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* t__pfx_xen_flush_tlb_one_user */
	.byte 0x10, 0x74, 0x78, 0xe8, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* txen_flush_tlb_one_user */
	.byte 0x06, 0xc6, 0x78, 0xe8, 0x1f, 0xbe, 0x64	/* t__pfx_xen_set_pud */
	.byte 0x06, 0x74, 0x78, 0xe8, 0x1f, 0xbe, 0x64	/* txen_set_pud */
	.byte 0x07, 0xc6, 0x78, 0xe8, 0x1f, 0x70, 0x6d, 0x64	/* t__pfx_xen_set_pmd */
	.byte 0x07, 0x74, 0x78, 0xe8, 0x1f, 0x70, 0x6d, 0x64	/* txen_set_pmd */
	.byte 0x0e, 0xc6, 0x78, 0xe8, 0x5f, 0xf8, 0x84, 0xd1, 0xd0, 0xcc, 0xda, 0x64, 0xe7, 0x9a, 0x73	/* t__pfx_xen_remap_exchanged_ptes */
	.byte 0x0e, 0x74, 0x78, 0xe8, 0x5f, 0xf8, 0x84, 0xd1, 0xd0, 0xcc, 0xda, 0x64, 0xe7, 0x9a, 0x73	/* txen_remap_exchanged_ptes */
	.byte 0x08, 0xbf, 0x78, 0xe8, 0x5f, 0xf8, 0x84, 0xef, 0x6e	/* T__pfx_xen_remap_pfn */
	.byte 0x08, 0x54, 0x78, 0xe8, 0x5f, 0xf8, 0x84, 0xef, 0x6e	/* Txen_remap_pfn */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0x5f, 0xd3, 0x61, 0x22, 0x1b, 0x7a, 0xc5, 0x6d, 0x6d, 0x75	/* t__pfx_xen_leave_lazy_mmu */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0x5f, 0xd3, 0x61, 0x22, 0x1b, 0x7a, 0xc5, 0x6d, 0x6d, 0x75	/* txen_leave_lazy_mmu */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* t__pfx_xen_release_ptpage */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* txen_release_ptpage */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0xbe, 0x64	/* t__pfx_xen_release_pud */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0xbe, 0x64	/* txen_release_pud */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x6d, 0x64	/* t__pfx_xen_release_pmd */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x6d, 0x64	/* txen_release_pmd */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x9a	/* t__pfx_xen_release_pte */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x9a	/* txen_release_pte */
	.byte 0x0c, 0xc6, 0x78, 0xe8, 0x5f, 0x7a, 0x61, 0xe2, 0xef, 0x7c, 0x72, 0xcc, 0xda	/* t__pfx_xen_zap_pfn_range */
	.byte 0x0c, 0x74, 0x78, 0xe8, 0x5f, 0x7a, 0x61, 0xe2, 0xef, 0x7c, 0x72, 0xcc, 0xda	/* txen_zap_pfn_range */
	.byte 0x10, 0xa8, 0xe7, 0x34, 0xe5, 0x6f, 0x66, 0x66, 0xc9, 0x74, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_p4d_offset.constprop.0 */
	.byte 0x0f, 0x06, 0x34, 0xe5, 0x6f, 0x66, 0x66, 0xc9, 0x74, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tp4d_offset.constprop.0 */
	.byte 0x07, 0xc6, 0x78, 0xe8, 0x5f, 0xa9, 0xe7, 0xf0	/* t__pfx_xen_do_pin */
	.byte 0x07, 0x74, 0x78, 0xe8, 0x5f, 0xa9, 0xe7, 0xf0	/* txen_do_pin */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0xd4, 0x70, 0xf0, 0xe7, 0x03	/* t__pfx_xen_unpin_page */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0xd4, 0x70, 0xf0, 0xe7, 0x03	/* txen_unpin_page */
	.byte 0x07, 0xc6, 0x78, 0xe8, 0xe7, 0xf0, 0xe7, 0x03	/* t__pfx_xen_pin_page */
	.byte 0x07, 0x74, 0x78, 0xe8, 0xe7, 0xf0, 0xe7, 0x03	/* txen_pin_page */
	.byte 0x0b, 0x29, 0x5f, 0x78, 0xe8, 0x1f, 0x70, 0x34, 0xe5, 0x68, 0x27, 0xee	/* t__pfx___xen_set_p4d_hyper */
	.byte 0x0b, 0x74, 0xff, 0x78, 0xe8, 0x1f, 0x70, 0x34, 0xe5, 0x68, 0x27, 0xee	/* t__xen_set_p4d_hyper */
	.byte 0x07, 0xc6, 0x78, 0xe8, 0x1f, 0x70, 0x34, 0x64	/* t__pfx_xen_set_p4d */
	.byte 0x07, 0x74, 0x78, 0xe8, 0x1f, 0x70, 0x34, 0x64	/* txen_set_p4d */
	.byte 0x0b, 0xa8, 0xe7, 0x74, 0xfa, 0xef, 0x7c, 0xac, 0x5f, 0x6d, 0x66, 0x6e	/* t__pfx_pte_pfn_to_mfn */
	.byte 0x0a, 0x06, 0x74, 0xfa, 0xef, 0x7c, 0xac, 0x5f, 0x6d, 0x66, 0x6e	/* tpte_pfn_to_mfn */
	.byte 0x11, 0xc6, 0x78, 0xe8, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0xfe, 0x6d, 0x6d, 0xe4	/* t__pfx_xen_ptep_modify_prot_commit */
	.byte 0x11, 0x74, 0x78, 0xe8, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0xfe, 0x6d, 0x6d, 0xe4	/* txen_ptep_modify_prot_commit */
	.byte 0x0e, 0xc6, 0xf8, 0x84, 0x61, 0xf8, 0x61, 0x5f, 0xef, 0x6e, 0xe7, 0x74, 0xfa, 0x66, 0x6e	/* t__pfx_remap_area_pfn_pte_fn */
	.byte 0x0e, 0x74, 0xf8, 0x84, 0x61, 0xf8, 0x61, 0x5f, 0xef, 0x6e, 0xe7, 0x74, 0xfa, 0x66, 0x6e	/* tremap_area_pfn_pte_fn */
	.byte 0x0a, 0x29, 0x5f, 0x78, 0xe8, 0xe7, 0x67, 0xe5, 0x77, 0xe1, 0x6b	/* t__pfx___xen_pgd_walk */
	.byte 0x0a, 0x74, 0xff, 0x78, 0xe8, 0xe7, 0x67, 0xe5, 0x77, 0xe1, 0x6b	/* t__xen_pgd_walk */
	.byte 0x0a, 0x29, 0x5f, 0x78, 0xe8, 0xe7, 0x67, 0xe5, 0xd4, 0x70, 0xf0	/* t__pfx___xen_pgd_unpin */
	.byte 0x0a, 0x74, 0xff, 0x78, 0xe8, 0xe7, 0x67, 0xe5, 0xd4, 0x70, 0xf0	/* t__xen_pgd_unpin */
	.byte 0x08, 0xc6, 0x78, 0xe8, 0x5f, 0xd1, 0x99, 0x6d, 0x0a	/* t__pfx_xen_exit_mmap */
	.byte 0x08, 0x74, 0x78, 0xe8, 0x5f, 0xd1, 0x99, 0x6d, 0x0a	/* txen_exit_mmap */
	.byte 0x09, 0x29, 0x5f, 0x78, 0xe8, 0xe7, 0x67, 0x64, 0xe7, 0xf0	/* t__pfx___xen_pgd_pin */
	.byte 0x09, 0x74, 0xff, 0x78, 0xe8, 0xe7, 0x67, 0x64, 0xe7, 0xf0	/* t__xen_pgd_pin */
	.byte 0x08, 0xc6, 0x78, 0xe8, 0x5f, 0x1e, 0xcf, 0x6d, 0x0a	/* t__pfx_xen_enter_mmap */
	.byte 0x08, 0x74, 0x78, 0xe8, 0x5f, 0x1e, 0xcf, 0x6d, 0x0a	/* txen_enter_mmap */
	.byte 0x08, 0xc6, 0x6d, 0x66, 0x7c, 0xac, 0x5f, 0xef, 0x6e	/* t__pfx_mfn_to_pfn */
	.byte 0x08, 0x74, 0x6d, 0x66, 0x7c, 0xac, 0x5f, 0xef, 0x6e	/* tmfn_to_pfn */
	.byte 0x0a, 0x29, 0x5f, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x63, 0x72, 0x33	/* t__pfx___xen_write_cr3 */
	.byte 0x0a, 0x74, 0xff, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x63, 0x72, 0x33	/* t__xen_write_cr3 */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x63, 0x72, 0x33	/* t__pfx_xen_write_cr3 */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0x24, 0xfa, 0x63, 0x72, 0x33	/* txen_write_cr3 */
	.byte 0x07, 0x29, 0x5f, 0x78, 0xe8, 0x1f, 0x70, 0x9a	/* t__pfx___xen_set_pte */
	.byte 0x07, 0x74, 0xff, 0x78, 0xe8, 0x1f, 0x70, 0x9a	/* t__xen_set_pte */
	.byte 0x06, 0xc6, 0x78, 0xe8, 0x1f, 0x70, 0x9a	/* t__pfx_xen_set_pte */
	.byte 0x06, 0x74, 0x78, 0xe8, 0x1f, 0x70, 0x9a	/* txen_set_pte */
	.byte 0x08, 0xc6, 0x78, 0xe8, 0xe7, 0x67, 0xe5, 0xe1, 0xc0	/* t__pfx_xen_pgd_alloc */
	.byte 0x08, 0x74, 0x78, 0xe8, 0xe7, 0x67, 0xe5, 0xe1, 0xc0	/* txen_pgd_alloc */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* t__pfx_xen_alloc_ptpage */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* txen_alloc_ptpage */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0xe1, 0xc0, 0xe7, 0x75, 0x64	/* t__pfx_xen_alloc_pud */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0xe1, 0xc0, 0xe7, 0x75, 0x64	/* txen_alloc_pud */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0xe1, 0xc0, 0xe7, 0x6d, 0x64	/* t__pfx_xen_alloc_pmd */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0xe1, 0xc0, 0xe7, 0x6d, 0x64	/* txen_alloc_pmd */
	.byte 0x08, 0xc6, 0x78, 0xe8, 0x5f, 0xe1, 0xc0, 0xe7, 0x9a	/* t__pfx_xen_alloc_pte */
	.byte 0x08, 0x74, 0x78, 0xe8, 0x5f, 0xe1, 0xc0, 0xe7, 0x9a	/* txen_alloc_pte */
	.byte 0x11, 0xbf, 0xdd, 0x6b, 0xfa, 0xdf, 0x77, 0xbd, 0x6d, 0xe7, 0x61, 0x21, 0xf8, 0xc7, 0x6f, 0x6e, 0x6c, 0x79	/* T__pfx_make_lowmem_page_readonly */
	.byte 0x11, 0x54, 0xdd, 0x6b, 0xfa, 0xdf, 0x77, 0xbd, 0x6d, 0xe7, 0x61, 0x21, 0xf8, 0xc7, 0x6f, 0x6e, 0x6c, 0x79	/* Tmake_lowmem_page_readonly */
	.byte 0x0f, 0xbf, 0xdd, 0x6b, 0xfa, 0xdf, 0x77, 0xbd, 0x6d, 0xe7, 0x61, 0x21, 0xf8, 0xc7, 0x24, 0x65	/* T__pfx_make_lowmem_page_readwrite */
	.byte 0x0f, 0x54, 0xdd, 0x6b, 0xfa, 0xdf, 0x77, 0xbd, 0x6d, 0xe7, 0x61, 0x21, 0xf8, 0xc7, 0x24, 0x65	/* Tmake_lowmem_page_readwrite */
	.byte 0x08, 0xbf, 0x78, 0xe8, 0xe7, 0x74, 0xfa, 0x76, 0xe1	/* T__pfx_xen_pte_val */
	.byte 0x08, 0x54, 0x78, 0xe8, 0xe7, 0x74, 0xfa, 0x76, 0xe1	/* Txen_pte_val */
	.byte 0x08, 0xbf, 0x78, 0xe8, 0xe7, 0x67, 0xe5, 0x76, 0xe1	/* T__pfx_xen_pgd_val */
	.byte 0x08, 0x54, 0x78, 0xe8, 0xe7, 0x67, 0xe5, 0x76, 0xe1	/* Txen_pgd_val */
	.byte 0x09, 0xbf, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x9a	/* T__pfx_xen_make_pte */
	.byte 0x09, 0x54, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x9a	/* Txen_make_pte */
	.byte 0x0a, 0xbf, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x67, 0x64	/* T__pfx_xen_make_pgd */
	.byte 0x0a, 0x54, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x67, 0x64	/* Txen_make_pgd */
	.byte 0x08, 0xbf, 0x78, 0xe8, 0xe7, 0x6d, 0xe5, 0x76, 0xe1	/* T__pfx_xen_pmd_val */
	.byte 0x08, 0x54, 0x78, 0xe8, 0xe7, 0x6d, 0xe5, 0x76, 0xe1	/* Txen_pmd_val */
	.byte 0x0a, 0xbf, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x6d, 0x64	/* T__pfx_xen_make_pmd */
	.byte 0x0a, 0x54, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x6d, 0x64	/* Txen_make_pmd */
	.byte 0x08, 0xbf, 0x78, 0xe8, 0xe7, 0x75, 0xe5, 0x76, 0xe1	/* T__pfx_xen_pud_val */
	.byte 0x08, 0x54, 0x78, 0xe8, 0xe7, 0x75, 0xe5, 0x76, 0xe1	/* Txen_pud_val */
	.byte 0x09, 0xbf, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0xbe, 0x64	/* T__pfx_xen_make_pud */
	.byte 0x09, 0x54, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0xbe, 0x64	/* Txen_make_pud */
	.byte 0x08, 0xbf, 0x78, 0xe8, 0xe7, 0x34, 0xe5, 0x76, 0xe1	/* T__pfx_xen_p4d_val */
	.byte 0x08, 0x54, 0x78, 0xe8, 0xe7, 0x34, 0xe5, 0x76, 0xe1	/* Txen_p4d_val */
	.byte 0x0a, 0xbf, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x34, 0x64	/* T__pfx_xen_make_p4d */
	.byte 0x0a, 0x54, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x34, 0x64	/* Txen_make_p4d */
	.byte 0x0b, 0xbf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0xe7, 0xf0, 0x5f, 0xe1, 0x6c	/* T__pfx_xen_mm_pin_all */
	.byte 0x0b, 0x54, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0xe7, 0xf0, 0x5f, 0xe1, 0x6c	/* Txen_mm_pin_all */
	.byte 0x0c, 0xbf, 0x78, 0xe8, 0x5f, 0x6d, 0xcd, 0xd4, 0x70, 0xf0, 0x5f, 0xe1, 0x6c	/* T__pfx_xen_mm_unpin_all */
	.byte 0x0c, 0x54, 0x78, 0xe8, 0x5f, 0x6d, 0xcd, 0xd4, 0x70, 0xf0, 0x5f, 0xe1, 0x6c	/* Txen_mm_unpin_all */
	.byte 0x0b, 0xbf, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x74, 0xfa, 0x8d	/* T__pfx_xen_make_pte_init */
	.byte 0x0b, 0x54, 0x78, 0xe8, 0x5f, 0xdd, 0x6b, 0xfa, 0x70, 0x74, 0xfa, 0x8d	/* Txen_make_pte_init */
	.byte 0x11, 0xbf, 0x78, 0xe8, 0x5f, 0x63, 0xf8, 0xa1, 0x98, 0xc2, 0x67, 0x75, 0x6f, 0x75, 0xe0, 0x9f, 0xd9, 0x6e	/* T__pfx_xen_create_contiguous_region */
	.byte 0x11, 0x54, 0x78, 0xe8, 0x5f, 0x63, 0xf8, 0xa1, 0x98, 0xc2, 0x67, 0x75, 0x6f, 0x75, 0xe0, 0x9f, 0xd9, 0x6e	/* Txen_create_contiguous_region */
	.byte 0x13, 0xbf, 0x78, 0xe8, 0x5f, 0xe6, 0x73, 0xea, 0x6f, 0xc5, 0x98, 0xc2, 0x67, 0x75, 0x6f, 0x75, 0xe0, 0x9f, 0xd9, 0x6e	/* T__pfx_xen_destroy_contiguous_region */
	.byte 0x13, 0x54, 0x78, 0xe8, 0x5f, 0xe6, 0x73, 0xea, 0x6f, 0xc5, 0x98, 0xc2, 0x67, 0x75, 0x6f, 0x75, 0xe0, 0x9f, 0xd9, 0x6e	/* Txen_destroy_contiguous_region */
	.byte 0x0f, 0x3f, 0xe7, 0x10, 0x72, 0x5f, 0x76, 0x6d, 0xfe, 0xf8, 0xf0, 0x66, 0x6f, 0x5f, 0xb6, 0x9a	/* T__pfx_paddr_vmcoreinfo_note */
	.byte 0x0f, 0x54, 0x70, 0x10, 0x72, 0x5f, 0x76, 0x6d, 0xfe, 0xf8, 0xf0, 0x66, 0x6f, 0x5f, 0xb6, 0x9a	/* Tpaddr_vmcoreinfo_note */
	.byte 0x07, 0xc6, 0x78, 0xe8, 0x5f, 0x68, 0xe1, 0x74	/* t__pfx_xen_halt */
	.byte 0x07, 0x74, 0x78, 0xe8, 0x5f, 0x68, 0xe1, 0x74	/* txen_halt */
	.byte 0x0f, 0xc6, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* t__pfx_trace_xen_mc_flush_reason */
	.byte 0x0f, 0x74, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* ttrace_xen_mc_flush_reason */
	.byte 0x0d, 0xc6, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* t__pfx_trace_xen_mc_extend_args */
	.byte 0x0d, 0x74, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* ttrace_xen_mc_extend_args */
	.byte 0x08, 0xbf, 0x6d, 0x63, 0xe7, 0xee, 0x92, 0x5f, 0x8d	/* T__pfx_mc_percpu_init */
	.byte 0x08, 0x54, 0x6d, 0x63, 0xe7, 0xee, 0x92, 0x5f, 0x8d	/* Tmc_percpu_init */
	.byte 0x0a, 0xbf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* T__pfx_xen_mc_flush */
	.byte 0x0a, 0x54, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* Txen_mc_flush */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* T__pfx___xen_mc_entry */
	.byte 0x09, 0x2f, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* T__xen_mc_entry */
	.byte 0x0c, 0xbf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* T__pfx_xen_mc_extend_args */
	.byte 0x0c, 0x54, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* Txen_mc_extend_args */
	.byte 0x0b, 0xbf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* T__pfx_xen_mc_callback */
	.byte 0x0b, 0x54, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* Txen_mc_callback */
	.byte 0x10, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0xd5, 0x64, 0x69, 0x76, 0x89, 0xfa, 0xee, 0xde, 0x72	/* Txen_asm_exc_divide_error */
	.byte 0x10, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0x78, 0xe8, 0x70, 0x76, 0x5f, 0xd1, 0xd5, 0xe6, 0xa2, 0x67	/* Txen_asm_xenpv_exc_debug */
	.byte 0x0b, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0xd5, 0xf0, 0x74, 0x33	/* Txen_asm_exc_int3 */
	.byte 0x10, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0x78, 0xe8, 0x70, 0x76, 0x5f, 0xd1, 0xd5, 0x6e, 0x6d, 0x69	/* Txen_asm_xenpv_exc_nmi */
	.byte 0x0e, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0xd5, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0x77	/* Txen_asm_exc_overflow */
	.byte 0x0d, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0xd5, 0x62, 0x6f, 0xd4, 0x64, 0x73	/* Txen_asm_exc_bounds */
	.byte 0x0e, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0xd5, 0xf0, 0x76, 0xe1, 0x69, 0xe5, 0x81	/* Txen_asm_exc_invalid_op */
	.byte 0x13, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0xd5, 0x07, 0xfa, 0xb6, 0xf9, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x80, 0xd3	/* Txen_asm_exc_device_not_available */
	.byte 0x15, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0x78, 0xe8, 0x70, 0x76, 0x5f, 0xd1, 0xd5, 0xa9, 0x75, 0x62, 0xb3, 0x66, 0x61, 0x0b, 0x74	/* Txen_asm_xenpv_exc_double_fault */
	.byte 0x14, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0xd5, 0xfe, 0x9b, 0x63, 0xba, 0x67, 0x6d, 0xbb, 0x6f, 0x76, 0xee, 0x72, 0xd4	/* Txen_asm_exc_coproc_segment_overrun */
	.byte 0x10, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0xd5, 0xf0, 0x76, 0xe1, 0x69, 0xe5, 0x74, 0x73, 0x73	/* Txen_asm_exc_invalid_tss */
	.byte 0x11, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0x63, 0xba, 0x67, 0x6d, 0xbb, 0xb6, 0xf9, 0x70, 0x3d, 0x1e	/* Txen_asm_exc_segment_not_present */
	.byte 0x0f, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0x63, 0x2a, 0xeb, 0x6b, 0xba, 0x67, 0x6d, 0x1e	/* Txen_asm_exc_stack_segment */
	.byte 0x11, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0xd5, 0x67, 0xe8, 0xee, 0xe1, 0x25, 0x9a, 0x7b, 0xd9, 0x6e	/* Txen_asm_exc_general_protection */
	.byte 0x0f, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0x63, 0xe7, 0x61, 0x21, 0x66, 0x61, 0x0b, 0x74	/* Txen_asm_exc_page_fault */
	.byte 0x16, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0x63, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0xf9, 0xa2, 0x67	/* Txen_asm_exc_spurious_interrupt_bug */
	.byte 0x12, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0xd5, 0xfe, 0x9b, 0x63, 0x3b, 0x73, 0xce, 0x5f, 0xee, 0xde, 0x72	/* Txen_asm_exc_coprocessor_error */
	.byte 0x10, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0xd5, 0xe1, 0x2c, 0x6e, 0x6d, 0xbb, 0x7e, 0x63, 0x6b	/* Txen_asm_exc_alignment_check */
	.byte 0x15, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0x78, 0xe8, 0x70, 0x76, 0x5f, 0xd1, 0xd5, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x7e, 0x63, 0x6b	/* Txen_asm_xenpv_exc_machine_check */
	.byte 0x16, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0x63, 0xf6, 0x69, 0x6d, 0xe5, 0xfe, 0x9b, 0x63, 0x3b, 0x73, 0xce, 0x5f, 0xee, 0xde, 0x72	/* Txen_asm_exc_simd_coprocessor_error */
	.byte 0x11, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xf0, 0x74, 0x38, 0x30, 0x5f, 0x65, 0x6d, 0x0b, 0xe9, 0xd9, 0x6e	/* Txen_asm_int80_emulation */
	.byte 0x13, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0xd5, 0x78, 0xe8, 0x5f, 0xd4, 0x6b, 0xb6, 0x77, 0x7c, 0xea, 0x61, 0x70	/* Txen_asm_exc_xen_unknown_trap */
	.byte 0x17, 0x54, 0x78, 0xe8, 0x5f, 0x96, 0xcd, 0xd1, 0xd5, 0x78, 0xe8, 0x5f, 0x68, 0x27, 0xee, 0x76, 0xab, 0xce, 0x5f, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* Txen_asm_exc_xen_hypervisor_callback */
	.byte 0x07, 0x54, 0x78, 0xe8, 0x5f, 0x69, 0xf8, 0x74	/* Txen_iret */
	.byte 0x18, 0x54, 0x78, 0xe8, 0x70, 0x76, 0x5f, 0xf8, 0xd6, 0xce, 0xfa, 0x9f, 0xe0, 0xcc, 0xe5, 0xf8, 0x74, 0x1d, 0x7c, 0xac, 0x5f, 0x5d, 0xee, 0xa5, 0xe6	/* Txenpv_restore_regs_and_return_to_usermode */
	.byte 0x11, 0x54, 0x78, 0xe8, 0x5f, 0xe8, 0xea, 0xc5, 0x53, 0x59, 0x53, 0x43, 0x41, 0x4c, 0x4c, 0x5f, 0x36, 0x34	/* Txen_entry_SYSCALL_64 */
	.byte 0x11, 0x54, 0x78, 0xe8, 0x5f, 0xe8, 0xea, 0xc5, 0x53, 0x59, 0x53, 0x43, 0x41, 0x4c, 0x4c, 0x5f, 0x09, 0xe9	/* Txen_entry_SYSCALL_compat */
	.byte 0x12, 0x54, 0x78, 0xe8, 0x5f, 0xe8, 0xea, 0xc5, 0x53, 0x59, 0x53, 0x45, 0x4e, 0x54, 0x45, 0x52, 0x5f, 0x09, 0xe9	/* Txen_entry_SYSENTER_compat */
	.byte 0x0c, 0xbf, 0x78, 0xe8, 0xe7, 0x76, 0x68, 0xba, 0x74, 0x3a, 0x67, 0x73, 0x69	/* T__pfx_xen_pvh_setup_gsi */
	.byte 0x0c, 0x54, 0x78, 0xe8, 0xe7, 0x76, 0x68, 0xba, 0x74, 0x3a, 0x67, 0x73, 0x69	/* Txen_pvh_setup_gsi */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x62, 0xe9, 0xd0	/* T__pfx___traceiter_xen_mc_batch */
	.byte 0x0c, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x62, 0xe9, 0xd0	/* T__traceiter_xen_mc_batch */
	.byte 0x0f, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x62, 0xe9, 0xd0	/* T__pfx___probestub_xen_mc_batch */
	.byte 0x0e, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x62, 0xe9, 0xd0	/* T__probestub_xen_mc_batch */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xab, 0xb7, 0x65	/* T__pfx___traceiter_xen_mc_issue */
	.byte 0x0c, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xab, 0xb7, 0x65	/* T__traceiter_xen_mc_issue */
	.byte 0x0f, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xab, 0xb7, 0x65	/* T__pfx___probestub_xen_mc_issue */
	.byte 0x0e, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xab, 0xb7, 0x65	/* T__probestub_xen_mc_issue */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_xen_mc_entry */
	.byte 0x0c, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* T__traceiter_xen_mc_entry */
	.byte 0x0f, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* T__pfx___probestub_xen_mc_entry */
	.byte 0x0e, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* T__probestub_xen_mc_entry */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0xc5, 0xe1, 0xc0	/* T__pfx___traceiter_xen_mc_entry_alloc */
	.byte 0x0e, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0xc5, 0xe1, 0xc0	/* T__traceiter_xen_mc_entry_alloc */
	.byte 0x11, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0xc5, 0xe1, 0xc0	/* T__pfx___probestub_xen_mc_entry_alloc */
	.byte 0x10, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0xc5, 0xe1, 0xc0	/* T__probestub_xen_mc_entry_alloc */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* T__pfx___traceiter_xen_mc_callback */
	.byte 0x0e, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* T__traceiter_xen_mc_callback */
	.byte 0x11, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* T__pfx___probestub_xen_mc_callback */
	.byte 0x10, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* T__probestub_xen_mc_callback */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* T__pfx___traceiter_xen_mc_flush_reason */
	.byte 0x11, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* T__traceiter_xen_mc_flush_reason */
	.byte 0x14, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* T__pfx___probestub_xen_mc_flush_reason */
	.byte 0x13, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* T__probestub_xen_mc_flush_reason */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* T__pfx___traceiter_xen_mc_flush */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* T__traceiter_xen_mc_flush */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* T__pfx___probestub_xen_mc_flush */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* T__probestub_xen_mc_flush */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* T__pfx___traceiter_xen_mc_extend_args */
	.byte 0x0f, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* T__traceiter_xen_mc_extend_args */
	.byte 0x12, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* T__pfx___probestub_xen_mc_extend_args */
	.byte 0x11, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* T__probestub_xen_mc_extend_args */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x9a	/* T__pfx___traceiter_xen_mmu_set_pte */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x9a	/* T__traceiter_xen_mmu_set_pte */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x9a	/* T__pfx___probestub_xen_mmu_set_pte */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x9a	/* T__probestub_xen_mmu_set_pte */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x6d, 0x64	/* T__pfx___traceiter_xen_mmu_set_pmd */
	.byte 0x0e, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x6d, 0x64	/* T__traceiter_xen_mmu_set_pmd */
	.byte 0x11, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x6d, 0x64	/* T__pfx___probestub_xen_mmu_set_pmd */
	.byte 0x10, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x6d, 0x64	/* T__probestub_xen_mmu_set_pmd */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0xbe, 0x64	/* T__pfx___traceiter_xen_mmu_set_pud */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0xbe, 0x64	/* T__traceiter_xen_mmu_set_pud */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0xbe, 0x64	/* T__pfx___probestub_xen_mmu_set_pud */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0xbe, 0x64	/* T__probestub_xen_mmu_set_pud */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x34, 0x64	/* T__pfx___traceiter_xen_mmu_set_p4d */
	.byte 0x0e, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x34, 0x64	/* T__traceiter_xen_mmu_set_p4d */
	.byte 0x11, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x34, 0x64	/* T__pfx___probestub_xen_mmu_set_p4d */
	.byte 0x10, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x34, 0x64	/* T__probestub_xen_mmu_set_p4d */
	.byte 0x1a, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0x73, 0xdb, 0x72, 0x74	/* T__pfx___traceiter_xen_mmu_ptep_modify_prot_start */
	.byte 0x18, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0x73, 0xdb, 0x72, 0x74	/* T__traceiter_xen_mmu_ptep_modify_prot_start */
	.byte 0x1b, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0x73, 0xdb, 0x72, 0x74	/* T__pfx___probestub_xen_mmu_ptep_modify_prot_start */
	.byte 0x1a, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0x73, 0xdb, 0x72, 0x74	/* T__probestub_xen_mmu_ptep_modify_prot_start */
	.byte 0x1a, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0xfe, 0x6d, 0x6d, 0xe4	/* T__pfx___traceiter_xen_mmu_ptep_modify_prot_commit */
	.byte 0x18, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0xfe, 0x6d, 0x6d, 0xe4	/* T__traceiter_xen_mmu_ptep_modify_prot_commit */
	.byte 0x1b, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0xfe, 0x6d, 0x6d, 0xe4	/* T__pfx___probestub_xen_mmu_ptep_modify_prot_commit */
	.byte 0x1a, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0xfe, 0x6d, 0x6d, 0xe4	/* T__probestub_xen_mmu_ptep_modify_prot_commit */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* T__pfx___traceiter_xen_mmu_alloc_ptpage */
	.byte 0x0f, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* T__traceiter_xen_mmu_alloc_ptpage */
	.byte 0x12, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* T__pfx___probestub_xen_mmu_alloc_ptpage */
	.byte 0x11, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* T__probestub_xen_mmu_alloc_ptpage */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* T__pfx___traceiter_xen_mmu_release_ptpage */
	.byte 0x11, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* T__traceiter_xen_mmu_release_ptpage */
	.byte 0x14, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* T__pfx___probestub_xen_mmu_release_ptpage */
	.byte 0x13, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* T__probestub_xen_mmu_release_ptpage */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0x64, 0xe7, 0xf0	/* T__pfx___traceiter_xen_mmu_pgd_pin */
	.byte 0x0f, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0x64, 0xe7, 0xf0	/* T__traceiter_xen_mmu_pgd_pin */
	.byte 0x12, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0x64, 0xe7, 0xf0	/* T__pfx___probestub_xen_mmu_pgd_pin */
	.byte 0x11, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0x64, 0xe7, 0xf0	/* T__probestub_xen_mmu_pgd_pin */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0xe5, 0xd4, 0x70, 0xf0	/* T__pfx___traceiter_xen_mmu_pgd_unpin */
	.byte 0x10, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0xe5, 0xd4, 0x70, 0xf0	/* T__traceiter_xen_mmu_pgd_unpin */
	.byte 0x13, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0xe5, 0xd4, 0x70, 0xf0	/* T__pfx___probestub_xen_mmu_pgd_unpin */
	.byte 0x12, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0xe5, 0xd4, 0x70, 0xf0	/* T__probestub_xen_mmu_pgd_unpin */
	.byte 0x18, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* T__pfx___traceiter_xen_mmu_flush_tlb_one_user */
	.byte 0x16, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* T__traceiter_xen_mmu_flush_tlb_one_user */
	.byte 0x19, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* T__pfx___probestub_xen_mmu_flush_tlb_one_user */
	.byte 0x18, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* T__probestub_xen_mmu_flush_tlb_one_user */
	.byte 0x16, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* T__pfx___traceiter_xen_mmu_flush_tlb_multi */
	.byte 0x14, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* T__traceiter_xen_mmu_flush_tlb_multi */
	.byte 0x17, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* T__pfx___probestub_xen_mmu_flush_tlb_multi */
	.byte 0x16, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* T__probestub_xen_mmu_flush_tlb_multi */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x24, 0xfa, 0x63, 0x72, 0x33	/* T__pfx___traceiter_xen_mmu_write_cr3 */
	.byte 0x0f, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x24, 0xfa, 0x63, 0x72, 0x33	/* T__traceiter_xen_mmu_write_cr3 */
	.byte 0x12, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x24, 0xfa, 0x63, 0x72, 0x33	/* T__pfx___probestub_xen_mmu_write_cr3 */
	.byte 0x11, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x24, 0xfa, 0x63, 0x72, 0x33	/* T__probestub_xen_mmu_write_cr3 */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_xen_cpu_write_ldt_entry */
	.byte 0x10, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* T__traceiter_xen_cpu_write_ldt_entry */
	.byte 0x13, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* T__pfx___probestub_xen_cpu_write_ldt_entry */
	.byte 0x12, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* T__probestub_xen_cpu_write_ldt_entry */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_xen_cpu_write_idt_entry */
	.byte 0x10, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* T__traceiter_xen_cpu_write_idt_entry */
	.byte 0x13, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* T__pfx___probestub_xen_cpu_write_idt_entry */
	.byte 0x12, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* T__probestub_xen_cpu_write_idt_entry */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* T__pfx___traceiter_xen_cpu_load_idt */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* T__traceiter_xen_cpu_load_idt */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* T__pfx___probestub_xen_cpu_load_idt */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* T__probestub_xen_cpu_load_idt */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_xen_cpu_write_gdt_entry */
	.byte 0x11, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* T__traceiter_xen_cpu_write_gdt_entry */
	.byte 0x14, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* T__pfx___probestub_xen_cpu_write_gdt_entry */
	.byte 0x13, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* T__probestub_xen_cpu_write_gdt_entry */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x92, 0x1f, 0x02, 0x74	/* T__pfx___traceiter_xen_cpu_set_ldt */
	.byte 0x0b, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0xe8, 0x5f, 0x92, 0x1f, 0x02, 0x74	/* T__traceiter_xen_cpu_set_ldt */
	.byte 0x0e, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x92, 0x1f, 0x02, 0x74	/* T__pfx___probestub_xen_cpu_set_ldt */
	.byte 0x0d, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0xe8, 0x5f, 0x92, 0x1f, 0x02, 0x74	/* T__probestub_xen_cpu_set_ldt */
	.byte 0x0c, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x1f, 0x02, 0x74	/* t__pfx_perf_trace_xen_cpu_set_ldt */
	.byte 0x0b, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x1f, 0x02, 0x74	/* tperf_trace_xen_cpu_set_ldt */
	.byte 0x12, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_perf_trace_xen_cpu_write_gdt_entry */
	.byte 0x11, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* tperf_trace_xen_cpu_write_gdt_entry */
	.byte 0x0e, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* t__pfx_perf_trace_xen_cpu_load_idt */
	.byte 0x0d, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* tperf_trace_xen_cpu_load_idt */
	.byte 0x11, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_perf_trace_xen_cpu_write_idt_entry */
	.byte 0x10, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* tperf_trace_xen_cpu_write_idt_entry */
	.byte 0x11, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_perf_trace_xen_cpu_write_ldt_entry */
	.byte 0x10, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* tperf_trace_xen_cpu_write_ldt_entry */
	.byte 0x10, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x24, 0xfa, 0x63, 0x72, 0x33	/* t__pfx_perf_trace_xen_mmu_write_cr3 */
	.byte 0x0f, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x24, 0xfa, 0x63, 0x72, 0x33	/* tperf_trace_xen_mmu_write_cr3 */
	.byte 0x17, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* t__pfx_perf_trace_xen_mmu_flush_tlb_one_user */
	.byte 0x16, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* tperf_trace_xen_mmu_flush_tlb_one_user */
	.byte 0x0e, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0x64	/* t__pfx_perf_trace_xen_mmu_pgd */
	.byte 0x0d, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0x64	/* tperf_trace_xen_mmu_pgd */
	.byte 0x12, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* t__pfx_perf_trace_xen_mmu_release_ptpage */
	.byte 0x11, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* tperf_trace_xen_mmu_release_ptpage */
	.byte 0x10, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* t__pfx_perf_trace_xen_mmu_alloc_ptpage */
	.byte 0x0f, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* tperf_trace_xen_mmu_alloc_ptpage */
	.byte 0x15, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0x74	/* t__pfx_perf_trace_xen_mmu_ptep_modify_prot */
	.byte 0x14, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0x74	/* tperf_trace_xen_mmu_ptep_modify_prot */
	.byte 0x0f, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x34, 0x64	/* t__pfx_perf_trace_xen_mmu_set_p4d */
	.byte 0x0e, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x34, 0x64	/* tperf_trace_xen_mmu_set_p4d */
	.byte 0x0e, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0xbe, 0x64	/* t__pfx_perf_trace_xen_mmu_set_pud */
	.byte 0x0d, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0xbe, 0x64	/* tperf_trace_xen_mmu_set_pud */
	.byte 0x0f, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x6d, 0x64	/* t__pfx_perf_trace_xen_mmu_set_pmd */
	.byte 0x0e, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x6d, 0x64	/* tperf_trace_xen_mmu_set_pmd */
	.byte 0x10, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xff, 0xc9, 0xf9, 0x70, 0x9a	/* t__pfx_perf_trace_xen_mmu__set_pte */
	.byte 0x0f, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xff, 0xc9, 0xf9, 0x70, 0x9a	/* tperf_trace_xen_mmu__set_pte */
	.byte 0x10, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* t__pfx_perf_trace_xen_mc_extend_args */
	.byte 0x0f, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* tperf_trace_xen_mc_extend_args */
	.byte 0x0e, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* t__pfx_perf_trace_xen_mc_flush */
	.byte 0x0d, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* tperf_trace_xen_mc_flush */
	.byte 0x12, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* t__pfx_perf_trace_xen_mc_flush_reason */
	.byte 0x11, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* tperf_trace_xen_mc_flush_reason */
	.byte 0x0f, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_perf_trace_xen_mc_callback */
	.byte 0x0e, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tperf_trace_xen_mc_callback */
	.byte 0x0f, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0xc5, 0xe1, 0xc0	/* t__pfx_perf_trace_xen_mc_entry_alloc */
	.byte 0x0e, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0xc5, 0xe1, 0xc0	/* tperf_trace_xen_mc_entry_alloc */
	.byte 0x0e, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x63, 0xff, 0x62, 0xe9, 0xd0	/* t__pfx_perf_trace_xen_mc__batch */
	.byte 0x0d, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x63, 0xff, 0x62, 0xe9, 0xd0	/* tperf_trace_xen_mc__batch */
	.byte 0x0c, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x92, 0x1f, 0x02, 0x74	/* t__pfx_trace_event_raw_event_xen_cpu_set_ldt */
	.byte 0x0c, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x92, 0x1f, 0x02, 0x74	/* ttrace_event_raw_event_xen_cpu_set_ldt */
	.byte 0x12, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_trace_event_raw_event_xen_cpu_write_gdt_entry */
	.byte 0x12, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* ttrace_event_raw_event_xen_cpu_write_gdt_entry */
	.byte 0x0e, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* t__pfx_trace_event_raw_event_xen_cpu_load_idt */
	.byte 0x0e, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* ttrace_event_raw_event_xen_cpu_load_idt */
	.byte 0x11, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_trace_event_raw_event_xen_cpu_write_ldt_entry */
	.byte 0x11, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* ttrace_event_raw_event_xen_cpu_write_ldt_entry */
	.byte 0x10, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x24, 0xfa, 0x63, 0x72, 0x33	/* t__pfx_trace_event_raw_event_xen_mmu_write_cr3 */
	.byte 0x10, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x24, 0xfa, 0x63, 0x72, 0x33	/* ttrace_event_raw_event_xen_mmu_write_cr3 */
	.byte 0x17, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* t__pfx_trace_event_raw_event_xen_mmu_flush_tlb_one_user */
	.byte 0x17, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* ttrace_event_raw_event_xen_mmu_flush_tlb_one_user */
	.byte 0x0e, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0x64	/* t__pfx_trace_event_raw_event_xen_mmu_pgd */
	.byte 0x0e, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0x64	/* ttrace_event_raw_event_xen_mmu_pgd */
	.byte 0x12, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* t__pfx_trace_event_raw_event_xen_mmu_release_ptpage */
	.byte 0x12, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* ttrace_event_raw_event_xen_mmu_release_ptpage */
	.byte 0x10, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* t__pfx_trace_event_raw_event_xen_mmu_alloc_ptpage */
	.byte 0x10, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* ttrace_event_raw_event_xen_mmu_alloc_ptpage */
	.byte 0x15, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0x74	/* t__pfx_trace_event_raw_event_xen_mmu_ptep_modify_prot */
	.byte 0x15, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0x74	/* ttrace_event_raw_event_xen_mmu_ptep_modify_prot */
	.byte 0x0e, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0xbe, 0x64	/* t__pfx_trace_event_raw_event_xen_mmu_set_pud */
	.byte 0x0e, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0xbe, 0x64	/* ttrace_event_raw_event_xen_mmu_set_pud */
	.byte 0x0f, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x6d, 0x64	/* t__pfx_trace_event_raw_event_xen_mmu_set_pmd */
	.byte 0x0f, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x6d, 0x64	/* ttrace_event_raw_event_xen_mmu_set_pmd */
	.byte 0x10, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xff, 0xc9, 0xf9, 0x70, 0x9a	/* t__pfx_trace_event_raw_event_xen_mmu__set_pte */
	.byte 0x10, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xff, 0xc9, 0xf9, 0x70, 0x9a	/* ttrace_event_raw_event_xen_mmu__set_pte */
	.byte 0x10, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* t__pfx_trace_event_raw_event_xen_mc_extend_args */
	.byte 0x10, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* ttrace_event_raw_event_xen_mc_extend_args */
	.byte 0x0e, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* t__pfx_trace_event_raw_event_xen_mc_flush */
	.byte 0x0e, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* ttrace_event_raw_event_xen_mc_flush */
	.byte 0x12, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* t__pfx_trace_event_raw_event_xen_mc_flush_reason */
	.byte 0x12, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* ttrace_event_raw_event_xen_mc_flush_reason */
	.byte 0x0f, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_trace_event_raw_event_xen_mc_callback */
	.byte 0x0f, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* ttrace_event_raw_event_xen_mc_callback */
	.byte 0x0f, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0xc5, 0xe1, 0xc0	/* t__pfx_trace_event_raw_event_xen_mc_entry_alloc */
	.byte 0x0f, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0xc5, 0xe1, 0xc0	/* ttrace_event_raw_event_xen_mc_entry_alloc */
	.byte 0x0e, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x63, 0xff, 0x62, 0xe9, 0xd0	/* t__pfx_trace_event_raw_event_xen_mc__batch */
	.byte 0x0e, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x63, 0xff, 0x62, 0xe9, 0xd0	/* ttrace_event_raw_event_xen_mc__batch */
	.byte 0x0e, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x92, 0x1f, 0x02, 0x74	/* t__pfx_trace_raw_output_xen_cpu_set_ldt */
	.byte 0x0e, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x92, 0x1f, 0x02, 0x74	/* ttrace_raw_output_xen_cpu_set_ldt */
	.byte 0x14, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_trace_raw_output_xen_cpu_write_gdt_entry */
	.byte 0x14, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* ttrace_raw_output_xen_cpu_write_gdt_entry */
	.byte 0x10, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* t__pfx_trace_raw_output_xen_cpu_load_idt */
	.byte 0x10, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* ttrace_raw_output_xen_cpu_load_idt */
	.byte 0x13, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_trace_raw_output_xen_cpu_write_idt_entry */
	.byte 0x13, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* ttrace_raw_output_xen_cpu_write_idt_entry */
	.byte 0x13, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_trace_raw_output_xen_cpu_write_ldt_entry */
	.byte 0x13, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* ttrace_raw_output_xen_cpu_write_ldt_entry */
	.byte 0x12, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x24, 0xfa, 0x63, 0x72, 0x33	/* t__pfx_trace_raw_output_xen_mmu_write_cr3 */
	.byte 0x12, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x24, 0xfa, 0x63, 0x72, 0x33	/* ttrace_raw_output_xen_mmu_write_cr3 */
	.byte 0x17, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* t__pfx_trace_raw_output_xen_mmu_flush_tlb_multi */
	.byte 0x17, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* ttrace_raw_output_xen_mmu_flush_tlb_multi */
	.byte 0x19, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* t__pfx_trace_raw_output_xen_mmu_flush_tlb_one_user */
	.byte 0x19, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* ttrace_raw_output_xen_mmu_flush_tlb_one_user */
	.byte 0x10, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0x64	/* t__pfx_trace_raw_output_xen_mmu_pgd */
	.byte 0x10, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0x64	/* ttrace_raw_output_xen_mmu_pgd */
	.byte 0x14, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* t__pfx_trace_raw_output_xen_mmu_release_ptpage */
	.byte 0x14, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* ttrace_raw_output_xen_mmu_release_ptpage */
	.byte 0x12, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* t__pfx_trace_raw_output_xen_mmu_alloc_ptpage */
	.byte 0x12, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* ttrace_raw_output_xen_mmu_alloc_ptpage */
	.byte 0x17, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0x74	/* t__pfx_trace_raw_output_xen_mmu_ptep_modify_prot */
	.byte 0x17, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0x74	/* ttrace_raw_output_xen_mmu_ptep_modify_prot */
	.byte 0x11, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x34, 0x64	/* t__pfx_trace_raw_output_xen_mmu_set_p4d */
	.byte 0x11, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x34, 0x64	/* ttrace_raw_output_xen_mmu_set_p4d */
	.byte 0x10, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0xbe, 0x64	/* t__pfx_trace_raw_output_xen_mmu_set_pud */
	.byte 0x10, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0xbe, 0x64	/* ttrace_raw_output_xen_mmu_set_pud */
	.byte 0x11, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x6d, 0x64	/* t__pfx_trace_raw_output_xen_mmu_set_pmd */
	.byte 0x11, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x6d, 0x64	/* ttrace_raw_output_xen_mmu_set_pmd */
	.byte 0x12, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* t__pfx_trace_raw_output_xen_mc_extend_args */
	.byte 0x12, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* ttrace_raw_output_xen_mc_extend_args */
	.byte 0x10, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* t__pfx_trace_raw_output_xen_mc_flush */
	.byte 0x10, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* ttrace_raw_output_xen_mc_flush */
	.byte 0x14, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* t__pfx_trace_raw_output_xen_mc_flush_reason */
	.byte 0x14, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* ttrace_raw_output_xen_mc_flush_reason */
	.byte 0x11, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_trace_raw_output_xen_mc_callback */
	.byte 0x11, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* ttrace_raw_output_xen_mc_callback */
	.byte 0x11, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0xc5, 0xe1, 0xc0	/* t__pfx_trace_raw_output_xen_mc_entry_alloc */
	.byte 0x11, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0xc5, 0xe1, 0xc0	/* ttrace_raw_output_xen_mc_entry_alloc */
	.byte 0x0f, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* t__pfx_trace_raw_output_xen_mc_entry */
	.byte 0x0f, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* ttrace_raw_output_xen_mc_entry */
	.byte 0x10, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x63, 0xff, 0x62, 0xe9, 0xd0	/* t__pfx_trace_raw_output_xen_mc__batch */
	.byte 0x10, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x63, 0xff, 0x62, 0xe9, 0xd0	/* ttrace_raw_output_xen_mc__batch */
	.byte 0x0d, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* t__pfx_perf_trace_xen_mc_entry */
	.byte 0x0c, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* tperf_trace_xen_mc_entry */
	.byte 0x0d, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* t__pfx_trace_event_raw_event_xen_mc_entry */
	.byte 0x0d, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* ttrace_event_raw_event_xen_mc_entry */
	.byte 0x15, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* t__pfx_perf_trace_xen_mmu_flush_tlb_multi */
	.byte 0x14, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* tperf_trace_xen_mmu_flush_tlb_multi */
	.byte 0x15, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* t__pfx_trace_event_raw_event_xen_mmu_flush_tlb_multi */
	.byte 0x15, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* ttrace_event_raw_event_xen_mmu_flush_tlb_multi */
	.byte 0x0d, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* t__pfx___bpf_trace_xen_cpu_load_idt */
	.byte 0x0d, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0xdf, 0x05, 0x89, 0x74	/* t__bpf_trace_xen_cpu_load_idt */
	.byte 0x16, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* t__pfx___bpf_trace_xen_mmu_flush_tlb_one_user */
	.byte 0x16, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* t__bpf_trace_xen_mmu_flush_tlb_one_user */
	.byte 0x11, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* t__pfx___bpf_trace_xen_mc_flush_reason */
	.byte 0x11, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x96, 0x6f, 0x6e	/* t__bpf_trace_xen_mc_flush_reason */
	.byte 0x0e, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0xc5, 0xe1, 0xc0	/* t__pfx___bpf_trace_xen_mc_entry_alloc */
	.byte 0x0e, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0xc5, 0xe1, 0xc0	/* t__bpf_trace_xen_mc_entry_alloc */
	.byte 0x0d, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x63, 0xff, 0x62, 0xe9, 0xd0	/* t__pfx___bpf_trace_xen_mc__batch */
	.byte 0x0d, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x63, 0xff, 0x62, 0xe9, 0xd0	/* t__bpf_trace_xen_mc__batch */
	.byte 0x0b, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x1f, 0x02, 0x74	/* t__pfx___bpf_trace_xen_cpu_set_ldt */
	.byte 0x0b, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x1f, 0x02, 0x74	/* t__bpf_trace_xen_cpu_set_ldt */
	.byte 0x0f, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x24, 0xfa, 0x63, 0x72, 0x33	/* t__pfx___bpf_trace_xen_mmu_write_cr3 */
	.byte 0x0f, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x24, 0xfa, 0x63, 0x72, 0x33	/* t__bpf_trace_xen_mmu_write_cr3 */
	.byte 0x0d, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0x64	/* t__pfx___bpf_trace_xen_mmu_pgd */
	.byte 0x0d, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x67, 0x64	/* t__bpf_trace_xen_mmu_pgd */
	.byte 0x0d, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0xbe, 0x64	/* t__pfx___bpf_trace_xen_mmu_set_pud */
	.byte 0x0d, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0xbe, 0x64	/* t__bpf_trace_xen_mmu_set_pud */
	.byte 0x0e, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x6d, 0x64	/* t__pfx___bpf_trace_xen_mmu_set_pmd */
	.byte 0x0e, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x6d, 0x64	/* t__bpf_trace_xen_mmu_set_pmd */
	.byte 0x0f, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xff, 0xc9, 0xf9, 0x70, 0x9a	/* t__pfx___bpf_trace_xen_mmu__set_pte */
	.byte 0x0f, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xff, 0xc9, 0xf9, 0x70, 0x9a	/* t__bpf_trace_xen_mmu__set_pte */
	.byte 0x0e, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx___bpf_trace_xen_mc_callback */
	.byte 0x0e, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__bpf_trace_xen_mc_callback */
	.byte 0x0c, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* t__pfx___bpf_trace_xen_mc_entry */
	.byte 0x0c, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0xe8, 0xea, 0x79	/* t__bpf_trace_xen_mc_entry */
	.byte 0x10, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx___bpf_trace_xen_cpu_write_idt_entry */
	.byte 0x10, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* t__bpf_trace_xen_cpu_write_idt_entry */
	.byte 0x10, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx___bpf_trace_xen_cpu_write_ldt_entry */
	.byte 0x10, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* t__bpf_trace_xen_cpu_write_ldt_entry */
	.byte 0x11, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* t__pfx___bpf_trace_xen_mmu_release_ptpage */
	.byte 0x11, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0x06, 0x03	/* t__bpf_trace_xen_mmu_release_ptpage */
	.byte 0x0e, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x34, 0x64	/* t__pfx___bpf_trace_xen_mmu_set_p4d */
	.byte 0x0e, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x34, 0x64	/* t__bpf_trace_xen_mmu_set_p4d */
	.byte 0x0f, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* t__pfx___bpf_trace_xen_mc_extend_args */
	.byte 0x0f, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x97, 0xe8, 0xe5, 0xca, 0x67, 0x73	/* t__bpf_trace_xen_mc_extend_args */
	.byte 0x0d, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* t__pfx___bpf_trace_xen_mc_flush */
	.byte 0x0d, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0xd5, 0x66, 0x6c, 0x5d, 0x68	/* t__bpf_trace_xen_mc_flush */
	.byte 0x11, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx___bpf_trace_xen_cpu_write_gdt_entry */
	.byte 0x11, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* t__bpf_trace_xen_cpu_write_gdt_entry */
	.byte 0x14, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* t__pfx___bpf_trace_xen_mmu_flush_tlb_multi */
	.byte 0x14, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* t__bpf_trace_xen_mmu_flush_tlb_multi */
	.byte 0x0f, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* t__pfx___bpf_trace_xen_mmu_alloc_ptpage */
	.byte 0x0f, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x00, 0xe1, 0xc0, 0xe7, 0x06, 0x03	/* t__bpf_trace_xen_mmu_alloc_ptpage */
	.byte 0x14, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0x74	/* t__pfx___bpf_trace_xen_mmu_ptep_modify_prot */
	.byte 0x14, 0x74, 0xff, 0x40, 0xc8, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0x74	/* t__bpf_trace_xen_mmu_ptep_modify_prot */
	.byte 0x11, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_trace_event_raw_event_xen_cpu_write_idt_entry */
	.byte 0x11, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* ttrace_event_raw_event_xen_cpu_write_idt_entry */
	.byte 0x0f, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x34, 0x64	/* t__pfx_trace_event_raw_event_xen_mmu_set_p4d */
	.byte 0x0f, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0x1f, 0x70, 0x34, 0x64	/* ttrace_event_raw_event_xen_mmu_set_p4d */
	.byte 0x12, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xff, 0xc9, 0xf9, 0x70, 0x9a	/* t__pfx_trace_raw_output_xen_mmu__set_pte */
	.byte 0x12, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0xe8, 0x5f, 0x6d, 0x6d, 0x75, 0xff, 0xc9, 0xf9, 0x70, 0x9a	/* ttrace_raw_output_xen_mmu__set_pte */
	.byte 0x0f, 0xc6, 0x78, 0xe8, 0x5f, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx_xen_reschedule_interrupt */
	.byte 0x0f, 0x74, 0x78, 0xe8, 0x5f, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* txen_reschedule_interrupt */
	.byte 0x14, 0xc6, 0x78, 0xe8, 0x5f, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xb3, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx_xen_call_function_single_interrupt */
	.byte 0x14, 0x74, 0x78, 0xe8, 0x5f, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xb3, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* txen_call_function_single_interrupt */
	.byte 0x10, 0xc6, 0x78, 0xe8, 0x5f, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x7c, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx_xen_call_function_interrupt */
	.byte 0x10, 0x74, 0x78, 0xe8, 0x5f, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x7c, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* txen_call_function_interrupt */
	.byte 0x0d, 0x29, 0x5f, 0x78, 0xe8, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* t__pfx___xen_send_IPI_mask */
	.byte 0x0d, 0x74, 0xff, 0x78, 0xe8, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* t__xen_send_IPI_mask */
	.byte 0x0b, 0xbf, 0x78, 0xe8, 0xf6, 0x6d, 0xe2, 0xf0, 0xea, 0x5f, 0x87, 0x65	/* T__pfx_xen_smp_intr_free */
	.byte 0x0b, 0x54, 0x78, 0xe8, 0xf6, 0x6d, 0xe2, 0xf0, 0xea, 0x5f, 0x87, 0x65	/* Txen_smp_intr_free */
	.byte 0x0a, 0xbf, 0x78, 0xe8, 0xf6, 0x6d, 0xe2, 0xf0, 0xea, 0x5f, 0x8d	/* T__pfx_xen_smp_intr_init */
	.byte 0x0a, 0x54, 0x78, 0xe8, 0xf6, 0x6d, 0xe2, 0xf0, 0xea, 0x5f, 0x8d	/* Txen_smp_intr_init */
	.byte 0x0d, 0xbf, 0x78, 0xe8, 0xf6, 0xb0, 0xf6, 0xe8, 0xe5, 0x3d, 0x7e, 0x64, 0x75, 0xd3	/* T__pfx_xen_smp_send_reschedule */
	.byte 0x0d, 0x54, 0x78, 0xe8, 0xf6, 0xb0, 0xf6, 0xe8, 0xe5, 0x3d, 0x7e, 0x64, 0x75, 0xd3	/* Txen_smp_send_reschedule */
	.byte 0x10, 0xbf, 0x78, 0xe8, 0xf6, 0xb0, 0xf6, 0xe8, 0xe5, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x7c, 0x0c, 0x69	/* T__pfx_xen_smp_send_call_function_ipi */
	.byte 0x10, 0x54, 0x78, 0xe8, 0xf6, 0xb0, 0xf6, 0xe8, 0xe5, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x7c, 0x0c, 0x69	/* Txen_smp_send_call_function_ipi */
	.byte 0x14, 0xbf, 0x78, 0xe8, 0xf6, 0xb0, 0xf6, 0xe8, 0xe5, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xb3, 0x0c, 0x69	/* T__pfx_xen_smp_send_call_function_single_ipi */
	.byte 0x14, 0x54, 0x78, 0xe8, 0xf6, 0xb0, 0xf6, 0xe8, 0xe5, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xb3, 0x0c, 0x69	/* Txen_smp_send_call_function_single_ipi */
	.byte 0x0c, 0xbf, 0x78, 0xe8, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* T__pfx_xen_send_IPI_mask */
	.byte 0x0c, 0x54, 0x78, 0xe8, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* Txen_send_IPI_mask */
	.byte 0x0c, 0xbf, 0x78, 0xe8, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c	/* T__pfx_xen_send_IPI_all */
	.byte 0x0c, 0x54, 0x78, 0xe8, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c	/* Txen_send_IPI_all */
	.byte 0x0c, 0xbf, 0x78, 0xe8, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xba, 0x6c, 0x66	/* T__pfx_xen_send_IPI_self */
	.byte 0x0c, 0x54, 0x78, 0xe8, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xba, 0x6c, 0x66	/* Txen_send_IPI_self */
	.byte 0x14, 0xbf, 0x78, 0xe8, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* T__pfx_xen_send_IPI_mask_allbutself */
	.byte 0x14, 0x54, 0x78, 0xe8, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* Txen_send_IPI_mask_allbutself */
	.byte 0x11, 0xbf, 0x78, 0xe8, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* T__pfx_xen_send_IPI_allbutself */
	.byte 0x11, 0x54, 0x78, 0xe8, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* Txen_send_IPI_allbutself */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0xe7, 0x76, 0xe7, 0x7f, 0x6c, 0x95, 0x6e, 0x63, 0x2a, 0x86	/* t__pfx_xen_pv_poll_sync_state */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0xe7, 0x76, 0xe7, 0x7f, 0x6c, 0x95, 0x6e, 0x63, 0x2a, 0x86	/* txen_pv_poll_sync_state */
	.byte 0x0f, 0xc6, 0x78, 0xe8, 0x5f, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx_xen_irq_work_interrupt */
	.byte 0x0f, 0x74, 0x78, 0xe8, 0x5f, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* txen_irq_work_interrupt */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0xe7, 0x76, 0xe7, 0x1b, 0xc5, 0xe6, 0xc7	/* t__pfx_xen_pv_play_dead */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0xe7, 0x76, 0xe7, 0x1b, 0xc5, 0xe6, 0xc7	/* txen_pv_play_dead */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0xe7, 0x76, 0x5f, 0x92, 0x5f, 0x64, 0x69, 0x65	/* t__pfx_xen_pv_cpu_die */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0xe7, 0x76, 0x5f, 0x92, 0x5f, 0x64, 0x69, 0x65	/* txen_pv_cpu_die */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0xe7, 0x76, 0x5f, 0x63, 0xd3, 0xcc, 0x3a, 0xe6, 0x05, 0x92	/* t__pfx_xen_pv_cleanup_dead_cpu */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0xe7, 0x76, 0x5f, 0x63, 0xd3, 0xcc, 0x3a, 0xe6, 0x05, 0x92	/* txen_pv_cleanup_dead_cpu */
	.byte 0x0d, 0xc6, 0x78, 0xe8, 0xe7, 0x76, 0xf6, 0xac, 0xe2, 0x6f, 0x15, 0xcf, 0x92, 0x73	/* t__pfx_xen_pv_stop_other_cpus */
	.byte 0x0d, 0x74, 0x78, 0xe8, 0xe7, 0x76, 0xf6, 0xac, 0xe2, 0x6f, 0x15, 0xcf, 0x92, 0x73	/* txen_pv_stop_other_cpus */
	.byte 0x07, 0xa8, 0xf6, 0xac, 0x70, 0xba, 0x6c, 0x66	/* t__pfx_stop_self */
	.byte 0x06, 0x74, 0xd6, 0x81, 0xba, 0x6c, 0x66	/* tstop_self */
	.byte 0x0c, 0xc6, 0x78, 0xe8, 0xe7, 0x76, 0x5f, 0x92, 0x5f, 0x64, 0xab, 0x80, 0xd3	/* t__pfx_xen_pv_cpu_disable */
	.byte 0x0c, 0x74, 0x78, 0xe8, 0xe7, 0x76, 0x5f, 0x92, 0x5f, 0x64, 0xab, 0x80, 0xd3	/* txen_pv_cpu_disable */
	.byte 0x0b, 0xc6, 0x78, 0xe8, 0xe7, 0x76, 0x5f, 0x6b, 0xa3, 0xd8, 0x61, 0x70	/* t__pfx_xen_pv_kick_ap */
	.byte 0x0b, 0x74, 0x78, 0xe8, 0xe7, 0x76, 0x5f, 0x6b, 0xa3, 0xd8, 0x61, 0x70	/* txen_pv_kick_ap */
	.byte 0x0c, 0xbf, 0x92, 0x5f, 0x62, 0x72, 0xf0, 0x67, 0x3a, 0xcc, 0xe5, 0x89, 0xd3	/* T__pfx_cpu_bringup_and_idle */
	.byte 0x0c, 0x54, 0x92, 0x5f, 0x62, 0x72, 0xf0, 0x67, 0x3a, 0xcc, 0xe5, 0x89, 0xd3	/* Tcpu_bringup_and_idle */
	.byte 0x0d, 0xbf, 0x78, 0xe8, 0xf6, 0x6d, 0xe2, 0xf0, 0xea, 0x5f, 0x87, 0xfa, 0x70, 0x76	/* T__pfx_xen_smp_intr_free_pv */
	.byte 0x0d, 0x54, 0x78, 0xe8, 0xf6, 0x6d, 0xe2, 0xf0, 0xea, 0x5f, 0x87, 0xfa, 0x70, 0x76	/* Txen_smp_intr_free_pv */
	.byte 0x0d, 0xbf, 0x78, 0xe8, 0xf6, 0x6d, 0xe2, 0xf0, 0xea, 0x5f, 0xf0, 0x99, 0x70, 0x76	/* T__pfx_xen_smp_intr_init_pv */
	.byte 0x0d, 0x54, 0x78, 0xe8, 0xf6, 0x6d, 0xe2, 0xf0, 0xea, 0x5f, 0xf0, 0x99, 0x70, 0x76	/* Txen_smp_intr_init_pv */
	.byte 0x0e, 0xc6, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0xcd, 0x63, 0xd3, 0xcc, 0x3a, 0xe6, 0x05, 0x92	/* t__pfx_xen_hvm_cleanup_dead_cpu */
	.byte 0x0e, 0x74, 0x78, 0xe8, 0x5f, 0x68, 0x76, 0xcd, 0x63, 0xd3, 0xcc, 0x3a, 0xe6, 0x05, 0x92	/* txen_hvm_cleanup_dead_cpu */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0xf6, 0xac, 0x6c, 0xe8	/* T__pfx___raw_callee_save_xen_vcpu_stolen */
	.byte 0x11, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x78, 0xe8, 0x5f, 0x76, 0x92, 0xf6, 0xac, 0x6c, 0xe8	/* T__raw_callee_save_xen_vcpu_stolen */
	.byte 0x0a, 0xc6, 0x78, 0xe8, 0x5f, 0x71, 0xc0, 0xd8, 0x6b, 0xa3, 0x6b	/* t__pfx_xen_qlock_kick */
	.byte 0x0a, 0x74, 0x78, 0xe8, 0x5f, 0x71, 0xc0, 0xd8, 0x6b, 0xa3, 0x6b	/* txen_qlock_kick */
	.byte 0x09, 0xc6, 0x78, 0xe8, 0x5f, 0x71, 0xc0, 0xd8, 0x13, 0xe4	/* t__pfx_xen_qlock_wait */
	.byte 0x09, 0x74, 0x78, 0xe8, 0x5f, 0x71, 0xc0, 0xd8, 0x13, 0xe4	/* txen_qlock_wait */
	.byte 0x0b, 0xc6, 0x64, 0x75, 0x6d, 0x6d, 0xc5, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_dummy_handler */
	.byte 0x0b, 0x74, 0x64, 0x75, 0x6d, 0x6d, 0xc5, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* tdummy_handler */
	.byte 0x09, 0xbf, 0x78, 0xe8, 0x5f, 0xf0, 0x99, 0xc0, 0xd8, 0x92	/* T__pfx_xen_init_lock_cpu */
	.byte 0x09, 0x54, 0x78, 0xe8, 0x5f, 0xf0, 0x99, 0xc0, 0xd8, 0x92	/* Txen_init_lock_cpu */
	.byte 0x0a, 0xbf, 0x78, 0xe8, 0x5f, 0xd4, 0xf0, 0x99, 0xc0, 0xd8, 0x92	/* T__pfx_xen_uninit_lock_cpu */
	.byte 0x0a, 0x54, 0x78, 0xe8, 0x5f, 0xd4, 0xf0, 0x99, 0xc0, 0xd8, 0x92	/* Txen_uninit_lock_cpu */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72	/* t__pfx_paravirt_write_msr */
	.byte 0x0a, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72	/* tparavirt_write_msr */
	.byte 0x14, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xf8, 0xe8, 0x6c, 0x2c, 0x68, 0x74, 0xe8, 0x6d, 0x1e	/* t__pfx___sysvec_hyperv_reenlightenment */
	.byte 0x15, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xf8, 0xe8, 0x6c, 0x2c, 0x68, 0x74, 0xe8, 0x6d, 0x1e	/* t__sysvec_hyperv_reenlightenment */
	.byte 0x11, 0xc6, 0x68, 0x76, 0x5f, 0xf8, 0xe8, 0x6c, 0x2c, 0x68, 0x74, 0xe8, 0x6d, 0xbb, 0xb6, 0xc2, 0x66, 0x79	/* t__pfx_hv_reenlightenment_notify */
	.byte 0x10, 0x15, 0x76, 0x5f, 0xf8, 0xe8, 0x6c, 0x2c, 0x68, 0x74, 0xe8, 0x6d, 0xbb, 0xb6, 0xc2, 0x66, 0x79	/* thv_reenlightenment_notify */
	.byte 0x11, 0xbf, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xac, 0xe2, 0x74, 0x73, 0xd5, 0x65, 0x6d, 0x0b, 0xe9, 0xd9, 0x6e	/* T__pfx_hyperv_stop_tsc_emulation */
	.byte 0x11, 0x54, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xac, 0xe2, 0x74, 0x73, 0xd5, 0x65, 0x6d, 0x0b, 0xe9, 0xd9, 0x6e	/* Thyperv_stop_tsc_emulation */
	.byte 0x0d, 0x3f, 0x1f, 0x68, 0x76, 0x5f, 0x74, 0x73, 0x63, 0xd0, 0xcc, 0x21, 0x63, 0x62	/* T__pfx_set_hv_tscchange_cb */
	.byte 0x0e, 0x54, 0xc9, 0xf9, 0x68, 0x76, 0x5f, 0x74, 0x73, 0x63, 0xd0, 0xcc, 0x21, 0x63, 0x62	/* Tset_hv_tscchange_cb */
	.byte 0x10, 0xbf, 0x63, 0xd3, 0xca, 0x5f, 0x68, 0x76, 0x5f, 0x74, 0x73, 0x63, 0xd0, 0xcc, 0x21, 0x63, 0x62	/* T__pfx_clear_hv_tscchange_cb */
	.byte 0x10, 0x54, 0x63, 0xd3, 0xca, 0x5f, 0x68, 0x76, 0x5f, 0x74, 0x73, 0x63, 0xd0, 0xcc, 0x21, 0x63, 0x62	/* Tclear_hv_tscchange_cb */
	.byte 0x12, 0xbf, 0x68, 0x76, 0x5f, 0x69, 0xe0, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x8d, 0x69, 0xe1, 0x69, 0x7a, 0x65, 0x64	/* T__pfx_hv_is_hyperv_initialized */
	.byte 0x12, 0x54, 0x68, 0x76, 0x5f, 0x69, 0xe0, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x8d, 0x69, 0xe1, 0x69, 0x7a, 0x65, 0x64	/* Thv_is_hyperv_initialized */
	.byte 0x0d, 0xbf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xf8, 0x70, 0xce, 0xf9, 0x70, 0xcc, 0xa3	/* T__pfx_hyperv_report_panic */
	.byte 0x0d, 0x54, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xf8, 0x70, 0xce, 0xf9, 0x70, 0xcc, 0xa3	/* Thyperv_report_panic */
	.byte 0x07, 0xc6, 0x68, 0x76, 0x5f, 0x92, 0x5f, 0x8d	/* t__pfx_hv_cpu_init */
	.byte 0x06, 0x15, 0x76, 0x5f, 0x92, 0x5f, 0x8d	/* thv_cpu_init */
	.byte 0x07, 0xc6, 0x68, 0x76, 0x5f, 0xf8, 0xb7, 0xbd	/* t__pfx_hv_resume */
	.byte 0x06, 0x15, 0x76, 0x5f, 0xf8, 0xb7, 0xbd	/* thv_resume */
	.byte 0x09, 0xc6, 0x68, 0x76, 0x5f, 0x92, 0x5f, 0x64, 0x69, 0x65	/* t__pfx_hv_cpu_die */
	.byte 0x08, 0x15, 0x76, 0x5f, 0x92, 0x5f, 0x64, 0x69, 0x65	/* thv_cpu_die */
	.byte 0x08, 0xc6, 0x68, 0x76, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* t__pfx_hv_suspend */
	.byte 0x07, 0x15, 0x76, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* thv_suspend */
	.byte 0x16, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xf8, 0xe8, 0x6c, 0x2c, 0x68, 0x74, 0xe8, 0x6d, 0x1e	/* T__pfx_fred_sysvec_hyperv_reenlightenment */
	.byte 0x16, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xf8, 0xe8, 0x6c, 0x2c, 0x68, 0x74, 0xe8, 0x6d, 0x1e	/* Tfred_sysvec_hyperv_reenlightenment */
	.byte 0x0a, 0xbf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x63, 0xd3, 0xcc, 0xb9	/* T__pfx_hyperv_cleanup */
	.byte 0x0a, 0x54, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x63, 0xd3, 0xcc, 0xb9	/* Thyperv_cleanup */
	.byte 0x18, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* T__pfx___traceiter_hyperv_mmu_flush_tlb_multi */
	.byte 0x16, 0x2f, 0x01, 0xe4, 0xcf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* T__traceiter_hyperv_mmu_flush_tlb_multi */
	.byte 0x19, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* T__pfx___probestub_hyperv_mmu_flush_tlb_multi */
	.byte 0x18, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* T__probestub_hyperv_mmu_flush_tlb_multi */
	.byte 0x1b, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* T__pfx___traceiter_hyperv_nested_flush_guest_mapping */
	.byte 0x19, 0x2f, 0x01, 0xe4, 0xcf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* T__traceiter_hyperv_nested_flush_guest_mapping */
	.byte 0x1c, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* T__pfx___probestub_hyperv_nested_flush_guest_mapping */
	.byte 0x1b, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* T__probestub_hyperv_nested_flush_guest_mapping */
	.byte 0x1e, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* T__pfx___traceiter_hyperv_nested_flush_guest_mapping_range */
	.byte 0x1c, 0x2f, 0x01, 0xe4, 0xcf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* T__traceiter_hyperv_nested_flush_guest_mapping_range */
	.byte 0x1f, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* T__pfx___probestub_hyperv_nested_flush_guest_mapping_range */
	.byte 0x1e, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* T__probestub_hyperv_nested_flush_guest_mapping_range */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* T__pfx___traceiter_hyperv_send_ipi_mask */
	.byte 0x0f, 0x2f, 0x01, 0xe4, 0xcf, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* T__traceiter_hyperv_send_ipi_mask */
	.byte 0x12, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* T__pfx___probestub_hyperv_send_ipi_mask */
	.byte 0x11, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* T__probestub_hyperv_send_ipi_mask */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* T__pfx___traceiter_hyperv_send_ipi_one */
	.byte 0x0f, 0x2f, 0x01, 0xe4, 0xcf, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* T__traceiter_hyperv_send_ipi_one */
	.byte 0x12, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* T__pfx___probestub_hyperv_send_ipi_one */
	.byte 0x11, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* T__probestub_hyperv_send_ipi_one */
	.byte 0x08, 0xc6, 0x92, 0x5f, 0x69, 0xe0, 0x1b, 0x7a, 0x79	/* t__pfx_cpu_is_lazy */
	.byte 0x08, 0x74, 0x92, 0x5f, 0x69, 0xe0, 0x1b, 0x7a, 0x79	/* tcpu_is_lazy */
	.byte 0x10, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* t__pfx_perf_trace_hyperv_send_ipi_one */
	.byte 0x0f, 0x06, 0xee, 0xa0, 0xc8, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* tperf_trace_hyperv_send_ipi_one */
	.byte 0x1d, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* t__pfx_perf_trace_hyperv_nested_flush_guest_mapping_range */
	.byte 0x1c, 0x06, 0xee, 0xa0, 0xc8, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* tperf_trace_hyperv_nested_flush_guest_mapping_range */
	.byte 0x1a, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* t__pfx_perf_trace_hyperv_nested_flush_guest_mapping */
	.byte 0x19, 0x06, 0xee, 0xa0, 0xc8, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* tperf_trace_hyperv_nested_flush_guest_mapping */
	.byte 0x10, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* t__pfx_perf_trace_hyperv_send_ipi_mask */
	.byte 0x0f, 0x06, 0xee, 0xa0, 0xc8, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* tperf_trace_hyperv_send_ipi_mask */
	.byte 0x17, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* t__pfx_perf_trace_hyperv_mmu_flush_tlb_multi */
	.byte 0x16, 0x06, 0xee, 0xa0, 0xc8, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* tperf_trace_hyperv_mmu_flush_tlb_multi */
	.byte 0x10, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* t__pfx_trace_event_raw_event_hyperv_send_ipi_one */
	.byte 0x10, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* ttrace_event_raw_event_hyperv_send_ipi_one */
	.byte 0x10, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* t__pfx_trace_event_raw_event_hyperv_send_ipi_mask */
	.byte 0x10, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* ttrace_event_raw_event_hyperv_send_ipi_mask */
	.byte 0x1d, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* t__pfx_trace_event_raw_event_hyperv_nested_flush_guest_mapping_range */
	.byte 0x1d, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* ttrace_event_raw_event_hyperv_nested_flush_guest_mapping_range */
	.byte 0x1a, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* t__pfx_trace_event_raw_event_hyperv_nested_flush_guest_mapping */
	.byte 0x1a, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* ttrace_event_raw_event_hyperv_nested_flush_guest_mapping */
	.byte 0x17, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* t__pfx_trace_event_raw_event_hyperv_mmu_flush_tlb_multi */
	.byte 0x17, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* ttrace_event_raw_event_hyperv_mmu_flush_tlb_multi */
	.byte 0x12, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* t__pfx_trace_raw_output_hyperv_send_ipi_one */
	.byte 0x12, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* ttrace_raw_output_hyperv_send_ipi_one */
	.byte 0x12, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* t__pfx_trace_raw_output_hyperv_send_ipi_mask */
	.byte 0x12, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* ttrace_raw_output_hyperv_send_ipi_mask */
	.byte 0x1f, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* t__pfx_trace_raw_output_hyperv_nested_flush_guest_mapping_range */
	.byte 0x1f, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* ttrace_raw_output_hyperv_nested_flush_guest_mapping_range */
	.byte 0x1c, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* t__pfx_trace_raw_output_hyperv_nested_flush_guest_mapping */
	.byte 0x1c, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* ttrace_raw_output_hyperv_nested_flush_guest_mapping */
	.byte 0x19, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* t__pfx_trace_raw_output_hyperv_mmu_flush_tlb_multi */
	.byte 0x19, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* ttrace_raw_output_hyperv_mmu_flush_tlb_multi */
	.byte 0x0f, 0x29, 0x5f, 0x40, 0xc8, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* t__pfx___bpf_trace_hyperv_send_ipi_one */
	.byte 0x0f, 0x74, 0xff, 0x40, 0xc8, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* t__bpf_trace_hyperv_send_ipi_one */
	.byte 0x0f, 0x29, 0x5f, 0x40, 0xc8, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* t__pfx___bpf_trace_hyperv_send_ipi_mask */
	.byte 0x0f, 0x74, 0xff, 0x40, 0xc8, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* t__bpf_trace_hyperv_send_ipi_mask */
	.byte 0x1c, 0x29, 0x5f, 0x40, 0xc8, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* t__pfx___bpf_trace_hyperv_nested_flush_guest_mapping_range */
	.byte 0x1c, 0x74, 0xff, 0x40, 0xc8, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* t__bpf_trace_hyperv_nested_flush_guest_mapping_range */
	.byte 0x19, 0x29, 0x5f, 0x40, 0xc8, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* t__pfx___bpf_trace_hyperv_nested_flush_guest_mapping */
	.byte 0x19, 0x74, 0xff, 0x40, 0xc8, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* t__bpf_trace_hyperv_nested_flush_guest_mapping */
	.byte 0x16, 0x29, 0x5f, 0x40, 0xc8, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* t__pfx___bpf_trace_hyperv_mmu_flush_tlb_multi */
	.byte 0x16, 0x74, 0xff, 0x40, 0xc8, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x6d, 0x6d, 0x00, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* t__bpf_trace_hyperv_mmu_flush_tlb_multi */
	.byte 0x12, 0xc6, 0x68, 0x76, 0x5f, 0xa9, 0x5f, 0x68, 0x27, 0xee, 0x28, 0x6c, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_hv_do_hypercall.constprop.0 */
	.byte 0x11, 0x15, 0x76, 0x5f, 0xa9, 0x5f, 0x68, 0x27, 0xee, 0x28, 0x6c, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* thv_do_hypercall.constprop.0 */
	.byte 0x10, 0xc6, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* t__pfx_hyperv_flush_tlb_multi */
	.byte 0x0f, 0x15, 0x27, 0xee, 0x76, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* thyperv_flush_tlb_multi */
	.byte 0x0d, 0xbf, 0x68, 0x27, 0xee, 0x76, 0xba, 0x74, 0x3a, 0x6d, 0x6d, 0x00, 0x81, 0x73	/* T__pfx_hyperv_setup_mmu_ops */
	.byte 0x0d, 0x54, 0x68, 0x27, 0xee, 0x76, 0xba, 0x74, 0x3a, 0x6d, 0x6d, 0x00, 0x81, 0x73	/* Thyperv_setup_mmu_ops */
	.byte 0x17, 0xbf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb8, 0x6c, 0xc3, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x6c, 0x7d	/* T__pfx_hyperv_fill_flush_guest_mapping_list */
	.byte 0x17, 0x54, 0x68, 0x27, 0xee, 0x76, 0x5f, 0xb8, 0x6c, 0xc3, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x6c, 0x7d	/* Thyperv_fill_flush_guest_mapping_list */
	.byte 0x12, 0xc6, 0x68, 0x76, 0x5f, 0xa9, 0x5f, 0x68, 0x27, 0xee, 0x28, 0x6c, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_hv_do_hypercall.constprop.0 */
	.byte 0x11, 0x15, 0x76, 0x5f, 0xa9, 0x5f, 0x68, 0x27, 0xee, 0x28, 0x6c, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* thv_do_hypercall.constprop.0 */
	.byte 0x15, 0xbf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* T__pfx_hyperv_flush_guest_mapping_range */
	.byte 0x15, 0x54, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0xa6, 0x72, 0xcc, 0xda	/* Thyperv_flush_guest_mapping_range */
	.byte 0x12, 0xbf, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* T__pfx_hyperv_flush_guest_mapping */
	.byte 0x12, 0x54, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0x75, 0x3b, 0xf9, 0x0a, 0x70, 0xf0, 0x67	/* Thyperv_flush_guest_mapping */
	.byte 0x07, 0xc6, 0xb2, 0x72, 0x69, 0xe5, 0x63, 0x62	/* t__pfx_get_rid_cb */
	.byte 0x07, 0x74, 0xb2, 0x72, 0x69, 0xe5, 0x63, 0x62	/* tget_rid_cb */
	.byte 0x0c, 0xc6, 0x68, 0x76, 0x5f, 0xa2, 0x69, 0x02, 0xe7, 0x63, 0xcb, 0x19, 0x89	/* t__pfx_hv_build_pci_dev_id */
	.byte 0x0b, 0x15, 0x76, 0x5f, 0xa2, 0x69, 0x02, 0xe7, 0x63, 0xcb, 0x19, 0x89	/* thv_build_pci_dev_id */
	.byte 0x0b, 0xc6, 0x68, 0x76, 0x5f, 0xa9, 0x5f, 0x68, 0x27, 0xee, 0x28, 0x6c	/* t__pfx_hv_do_hypercall */
	.byte 0x0a, 0x15, 0x76, 0x5f, 0xa9, 0x5f, 0x68, 0x27, 0xee, 0x28, 0x6c	/* thv_do_hypercall */
	.byte 0x0c, 0xc6, 0x68, 0x76, 0x5f, 0xd4, 0x84, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx_hv_unmap_interrupt */
	.byte 0x0b, 0x15, 0x76, 0x5f, 0xd4, 0x84, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* thv_unmap_interrupt */
	.byte 0x11, 0xbf, 0x68, 0x76, 0x5f, 0xd4, 0x84, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* T__pfx_hv_unmap_ioapic_interrupt */
	.byte 0x11, 0x54, 0x68, 0x76, 0x5f, 0xd4, 0x84, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* Thv_unmap_ioapic_interrupt */
	.byte 0x0a, 0xc6, 0x68, 0x76, 0x5f, 0x20, 0xcb, 0x87, 0xfa, 0xa7, 0x71	/* t__pfx_hv_msi_free_irq */
	.byte 0x09, 0x15, 0x76, 0x5f, 0x20, 0xcb, 0x87, 0xfa, 0xa7, 0x71	/* thv_msi_free_irq */
	.byte 0x0b, 0xc6, 0x68, 0x76, 0x5f, 0x84, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx_hv_map_interrupt */
	.byte 0x0a, 0x15, 0x76, 0x5f, 0x84, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* thv_map_interrupt */
	.byte 0x10, 0xbf, 0x68, 0x76, 0x5f, 0x84, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* T__pfx_hv_map_ioapic_interrupt */
	.byte 0x10, 0x54, 0x68, 0x76, 0x5f, 0x84, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* Thv_map_ioapic_interrupt */
	.byte 0x0e, 0xc6, 0x68, 0x76, 0x5f, 0xa7, 0x93, 0x09, 0x6f, 0x73, 0xfa, 0x20, 0xcb, 0x20, 0x67	/* t__pfx_hv_irq_compose_msi_msg */
	.byte 0x0d, 0x15, 0x76, 0x5f, 0xa7, 0x93, 0x09, 0x6f, 0x73, 0xfa, 0x20, 0xcb, 0x20, 0x67	/* thv_irq_compose_msi_msg */
	.byte 0x13, 0xc6, 0x68, 0x76, 0x5f, 0x76, 0xac, 0xcd, 0x74, 0x6c, 0xdc, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x8e, 0x69, 0xf8, 0x64	/* t__pfx_hv_vtom_tlb_flush_required */
	.byte 0x12, 0x15, 0x76, 0x5f, 0x76, 0xac, 0xcd, 0x74, 0x6c, 0xdc, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x8e, 0x69, 0xf8, 0x64	/* thv_vtom_tlb_flush_required */
	.byte 0x14, 0xc6, 0x68, 0x76, 0x5f, 0x76, 0xac, 0xcd, 0x63, 0xeb, 0x68, 0xfa, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x8e, 0x69, 0xf8, 0x64	/* t__pfx_hv_vtom_cache_flush_required */
	.byte 0x13, 0x15, 0x76, 0x5f, 0x76, 0xac, 0xcd, 0x63, 0xeb, 0x68, 0xfa, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x8e, 0x69, 0xf8, 0x64	/* thv_vtom_cache_flush_required */
	.byte 0x0d, 0xc6, 0x68, 0x76, 0x5f, 0xab, 0xe7, 0x72, 0x69, 0x76, 0xa1, 0x6d, 0x6d, 0xd9	/* t__pfx_hv_is_private_mmio */
	.byte 0x0c, 0x15, 0x76, 0x5f, 0xab, 0xe7, 0x72, 0x69, 0x76, 0xa1, 0x6d, 0x6d, 0xd9	/* thv_is_private_mmio */
	.byte 0x0d, 0xbf, 0x68, 0x76, 0x5f, 0xb2, 0xab, 0x7f, 0xe9, 0xd9, 0x7c, 0x74, 0x27, 0x65	/* T__pfx_hv_get_isolation_type */
	.byte 0x0d, 0x54, 0x68, 0x76, 0x5f, 0xb2, 0xab, 0x7f, 0xe9, 0xd9, 0x7c, 0x74, 0x27, 0x65	/* Thv_get_isolation_type */
	.byte 0x0b, 0xa8, 0xf6, 0x6e, 0xe2, 0x63, 0xd3, 0xcc, 0x3a, 0x76, 0x20, 0x61	/* t__pfx_snp_cleanup_vmsa */
	.byte 0x0b, 0x74, 0x73, 0x6e, 0xe2, 0x63, 0xd3, 0xcc, 0x3a, 0x76, 0x20, 0x61	/* tsnp_cleanup_vmsa */
	.byte 0x0b, 0xc6, 0x68, 0x76, 0x5f, 0xa9, 0x5f, 0x68, 0x27, 0xee, 0x28, 0x6c	/* t__pfx_hv_do_hypercall */
	.byte 0x0a, 0x15, 0x76, 0x5f, 0xa9, 0x5f, 0x68, 0x27, 0xee, 0x28, 0x6c	/* thv_do_hypercall */
	.byte 0x0d, 0xc6, 0x68, 0x76, 0x5f, 0x76, 0xac, 0xcd, 0x63, 0xd3, 0xca, 0xe7, 0x3d, 0x1e	/* t__pfx_hv_vtom_clear_present */
	.byte 0x0c, 0x15, 0x76, 0x5f, 0x76, 0xac, 0xcd, 0x63, 0xd3, 0xca, 0xe7, 0x3d, 0x1e	/* thv_vtom_clear_present */
	.byte 0x14, 0xc6, 0x68, 0x76, 0x5f, 0x67, 0x68, 0x63, 0xdc, 0x68, 0x76, 0x5f, 0x28, 0x6c, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_hv_ghcb_hv_call.constprop.0 */
	.byte 0x13, 0x15, 0x76, 0x5f, 0x67, 0x68, 0x63, 0xdc, 0x68, 0x76, 0x5f, 0x28, 0x6c, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* thv_ghcb_hv_call.constprop.0 */
	.byte 0x0d, 0xbf, 0x68, 0x76, 0x5f, 0x67, 0x68, 0x63, 0xdc, 0x68, 0x27, 0xee, 0x28, 0x6c	/* T__pfx_hv_ghcb_hypercall */
	.byte 0x0d, 0x54, 0x68, 0x76, 0x5f, 0x67, 0x68, 0x63, 0xdc, 0x68, 0x27, 0xee, 0x28, 0x6c	/* Thv_ghcb_hypercall */
	.byte 0x0d, 0xbf, 0x68, 0x76, 0x5f, 0x67, 0x68, 0x63, 0xdc, 0x74, 0xee, 0x6d, 0xf0, 0x86	/* T__pfx_hv_ghcb_terminate */
	.byte 0x0d, 0x54, 0x68, 0x76, 0x5f, 0x67, 0x68, 0x63, 0xdc, 0x74, 0xee, 0x6d, 0xf0, 0x86	/* Thv_ghcb_terminate */
	.byte 0x11, 0xbf, 0x68, 0x76, 0x5f, 0x67, 0x68, 0x63, 0xdc, 0xb4, 0x67, 0x6f, 0xc2, 0xa1, 0x9b, 0xac, 0xfe, 0x6c	/* T__pfx_hv_ghcb_negotiate_protocol */
	.byte 0x11, 0x54, 0x68, 0x76, 0x5f, 0x67, 0x68, 0x63, 0xdc, 0xb4, 0x67, 0x6f, 0xc2, 0xa1, 0x9b, 0xac, 0xfe, 0x6c	/* Thv_ghcb_negotiate_protocol */
	.byte 0x0c, 0xbf, 0x68, 0x76, 0xf6, 0x6e, 0xe2, 0x62, 0x6f, 0x6f, 0xf9, 0x61, 0x70	/* T__pfx_hv_snp_boot_ap */
	.byte 0x0c, 0x54, 0x68, 0x76, 0xf6, 0x6e, 0xe2, 0x62, 0x6f, 0x6f, 0xf9, 0x61, 0x70	/* Thv_snp_boot_ap */
	.byte 0x0c, 0xbf, 0x68, 0x76, 0x5f, 0x69, 0x76, 0xcd, 0x20, 0x72, 0x5f, 0x24, 0x65	/* T__pfx_hv_ivm_msr_write */
	.byte 0x0c, 0x54, 0x68, 0x76, 0x5f, 0x69, 0x76, 0xcd, 0x20, 0x72, 0x5f, 0x24, 0x65	/* Thv_ivm_msr_write */
	.byte 0x0c, 0xbf, 0x68, 0x76, 0x5f, 0x69, 0x76, 0xcd, 0x20, 0x72, 0x5f, 0xf8, 0xc7	/* T__pfx_hv_ivm_msr_read */
	.byte 0x0c, 0x54, 0x68, 0x76, 0x5f, 0x69, 0x76, 0xcd, 0x20, 0x72, 0x5f, 0xf8, 0xc7	/* Thv_ivm_msr_read */
	.byte 0x11, 0xbf, 0x68, 0x76, 0x5f, 0x69, 0xe0, 0xab, 0x7f, 0xe9, 0xd9, 0x6e, 0xf6, 0xb9, 0x70, 0xce, 0x9a, 0x64	/* T__pfx_hv_is_isolation_supported */
	.byte 0x11, 0x54, 0x68, 0x76, 0x5f, 0x69, 0xe0, 0xab, 0x7f, 0xe9, 0xd9, 0x6e, 0xf6, 0xb9, 0x70, 0xce, 0x9a, 0x64	/* Thv_is_isolation_supported */
	.byte 0x13, 0xc6, 0x68, 0x76, 0x5f, 0x76, 0xac, 0x6d, 0x1f, 0xad, 0x73, 0xf9, 0x76, 0xab, 0x69, 0x62, 0x69, 0x6c, 0xe4, 0x79	/* t__pfx_hv_vtom_set_host_visibility */
	.byte 0x12, 0x15, 0x76, 0x5f, 0x76, 0xac, 0x6d, 0x1f, 0xad, 0x73, 0xf9, 0x76, 0xab, 0x69, 0x62, 0x69, 0x6c, 0xe4, 0x79	/* thv_vtom_set_host_visibility */
	.byte 0x0f, 0xbf, 0x68, 0x76, 0x5f, 0xab, 0x7f, 0xe9, 0xd9, 0x7c, 0x74, 0x27, 0xfa, 0x73, 0x6e, 0x70	/* T__pfx_hv_isolation_type_snp */
	.byte 0x0f, 0x54, 0x68, 0x76, 0x5f, 0xab, 0x7f, 0xe9, 0xd9, 0x7c, 0x74, 0x27, 0xfa, 0x73, 0x6e, 0x70	/* Thv_isolation_type_snp */
	.byte 0x0f, 0xbf, 0x68, 0x76, 0x5f, 0xab, 0x7f, 0xe9, 0xd9, 0x7c, 0x74, 0x27, 0xfa, 0x74, 0x64, 0x78	/* T__pfx_hv_isolation_type_tdx */
	.byte 0x0f, 0x54, 0x68, 0x76, 0x5f, 0xab, 0x7f, 0xe9, 0xd9, 0x7c, 0x74, 0x27, 0xfa, 0x74, 0x64, 0x78	/* Thv_isolation_type_tdx */
	.byte 0x07, 0xc6, 0x92, 0x5f, 0xab, 0xba, 0x6c, 0x66	/* t__pfx_cpu_is_self */
	.byte 0x07, 0x74, 0x92, 0x5f, 0xab, 0xba, 0x6c, 0x66	/* tcpu_is_self */
	.byte 0x17, 0x29, 0x68, 0x76, 0x5f, 0xa9, 0x5f, 0x66, 0x96, 0xf9, 0x68, 0x27, 0xee, 0x28, 0x6c, 0x31, 0x36, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx__hv_do_fast_hypercall16.constprop.0 */
	.byte 0x17, 0xf9, 0x68, 0x76, 0x5f, 0xa9, 0x5f, 0x66, 0x96, 0xf9, 0x68, 0x27, 0xee, 0x28, 0x6c, 0x31, 0x36, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t_hv_do_fast_hypercall16.constprop.0 */
	.byte 0x0a, 0x29, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x73, 0xd8, 0xd1	/* t__pfx___send_ipi_mask_ex */
	.byte 0x0b, 0x74, 0xff, 0x73, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x73, 0xd8, 0xd1	/* t__send_ipi_mask_ex */
	.byte 0x08, 0x29, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* t__pfx___send_ipi_one */
	.byte 0x09, 0x74, 0xff, 0x73, 0xe8, 0xe5, 0x69, 0x85, 0x6f, 0xb4	/* t__send_ipi_one */
	.byte 0x0b, 0xc6, 0x68, 0x76, 0xf6, 0xe8, 0xe5, 0x0c, 0x69, 0xba, 0x6c, 0x66	/* t__pfx_hv_send_ipi_self */
	.byte 0x0a, 0x15, 0x76, 0xf6, 0xe8, 0xe5, 0x0c, 0x69, 0xba, 0x6c, 0x66	/* thv_send_ipi_self */
	.byte 0x08, 0xc6, 0x68, 0x76, 0xf6, 0xe8, 0xe5, 0x0c, 0x69	/* t__pfx_hv_send_ipi */
	.byte 0x07, 0x15, 0x76, 0xf6, 0xe8, 0xe5, 0x0c, 0x69	/* thv_send_ipi */
	.byte 0x08, 0x29, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* t__pfx___send_ipi_mask */
	.byte 0x09, 0x74, 0xff, 0x73, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* t__send_ipi_mask */
	.byte 0x0a, 0xc6, 0x68, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xe1, 0x6c	/* t__pfx_hv_send_ipi_all */
	.byte 0x09, 0x15, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xe1, 0x6c	/* thv_send_ipi_all */
	.byte 0x12, 0xc6, 0x68, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* t__pfx_hv_send_ipi_mask_allbutself */
	.byte 0x11, 0x15, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* thv_send_ipi_mask_allbutself */
	.byte 0x0f, 0xc6, 0x68, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* t__pfx_hv_send_ipi_allbutself */
	.byte 0x0e, 0x15, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* thv_send_ipi_allbutself */
	.byte 0x0a, 0xc6, 0x68, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* t__pfx_hv_send_ipi_mask */
	.byte 0x09, 0x15, 0x76, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* thv_send_ipi_mask */
	.byte 0x0d, 0xc6, 0x68, 0x76, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0xf8, 0xc7	/* t__pfx_hv_apic_icr_read */
	.byte 0x0c, 0x15, 0x76, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0xf8, 0xc7	/* thv_apic_icr_read */
	.byte 0x0d, 0xc6, 0x68, 0x76, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0x24, 0x65	/* t__pfx_hv_apic_icr_write */
	.byte 0x0c, 0x15, 0x76, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0x24, 0x65	/* thv_apic_icr_write */
	.byte 0x0d, 0xc6, 0x68, 0x76, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0x65, 0x6f, 0xcb, 0x24, 0x65	/* t__pfx_hv_apic_eoi_write */
	.byte 0x0c, 0x15, 0x76, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0x65, 0x6f, 0xcb, 0x24, 0x65	/* thv_apic_eoi_write */
	.byte 0x0a, 0xc6, 0x68, 0x76, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0xc7	/* t__pfx_hv_apic_read */
	.byte 0x09, 0x15, 0x76, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0xc7	/* thv_apic_read */
	.byte 0x0a, 0xc6, 0x68, 0x76, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0x24, 0x65	/* t__pfx_hv_apic_write */
	.byte 0x09, 0x15, 0x76, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0x24, 0x65	/* thv_apic_write */
	.byte 0x0b, 0xc6, 0x68, 0x76, 0x5f, 0xa9, 0x5f, 0x68, 0x27, 0xee, 0x28, 0x6c	/* t__pfx_hv_do_hypercall */
	.byte 0x0a, 0x15, 0x76, 0x5f, 0xa9, 0x5f, 0x68, 0x27, 0xee, 0x28, 0x6c	/* thv_do_hypercall */
	.byte 0x0e, 0xbf, 0x68, 0x76, 0x5f, 0x28, 0xc3, 0xe6, 0x70, 0x6f, 0x73, 0x99, 0x70, 0x03, 0x73	/* T__pfx_hv_call_deposit_pages */
	.byte 0x0e, 0x54, 0x68, 0x76, 0x5f, 0x28, 0xc3, 0xe6, 0x70, 0x6f, 0x73, 0x99, 0x70, 0x03, 0x73	/* Thv_call_deposit_pages */
	.byte 0x0e, 0xbf, 0x68, 0x76, 0x5f, 0x28, 0xc3, 0xc7, 0xe5, 0xdf, 0x67, 0xa3, 0xe1, 0x25, 0x63	/* T__pfx_hv_call_add_logical_proc */
	.byte 0x0e, 0x54, 0x68, 0x76, 0x5f, 0x28, 0xc3, 0xc7, 0xe5, 0xdf, 0x67, 0xa3, 0xe1, 0x25, 0x63	/* Thv_call_add_logical_proc */
	.byte 0x0b, 0xbf, 0x68, 0x76, 0x5f, 0x28, 0xc3, 0x63, 0xf8, 0xa1, 0x76, 0x70	/* T__pfx_hv_call_create_vp */
	.byte 0x0b, 0x54, 0x68, 0x76, 0x5f, 0x28, 0xc3, 0x63, 0xf8, 0xa1, 0x76, 0x70	/* Thv_call_create_vp */
	.byte 0x17, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x68, 0x76, 0x5f, 0x76, 0x92, 0x5f, 0xab, 0xe7, 0xf8, 0x65, 0xb0, 0x9a, 0x64	/* T__pfx___raw_callee_save_hv_vcpu_is_preempted */
	.byte 0x15, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x22, 0x68, 0x76, 0x5f, 0x76, 0x92, 0x5f, 0xab, 0xe7, 0xf8, 0x65, 0xb0, 0x9a, 0x64	/* T__raw_callee_save_hv_vcpu_is_preempted */
	.byte 0x0a, 0xc6, 0x68, 0x76, 0x5f, 0x71, 0xc0, 0xd8, 0x6b, 0xa3, 0x6b	/* t__pfx_hv_qlock_kick */
	.byte 0x09, 0x15, 0x76, 0x5f, 0x71, 0xc0, 0xd8, 0x6b, 0xa3, 0x6b	/* thv_qlock_kick */
	.byte 0x09, 0xc6, 0x68, 0x76, 0x5f, 0x71, 0xc0, 0xd8, 0x13, 0xe4	/* t__pfx_hv_qlock_wait */
	.byte 0x08, 0x15, 0x76, 0x5f, 0x71, 0xc0, 0xd8, 0x13, 0xe4	/* thv_qlock_wait */
	.byte 0x0e, 0xbf, 0x68, 0x76, 0x5f, 0x76, 0x92, 0x5f, 0xab, 0xe7, 0xf8, 0x65, 0xb0, 0x9a, 0x64	/* T__pfx_hv_vcpu_is_preempted */
	.byte 0x0e, 0x54, 0x68, 0x76, 0x5f, 0x76, 0x92, 0x5f, 0xab, 0xe7, 0xf8, 0x65, 0xb0, 0x9a, 0x64	/* Thv_vcpu_is_preempted */
	.byte 0x0e, 0xbf, 0xdf, 0x05, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x70, 0x67, 0xdb, 0x62, 0xd3	/* T__pfx_load_trampoline_pgtable */
	.byte 0x0e, 0x54, 0xdf, 0x05, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x70, 0x67, 0xdb, 0x62, 0xd3	/* Tload_trampoline_pgtable */
	.byte 0x0d, 0x54, 0xc9, 0x98, 0x64, 0xca, 0x79, 0xf6, 0xdb, 0x72, 0x74, 0x3a, 0x36, 0x34	/* Tsecondary_startup_64 */
	.byte 0x14, 0x54, 0xc9, 0x98, 0x64, 0xca, 0x79, 0xf6, 0xdb, 0x72, 0x74, 0x3a, 0x36, 0x5c, 0xb6, 0x5f, 0x76, 0xee, 0x69, 0x66, 0x79	/* Tsecondary_startup_64_no_verify */
	.byte 0x0c, 0x74, 0xfe, 0x6d, 0xa5, 0x6e, 0xf6, 0xdb, 0x72, 0x74, 0x3a, 0x36, 0x34	/* tcommon_startup_64 */
	.byte 0x07, 0xc6, 0x76, 0xee, 0x69, 0x66, 0xc5, 0x92	/* t__pfx_verify_cpu */
	.byte 0x07, 0x74, 0x76, 0xee, 0x69, 0x66, 0xc5, 0x92	/* tverify_cpu */
	.byte 0x0c, 0x3f, 0xf6, 0xbc, 0x5f, 0x76, 0xee, 0x69, 0x66, 0xc5, 0x63, 0x62, 0xe4	/* T__pfx_sev_verify_cbit */
	.byte 0x0c, 0x54, 0xc9, 0x76, 0x5f, 0x76, 0xee, 0x69, 0x66, 0xc5, 0x63, 0x62, 0xe4	/* Tsev_verify_cbit */
	.byte 0x0a, 0x54, 0x73, 0x6f, 0x66, 0xf9, 0x3d, 0xdb, 0x72, 0xf9, 0x92	/* Tsoft_restart_cpu */
	.byte 0x0b, 0x54, 0x76, 0xd5, 0x62, 0x6f, 0x6f, 0xf9, 0x67, 0x68, 0x63, 0x62	/* Tvc_boot_ghcb */
	.byte 0x0e, 0x54, 0x96, 0xcd, 0x92, 0x5f, 0x62, 0x72, 0xf0, 0x67, 0x3a, 0xcc, 0xe5, 0x89, 0xd3	/* Tasm_cpu_bringup_and_idle */
	.byte 0x0f, 0x54, 0x78, 0xe8, 0x5f, 0x92, 0x5f, 0x62, 0x72, 0xf0, 0x67, 0x3a, 0x61, 0x67, 0x61, 0xf0	/* Txen_cpu_bringup_again */
	.byte 0x0a, 0xbf, 0x65, 0xca, 0x6c, 0x79, 0xba, 0x74, 0x3a, 0x89, 0x74	/* T__pfx_early_setup_idt */
	.byte 0x0a, 0x54, 0x65, 0xca, 0x6c, 0x79, 0xba, 0x74, 0x3a, 0x89, 0x74	/* Tearly_setup_idt */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* t__pfx_paravirt_read_msr */
	.byte 0x0a, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* tparavirt_read_msr */
	.byte 0x0e, 0x3f, 0x1f, 0x70, 0xee, 0x73, 0x6f, 0x6e, 0xe1, 0xe4, 0xc5, 0x69, 0x61, 0x33, 0x32	/* T__pfx_set_personality_ia32 */
	.byte 0x0f, 0x54, 0xc9, 0xf9, 0x70, 0xee, 0x73, 0x6f, 0x6e, 0xe1, 0xe4, 0xc5, 0x69, 0x61, 0x33, 0x32	/* Tset_personality_ia32 */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0x6c	/* T__pfx___ia32_compat_sys_arch_prctl */
	.byte 0x11, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0x6c	/* T__ia32_compat_sys_arch_prctl */
	.byte 0x0d, 0xbf, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x73, 0x61, 0x22, 0x66, 0x73, 0x67, 0x73	/* T__pfx_current_save_fsgs */
	.byte 0x0d, 0x54, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x73, 0x61, 0x22, 0x66, 0x73, 0x67, 0x73	/* Tcurrent_save_fsgs */
	.byte 0x13, 0xa8, 0xf6, 0xdb, 0x72, 0xf9, 0x15, 0xf8, 0x05, 0xfe, 0x6d, 0xa5, 0x6e, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_start_thread_common.constprop.0 */
	.byte 0x13, 0x74, 0x73, 0xdb, 0x72, 0xf9, 0x15, 0xf8, 0x05, 0xfe, 0x6d, 0xa5, 0x6e, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tstart_thread_common.constprop.0 */
	.byte 0x08, 0x3f, 0xf6, 0xdb, 0x72, 0xf9, 0x15, 0xf8, 0xc7	/* T__pfx_start_thread */
	.byte 0x08, 0x54, 0x73, 0xdb, 0x72, 0xf9, 0x15, 0xf8, 0xc7	/* Tstart_thread */
	.byte 0x07, 0x3f, 0xff, 0xf6, 0xad, 0xaa, 0x9f, 0x73	/* T__pfx___show_regs */
	.byte 0x06, 0x2f, 0x73, 0xad, 0xaa, 0x9f, 0x73	/* T__show_regs */
	.byte 0x08, 0xbf, 0xf8, 0xd3, 0x96, 0xfa, 0x15, 0xf8, 0xc7	/* T__pfx_release_thread */
	.byte 0x08, 0x54, 0xf8, 0xd3, 0x96, 0xfa, 0x15, 0xf8, 0xc7	/* Trelease_thread */
	.byte 0x10, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0x73, 0x67, 0x73, 0x62, 0x96, 0xfa, 0xf8, 0x05, 0xdb, 0x16	/* T__pfx_x86_fsgsbase_read_task */
	.byte 0x10, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x66, 0x73, 0x67, 0x73, 0x62, 0x96, 0xfa, 0xf8, 0x05, 0xdb, 0x16	/* Tx86_fsgsbase_read_task */
	.byte 0x13, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x67, 0x73, 0x62, 0x96, 0xfa, 0xf8, 0x05, 0x92, 0x5f, 0xf0, 0xeb, 0xc2, 0x76, 0x65	/* T__pfx_x86_gsbase_read_cpu_inactive */
	.byte 0x13, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x67, 0x73, 0x62, 0x96, 0xfa, 0xf8, 0x05, 0x92, 0x5f, 0xf0, 0xeb, 0xc2, 0x76, 0x65	/* Tx86_gsbase_read_cpu_inactive */
	.byte 0x13, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x67, 0x73, 0x62, 0x96, 0xfa, 0x24, 0xfa, 0x92, 0x5f, 0xf0, 0xeb, 0xc2, 0x76, 0x65	/* T__pfx_x86_gsbase_write_cpu_inactive */
	.byte 0x13, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x67, 0x73, 0x62, 0x96, 0xfa, 0x24, 0xfa, 0x92, 0x5f, 0xf0, 0xeb, 0xc2, 0x76, 0x65	/* Tx86_gsbase_write_cpu_inactive */
	.byte 0x0e, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0x73, 0x62, 0x96, 0xfa, 0xf8, 0x05, 0xdb, 0x16	/* T__pfx_x86_fsbase_read_task */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x66, 0x73, 0x62, 0x96, 0xfa, 0xf8, 0x05, 0xdb, 0x16	/* Tx86_fsbase_read_task */
	.byte 0x0e, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x67, 0x73, 0x62, 0x96, 0xfa, 0xf8, 0x05, 0xdb, 0x16	/* T__pfx_x86_gsbase_read_task */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x67, 0x73, 0x62, 0x96, 0xfa, 0xf8, 0x05, 0xdb, 0x16	/* Tx86_gsbase_read_task */
	.byte 0x0e, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0x73, 0x62, 0x96, 0xfa, 0x24, 0xfa, 0xdb, 0x16	/* T__pfx_x86_fsbase_write_task */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x66, 0x73, 0x62, 0x96, 0xfa, 0x24, 0xfa, 0xdb, 0x16	/* Tx86_fsbase_write_task */
	.byte 0x0e, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x67, 0x73, 0x62, 0x96, 0xfa, 0x24, 0xfa, 0xdb, 0x16	/* T__pfx_x86_gsbase_write_task */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x67, 0x73, 0x62, 0x96, 0xfa, 0x24, 0xfa, 0xdb, 0x16	/* Tx86_gsbase_write_task */
	.byte 0x0b, 0xbf, 0x09, 0x61, 0xf9, 0x73, 0xdb, 0x72, 0xf9, 0x15, 0xf8, 0xc7	/* T__pfx_compat_start_thread */
	.byte 0x0b, 0x54, 0x09, 0x61, 0xf9, 0x73, 0xdb, 0x72, 0xf9, 0x15, 0xf8, 0xc7	/* Tcompat_start_thread */
	.byte 0x08, 0x3f, 0xff, 0xf6, 0x77, 0xe4, 0xd0, 0x5f, 0xac	/* T__pfx___switch_to */
	.byte 0x07, 0x2f, 0x73, 0x77, 0xe4, 0xd0, 0x5f, 0xac	/* T__switch_to */
	.byte 0x0e, 0x3f, 0x1f, 0x70, 0xee, 0x73, 0x6f, 0x6e, 0xe1, 0xe4, 0xc5, 0x36, 0x34, 0x62, 0xe4	/* T__pfx_set_personality_64bit */
	.byte 0x0f, 0x54, 0xc9, 0xf9, 0x70, 0xee, 0x73, 0x6f, 0x6e, 0xe1, 0xe4, 0xc5, 0x36, 0x34, 0x62, 0xe4	/* Tset_personality_64bit */
	.byte 0x0b, 0xbf, 0xa9, 0x5f, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0xc3, 0x36, 0x34	/* T__pfx_do_arch_prctl_64 */
	.byte 0x0b, 0x54, 0xa9, 0x5f, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0xc3, 0x36, 0x34	/* Tdo_arch_prctl_64 */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0x6c	/* T__pfx___ia32_sys_arch_prctl */
	.byte 0x0d, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0x6c	/* T__ia32_sys_arch_prctl */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0x6c	/* T__pfx___x64_sys_arch_prctl */
	.byte 0x0c, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0x6c	/* T__x64_sys_arch_prctl */
	.byte 0x09, 0xbf, 0x4b, 0x53, 0x54, 0x4b, 0x5f, 0x45, 0x53, 0x50	/* T__pfx_KSTK_ESP */
	.byte 0x09, 0x54, 0x4b, 0x53, 0x54, 0x4b, 0x5f, 0x45, 0x53, 0x50	/* TKSTK_ESP */
	.byte 0x07, 0xbf, 0xb2, 0x73, 0x2c, 0x66, 0xb5, 0xbd	/* T__pfx_get_sigframe */
	.byte 0x07, 0x54, 0xb2, 0x73, 0x2c, 0x66, 0xb5, 0xbd	/* Tget_sigframe */
	.byte 0x0c, 0xbf, 0xb2, 0x73, 0x2c, 0x66, 0xb5, 0x6d, 0xfa, 0x73, 0x69, 0x7a, 0x65	/* T__pfx_get_sigframe_size */
	.byte 0x0c, 0x54, 0xb2, 0x73, 0x2c, 0x66, 0xb5, 0x6d, 0xfa, 0x73, 0x69, 0x7a, 0x65	/* Tget_sigframe_size */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0x5f, 0xa9, 0xf6, 0x2c, 0x6e, 0xe1, 0x5f, 0xce, 0x5f, 0x3d, 0xdb, 0x72, 0x74	/* T__pfx_arch_do_signal_or_restart */
	.byte 0x10, 0x54, 0xca, 0xd0, 0x5f, 0xa9, 0xf6, 0x2c, 0x6e, 0xe1, 0x5f, 0xce, 0x5f, 0x3d, 0xdb, 0x72, 0x74	/* Tarch_do_signal_or_restart */
	.byte 0x0a, 0x3f, 0xf6, 0x2c, 0x6e, 0xe1, 0x5f, 0x66, 0x61, 0x0b, 0x74	/* T__pfx_signal_fault */
	.byte 0x0a, 0x54, 0x73, 0x2c, 0x6e, 0xe1, 0x5f, 0x66, 0x61, 0x0b, 0x74	/* Tsignal_fault */
	.byte 0x0f, 0x3f, 0xf6, 0x2c, 0xe1, 0x74, 0xd6, 0xeb, 0x6b, 0xf6, 0x69, 0x7a, 0xfa, 0x76, 0xe1, 0x89	/* T__pfx_sigaltstack_size_valid */
	.byte 0x0f, 0x54, 0x73, 0x2c, 0xe1, 0x74, 0xd6, 0xeb, 0x6b, 0xf6, 0x69, 0x7a, 0xfa, 0x76, 0xe1, 0x89	/* Tsigaltstack_size_valid */
	.byte 0x0a, 0xc6, 0x66, 0xce, 0x63, 0xfa, 0x76, 0xe1, 0x89, 0xf6, 0x73	/* t__pfx_force_valid_ss */
	.byte 0x0a, 0x74, 0x66, 0xce, 0x63, 0xfa, 0x76, 0xe1, 0x89, 0xf6, 0x73	/* tforce_valid_ss */
	.byte 0x0a, 0xc6, 0xf8, 0xd6, 0xce, 0xfa, 0x73, 0x2c, 0x98, 0x74, 0x97	/* t__pfx_restore_sigcontext */
	.byte 0x0a, 0x74, 0xf8, 0xd6, 0xce, 0xfa, 0x73, 0x2c, 0x98, 0x74, 0x97	/* trestore_sigcontext */
	.byte 0x0d, 0x29, 0x5f, 0xa9, 0x95, 0xe0, 0x72, 0xf9, 0x73, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* t__pfx___do_sys_rt_sigreturn */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x72, 0xf9, 0x73, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* T__pfx___ia32_sys_rt_sigreturn */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x72, 0xf9, 0x73, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* T__pfx___x64_sys_rt_sigreturn */
	.byte 0x0d, 0x74, 0xff, 0xa9, 0x95, 0xe0, 0x72, 0xf9, 0x73, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* t__do_sys_rt_sigreturn */
	.byte 0x0f, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x72, 0xf9, 0x73, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* T__ia32_sys_rt_sigreturn */
	.byte 0x0e, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x72, 0xf9, 0x73, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* T__x64_sys_rt_sigreturn */
	.byte 0x0c, 0xbf, 0x78, 0x36, 0x34, 0xba, 0x74, 0x3a, 0x72, 0xf9, 0x66, 0xb5, 0xbd	/* T__pfx_x64_setup_rt_frame */
	.byte 0x0c, 0x54, 0x78, 0x36, 0x34, 0xba, 0x74, 0x3a, 0x72, 0xf9, 0x66, 0xb5, 0xbd	/* Tx64_setup_rt_frame */
	.byte 0x0c, 0x3f, 0xf6, 0x2c, 0xeb, 0x74, 0xd9, 0x7c, 0x09, 0x61, 0xf9, 0x80, 0x69	/* T__pfx_sigaction_compat_abi */
	.byte 0x0c, 0x54, 0x73, 0x2c, 0xeb, 0x74, 0xd9, 0x7c, 0x09, 0x61, 0xf9, 0x80, 0x69	/* Tsigaction_compat_abi */
	.byte 0x07, 0xa8, 0xf6, 0x26, 0xf6, 0x2c, 0x6e, 0xe1	/* t__pfx_show_signal */
	.byte 0x07, 0x74, 0x73, 0x26, 0xf6, 0x2c, 0x6e, 0xe1	/* tshow_signal */
	.byte 0x06, 0xc6, 0xa9, 0x5f, 0xea, 0x61, 0x70	/* t__pfx_do_trap */
	.byte 0x06, 0x74, 0xa9, 0x5f, 0xea, 0x61, 0x70	/* tdo_trap */
	.byte 0x08, 0xc6, 0xb6, 0xc2, 0x66, 0xc5, 0xe6, 0xa2, 0x67	/* t__pfx_notify_debug */
	.byte 0x08, 0x74, 0xb6, 0xc2, 0x66, 0xc5, 0xe6, 0xa2, 0x67	/* tnotify_debug */
	.byte 0x0b, 0xc6, 0xb2, 0x6b, 0xee, 0xb4, 0xc3, 0x67, 0xe2, 0x10, 0x3d, 0x73	/* t__pfx_get_kernel_gp_address */
	.byte 0x0b, 0x74, 0xb2, 0x6b, 0xee, 0xb4, 0xc3, 0x67, 0xe2, 0x10, 0x3d, 0x73	/* tget_kernel_gp_address */
	.byte 0x06, 0xc6, 0xa9, 0x5f, 0xf0, 0x74, 0x33	/* t__pfx_do_int3 */
	.byte 0x06, 0x74, 0xa9, 0x5f, 0xf0, 0x74, 0x33	/* tdo_int3 */
	.byte 0x07, 0xc6, 0x6d, 0xe9, 0x5b, 0xee, 0xde, 0x72	/* t__pfx_math_error */
	.byte 0x07, 0x74, 0x6d, 0xe9, 0x5b, 0xee, 0xde, 0x72	/* tmath_error */
	.byte 0x0a, 0xc6, 0xa9, 0x5f, 0xee, 0xde, 0x72, 0x5f, 0xea, 0x61, 0x70	/* t__pfx_do_error_trap */
	.byte 0x0a, 0x74, 0xa9, 0x5f, 0xee, 0xde, 0x72, 0x5f, 0xea, 0x61, 0x70	/* tdo_error_trap */
	.byte 0x0b, 0xbf, 0x69, 0xe0, 0x76, 0xe1, 0x69, 0xe5, 0xa2, 0x67, 0x10, 0x72	/* T__pfx_is_valid_bugaddr */
	.byte 0x0b, 0x54, 0x69, 0xe0, 0x76, 0xe1, 0x69, 0xe5, 0xa2, 0x67, 0x10, 0x72	/* Tis_valid_bugaddr */
	.byte 0x07, 0xbf, 0xe6, 0xfe, 0x64, 0xfa, 0xa2, 0x67	/* T__pfx_decode_bug */
	.byte 0x07, 0x54, 0xe6, 0xfe, 0x64, 0xfa, 0xa2, 0x67	/* Tdecode_bug */
	.byte 0x0e, 0xbf, 0x68, 0xcc, 0x64, 0xb3, 0xd6, 0xeb, 0xd8, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0x77	/* T__pfx_handle_stack_overflow */
	.byte 0x0e, 0x54, 0x68, 0xcc, 0x64, 0xb3, 0xd6, 0xeb, 0xd8, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0x77	/* Thandle_stack_overflow */
	.byte 0x05, 0xc6, 0xdf, 0x05, 0x89, 0x74	/* t__pfx_load_idt */
	.byte 0x05, 0x74, 0xdf, 0x05, 0x89, 0x74	/* tload_idt */
	.byte 0x0a, 0xbf, 0xdf, 0x05, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x89, 0x74	/* T__pfx_load_current_idt */
	.byte 0x0a, 0x54, 0xdf, 0x05, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x89, 0x74	/* Tload_current_idt */
	.byte 0x08, 0xbf, 0x89, 0xf9, 0xf0, 0x76, 0xe1, 0x89, 0x86	/* T__pfx_idt_invalidate */
	.byte 0x08, 0x54, 0x89, 0xf9, 0xf0, 0x76, 0xe1, 0x89, 0x86	/* Tidt_invalidate */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xc0, 0xe1, 0x5f, 0xc2, 0x6d, 0xcf, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_local_timer_entry */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xcf, 0xc0, 0xe1, 0x5f, 0xc2, 0x6d, 0xcf, 0xe8, 0xea, 0x79	/* T__traceiter_local_timer_entry */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xc0, 0xe1, 0x5f, 0xc2, 0x6d, 0xcf, 0xe8, 0xea, 0x79	/* T__pfx___probestub_local_timer_entry */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xc0, 0xe1, 0x5f, 0xc2, 0x6d, 0xcf, 0xe8, 0xea, 0x79	/* T__probestub_local_timer_entry */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xc0, 0xe1, 0x5f, 0xc2, 0x6d, 0xcf, 0xd1, 0xe4	/* T__pfx___traceiter_local_timer_exit */
	.byte 0x0c, 0x2f, 0x01, 0xe4, 0xcf, 0xc0, 0xe1, 0x5f, 0xc2, 0x6d, 0xcf, 0xd1, 0xe4	/* T__traceiter_local_timer_exit */
	.byte 0x0f, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xc0, 0xe1, 0x5f, 0xc2, 0x6d, 0xcf, 0xd1, 0xe4	/* T__pfx___probestub_local_timer_exit */
	.byte 0x0e, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xc0, 0xe1, 0x5f, 0xc2, 0x6d, 0xcf, 0xd1, 0xe4	/* T__probestub_local_timer_exit */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xee, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_spurious_apic_entry */
	.byte 0x11, 0x2f, 0x01, 0xe4, 0xee, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__traceiter_spurious_apic_entry */
	.byte 0x14, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0x62, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__pfx___probestub_spurious_apic_entry */
	.byte 0x13, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0x62, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__probestub_spurious_apic_entry */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xee, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__pfx___traceiter_spurious_apic_exit */
	.byte 0x10, 0x2f, 0x01, 0xe4, 0xee, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__traceiter_spurious_apic_exit */
	.byte 0x13, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0x62, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__pfx___probestub_spurious_apic_exit */
	.byte 0x12, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0x62, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__probestub_spurious_apic_exit */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_error_apic_entry */
	.byte 0x0f, 0x2f, 0x01, 0xe4, 0xcf, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__traceiter_error_apic_entry */
	.byte 0x12, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__pfx___probestub_error_apic_entry */
	.byte 0x11, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__probestub_error_apic_entry */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__pfx___traceiter_error_apic_exit */
	.byte 0x0e, 0x2f, 0x01, 0xe4, 0xcf, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__traceiter_error_apic_exit */
	.byte 0x11, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__pfx___probestub_error_apic_exit */
	.byte 0x10, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__probestub_error_apic_exit */
	.byte 0x14, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x69, 0x85, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_x86_platform_ipi_entry */
	.byte 0x12, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x69, 0x85, 0xe8, 0xea, 0x79	/* T__traceiter_x86_platform_ipi_entry */
	.byte 0x15, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x69, 0x85, 0xe8, 0xea, 0x79	/* T__pfx___probestub_x86_platform_ipi_entry */
	.byte 0x14, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x69, 0x85, 0xe8, 0xea, 0x79	/* T__probestub_x86_platform_ipi_entry */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x69, 0x85, 0xd1, 0xe4	/* T__pfx___traceiter_x86_platform_ipi_exit */
	.byte 0x11, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x69, 0x85, 0xd1, 0xe4	/* T__traceiter_x86_platform_ipi_exit */
	.byte 0x14, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x69, 0x85, 0xd1, 0xe4	/* T__pfx___probestub_x86_platform_ipi_exit */
	.byte 0x13, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x69, 0x85, 0xd1, 0xe4	/* T__probestub_x86_platform_ipi_exit */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_irq_work_entry */
	.byte 0x0c, 0x2f, 0x01, 0xe4, 0xcf, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xe8, 0xea, 0x79	/* T__traceiter_irq_work_entry */
	.byte 0x0f, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xe8, 0xea, 0x79	/* T__pfx___probestub_irq_work_entry */
	.byte 0x0e, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xe8, 0xea, 0x79	/* T__probestub_irq_work_entry */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xd1, 0xe4	/* T__pfx___traceiter_irq_work_exit */
	.byte 0x0b, 0x2f, 0x01, 0xe4, 0xcf, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xd1, 0xe4	/* T__traceiter_irq_work_exit */
	.byte 0x0e, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xd1, 0xe4	/* T__pfx___probestub_irq_work_exit */
	.byte 0x0d, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xd1, 0xe4	/* T__probestub_irq_work_exit */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_reschedule_entry */
	.byte 0x0c, 0x2f, 0x01, 0xe4, 0xcf, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xe8, 0xea, 0x79	/* T__traceiter_reschedule_entry */
	.byte 0x0f, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xe8, 0xea, 0x79	/* T__pfx___probestub_reschedule_entry */
	.byte 0x0e, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xe8, 0xea, 0x79	/* T__probestub_reschedule_entry */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xd1, 0xe4	/* T__pfx___traceiter_reschedule_exit */
	.byte 0x0b, 0x2f, 0x01, 0xe4, 0xcf, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xd1, 0xe4	/* T__traceiter_reschedule_exit */
	.byte 0x0e, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xd1, 0xe4	/* T__pfx___probestub_reschedule_exit */
	.byte 0x0d, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xd1, 0xe4	/* T__probestub_reschedule_exit */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x7c, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_call_function_entry */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xcf, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x7c, 0xe8, 0xea, 0x79	/* T__traceiter_call_function_entry */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x7c, 0xe8, 0xea, 0x79	/* T__pfx___probestub_call_function_entry */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x7c, 0xe8, 0xea, 0x79	/* T__probestub_call_function_entry */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x7c, 0xd1, 0xe4	/* T__pfx___traceiter_call_function_exit */
	.byte 0x0c, 0x2f, 0x01, 0xe4, 0xcf, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x7c, 0xd1, 0xe4	/* T__traceiter_call_function_exit */
	.byte 0x0f, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x7c, 0xd1, 0xe4	/* T__pfx___probestub_call_function_exit */
	.byte 0x0e, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x7c, 0xd1, 0xe4	/* T__probestub_call_function_exit */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xb3, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_call_function_single_entry */
	.byte 0x11, 0x2f, 0x01, 0xe4, 0xcf, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xb3, 0xe8, 0xea, 0x79	/* T__traceiter_call_function_single_entry */
	.byte 0x14, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xb3, 0xe8, 0xea, 0x79	/* T__pfx___probestub_call_function_single_entry */
	.byte 0x13, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xb3, 0xe8, 0xea, 0x79	/* T__probestub_call_function_single_entry */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xb3, 0xd1, 0xe4	/* T__pfx___traceiter_call_function_single_exit */
	.byte 0x10, 0x2f, 0x01, 0xe4, 0xcf, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xb3, 0xd1, 0xe4	/* T__traceiter_call_function_single_exit */
	.byte 0x13, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xb3, 0xd1, 0xe4	/* T__pfx___probestub_call_function_single_exit */
	.byte 0x12, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xb3, 0xd1, 0xe4	/* T__probestub_call_function_single_exit */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_threshold_apic_entry */
	.byte 0x10, 0x2f, 0x01, 0xe4, 0xcf, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__traceiter_threshold_apic_entry */
	.byte 0x13, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__pfx___probestub_threshold_apic_entry */
	.byte 0x12, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__probestub_threshold_apic_entry */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__pfx___traceiter_threshold_apic_exit */
	.byte 0x0f, 0x2f, 0x01, 0xe4, 0xcf, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__traceiter_threshold_apic_exit */
	.byte 0x12, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__pfx___probestub_threshold_apic_exit */
	.byte 0x11, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__probestub_threshold_apic_exit */
	.byte 0x16, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_deferred_error_apic_entry */
	.byte 0x14, 0x2f, 0x01, 0xe4, 0xcf, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__traceiter_deferred_error_apic_entry */
	.byte 0x17, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__pfx___probestub_deferred_error_apic_entry */
	.byte 0x16, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__probestub_deferred_error_apic_entry */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__pfx___traceiter_deferred_error_apic_exit */
	.byte 0x13, 0x2f, 0x01, 0xe4, 0xcf, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__traceiter_deferred_error_apic_exit */
	.byte 0x16, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__pfx___probestub_deferred_error_apic_exit */
	.byte 0x15, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__probestub_deferred_error_apic_exit */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x15, 0xee, 0x6d, 0xe1, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_thermal_apic_entry */
	.byte 0x10, 0x2f, 0x01, 0xe4, 0xcf, 0x15, 0xee, 0x6d, 0xe1, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__traceiter_thermal_apic_entry */
	.byte 0x13, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x15, 0xee, 0x6d, 0xe1, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__pfx___probestub_thermal_apic_entry */
	.byte 0x12, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x15, 0xee, 0x6d, 0xe1, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x79	/* T__probestub_thermal_apic_entry */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x15, 0xee, 0x6d, 0xe1, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__pfx___traceiter_thermal_apic_exit */
	.byte 0x0f, 0x2f, 0x01, 0xe4, 0xcf, 0x15, 0xee, 0x6d, 0xe1, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__traceiter_thermal_apic_exit */
	.byte 0x12, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x15, 0xee, 0x6d, 0xe1, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__pfx___probestub_thermal_apic_exit */
	.byte 0x11, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x15, 0xee, 0x6d, 0xe1, 0x5f, 0x61, 0x70, 0x69, 0xd5, 0xd1, 0xe4	/* T__probestub_thermal_apic_exit */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x98, 0xb8, 0x67	/* T__pfx___traceiter_vector_config */
	.byte 0x0c, 0x2f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x98, 0xb8, 0x67	/* T__traceiter_vector_config */
	.byte 0x0f, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x98, 0xb8, 0x67	/* T__pfx___probestub_vector_config */
	.byte 0x0e, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x98, 0xb8, 0x67	/* T__probestub_vector_config */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xb9, 0x64, 0x86	/* T__pfx___traceiter_vector_update */
	.byte 0x0c, 0x2f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xb9, 0x64, 0x86	/* T__traceiter_vector_update */
	.byte 0x0f, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xb9, 0x64, 0x86	/* T__pfx___probestub_vector_update */
	.byte 0x0e, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xb9, 0x64, 0x86	/* T__probestub_vector_update */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x63, 0xd3, 0xca	/* T__pfx___traceiter_vector_clear */
	.byte 0x0c, 0x2f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x63, 0xd3, 0xca	/* T__traceiter_vector_clear */
	.byte 0x0f, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x63, 0xd3, 0xca	/* T__pfx___probestub_vector_clear */
	.byte 0x0e, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x63, 0xd3, 0xca	/* T__probestub_vector_clear */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x22, 0xdd, 0x6e, 0x03, 0x64	/* T__pfx___traceiter_vector_reserve_managed */
	.byte 0x10, 0x2f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x22, 0xdd, 0x6e, 0x03, 0x64	/* T__traceiter_vector_reserve_managed */
	.byte 0x13, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x22, 0xdd, 0x6e, 0x03, 0x64	/* T__pfx___probestub_vector_reserve_managed */
	.byte 0x12, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x22, 0xdd, 0x6e, 0x03, 0x64	/* T__probestub_vector_reserve_managed */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x76, 0x65	/* T__pfx___traceiter_vector_reserve */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x76, 0x65	/* T__traceiter_vector_reserve */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x76, 0x65	/* T__pfx___probestub_vector_reserve */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x76, 0x65	/* T__probestub_vector_reserve */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe1, 0xc0	/* T__pfx___traceiter_vector_alloc */
	.byte 0x0b, 0x2f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe1, 0xc0	/* T__traceiter_vector_alloc */
	.byte 0x0e, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe1, 0xc0	/* T__pfx___probestub_vector_alloc */
	.byte 0x0d, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe1, 0xc0	/* T__probestub_vector_alloc */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xdd, 0x6e, 0x03, 0x64	/* T__pfx___traceiter_vector_alloc_managed */
	.byte 0x0f, 0x2f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xdd, 0x6e, 0x03, 0x64	/* T__traceiter_vector_alloc_managed */
	.byte 0x12, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xdd, 0x6e, 0x03, 0x64	/* T__pfx___probestub_vector_alloc_managed */
	.byte 0x11, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xdd, 0x6e, 0x03, 0x64	/* T__probestub_vector_alloc_managed */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* T__pfx___traceiter_vector_activate */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* T__traceiter_vector_activate */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* T__pfx___probestub_vector_activate */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* T__probestub_vector_activate */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe6, 0xeb, 0xc2, 0x76, 0x86	/* T__pfx___traceiter_vector_deactivate */
	.byte 0x0e, 0x2f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe6, 0xeb, 0xc2, 0x76, 0x86	/* T__traceiter_vector_deactivate */
	.byte 0x11, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe6, 0xeb, 0xc2, 0x76, 0x86	/* T__pfx___probestub_vector_deactivate */
	.byte 0x10, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe6, 0xeb, 0xc2, 0x76, 0x86	/* T__probestub_vector_deactivate */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* T__pfx___traceiter_vector_teardown */
	.byte 0x0e, 0x2f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* T__traceiter_vector_teardown */
	.byte 0x11, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* T__pfx___probestub_vector_teardown */
	.byte 0x10, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* T__probestub_vector_teardown */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* T__pfx___traceiter_vector_setup */
	.byte 0x0b, 0x2f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* T__traceiter_vector_setup */
	.byte 0x0e, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* T__pfx___probestub_vector_setup */
	.byte 0x0d, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* T__probestub_vector_setup */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0x64	/* T__pfx___traceiter_vector_free_moved */
	.byte 0x0f, 0x2f, 0x01, 0xe4, 0xcf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0x64	/* T__traceiter_vector_free_moved */
	.byte 0x12, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0x64	/* T__pfx___probestub_vector_free_moved */
	.byte 0x11, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0x64	/* T__probestub_vector_free_moved */
	.byte 0x0e, 0xa8, 0xe7, 0xee, 0x66, 0xe7, 0xee, 0xcd, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xd1, 0xe4	/* t__pfx_perf_perm_irq_work_exit */
	.byte 0x0d, 0x06, 0xee, 0x66, 0xe7, 0xee, 0xcd, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xd1, 0xe4	/* tperf_perm_irq_work_exit */
	.byte 0x0b, 0xc6, 0x64, 0x75, 0x6d, 0x6d, 0xc5, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_dummy_handler */
	.byte 0x0b, 0x74, 0x64, 0x75, 0x6d, 0x6d, 0xc5, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* tdummy_handler */
	.byte 0x10, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0x64	/* t__pfx_perf_trace_vector_free_moved */
	.byte 0x0f, 0x06, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0x64	/* tperf_trace_vector_free_moved */
	.byte 0x0c, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* t__pfx_perf_trace_vector_setup */
	.byte 0x0b, 0x06, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* tperf_trace_vector_setup */
	.byte 0x0f, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* t__pfx_perf_trace_vector_teardown */
	.byte 0x0e, 0x06, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* tperf_trace_vector_teardown */
	.byte 0x0e, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* t__pfx_perf_trace_vector_activate */
	.byte 0x0d, 0x06, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* tperf_trace_vector_activate */
	.byte 0x10, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xdd, 0x6e, 0x03, 0x64	/* t__pfx_perf_trace_vector_alloc_managed */
	.byte 0x0f, 0x06, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xdd, 0x6e, 0x03, 0x64	/* tperf_trace_vector_alloc_managed */
	.byte 0x0c, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe1, 0xc0	/* t__pfx_perf_trace_vector_alloc */
	.byte 0x0b, 0x06, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe1, 0xc0	/* tperf_trace_vector_alloc */
	.byte 0x0e, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x76, 0x65	/* t__pfx_perf_trace_vector_reserve */
	.byte 0x0d, 0x06, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x76, 0x65	/* tperf_trace_vector_reserve */
	.byte 0x0c, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xa5, 0x64	/* t__pfx_perf_trace_vector_mod */
	.byte 0x0b, 0x06, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xa5, 0x64	/* tperf_trace_vector_mod */
	.byte 0x0d, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x98, 0xb8, 0x67	/* t__pfx_perf_trace_vector_config */
	.byte 0x0c, 0x06, 0xee, 0xa0, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x98, 0xb8, 0x67	/* tperf_trace_vector_config */
	.byte 0x0f, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce	/* t__pfx_perf_trace_x86_irq_vector */
	.byte 0x0e, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce	/* tperf_trace_x86_irq_vector */
	.byte 0x10, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0x64	/* t__pfx_trace_event_raw_event_vector_free_moved */
	.byte 0x10, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0x64	/* ttrace_event_raw_event_vector_free_moved */
	.byte 0x0c, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* t__pfx_trace_event_raw_event_vector_setup */
	.byte 0x0c, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* ttrace_event_raw_event_vector_setup */
	.byte 0x0f, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* t__pfx_trace_event_raw_event_vector_teardown */
	.byte 0x0f, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* ttrace_event_raw_event_vector_teardown */
	.byte 0x0e, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* t__pfx_trace_event_raw_event_vector_activate */
	.byte 0x0e, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* ttrace_event_raw_event_vector_activate */
	.byte 0x10, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xdd, 0x6e, 0x03, 0x64	/* t__pfx_trace_event_raw_event_vector_alloc_managed */
	.byte 0x10, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xdd, 0x6e, 0x03, 0x64	/* ttrace_event_raw_event_vector_alloc_managed */
	.byte 0x0c, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe1, 0xc0	/* t__pfx_trace_event_raw_event_vector_alloc */
	.byte 0x0c, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe1, 0xc0	/* ttrace_event_raw_event_vector_alloc */
	.byte 0x0e, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x76, 0x65	/* t__pfx_trace_event_raw_event_vector_reserve */
	.byte 0x0e, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x76, 0x65	/* ttrace_event_raw_event_vector_reserve */
	.byte 0x0c, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xa5, 0x64	/* t__pfx_trace_event_raw_event_vector_mod */
	.byte 0x0c, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xa5, 0x64	/* ttrace_event_raw_event_vector_mod */
	.byte 0x0d, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x98, 0xb8, 0x67	/* t__pfx_trace_event_raw_event_vector_config */
	.byte 0x0d, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x98, 0xb8, 0x67	/* ttrace_event_raw_event_vector_config */
	.byte 0x0f, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0x38, 0x36, 0x5f, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce	/* t__pfx_trace_event_raw_event_x86_irq_vector */
	.byte 0x0f, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0x38, 0x36, 0x5f, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce	/* ttrace_event_raw_event_x86_irq_vector */
	.byte 0x12, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0x64	/* t__pfx_trace_raw_output_vector_free_moved */
	.byte 0x12, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0x64	/* ttrace_raw_output_vector_free_moved */
	.byte 0x0e, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* t__pfx_trace_raw_output_vector_setup */
	.byte 0x0e, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* ttrace_raw_output_vector_setup */
	.byte 0x11, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* t__pfx_trace_raw_output_vector_teardown */
	.byte 0x11, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* ttrace_raw_output_vector_teardown */
	.byte 0x10, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* t__pfx_trace_raw_output_vector_activate */
	.byte 0x10, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* ttrace_raw_output_vector_activate */
	.byte 0x12, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xdd, 0x6e, 0x03, 0x64	/* t__pfx_trace_raw_output_vector_alloc_managed */
	.byte 0x12, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xdd, 0x6e, 0x03, 0x64	/* ttrace_raw_output_vector_alloc_managed */
	.byte 0x0e, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe1, 0xc0	/* t__pfx_trace_raw_output_vector_alloc */
	.byte 0x0e, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe1, 0xc0	/* ttrace_raw_output_vector_alloc */
	.byte 0x10, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x76, 0x65	/* t__pfx_trace_raw_output_vector_reserve */
	.byte 0x10, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x76, 0x65	/* ttrace_raw_output_vector_reserve */
	.byte 0x0e, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xa5, 0x64	/* t__pfx_trace_raw_output_vector_mod */
	.byte 0x0e, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xa5, 0x64	/* ttrace_raw_output_vector_mod */
	.byte 0x0f, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x98, 0xb8, 0x67	/* t__pfx_trace_raw_output_vector_config */
	.byte 0x0f, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x98, 0xb8, 0x67	/* ttrace_raw_output_vector_config */
	.byte 0x11, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0x38, 0x36, 0x5f, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce	/* t__pfx_trace_raw_output_x86_irq_vector */
	.byte 0x11, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0x38, 0x36, 0x5f, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce	/* ttrace_raw_output_x86_irq_vector */
	.byte 0x0e, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce	/* t__pfx___bpf_trace_x86_irq_vector */
	.byte 0x0e, 0x74, 0xff, 0x40, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce	/* t__bpf_trace_x86_irq_vector */
	.byte 0x0f, 0x29, 0x5f, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0x64	/* t__pfx___bpf_trace_vector_free_moved */
	.byte 0x0f, 0x74, 0xff, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0x64	/* t__bpf_trace_vector_free_moved */
	.byte 0x0d, 0x29, 0x5f, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* t__pfx___bpf_trace_vector_activate */
	.byte 0x0d, 0x74, 0xff, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* t__bpf_trace_vector_activate */
	.byte 0x0b, 0x29, 0x5f, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe1, 0xc0	/* t__pfx___bpf_trace_vector_alloc */
	.byte 0x0b, 0x74, 0xff, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe1, 0xc0	/* t__bpf_trace_vector_alloc */
	.byte 0x0c, 0x29, 0x5f, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x98, 0xb8, 0x67	/* t__pfx___bpf_trace_vector_config */
	.byte 0x0c, 0x74, 0xff, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x98, 0xb8, 0x67	/* t__bpf_trace_vector_config */
	.byte 0x0b, 0x29, 0x5f, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xa5, 0x64	/* t__pfx___bpf_trace_vector_mod */
	.byte 0x0b, 0x74, 0xff, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xa5, 0x64	/* t__bpf_trace_vector_mod */
	.byte 0x0d, 0x29, 0x5f, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x76, 0x65	/* t__pfx___bpf_trace_vector_reserve */
	.byte 0x0d, 0x74, 0xff, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3d, 0xee, 0x76, 0x65	/* t__bpf_trace_vector_reserve */
	.byte 0x0b, 0x29, 0x5f, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* t__pfx___bpf_trace_vector_setup */
	.byte 0x0b, 0x74, 0xff, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* t__bpf_trace_vector_setup */
	.byte 0x0e, 0x29, 0x5f, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* t__pfx___bpf_trace_vector_teardown */
	.byte 0x0e, 0x74, 0xff, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* t__bpf_trace_vector_teardown */
	.byte 0x0f, 0x29, 0x5f, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xdd, 0x6e, 0x03, 0x64	/* t__pfx___bpf_trace_vector_alloc_managed */
	.byte 0x0f, 0x74, 0xff, 0x40, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xdd, 0x6e, 0x03, 0x64	/* t__bpf_trace_vector_alloc_managed */
	.byte 0x16, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x6b, 0x76, 0x6d, 0xe7, 0x6f, 0xd6, 0x65, 0xe5, 0xf0, 0xea, 0x5f, 0x13, 0x0e, 0x3a, 0x0c, 0x69	/* t__pfx___sysvec_kvm_posted_intr_wakeup_ipi */
	.byte 0x17, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0x6b, 0x76, 0x6d, 0xe7, 0x6f, 0xd6, 0x65, 0xe5, 0xf0, 0xea, 0x5f, 0x13, 0x0e, 0x3a, 0x0c, 0x69	/* t__sysvec_kvm_posted_intr_wakeup_ipi */
	.byte 0x0c, 0x29, 0x5f, 0xfe, 0x6d, 0xa5, 0x7c, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx___common_interrupt */
	.byte 0x0c, 0x74, 0xff, 0xfe, 0x6d, 0xa5, 0x7c, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__common_interrupt */
	.byte 0x15, 0xbf, 0x6b, 0x76, 0x6d, 0x1f, 0x70, 0x6f, 0xd6, 0x65, 0xe5, 0xf0, 0xea, 0x5f, 0x13, 0x0e, 0x3a, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_kvm_set_posted_intr_wakeup_handler */
	.byte 0x15, 0x54, 0x6b, 0x76, 0x6d, 0x1f, 0x70, 0x6f, 0xd6, 0x65, 0xe5, 0xf0, 0xea, 0x5f, 0x13, 0x0e, 0x3a, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Tkvm_set_posted_intr_wakeup_handler */
	.byte 0x0a, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x15, 0xee, 0x6d, 0xe1	/* t__pfx___sysvec_thermal */
	.byte 0x0b, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0x15, 0xee, 0x6d, 0xe1	/* t__sysvec_thermal */
	.byte 0x11, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x78, 0x38, 0x36, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x0c, 0x69	/* t__pfx___sysvec_x86_platform_ipi */
	.byte 0x12, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0x78, 0x38, 0x36, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x0c, 0x69	/* t__sysvec_x86_platform_ipi */
	.byte 0x07, 0xbf, 0xeb, 0xd8, 0x62, 0x05, 0xa7, 0x71	/* T__pfx_ack_bad_irq */
	.byte 0x07, 0x54, 0xeb, 0xd8, 0x62, 0x05, 0xa7, 0x71	/* Tack_bad_irq */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0xf6, 0xad, 0xaa, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74, 0x73	/* T__pfx_arch_show_interrupts */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0xf6, 0xad, 0xaa, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74, 0x73	/* Tarch_show_interrupts */
	.byte 0x0a, 0xbf, 0xca, 0xd0, 0x5f, 0xa7, 0x71, 0xf6, 0xdb, 0xf9, 0x92	/* T__pfx_arch_irq_stat_cpu */
	.byte 0x0a, 0x54, 0xca, 0xd0, 0x5f, 0xa7, 0x71, 0xf6, 0xdb, 0xf9, 0x92	/* Tarch_irq_stat_cpu */
	.byte 0x08, 0xbf, 0xca, 0xd0, 0x5f, 0xa7, 0x71, 0x2a, 0xe9	/* T__pfx_arch_irq_stat */
	.byte 0x08, 0x54, 0xca, 0xd0, 0x5f, 0xa7, 0x71, 0x2a, 0xe9	/* Tarch_irq_stat */
	.byte 0x13, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x78, 0x38, 0x36, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x0c, 0x69	/* T__pfx_fred_sysvec_x86_platform_ipi */
	.byte 0x13, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x78, 0x38, 0x36, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0xcd, 0x0c, 0x69	/* Tfred_sysvec_x86_platform_ipi */
	.byte 0x15, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x6b, 0x76, 0x6d, 0xe7, 0x6f, 0xd6, 0x65, 0xe5, 0xf0, 0xea, 0x5f, 0x0c, 0x69	/* T__pfx_fred_sysvec_kvm_posted_intr_ipi */
	.byte 0x15, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x6b, 0x76, 0x6d, 0xe7, 0x6f, 0xd6, 0x65, 0xe5, 0xf0, 0xea, 0x5f, 0x0c, 0x69	/* Tfred_sysvec_kvm_posted_intr_ipi */
	.byte 0x18, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x6b, 0x76, 0x6d, 0xe7, 0x6f, 0xd6, 0x65, 0xe5, 0xf0, 0xea, 0x5f, 0x13, 0x0e, 0x3a, 0x0c, 0x69	/* T__pfx_fred_sysvec_kvm_posted_intr_wakeup_ipi */
	.byte 0x18, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x6b, 0x76, 0x6d, 0xe7, 0x6f, 0xd6, 0x65, 0xe5, 0xf0, 0xea, 0x5f, 0x13, 0x0e, 0x3a, 0x0c, 0x69	/* Tfred_sysvec_kvm_posted_intr_wakeup_ipi */
	.byte 0x19, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x6b, 0x76, 0x6d, 0xe7, 0x6f, 0xd6, 0x65, 0xe5, 0xf0, 0xea, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x0c, 0x69	/* T__pfx_fred_sysvec_kvm_posted_intr_nested_ipi */
	.byte 0x19, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x6b, 0x76, 0x6d, 0xe7, 0x6f, 0xd6, 0x65, 0xe5, 0xf0, 0xea, 0x5f, 0xb4, 0xd6, 0x65, 0xe5, 0x0c, 0x69	/* Tfred_sysvec_kvm_posted_intr_nested_ipi */
	.byte 0x07, 0xbf, 0xb8, 0x78, 0x3a, 0xa7, 0x71, 0x73	/* T__pfx_fixup_irqs */
	.byte 0x07, 0x54, 0xb8, 0x78, 0x3a, 0xa7, 0x71, 0x73	/* Tfixup_irqs */
	.byte 0x0c, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x15, 0xee, 0x6d, 0xe1	/* T__pfx_fred_sysvec_thermal */
	.byte 0x0c, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x15, 0xee, 0x6d, 0xe1	/* Tfred_sysvec_thermal */
	.byte 0x0e, 0xbf, 0xa7, 0x93, 0xf0, 0x99, 0x70, 0xee, 0x92, 0x5f, 0xa7, 0x71, 0xd6, 0xeb, 0x6b	/* T__pfx_irq_init_percpu_irqstack */
	.byte 0x0e, 0x54, 0xa7, 0x93, 0xf0, 0x99, 0x70, 0xee, 0x92, 0x5f, 0xa7, 0x71, 0xd6, 0xeb, 0x6b	/* Tirq_init_percpu_irqstack */
	.byte 0x0a, 0x3f, 0x2a, 0xeb, 0xd8, 0x74, 0x27, 0xfa, 0x6e, 0x61, 0xbd	/* T__pfx_stack_type_name */
	.byte 0x0a, 0x54, 0xd6, 0xeb, 0xd8, 0x74, 0x27, 0xfa, 0x6e, 0x61, 0xbd	/* Tstack_type_name */
	.byte 0x08, 0xbf, 0xb2, 0xd6, 0xeb, 0xd8, 0xf0, 0x66, 0x6f	/* T__pfx_get_stack_info */
	.byte 0x08, 0x54, 0xb2, 0xd6, 0xeb, 0xd8, 0xf0, 0x66, 0x6f	/* Tget_stack_info */
	.byte 0x06, 0x3f, 0x25, 0xb8, 0xb3, 0x70, 0x63	/* T__pfx_profile_pc */
	.byte 0x06, 0x54, 0x9b, 0xb8, 0xb3, 0x70, 0x63	/* Tprofile_pc */
	.byte 0x0a, 0xc6, 0xc2, 0x6d, 0xcf, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx_timer_interrupt */
	.byte 0x0a, 0x74, 0xc2, 0x6d, 0xcf, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* ttimer_interrupt */
	.byte 0x0c, 0xbf, 0x63, 0x3c, 0x73, 0x6f, 0x1d, 0x63, 0xfa, 0xca, 0xd0, 0x5f, 0x8d	/* T__pfx_clocksource_arch_init */
	.byte 0x0c, 0x54, 0x63, 0x3c, 0x73, 0x6f, 0x1d, 0x63, 0xfa, 0xca, 0xd0, 0x5f, 0x8d	/* Tclocksource_arch_init */
	.byte 0x0b, 0xc6, 0xdb, 0x73, 0xd8, 0xb9, 0x64, 0xa1, 0x3e, 0x62, 0xe4, 0x0a	/* t__pfx_task_update_io_bitmap */
	.byte 0x0b, 0x74, 0xdb, 0x73, 0xd8, 0xb9, 0x64, 0xa1, 0x3e, 0x62, 0xe4, 0x0a	/* ttask_update_io_bitmap */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xd9, 0x70, 0x6c	/* T__pfx___x64_sys_iopl */
	.byte 0x09, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xd9, 0x70, 0x6c	/* T__x64_sys_iopl */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xd9, 0x70, 0x6c	/* T__pfx___ia32_sys_iopl */
	.byte 0x0a, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xd9, 0x70, 0x6c	/* T__ia32_sys_iopl */
	.byte 0x09, 0xbf, 0x3e, 0x62, 0xe4, 0x0a, 0xf6, 0x68, 0x61, 0xf8	/* T__pfx_io_bitmap_share */
	.byte 0x09, 0x54, 0x3e, 0x62, 0xe4, 0x0a, 0xf6, 0x68, 0x61, 0xf8	/* Tio_bitmap_share */
	.byte 0x07, 0xbf, 0x3e, 0x62, 0xe4, 0x84, 0xd1, 0xe4	/* T__pfx_io_bitmap_exit */
	.byte 0x07, 0x54, 0x3e, 0x62, 0xe4, 0x84, 0xd1, 0xe4	/* Tio_bitmap_exit */
	.byte 0x08, 0xbf, 0x6b, 0xc1, 0xe0, 0xd9, 0x70, 0xee, 0x6d	/* T__pfx_ksys_ioperm */
	.byte 0x08, 0x54, 0x6b, 0xc1, 0xe0, 0xd9, 0x70, 0xee, 0x6d	/* Tksys_ioperm */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xd9, 0x70, 0xee, 0x6d	/* T__pfx___ia32_sys_ioperm */
	.byte 0x0b, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xd9, 0x70, 0xee, 0x6d	/* T__ia32_sys_ioperm */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xd9, 0x70, 0xee, 0x6d	/* T__pfx___x64_sys_ioperm */
	.byte 0x0a, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xd9, 0x70, 0xee, 0x6d	/* T__x64_sys_ioperm */
	.byte 0x06, 0xbf, 0x6f, 0x81, 0xe0, 0xe8, 0x64	/* T__pfx_oops_end */
	.byte 0x06, 0x54, 0x6f, 0x81, 0xe0, 0xe8, 0x64	/* Toops_end */
	.byte 0x07, 0xbf, 0x6f, 0x81, 0xe0, 0x17, 0x67, 0xf0	/* T__pfx_oops_begin */
	.byte 0x07, 0x54, 0x6f, 0x81, 0xe0, 0x17, 0x67, 0xf0	/* Toops_begin */
	.byte 0x08, 0x3f, 0xf6, 0xad, 0xaa, 0x81, 0xfe, 0xe6, 0x73	/* T__pfx_show_opcodes */
	.byte 0x08, 0x54, 0x73, 0xad, 0xaa, 0x81, 0xfe, 0xe6, 0x73	/* Tshow_opcodes */
	.byte 0x06, 0x3f, 0xf6, 0x26, 0x2a, 0xeb, 0x6b	/* T__pfx_show_stack */
	.byte 0x06, 0x54, 0x73, 0x26, 0x2a, 0xeb, 0x6b	/* Tshow_stack */
	.byte 0x06, 0x3f, 0xf6, 0xad, 0xaa, 0x9f, 0x73	/* T__pfx_show_regs */
	.byte 0x06, 0x54, 0x73, 0xad, 0xaa, 0x9f, 0x73	/* Tshow_regs */
	.byte 0x09, 0x29, 0x5f, 0x64, 0x69, 0xfa, 0x62, 0x6f, 0x64, 0x79	/* t__pfx___die_body */
	.byte 0x09, 0x74, 0xff, 0x64, 0x69, 0xfa, 0x62, 0x6f, 0x64, 0x79	/* t__die_body */
	.byte 0x06, 0xbf, 0x64, 0x69, 0xfa, 0x10, 0x72	/* T__pfx_die_addr */
	.byte 0x06, 0x54, 0x64, 0x69, 0xfa, 0x10, 0x72	/* Tdie_addr */
	.byte 0x04, 0xbf, 0x64, 0x69, 0x65	/* T__pfx_die */
	.byte 0x04, 0x54, 0x64, 0x69, 0x65	/* Tdie */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx___traceiter_nmi_handler */
	.byte 0x0c, 0x2f, 0x01, 0xe4, 0xcf, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__traceiter_nmi_handler */
	.byte 0x0f, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx___probestub_nmi_handler */
	.byte 0x0e, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__probestub_nmi_handler */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x18, 0xcf, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx___register_nmi_handler */
	.byte 0x0b, 0x2f, 0x18, 0xcf, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__register_nmi_handler */
	.byte 0x0b, 0xbf, 0xc0, 0xe1, 0x5f, 0xac, 0x75, 0xd0, 0x5f, 0x6e, 0x6d, 0x69	/* T__pfx_local_touch_nmi */
	.byte 0x0b, 0x54, 0xc0, 0xe1, 0x5f, 0xac, 0x75, 0xd0, 0x5f, 0x6e, 0x6d, 0x69	/* Tlocal_touch_nmi */
	.byte 0x0d, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_perf_trace_nmi_handler */
	.byte 0x0c, 0x06, 0xee, 0xa0, 0xc8, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* tperf_trace_nmi_handler */
	.byte 0x0d, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_trace_event_raw_event_nmi_handler */
	.byte 0x0d, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* ttrace_event_raw_event_nmi_handler */
	.byte 0x0f, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_trace_raw_output_nmi_handler */
	.byte 0x0f, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* ttrace_raw_output_nmi_handler */
	.byte 0x0c, 0x29, 0x5f, 0x40, 0xc8, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx___bpf_trace_nmi_handler */
	.byte 0x0c, 0x74, 0xff, 0x40, 0xc8, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__bpf_trace_nmi_handler */
	.byte 0x08, 0xc6, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0xd3	/* t__pfx_nmi_handle */
	.byte 0x08, 0x74, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0xd3	/* tnmi_handle */
	.byte 0x0c, 0xbf, 0xd4, 0x18, 0xcf, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_unregister_nmi_handler */
	.byte 0x0c, 0x54, 0xd4, 0x18, 0xcf, 0x6e, 0x6d, 0xcb, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Tunregister_nmi_handler */
	.byte 0x0c, 0xc6, 0xd4, 0x6b, 0xb6, 0x77, 0x7c, 0x6e, 0x6d, 0xcb, 0xee, 0xde, 0x72	/* t__pfx_unknown_nmi_error */
	.byte 0x0c, 0x74, 0xd4, 0x6b, 0xb6, 0x77, 0x7c, 0x6e, 0x6d, 0xcb, 0xee, 0xde, 0x72	/* tunknown_nmi_error */
	.byte 0x0b, 0xa8, 0xe7, 0x63, 0x69, 0xf6, 0xee, 0x72, 0x5f, 0xee, 0xde, 0x72	/* t__pfx_pci_serr_error */
	.byte 0x0a, 0x06, 0x63, 0x69, 0xf6, 0xee, 0x72, 0x5f, 0xee, 0xde, 0x72	/* tpci_serr_error */
	.byte 0x08, 0xc6, 0x3e, 0x7e, 0x63, 0xd8, 0xee, 0xde, 0x72	/* t__pfx_io_check_error */
	.byte 0x08, 0x74, 0x3e, 0x7e, 0x63, 0xd8, 0xee, 0xde, 0x72	/* tio_check_error */
	.byte 0x07, 0x3f, 0xf6, 0xac, 0xe2, 0x6e, 0x6d, 0x69	/* T__pfx_stop_nmi */
	.byte 0x07, 0x54, 0xd6, 0x6f, 0xe2, 0x6e, 0x6d, 0x69	/* Tstop_nmi */
	.byte 0x08, 0xbf, 0x3d, 0xdb, 0x72, 0xf9, 0x6e, 0x6d, 0x69	/* T__pfx_restart_nmi */
	.byte 0x08, 0x54, 0x3d, 0xdb, 0x72, 0xf9, 0x6e, 0x6d, 0x69	/* Trestart_nmi */
	.byte 0x09, 0xc6, 0x08, 0xd5, 0x02, 0xf9, 0x73, 0xea, 0x75, 0x7b	/* t__pfx_alloc_ldt_struct */
	.byte 0x09, 0x74, 0x08, 0xd5, 0x02, 0xf9, 0x73, 0xea, 0x75, 0x7b	/* talloc_ldt_struct */
	.byte 0x0b, 0xc6, 0x87, 0xfa, 0x02, 0xf9, 0x70, 0x67, 0xdb, 0x62, 0xd3, 0x73	/* t__pfx_free_ldt_pgtables */
	.byte 0x0b, 0x74, 0x87, 0xfa, 0x02, 0xf9, 0x70, 0x67, 0xdb, 0x62, 0xd3, 0x73	/* tfree_ldt_pgtables */
	.byte 0x09, 0xc6, 0x87, 0xfa, 0x02, 0xf9, 0x73, 0xea, 0x75, 0x7b	/* t__pfx_free_ldt_struct */
	.byte 0x09, 0x74, 0x87, 0xfa, 0x02, 0xf9, 0x73, 0xea, 0x75, 0x7b	/* tfree_ldt_struct */
	.byte 0x05, 0xc6, 0xf8, 0x05, 0x02, 0x74	/* t__pfx_read_ldt */
	.byte 0x05, 0x74, 0xf8, 0x05, 0x02, 0x74	/* tread_ldt */
	.byte 0x0a, 0xc6, 0xf8, 0x05, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x02, 0x74	/* t__pfx_read_default_ldt */
	.byte 0x0a, 0x74, 0xf8, 0x05, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x02, 0x74	/* tread_default_ldt */
	.byte 0x08, 0xc6, 0x84, 0x02, 0xf9, 0x73, 0xea, 0x75, 0x7b	/* t__pfx_map_ldt_struct */
	.byte 0x08, 0x74, 0x84, 0x02, 0xf9, 0x73, 0xea, 0x75, 0x7b	/* tmap_ldt_struct */
	.byte 0x05, 0xc6, 0x24, 0xfa, 0x02, 0x74	/* t__pfx_write_ldt */
	.byte 0x05, 0x74, 0x24, 0xfa, 0x02, 0x74	/* twrite_ldt */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0x02, 0x74	/* T__pfx___ia32_sys_modify_ldt */
	.byte 0x0e, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0x02, 0x74	/* T__ia32_sys_modify_ldt */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0x02, 0x74	/* T__pfx___x64_sys_modify_ldt */
	.byte 0x0d, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0x02, 0x74	/* T__x64_sys_modify_ldt */
	.byte 0x07, 0xbf, 0xdf, 0x05, 0x6d, 0xcd, 0x02, 0x74	/* T__pfx_load_mm_ldt */
	.byte 0x07, 0x54, 0xdf, 0x05, 0x6d, 0xcd, 0x02, 0x74	/* Tload_mm_ldt */
	.byte 0x07, 0xc6, 0x66, 0x6c, 0x5d, 0x5b, 0x02, 0x74	/* t__pfx_flush_ldt */
	.byte 0x07, 0x74, 0x66, 0x6c, 0x5d, 0x5b, 0x02, 0x74	/* tflush_ldt */
	.byte 0x08, 0x3f, 0xf6, 0x77, 0xe4, 0xd0, 0x5f, 0x02, 0x74	/* T__pfx_switch_ldt */
	.byte 0x08, 0x54, 0x73, 0x77, 0xe4, 0xd0, 0x5f, 0x02, 0x74	/* Tswitch_ldt */
	.byte 0x08, 0xbf, 0x02, 0xf9, 0x64, 0x3a, 0x98, 0x74, 0x97	/* T__pfx_ldt_dup_context */
	.byte 0x08, 0x54, 0x02, 0xf9, 0x64, 0x3a, 0x98, 0x74, 0x97	/* Tldt_dup_context */
	.byte 0x0c, 0xbf, 0xe6, 0x73, 0xea, 0x6f, 0xc5, 0x98, 0x74, 0xd1, 0xf9, 0x02, 0x74	/* T__pfx_destroy_context_ldt */
	.byte 0x0c, 0x54, 0xe6, 0x73, 0xea, 0x6f, 0xc5, 0x98, 0x74, 0xd1, 0xf9, 0x02, 0x74	/* Tdestroy_context_ldt */
	.byte 0x0a, 0xbf, 0x02, 0xf9, 0xca, 0xd0, 0x5f, 0xd1, 0x99, 0x6d, 0x0a	/* T__pfx_ldt_arch_exit_mmap */
	.byte 0x0a, 0x54, 0x02, 0xf9, 0xca, 0xd0, 0x5f, 0xd1, 0x99, 0x6d, 0x0a	/* Tldt_arch_exit_mmap */
	.byte 0x0c, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x98, 0xb8, 0x67, 0x1d, 0xfa, 0x6e, 0x78	/* T__pfx_x86_configure_nx */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x98, 0xb8, 0x67, 0x1d, 0xfa, 0x6e, 0x78	/* Tx86_configure_nx */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0x5f, 0x92, 0x5f, 0x69, 0xe0, 0xad, 0x06, 0x6c, 0x75, 0x67, 0x67, 0x80, 0xd3	/* T__pfx_arch_cpu_is_hotpluggable */
	.byte 0x10, 0x54, 0xca, 0xd0, 0x5f, 0x92, 0x5f, 0x69, 0xe0, 0xad, 0x06, 0x6c, 0x75, 0x67, 0x67, 0x80, 0xd3	/* Tarch_cpu_is_hotpluggable */
	.byte 0x0a, 0xc6, 0x69, 0xe0, 0x49, 0x53, 0x41, 0x5f, 0x72, 0xcc, 0xda	/* t__pfx_is_ISA_range */
	.byte 0x09, 0xc2, 0xe0, 0x49, 0x53, 0x41, 0x5f, 0x72, 0xcc, 0xda	/* tis_ISA_range */
	.byte 0x0e, 0xc6, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0xb2, 0x6e, 0x6d, 0xcb, 0xf8, 0x96, 0x6f, 0x6e	/* t__pfx_default_get_nmi_reason */
	.byte 0x0e, 0x74, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0xb2, 0x6e, 0x6d, 0xcb, 0xf8, 0x96, 0x6f, 0x6e	/* tdefault_get_nmi_reason */
	.byte 0x09, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0xf0, 0x99, 0xb6, 0x81	/* T__pfx_x86_init_noop */
	.byte 0x09, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xf0, 0x99, 0xb6, 0x81	/* Tx86_init_noop */
	.byte 0x0d, 0xc6, 0xd9, 0x6d, 0x6d, 0x75, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x7c, 0xb6, 0x81	/* t__pfx_iommu_shutdown_noop */
	.byte 0x0d, 0x74, 0xd9, 0x6d, 0x6d, 0x75, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x7c, 0xb6, 0x81	/* tiommu_shutdown_noop */
	.byte 0x0b, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x6f, 0xe2, 0xf0, 0xf9, 0xb6, 0x81	/* T__pfx_x86_op_int_noop */
	.byte 0x0b, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x6f, 0xe2, 0xf0, 0xf9, 0xb6, 0x81	/* Tx86_op_int_noop */
	.byte 0x07, 0x3f, 0x1f, 0x72, 0x74, 0xd5, 0xb6, 0x81	/* T__pfx_set_rtc_noop */
	.byte 0x08, 0x54, 0xc9, 0xf9, 0x72, 0x74, 0xd5, 0xb6, 0x81	/* Tset_rtc_noop */
	.byte 0x07, 0xbf, 0xb2, 0x72, 0x74, 0xd5, 0xb6, 0x81	/* T__pfx_get_rtc_noop */
	.byte 0x07, 0x54, 0xb2, 0x72, 0x74, 0xd5, 0xb6, 0x81	/* Tget_rtc_noop */
	.byte 0x0a, 0xc6, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x6e, 0x6d, 0xcb, 0x8d	/* t__pfx_default_nmi_init */
	.byte 0x0a, 0x74, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x6e, 0x6d, 0xcb, 0x8d	/* tdefault_nmi_init */
	.byte 0x11, 0xc6, 0xe8, 0x63, 0x2a, 0xe9, 0x75, 0xe0, 0xd0, 0xcc, 0x21, 0x70, 0xf8, 0x70, 0xca, 0xfa, 0xb6, 0x81	/* t__pfx_enc_status_change_prepare_noop */
	.byte 0x11, 0x74, 0xe8, 0x63, 0x2a, 0xe9, 0x75, 0xe0, 0xd0, 0xcc, 0x21, 0x70, 0xf8, 0x70, 0xca, 0xfa, 0xb6, 0x81	/* tenc_status_change_prepare_noop */
	.byte 0x10, 0xc6, 0xe8, 0x63, 0x2a, 0xe9, 0x75, 0xe0, 0xd0, 0xcc, 0x21, 0x66, 0xf0, 0xab, 0x5b, 0xb6, 0x81	/* t__pfx_enc_status_change_finish_noop */
	.byte 0x10, 0x74, 0xe8, 0x63, 0x2a, 0xe9, 0x75, 0xe0, 0xd0, 0xcc, 0x21, 0x66, 0xf0, 0xab, 0x5b, 0xb6, 0x81	/* tenc_status_change_finish_noop */
	.byte 0x11, 0xc6, 0xe8, 0xd5, 0x74, 0x6c, 0xdc, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x8e, 0x69, 0xf8, 0xe5, 0xb6, 0x81	/* t__pfx_enc_tlb_flush_required_noop */
	.byte 0x11, 0x74, 0xe8, 0xd5, 0x74, 0x6c, 0xdc, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x8e, 0x69, 0xf8, 0xe5, 0xb6, 0x81	/* tenc_tlb_flush_required_noop */
	.byte 0x12, 0xc6, 0xe8, 0xd5, 0x63, 0xeb, 0x68, 0xfa, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x8e, 0x69, 0xf8, 0xe5, 0xb6, 0x81	/* t__pfx_enc_cache_flush_required_noop */
	.byte 0x12, 0x74, 0xe8, 0xd5, 0x63, 0xeb, 0x68, 0xfa, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x8e, 0x69, 0xf8, 0xe5, 0xb6, 0x81	/* tenc_cache_flush_required_noop */
	.byte 0x0d, 0xc6, 0xe8, 0xd5, 0x6b, 0xd1, 0x65, 0xd5, 0x17, 0x67, 0xf0, 0x5f, 0xb6, 0x81	/* t__pfx_enc_kexec_begin_noop */
	.byte 0x0d, 0x74, 0xe8, 0xd5, 0x6b, 0xd1, 0x65, 0xd5, 0x17, 0x67, 0xf0, 0x5f, 0xb6, 0x81	/* tenc_kexec_begin_noop */
	.byte 0x0d, 0xc6, 0xe8, 0xd5, 0x6b, 0xd1, 0x65, 0xd5, 0x66, 0xf0, 0xab, 0x5b, 0xb6, 0x81	/* t__pfx_enc_kexec_finish_noop */
	.byte 0x0d, 0x74, 0xe8, 0xd5, 0x6b, 0xd1, 0x65, 0xd5, 0x66, 0xf0, 0xab, 0x5b, 0xb6, 0x81	/* tenc_kexec_finish_noop */
	.byte 0x0c, 0xc6, 0xab, 0xe7, 0x72, 0x69, 0x76, 0xa1, 0x6d, 0x6d, 0x3e, 0xb6, 0x81	/* t__pfx_is_private_mmio_noop */
	.byte 0x0c, 0xc2, 0x73, 0xe7, 0x72, 0x69, 0x76, 0xa1, 0x6d, 0x6d, 0x3e, 0xb6, 0x81	/* tis_private_mmio_noop */
	.byte 0x0c, 0xc6, 0xdd, 0x73, 0xd8, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xa7, 0x71	/* t__pfx_mask_8259A_irq */
	.byte 0x0c, 0x74, 0xdd, 0x73, 0xd8, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xa7, 0x71	/* tmask_8259A_irq */
	.byte 0x0d, 0xc6, 0x64, 0xab, 0x80, 0xb3, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xa7, 0x71	/* t__pfx_disable_8259A_irq */
	.byte 0x0d, 0x74, 0x64, 0xab, 0x80, 0xb3, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xa7, 0x71	/* tdisable_8259A_irq */
	.byte 0x0d, 0xc6, 0xd4, 0xdd, 0x73, 0xd8, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xa7, 0x71	/* t__pfx_unmask_8259A_irq */
	.byte 0x0d, 0x74, 0xd4, 0xdd, 0x73, 0xd8, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xa7, 0x71	/* tunmask_8259A_irq */
	.byte 0x0c, 0xc6, 0xe8, 0x80, 0xb3, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xa7, 0x71	/* t__pfx_enable_8259A_irq */
	.byte 0x0c, 0x74, 0xe8, 0x80, 0xb3, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xa7, 0x71	/* tenable_8259A_irq */
	.byte 0x0f, 0xc6, 0x69, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xa7, 0x71, 0xe7, 0xe8, 0x64, 0xf0, 0x67	/* t__pfx_i8259A_irq_pending */
	.byte 0x0e, 0xc2, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xa7, 0x71, 0xe7, 0xe8, 0x64, 0xf0, 0x67	/* ti8259A_irq_pending */
	.byte 0x0c, 0xc6, 0x69, 0x38, 0x32, 0x35, 0x39, 0x41, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* t__pfx_i8259A_suspend */
	.byte 0x0b, 0xc2, 0x38, 0x32, 0x35, 0x39, 0x41, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* ti8259A_suspend */
	.byte 0x0d, 0xc6, 0x69, 0x38, 0x32, 0x35, 0x39, 0x41, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_i8259A_shutdown */
	.byte 0x0c, 0xc2, 0x38, 0x32, 0x35, 0x39, 0x41, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* ti8259A_shutdown */
	.byte 0x09, 0xc6, 0xdd, 0x73, 0xd8, 0x38, 0x32, 0x35, 0x39, 0x41	/* t__pfx_mask_8259A */
	.byte 0x09, 0x74, 0xdd, 0x73, 0xd8, 0x38, 0x32, 0x35, 0x39, 0x41	/* tmask_8259A */
	.byte 0x0a, 0xc6, 0xd4, 0xdd, 0x73, 0xd8, 0x38, 0x32, 0x35, 0x39, 0x41	/* t__pfx_unmask_8259A */
	.byte 0x0a, 0x74, 0xd4, 0xdd, 0x73, 0xd8, 0x38, 0x32, 0x35, 0x39, 0x41	/* tunmask_8259A */
	.byte 0x0a, 0xc6, 0xd3, 0x67, 0xeb, 0x79, 0xe7, 0x69, 0xd5, 0xb6, 0x81	/* t__pfx_legacy_pic_noop */
	.byte 0x0a, 0x74, 0xd3, 0x67, 0xeb, 0x79, 0xe7, 0x69, 0xd5, 0xb6, 0x81	/* tlegacy_pic_noop */
	.byte 0x0d, 0xc6, 0xd3, 0x67, 0xeb, 0x79, 0xe7, 0x69, 0xd5, 0x75, 0xf0, 0xf9, 0xb6, 0x81	/* t__pfx_legacy_pic_uint_noop */
	.byte 0x0d, 0x74, 0xd3, 0x67, 0xeb, 0x79, 0xe7, 0x69, 0xd5, 0x75, 0xf0, 0xf9, 0xb6, 0x81	/* tlegacy_pic_uint_noop */
	.byte 0x0c, 0xc6, 0xd3, 0x67, 0xeb, 0x79, 0xe7, 0x69, 0xd5, 0xf0, 0xf9, 0xb6, 0x81	/* t__pfx_legacy_pic_int_noop */
	.byte 0x0c, 0x74, 0xd3, 0x67, 0xeb, 0x79, 0xe7, 0x69, 0xd5, 0xf0, 0xf9, 0xb6, 0x81	/* tlegacy_pic_int_noop */
	.byte 0x11, 0xc6, 0xd3, 0x67, 0xeb, 0x79, 0xe7, 0x69, 0xd5, 0xa7, 0x71, 0xe7, 0xe8, 0x64, 0xf0, 0xa6, 0xb6, 0x81	/* t__pfx_legacy_pic_irq_pending_noop */
	.byte 0x11, 0x74, 0xd3, 0x67, 0xeb, 0x79, 0xe7, 0x69, 0xd5, 0xa7, 0x71, 0xe7, 0xe8, 0x64, 0xf0, 0xa6, 0xb6, 0x81	/* tlegacy_pic_irq_pending_noop */
	.byte 0x09, 0xc6, 0xd3, 0x67, 0xeb, 0x79, 0xe7, 0xa3, 0x25, 0x17	/* t__pfx_legacy_pic_probe */
	.byte 0x09, 0x74, 0xd3, 0x67, 0xeb, 0x79, 0xe7, 0xa3, 0x25, 0x17	/* tlegacy_pic_probe */
	.byte 0x0d, 0xc6, 0xdd, 0x73, 0xd8, 0xcc, 0xe5, 0xeb, 0xd8, 0x38, 0x32, 0x35, 0x39, 0x41	/* t__pfx_mask_and_ack_8259A */
	.byte 0x0d, 0x74, 0xdd, 0x73, 0xd8, 0xcc, 0xe5, 0xeb, 0xd8, 0x38, 0x32, 0x35, 0x39, 0x41	/* tmask_and_ack_8259A */
	.byte 0x0c, 0xc6, 0xdd, 0x6b, 0xfa, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xa7, 0x71	/* t__pfx_make_8259A_irq */
	.byte 0x0c, 0x74, 0xdd, 0x6b, 0xfa, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xa7, 0x71	/* tmake_8259A_irq */
	.byte 0x09, 0xa8, 0x25, 0x62, 0xfa, 0x38, 0x32, 0x35, 0x39, 0x41	/* t__pfx_probe_8259A */
	.byte 0x09, 0x74, 0x9b, 0x62, 0xfa, 0x38, 0x32, 0x35, 0x39, 0x41	/* tprobe_8259A */
	.byte 0x08, 0xc6, 0xf0, 0x99, 0x38, 0x32, 0x35, 0x39, 0x41	/* t__pfx_init_8259A */
	.byte 0x08, 0x74, 0xf0, 0x99, 0x38, 0x32, 0x35, 0x39, 0x41	/* tinit_8259A */
	.byte 0x0b, 0xc6, 0x69, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xf8, 0xb7, 0xbd	/* t__pfx_i8259A_resume */
	.byte 0x0a, 0xc2, 0x38, 0x32, 0x35, 0x39, 0x41, 0x5f, 0xf8, 0xb7, 0xbd	/* ti8259A_resume */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0x6a, 0x75, 0x6d, 0xe2, 0xe8, 0xea, 0x79, 0xf6, 0x69, 0x7a, 0x65	/* T__pfx_arch_jump_entry_size */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0x6a, 0x75, 0x6d, 0xe2, 0xe8, 0xea, 0x79, 0xf6, 0x69, 0x7a, 0x65	/* Tarch_jump_entry_size */
	.byte 0x0d, 0x29, 0x5f, 0x6a, 0x75, 0x6d, 0xe2, 0x6c, 0x80, 0x65, 0x6c, 0xe7, 0xe9, 0xd0	/* t__pfx___jump_label_patch */
	.byte 0x0d, 0x74, 0xff, 0x6a, 0x75, 0x6d, 0xe2, 0x6c, 0x80, 0x65, 0x6c, 0xe7, 0xe9, 0xd0	/* t__jump_label_patch */
	.byte 0x12, 0xbf, 0xca, 0xd0, 0x5f, 0x6a, 0x75, 0x6d, 0xe2, 0x6c, 0x80, 0x65, 0xc3, 0xea, 0xcc, 0x73, 0x66, 0xce, 0x6d	/* T__pfx_arch_jump_label_transform */
	.byte 0x12, 0x54, 0xca, 0xd0, 0x5f, 0x6a, 0x75, 0x6d, 0xe2, 0x6c, 0x80, 0x65, 0xc3, 0xea, 0xcc, 0x73, 0x66, 0xce, 0x6d	/* Tarch_jump_label_transform */
	.byte 0x15, 0xbf, 0xca, 0xd0, 0x5f, 0x6a, 0x75, 0x6d, 0xe2, 0x6c, 0x80, 0x65, 0xc3, 0xea, 0xcc, 0x73, 0x66, 0xce, 0xcd, 0x04, 0x75, 0x65	/* T__pfx_arch_jump_label_transform_queue */
	.byte 0x15, 0x54, 0xca, 0xd0, 0x5f, 0x6a, 0x75, 0x6d, 0xe2, 0x6c, 0x80, 0x65, 0xc3, 0xea, 0xcc, 0x73, 0x66, 0xce, 0xcd, 0x04, 0x75, 0x65	/* Tarch_jump_label_transform_queue */
	.byte 0x17, 0xbf, 0xca, 0xd0, 0x5f, 0x6a, 0x75, 0x6d, 0xe2, 0x6c, 0x80, 0x65, 0xc3, 0xea, 0xcc, 0x73, 0x66, 0xce, 0xcd, 0x61, 0x70, 0x70, 0x6c, 0x79	/* T__pfx_arch_jump_label_transform_apply */
	.byte 0x17, 0x54, 0xca, 0xd0, 0x5f, 0x6a, 0x75, 0x6d, 0xe2, 0x6c, 0x80, 0x65, 0xc3, 0xea, 0xcc, 0x73, 0x66, 0xce, 0xcd, 0x61, 0x70, 0x70, 0x6c, 0x79	/* Tarch_jump_label_transform_apply */
	.byte 0x0b, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xa7, 0x93, 0x77, 0xce, 0x6b	/* t__pfx___sysvec_irq_work */
	.byte 0x0c, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0xa7, 0x93, 0x77, 0xce, 0x6b	/* t__sysvec_irq_work */
	.byte 0x0d, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xa7, 0x93, 0x77, 0xce, 0x6b	/* T__pfx_fred_sysvec_irq_work */
	.byte 0x0d, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xa7, 0x93, 0x77, 0xce, 0x6b	/* Tfred_sysvec_irq_work */
	.byte 0x0c, 0xbf, 0xca, 0xd0, 0x5f, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xb5, 0x69, 0xc9	/* T__pfx_arch_irq_work_raise */
	.byte 0x0c, 0x54, 0xca, 0xd0, 0x5f, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0xb5, 0x69, 0xc9	/* Tarch_irq_work_raise */
	.byte 0x0b, 0x3f, 0xe7, 0x63, 0xcb, 0xd4, 0x84, 0x62, 0xd9, 0x73, 0xde, 0x6d	/* T__pfx_pci_unmap_biosrom */
	.byte 0x0b, 0x54, 0x70, 0x63, 0xcb, 0xd4, 0x84, 0x62, 0xd9, 0x73, 0xde, 0x6d	/* Tpci_unmap_biosrom */
	.byte 0x0b, 0xc6, 0x6d, 0xe9, 0xd0, 0x5f, 0x89, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_match_id.isra.0 */
	.byte 0x0b, 0x74, 0x6d, 0xe9, 0xd0, 0x5f, 0x89, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tmatch_id.isra.0 */
	.byte 0x07, 0xc6, 0x66, 0xf0, 0xe5, 0x6f, 0x9b, 0x6d	/* t__pfx_find_oprom */
	.byte 0x07, 0x74, 0x66, 0xf0, 0xe5, 0x6f, 0x9b, 0x6d	/* tfind_oprom */
	.byte 0x0d, 0x3f, 0xe7, 0x63, 0xcb, 0x62, 0xd9, 0x73, 0xde, 0x6d, 0xf6, 0x69, 0x7a, 0x65	/* T__pfx_pci_biosrom_size */
	.byte 0x0d, 0x54, 0x70, 0x63, 0xcb, 0x62, 0xd9, 0x73, 0xde, 0x6d, 0xf6, 0x69, 0x7a, 0x65	/* Tpci_biosrom_size */
	.byte 0x0a, 0x3f, 0xe7, 0x63, 0xcb, 0x84, 0x62, 0xd9, 0x73, 0xde, 0x6d	/* T__pfx_pci_map_biosrom */
	.byte 0x0a, 0x54, 0x70, 0x63, 0xcb, 0x84, 0x62, 0xd9, 0x73, 0xde, 0x6d	/* Tpci_map_biosrom */
	.byte 0x14, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0xea, 0xd4, 0x63, 0x86, 0x36, 0x34	/* T__pfx___ia32_sys_ia32_truncate64 */
	.byte 0x12, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0xea, 0xd4, 0x63, 0x86, 0x36, 0x34	/* T__ia32_sys_ia32_truncate64 */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0xea, 0xd4, 0x63, 0x86, 0x36, 0x34	/* T__pfx___x64_sys_ia32_truncate64 */
	.byte 0x11, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0xea, 0xd4, 0x63, 0x86, 0x36, 0x34	/* T__x64_sys_ia32_truncate64 */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xea, 0xd4, 0x63, 0x86, 0x36, 0x34	/* T__pfx___ia32_sys_ia32_ftruncate64 */
	.byte 0x13, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xea, 0xd4, 0x63, 0x86, 0x36, 0x34	/* T__ia32_sys_ia32_ftruncate64 */
	.byte 0x14, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xea, 0xd4, 0x63, 0x86, 0x36, 0x34	/* T__pfx___x64_sys_ia32_ftruncate64 */
	.byte 0x12, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xea, 0xd4, 0x63, 0x86, 0x36, 0x34	/* T__x64_sys_ia32_ftruncate64 */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0xe7, 0xf8, 0xc7, 0x36, 0x34	/* T__pfx___ia32_sys_ia32_pread64 */
	.byte 0x10, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0xe7, 0xf8, 0xc7, 0x36, 0x34	/* T__ia32_sys_ia32_pread64 */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0xe7, 0xf8, 0xc7, 0x36, 0x34	/* T__pfx___x64_sys_ia32_pread64 */
	.byte 0x0f, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0xe7, 0xf8, 0xc7, 0x36, 0x34	/* T__x64_sys_ia32_pread64 */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0xe7, 0x24, 0x65, 0x36, 0x34	/* T__pfx___ia32_sys_ia32_pwrite64 */
	.byte 0x10, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0xe7, 0x24, 0x65, 0x36, 0x34	/* T__ia32_sys_ia32_pwrite64 */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0xe7, 0x24, 0x65, 0x36, 0x34	/* T__pfx___x64_sys_ia32_pwrite64 */
	.byte 0x0f, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0xe7, 0x24, 0x65, 0x36, 0x34	/* T__x64_sys_ia32_pwrite64 */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xc7, 0x76, 0x69, 0xc9, 0x36, 0x34	/* T__pfx___ia32_sys_ia32_fadvise64 */
	.byte 0x13, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xc7, 0x76, 0x69, 0xc9, 0x36, 0x34	/* T__ia32_sys_ia32_fadvise64 */
	.byte 0x14, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xc7, 0x76, 0x69, 0xc9, 0x36, 0x34	/* T__pfx___x64_sys_ia32_fadvise64 */
	.byte 0x12, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xc7, 0x76, 0x69, 0xc9, 0x36, 0x34	/* T__x64_sys_ia32_fadvise64 */
	.byte 0x17, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xc7, 0x76, 0x69, 0xc9, 0x36, 0x5c, 0x36, 0x34	/* T__pfx___ia32_sys_ia32_fadvise64_64 */
	.byte 0x15, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xc7, 0x76, 0x69, 0xc9, 0x36, 0x5c, 0x36, 0x34	/* T__ia32_sys_ia32_fadvise64_64 */
	.byte 0x14, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0xf8, 0xc7, 0x61, 0x68, 0x65, 0xc7	/* T__pfx___ia32_sys_ia32_readahead */
	.byte 0x12, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0xf8, 0xc7, 0x61, 0x68, 0x65, 0xc7	/* T__ia32_sys_ia32_readahead */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0xf8, 0xc7, 0x61, 0x68, 0x65, 0xc7	/* T__pfx___x64_sys_ia32_readahead */
	.byte 0x11, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0xf8, 0xc7, 0x61, 0x68, 0x65, 0xc7	/* T__x64_sys_ia32_readahead */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x95, 0x6e, 0xd5, 0xb8, 0xb3, 0x72, 0xcc, 0xda	/* T__pfx___ia32_sys_ia32_sync_file_range */
	.byte 0x13, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x95, 0x6e, 0xd5, 0xb8, 0xb3, 0x72, 0xcc, 0xda	/* T__ia32_sys_ia32_sync_file_range */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xe1, 0xc0, 0x86	/* T__pfx___ia32_sys_ia32_fallocate */
	.byte 0x10, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xe1, 0xc0, 0x86	/* T__ia32_sys_ia32_fallocate */
	.byte 0x07, 0xc6, 0x63, 0x70, 0x2a, 0xe9, 0x36, 0x34	/* t__pfx_cp_stat64 */
	.byte 0x06, 0x2d, 0x70, 0x2a, 0xe9, 0x36, 0x34	/* tcp_stat64 */
	.byte 0x14, 0x29, 0x5f, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xd6, 0xe9, 0xe9, 0x36, 0x34	/* t__pfx___do_compat_sys_ia32_fstatat64 */
	.byte 0x14, 0x74, 0xff, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xd6, 0xe9, 0xe9, 0x36, 0x34	/* t__do_compat_sys_ia32_fstatat64 */
	.byte 0x18, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xd6, 0xe9, 0xe9, 0x36, 0x34	/* T__pfx___ia32_compat_sys_ia32_fstatat64 */
	.byte 0x16, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xd6, 0xe9, 0xe9, 0x36, 0x34	/* T__ia32_compat_sys_ia32_fstatat64 */
	.byte 0x13, 0x29, 0x5f, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x6c, 0xd6, 0xe9, 0x36, 0x34	/* t__pfx___do_compat_sys_ia32_lstat64 */
	.byte 0x13, 0x74, 0xff, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x6c, 0xd6, 0xe9, 0x36, 0x34	/* t__do_compat_sys_ia32_lstat64 */
	.byte 0x17, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x6c, 0xd6, 0xe9, 0x36, 0x34	/* T__pfx___ia32_compat_sys_ia32_lstat64 */
	.byte 0x15, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x6c, 0xd6, 0xe9, 0x36, 0x34	/* T__ia32_compat_sys_ia32_lstat64 */
	.byte 0x11, 0x29, 0x5f, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x2a, 0xe9, 0x36, 0x34	/* t__pfx___do_compat_sys_ia32_stat64 */
	.byte 0x11, 0x74, 0xff, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x2a, 0xe9, 0x36, 0x34	/* t__do_compat_sys_ia32_stat64 */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x2a, 0xe9, 0x36, 0x34	/* T__pfx___ia32_compat_sys_ia32_stat64 */
	.byte 0x13, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x2a, 0xe9, 0x36, 0x34	/* T__ia32_compat_sys_ia32_stat64 */
	.byte 0x13, 0x29, 0x5f, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xd6, 0xe9, 0x36, 0x34	/* t__pfx___do_compat_sys_ia32_fstat64 */
	.byte 0x13, 0x74, 0xff, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xd6, 0xe9, 0x36, 0x34	/* t__do_compat_sys_ia32_fstat64 */
	.byte 0x17, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xd6, 0xe9, 0x36, 0x34	/* T__pfx___ia32_compat_sys_ia32_fstat64 */
	.byte 0x15, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xd6, 0xe9, 0x36, 0x34	/* T__ia32_compat_sys_ia32_fstat64 */
	.byte 0x14, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x6d, 0x0a	/* T__pfx___ia32_compat_sys_ia32_mmap */
	.byte 0x12, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x6d, 0x0a	/* T__ia32_compat_sys_ia32_mmap */
	.byte 0x11, 0x29, 0x5f, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x63, 0xdf, 0xb4	/* t__pfx___do_compat_sys_ia32_clone */
	.byte 0x11, 0x74, 0xff, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x63, 0xdf, 0xb4	/* t__do_compat_sys_ia32_clone */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x63, 0xdf, 0xb4	/* T__pfx___ia32_compat_sys_ia32_clone */
	.byte 0x13, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x63, 0xdf, 0xb4	/* T__ia32_compat_sys_ia32_clone */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xe1, 0xc0, 0x86	/* T__pfx___x64_sys_ia32_fallocate */
	.byte 0x0f, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xe1, 0xc0, 0x86	/* T__x64_sys_ia32_fallocate */
	.byte 0x14, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x95, 0x6e, 0xd5, 0xb8, 0xb3, 0x72, 0xcc, 0xda	/* T__pfx___x64_sys_ia32_sync_file_range */
	.byte 0x12, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x95, 0x6e, 0xd5, 0xb8, 0xb3, 0x72, 0xcc, 0xda	/* T__x64_sys_ia32_sync_file_range */
	.byte 0x16, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xc7, 0x76, 0x69, 0xc9, 0x36, 0x5c, 0x36, 0x34	/* T__pfx___x64_sys_ia32_fadvise64_64 */
	.byte 0x14, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0xc7, 0x76, 0x69, 0xc9, 0x36, 0x5c, 0x36, 0x34	/* T__x64_sys_ia32_fadvise64_64 */
	.byte 0x0f, 0xc6, 0x69, 0x61, 0x33, 0x32, 0x5f, 0xf8, 0xd6, 0xce, 0xfa, 0x73, 0x2c, 0x98, 0x74, 0x97	/* t__pfx_ia32_restore_sigcontext */
	.byte 0x0e, 0xc2, 0x61, 0x33, 0x32, 0x5f, 0xf8, 0xd6, 0xce, 0xfa, 0x73, 0x2c, 0x98, 0x74, 0x97	/* tia32_restore_sigcontext */
	.byte 0x0f, 0x29, 0x5f, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0x73, 0xf6, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* t__pfx___do_compat_sys_sigreturn */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0x73, 0xf6, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* T__pfx___ia32_compat_sys_sigreturn */
	.byte 0x0f, 0x74, 0xff, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0x73, 0xf6, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* t__do_compat_sys_sigreturn */
	.byte 0x11, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0x73, 0xf6, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* T__ia32_compat_sys_sigreturn */
	.byte 0x11, 0x29, 0x5f, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x72, 0xf9, 0x73, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* t__pfx___do_compat_sys_rt_sigreturn */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x72, 0xf9, 0x73, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* T__pfx___ia32_compat_sys_rt_sigreturn */
	.byte 0x11, 0x74, 0xff, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x72, 0xf9, 0x73, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* t__do_compat_sys_rt_sigreturn */
	.byte 0x13, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x72, 0xf9, 0x73, 0x2c, 0xf8, 0x74, 0x1d, 0x6e	/* T__ia32_compat_sys_rt_sigreturn */
	.byte 0x0b, 0xbf, 0x69, 0x61, 0x33, 0x32, 0xba, 0x74, 0x3a, 0x66, 0xb5, 0xbd	/* T__pfx_ia32_setup_frame */
	.byte 0x0b, 0x54, 0x69, 0x61, 0x33, 0x32, 0xba, 0x74, 0x3a, 0x66, 0xb5, 0xbd	/* Tia32_setup_frame */
	.byte 0x0d, 0xbf, 0x69, 0x61, 0x33, 0x32, 0xba, 0x74, 0x3a, 0x72, 0xf9, 0x66, 0xb5, 0xbd	/* T__pfx_ia32_setup_rt_frame */
	.byte 0x0d, 0x54, 0x69, 0x61, 0x33, 0x32, 0xba, 0x74, 0x3a, 0x72, 0xf9, 0x66, 0xb5, 0xbd	/* Tia32_setup_rt_frame */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x6d, 0x0a	/* T__pfx___ia32_sys_mmap */
	.byte 0x09, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x6d, 0x0a	/* T__ia32_sys_mmap */
	.byte 0x0a, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x6d, 0x0a	/* T__pfx___x64_sys_mmap */
	.byte 0x08, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x6d, 0x0a	/* T__x64_sys_mmap */
	.byte 0x07, 0xc6, 0xb2, 0xe1, 0x2c, 0x7c, 0xdd, 0x16	/* t__pfx_get_align_mask */
	.byte 0x07, 0x74, 0xb2, 0xe1, 0x2c, 0x7c, 0xdd, 0x16	/* tget_align_mask */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0x5f, 0xb2, 0xd4, 0x0a, 0x70, 0x65, 0xe5, 0x61, 0xf8, 0x61	/* T__pfx_arch_get_unmapped_area */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0x5f, 0xb2, 0xd4, 0x0a, 0x70, 0x65, 0xe5, 0x61, 0xf8, 0x61	/* Tarch_get_unmapped_area */
	.byte 0x13, 0xbf, 0xca, 0xd0, 0x5f, 0xb2, 0xd4, 0x0a, 0x70, 0x65, 0xe5, 0x61, 0xf8, 0x61, 0x5f, 0xac, 0x70, 0xa9, 0x77, 0x6e	/* T__pfx_arch_get_unmapped_area_topdown */
	.byte 0x13, 0x54, 0xca, 0xd0, 0x5f, 0xb2, 0xd4, 0x0a, 0x70, 0x65, 0xe5, 0x61, 0xf8, 0x61, 0x5f, 0xac, 0x70, 0xa9, 0x77, 0x6e	/* Tarch_get_unmapped_area_topdown */
	.byte 0x09, 0xbf, 0xf0, 0x99, 0x3b, 0xef, 0x69, 0x1a, 0x61, 0x70	/* T__pfx_init_espfix_ap */
	.byte 0x09, 0x54, 0xf0, 0x99, 0x3b, 0xef, 0x69, 0x1a, 0x61, 0x70	/* Tinit_espfix_ap */
	.byte 0x0f, 0xc6, 0x62, 0x6f, 0x6f, 0xf9, 0x70, 0xca, 0x61, 0x6d, 0xe0, 0x64, 0x0f, 0x5f, 0xf8, 0xc7	/* t__pfx_boot_params_data_read */
	.byte 0x0f, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0x70, 0xca, 0x61, 0x6d, 0xe0, 0x64, 0x0f, 0x5f, 0xf8, 0xc7	/* tboot_params_data_read */
	.byte 0x08, 0xc6, 0x76, 0xee, 0x73, 0xd9, 0x6e, 0xf6, 0x26	/* t__pfx_version_show */
	.byte 0x08, 0x74, 0x76, 0xee, 0x73, 0xd9, 0x6e, 0xf6, 0x26	/* tversion_show */
	.byte 0x0a, 0xc6, 0xb2, 0xc9, 0x74, 0x3a, 0x64, 0x0f, 0xe7, 0x10, 0x72	/* t__pfx_get_setup_data_paddr */
	.byte 0x0a, 0x74, 0xb2, 0xc9, 0x74, 0x3a, 0x64, 0x0f, 0xe7, 0x10, 0x72	/* tget_setup_data_paddr */
	.byte 0x0c, 0xa8, 0xba, 0x74, 0x3a, 0x64, 0x0f, 0x5f, 0x64, 0x0f, 0x5f, 0xf8, 0xc7	/* t__pfx_setup_data_data_read */
	.byte 0x0c, 0x74, 0xc9, 0x74, 0x3a, 0x64, 0x0f, 0x5f, 0x64, 0x0f, 0x5f, 0xf8, 0xc7	/* tsetup_data_data_read */
	.byte 0x06, 0xc6, 0x74, 0x27, 0xfa, 0x73, 0x26	/* t__pfx_type_show */
	.byte 0x06, 0x74, 0x74, 0x27, 0xfa, 0x73, 0x26	/* ttype_show */
	.byte 0x0c, 0x29, 0x65, 0x38, 0x32, 0x30, 0xff, 0x0a, 0x70, 0x65, 0xe5, 0xcc, 0x79	/* t__pfx__e820__mapped_any */
	.byte 0x0c, 0xf9, 0x65, 0x38, 0x32, 0x30, 0xff, 0x0a, 0x70, 0x65, 0xe5, 0xcc, 0x79	/* t_e820__mapped_any */
	.byte 0x0d, 0xbf, 0x65, 0x38, 0x32, 0x30, 0xff, 0x0a, 0x70, 0x65, 0xe5, 0x1c, 0xcc, 0x79	/* T__pfx_e820__mapped_raw_any */
	.byte 0x0d, 0x54, 0x65, 0x38, 0x32, 0x30, 0xff, 0x0a, 0x70, 0x65, 0xe5, 0x1c, 0xcc, 0x79	/* Te820__mapped_raw_any */
	.byte 0x0c, 0xbf, 0x65, 0x38, 0x32, 0x30, 0xff, 0x0a, 0x70, 0x65, 0xe5, 0xcc, 0x79	/* T__pfx_e820__mapped_any */
	.byte 0x0c, 0x54, 0x65, 0x38, 0x32, 0x30, 0xff, 0x0a, 0x70, 0x65, 0xe5, 0xcc, 0x79	/* Te820__mapped_any */
	.byte 0x0d, 0x29, 0x5f, 0x65, 0x38, 0x32, 0x30, 0xff, 0x0a, 0x70, 0x65, 0xe5, 0xe1, 0x6c	/* t__pfx___e820__mapped_all */
	.byte 0x0d, 0x74, 0xff, 0x65, 0x38, 0x32, 0x30, 0xff, 0x0a, 0x70, 0x65, 0xe5, 0xe1, 0x6c	/* t__e820__mapped_all */
	.byte 0x0e, 0xbf, 0x65, 0x38, 0x32, 0x30, 0xfd, 0x65, 0xf9, 0xe8, 0xea, 0xc5, 0x74, 0x27, 0x65	/* T__pfx_e820__get_entry_type */
	.byte 0x0e, 0x54, 0x65, 0x38, 0x32, 0x30, 0xfd, 0x65, 0xf9, 0xe8, 0xea, 0xc5, 0x74, 0x27, 0x65	/* Te820__get_entry_type */
	.byte 0x0c, 0xc6, 0x76, 0x69, 0x61, 0x5f, 0xb6, 0x5f, 0x64, 0xeb, 0x5f, 0x63, 0x62	/* t__pfx_via_no_dac_cb */
	.byte 0x0c, 0x74, 0x76, 0x69, 0x61, 0x5f, 0xb6, 0x5f, 0x64, 0xeb, 0x5f, 0x63, 0x62	/* tvia_no_dac_cb */
	.byte 0x09, 0xc6, 0x76, 0x69, 0x61, 0x5f, 0xb6, 0x5f, 0x64, 0xeb	/* t__pfx_via_no_dac */
	.byte 0x09, 0x74, 0x76, 0x69, 0x61, 0x5f, 0xb6, 0x5f, 0x64, 0xeb	/* tvia_no_dac */
	.byte 0x0f, 0xc6, 0x66, 0xce, 0x63, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x68, 0x70, 0x65, 0xf9, 0x20, 0x69	/* t__pfx_force_disable_hpet_msi */
	.byte 0x0f, 0x74, 0x66, 0xce, 0x63, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x68, 0x70, 0x65, 0xf9, 0x20, 0x69	/* tforce_disable_hpet_msi */
	.byte 0x0e, 0xc6, 0x8e, 0xa7, 0xd8, 0xf0, 0x9a, 0xc3, 0xa7, 0x71, 0x62, 0xe1, 0xcc, 0x63, 0x65	/* t__pfx_quirk_intel_irqbalance */
	.byte 0x0e, 0x74, 0x8e, 0xa7, 0xd8, 0xf0, 0x9a, 0xc3, 0xa7, 0x71, 0x62, 0xe1, 0xcc, 0x63, 0x65	/* tquirk_intel_irqbalance */
	.byte 0x10, 0xc6, 0x65, 0x36, 0x78, 0x1a, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0x74	/* t__pfx_e6xx_force_enable_hpet */
	.byte 0x0f, 0x9a, 0x36, 0x78, 0x1a, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0x74	/* te6xx_force_enable_hpet */
	.byte 0x0f, 0xc6, 0x69, 0xd0, 0x5f, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0x74	/* t__pfx_ich_force_enable_hpet */
	.byte 0x0e, 0xc2, 0xd0, 0x5f, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0x74	/* tich_force_enable_hpet */
	.byte 0x17, 0xc6, 0x61, 0x6d, 0xe5, 0x64, 0xab, 0x80, 0xb3, 0xc9, 0x93, 0xcc, 0xe5, 0xf8, 0x64, 0x69, 0xf8, 0x63, 0xf9, 0x73, 0x63, 0x72, 0x75, 0x62	/* t__pfx_amd_disable_seq_and_redirect_scrub */
	.byte 0x16, 0xdb, 0x6d, 0xe5, 0x64, 0xab, 0x80, 0xb3, 0xc9, 0x93, 0xcc, 0xe5, 0xf8, 0x64, 0x69, 0xf8, 0x63, 0xf9, 0x73, 0x63, 0x72, 0x75, 0x62	/* tamd_disable_seq_and_redirect_scrub */
	.byte 0x11, 0xc6, 0x7f, 0xe5, 0x69, 0xd0, 0x5f, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0x74	/* t__pfx_old_ich_force_enable_hpet */
	.byte 0x11, 0xac, 0x6c, 0xe5, 0x69, 0xd0, 0x5f, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0x74	/* told_ich_force_enable_hpet */
	.byte 0x13, 0xc6, 0x7f, 0xe5, 0x69, 0xd0, 0x5f, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0xf9, 0x5d, 0xee	/* t__pfx_old_ich_force_enable_hpet_user */
	.byte 0x13, 0xac, 0x6c, 0xe5, 0x69, 0xd0, 0x5f, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0xf9, 0x5d, 0xee	/* told_ich_force_enable_hpet_user */
	.byte 0x12, 0xc6, 0x6e, 0x76, 0x89, 0x69, 0x61, 0x5f, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0x74	/* t__pfx_nvidia_force_enable_hpet */
	.byte 0x12, 0x74, 0x6e, 0x76, 0x89, 0x69, 0x61, 0x5f, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0x74	/* tnvidia_force_enable_hpet */
	.byte 0x13, 0xc6, 0x76, 0x74, 0x38, 0x32, 0x33, 0x37, 0x5f, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0x74	/* t__pfx_vt8237_force_enable_hpet */
	.byte 0x13, 0x74, 0x76, 0x74, 0x38, 0x32, 0x33, 0x37, 0x5f, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0x74	/* tvt8237_force_enable_hpet */
	.byte 0x0e, 0xc6, 0xe9, 0xcb, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0x74	/* t__pfx_ati_force_enable_hpet */
	.byte 0x0e, 0x74, 0xe9, 0xcb, 0x66, 0xce, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x68, 0x70, 0x65, 0x74	/* tati_force_enable_hpet */
	.byte 0x0b, 0xc6, 0x8e, 0xa7, 0xd8, 0x61, 0x6d, 0xe5, 0x6e, 0xdc, 0xb6, 0xe6	/* t__pfx_quirk_amd_nb_node */
	.byte 0x0b, 0x74, 0x8e, 0xa7, 0xd8, 0x61, 0x6d, 0xe5, 0x6e, 0xdc, 0xb6, 0xe6	/* tquirk_amd_nb_node */
	.byte 0x14, 0xc6, 0x8e, 0xa7, 0xd8, 0xf0, 0x9a, 0x6c, 0xe7, 0x1d, 0xd3, 0xc5, 0x78, 0x65, 0x6f, 0x7c, 0xb5, 0xe0, 0x63, 0x61, 0x70	/* t__pfx_quirk_intel_purley_xeon_ras_cap */
	.byte 0x14, 0x74, 0x8e, 0xa7, 0xd8, 0xf0, 0x9a, 0x6c, 0xe7, 0x1d, 0xd3, 0xc5, 0x78, 0x65, 0x6f, 0x7c, 0xb5, 0xe0, 0x63, 0x61, 0x70	/* tquirk_intel_purley_xeon_ras_cap */
	.byte 0x17, 0xc6, 0x8e, 0xa7, 0xd8, 0xf0, 0x9a, 0xc3, 0x62, 0x72, 0xa3, 0x6b, 0x6c, 0xcc, 0xe5, 0x78, 0x65, 0x6f, 0x7c, 0xb5, 0xe0, 0x63, 0x61, 0x70	/* t__pfx_quirk_intel_brickland_xeon_ras_cap */
	.byte 0x17, 0x74, 0x8e, 0xa7, 0xd8, 0xf0, 0x9a, 0xc3, 0x62, 0x72, 0xa3, 0x6b, 0x6c, 0xcc, 0xe5, 0x78, 0x65, 0x6f, 0x7c, 0xb5, 0xe0, 0x63, 0x61, 0x70	/* tquirk_intel_brickland_xeon_ras_cap */
	.byte 0x0c, 0xbf, 0x66, 0xce, 0x63, 0xfa, 0x68, 0x70, 0x65, 0xf9, 0xf8, 0xb7, 0xbd	/* T__pfx_force_hpet_resume */
	.byte 0x0c, 0x54, 0x66, 0xce, 0x63, 0xfa, 0x68, 0x70, 0x65, 0xf9, 0xf8, 0xb7, 0xbd	/* Tforce_hpet_resume */
	.byte 0x07, 0xc6, 0xa9, 0x95, 0x6e, 0xd5, 0xfe, 0xf8	/* t__pfx_do_sync_core */
	.byte 0x07, 0x74, 0xa9, 0x95, 0x6e, 0xd5, 0xfe, 0xf8	/* tdo_sync_core */
	.byte 0x0c, 0xc6, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xbd, 0x6d, 0xc9, 0x74	/* t__pfx_text_poke_memset */
	.byte 0x0c, 0x74, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xbd, 0x6d, 0xc9, 0x74	/* ttext_poke_memset */
	.byte 0x0d, 0xc6, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xbd, 0x6d, 0x63, 0x70, 0x79	/* t__pfx_text_poke_memcpy */
	.byte 0x0d, 0x74, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xbd, 0x6d, 0x63, 0x70, 0x79	/* ttext_poke_memcpy */
	.byte 0x0b, 0xc6, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xdf, 0xd5, 0x8d	/* t__pfx_text_poke_loc_init */
	.byte 0x0b, 0x74, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xdf, 0xd5, 0x8d	/* ttext_poke_loc_init */
	.byte 0x0c, 0x29, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xf8, 0xc0, 0xe9, 0xd9, 0x6e	/* t__pfx___apply_relocation */
	.byte 0x0c, 0x74, 0xff, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xf8, 0xc0, 0xe9, 0xd9, 0x6e	/* t__apply_relocation */
	.byte 0x08, 0xa8, 0xf6, 0x6b, 0x69, 0xe2, 0xb6, 0x70, 0x73	/* t__pfx_skip_nops */
	.byte 0x07, 0x74, 0x16, 0x69, 0xe2, 0xb6, 0x70, 0x73	/* tskip_nops */
	.byte 0x0a, 0xc6, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0xfa, 0xb6, 0x70, 0x73	/* t__pfx_optimize_nops */
	.byte 0x0a, 0xac, 0x70, 0xc2, 0x6d, 0x69, 0x7a, 0xfa, 0xb6, 0x70, 0x73	/* toptimize_nops */
	.byte 0x0c, 0xa8, 0x1f, 0x70, 0x9a, 0x73, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_set_ptes.constprop.0 */
	.byte 0x0d, 0x74, 0xc9, 0xf9, 0x70, 0x9a, 0x73, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tset_ptes.constprop.0 */
	.byte 0x08, 0x29, 0x5f, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x0e	/* t__pfx___text_poke */
	.byte 0x08, 0x74, 0xff, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x0e	/* t__text_poke */
	.byte 0x0d, 0xc6, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0x62, 0xe2, 0x62, 0xe9, 0xd0	/* t__pfx_text_poke_bp_batch */
	.byte 0x0d, 0x74, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0x62, 0xe2, 0x62, 0xe9, 0xd0	/* ttext_poke_bp_batch */
	.byte 0x0b, 0xbf, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xf8, 0xc0, 0xe9, 0xd9, 0x6e	/* T__pfx_apply_relocation */
	.byte 0x0b, 0x54, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xf8, 0xc0, 0xe9, 0xd9, 0x6e	/* Tapply_relocation */
	.byte 0x0d, 0xbf, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xba, 0xe1, 0x5f, 0xe8, 0x64, 0x62, 0x72	/* T__pfx_apply_seal_endbr */
	.byte 0x0d, 0x54, 0x61, 0x70, 0x70, 0x6c, 0x79, 0xba, 0xe1, 0x5f, 0xe8, 0x64, 0x62, 0x72	/* Tapply_seal_endbr */
	.byte 0x0c, 0xbf, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0x66, 0xf0, 0x65, 0x69, 0x62, 0x74	/* T__pfx_apply_fineibt */
	.byte 0x0c, 0x54, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0x66, 0xf0, 0x65, 0x69, 0x62, 0x74	/* Tapply_fineibt */
	.byte 0x11, 0xbf, 0xe1, 0x74, 0xee, 0x6e, 0xe9, 0x69, 0x76, 0x3b, 0xf6, 0x6d, 0xe2, 0xa5, 0x64, 0x75, 0xb3, 0x10	/* T__pfx_alternatives_smp_module_add */
	.byte 0x11, 0x54, 0xe1, 0x74, 0xee, 0x6e, 0xe9, 0x69, 0x76, 0x3b, 0xf6, 0x6d, 0xe2, 0xa5, 0x64, 0x75, 0xb3, 0x10	/* Talternatives_smp_module_add */
	.byte 0x12, 0xbf, 0xe1, 0x74, 0xee, 0x6e, 0xe9, 0x69, 0x76, 0x3b, 0xf6, 0x6d, 0xe2, 0xa5, 0x64, 0x75, 0xb3, 0xe6, 0x6c	/* T__pfx_alternatives_smp_module_del */
	.byte 0x12, 0x54, 0xe1, 0x74, 0xee, 0x6e, 0xe9, 0x69, 0x76, 0x3b, 0xf6, 0x6d, 0xe2, 0xa5, 0x64, 0x75, 0xb3, 0xe6, 0x6c	/* Talternatives_smp_module_del */
	.byte 0x0f, 0xbf, 0xe1, 0x74, 0xee, 0x6e, 0xe9, 0x69, 0x76, 0x65, 0xe0, 0xe8, 0x80, 0xb3, 0x73, 0xb0	/* T__pfx_alternatives_enable_smp */
	.byte 0x0f, 0x54, 0xe1, 0x74, 0xee, 0x6e, 0xe9, 0x69, 0x76, 0x65, 0xe0, 0xe8, 0x80, 0xb3, 0x73, 0xb0	/* Talternatives_enable_smp */
	.byte 0x12, 0xbf, 0xe1, 0x74, 0xee, 0x6e, 0xe9, 0x69, 0x76, 0x65, 0xe0, 0x74, 0xd1, 0xf9, 0x3d, 0xee, 0x76, 0x65, 0x64	/* T__pfx_alternatives_text_reserved */
	.byte 0x12, 0x54, 0xe1, 0x74, 0xee, 0x6e, 0xe9, 0x69, 0x76, 0x65, 0xe0, 0x74, 0xd1, 0xf9, 0x3d, 0xee, 0x76, 0x65, 0x64	/* Talternatives_text_reserved */
	.byte 0x0c, 0xbf, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0x65, 0xca, 0x6c, 0x79	/* T__pfx_text_poke_early */
	.byte 0x0c, 0x54, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0x65, 0xca, 0x6c, 0x79	/* Ttext_poke_early */
	.byte 0x0b, 0xbf, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xf8, 0x74, 0x1d, 0x6e, 0x73	/* T__pfx_apply_returns */
	.byte 0x0b, 0x54, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xf8, 0x74, 0x1d, 0x6e, 0x73	/* Tapply_returns */
	.byte 0x0b, 0xbf, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xf8, 0x06, 0x6f, 0x88, 0x3b	/* T__pfx_apply_retpolines */
	.byte 0x0b, 0x54, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xf8, 0x06, 0x6f, 0x88, 0x3b	/* Tapply_retpolines */
	.byte 0x0e, 0xbf, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xe1, 0x74, 0xee, 0x6e, 0xe9, 0x69, 0x76, 0x3b	/* T__pfx_apply_alternatives */
	.byte 0x0e, 0x54, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xe1, 0x74, 0xee, 0x6e, 0xe9, 0x69, 0x76, 0x3b	/* Tapply_alternatives */
	.byte 0x07, 0xbf, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x0e	/* T__pfx_text_poke */
	.byte 0x07, 0x54, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x0e	/* Ttext_poke */
	.byte 0x0c, 0xbf, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0x6b, 0x67, 0x64, 0x62	/* T__pfx_text_poke_kgdb */
	.byte 0x0c, 0x54, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0x6b, 0x67, 0x64, 0x62	/* Ttext_poke_kgdb */
	.byte 0x0e, 0xbf, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xfe, 0x70, 0xc5, 0x3c, 0x65, 0x64	/* T__pfx_text_poke_copy_locked */
	.byte 0x0e, 0x54, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xfe, 0x70, 0xc5, 0x3c, 0x65, 0x64	/* Ttext_poke_copy_locked */
	.byte 0x0b, 0xbf, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xfe, 0x70, 0x79	/* T__pfx_text_poke_copy */
	.byte 0x0b, 0x54, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xfe, 0x70, 0x79	/* Ttext_poke_copy */
	.byte 0x0a, 0xbf, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xc9, 0x74	/* T__pfx_text_poke_set */
	.byte 0x0a, 0x54, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xc9, 0x74	/* Ttext_poke_set */
	.byte 0x0b, 0xbf, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xc1, 0x6e, 0x63	/* T__pfx_text_poke_sync */
	.byte 0x0b, 0x54, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0xc1, 0x6e, 0x63	/* Ttext_poke_sync */
	.byte 0x0c, 0xbf, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0x66, 0xf0, 0xab, 0x68	/* T__pfx_text_poke_finish */
	.byte 0x0c, 0x54, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x6b, 0xfa, 0x66, 0xf0, 0xab, 0x68	/* Ttext_poke_finish */
	.byte 0x0f, 0xbf, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0xf9, 0xf8, 0xd6, 0x6f, 0xf8	/* T__pfx_hw_breakpoint_restore */
	.byte 0x0f, 0x54, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0xf9, 0xf8, 0xd6, 0x6f, 0xf8	/* Thw_breakpoint_restore */
	.byte 0x08, 0xbf, 0xe8, 0xfe, 0x64, 0xfa, 0x64, 0x72, 0x37	/* T__pfx_encode_dr7 */
	.byte 0x08, 0x54, 0xe8, 0xfe, 0x64, 0xfa, 0x64, 0x72, 0x37	/* Tencode_dr7 */
	.byte 0x08, 0xbf, 0xe6, 0xfe, 0x64, 0xfa, 0x64, 0x72, 0x37	/* T__pfx_decode_dr7 */
	.byte 0x08, 0x54, 0xe6, 0xfe, 0x64, 0xfa, 0x64, 0x72, 0x37	/* Tdecode_dr7 */
	.byte 0x12, 0xbf, 0xca, 0xd0, 0x5f, 0xf0, 0xd6, 0xe1, 0xc3, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0x74	/* T__pfx_arch_install_hw_breakpoint */
	.byte 0x12, 0x54, 0xca, 0xd0, 0x5f, 0xf0, 0xd6, 0xe1, 0xc3, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0x74	/* Tarch_install_hw_breakpoint */
	.byte 0x13, 0xbf, 0xca, 0xd0, 0x5f, 0xd4, 0xf0, 0xd6, 0xe1, 0xc3, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0x74	/* T__pfx_arch_uninstall_hw_breakpoint */
	.byte 0x13, 0x54, 0xca, 0xd0, 0x5f, 0xd4, 0xf0, 0xd6, 0xe1, 0xc3, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0x74	/* Tarch_uninstall_hw_breakpoint */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0x62, 0xe2, 0x67, 0xe8, 0xee, 0x69, 0xd5, 0xb8, 0x65, 0x02, 0x73	/* T__pfx_arch_bp_generic_fields */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0x62, 0xe2, 0x67, 0xe8, 0xee, 0x69, 0xd5, 0xb8, 0x65, 0x02, 0x73	/* Tarch_bp_generic_fields */
	.byte 0x13, 0xbf, 0xca, 0xd0, 0x5f, 0x7e, 0x63, 0xd8, 0x62, 0xe2, 0xf0, 0x5f, 0x6b, 0xee, 0xb4, 0x6c, 0x73, 0x70, 0xeb, 0x65	/* T__pfx_arch_check_bp_in_kernelspace */
	.byte 0x13, 0x54, 0xca, 0xd0, 0x5f, 0x7e, 0x63, 0xd8, 0x62, 0xe2, 0xf0, 0x5f, 0x6b, 0xee, 0xb4, 0x6c, 0x73, 0x70, 0xeb, 0x65	/* Tarch_check_bp_in_kernelspace */
	.byte 0x10, 0xbf, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0xf9, 0xca, 0xd0, 0xe7, 0xca, 0xc9	/* T__pfx_hw_breakpoint_arch_parse */
	.byte 0x10, 0x54, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0xf9, 0xca, 0xd0, 0xe7, 0xca, 0xc9	/* Thw_breakpoint_arch_parse */
	.byte 0x11, 0xbf, 0x66, 0x6c, 0x5d, 0x68, 0xe7, 0xc8, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0x74	/* T__pfx_flush_ptrace_hw_breakpoint */
	.byte 0x11, 0x54, 0x66, 0x6c, 0x5d, 0x68, 0xe7, 0xc8, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0x74	/* Tflush_ptrace_hw_breakpoint */
	.byte 0x17, 0xbf, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0xf9, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0xe0, 0xb6, 0xc2, 0x66, 0x79	/* T__pfx_hw_breakpoint_exceptions_notify */
	.byte 0x17, 0x54, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0xf9, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0xe0, 0xb6, 0xc2, 0x66, 0x79	/* Thw_breakpoint_exceptions_notify */
	.byte 0x10, 0xbf, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0xf9, 0x70, 0x6d, 0x00, 0xf8, 0xc7	/* T__pfx_hw_breakpoint_pmu_read */
	.byte 0x10, 0x54, 0x68, 0xaa, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0xf9, 0x70, 0x6d, 0x00, 0xf8, 0xc7	/* Thw_breakpoint_pmu_read */
	.byte 0x0c, 0xbf, 0x7e, 0x63, 0xd8, 0x74, 0x73, 0xd5, 0xd4, 0x73, 0xdb, 0x62, 0xd3	/* T__pfx_check_tsc_unstable */
	.byte 0x0c, 0x54, 0x7e, 0x63, 0xd8, 0x74, 0x73, 0xd5, 0xd4, 0x73, 0xdb, 0x62, 0xd3	/* Tcheck_tsc_unstable */
	.byte 0x0c, 0xbf, 0xf8, 0x28, 0x69, 0x62, 0x72, 0xa1, 0x92, 0x5f, 0x6b, 0x68, 0x7a	/* T__pfx_recalibrate_cpu_khz */
	.byte 0x0c, 0x54, 0xf8, 0x28, 0x69, 0x62, 0x72, 0xa1, 0x92, 0x5f, 0x6b, 0x68, 0x7a	/* Trecalibrate_cpu_khz */
	.byte 0x06, 0xc6, 0xf8, 0x05, 0x74, 0x73, 0x63	/* t__pfx_read_tsc */
	.byte 0x06, 0x74, 0xf8, 0x05, 0x74, 0x73, 0x63	/* tread_tsc */
	.byte 0x09, 0xc6, 0x74, 0x73, 0xd5, 0x63, 0xe0, 0xe8, 0x80, 0xd3	/* t__pfx_tsc_cs_enable */
	.byte 0x09, 0x74, 0x74, 0x73, 0xd5, 0x63, 0xe0, 0xe8, 0x80, 0xd3	/* ttsc_cs_enable */
	.byte 0x0b, 0x29, 0x1f, 0x63, 0x79, 0x63, 0x32, 0x6e, 0x73, 0xf6, 0x28, 0x65	/* t__pfx___set_cyc2ns_scale */
	.byte 0x0d, 0x74, 0xff, 0xc9, 0xf9, 0x63, 0x79, 0x63, 0x32, 0x6e, 0x73, 0xf6, 0x28, 0x65	/* t__set_cyc2ns_scale */
	.byte 0x0b, 0xa8, 0x1f, 0x63, 0x79, 0x63, 0x32, 0x6e, 0x73, 0xf6, 0x28, 0x65	/* t__pfx_set_cyc2ns_scale */
	.byte 0x0c, 0x74, 0xc9, 0xf9, 0x63, 0x79, 0x63, 0x32, 0x6e, 0x73, 0xf6, 0x28, 0x65	/* tset_cyc2ns_scale */
	.byte 0x0e, 0xc6, 0x74, 0x73, 0xd5, 0x63, 0xe0, 0xdd, 0x72, 0xd8, 0xd4, 0x73, 0xdb, 0x62, 0xd3	/* t__pfx_tsc_cs_mark_unstable */
	.byte 0x0e, 0x74, 0x74, 0x73, 0xd5, 0x63, 0xe0, 0xdd, 0x72, 0xd8, 0xd4, 0x73, 0xdb, 0x62, 0xd3	/* ttsc_cs_mark_unstable */
	.byte 0x0c, 0xbf, 0xdd, 0x72, 0xd8, 0x74, 0x73, 0xd5, 0xd4, 0x73, 0xdb, 0x62, 0xd3	/* T__pfx_mark_tsc_unstable */
	.byte 0x0c, 0x54, 0xdd, 0x72, 0xd8, 0x74, 0x73, 0xd5, 0xd4, 0x73, 0xdb, 0x62, 0xd3	/* Tmark_tsc_unstable */
	.byte 0x0b, 0xc6, 0xc2, 0x6d, 0xfa, 0x92, 0x87, 0x93, 0xb6, 0xc2, 0xb8, 0xee	/* t__pfx_time_cpufreq_notifier */
	.byte 0x0b, 0x74, 0xc2, 0x6d, 0xfa, 0x92, 0x87, 0x93, 0xb6, 0xc2, 0xb8, 0xee	/* ttime_cpufreq_notifier */
	.byte 0x0d, 0xc6, 0x74, 0x73, 0xd5, 0x63, 0xe0, 0xc2, 0x63, 0x6b, 0xf6, 0xdb, 0x62, 0xd3	/* t__pfx_tsc_cs_tick_stable */
	.byte 0x0d, 0x74, 0x74, 0x73, 0xd5, 0x63, 0xe0, 0xc2, 0x63, 0x6b, 0xf6, 0xdb, 0x62, 0xd3	/* ttsc_cs_tick_stable */
	.byte 0x07, 0xc6, 0x74, 0x73, 0xd5, 0xf8, 0xb7, 0xbd	/* t__pfx_tsc_resume */
	.byte 0x07, 0x74, 0x74, 0x73, 0xd5, 0xf8, 0xb7, 0xbd	/* ttsc_resume */
	.byte 0x09, 0xc6, 0x74, 0x73, 0xd5, 0xf8, 0x05, 0xf8, 0x66, 0x73	/* t__pfx_tsc_read_refs */
	.byte 0x09, 0x74, 0x74, 0x73, 0xd5, 0xf8, 0x05, 0xf8, 0x66, 0x73	/* ttsc_read_refs */
	.byte 0x11, 0xa8, 0xe7, 0x99, 0x68, 0x70, 0x65, 0xf9, 0x70, 0xc2, 0x6d, 0xcf, 0x28, 0x69, 0x62, 0x72, 0xa1, 0x92	/* t__pfx_pit_hpet_ptimer_calibrate_cpu */
	.byte 0x10, 0x06, 0x99, 0x68, 0x70, 0x65, 0xf9, 0x70, 0xc2, 0x6d, 0xcf, 0x28, 0x69, 0x62, 0x72, 0xa1, 0x92	/* tpit_hpet_ptimer_calibrate_cpu */
	.byte 0x12, 0xc6, 0x74, 0x73, 0xd5, 0xf8, 0x66, 0xf0, 0xfa, 0x28, 0x69, 0x62, 0x72, 0xe9, 0xd9, 0x7c, 0x77, 0xce, 0x6b	/* t__pfx_tsc_refine_calibration_work */
	.byte 0x12, 0x74, 0x74, 0x73, 0xd5, 0xf8, 0x66, 0xf0, 0xfa, 0x28, 0x69, 0x62, 0x72, 0xe9, 0xd9, 0x7c, 0x77, 0xce, 0x6b	/* ttsc_refine_calibration_work */
	.byte 0x10, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x28, 0x69, 0x62, 0x72, 0xa1, 0x92, 0x5f, 0x65, 0xca, 0x6c, 0x79	/* T__pfx_native_calibrate_cpu_early */
	.byte 0x10, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x28, 0x69, 0x62, 0x72, 0xa1, 0x92, 0x5f, 0x65, 0xca, 0x6c, 0x79	/* Tnative_calibrate_cpu_early */
	.byte 0x0b, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x28, 0x69, 0x62, 0x72, 0xa1, 0x92	/* t__pfx_native_calibrate_cpu */
	.byte 0x0b, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x28, 0x69, 0x62, 0x72, 0xa1, 0x92	/* tnative_calibrate_cpu */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x63, 0x79, 0x63, 0x32, 0x6e, 0xe0, 0xf8, 0xc7	/* T__pfx___cyc2ns_read */
	.byte 0x09, 0x2f, 0x63, 0x79, 0x63, 0x32, 0x6e, 0xe0, 0xf8, 0xc7	/* T__cyc2ns_read */
	.byte 0x0c, 0xbf, 0x63, 0x79, 0x63, 0x32, 0x6e, 0xe0, 0xf8, 0x05, 0x17, 0x67, 0xf0	/* T__pfx_cyc2ns_read_begin */
	.byte 0x0c, 0x54, 0x63, 0x79, 0x63, 0x32, 0x6e, 0xe0, 0xf8, 0x05, 0x17, 0x67, 0xf0	/* Tcyc2ns_read_begin */
	.byte 0x0b, 0xbf, 0x63, 0x79, 0x63, 0x32, 0x6e, 0xe0, 0xf8, 0x05, 0xe8, 0x64	/* T__pfx_cyc2ns_read_end */
	.byte 0x0b, 0x54, 0x63, 0x79, 0x63, 0x32, 0x6e, 0xe0, 0xf8, 0x05, 0xe8, 0x64	/* Tcyc2ns_read_end */
	.byte 0x11, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x73, 0x7e, 0xe5, 0x63, 0xc0, 0xd8, 0x66, 0xde, 0xcd, 0x74, 0x73, 0x63	/* T__pfx_native_sched_clock_from_tsc */
	.byte 0x11, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x73, 0x7e, 0xe5, 0x63, 0xc0, 0xd8, 0x66, 0xde, 0xcd, 0x74, 0x73, 0x63	/* Tnative_sched_clock_from_tsc */
	.byte 0x0d, 0xbf, 0x5d, 0xf0, 0xa6, 0x6e, 0xe9, 0x69, 0x22, 0x73, 0x7e, 0xe5, 0x63, 0x3c	/* T__pfx_using_native_sched_clock */
	.byte 0x0d, 0x54, 0x5d, 0xf0, 0xa6, 0x6e, 0xe9, 0x69, 0x22, 0x73, 0x7e, 0xe5, 0x63, 0x3c	/* Tusing_native_sched_clock */
	.byte 0x06, 0x3f, 0xf6, 0x7e, 0xe5, 0x63, 0x3c	/* T__pfx_sched_clock */
	.byte 0x06, 0x54, 0x73, 0x7e, 0xe5, 0x63, 0x3c	/* Tsched_clock */
	.byte 0x0d, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x28, 0x69, 0x62, 0x72, 0xa1, 0x74, 0x73, 0x63	/* T__pfx_native_calibrate_tsc */
	.byte 0x0d, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x28, 0x69, 0x62, 0x72, 0xa1, 0x74, 0x73, 0x63	/* Tnative_calibrate_tsc */
	.byte 0x0e, 0xbf, 0x74, 0x73, 0x63, 0xf6, 0x61, 0x22, 0x73, 0x7e, 0xe5, 0x63, 0x3c, 0x2a, 0x86	/* T__pfx_tsc_save_sched_clock_state */
	.byte 0x0e, 0x54, 0x74, 0x73, 0x63, 0xf6, 0x61, 0x22, 0x73, 0x7e, 0xe5, 0x63, 0x3c, 0x2a, 0x86	/* Ttsc_save_sched_clock_state */
	.byte 0x0f, 0xbf, 0x74, 0x73, 0xd5, 0xf8, 0xd6, 0xce, 0xfa, 0x73, 0x7e, 0xe5, 0x63, 0x3c, 0x2a, 0x86	/* T__pfx_tsc_restore_sched_clock_state */
	.byte 0x0f, 0x54, 0x74, 0x73, 0xd5, 0xf8, 0xd6, 0xce, 0xfa, 0x73, 0x7e, 0xe5, 0x63, 0x3c, 0x2a, 0x86	/* Ttsc_restore_sched_clock_state */
	.byte 0x15, 0xbf, 0x74, 0x73, 0xd5, 0x63, 0x3c, 0x73, 0x6f, 0x1d, 0x63, 0xfa, 0x77, 0xe9, 0xd0, 0xa9, 0xa6, 0x64, 0xab, 0x80, 0xd3, 0x64	/* T__pfx_tsc_clocksource_watchdog_disabled */
	.byte 0x15, 0x54, 0x74, 0x73, 0xd5, 0x63, 0x3c, 0x73, 0x6f, 0x1d, 0x63, 0xfa, 0x77, 0xe9, 0xd0, 0xa9, 0xa6, 0x64, 0xab, 0x80, 0xd3, 0x64	/* Ttsc_clocksource_watchdog_disabled */
	.byte 0x0e, 0xbf, 0xd4, 0xc1, 0x6e, 0xd0, 0xde, 0x6e, 0x69, 0x7a, 0x65, 0xe5, 0x74, 0x73, 0x63	/* T__pfx_unsynchronized_tsc */
	.byte 0x0e, 0x54, 0xd4, 0xc1, 0x6e, 0xd0, 0xde, 0x6e, 0x69, 0x7a, 0x65, 0xe5, 0x74, 0x73, 0x63	/* Tunsynchronized_tsc */
	.byte 0x0f, 0xbf, 0x28, 0x69, 0x62, 0x72, 0xa1, 0xe6, 0x1b, 0xc5, 0x69, 0xe0, 0x6b, 0xb6, 0x77, 0x6e	/* T__pfx_calibrate_delay_is_known */
	.byte 0x0f, 0x54, 0x28, 0x69, 0x62, 0x72, 0xa1, 0xe6, 0x1b, 0xc5, 0x69, 0xe0, 0x6b, 0xb6, 0x77, 0x6e	/* Tcalibrate_delay_is_known */
	.byte 0x0c, 0xbf, 0x92, 0x5f, 0x6b, 0x68, 0x7a, 0x5f, 0x66, 0xde, 0xcd, 0x20, 0x72	/* T__pfx_cpu_khz_from_msr */
	.byte 0x0c, 0x54, 0x92, 0x5f, 0x6b, 0x68, 0x7a, 0x5f, 0x66, 0xde, 0xcd, 0x20, 0x72	/* Tcpu_khz_from_msr */
	.byte 0x09, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x3e, 0xe6, 0x1b, 0x79	/* T__pfx_native_io_delay */
	.byte 0x09, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x3e, 0xe6, 0x1b, 0x79	/* Tnative_io_delay */
	.byte 0x09, 0xbf, 0x72, 0x74, 0xd5, 0x63, 0xa5, 0xe0, 0xf8, 0xc7	/* T__pfx_rtc_cmos_read */
	.byte 0x09, 0x54, 0x72, 0x74, 0xd5, 0x63, 0xa5, 0xe0, 0xf8, 0xc7	/* Trtc_cmos_read */
	.byte 0x09, 0xbf, 0x72, 0x74, 0xd5, 0x63, 0xa5, 0xe0, 0x24, 0x65	/* T__pfx_rtc_cmos_write */
	.byte 0x09, 0x54, 0x72, 0x74, 0xd5, 0x63, 0xa5, 0xe0, 0x24, 0x65	/* Trtc_cmos_write */
	.byte 0x0a, 0xbf, 0x6d, 0xeb, 0x68, 0x1f, 0x63, 0xa5, 0xe0, 0xc2, 0xbd	/* T__pfx_mach_set_cmos_time */
	.byte 0x0a, 0x54, 0x6d, 0xeb, 0x68, 0x1f, 0x63, 0xa5, 0xe0, 0xc2, 0xbd	/* Tmach_set_cmos_time */
	.byte 0x0a, 0xbf, 0x6d, 0xeb, 0x5b, 0xb2, 0x63, 0xa5, 0xe0, 0xc2, 0xbd	/* T__pfx_mach_get_cmos_time */
	.byte 0x0a, 0x54, 0x6d, 0xeb, 0x5b, 0xb2, 0x63, 0xa5, 0xe0, 0xc2, 0xbd	/* Tmach_get_cmos_time */
	.byte 0x0d, 0xbf, 0xb9, 0x64, 0xa1, 0x70, 0xee, 0x73, 0x7d, 0xbb, 0x63, 0x3c, 0x36, 0x34	/* T__pfx_update_persistent_clock64 */
	.byte 0x0d, 0x54, 0xb9, 0x64, 0xa1, 0x70, 0xee, 0x73, 0x7d, 0xbb, 0x63, 0x3c, 0x36, 0x34	/* Tupdate_persistent_clock64 */
	.byte 0x0c, 0xbf, 0xf8, 0xc7, 0xe7, 0xee, 0x73, 0x7d, 0xbb, 0x63, 0x3c, 0x36, 0x34	/* T__pfx_read_persistent_clock64 */
	.byte 0x0c, 0x54, 0xf8, 0xc7, 0xe7, 0xee, 0x73, 0x7d, 0xbb, 0x63, 0x3c, 0x36, 0x34	/* Tread_persistent_clock64 */
	.byte 0x09, 0xc6, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x63, 0x6c, 0x0c	/* t__pfx_resource_clip */
	.byte 0x09, 0x74, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x63, 0x6c, 0x0c	/* tresource_clip */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0xf8, 0xa5, 0x22, 0x3d, 0xee, 0x76, 0xe9, 0xd9, 0x6e, 0x73	/* T__pfx_arch_remove_reservations */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0xf8, 0xa5, 0x22, 0x3d, 0xee, 0x76, 0xe9, 0xd9, 0x6e, 0x73	/* Tarch_remove_reservations */
	.byte 0x0c, 0x3f, 0xff, 0x2a, 0xe9, 0x69, 0xd5, 0x28, 0xc3, 0xf8, 0x74, 0x1d, 0x6e	/* T__pfx___static_call_return */
	.byte 0x0b, 0x2f, 0xd6, 0xe9, 0x69, 0xd5, 0x28, 0xc3, 0xf8, 0x74, 0x1d, 0x6e	/* T__static_call_return */
	.byte 0x0b, 0x29, 0x2a, 0xe9, 0x69, 0xd5, 0x28, 0xc3, 0x76, 0xe1, 0x89, 0x86	/* t__pfx___static_call_validate */
	.byte 0x0c, 0x74, 0xff, 0xd6, 0xe9, 0x69, 0xd5, 0x28, 0xc3, 0x76, 0xe1, 0x89, 0x86	/* t__static_call_validate */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x2a, 0xe9, 0x69, 0xd5, 0x28, 0xc3, 0xea, 0xcc, 0x73, 0x66, 0xce, 0x6d	/* T__pfx_arch_static_call_transform */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x2a, 0xe9, 0x69, 0xd5, 0x28, 0xc3, 0xea, 0xcc, 0x73, 0x66, 0xce, 0x6d	/* Tarch_static_call_transform */
	.byte 0x0b, 0x3f, 0xff, 0x2a, 0xe9, 0x69, 0xd5, 0x28, 0xc3, 0xb8, 0x78, 0xb9	/* T__pfx___static_call_fixup */
	.byte 0x0a, 0x2f, 0xd6, 0xe9, 0x69, 0xd5, 0x28, 0xc3, 0xb8, 0x78, 0xb9	/* T__static_call_fixup */
	.byte 0x0b, 0x29, 0x5f, 0x92, 0x89, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx___cpuid.constprop.0 */
	.byte 0x0b, 0x74, 0xff, 0x92, 0x89, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__cpuid.constprop.0 */
	.byte 0x11, 0xa8, 0xf6, 0x70, 0x65, 0x63, 0x0b, 0xe9, 0xd9, 0x7c, 0x63, 0xea, 0xc3, 0xb9, 0x64, 0xa1, 0xc2, 0x66	/* t__pfx_speculation_ctrl_update_tif */
	.byte 0x11, 0x74, 0x73, 0x70, 0x65, 0x63, 0x0b, 0xe9, 0xd9, 0x7c, 0x63, 0xea, 0xc3, 0xb9, 0x64, 0xa1, 0xc2, 0x66	/* tspeculation_ctrl_update_tif */
	.byte 0x0b, 0xa8, 0x1f, 0x92, 0x69, 0xe5, 0x66, 0x61, 0x0b, 0x74, 0xf0, 0x67	/* t__pfx_set_cpuid_faulting */
	.byte 0x0c, 0x74, 0xc9, 0xf9, 0x92, 0x69, 0xe5, 0x66, 0x61, 0x0b, 0x74, 0xf0, 0x67	/* tset_cpuid_faulting */
	.byte 0x06, 0xc6, 0xe8, 0x80, 0xb3, 0x92, 0x89	/* t__pfx_enable_cpuid */
	.byte 0x06, 0x74, 0xe8, 0x80, 0xb3, 0x92, 0x89	/* tenable_cpuid */
	.byte 0x0c, 0xbf, 0xca, 0xd0, 0x5f, 0x64, 0x3a, 0xdb, 0x16, 0xf6, 0xea, 0x75, 0x7b	/* T__pfx_arch_dup_task_struct */
	.byte 0x0c, 0x54, 0xca, 0xd0, 0x5f, 0x64, 0x3a, 0xdb, 0x16, 0xf6, 0xea, 0x75, 0x7b	/* Tarch_dup_task_struct */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0xdb, 0x16, 0xf6, 0xea, 0x75, 0x7b	/* T__pfx_arch_release_task_struct */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0xdb, 0x16, 0xf6, 0xea, 0x75, 0x7b	/* Tarch_release_task_struct */
	.byte 0x06, 0xbf, 0xd1, 0x99, 0x15, 0xf8, 0xc7	/* T__pfx_exit_thread */
	.byte 0x06, 0x54, 0xd1, 0x99, 0x15, 0xf8, 0xc7	/* Texit_thread */
	.byte 0x09, 0xbf, 0xf8, 0xf9, 0x66, 0xde, 0xcd, 0x66, 0xce, 0x6b	/* T__pfx_ret_from_fork */
	.byte 0x09, 0x54, 0xf8, 0xf9, 0x66, 0xde, 0xcd, 0x66, 0xce, 0x6b	/* Tret_from_fork */
	.byte 0x07, 0xbf, 0xfe, 0x70, 0xc5, 0x15, 0xf8, 0xc7	/* T__pfx_copy_thread */
	.byte 0x07, 0x54, 0xfe, 0x70, 0xc5, 0x15, 0xf8, 0xc7	/* Tcopy_thread */
	.byte 0x08, 0xbf, 0x66, 0x6c, 0x5d, 0x5b, 0x15, 0xf8, 0xc7	/* T__pfx_flush_thread */
	.byte 0x08, 0x54, 0x66, 0x6c, 0x5d, 0x5b, 0x15, 0xf8, 0xc7	/* Tflush_thread */
	.byte 0x08, 0xbf, 0x64, 0xab, 0x80, 0xb3, 0x54, 0x53, 0x43	/* T__pfx_disable_TSC */
	.byte 0x08, 0x54, 0x64, 0xab, 0x80, 0xb3, 0x54, 0x53, 0x43	/* Tdisable_TSC */
	.byte 0x07, 0xbf, 0xb2, 0x74, 0x73, 0xd5, 0xa5, 0xe6	/* T__pfx_get_tsc_mode */
	.byte 0x07, 0x54, 0xb2, 0x74, 0x73, 0xd5, 0xa5, 0xe6	/* Tget_tsc_mode */
	.byte 0x07, 0x3f, 0x1f, 0x74, 0x73, 0xd5, 0xa5, 0xe6	/* T__pfx_set_tsc_mode */
	.byte 0x08, 0x54, 0xc9, 0xf9, 0x74, 0x73, 0xd5, 0xa5, 0xe6	/* Tset_tsc_mode */
	.byte 0x0f, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x74, 0x73, 0xe0, 0xb9, 0x64, 0xa1, 0x3e, 0x62, 0xe4, 0x0a	/* T__pfx_native_tss_update_io_bitmap */
	.byte 0x0f, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x74, 0x73, 0xe0, 0xb9, 0x64, 0xa1, 0x3e, 0x62, 0xe4, 0x0a	/* Tnative_tss_update_io_bitmap */
	.byte 0x13, 0x3f, 0xf6, 0x70, 0x65, 0x63, 0x0b, 0xe9, 0x69, 0x22, 0xd6, 0xce, 0xfa, 0x62, 0x27, 0x96, 0xe0, 0x68, 0xf9, 0x8d	/* T__pfx_speculative_store_bypass_ht_init */
	.byte 0x13, 0x54, 0x73, 0x70, 0x65, 0x63, 0x0b, 0xe9, 0x69, 0x22, 0xd6, 0xce, 0xfa, 0x62, 0x27, 0x96, 0xe0, 0x68, 0xf9, 0x8d	/* Tspeculative_store_bypass_ht_init */
	.byte 0x0f, 0x3f, 0xf6, 0x70, 0x65, 0x63, 0x0b, 0xe9, 0xd9, 0x7c, 0x63, 0xea, 0xc3, 0xb9, 0x64, 0x86	/* T__pfx_speculation_ctrl_update */
	.byte 0x0f, 0x54, 0x73, 0x70, 0x65, 0x63, 0x0b, 0xe9, 0xd9, 0x7c, 0x63, 0xea, 0xc3, 0xb9, 0x64, 0x86	/* Tspeculation_ctrl_update */
	.byte 0x0b, 0xbf, 0xca, 0xd0, 0xba, 0x74, 0x3a, 0xb4, 0xaa, 0xd1, 0x65, 0x63	/* T__pfx_arch_setup_new_exec */
	.byte 0x0b, 0x54, 0xca, 0xd0, 0xba, 0x74, 0x3a, 0xb4, 0xaa, 0xd1, 0x65, 0x63	/* Tarch_setup_new_exec */
	.byte 0x14, 0x3f, 0xf6, 0x70, 0x65, 0x63, 0x0b, 0xe9, 0xd9, 0x7c, 0x63, 0xea, 0xc3, 0xb9, 0x64, 0xa1, 0x63, 0x1d, 0xf8, 0x6e, 0x74	/* T__pfx_speculation_ctrl_update_current */
	.byte 0x14, 0x54, 0x73, 0x70, 0x65, 0x63, 0x0b, 0xe9, 0xd9, 0x7c, 0x63, 0xea, 0xc3, 0xb9, 0x64, 0xa1, 0x63, 0x1d, 0xf8, 0x6e, 0x74	/* Tspeculation_ctrl_update_current */
	.byte 0x0c, 0x3f, 0xff, 0xf6, 0x77, 0xe4, 0xd0, 0x5f, 0xac, 0x5f, 0x78, 0xea, 0x61	/* T__pfx___switch_to_xtra */
	.byte 0x0b, 0x2f, 0x73, 0x77, 0xe4, 0xd0, 0x5f, 0xac, 0x5f, 0x78, 0xea, 0x61	/* T__switch_to_xtra */
	.byte 0x0a, 0xbf, 0xca, 0xd0, 0x5f, 0x92, 0x5f, 0x89, 0xb3, 0x1e, 0xee	/* T__pfx_arch_cpu_idle_enter */
	.byte 0x0a, 0x54, 0xca, 0xd0, 0x5f, 0x92, 0x5f, 0x89, 0xb3, 0x1e, 0xee	/* Tarch_cpu_idle_enter */
	.byte 0x0a, 0xbf, 0xca, 0xd0, 0x5f, 0x92, 0x5f, 0x89, 0xb3, 0xe6, 0xc7	/* T__pfx_arch_cpu_idle_dead */
	.byte 0x0a, 0x54, 0xca, 0xd0, 0x5f, 0x92, 0x5f, 0x89, 0xb3, 0xe6, 0xc7	/* Tarch_cpu_idle_dead */
	.byte 0x0b, 0xbf, 0x78, 0xe8, 0x1f, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x89, 0xd3	/* T__pfx_xen_set_default_idle */
	.byte 0x0b, 0x54, 0x78, 0xe8, 0x1f, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x89, 0xd3	/* Txen_set_default_idle */
	.byte 0x08, 0x3f, 0xf6, 0xac, 0xe2, 0x15, 0x69, 0xe0, 0x92	/* T__pfx_stop_this_cpu */
	.byte 0x08, 0x54, 0xd6, 0x6f, 0xe2, 0x15, 0x69, 0xe0, 0x92	/* Tstop_this_cpu */
	.byte 0x10, 0xbf, 0x61, 0x6d, 0xe5, 0x65, 0x34, 0x90, 0x63, 0x31, 0xfa, 0x61, 0x70, 0xa3, 0xba, 0x74, 0xb9	/* T__pfx_amd_e400_c1e_apic_setup */
	.byte 0x10, 0x54, 0x61, 0x6d, 0xe5, 0x65, 0x34, 0x90, 0x63, 0x31, 0xfa, 0x61, 0x70, 0xa3, 0xba, 0x74, 0xb9	/* Tamd_e400_c1e_apic_setup */
	.byte 0x0a, 0xbf, 0xca, 0xd0, 0x5f, 0xe1, 0x2c, 0x6e, 0x2a, 0xeb, 0x6b	/* T__pfx_arch_align_stack */
	.byte 0x0a, 0x54, 0xca, 0xd0, 0x5f, 0xe1, 0x2c, 0x6e, 0x2a, 0xeb, 0x6b	/* Tarch_align_stack */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0x72, 0xcc, 0xa9, 0x6d, 0x69, 0x7a, 0xfa, 0x62, 0x72, 0x6b	/* T__pfx_arch_randomize_brk */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0x72, 0xcc, 0xa9, 0x6d, 0x69, 0x7a, 0xfa, 0x62, 0x72, 0x6b	/* Tarch_randomize_brk */
	.byte 0x07, 0x3f, 0xff, 0x5f, 0xb2, 0x77, 0xd0, 0xcc	/* T__pfx___get_wchan */
	.byte 0x07, 0x54, 0xfd, 0x65, 0xf9, 0x77, 0xd0, 0xcc	/* T__get_wchan */
	.byte 0x0d, 0xbf, 0xa9, 0x5f, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0xc3, 0xfe, 0x6d, 0xa5, 0x6e	/* T__pfx_do_arch_prctl_common */
	.byte 0x0d, 0x54, 0xa9, 0x5f, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0xc3, 0xfe, 0x6d, 0xa5, 0x6e	/* Tdo_arch_prctl_common */
	.byte 0x0c, 0xc6, 0x66, 0xbe, 0xff, 0xf0, 0x99, 0x92, 0x5f, 0x67, 0xe8, 0xee, 0xa3	/* t__pfx_fpu__init_cpu_generic */
	.byte 0x0c, 0x74, 0x66, 0xbe, 0xff, 0xf0, 0x99, 0x92, 0x5f, 0x67, 0xe8, 0xee, 0xa3	/* tfpu__init_cpu_generic */
	.byte 0x07, 0xbf, 0x66, 0xbe, 0xff, 0xf0, 0x99, 0x92	/* T__pfx_fpu__init_cpu */
	.byte 0x07, 0x54, 0x66, 0xbe, 0xff, 0xf0, 0x99, 0x92	/* Tfpu__init_cpu */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x17, 0x66, 0xce, 0xfa, 0x73, 0x61, 0x76, 0x65	/* T__pfx___traceiter_x86_fpu_before_save */
	.byte 0x13, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x17, 0x66, 0xce, 0xfa, 0x73, 0x61, 0x76, 0x65	/* T__traceiter_x86_fpu_before_save */
	.byte 0x16, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x17, 0x66, 0xce, 0xfa, 0x73, 0x61, 0x76, 0x65	/* T__pfx___probestub_x86_fpu_before_save */
	.byte 0x15, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x17, 0x66, 0xce, 0xfa, 0x73, 0x61, 0x76, 0x65	/* T__probestub_x86_fpu_before_save */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x61, 0x66, 0x74, 0xee, 0xf6, 0x61, 0x76, 0x65	/* T__pfx___traceiter_x86_fpu_after_save */
	.byte 0x13, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x61, 0x66, 0x74, 0xee, 0xf6, 0x61, 0x76, 0x65	/* T__traceiter_x86_fpu_after_save */
	.byte 0x16, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x61, 0x66, 0x74, 0xee, 0xf6, 0x61, 0x76, 0x65	/* T__pfx___probestub_x86_fpu_after_save */
	.byte 0x15, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x61, 0x66, 0x74, 0xee, 0xf6, 0x61, 0x76, 0x65	/* T__probestub_x86_fpu_after_save */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x17, 0x66, 0xce, 0xfa, 0xf8, 0xd6, 0x6f, 0xf8	/* T__pfx___traceiter_x86_fpu_before_restore */
	.byte 0x13, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x17, 0x66, 0xce, 0xfa, 0xf8, 0xd6, 0x6f, 0xf8	/* T__traceiter_x86_fpu_before_restore */
	.byte 0x16, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x17, 0x66, 0xce, 0xfa, 0xf8, 0xd6, 0x6f, 0xf8	/* T__pfx___probestub_x86_fpu_before_restore */
	.byte 0x15, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x17, 0x66, 0xce, 0xfa, 0xf8, 0xd6, 0x6f, 0xf8	/* T__probestub_x86_fpu_before_restore */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x61, 0x66, 0x74, 0xcf, 0xf8, 0xd6, 0x6f, 0xf8	/* T__pfx___traceiter_x86_fpu_after_restore */
	.byte 0x13, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x61, 0x66, 0x74, 0xcf, 0xf8, 0xd6, 0x6f, 0xf8	/* T__traceiter_x86_fpu_after_restore */
	.byte 0x16, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x61, 0x66, 0x74, 0xcf, 0xf8, 0xd6, 0x6f, 0xf8	/* T__pfx___probestub_x86_fpu_after_restore */
	.byte 0x15, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x61, 0x66, 0x74, 0xcf, 0xf8, 0xd6, 0x6f, 0xf8	/* T__probestub_x86_fpu_after_restore */
	.byte 0x14, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x9f, 0xe0, 0xeb, 0xc2, 0x76, 0x86, 0x64	/* T__pfx___traceiter_x86_fpu_regs_activated */
	.byte 0x12, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x9f, 0xe0, 0xeb, 0xc2, 0x76, 0x86, 0x64	/* T__traceiter_x86_fpu_regs_activated */
	.byte 0x15, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x9f, 0xe0, 0xeb, 0xc2, 0x76, 0x86, 0x64	/* T__pfx___probestub_x86_fpu_regs_activated */
	.byte 0x14, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x9f, 0xe0, 0xeb, 0xc2, 0x76, 0x86, 0x64	/* T__probestub_x86_fpu_regs_activated */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x9f, 0xe0, 0xe6, 0xeb, 0xc2, 0x76, 0x86, 0x64	/* T__pfx___traceiter_x86_fpu_regs_deactivated */
	.byte 0x13, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x9f, 0xe0, 0xe6, 0xeb, 0xc2, 0x76, 0x86, 0x64	/* T__traceiter_x86_fpu_regs_deactivated */
	.byte 0x16, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x9f, 0xe0, 0xe6, 0xeb, 0xc2, 0x76, 0x86, 0x64	/* T__pfx___probestub_x86_fpu_regs_deactivated */
	.byte 0x15, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x9f, 0xe0, 0xe6, 0xeb, 0xc2, 0x76, 0x86, 0x64	/* T__probestub_x86_fpu_regs_deactivated */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0xf0, 0x99, 0xd6, 0x86	/* T__pfx___traceiter_x86_fpu_init_state */
	.byte 0x0f, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0xf0, 0x99, 0xd6, 0x86	/* T__traceiter_x86_fpu_init_state */
	.byte 0x12, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0xf0, 0x99, 0xd6, 0x86	/* T__pfx___probestub_x86_fpu_init_state */
	.byte 0x11, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0xf0, 0x99, 0xd6, 0x86	/* T__probestub_x86_fpu_init_state */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x64, 0xde, 0x70, 0x70, 0x65, 0x64	/* T__pfx___traceiter_x86_fpu_dropped */
	.byte 0x11, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x64, 0xde, 0x70, 0x70, 0x65, 0x64	/* T__traceiter_x86_fpu_dropped */
	.byte 0x14, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x64, 0xde, 0x70, 0x70, 0x65, 0x64	/* T__pfx___probestub_x86_fpu_dropped */
	.byte 0x13, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x64, 0xde, 0x70, 0x70, 0x65, 0x64	/* T__probestub_x86_fpu_dropped */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0xfe, 0x70, 0x79, 0xf6, 0x72, 0x63	/* T__pfx___traceiter_x86_fpu_copy_src */
	.byte 0x11, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0xfe, 0x70, 0x79, 0xf6, 0x72, 0x63	/* T__traceiter_x86_fpu_copy_src */
	.byte 0x14, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0xfe, 0x70, 0x79, 0xf6, 0x72, 0x63	/* T__pfx___probestub_x86_fpu_copy_src */
	.byte 0x13, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0xfe, 0x70, 0x79, 0xf6, 0x72, 0x63	/* T__probestub_x86_fpu_copy_src */
	.byte 0x12, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0xfe, 0x70, 0xc5, 0x64, 0xd6	/* T__pfx___traceiter_x86_fpu_copy_dst */
	.byte 0x10, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0xfe, 0x70, 0xc5, 0x64, 0xd6	/* T__traceiter_x86_fpu_copy_dst */
	.byte 0x13, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0xfe, 0x70, 0xc5, 0x64, 0xd6	/* T__pfx___probestub_x86_fpu_copy_dst */
	.byte 0x12, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0xfe, 0x70, 0xc5, 0x64, 0xd6	/* T__probestub_x86_fpu_copy_dst */
	.byte 0x18, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x78, 0xd6, 0xa1, 0x7e, 0x63, 0xd8, 0x66, 0x61, 0x69, 0xd3, 0x64	/* T__pfx___traceiter_x86_fpu_xstate_check_failed */
	.byte 0x16, 0x2f, 0x01, 0xe4, 0xcf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x78, 0xd6, 0xa1, 0x7e, 0x63, 0xd8, 0x66, 0x61, 0x69, 0xd3, 0x64	/* T__traceiter_x86_fpu_xstate_check_failed */
	.byte 0x19, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x78, 0xd6, 0xa1, 0x7e, 0x63, 0xd8, 0x66, 0x61, 0x69, 0xd3, 0x64	/* T__pfx___probestub_x86_fpu_xstate_check_failed */
	.byte 0x18, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x78, 0xd6, 0xa1, 0x7e, 0x63, 0xd8, 0x66, 0x61, 0x69, 0xd3, 0x64	/* T__probestub_x86_fpu_xstate_check_failed */
	.byte 0x0a, 0xbf, 0x6b, 0xee, 0xb4, 0xc3, 0x66, 0xbe, 0x5f, 0xe8, 0x64	/* T__pfx_kernel_fpu_end */
	.byte 0x0a, 0x54, 0x6b, 0xee, 0xb4, 0xc3, 0x66, 0xbe, 0x5f, 0xe8, 0x64	/* Tkernel_fpu_end */
	.byte 0x09, 0xbf, 0xa7, 0x93, 0x66, 0xbe, 0x5f, 0x5d, 0x80, 0xd3	/* T__pfx_irq_fpu_usable */
	.byte 0x09, 0x54, 0xa7, 0x93, 0x66, 0xbe, 0x5f, 0x5d, 0x80, 0xd3	/* Tirq_fpu_usable */
	.byte 0x10, 0xc6, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x9f, 0xe0, 0xeb, 0xc2, 0x76, 0x86, 0x64	/* t__pfx_trace_x86_fpu_regs_activated */
	.byte 0x10, 0x74, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe, 0x5f, 0x9f, 0xe0, 0xeb, 0xc2, 0x76, 0x86, 0x64	/* ttrace_x86_fpu_regs_activated */
	.byte 0x0d, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe	/* t__pfx_trace_raw_output_x86_fpu */
	.byte 0x0d, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe	/* ttrace_raw_output_x86_fpu */
	.byte 0x0a, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe	/* t__pfx___bpf_trace_x86_fpu */
	.byte 0x0a, 0x74, 0xff, 0x40, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe	/* t__bpf_trace_x86_fpu */
	.byte 0x0e, 0xbf, 0x66, 0xbe, 0x5f, 0x08, 0xd5, 0x67, 0x75, 0x3b, 0xf9, 0x66, 0x70, 0xd6, 0x86	/* T__pfx_fpu_alloc_guest_fpstate */
	.byte 0x0e, 0x54, 0x66, 0xbe, 0x5f, 0x08, 0xd5, 0x67, 0x75, 0x3b, 0xf9, 0x66, 0x70, 0xd6, 0x86	/* Tfpu_alloc_guest_fpstate */
	.byte 0x0e, 0xbf, 0x66, 0xbe, 0x5f, 0x87, 0xfa, 0x67, 0x75, 0x3b, 0xf9, 0x66, 0x70, 0xd6, 0x86	/* T__pfx_fpu_free_guest_fpstate */
	.byte 0x0e, 0x54, 0x66, 0xbe, 0x5f, 0x87, 0xfa, 0x67, 0x75, 0x3b, 0xf9, 0x66, 0x70, 0xd6, 0x86	/* Tfpu_free_guest_fpstate */
	.byte 0x13, 0xbf, 0x66, 0xbe, 0x5f, 0xe8, 0x80, 0xb3, 0x67, 0x75, 0x3b, 0xf9, 0x78, 0x66, 0xe5, 0x66, 0x65, 0xe9, 0x75, 0x3d	/* T__pfx_fpu_enable_guest_xfd_features */
	.byte 0x13, 0x54, 0x66, 0xbe, 0x5f, 0xe8, 0x80, 0xb3, 0x67, 0x75, 0x3b, 0xf9, 0x78, 0x66, 0xe5, 0x66, 0x65, 0xe9, 0x75, 0x3d	/* Tfpu_enable_guest_xfd_features */
	.byte 0x14, 0xbf, 0x66, 0xbe, 0x5f, 0xfe, 0x70, 0xc5, 0x67, 0x75, 0x3b, 0xf9, 0x66, 0x70, 0xd6, 0xa1, 0xac, 0x5f, 0x75, 0x80, 0x69	/* T__pfx_fpu_copy_guest_fpstate_to_uabi */
	.byte 0x14, 0x54, 0x66, 0xbe, 0x5f, 0xfe, 0x70, 0xc5, 0x67, 0x75, 0x3b, 0xf9, 0x66, 0x70, 0xd6, 0xa1, 0xac, 0x5f, 0x75, 0x80, 0x69	/* Tfpu_copy_guest_fpstate_to_uabi */
	.byte 0x14, 0xbf, 0x66, 0xbe, 0x5f, 0xfe, 0x70, 0xc5, 0x75, 0x80, 0xcb, 0xac, 0x5f, 0x67, 0x75, 0x3b, 0xf9, 0x66, 0x70, 0xd6, 0x86	/* T__pfx_fpu_copy_uabi_to_guest_fpstate */
	.byte 0x14, 0x54, 0x66, 0xbe, 0x5f, 0xfe, 0x70, 0xc5, 0x75, 0x80, 0xcb, 0xac, 0x5f, 0x67, 0x75, 0x3b, 0xf9, 0x66, 0x70, 0xd6, 0x86	/* Tfpu_copy_uabi_to_guest_fpstate */
	.byte 0x13, 0xbf, 0x66, 0xbe, 0x95, 0x6e, 0xd5, 0x67, 0x75, 0x3b, 0xf9, 0x76, 0x6d, 0xd1, 0x99, 0x78, 0x66, 0x64, 0x2a, 0x86	/* T__pfx_fpu_sync_guest_vmexit_xfd_state */
	.byte 0x13, 0x54, 0x66, 0xbe, 0x95, 0x6e, 0xd5, 0x67, 0x75, 0x3b, 0xf9, 0x76, 0x6d, 0xd1, 0x99, 0x78, 0x66, 0x64, 0x2a, 0x86	/* Tfpu_sync_guest_vmexit_xfd_state */
	.byte 0x0e, 0xbf, 0x66, 0xbe, 0x5f, 0xb9, 0x64, 0xa1, 0x67, 0x75, 0x3b, 0xf9, 0x78, 0x66, 0x64	/* T__pfx_fpu_update_guest_xfd */
	.byte 0x0e, 0x54, 0x66, 0xbe, 0x5f, 0xb9, 0x64, 0xa1, 0x67, 0x75, 0x3b, 0xf9, 0x78, 0x66, 0x64	/* Tfpu_update_guest_xfd */
	.byte 0x0b, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe	/* t__pfx_trace_event_raw_event_x86_fpu */
	.byte 0x0b, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe	/* ttrace_event_raw_event_x86_fpu */
	.byte 0x0b, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe	/* t__pfx_perf_trace_x86_fpu */
	.byte 0x0a, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0x66, 0xbe	/* tperf_trace_x86_fpu */
	.byte 0x0e, 0x3f, 0xf6, 0x61, 0x22, 0x66, 0x70, 0x9f, 0xe0, 0xac, 0x5f, 0x66, 0x70, 0xd6, 0x86	/* T__pfx_save_fpregs_to_fpstate */
	.byte 0x0e, 0x54, 0x73, 0x61, 0x22, 0x66, 0x70, 0x9f, 0xe0, 0xac, 0x5f, 0x66, 0x70, 0xd6, 0x86	/* Tsave_fpregs_to_fpstate */
	.byte 0x0e, 0xbf, 0x6b, 0xee, 0xb4, 0xc3, 0x66, 0xbe, 0x5f, 0x17, 0x67, 0xf0, 0x5f, 0xdd, 0x16	/* T__pfx_kernel_fpu_begin_mask */
	.byte 0x0e, 0x54, 0x6b, 0xee, 0xb4, 0xc3, 0x66, 0xbe, 0x5f, 0x17, 0x67, 0xf0, 0x5f, 0xdd, 0x16	/* Tkernel_fpu_begin_mask */
	.byte 0x10, 0xbf, 0xf8, 0xd6, 0xce, 0xfa, 0x66, 0x70, 0x9f, 0xe0, 0x66, 0xde, 0xcd, 0x66, 0x70, 0xd6, 0x86	/* T__pfx_restore_fpregs_from_fpstate */
	.byte 0x10, 0x54, 0xf8, 0xd6, 0xce, 0xfa, 0x66, 0x70, 0x9f, 0xe0, 0x66, 0xde, 0xcd, 0x66, 0x70, 0xd6, 0x86	/* Trestore_fpregs_from_fpstate */
	.byte 0x0d, 0x3f, 0xf6, 0x77, 0xe4, 0xd0, 0x5f, 0x66, 0xbe, 0x5f, 0xf8, 0x74, 0x1d, 0x6e	/* T__pfx_switch_fpu_return */
	.byte 0x0d, 0x54, 0x73, 0x77, 0xe4, 0xd0, 0x5f, 0x66, 0xbe, 0x5f, 0xf8, 0x74, 0x1d, 0x6e	/* Tswitch_fpu_return */
	.byte 0x14, 0xbf, 0x66, 0xbe, 0x5f, 0xf8, 0xc9, 0xf9, 0x66, 0xde, 0xcd, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x7c, 0xb8, 0x78, 0xb9	/* T__pfx_fpu_reset_from_exception_fixup */
	.byte 0x14, 0x54, 0x66, 0xbe, 0x5f, 0xf8, 0xc9, 0xf9, 0x66, 0xde, 0xcd, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x7c, 0xb8, 0x78, 0xb9	/* Tfpu_reset_from_exception_fixup */
	.byte 0x0a, 0xbf, 0x66, 0xbe, 0x95, 0x6e, 0xd5, 0x66, 0x70, 0xd6, 0x86	/* T__pfx_fpu_sync_fpstate */
	.byte 0x0a, 0x54, 0x66, 0xbe, 0x95, 0x6e, 0xd5, 0x66, 0x70, 0xd6, 0x86	/* Tfpu_sync_fpstate */
	.byte 0x09, 0xbf, 0x66, 0x70, 0xd6, 0xa1, 0xf0, 0x99, 0x5d, 0xee	/* T__pfx_fpstate_init_user */
	.byte 0x09, 0x54, 0x66, 0x70, 0xd6, 0xa1, 0xf0, 0x99, 0x5d, 0xee	/* Tfpstate_init_user */
	.byte 0x08, 0xbf, 0x66, 0x70, 0xd6, 0xa1, 0xf8, 0xc9, 0x74	/* T__pfx_fpstate_reset */
	.byte 0x08, 0x54, 0x66, 0x70, 0xd6, 0xa1, 0xf8, 0xc9, 0x74	/* Tfpstate_reset */
	.byte 0x07, 0xbf, 0x66, 0xbe, 0x5f, 0x63, 0xdf, 0xb4	/* T__pfx_fpu_clone */
	.byte 0x07, 0x54, 0x66, 0xbe, 0x5f, 0x63, 0xdf, 0xb4	/* Tfpu_clone */
	.byte 0x12, 0xbf, 0x66, 0xbe, 0x5f, 0x15, 0xf8, 0xc7, 0xf6, 0xea, 0x75, 0x63, 0xf9, 0x77, 0x68, 0xe4, 0x65, 0x6c, 0x7d	/* T__pfx_fpu_thread_struct_whitelist */
	.byte 0x12, 0x54, 0x66, 0xbe, 0x5f, 0x15, 0xf8, 0xc7, 0xf6, 0xea, 0x75, 0x63, 0xf9, 0x77, 0x68, 0xe4, 0x65, 0x6c, 0x7d	/* Tfpu_thread_struct_whitelist */
	.byte 0x07, 0xbf, 0x66, 0xbe, 0xff, 0x64, 0xde, 0x70	/* T__pfx_fpu__drop */
	.byte 0x07, 0x54, 0x66, 0xbe, 0xff, 0x64, 0xde, 0x70	/* Tfpu__drop */
	.byte 0x0b, 0xbf, 0x66, 0xbe, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x15, 0xf8, 0xc7	/* T__pfx_fpu_flush_thread */
	.byte 0x0b, 0x54, 0x66, 0xbe, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x15, 0xf8, 0xc7	/* Tfpu_flush_thread */
	.byte 0x0b, 0xbf, 0x66, 0x70, 0x9f, 0xe0, 0xc0, 0xd8, 0xcc, 0xe5, 0xdf, 0xc7	/* T__pfx_fpregs_lock_and_load */
	.byte 0x0b, 0x54, 0x66, 0x70, 0x9f, 0xe0, 0xc0, 0xd8, 0xcc, 0xe5, 0xdf, 0xc7	/* Tfpregs_lock_and_load */
	.byte 0x0c, 0xbf, 0x66, 0x70, 0x9f, 0xe0, 0xdd, 0x72, 0xd8, 0xeb, 0xc2, 0x76, 0x86	/* T__pfx_fpregs_mark_activate */
	.byte 0x0c, 0x54, 0x66, 0x70, 0x9f, 0xe0, 0xdd, 0x72, 0xd8, 0xeb, 0xc2, 0x76, 0x86	/* Tfpregs_mark_activate */
	.byte 0x0d, 0xbf, 0x66, 0xbe, 0xff, 0x63, 0xd3, 0xca, 0x5f, 0x5d, 0xee, 0x2a, 0x86, 0x73	/* T__pfx_fpu__clear_user_states */
	.byte 0x0d, 0x54, 0x66, 0xbe, 0xff, 0x63, 0xd3, 0xca, 0x5f, 0x5d, 0xee, 0x2a, 0x86, 0x73	/* Tfpu__clear_user_states */
	.byte 0x0d, 0xbf, 0x66, 0xbe, 0xf6, 0x13, 0xe2, 0x6b, 0x76, 0xcd, 0x66, 0x70, 0xd6, 0x86	/* T__pfx_fpu_swap_kvm_fpstate */
	.byte 0x0d, 0x54, 0x66, 0xbe, 0xf6, 0x13, 0xe2, 0x6b, 0x76, 0xcd, 0x66, 0x70, 0xd6, 0x86	/* Tfpu_swap_kvm_fpstate */
	.byte 0x0d, 0xbf, 0x66, 0xbe, 0xff, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x7c, 0xfe, 0xe6	/* T__pfx_fpu__exception_code */
	.byte 0x0d, 0x54, 0x66, 0xbe, 0xff, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x7c, 0xfe, 0xe6	/* Tfpu__exception_code */
	.byte 0x0d, 0x29, 0x5f, 0x98, 0x76, 0xee, 0xf9, 0x66, 0xde, 0xcd, 0x66, 0x78, 0x73, 0x72	/* t__pfx___convert_from_fxsr */
	.byte 0x0d, 0x74, 0xff, 0x98, 0x76, 0xee, 0xf9, 0x66, 0xde, 0xcd, 0x66, 0x78, 0x73, 0x72	/* t__convert_from_fxsr */
	.byte 0x0c, 0xbf, 0x9f, 0xc9, 0xf9, 0x66, 0x70, 0x9f, 0xe0, 0xeb, 0xc2, 0x76, 0x65	/* T__pfx_regset_fpregs_active */
	.byte 0x0c, 0x54, 0x9f, 0xc9, 0xf9, 0x66, 0x70, 0x9f, 0xe0, 0xeb, 0xc2, 0x76, 0x65	/* Tregset_fpregs_active */
	.byte 0x10, 0xbf, 0x9f, 0xc9, 0xf9, 0x78, 0x9f, 0xc9, 0xf9, 0x66, 0x70, 0x9f, 0xe0, 0xeb, 0xc2, 0x76, 0x65	/* T__pfx_regset_xregset_fpregs_active */
	.byte 0x10, 0x54, 0x9f, 0xc9, 0xf9, 0x78, 0x9f, 0xc9, 0xf9, 0x66, 0x70, 0x9f, 0xe0, 0xeb, 0xc2, 0x76, 0x65	/* Tregset_xregset_fpregs_active */
	.byte 0x08, 0xbf, 0x78, 0x66, 0x70, 0x9f, 0xe0, 0xda, 0x74	/* T__pfx_xfpregs_get */
	.byte 0x08, 0x54, 0x78, 0x66, 0x70, 0x9f, 0xe0, 0xda, 0x74	/* Txfpregs_get */
	.byte 0x08, 0xbf, 0x78, 0x66, 0x70, 0x9f, 0x73, 0xba, 0x74	/* T__pfx_xfpregs_set */
	.byte 0x08, 0x54, 0x78, 0x66, 0x70, 0x9f, 0x73, 0xba, 0x74	/* Txfpregs_set */
	.byte 0x08, 0xbf, 0x78, 0xd6, 0x86, 0x9f, 0xe0, 0xda, 0x74	/* T__pfx_xstateregs_get */
	.byte 0x08, 0x54, 0x78, 0xd6, 0x86, 0x9f, 0xe0, 0xda, 0x74	/* Txstateregs_get */
	.byte 0x08, 0xbf, 0x78, 0xd6, 0x86, 0x9f, 0x73, 0xba, 0x74	/* T__pfx_xstateregs_set */
	.byte 0x08, 0x54, 0x78, 0xd6, 0x86, 0x9f, 0x73, 0xba, 0x74	/* Txstateregs_set */
	.byte 0x0c, 0xbf, 0x98, 0x76, 0xee, 0xf9, 0x66, 0xde, 0xcd, 0x66, 0x78, 0x73, 0x72	/* T__pfx_convert_from_fxsr */
	.byte 0x0c, 0x54, 0x98, 0x76, 0xee, 0xf9, 0x66, 0xde, 0xcd, 0x66, 0x78, 0x73, 0x72	/* Tconvert_from_fxsr */
	.byte 0x0b, 0xbf, 0x98, 0x76, 0xee, 0xf9, 0xac, 0x5f, 0x66, 0x78, 0x73, 0x72	/* T__pfx_convert_to_fxsr */
	.byte 0x0b, 0x54, 0x98, 0x76, 0xee, 0xf9, 0xac, 0x5f, 0x66, 0x78, 0x73, 0x72	/* Tconvert_to_fxsr */
	.byte 0x07, 0xbf, 0x66, 0x70, 0x9f, 0xe0, 0xda, 0x74	/* T__pfx_fpregs_get */
	.byte 0x07, 0x54, 0x66, 0x70, 0x9f, 0xe0, 0xda, 0x74	/* Tfpregs_get */
	.byte 0x07, 0xbf, 0x66, 0x70, 0x9f, 0x73, 0xba, 0x74	/* T__pfx_fpregs_set */
	.byte 0x07, 0x54, 0x66, 0x70, 0x9f, 0x73, 0xba, 0x74	/* Tfpregs_set */
	.byte 0x0c, 0xa8, 0xf6, 0x61, 0x22, 0x66, 0x73, 0x61, 0x22, 0x68, 0x65, 0xc7, 0xee	/* t__pfx_save_fsave_header */
	.byte 0x0c, 0x74, 0x73, 0x61, 0x22, 0x66, 0x73, 0x61, 0x22, 0x68, 0x65, 0xc7, 0xee	/* tsave_fsave_header */
	.byte 0x0b, 0x29, 0x5f, 0x66, 0xbe, 0x5f, 0xf8, 0xd6, 0xce, 0xfa, 0x73, 0x2c	/* t__pfx___fpu_restore_sig */
	.byte 0x0b, 0x74, 0xff, 0x66, 0xbe, 0x5f, 0xf8, 0xd6, 0xce, 0xfa, 0x73, 0x2c	/* t__fpu_restore_sig */
	.byte 0x0e, 0xbf, 0xfe, 0x70, 0xc5, 0x66, 0x70, 0xd6, 0xa1, 0xac, 0xf6, 0x2c, 0x66, 0xb5, 0xbd	/* T__pfx_copy_fpstate_to_sigframe */
	.byte 0x0e, 0x54, 0xfe, 0x70, 0xc5, 0x66, 0x70, 0xd6, 0xa1, 0xac, 0xf6, 0x2c, 0x66, 0xb5, 0xbd	/* Tcopy_fpstate_to_sigframe */
	.byte 0x0a, 0xbf, 0x66, 0xbe, 0xff, 0xf8, 0xd6, 0xce, 0xfa, 0x73, 0x2c	/* T__pfx_fpu__restore_sig */
	.byte 0x0a, 0x54, 0x66, 0xbe, 0xff, 0xf8, 0xd6, 0xce, 0xfa, 0x73, 0x2c	/* Tfpu__restore_sig */
	.byte 0x0c, 0xbf, 0x66, 0xbe, 0xff, 0x08, 0xd5, 0x6d, 0xe9, 0x68, 0x66, 0xb5, 0xbd	/* T__pfx_fpu__alloc_mathframe */
	.byte 0x0c, 0x54, 0x66, 0xbe, 0xff, 0x08, 0xd5, 0x6d, 0xe9, 0x68, 0x66, 0xb5, 0xbd	/* Tfpu__alloc_mathframe */
	.byte 0x04, 0x29, 0x5f, 0x92, 0x89	/* t__pfx___cpuid */
	.byte 0x04, 0x74, 0xff, 0x92, 0x89	/* t__cpuid */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72	/* t__pfx_paravirt_write_msr */
	.byte 0x0a, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72	/* tparavirt_write_msr */
	.byte 0x0e, 0xbf, 0x78, 0xd6, 0xa1, 0xb2, 0x67, 0x75, 0x3b, 0xf9, 0x0d, 0xb9, 0xe7, 0xee, 0x6d	/* T__pfx_xstate_get_guest_group_perm */
	.byte 0x0e, 0x54, 0x78, 0xd6, 0xa1, 0xb2, 0x67, 0x75, 0x3b, 0xf9, 0x0d, 0xb9, 0xe7, 0xee, 0x6d	/* Txstate_get_guest_group_perm */
	.byte 0x0c, 0xbf, 0x92, 0x5f, 0x68, 0x61, 0xe0, 0x78, 0x66, 0x65, 0xe9, 0x75, 0x3d	/* T__pfx_cpu_has_xfeatures */
	.byte 0x0c, 0x54, 0x92, 0x5f, 0x68, 0x61, 0xe0, 0x78, 0x66, 0x65, 0xe9, 0x75, 0x3d	/* Tcpu_has_xfeatures */
	.byte 0x0d, 0xc6, 0xb2, 0x78, 0x73, 0x61, 0x22, 0xe6, 0x73, 0x63, 0xf6, 0x69, 0x7a, 0x65	/* t__pfx_get_xsave_desc_size */
	.byte 0x0d, 0x74, 0xb2, 0x78, 0x73, 0x61, 0x22, 0xe6, 0x73, 0x63, 0xf6, 0x69, 0x7a, 0x65	/* tget_xsave_desc_size */
	.byte 0x0d, 0xc6, 0x78, 0x66, 0x65, 0xe9, 0x1d, 0xfa, 0xb2, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* t__pfx_xfeature_get_offset */
	.byte 0x0d, 0x74, 0x78, 0x66, 0x65, 0xe9, 0x1d, 0xfa, 0xb2, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* txfeature_get_offset */
	.byte 0x09, 0x29, 0x5f, 0x1c, 0x78, 0x73, 0x61, 0x22, 0x10, 0x72	/* t__pfx___raw_xsave_addr */
	.byte 0x09, 0x74, 0xff, 0x1c, 0x78, 0x73, 0x61, 0x22, 0x10, 0x72	/* t__raw_xsave_addr */
	.byte 0x08, 0xbf, 0xb2, 0x78, 0x73, 0x61, 0x22, 0x10, 0x72	/* T__pfx_get_xsave_addr */
	.byte 0x08, 0x54, 0xb2, 0x78, 0x73, 0x61, 0x22, 0x10, 0x72	/* Tget_xsave_addr */
	.byte 0x0c, 0xc6, 0x78, 0xd6, 0xa1, 0x28, 0x63, 0x0b, 0xa1, 0x73, 0x69, 0x7a, 0x65	/* t__pfx_xstate_calculate_size */
	.byte 0x0c, 0x74, 0x78, 0xd6, 0xa1, 0x28, 0x63, 0x0b, 0xa1, 0x73, 0x69, 0x7a, 0x65	/* txstate_calculate_size */
	.byte 0x10, 0xbf, 0x66, 0x70, 0xd6, 0xa1, 0x63, 0xd3, 0xca, 0x5f, 0x78, 0xd6, 0xa1, 0x09, 0x6f, 0x6e, 0x1e	/* T__pfx_fpstate_clear_xstate_component */
	.byte 0x10, 0x54, 0x66, 0x70, 0xd6, 0xa1, 0x63, 0xd3, 0xca, 0x5f, 0x78, 0xd6, 0xa1, 0x09, 0x6f, 0x6e, 0x1e	/* Tfpstate_clear_xstate_component */
	.byte 0x0b, 0xc6, 0xfe, 0x70, 0xc5, 0x66, 0xde, 0xcd, 0xa2, 0x66, 0x66, 0xee	/* t__pfx_copy_from_buffer */
	.byte 0x0b, 0x74, 0xfe, 0x70, 0xc5, 0x66, 0xde, 0xcd, 0xa2, 0x66, 0x66, 0xee	/* tcopy_from_buffer */
	.byte 0x0c, 0xc6, 0xfe, 0x70, 0xc5, 0x75, 0x80, 0xcb, 0xac, 0x5f, 0x78, 0xd6, 0x86	/* t__pfx_copy_uabi_to_xstate */
	.byte 0x0c, 0x74, 0xfe, 0x70, 0xc5, 0x75, 0x80, 0xcb, 0xac, 0x5f, 0x78, 0xd6, 0x86	/* tcopy_uabi_to_xstate */
	.byte 0x10, 0xc6, 0x76, 0xe1, 0x89, 0xa1, 0xf0, 0xe6, 0x70, 0xe8, 0x64, 0xbb, 0x09, 0x6f, 0x6e, 0x1e, 0x73	/* t__pfx_validate_independent_components */
	.byte 0x10, 0x74, 0x76, 0xe1, 0x89, 0xa1, 0xf0, 0xe6, 0x70, 0xe8, 0x64, 0xbb, 0x09, 0x6f, 0x6e, 0x1e, 0x73	/* tvalidate_independent_components */
	.byte 0x0b, 0xbf, 0x66, 0xbe, 0xff, 0xf0, 0x99, 0x92, 0x5f, 0x78, 0xd6, 0x86	/* T__pfx_fpu__init_cpu_xstate */
	.byte 0x0b, 0x54, 0x66, 0xbe, 0xff, 0xf0, 0x99, 0x92, 0x5f, 0x78, 0xd6, 0x86	/* Tfpu__init_cpu_xstate */
	.byte 0x0b, 0xbf, 0x78, 0x66, 0x65, 0xe9, 0x1d, 0xfa, 0x73, 0x69, 0x7a, 0x65	/* T__pfx_xfeature_size */
	.byte 0x0b, 0x54, 0x78, 0x66, 0x65, 0xe9, 0x1d, 0xfa, 0x73, 0x69, 0x7a, 0x65	/* Txfeature_size */
	.byte 0x09, 0xbf, 0x66, 0xbe, 0xff, 0xf8, 0xb7, 0x6d, 0xfa, 0x92	/* T__pfx_fpu__resume_cpu */
	.byte 0x09, 0x54, 0x66, 0xbe, 0xff, 0xf8, 0xb7, 0x6d, 0xfa, 0x92	/* Tfpu__resume_cpu */
	.byte 0x0b, 0xbf, 0xb2, 0x78, 0x73, 0x61, 0x22, 0x10, 0x72, 0x5f, 0x5d, 0xee	/* T__pfx_get_xsave_addr_user */
	.byte 0x0b, 0x54, 0xb2, 0x78, 0x73, 0x61, 0x22, 0x10, 0x72, 0x5f, 0x5d, 0xee	/* Tget_xsave_addr_user */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0x1f, 0x5d, 0xee, 0xe7, 0x0e, 0xc5, 0xeb, 0x63, 0x3b, 0x73	/* T__pfx_arch_set_user_pkey_access */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0x1f, 0x5d, 0xee, 0xe7, 0x0e, 0xc5, 0xeb, 0x63, 0x3b, 0x73	/* Tarch_set_user_pkey_access */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0xfe, 0x70, 0xc5, 0x78, 0xd6, 0xa1, 0xac, 0x5f, 0x75, 0x80, 0xcb, 0xa2, 0x66	/* T__pfx___copy_xstate_to_uabi_buf */
	.byte 0x0e, 0x2f, 0xfe, 0x70, 0xc5, 0x78, 0xd6, 0xa1, 0xac, 0x5f, 0x75, 0x80, 0xcb, 0xa2, 0x66	/* T__copy_xstate_to_uabi_buf */
	.byte 0x0e, 0xbf, 0xfe, 0x70, 0xc5, 0x78, 0xd6, 0xa1, 0xac, 0x5f, 0x75, 0x80, 0xcb, 0xa2, 0x66	/* T__pfx_copy_xstate_to_uabi_buf */
	.byte 0x0e, 0x54, 0xfe, 0x70, 0xc5, 0x78, 0xd6, 0xa1, 0xac, 0x5f, 0x75, 0x80, 0xcb, 0xa2, 0x66	/* Tcopy_xstate_to_uabi_buf */
	.byte 0x13, 0xbf, 0xfe, 0x70, 0xc5, 0x75, 0x80, 0xcb, 0x66, 0xde, 0xcd, 0x6b, 0xee, 0xb4, 0xc3, 0xac, 0x5f, 0x78, 0xd6, 0x86	/* T__pfx_copy_uabi_from_kernel_to_xstate */
	.byte 0x13, 0x54, 0xfe, 0x70, 0xc5, 0x75, 0x80, 0xcb, 0x66, 0xde, 0xcd, 0x6b, 0xee, 0xb4, 0xc3, 0xac, 0x5f, 0x78, 0xd6, 0x86	/* Tcopy_uabi_from_kernel_to_xstate */
	.byte 0x14, 0xbf, 0xfe, 0x70, 0x79, 0xf6, 0x2c, 0x66, 0xb5, 0x6d, 0xfa, 0x66, 0xde, 0xcd, 0x5d, 0xcf, 0xac, 0x5f, 0x78, 0xd6, 0x86	/* T__pfx_copy_sigframe_from_user_to_xstate */
	.byte 0x14, 0x54, 0xfe, 0x70, 0x79, 0xf6, 0x2c, 0x66, 0xb5, 0x6d, 0xfa, 0x66, 0xde, 0xcd, 0x5d, 0xcf, 0xac, 0x5f, 0x78, 0xd6, 0x86	/* Tcopy_sigframe_from_user_to_xstate */
	.byte 0x06, 0xbf, 0x78, 0x73, 0x61, 0x76, 0x3b	/* T__pfx_xsaves */
	.byte 0x06, 0x54, 0x78, 0x73, 0x61, 0x76, 0x3b	/* Txsaves */
	.byte 0x06, 0xbf, 0x78, 0x72, 0xd6, 0xce, 0x73	/* T__pfx_xrstors */
	.byte 0x06, 0x54, 0x78, 0x72, 0xd6, 0xce, 0x73	/* Txrstors */
	.byte 0x07, 0xbf, 0x66, 0x70, 0xd6, 0xa1, 0x87, 0x65	/* T__pfx_fpstate_free */
	.byte 0x07, 0x54, 0x66, 0x70, 0xd6, 0xa1, 0x87, 0x65	/* Tfpstate_free */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x78, 0x66, 0xe5, 0xe8, 0x80, 0xb3, 0x66, 0x65, 0xe9, 0x75, 0xf8	/* T__pfx___xfd_enable_feature */
	.byte 0x0c, 0x2f, 0x78, 0x66, 0xe5, 0xe8, 0x80, 0xb3, 0x66, 0x65, 0xe9, 0x75, 0xf8	/* T__xfd_enable_feature */
	.byte 0x0c, 0xbf, 0x78, 0x66, 0xe5, 0xe8, 0x80, 0xb3, 0x66, 0x65, 0xe9, 0x75, 0xf8	/* T__pfx_xfd_enable_feature */
	.byte 0x0c, 0x54, 0x78, 0x66, 0xe5, 0xe8, 0x80, 0xb3, 0x66, 0x65, 0xe9, 0x75, 0xf8	/* Txfd_enable_feature */
	.byte 0x0b, 0xbf, 0x66, 0xbe, 0x5f, 0x78, 0xd6, 0xa1, 0x70, 0x72, 0x7b, 0x6c	/* T__pfx_fpu_xstate_prctl */
	.byte 0x0b, 0x54, 0x66, 0xbe, 0x5f, 0x78, 0xd6, 0xa1, 0x70, 0x72, 0x7b, 0x6c	/* Tfpu_xstate_prctl */
	.byte 0x0b, 0x3f, 0x25, 0x63, 0xe7, 0x69, 0xe5, 0xca, 0xd0, 0x2a, 0xe9, 0x5d	/* T__pfx_proc_pid_arch_status */
	.byte 0x0b, 0x54, 0x9b, 0x63, 0xe7, 0x69, 0xe5, 0xca, 0xd0, 0x2a, 0xe9, 0x5d	/* Tproc_pid_arch_status */
	.byte 0x13, 0xbf, 0x65, 0x6c, 0xa0, 0xfe, 0xf8, 0x64, 0x75, 0x6d, 0xe2, 0xd1, 0xea, 0x61, 0x5f, 0xb6, 0x9a, 0xe0, 0x24, 0x65	/* T__pfx_elf_coredump_extra_notes_write */
	.byte 0x13, 0x54, 0x65, 0x6c, 0xa0, 0xfe, 0xf8, 0x64, 0x75, 0x6d, 0xe2, 0xd1, 0xea, 0x61, 0x5f, 0xb6, 0x9a, 0xe0, 0x24, 0x65	/* Telf_coredump_extra_notes_write */
	.byte 0x15, 0xbf, 0x65, 0x6c, 0xa0, 0xfe, 0xf8, 0x64, 0x75, 0x6d, 0xe2, 0xd1, 0xea, 0x61, 0x5f, 0xb6, 0x9a, 0x73, 0xf6, 0x69, 0x7a, 0x65	/* T__pfx_elf_coredump_extra_notes_size */
	.byte 0x15, 0x54, 0x65, 0x6c, 0xa0, 0xfe, 0xf8, 0x64, 0x75, 0x6d, 0xe2, 0xd1, 0xea, 0x61, 0x5f, 0xb6, 0x9a, 0x73, 0xf6, 0x69, 0x7a, 0x65	/* Telf_coredump_extra_notes_size */
	.byte 0x08, 0xa8, 0xe7, 0xc8, 0xea, 0x2c, 0xda, 0xf8, 0x64	/* t__pfx_ptrace_triggered */
	.byte 0x07, 0x06, 0xc8, 0xea, 0x2c, 0xda, 0xf8, 0x64	/* tptrace_triggered */
	.byte 0x08, 0xa8, 0xe7, 0xc8, 0xb2, 0xe6, 0xa2, 0x67, 0x9f	/* t__pfx_ptrace_get_debugreg */
	.byte 0x07, 0x06, 0xc8, 0xb2, 0xe6, 0xa2, 0x67, 0x9f	/* tptrace_get_debugreg */
	.byte 0x09, 0xc6, 0xd9, 0x70, 0xee, 0xcd, 0xeb, 0xc2, 0x76, 0x65	/* t__pfx_ioperm_active */
	.byte 0x09, 0x74, 0xd9, 0x70, 0xee, 0xcd, 0xeb, 0xc2, 0x76, 0x65	/* tioperm_active */
	.byte 0x07, 0xa8, 0x1f, 0xc9, 0x67, 0x6d, 0xbb, 0x9f	/* t__pfx_set_segment_reg */
	.byte 0x08, 0x74, 0xc9, 0xf9, 0xc9, 0x67, 0x6d, 0xbb, 0x9f	/* tset_segment_reg */
	.byte 0x0d, 0xa8, 0xe7, 0xc8, 0x18, 0xcf, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0x74	/* t__pfx_ptrace_register_breakpoint */
	.byte 0x0c, 0x06, 0xc8, 0x18, 0xcf, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0x74	/* tptrace_register_breakpoint */
	.byte 0x0f, 0xa8, 0xe7, 0xc8, 0xc9, 0xf9, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0xf9, 0x10, 0x72	/* t__pfx_ptrace_set_breakpoint_addr */
	.byte 0x0e, 0x06, 0xc8, 0xc9, 0xf9, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0xf9, 0x10, 0x72	/* tptrace_set_breakpoint_addr */
	.byte 0x07, 0xc6, 0xd9, 0x70, 0xee, 0xcd, 0xda, 0x74	/* t__pfx_ioperm_get */
	.byte 0x07, 0x74, 0xd9, 0x70, 0xee, 0xcd, 0xda, 0x74	/* tioperm_get */
	.byte 0x0b, 0xa8, 0x1f, 0x66, 0x1b, 0x67, 0x73, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_set_flags.isra.0 */
	.byte 0x0c, 0x74, 0xc9, 0xf9, 0x66, 0x1b, 0x67, 0x73, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tset_flags.isra.0 */
	.byte 0x04, 0xa8, 0xe7, 0x5e, 0x9f	/* t__pfx_putreg */
	.byte 0x04, 0x74, 0xbe, 0x74, 0x9f	/* tputreg */
	.byte 0x07, 0xc6, 0x67, 0xe8, 0x9f, 0x73, 0xba, 0x74	/* t__pfx_genregs_set */
	.byte 0x07, 0x74, 0x67, 0xe8, 0x9f, 0x73, 0xba, 0x74	/* tgenregs_set */
	.byte 0x10, 0xa8, 0xe7, 0xc8, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0x74	/* t__pfx_ptrace_modify_breakpoint */
	.byte 0x0f, 0x06, 0xc8, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0x62, 0xf8, 0x61, 0x6b, 0x70, 0x6f, 0xf0, 0x74	/* tptrace_modify_breakpoint */
	.byte 0x09, 0xa8, 0xe7, 0xc8, 0xc9, 0xf9, 0xe6, 0xa2, 0x67, 0x9f	/* t__pfx_ptrace_set_debugreg */
	.byte 0x08, 0x06, 0xc8, 0xc9, 0xf9, 0xe6, 0xa2, 0x67, 0x9f	/* tptrace_set_debugreg */
	.byte 0x06, 0xa8, 0xe7, 0x5e, 0x9f, 0x33, 0x32	/* t__pfx_putreg32 */
	.byte 0x06, 0x74, 0xbe, 0x74, 0x9f, 0x33, 0x32	/* tputreg32 */
	.byte 0x09, 0xc6, 0x67, 0xe8, 0x9f, 0x73, 0x33, 0x32, 0xba, 0x74	/* t__pfx_genregs32_set */
	.byte 0x09, 0x74, 0x67, 0xe8, 0x9f, 0x73, 0x33, 0x32, 0xba, 0x74	/* tgenregs32_set */
	.byte 0x06, 0xc6, 0xb2, 0x66, 0x1b, 0x67, 0x73	/* t__pfx_get_flags */
	.byte 0x06, 0x74, 0xb2, 0x66, 0x1b, 0x67, 0x73	/* tget_flags */
	.byte 0x06, 0xc6, 0xda, 0x74, 0x9f, 0x33, 0x32	/* t__pfx_getreg32 */
	.byte 0x06, 0x74, 0xda, 0x74, 0x9f, 0x33, 0x32	/* tgetreg32 */
	.byte 0x0a, 0xc6, 0x67, 0xe8, 0x9f, 0x73, 0x33, 0x32, 0x5f, 0xda, 0x74	/* t__pfx_genregs32_get */
	.byte 0x0a, 0x74, 0x67, 0xe8, 0x9f, 0x73, 0x33, 0x32, 0x5f, 0xda, 0x74	/* tgenregs32_get */
	.byte 0x04, 0xc6, 0xda, 0x74, 0x9f	/* t__pfx_getreg */
	.byte 0x04, 0x74, 0xda, 0x74, 0x9f	/* tgetreg */
	.byte 0x07, 0xc6, 0x67, 0xe8, 0x9f, 0xe0, 0xda, 0x74	/* t__pfx_genregs_get */
	.byte 0x07, 0x74, 0x67, 0xe8, 0x9f, 0xe0, 0xda, 0x74	/* tgenregs_get */
	.byte 0x0d, 0xbf, 0x9f, 0xe0, 0x8e, 0xee, 0xc5, 0x18, 0xcf, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* T__pfx_regs_query_register_offset */
	.byte 0x0d, 0x54, 0x9f, 0xe0, 0x8e, 0xee, 0xc5, 0x18, 0xcf, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* Tregs_query_register_offset */
	.byte 0x0b, 0xbf, 0x9f, 0xe0, 0x8e, 0xee, 0xc5, 0x18, 0xcf, 0x6e, 0x61, 0xbd	/* T__pfx_regs_query_register_name */
	.byte 0x0b, 0x54, 0x9f, 0xe0, 0x8e, 0xee, 0xc5, 0x18, 0xcf, 0x6e, 0x61, 0xbd	/* Tregs_query_register_name */
	.byte 0x07, 0x3f, 0xe7, 0xc8, 0x64, 0xab, 0x80, 0xd3	/* T__pfx_ptrace_disable */
	.byte 0x07, 0x54, 0x70, 0xc8, 0x64, 0xab, 0x80, 0xd3	/* Tptrace_disable */
	.byte 0x05, 0xbf, 0xca, 0xd0, 0xe7, 0x01	/* T__pfx_arch_ptrace */
	.byte 0x05, 0x54, 0xca, 0xd0, 0xe7, 0x01	/* Tarch_ptrace */
	.byte 0x08, 0xbf, 0x09, 0x61, 0xf9, 0xca, 0xd0, 0xe7, 0x01	/* T__pfx_compat_arch_ptrace */
	.byte 0x08, 0x54, 0x09, 0x61, 0xf9, 0xca, 0xd0, 0xe7, 0x01	/* Tcompat_arch_ptrace */
	.byte 0x0d, 0xbf, 0xdb, 0x73, 0xd8, 0x5d, 0xcf, 0x9f, 0xc9, 0xf9, 0x76, 0x69, 0x65, 0x77	/* T__pfx_task_user_regset_view */
	.byte 0x0d, 0x54, 0xdb, 0x73, 0xd8, 0x5d, 0xcf, 0x9f, 0xc9, 0xf9, 0x76, 0x69, 0x65, 0x77	/* Ttask_user_regset_view */
	.byte 0x09, 0x3f, 0xf6, 0xe8, 0x64, 0xf6, 0x2c, 0xea, 0x61, 0x70	/* T__pfx_send_sigtrap */
	.byte 0x09, 0x54, 0x73, 0xe8, 0x64, 0xf6, 0x2c, 0xea, 0x61, 0x70	/* Tsend_sigtrap */
	.byte 0x0e, 0xbf, 0x5d, 0xee, 0xf6, 0xf0, 0x67, 0xb3, 0xd6, 0x65, 0xe2, 0xf8, 0x70, 0xce, 0x74	/* T__pfx_user_single_step_report */
	.byte 0x0e, 0x54, 0x5d, 0xee, 0xf6, 0xf0, 0x67, 0xb3, 0xd6, 0x65, 0xe2, 0xf8, 0x70, 0xce, 0x74	/* Tuser_single_step_report */
	.byte 0x0b, 0xc6, 0x74, 0x6c, 0xe0, 0xe6, 0x73, 0xd5, 0x6f, 0x6b, 0x61, 0x79	/* t__pfx_tls_desc_okay */
	.byte 0x0b, 0x74, 0x74, 0x6c, 0xe0, 0xe6, 0x73, 0xd5, 0x6f, 0x6b, 0x61, 0x79	/* ttls_desc_okay */
	.byte 0x08, 0xa8, 0x1f, 0x74, 0x6c, 0xe0, 0xe6, 0x73, 0x63	/* t__pfx_set_tls_desc */
	.byte 0x09, 0x74, 0xc9, 0xf9, 0x74, 0x6c, 0xe0, 0xe6, 0x73, 0x63	/* tset_tls_desc */
	.byte 0x09, 0xbf, 0xa9, 0x1f, 0x15, 0xf8, 0x05, 0x61, 0xf8, 0x61	/* T__pfx_do_set_thread_area */
	.byte 0x09, 0x54, 0xa9, 0x1f, 0x15, 0xf8, 0x05, 0x61, 0xf8, 0x61	/* Tdo_set_thread_area */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0x73, 0x1f, 0x15, 0xf8, 0x05, 0x61, 0xf8, 0x61	/* T__pfx___ia32_sys_set_thread_area */
	.byte 0x0e, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0x73, 0x1f, 0x15, 0xf8, 0x05, 0x61, 0xf8, 0x61	/* T__ia32_sys_set_thread_area */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0x73, 0x1f, 0x15, 0xf8, 0x05, 0x61, 0xf8, 0x61	/* T__pfx___x64_sys_set_thread_area */
	.byte 0x0d, 0x2f, 0x78, 0x36, 0x34, 0x95, 0x73, 0x1f, 0x15, 0xf8, 0x05, 0x61, 0xf8, 0x61	/* T__x64_sys_set_thread_area */
	.byte 0x0a, 0xbf, 0xa9, 0x5f, 0xb2, 0x15, 0xf8, 0x05, 0x61, 0xf8, 0x61	/* T__pfx_do_get_thread_area */
	.byte 0x0a, 0x54, 0xa9, 0x5f, 0xb2, 0x15, 0xf8, 0x05, 0x61, 0xf8, 0x61	/* Tdo_get_thread_area */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xb2, 0x15, 0xf8, 0x05, 0x61, 0xf8, 0x61	/* T__pfx___ia32_sys_get_thread_area */
	.byte 0x0e, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xb2, 0x15, 0xf8, 0x05, 0x61, 0xf8, 0x61	/* T__ia32_sys_get_thread_area */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xb2, 0x15, 0xf8, 0x05, 0x61, 0xf8, 0x61	/* T__pfx___x64_sys_get_thread_area */
	.byte 0x0d, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xb2, 0x15, 0xf8, 0x05, 0x61, 0xf8, 0x61	/* T__x64_sys_get_thread_area */
	.byte 0x0b, 0xbf, 0x9f, 0xc9, 0xf9, 0x74, 0x6c, 0xe0, 0xeb, 0xc2, 0x76, 0x65	/* T__pfx_regset_tls_active */
	.byte 0x0b, 0x54, 0x9f, 0xc9, 0xf9, 0x74, 0x6c, 0xe0, 0xeb, 0xc2, 0x76, 0x65	/* Tregset_tls_active */
	.byte 0x09, 0xbf, 0x9f, 0xc9, 0xf9, 0x74, 0x6c, 0xe0, 0xda, 0x74	/* T__pfx_regset_tls_get */
	.byte 0x09, 0x54, 0x9f, 0xc9, 0xf9, 0x74, 0x6c, 0xe0, 0xda, 0x74	/* Tregset_tls_get */
	.byte 0x09, 0xbf, 0x9f, 0xc9, 0xf9, 0x74, 0x6c, 0x73, 0xba, 0x74	/* T__pfx_regset_tls_set */
	.byte 0x09, 0x54, 0x9f, 0xc9, 0xf9, 0x74, 0x6c, 0x73, 0xba, 0x74	/* Tregset_tls_set */
	.byte 0x0c, 0xbf, 0x98, 0x76, 0xee, 0xf9, 0x69, 0xe2, 0xac, 0x5f, 0x88, 0x65, 0xca	/* T__pfx_convert_ip_to_linear */
	.byte 0x0c, 0x54, 0x98, 0x76, 0xee, 0xf9, 0x69, 0xe2, 0xac, 0x5f, 0x88, 0x65, 0xca	/* Tconvert_ip_to_linear */
	.byte 0x0a, 0x3f, 0x1f, 0xdb, 0x73, 0xd8, 0x62, 0x3c, 0xd6, 0x65, 0x70	/* T__pfx_set_task_blockstep */
	.byte 0x0b, 0x54, 0xc9, 0xf9, 0xdb, 0x73, 0xd8, 0x62, 0x3c, 0xd6, 0x65, 0x70	/* Tset_task_blockstep */
	.byte 0x07, 0xc6, 0xe8, 0x80, 0xb3, 0xd6, 0x65, 0x70	/* t__pfx_enable_step */
	.byte 0x07, 0x74, 0xe8, 0x80, 0xb3, 0xd6, 0x65, 0x70	/* tenable_step */
	.byte 0x0d, 0xbf, 0x5d, 0xcf, 0xe8, 0x80, 0xb3, 0x73, 0xf0, 0x67, 0xb3, 0xd6, 0x65, 0x70	/* T__pfx_user_enable_single_step */
	.byte 0x0d, 0x54, 0x5d, 0xcf, 0xe8, 0x80, 0xb3, 0x73, 0xf0, 0x67, 0xb3, 0xd6, 0x65, 0x70	/* Tuser_enable_single_step */
	.byte 0x0b, 0xbf, 0x5d, 0xcf, 0xe8, 0x80, 0xb3, 0x62, 0x3c, 0xf6, 0x9a, 0x70	/* T__pfx_user_enable_block_step */
	.byte 0x0b, 0x54, 0x5d, 0xcf, 0xe8, 0x80, 0xb3, 0x62, 0x3c, 0xf6, 0x9a, 0x70	/* Tuser_enable_block_step */
	.byte 0x0e, 0xbf, 0x5d, 0xcf, 0x64, 0xab, 0x80, 0xb3, 0x73, 0xf0, 0x67, 0xb3, 0xd6, 0x65, 0x70	/* T__pfx_user_disable_single_step */
	.byte 0x0e, 0x54, 0x5d, 0xcf, 0x64, 0xab, 0x80, 0xb3, 0x73, 0xf0, 0x67, 0xb3, 0xd6, 0x65, 0x70	/* Tuser_disable_single_step */
	.byte 0x0e, 0xc6, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0x97, 0xe8, 0xe6, 0x64, 0xf6, 0xd3, 0x65, 0x70	/* t__pfx_tboot_extended_sleep */
	.byte 0x0e, 0x74, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0x97, 0xe8, 0xe6, 0x64, 0xf6, 0xd3, 0x65, 0x70	/* ttboot_extended_sleep */
	.byte 0x0a, 0xc6, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0xdf, 0xa6, 0xf8, 0xc7	/* t__pfx_tboot_log_read */
	.byte 0x0a, 0x74, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0xdf, 0xa6, 0xf8, 0xc7	/* ttboot_log_read */
	.byte 0x0b, 0xc6, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0x64, 0x79, 0xf0, 0xa6, 0x92	/* t__pfx_tboot_dying_cpu */
	.byte 0x0b, 0x74, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0x64, 0x79, 0xf0, 0xa6, 0x92	/* ttboot_dying_cpu */
	.byte 0x0a, 0xbf, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0xe8, 0x80, 0xd3, 0x64	/* T__pfx_tboot_enabled */
	.byte 0x0a, 0x54, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0xe8, 0x80, 0xd3, 0x64	/* Ttboot_enabled */
	.byte 0x0c, 0xbf, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0x73, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* T__pfx_tboot_shutdown */
	.byte 0x0c, 0x54, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0x73, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* Ttboot_shutdown */
	.byte 0x0a, 0xc6, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0x73, 0xd3, 0x65, 0x70	/* t__pfx_tboot_sleep */
	.byte 0x0a, 0x74, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0x73, 0xd3, 0x65, 0x70	/* ttboot_sleep */
	.byte 0x0e, 0xbf, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0xb2, 0x64, 0xdd, 0x72, 0x5f, 0xdb, 0x62, 0xd3	/* T__pfx_tboot_get_dmar_table */
	.byte 0x0e, 0x54, 0x74, 0x62, 0x6f, 0x6f, 0xf9, 0xb2, 0x64, 0xdd, 0x72, 0x5f, 0xdb, 0x62, 0xd3	/* Ttboot_get_dmar_table */
	.byte 0x0b, 0xc6, 0x69, 0x38, 0x32, 0x33, 0x37, 0x41, 0x5f, 0xf8, 0xb7, 0xbd	/* t__pfx_i8237A_resume */
	.byte 0x0a, 0xc2, 0x38, 0x32, 0x33, 0x37, 0x41, 0x5f, 0xf8, 0xb7, 0xbd	/* ti8237A_resume */
	.byte 0x09, 0xbf, 0xca, 0xd0, 0x2a, 0xeb, 0xd8, 0x77, 0xe1, 0x6b	/* T__pfx_arch_stack_walk */
	.byte 0x09, 0x54, 0xca, 0xd0, 0x2a, 0xeb, 0xd8, 0x77, 0xe1, 0x6b	/* Tarch_stack_walk */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x2a, 0xeb, 0xd8, 0x77, 0xe1, 0xd8, 0xf8, 0x6c, 0x69, 0x80, 0xd3	/* T__pfx_arch_stack_walk_reliable */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x2a, 0xeb, 0xd8, 0x77, 0xe1, 0xd8, 0xf8, 0x6c, 0x69, 0x80, 0xd3	/* Tarch_stack_walk_reliable */
	.byte 0x0b, 0xbf, 0xca, 0xd0, 0x2a, 0xeb, 0xd8, 0x77, 0xe1, 0xd8, 0x5d, 0xee	/* T__pfx_arch_stack_walk_user */
	.byte 0x0b, 0x54, 0xca, 0xd0, 0x2a, 0xeb, 0xd8, 0x77, 0xe1, 0xd8, 0x5d, 0xee	/* Tarch_stack_walk_user */
	.byte 0x14, 0xc6, 0x63, 0xeb, 0x68, 0xfa, 0x70, 0x72, 0x69, 0x76, 0xa1, 0xe9, 0xea, 0xe0, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_cache_private_attrs_is_visible */
	.byte 0x13, 0x2d, 0xeb, 0x68, 0xfa, 0x70, 0x72, 0x69, 0x76, 0xa1, 0xe9, 0xea, 0xe0, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* tcache_private_attrs_is_visible */
	.byte 0x0c, 0xc6, 0x63, 0xeb, 0x68, 0xfa, 0x61, 0xe2, 0x6f, 0x66, 0x66, 0x88, 0x65	/* t__pfx_cache_ap_offline */
	.byte 0x0b, 0x2d, 0xeb, 0x68, 0xfa, 0x61, 0xe2, 0x6f, 0x66, 0x66, 0x88, 0x65	/* tcache_ap_offline */
	.byte 0x0b, 0xa8, 0xf6, 0x75, 0x62, 0x63, 0xeb, 0x68, 0x3b, 0xf6, 0xac, 0xf8	/* t__pfx_subcaches_store */
	.byte 0x0a, 0x74, 0xb7, 0x62, 0x63, 0xeb, 0x68, 0x3b, 0xf6, 0xac, 0xf8	/* tsubcaches_store */
	.byte 0x0a, 0xa8, 0xf6, 0x75, 0x62, 0x63, 0xeb, 0x68, 0x3b, 0xf6, 0x26	/* t__pfx_subcaches_show */
	.byte 0x09, 0x74, 0xb7, 0x62, 0x63, 0xeb, 0x68, 0x3b, 0xf6, 0x26	/* tsubcaches_show */
	.byte 0x0d, 0xc6, 0x61, 0x6d, 0xe5, 0xf0, 0x99, 0x6c, 0x33, 0x5f, 0x63, 0xeb, 0x68, 0x65	/* t__pfx_amd_init_l3_cache */
	.byte 0x0c, 0xdb, 0x6d, 0xe5, 0xf0, 0x99, 0x6c, 0x33, 0x5f, 0x63, 0xeb, 0x68, 0x65	/* tamd_init_l3_cache */
	.byte 0x0b, 0xc6, 0x63, 0xeb, 0x68, 0xfa, 0x61, 0xe2, 0x6f, 0x6e, 0x88, 0x65	/* t__pfx_cache_ap_online */
	.byte 0x0a, 0x2d, 0xeb, 0x68, 0xfa, 0x61, 0xe2, 0x6f, 0x6e, 0x88, 0x65	/* tcache_ap_online */
	.byte 0x14, 0xc6, 0x61, 0x6d, 0xe5, 0xb2, 0x6c, 0x33, 0x5f, 0x64, 0xab, 0x80, 0xb3, 0x73, 0xdf, 0x74, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_amd_get_l3_disable_slot.isra.0 */
	.byte 0x13, 0xdb, 0x6d, 0xe5, 0xb2, 0x6c, 0x33, 0x5f, 0x64, 0xab, 0x80, 0xb3, 0x73, 0xdf, 0x74, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tamd_get_l3_disable_slot.isra.0 */
	.byte 0x11, 0xa8, 0xf6, 0xad, 0xaa, 0x63, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xd3, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_show_cache_disable.isra.0 */
	.byte 0x11, 0x74, 0x73, 0xad, 0xaa, 0x63, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xd3, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tshow_cache_disable.isra.0 */
	.byte 0x0c, 0xc6, 0x63, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x30, 0xf6, 0x26	/* t__pfx_cache_disable_0_show */
	.byte 0x0b, 0x2d, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x30, 0xf6, 0x26	/* tcache_disable_0_show */
	.byte 0x0c, 0xc6, 0x63, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x31, 0xf6, 0x26	/* t__pfx_cache_disable_1_show */
	.byte 0x0b, 0x2d, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x31, 0xf6, 0x26	/* tcache_disable_1_show */
	.byte 0x0c, 0xa8, 0x2a, 0xce, 0xfa, 0x63, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xd3	/* t__pfx_store_cache_disable */
	.byte 0x0c, 0x74, 0xd6, 0xce, 0xfa, 0x63, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xd3	/* tstore_cache_disable */
	.byte 0x0d, 0xc6, 0x63, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x31, 0xf6, 0xac, 0xf8	/* t__pfx_cache_disable_1_store */
	.byte 0x0c, 0x2d, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x31, 0xf6, 0xac, 0xf8	/* tcache_disable_1_store */
	.byte 0x0d, 0xc6, 0x63, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x30, 0xf6, 0xac, 0xf8	/* t__pfx_cache_disable_0_store */
	.byte 0x0c, 0x2d, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x30, 0xf6, 0xac, 0xf8	/* tcache_disable_0_store */
	.byte 0x14, 0xc6, 0x66, 0xf0, 0xe5, 0x6e, 0x75, 0xcd, 0x63, 0xeb, 0x68, 0xfa, 0xd3, 0x61, 0x76, 0x3b, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_find_num_cache_leaves.isra.0 */
	.byte 0x14, 0x74, 0x66, 0xf0, 0xe5, 0x6e, 0x75, 0xcd, 0x63, 0xeb, 0x68, 0xfa, 0xd3, 0x61, 0x76, 0x3b, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tfind_num_cache_leaves.isra.0 */
	.byte 0x0e, 0xc6, 0x92, 0x89, 0x5c, 0x63, 0xeb, 0x68, 0xfa, 0xdf, 0x6f, 0x6b, 0x3a, 0x9f, 0x73	/* t__pfx_cpuid4_cache_lookup_regs */
	.byte 0x0e, 0x74, 0x92, 0x89, 0x5c, 0x63, 0xeb, 0x68, 0xfa, 0xdf, 0x6f, 0x6b, 0x3a, 0x9f, 0x73	/* tcpuid4_cache_lookup_regs */
	.byte 0x0d, 0xbf, 0x63, 0xeb, 0x68, 0xfa, 0xb2, 0x70, 0x72, 0x69, 0x76, 0x5f, 0x0d, 0xb9	/* T__pfx_cache_get_priv_group */
	.byte 0x0d, 0x54, 0x63, 0xeb, 0x68, 0xfa, 0xb2, 0x70, 0x72, 0x69, 0x76, 0x5f, 0x0d, 0xb9	/* Tcache_get_priv_group */
	.byte 0x12, 0xbf, 0x63, 0xeb, 0x68, 0x65, 0xf0, 0x66, 0x6f, 0x5f, 0x61, 0x6d, 0xe5, 0xf0, 0x99, 0x6c, 0x6c, 0xd5, 0x89	/* T__pfx_cacheinfo_amd_init_llc_id */
	.byte 0x12, 0x54, 0x63, 0xeb, 0x68, 0x65, 0xf0, 0x66, 0x6f, 0x5f, 0x61, 0x6d, 0xe5, 0xf0, 0x99, 0x6c, 0x6c, 0xd5, 0x89	/* Tcacheinfo_amd_init_llc_id */
	.byte 0x14, 0xbf, 0x63, 0xeb, 0x68, 0x65, 0xf0, 0x66, 0x6f, 0x5f, 0x68, 0x79, 0x67, 0x6f, 0x7c, 0xf0, 0x99, 0x6c, 0x6c, 0xd5, 0x89	/* T__pfx_cacheinfo_hygon_init_llc_id */
	.byte 0x14, 0x54, 0x63, 0xeb, 0x68, 0x65, 0xf0, 0x66, 0x6f, 0x5f, 0x68, 0x79, 0x67, 0x6f, 0x7c, 0xf0, 0x99, 0x6c, 0x6c, 0xd5, 0x89	/* Tcacheinfo_hygon_init_llc_id */
	.byte 0x0d, 0xbf, 0xf0, 0x99, 0x61, 0x6d, 0xe5, 0x63, 0xeb, 0x68, 0x65, 0xf0, 0x66, 0x6f	/* T__pfx_init_amd_cacheinfo */
	.byte 0x0d, 0x54, 0xf0, 0x99, 0x61, 0x6d, 0xe5, 0x63, 0xeb, 0x68, 0x65, 0xf0, 0x66, 0x6f	/* Tinit_amd_cacheinfo */
	.byte 0x0f, 0xbf, 0xf0, 0x99, 0x68, 0x79, 0x67, 0x6f, 0x7c, 0x63, 0xeb, 0x68, 0x65, 0xf0, 0x66, 0x6f	/* T__pfx_init_hygon_cacheinfo */
	.byte 0x0f, 0x54, 0xf0, 0x99, 0x68, 0x79, 0x67, 0x6f, 0x7c, 0x63, 0xeb, 0x68, 0x65, 0xf0, 0x66, 0x6f	/* Tinit_hygon_cacheinfo */
	.byte 0x0d, 0xbf, 0xf0, 0x99, 0xf0, 0x9a, 0xc3, 0x63, 0xeb, 0x68, 0x65, 0xf0, 0x66, 0x6f	/* T__pfx_init_intel_cacheinfo */
	.byte 0x0d, 0x54, 0xf0, 0x99, 0xf0, 0x9a, 0xc3, 0x63, 0xeb, 0x68, 0x65, 0xf0, 0x66, 0x6f	/* Tinit_intel_cacheinfo */
	.byte 0x0b, 0xbf, 0xf0, 0x99, 0x63, 0xeb, 0x68, 0xfa, 0xd3, 0x76, 0x65, 0x6c	/* T__pfx_init_cache_level */
	.byte 0x0b, 0x54, 0xf0, 0x99, 0x63, 0xeb, 0x68, 0xfa, 0xd3, 0x76, 0x65, 0x6c	/* Tinit_cache_level */
	.byte 0x0e, 0x3f, 0xe7, 0x6f, 0xbe, 0x6c, 0xa1, 0x63, 0xeb, 0x68, 0xfa, 0xd3, 0x61, 0x76, 0x3b	/* T__pfx_populate_cache_leaves */
	.byte 0x0e, 0x54, 0x70, 0x6f, 0xbe, 0x6c, 0xa1, 0x63, 0xeb, 0x68, 0xfa, 0xd3, 0x61, 0x76, 0x3b	/* Tpopulate_cache_leaves */
	.byte 0x09, 0xbf, 0x63, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xd3	/* T__pfx_cache_disable */
	.byte 0x09, 0x54, 0x63, 0xeb, 0x68, 0xfa, 0x64, 0xab, 0x80, 0xd3	/* Tcache_disable */
	.byte 0x08, 0xbf, 0x63, 0xeb, 0x68, 0xfa, 0xe8, 0x80, 0xd3	/* T__pfx_cache_enable */
	.byte 0x08, 0x54, 0x63, 0xeb, 0x68, 0xfa, 0xe8, 0x80, 0xd3	/* Tcache_enable */
	.byte 0x08, 0xc6, 0x63, 0xeb, 0x68, 0xfa, 0x92, 0x5f, 0x8d	/* t__pfx_cache_cpu_init */
	.byte 0x07, 0x2d, 0xeb, 0x68, 0xfa, 0x92, 0x5f, 0x8d	/* tcache_cpu_init */
	.byte 0x12, 0xc6, 0x63, 0xeb, 0x68, 0xfa, 0xf8, 0x6e, 0xe6, 0x7a, 0x76, 0x6f, 0x75, 0xe0, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_cache_rendezvous_handler */
	.byte 0x11, 0x2d, 0xeb, 0x68, 0xfa, 0xf8, 0x6e, 0xe6, 0x7a, 0x76, 0x6f, 0x75, 0xe0, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* tcache_rendezvous_handler */
	.byte 0x0f, 0x3f, 0x1f, 0x63, 0xeb, 0x68, 0xfa, 0x61, 0x70, 0xe0, 0xe6, 0x1b, 0x79, 0x65, 0xe5, 0x8d	/* T__pfx_set_cache_aps_delayed_init */
	.byte 0x10, 0x54, 0xc9, 0xf9, 0x63, 0xeb, 0x68, 0xfa, 0x61, 0x70, 0xe0, 0xe6, 0x1b, 0x79, 0x65, 0xe5, 0x8d	/* Tset_cache_aps_delayed_init */
	.byte 0x0f, 0xbf, 0xb2, 0x63, 0xeb, 0x68, 0xfa, 0x61, 0x70, 0xe0, 0xe6, 0x1b, 0x79, 0x65, 0xe5, 0x8d	/* T__pfx_get_cache_aps_delayed_init */
	.byte 0x0f, 0x54, 0xb2, 0x63, 0xeb, 0x68, 0xfa, 0x61, 0x70, 0xe0, 0xe6, 0x1b, 0x79, 0x65, 0xe5, 0x8d	/* Tget_cache_aps_delayed_init */
	.byte 0x0b, 0xbf, 0x63, 0xeb, 0x68, 0xfa, 0x62, 0xe2, 0xf8, 0xd6, 0x6f, 0xf8	/* T__pfx_cache_bp_restore */
	.byte 0x0b, 0x54, 0x63, 0xeb, 0x68, 0xfa, 0x62, 0xe2, 0xf8, 0xd6, 0x6f, 0xf8	/* Tcache_bp_restore */
	.byte 0x09, 0xbf, 0x63, 0xeb, 0x68, 0xfa, 0x61, 0x70, 0xe0, 0x8d	/* T__pfx_cache_aps_init */
	.byte 0x09, 0x54, 0x63, 0xeb, 0x68, 0xfa, 0x61, 0x70, 0xe0, 0x8d	/* Tcache_aps_init */
	.byte 0x11, 0xbf, 0xf0, 0x99, 0x73, 0x63, 0xe9, 0x9a, 0xf8, 0xe5, 0x92, 0x69, 0xe5, 0x66, 0x65, 0xe9, 0x75, 0x3d	/* T__pfx_init_scattered_cpuid_features */
	.byte 0x11, 0x54, 0xf0, 0x99, 0x73, 0x63, 0xe9, 0x9a, 0xf8, 0xe5, 0x92, 0x69, 0xe5, 0x66, 0x65, 0xe9, 0x75, 0x3d	/* Tinit_scattered_cpuid_features */
	.byte 0x07, 0xc6, 0xac, 0x70, 0x6f, 0x1f, 0x89, 0x73	/* t__pfx_topo_set_ids */
	.byte 0x07, 0x74, 0xac, 0x70, 0x6f, 0x1f, 0x89, 0x73	/* ttopo_set_ids */
	.byte 0x09, 0xa8, 0xe7, 0xca, 0x73, 0xfa, 0xd3, 0x67, 0xeb, 0x79	/* t__pfx_parse_legacy */
	.byte 0x08, 0x06, 0xca, 0x73, 0xfa, 0xd3, 0x67, 0xeb, 0x79	/* tparse_legacy */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x73, 0xfa, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0x79	/* t__pfx_parse_topology */
	.byte 0x0a, 0x06, 0xca, 0x73, 0xfa, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0x79	/* tparse_topology */
	.byte 0x0a, 0xbf, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0x79, 0x1f, 0xa9, 0x6d	/* T__pfx_topology_set_dom */
	.byte 0x0a, 0x54, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0x79, 0x1f, 0xa9, 0x6d	/* Ttopology_set_dom */
	.byte 0x0c, 0xbf, 0x92, 0xe7, 0xca, 0x73, 0xfa, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0x79	/* T__pfx_cpu_parse_topology */
	.byte 0x0c, 0x54, 0x92, 0xe7, 0xca, 0x73, 0xfa, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0x79	/* Tcpu_parse_topology */
	.byte 0x0e, 0xa8, 0xe7, 0xca, 0x73, 0xfa, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0xd3, 0x61, 0x66	/* t__pfx_parse_topology_leaf */
	.byte 0x0d, 0x06, 0xca, 0x73, 0xfa, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0xd3, 0x61, 0x66	/* tparse_topology_leaf */
	.byte 0x0d, 0xbf, 0x92, 0xe7, 0xca, 0x73, 0xfa, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0x97	/* T__pfx_cpu_parse_topology_ext */
	.byte 0x0d, 0x54, 0x92, 0xe7, 0xca, 0x73, 0xfa, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0x97	/* Tcpu_parse_topology_ext */
	.byte 0x0f, 0xbf, 0x92, 0xe7, 0xca, 0x73, 0xfa, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0x61, 0x6d, 0x64	/* T__pfx_cpu_parse_topology_amd */
	.byte 0x0f, 0x54, 0x92, 0xe7, 0xca, 0x73, 0xfa, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0x61, 0x6d, 0x64	/* Tcpu_parse_topology_amd */
	.byte 0x0f, 0xbf, 0x92, 0x5f, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0xb8, 0x78, 0x3a, 0x61, 0x6d, 0x64	/* T__pfx_cpu_topology_fixup_amd */
	.byte 0x0f, 0x54, 0x92, 0x5f, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0xb8, 0x78, 0x3a, 0x61, 0x6d, 0x64	/* Tcpu_topology_fixup_amd */
	.byte 0x09, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x6c, 0x6b, 0x67, 0x73	/* t__pfx_native_lkgs */
	.byte 0x09, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x6c, 0x6b, 0x67, 0x73	/* tnative_lkgs */
	.byte 0x0d, 0xbf, 0x63, 0x72, 0x5c, 0xb9, 0x64, 0xa1, 0xa7, 0x71, 0x73, 0x6f, 0x66, 0x66	/* T__pfx_cr4_update_irqsoff */
	.byte 0x0d, 0x54, 0x63, 0x72, 0x5c, 0xb9, 0x64, 0xa1, 0xa7, 0x71, 0x73, 0x6f, 0x66, 0x66	/* Tcr4_update_irqsoff */
	.byte 0x0b, 0xc6, 0x63, 0x72, 0x5c, 0x63, 0xd3, 0xca, 0x5f, 0x62, 0xe4, 0x73	/* t__pfx_cr4_clear_bits */
	.byte 0x0a, 0x2d, 0x72, 0x5c, 0x63, 0xd3, 0xca, 0x5f, 0x62, 0xe4, 0x73	/* tcr4_clear_bits */
	.byte 0x08, 0xc6, 0x63, 0x72, 0x34, 0x1f, 0x62, 0xe4, 0x73	/* t__pfx_cr4_set_bits */
	.byte 0x07, 0x2d, 0x72, 0x34, 0x1f, 0x62, 0xe4, 0x73	/* tcr4_set_bits */
	.byte 0x0b, 0xbf, 0x63, 0x72, 0x5c, 0xf8, 0xc7, 0xf6, 0x68, 0xc7, 0x6f, 0x77	/* T__pfx_cr4_read_shadow */
	.byte 0x0b, 0x54, 0x63, 0x72, 0x5c, 0xf8, 0xc7, 0xf6, 0x68, 0xc7, 0x6f, 0x77	/* Tcr4_read_shadow */
	.byte 0x0f, 0xc6, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0x66, 0xce, 0x63, 0x65, 0xe5, 0x63, 0x61, 0x70, 0x73	/* t__pfx_apply_forced_caps */
	.byte 0x0e, 0xdb, 0x70, 0x70, 0x6c, 0xc5, 0x66, 0xce, 0x63, 0x65, 0xe5, 0x63, 0x61, 0x70, 0x73	/* tapply_forced_caps */
	.byte 0x0a, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x63, 0x72, 0x30	/* T__pfx_native_write_cr0 */
	.byte 0x0a, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x63, 0x72, 0x30	/* Tnative_write_cr0 */
	.byte 0x0d, 0xc6, 0xb8, 0x6c, 0x74, 0xcf, 0x92, 0x69, 0xe5, 0x66, 0x65, 0xe9, 0x75, 0x3d	/* t__pfx_filter_cpuid_features */
	.byte 0x0d, 0x74, 0xb8, 0x6c, 0x74, 0xcf, 0x92, 0x69, 0xe5, 0x66, 0x65, 0xe9, 0x75, 0x3d	/* tfilter_cpuid_features */
	.byte 0x09, 0xbf, 0xdf, 0x05, 0xb8, 0x78, 0x84, 0x67, 0x64, 0x74	/* T__pfx_load_fixmap_gdt */
	.byte 0x09, 0x54, 0xdf, 0x05, 0xb8, 0x78, 0x84, 0x67, 0x64, 0x74	/* Tload_fixmap_gdt */
	.byte 0x0a, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x63, 0x72, 0x34	/* T__pfx_native_write_cr4 */
	.byte 0x0a, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x63, 0x72, 0x34	/* Tnative_write_cr4 */
	.byte 0x0b, 0xbf, 0xdf, 0x05, 0x64, 0x69, 0xf8, 0x63, 0xf9, 0x67, 0x64, 0x74	/* T__pfx_load_direct_gdt */
	.byte 0x0b, 0x54, 0xdf, 0x05, 0x64, 0x69, 0xf8, 0x63, 0xf9, 0x67, 0x64, 0x74	/* Tload_direct_gdt */
	.byte 0x0a, 0xc6, 0x77, 0x72, 0x20, 0x72, 0xc3, 0x63, 0x73, 0xdb, 0x72	/* t__pfx_wrmsrl_cstar */
	.byte 0x0a, 0x74, 0x77, 0x72, 0x20, 0x72, 0xc3, 0x63, 0x73, 0xdb, 0x72	/* twrmsrl_cstar */
	.byte 0x08, 0xc6, 0x89, 0xf9, 0xc1, 0x73, 0x28, 0xc3, 0x8d	/* t__pfx_idt_syscall_init */
	.byte 0x08, 0xc2, 0x64, 0xf9, 0xc1, 0x73, 0x28, 0xc3, 0x8d	/* tidt_syscall_init */
	.byte 0x05, 0xbf, 0x63, 0x72, 0x5c, 0x8d	/* T__pfx_cr4_init */
	.byte 0x05, 0x54, 0x63, 0x72, 0x5c, 0x8d	/* Tcr4_init */
	.byte 0x08, 0xbf, 0x63, 0x65, 0xf9, 0x64, 0xab, 0x80, 0xd3	/* T__pfx_cet_disable */
	.byte 0x08, 0x54, 0x63, 0x65, 0xf9, 0x64, 0xab, 0x80, 0xd3	/* Tcet_disable */
	.byte 0x0f, 0xbf, 0x92, 0x5f, 0xe6, 0x9a, 0x63, 0xf9, 0x63, 0xeb, 0x68, 0xfa, 0x73, 0x69, 0x7a, 0x3b	/* T__pfx_cpu_detect_cache_sizes */
	.byte 0x0f, 0x54, 0x92, 0x5f, 0xe6, 0x9a, 0x63, 0xf9, 0x63, 0xeb, 0x68, 0xfa, 0x73, 0x69, 0x7a, 0x3b	/* Tcpu_detect_cache_sizes */
	.byte 0x07, 0xc6, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x8d	/* t__pfx_default_init */
	.byte 0x07, 0x74, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x8d	/* tdefault_init */
	.byte 0x08, 0xbf, 0xb2, 0x92, 0x5f, 0x76, 0xe8, 0x64, 0xce	/* T__pfx_get_cpu_vendor */
	.byte 0x08, 0x54, 0xb2, 0x92, 0x5f, 0x76, 0xe8, 0x64, 0xce	/* Tget_cpu_vendor */
	.byte 0x06, 0xbf, 0x92, 0x5f, 0xe6, 0x9a, 0x7b	/* T__pfx_cpu_detect */
	.byte 0x06, 0x54, 0x92, 0x5f, 0xe6, 0x9a, 0x7b	/* Tcpu_detect */
	.byte 0x07, 0xbf, 0xb2, 0x92, 0x5f, 0x63, 0x61, 0x70	/* T__pfx_get_cpu_cap */
	.byte 0x07, 0x54, 0xb2, 0x92, 0x5f, 0x63, 0x61, 0x70	/* Tget_cpu_cap */
	.byte 0x0b, 0xbf, 0xb2, 0x92, 0x5f, 0x10, 0x3d, 0x73, 0xf6, 0x69, 0x7a, 0x3b	/* T__pfx_get_cpu_address_sizes */
	.byte 0x0b, 0x54, 0xb2, 0x92, 0x5f, 0x10, 0x3d, 0x73, 0xf6, 0x69, 0x7a, 0x3b	/* Tget_cpu_address_sizes */
	.byte 0x07, 0xc6, 0x89, 0xe8, 0xc2, 0x66, 0xc5, 0x92	/* t__pfx_identify_cpu */
	.byte 0x07, 0xc2, 0x64, 0xe8, 0xc2, 0x66, 0xc5, 0x92	/* tidentify_cpu */
	.byte 0x0f, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0xf8, 0x05, 0xca, 0xd0, 0x5f, 0x63, 0x61, 0xe2, 0x20, 0x72	/* T__pfx_x86_read_arch_cap_msr */
	.byte 0x0f, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xf8, 0x05, 0xca, 0xd0, 0x5f, 0x63, 0x61, 0xe2, 0x20, 0x72	/* Tx86_read_arch_cap_msr */
	.byte 0x10, 0xbf, 0x7e, 0x63, 0xd8, 0x6e, 0x0b, 0x6c, 0xba, 0xa6, 0x63, 0xd3, 0xca, 0xe0, 0x62, 0x61, 0xc9	/* T__pfx_check_null_seg_clears_base */
	.byte 0x10, 0x54, 0x7e, 0x63, 0xd8, 0x6e, 0x0b, 0x6c, 0xba, 0xa6, 0x63, 0xd3, 0xca, 0xe0, 0x62, 0x61, 0xc9	/* Tcheck_null_seg_clears_base */
	.byte 0x0c, 0xbf, 0x89, 0xe8, 0xc2, 0x66, 0x79, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x92	/* T__pfx_identify_secondary_cpu */
	.byte 0x0c, 0x54, 0x89, 0xe8, 0xc2, 0x66, 0x79, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x92	/* Tidentify_secondary_cpu */
	.byte 0x06, 0x3f, 0x95, 0x73, 0x28, 0xc3, 0x8d	/* T__pfx_syscall_init */
	.byte 0x06, 0x54, 0xc1, 0x73, 0x28, 0xc3, 0x8d	/* Tsyscall_init */
	.byte 0x11, 0xbf, 0x92, 0x5f, 0xf0, 0x99, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x7c, 0x68, 0xcc, 0x64, 0x88, 0x67	/* T__pfx_cpu_init_exception_handling */
	.byte 0x11, 0x54, 0x92, 0x5f, 0xf0, 0x99, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x7c, 0x68, 0xcc, 0x64, 0x88, 0x67	/* Tcpu_init_exception_handling */
	.byte 0x04, 0xbf, 0x92, 0x5f, 0x8d	/* T__pfx_cpu_init */
	.byte 0x04, 0x54, 0x92, 0x5f, 0x8d	/* Tcpu_init */
	.byte 0x09, 0xbf, 0xca, 0xd0, 0xf6, 0x6d, 0xf9, 0xb9, 0x64, 0x86	/* T__pfx_arch_smt_update */
	.byte 0x09, 0x54, 0xca, 0xd0, 0xf6, 0x6d, 0xf9, 0xb9, 0x64, 0x86	/* Tarch_smt_update */
	.byte 0x0c, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0xf0, 0x99, 0x72, 0x64, 0x72, 0xcc, 0x64	/* T__pfx_x86_init_rdrand */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xf0, 0x99, 0x72, 0x64, 0x72, 0xcc, 0x64	/* Tx86_init_rdrand */
	.byte 0x15, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x92, 0x5f, 0x68, 0x61, 0xe0, 0x6d, 0xf0, 0x5f, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0xf8, 0x76	/* T__pfx_x86_cpu_has_min_microcode_rev */
	.byte 0x15, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x92, 0x5f, 0x68, 0x61, 0xe0, 0x6d, 0xf0, 0x5f, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0xf8, 0x76	/* Tx86_cpu_has_min_microcode_rev */
	.byte 0x0a, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x6d, 0xe9, 0xd0, 0x5f, 0x92	/* T__pfx_x86_match_cpu */
	.byte 0x0a, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x6d, 0xe9, 0xd0, 0x5f, 0x92	/* Tx86_match_cpu */
	.byte 0x0d, 0xbf, 0x67, 0x64, 0xe0, 0x75, 0xfe, 0x64, 0xfa, 0x6d, 0xe4, 0x2c, 0x86, 0x64	/* T__pfx_gds_ucode_mitigated */
	.byte 0x0d, 0x54, 0x67, 0x64, 0xe0, 0x75, 0xfe, 0x64, 0xfa, 0x6d, 0xe4, 0x2c, 0x86, 0x64	/* Tgds_ucode_mitigated */
	.byte 0x0f, 0xc6, 0xab, 0xf6, 0x70, 0x65, 0xd5, 0x69, 0xdc, 0x5d, 0xcf, 0x98, 0xea, 0x7f, 0xd3, 0x64	/* t__pfx_is_spec_ib_user_controlled */
	.byte 0x0f, 0xc2, 0x73, 0xf6, 0x70, 0x65, 0xd5, 0x69, 0xdc, 0x5d, 0xcf, 0x98, 0xea, 0x7f, 0xd3, 0x64	/* tis_spec_ib_user_controlled */
	.byte 0x0f, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xa7, 0xf9, 0x73, 0x70, 0x65, 0xd5, 0x63, 0xea, 0x6c	/* T__pfx_x86_virt_spec_ctrl */
	.byte 0x0f, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x76, 0xa7, 0xf9, 0x73, 0x70, 0x65, 0xd5, 0x63, 0xea, 0x6c	/* Tx86_virt_spec_ctrl */
	.byte 0x0d, 0xc6, 0xdb, 0x73, 0xd8, 0xb9, 0x64, 0xa1, 0x73, 0x70, 0x65, 0xd5, 0xc2, 0x66	/* t__pfx_task_update_spec_tif */
	.byte 0x0d, 0x74, 0xdb, 0x73, 0xd8, 0xb9, 0x64, 0xa1, 0x73, 0x70, 0x65, 0xd5, 0xc2, 0x66	/* ttask_update_spec_tif */
	.byte 0x09, 0xc6, 0x69, 0x62, 0xe7, 0x72, 0x7b, 0x6c, 0xba, 0x74	/* t__pfx_ib_prctl_set */
	.byte 0x08, 0xc2, 0x62, 0xe7, 0x72, 0x7b, 0x6c, 0xba, 0x74	/* tib_prctl_set */
	.byte 0x0a, 0xa8, 0xf6, 0x73, 0x62, 0xe7, 0x72, 0x7b, 0x6c, 0xba, 0x74	/* t__pfx_ssb_prctl_set */
	.byte 0x0a, 0x74, 0x73, 0x73, 0x62, 0xe7, 0x72, 0x7b, 0x6c, 0xba, 0x74	/* tssb_prctl_set */
	.byte 0x0e, 0xc6, 0x92, 0xf6, 0xad, 0xaa, 0xfe, 0x6d, 0xa5, 0x6e, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_cpu_show_common.isra.0 */
	.byte 0x0e, 0x74, 0x92, 0xf6, 0xad, 0xaa, 0xfe, 0x6d, 0xa5, 0x6e, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tcpu_show_common.isra.0 */
	.byte 0x0b, 0xc6, 0xb9, 0x64, 0xa1, 0x73, 0x70, 0x65, 0xd5, 0x63, 0xea, 0x6c	/* t__pfx_update_spec_ctrl */
	.byte 0x0b, 0x74, 0xb9, 0x64, 0xa1, 0x73, 0x70, 0x65, 0xd5, 0x63, 0xea, 0x6c	/* tupdate_spec_ctrl */
	.byte 0x0a, 0xc6, 0xb9, 0x64, 0xa1, 0xd6, 0x69, 0x62, 0xe2, 0x20, 0x72	/* t__pfx_update_stibp_msr */
	.byte 0x0a, 0x74, 0xb9, 0x64, 0xa1, 0xd6, 0x69, 0x62, 0xe2, 0x20, 0x72	/* tupdate_stibp_msr */
	.byte 0x0f, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0x61, 0x6d, 0x64, 0xf6, 0x73, 0xdc, 0x64, 0xab, 0x80, 0xd3	/* t__pfx_x86_amd_ssb_disable */
	.byte 0x0f, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x61, 0x6d, 0x64, 0xf6, 0x73, 0xdc, 0x64, 0xab, 0x80, 0xd3	/* tx86_amd_ssb_disable */
	.byte 0x0d, 0xbf, 0xb9, 0x64, 0xa1, 0x73, 0x70, 0x65, 0xd5, 0x63, 0xea, 0xc3, 0x98, 0x64	/* T__pfx_update_spec_ctrl_cond */
	.byte 0x0d, 0x54, 0xb9, 0x64, 0xa1, 0x73, 0x70, 0x65, 0xd5, 0x63, 0xea, 0xc3, 0x98, 0x64	/* Tupdate_spec_ctrl_cond */
	.byte 0x0b, 0xbf, 0xb9, 0x64, 0xa1, 0x73, 0x72, 0x62, 0x64, 0xe0, 0x20, 0x72	/* T__pfx_update_srbds_msr */
	.byte 0x0b, 0x54, 0xb9, 0x64, 0xa1, 0x73, 0x72, 0x62, 0x64, 0xe0, 0x20, 0x72	/* Tupdate_srbds_msr */
	.byte 0x09, 0xbf, 0xb9, 0x64, 0xa1, 0x67, 0x64, 0xe0, 0x20, 0x72	/* T__pfx_update_gds_msr */
	.byte 0x09, 0x54, 0xb9, 0x64, 0xa1, 0x67, 0x64, 0xe0, 0x20, 0x72	/* Tupdate_gds_msr */
	.byte 0x0c, 0xbf, 0xf8, 0x06, 0x6f, 0x88, 0xfa, 0xa5, 0x64, 0x75, 0xb3, 0x6f, 0x6b	/* T__pfx_retpoline_module_ok */
	.byte 0x0c, 0x54, 0xf8, 0x06, 0x6f, 0x88, 0xfa, 0xa5, 0x64, 0x75, 0xb3, 0x6f, 0x6b	/* Tretpoline_module_ok */
	.byte 0x0d, 0xbf, 0xd4, 0x70, 0x72, 0x69, 0x76, 0x5f, 0x65, 0x40, 0xb6, 0xc2, 0x66, 0x79	/* T__pfx_unpriv_ebpf_notify */
	.byte 0x0d, 0x54, 0xd4, 0x70, 0x72, 0x69, 0x76, 0x5f, 0x65, 0x40, 0xb6, 0xc2, 0x66, 0x79	/* Tunpriv_ebpf_notify */
	.byte 0x0c, 0xbf, 0x92, 0x5f, 0xa2, 0x67, 0x73, 0xf6, 0x6d, 0xf9, 0xb9, 0x64, 0x86	/* T__pfx_cpu_bugs_smt_update */
	.byte 0x0c, 0x54, 0x92, 0x5f, 0xa2, 0x67, 0x73, 0xf6, 0x6d, 0xf9, 0xb9, 0x64, 0x86	/* Tcpu_bugs_smt_update */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0x6c, 0xf6, 0x70, 0x65, 0xd5, 0x63, 0xea, 0x6c, 0xba, 0x74	/* T__pfx_arch_prctl_spec_ctrl_set */
	.byte 0x10, 0x54, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0x6c, 0xf6, 0x70, 0x65, 0xd5, 0x63, 0xea, 0x6c, 0xba, 0x74	/* Tarch_prctl_spec_ctrl_set */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0xba, 0x63, 0x09, 0xf6, 0x70, 0x65, 0xd5, 0x6d, 0xe4, 0x2c, 0x86	/* T__pfx_arch_seccomp_spec_mitigate */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0xba, 0x63, 0x09, 0xf6, 0x70, 0x65, 0xd5, 0x6d, 0xe4, 0x2c, 0x86	/* Tarch_seccomp_spec_mitigate */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0x6c, 0xf6, 0x70, 0x65, 0xd5, 0x63, 0xea, 0xc3, 0xda, 0x74	/* T__pfx_arch_prctl_spec_ctrl_get */
	.byte 0x10, 0x54, 0xca, 0xd0, 0xe7, 0x72, 0x7b, 0x6c, 0xf6, 0x70, 0x65, 0xd5, 0x63, 0xea, 0xc3, 0xda, 0x74	/* Tarch_prctl_spec_ctrl_get */
	.byte 0x10, 0xbf, 0x78, 0x38, 0x36, 0xf6, 0x70, 0x65, 0xd5, 0x63, 0xea, 0x6c, 0xba, 0x74, 0x3a, 0x61, 0x70	/* T__pfx_x86_spec_ctrl_setup_ap */
	.byte 0x10, 0x54, 0x78, 0x38, 0x36, 0xf6, 0x70, 0x65, 0xd5, 0x63, 0xea, 0x6c, 0xba, 0x74, 0x3a, 0x61, 0x70	/* Tx86_spec_ctrl_setup_ap */
	.byte 0x0b, 0xbf, 0x92, 0xf6, 0xad, 0xaa, 0xbd, 0x6c, 0x74, 0xa9, 0x77, 0x6e	/* T__pfx_cpu_show_meltdown */
	.byte 0x0b, 0x54, 0x92, 0xf6, 0xad, 0xaa, 0xbd, 0x6c, 0x74, 0xa9, 0x77, 0x6e	/* Tcpu_show_meltdown */
	.byte 0x0c, 0xbf, 0x92, 0xf6, 0x26, 0xf6, 0x70, 0x65, 0x63, 0xea, 0xfa, 0x76, 0x31	/* T__pfx_cpu_show_spectre_v1 */
	.byte 0x0c, 0x54, 0x92, 0xf6, 0x26, 0xf6, 0x70, 0x65, 0x63, 0xea, 0xfa, 0x76, 0x31	/* Tcpu_show_spectre_v1 */
	.byte 0x0c, 0xbf, 0x92, 0xf6, 0x26, 0xf6, 0x70, 0x65, 0x63, 0xea, 0xfa, 0x76, 0x32	/* T__pfx_cpu_show_spectre_v2 */
	.byte 0x0c, 0x54, 0x92, 0xf6, 0x26, 0xf6, 0x70, 0x65, 0x63, 0xea, 0xfa, 0x76, 0x32	/* Tcpu_show_spectre_v2 */
	.byte 0x0f, 0xbf, 0x92, 0xf6, 0x26, 0xf6, 0x70, 0x65, 0x63, 0x2a, 0xce, 0xfa, 0x62, 0x27, 0x96, 0x73	/* T__pfx_cpu_show_spec_store_bypass */
	.byte 0x0f, 0x54, 0x92, 0xf6, 0x26, 0xf6, 0x70, 0x65, 0x63, 0x2a, 0xce, 0xfa, 0x62, 0x27, 0x96, 0x73	/* Tcpu_show_spec_store_bypass */
	.byte 0x09, 0xbf, 0x92, 0xf6, 0xad, 0xaa, 0x6c, 0x31, 0x74, 0x66	/* T__pfx_cpu_show_l1tf */
	.byte 0x09, 0x54, 0x92, 0xf6, 0xad, 0xaa, 0x6c, 0x31, 0x74, 0x66	/* Tcpu_show_l1tf */
	.byte 0x08, 0xbf, 0x92, 0xf6, 0xad, 0xaa, 0x6d, 0x64, 0x73	/* T__pfx_cpu_show_mds */
	.byte 0x08, 0x54, 0x92, 0xf6, 0xad, 0xaa, 0x6d, 0x64, 0x73	/* Tcpu_show_mds */
	.byte 0x0f, 0xbf, 0x92, 0xf6, 0xad, 0xaa, 0x74, 0x73, 0x1a, 0x61, 0xc1, 0x6e, 0xd5, 0x80, 0xce, 0x74	/* T__pfx_cpu_show_tsx_async_abort */
	.byte 0x0f, 0x54, 0x92, 0xf6, 0xad, 0xaa, 0x74, 0x73, 0x1a, 0x61, 0xc1, 0x6e, 0xd5, 0x80, 0xce, 0x74	/* Tcpu_show_tsx_async_abort */
	.byte 0x0d, 0xbf, 0x92, 0xf6, 0xad, 0xaa, 0xe4, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2, 0x68, 0xe4	/* T__pfx_cpu_show_itlb_multihit */
	.byte 0x0d, 0x54, 0x92, 0xf6, 0xad, 0xaa, 0xe4, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2, 0x68, 0xe4	/* Tcpu_show_itlb_multihit */
	.byte 0x09, 0xbf, 0x92, 0xf6, 0x26, 0xf6, 0x72, 0x62, 0x64, 0x73	/* T__pfx_cpu_show_srbds */
	.byte 0x09, 0x54, 0x92, 0xf6, 0x26, 0xf6, 0x72, 0x62, 0x64, 0x73	/* Tcpu_show_srbds */
	.byte 0x0d, 0xbf, 0x92, 0xf6, 0xad, 0xaa, 0x6d, 0x6d, 0xd9, 0x2a, 0xe1, 0xfa, 0x64, 0x0f	/* T__pfx_cpu_show_mmio_stale_data */
	.byte 0x0d, 0x54, 0x92, 0xf6, 0xad, 0xaa, 0x6d, 0x6d, 0xd9, 0x2a, 0xe1, 0xfa, 0x64, 0x0f	/* Tcpu_show_mmio_stale_data */
	.byte 0x0b, 0xbf, 0x92, 0xf6, 0xad, 0xaa, 0xf8, 0x74, 0x62, 0xd3, 0x65, 0x64	/* T__pfx_cpu_show_retbleed */
	.byte 0x0b, 0x54, 0x92, 0xf6, 0xad, 0xaa, 0xf8, 0x74, 0x62, 0xd3, 0x65, 0x64	/* Tcpu_show_retbleed */
	.byte 0x12, 0xbf, 0x92, 0xf6, 0x26, 0xf6, 0x70, 0x65, 0xd5, 0x72, 0xd6, 0xeb, 0xd8, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0x77	/* T__pfx_cpu_show_spec_rstack_overflow */
	.byte 0x12, 0x54, 0x92, 0xf6, 0x26, 0xf6, 0x70, 0x65, 0xd5, 0x72, 0xd6, 0xeb, 0xd8, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0x77	/* Tcpu_show_spec_rstack_overflow */
	.byte 0x08, 0xbf, 0x92, 0xf6, 0xad, 0xaa, 0x67, 0x64, 0x73	/* T__pfx_cpu_show_gds */
	.byte 0x08, 0x54, 0x92, 0xf6, 0xad, 0xaa, 0x67, 0x64, 0x73	/* Tcpu_show_gds */
	.byte 0x10, 0xbf, 0x92, 0xf6, 0xad, 0xaa, 0xf8, 0xa6, 0xb8, 0xb3, 0x64, 0x0f, 0xf6, 0x61, 0xb0, 0x88, 0x67	/* T__pfx_cpu_show_reg_file_data_sampling */
	.byte 0x10, 0x54, 0x92, 0xf6, 0xad, 0xaa, 0xf8, 0xa6, 0xb8, 0xb3, 0x64, 0x0f, 0xf6, 0x61, 0xb0, 0x88, 0x67	/* Tcpu_show_reg_file_data_sampling */
	.byte 0x09, 0x3f, 0xff, 0x5f, 0x77, 0xca, 0x7c, 0x15, 0xd4, 0x6b	/* T__pfx___warn_thunk */
	.byte 0x07, 0x2f, 0x77, 0xca, 0x7c, 0x15, 0xd4, 0x6b	/* T__warn_thunk */
	.byte 0x0b, 0xbf, 0xca, 0xd0, 0x1f, 0xdd, 0x1a, 0x87, 0x93, 0x72, 0xe9, 0xd9	/* T__pfx_arch_set_max_freq_ratio */
	.byte 0x0b, 0x54, 0xca, 0xd0, 0x1f, 0xdd, 0x1a, 0x87, 0x93, 0x72, 0xe9, 0xd9	/* Tarch_set_max_freq_ratio */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0xf6, 0x28, 0xfa, 0x92, 0x5f, 0x63, 0x61, 0x70, 0xeb, 0xe4, 0x79	/* T__pfx_arch_scale_cpu_capacity */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0xf6, 0x28, 0xfa, 0x92, 0x5f, 0x63, 0x61, 0x70, 0xeb, 0xe4, 0x79	/* Tarch_scale_cpu_capacity */
	.byte 0x0d, 0xc6, 0x87, 0x93, 0xf0, 0x76, 0xca, 0x69, 0xcc, 0x63, 0xfa, 0xe8, 0x80, 0xd3	/* t__pfx_freq_invariance_enable */
	.byte 0x0d, 0x74, 0x87, 0x93, 0xf0, 0x76, 0xca, 0x69, 0xcc, 0x63, 0xfa, 0xe8, 0x80, 0xd3	/* tfreq_invariance_enable */
	.byte 0x13, 0xc6, 0x64, 0xab, 0x80, 0xb3, 0x87, 0x93, 0xf0, 0x76, 0xca, 0x69, 0xcc, 0x63, 0xfa, 0x77, 0xce, 0x6b, 0x66, 0x6e	/* t__pfx_disable_freq_invariance_workfn */
	.byte 0x13, 0x74, 0x64, 0xab, 0x80, 0xb3, 0x87, 0x93, 0xf0, 0x76, 0xca, 0x69, 0xcc, 0x63, 0xfa, 0x77, 0xce, 0x6b, 0x66, 0x6e	/* tdisable_freq_invariance_workfn */
	.byte 0x0a, 0xc6, 0xf0, 0x99, 0xfe, 0xd4, 0x74, 0xcf, 0xf8, 0x66, 0x73	/* t__pfx_init_counter_refs */
	.byte 0x0a, 0x74, 0xf0, 0x99, 0xfe, 0xd4, 0x74, 0xcf, 0xf8, 0x66, 0x73	/* tinit_counter_refs */
	.byte 0x12, 0xbf, 0x87, 0x93, 0xf0, 0x76, 0xca, 0x69, 0xcc, 0x63, 0xfa, 0xc9, 0xf9, 0x70, 0xee, 0xa0, 0x72, 0xe9, 0xd9	/* T__pfx_freq_invariance_set_perf_ratio */
	.byte 0x12, 0x54, 0x87, 0x93, 0xf0, 0x76, 0xca, 0x69, 0xcc, 0x63, 0xfa, 0xc9, 0xf9, 0x70, 0xee, 0xa0, 0x72, 0xe9, 0xd9	/* Tfreq_invariance_set_perf_ratio */
	.byte 0x16, 0xbf, 0xca, 0xd0, 0x5f, 0xe8, 0x80, 0xb3, 0x68, 0x79, 0x62, 0x72, 0x69, 0xe5, 0x63, 0x61, 0x70, 0xeb, 0xe4, 0x79, 0xf6, 0x28, 0x65	/* T__pfx_arch_enable_hybrid_capacity_scale */
	.byte 0x16, 0x54, 0xca, 0xd0, 0x5f, 0xe8, 0x80, 0xb3, 0x68, 0x79, 0x62, 0x72, 0x69, 0xe5, 0x63, 0x61, 0x70, 0xeb, 0xe4, 0x79, 0xf6, 0x28, 0x65	/* Tarch_enable_hybrid_capacity_scale */
	.byte 0x0c, 0xbf, 0xca, 0xd0, 0x1f, 0x92, 0x5f, 0x63, 0x61, 0x70, 0xeb, 0xe4, 0x79	/* T__pfx_arch_set_cpu_capacity */
	.byte 0x0c, 0x54, 0xca, 0xd0, 0x1f, 0x92, 0x5f, 0x63, 0x61, 0x70, 0xeb, 0xe4, 0x79	/* Tarch_set_cpu_capacity */
	.byte 0x0b, 0xbf, 0xca, 0xd0, 0xf6, 0x28, 0xfa, 0x87, 0x93, 0xc2, 0x63, 0x6b	/* T__pfx_arch_scale_freq_tick */
	.byte 0x0b, 0x54, 0xca, 0xd0, 0xf6, 0x28, 0xfa, 0x87, 0x93, 0xc2, 0x63, 0x6b	/* Tarch_scale_freq_tick */
	.byte 0x0a, 0xbf, 0xca, 0xd0, 0x5f, 0x87, 0x93, 0xb2, 0x6f, 0x7c, 0x92	/* T__pfx_arch_freq_get_on_cpu */
	.byte 0x0a, 0x54, 0xca, 0xd0, 0x5f, 0x87, 0x93, 0xb2, 0x6f, 0x7c, 0x92	/* Tarch_freq_get_on_cpu */
	.byte 0x0c, 0xbf, 0x61, 0xe2, 0xf0, 0x99, 0x61, 0x70, 0xee, 0x66, 0xb0, 0xee, 0x66	/* T__pfx_ap_init_aperfmperf */
	.byte 0x0c, 0x54, 0x61, 0xe2, 0xf0, 0x99, 0x61, 0x70, 0xee, 0x66, 0xb0, 0xee, 0x66	/* Tap_init_aperfmperf */
	.byte 0x0c, 0xc6, 0xa9, 0x5f, 0x63, 0xd3, 0xca, 0x5f, 0x92, 0x5f, 0x63, 0x61, 0x70	/* t__pfx_do_clear_cpu_cap */
	.byte 0x0c, 0x74, 0xa9, 0x5f, 0x63, 0xd3, 0xca, 0x5f, 0x92, 0x5f, 0x63, 0x61, 0x70	/* tdo_clear_cpu_cap */
	.byte 0x0a, 0xbf, 0x63, 0xd3, 0xca, 0x5f, 0x92, 0x5f, 0x63, 0x61, 0x70	/* T__pfx_clear_cpu_cap */
	.byte 0x0a, 0x54, 0x63, 0xd3, 0xca, 0x5f, 0x92, 0x5f, 0x63, 0x61, 0x70	/* Tclear_cpu_cap */
	.byte 0x0d, 0x3f, 0xba, 0x74, 0x3a, 0x63, 0xd3, 0xca, 0x5f, 0x92, 0x5f, 0x63, 0x61, 0x70	/* T__pfx_setup_clear_cpu_cap */
	.byte 0x0d, 0x54, 0xc9, 0x74, 0x3a, 0x63, 0xd3, 0xca, 0x5f, 0x92, 0x5f, 0x63, 0x61, 0x70	/* Tsetup_clear_cpu_cap */
	.byte 0x08, 0xc6, 0xdd, 0x1a, 0xc2, 0x6d, 0xfa, 0x73, 0x26	/* t__pfx_max_time_show */
	.byte 0x08, 0x74, 0xdd, 0x1a, 0xc2, 0x6d, 0xfa, 0x73, 0x26	/* tmax_time_show */
	.byte 0x09, 0xc6, 0xe8, 0x80, 0xb3, 0x63, 0x30, 0x32, 0xf6, 0x26	/* t__pfx_enable_c02_show */
	.byte 0x09, 0x74, 0xe8, 0x80, 0xb3, 0x63, 0x30, 0x32, 0xf6, 0x26	/* tenable_c02_show */
	.byte 0x0a, 0xc6, 0xe8, 0x80, 0xb3, 0x63, 0x30, 0x32, 0xf6, 0xac, 0xf8	/* t__pfx_enable_c02_store */
	.byte 0x0a, 0x74, 0xe8, 0x80, 0xb3, 0x63, 0x30, 0x32, 0xf6, 0xac, 0xf8	/* tenable_c02_store */
	.byte 0x0b, 0xc6, 0x75, 0x6d, 0x13, 0x99, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* t__pfx_umwait_cpu_online */
	.byte 0x0b, 0x74, 0x75, 0x6d, 0x13, 0x99, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* tumwait_cpu_online */
	.byte 0x09, 0xc6, 0xdd, 0x1a, 0xc2, 0x6d, 0xfa, 0xd6, 0x6f, 0xf8	/* t__pfx_max_time_store */
	.byte 0x09, 0x74, 0xdd, 0x1a, 0xc2, 0x6d, 0xfa, 0xd6, 0x6f, 0xf8	/* tmax_time_store */
	.byte 0x0d, 0xc6, 0x75, 0x6d, 0x13, 0x99, 0xc1, 0x73, 0xfe, 0x72, 0xfa, 0xf8, 0xb7, 0xbd	/* t__pfx_umwait_syscore_resume */
	.byte 0x0d, 0x74, 0x75, 0x6d, 0x13, 0x99, 0xc1, 0x73, 0xfe, 0x72, 0xfa, 0xf8, 0xb7, 0xbd	/* tumwait_syscore_resume */
	.byte 0x0c, 0xc6, 0x75, 0x6d, 0x13, 0x99, 0x92, 0x5f, 0x6f, 0x66, 0x66, 0x88, 0x65	/* t__pfx_umwait_cpu_offline */
	.byte 0x0c, 0x74, 0x75, 0x6d, 0x13, 0x99, 0x92, 0x5f, 0x6f, 0x66, 0x66, 0x88, 0x65	/* tumwait_cpu_offline */
	.byte 0x0e, 0xc6, 0x75, 0x6d, 0x13, 0x99, 0xb9, 0x64, 0xa1, 0x98, 0xea, 0x6f, 0xc3, 0x20, 0x72	/* t__pfx_umwait_update_control_msr */
	.byte 0x0e, 0x74, 0x75, 0x6d, 0x13, 0x99, 0xb9, 0x64, 0xa1, 0x98, 0xea, 0x6f, 0xc3, 0x20, 0x72	/* tumwait_update_control_msr */
	.byte 0x08, 0xc6, 0xac, 0x70, 0x6f, 0x1f, 0x92, 0x89, 0x73	/* t__pfx_topo_set_cpuids */
	.byte 0x08, 0x74, 0xac, 0x70, 0x6f, 0x1f, 0x92, 0x89, 0x73	/* ttopo_set_cpuids */
	.byte 0x0f, 0xc6, 0x92, 0x5f, 0xdd, 0x72, 0x6b, 0xe7, 0x72, 0x69, 0xdd, 0x72, 0xc5, 0x15, 0xf8, 0xc7	/* t__pfx_cpu_mark_primary_thread */
	.byte 0x0f, 0x74, 0x92, 0x5f, 0xdd, 0x72, 0x6b, 0xe7, 0x72, 0x69, 0xdd, 0x72, 0xc5, 0x15, 0xf8, 0xc7	/* tcpu_mark_primary_thread */
	.byte 0x0a, 0xc6, 0xac, 0x70, 0x6f, 0x5f, 0xd4, 0x99, 0xfe, 0xd4, 0x74	/* t__pfx_topo_unit_count */
	.byte 0x0a, 0x74, 0xac, 0x70, 0x6f, 0x5f, 0xd4, 0x99, 0xfe, 0xd4, 0x74	/* ttopo_unit_count */
	.byte 0x0e, 0xbf, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0xb2, 0xdf, 0x67, 0xa3, 0xe1, 0x5f, 0x89	/* T__pfx_topology_get_logical_id */
	.byte 0x0e, 0x54, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0xb2, 0xdf, 0x67, 0xa3, 0xe1, 0x5f, 0x89	/* Ttopology_get_logical_id */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0x6d, 0xe9, 0xd0, 0x5f, 0x92, 0xe7, 0x68, 0x79, 0xe0, 0x89	/* T__pfx_arch_match_cpu_phys_id */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0x6d, 0xe9, 0xd0, 0x5f, 0x92, 0xe7, 0x68, 0x79, 0xe0, 0x89	/* Tarch_match_cpu_phys_id */
	.byte 0x0c, 0xbf, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0xd4, 0x99, 0xfe, 0xd4, 0x74	/* T__pfx_topology_unit_count */
	.byte 0x0c, 0x54, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0xd4, 0x99, 0xfe, 0xd4, 0x74	/* Ttopology_unit_count */
	.byte 0x0f, 0xbf, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0x61, 0x70, 0xa3	/* T__pfx_topology_hotplug_apic */
	.byte 0x0f, 0x54, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0x61, 0x70, 0xa3	/* Ttopology_hotplug_apic */
	.byte 0x11, 0xbf, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0xad, 0x74, 0xd4, 0x70, 0x6c, 0x75, 0xa6, 0x61, 0x70, 0xa3	/* T__pfx_topology_hotunplug_apic */
	.byte 0x11, 0x54, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0xc5, 0xad, 0x74, 0xd4, 0x70, 0x6c, 0x75, 0xa6, 0x61, 0x70, 0xa3	/* Ttopology_hotunplug_apic */
	.byte 0x05, 0xc6, 0x63, 0xf6, 0xac, 0x70	/* t__pfx_c_stop */
	.byte 0x04, 0x2d, 0xf6, 0xac, 0x70	/* tc_stop */
	.byte 0x08, 0xa8, 0xf6, 0xad, 0xaa, 0x92, 0xf0, 0x66, 0x6f	/* t__pfx_show_cpuinfo */
	.byte 0x08, 0x74, 0x73, 0xad, 0xaa, 0x92, 0xf0, 0x66, 0x6f	/* tshow_cpuinfo */
	.byte 0x06, 0xc6, 0x63, 0xf6, 0xdb, 0x72, 0x74	/* t__pfx_c_start */
	.byte 0x05, 0x2d, 0xf6, 0xdb, 0x72, 0x74	/* tc_start */
	.byte 0x04, 0xc6, 0xd5, 0x6e, 0x97	/* t__pfx_c_next */
	.byte 0x04, 0x74, 0xd5, 0x6e, 0x97	/* tc_next */
	.byte 0x0e, 0xbf, 0xf0, 0x99, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0x65, 0x61, 0xf9, 0x7b, 0x6c	/* T__pfx_init_ia32_feat_ctl */
	.byte 0x0e, 0x54, 0xf0, 0x99, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x66, 0x65, 0x61, 0xf9, 0x7b, 0x6c	/* Tinit_ia32_feat_ctl */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* t__pfx_paravirt_read_msr */
	.byte 0x0a, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* tparavirt_read_msr */
	.byte 0x09, 0xc6, 0x62, 0x73, 0xe2, 0xf0, 0x99, 0xf0, 0x9a, 0x6c	/* t__pfx_bsp_init_intel */
	.byte 0x09, 0x74, 0x62, 0x73, 0xe2, 0xf0, 0x99, 0xf0, 0x9a, 0x6c	/* tbsp_init_intel */
	.byte 0x0b, 0xc6, 0xf0, 0x9a, 0xc3, 0xe6, 0x9a, 0x63, 0xf9, 0x74, 0x6c, 0x62	/* t__pfx_intel_detect_tlb */
	.byte 0x0b, 0x74, 0xf0, 0x9a, 0xc3, 0xe6, 0x9a, 0x63, 0xf9, 0x74, 0x6c, 0x62	/* tintel_detect_tlb */
	.byte 0x0a, 0xa8, 0xf6, 0x70, 0x6c, 0x99, 0xc0, 0xd8, 0x77, 0xca, 0x6e	/* t__pfx_split_lock_warn */
	.byte 0x0a, 0x74, 0x73, 0x70, 0x6c, 0x99, 0xc0, 0xd8, 0x77, 0xca, 0x6e	/* tsplit_lock_warn */
	.byte 0x0e, 0xbf, 0x68, 0xcc, 0x64, 0xb3, 0x67, 0x75, 0x3b, 0xf9, 0x73, 0x70, 0x6c, 0x99, 0x3c	/* T__pfx_handle_guest_split_lock */
	.byte 0x0e, 0x54, 0x68, 0xcc, 0x64, 0xb3, 0x67, 0x75, 0x3b, 0xf9, 0x73, 0x70, 0x6c, 0x99, 0x3c	/* Thandle_guest_split_lock */
	.byte 0x0e, 0xa8, 0xf6, 0x70, 0x6c, 0xe4, 0xc0, 0xd8, 0x92, 0x5f, 0x6f, 0x66, 0x66, 0x88, 0x65	/* t__pfx_splitlock_cpu_offline */
	.byte 0x0e, 0x74, 0x73, 0x70, 0x6c, 0xe4, 0xc0, 0xd8, 0x92, 0x5f, 0x6f, 0x66, 0x66, 0x88, 0x65	/* tsplitlock_cpu_offline */
	.byte 0x0b, 0x29, 0xf6, 0x70, 0x6c, 0x99, 0xc0, 0xd8, 0xf8, 0xe8, 0x80, 0xd3	/* t__pfx___split_lock_reenable */
	.byte 0x0c, 0x74, 0xff, 0x73, 0x70, 0x6c, 0x99, 0xc0, 0xd8, 0xf8, 0xe8, 0x80, 0xd3	/* t__split_lock_reenable */
	.byte 0x0d, 0x29, 0xf6, 0x70, 0x6c, 0x99, 0xc0, 0xd8, 0xf8, 0xe8, 0x80, 0xb3, 0xd4, 0x3c	/* t__pfx___split_lock_reenable_unlock */
	.byte 0x0e, 0x74, 0xff, 0x73, 0x70, 0x6c, 0x99, 0xc0, 0xd8, 0xf8, 0xe8, 0x80, 0xb3, 0xd4, 0x3c	/* t__split_lock_reenable_unlock */
	.byte 0x0e, 0xa8, 0xf6, 0x70, 0x6c, 0x99, 0xc0, 0xd8, 0x76, 0xee, 0x69, 0x66, 0xc5, 0x20, 0x72	/* t__pfx_split_lock_verify_msr */
	.byte 0x0e, 0x74, 0x73, 0x70, 0x6c, 0x99, 0xc0, 0xd8, 0x76, 0xee, 0x69, 0x66, 0xc5, 0x20, 0x72	/* tsplit_lock_verify_msr */
	.byte 0x0a, 0xc6, 0x65, 0xca, 0x6c, 0xc5, 0xf0, 0x99, 0xf0, 0x9a, 0x6c	/* t__pfx_early_init_intel */
	.byte 0x09, 0x9a, 0xca, 0x6c, 0xc5, 0xf0, 0x99, 0xf0, 0x9a, 0x6c	/* tearly_init_intel */
	.byte 0x06, 0xc6, 0xf0, 0x99, 0xf0, 0x9a, 0x6c	/* t__pfx_init_intel */
	.byte 0x06, 0x74, 0xf0, 0x99, 0xf0, 0x9a, 0x6c	/* tinit_intel */
	.byte 0x0e, 0xbf, 0xf0, 0x9a, 0xc3, 0xd4, 0xc0, 0xd8, 0x92, 0x69, 0xe5, 0xd3, 0x61, 0x66, 0x73	/* T__pfx_intel_unlock_cpuid_leafs */
	.byte 0x0e, 0x54, 0xf0, 0x9a, 0xc3, 0xd4, 0xc0, 0xd8, 0x92, 0x69, 0xe5, 0xd3, 0x61, 0x66, 0x73	/* Tintel_unlock_cpuid_leafs */
	.byte 0x0c, 0xbf, 0x68, 0xcc, 0x64, 0xb3, 0x5d, 0xee, 0xf6, 0x70, 0x6c, 0x99, 0x3c	/* T__pfx_handle_user_split_lock */
	.byte 0x0c, 0x54, 0x68, 0xcc, 0x64, 0xb3, 0x5d, 0xee, 0xf6, 0x70, 0x6c, 0x99, 0x3c	/* Thandle_user_split_lock */
	.byte 0x08, 0xbf, 0x68, 0xcc, 0x64, 0xb3, 0xa2, 0xe0, 0x3c	/* T__pfx_handle_bus_lock */
	.byte 0x08, 0x54, 0x68, 0xcc, 0x64, 0xb3, 0xa2, 0xe0, 0x3c	/* Thandle_bus_lock */
	.byte 0x10, 0xbf, 0xb2, 0x15, 0x69, 0xe0, 0x68, 0x79, 0x62, 0x72, 0x69, 0xe5, 0x92, 0x5f, 0x74, 0x27, 0x65	/* T__pfx_get_this_hybrid_cpu_type */
	.byte 0x10, 0x54, 0xb2, 0x15, 0x69, 0xe0, 0x68, 0x79, 0x62, 0x72, 0x69, 0xe5, 0x92, 0x5f, 0x74, 0x27, 0x65	/* Tget_this_hybrid_cpu_type */
	.byte 0x08, 0xc6, 0x74, 0x73, 0x1a, 0x64, 0xab, 0x80, 0xd3	/* t__pfx_tsx_disable */
	.byte 0x08, 0x74, 0x74, 0x73, 0x1a, 0x64, 0xab, 0x80, 0xd3	/* ttsx_disable */
	.byte 0x07, 0xc6, 0x74, 0x73, 0x1a, 0xe8, 0x80, 0xd3	/* t__pfx_tsx_enable */
	.byte 0x07, 0x74, 0x74, 0x73, 0x1a, 0xe8, 0x80, 0xd3	/* ttsx_enable */
	.byte 0x0a, 0xc6, 0x74, 0x73, 0x1a, 0x63, 0xd3, 0xca, 0x5f, 0x92, 0x89	/* t__pfx_tsx_clear_cpuid */
	.byte 0x0a, 0x74, 0x74, 0x73, 0x1a, 0x63, 0xd3, 0xca, 0x5f, 0x92, 0x89	/* ttsx_clear_cpuid */
	.byte 0x0c, 0xc6, 0x74, 0x73, 0x1a, 0x19, 0xa5, 0x64, 0xfa, 0x64, 0xab, 0x80, 0xd3	/* t__pfx_tsx_dev_mode_disable */
	.byte 0x0c, 0x74, 0x74, 0x73, 0x1a, 0x19, 0xa5, 0x64, 0xfa, 0x64, 0xab, 0x80, 0xd3	/* ttsx_dev_mode_disable */
	.byte 0x07, 0xbf, 0x74, 0x73, 0x1a, 0x61, 0xe2, 0x8d	/* T__pfx_tsx_ap_init */
	.byte 0x07, 0x54, 0x74, 0x73, 0x1a, 0x61, 0xe2, 0x8d	/* Ttsx_ap_init */
	.byte 0x0e, 0xc6, 0xe8, 0xee, 0x67, 0x79, 0xe7, 0xee, 0xa0, 0x62, 0x69, 0x96, 0xf6, 0xac, 0xf8	/* t__pfx_energy_perf_bias_store */
	.byte 0x0e, 0x74, 0xe8, 0xee, 0x67, 0x79, 0xe7, 0xee, 0xa0, 0x62, 0x69, 0x96, 0xf6, 0xac, 0xf8	/* tenergy_perf_bias_store */
	.byte 0x0d, 0xc6, 0xe8, 0xee, 0x67, 0x79, 0xe7, 0xee, 0xa0, 0x62, 0x69, 0x96, 0xf6, 0x26	/* t__pfx_energy_perf_bias_show */
	.byte 0x0d, 0x74, 0xe8, 0xee, 0x67, 0x79, 0xe7, 0xee, 0xa0, 0x62, 0x69, 0x96, 0xf6, 0x26	/* tenergy_perf_bias_show */
	.byte 0x0b, 0xc6, 0xf0, 0x9a, 0xc3, 0x65, 0x70, 0xdc, 0xf8, 0xd6, 0x6f, 0xf8	/* t__pfx_intel_epb_restore */
	.byte 0x0b, 0x74, 0xf0, 0x9a, 0xc3, 0x65, 0x70, 0xdc, 0xf8, 0xd6, 0x6f, 0xf8	/* tintel_epb_restore */
	.byte 0x0b, 0xc6, 0xf0, 0x9a, 0xc3, 0x65, 0x70, 0xdc, 0x6f, 0x6e, 0x88, 0x65	/* t__pfx_intel_epb_online */
	.byte 0x0b, 0x74, 0xf0, 0x9a, 0xc3, 0x65, 0x70, 0xdc, 0x6f, 0x6e, 0x88, 0x65	/* tintel_epb_online */
	.byte 0x0b, 0xc6, 0xf0, 0x9a, 0xc3, 0x65, 0x70, 0x62, 0xf6, 0x61, 0x76, 0x65	/* t__pfx_intel_epb_save */
	.byte 0x0b, 0x74, 0xf0, 0x9a, 0xc3, 0x65, 0x70, 0x62, 0xf6, 0x61, 0x76, 0x65	/* tintel_epb_save */
	.byte 0x0c, 0xc6, 0xf0, 0x9a, 0xc3, 0x65, 0x70, 0xdc, 0x6f, 0x66, 0x66, 0x88, 0x65	/* t__pfx_intel_epb_offline */
	.byte 0x0c, 0x74, 0xf0, 0x9a, 0xc3, 0x65, 0x70, 0xdc, 0x6f, 0x66, 0x66, 0x88, 0x65	/* tintel_epb_offline */
	.byte 0x0d, 0xbf, 0x61, 0x6d, 0xe5, 0xb2, 0x64, 0x72, 0x5f, 0x10, 0x72, 0x5f, 0xdd, 0x16	/* T__pfx_amd_get_dr_addr_mask */
	.byte 0x0d, 0x54, 0x61, 0x6d, 0xe5, 0xb2, 0x64, 0x72, 0x5f, 0x10, 0x72, 0x5f, 0xdd, 0x16	/* Tamd_get_dr_addr_mask */
	.byte 0x0e, 0xc6, 0x7a, 0xe8, 0x32, 0x5f, 0x7a, 0xe8, 0x62, 0xd3, 0x65, 0xe5, 0x7e, 0x63, 0x6b	/* t__pfx_zen2_zenbleed_check */
	.byte 0x0e, 0x74, 0x7a, 0xe8, 0x32, 0x5f, 0x7a, 0xe8, 0x62, 0xd3, 0x65, 0xe5, 0x7e, 0x63, 0x6b	/* tzen2_zenbleed_check */
	.byte 0x0b, 0xc6, 0x7a, 0xe8, 0x62, 0xd3, 0x65, 0xe5, 0x7e, 0x63, 0xd8, 0x92	/* t__pfx_zenbleed_check_cpu */
	.byte 0x0b, 0x74, 0x7a, 0xe8, 0x62, 0xd3, 0x65, 0xe5, 0x7e, 0x63, 0xd8, 0x92	/* tzenbleed_check_cpu */
	.byte 0x0c, 0xc6, 0xb8, 0x1a, 0xee, 0x72, 0xe9, 0x75, 0xcd, 0x31, 0x33, 0x38, 0x36	/* t__pfx_fix_erratum_1386 */
	.byte 0x0c, 0x74, 0xb8, 0x1a, 0xee, 0x72, 0xe9, 0x75, 0xcd, 0x31, 0x33, 0x38, 0x36	/* tfix_erratum_1386 */
	.byte 0x0f, 0xc6, 0x63, 0xd3, 0xca, 0x5f, 0x72, 0x64, 0x72, 0xcc, 0xe5, 0x92, 0x69, 0xe5, 0x62, 0xe4	/* t__pfx_clear_rdrand_cpuid_bit */
	.byte 0x0e, 0x2d, 0xd3, 0xca, 0x5f, 0x72, 0x64, 0x72, 0xcc, 0xe5, 0x92, 0x69, 0xe5, 0x62, 0xe4	/* tclear_rdrand_cpuid_bit */
	.byte 0x0a, 0xc6, 0x65, 0xca, 0x6c, 0xc5, 0xf0, 0x99, 0x61, 0x6d, 0x64	/* t__pfx_early_init_amd */
	.byte 0x09, 0x9a, 0xca, 0x6c, 0xc5, 0xf0, 0x99, 0x61, 0x6d, 0x64	/* tearly_init_amd */
	.byte 0x0d, 0xc6, 0x92, 0x5f, 0xe6, 0x9a, 0x63, 0xf9, 0x74, 0x6c, 0xdc, 0x61, 0x6d, 0x64	/* t__pfx_cpu_detect_tlb_amd */
	.byte 0x0d, 0x74, 0x92, 0x5f, 0xe6, 0x9a, 0x63, 0xf9, 0x74, 0x6c, 0xdc, 0x61, 0x6d, 0x64	/* tcpu_detect_tlb_amd */
	.byte 0x09, 0xc6, 0x62, 0x73, 0xe2, 0xf0, 0x99, 0x61, 0x6d, 0x64	/* t__pfx_bsp_init_amd */
	.byte 0x09, 0x74, 0x62, 0x73, 0xe2, 0xf0, 0x99, 0x61, 0x6d, 0x64	/* tbsp_init_amd */
	.byte 0x0e, 0xbf, 0xf0, 0x99, 0x73, 0x70, 0x65, 0x63, 0xea, 0xe1, 0x5f, 0xd0, 0xa3, 0x6b, 0xe8	/* T__pfx_init_spectral_chicken */
	.byte 0x0e, 0x54, 0xf0, 0x99, 0x73, 0x70, 0x65, 0x63, 0xea, 0xe1, 0x5f, 0xd0, 0xa3, 0x6b, 0xe8	/* Tinit_spectral_chicken */
	.byte 0x06, 0xc6, 0xf0, 0x99, 0x61, 0x6d, 0x64	/* t__pfx_init_amd */
	.byte 0x06, 0x74, 0xf0, 0x99, 0x61, 0x6d, 0x64	/* tinit_amd */
	.byte 0x0d, 0xbf, 0x61, 0x6d, 0x64, 0x1f, 0x64, 0x72, 0x5f, 0x10, 0x72, 0x5f, 0xdd, 0x16	/* T__pfx_amd_set_dr_addr_mask */
	.byte 0x0d, 0x54, 0x61, 0x6d, 0x64, 0x1f, 0x64, 0x72, 0x5f, 0x10, 0x72, 0x5f, 0xdd, 0x16	/* Tamd_set_dr_addr_mask */
	.byte 0x0c, 0xbf, 0x61, 0x6d, 0xe5, 0x7e, 0x63, 0xd8, 0x6d, 0xa3, 0xde, 0xfe, 0xe6	/* T__pfx_amd_check_microcode */
	.byte 0x0c, 0x54, 0x61, 0x6d, 0xe5, 0x7e, 0x63, 0xd8, 0x6d, 0xa3, 0xde, 0xfe, 0xe6	/* Tamd_check_microcode */
	.byte 0x0c, 0xc6, 0x65, 0xca, 0x6c, 0xc5, 0xf0, 0x99, 0x68, 0x79, 0x67, 0x6f, 0x6e	/* t__pfx_early_init_hygon */
	.byte 0x0b, 0x9a, 0xca, 0x6c, 0xc5, 0xf0, 0x99, 0x68, 0x79, 0x67, 0x6f, 0x6e	/* tearly_init_hygon */
	.byte 0x08, 0xc6, 0xf0, 0x99, 0x68, 0x79, 0x67, 0x6f, 0x6e	/* t__pfx_init_hygon */
	.byte 0x08, 0x74, 0xf0, 0x99, 0x68, 0x79, 0x67, 0x6f, 0x6e	/* tinit_hygon */
	.byte 0x0b, 0xc6, 0x62, 0x73, 0xe2, 0xf0, 0x99, 0x68, 0x79, 0x67, 0x6f, 0x6e	/* t__pfx_bsp_init_hygon */
	.byte 0x0b, 0x74, 0x62, 0x73, 0xe2, 0xf0, 0x99, 0x68, 0x79, 0x67, 0x6f, 0x6e	/* tbsp_init_hygon */
	.byte 0x0f, 0xc6, 0x92, 0x5f, 0xe6, 0x9a, 0x63, 0xf9, 0x74, 0x6c, 0xdc, 0x68, 0x79, 0x67, 0x6f, 0x6e	/* t__pfx_cpu_detect_tlb_hygon */
	.byte 0x0f, 0x74, 0x92, 0x5f, 0xe6, 0x9a, 0x63, 0xf9, 0x74, 0x6c, 0xdc, 0x68, 0x79, 0x67, 0x6f, 0x6e	/* tcpu_detect_tlb_hygon */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* t__pfx_paravirt_read_msr */
	.byte 0x0a, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* tparavirt_read_msr */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72	/* t__pfx_paravirt_write_msr */
	.byte 0x0a, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72	/* tparavirt_write_msr */
	.byte 0x0b, 0xc6, 0x65, 0xca, 0x6c, 0xc5, 0xf0, 0x99, 0x63, 0xe8, 0xdb, 0x1d	/* t__pfx_early_init_centaur */
	.byte 0x0a, 0x9a, 0xca, 0x6c, 0xc5, 0xf0, 0x99, 0x63, 0xe8, 0xdb, 0x1d	/* tearly_init_centaur */
	.byte 0x07, 0xc6, 0xf0, 0x99, 0x63, 0xe8, 0xdb, 0x1d	/* t__pfx_init_centaur */
	.byte 0x07, 0x74, 0xf0, 0x99, 0x63, 0xe8, 0xdb, 0x1d	/* tinit_centaur */
	.byte 0x0d, 0xc6, 0x65, 0xca, 0x6c, 0xc5, 0xf0, 0x99, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0	/* t__pfx_early_init_zhaoxin */
	.byte 0x0c, 0x9a, 0xca, 0x6c, 0xc5, 0xf0, 0x99, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0	/* tearly_init_zhaoxin */
	.byte 0x12, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_paravirt_write_msr.constprop.0 */
	.byte 0x11, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tparavirt_write_msr.constprop.0 */
	.byte 0x12, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_paravirt_read_msr.constprop.0 */
	.byte 0x11, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tparavirt_read_msr.constprop.0 */
	.byte 0x09, 0xc6, 0xf0, 0x99, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0	/* t__pfx_init_zhaoxin */
	.byte 0x09, 0x74, 0xf0, 0x99, 0x7a, 0x68, 0x61, 0x6f, 0x78, 0xf0	/* tinit_zhaoxin */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x6d, 0x63, 0xfa, 0xf8, 0xfe, 0x72, 0x64	/* T__pfx___traceiter_mce_record */
	.byte 0x0b, 0x2f, 0x01, 0xe4, 0xcf, 0x6d, 0x63, 0xfa, 0xf8, 0xfe, 0x72, 0x64	/* T__traceiter_mce_record */
	.byte 0x0e, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x6d, 0x63, 0xfa, 0xf8, 0xfe, 0x72, 0x64	/* T__pfx___probestub_mce_record */
	.byte 0x0d, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x6d, 0x63, 0xfa, 0xf8, 0xfe, 0x72, 0x64	/* T__probestub_mce_record */
	.byte 0x0b, 0xc6, 0x20, 0x72, 0x5f, 0xac, 0x5f, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* t__pfx_msr_to_offset */
	.byte 0x0b, 0x74, 0x20, 0x72, 0x5f, 0xac, 0x5f, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* tmsr_to_offset */
	.byte 0x0d, 0xbf, 0x6d, 0x63, 0xfa, 0x69, 0xe0, 0xfe, 0x72, 0xf8, 0x63, 0xdb, 0x62, 0xd3	/* T__pfx_mce_is_correctable */
	.byte 0x0d, 0x54, 0x6d, 0x63, 0xfa, 0x69, 0xe0, 0xfe, 0x72, 0xf8, 0x63, 0xdb, 0x62, 0xd3	/* Tmce_is_correctable */
	.byte 0x0b, 0xc6, 0x66, 0x61, 0x6b, 0xfa, 0x70, 0xcc, 0x69, 0xd5, 0xda, 0x74	/* t__pfx_fake_panic_get */
	.byte 0x0b, 0x74, 0x66, 0x61, 0x6b, 0xfa, 0x70, 0xcc, 0x69, 0xd5, 0xda, 0x74	/* tfake_panic_get */
	.byte 0x0c, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x6d, 0x63, 0xfa, 0xf8, 0xfe, 0x72, 0x64	/* t__pfx_perf_trace_mce_record */
	.byte 0x0b, 0x06, 0xee, 0xa0, 0xc8, 0x6d, 0x63, 0xfa, 0xf8, 0xfe, 0x72, 0x64	/* tperf_trace_mce_record */
	.byte 0x0c, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x6d, 0x63, 0xfa, 0xf8, 0xfe, 0x72, 0x64	/* t__pfx_trace_event_raw_event_mce_record */
	.byte 0x0c, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x6d, 0x63, 0xfa, 0xf8, 0xfe, 0x72, 0x64	/* ttrace_event_raw_event_mce_record */
	.byte 0x0e, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x6d, 0x63, 0xfa, 0xf8, 0xfe, 0x72, 0x64	/* t__pfx_trace_raw_output_mce_record */
	.byte 0x0e, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x6d, 0x63, 0xfa, 0xf8, 0xfe, 0x72, 0x64	/* ttrace_raw_output_mce_record */
	.byte 0x0b, 0x29, 0x5f, 0x40, 0xc8, 0x6d, 0x63, 0xfa, 0xf8, 0xfe, 0x72, 0x64	/* t__pfx___bpf_trace_mce_record */
	.byte 0x0b, 0x74, 0xff, 0x40, 0xc8, 0x6d, 0x63, 0xfa, 0xf8, 0xfe, 0x72, 0x64	/* t__bpf_trace_mce_record */
	.byte 0x0a, 0xc6, 0x66, 0x61, 0x6b, 0xfa, 0x70, 0xcc, 0xa3, 0xba, 0x74	/* t__pfx_fake_panic_set */
	.byte 0x0a, 0x74, 0x66, 0x61, 0x6b, 0xfa, 0x70, 0xcc, 0xa3, 0xba, 0x74	/* tfake_panic_set */
	.byte 0x06, 0xbf, 0x6d, 0x63, 0xfa, 0xdf, 0x67	/* T__pfx_mce_log */
	.byte 0x06, 0x54, 0x6d, 0x63, 0xfa, 0xdf, 0x67	/* Tmce_log */
	.byte 0x0d, 0xbf, 0x6d, 0x63, 0xfa, 0x18, 0xcf, 0xe6, 0xfe, 0x64, 0xfa, 0xd0, 0x61, 0xf0	/* T__pfx_mce_register_decode_chain */
	.byte 0x0d, 0x54, 0x6d, 0x63, 0xfa, 0x18, 0xcf, 0xe6, 0xfe, 0x64, 0xfa, 0xd0, 0x61, 0xf0	/* Tmce_register_decode_chain */
	.byte 0x0e, 0xbf, 0x6d, 0x63, 0xfa, 0xd4, 0x18, 0xcf, 0xe6, 0xfe, 0x64, 0xfa, 0xd0, 0x61, 0xf0	/* T__pfx_mce_unregister_decode_chain */
	.byte 0x0e, 0x54, 0x6d, 0x63, 0xfa, 0xd4, 0x18, 0xcf, 0xe6, 0xfe, 0x64, 0xfa, 0xd0, 0x61, 0xf0	/* Tmce_unregister_decode_chain */
	.byte 0x0d, 0xc6, 0x6d, 0x63, 0xfa, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0xb6, 0xc2, 0xb8, 0xee	/* t__pfx_mce_default_notifier */
	.byte 0x0d, 0x74, 0x6d, 0x63, 0xfa, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0xb6, 0xc2, 0xb8, 0xee	/* tmce_default_notifier */
	.byte 0x0a, 0xbf, 0x6d, 0x63, 0xfa, 0x5d, 0x80, 0xb3, 0x10, 0x3d, 0x73	/* T__pfx_mce_usable_address */
	.byte 0x0a, 0x54, 0x6d, 0x63, 0xfa, 0x5d, 0x80, 0xb3, 0x10, 0x3d, 0x73	/* Tmce_usable_address */
	.byte 0x0d, 0xbf, 0x6d, 0x63, 0xfa, 0x69, 0xe0, 0xbd, 0x6d, 0xce, 0xc5, 0xee, 0xde, 0x72	/* T__pfx_mce_is_memory_error */
	.byte 0x0d, 0x54, 0x6d, 0x63, 0xfa, 0x69, 0xe0, 0xbd, 0x6d, 0xce, 0xc5, 0xee, 0xde, 0x72	/* Tmce_is_memory_error */
	.byte 0x0b, 0xc6, 0x75, 0xd5, 0xe6, 0xfe, 0x64, 0xfa, 0xb6, 0xc2, 0xb8, 0xee	/* t__pfx_uc_decode_notifier */
	.byte 0x0b, 0x74, 0x75, 0xd5, 0xe6, 0xfe, 0x64, 0xfa, 0xb6, 0xc2, 0xb8, 0xee	/* tuc_decode_notifier */
	.byte 0x09, 0xc6, 0x6b, 0x69, 0x6c, 0xc3, 0x6d, 0xfa, 0xb6, 0x77	/* t__pfx_kill_me_now */
	.byte 0x09, 0x74, 0x6b, 0x69, 0x6c, 0xc3, 0x6d, 0xfa, 0xb6, 0x77	/* tkill_me_now */
	.byte 0x08, 0xc6, 0x13, 0x99, 0x66, 0xce, 0xe7, 0xcc, 0xa3	/* t__pfx_wait_for_panic */
	.byte 0x08, 0x74, 0x13, 0x99, 0x66, 0xce, 0xe7, 0xcc, 0xa3	/* twait_for_panic */
	.byte 0x0a, 0xbf, 0x6d, 0x63, 0xfa, 0xb6, 0xc2, 0x66, 0xc5, 0xa7, 0x71	/* T__pfx_mce_notify_irq */
	.byte 0x0a, 0x54, 0x6d, 0x63, 0xfa, 0xb6, 0xc2, 0x66, 0xc5, 0xa7, 0x71	/* Tmce_notify_irq */
	.byte 0x0c, 0xc6, 0x6d, 0x63, 0xfa, 0x65, 0xca, 0x6c, 0xc5, 0xb6, 0xc2, 0xb8, 0xee	/* t__pfx_mce_early_notifier */
	.byte 0x0c, 0x74, 0x6d, 0x63, 0xfa, 0x65, 0xca, 0x6c, 0xc5, 0xb6, 0xc2, 0xb8, 0xee	/* tmce_early_notifier */
	.byte 0x08, 0x29, 0xf6, 0xdb, 0x72, 0xf9, 0xc2, 0x6d, 0xee	/* t__pfx___start_timer */
	.byte 0x09, 0x74, 0xff, 0x73, 0xdb, 0x72, 0xf9, 0xc2, 0x6d, 0xee	/* t__start_timer */
	.byte 0x0b, 0xc6, 0x6d, 0x63, 0xfa, 0x73, 0xdb, 0x72, 0xf9, 0xc2, 0x6d, 0xee	/* t__pfx_mce_start_timer */
	.byte 0x0b, 0x74, 0x6d, 0x63, 0xfa, 0x73, 0xdb, 0x72, 0xf9, 0xc2, 0x6d, 0xee	/* tmce_start_timer */
	.byte 0x0e, 0x29, 0x5f, 0x6d, 0x7e, 0x63, 0xd8, 0x92, 0x5f, 0xf0, 0x99, 0x76, 0xe8, 0x64, 0xce	/* t__pfx___mcheck_cpu_init_vendor */
	.byte 0x0e, 0x74, 0xff, 0x6d, 0x7e, 0x63, 0xd8, 0x92, 0x5f, 0xf0, 0x99, 0x76, 0xe8, 0x64, 0xce	/* t__mcheck_cpu_init_vendor */
	.byte 0x0d, 0x29, 0x5f, 0x6d, 0x7e, 0x63, 0xd8, 0x92, 0x5f, 0xf0, 0x99, 0xc2, 0x6d, 0xee	/* t__pfx___mcheck_cpu_init_timer */
	.byte 0x0d, 0x74, 0xff, 0x6d, 0x7e, 0x63, 0xd8, 0x92, 0x5f, 0xf0, 0x99, 0xc2, 0x6d, 0xee	/* t__mcheck_cpu_init_timer */
	.byte 0x0c, 0x29, 0x5f, 0x6d, 0x63, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x62, 0xcc, 0x6b	/* t__pfx___mce_disable_bank */
	.byte 0x0c, 0x74, 0xff, 0x6d, 0x63, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x62, 0xcc, 0x6b	/* t__mce_disable_bank */
	.byte 0x0d, 0xc6, 0x6d, 0x63, 0xfa, 0xc2, 0x6d, 0xcf, 0xe6, 0xd3, 0x74, 0xfa, 0xe1, 0x6c	/* t__pfx_mce_timer_delete_all */
	.byte 0x0d, 0x74, 0x6d, 0x63, 0xfa, 0xc2, 0x6d, 0xcf, 0xe6, 0xd3, 0x74, 0xfa, 0xe1, 0x6c	/* tmce_timer_delete_all */
	.byte 0x0a, 0xc6, 0x6d, 0x63, 0xfa, 0x07, 0xfa, 0xf8, 0xa5, 0x76, 0x65	/* t__pfx_mce_device_remove */
	.byte 0x0a, 0x74, 0x6d, 0x63, 0xfa, 0x07, 0xfa, 0xf8, 0xa5, 0x76, 0x65	/* tmce_device_remove */
	.byte 0x0b, 0xa8, 0x1f, 0x63, 0x6d, 0x63, 0xcb, 0x64, 0xab, 0x80, 0xd3, 0x64	/* t__pfx_set_cmci_disabled */
	.byte 0x0c, 0x74, 0xc9, 0xf9, 0x63, 0x6d, 0x63, 0xcb, 0x64, 0xab, 0x80, 0xd3, 0x64	/* tset_cmci_disabled */
	.byte 0x08, 0xa8, 0x1f, 0x2c, 0x6e, 0xce, 0xfa, 0x63, 0x65	/* t__pfx_set_ignore_ce */
	.byte 0x09, 0x74, 0xc9, 0xf9, 0x2c, 0x6e, 0xce, 0xfa, 0x63, 0x65	/* tset_ignore_ce */
	.byte 0x0a, 0xc6, 0x6d, 0x63, 0xfa, 0x07, 0xfa, 0xf8, 0xd3, 0x61, 0xc9	/* t__pfx_mce_device_release */
	.byte 0x0a, 0x74, 0x6d, 0x63, 0xfa, 0x07, 0xfa, 0xf8, 0xd3, 0x61, 0xc9	/* tmce_device_release */
	.byte 0x08, 0xc6, 0x6d, 0x63, 0xfa, 0x92, 0x5f, 0xe6, 0xc7	/* t__pfx_mce_cpu_dead */
	.byte 0x08, 0x74, 0x6d, 0x63, 0xfa, 0x92, 0x5f, 0xe6, 0xc7	/* tmce_cpu_dead */
	.byte 0x07, 0xa8, 0xf6, 0xad, 0xaa, 0x62, 0xcc, 0x6b	/* t__pfx_show_bank */
	.byte 0x07, 0x74, 0x73, 0xad, 0xaa, 0x62, 0xcc, 0x6b	/* tshow_bank */
	.byte 0x0e, 0xc6, 0x66, 0x61, 0x6b, 0xfa, 0x70, 0xcc, 0x69, 0xd5, 0x66, 0x81, 0xe0, 0x81, 0xe8	/* t__pfx_fake_panic_fops_open */
	.byte 0x0e, 0x74, 0x66, 0x61, 0x6b, 0xfa, 0x70, 0xcc, 0x69, 0xd5, 0x66, 0x81, 0xe0, 0x81, 0xe8	/* tfake_panic_fops_open */
	.byte 0x0c, 0xc6, 0x6d, 0x63, 0xfa, 0x73, 0x7e, 0x64, 0x75, 0xb3, 0x77, 0xce, 0x6b	/* t__pfx_mce_schedule_work */
	.byte 0x0c, 0x74, 0x6d, 0x63, 0xfa, 0x73, 0x7e, 0x64, 0x75, 0xb3, 0x77, 0xce, 0x6b	/* tmce_schedule_work */
	.byte 0x08, 0xc6, 0x6d, 0x63, 0xfa, 0x3d, 0xdb, 0x72, 0x74	/* t__pfx_mce_restart */
	.byte 0x08, 0x74, 0x6d, 0x63, 0xfa, 0x3d, 0xdb, 0x72, 0x74	/* tmce_restart */
	.byte 0x0d, 0xa8, 0x2a, 0xce, 0xfa, 0xf0, 0xf9, 0x77, 0xe4, 0x5b, 0x3d, 0xdb, 0x72, 0x74	/* t__pfx_store_int_with_restart */
	.byte 0x0d, 0x74, 0xd6, 0xce, 0xfa, 0xf0, 0xf9, 0x77, 0xe4, 0x5b, 0x3d, 0xdb, 0x72, 0x74	/* tstore_int_with_restart */
	.byte 0x05, 0xa8, 0x1f, 0x62, 0xcc, 0x6b	/* t__pfx_set_bank */
	.byte 0x06, 0x74, 0xc9, 0xf9, 0x62, 0xcc, 0x6b	/* tset_bank */
	.byte 0x0b, 0xc6, 0x6d, 0x63, 0xfa, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0x63, 0x62	/* t__pfx_mce_irq_work_cb */
	.byte 0x0b, 0x74, 0x6d, 0x63, 0xfa, 0xa7, 0x93, 0x77, 0xce, 0xd8, 0x63, 0x62	/* tmce_irq_work_cb */
	.byte 0x0a, 0xc6, 0x04, 0x75, 0xfa, 0xdb, 0x73, 0xd8, 0x77, 0xce, 0x6b	/* t__pfx_queue_task_work */
	.byte 0x0a, 0x74, 0x04, 0x75, 0xfa, 0xdb, 0x73, 0xd8, 0x77, 0xce, 0x6b	/* tqueue_task_work */
	.byte 0x12, 0xc6, 0x6d, 0x63, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0xee, 0xde, 0x72, 0x5f, 0xf8, 0x70, 0xce, 0x74, 0xf0, 0x67	/* t__pfx_mce_disable_error_reporting */
	.byte 0x12, 0x74, 0x6d, 0x63, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0xee, 0xde, 0x72, 0x5f, 0xf8, 0x70, 0xce, 0x74, 0xf0, 0x67	/* tmce_disable_error_reporting */
	.byte 0x0f, 0xc6, 0x6d, 0x63, 0xfa, 0xc1, 0x73, 0xfe, 0x72, 0xfa, 0x73, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_mce_syscore_shutdown */
	.byte 0x0f, 0x74, 0x6d, 0x63, 0xfa, 0xc1, 0x73, 0xfe, 0x72, 0xfa, 0x73, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* tmce_syscore_shutdown */
	.byte 0x0e, 0xc6, 0x6d, 0x63, 0xfa, 0xc1, 0x73, 0xfe, 0x72, 0xfa, 0xb7, 0x73, 0x70, 0xe8, 0x64	/* t__pfx_mce_syscore_suspend */
	.byte 0x0e, 0x74, 0x6d, 0x63, 0xfa, 0xc1, 0x73, 0xfe, 0x72, 0xfa, 0xb7, 0x73, 0x70, 0xe8, 0x64	/* tmce_syscore_suspend */
	.byte 0x12, 0x29, 0x5f, 0x6d, 0x7e, 0x63, 0xd8, 0x92, 0x5f, 0xf0, 0x99, 0x63, 0xd3, 0xca, 0x5f, 0x62, 0xcc, 0x6b, 0x73	/* t__pfx___mcheck_cpu_init_clear_banks */
	.byte 0x12, 0x74, 0xff, 0x6d, 0x7e, 0x63, 0xd8, 0x92, 0x5f, 0xf0, 0x99, 0x63, 0xd3, 0xca, 0x5f, 0x62, 0xcc, 0x6b, 0x73	/* t__mcheck_cpu_init_clear_banks */
	.byte 0x0c, 0xc6, 0x6d, 0x63, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x63, 0x6d, 0x63, 0x69	/* t__pfx_mce_disable_cmci */
	.byte 0x0c, 0x74, 0x6d, 0x63, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x63, 0x6d, 0x63, 0x69	/* tmce_disable_cmci */
	.byte 0x0f, 0xbf, 0x6d, 0x63, 0xfa, 0x70, 0xf8, 0xe2, 0xf8, 0xfe, 0x72, 0xe5, 0xfe, 0x6d, 0xa5, 0x6e	/* T__pfx_mce_prep_record_common */
	.byte 0x0f, 0x54, 0x6d, 0x63, 0xfa, 0x70, 0xf8, 0xe2, 0xf8, 0xfe, 0x72, 0xe5, 0xfe, 0x6d, 0xa5, 0x6e	/* Tmce_prep_record_common */
	.byte 0x0e, 0xbf, 0x6d, 0x63, 0xfa, 0x70, 0xf8, 0xe2, 0xf8, 0xfe, 0x72, 0x64, 0xe7, 0xcf, 0x92	/* T__pfx_mce_prep_record_per_cpu */
	.byte 0x0e, 0x54, 0x6d, 0x63, 0xfa, 0x70, 0xf8, 0xe2, 0xf8, 0xfe, 0x72, 0x64, 0xe7, 0xcf, 0x92	/* Tmce_prep_record_per_cpu */
	.byte 0x0c, 0xbf, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x7e, 0x63, 0x6b, 0xe7, 0x7f, 0x6c	/* T__pfx_machine_check_poll */
	.byte 0x0c, 0x54, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x7e, 0x63, 0x6b, 0xe7, 0x7f, 0x6c	/* Tmachine_check_poll */
	.byte 0x0e, 0x29, 0x5f, 0x6d, 0x7e, 0x63, 0xd8, 0x92, 0x5f, 0xf0, 0x99, 0x67, 0xe8, 0xee, 0xa3	/* t__pfx___mcheck_cpu_init_generic */
	.byte 0x0e, 0x74, 0xff, 0x6d, 0x7e, 0x63, 0xd8, 0x92, 0x5f, 0xf0, 0x99, 0x67, 0xe8, 0xee, 0xa3	/* t__mcheck_cpu_init_generic */
	.byte 0x0c, 0xc6, 0x6d, 0x63, 0xfa, 0xc1, 0x73, 0xfe, 0x72, 0xfa, 0xf8, 0xb7, 0xbd	/* t__pfx_mce_syscore_resume */
	.byte 0x0c, 0x74, 0x6d, 0x63, 0xfa, 0xc1, 0x73, 0xfe, 0x72, 0xfa, 0xf8, 0xb7, 0xbd	/* tmce_syscore_resume */
	.byte 0x0f, 0xc6, 0x6d, 0x63, 0xe7, 0x7f, 0xc3, 0x62, 0xcc, 0x6b, 0xe0, 0xe6, 0x66, 0x61, 0x0b, 0x74	/* t__pfx_mc_poll_banks_default */
	.byte 0x0f, 0x74, 0x6d, 0x63, 0xe7, 0x7f, 0xc3, 0x62, 0xcc, 0x6b, 0xe0, 0xe6, 0x66, 0x61, 0x0b, 0x74	/* tmc_poll_banks_default */
	.byte 0x0b, 0xbf, 0x6d, 0x63, 0xfa, 0x70, 0xf8, 0xe2, 0xf8, 0xfe, 0x72, 0x64	/* T__pfx_mce_prep_record */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfa, 0x70, 0xf8, 0xe2, 0xf8, 0xfe, 0x72, 0x64	/* Tmce_prep_record */
	.byte 0x0b, 0xbf, 0x6d, 0x63, 0xfa, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x80, 0xd3	/* T__pfx_mce_available */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfa, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x80, 0xd3	/* Tmce_available */
	.byte 0x0a, 0xc6, 0x6d, 0x63, 0xfa, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* t__pfx_mce_cpu_online */
	.byte 0x0a, 0x74, 0x6d, 0x63, 0xfa, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* tmce_cpu_online */
	.byte 0x0b, 0xc6, 0x6d, 0x63, 0xfa, 0x92, 0xe7, 0x72, 0xfa, 0xa9, 0x77, 0x6e	/* t__pfx_mce_cpu_pre_down */
	.byte 0x0b, 0x74, 0x6d, 0x63, 0xfa, 0x92, 0xe7, 0x72, 0xfa, 0xa9, 0x77, 0x6e	/* tmce_cpu_pre_down */
	.byte 0x09, 0xc6, 0x6d, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x63, 0x65	/* t__pfx_mce_enable_ce */
	.byte 0x09, 0x74, 0x6d, 0x63, 0xfa, 0xe8, 0x80, 0xb3, 0x63, 0x65	/* tmce_enable_ce */
	.byte 0x0a, 0xc6, 0x6d, 0x63, 0xfa, 0x92, 0x5f, 0x3d, 0xdb, 0x72, 0x74	/* t__pfx_mce_cpu_restart */
	.byte 0x0a, 0x74, 0x6d, 0x63, 0xfa, 0x92, 0x5f, 0x3d, 0xdb, 0x72, 0x74	/* tmce_cpu_restart */
	.byte 0x09, 0xc6, 0x6d, 0x63, 0xfa, 0xc2, 0x6d, 0xcf, 0x66, 0x6e	/* t__pfx_mce_timer_fn */
	.byte 0x09, 0x74, 0x6d, 0x63, 0xfa, 0xc2, 0x6d, 0xcf, 0x66, 0x6e	/* tmce_timer_fn */
	.byte 0x0a, 0xbf, 0x6d, 0x63, 0xfa, 0xc2, 0x6d, 0xcf, 0x6b, 0xa3, 0x6b	/* T__pfx_mce_timer_kick */
	.byte 0x0a, 0x54, 0x6d, 0x63, 0xfa, 0xc2, 0x6d, 0xcf, 0x6b, 0xa3, 0x6b	/* Tmce_timer_kick */
	.byte 0x08, 0xbf, 0xb8, 0x6c, 0x74, 0xcf, 0x6d, 0x63, 0x65	/* T__pfx_filter_mce */
	.byte 0x08, 0x54, 0xb8, 0x6c, 0x74, 0xcf, 0x6d, 0x63, 0x65	/* Tfilter_mce */
	.byte 0x08, 0xbf, 0x6d, 0x7e, 0x63, 0xd8, 0x92, 0x5f, 0x8d	/* T__pfx_mcheck_cpu_init */
	.byte 0x08, 0x54, 0x6d, 0x7e, 0x63, 0xd8, 0x92, 0x5f, 0x8d	/* Tmcheck_cpu_init */
	.byte 0x0a, 0xbf, 0x6d, 0x7e, 0x63, 0xd8, 0x92, 0x5f, 0x63, 0xd3, 0xca	/* T__pfx_mcheck_cpu_clear */
	.byte 0x0a, 0x54, 0x6d, 0x7e, 0x63, 0xd8, 0x92, 0x5f, 0x63, 0xd3, 0xca	/* Tmcheck_cpu_clear */
	.byte 0x0b, 0xbf, 0x6d, 0x63, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x62, 0xcc, 0x6b	/* T__pfx_mce_disable_bank */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfa, 0x64, 0xab, 0x80, 0xb3, 0x62, 0xcc, 0x6b	/* Tmce_disable_bank */
	.byte 0x0c, 0xbf, 0x6d, 0x63, 0xfa, 0xb2, 0xe6, 0xa2, 0x67, 0x66, 0xe0, 0x64, 0xa7	/* T__pfx_mce_get_debugfs_dir */
	.byte 0x0c, 0x54, 0x6d, 0x63, 0xfa, 0xb2, 0xe6, 0xa2, 0x67, 0x66, 0xe0, 0x64, 0xa7	/* Tmce_get_debugfs_dir */
	.byte 0x06, 0xa8, 0xf6, 0xf6, 0xdb, 0x72, 0x74	/* t__pfx_s_start */
	.byte 0x06, 0x74, 0x73, 0xf6, 0xdb, 0x72, 0x74	/* ts_start */
	.byte 0x05, 0xa8, 0xf6, 0x5f, 0x6e, 0x97	/* t__pfx_s_next */
	.byte 0x04, 0x74, 0xe0, 0x6e, 0x97	/* ts_next */
	.byte 0x05, 0xa8, 0xf6, 0xf6, 0xac, 0x70	/* t__pfx_s_stop */
	.byte 0x05, 0x74, 0x73, 0xf6, 0xac, 0x70	/* ts_stop */
	.byte 0x0e, 0xa8, 0xf6, 0xbc, 0xee, 0xe4, 0x69, 0x65, 0xe0, 0xfc, 0xee, 0x61, 0x21, 0x24, 0x65	/* t__pfx_severities_coverage_write */
	.byte 0x0e, 0x74, 0xc9, 0x76, 0xee, 0xe4, 0x69, 0x65, 0xe0, 0xfc, 0xee, 0x61, 0x21, 0x24, 0x65	/* tseverities_coverage_write */
	.byte 0x0b, 0xc6, 0x69, 0xe0, 0xfe, 0x70, 0xc5, 0x66, 0xde, 0xcd, 0x5d, 0xee	/* t__pfx_is_copy_from_user */
	.byte 0x0a, 0xc2, 0xe0, 0xfe, 0x70, 0xc5, 0x66, 0xde, 0xcd, 0x5d, 0xee	/* tis_copy_from_user */
	.byte 0x0e, 0xa8, 0xf6, 0xbc, 0xee, 0xe4, 0x69, 0x65, 0xe0, 0xfc, 0xee, 0x61, 0x21, 0x81, 0xe8	/* t__pfx_severities_coverage_open */
	.byte 0x0e, 0x74, 0xc9, 0x76, 0xee, 0xe4, 0x69, 0x65, 0xe0, 0xfc, 0xee, 0x61, 0x21, 0x81, 0xe8	/* tseverities_coverage_open */
	.byte 0x04, 0xa8, 0xf6, 0xf6, 0x26	/* t__pfx_s_show */
	.byte 0x04, 0x74, 0x73, 0xf6, 0x26	/* ts_show */
	.byte 0x13, 0xbf, 0x6d, 0x63, 0xfa, 0x67, 0xe8, 0xe7, 0x6f, 0x7f, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0xf8, 0xfe, 0x72, 0x64, 0x73	/* T__pfx_mce_gen_pool_prepare_records */
	.byte 0x13, 0x54, 0x6d, 0x63, 0xfa, 0x67, 0xe8, 0xe7, 0x6f, 0x7f, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0xf8, 0xfe, 0x72, 0x64, 0x73	/* Tmce_gen_pool_prepare_records */
	.byte 0x0d, 0xbf, 0x6d, 0x63, 0xfa, 0x67, 0xe8, 0xe7, 0x6f, 0x7f, 0x25, 0x63, 0x3b, 0x73	/* T__pfx_mce_gen_pool_process */
	.byte 0x0d, 0x54, 0x6d, 0x63, 0xfa, 0x67, 0xe8, 0xe7, 0x6f, 0x7f, 0x25, 0x63, 0x3b, 0x73	/* Tmce_gen_pool_process */
	.byte 0x0e, 0xbf, 0x6d, 0x63, 0xfa, 0x67, 0xe8, 0xe7, 0x6f, 0x6f, 0xc3, 0x65, 0xb0, 0x74, 0x79	/* T__pfx_mce_gen_pool_empty */
	.byte 0x0e, 0x54, 0x6d, 0x63, 0xfa, 0x67, 0xe8, 0xe7, 0x6f, 0x6f, 0xc3, 0x65, 0xb0, 0x74, 0x79	/* Tmce_gen_pool_empty */
	.byte 0x0b, 0xbf, 0x6d, 0x63, 0xfa, 0x67, 0xe8, 0xe7, 0x6f, 0x6f, 0xc3, 0x10	/* T__pfx_mce_gen_pool_add */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfa, 0x67, 0xe8, 0xe7, 0x6f, 0x6f, 0xc3, 0x10	/* Tmce_gen_pool_add */
	.byte 0x0b, 0xbf, 0x6d, 0x63, 0xfa, 0x67, 0xe8, 0xe7, 0x6f, 0x6f, 0xc3, 0x8d	/* T__pfx_mce_gen_pool_init */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfa, 0x67, 0xe8, 0xe7, 0x6f, 0x6f, 0xc3, 0x8d	/* Tmce_gen_pool_init */
	.byte 0x0e, 0xc6, 0x63, 0x6d, 0x63, 0xcb, 0x6d, 0x63, 0xe7, 0x7f, 0xc3, 0x62, 0xcc, 0x6b, 0x73	/* t__pfx_cmci_mc_poll_banks */
	.byte 0x0d, 0x2d, 0x6d, 0x63, 0xcb, 0x6d, 0x63, 0xe7, 0x7f, 0xc3, 0x62, 0xcc, 0x6b, 0x73	/* tcmci_mc_poll_banks */
	.byte 0x0f, 0xc6, 0xf0, 0x9a, 0xc3, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx_intel_threshold_interrupt */
	.byte 0x0f, 0x74, 0xf0, 0x9a, 0xc3, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* tintel_threshold_interrupt */
	.byte 0x0b, 0xc6, 0x63, 0x6d, 0x63, 0x69, 0xf6, 0xb9, 0x70, 0xce, 0x9a, 0x64	/* t__pfx_cmci_supported */
	.byte 0x0a, 0x2d, 0x6d, 0x63, 0x69, 0xf6, 0xb9, 0x70, 0xce, 0x9a, 0x64	/* tcmci_supported */
	.byte 0x0a, 0xc6, 0x63, 0x6d, 0x63, 0x69, 0x1f, 0x15, 0x3d, 0xad, 0x02	/* t__pfx_cmci_set_threshold */
	.byte 0x09, 0x2d, 0x6d, 0x63, 0x69, 0x1f, 0x15, 0x3d, 0xad, 0x02	/* tcmci_set_threshold */
	.byte 0x0d, 0x29, 0x5f, 0x63, 0x6d, 0x63, 0xcb, 0x64, 0xab, 0x80, 0xb3, 0x62, 0xcc, 0x6b	/* t__pfx___cmci_disable_bank */
	.byte 0x0d, 0x74, 0xff, 0x63, 0x6d, 0x63, 0xcb, 0x64, 0xab, 0x80, 0xb3, 0x62, 0xcc, 0x6b	/* t__cmci_disable_bank */
	.byte 0x09, 0xc6, 0x63, 0x6d, 0x63, 0xcb, 0x64, 0xab, 0xfc, 0xee	/* t__pfx_cmci_discover */
	.byte 0x08, 0x2d, 0x6d, 0x63, 0xcb, 0x64, 0xab, 0xfc, 0xee	/* tcmci_discover */
	.byte 0x0f, 0xc6, 0x63, 0x6d, 0x63, 0xcb, 0xf8, 0x64, 0xab, 0xfc, 0xcf, 0x77, 0xce, 0xd8, 0x2b, 0x63	/* t__pfx_cmci_rediscover_work_func */
	.byte 0x0e, 0x2d, 0x6d, 0x63, 0xcb, 0xf8, 0x64, 0xab, 0xfc, 0xcf, 0x77, 0xce, 0xd8, 0x2b, 0x63	/* tcmci_rediscover_work_func */
	.byte 0x0b, 0xc6, 0x6c, 0x6d, 0x63, 0xfa, 0x73, 0xb9, 0x70, 0xce, 0x9a, 0x64	/* t__pfx_lmce_supported */
	.byte 0x0b, 0x74, 0x6c, 0x6d, 0x63, 0xfa, 0x73, 0xb9, 0x70, 0xce, 0x9a, 0x64	/* tlmce_supported */
	.byte 0x0e, 0xbf, 0x6d, 0x63, 0xfa, 0xf0, 0x9a, 0xc3, 0x68, 0xcc, 0x64, 0xb3, 0xd6, 0xce, 0x6d	/* T__pfx_mce_intel_handle_storm */
	.byte 0x0e, 0x54, 0x6d, 0x63, 0xfa, 0xf0, 0x9a, 0xc3, 0x68, 0xcc, 0x64, 0xb3, 0xd6, 0xce, 0x6d	/* Tmce_intel_handle_storm */
	.byte 0x09, 0xbf, 0x63, 0x6d, 0x63, 0xcb, 0xf8, 0x7e, 0x63, 0x6b	/* T__pfx_cmci_recheck */
	.byte 0x09, 0x54, 0x63, 0x6d, 0x63, 0xcb, 0xf8, 0x7e, 0x63, 0x6b	/* Tcmci_recheck */
	.byte 0x08, 0xbf, 0x63, 0x6d, 0x63, 0xcb, 0x63, 0xd3, 0xca	/* T__pfx_cmci_clear */
	.byte 0x08, 0x54, 0x63, 0x6d, 0x63, 0xcb, 0x63, 0xd3, 0xca	/* Tcmci_clear */
	.byte 0x0a, 0xbf, 0x63, 0x6d, 0x63, 0xcb, 0xf8, 0x64, 0xab, 0xfc, 0xee	/* T__pfx_cmci_rediscover */
	.byte 0x0a, 0x54, 0x63, 0x6d, 0x63, 0xcb, 0xf8, 0x64, 0xab, 0xfc, 0xee	/* Tcmci_rediscover */
	.byte 0x09, 0xbf, 0x63, 0x6d, 0x63, 0xcb, 0xf8, 0xe8, 0x80, 0xd3	/* T__pfx_cmci_reenable */
	.byte 0x09, 0x54, 0x63, 0x6d, 0x63, 0xcb, 0xf8, 0xe8, 0x80, 0xd3	/* Tcmci_reenable */
	.byte 0x0c, 0xbf, 0x63, 0x6d, 0x63, 0xcb, 0x64, 0xab, 0x80, 0xb3, 0x62, 0xcc, 0x6b	/* T__pfx_cmci_disable_bank */
	.byte 0x0c, 0x54, 0x63, 0x6d, 0x63, 0xcb, 0x64, 0xab, 0x80, 0xb3, 0x62, 0xcc, 0x6b	/* Tcmci_disable_bank */
	.byte 0x0a, 0xbf, 0xf0, 0x9a, 0xc3, 0xf0, 0x99, 0x63, 0x6d, 0x63, 0x69	/* T__pfx_intel_init_cmci */
	.byte 0x0a, 0x54, 0xf0, 0x9a, 0xc3, 0xf0, 0x99, 0x63, 0x6d, 0x63, 0x69	/* Tintel_init_cmci */
	.byte 0x0a, 0xbf, 0xf0, 0x9a, 0xc3, 0xf0, 0x99, 0x6c, 0x6d, 0x63, 0x65	/* T__pfx_intel_init_lmce */
	.byte 0x0a, 0x54, 0xf0, 0x9a, 0xc3, 0xf0, 0x99, 0x6c, 0x6d, 0x63, 0x65	/* Tintel_init_lmce */
	.byte 0x0c, 0xbf, 0xf0, 0x9a, 0xc3, 0x63, 0xd3, 0xca, 0x5f, 0x6c, 0x6d, 0x63, 0x65	/* T__pfx_intel_clear_lmce */
	.byte 0x0c, 0x54, 0xf0, 0x9a, 0xc3, 0x63, 0xd3, 0xca, 0x5f, 0x6c, 0x6d, 0x63, 0x65	/* Tintel_clear_lmce */
	.byte 0x0d, 0xbf, 0x6d, 0x63, 0xfa, 0xf0, 0x9a, 0xc3, 0x66, 0x65, 0xe9, 0x1d, 0xfa, 0x8d	/* T__pfx_mce_intel_feature_init */
	.byte 0x0d, 0x54, 0x6d, 0x63, 0xfa, 0xf0, 0x9a, 0xc3, 0x66, 0x65, 0xe9, 0x1d, 0xfa, 0x8d	/* Tmce_intel_feature_init */
	.byte 0x0f, 0xbf, 0x6d, 0x63, 0xfa, 0xf0, 0x9a, 0xc3, 0x66, 0x65, 0xe9, 0x1d, 0xfa, 0x63, 0xd3, 0xca	/* T__pfx_mce_intel_feature_clear */
	.byte 0x0f, 0x54, 0x6d, 0x63, 0xfa, 0xf0, 0x9a, 0xc3, 0x66, 0x65, 0xe9, 0x1d, 0xfa, 0x63, 0xd3, 0xca	/* Tmce_intel_feature_clear */
	.byte 0x0b, 0xbf, 0xf0, 0x9a, 0xc3, 0xb8, 0x6c, 0x74, 0xcf, 0x6d, 0x63, 0x65	/* T__pfx_intel_filter_mce */
	.byte 0x0b, 0x54, 0xf0, 0x9a, 0xc3, 0xb8, 0x6c, 0x74, 0xcf, 0x6d, 0x63, 0x65	/* Tintel_filter_mce */
	.byte 0x0d, 0xbf, 0xf0, 0x9a, 0xc3, 0x6d, 0x63, 0xfa, 0x5d, 0x80, 0xb3, 0x10, 0x3d, 0x73	/* T__pfx_intel_mce_usable_address */
	.byte 0x0d, 0x54, 0xf0, 0x9a, 0xc3, 0x6d, 0x63, 0xfa, 0x5d, 0x80, 0xb3, 0x10, 0x3d, 0x73	/* Tintel_mce_usable_address */
	.byte 0x0d, 0x3f, 0xf6, 0x6d, 0x63, 0x61, 0x5f, 0xb2, 0x62, 0xcc, 0xd8, 0x74, 0x27, 0x65	/* T__pfx_smca_get_bank_type */
	.byte 0x0d, 0x54, 0x73, 0x6d, 0x63, 0x61, 0x5f, 0xb2, 0x62, 0xcc, 0xd8, 0x74, 0x27, 0x65	/* Tsmca_get_bank_type */
	.byte 0x03, 0xa8, 0xf6, 0x26	/* t__pfx_show */
	.byte 0x03, 0x74, 0x73, 0x26	/* tshow */
	.byte 0x04, 0xa8, 0xf6, 0xac, 0xf8	/* t__pfx_store */
	.byte 0x04, 0x74, 0xd6, 0x6f, 0xf8	/* tstore */
	.byte 0x0d, 0xc6, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x62, 0xc0, 0xd8, 0xf8, 0xd3, 0x61, 0xc9	/* t__pfx_threshold_block_release */
	.byte 0x0d, 0x74, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x62, 0xc0, 0xd8, 0xf8, 0xd3, 0x61, 0xc9	/* tthreshold_block_release */
	.byte 0x0d, 0xa8, 0x2a, 0xce, 0xfa, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x6c, 0x69, 0x6d, 0xe4	/* t__pfx_store_threshold_limit */
	.byte 0x0d, 0x74, 0xd6, 0xce, 0xfa, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x6c, 0x69, 0x6d, 0xe4	/* tstore_threshold_limit */
	.byte 0x0d, 0xa8, 0x2a, 0xce, 0xfa, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0xf9, 0xe8, 0x80, 0xd3	/* t__pfx_store_interrupt_enable */
	.byte 0x0d, 0x74, 0xd6, 0xce, 0xfa, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0xf9, 0xe8, 0x80, 0xd3	/* tstore_interrupt_enable */
	.byte 0x0d, 0xa8, 0xf6, 0xad, 0xaa, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x6c, 0x69, 0x6d, 0xe4	/* t__pfx_show_threshold_limit */
	.byte 0x0d, 0x74, 0x73, 0xad, 0xaa, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x6c, 0x69, 0x6d, 0xe4	/* tshow_threshold_limit */
	.byte 0x0d, 0xa8, 0xf6, 0xad, 0xaa, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0xf9, 0xe8, 0x80, 0xd3	/* t__pfx_show_interrupt_enable */
	.byte 0x0d, 0x74, 0x73, 0xad, 0xaa, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0xf9, 0xe8, 0x80, 0xd3	/* tshow_interrupt_enable */
	.byte 0x0b, 0xa8, 0xf6, 0xad, 0xaa, 0xee, 0xde, 0x72, 0x5f, 0xfe, 0xd4, 0x74	/* t__pfx_show_error_count */
	.byte 0x0b, 0x74, 0x73, 0xad, 0xaa, 0xee, 0xde, 0x72, 0x5f, 0xfe, 0xd4, 0x74	/* tshow_error_count */
	.byte 0x0e, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72	/* t__pfx___sysvec_deferred_error */
	.byte 0x0f, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72	/* t__sysvec_deferred_error */
	.byte 0x0c, 0x29, 0x5f, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0xf8, 0xa5, 0x22, 0x07, 0x65	/* t__pfx___threshold_remove_device */
	.byte 0x0c, 0x74, 0xff, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0xf8, 0xa5, 0x22, 0x07, 0x65	/* t__threshold_remove_device */
	.byte 0x0d, 0xc6, 0xb2, 0x62, 0xc0, 0xd8, 0x10, 0x3d, 0x73, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_get_block_address.isra.0 */
	.byte 0x0d, 0x74, 0xb2, 0x62, 0xc0, 0xd8, 0x10, 0x3d, 0x73, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tget_block_address.isra.0 */
	.byte 0x05, 0xc6, 0xb2, 0x6e, 0x61, 0xbd	/* t__pfx_get_name */
	.byte 0x05, 0x74, 0xb2, 0x6e, 0x61, 0xbd	/* tget_name */
	.byte 0x0d, 0xc6, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x3d, 0xdb, 0x72, 0xf9, 0x62, 0xcc, 0x6b	/* t__pfx_threshold_restart_bank */
	.byte 0x0d, 0x74, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x3d, 0xdb, 0x72, 0xf9, 0x62, 0xcc, 0x6b	/* tthreshold_restart_bank */
	.byte 0x0d, 0xa8, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x62, 0x3c	/* t__pfx_prepare_threshold_block */
	.byte 0x0c, 0x06, 0xf8, 0x70, 0xca, 0xfa, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x62, 0x3c	/* tprepare_threshold_block */
	.byte 0x07, 0x29, 0x5f, 0xdf, 0xa6, 0xee, 0xde, 0x72	/* t__pfx___log_error */
	.byte 0x07, 0x74, 0xff, 0xdf, 0xa6, 0xee, 0xde, 0x72	/* t__log_error */
	.byte 0x0c, 0x29, 0xdf, 0xa6, 0xee, 0xde, 0x72, 0x5f, 0xe6, 0x66, 0xee, 0xf8, 0x64	/* t__pfx__log_error_deferred */
	.byte 0x0c, 0xf9, 0xdf, 0xa6, 0xee, 0xde, 0x72, 0x5f, 0xe6, 0x66, 0xee, 0xf8, 0x64	/* t_log_error_deferred */
	.byte 0x0a, 0xc6, 0xdf, 0xa6, 0xcc, 0xe5, 0xf8, 0xc9, 0xf9, 0x62, 0x3c	/* t__pfx_log_and_reset_block */
	.byte 0x0a, 0x74, 0xdf, 0xa6, 0xcc, 0xe5, 0xf8, 0xc9, 0xf9, 0x62, 0x3c	/* tlog_and_reset_block */
	.byte 0x0f, 0xc6, 0x61, 0x6d, 0xe5, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx_amd_threshold_interrupt */
	.byte 0x0e, 0xdb, 0x6d, 0xe5, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* tamd_threshold_interrupt */
	.byte 0x13, 0xc6, 0x61, 0x6d, 0xe5, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72, 0x5f, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx_amd_deferred_error_interrupt */
	.byte 0x12, 0xdb, 0x6d, 0xe5, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72, 0x5f, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* tamd_deferred_error_interrupt */
	.byte 0x0c, 0xc6, 0xe1, 0xc0, 0xa1, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x62, 0x3c, 0x73	/* t__pfx_allocate_threshold_blocks */
	.byte 0x0c, 0x74, 0xe1, 0xc0, 0xa1, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x62, 0x3c, 0x73	/* tallocate_threshold_blocks */
	.byte 0x0b, 0xbf, 0x61, 0x6d, 0xe5, 0xb8, 0x6c, 0x74, 0xcf, 0x6d, 0x63, 0x65	/* T__pfx_amd_filter_mce */
	.byte 0x0b, 0x54, 0x61, 0x6d, 0xe5, 0xb8, 0x6c, 0x74, 0xcf, 0x6d, 0x63, 0x65	/* Tamd_filter_mce */
	.byte 0x0d, 0xbf, 0x6d, 0x63, 0xfa, 0x61, 0x6d, 0xe5, 0x66, 0x65, 0xe9, 0x1d, 0xfa, 0x8d	/* T__pfx_mce_amd_feature_init */
	.byte 0x0d, 0x54, 0x6d, 0x63, 0xfa, 0x61, 0x6d, 0xe5, 0x66, 0x65, 0xe9, 0x1d, 0xfa, 0x8d	/* Tmce_amd_feature_init */
	.byte 0x10, 0xbf, 0x61, 0x6d, 0xe5, 0x6d, 0x63, 0xfa, 0x69, 0xe0, 0xbd, 0x6d, 0xce, 0xc5, 0xee, 0xde, 0x72	/* T__pfx_amd_mce_is_memory_error */
	.byte 0x10, 0x54, 0x61, 0x6d, 0xe5, 0x6d, 0x63, 0xfa, 0x69, 0xe0, 0xbd, 0x6d, 0xce, 0xc5, 0xee, 0xde, 0x72	/* Tamd_mce_is_memory_error */
	.byte 0x0d, 0xbf, 0x61, 0x6d, 0xe5, 0x6d, 0x63, 0xfa, 0x5d, 0x80, 0xb3, 0x10, 0x3d, 0x73	/* T__pfx_amd_mce_usable_address */
	.byte 0x0d, 0x54, 0x61, 0x6d, 0xe5, 0x6d, 0x63, 0xfa, 0x5d, 0x80, 0xb3, 0x10, 0x3d, 0x73	/* Tamd_mce_usable_address */
	.byte 0x10, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72	/* T__pfx_fred_sysvec_deferred_error */
	.byte 0x10, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xe6, 0x66, 0xee, 0xf8, 0xe5, 0xee, 0xde, 0x72	/* Tfred_sysvec_deferred_error */
	.byte 0x0e, 0xbf, 0x6d, 0x63, 0xfa, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0xf8, 0xa5, 0x22, 0x07, 0x65	/* T__pfx_mce_threshold_remove_device */
	.byte 0x0e, 0x54, 0x6d, 0x63, 0xfa, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0xf8, 0xa5, 0x22, 0x07, 0x65	/* Tmce_threshold_remove_device */
	.byte 0x0e, 0xbf, 0x6d, 0x63, 0xfa, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x63, 0xf8, 0xa1, 0x07, 0x65	/* T__pfx_mce_threshold_create_device */
	.byte 0x0e, 0x54, 0x6d, 0x63, 0xfa, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x63, 0xf8, 0xa1, 0x07, 0x65	/* Tmce_threshold_create_device */
	.byte 0x0a, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x15, 0x3d, 0xad, 0x02	/* t__pfx___sysvec_threshold */
	.byte 0x0b, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0x15, 0x3d, 0xad, 0x02	/* t__sysvec_threshold */
	.byte 0x0c, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x15, 0x3d, 0xad, 0x02	/* T__pfx_fred_sysvec_threshold */
	.byte 0x0c, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x15, 0x3d, 0xad, 0x02	/* Tfred_sysvec_threshold */
	.byte 0x0b, 0xbf, 0x6d, 0x63, 0xfa, 0xf0, 0x68, 0xee, 0x99, 0xd6, 0xce, 0x6d	/* T__pfx_mce_inherit_storm */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfa, 0xf0, 0x68, 0xee, 0x99, 0xd6, 0xce, 0x6d	/* Tmce_inherit_storm */
	.byte 0x0a, 0xbf, 0x6d, 0x63, 0xfa, 0xb2, 0xd6, 0xce, 0xcd, 0xa5, 0xe6	/* T__pfx_mce_get_storm_mode */
	.byte 0x0a, 0x54, 0x6d, 0x63, 0xfa, 0xb2, 0xd6, 0xce, 0xcd, 0xa5, 0xe6	/* Tmce_get_storm_mode */
	.byte 0x0b, 0xbf, 0x6d, 0x63, 0xfa, 0xc9, 0xf9, 0xd6, 0xce, 0xcd, 0xa5, 0xe6	/* T__pfx_mce_set_storm_mode */
	.byte 0x0b, 0x54, 0x6d, 0x63, 0xfa, 0xc9, 0xf9, 0xd6, 0xce, 0xcd, 0xa5, 0xe6	/* Tmce_set_storm_mode */
	.byte 0x0b, 0xbf, 0x63, 0x6d, 0x63, 0x69, 0x2a, 0xce, 0xcd, 0x17, 0x67, 0xf0	/* T__pfx_cmci_storm_begin */
	.byte 0x0b, 0x54, 0x63, 0x6d, 0x63, 0x69, 0x2a, 0xce, 0xcd, 0x17, 0x67, 0xf0	/* Tcmci_storm_begin */
	.byte 0x0a, 0xbf, 0x63, 0x6d, 0x63, 0x69, 0x2a, 0xce, 0xcd, 0xe8, 0x64	/* T__pfx_cmci_storm_end */
	.byte 0x0a, 0x54, 0x63, 0x6d, 0x63, 0x69, 0x2a, 0xce, 0xcd, 0xe8, 0x64	/* Tcmci_storm_end */
	.byte 0x09, 0xbf, 0x6d, 0x63, 0xfa, 0xd7, 0x6b, 0x2a, 0xce, 0x6d	/* T__pfx_mce_track_storm */
	.byte 0x09, 0x54, 0x6d, 0x63, 0xfa, 0xd7, 0x6b, 0x2a, 0xce, 0x6d	/* Tmce_track_storm */
	.byte 0x11, 0xbf, 0x61, 0x70, 0x65, 0xcb, 0x6d, 0x63, 0xfa, 0xf8, 0x70, 0xce, 0xf9, 0xbd, 0xcd, 0xee, 0xde, 0x72	/* T__pfx_apei_mce_report_mem_error */
	.byte 0x11, 0x54, 0x61, 0x70, 0x65, 0xcb, 0x6d, 0x63, 0xfa, 0xf8, 0x70, 0xce, 0xf9, 0xbd, 0xcd, 0xee, 0xde, 0x72	/* Tapei_mce_report_mem_error */
	.byte 0x15, 0xbf, 0x61, 0x70, 0x65, 0x69, 0xf6, 0x6d, 0x63, 0x61, 0x5f, 0xf8, 0x70, 0xce, 0xf9, 0x78, 0x38, 0x36, 0x5f, 0xee, 0xde, 0x72	/* T__pfx_apei_smca_report_x86_error */
	.byte 0x15, 0x54, 0x61, 0x70, 0x65, 0x69, 0xf6, 0x6d, 0x63, 0x61, 0x5f, 0xf8, 0x70, 0xce, 0xf9, 0x78, 0x38, 0x36, 0x5f, 0xee, 0xde, 0x72	/* Tapei_smca_report_x86_error */
	.byte 0x0a, 0xbf, 0x61, 0x70, 0x65, 0xcb, 0x24, 0xfa, 0x6d, 0x63, 0x65	/* T__pfx_apei_write_mce */
	.byte 0x0a, 0x54, 0x61, 0x70, 0x65, 0xcb, 0x24, 0xfa, 0x6d, 0x63, 0x65	/* Tapei_write_mce */
	.byte 0x0a, 0xbf, 0x61, 0x70, 0x65, 0xcb, 0xf8, 0x05, 0x6d, 0x63, 0x65	/* T__pfx_apei_read_mce */
	.byte 0x0a, 0x54, 0x61, 0x70, 0x65, 0xcb, 0xf8, 0x05, 0x6d, 0x63, 0x65	/* Tapei_read_mce */
	.byte 0x0b, 0xbf, 0x61, 0x70, 0x65, 0xcb, 0x7e, 0x63, 0xd8, 0x6d, 0x63, 0x65	/* T__pfx_apei_check_mce */
	.byte 0x0b, 0x54, 0x61, 0x70, 0x65, 0xcb, 0x7e, 0x63, 0xd8, 0x6d, 0x63, 0x65	/* Tapei_check_mce */
	.byte 0x0c, 0xbf, 0x61, 0x70, 0x65, 0xcb, 0x63, 0xd3, 0xca, 0x5f, 0x6d, 0x63, 0x65	/* T__pfx_apei_clear_mce */
	.byte 0x0c, 0x54, 0x61, 0x70, 0x65, 0xcb, 0x63, 0xd3, 0xca, 0x5f, 0x6d, 0x63, 0x65	/* Tapei_clear_mce */
	.byte 0x12, 0xc6, 0x6d, 0xea, 0x72, 0x5f, 0xf8, 0x6e, 0xe6, 0x7a, 0x76, 0x6f, 0x75, 0xe0, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_mtrr_rendezvous_handler */
	.byte 0x12, 0x74, 0x6d, 0xea, 0x72, 0x5f, 0xf8, 0x6e, 0xe6, 0x7a, 0x76, 0x6f, 0x75, 0xe0, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* tmtrr_rendezvous_handler */
	.byte 0x0c, 0xbf, 0xca, 0xd0, 0xe7, 0x68, 0x79, 0xe0, 0x77, 0xd5, 0xf0, 0xe6, 0x78	/* T__pfx_arch_phys_wc_index */
	.byte 0x0c, 0x54, 0xca, 0xd0, 0xe7, 0x68, 0x79, 0xe0, 0x77, 0xd5, 0xf0, 0xe6, 0x78	/* Tarch_phys_wc_index */
	.byte 0x08, 0xc6, 0x6d, 0xea, 0x72, 0x5f, 0x7e, 0x63, 0x6b	/* t__pfx_mtrr_check */
	.byte 0x08, 0x74, 0x6d, 0xea, 0x72, 0x5f, 0x7e, 0x63, 0x6b	/* tmtrr_check */
	.byte 0x08, 0xbf, 0x6d, 0xea, 0x72, 0x5f, 0x10, 0xe7, 0x03	/* T__pfx_mtrr_add_page */
	.byte 0x08, 0x54, 0x6d, 0xea, 0x72, 0x5f, 0x10, 0xe7, 0x03	/* Tmtrr_add_page */
	.byte 0x06, 0xbf, 0x6d, 0xea, 0x72, 0x5f, 0x10	/* T__pfx_mtrr_add */
	.byte 0x06, 0x54, 0x6d, 0xea, 0x72, 0x5f, 0x10	/* Tmtrr_add */
	.byte 0x0a, 0xbf, 0xca, 0xd0, 0xe7, 0x68, 0x79, 0xe0, 0x77, 0xd5, 0x10	/* T__pfx_arch_phys_wc_add */
	.byte 0x0a, 0x54, 0xca, 0xd0, 0xe7, 0x68, 0x79, 0xe0, 0x77, 0xd5, 0x10	/* Tarch_phys_wc_add */
	.byte 0x09, 0xbf, 0x6d, 0xea, 0x72, 0x5f, 0xe6, 0x6c, 0xe7, 0x03	/* T__pfx_mtrr_del_page */
	.byte 0x09, 0x54, 0x6d, 0xea, 0x72, 0x5f, 0xe6, 0x6c, 0xe7, 0x03	/* Tmtrr_del_page */
	.byte 0x07, 0xbf, 0x6d, 0xea, 0x72, 0x5f, 0xe6, 0x6c	/* T__pfx_mtrr_del */
	.byte 0x07, 0x54, 0x6d, 0xea, 0x72, 0x5f, 0xe6, 0x6c	/* Tmtrr_del */
	.byte 0x0b, 0xbf, 0xca, 0xd0, 0xe7, 0x68, 0x79, 0xe0, 0x77, 0xd5, 0xe6, 0x6c	/* T__pfx_arch_phys_wc_del */
	.byte 0x0b, 0x54, 0xca, 0xd0, 0xe7, 0x68, 0x79, 0xe0, 0x77, 0xd5, 0xe6, 0x6c	/* Tarch_phys_wc_del */
	.byte 0x09, 0xbf, 0x6d, 0xea, 0x72, 0xf6, 0x61, 0x22, 0xd6, 0x86	/* T__pfx_mtrr_save_state */
	.byte 0x09, 0x54, 0x6d, 0xea, 0x72, 0xf6, 0x61, 0x22, 0xd6, 0x86	/* Tmtrr_save_state */
	.byte 0x08, 0xc6, 0x6d, 0xea, 0x72, 0x5f, 0x63, 0xdf, 0xc9	/* t__pfx_mtrr_close */
	.byte 0x08, 0x74, 0x6d, 0xea, 0x72, 0x5f, 0x63, 0xdf, 0xc9	/* tmtrr_close */
	.byte 0x07, 0xc6, 0x6d, 0xea, 0x72, 0x5f, 0x24, 0x65	/* t__pfx_mtrr_write */
	.byte 0x07, 0x74, 0x6d, 0xea, 0x72, 0x5f, 0x24, 0x65	/* tmtrr_write */
	.byte 0x07, 0xc6, 0x6d, 0xea, 0x72, 0x5f, 0x81, 0xe8	/* t__pfx_mtrr_open */
	.byte 0x07, 0x74, 0x6d, 0xea, 0x72, 0x5f, 0x81, 0xe8	/* tmtrr_open */
	.byte 0x08, 0xc6, 0x6d, 0xea, 0x72, 0xba, 0x71, 0xf6, 0x26	/* t__pfx_mtrr_seq_show */
	.byte 0x08, 0x74, 0x6d, 0xea, 0x72, 0xba, 0x71, 0xf6, 0x26	/* tmtrr_seq_show */
	.byte 0x0f, 0xc6, 0x6d, 0xea, 0x72, 0x5f, 0xb8, 0xb3, 0x10, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_mtrr_file_add.constprop.0 */
	.byte 0x0f, 0x74, 0x6d, 0xea, 0x72, 0x5f, 0xb8, 0xb3, 0x10, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tmtrr_file_add.constprop.0 */
	.byte 0x0e, 0xc6, 0x6d, 0xea, 0x72, 0x5f, 0xb8, 0xb3, 0xe6, 0x6c, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_mtrr_file_del.isra.0 */
	.byte 0x0e, 0x74, 0x6d, 0xea, 0x72, 0x5f, 0xb8, 0xb3, 0xe6, 0x6c, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tmtrr_file_del.isra.0 */
	.byte 0x08, 0xc6, 0x6d, 0xea, 0x72, 0x5f, 0xd9, 0x7b, 0x6c	/* t__pfx_mtrr_ioctl */
	.byte 0x08, 0x74, 0x6d, 0xea, 0x72, 0x5f, 0xd9, 0x7b, 0x6c	/* tmtrr_ioctl */
	.byte 0x0c, 0xbf, 0x6d, 0xea, 0x72, 0x5f, 0xe9, 0xea, 0x69, 0xdc, 0xac, 0xf6, 0xea	/* T__pfx_mtrr_attrib_to_str */
	.byte 0x0c, 0x54, 0x6d, 0xea, 0x72, 0x5f, 0xe9, 0xea, 0x69, 0xdc, 0xac, 0xf6, 0xea	/* Tmtrr_attrib_to_str */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* t__pfx_paravirt_read_msr */
	.byte 0x0a, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* tparavirt_read_msr */
	.byte 0x0c, 0xc6, 0xb2, 0x65, 0x66, 0x66, 0x65, 0x63, 0xc2, 0x22, 0x74, 0x27, 0x65	/* t__pfx_get_effective_type */
	.byte 0x0c, 0x74, 0xb2, 0x65, 0x66, 0x66, 0x65, 0x63, 0xc2, 0x22, 0x74, 0x27, 0x65	/* tget_effective_type */
	.byte 0x0c, 0xbf, 0x67, 0xe8, 0xee, 0x69, 0xd5, 0xb2, 0x87, 0xfa, 0x9f, 0xd9, 0x6e	/* T__pfx_generic_get_free_region */
	.byte 0x0c, 0x54, 0x67, 0xe8, 0xee, 0x69, 0xd5, 0xb2, 0x87, 0xfa, 0x9f, 0xd9, 0x6e	/* Tgeneric_get_free_region */
	.byte 0x08, 0xc6, 0x72, 0xcd, 0x84, 0xe8, 0xea, 0xc5, 0xe9	/* t__pfx_rm_map_entry_at */
	.byte 0x07, 0xea, 0xcd, 0x84, 0xe8, 0xea, 0xc5, 0xe9	/* trm_map_entry_at */
	.byte 0x08, 0xc6, 0xc7, 0xe5, 0x84, 0xe8, 0xea, 0xc5, 0xe9	/* t__pfx_add_map_entry_at */
	.byte 0x08, 0xdb, 0x64, 0xe5, 0x84, 0xe8, 0xea, 0xc5, 0xe9	/* tadd_map_entry_at */
	.byte 0x07, 0xc6, 0xc7, 0xe5, 0x84, 0xe8, 0xea, 0x79	/* t__pfx_add_map_entry */
	.byte 0x07, 0xdb, 0x64, 0xe5, 0x84, 0xe8, 0xea, 0x79	/* tadd_map_entry */
	.byte 0x06, 0xc6, 0x84, 0xc7, 0xe5, 0x76, 0xca	/* t__pfx_map_add_var */
	.byte 0x06, 0x74, 0x84, 0xc7, 0xe5, 0x76, 0xca	/* tmap_add_var */
	.byte 0x0d, 0xbf, 0x67, 0xe8, 0xee, 0x69, 0xd5, 0x76, 0xe1, 0x89, 0xa1, 0x10, 0xe7, 0x03	/* T__pfx_generic_validate_add_page */
	.byte 0x0d, 0x54, 0x67, 0xe8, 0xee, 0x69, 0xd5, 0x76, 0xe1, 0x89, 0xa1, 0x10, 0xe7, 0x03	/* Tgeneric_validate_add_page */
	.byte 0x0e, 0xc6, 0x67, 0xe8, 0xee, 0x69, 0xd5, 0x68, 0x61, 0x22, 0x77, 0x72, 0xfe, 0x6d, 0x62	/* t__pfx_generic_have_wrcomb */
	.byte 0x0e, 0x74, 0x67, 0xe8, 0xee, 0x69, 0xd5, 0x68, 0x61, 0x22, 0x77, 0x72, 0xfe, 0x6d, 0x62	/* tgeneric_have_wrcomb */
	.byte 0x0a, 0xc6, 0x67, 0xe8, 0xee, 0x69, 0xd5, 0xb2, 0x6d, 0xea, 0x72	/* t__pfx_generic_get_mtrr */
	.byte 0x0a, 0x74, 0x67, 0xe8, 0xee, 0x69, 0xd5, 0xb2, 0x6d, 0xea, 0x72	/* tgeneric_get_mtrr */
	.byte 0x0c, 0xbf, 0x67, 0xe8, 0xee, 0x69, 0xd5, 0xf8, 0xa2, 0x69, 0x6c, 0xe5, 0x0a	/* T__pfx_generic_rebuild_map */
	.byte 0x0c, 0x54, 0x67, 0xe8, 0xee, 0x69, 0xd5, 0xf8, 0xa2, 0x69, 0x6c, 0xe5, 0x0a	/* Tgeneric_rebuild_map */
	.byte 0x0c, 0xbf, 0x6d, 0xea, 0x72, 0x5f, 0x6f, 0x76, 0xee, 0x24, 0xfa, 0xd6, 0x86	/* T__pfx_mtrr_overwrite_state */
	.byte 0x0c, 0x54, 0x6d, 0xea, 0x72, 0x5f, 0x6f, 0x76, 0xee, 0x24, 0xfa, 0xd6, 0x86	/* Tmtrr_overwrite_state */
	.byte 0x0c, 0xbf, 0x6d, 0xea, 0x72, 0x5f, 0x74, 0x27, 0xfa, 0xdf, 0x6f, 0x6b, 0xb9	/* T__pfx_mtrr_type_lookup */
	.byte 0x0c, 0x54, 0x6d, 0xea, 0x72, 0x5f, 0x74, 0x27, 0xfa, 0xdf, 0x6f, 0x6b, 0xb9	/* Tmtrr_type_lookup */
	.byte 0x0e, 0xbf, 0xb8, 0x6c, 0xc3, 0x6d, 0xea, 0x72, 0x5f, 0x76, 0xca, 0x5f, 0x72, 0xcc, 0xda	/* T__pfx_fill_mtrr_var_range */
	.byte 0x0e, 0x54, 0xb8, 0x6c, 0xc3, 0x6d, 0xea, 0x72, 0x5f, 0x76, 0xca, 0x5f, 0x72, 0xcc, 0xda	/* Tfill_mtrr_var_range */
	.byte 0x09, 0xbf, 0x6d, 0xea, 0x72, 0x5f, 0x77, 0x72, 0x20, 0x72	/* T__pfx_mtrr_wrmsr */
	.byte 0x09, 0x54, 0x6d, 0xea, 0x72, 0x5f, 0x77, 0x72, 0x20, 0x72	/* Tmtrr_wrmsr */
	.byte 0x09, 0xc6, 0x67, 0xe8, 0xee, 0xa3, 0x1f, 0x6d, 0xea, 0x72	/* t__pfx_generic_set_mtrr */
	.byte 0x09, 0x74, 0x67, 0xe8, 0xee, 0xa3, 0x1f, 0x6d, 0xea, 0x72	/* tgeneric_set_mtrr */
	.byte 0x11, 0xc6, 0xb2, 0xb8, 0x78, 0x65, 0xe5, 0x72, 0xcc, 0xda, 0x73, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_get_fixed_ranges.constprop.0 */
	.byte 0x11, 0x74, 0xb2, 0xb8, 0x78, 0x65, 0xe5, 0x72, 0xcc, 0xda, 0x73, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tget_fixed_ranges.constprop.0 */
	.byte 0x0f, 0xbf, 0x6d, 0xea, 0x72, 0xf6, 0x61, 0x22, 0xb8, 0x78, 0x65, 0xe5, 0x72, 0xcc, 0xda, 0x73	/* T__pfx_mtrr_save_fixed_ranges */
	.byte 0x0f, 0x54, 0x6d, 0xea, 0x72, 0xf6, 0x61, 0x22, 0xb8, 0x78, 0x65, 0xe5, 0x72, 0xcc, 0xda, 0x73	/* Tmtrr_save_fixed_ranges */
	.byte 0x09, 0xbf, 0x6d, 0xea, 0x72, 0x5f, 0x64, 0xab, 0x80, 0xd3	/* T__pfx_mtrr_disable */
	.byte 0x09, 0x54, 0x6d, 0xea, 0x72, 0x5f, 0x64, 0xab, 0x80, 0xd3	/* Tmtrr_disable */
	.byte 0x08, 0xbf, 0x6d, 0xea, 0x72, 0x5f, 0xe8, 0x80, 0xd3	/* T__pfx_mtrr_enable */
	.byte 0x08, 0x54, 0x6d, 0xea, 0x72, 0x5f, 0xe8, 0x80, 0xd3	/* Tmtrr_enable */
	.byte 0x0c, 0xbf, 0x6d, 0xea, 0x72, 0x5f, 0x67, 0xe8, 0xee, 0xa3, 0x1f, 0xd6, 0x86	/* T__pfx_mtrr_generic_set_state */
	.byte 0x0c, 0x54, 0x6d, 0xea, 0x72, 0x5f, 0x67, 0xe8, 0xee, 0xa3, 0x1f, 0xd6, 0x86	/* Tmtrr_generic_set_state */
	.byte 0x0f, 0x3f, 0xe7, 0x6f, 0x73, 0xe4, 0x69, 0x22, 0x68, 0x61, 0x22, 0x77, 0x72, 0xfe, 0x6d, 0x62	/* T__pfx_positive_have_wrcomb */
	.byte 0x0f, 0x54, 0x70, 0x6f, 0x73, 0xe4, 0x69, 0x22, 0x68, 0x61, 0x22, 0x77, 0x72, 0xfe, 0x6d, 0x62	/* Tpositive_have_wrcomb */
	.byte 0x0c, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0x92, 0x69, 0xe5, 0x76, 0xe8, 0x64, 0xce	/* t__pfx_x86_cpuid_vendor */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x92, 0x69, 0xe5, 0x76, 0xe8, 0x64, 0xce	/* tx86_cpuid_vendor */
	.byte 0x0b, 0xc6, 0x6d, 0xd5, 0x92, 0x5f, 0xa9, 0x77, 0x6e, 0xe7, 0xf8, 0x70	/* t__pfx_mc_cpu_down_prep */
	.byte 0x0b, 0x74, 0x6d, 0xd5, 0x92, 0x5f, 0xa9, 0x77, 0x6e, 0xe7, 0xf8, 0x70	/* tmc_cpu_down_prep */
	.byte 0x0d, 0xa8, 0x25, 0x63, 0x3b, 0x73, 0xce, 0x5f, 0x66, 0x1b, 0x67, 0x73, 0xf6, 0x26	/* t__pfx_processor_flags_show */
	.byte 0x0d, 0x74, 0x9b, 0x63, 0x3b, 0x73, 0xce, 0x5f, 0x66, 0x1b, 0x67, 0x73, 0xf6, 0x26	/* tprocessor_flags_show */
	.byte 0x08, 0xc6, 0x76, 0xee, 0x73, 0xd9, 0x6e, 0xf6, 0x26	/* t__pfx_version_show */
	.byte 0x08, 0x74, 0x76, 0xee, 0x73, 0xd9, 0x6e, 0xf6, 0x26	/* tversion_show */
	.byte 0x09, 0xc6, 0x6d, 0xd5, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* t__pfx_mc_cpu_online */
	.byte 0x09, 0x74, 0x6d, 0xd5, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* tmc_cpu_online */
	.byte 0x0d, 0xbf, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x62, 0x73, 0xe2, 0xf8, 0xb7, 0xbd	/* T__pfx_microcode_bsp_resume */
	.byte 0x0d, 0x54, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x62, 0x73, 0xe2, 0xf8, 0xb7, 0xbd	/* Tmicrocode_bsp_resume */
	.byte 0x09, 0xbf, 0xdf, 0x05, 0x75, 0xfe, 0x64, 0xfa, 0x61, 0x70	/* T__pfx_load_ucode_ap */
	.byte 0x09, 0x54, 0xdf, 0x05, 0x75, 0xfe, 0x64, 0xfa, 0x61, 0x70	/* Tload_ucode_ap */
	.byte 0x12, 0xbf, 0xf0, 0x9a, 0xc3, 0x66, 0xf0, 0xe5, 0x6d, 0xe9, 0xd0, 0xf0, 0x67, 0xf6, 0x2c, 0x6e, 0xe9, 0x75, 0xf8	/* T__pfx_intel_find_matching_signature */
	.byte 0x12, 0x54, 0xf0, 0x9a, 0xc3, 0x66, 0xf0, 0xe5, 0x6d, 0xe9, 0xd0, 0xf0, 0x67, 0xf6, 0x2c, 0x6e, 0xe9, 0x75, 0xf8	/* Tintel_find_matching_signature */
	.byte 0x11, 0xbf, 0xf0, 0x9a, 0xc3, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x73, 0xcc, 0xe4, 0xc5, 0x7e, 0x63, 0x6b	/* T__pfx_intel_microcode_sanity_check */
	.byte 0x11, 0x54, 0xf0, 0x9a, 0xc3, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x73, 0xcc, 0xe4, 0xc5, 0x7e, 0x63, 0x6b	/* Tintel_microcode_sanity_check */
	.byte 0x0b, 0xc6, 0x66, 0xf0, 0xe1, 0x69, 0x7a, 0xfa, 0x6c, 0xa1, 0xdf, 0xc7	/* t__pfx_finalize_late_load */
	.byte 0x0b, 0x74, 0x66, 0xf0, 0xe1, 0x69, 0x7a, 0xfa, 0x6c, 0xa1, 0xdf, 0xc7	/* tfinalize_late_load */
	.byte 0x0f, 0xa8, 0xe7, 0xca, 0x73, 0xfa, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x62, 0xdf, 0x62, 0x73	/* t__pfx_parse_microcode_blobs */
	.byte 0x0e, 0x06, 0xca, 0x73, 0xfa, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x62, 0xdf, 0x62, 0x73	/* tparse_microcode_blobs */
	.byte 0x0d, 0xc6, 0xf8, 0x8e, 0x3b, 0xf9, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x66, 0x77	/* t__pfx_request_microcode_fw */
	.byte 0x0d, 0x74, 0xf8, 0x8e, 0x3b, 0xf9, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x66, 0x77	/* trequest_microcode_fw */
	.byte 0x0c, 0x29, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0x6d, 0xa3, 0xde, 0xfe, 0xe6	/* t__pfx___apply_microcode */
	.byte 0x0c, 0x74, 0xff, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0x6d, 0xa3, 0xde, 0xfe, 0xe6	/* t__apply_microcode */
	.byte 0x0e, 0xc6, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x6c, 0x86	/* t__pfx_apply_microcode_late */
	.byte 0x0d, 0xdb, 0x70, 0x70, 0x6c, 0xc5, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x6c, 0x86	/* tapply_microcode_late */
	.byte 0x0e, 0xbf, 0xf0, 0x9a, 0xc3, 0xfe, 0x6c, 0xd3, 0x63, 0xf9, 0x92, 0x5f, 0xf0, 0x66, 0x6f	/* T__pfx_intel_collect_cpu_info */
	.byte 0x0e, 0x54, 0xf0, 0x9a, 0xc3, 0xfe, 0x6c, 0xd3, 0x63, 0xf9, 0x92, 0x5f, 0xf0, 0x66, 0x6f	/* Tintel_collect_cpu_info */
	.byte 0x0b, 0xc6, 0xfe, 0x6c, 0xd3, 0x63, 0xf9, 0x92, 0x5f, 0xf0, 0x66, 0x6f	/* t__pfx_collect_cpu_info */
	.byte 0x0b, 0x74, 0xfe, 0x6c, 0xd3, 0x63, 0xf9, 0x92, 0x5f, 0xf0, 0x66, 0x6f	/* tcollect_cpu_info */
	.byte 0x0c, 0xbf, 0xdf, 0x05, 0x75, 0xfe, 0x64, 0xfa, 0xf0, 0x9a, 0xc3, 0x61, 0x70	/* T__pfx_load_ucode_intel_ap */
	.byte 0x0c, 0x54, 0xdf, 0x05, 0x75, 0xfe, 0x64, 0xfa, 0xf0, 0x9a, 0xc3, 0x61, 0x70	/* Tload_ucode_intel_ap */
	.byte 0x0b, 0xbf, 0xf8, 0xdf, 0x05, 0x75, 0xfe, 0x64, 0xfa, 0xf0, 0x9a, 0x6c	/* T__pfx_reload_ucode_intel */
	.byte 0x0b, 0x54, 0xf8, 0xdf, 0x05, 0x75, 0xfe, 0x64, 0xfa, 0xf0, 0x9a, 0x6c	/* Treload_ucode_intel */
	.byte 0x0f, 0xc6, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x66, 0xf0, 0xcb, 0x92, 0x5f, 0x61, 0x6d, 0x64	/* t__pfx_microcode_fini_cpu_amd */
	.byte 0x0f, 0x74, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x66, 0xf0, 0xcb, 0x92, 0x5f, 0x61, 0x6d, 0x64	/* tmicrocode_fini_cpu_amd */
	.byte 0x10, 0x29, 0x5f, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x61, 0x6d, 0x64	/* t__pfx___apply_microcode_amd */
	.byte 0x10, 0x74, 0xff, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x61, 0x6d, 0x64	/* t__apply_microcode_amd */
	.byte 0x0a, 0xc6, 0x66, 0xf0, 0xe5, 0x65, 0x8e, 0x69, 0x76, 0x5f, 0x89	/* t__pfx_find_equiv_id */
	.byte 0x0a, 0x74, 0x66, 0xf0, 0xe5, 0x65, 0x8e, 0x69, 0x76, 0x5f, 0x89	/* tfind_equiv_id */
	.byte 0x0a, 0xc6, 0x76, 0xee, 0x69, 0x66, 0xc5, 0x98, 0xdb, 0xf0, 0xee	/* t__pfx_verify_container */
	.byte 0x0a, 0x74, 0x76, 0xee, 0x69, 0x66, 0xc5, 0x98, 0xdb, 0xf0, 0xee	/* tverify_container */
	.byte 0x11, 0xc6, 0x76, 0xee, 0x69, 0x66, 0xc5, 0x65, 0x8e, 0x69, 0x76, 0xe1, 0xe8, 0x63, 0xfa, 0xdb, 0x62, 0xd3	/* t__pfx_verify_equivalence_table */
	.byte 0x11, 0x74, 0x76, 0xee, 0x69, 0x66, 0xc5, 0x65, 0x8e, 0x69, 0x76, 0xe1, 0xe8, 0x63, 0xfa, 0xdb, 0x62, 0xd3	/* tverify_equivalence_table */
	.byte 0x09, 0xc6, 0x76, 0xee, 0x69, 0x66, 0x79, 0xe7, 0xe9, 0xd0	/* t__pfx_verify_patch */
	.byte 0x09, 0x74, 0x76, 0xee, 0x69, 0x66, 0x79, 0xe7, 0xe9, 0xd0	/* tverify_patch */
	.byte 0x0d, 0xc6, 0x87, 0xfa, 0x65, 0x8e, 0x69, 0x76, 0x5f, 0x92, 0x5f, 0xdb, 0x62, 0xd3	/* t__pfx_free_equiv_cpu_table */
	.byte 0x0d, 0x74, 0x87, 0xfa, 0x65, 0x8e, 0x69, 0x76, 0x5f, 0x92, 0x5f, 0xdb, 0x62, 0xd3	/* tfree_equiv_cpu_table */
	.byte 0x07, 0xc6, 0x87, 0xfa, 0x63, 0xeb, 0x68, 0x65	/* t__pfx_free_cache */
	.byte 0x07, 0x74, 0x87, 0xfa, 0x63, 0xeb, 0x68, 0x65	/* tfree_cache */
	.byte 0x07, 0xc6, 0x66, 0xf0, 0x64, 0xe7, 0xe9, 0xd0	/* t__pfx_find_patch */
	.byte 0x07, 0x74, 0x66, 0xf0, 0x64, 0xe7, 0xe9, 0xd0	/* tfind_patch */
	.byte 0x0f, 0xc6, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x61, 0x6d, 0x64	/* t__pfx_apply_microcode_amd */
	.byte 0x0e, 0xdb, 0x70, 0x70, 0x6c, 0xc5, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x61, 0x6d, 0x64	/* tapply_microcode_amd */
	.byte 0x0f, 0xc6, 0xfe, 0x6c, 0xd3, 0x63, 0xf9, 0x92, 0x5f, 0xf0, 0x66, 0x6f, 0x5f, 0x61, 0x6d, 0x64	/* t__pfx_collect_cpu_info_amd */
	.byte 0x0f, 0x74, 0xfe, 0x6c, 0xd3, 0x63, 0xf9, 0x92, 0x5f, 0xf0, 0x66, 0x6f, 0x5f, 0x61, 0x6d, 0x64	/* tcollect_cpu_info_amd */
	.byte 0x11, 0x29, 0xdf, 0x05, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x61, 0x6d, 0x64, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx__load_microcode_amd.isra.0 */
	.byte 0x11, 0xf9, 0xdf, 0x05, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x61, 0x6d, 0x64, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t_load_microcode_amd.isra.0 */
	.byte 0x0e, 0xc6, 0xf8, 0x8e, 0x3b, 0xf9, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x61, 0x6d, 0x64	/* t__pfx_request_microcode_amd */
	.byte 0x0e, 0x74, 0xf8, 0x8e, 0x3b, 0xf9, 0x6d, 0xa3, 0xde, 0xfe, 0x64, 0xfa, 0x61, 0x6d, 0x64	/* trequest_microcode_amd */
	.byte 0x0b, 0xbf, 0xf8, 0xdf, 0x05, 0x75, 0xfe, 0x64, 0xfa, 0x61, 0x6d, 0x64	/* T__pfx_reload_ucode_amd */
	.byte 0x0b, 0x54, 0xf8, 0xdf, 0x05, 0x75, 0xfe, 0x64, 0xfa, 0x61, 0x6d, 0x64	/* Treload_ucode_amd */
	.byte 0x0c, 0xbf, 0xdf, 0x05, 0x75, 0xfe, 0x64, 0xfa, 0x61, 0x6d, 0xe5, 0x61, 0x70	/* T__pfx_load_ucode_amd_ap */
	.byte 0x0c, 0x54, 0xdf, 0x05, 0x75, 0xfe, 0x64, 0xfa, 0x61, 0x6d, 0xe5, 0x61, 0x70	/* Tload_ucode_amd_ap */
	.byte 0x04, 0x29, 0x5f, 0x92, 0x89	/* t__pfx___cpuid */
	.byte 0x04, 0x74, 0xff, 0x92, 0x89	/* t__cpuid */
	.byte 0x09, 0xc6, 0xa5, 0x7c, 0xa9, 0xdd, 0xf0, 0x5f, 0x87, 0x65	/* t__pfx_mon_domain_free */
	.byte 0x09, 0x74, 0xa5, 0x7c, 0xa9, 0xdd, 0xf0, 0x5f, 0x87, 0x65	/* tmon_domain_free */
	.byte 0x0b, 0xc6, 0x6b, 0x6d, 0x08, 0xd5, 0xca, 0xb5, 0xc5, 0xb6, 0x9b, 0x66	/* t__pfx_kmalloc_array_noprof */
	.byte 0x0b, 0x74, 0x6b, 0x6d, 0x08, 0xd5, 0xca, 0xb5, 0xc5, 0xb6, 0x9b, 0x66	/* tkmalloc_array_noprof */
	.byte 0x08, 0xc6, 0x63, 0x61, 0xf9, 0x77, 0x72, 0x20, 0x72	/* t__pfx_cat_wrmsr */
	.byte 0x07, 0x2d, 0x61, 0xf9, 0x77, 0x72, 0x20, 0x72	/* tcat_wrmsr */
	.byte 0x0d, 0xc6, 0x6d, 0x62, 0x61, 0x5f, 0x77, 0x72, 0x20, 0x72, 0x5f, 0x61, 0x6d, 0x64	/* t__pfx_mba_wrmsr_amd */
	.byte 0x0d, 0x74, 0x6d, 0x62, 0x61, 0x5f, 0x77, 0x72, 0x20, 0x72, 0x5f, 0x61, 0x6d, 0x64	/* tmba_wrmsr_amd */
	.byte 0x0d, 0xc6, 0x6d, 0x62, 0x61, 0x5f, 0x77, 0x72, 0x20, 0x72, 0x5f, 0xf0, 0x9a, 0x6c	/* t__pfx_mba_wrmsr_intel */
	.byte 0x0d, 0x74, 0x6d, 0x62, 0x61, 0x5f, 0x77, 0x72, 0x20, 0x72, 0x5f, 0xf0, 0x9a, 0x6c	/* tmba_wrmsr_intel */
	.byte 0x0f, 0xc6, 0xb2, 0xa9, 0xdd, 0xf0, 0x5f, 0x69, 0xe5, 0x66, 0xde, 0x6d, 0xf6, 0xfe, 0x70, 0x65	/* t__pfx_get_domain_id_from_scope */
	.byte 0x0f, 0x74, 0xb2, 0xa9, 0xdd, 0xf0, 0x5f, 0x69, 0xe5, 0x66, 0xde, 0x6d, 0xf6, 0xfe, 0x70, 0x65	/* tget_domain_id_from_scope */
	.byte 0x0e, 0xc6, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0x6f, 0x66, 0x66, 0x88, 0xfa, 0x92	/* t__pfx_resctrl_arch_offline_cpu */
	.byte 0x0e, 0x74, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0x6f, 0x66, 0x66, 0x88, 0xfa, 0x92	/* tresctrl_arch_offline_cpu */
	.byte 0x0d, 0xc6, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0x6f, 0x6e, 0x88, 0xfa, 0x92	/* t__pfx_resctrl_arch_online_cpu */
	.byte 0x0d, 0x74, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0x6f, 0x6e, 0x88, 0xfa, 0x92	/* tresctrl_arch_online_cpu */
	.byte 0x14, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x95, 0xd6, 0x65, 0xcd, 0x6e, 0x75, 0xcd, 0x72, 0x6d, 0x69, 0xe5, 0x89, 0x78	/* T__pfx_resctrl_arch_system_num_rmid_idx */
	.byte 0x14, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x95, 0xd6, 0x65, 0xcd, 0x6e, 0x75, 0xcd, 0x72, 0x6d, 0x69, 0xe5, 0x89, 0x78	/* Tresctrl_arch_system_num_rmid_idx */
	.byte 0x08, 0xbf, 0x69, 0xe0, 0x6d, 0x62, 0x61, 0xf6, 0x63	/* T__pfx_is_mba_sc */
	.byte 0x08, 0x54, 0x69, 0xe0, 0x6d, 0x62, 0x61, 0xf6, 0x63	/* Tis_mba_sc */
	.byte 0x0d, 0xbf, 0xb2, 0x63, 0xea, 0xc3, 0xa9, 0xdd, 0xf0, 0x5f, 0x66, 0xde, 0xcd, 0x92	/* T__pfx_get_ctrl_domain_from_cpu */
	.byte 0x0d, 0x54, 0xb2, 0x63, 0xea, 0xc3, 0xa9, 0xdd, 0xf0, 0x5f, 0x66, 0xde, 0xcd, 0x92	/* Tget_ctrl_domain_from_cpu */
	.byte 0x0c, 0xbf, 0xb2, 0xa5, 0x7c, 0xa9, 0xdd, 0xf0, 0x5f, 0x66, 0xde, 0xcd, 0x92	/* T__pfx_get_mon_domain_from_cpu */
	.byte 0x0c, 0x54, 0xb2, 0xa5, 0x7c, 0xa9, 0xdd, 0xf0, 0x5f, 0x66, 0xde, 0xcd, 0x92	/* Tget_mon_domain_from_cpu */
	.byte 0x10, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0xb2, 0x6e, 0x75, 0xcd, 0x63, 0xdf, 0x73, 0x89	/* T__pfx_resctrl_arch_get_num_closid */
	.byte 0x10, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0xb2, 0x6e, 0x75, 0xcd, 0x63, 0xdf, 0x73, 0x89	/* Tresctrl_arch_get_num_closid */
	.byte 0x0a, 0xbf, 0x72, 0x64, 0xf9, 0x63, 0xea, 0xc3, 0xb9, 0x64, 0x86	/* T__pfx_rdt_ctrl_update */
	.byte 0x0a, 0x54, 0x72, 0x64, 0xf9, 0x63, 0xea, 0xc3, 0xb9, 0x64, 0x86	/* Trdt_ctrl_update */
	.byte 0x0a, 0xbf, 0x72, 0x64, 0xf9, 0x66, 0xf0, 0xe5, 0xa9, 0xdd, 0xf0	/* T__pfx_rdt_find_domain */
	.byte 0x0a, 0x54, 0x72, 0x64, 0xf9, 0x66, 0xf0, 0xe5, 0xa9, 0xdd, 0xf0	/* Trdt_find_domain */
	.byte 0x0a, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0x92, 0x5f, 0xe6, 0x9a, 0x7b	/* T__pfx_resctrl_cpu_detect */
	.byte 0x0a, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0x92, 0x5f, 0xe6, 0x9a, 0x7b	/* Tresctrl_cpu_detect */
	.byte 0x0c, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0xb9, 0xba, 0x71, 0xb8, 0xb3, 0x73, 0x26	/* t__pfx_rdtgroup_seqfile_show */
	.byte 0x0b, 0xea, 0x64, 0x74, 0x0d, 0xb9, 0xba, 0x71, 0xb8, 0xb3, 0x73, 0x26	/* trdtgroup_seqfile_show */
	.byte 0x0a, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0xb8, 0xb3, 0x24, 0x65	/* t__pfx_rdtgroup_file_write */
	.byte 0x09, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0xb8, 0xb3, 0x24, 0x65	/* trdtgroup_file_write */
	.byte 0x0f, 0xa8, 0xf6, 0xb9, 0x70, 0xce, 0x74, 0xe0, 0x6d, 0x62, 0x61, 0x5f, 0x6d, 0x62, 0x70, 0x73	/* t__pfx_supports_mba_mbps */
	.byte 0x0f, 0x74, 0x73, 0xb9, 0x70, 0xce, 0x74, 0xe0, 0x6d, 0x62, 0x61, 0x5f, 0x6d, 0x62, 0x70, 0x73	/* tsupports_mba_mbps */
	.byte 0x0d, 0xc6, 0x6b, 0xee, 0x6e, 0x66, 0xe0, 0xac, 0x5f, 0x72, 0x64, 0x74, 0x0d, 0xb9	/* t__pfx_kernfs_to_rdtgroup */
	.byte 0x0d, 0x74, 0x6b, 0xee, 0x6e, 0x66, 0xe0, 0xac, 0x5f, 0x72, 0x64, 0x74, 0x0d, 0xb9	/* tkernfs_to_rdtgroup */
	.byte 0x07, 0xa8, 0x1f, 0x6d, 0x62, 0x61, 0xf6, 0x63	/* t__pfx_set_mba_sc */
	.byte 0x08, 0x74, 0xc9, 0xf9, 0x6d, 0x62, 0x61, 0xf6, 0x63	/* tset_mba_sc */
	.byte 0x0b, 0xc6, 0x72, 0x64, 0xf9, 0xa5, 0x22, 0x0d, 0x3a, 0xdb, 0x16, 0x73	/* t__pfx_rdt_move_group_tasks */
	.byte 0x0a, 0xea, 0x64, 0xf9, 0xa5, 0x22, 0x0d, 0x3a, 0xdb, 0x16, 0x73	/* trdt_move_group_tasks */
	.byte 0x0e, 0xa8, 0xf6, 0x7e, 0x6d, 0x0f, 0x5f, 0x6c, 0xab, 0xf9, 0xe6, 0x73, 0xea, 0x6f, 0x79	/* t__pfx_schemata_list_destroy */
	.byte 0x0e, 0x74, 0x73, 0x7e, 0x6d, 0x0f, 0x5f, 0x6c, 0xab, 0xf9, 0xe6, 0x73, 0xea, 0x6f, 0x79	/* tschemata_list_destroy */
	.byte 0x0a, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x7c, 0xda, 0x74	/* t__pfx_rdtgroup_kn_get */
	.byte 0x09, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x7c, 0xda, 0x74	/* trdtgroup_kn_get */
	.byte 0x0c, 0xa8, 0x1f, 0x63, 0xeb, 0x68, 0xfa, 0x71, 0x6f, 0xe0, 0x63, 0x66, 0x67	/* t__pfx_set_cache_qos_cfg */
	.byte 0x0d, 0x74, 0xc9, 0xf9, 0x63, 0xeb, 0x68, 0xfa, 0x71, 0x6f, 0xe0, 0x63, 0x66, 0x67	/* tset_cache_qos_cfg */
	.byte 0x0c, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x6e, 0x1f, 0x75, 0x67, 0x89	/* t__pfx_rdtgroup_kn_set_ugid */
	.byte 0x0b, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x6e, 0x1f, 0x75, 0x67, 0x89	/* trdtgroup_kn_set_ugid */
	.byte 0x0e, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0xb9, 0xf6, 0xad, 0xaa, 0x81, 0x74, 0xd9, 0x6e, 0x73	/* t__pfx_rdtgroup_show_options */
	.byte 0x0d, 0xea, 0x64, 0x74, 0x0d, 0xb9, 0xf6, 0xad, 0xaa, 0x81, 0x74, 0xd9, 0x6e, 0x73	/* trdtgroup_show_options */
	.byte 0x11, 0xc6, 0x72, 0x64, 0xf9, 0x15, 0xf8, 0x05, 0x15, 0xde, 0x74, 0x74, 0xb3, 0xa5, 0x64, 0xfa, 0x73, 0x26	/* t__pfx_rdt_thread_throttle_mode_show */
	.byte 0x10, 0xea, 0x64, 0xf9, 0x15, 0xf8, 0x05, 0x15, 0xde, 0x74, 0x74, 0xb3, 0xa5, 0x64, 0xfa, 0x73, 0x26	/* trdt_thread_throttle_mode_show */
	.byte 0x09, 0xc6, 0xa5, 0x7c, 0xaf, 0x98, 0xb8, 0xa6, 0xf8, 0xc7	/* t__pfx_mon_event_config_read */
	.byte 0x09, 0x74, 0xa5, 0x7c, 0xaf, 0x98, 0xb8, 0xa6, 0xf8, 0xc7	/* tmon_event_config_read */
	.byte 0x12, 0xc6, 0x72, 0x64, 0xf9, 0x68, 0x96, 0xf6, 0x70, 0xca, 0x73, 0xfa, 0x62, 0xe4, 0xdd, 0x16, 0x73, 0xf6, 0x26	/* t__pfx_rdt_has_sparse_bitmasks_show */
	.byte 0x11, 0xea, 0x64, 0xf9, 0x68, 0x96, 0xf6, 0x70, 0xca, 0x73, 0xfa, 0x62, 0xe4, 0xdd, 0x16, 0x73, 0xf6, 0x26	/* trdt_has_sparse_bitmasks_show */
	.byte 0x0d, 0xc6, 0xdd, 0x1a, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x6f, 0x63, 0x63, 0xf6, 0x26	/* t__pfx_max_threshold_occ_show */
	.byte 0x0d, 0x74, 0xdd, 0x1a, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x6f, 0x63, 0x63, 0xf6, 0x26	/* tmax_threshold_occ_show */
	.byte 0x0c, 0xc6, 0x72, 0x64, 0xf9, 0xe6, 0x1b, 0xc5, 0x88, 0x65, 0xca, 0xf6, 0x26	/* t__pfx_rdt_delay_linear_show */
	.byte 0x0b, 0xea, 0x64, 0xf9, 0xe6, 0x1b, 0xc5, 0x88, 0x65, 0xca, 0xf6, 0x26	/* trdt_delay_linear_show */
	.byte 0x0b, 0xc6, 0x72, 0x64, 0xf9, 0x62, 0xaa, 0x67, 0x72, 0xcc, 0xf6, 0x26	/* t__pfx_rdt_bw_gran_show */
	.byte 0x0a, 0xea, 0x64, 0xf9, 0x62, 0xaa, 0x67, 0x72, 0xcc, 0xf6, 0x26	/* trdt_bw_gran_show */
	.byte 0x0d, 0xc6, 0x72, 0x64, 0xf9, 0xa5, 0x7c, 0x66, 0x65, 0xe9, 0x75, 0x3d, 0xf6, 0x26	/* t__pfx_rdt_mon_features_show */
	.byte 0x0c, 0xea, 0x64, 0xf9, 0xa5, 0x7c, 0x66, 0x65, 0xe9, 0x75, 0x3d, 0xf6, 0x26	/* trdt_mon_features_show */
	.byte 0x0d, 0xc6, 0x72, 0x64, 0xf9, 0x6e, 0x75, 0xcd, 0x72, 0x6d, 0x89, 0x73, 0xf6, 0x26	/* t__pfx_rdt_num_rmids_show */
	.byte 0x0c, 0xea, 0x64, 0xf9, 0x6e, 0x75, 0xcd, 0x72, 0x6d, 0x89, 0x73, 0xf6, 0x26	/* trdt_num_rmids_show */
	.byte 0x0b, 0xc6, 0x72, 0x64, 0xf9, 0x6d, 0xf0, 0x5f, 0x62, 0x77, 0xf6, 0x26	/* t__pfx_rdt_min_bw_show */
	.byte 0x0a, 0xea, 0x64, 0xf9, 0x6d, 0xf0, 0x5f, 0x62, 0x77, 0xf6, 0x26	/* trdt_min_bw_show */
	.byte 0x0f, 0xc6, 0x72, 0x64, 0xf9, 0x73, 0x68, 0x61, 0xf8, 0x80, 0xb3, 0x62, 0xe4, 0x73, 0xf6, 0x26	/* t__pfx_rdt_shareable_bits_show */
	.byte 0x0e, 0xea, 0x64, 0xf9, 0x73, 0x68, 0x61, 0xf8, 0x80, 0xb3, 0x62, 0xe4, 0x73, 0xf6, 0x26	/* trdt_shareable_bits_show */
	.byte 0x0f, 0xc6, 0x72, 0x64, 0xf9, 0x6d, 0xf0, 0x5f, 0x63, 0x62, 0xcd, 0x62, 0xe4, 0x73, 0xf6, 0x26	/* t__pfx_rdt_min_cbm_bits_show */
	.byte 0x0e, 0xea, 0x64, 0xf9, 0x6d, 0xf0, 0x5f, 0x63, 0x62, 0xcd, 0x62, 0xe4, 0x73, 0xf6, 0x26	/* trdt_min_cbm_bits_show */
	.byte 0x0e, 0xc6, 0x72, 0x64, 0xf9, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x63, 0xea, 0x6c, 0xf6, 0x26	/* t__pfx_rdt_default_ctrl_show */
	.byte 0x0d, 0xea, 0x64, 0xf9, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x63, 0xea, 0x6c, 0xf6, 0x26	/* trdt_default_ctrl_show */
	.byte 0x0e, 0xc6, 0x72, 0x64, 0xf9, 0x6e, 0x75, 0xcd, 0x63, 0xdf, 0x73, 0x89, 0x73, 0xf6, 0x26	/* t__pfx_rdt_num_closids_show */
	.byte 0x0d, 0xea, 0x64, 0xf9, 0x6e, 0x75, 0xcd, 0x63, 0xdf, 0x73, 0x89, 0x73, 0xf6, 0x26	/* trdt_num_closids_show */
	.byte 0x0f, 0xc6, 0x72, 0x64, 0xf9, 0x6c, 0x96, 0xf9, 0x63, 0x6d, 0x64, 0x2a, 0xe9, 0x5d, 0xf6, 0x26	/* t__pfx_rdt_last_cmd_status_show */
	.byte 0x0e, 0xea, 0x64, 0xf9, 0x6c, 0x96, 0xf9, 0x63, 0x6d, 0x64, 0x2a, 0xe9, 0x5d, 0xf6, 0x26	/* trdt_last_cmd_status_show */
	.byte 0x0d, 0xc6, 0xdd, 0x1a, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x6f, 0x63, 0xd5, 0x24, 0x65	/* t__pfx_max_threshold_occ_write */
	.byte 0x0d, 0x74, 0xdd, 0x1a, 0x15, 0x3d, 0xad, 0x6c, 0xe5, 0x6f, 0x63, 0xd5, 0x24, 0x65	/* tmax_threshold_occ_write */
	.byte 0x0b, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0xc7, 0xe5, 0xb8, 0xd3, 0x73	/* t__pfx_rdtgroup_add_files */
	.byte 0x0a, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0xc7, 0xe5, 0xb8, 0xd3, 0x73	/* trdtgroup_add_files */
	.byte 0x0f, 0xc6, 0xa5, 0x7c, 0x72, 0x6d, 0x64, 0xa7, 0x5f, 0x6f, 0x6e, 0xfa, 0xb7, 0x62, 0x64, 0xa7	/* t__pfx_mon_rmdir_one_subdir */
	.byte 0x0f, 0x74, 0xa5, 0x7c, 0x72, 0x6d, 0x64, 0xa7, 0x5f, 0x6f, 0x6e, 0xfa, 0xb7, 0x62, 0x64, 0xa7	/* tmon_rmdir_one_subdir */
	.byte 0x0a, 0xc6, 0xa5, 0x7c, 0xc7, 0xe5, 0xe1, 0xc3, 0xb8, 0xd3, 0x73	/* t__pfx_mon_add_all_files */
	.byte 0x0a, 0x74, 0xa5, 0x7c, 0xc7, 0xe5, 0xe1, 0xc3, 0xb8, 0xd3, 0x73	/* tmon_add_all_files */
	.byte 0x0c, 0xc6, 0x72, 0x64, 0xf9, 0x70, 0xca, 0x73, 0xfa, 0x70, 0xca, 0x61, 0x6d	/* t__pfx_rdt_parse_param */
	.byte 0x0b, 0xea, 0x64, 0xf9, 0x70, 0xca, 0x73, 0xfa, 0x70, 0xca, 0x61, 0x6d	/* trdt_parse_param */
	.byte 0x0c, 0xc6, 0x72, 0x64, 0xf9, 0x66, 0xe0, 0x98, 0x74, 0xd1, 0xf9, 0x87, 0x65	/* t__pfx_rdt_fs_context_free */
	.byte 0x0b, 0xea, 0x64, 0xf9, 0x66, 0xe0, 0x98, 0x74, 0xd1, 0xf9, 0x87, 0x65	/* trdt_fs_context_free */
	.byte 0x12, 0xc6, 0x6b, 0x6d, 0x08, 0xd5, 0xca, 0xb5, 0xc5, 0xb6, 0x9b, 0x66, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_kmalloc_array_noprof.constprop.0 */
	.byte 0x12, 0x74, 0x6b, 0x6d, 0x08, 0xd5, 0xca, 0xb5, 0xc5, 0xb6, 0x9b, 0x66, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tkmalloc_array_noprof.constprop.0 */
	.byte 0x0d, 0xc6, 0x69, 0xe0, 0xa5, 0x7c, 0x0d, 0xb9, 0x73, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_is_mon_groups.isra.0 */
	.byte 0x0c, 0xc2, 0xe0, 0xa5, 0x7c, 0x0d, 0xb9, 0x73, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tis_mon_groups.isra.0 */
	.byte 0x0e, 0xc6, 0x6d, 0x62, 0xcd, 0x98, 0xb8, 0x67, 0xf6, 0x26, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_mbm_config_show.isra.0 */
	.byte 0x0e, 0x74, 0x6d, 0x62, 0xcd, 0x98, 0xb8, 0x67, 0xf6, 0x26, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tmbm_config_show.isra.0 */
	.byte 0x11, 0xc6, 0x6d, 0x62, 0xcd, 0xac, 0x74, 0xe1, 0x5f, 0x62, 0x79, 0x9a, 0xe0, 0x98, 0xb8, 0x67, 0xf6, 0x26	/* t__pfx_mbm_total_bytes_config_show */
	.byte 0x11, 0x74, 0x6d, 0x62, 0xcd, 0xac, 0x74, 0xe1, 0x5f, 0x62, 0x79, 0x9a, 0xe0, 0x98, 0xb8, 0x67, 0xf6, 0x26	/* tmbm_total_bytes_config_show */
	.byte 0x10, 0xc6, 0x6d, 0x62, 0xcd, 0xc0, 0xe1, 0x5f, 0x62, 0x79, 0x9a, 0xe0, 0x98, 0xb8, 0x67, 0xf6, 0x26	/* t__pfx_mbm_local_bytes_config_show */
	.byte 0x10, 0x74, 0x6d, 0x62, 0xcd, 0xc0, 0xe1, 0x5f, 0x62, 0x79, 0x9a, 0xe0, 0x98, 0xb8, 0x67, 0xf6, 0x26	/* tmbm_local_bytes_config_show */
	.byte 0x0b, 0xc6, 0x72, 0x64, 0xf9, 0xf0, 0x99, 0x66, 0xe0, 0x98, 0x74, 0x97	/* t__pfx_rdt_init_fs_context */
	.byte 0x0a, 0xea, 0x64, 0xf9, 0xf0, 0x99, 0x66, 0xe0, 0x98, 0x74, 0x97	/* trdt_init_fs_context */
	.byte 0x0a, 0xa8, 0xf6, 0x7e, 0x6d, 0x0f, 0x5f, 0x6c, 0xab, 0xf9, 0x10	/* t__pfx_schemata_list_add */
	.byte 0x0a, 0x74, 0x73, 0x7e, 0x6d, 0x0f, 0x5f, 0x6c, 0xab, 0xf9, 0x10	/* tschemata_list_add */
	.byte 0x0a, 0xc6, 0xa5, 0x6e, 0x0d, 0x3a, 0x63, 0xf8, 0xa1, 0x64, 0xa7	/* t__pfx_mongroup_create_dir */
	.byte 0x0a, 0x74, 0xa5, 0x6e, 0x0d, 0x3a, 0x63, 0xf8, 0xa1, 0x64, 0xa7	/* tmongroup_create_dir */
	.byte 0x12, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x6d, 0x6b, 0x64, 0xa7, 0x5f, 0xf0, 0x66, 0x6f, 0x5f, 0x3d, 0x64, 0xa7	/* t__pfx_rdtgroup_mkdir_info_resdir */
	.byte 0x11, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0x6d, 0x6b, 0x64, 0xa7, 0x5f, 0xf0, 0x66, 0x6f, 0x5f, 0x3d, 0x64, 0xa7	/* trdtgroup_mkdir_info_resdir */
	.byte 0x0f, 0xc6, 0x87, 0xfa, 0xe1, 0xc3, 0xd0, 0x69, 0x6c, 0xe5, 0x72, 0x64, 0x74, 0x67, 0x72, 0x70	/* t__pfx_free_all_child_rdtgrp */
	.byte 0x0f, 0x74, 0x87, 0xfa, 0xe1, 0xc3, 0xd0, 0x69, 0x6c, 0xe5, 0x72, 0x64, 0x74, 0x67, 0x72, 0x70	/* tfree_all_child_rdtgrp */
	.byte 0x0d, 0xc6, 0x6c, 0x32, 0x5f, 0x71, 0x6f, 0xe0, 0x63, 0x66, 0xa6, 0xb9, 0x64, 0x86	/* t__pfx_l2_qos_cfg_update */
	.byte 0x0d, 0x74, 0x6c, 0x32, 0x5f, 0x71, 0x6f, 0xe0, 0x63, 0x66, 0xa6, 0xb9, 0x64, 0x86	/* tl2_qos_cfg_update */
	.byte 0x0d, 0xc6, 0x6c, 0x33, 0x5f, 0x71, 0x6f, 0xe0, 0x63, 0x66, 0xa6, 0xb9, 0x64, 0x86	/* t__pfx_l3_qos_cfg_update */
	.byte 0x0d, 0x74, 0x6c, 0x33, 0x5f, 0x71, 0x6f, 0xe0, 0x63, 0x66, 0xa6, 0xb9, 0x64, 0x86	/* tl3_qos_cfg_update */
	.byte 0x0f, 0xc6, 0x6d, 0x6b, 0x64, 0xa7, 0x5f, 0xa5, 0x6e, 0x64, 0x0f, 0xf6, 0x75, 0x62, 0x64, 0xa7	/* t__pfx_mkdir_mondata_subdir */
	.byte 0x0f, 0x74, 0x6d, 0x6b, 0x64, 0xa7, 0x5f, 0xa5, 0x6e, 0x64, 0x0f, 0xf6, 0x75, 0x62, 0x64, 0xa7	/* tmkdir_mondata_subdir */
	.byte 0x0d, 0xc6, 0x6d, 0x6b, 0x64, 0xa7, 0x5f, 0xa5, 0x6e, 0x64, 0x0f, 0x5f, 0xe1, 0x6c	/* t__pfx_mkdir_mondata_all */
	.byte 0x0d, 0x74, 0x6d, 0x6b, 0x64, 0xa7, 0x5f, 0xa5, 0x6e, 0x64, 0x0f, 0x5f, 0xe1, 0x6c	/* tmkdir_mondata_all */
	.byte 0x14, 0xc6, 0x6d, 0x6b, 0x64, 0xa7, 0x5f, 0x72, 0x64, 0xf9, 0x70, 0xf8, 0x70, 0xca, 0xfa, 0x72, 0x6d, 0x69, 0xe5, 0xe1, 0xc0	/* t__pfx_mkdir_rdt_prepare_rmid_alloc */
	.byte 0x14, 0x74, 0x6d, 0x6b, 0x64, 0xa7, 0x5f, 0x72, 0x64, 0xf9, 0x70, 0xf8, 0x70, 0xca, 0xfa, 0x72, 0x6d, 0x69, 0xe5, 0xe1, 0xc0	/* tmkdir_rdt_prepare_rmid_alloc */
	.byte 0x09, 0xc6, 0xa5, 0x7c, 0xaf, 0x98, 0xb8, 0xa6, 0x24, 0x65	/* t__pfx_mon_event_config_write */
	.byte 0x09, 0x74, 0xa5, 0x7c, 0xaf, 0x98, 0xb8, 0xa6, 0x24, 0x65	/* tmon_event_config_write */
	.byte 0x0a, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x6e, 0xe7, 0x5e	/* t__pfx_rdtgroup_kn_put */
	.byte 0x09, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x6e, 0xe7, 0x5e	/* trdtgroup_kn_put */
	.byte 0x0a, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0xf8, 0x6e, 0x61, 0xbd	/* t__pfx_rdtgroup_rename */
	.byte 0x09, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0xf8, 0x6e, 0x61, 0xbd	/* trdtgroup_rename */
	.byte 0x09, 0xc6, 0x3d, 0x63, 0xea, 0x6c, 0xf6, 0x7e, 0xe5, 0xf0	/* t__pfx_resctrl_sched_in */
	.byte 0x09, 0x74, 0x3d, 0x63, 0xea, 0x6c, 0xf6, 0x7e, 0xe5, 0xf0	/* tresctrl_sched_in */
	.byte 0x0f, 0x29, 0xb9, 0x64, 0xa1, 0xdb, 0x73, 0xd8, 0x63, 0xdf, 0x73, 0x69, 0xe5, 0x72, 0x6d, 0x89	/* t__pfx__update_task_closid_rmid */
	.byte 0x0f, 0xf9, 0xb9, 0x64, 0xa1, 0xdb, 0x73, 0xd8, 0x63, 0xdf, 0x73, 0x69, 0xe5, 0x72, 0x6d, 0x89	/* t_update_task_closid_rmid */
	.byte 0x0e, 0xc6, 0xb9, 0x64, 0xa1, 0x92, 0x5f, 0x63, 0xdf, 0x73, 0x69, 0xe5, 0x72, 0x6d, 0x89	/* t__pfx_update_cpu_closid_rmid */
	.byte 0x0e, 0x74, 0xb9, 0x64, 0xa1, 0x92, 0x5f, 0x63, 0xdf, 0x73, 0x69, 0xe5, 0x72, 0x6d, 0x89	/* tupdate_cpu_closid_rmid */
	.byte 0x0d, 0xbf, 0x72, 0x64, 0xf9, 0x6c, 0x96, 0xf9, 0x63, 0x6d, 0xe5, 0x63, 0xd3, 0xca	/* T__pfx_rdt_last_cmd_clear */
	.byte 0x0d, 0x54, 0x72, 0x64, 0xf9, 0x6c, 0x96, 0xf9, 0x63, 0x6d, 0xe5, 0x63, 0xd3, 0xca	/* Trdt_last_cmd_clear */
	.byte 0x0d, 0xbf, 0x72, 0x64, 0xf9, 0x6c, 0x96, 0xf9, 0x63, 0x6d, 0x64, 0xe7, 0x5e, 0x73	/* T__pfx_rdt_last_cmd_puts */
	.byte 0x0d, 0x54, 0x72, 0x64, 0xf9, 0x6c, 0x96, 0xf9, 0x63, 0x6d, 0x64, 0xe7, 0x5e, 0x73	/* Trdt_last_cmd_puts */
	.byte 0x0f, 0xbf, 0x72, 0x64, 0xf9, 0x6c, 0x96, 0xf9, 0x63, 0x6d, 0x64, 0xe7, 0x72, 0xf0, 0x74, 0x66	/* T__pfx_rdt_last_cmd_printf */
	.byte 0x0f, 0x54, 0x72, 0x64, 0xf9, 0x6c, 0x96, 0xf9, 0x63, 0x6d, 0x64, 0xe7, 0x72, 0xf0, 0x74, 0x66	/* Trdt_last_cmd_printf */
	.byte 0x08, 0xc6, 0xa5, 0x7c, 0x98, 0xb8, 0xa6, 0x24, 0x65	/* t__pfx_mon_config_write */
	.byte 0x08, 0x74, 0xa5, 0x7c, 0x98, 0xb8, 0xa6, 0x24, 0x65	/* tmon_config_write */
	.byte 0x10, 0xc6, 0x6d, 0x62, 0xcd, 0xc0, 0xe1, 0x5f, 0x62, 0x79, 0x9a, 0xe0, 0x98, 0xb8, 0xa6, 0x24, 0x65	/* t__pfx_mbm_local_bytes_config_write */
	.byte 0x10, 0x74, 0x6d, 0x62, 0xcd, 0xc0, 0xe1, 0x5f, 0x62, 0x79, 0x9a, 0xe0, 0x98, 0xb8, 0xa6, 0x24, 0x65	/* tmbm_local_bytes_config_write */
	.byte 0x11, 0xc6, 0x6d, 0x62, 0xcd, 0xac, 0x74, 0xe1, 0x5f, 0x62, 0x79, 0x9a, 0xe0, 0x98, 0xb8, 0xa6, 0x24, 0x65	/* t__pfx_mbm_total_bytes_config_write */
	.byte 0x11, 0x74, 0x6d, 0x62, 0xcd, 0xac, 0x74, 0xe1, 0x5f, 0x62, 0x79, 0x9a, 0xe0, 0x98, 0xb8, 0xa6, 0x24, 0x65	/* tmbm_total_bytes_config_write */
	.byte 0x0f, 0xbf, 0x72, 0x64, 0xf9, 0x73, 0xdb, 0xda, 0xe5, 0x98, 0xb8, 0x67, 0xe0, 0x63, 0xd3, 0xca	/* T__pfx_rdt_staged_configs_clear */
	.byte 0x0f, 0x54, 0x72, 0x64, 0xf9, 0x73, 0xdb, 0xda, 0xe5, 0x98, 0xb8, 0x67, 0xe0, 0x63, 0xd3, 0xca	/* Trdt_staged_configs_clear */
	.byte 0x0c, 0xbf, 0x63, 0xdf, 0x73, 0x89, 0x73, 0xf6, 0xb9, 0x70, 0xce, 0x9a, 0x64	/* T__pfx_closids_supported */
	.byte 0x0c, 0x54, 0x63, 0xdf, 0x73, 0x89, 0x73, 0xf6, 0xb9, 0x70, 0xce, 0x9a, 0x64	/* Tclosids_supported */
	.byte 0x08, 0xbf, 0x63, 0xdf, 0x73, 0x69, 0xe5, 0x87, 0x65	/* T__pfx_closid_free */
	.byte 0x08, 0x54, 0x63, 0xdf, 0x73, 0x69, 0xe5, 0x87, 0x65	/* Tclosid_free */
	.byte 0x0a, 0xbf, 0x63, 0xdf, 0x73, 0x69, 0xe5, 0xe1, 0xc0, 0x86, 0x64	/* T__pfx_closid_allocated */
	.byte 0x0a, 0x54, 0x63, 0xdf, 0x73, 0x69, 0xe5, 0xe1, 0xc0, 0x86, 0x64	/* Tclosid_allocated */
	.byte 0x0f, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0xa5, 0x64, 0xfa, 0x62, 0xc5, 0x63, 0xdf, 0x73, 0x89	/* T__pfx_rdtgroup_mode_by_closid */
	.byte 0x0f, 0x54, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0xa5, 0x64, 0xfa, 0x62, 0xc5, 0x63, 0xdf, 0x73, 0x89	/* Trdtgroup_mode_by_closid */
	.byte 0x10, 0x29, 0x5f, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x63, 0x62, 0xcd, 0x6f, 0x76, 0xee, 0x1b, 0x70, 0x73	/* t__pfx___rdtgroup_cbm_overlaps */
	.byte 0x10, 0x74, 0xff, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x63, 0x62, 0xcd, 0x6f, 0x76, 0xee, 0x1b, 0x70, 0x73	/* t__rdtgroup_cbm_overlaps */
	.byte 0x0b, 0xc6, 0x72, 0x64, 0xf9, 0x62, 0x99, 0x5d, 0x61, 0x21, 0x73, 0x26	/* t__pfx_rdt_bit_usage_show */
	.byte 0x0a, 0xea, 0x64, 0xf9, 0x62, 0x99, 0x5d, 0x61, 0x21, 0x73, 0x26	/* trdt_bit_usage_show */
	.byte 0x0e, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0xdb, 0x16, 0xe0, 0x96, 0x73, 0x2c, 0xb4, 0x64	/* T__pfx_rdtgroup_tasks_assigned */
	.byte 0x0e, 0x54, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0xdb, 0x16, 0xe0, 0x96, 0x73, 0x2c, 0xb4, 0x64	/* Trdtgroup_tasks_assigned */
	.byte 0x09, 0x3f, 0x25, 0xd5, 0x3d, 0x63, 0xea, 0x6c, 0xf6, 0x26	/* T__pfx_proc_resctrl_show */
	.byte 0x09, 0x54, 0x9b, 0xd5, 0x3d, 0x63, 0xea, 0x6c, 0xf6, 0x26	/* Tproc_resctrl_show */
	.byte 0x0f, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x63, 0x62, 0xcd, 0x6f, 0x76, 0xee, 0x1b, 0x70, 0x73	/* T__pfx_rdtgroup_cbm_overlaps */
	.byte 0x0f, 0x54, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x63, 0x62, 0xcd, 0x6f, 0x76, 0xee, 0x1b, 0x70, 0x73	/* Trdtgroup_cbm_overlaps */
	.byte 0x0e, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x63, 0x62, 0xcd, 0xac, 0xf6, 0x69, 0x7a, 0x65	/* T__pfx_rdtgroup_cbm_to_size */
	.byte 0x0e, 0x54, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x63, 0x62, 0xcd, 0xac, 0xf6, 0x69, 0x7a, 0x65	/* Trdtgroup_cbm_to_size */
	.byte 0x0f, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x7c, 0xa5, 0x64, 0xfa, 0x3d, 0xea, 0xa3, 0x74	/* T__pfx_rdtgroup_kn_mode_restrict */
	.byte 0x0f, 0x54, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x7c, 0xa5, 0x64, 0xfa, 0x3d, 0xea, 0xa3, 0x74	/* Trdtgroup_kn_mode_restrict */
	.byte 0x0f, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x7c, 0xa5, 0x64, 0xfa, 0xf8, 0xd6, 0x6f, 0xf8	/* T__pfx_rdtgroup_kn_mode_restore */
	.byte 0x0f, 0x54, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x7c, 0xa5, 0x64, 0xfa, 0xf8, 0xd6, 0x6f, 0xf8	/* Trdtgroup_kn_mode_restore */
	.byte 0x11, 0xbf, 0x72, 0x64, 0xf9, 0xa9, 0xdd, 0xf0, 0x5f, 0xf8, 0x98, 0xb8, 0x67, 0x1d, 0xfa, 0x63, 0x64, 0x70	/* T__pfx_rdt_domain_reconfigure_cdp */
	.byte 0x11, 0x54, 0x72, 0x64, 0xf9, 0xa9, 0xdd, 0xf0, 0x5f, 0xf8, 0x98, 0xb8, 0x67, 0x1d, 0xfa, 0x63, 0x64, 0x70	/* Trdt_domain_reconfigure_cdp */
	.byte 0x0f, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x1f, 0x63, 0x64, 0xe2, 0xe8, 0x80, 0xd3, 0x64	/* T__pfx_resctrl_arch_set_cdp_enabled */
	.byte 0x0f, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x1f, 0x63, 0x64, 0xe2, 0xe8, 0x80, 0xd3, 0x64	/* Tresctrl_arch_set_cdp_enabled */
	.byte 0x0a, 0xc6, 0x72, 0x64, 0xf9, 0x64, 0xab, 0x80, 0xb3, 0x7b, 0x78	/* t__pfx_rdt_disable_ctx */
	.byte 0x09, 0xea, 0x64, 0xf9, 0x64, 0xab, 0x80, 0xb3, 0x7b, 0x78	/* trdt_disable_ctx */
	.byte 0x0a, 0xc6, 0x72, 0x64, 0xf9, 0x6b, 0x69, 0x6c, 0x6c, 0xf6, 0x62	/* t__pfx_rdt_kill_sb */
	.byte 0x09, 0xea, 0x64, 0xf9, 0x6b, 0x69, 0x6c, 0x6c, 0xf6, 0x62	/* trdt_kill_sb */
	.byte 0x08, 0xc6, 0x72, 0x64, 0xf9, 0xb2, 0x74, 0xf8, 0x65	/* t__pfx_rdt_get_tree */
	.byte 0x07, 0xea, 0x64, 0xf9, 0xb2, 0x74, 0xf8, 0x65	/* trdt_get_tree */
	.byte 0x0e, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x7c, 0xc0, 0xd8, 0x6c, 0x69, 0x76, 0x65	/* T__pfx_rdtgroup_kn_lock_live */
	.byte 0x0e, 0x54, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x7c, 0xc0, 0xd8, 0x6c, 0x69, 0x76, 0x65	/* Trdtgroup_kn_lock_live */
	.byte 0x0a, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x7c, 0xd4, 0x3c	/* T__pfx_rdtgroup_kn_unlock */
	.byte 0x0a, 0x54, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x6b, 0x7c, 0xd4, 0x3c	/* Trdtgroup_kn_unlock */
	.byte 0x0a, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x72, 0x6d, 0x64, 0xa7	/* t__pfx_rdtgroup_rmdir */
	.byte 0x09, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0x72, 0x6d, 0x64, 0xa7	/* trdtgroup_rmdir */
	.byte 0x0e, 0xc6, 0x6d, 0x6b, 0x64, 0xa7, 0x5f, 0x72, 0x64, 0xf9, 0x70, 0xf8, 0x70, 0x61, 0xf8	/* t__pfx_mkdir_rdt_prepare */
	.byte 0x0e, 0x74, 0x6d, 0x6b, 0x64, 0xa7, 0x5f, 0x72, 0x64, 0xf9, 0x70, 0xf8, 0x70, 0x61, 0xf8	/* tmkdir_rdt_prepare */
	.byte 0x0a, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x6d, 0x6b, 0x64, 0xa7	/* t__pfx_rdtgroup_mkdir */
	.byte 0x09, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0x6d, 0x6b, 0x64, 0xa7	/* trdtgroup_mkdir */
	.byte 0x0c, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0xb9, 0xf6, 0x69, 0x7a, 0xfa, 0x73, 0x26	/* t__pfx_rdtgroup_size_show */
	.byte 0x0b, 0xea, 0x64, 0x74, 0x0d, 0xb9, 0xf6, 0x69, 0x7a, 0xfa, 0x73, 0x26	/* trdtgroup_size_show */
	.byte 0x0b, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0xa5, 0x64, 0xfa, 0x24, 0x65	/* t__pfx_rdtgroup_mode_write */
	.byte 0x0a, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0xa5, 0x64, 0xfa, 0x24, 0x65	/* trdtgroup_mode_write */
	.byte 0x0b, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0xa5, 0x64, 0xfa, 0x73, 0x26	/* t__pfx_rdtgroup_mode_show */
	.byte 0x0a, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0xa5, 0x64, 0xfa, 0x73, 0x26	/* trdtgroup_mode_show */
	.byte 0x0b, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x72, 0x6d, 0x89, 0xf6, 0x26	/* t__pfx_rdtgroup_rmid_show */
	.byte 0x0a, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0x72, 0x6d, 0x89, 0xf6, 0x26	/* trdtgroup_rmid_show */
	.byte 0x0c, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x63, 0xdf, 0x73, 0x89, 0xf6, 0x26	/* t__pfx_rdtgroup_closid_show */
	.byte 0x0b, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0x63, 0xdf, 0x73, 0x89, 0xf6, 0x26	/* trdtgroup_closid_show */
	.byte 0x0b, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0xdb, 0x16, 0x73, 0xf6, 0x26	/* t__pfx_rdtgroup_tasks_show */
	.byte 0x0a, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0xdb, 0x16, 0x73, 0xf6, 0x26	/* trdtgroup_tasks_show */
	.byte 0x0b, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0xdb, 0x16, 0xe0, 0x24, 0x65	/* t__pfx_rdtgroup_tasks_write */
	.byte 0x0a, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0xdb, 0x16, 0xe0, 0x24, 0x65	/* trdtgroup_tasks_write */
	.byte 0x0a, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x92, 0xe0, 0x24, 0x65	/* t__pfx_rdtgroup_cpus_write */
	.byte 0x09, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0x92, 0xe0, 0x24, 0x65	/* trdtgroup_cpus_write */
	.byte 0x0a, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x92, 0x73, 0xf6, 0x26	/* t__pfx_rdtgroup_cpus_show */
	.byte 0x09, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0x92, 0x73, 0xf6, 0x26	/* trdtgroup_cpus_show */
	.byte 0x10, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0x6f, 0x66, 0x66, 0x88, 0xfa, 0x63, 0xea, 0xc3, 0xa9, 0xdd, 0xf0	/* T__pfx_resctrl_offline_ctrl_domain */
	.byte 0x10, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0x6f, 0x66, 0x66, 0x88, 0xfa, 0x63, 0xea, 0xc3, 0xa9, 0xdd, 0xf0	/* Tresctrl_offline_ctrl_domain */
	.byte 0x0f, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0x6f, 0x66, 0x66, 0x88, 0xfa, 0xa5, 0x7c, 0xa9, 0xdd, 0xf0	/* T__pfx_resctrl_offline_mon_domain */
	.byte 0x0f, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0x6f, 0x66, 0x66, 0x88, 0xfa, 0xa5, 0x7c, 0xa9, 0xdd, 0xf0	/* Tresctrl_offline_mon_domain */
	.byte 0x0f, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0x6f, 0x6e, 0x88, 0xfa, 0x63, 0xea, 0xc3, 0xa9, 0xdd, 0xf0	/* T__pfx_resctrl_online_ctrl_domain */
	.byte 0x0f, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0x6f, 0x6e, 0x88, 0xfa, 0x63, 0xea, 0xc3, 0xa9, 0xdd, 0xf0	/* Tresctrl_online_ctrl_domain */
	.byte 0x0e, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0x6f, 0x6e, 0x88, 0xfa, 0xa5, 0x7c, 0xa9, 0xdd, 0xf0	/* T__pfx_resctrl_online_mon_domain */
	.byte 0x0e, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0x6f, 0x6e, 0x88, 0xfa, 0xa5, 0x7c, 0xa9, 0xdd, 0xf0	/* Tresctrl_online_mon_domain */
	.byte 0x0a, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0x6f, 0x6e, 0x88, 0xfa, 0x92	/* T__pfx_resctrl_online_cpu */
	.byte 0x0a, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0x6f, 0x6e, 0x88, 0xfa, 0x92	/* Tresctrl_online_cpu */
	.byte 0x0b, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0x6f, 0x66, 0x66, 0x88, 0xfa, 0x92	/* T__pfx_resctrl_offline_cpu */
	.byte 0x0b, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0x6f, 0x66, 0x66, 0x88, 0xfa, 0x92	/* Tresctrl_offline_cpu */
	.byte 0x0a, 0xc6, 0xb2, 0xca, 0xd0, 0x5f, 0x6d, 0x62, 0x6d, 0x2a, 0x86	/* t__pfx_get_arch_mbm_state */
	.byte 0x0a, 0x74, 0xb2, 0xca, 0xd0, 0x5f, 0x6d, 0x62, 0x6d, 0x2a, 0x86	/* tget_arch_mbm_state */
	.byte 0x0c, 0x29, 0x5f, 0x72, 0x6d, 0x69, 0xe5, 0xf8, 0xc7, 0xe7, 0x68, 0x79, 0x73	/* t__pfx___rmid_read_phys */
	.byte 0x0c, 0x74, 0xff, 0x72, 0x6d, 0x69, 0xe5, 0xf8, 0xc7, 0xe7, 0x68, 0x79, 0x73	/* t__rmid_read_phys */
	.byte 0x0f, 0xc6, 0x92, 0xdd, 0x73, 0xd8, 0xcc, 0xc5, 0xad, 0x75, 0xc9, 0x0e, 0x65, 0x70, 0xf0, 0x67	/* t__pfx_cpumask_any_housekeeping */
	.byte 0x0f, 0x74, 0x92, 0xdd, 0x73, 0xd8, 0xcc, 0xc5, 0xad, 0x75, 0xc9, 0x0e, 0x65, 0x70, 0xf0, 0x67	/* tcpumask_any_housekeeping */
	.byte 0x0e, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0xf8, 0xc9, 0xf9, 0x72, 0x6d, 0x89	/* T__pfx_resctrl_arch_reset_rmid */
	.byte 0x0e, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0xf8, 0xc9, 0xf9, 0x72, 0x6d, 0x89	/* Tresctrl_arch_reset_rmid */
	.byte 0x11, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0xf8, 0xc9, 0xf9, 0x72, 0x6d, 0x69, 0xe5, 0xe1, 0x6c	/* T__pfx_resctrl_arch_reset_rmid_all */
	.byte 0x11, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0xf8, 0xc9, 0xf9, 0x72, 0x6d, 0x69, 0xe5, 0xe1, 0x6c	/* Tresctrl_arch_reset_rmid_all */
	.byte 0x0e, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0x72, 0x6d, 0x69, 0xe5, 0xf8, 0xc7	/* T__pfx_resctrl_arch_rmid_read */
	.byte 0x0e, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0x72, 0x6d, 0x69, 0xe5, 0xf8, 0xc7	/* Tresctrl_arch_rmid_read */
	.byte 0x08, 0x29, 0x5f, 0xa5, 0x7c, 0xaf, 0xfe, 0xd4, 0x74	/* t__pfx___mon_event_count */
	.byte 0x08, 0x74, 0xff, 0xa5, 0x7c, 0xaf, 0xfe, 0xd4, 0x74	/* t__mon_event_count */
	.byte 0x0e, 0xc6, 0x6d, 0x62, 0xcd, 0xb9, 0x64, 0x86, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_mbm_update.constprop.0 */
	.byte 0x0e, 0x74, 0x6d, 0x62, 0xcd, 0xb9, 0x64, 0x86, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tmbm_update.constprop.0 */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x7e, 0x63, 0xd8, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* T__pfx___check_limbo */
	.byte 0x09, 0x2f, 0x7e, 0x63, 0xd8, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* T__check_limbo */
	.byte 0x0a, 0xbf, 0x68, 0x61, 0xe0, 0xa2, 0x73, 0xc5, 0x72, 0x6d, 0x89	/* T__pfx_has_busy_rmid */
	.byte 0x0a, 0x54, 0x68, 0x61, 0xe0, 0xa2, 0x73, 0xc5, 0x72, 0x6d, 0x89	/* Thas_busy_rmid */
	.byte 0x11, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0x66, 0xf0, 0xe5, 0x63, 0xd3, 0xcc, 0x3b, 0xf9, 0x63, 0xdf, 0x73, 0x89	/* T__pfx_resctrl_find_cleanest_closid */
	.byte 0x11, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0x66, 0xf0, 0xe5, 0x63, 0xd3, 0xcc, 0x3b, 0xf9, 0x63, 0xdf, 0x73, 0x89	/* Tresctrl_find_cleanest_closid */
	.byte 0x06, 0xbf, 0x08, 0xd5, 0x72, 0x6d, 0x89	/* T__pfx_alloc_rmid */
	.byte 0x06, 0x54, 0x08, 0xd5, 0x72, 0x6d, 0x89	/* Talloc_rmid */
	.byte 0x07, 0xbf, 0xa5, 0x7c, 0xaf, 0xfe, 0xd4, 0x74	/* T__pfx_mon_event_count */
	.byte 0x07, 0x54, 0xa5, 0x7c, 0xaf, 0xfe, 0xd4, 0x74	/* Tmon_event_count */
	.byte 0x0d, 0xbf, 0x63, 0x71, 0xcd, 0x68, 0xcc, 0x64, 0xb3, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* T__pfx_cqm_handle_limbo */
	.byte 0x0d, 0x54, 0x63, 0x71, 0xcd, 0x68, 0xcc, 0x64, 0xb3, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* Tcqm_handle_limbo */
	.byte 0x12, 0xbf, 0x63, 0x71, 0x6d, 0xba, 0x74, 0x3a, 0x6c, 0x69, 0x6d, 0x62, 0x6f, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_cqm_setup_limbo_handler */
	.byte 0x12, 0x54, 0x63, 0x71, 0x6d, 0xba, 0x74, 0x3a, 0x6c, 0x69, 0x6d, 0x62, 0x6f, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Tcqm_setup_limbo_handler */
	.byte 0x06, 0xbf, 0x87, 0xfa, 0x72, 0x6d, 0x89	/* T__pfx_free_rmid */
	.byte 0x06, 0x54, 0x87, 0xfa, 0x72, 0x6d, 0x89	/* Tfree_rmid */
	.byte 0x0e, 0xbf, 0x6d, 0x62, 0xcd, 0x68, 0xcc, 0x64, 0xb3, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0x77	/* T__pfx_mbm_handle_overflow */
	.byte 0x0e, 0x54, 0x6d, 0x62, 0xcd, 0x68, 0xcc, 0x64, 0xb3, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0x77	/* Tmbm_handle_overflow */
	.byte 0x12, 0xbf, 0x6d, 0x62, 0x6d, 0xba, 0x74, 0x3a, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0xaa, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_mbm_setup_overflow_handler */
	.byte 0x12, 0x54, 0x6d, 0x62, 0x6d, 0xba, 0x74, 0x3a, 0x6f, 0x76, 0xee, 0x66, 0xdf, 0xaa, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Tmbm_setup_overflow_handler */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0xa5, 0x7c, 0xa9, 0xdd, 0xf0, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* T__pfx_arch_mon_domain_online */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0xa5, 0x7c, 0xa9, 0xdd, 0xf0, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* Tarch_mon_domain_online */
	.byte 0x0a, 0xa8, 0xf6, 0x6d, 0xe2, 0xa5, 0x7c, 0xaf, 0xfe, 0xd4, 0x74	/* t__pfx_smp_mon_event_count */
	.byte 0x0a, 0x74, 0x73, 0x6d, 0xe2, 0xa5, 0x7c, 0xaf, 0xfe, 0xd4, 0x74	/* tsmp_mon_event_count */
	.byte 0x07, 0x3f, 0xe7, 0xca, 0x73, 0xfa, 0x62, 0x77	/* T__pfx_parse_bw */
	.byte 0x07, 0x54, 0x70, 0xca, 0x73, 0xfa, 0x62, 0x77	/* Tparse_bw */
	.byte 0x08, 0x3f, 0xe7, 0xca, 0x73, 0xfa, 0x63, 0x62, 0x6d	/* T__pfx_parse_cbm */
	.byte 0x08, 0x54, 0x70, 0xca, 0x73, 0xfa, 0x63, 0x62, 0x6d	/* Tparse_cbm */
	.byte 0x0d, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0xb9, 0x64, 0xa1, 0x6f, 0xb4	/* T__pfx_resctrl_arch_update_one */
	.byte 0x0d, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0xb9, 0x64, 0xa1, 0x6f, 0xb4	/* Tresctrl_arch_update_one */
	.byte 0x0f, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0xb9, 0x64, 0xa1, 0xa9, 0xdd, 0xf0, 0x73	/* T__pfx_resctrl_arch_update_domains */
	.byte 0x0f, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0xb9, 0x64, 0xa1, 0xa9, 0xdd, 0xf0, 0x73	/* Tresctrl_arch_update_domains */
	.byte 0x0d, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0xb9, 0xf6, 0x7e, 0x6d, 0x0f, 0x5f, 0x24, 0x65	/* T__pfx_rdtgroup_schemata_write */
	.byte 0x0d, 0x54, 0x72, 0x64, 0x74, 0x0d, 0xb9, 0xf6, 0x7e, 0x6d, 0x0f, 0x5f, 0x24, 0x65	/* Trdtgroup_schemata_write */
	.byte 0x0c, 0xbf, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0xb2, 0x98, 0xb8, 0x67	/* T__pfx_resctrl_arch_get_config */
	.byte 0x0c, 0x54, 0x3d, 0x63, 0xea, 0xc3, 0xca, 0xd0, 0x5f, 0xb2, 0x98, 0xb8, 0x67	/* Tresctrl_arch_get_config */
	.byte 0x0c, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0xb9, 0xf6, 0x7e, 0x6d, 0x0f, 0xf6, 0x26	/* T__pfx_rdtgroup_schemata_show */
	.byte 0x0c, 0x54, 0x72, 0x64, 0x74, 0x0d, 0xb9, 0xf6, 0x7e, 0x6d, 0x0f, 0xf6, 0x26	/* Trdtgroup_schemata_show */
	.byte 0x06, 0xbf, 0xa5, 0x7c, 0xaf, 0xf8, 0xc7	/* T__pfx_mon_event_read */
	.byte 0x06, 0x54, 0xa5, 0x7c, 0xaf, 0xf8, 0xc7	/* Tmon_event_read */
	.byte 0x0c, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0xa5, 0x6e, 0x64, 0x0f, 0xf6, 0x26	/* T__pfx_rdtgroup_mondata_show */
	.byte 0x0c, 0x54, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0xa5, 0x6e, 0x64, 0x0f, 0xf6, 0x26	/* Trdtgroup_mondata_show */
	.byte 0x14, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xee, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0xcd, 0x6c, 0xe9, 0xe8, 0x63, 0x79	/* T__pfx___traceiter_pseudo_lock_mem_latency */
	.byte 0x12, 0x2f, 0x01, 0xe4, 0xee, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0xcd, 0x6c, 0xe9, 0xe8, 0x63, 0x79	/* T__traceiter_pseudo_lock_mem_latency */
	.byte 0x15, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0x62, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0xcd, 0x6c, 0xe9, 0xe8, 0x63, 0x79	/* T__pfx___probestub_pseudo_lock_mem_latency */
	.byte 0x14, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0x62, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0xcd, 0x6c, 0xe9, 0xe8, 0x63, 0x79	/* T__probestub_pseudo_lock_mem_latency */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xee, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x32	/* T__pfx___traceiter_pseudo_lock_l2 */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xee, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x32	/* T__traceiter_pseudo_lock_l2 */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0x62, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x32	/* T__pfx___probestub_pseudo_lock_l2 */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0x62, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x32	/* T__probestub_pseudo_lock_l2 */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xee, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x33	/* T__pfx___traceiter_pseudo_lock_l3 */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xee, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x33	/* T__traceiter_pseudo_lock_l3 */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0x62, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x33	/* T__pfx___probestub_pseudo_lock_l3 */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0x62, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x33	/* T__probestub_pseudo_lock_l3 */
	.byte 0x17, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xa5, 0x7c, 0x6c, 0x6c, 0xd5, 0x6f, 0x63, 0x63, 0xb9, 0xcc, 0x63, 0xc5, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* T__pfx___traceiter_mon_llc_occupancy_limbo */
	.byte 0x15, 0x2f, 0x01, 0xe4, 0xcf, 0xa5, 0x7c, 0x6c, 0x6c, 0xd5, 0x6f, 0x63, 0x63, 0xb9, 0xcc, 0x63, 0xc5, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* T__traceiter_mon_llc_occupancy_limbo */
	.byte 0x18, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xa5, 0x7c, 0x6c, 0x6c, 0xd5, 0x6f, 0x63, 0x63, 0xb9, 0xcc, 0x63, 0xc5, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* T__pfx___probestub_mon_llc_occupancy_limbo */
	.byte 0x17, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xa5, 0x7c, 0x6c, 0x6c, 0xd5, 0x6f, 0x63, 0x63, 0xb9, 0xcc, 0x63, 0xc5, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* T__probestub_mon_llc_occupancy_limbo */
	.byte 0x0c, 0xa8, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x19, 0x6d, 0xf8, 0x0a	/* t__pfx_pseudo_lock_dev_mremap */
	.byte 0x0b, 0x06, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x19, 0x6d, 0xf8, 0x0a	/* tpseudo_lock_dev_mremap */
	.byte 0x10, 0xa8, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6d, 0xf0, 0xce, 0x5f, 0xf8, 0xd3, 0x61, 0xc9	/* t__pfx_pseudo_lock_minor_release */
	.byte 0x0f, 0x06, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6d, 0xf0, 0xce, 0x5f, 0xf8, 0xd3, 0x61, 0xc9	/* tpseudo_lock_minor_release */
	.byte 0x16, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0xa5, 0x7c, 0x6c, 0x6c, 0xd5, 0x6f, 0x63, 0x63, 0xb9, 0xcc, 0x63, 0xc5, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* t__pfx_perf_trace_mon_llc_occupancy_limbo */
	.byte 0x15, 0x06, 0xee, 0xa0, 0xc8, 0xa5, 0x7c, 0x6c, 0x6c, 0xd5, 0x6f, 0x63, 0x63, 0xb9, 0xcc, 0x63, 0xc5, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* tperf_trace_mon_llc_occupancy_limbo */
	.byte 0x0e, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x33	/* t__pfx_perf_trace_pseudo_lock_l3 */
	.byte 0x0d, 0x06, 0xee, 0xa0, 0xc8, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x33	/* tperf_trace_pseudo_lock_l3 */
	.byte 0x0e, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x32	/* t__pfx_perf_trace_pseudo_lock_l2 */
	.byte 0x0d, 0x06, 0xee, 0xa0, 0xc8, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x32	/* tperf_trace_pseudo_lock_l2 */
	.byte 0x13, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0xcd, 0x6c, 0xe9, 0xe8, 0x63, 0x79	/* t__pfx_perf_trace_pseudo_lock_mem_latency */
	.byte 0x12, 0x06, 0xee, 0xa0, 0xc8, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0xcd, 0x6c, 0xe9, 0xe8, 0x63, 0x79	/* tperf_trace_pseudo_lock_mem_latency */
	.byte 0x16, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0xa5, 0x7c, 0x6c, 0x6c, 0xd5, 0x6f, 0x63, 0x63, 0xb9, 0xcc, 0x63, 0xc5, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* t__pfx_trace_event_raw_event_mon_llc_occupancy_limbo */
	.byte 0x16, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0xa5, 0x7c, 0x6c, 0x6c, 0xd5, 0x6f, 0x63, 0x63, 0xb9, 0xcc, 0x63, 0xc5, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* ttrace_event_raw_event_mon_llc_occupancy_limbo */
	.byte 0x0e, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x33	/* t__pfx_trace_event_raw_event_pseudo_lock_l3 */
	.byte 0x0e, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x33	/* ttrace_event_raw_event_pseudo_lock_l3 */
	.byte 0x0e, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x32	/* t__pfx_trace_event_raw_event_pseudo_lock_l2 */
	.byte 0x0e, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x32	/* ttrace_event_raw_event_pseudo_lock_l2 */
	.byte 0x13, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0xcd, 0x6c, 0xe9, 0xe8, 0x63, 0x79	/* t__pfx_trace_event_raw_event_pseudo_lock_mem_latency */
	.byte 0x13, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0xcd, 0x6c, 0xe9, 0xe8, 0x63, 0x79	/* ttrace_event_raw_event_pseudo_lock_mem_latency */
	.byte 0x18, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0xa5, 0x7c, 0x6c, 0x6c, 0xd5, 0x6f, 0x63, 0x63, 0xb9, 0xcc, 0x63, 0xc5, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* t__pfx_trace_raw_output_mon_llc_occupancy_limbo */
	.byte 0x18, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0xa5, 0x7c, 0x6c, 0x6c, 0xd5, 0x6f, 0x63, 0x63, 0xb9, 0xcc, 0x63, 0xc5, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* ttrace_raw_output_mon_llc_occupancy_limbo */
	.byte 0x10, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x33	/* t__pfx_trace_raw_output_pseudo_lock_l3 */
	.byte 0x10, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x33	/* ttrace_raw_output_pseudo_lock_l3 */
	.byte 0x10, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x32	/* t__pfx_trace_raw_output_pseudo_lock_l2 */
	.byte 0x10, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x32	/* ttrace_raw_output_pseudo_lock_l2 */
	.byte 0x15, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0xcd, 0x6c, 0xe9, 0xe8, 0x63, 0x79	/* t__pfx_trace_raw_output_pseudo_lock_mem_latency */
	.byte 0x15, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0xcd, 0x6c, 0xe9, 0xe8, 0x63, 0x79	/* ttrace_raw_output_pseudo_lock_mem_latency */
	.byte 0x12, 0x29, 0x5f, 0x40, 0xc8, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0xcd, 0x6c, 0xe9, 0xe8, 0x63, 0x79	/* t__pfx___bpf_trace_pseudo_lock_mem_latency */
	.byte 0x12, 0x74, 0xff, 0x40, 0xc8, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0xcd, 0x6c, 0xe9, 0xe8, 0x63, 0x79	/* t__bpf_trace_pseudo_lock_mem_latency */
	.byte 0x0d, 0x29, 0x5f, 0x40, 0xc8, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x33	/* t__pfx___bpf_trace_pseudo_lock_l3 */
	.byte 0x0d, 0x74, 0xff, 0x40, 0xc8, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x33	/* t__bpf_trace_pseudo_lock_l3 */
	.byte 0x0d, 0x29, 0x5f, 0x40, 0xc8, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x32	/* t__pfx___bpf_trace_pseudo_lock_l2 */
	.byte 0x0d, 0x74, 0xff, 0x40, 0xc8, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x6c, 0x32	/* t__bpf_trace_pseudo_lock_l2 */
	.byte 0x15, 0x29, 0x5f, 0x40, 0xc8, 0xa5, 0x7c, 0x6c, 0x6c, 0xd5, 0x6f, 0x63, 0x63, 0xb9, 0xcc, 0x63, 0xc5, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* t__pfx___bpf_trace_mon_llc_occupancy_limbo */
	.byte 0x15, 0x74, 0xff, 0x40, 0xc8, 0xa5, 0x7c, 0x6c, 0x6c, 0xd5, 0x6f, 0x63, 0x63, 0xb9, 0xcc, 0x63, 0xc5, 0x6c, 0x69, 0x6d, 0x62, 0x6f	/* t__bpf_trace_mon_llc_occupancy_limbo */
	.byte 0x10, 0xc6, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x3c, 0xc9, 0x74, 0x3a, 0x5d, 0xcf, 0xf8, 0xd6, 0x6f, 0xf8	/* t__pfx_rdtgroup_locksetup_user_restore */
	.byte 0x0f, 0xea, 0x64, 0x74, 0x0d, 0x3a, 0x3c, 0xc9, 0x74, 0x3a, 0x5d, 0xcf, 0xf8, 0xd6, 0x6f, 0xf8	/* trdtgroup_locksetup_user_restore */
	.byte 0x0e, 0xa8, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x9f, 0xd9, 0x7c, 0x63, 0xd3, 0xca	/* t__pfx_pseudo_lock_region_clear */
	.byte 0x0d, 0x06, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x9f, 0xd9, 0x7c, 0x63, 0xd3, 0xca	/* tpseudo_lock_region_clear */
	.byte 0x0d, 0xa8, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x19, 0xf8, 0xd3, 0x61, 0xc9	/* t__pfx_pseudo_lock_dev_release */
	.byte 0x0c, 0x06, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x19, 0xf8, 0xd3, 0x61, 0xc9	/* tpseudo_lock_dev_release */
	.byte 0x0b, 0xa8, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x19, 0x81, 0xe8	/* t__pfx_pseudo_lock_dev_open */
	.byte 0x0a, 0x06, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x19, 0x81, 0xe8	/* tpseudo_lock_dev_open */
	.byte 0x0b, 0xa8, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xd2, 0xb6, 0xe6	/* t__pfx_pseudo_lock_devnode */
	.byte 0x0a, 0x06, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xd2, 0xb6, 0xe6	/* tpseudo_lock_devnode */
	.byte 0x11, 0xa8, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0x61, 0xb7, 0x72, 0xfa, 0xea, 0x2c, 0x67, 0xee	/* t__pfx_pseudo_lock_measure_trigger */
	.byte 0x10, 0x06, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xbd, 0x61, 0xb7, 0x72, 0xfa, 0xea, 0x2c, 0x67, 0xee	/* tpseudo_lock_measure_trigger */
	.byte 0x0f, 0xa8, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x63, 0xd6, 0x86, 0xe0, 0xf8, 0x1b, 0x78	/* t__pfx_pseudo_lock_cstates_relax */
	.byte 0x0e, 0x06, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x63, 0xd6, 0x86, 0xe0, 0xf8, 0x1b, 0x78	/* tpseudo_lock_cstates_relax */
	.byte 0x0b, 0xa8, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x19, 0x6d, 0x0a	/* t__pfx_pseudo_lock_dev_mmap */
	.byte 0x0a, 0x06, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x19, 0x6d, 0x0a	/* tpseudo_lock_dev_mmap */
	.byte 0x0a, 0xa8, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x66, 0x6e	/* t__pfx_pseudo_lock_fn */
	.byte 0x09, 0x06, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x66, 0x6e	/* tpseudo_lock_fn */
	.byte 0x0f, 0xc6, 0xbd, 0x61, 0xb7, 0x72, 0xfa, 0x63, 0x79, 0x63, 0xd3, 0xe0, 0x1b, 0xf9, 0x66, 0x6e	/* t__pfx_measure_cycles_lat_fn */
	.byte 0x0f, 0x74, 0xbd, 0x61, 0xb7, 0x72, 0xfa, 0x63, 0x79, 0x63, 0xd3, 0xe0, 0x1b, 0xf9, 0x66, 0x6e	/* tmeasure_cycles_lat_fn */
	.byte 0x18, 0xc6, 0xbd, 0x61, 0xb7, 0x72, 0xfa, 0x3d, 0x89, 0xe8, 0x63, 0xc5, 0x66, 0x6e, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0xf7, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_measure_residency_fn.constprop.0.isra.0 */
	.byte 0x18, 0x74, 0xbd, 0x61, 0xb7, 0x72, 0xfa, 0x3d, 0x89, 0xe8, 0x63, 0xc5, 0x66, 0x6e, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0xf7, 0xab, 0xb5, 0x2e, 0x30	/* tmeasure_residency_fn.constprop.0.isra.0 */
	.byte 0x0e, 0xc6, 0xbd, 0x61, 0xb7, 0x72, 0xfa, 0x6c, 0x33, 0x5f, 0x3d, 0x89, 0xe8, 0x63, 0x79	/* t__pfx_measure_l3_residency */
	.byte 0x0e, 0x74, 0xbd, 0x61, 0xb7, 0x72, 0xfa, 0x6c, 0x33, 0x5f, 0x3d, 0x89, 0xe8, 0x63, 0x79	/* tmeasure_l3_residency */
	.byte 0x0e, 0xc6, 0xbd, 0x61, 0xb7, 0x72, 0xfa, 0x6c, 0x32, 0x5f, 0x3d, 0x89, 0xe8, 0x63, 0x79	/* t__pfx_measure_l2_residency */
	.byte 0x0e, 0x74, 0xbd, 0x61, 0xb7, 0x72, 0xfa, 0x6c, 0x32, 0x5f, 0x3d, 0x89, 0xe8, 0x63, 0x79	/* tmeasure_l2_residency */
	.byte 0x0c, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x3c, 0xc9, 0x74, 0x3a, 0x1e, 0xee	/* T__pfx_rdtgroup_locksetup_enter */
	.byte 0x0c, 0x54, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x3c, 0xc9, 0x74, 0x3a, 0x1e, 0xee	/* Trdtgroup_locksetup_enter */
	.byte 0x0c, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x3c, 0xc9, 0x74, 0x3a, 0xd1, 0xe4	/* T__pfx_rdtgroup_locksetup_exit */
	.byte 0x0c, 0x54, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x3c, 0xc9, 0x74, 0x3a, 0xd1, 0xe4	/* Trdtgroup_locksetup_exit */
	.byte 0x17, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x63, 0x62, 0xcd, 0x6f, 0x76, 0xee, 0x1b, 0x70, 0x73, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0x3c, 0x65, 0x64	/* T__pfx_rdtgroup_cbm_overlaps_pseudo_locked */
	.byte 0x17, 0x54, 0x72, 0x64, 0x74, 0x0d, 0x3a, 0x63, 0x62, 0xcd, 0x6f, 0x76, 0xee, 0x1b, 0x70, 0x73, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0x3c, 0x65, 0x64	/* Trdtgroup_cbm_overlaps_pseudo_locked */
	.byte 0x16, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0xb9, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0x3c, 0x65, 0xe5, 0xf0, 0x5f, 0x68, 0x69, 0xee, 0xca, 0xd0, 0x79	/* T__pfx_rdtgroup_pseudo_locked_in_hierarchy */
	.byte 0x16, 0x54, 0x72, 0x64, 0x74, 0x0d, 0xb9, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0x3c, 0x65, 0xe5, 0xf0, 0x5f, 0x68, 0x69, 0xee, 0xca, 0xd0, 0x79	/* Trdtgroup_pseudo_locked_in_hierarchy */
	.byte 0x10, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0xb9, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x63, 0xf8, 0x86	/* T__pfx_rdtgroup_pseudo_lock_create */
	.byte 0x10, 0x54, 0x72, 0x64, 0x74, 0x0d, 0xb9, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x63, 0xf8, 0x86	/* Trdtgroup_pseudo_lock_create */
	.byte 0x11, 0xbf, 0x72, 0x64, 0x74, 0x0d, 0xb9, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xf8, 0xa5, 0x76, 0x65	/* T__pfx_rdtgroup_pseudo_lock_remove */
	.byte 0x11, 0x54, 0x72, 0x64, 0x74, 0x0d, 0xb9, 0xe7, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xf8, 0xa5, 0x76, 0x65	/* Trdtgroup_pseudo_lock_remove */
	.byte 0x0c, 0xbf, 0x72, 0x64, 0xf9, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x8d	/* T__pfx_rdt_pseudo_lock_init */
	.byte 0x0c, 0x54, 0x72, 0x64, 0xf9, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0x8d	/* Trdt_pseudo_lock_init */
	.byte 0x0f, 0xbf, 0x72, 0x64, 0xf9, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xf8, 0xd3, 0x61, 0xc9	/* T__pfx_rdt_pseudo_lock_release */
	.byte 0x0f, 0x54, 0x72, 0x64, 0xf9, 0x70, 0xc9, 0x75, 0xa9, 0x5f, 0xc0, 0xd8, 0xf8, 0xd3, 0x61, 0xc9	/* Trdt_pseudo_lock_release */
	.byte 0x0a, 0xa8, 0xf6, 0x67, 0x1a, 0x09, 0x61, 0xf9, 0xd9, 0x7b, 0x6c	/* t__pfx_sgx_compat_ioctl */
	.byte 0x0a, 0x74, 0x73, 0x67, 0x1a, 0x09, 0x61, 0xf9, 0xd9, 0x7b, 0x6c	/* tsgx_compat_ioctl */
	.byte 0x0d, 0xa8, 0xf6, 0x67, 0x1a, 0xb2, 0xd4, 0x0a, 0x70, 0x65, 0xe5, 0x61, 0xf8, 0x61	/* t__pfx_sgx_get_unmapped_area */
	.byte 0x0d, 0x74, 0x73, 0x67, 0x1a, 0xb2, 0xd4, 0x0a, 0x70, 0x65, 0xe5, 0x61, 0xf8, 0x61	/* tsgx_get_unmapped_area */
	.byte 0x06, 0xa8, 0xf6, 0x67, 0x1a, 0x6d, 0x0a	/* t__pfx_sgx_mmap */
	.byte 0x06, 0x74, 0x73, 0x67, 0x1a, 0x6d, 0x0a	/* tsgx_mmap */
	.byte 0x06, 0xa8, 0xf6, 0x67, 0x1a, 0x81, 0xe8	/* t__pfx_sgx_open */
	.byte 0x06, 0x74, 0x73, 0x67, 0x1a, 0x81, 0xe8	/* tsgx_open */
	.byte 0x08, 0xa8, 0xf6, 0x67, 0x1a, 0xf8, 0xd3, 0x61, 0xc9	/* t__pfx_sgx_release */
	.byte 0x08, 0x74, 0x73, 0x67, 0x1a, 0xf8, 0xd3, 0x61, 0xc9	/* tsgx_release */
	.byte 0x0a, 0xc6, 0x78, 0x61, 0xe0, 0x6e, 0xd1, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_xas_next_entry */
	.byte 0x0a, 0x74, 0x78, 0x61, 0xe0, 0x6e, 0xd1, 0xf9, 0xe8, 0xea, 0x79	/* txas_next_entry */
	.byte 0x0f, 0xa8, 0xf6, 0x67, 0x1a, 0x6d, 0x6d, 0x00, 0xb6, 0xc2, 0xb8, 0xcf, 0xf8, 0xd3, 0x61, 0xc9	/* t__pfx_sgx_mmu_notifier_release */
	.byte 0x0f, 0x74, 0x73, 0x67, 0x1a, 0x6d, 0x6d, 0x00, 0xb6, 0xc2, 0xb8, 0xcf, 0xf8, 0xd3, 0x61, 0xc9	/* tsgx_mmu_notifier_release */
	.byte 0x06, 0xa8, 0xe7, 0x75, 0xf9, 0x70, 0x03	/* t__pfx_put_page */
	.byte 0x05, 0x74, 0xbe, 0xf9, 0x70, 0x03	/* tput_page */
	.byte 0x0d, 0x29, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0xb2, 0x62, 0xeb, 0x6b, 0xf0, 0x67	/* t__pfx___sgx_encl_get_backing */
	.byte 0x0e, 0x74, 0xff, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0xb2, 0x62, 0xeb, 0x6b, 0xf0, 0x67	/* t__sgx_encl_get_backing */
	.byte 0x16, 0xa8, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x9a, 0x73, 0xf9, 0xcc, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x79, 0x6f, 0xd4, 0xa6, 0x63, 0x62	/* t__pfx_sgx_encl_test_and_clear_young_cb */
	.byte 0x16, 0x74, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x9a, 0x73, 0xf9, 0xcc, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x79, 0x6f, 0xd4, 0xa6, 0x63, 0x62	/* tsgx_encl_test_and_clear_young_cb */
	.byte 0x0a, 0x3f, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0xdd, 0xc5, 0x0a	/* T__pfx_sgx_encl_may_map */
	.byte 0x0a, 0x54, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0xdd, 0xc5, 0x0a	/* Tsgx_encl_may_map */
	.byte 0x0b, 0xa8, 0xf6, 0x67, 0x1a, 0x76, 0xdd, 0x5f, 0xb0, 0xde, 0x9a, 0x7b	/* t__pfx_sgx_vma_mprotect */
	.byte 0x0b, 0x74, 0x73, 0x67, 0x1a, 0x76, 0xdd, 0x5f, 0xb0, 0xde, 0x9a, 0x7b	/* tsgx_vma_mprotect */
	.byte 0x0a, 0x3f, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x6d, 0xcd, 0x10	/* T__pfx_sgx_encl_mm_add */
	.byte 0x0a, 0x54, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x6d, 0xcd, 0x10	/* Tsgx_encl_mm_add */
	.byte 0x09, 0xa8, 0xf6, 0x67, 0x1a, 0x76, 0xdd, 0x5f, 0x81, 0xe8	/* t__pfx_sgx_vma_open */
	.byte 0x09, 0x74, 0x73, 0x67, 0x1a, 0x76, 0xdd, 0x5f, 0x81, 0xe8	/* tsgx_vma_open */
	.byte 0x0a, 0x3f, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x92, 0xdd, 0x16	/* T__pfx_sgx_encl_cpumask */
	.byte 0x0a, 0x54, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x92, 0xdd, 0x16	/* Tsgx_encl_cpumask */
	.byte 0x0e, 0x3f, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x08, 0xd5, 0x62, 0xeb, 0x6b, 0xf0, 0x67	/* T__pfx_sgx_encl_alloc_backing */
	.byte 0x0e, 0x54, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x08, 0xd5, 0x62, 0xeb, 0x6b, 0xf0, 0x67	/* Tsgx_encl_alloc_backing */
	.byte 0x0f, 0x3f, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0x6c, 0xe7, 0x75, 0xf9, 0x62, 0xeb, 0x6b, 0xf0, 0x67	/* T__pfx_sgx_encl_put_backing */
	.byte 0x0f, 0x54, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0x6c, 0xe7, 0x75, 0xf9, 0x62, 0xeb, 0x6b, 0xf0, 0x67	/* Tsgx_encl_put_backing */
	.byte 0x14, 0x3f, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x9a, 0x73, 0xf9, 0xcc, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x79, 0x6f, 0xd4, 0x67	/* T__pfx_sgx_encl_test_and_clear_young */
	.byte 0x14, 0x54, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x9a, 0x73, 0xf9, 0xcc, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x79, 0x6f, 0xd4, 0x67	/* Tsgx_encl_test_and_clear_young */
	.byte 0x0c, 0x3f, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0x6c, 0xe7, 0x61, 0x21, 0xe1, 0xc0	/* T__pfx_sgx_encl_page_alloc */
	.byte 0x0c, 0x54, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0x6c, 0xe7, 0x61, 0x21, 0xe1, 0xc0	/* Tsgx_encl_page_alloc */
	.byte 0x0e, 0x3f, 0xf6, 0x67, 0x1a, 0x7a, 0x61, 0xe2, 0xe8, 0x63, 0x1b, 0x22, 0x70, 0x9a, 0x73	/* T__pfx_sgx_zap_enclave_ptes */
	.byte 0x0e, 0x54, 0x73, 0x67, 0x1a, 0x7a, 0x61, 0xe2, 0xe8, 0x63, 0x1b, 0x22, 0x70, 0x9a, 0x73	/* Tsgx_zap_enclave_ptes */
	.byte 0x0b, 0x3f, 0xf6, 0x67, 0x1a, 0x08, 0xd5, 0x76, 0x61, 0xf6, 0xdf, 0x74	/* T__pfx_sgx_alloc_va_slot */
	.byte 0x0b, 0x54, 0x73, 0x67, 0x1a, 0x08, 0xd5, 0x76, 0x61, 0xf6, 0xdf, 0x74	/* Tsgx_alloc_va_slot */
	.byte 0x0b, 0x3f, 0xf6, 0x67, 0x1a, 0x87, 0xfa, 0x76, 0x61, 0xf6, 0xdf, 0x74	/* T__pfx_sgx_free_va_slot */
	.byte 0x0b, 0x54, 0x73, 0x67, 0x1a, 0x87, 0xfa, 0x76, 0x61, 0xf6, 0xdf, 0x74	/* Tsgx_free_va_slot */
	.byte 0x0c, 0x3f, 0xf6, 0x67, 0x1a, 0x76, 0x61, 0xe7, 0x61, 0x21, 0x66, 0x0b, 0x6c	/* T__pfx_sgx_va_page_full */
	.byte 0x0c, 0x54, 0x73, 0x67, 0x1a, 0x76, 0x61, 0xe7, 0x61, 0x21, 0x66, 0x0b, 0x6c	/* Tsgx_va_page_full */
	.byte 0x0e, 0x3f, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x87, 0xfa, 0x65, 0x70, 0x63, 0xe7, 0x03	/* T__pfx_sgx_encl_free_epc_page */
	.byte 0x0e, 0x54, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x87, 0xfa, 0x65, 0x70, 0x63, 0xe7, 0x03	/* Tsgx_encl_free_epc_page */
	.byte 0x0a, 0x3f, 0xf6, 0x67, 0x1a, 0x08, 0xd5, 0x76, 0x61, 0xe7, 0x03	/* T__pfx_sgx_alloc_va_page */
	.byte 0x0a, 0x54, 0x73, 0x67, 0x1a, 0x08, 0xd5, 0x76, 0x61, 0xe7, 0x03	/* Tsgx_alloc_va_page */
	.byte 0x0b, 0x3f, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0xf8, 0xd3, 0x61, 0xc9	/* T__pfx_sgx_encl_release */
	.byte 0x0b, 0x54, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0xf8, 0xd3, 0x61, 0xc9	/* Tsgx_encl_release */
	.byte 0x0d, 0xa8, 0xf6, 0x67, 0x1a, 0x6d, 0x6d, 0x00, 0xb6, 0xc2, 0xb8, 0xcf, 0x87, 0x65	/* t__pfx_sgx_mmu_notifier_free */
	.byte 0x0d, 0x74, 0x73, 0x67, 0x1a, 0x6d, 0x6d, 0x00, 0xb6, 0xc2, 0xb8, 0xcf, 0x87, 0x65	/* tsgx_mmu_notifier_free */
	.byte 0x0a, 0xa8, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x65, 0x02, 0x75	/* t__pfx_sgx_encl_eldu */
	.byte 0x0a, 0x74, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x65, 0x02, 0x75	/* tsgx_encl_eldu */
	.byte 0x0b, 0x29, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0xdf, 0xc7, 0xe7, 0x03	/* t__pfx___sgx_encl_load_page */
	.byte 0x0c, 0x74, 0xff, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0xdf, 0xc7, 0xe7, 0x03	/* t__sgx_encl_load_page */
	.byte 0x0b, 0x3f, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0xdf, 0xc7, 0xe7, 0x03	/* T__pfx_sgx_encl_load_page */
	.byte 0x0b, 0x54, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0xdf, 0xc7, 0xe7, 0x03	/* Tsgx_encl_load_page */
	.byte 0x10, 0xa8, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0xdf, 0xc7, 0xe7, 0x61, 0x21, 0xf0, 0x5f, 0x76, 0xdd	/* t__pfx_sgx_encl_load_page_in_vma */
	.byte 0x10, 0x74, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0xdf, 0xc7, 0xe7, 0x61, 0x21, 0xf0, 0x5f, 0x76, 0xdd	/* tsgx_encl_load_page_in_vma */
	.byte 0x0b, 0xa8, 0xf6, 0x67, 0x1a, 0x76, 0xdd, 0x5f, 0xeb, 0x63, 0x3b, 0x73	/* t__pfx_sgx_vma_access */
	.byte 0x0b, 0x74, 0x73, 0x67, 0x1a, 0x76, 0xdd, 0x5f, 0xeb, 0x63, 0x3b, 0x73	/* tsgx_vma_access */
	.byte 0x0b, 0xa8, 0xf6, 0x67, 0x1a, 0x76, 0xdd, 0x5f, 0x66, 0x61, 0x0b, 0x74	/* t__pfx_sgx_vma_fault */
	.byte 0x0b, 0x74, 0x73, 0x67, 0x1a, 0x76, 0xdd, 0x5f, 0x66, 0x61, 0x0b, 0x74	/* tsgx_vma_fault */
	.byte 0x11, 0xa8, 0xf6, 0x67, 0x1a, 0x76, 0xe1, 0x89, 0xa1, 0x6f, 0x66, 0x66, 0xc9, 0xf9, 0x6c, 0xe8, 0x67, 0x15	/* t__pfx_sgx_validate_offset_length */
	.byte 0x11, 0x74, 0x73, 0x67, 0x1a, 0x76, 0xe1, 0x89, 0xa1, 0x6f, 0x66, 0x66, 0xc9, 0xf9, 0x6c, 0xe8, 0x67, 0x15	/* tsgx_validate_offset_length */
	.byte 0x0e, 0xa8, 0xf6, 0x67, 0x1a, 0xd9, 0x63, 0xf6, 0x67, 0x78, 0x32, 0x5f, 0xf8, 0xc7, 0x79	/* t__pfx_sgx_ioc_sgx2_ready */
	.byte 0x0e, 0x74, 0x73, 0x67, 0x1a, 0xd9, 0x63, 0xf6, 0x67, 0x78, 0x32, 0x5f, 0xf8, 0xc7, 0x79	/* tsgx_ioc_sgx2_ready */
	.byte 0x0a, 0x29, 0xf6, 0x67, 0x1a, 0xb2, 0x0e, 0xc5, 0x68, 0x96, 0x68	/* t__pfx___sgx_get_key_hash */
	.byte 0x0b, 0x74, 0xff, 0x73, 0x67, 0x1a, 0xb2, 0x0e, 0xc5, 0x68, 0x96, 0x68	/* t__sgx_get_key_hash */
	.byte 0x0a, 0xa8, 0xf6, 0x2c, 0x6e, 0xe1, 0xe7, 0xe8, 0x64, 0xf0, 0x67	/* t__pfx_signal_pending */
	.byte 0x0a, 0x74, 0x73, 0x2c, 0x6e, 0xe1, 0xe7, 0xe8, 0x64, 0xf0, 0x67	/* tsignal_pending */
	.byte 0x0b, 0xa8, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0x1b, 0x22, 0x65, 0xd7, 0x6b	/* t__pfx_sgx_enclave_etrack */
	.byte 0x0b, 0x74, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0x1b, 0x22, 0x65, 0xd7, 0x6b	/* tsgx_enclave_etrack */
	.byte 0x10, 0xa8, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0x1b, 0x22, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0x74, 0x27, 0x3b	/* t__pfx_sgx_enclave_modify_types */
	.byte 0x10, 0x74, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0x1b, 0x22, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0x74, 0x27, 0x3b	/* tsgx_enclave_modify_types */
	.byte 0x14, 0xa8, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0x1b, 0x22, 0x3d, 0xea, 0xa3, 0xf9, 0x70, 0xee, 0x6d, 0xab, 0x73, 0xd9, 0x6e, 0x73	/* t__pfx_sgx_enclave_restrict_permissions */
	.byte 0x14, 0x74, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0x1b, 0x22, 0x3d, 0xea, 0xa3, 0xf9, 0x70, 0xee, 0x6d, 0xab, 0x73, 0xd9, 0x6e, 0x73	/* tsgx_enclave_restrict_permissions */
	.byte 0x09, 0x3f, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x0d, 0x77	/* T__pfx_sgx_encl_grow */
	.byte 0x09, 0x54, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x0d, 0x77	/* Tsgx_encl_grow */
	.byte 0x0c, 0x3f, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0x6c, 0xf6, 0x68, 0x72, 0xf0, 0x6b	/* T__pfx_sgx_encl_shrink */
	.byte 0x0c, 0x54, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0x6c, 0xf6, 0x68, 0x72, 0xf0, 0x6b	/* Tsgx_encl_shrink */
	.byte 0x0e, 0xa8, 0xf6, 0x67, 0x1a, 0xd9, 0xd5, 0xe8, 0x63, 0x1b, 0x22, 0x10, 0xe7, 0x03, 0x73	/* t__pfx_sgx_ioc_enclave_add_pages */
	.byte 0x0e, 0x74, 0x73, 0x67, 0x1a, 0xd9, 0xd5, 0xe8, 0x63, 0x1b, 0x22, 0x10, 0xe7, 0x03, 0x73	/* tsgx_ioc_enclave_add_pages */
	.byte 0x0a, 0xa8, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x63, 0xf8, 0x86	/* t__pfx_sgx_encl_create */
	.byte 0x0a, 0x74, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x63, 0xf8, 0x86	/* tsgx_encl_create */
	.byte 0x07, 0x3f, 0xf6, 0x67, 0x1a, 0xd9, 0x7b, 0x6c	/* T__pfx_sgx_ioctl */
	.byte 0x07, 0x54, 0x73, 0x67, 0x1a, 0xd9, 0x7b, 0x6c	/* Tsgx_ioctl */
	.byte 0x08, 0x3f, 0xf6, 0x67, 0x1a, 0x69, 0x85, 0x63, 0x62	/* T__pfx_sgx_ipi_cb */
	.byte 0x08, 0x54, 0x73, 0x67, 0x1a, 0x69, 0x85, 0x63, 0x62	/* Tsgx_ipi_cb */
	.byte 0x11, 0xc6, 0xca, 0xd0, 0x5f, 0xb6, 0x64, 0xfa, 0xe9, 0xea, 0x5f, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* t__pfx_arch_node_attr_is_visible */
	.byte 0x11, 0xdb, 0x72, 0xd0, 0x5f, 0xb6, 0x64, 0xfa, 0xe9, 0xea, 0x5f, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* tarch_node_attr_is_visible */
	.byte 0x0a, 0x29, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x65, 0x77, 0x62	/* t__pfx___sgx_encl_ewb */
	.byte 0x0b, 0x74, 0xff, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x65, 0x77, 0x62	/* t__sgx_encl_ewb */
	.byte 0x0a, 0xa8, 0xf6, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x65, 0x77, 0x62	/* t__pfx_sgx_encl_ewb */
	.byte 0x0a, 0x74, 0x73, 0x67, 0x1a, 0xe8, 0x63, 0xc3, 0x65, 0x77, 0x62	/* tsgx_encl_ewb */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0x5f, 0xab, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0x6d, 0xe7, 0x03	/* T__pfx_arch_is_platform_page */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0x5f, 0xab, 0xe7, 0x6c, 0xe9, 0x66, 0xce, 0x6d, 0xe7, 0x03	/* Tarch_is_platform_page */
	.byte 0x0e, 0xa8, 0xf6, 0x67, 0x1a, 0xac, 0x74, 0xe1, 0x5f, 0x62, 0x79, 0x9a, 0x73, 0xf6, 0x26	/* t__pfx_sgx_total_bytes_show */
	.byte 0x0e, 0x74, 0x73, 0x67, 0x1a, 0xac, 0x74, 0xe1, 0x5f, 0x62, 0x79, 0x9a, 0x73, 0xf6, 0x26	/* tsgx_total_bytes_show */
	.byte 0x0a, 0x3f, 0xf6, 0x67, 0x78, 0x1f, 0xe9, 0xea, 0x69, 0xa2, 0x9a	/* T__pfx_sgx_set_attribute */
	.byte 0x0a, 0x54, 0x73, 0x67, 0x78, 0x1f, 0xe9, 0xea, 0x69, 0xa2, 0x9a	/* Tsgx_set_attribute */
	.byte 0x0d, 0xbf, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x69, 0xe0, 0x6b, 0x73, 0x67, 0x78, 0x64	/* T__pfx_current_is_ksgxd */
	.byte 0x0d, 0x54, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x69, 0xe0, 0x6b, 0x73, 0x67, 0x78, 0x64	/* Tcurrent_is_ksgxd */
	.byte 0x0c, 0x3f, 0xff, 0xf6, 0x67, 0x1a, 0x08, 0xd5, 0x65, 0x70, 0x63, 0xe7, 0x03	/* T__pfx___sgx_alloc_epc_page */
	.byte 0x0b, 0x2f, 0x73, 0x67, 0x1a, 0x08, 0xd5, 0x65, 0x70, 0x63, 0xe7, 0x03	/* T__sgx_alloc_epc_page */
	.byte 0x11, 0x3f, 0xf6, 0x67, 0x1a, 0xdd, 0x72, 0x6b, 0xe7, 0x61, 0x21, 0xf8, 0x63, 0x1b, 0x69, 0xdd, 0x62, 0xd3	/* T__pfx_sgx_mark_page_reclaimable */
	.byte 0x11, 0x54, 0x73, 0x67, 0x1a, 0xdd, 0x72, 0x6b, 0xe7, 0x61, 0x21, 0xf8, 0x63, 0x1b, 0x69, 0xdd, 0x62, 0xd3	/* Tsgx_mark_page_reclaimable */
	.byte 0x12, 0x3f, 0xf6, 0x67, 0x1a, 0xd4, 0xdd, 0x72, 0x6b, 0xe7, 0x61, 0x21, 0xf8, 0x63, 0x1b, 0x69, 0xdd, 0x62, 0xd3	/* T__pfx_sgx_unmark_page_reclaimable */
	.byte 0x12, 0x54, 0x73, 0x67, 0x1a, 0xd4, 0xdd, 0x72, 0x6b, 0xe7, 0x61, 0x21, 0xf8, 0x63, 0x1b, 0x69, 0xdd, 0x62, 0xd3	/* Tsgx_unmark_page_reclaimable */
	.byte 0x0b, 0x3f, 0xf6, 0x67, 0x1a, 0x87, 0xfa, 0x65, 0x70, 0x63, 0xe7, 0x03	/* T__pfx_sgx_free_epc_page */
	.byte 0x0b, 0x54, 0x73, 0x67, 0x1a, 0x87, 0xfa, 0x65, 0x70, 0x63, 0xe7, 0x03	/* Tsgx_free_epc_page */
	.byte 0x0c, 0xa8, 0xf6, 0x67, 0x1a, 0xf8, 0x63, 0x1b, 0x69, 0x6d, 0xe7, 0x03, 0x73	/* t__pfx_sgx_reclaim_pages */
	.byte 0x0c, 0x74, 0x73, 0x67, 0x1a, 0xf8, 0x63, 0x1b, 0x69, 0x6d, 0xe7, 0x03, 0x73	/* tsgx_reclaim_pages */
	.byte 0x0b, 0x3f, 0xf6, 0x67, 0x1a, 0x08, 0xd5, 0x65, 0x70, 0x63, 0xe7, 0x03	/* T__pfx_sgx_alloc_epc_page */
	.byte 0x0b, 0x54, 0x73, 0x67, 0x1a, 0x08, 0xd5, 0x65, 0x70, 0x63, 0xe7, 0x03	/* Tsgx_alloc_epc_page */
	.byte 0x0d, 0x3f, 0xf6, 0x67, 0x1a, 0xf8, 0x63, 0x1b, 0x69, 0xcd, 0x64, 0x69, 0xf8, 0x7b	/* T__pfx_sgx_reclaim_direct */
	.byte 0x0d, 0x54, 0x73, 0x67, 0x1a, 0xf8, 0x63, 0x1b, 0x69, 0xcd, 0x64, 0x69, 0xf8, 0x7b	/* Tsgx_reclaim_direct */
	.byte 0x14, 0x29, 0xf6, 0x67, 0x78, 0xf6, 0xcc, 0xe4, 0x69, 0x7a, 0xfa, 0x70, 0x03, 0x73, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx___sgx_sanitize_pages.constprop.0 */
	.byte 0x15, 0x74, 0xff, 0x73, 0x67, 0x78, 0xf6, 0xcc, 0xe4, 0x69, 0x7a, 0xfa, 0x70, 0x03, 0x73, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__sgx_sanitize_pages.constprop.0 */
	.byte 0x06, 0xc6, 0x6b, 0x73, 0x67, 0x78, 0x64	/* t__pfx_ksgxd */
	.byte 0x06, 0x74, 0x6b, 0x73, 0x67, 0x78, 0x64	/* tksgxd */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0xbd, 0x6d, 0xce, 0xc5, 0x66, 0x61, 0x69, 0x6c, 0x75, 0xf8	/* T__pfx_arch_memory_failure */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0xbd, 0x6d, 0xce, 0xc5, 0x66, 0x61, 0x69, 0x6c, 0x75, 0xf8	/* Tarch_memory_failure */
	.byte 0x0f, 0x3f, 0xf6, 0x67, 0x1a, 0xb9, 0x64, 0xa1, 0xd3, 0xbe, 0x62, 0x0e, 0x79, 0x68, 0x96, 0x68	/* T__pfx_sgx_update_lepubkeyhash */
	.byte 0x0f, 0x54, 0x73, 0x67, 0x1a, 0xb9, 0x64, 0xa1, 0xd3, 0xbe, 0x62, 0x0e, 0x79, 0x68, 0x96, 0x68	/* Tsgx_update_lepubkeyhash */
	.byte 0x0d, 0xa8, 0xf6, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0xf8, 0xa5, 0x22, 0x70, 0x03	/* t__pfx_sgx_vepc_remove_page */
	.byte 0x0d, 0x74, 0x73, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0xf8, 0xa5, 0x22, 0x70, 0x03	/* tsgx_vepc_remove_page */
	.byte 0x09, 0x29, 0xf6, 0x67, 0x1a, 0x76, 0xa7, 0xf9, 0x65, 0x8d	/* t__pfx___sgx_virt_einit */
	.byte 0x0a, 0x74, 0xff, 0x73, 0x67, 0x1a, 0x76, 0xa7, 0xf9, 0x65, 0x8d	/* t__sgx_virt_einit */
	.byte 0x0b, 0x3f, 0xf6, 0x67, 0x1a, 0x76, 0xa7, 0xf9, 0x65, 0x63, 0xf8, 0x86	/* T__pfx_sgx_virt_ecreate */
	.byte 0x0b, 0x54, 0x73, 0x67, 0x1a, 0x76, 0xa7, 0xf9, 0x65, 0x63, 0xf8, 0x86	/* Tsgx_virt_ecreate */
	.byte 0x0c, 0xa8, 0xf6, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0x87, 0xfa, 0x70, 0x03	/* t__pfx_sgx_vepc_free_page */
	.byte 0x0c, 0x74, 0x73, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0x87, 0xfa, 0x70, 0x03	/* tsgx_vepc_free_page */
	.byte 0x0c, 0xa8, 0xf6, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0xf8, 0xd3, 0x61, 0xc9	/* t__pfx_sgx_vepc_release */
	.byte 0x0c, 0x74, 0x73, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0xf8, 0xd3, 0x61, 0xc9	/* tsgx_vepc_release */
	.byte 0x0b, 0xa8, 0xf6, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0xd9, 0x7b, 0x6c	/* t__pfx_sgx_vepc_ioctl */
	.byte 0x0b, 0x74, 0x73, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0xd9, 0x7b, 0x6c	/* tsgx_vepc_ioctl */
	.byte 0x09, 0x3f, 0xf6, 0x67, 0x1a, 0x76, 0xa7, 0xf9, 0x65, 0x8d	/* T__pfx_sgx_virt_einit */
	.byte 0x09, 0x54, 0x73, 0x67, 0x1a, 0x76, 0xa7, 0xf9, 0x65, 0x8d	/* Tsgx_virt_einit */
	.byte 0x0a, 0xa8, 0xf6, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0x6d, 0x0a	/* t__pfx_sgx_vepc_mmap */
	.byte 0x0a, 0x74, 0x73, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0x6d, 0x0a	/* tsgx_vepc_mmap */
	.byte 0x0a, 0xa8, 0xf6, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0x81, 0xe8	/* t__pfx_sgx_vepc_open */
	.byte 0x0a, 0x74, 0x73, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0x81, 0xe8	/* tsgx_vepc_open */
	.byte 0x0c, 0xa8, 0xf6, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0x66, 0x61, 0x0b, 0x74	/* t__pfx_sgx_vepc_fault */
	.byte 0x0c, 0x74, 0x73, 0x67, 0x1a, 0x76, 0x65, 0x70, 0xd5, 0x66, 0x61, 0x0b, 0x74	/* tsgx_vepc_fault */
	.byte 0x0d, 0xbf, 0xf8, 0xd3, 0x96, 0xfa, 0xbc, 0x6e, 0x74, 0xc9, 0xc3, 0x6e, 0x6d, 0x69	/* T__pfx_release_evntsel_nmi */
	.byte 0x0d, 0x54, 0xf8, 0xd3, 0x96, 0xfa, 0xbc, 0x6e, 0x74, 0xc9, 0xc3, 0x6e, 0x6d, 0x69	/* Trelease_evntsel_nmi */
	.byte 0x0e, 0xbf, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0xee, 0x66, 0x63, 0xea, 0x5f, 0x6e, 0x6d, 0x69	/* T__pfx_release_perfctr_nmi */
	.byte 0x0e, 0x54, 0xf8, 0xd3, 0x96, 0xfa, 0x70, 0xee, 0x66, 0x63, 0xea, 0x5f, 0x6e, 0x6d, 0x69	/* Trelease_perfctr_nmi */
	.byte 0x0c, 0xbf, 0x3d, 0xee, 0x22, 0xbc, 0x6e, 0x74, 0xc9, 0xc3, 0x6e, 0x6d, 0x69	/* T__pfx_reserve_evntsel_nmi */
	.byte 0x0c, 0x54, 0x3d, 0xee, 0x22, 0xbc, 0x6e, 0x74, 0xc9, 0xc3, 0x6e, 0x6d, 0x69	/* Treserve_evntsel_nmi */
	.byte 0x0d, 0xbf, 0x3d, 0xee, 0x22, 0x70, 0xee, 0x66, 0x63, 0xea, 0x5f, 0x6e, 0x6d, 0x69	/* T__pfx_reserve_perfctr_nmi */
	.byte 0x0d, 0x54, 0x3d, 0xee, 0x22, 0x70, 0xee, 0x66, 0x63, 0xea, 0x5f, 0x6e, 0x6d, 0x69	/* Treserve_perfctr_nmi */
	.byte 0x0d, 0xc6, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0xb2, 0x74, 0x73, 0xd5, 0x6b, 0x68, 0x7a	/* t__pfx_vmware_get_tsc_khz */
	.byte 0x0d, 0x74, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0xb2, 0x74, 0x73, 0xd5, 0x6b, 0x68, 0x7a	/* tvmware_get_tsc_khz */
	.byte 0x0c, 0xc6, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0xd6, 0x65, 0xe1, 0x5f, 0x63, 0x3c	/* t__pfx_vmware_steal_clock */
	.byte 0x0c, 0x74, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0xd6, 0x65, 0xe1, 0x5f, 0x63, 0x3c	/* tvmware_steal_clock */
	.byte 0x12, 0xc6, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0xc9, 0x76, 0x5f, 0x65, 0xe0, 0x68, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* t__pfx_vmware_sev_es_hcall_finish */
	.byte 0x12, 0x74, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0xc9, 0x76, 0x5f, 0x65, 0xe0, 0x68, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* tvmware_sev_es_hcall_finish */
	.byte 0x13, 0xc6, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0xc9, 0x76, 0x5f, 0x65, 0xe0, 0x68, 0x28, 0x6c, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* t__pfx_vmware_sev_es_hcall_prepare */
	.byte 0x13, 0x74, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0xc9, 0x76, 0x5f, 0x65, 0xe0, 0x68, 0x28, 0x6c, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* tvmware_sev_es_hcall_prepare */
	.byte 0x12, 0xc6, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x70, 0x76, 0x5f, 0xf8, 0x62, 0x6f, 0x6f, 0xf9, 0xb6, 0xc2, 0x66, 0x79	/* t__pfx_vmware_pv_reboot_notify */
	.byte 0x12, 0x74, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x70, 0x76, 0x5f, 0xf8, 0x62, 0x6f, 0x6f, 0xf9, 0xb6, 0xc2, 0x66, 0x79	/* tvmware_pv_reboot_notify */
	.byte 0x0e, 0xc6, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x63, 0x6d, 0x64, 0xf6, 0x9a, 0xe1, 0x63, 0x3c	/* t__pfx_vmware_cmd_stealclock */
	.byte 0x0e, 0x74, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x63, 0x6d, 0x64, 0xf6, 0x9a, 0xe1, 0x63, 0x3c	/* tvmware_cmd_stealclock */
	.byte 0x10, 0xc6, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x92, 0x5f, 0xa9, 0x77, 0x6e, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* t__pfx_vmware_cpu_down_prepare */
	.byte 0x10, 0x74, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x92, 0x5f, 0xa9, 0x77, 0x6e, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* tvmware_cpu_down_prepare */
	.byte 0x0e, 0xc6, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x18, 0xee, 0xf6, 0x9a, 0xe1, 0x5f, 0xc2, 0xbd	/* t__pfx_vmware_register_steal_time */
	.byte 0x0e, 0x74, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x18, 0xee, 0xf6, 0x9a, 0xe1, 0x5f, 0xc2, 0xbd	/* tvmware_register_steal_time */
	.byte 0x0c, 0xc6, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* t__pfx_vmware_cpu_online */
	.byte 0x0c, 0x74, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* tvmware_cpu_online */
	.byte 0x14, 0xc6, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x70, 0x76, 0x5f, 0x67, 0x75, 0x3b, 0xf9, 0x92, 0x5f, 0xf8, 0x62, 0x6f, 0x6f, 0x74	/* t__pfx_vmware_pv_guest_cpu_reboot */
	.byte 0x14, 0x74, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x70, 0x76, 0x5f, 0x67, 0x75, 0x3b, 0xf9, 0x92, 0x5f, 0xf8, 0x62, 0x6f, 0x6f, 0x74	/* tvmware_pv_guest_cpu_reboot */
	.byte 0x0e, 0xbf, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x68, 0x27, 0xee, 0x28, 0x6c, 0xf6, 0xdf, 0x77	/* T__pfx_vmware_hypercall_slow */
	.byte 0x0e, 0x54, 0x76, 0x6d, 0x77, 0xca, 0xfa, 0x68, 0x27, 0xee, 0x28, 0x6c, 0xf6, 0xdf, 0x77	/* Tvmware_hypercall_slow */
	.byte 0x04, 0x29, 0x5f, 0x92, 0x89	/* t__pfx___cpuid */
	.byte 0x04, 0x74, 0xff, 0x92, 0x89	/* t__cpuid */
	.byte 0x0c, 0xc6, 0x68, 0x76, 0x5f, 0xb2, 0x6e, 0x6d, 0xcb, 0xf8, 0x96, 0x6f, 0x6e	/* t__pfx_hv_get_nmi_reason */
	.byte 0x0b, 0x15, 0x76, 0x5f, 0xb2, 0x6e, 0x6d, 0xcb, 0xf8, 0x96, 0x6f, 0x6e	/* thv_get_nmi_reason */
	.byte 0x0f, 0xc6, 0x68, 0x76, 0xf6, 0xbc, 0x5f, 0x65, 0xe0, 0x68, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* t__pfx_hv_sev_es_hcall_finish */
	.byte 0x0e, 0x15, 0x76, 0xf6, 0xbc, 0x5f, 0x65, 0xe0, 0x68, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* thv_sev_es_hcall_finish */
	.byte 0x10, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx___sysvec_hyperv_callback */
	.byte 0x11, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__sysvec_hyperv_callback */
	.byte 0x0f, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xc2, 0x6d, 0xee, 0x30	/* t__pfx___sysvec_hyperv_stimer0 */
	.byte 0x10, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xc2, 0x6d, 0xee, 0x30	/* t__sysvec_hyperv_stimer0 */
	.byte 0x10, 0xc6, 0x68, 0x76, 0xf6, 0xbc, 0x5f, 0x65, 0xe0, 0x68, 0x28, 0x6c, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* t__pfx_hv_sev_es_hcall_prepare */
	.byte 0x0f, 0x15, 0x76, 0xf6, 0xbc, 0x5f, 0x65, 0xe0, 0x68, 0x28, 0x6c, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* thv_sev_es_hcall_prepare */
	.byte 0x0c, 0xc6, 0x68, 0x76, 0x5f, 0x6e, 0x6d, 0xcb, 0xd4, 0x6b, 0xb6, 0x77, 0x6e	/* t__pfx_hv_nmi_unknown */
	.byte 0x0b, 0x15, 0x76, 0x5f, 0x6e, 0x6d, 0xcb, 0xd4, 0x6b, 0xb6, 0x77, 0x6e	/* thv_nmi_unknown */
	.byte 0x13, 0xc6, 0x68, 0x76, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_hv_machine_crash_shutdown */
	.byte 0x12, 0x15, 0x76, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* thv_machine_crash_shutdown */
	.byte 0x0f, 0xc6, 0x68, 0x76, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x73, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_hv_machine_shutdown */
	.byte 0x0e, 0x15, 0x76, 0x5f, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x73, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* thv_machine_shutdown */
	.byte 0x0b, 0xc6, 0x68, 0x76, 0x5f, 0xb2, 0x74, 0x73, 0xd5, 0x6b, 0x68, 0x7a	/* t__pfx_hv_get_tsc_khz */
	.byte 0x0a, 0x15, 0x76, 0x5f, 0xb2, 0x74, 0x73, 0xd5, 0x6b, 0x68, 0x7a	/* thv_get_tsc_khz */
	.byte 0x0d, 0xbf, 0x68, 0x76, 0x5f, 0xb2, 0xb6, 0x7c, 0xb4, 0xd6, 0x65, 0xe5, 0x20, 0x72	/* T__pfx_hv_get_non_nested_msr */
	.byte 0x0d, 0x54, 0x68, 0x76, 0x5f, 0xb2, 0xb6, 0x7c, 0xb4, 0xd6, 0x65, 0xe5, 0x20, 0x72	/* Thv_get_non_nested_msr */
	.byte 0x07, 0xbf, 0x68, 0x76, 0x5f, 0xb2, 0x20, 0x72	/* T__pfx_hv_get_msr */
	.byte 0x07, 0x54, 0x68, 0x76, 0x5f, 0xb2, 0x20, 0x72	/* Thv_get_msr */
	.byte 0x07, 0xc6, 0x92, 0x69, 0xe5, 0x65, 0x61, 0x78	/* t__pfx_cpuid_eax */
	.byte 0x07, 0x74, 0x92, 0x69, 0xe5, 0x65, 0x61, 0x78	/* tcpuid_eax */
	.byte 0x0c, 0xbf, 0x68, 0x76, 0x1f, 0xb6, 0x7c, 0xb4, 0xd6, 0x65, 0xe5, 0x20, 0x72	/* T__pfx_hv_set_non_nested_msr */
	.byte 0x0c, 0x54, 0x68, 0x76, 0x1f, 0xb6, 0x7c, 0xb4, 0xd6, 0x65, 0xe5, 0x20, 0x72	/* Thv_set_non_nested_msr */
	.byte 0x06, 0xbf, 0x68, 0x76, 0x1f, 0x20, 0x72	/* T__pfx_hv_set_msr */
	.byte 0x06, 0x54, 0x68, 0x76, 0x1f, 0x20, 0x72	/* Thv_set_msr */
	.byte 0x12, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* T__pfx_fred_sysvec_hyperv_callback */
	.byte 0x12, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x68, 0x27, 0xee, 0x76, 0x5f, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* Tfred_sysvec_hyperv_callback */
	.byte 0x0f, 0xbf, 0x68, 0x76, 0xba, 0x74, 0x3a, 0x76, 0x6d, 0xa2, 0xe0, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_hv_setup_vmbus_handler */
	.byte 0x0f, 0x54, 0x68, 0x76, 0xba, 0x74, 0x3a, 0x76, 0x6d, 0xa2, 0xe0, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Thv_setup_vmbus_handler */
	.byte 0x10, 0xbf, 0x68, 0x76, 0x5f, 0xf8, 0xa5, 0x22, 0x76, 0x6d, 0xa2, 0xe0, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_hv_remove_vmbus_handler */
	.byte 0x10, 0x54, 0x68, 0x76, 0x5f, 0xf8, 0xa5, 0x22, 0x76, 0x6d, 0xa2, 0xe0, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Thv_remove_vmbus_handler */
	.byte 0x11, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xc2, 0x6d, 0xee, 0x30	/* T__pfx_fred_sysvec_hyperv_stimer0 */
	.byte 0x11, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x68, 0x27, 0xee, 0x76, 0xf6, 0xc2, 0x6d, 0xee, 0x30	/* Tfred_sysvec_hyperv_stimer0 */
	.byte 0x11, 0xbf, 0x68, 0x76, 0xba, 0x74, 0xb9, 0xf6, 0xc2, 0x6d, 0xee, 0x30, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_hv_setup_stimer0_handler */
	.byte 0x11, 0x54, 0x68, 0x76, 0xba, 0x74, 0xb9, 0xf6, 0xc2, 0x6d, 0xee, 0x30, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Thv_setup_stimer0_handler */
	.byte 0x12, 0xbf, 0x68, 0x76, 0x5f, 0xf8, 0xa5, 0x22, 0xd6, 0x69, 0x6d, 0xee, 0x30, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_hv_remove_stimer0_handler */
	.byte 0x12, 0x54, 0x68, 0x76, 0x5f, 0xf8, 0xa5, 0x22, 0xd6, 0x69, 0x6d, 0xee, 0x30, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Thv_remove_stimer0_handler */
	.byte 0x0f, 0xbf, 0x68, 0x76, 0xba, 0x74, 0x3a, 0x6b, 0xd1, 0x65, 0xd5, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_hv_setup_kexec_handler */
	.byte 0x0f, 0x54, 0x68, 0x76, 0xba, 0x74, 0x3a, 0x6b, 0xd1, 0x65, 0xd5, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Thv_setup_kexec_handler */
	.byte 0x10, 0xbf, 0x68, 0x76, 0x5f, 0xf8, 0xa5, 0x22, 0x6b, 0xd1, 0x65, 0xd5, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_hv_remove_kexec_handler */
	.byte 0x10, 0x54, 0x68, 0x76, 0x5f, 0xf8, 0xa5, 0x22, 0x6b, 0xd1, 0x65, 0xd5, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Thv_remove_kexec_handler */
	.byte 0x0f, 0xbf, 0x68, 0x76, 0xba, 0x74, 0x3a, 0x63, 0xb5, 0x73, 0x5b, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_hv_setup_crash_handler */
	.byte 0x0f, 0x54, 0x68, 0x76, 0xba, 0x74, 0x3a, 0x63, 0xb5, 0x73, 0x5b, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Thv_setup_crash_handler */
	.byte 0x10, 0xbf, 0x68, 0x76, 0x5f, 0xf8, 0xa5, 0x22, 0x63, 0xb5, 0x73, 0x5b, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_hv_remove_crash_handler */
	.byte 0x10, 0x54, 0x68, 0x76, 0x5f, 0xf8, 0xa5, 0x22, 0x63, 0xb5, 0x73, 0x5b, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Thv_remove_crash_handler */
	.byte 0x11, 0xbf, 0x68, 0x76, 0x5f, 0xb2, 0x68, 0x27, 0xee, 0x76, 0xab, 0xce, 0x5f, 0x76, 0xee, 0x73, 0xd9, 0x6e	/* T__pfx_hv_get_hypervisor_version */
	.byte 0x11, 0x54, 0x68, 0x76, 0x5f, 0xb2, 0x68, 0x27, 0xee, 0x76, 0xab, 0xce, 0x5f, 0x76, 0xee, 0x73, 0xd9, 0x6e	/* Thv_get_hypervisor_version */
	.byte 0x11, 0xc6, 0xeb, 0x72, 0x7c, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x80, 0xd3	/* t__pfx_acrn_x2apic_available */
	.byte 0x11, 0x74, 0xeb, 0x72, 0x7c, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x80, 0xd3	/* tacrn_x2apic_available */
	.byte 0x0f, 0xbf, 0xeb, 0x72, 0x6e, 0xba, 0x74, 0x3a, 0xf0, 0xea, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_acrn_setup_intr_handler */
	.byte 0x0f, 0x54, 0xeb, 0x72, 0x6e, 0xba, 0x74, 0x3a, 0xf0, 0xea, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Tacrn_setup_intr_handler */
	.byte 0x0f, 0xbf, 0xeb, 0x72, 0x7c, 0xf8, 0xa5, 0x22, 0xf0, 0xea, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_acrn_remove_intr_handler */
	.byte 0x0f, 0x54, 0xeb, 0x72, 0x7c, 0xf8, 0xa5, 0x22, 0xf0, 0xea, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Tacrn_remove_intr_handler */
	.byte 0x11, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xeb, 0x72, 0x7c, 0x68, 0x76, 0x5f, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx___sysvec_acrn_hv_callback */
	.byte 0x12, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0xeb, 0x72, 0x7c, 0x68, 0x76, 0x5f, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__sysvec_acrn_hv_callback */
	.byte 0x0b, 0xc6, 0xeb, 0x72, 0x7c, 0xb2, 0x74, 0x73, 0xd5, 0x6b, 0x68, 0x7a	/* t__pfx_acrn_get_tsc_khz */
	.byte 0x0b, 0x74, 0xeb, 0x72, 0x7c, 0xb2, 0x74, 0x73, 0xd5, 0x6b, 0x68, 0x7a	/* tacrn_get_tsc_khz */
	.byte 0x13, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xeb, 0x72, 0x7c, 0x68, 0x76, 0x5f, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* T__pfx_fred_sysvec_acrn_hv_callback */
	.byte 0x13, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xeb, 0x72, 0x7c, 0x68, 0x76, 0x5f, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* Tfred_sysvec_acrn_hv_callback */
	.byte 0x08, 0xc6, 0xa9, 0xcd, 0xe6, 0xa2, 0xa6, 0x81, 0xe8	/* t__pfx_dom_debug_open */
	.byte 0x08, 0x74, 0xa9, 0xcd, 0xe6, 0xa2, 0xa6, 0x81, 0xe8	/* tdom_debug_open */
	.byte 0x08, 0xc6, 0x92, 0x5f, 0xe6, 0xa2, 0xa6, 0x81, 0xe8	/* t__pfx_cpu_debug_open */
	.byte 0x08, 0x74, 0x92, 0x5f, 0xe6, 0xa2, 0xa6, 0x81, 0xe8	/* tcpu_debug_open */
	.byte 0x08, 0xc6, 0xa9, 0xcd, 0xe6, 0xa2, 0x67, 0xf6, 0x26	/* t__pfx_dom_debug_show */
	.byte 0x08, 0x74, 0xa9, 0xcd, 0xe6, 0xa2, 0x67, 0xf6, 0x26	/* tdom_debug_show */
	.byte 0x08, 0xc6, 0x92, 0x5f, 0xe6, 0xa2, 0x67, 0xf6, 0x26	/* t__pfx_cpu_debug_show */
	.byte 0x08, 0x74, 0x92, 0x5f, 0xe6, 0xa2, 0x67, 0xf6, 0x26	/* tcpu_debug_show */
	.byte 0x07, 0xbf, 0x23, 0x18, 0xcf, 0x67, 0x73, 0x69	/* T__pfx_acpi_register_gsi */
	.byte 0x07, 0x54, 0x23, 0x18, 0xcf, 0x67, 0x73, 0x69	/* Tacpi_register_gsi */
	.byte 0x08, 0xbf, 0x23, 0xd4, 0x18, 0xcf, 0x67, 0x73, 0x69	/* T__pfx_acpi_unregister_gsi */
	.byte 0x08, 0x54, 0x23, 0xd4, 0x18, 0xcf, 0x67, 0x73, 0x69	/* Tacpi_unregister_gsi */
	.byte 0x09, 0xbf, 0x23, 0x67, 0x73, 0xcb, 0xac, 0x5f, 0xa7, 0x71	/* T__pfx_acpi_gsi_to_irq */
	.byte 0x09, 0x54, 0x23, 0x67, 0x73, 0xcb, 0xac, 0x5f, 0xa7, 0x71	/* Tacpi_gsi_to_irq */
	.byte 0x09, 0xc6, 0x23, 0x18, 0xcf, 0x67, 0x73, 0x69, 0xe7, 0xa3	/* t__pfx_acpi_register_gsi_pic */
	.byte 0x09, 0x74, 0x23, 0x18, 0xcf, 0x67, 0x73, 0x69, 0xe7, 0xa3	/* tacpi_register_gsi_pic */
	.byte 0x05, 0xbf, 0x23, 0xd4, 0x84, 0x92	/* T__pfx_acpi_unmap_cpu */
	.byte 0x05, 0x54, 0x23, 0xd4, 0x84, 0x92	/* Tacpi_unmap_cpu */
	.byte 0x08, 0xbf, 0x23, 0x18, 0xcf, 0xd9, 0x61, 0x70, 0xa3	/* T__pfx_acpi_register_ioapic */
	.byte 0x08, 0x54, 0x23, 0x18, 0xcf, 0xd9, 0x61, 0x70, 0xa3	/* Tacpi_register_ioapic */
	.byte 0x09, 0xbf, 0x23, 0xd4, 0x18, 0xcf, 0xd9, 0x61, 0x70, 0xa3	/* T__pfx_acpi_unregister_ioapic */
	.byte 0x09, 0x54, 0x23, 0xd4, 0x18, 0xcf, 0xd9, 0x61, 0x70, 0xa3	/* Tacpi_unregister_ioapic */
	.byte 0x0c, 0xc6, 0x23, 0xd4, 0x18, 0xcf, 0x67, 0x73, 0xcb, 0xd9, 0x61, 0x70, 0xa3	/* t__pfx_acpi_unregister_gsi_ioapic */
	.byte 0x0c, 0x74, 0x23, 0xd4, 0x18, 0xcf, 0x67, 0x73, 0xcb, 0xd9, 0x61, 0x70, 0xa3	/* tacpi_unregister_gsi_ioapic */
	.byte 0x0b, 0xc6, 0x23, 0x18, 0xcf, 0x67, 0x73, 0xcb, 0xd9, 0x61, 0x70, 0xa3	/* t__pfx_acpi_register_gsi_ioapic */
	.byte 0x0b, 0x74, 0x23, 0x18, 0xcf, 0x67, 0x73, 0xcb, 0xd9, 0x61, 0x70, 0xa3	/* tacpi_register_gsi_ioapic */
	.byte 0x0b, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x23, 0x6f, 0xe0, 0xd9, 0xf8, 0x0a	/* T__pfx_x86_acpi_os_ioremap */
	.byte 0x0b, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x23, 0x6f, 0xe0, 0xd9, 0xf8, 0x0a	/* Tx86_acpi_os_ioremap */
	.byte 0x04, 0xbf, 0x23, 0x84, 0x92	/* T__pfx_acpi_map_cpu */
	.byte 0x04, 0x54, 0x23, 0x84, 0x92	/* Tacpi_map_cpu */
	.byte 0x0c, 0xbf, 0x23, 0xab, 0x61, 0x5f, 0xa7, 0x93, 0xac, 0x5f, 0x67, 0x73, 0x69	/* T__pfx_acpi_isa_irq_to_gsi */
	.byte 0x0c, 0x54, 0x23, 0xab, 0x61, 0x5f, 0xa7, 0x93, 0xac, 0x5f, 0x67, 0x73, 0x69	/* Tacpi_isa_irq_to_gsi */
	.byte 0x0b, 0xbf, 0x23, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x18, 0x65, 0xf8, 0x64	/* T__pfx_acpi_ioapic_registered */
	.byte 0x0b, 0x54, 0x23, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x18, 0x65, 0xf8, 0x64	/* Tacpi_ioapic_registered */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x23, 0xeb, 0x8e, 0xa7, 0xfa, 0x67, 0xdf, 0x62, 0xe1, 0x5f, 0x3c	/* T__pfx___acpi_acquire_global_lock */
	.byte 0x0c, 0x2f, 0x23, 0xeb, 0x8e, 0xa7, 0xfa, 0x67, 0xdf, 0x62, 0xe1, 0x5f, 0x3c	/* T__acpi_acquire_global_lock */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x23, 0xf8, 0xd3, 0x96, 0xfa, 0x67, 0xdf, 0x62, 0xe1, 0x5f, 0x3c	/* T__pfx___acpi_release_global_lock */
	.byte 0x0c, 0x2f, 0x23, 0xf8, 0xd3, 0x96, 0xfa, 0x67, 0xdf, 0x62, 0xe1, 0x5f, 0x3c	/* T__acpi_release_global_lock */
	.byte 0x14, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0xc9, 0xf9, 0xde, 0x6f, 0xf9, 0x70, 0x6f, 0xf0, 0x74, 0xee	/* T__pfx_x86_default_set_root_pointer */
	.byte 0x14, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0xc9, 0xf9, 0xde, 0x6f, 0xf9, 0x70, 0x6f, 0xf0, 0x74, 0xee	/* Tx86_default_set_root_pointer */
	.byte 0x13, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0xb2, 0xde, 0x6f, 0xf9, 0x70, 0x6f, 0xf0, 0x74, 0xee	/* T__pfx_x86_default_get_root_pointer */
	.byte 0x13, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0xb2, 0xde, 0x6f, 0xf9, 0x70, 0x6f, 0xf0, 0x74, 0xee	/* Tx86_default_get_root_pointer */
	.byte 0x09, 0xbf, 0x23, 0xb2, 0x13, 0x0e, 0x3a, 0x10, 0x3d, 0x73	/* T__pfx_acpi_get_wakeup_address */
	.byte 0x09, 0x54, 0x23, 0xb2, 0x13, 0x0e, 0x3a, 0x10, 0x3d, 0x73	/* Tacpi_get_wakeup_address */
	.byte 0x0e, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x23, 0x1e, 0xee, 0xf6, 0xd3, 0x65, 0x70, 0x2a, 0x86	/* T__pfx_x86_acpi_enter_sleep_state */
	.byte 0x0e, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x23, 0x1e, 0xee, 0xf6, 0xd3, 0x65, 0x70, 0x2a, 0x86	/* Tx86_acpi_enter_sleep_state */
	.byte 0x13, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0xeb, 0x70, 0x69, 0xf6, 0x5d, 0x70, 0xe8, 0xe5, 0xdf, 0x77, 0xd3, 0x76, 0x65, 0x6c	/* T__pfx_x86_acpi_suspend_lowlevel */
	.byte 0x13, 0x54, 0x78, 0x38, 0x36, 0x5f, 0xeb, 0x70, 0x69, 0xf6, 0x5d, 0x70, 0xe8, 0xe5, 0xdf, 0x77, 0xd3, 0x76, 0x65, 0x6c	/* Tx86_acpi_suspend_lowlevel */
	.byte 0x09, 0xbf, 0x13, 0x0e, 0x3a, 0xdf, 0x6e, 0x67, 0x36, 0x34	/* T__pfx_wakeup_long64 */
	.byte 0x09, 0x54, 0x13, 0x0e, 0x3a, 0xdf, 0x6e, 0x67, 0x36, 0x34	/* Twakeup_long64 */
	.byte 0x0d, 0xbf, 0xa9, 0xf6, 0x5d, 0x70, 0xe8, 0xe5, 0xdf, 0x77, 0xd3, 0x76, 0x65, 0x6c	/* T__pfx_do_suspend_lowlevel */
	.byte 0x0d, 0x54, 0xa9, 0xf6, 0x5d, 0x70, 0xe8, 0xe5, 0xdf, 0x77, 0xd3, 0x76, 0x65, 0x6c	/* Tdo_suspend_lowlevel */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0x5f, 0x61, 0x70, 0x65, 0xcb, 0xe8, 0x80, 0xb3, 0x63, 0x6d, 0x63, 0x66, 0x66	/* T__pfx_arch_apei_enable_cmcff */
	.byte 0x10, 0x54, 0xca, 0xd0, 0x5f, 0x61, 0x70, 0x65, 0xcb, 0xe8, 0x80, 0xb3, 0x63, 0x6d, 0x63, 0x66, 0x66	/* Tarch_apei_enable_cmcff */
	.byte 0x11, 0xbf, 0xca, 0xd0, 0x5f, 0x61, 0x70, 0x65, 0xcb, 0xf8, 0x70, 0xce, 0xf9, 0xbd, 0xcd, 0xee, 0xde, 0x72	/* T__pfx_arch_apei_report_mem_error */
	.byte 0x11, 0x54, 0xca, 0xd0, 0x5f, 0x61, 0x70, 0x65, 0xcb, 0xf8, 0x70, 0xce, 0xf9, 0xbd, 0xcd, 0xee, 0xde, 0x72	/* Tarch_apei_report_mem_error */
	.byte 0x13, 0xbf, 0xca, 0xd0, 0x5f, 0x61, 0x70, 0x65, 0xcb, 0xf8, 0x70, 0xce, 0xf9, 0x78, 0x38, 0x36, 0x5f, 0xee, 0xde, 0x72	/* T__pfx_arch_apei_report_x86_error */
	.byte 0x13, 0x54, 0xca, 0xd0, 0x5f, 0x61, 0x70, 0x65, 0xcb, 0xf8, 0x70, 0xce, 0xf9, 0x78, 0x38, 0x36, 0x5f, 0xee, 0xde, 0x72	/* Tarch_apei_report_x86_error */
	.byte 0x0d, 0xbf, 0x61, 0x6d, 0xe5, 0xb2, 0x68, 0x2c, 0x68, 0x3b, 0xf9, 0x70, 0xee, 0x66	/* T__pfx_amd_get_highest_perf */
	.byte 0x0d, 0x54, 0x61, 0x6d, 0xe5, 0xb2, 0x68, 0x2c, 0x68, 0x3b, 0xf9, 0x70, 0xee, 0x66	/* Tamd_get_highest_perf */
	.byte 0x0d, 0xbf, 0x61, 0x6d, 0xe5, 0xe6, 0x9a, 0x63, 0xf9, 0x70, 0xf8, 0x66, 0xfe, 0xf8	/* T__pfx_amd_detect_prefcore */
	.byte 0x0d, 0x54, 0x61, 0x6d, 0xe5, 0xe6, 0x9a, 0x63, 0xf9, 0x70, 0xf8, 0x66, 0xfe, 0xf8	/* Tamd_detect_prefcore */
	.byte 0x13, 0xbf, 0x61, 0x6d, 0xe5, 0xb2, 0x62, 0x6f, 0x6f, 0x73, 0xf9, 0x72, 0xe9, 0x3e, 0x6e, 0x75, 0x6d, 0xee, 0xe9, 0xce	/* T__pfx_amd_get_boost_ratio_numerator */
	.byte 0x13, 0x54, 0x61, 0x6d, 0xe5, 0xb2, 0x62, 0x6f, 0x6f, 0x73, 0xf9, 0x72, 0xe9, 0x3e, 0x6e, 0x75, 0x6d, 0xee, 0xe9, 0xce	/* Tamd_get_boost_ratio_numerator */
	.byte 0x0d, 0xbf, 0x63, 0x70, 0x63, 0xf6, 0xb9, 0x70, 0xce, 0x9a, 0xe5, 0x62, 0xc5, 0x92	/* T__pfx_cpc_supported_by_cpu */
	.byte 0x0d, 0x54, 0x63, 0x70, 0x63, 0xf6, 0xb9, 0x70, 0xce, 0x9a, 0xe5, 0x62, 0xc5, 0x92	/* Tcpc_supported_by_cpu */
	.byte 0x0d, 0xbf, 0x63, 0x70, 0xd5, 0x66, 0x66, 0x68, 0xf6, 0xb9, 0x70, 0xce, 0x9a, 0x64	/* T__pfx_cpc_ffh_supported */
	.byte 0x0d, 0x54, 0x63, 0x70, 0xd5, 0x66, 0x66, 0x68, 0xf6, 0xb9, 0x70, 0xce, 0x9a, 0x64	/* Tcpc_ffh_supported */
	.byte 0x09, 0xbf, 0x63, 0x70, 0xd5, 0xf8, 0x05, 0x66, 0x66, 0x68	/* T__pfx_cpc_read_ffh */
	.byte 0x09, 0x54, 0x63, 0x70, 0xd5, 0xf8, 0x05, 0x66, 0x66, 0x68	/* Tcpc_read_ffh */
	.byte 0x09, 0xbf, 0x63, 0x70, 0xd5, 0x24, 0xfa, 0x66, 0x66, 0x68	/* T__pfx_cpc_write_ffh */
	.byte 0x09, 0x54, 0x63, 0x70, 0xd5, 0x24, 0xfa, 0x66, 0x66, 0x68	/* Tcpc_write_ffh */
	.byte 0x17, 0xbf, 0xeb, 0x70, 0x69, 0x25, 0x63, 0x3b, 0x73, 0xce, 0x5f, 0xf0, 0x99, 0xf0, 0x76, 0xca, 0x69, 0xcc, 0x63, 0xfa, 0x63, 0x70, 0x70, 0x63	/* T__pfx_acpi_processor_init_invariance_cppc */
	.byte 0x17, 0x54, 0xeb, 0x70, 0x69, 0x25, 0x63, 0x3b, 0x73, 0xce, 0x5f, 0xf0, 0x99, 0xf0, 0x76, 0xca, 0x69, 0xcc, 0x63, 0xfa, 0x63, 0x70, 0x70, 0x63	/* Tacpi_processor_init_invariance_cppc */
	.byte 0x06, 0xc6, 0x23, 0x13, 0x0e, 0x3a, 0x92	/* t__pfx_acpi_wakeup_cpu */
	.byte 0x06, 0x74, 0x23, 0x13, 0x0e, 0x3a, 0x92	/* tacpi_wakeup_cpu */
	.byte 0x09, 0xc6, 0x23, 0x6d, 0xe2, 0x92, 0x5f, 0x64, 0x69, 0x65	/* t__pfx_acpi_mp_cpu_die */
	.byte 0x09, 0x74, 0x23, 0x6d, 0xe2, 0x92, 0x5f, 0x64, 0x69, 0x65	/* tacpi_mp_cpu_die */
	.byte 0x0a, 0xc6, 0x23, 0xb0, 0xf6, 0xac, 0xe2, 0x15, 0x69, 0xe0, 0x92	/* t__pfx_acpi_mp_stop_this_cpu */
	.byte 0x0a, 0x74, 0x23, 0xb0, 0xf6, 0xac, 0xe2, 0x15, 0x69, 0xe0, 0x92	/* tacpi_mp_stop_this_cpu */
	.byte 0x08, 0xc6, 0x23, 0xb0, 0xe7, 0x1b, 0xc5, 0xe6, 0xc7	/* t__pfx_acpi_mp_play_dead */
	.byte 0x08, 0x74, 0x23, 0xb0, 0xe7, 0x1b, 0xc5, 0xe6, 0xc7	/* tacpi_mp_play_dead */
	.byte 0x0a, 0xbf, 0x96, 0xcd, 0x23, 0xb0, 0xe7, 0x1b, 0xc5, 0xe6, 0xc7	/* T__pfx_asm_acpi_mp_play_dead */
	.byte 0x0a, 0x54, 0x96, 0xcd, 0x23, 0xb0, 0xe7, 0x1b, 0xc5, 0xe6, 0xc7	/* Tasm_acpi_mp_play_dead */
	.byte 0x14, 0xbf, 0xeb, 0x70, 0x69, 0x25, 0x63, 0x3b, 0x73, 0xce, 0xe7, 0x6f, 0x77, 0xcf, 0xf0, 0x99, 0x62, 0xcd, 0x7e, 0x63, 0x6b	/* T__pfx_acpi_processor_power_init_bm_check */
	.byte 0x14, 0x54, 0xeb, 0x70, 0x69, 0x25, 0x63, 0x3b, 0x73, 0xce, 0xe7, 0x6f, 0x77, 0xcf, 0xf0, 0x99, 0x62, 0xcd, 0x7e, 0x63, 0x6b	/* Tacpi_processor_power_init_bm_check */
	.byte 0x14, 0xc6, 0xeb, 0x70, 0x69, 0x25, 0x63, 0x3b, 0x73, 0xce, 0x5f, 0x66, 0x66, 0x5b, 0x63, 0xd6, 0xa1, 0x9b, 0x62, 0xfa, 0x92	/* t__pfx_acpi_processor_ffh_cstate_probe_cpu */
	.byte 0x14, 0x74, 0xeb, 0x70, 0x69, 0x25, 0x63, 0x3b, 0x73, 0xce, 0x5f, 0x66, 0x66, 0x5b, 0x63, 0xd6, 0xa1, 0x9b, 0x62, 0xfa, 0x92	/* tacpi_processor_ffh_cstate_probe_cpu */
	.byte 0x12, 0xbf, 0xeb, 0x70, 0x69, 0x25, 0x63, 0x3b, 0x73, 0xce, 0x5f, 0x66, 0x66, 0x5b, 0x63, 0xd6, 0xa1, 0x9b, 0x17	/* T__pfx_acpi_processor_ffh_cstate_probe */
	.byte 0x12, 0x54, 0xeb, 0x70, 0x69, 0x25, 0x63, 0x3b, 0x73, 0xce, 0x5f, 0x66, 0x66, 0x5b, 0x63, 0xd6, 0xa1, 0x9b, 0x17	/* Tacpi_processor_ffh_cstate_probe */
	.byte 0x0d, 0xbf, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0xf8, 0xe1, 0x5f, 0x3d, 0xdb, 0x72, 0x74	/* T__pfx_machine_real_restart */
	.byte 0x0d, 0x54, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0xf8, 0xe1, 0x5f, 0x3d, 0xdb, 0x72, 0x74	/* Tmachine_real_restart */
	.byte 0x14, 0xbf, 0x92, 0x5f, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0xc5, 0x18, 0xcf, 0x76, 0xa7, 0xf9, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* T__pfx_cpu_emergency_register_virt_callback */
	.byte 0x14, 0x54, 0x92, 0x5f, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0xc5, 0x18, 0xcf, 0x76, 0xa7, 0xf9, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* Tcpu_emergency_register_virt_callback */
	.byte 0x15, 0xbf, 0x92, 0x5f, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0xc5, 0xd4, 0x18, 0xcf, 0x76, 0xa7, 0xf9, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* T__pfx_cpu_emergency_unregister_virt_callback */
	.byte 0x15, 0x54, 0x92, 0x5f, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0xc5, 0xd4, 0x18, 0xcf, 0x76, 0xa7, 0xf9, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* Tcpu_emergency_unregister_virt_callback */
	.byte 0x10, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x73, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* T__pfx_native_machine_shutdown */
	.byte 0x10, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x73, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* Tnative_machine_shutdown */
	.byte 0x11, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x70, 0x6f, 0x77, 0xcf, 0x6f, 0x66, 0x66	/* t__pfx_native_machine_power_off */
	.byte 0x11, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x70, 0x6f, 0x77, 0xcf, 0x6f, 0x66, 0x66	/* tnative_machine_power_off */
	.byte 0x0d, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x68, 0xe1, 0x74	/* t__pfx_native_machine_halt */
	.byte 0x0d, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x68, 0xe1, 0x74	/* tnative_machine_halt */
	.byte 0x18, 0xbf, 0x92, 0x5f, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0xc5, 0x64, 0xab, 0x80, 0xb3, 0x76, 0xa7, 0x74, 0x75, 0xe1, 0x69, 0x7a, 0xe9, 0xd9, 0x6e	/* T__pfx_cpu_emergency_disable_virtualization */
	.byte 0x18, 0x54, 0x92, 0x5f, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0xc5, 0x64, 0xab, 0x80, 0xb3, 0x76, 0xa7, 0x74, 0x75, 0xe1, 0x69, 0x7a, 0xe9, 0xd9, 0x6e	/* Tcpu_emergency_disable_virtualization */
	.byte 0x0d, 0xc6, 0x63, 0xb5, 0x73, 0x5b, 0x6e, 0x6d, 0xcb, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_crash_nmi_callback */
	.byte 0x0c, 0x2d, 0xb5, 0x73, 0x5b, 0x6e, 0x6d, 0xcb, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tcrash_nmi_callback */
	.byte 0x0e, 0x57, 0xe3, 0x6d, 0xeb, 0x5b, 0xf8, 0x62, 0x6f, 0x6f, 0xf9, 0xb8, 0x78, 0xb9, 0x73	/* W__pfx_mach_reboot_fixups */
	.byte 0x0d, 0x57, 0x6d, 0xeb, 0x5b, 0xf8, 0x62, 0x6f, 0x6f, 0xf9, 0xb8, 0x78, 0xb9, 0x73	/* Wmach_reboot_fixups */
	.byte 0x0d, 0xbf, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x70, 0x6f, 0x77, 0xcf, 0x6f, 0x66, 0x66	/* T__pfx_machine_power_off */
	.byte 0x0d, 0x54, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x70, 0x6f, 0x77, 0xcf, 0x6f, 0x66, 0x66	/* Tmachine_power_off */
	.byte 0x0c, 0xbf, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x73, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* T__pfx_machine_shutdown */
	.byte 0x0c, 0x54, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x73, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* Tmachine_shutdown */
	.byte 0x11, 0xbf, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0xc5, 0x3d, 0xdb, 0x72, 0x74	/* T__pfx_machine_emergency_restart */
	.byte 0x11, 0x54, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0xc5, 0x3d, 0xdb, 0x72, 0x74	/* Tmachine_emergency_restart */
	.byte 0x0a, 0xbf, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x3d, 0xdb, 0x72, 0x74	/* T__pfx_machine_restart */
	.byte 0x0a, 0x54, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x3d, 0xdb, 0x72, 0x74	/* Tmachine_restart */
	.byte 0x09, 0xbf, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x68, 0xe1, 0x74	/* T__pfx_machine_halt */
	.byte 0x09, 0x54, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x68, 0xe1, 0x74	/* Tmachine_halt */
	.byte 0x10, 0xbf, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* T__pfx_machine_crash_shutdown */
	.byte 0x10, 0x54, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* Tmachine_crash_shutdown */
	.byte 0x0d, 0xbf, 0x6e, 0x6d, 0x69, 0xf6, 0xad, 0x6f, 0x74, 0xa9, 0x77, 0x7c, 0x92, 0x73	/* T__pfx_nmi_shootdown_cpus */
	.byte 0x0d, 0x54, 0x6e, 0x6d, 0x69, 0xf6, 0xad, 0x6f, 0x74, 0xa9, 0x77, 0x7c, 0x92, 0x73	/* Tnmi_shootdown_cpus */
	.byte 0x15, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0xc5, 0x3d, 0xdb, 0x72, 0x74	/* t__pfx_native_machine_emergency_restart */
	.byte 0x15, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x65, 0x6d, 0xee, 0x67, 0xe8, 0x63, 0xc5, 0x3d, 0xdb, 0x72, 0x74	/* tnative_machine_emergency_restart */
	.byte 0x0f, 0xbf, 0x72, 0xd4, 0x5f, 0x63, 0xb5, 0x73, 0x5b, 0x69, 0x85, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* T__pfx_run_crash_ipi_callback */
	.byte 0x0f, 0x54, 0x72, 0xd4, 0x5f, 0x63, 0xb5, 0x73, 0x5b, 0x69, 0x85, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* Trun_crash_ipi_callback */
	.byte 0x0d, 0xbf, 0x6e, 0x6d, 0x69, 0xe7, 0xcc, 0xa3, 0xba, 0x6c, 0x66, 0xf6, 0xac, 0x70	/* T__pfx_nmi_panic_self_stop */
	.byte 0x0d, 0x54, 0x6e, 0x6d, 0x69, 0xe7, 0xcc, 0xa3, 0xba, 0x6c, 0x66, 0xf6, 0xac, 0x70	/* Tnmi_panic_self_stop */
	.byte 0x0e, 0xa8, 0xf6, 0xb0, 0xf6, 0xac, 0xe2, 0x6e, 0x6d, 0xcb, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_smp_stop_nmi_callback */
	.byte 0x0e, 0x74, 0x73, 0xb0, 0xf6, 0xac, 0xe2, 0x6e, 0x6d, 0xcb, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tsmp_stop_nmi_callback */
	.byte 0x0b, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xf8, 0x62, 0x6f, 0x6f, 0x74	/* t__pfx___sysvec_reboot */
	.byte 0x0c, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0xf8, 0x62, 0x6f, 0x6f, 0x74	/* t__sysvec_reboot */
	.byte 0x0d, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xd6, 0x6f, 0xe2, 0x6f, 0x15, 0xcf, 0x92, 0x73	/* t__pfx_native_stop_other_cpus */
	.byte 0x0d, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xd6, 0x6f, 0xe2, 0x6f, 0x15, 0xcf, 0x92, 0x73	/* tnative_stop_other_cpus */
	.byte 0x10, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xd3	/* t__pfx___sysvec_call_function_single */
	.byte 0x11, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xd3	/* t__sysvec_call_function_single */
	.byte 0x0c, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e	/* t__pfx___sysvec_call_function */
	.byte 0x0d, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e	/* t__sysvec_call_function */
	.byte 0x10, 0xc6, 0xc8, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xd1, 0xe4, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_trace_reschedule_exit.constprop.0 */
	.byte 0x10, 0x74, 0xc8, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xd1, 0xe4, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* ttrace_reschedule_exit.constprop.0 */
	.byte 0x11, 0xc6, 0xc8, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xe8, 0xea, 0x79, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_trace_reschedule_entry.constprop.0 */
	.byte 0x11, 0x74, 0xc8, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0xe8, 0xea, 0x79, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* ttrace_reschedule_entry.constprop.0 */
	.byte 0x0d, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xf8, 0x62, 0x6f, 0x6f, 0x74	/* T__pfx_fred_sysvec_reboot */
	.byte 0x0d, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xf8, 0x62, 0x6f, 0x6f, 0x74	/* Tfred_sysvec_reboot */
	.byte 0x0f, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0x0c, 0x69	/* T__pfx_fred_sysvec_reschedule_ipi */
	.byte 0x0f, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x3d, 0x7e, 0x64, 0x75, 0xb3, 0x0c, 0x69	/* Tfred_sysvec_reschedule_ipi */
	.byte 0x0e, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e	/* T__pfx_fred_sysvec_call_function */
	.byte 0x0e, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e	/* Tfred_sysvec_call_function */
	.byte 0x12, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xd3	/* T__pfx_fred_sysvec_call_function_single */
	.byte 0x12, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x28, 0xc3, 0x2b, 0x7b, 0xd9, 0x6e, 0xf6, 0xf0, 0x67, 0xd3	/* Tfred_sysvec_call_function_single */
	.byte 0x07, 0xc6, 0x92, 0xf6, 0x6d, 0xf9, 0xdd, 0x16	/* t__pfx_cpu_smt_mask */
	.byte 0x07, 0x74, 0x92, 0xf6, 0x6d, 0xf9, 0xdd, 0x16	/* tcpu_smt_mask */
	.byte 0x07, 0xc6, 0x92, 0x5f, 0x92, 0x5f, 0xdd, 0x16	/* t__pfx_cpu_cpu_mask */
	.byte 0x07, 0x74, 0x92, 0x5f, 0x92, 0x5f, 0xdd, 0x16	/* tcpu_cpu_mask */
	.byte 0x0c, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0xfe, 0x72, 0xfa, 0x66, 0x1b, 0x67, 0x73	/* t__pfx_x86_core_flags */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0x5f, 0xfe, 0x72, 0xfa, 0x66, 0x1b, 0x67, 0x73	/* tx86_core_flags */
	.byte 0x0b, 0xc6, 0x78, 0x38, 0x36, 0xf6, 0x6d, 0xf9, 0x66, 0x1b, 0x67, 0x73	/* t__pfx_x86_smt_flags */
	.byte 0x0b, 0x74, 0x78, 0x38, 0x36, 0xf6, 0x6d, 0xf9, 0x66, 0x1b, 0x67, 0x73	/* tx86_smt_flags */
	.byte 0x0e, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0x63, 0x6c, 0x75, 0xd6, 0xcf, 0x66, 0x1b, 0x67, 0x73	/* t__pfx_x86_cluster_flags */
	.byte 0x0e, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x63, 0x6c, 0x75, 0xd6, 0xcf, 0x66, 0x1b, 0x67, 0x73	/* tx86_cluster_flags */
	.byte 0x0c, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0x64, 0x69, 0xfa, 0x66, 0x1b, 0x67, 0x73	/* t__pfx_x86_die_flags */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x64, 0x69, 0xfa, 0x66, 0x1b, 0x67, 0x73	/* tx86_die_flags */
	.byte 0x09, 0xbf, 0x92, 0x5f, 0xfe, 0x9f, 0xde, 0x3a, 0xdd, 0x16	/* T__pfx_cpu_coregroup_mask */
	.byte 0x09, 0x54, 0x92, 0x5f, 0xfe, 0x9f, 0xde, 0x3a, 0xdd, 0x16	/* Tcpu_coregroup_mask */
	.byte 0x0c, 0xbf, 0x92, 0x5f, 0x63, 0x6c, 0x75, 0xd6, 0xee, 0x0d, 0x3a, 0xdd, 0x16	/* T__pfx_cpu_clustergroup_mask */
	.byte 0x0c, 0x54, 0x92, 0x5f, 0x63, 0x6c, 0x75, 0xd6, 0xee, 0x0d, 0x3a, 0xdd, 0x16	/* Tcpu_clustergroup_mask */
	.byte 0x0a, 0xc6, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0x79, 0xf6, 0xcc, 0x65	/* t__pfx_topology_sane */
	.byte 0x0a, 0x74, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0x79, 0xf6, 0xcc, 0x65	/* ttopology_sane */
	.byte 0x07, 0xc6, 0x6d, 0xe9, 0xd0, 0xf6, 0x6d, 0x74	/* t__pfx_match_smt */
	.byte 0x07, 0x74, 0x6d, 0xe9, 0xd0, 0xf6, 0x6d, 0x74	/* tmatch_smt */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0xb9, 0x64, 0xa1, 0x92, 0x5f, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0x79	/* T__pfx_arch_update_cpu_topology */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0xb9, 0x64, 0xa1, 0x92, 0x5f, 0xac, 0x70, 0x6f, 0xdf, 0x67, 0x79	/* Tarch_update_cpu_topology */
	.byte 0x0b, 0x3f, 0xf6, 0xb0, 0x2a, 0xce, 0xfa, 0x92, 0x5f, 0xf0, 0x66, 0x6f	/* T__pfx_smp_store_cpu_info */
	.byte 0x0b, 0x54, 0x73, 0xb0, 0x2a, 0xce, 0xfa, 0x92, 0x5f, 0xf0, 0x66, 0x6f	/* Tsmp_store_cpu_info */
	.byte 0x09, 0x3f, 0x1f, 0x92, 0xf6, 0x69, 0x62, 0x88, 0xa6, 0x0a	/* T__pfx_set_cpu_sibling_map */
	.byte 0x0a, 0x54, 0xc9, 0xf9, 0x92, 0xf6, 0x69, 0x62, 0x88, 0xa6, 0x0a	/* Tset_cpu_sibling_map */
	.byte 0x0a, 0xa8, 0xf6, 0xdb, 0x72, 0xf9, 0xc9, 0x98, 0x64, 0xca, 0x79	/* t__pfx_start_secondary */
	.byte 0x0a, 0x74, 0x73, 0xdb, 0x72, 0xf9, 0xc9, 0x98, 0x64, 0xca, 0x79	/* tstart_secondary */
	.byte 0x08, 0xbf, 0xfe, 0x6d, 0xa5, 0x7c, 0x92, 0x5f, 0xb9	/* T__pfx_common_cpu_up */
	.byte 0x08, 0x54, 0xfe, 0x6d, 0xa5, 0x7c, 0x92, 0x5f, 0xb9	/* Tcommon_cpu_up */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0x5f, 0x92, 0x68, 0xe2, 0x6b, 0xa3, 0xd8, 0x61, 0xe2, 0xe1, 0x69, 0x76, 0x65	/* T__pfx_arch_cpuhp_kick_ap_alive */
	.byte 0x10, 0x54, 0xca, 0xd0, 0x5f, 0x92, 0x68, 0xe2, 0x6b, 0xa3, 0xd8, 0x61, 0xe2, 0xe1, 0x69, 0x76, 0x65	/* Tarch_cpuhp_kick_ap_alive */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0x92, 0x68, 0xe2, 0x63, 0xd3, 0xcc, 0x3a, 0x6b, 0xa3, 0xd8, 0x92	/* T__pfx_arch_cpuhp_cleanup_kick_cpu */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0x92, 0x68, 0xe2, 0x63, 0xd3, 0xcc, 0x3a, 0x6b, 0xa3, 0xd8, 0x92	/* Tarch_cpuhp_cleanup_kick_cpu */
	.byte 0x0a, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x6b, 0xa3, 0xd8, 0x61, 0x70	/* T__pfx_native_kick_ap */
	.byte 0x0a, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x6b, 0xa3, 0xd8, 0x61, 0x70	/* Tnative_kick_ap */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0x92, 0x68, 0xe2, 0x63, 0xd3, 0xcc, 0x3a, 0xe6, 0x05, 0x92	/* T__pfx_arch_cpuhp_cleanup_dead_cpu */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0x92, 0x68, 0xe2, 0x63, 0xd3, 0xcc, 0x3a, 0xe6, 0x05, 0x92	/* Tarch_cpuhp_cleanup_dead_cpu */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0x92, 0x68, 0x70, 0x95, 0x6e, 0x63, 0x2a, 0xa1, 0x70, 0x7f, 0x6c	/* T__pfx_arch_cpuhp_sync_state_poll */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0x92, 0x68, 0x70, 0x95, 0x6e, 0x63, 0x2a, 0xa1, 0x70, 0x7f, 0x6c	/* Tarch_cpuhp_sync_state_poll */
	.byte 0x11, 0xbf, 0xca, 0xd0, 0x5f, 0x15, 0x61, 0x77, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x92, 0xe0, 0x17, 0x67, 0xf0	/* T__pfx_arch_thaw_secondary_cpus_begin */
	.byte 0x11, 0x54, 0xca, 0xd0, 0x5f, 0x15, 0x61, 0x77, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x92, 0xe0, 0x17, 0x67, 0xf0	/* Tarch_thaw_secondary_cpus_begin */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0x5f, 0x15, 0x61, 0x77, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x92, 0xe0, 0xe8, 0x64	/* T__pfx_arch_thaw_secondary_cpus_end */
	.byte 0x10, 0x54, 0xca, 0xd0, 0x5f, 0x15, 0x61, 0x77, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x92, 0xe0, 0xe8, 0x64	/* Tarch_thaw_secondary_cpus_end */
	.byte 0x0b, 0xbf, 0x92, 0x5f, 0x64, 0xab, 0x80, 0xb3, 0xfe, 0x6d, 0xa5, 0x6e	/* T__pfx_cpu_disable_common */
	.byte 0x0b, 0x54, 0x92, 0x5f, 0x64, 0xab, 0x80, 0xb3, 0xfe, 0x6d, 0xa5, 0x6e	/* Tcpu_disable_common */
	.byte 0x0b, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x92, 0x5f, 0x64, 0xab, 0x80, 0xd3	/* T__pfx_native_cpu_disable */
	.byte 0x0b, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x92, 0x5f, 0x64, 0xab, 0x80, 0xd3	/* Tnative_cpu_disable */
	.byte 0x0a, 0x3f, 0xe7, 0x1b, 0xc5, 0xe6, 0x05, 0xfe, 0x6d, 0xa5, 0x6e	/* T__pfx_play_dead_common */
	.byte 0x0a, 0x54, 0x70, 0x1b, 0xc5, 0xe6, 0x05, 0xfe, 0x6d, 0xa5, 0x6e	/* Tplay_dead_common */
	.byte 0x0f, 0x3f, 0xf6, 0x6d, 0xe2, 0x6b, 0xa3, 0xd8, 0x6d, 0x13, 0x99, 0x70, 0x1b, 0xc5, 0xe6, 0xc7	/* T__pfx_smp_kick_mwait_play_dead */
	.byte 0x0f, 0x54, 0x73, 0x6d, 0xe2, 0x6b, 0xa3, 0xd8, 0x6d, 0x13, 0x99, 0x70, 0x1b, 0xc5, 0xe6, 0xc7	/* Tsmp_kick_mwait_play_dead */
	.byte 0x09, 0xbf, 0x68, 0x6c, 0xf9, 0x70, 0x1b, 0xc5, 0xe6, 0xc7	/* T__pfx_hlt_play_dead */
	.byte 0x09, 0x54, 0x68, 0x6c, 0xf9, 0x70, 0x1b, 0xc5, 0xe6, 0xc7	/* Thlt_play_dead */
	.byte 0x0a, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x70, 0x1b, 0xc5, 0xe6, 0xc7	/* T__pfx_native_play_dead */
	.byte 0x0a, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x70, 0x1b, 0xc5, 0xe6, 0xc7	/* Tnative_play_dead */
	.byte 0x12, 0xc6, 0x74, 0x73, 0x63, 0x95, 0x6e, 0xd5, 0xdd, 0x72, 0xd8, 0x74, 0x73, 0xd5, 0xd4, 0x73, 0xdb, 0x62, 0xd3	/* t__pfx_tsc_sync_mark_tsc_unstable */
	.byte 0x12, 0x74, 0x74, 0x73, 0x63, 0x95, 0x6e, 0xd5, 0xdd, 0x72, 0xd8, 0x74, 0x73, 0xd5, 0xd4, 0x73, 0xdb, 0x62, 0xd3	/* ttsc_sync_mark_tsc_unstable */
	.byte 0x08, 0xc6, 0xdf, 0x6f, 0xe2, 0xc2, 0xbd, 0x6f, 0x5e	/* t__pfx_loop_timeout */
	.byte 0x08, 0x74, 0xdf, 0x6f, 0xe2, 0xc2, 0xbd, 0x6f, 0x5e	/* tloop_timeout */
	.byte 0x12, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_paravirt_write_msr.constprop.0 */
	.byte 0x11, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tparavirt_write_msr.constprop.0 */
	.byte 0x0a, 0xc6, 0x7e, 0x63, 0xd8, 0x74, 0x73, 0xd5, 0x77, 0xca, 0x70	/* t__pfx_check_tsc_warp */
	.byte 0x0a, 0x74, 0x7e, 0x63, 0xd8, 0x74, 0x73, 0xd5, 0x77, 0xca, 0x70	/* tcheck_tsc_warp */
	.byte 0x0f, 0xc6, 0x7e, 0x63, 0xd8, 0x74, 0x73, 0x63, 0x95, 0x6e, 0x63, 0xf6, 0x6f, 0x1d, 0x63, 0x65	/* t__pfx_check_tsc_sync_source */
	.byte 0x0f, 0x74, 0x7e, 0x63, 0xd8, 0x74, 0x73, 0x63, 0x95, 0x6e, 0x63, 0xf6, 0x6f, 0x1d, 0x63, 0x65	/* tcheck_tsc_sync_source */
	.byte 0x0f, 0xbf, 0xdd, 0x72, 0xd8, 0x74, 0x73, 0xd5, 0x61, 0xc1, 0x6e, 0xd5, 0xf8, 0xc9, 0x74, 0x73	/* T__pfx_mark_tsc_async_resets */
	.byte 0x0f, 0x54, 0xdd, 0x72, 0xd8, 0x74, 0x73, 0xd5, 0x61, 0xc1, 0x6e, 0xd5, 0xf8, 0xc9, 0x74, 0x73	/* Tmark_tsc_async_resets */
	.byte 0x10, 0xbf, 0x74, 0x73, 0xd5, 0x76, 0xee, 0x69, 0x66, 0xc5, 0x74, 0x73, 0xd5, 0xc7, 0x6a, 0x75, 0xd6	/* T__pfx_tsc_verify_tsc_adjust */
	.byte 0x10, 0x54, 0x74, 0x73, 0xd5, 0x76, 0xee, 0x69, 0x66, 0xc5, 0x74, 0x73, 0xd5, 0xc7, 0x6a, 0x75, 0xd6	/* Ttsc_verify_tsc_adjust */
	.byte 0x0f, 0xc6, 0x74, 0x73, 0x63, 0x95, 0x6e, 0xd5, 0x7e, 0x63, 0xd8, 0xc2, 0x6d, 0xcf, 0x66, 0x6e	/* t__pfx_tsc_sync_check_timer_fn */
	.byte 0x0f, 0x74, 0x74, 0x73, 0x63, 0x95, 0x6e, 0xd5, 0x7e, 0x63, 0xd8, 0xc2, 0x6d, 0xcf, 0x66, 0x6e	/* ttsc_sync_check_timer_fn */
	.byte 0x13, 0xbf, 0x74, 0x73, 0x63, 0x2a, 0xce, 0xfa, 0xcc, 0xe5, 0x7e, 0x63, 0xd8, 0x74, 0x73, 0xd5, 0xc7, 0x6a, 0x75, 0xd6	/* T__pfx_tsc_store_and_check_tsc_adjust */
	.byte 0x13, 0x54, 0x74, 0x73, 0x63, 0x2a, 0xce, 0xfa, 0xcc, 0xe5, 0x7e, 0x63, 0xd8, 0x74, 0x73, 0xd5, 0xc7, 0x6a, 0x75, 0xd6	/* Ttsc_store_and_check_tsc_adjust */
	.byte 0x0e, 0xbf, 0x7e, 0x63, 0xd8, 0x74, 0x73, 0x63, 0x95, 0x6e, 0xd5, 0xdb, 0x72, 0xda, 0x74	/* T__pfx_check_tsc_sync_target */
	.byte 0x0e, 0x54, 0x7e, 0x63, 0xd8, 0x74, 0x73, 0x63, 0x95, 0x6e, 0xd5, 0xdb, 0x72, 0xda, 0x74	/* Tcheck_tsc_sync_target */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* t__pfx_paravirt_read_msr */
	.byte 0x0a, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* tparavirt_read_msr */
	.byte 0x0d, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x20, 0xcb, 0x20, 0xa6, 0xb2, 0xe6, 0xd6, 0x89	/* T__pfx_x86_msi_msg_get_destid */
	.byte 0x0d, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x20, 0xcb, 0x20, 0xa6, 0xb2, 0xe6, 0xd6, 0x89	/* Tx86_msi_msg_get_destid */
	.byte 0x05, 0xa8, 0x1f, 0x6d, 0x0b, 0xc2	/* t__pfx_set_multi */
	.byte 0x06, 0x74, 0xc9, 0xf9, 0x6d, 0x0b, 0xc2	/* tset_multi */
	.byte 0x09, 0xc6, 0x1b, 0x70, 0xa3, 0xba, 0x74, 0x3a, 0x3b, 0x72	/* t__pfx_lapic_setup_esr */
	.byte 0x09, 0x74, 0x1b, 0x70, 0xa3, 0xba, 0x74, 0x3a, 0x3b, 0x72	/* tlapic_setup_esr */
	.byte 0x0a, 0xc6, 0x1b, 0x70, 0x69, 0xd5, 0x6e, 0xd1, 0xf9, 0xbc, 0x1e	/* t__pfx_lapic_next_event */
	.byte 0x0a, 0x74, 0x1b, 0x70, 0x69, 0xd5, 0x6e, 0xd1, 0xf9, 0xbc, 0x1e	/* tlapic_next_event */
	.byte 0x0d, 0x29, 0xba, 0x74, 0x3a, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x4c, 0x56, 0x54, 0x54	/* t__pfx___setup_APIC_LVTT */
	.byte 0x0e, 0x74, 0xff, 0xc9, 0x74, 0x3a, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x4c, 0x56, 0x54, 0x54	/* t__setup_APIC_LVTT */
	.byte 0x0e, 0x3f, 0xba, 0x74, 0x3a, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x65, 0x69, 0x6c, 0x76, 0x74	/* T__pfx_setup_APIC_eilvt */
	.byte 0x0e, 0x54, 0xc9, 0x74, 0x3a, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x65, 0x69, 0x6c, 0x76, 0x74	/* Tsetup_APIC_eilvt */
	.byte 0x0e, 0x29, 0x5f, 0x1b, 0x70, 0x69, 0xd5, 0xb9, 0x64, 0xa1, 0x74, 0x73, 0xd5, 0x87, 0x71	/* t__pfx___lapic_update_tsc_freq */
	.byte 0x0e, 0x74, 0xff, 0x1b, 0x70, 0x69, 0xd5, 0xb9, 0x64, 0xa1, 0x74, 0x73, 0xd5, 0x87, 0x71	/* t__lapic_update_tsc_freq */
	.byte 0x0e, 0xc6, 0x1b, 0x70, 0x69, 0xd5, 0xc2, 0x6d, 0xcf, 0x62, 0xde, 0xc7, 0x63, 0x61, 0xd6	/* t__pfx_lapic_timer_broadcast */
	.byte 0x0e, 0x74, 0x1b, 0x70, 0x69, 0xd5, 0xc2, 0x6d, 0xcf, 0x62, 0xde, 0xc7, 0x63, 0x61, 0xd6	/* tlapic_timer_broadcast */
	.byte 0x0c, 0xa8, 0xba, 0x74, 0x3a, 0x41, 0x50, 0x49, 0x43, 0x5f, 0xc2, 0x6d, 0xee	/* t__pfx_setup_APIC_timer */
	.byte 0x0c, 0x74, 0xc9, 0x74, 0x3a, 0x41, 0x50, 0x49, 0x43, 0x5f, 0xc2, 0x6d, 0xee	/* tsetup_APIC_timer */
	.byte 0x0b, 0xa8, 0xba, 0x74, 0x3a, 0xc0, 0xe1, 0x5f, 0x41, 0x50, 0x49, 0x43	/* t__pfx_setup_local_APIC */
	.byte 0x0b, 0x74, 0xc9, 0x74, 0x3a, 0xc0, 0xe1, 0x5f, 0x41, 0x50, 0x49, 0x43	/* tsetup_local_APIC */
	.byte 0x11, 0xc6, 0x68, 0xcc, 0x64, 0xb3, 0x73, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx_handle_spurious_interrupt */
	.byte 0x10, 0x15, 0xcc, 0x64, 0xb3, 0x73, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* thandle_spurious_interrupt */
	.byte 0x16, 0x29, 0x95, 0x73, 0x76, 0x65, 0x63, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x61, 0x70, 0x69, 0xd5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx___sysvec_spurious_apic_interrupt */
	.byte 0x17, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0x63, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x61, 0x70, 0x69, 0xd5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__sysvec_spurious_apic_interrupt */
	.byte 0x0d, 0x29, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx___spurious_interrupt */
	.byte 0x0e, 0x74, 0xff, 0x73, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__spurious_interrupt */
	.byte 0x10, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xee, 0xde, 0x72, 0x5f, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx___sysvec_error_interrupt */
	.byte 0x11, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0xee, 0xde, 0x72, 0x5f, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__sysvec_error_interrupt */
	.byte 0x0e, 0xc6, 0x1b, 0x70, 0x69, 0xd5, 0xc2, 0x6d, 0xee, 0x1f, 0x6f, 0xb4, 0x73, 0xad, 0x74	/* t__pfx_lapic_timer_set_oneshot */
	.byte 0x0e, 0x74, 0x1b, 0x70, 0x69, 0xd5, 0xc2, 0x6d, 0xee, 0x1f, 0x6f, 0xb4, 0x73, 0xad, 0x74	/* tlapic_timer_set_oneshot */
	.byte 0x0e, 0xc6, 0x1b, 0x70, 0x69, 0xd5, 0xc2, 0x6d, 0xee, 0x1f, 0x70, 0xee, 0xd9, 0x64, 0xa3	/* t__pfx_lapic_timer_set_periodic */
	.byte 0x0e, 0x74, 0x1b, 0x70, 0x69, 0xd5, 0xc2, 0x6d, 0xee, 0x1f, 0x70, 0xee, 0xd9, 0x64, 0xa3	/* tlapic_timer_set_periodic */
	.byte 0x0c, 0xc6, 0x1b, 0x70, 0x69, 0xd5, 0x6e, 0xd1, 0xf9, 0xe6, 0xc7, 0x88, 0x65	/* t__pfx_lapic_next_deadline */
	.byte 0x0c, 0x74, 0x1b, 0x70, 0x69, 0xd5, 0x6e, 0xd1, 0xf9, 0xe6, 0xc7, 0x88, 0x65	/* tlapic_next_deadline */
	.byte 0x0b, 0x29, 0x5f, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0x80, 0xd3	/* t__pfx___x2apic_enable */
	.byte 0x0b, 0x74, 0xff, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0x80, 0xd3	/* t__x2apic_enable */
	.byte 0x0e, 0xc6, 0x1b, 0x70, 0x69, 0xd5, 0xc2, 0x6d, 0xee, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_lapic_timer_shutdown */
	.byte 0x0e, 0x74, 0x1b, 0x70, 0x69, 0xd5, 0xc2, 0x6d, 0xee, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* tlapic_timer_shutdown */
	.byte 0x13, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x61, 0x70, 0x69, 0xd5, 0xc2, 0x6d, 0xcf, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx___sysvec_apic_timer_interrupt */
	.byte 0x14, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0x61, 0x70, 0x69, 0xd5, 0xc2, 0x6d, 0xcf, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__sysvec_apic_timer_interrupt */
	.byte 0x0c, 0xc6, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x68, 0xaa, 0x3c, 0x65, 0x64	/* t__pfx_x2apic_hw_locked */
	.byte 0x0c, 0x74, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x68, 0xaa, 0x3c, 0x65, 0x64	/* tx2apic_hw_locked */
	.byte 0x0c, 0x29, 0x5f, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x64, 0xab, 0x80, 0xd3	/* t__pfx___x2apic_disable */
	.byte 0x0c, 0x74, 0xff, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x64, 0xab, 0x80, 0xd3	/* t__x2apic_disable */
	.byte 0x08, 0xc6, 0x1b, 0x70, 0x69, 0xd5, 0xf8, 0xb7, 0xbd	/* t__pfx_lapic_resume */
	.byte 0x08, 0x74, 0x1b, 0x70, 0x69, 0xd5, 0xf8, 0xb7, 0xbd	/* tlapic_resume */
	.byte 0x0e, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0x24, 0x65	/* T__pfx_native_apic_icr_write */
	.byte 0x0e, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0x24, 0x65	/* Tnative_apic_icr_write */
	.byte 0x0e, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0xf8, 0xc7	/* T__pfx_native_apic_icr_read */
	.byte 0x0e, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0xf8, 0xc7	/* Tnative_apic_icr_read */
	.byte 0x0b, 0xbf, 0x1b, 0x70, 0x69, 0xd5, 0xb2, 0xdd, 0x78, 0x6c, 0x76, 0x74	/* T__pfx_lapic_get_maxlvt */
	.byte 0x0b, 0x54, 0x1b, 0x70, 0x69, 0xd5, 0xb2, 0xdd, 0x78, 0x6c, 0x76, 0x74	/* Tlapic_get_maxlvt */
	.byte 0x0d, 0xbf, 0x1b, 0x70, 0x69, 0xd5, 0xb9, 0x64, 0xa1, 0x74, 0x73, 0xd5, 0x87, 0x71	/* T__pfx_lapic_update_tsc_freq */
	.byte 0x0d, 0x54, 0x1b, 0x70, 0x69, 0xd5, 0xb9, 0x64, 0xa1, 0x74, 0x73, 0xd5, 0x87, 0x71	/* Tlapic_update_tsc_freq */
	.byte 0x10, 0x3f, 0xba, 0x74, 0xb9, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x63, 0x3c	/* T__pfx_setup_secondary_APIC_clock */
	.byte 0x10, 0x54, 0xc9, 0x74, 0xb9, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x41, 0x50, 0x49, 0x43, 0x5f, 0x63, 0x3c	/* Tsetup_secondary_APIC_clock */
	.byte 0x15, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x61, 0x70, 0x69, 0xd5, 0xc2, 0x6d, 0xcf, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* T__pfx_fred_sysvec_apic_timer_interrupt */
	.byte 0x15, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x61, 0x70, 0x69, 0xd5, 0xc2, 0x6d, 0xcf, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* Tfred_sysvec_apic_timer_interrupt */
	.byte 0x0c, 0xbf, 0x63, 0xd3, 0xca, 0x5f, 0xc0, 0xe1, 0x5f, 0x41, 0x50, 0x49, 0x43	/* T__pfx_clear_local_APIC */
	.byte 0x0c, 0x54, 0x63, 0xd3, 0xca, 0x5f, 0xc0, 0xe1, 0x5f, 0x41, 0x50, 0x49, 0x43	/* Tclear_local_APIC */
	.byte 0x0c, 0xbf, 0x61, 0x70, 0xa3, 0xf6, 0x6f, 0x66, 0xf9, 0x64, 0xab, 0x80, 0xd3	/* T__pfx_apic_soft_disable */
	.byte 0x0c, 0x54, 0x61, 0x70, 0xa3, 0xf6, 0x6f, 0x66, 0xf9, 0x64, 0xab, 0x80, 0xd3	/* Tapic_soft_disable */
	.byte 0x0c, 0xbf, 0x64, 0xab, 0x80, 0xb3, 0xc0, 0xe1, 0x5f, 0x41, 0x50, 0x49, 0x43	/* T__pfx_disable_local_APIC */
	.byte 0x0c, 0x54, 0x64, 0xab, 0x80, 0xb3, 0xc0, 0xe1, 0x5f, 0x41, 0x50, 0x49, 0x43	/* Tdisable_local_APIC */
	.byte 0x09, 0xc6, 0x1b, 0x70, 0xa3, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* t__pfx_lapic_suspend */
	.byte 0x09, 0x74, 0x1b, 0x70, 0xa3, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* tlapic_suspend */
	.byte 0x0a, 0xbf, 0x1b, 0x70, 0xa3, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* T__pfx_lapic_shutdown */
	.byte 0x0a, 0x54, 0x1b, 0x70, 0xa3, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* Tlapic_shutdown */
	.byte 0x0a, 0xbf, 0x61, 0x70, 0x69, 0xd5, 0x61, 0x70, 0xba, 0x74, 0xb9	/* T__pfx_apic_ap_setup */
	.byte 0x0a, 0x54, 0x61, 0x70, 0x69, 0xd5, 0x61, 0x70, 0xba, 0x74, 0xb9	/* Tapic_ap_setup */
	.byte 0x09, 0xbf, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xba, 0x74, 0xb9	/* T__pfx_x2apic_setup */
	.byte 0x09, 0x54, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xba, 0x74, 0xb9	/* Tx2apic_setup */
	.byte 0x18, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0x63, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x61, 0x70, 0x69, 0xd5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* T__pfx_fred_sysvec_spurious_apic_interrupt */
	.byte 0x18, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0x63, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x61, 0x70, 0x69, 0xd5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* Tfred_sysvec_spurious_apic_interrupt */
	.byte 0x12, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xee, 0xde, 0x72, 0x5f, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* T__pfx_fred_sysvec_error_interrupt */
	.byte 0x12, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0xee, 0xde, 0x72, 0x5f, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* Tfred_sysvec_error_interrupt */
	.byte 0x0e, 0xbf, 0x64, 0xab, 0x98, 0xb4, 0x63, 0xf9, 0x62, 0x73, 0xe2, 0x41, 0x50, 0x49, 0x43	/* T__pfx_disconnect_bsp_APIC */
	.byte 0x0e, 0x54, 0x64, 0xab, 0x98, 0xb4, 0x63, 0xf9, 0x62, 0x73, 0xe2, 0x41, 0x50, 0x49, 0x43	/* Tdisconnect_bsp_APIC */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0xa7, 0x93, 0x20, 0xcb, 0x09, 0x6f, 0x73, 0xfa, 0x20, 0x67	/* T__pfx___irq_msi_compose_msg */
	.byte 0x0b, 0x2f, 0xa7, 0x93, 0x20, 0xcb, 0x09, 0x6f, 0x73, 0xfa, 0x20, 0x67	/* T__irq_msi_compose_msg */
	.byte 0x11, 0xbf, 0x61, 0x70, 0x69, 0xd5, 0x69, 0xe0, 0x63, 0x6c, 0x75, 0xd6, 0x65, 0xf8, 0xe5, 0x62, 0x6f, 0x78	/* T__pfx_apic_is_clustered_box */
	.byte 0x11, 0x54, 0x61, 0x70, 0x69, 0xd5, 0x69, 0xe0, 0x63, 0x6c, 0x75, 0xd6, 0x65, 0xf8, 0xe5, 0x62, 0x6f, 0x78	/* Tapic_is_clustered_box */
	.byte 0x10, 0xbf, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x92, 0xe7, 0x3d, 0xbb, 0xac, 0x5f, 0x61, 0x70, 0xa3, 0x89	/* T__pfx_default_cpu_present_to_apicid */
	.byte 0x10, 0x54, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x92, 0xe7, 0x3d, 0xbb, 0xac, 0x5f, 0x61, 0x70, 0xa3, 0x89	/* Tdefault_cpu_present_to_apicid */
	.byte 0x10, 0xbf, 0x61, 0x70, 0x69, 0xd5, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x28, 0xd5, 0x61, 0x70, 0xa3, 0x89	/* T__pfx_apic_default_calc_apicid */
	.byte 0x10, 0x54, 0x61, 0x70, 0x69, 0xd5, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x28, 0xd5, 0x61, 0x70, 0xa3, 0x89	/* Tapic_default_calc_apicid */
	.byte 0x0e, 0xbf, 0x61, 0x70, 0x69, 0xd5, 0x66, 0x1b, 0xf9, 0x28, 0xd5, 0x61, 0x70, 0xa3, 0x89	/* T__pfx_apic_flat_calc_apicid */
	.byte 0x0e, 0x54, 0x61, 0x70, 0x69, 0xd5, 0x66, 0x1b, 0xf9, 0x28, 0xd5, 0x61, 0x70, 0xa3, 0x89	/* Tapic_flat_calc_apicid */
	.byte 0x0e, 0xbf, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0xf0, 0x99, 0x61, 0x70, 0x69, 0xd5, 0x02, 0x72	/* T__pfx_default_init_apic_ldr */
	.byte 0x0e, 0x54, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0xf0, 0x99, 0x61, 0x70, 0x69, 0xd5, 0x02, 0x72	/* Tdefault_init_apic_ldr */
	.byte 0x09, 0xc6, 0xb6, 0x81, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49	/* t__pfx_noop_send_IPI */
	.byte 0x09, 0x74, 0xb6, 0x81, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49	/* tnoop_send_IPI */
	.byte 0x0c, 0xc6, 0xb6, 0x81, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* t__pfx_noop_send_IPI_mask */
	.byte 0x0c, 0x74, 0xb6, 0x81, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* tnoop_send_IPI_mask */
	.byte 0x14, 0xc6, 0xb6, 0x81, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* t__pfx_noop_send_IPI_mask_allbutself */
	.byte 0x14, 0x74, 0xb6, 0x81, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* tnoop_send_IPI_mask_allbutself */
	.byte 0x11, 0xc6, 0xb6, 0x81, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* t__pfx_noop_send_IPI_allbutself */
	.byte 0x11, 0x74, 0xb6, 0x81, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* tnoop_send_IPI_allbutself */
	.byte 0x0c, 0xc6, 0xb6, 0x81, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c	/* t__pfx_noop_send_IPI_all */
	.byte 0x0c, 0x74, 0xb6, 0x81, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c	/* tnoop_send_IPI_all */
	.byte 0x0c, 0xc6, 0xb6, 0x81, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xba, 0x6c, 0x66	/* t__pfx_noop_send_IPI_self */
	.byte 0x0c, 0x74, 0xb6, 0x81, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xba, 0x6c, 0x66	/* tnoop_send_IPI_self */
	.byte 0x0d, 0xc6, 0xb6, 0x6f, 0xe2, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0x24, 0x65	/* t__pfx_noop_apic_icr_write */
	.byte 0x0d, 0x74, 0xb6, 0x6f, 0xe2, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0x24, 0x65	/* tnoop_apic_icr_write */
	.byte 0x0d, 0xc6, 0xb6, 0x6f, 0xe2, 0x13, 0x0e, 0xb9, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x92	/* t__pfx_noop_wakeup_secondary_cpu */
	.byte 0x0d, 0x74, 0xb6, 0x6f, 0xe2, 0x13, 0x0e, 0xb9, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x92	/* tnoop_wakeup_secondary_cpu */
	.byte 0x0d, 0xc6, 0xb6, 0x6f, 0xe2, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0xf8, 0xc7	/* t__pfx_noop_apic_icr_read */
	.byte 0x0d, 0x74, 0xb6, 0x6f, 0xe2, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0xf8, 0xc7	/* tnoop_apic_icr_read */
	.byte 0x0a, 0xc6, 0xb6, 0x6f, 0xe2, 0xb2, 0x61, 0x70, 0x69, 0xd5, 0x89	/* t__pfx_noop_get_apic_id */
	.byte 0x0a, 0x74, 0xb6, 0x6f, 0xe2, 0xb2, 0x61, 0x70, 0x69, 0xd5, 0x89	/* tnoop_get_apic_id */
	.byte 0x0b, 0xc6, 0xb6, 0x6f, 0xe2, 0x61, 0x70, 0x69, 0xd5, 0x65, 0x6f, 0x69	/* t__pfx_noop_apic_eoi */
	.byte 0x0b, 0x74, 0xb6, 0x6f, 0xe2, 0x61, 0x70, 0x69, 0xd5, 0x65, 0x6f, 0x69	/* tnoop_apic_eoi */
	.byte 0x0a, 0xc6, 0xb6, 0x6f, 0xe2, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0xc7	/* t__pfx_noop_apic_read */
	.byte 0x0a, 0x74, 0xb6, 0x6f, 0xe2, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0xc7	/* tnoop_apic_read */
	.byte 0x0a, 0xc6, 0xb6, 0x6f, 0xe2, 0x61, 0x70, 0x69, 0xd5, 0x24, 0x65	/* t__pfx_noop_apic_write */
	.byte 0x0a, 0x74, 0xb6, 0x6f, 0xe2, 0x61, 0x70, 0x69, 0xd5, 0x24, 0x65	/* tnoop_apic_write */
	.byte 0x0a, 0xbf, 0x61, 0x70, 0xa3, 0xf6, 0x6d, 0xf9, 0xb9, 0x64, 0x86	/* T__pfx_apic_smt_update */
	.byte 0x0a, 0x54, 0x61, 0x70, 0xa3, 0xf6, 0x6d, 0xf9, 0xb9, 0x64, 0x86	/* Tapic_smt_update */
	.byte 0x12, 0xbf, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* T__pfx_apic_send_IPI_allbutself */
	.byte 0x12, 0x54, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* Tapic_send_IPI_allbutself */
	.byte 0x0f, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x73, 0xb0, 0xf6, 0xe8, 0xe5, 0x3d, 0x7e, 0x64, 0x75, 0xd3	/* T__pfx_native_smp_send_reschedule */
	.byte 0x0f, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x73, 0xb0, 0xf6, 0xe8, 0xe5, 0x3d, 0x7e, 0x64, 0x75, 0xd3	/* Tnative_smp_send_reschedule */
	.byte 0x12, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x73, 0xe8, 0xe5, 0x28, 0xc3, 0x2b, 0x63, 0xf6, 0xf0, 0x67, 0xb3, 0x0c, 0x69	/* T__pfx_native_send_call_func_single_ipi */
	.byte 0x12, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x73, 0xe8, 0xe5, 0x28, 0xc3, 0x2b, 0x63, 0xf6, 0xf0, 0x67, 0xb3, 0x0c, 0x69	/* Tnative_send_call_func_single_ipi */
	.byte 0x0e, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x73, 0xe8, 0xe5, 0x28, 0xc3, 0x2b, 0xd5, 0x0c, 0x69	/* T__pfx_native_send_call_func_ipi */
	.byte 0x0e, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x73, 0xe8, 0xe5, 0x28, 0xc3, 0x2b, 0xd5, 0x0c, 0x69	/* Tnative_send_call_func_ipi */
	.byte 0x12, 0xbf, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x6e, 0x6d, 0xcb, 0xac, 0x5f, 0x6f, 0x66, 0x66, 0x88, 0xfa, 0x92	/* T__pfx_apic_send_nmi_to_offline_cpu */
	.byte 0x12, 0x54, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x6e, 0x6d, 0xcb, 0xac, 0x5f, 0x6f, 0x66, 0x66, 0x88, 0xfa, 0x92	/* Tapic_send_nmi_to_offline_cpu */
	.byte 0x12, 0xbf, 0x61, 0x70, 0x69, 0xd5, 0xbd, 0xcd, 0x13, 0x99, 0xa3, 0x72, 0x5f, 0x89, 0xb3, 0xc2, 0xbd, 0x6f, 0x5e	/* T__pfx_apic_mem_wait_icr_idle_timeout */
	.byte 0x12, 0x54, 0x61, 0x70, 0x69, 0xd5, 0xbd, 0xcd, 0x13, 0x99, 0xa3, 0x72, 0x5f, 0x89, 0xb3, 0xc2, 0xbd, 0x6f, 0x5e	/* Tapic_mem_wait_icr_idle_timeout */
	.byte 0x12, 0x29, 0x5f, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xf6, 0x68, 0xce, 0x2d, 0x5e	/* t__pfx___default_send_IPI_shortcut */
	.byte 0x12, 0x74, 0xff, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xf6, 0x68, 0xce, 0x2d, 0x5e	/* t__default_send_IPI_shortcut */
	.byte 0x0e, 0xbf, 0x61, 0x70, 0x69, 0xd5, 0xbd, 0xcd, 0x13, 0x99, 0xa3, 0x72, 0x5f, 0x89, 0xd3	/* T__pfx_apic_mem_wait_icr_idle */
	.byte 0x0e, 0x54, 0x61, 0x70, 0x69, 0xd5, 0xbd, 0xcd, 0x13, 0x99, 0xa3, 0x72, 0x5f, 0x89, 0xd3	/* Tapic_mem_wait_icr_idle */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe6, 0x73, 0xf9, 0xb8, 0x65, 0x02	/* T__pfx___default_send_IPI_dest_field */
	.byte 0x13, 0x2f, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe6, 0x73, 0xf9, 0xb8, 0x65, 0x02	/* T__default_send_IPI_dest_field */
	.byte 0x14, 0xbf, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xf6, 0xf0, 0x67, 0xb3, 0x70, 0x68, 0x79, 0x73	/* T__pfx_default_send_IPI_single_phys */
	.byte 0x14, 0x54, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xf6, 0xf0, 0x67, 0xb3, 0x70, 0x68, 0x79, 0x73	/* Tdefault_send_IPI_single_phys */
	.byte 0x18, 0xbf, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16, 0xba, 0x8e, 0xe8, 0x63, 0xfa, 0x70, 0x68, 0x79, 0x73	/* T__pfx_default_send_IPI_mask_sequence_phys */
	.byte 0x18, 0x54, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16, 0xba, 0x8e, 0xe8, 0x63, 0xfa, 0x70, 0x68, 0x79, 0x73	/* Tdefault_send_IPI_mask_sequence_phys */
	.byte 0x1b, 0xbf, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66, 0xe7, 0x68, 0x79, 0x73	/* T__pfx_default_send_IPI_mask_allbutself_phys */
	.byte 0x1b, 0x54, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66, 0xe7, 0x68, 0x79, 0x73	/* Tdefault_send_IPI_mask_allbutself_phys */
	.byte 0x10, 0xbf, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xf6, 0xf0, 0x67, 0xd3	/* T__pfx_default_send_IPI_single */
	.byte 0x10, 0x54, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xf6, 0xf0, 0x67, 0xd3	/* Tdefault_send_IPI_single */
	.byte 0x14, 0xbf, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* T__pfx_default_send_IPI_allbutself */
	.byte 0x14, 0x54, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* Tdefault_send_IPI_allbutself */
	.byte 0x0f, 0xbf, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c	/* T__pfx_default_send_IPI_all */
	.byte 0x0f, 0x54, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c	/* Tdefault_send_IPI_all */
	.byte 0x0f, 0xbf, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xba, 0x6c, 0x66	/* T__pfx_default_send_IPI_self */
	.byte 0x0f, 0x54, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xba, 0x6c, 0x66	/* Tdefault_send_IPI_self */
	.byte 0x07, 0xbf, 0xa7, 0x71, 0xe5, 0x63, 0x66, 0x67	/* T__pfx_irqd_cfg */
	.byte 0x07, 0x54, 0xa7, 0x71, 0xe5, 0x63, 0x66, 0x67	/* Tirqd_cfg */
	.byte 0x0b, 0xc6, 0x63, 0xd3, 0xca, 0x5f, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce	/* t__pfx_clear_irq_vector */
	.byte 0x0a, 0x2d, 0xd3, 0xca, 0x5f, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce	/* tclear_irq_vector */
	.byte 0x0c, 0xc6, 0x61, 0x70, 0x69, 0xd5, 0xb9, 0x64, 0xa1, 0x76, 0x65, 0x7b, 0xce	/* t__pfx_apic_update_vector */
	.byte 0x0b, 0xdb, 0x70, 0x69, 0xd5, 0xb9, 0x64, 0xa1, 0x76, 0x65, 0x7b, 0xce	/* tapic_update_vector */
	.byte 0x0f, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa7, 0x71, 0x73	/* t__pfx_x86_vector_free_irqs */
	.byte 0x0f, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x87, 0xfa, 0xa7, 0x71, 0x73	/* tx86_vector_free_irqs */
	.byte 0x12, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x20, 0xcb, 0x09, 0x6f, 0x73, 0xfa, 0x20, 0x67	/* t__pfx_x86_vector_msi_compose_msg */
	.byte 0x12, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x20, 0xcb, 0x09, 0x6f, 0x73, 0xfa, 0x20, 0x67	/* tx86_vector_msi_compose_msg */
	.byte 0x0c, 0xc6, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0xea, 0x2c, 0x67, 0xcf, 0xa7, 0x71	/* t__pfx_apic_retrigger_irq */
	.byte 0x0b, 0xdb, 0x70, 0x69, 0xd5, 0xf8, 0xea, 0x2c, 0x67, 0xcf, 0xa7, 0x71	/* tapic_retrigger_irq */
	.byte 0x09, 0xc6, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* t__pfx_trace_vector_setup */
	.byte 0x09, 0x74, 0xc8, 0x76, 0x65, 0x7b, 0xce, 0xba, 0x74, 0xb9	/* ttrace_vector_setup */
	.byte 0x0b, 0xc6, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0xe5, 0x76, 0x65, 0x7b, 0xce	/* t__pfx_free_moved_vector */
	.byte 0x0b, 0x74, 0x87, 0xfa, 0xa5, 0x76, 0x65, 0xe5, 0x76, 0x65, 0x7b, 0xce	/* tfree_moved_vector */
	.byte 0x0b, 0x29, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x63, 0xd3, 0xcc, 0xb9	/* t__pfx___vector_cleanup */
	.byte 0x0b, 0x74, 0xff, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x63, 0xd3, 0xcc, 0xb9	/* t__vector_cleanup */
	.byte 0x0f, 0xc6, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x63, 0xd3, 0xcc, 0x3a, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_vector_cleanup_callback */
	.byte 0x0f, 0x74, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x63, 0xd3, 0xcc, 0x3a, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tvector_cleanup_callback */
	.byte 0x0f, 0x29, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0xf6, 0x7e, 0x64, 0x75, 0xb3, 0x63, 0xd3, 0xcc, 0xb9	/* t__pfx___vector_schedule_cleanup */
	.byte 0x0f, 0x74, 0xff, 0x76, 0x65, 0x7b, 0xce, 0xf6, 0x7e, 0x64, 0x75, 0xb3, 0x63, 0xd3, 0xcc, 0xb9	/* t__vector_schedule_cleanup */
	.byte 0x0d, 0xc6, 0x61, 0x70, 0x69, 0xd5, 0xb9, 0x64, 0xa1, 0xa7, 0x93, 0x63, 0x66, 0x67	/* t__pfx_apic_update_irq_cfg */
	.byte 0x0c, 0xdb, 0x70, 0x69, 0xd5, 0xb9, 0x64, 0xa1, 0xa7, 0x93, 0x63, 0x66, 0x67	/* tapic_update_irq_cfg */
	.byte 0x0d, 0xc6, 0x96, 0x73, 0x2c, 0x7c, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3c, 0x65, 0x64	/* t__pfx_assign_vector_locked */
	.byte 0x0d, 0xdb, 0x73, 0x73, 0x2c, 0x7c, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3c, 0x65, 0x64	/* tassign_vector_locked */
	.byte 0x11, 0xc6, 0x96, 0x73, 0x2c, 0x7c, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xcc, 0xc5, 0x3c, 0x65, 0x64	/* t__pfx_assign_irq_vector_any_locked */
	.byte 0x11, 0xdb, 0x73, 0x73, 0x2c, 0x7c, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xcc, 0xc5, 0x3c, 0x65, 0x64	/* tassign_irq_vector_any_locked */
	.byte 0x14, 0xc6, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x96, 0x73, 0x2c, 0x7c, 0xdd, 0x6e, 0x03, 0x64, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_vector_assign_managed_shutdown */
	.byte 0x14, 0x74, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x96, 0x73, 0x2c, 0x7c, 0xdd, 0x6e, 0x03, 0x64, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* tvector_assign_managed_shutdown */
	.byte 0x0e, 0xc6, 0x3d, 0xee, 0x22, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3c, 0x65, 0x64	/* t__pfx_reserve_irq_vector_locked */
	.byte 0x0e, 0x74, 0x3d, 0xee, 0x22, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3c, 0x65, 0x64	/* treserve_irq_vector_locked */
	.byte 0x0f, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe6, 0xeb, 0xc2, 0x76, 0x86	/* t__pfx_x86_vector_deactivate */
	.byte 0x0f, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xe6, 0xeb, 0xc2, 0x76, 0x86	/* tx86_vector_deactivate */
	.byte 0x0f, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xa7, 0x71, 0x73	/* t__pfx_x86_vector_alloc_irqs */
	.byte 0x0f, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x08, 0xd5, 0xa7, 0x71, 0x73	/* tx86_vector_alloc_irqs */
	.byte 0x14, 0xc6, 0x96, 0x73, 0x2c, 0x7c, 0xdd, 0x6e, 0x03, 0xe5, 0x76, 0x65, 0x7b, 0xce, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_assign_managed_vector.constprop.0 */
	.byte 0x14, 0xdb, 0x73, 0x73, 0x2c, 0x7c, 0xdd, 0x6e, 0x03, 0xe5, 0x76, 0x65, 0x7b, 0xce, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tassign_managed_vector.constprop.0 */
	.byte 0x0e, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* t__pfx_x86_vector_activate */
	.byte 0x0e, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* tx86_vector_activate */
	.byte 0x0a, 0xc6, 0x61, 0x70, 0xa3, 0x1f, 0x61, 0x66, 0x66, 0x8d, 0x79	/* t__pfx_apic_set_affinity */
	.byte 0x09, 0xdb, 0x70, 0xa3, 0x1f, 0x61, 0x66, 0x66, 0x8d, 0x79	/* tapic_set_affinity */
	.byte 0x09, 0xbf, 0xc0, 0xd8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3c	/* T__pfx_lock_vector_lock */
	.byte 0x09, 0x54, 0xc0, 0xd8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3c	/* Tlock_vector_lock */
	.byte 0x0a, 0xbf, 0xd4, 0xc0, 0xd8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3c	/* T__pfx_unlock_vector_lock */
	.byte 0x0a, 0x54, 0xd4, 0xc0, 0xd8, 0x76, 0x65, 0x7b, 0xce, 0x5f, 0x3c	/* Tunlock_vector_lock */
	.byte 0x0a, 0xbf, 0xf0, 0x99, 0xa7, 0x93, 0x08, 0xd5, 0xf0, 0x66, 0x6f	/* T__pfx_init_irq_alloc_info */
	.byte 0x0a, 0x54, 0xf0, 0x99, 0xa7, 0x93, 0x08, 0xd5, 0xf0, 0x66, 0x6f	/* Tinit_irq_alloc_info */
	.byte 0x0b, 0xbf, 0xfe, 0x70, 0xc5, 0xa7, 0x93, 0x08, 0xd5, 0xf0, 0x66, 0x6f	/* T__pfx_copy_irq_alloc_info */
	.byte 0x0b, 0x54, 0xfe, 0x70, 0xc5, 0xa7, 0x93, 0x08, 0xd5, 0xf0, 0x66, 0x6f	/* Tcopy_irq_alloc_info */
	.byte 0x06, 0xbf, 0xa7, 0x93, 0x63, 0x66, 0x67	/* T__pfx_irq_cfg */
	.byte 0x06, 0x54, 0xa7, 0x93, 0x63, 0x66, 0x67	/* Tirq_cfg */
	.byte 0x11, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0x77, 0x73, 0x70, 0x65, 0xd5, 0x69, 0xe0, 0xd9, 0x61, 0x70, 0xa3	/* T__pfx_x86_fwspec_is_ioapic */
	.byte 0x11, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x66, 0x77, 0x73, 0x70, 0x65, 0xd5, 0x69, 0xe0, 0xd9, 0x61, 0x70, 0xa3	/* Tx86_fwspec_is_ioapic */
	.byte 0x11, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x66, 0x77, 0x73, 0x70, 0x65, 0xd5, 0x69, 0xe0, 0x68, 0x70, 0x65, 0x74	/* T__pfx_x86_fwspec_is_hpet */
	.byte 0x11, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x66, 0x77, 0x73, 0x70, 0x65, 0xd5, 0x69, 0xe0, 0x68, 0x70, 0x65, 0x74	/* Tx86_fwspec_is_hpet */
	.byte 0x0c, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0xba, 0xd3, 0x7b	/* t__pfx_x86_vector_select */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x76, 0x65, 0x7b, 0xce, 0xba, 0xd3, 0x7b	/* tx86_vector_select */
	.byte 0x11, 0xbf, 0x1b, 0x70, 0x69, 0xd5, 0x96, 0x73, 0x2c, 0x7c, 0xd3, 0x67, 0xeb, 0xc5, 0x76, 0x65, 0x7b, 0xce	/* T__pfx_lapic_assign_legacy_vector */
	.byte 0x11, 0x54, 0x1b, 0x70, 0x69, 0xd5, 0x96, 0x73, 0x2c, 0x7c, 0xd3, 0x67, 0xeb, 0xc5, 0x76, 0x65, 0x7b, 0xce	/* Tlapic_assign_legacy_vector */
	.byte 0x09, 0xbf, 0x1b, 0x70, 0x69, 0xd5, 0x6f, 0x6e, 0x88, 0x65	/* T__pfx_lapic_online */
	.byte 0x09, 0x54, 0x1b, 0x70, 0x69, 0xd5, 0x6f, 0x6e, 0x88, 0x65	/* Tlapic_online */
	.byte 0x0a, 0xbf, 0x1b, 0x70, 0x69, 0xd5, 0x6f, 0x66, 0x66, 0x88, 0x65	/* T__pfx_lapic_offline */
	.byte 0x0a, 0x54, 0x1b, 0x70, 0x69, 0xd5, 0x6f, 0x66, 0x66, 0x88, 0x65	/* Tlapic_offline */
	.byte 0x09, 0xbf, 0x61, 0x70, 0x69, 0xd5, 0xeb, 0xd8, 0xa7, 0x71	/* T__pfx_apic_ack_irq */
	.byte 0x09, 0x54, 0x61, 0x70, 0x69, 0xd5, 0xeb, 0xd8, 0xa7, 0x71	/* Tapic_ack_irq */
	.byte 0x0e, 0xbf, 0x76, 0x65, 0x7b, 0xce, 0xf6, 0x7e, 0x64, 0x75, 0xb3, 0x63, 0xd3, 0xcc, 0xb9	/* T__pfx_vector_schedule_cleanup */
	.byte 0x0e, 0x54, 0x76, 0x65, 0x7b, 0xce, 0xf6, 0x7e, 0x64, 0x75, 0xb3, 0x63, 0xd3, 0xcc, 0xb9	/* Tvector_schedule_cleanup */
	.byte 0x0a, 0xbf, 0xa7, 0x93, 0x09, 0xd3, 0x74, 0xfa, 0xa5, 0x76, 0x65	/* T__pfx_irq_complete_move */
	.byte 0x0a, 0x54, 0xa7, 0x93, 0x09, 0xd3, 0x74, 0xfa, 0xa5, 0x76, 0x65	/* Tirq_complete_move */
	.byte 0x0a, 0xbf, 0x61, 0x70, 0x69, 0xd5, 0xeb, 0xd8, 0x65, 0x64, 0xda	/* T__pfx_apic_ack_edge */
	.byte 0x0a, 0x54, 0x61, 0x70, 0x69, 0xd5, 0xeb, 0xd8, 0x65, 0x64, 0xda	/* Tapic_ack_edge */
	.byte 0x0e, 0xbf, 0xa7, 0x93, 0x66, 0xce, 0x63, 0xfa, 0x09, 0xd3, 0x74, 0xfa, 0xa5, 0x76, 0x65	/* T__pfx_irq_force_complete_move */
	.byte 0x0e, 0x54, 0xa7, 0x93, 0x66, 0xce, 0x63, 0xfa, 0x09, 0xd3, 0x74, 0xfa, 0xa5, 0x76, 0x65	/* Tirq_force_complete_move */
	.byte 0x0e, 0xbf, 0x1b, 0x70, 0x69, 0xd5, 0x63, 0xcc, 0x5f, 0xd4, 0x70, 0x6c, 0x75, 0xa6, 0x92	/* T__pfx_lapic_can_unplug_cpu */
	.byte 0x0e, 0x54, 0x1b, 0x70, 0x69, 0xd5, 0x63, 0xcc, 0x5f, 0xd4, 0x70, 0x6c, 0x75, 0xa6, 0x92	/* Tlapic_can_unplug_cpu */
	.byte 0x0d, 0xc6, 0x6e, 0x6d, 0xcb, 0xb5, 0xab, 0xfa, 0x92, 0x5f, 0x62, 0xeb, 0x6b, 0x01	/* t__pfx_nmi_raise_cpu_backtrace */
	.byte 0x0d, 0x74, 0x6e, 0x6d, 0xcb, 0xb5, 0xab, 0xfa, 0x92, 0x5f, 0x62, 0xeb, 0x6b, 0x01	/* tnmi_raise_cpu_backtrace */
	.byte 0x0f, 0xc6, 0x6e, 0x6d, 0xcb, 0x92, 0x5f, 0x62, 0xeb, 0x6b, 0xc8, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_nmi_cpu_backtrace_handler */
	.byte 0x0f, 0x74, 0x6e, 0x6d, 0xcb, 0x92, 0x5f, 0x62, 0xeb, 0x6b, 0xc8, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* tnmi_cpu_backtrace_handler */
	.byte 0x0f, 0xbf, 0x68, 0xaa, 0x6e, 0x6d, 0xcb, 0xb2, 0x73, 0x61, 0xb0, 0xb3, 0x70, 0xee, 0xd9, 0x64	/* T__pfx_hw_nmi_get_sample_period */
	.byte 0x0f, 0x54, 0x68, 0xaa, 0x6e, 0x6d, 0xcb, 0xb2, 0x73, 0x61, 0xb0, 0xb3, 0x70, 0xee, 0xd9, 0x64	/* Thw_nmi_get_sample_period */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0x5f, 0xea, 0x2c, 0x67, 0xcf, 0x92, 0xdd, 0x73, 0xd8, 0x62, 0xeb, 0x6b, 0x01	/* T__pfx_arch_trigger_cpumask_backtrace */
	.byte 0x10, 0x54, 0xca, 0xd0, 0x5f, 0xea, 0x2c, 0x67, 0xcf, 0x92, 0xdd, 0x73, 0xd8, 0x62, 0xeb, 0x6b, 0x01	/* Tarch_trigger_cpumask_backtrace */
	.byte 0x0c, 0x29, 0x5f, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0x05, 0xe8, 0xea, 0x79	/* t__pfx___ioapic_read_entry */
	.byte 0x0c, 0x74, 0xff, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0x05, 0xe8, 0xea, 0x79	/* t__ioapic_read_entry */
	.byte 0x0c, 0x29, 0x5f, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x24, 0xfa, 0xe8, 0xea, 0x79	/* t__pfx___ioapic_write_entry */
	.byte 0x0c, 0x74, 0xff, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x24, 0xfa, 0xe8, 0xea, 0x79	/* t__ioapic_write_entry */
	.byte 0x0d, 0xc6, 0x3e, 0x61, 0x70, 0x69, 0xd5, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0xa7, 0x71	/* t__pfx_io_apic_modify_irq */
	.byte 0x0d, 0x74, 0x3e, 0x61, 0x70, 0x69, 0xd5, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0xa7, 0x71	/* tio_apic_modify_irq */
	.byte 0x08, 0xc6, 0x3e, 0x61, 0x70, 0xa3, 0x95, 0x6e, 0x63	/* t__pfx_io_apic_sync */
	.byte 0x08, 0x74, 0x3e, 0x61, 0x70, 0xa3, 0x95, 0x6e, 0x63	/* tio_apic_sync */
	.byte 0x0b, 0x29, 0x5f, 0x65, 0x6f, 0xcb, 0xd9, 0x61, 0x70, 0xa3, 0xe7, 0xf0	/* t__pfx___eoi_ioapic_pin */
	.byte 0x0b, 0x74, 0xff, 0x65, 0x6f, 0xcb, 0xd9, 0x61, 0x70, 0xa3, 0xe7, 0xf0	/* t__eoi_ioapic_pin */
	.byte 0x0d, 0xc6, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xa7, 0x93, 0xb2, 0xd0, 0x0c, 0x2a, 0x86	/* t__pfx_ioapic_irq_get_chip_state */
	.byte 0x0d, 0x74, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xa7, 0x93, 0xb2, 0xd0, 0x0c, 0x2a, 0x86	/* tioapic_irq_get_chip_state */
	.byte 0x09, 0xc6, 0x3e, 0x61, 0x70, 0xa3, 0x1f, 0xb8, 0x78, 0x0a	/* t__pfx_io_apic_set_fixmap */
	.byte 0x09, 0x74, 0x3e, 0x61, 0x70, 0xa3, 0x1f, 0xb8, 0x78, 0x0a	/* tio_apic_set_fixmap */
	.byte 0x09, 0xc6, 0xa7, 0x93, 0x69, 0xe0, 0xd3, 0x76, 0x65, 0x6c	/* t__pfx_irq_is_level */
	.byte 0x09, 0xc2, 0x72, 0x93, 0x69, 0xe0, 0xd3, 0x76, 0x65, 0x6c	/* tirq_is_level */
	.byte 0x0b, 0xc6, 0x10, 0xe7, 0xf0, 0x5f, 0xac, 0x5f, 0xa7, 0x93, 0xb6, 0xe6	/* t__pfx_add_pin_to_irq_node */
	.byte 0x0c, 0xdb, 0x64, 0x64, 0xe7, 0xf0, 0x5f, 0xac, 0x5f, 0xa7, 0x93, 0xb6, 0xe6	/* tadd_pin_to_irq_node */
	.byte 0x0a, 0xc6, 0x6d, 0xe2, 0x18, 0xcf, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_mp_register_handler */
	.byte 0x0a, 0x74, 0x6d, 0xe2, 0x18, 0xcf, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* tmp_register_handler */
	.byte 0x0b, 0xc6, 0x6d, 0xe2, 0x7e, 0x63, 0x6b, 0xe7, 0xf0, 0x5f, 0xe9, 0xea	/* t__pfx_mp_check_pin_attr */
	.byte 0x0b, 0x74, 0x6d, 0xe2, 0x7e, 0x63, 0x6b, 0xe7, 0xf0, 0x5f, 0xe9, 0xea	/* tmp_check_pin_attr */
	.byte 0x0e, 0xc6, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x98, 0xb8, 0x67, 0x1d, 0xfa, 0xe8, 0xea, 0x79	/* t__pfx_ioapic_configure_entry */
	.byte 0x0e, 0x74, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x98, 0xb8, 0x67, 0x1d, 0xfa, 0xe8, 0xea, 0x79	/* tioapic_configure_entry */
	.byte 0x09, 0xc6, 0xeb, 0xd8, 0x1b, 0x70, 0x69, 0xd5, 0xa7, 0x71	/* t__pfx_ack_lapic_irq */
	.byte 0x09, 0x74, 0xeb, 0xd8, 0x1b, 0x70, 0x69, 0xd5, 0xa7, 0x71	/* tack_lapic_irq */
	.byte 0x0c, 0xc6, 0x6d, 0xe2, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0x63, 0xf8, 0x86	/* t__pfx_mp_irqdomain_create */
	.byte 0x0c, 0x74, 0x6d, 0xe2, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0x63, 0xf8, 0x86	/* tmp_irqdomain_create */
	.byte 0x0b, 0xc6, 0xd4, 0xdd, 0x73, 0xd8, 0x1b, 0x70, 0x69, 0xd5, 0xa7, 0x71	/* t__pfx_unmask_lapic_irq */
	.byte 0x0b, 0x74, 0xd4, 0xdd, 0x73, 0xd8, 0x1b, 0x70, 0x69, 0xd5, 0xa7, 0x71	/* tunmask_lapic_irq */
	.byte 0x0a, 0xc6, 0xdd, 0x73, 0xd8, 0x1b, 0x70, 0x69, 0xd5, 0xa7, 0x71	/* t__pfx_mask_lapic_irq */
	.byte 0x0a, 0x74, 0xdd, 0x73, 0xd8, 0x1b, 0x70, 0x69, 0xd5, 0xa7, 0x71	/* tmask_lapic_irq */
	.byte 0x0b, 0xbf, 0x6d, 0xe2, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0x87, 0x65	/* T__pfx_mp_irqdomain_free */
	.byte 0x0b, 0x54, 0x6d, 0xe2, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0x87, 0x65	/* Tmp_irqdomain_free */
	.byte 0x10, 0xc6, 0x66, 0xf0, 0xe5, 0xa7, 0x93, 0xe8, 0xea, 0x79, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_find_irq_entry.constprop.0 */
	.byte 0x10, 0x74, 0x66, 0xf0, 0xe5, 0xa7, 0x93, 0xe8, 0xea, 0x79, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tfind_irq_entry.constprop.0 */
	.byte 0x0f, 0xc6, 0x08, 0xd5, 0xd9, 0x61, 0x70, 0xa3, 0xf6, 0x61, 0x76, 0x65, 0xe5, 0x18, 0xee, 0x73	/* t__pfx_alloc_ioapic_saved_registers */
	.byte 0x0f, 0x74, 0x08, 0xd5, 0xd9, 0x61, 0x70, 0xa3, 0xf6, 0x61, 0x76, 0x65, 0xe5, 0x18, 0xee, 0x73	/* talloc_ioapic_saved_registers */
	.byte 0x13, 0xc6, 0x08, 0xd5, 0xab, 0x61, 0x5f, 0xa7, 0x93, 0x66, 0xde, 0xcd, 0xa9, 0xdd, 0xf0, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_alloc_isa_irq_from_domain.isra.0 */
	.byte 0x13, 0x74, 0x08, 0xd5, 0xab, 0x61, 0x5f, 0xa7, 0x93, 0x66, 0xde, 0xcd, 0xa9, 0xdd, 0xf0, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* talloc_isa_irq_from_domain.isra.0 */
	.byte 0x0d, 0xbf, 0x6d, 0xe2, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* T__pfx_mp_irqdomain_activate */
	.byte 0x0d, 0x54, 0x6d, 0xe2, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0xeb, 0xc2, 0x76, 0x86	/* Tmp_irqdomain_activate */
	.byte 0x0b, 0xc6, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x24, 0xfa, 0xe8, 0xea, 0x79	/* t__pfx_ioapic_write_entry */
	.byte 0x0b, 0x74, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x24, 0xfa, 0xe8, 0xea, 0x79	/* tioapic_write_entry */
	.byte 0x0b, 0xc6, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0x05, 0xe8, 0xea, 0x79	/* t__pfx_ioapic_read_entry */
	.byte 0x0b, 0x74, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0x05, 0xe8, 0xea, 0x79	/* tioapic_read_entry */
	.byte 0x0d, 0x3f, 0xf6, 0x61, 0x22, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x69, 0x3b	/* T__pfx_save_ioapic_entries */
	.byte 0x0d, 0x54, 0x73, 0x61, 0x22, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x69, 0x3b	/* Tsave_ioapic_entries */
	.byte 0x0c, 0xc6, 0xd4, 0xdd, 0x73, 0xd8, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xa7, 0x71	/* t__pfx_unmask_ioapic_irq */
	.byte 0x0c, 0x74, 0xd4, 0xdd, 0x73, 0xd8, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xa7, 0x71	/* tunmask_ioapic_irq */
	.byte 0x0b, 0xc6, 0xdd, 0x73, 0xd8, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xa7, 0x71	/* t__pfx_mask_ioapic_irq */
	.byte 0x0b, 0x74, 0xdd, 0x73, 0xd8, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xa7, 0x71	/* tmask_ioapic_irq */
	.byte 0x0a, 0xc6, 0x65, 0x6f, 0xcb, 0xd9, 0x61, 0x70, 0xa3, 0xe7, 0xf0	/* t__pfx_eoi_ioapic_pin */
	.byte 0x09, 0x9a, 0x6f, 0xcb, 0xd9, 0x61, 0x70, 0xa3, 0xe7, 0xf0	/* teoi_ioapic_pin */
	.byte 0x0e, 0xc6, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xa7, 0x5f, 0xeb, 0xd8, 0xd3, 0x76, 0x65, 0x6c	/* t__pfx_ioapic_ir_ack_level */
	.byte 0x0e, 0x74, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xa7, 0x5f, 0xeb, 0xd8, 0xd3, 0x76, 0x65, 0x6c	/* tioapic_ir_ack_level */
	.byte 0x0b, 0xc6, 0xd9, 0x61, 0x70, 0xa3, 0x1f, 0x61, 0x66, 0x66, 0x8d, 0x79	/* t__pfx_ioapic_set_affinity */
	.byte 0x0b, 0x74, 0xd9, 0x61, 0x70, 0xa3, 0x1f, 0x61, 0x66, 0x66, 0x8d, 0x79	/* tioapic_set_affinity */
	.byte 0x0d, 0xa8, 0xf6, 0xdb, 0x72, 0x74, 0x3a, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xa7, 0x71	/* t__pfx_startup_ioapic_irq */
	.byte 0x0d, 0x74, 0x73, 0xdb, 0x72, 0x74, 0x3a, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xa7, 0x71	/* tstartup_ioapic_irq */
	.byte 0x0c, 0xc6, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xdd, 0x73, 0xd8, 0xe8, 0xea, 0x79	/* t__pfx_ioapic_mask_entry */
	.byte 0x0c, 0x74, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xdd, 0x73, 0xd8, 0xe8, 0xea, 0x79	/* tioapic_mask_entry */
	.byte 0x0e, 0xbf, 0x6d, 0xe2, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0xe6, 0xeb, 0xc2, 0x76, 0x86	/* T__pfx_mp_irqdomain_deactivate */
	.byte 0x0e, 0x54, 0x6d, 0xe2, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0xe6, 0xeb, 0xc2, 0x76, 0x86	/* Tmp_irqdomain_deactivate */
	.byte 0x0e, 0xc6, 0x63, 0xd3, 0xca, 0x5f, 0x49, 0x4f, 0x5f, 0x41, 0x50, 0x49, 0x43, 0xe7, 0xf0	/* t__pfx_clear_IO_APIC_pin */
	.byte 0x0d, 0x2d, 0xd3, 0xca, 0x5f, 0x49, 0x4f, 0x5f, 0x41, 0x50, 0x49, 0x43, 0xe7, 0xf0	/* tclear_IO_APIC_pin */
	.byte 0x0c, 0xc6, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xeb, 0xd8, 0xd3, 0x76, 0x65, 0x6c	/* t__pfx_ioapic_ack_level */
	.byte 0x0c, 0x74, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xeb, 0xd8, 0xd3, 0x76, 0x65, 0x6c	/* tioapic_ack_level */
	.byte 0x09, 0xbf, 0xb0, 0xd5, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x89	/* T__pfx_mpc_ioapic_id */
	.byte 0x09, 0x54, 0xb0, 0xd5, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x89	/* Tmpc_ioapic_id */
	.byte 0x0a, 0xbf, 0xb0, 0xd5, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x10, 0x72	/* T__pfx_mpc_ioapic_addr */
	.byte 0x0a, 0x54, 0xb0, 0xd5, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x10, 0x72	/* Tmpc_ioapic_addr */
	.byte 0x0e, 0xbf, 0x64, 0xab, 0x80, 0xb3, 0xd9, 0x61, 0x70, 0xa3, 0xf6, 0xb9, 0x70, 0xce, 0x74	/* T__pfx_disable_ioapic_support */
	.byte 0x0e, 0x54, 0x64, 0xab, 0x80, 0xb3, 0xd9, 0x61, 0x70, 0xa3, 0xf6, 0xb9, 0x70, 0xce, 0x74	/* Tdisable_ioapic_support */
	.byte 0x07, 0xbf, 0xb0, 0xf6, 0x61, 0x22, 0xa7, 0x71	/* T__pfx_mp_save_irq */
	.byte 0x07, 0x54, 0xb0, 0xf6, 0x61, 0x22, 0xa7, 0x71	/* Tmp_save_irq */
	.byte 0x0c, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x3e, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0xc7	/* T__pfx_native_io_apic_read */
	.byte 0x0c, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x3e, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0xc7	/* Tnative_io_apic_read */
	.byte 0x0c, 0xbf, 0x63, 0xd3, 0xca, 0x5f, 0x49, 0x4f, 0x5f, 0x41, 0x50, 0x49, 0x43	/* T__pfx_clear_IO_APIC */
	.byte 0x0c, 0x54, 0x63, 0xd3, 0xca, 0x5f, 0x49, 0x4f, 0x5f, 0x41, 0x50, 0x49, 0x43	/* Tclear_IO_APIC */
	.byte 0x0d, 0xbf, 0xdd, 0x73, 0xd8, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x69, 0x3b	/* T__pfx_mask_ioapic_entries */
	.byte 0x0d, 0x54, 0xdd, 0x73, 0xd8, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x69, 0x3b	/* Tmask_ioapic_entries */
	.byte 0x0e, 0xbf, 0xf8, 0xd6, 0xce, 0xfa, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x69, 0x3b	/* T__pfx_restore_ioapic_entries */
	.byte 0x0e, 0x54, 0xf8, 0xd6, 0xce, 0xfa, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xe8, 0xea, 0x69, 0x3b	/* Trestore_ioapic_entries */
	.byte 0x09, 0xc6, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0xb7, 0xbd	/* t__pfx_ioapic_resume */
	.byte 0x09, 0x74, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0xf8, 0xb7, 0xbd	/* tioapic_resume */
	.byte 0x0a, 0xbf, 0xd9, 0x61, 0x70, 0xa3, 0x1f, 0x08, 0xd5, 0xe9, 0xea	/* T__pfx_ioapic_set_alloc_attr */
	.byte 0x0a, 0x54, 0xd9, 0x61, 0x70, 0xa3, 0x1f, 0x08, 0xd5, 0xe9, 0xea	/* Tioapic_set_alloc_attr */
	.byte 0x07, 0xbf, 0x6d, 0xe2, 0xd4, 0x84, 0xa7, 0x71	/* T__pfx_mp_unmap_irq */
	.byte 0x07, 0x54, 0x6d, 0xe2, 0xd4, 0x84, 0xa7, 0x71	/* Tmp_unmap_irq */
	.byte 0x0b, 0xbf, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x7a, 0x61, 0xe2, 0x3c, 0x73	/* T__pfx_ioapic_zap_locks */
	.byte 0x0b, 0x54, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x7a, 0x61, 0xe2, 0x3c, 0x73	/* Tioapic_zap_locks */
	.byte 0x11, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0xf8, 0xd6, 0xce, 0xfa, 0x62, 0x6f, 0x6f, 0xf9, 0xa7, 0x93, 0xa5, 0xe6	/* T__pfx_native_restore_boot_irq_mode */
	.byte 0x11, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0xf8, 0xd6, 0xce, 0xfa, 0x62, 0x6f, 0x6f, 0xf9, 0xa7, 0x93, 0xa5, 0xe6	/* Tnative_restore_boot_irq_mode */
	.byte 0x0d, 0xbf, 0xf8, 0xd6, 0xce, 0xfa, 0x62, 0x6f, 0x6f, 0xf9, 0xa7, 0x93, 0xa5, 0xe6	/* T__pfx_restore_boot_irq_mode */
	.byte 0x0d, 0x54, 0xf8, 0xd6, 0xce, 0xfa, 0x62, 0x6f, 0x6f, 0xf9, 0xa7, 0x93, 0xa5, 0xe6	/* Trestore_boot_irq_mode */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0x5f, 0x64, 0x79, 0x6e, 0xa7, 0x93, 0xdf, 0x77, 0xcf, 0x62, 0x6f, 0xd4, 0x64	/* T__pfx_arch_dynirq_lower_bound */
	.byte 0x10, 0x54, 0xca, 0xd0, 0x5f, 0x64, 0x79, 0x6e, 0xa7, 0x93, 0xdf, 0x77, 0xcf, 0x62, 0x6f, 0xd4, 0x64	/* Tarch_dynirq_lower_bound */
	.byte 0x0a, 0xbf, 0x6d, 0xe2, 0x66, 0xf0, 0xe5, 0xd9, 0x61, 0x70, 0xa3	/* T__pfx_mp_find_ioapic */
	.byte 0x0a, 0x54, 0x6d, 0xe2, 0x66, 0xf0, 0xe5, 0xd9, 0x61, 0x70, 0xa3	/* Tmp_find_ioapic */
	.byte 0x0c, 0xbf, 0x6d, 0xe2, 0x66, 0xf0, 0xe5, 0xd9, 0x61, 0x70, 0xa3, 0xe7, 0xf0	/* T__pfx_mp_find_ioapic_pin */
	.byte 0x0c, 0x54, 0x6d, 0xe2, 0x66, 0xf0, 0xe5, 0xd9, 0x61, 0x70, 0xa3, 0xe7, 0xf0	/* Tmp_find_ioapic_pin */
	.byte 0x0c, 0x29, 0x5f, 0x23, 0xb2, 0x6f, 0x76, 0xee, 0x72, 0x89, 0xfa, 0xa7, 0x71	/* t__pfx___acpi_get_override_irq */
	.byte 0x0c, 0x74, 0xff, 0x23, 0xb2, 0x6f, 0x76, 0xee, 0x72, 0x89, 0xfa, 0xa7, 0x71	/* t__acpi_get_override_irq */
	.byte 0x0b, 0xbf, 0x6d, 0xe2, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0xe1, 0xc0	/* T__pfx_mp_irqdomain_alloc */
	.byte 0x0b, 0x54, 0x6d, 0xe2, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0xe1, 0xc0	/* Tmp_irqdomain_alloc */
	.byte 0x0b, 0xc6, 0x6d, 0xe2, 0x0a, 0xe7, 0xf0, 0x5f, 0xac, 0x5f, 0xa7, 0x71	/* t__pfx_mp_map_pin_to_irq */
	.byte 0x0b, 0x74, 0x6d, 0xe2, 0x0a, 0xe7, 0xf0, 0x5f, 0xac, 0x5f, 0xa7, 0x71	/* tmp_map_pin_to_irq */
	.byte 0x0b, 0xbf, 0x6d, 0xe2, 0x84, 0x67, 0x73, 0xcb, 0xac, 0x5f, 0xa7, 0x71	/* T__pfx_mp_map_gsi_to_irq */
	.byte 0x0b, 0x54, 0x6d, 0xe2, 0x84, 0x67, 0x73, 0xcb, 0xac, 0x5f, 0xa7, 0x71	/* Tmp_map_gsi_to_irq */
	.byte 0x08, 0xa8, 0xe7, 0xf0, 0x5f, 0x32, 0x5f, 0xa7, 0x71	/* t__pfx_pin_2_irq */
	.byte 0x07, 0x06, 0xf0, 0x5f, 0x32, 0x5f, 0xa7, 0x71	/* tpin_2_irq */
	.byte 0x14, 0xbf, 0x49, 0x4f, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x5f, 0xb2, 0x50, 0x43, 0x49, 0x5f, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce	/* T__pfx_IO_APIC_get_PCI_irq_vector */
	.byte 0x14, 0x54, 0x49, 0x4f, 0x5f, 0x41, 0x50, 0x49, 0x43, 0x5f, 0xb2, 0x50, 0x43, 0x49, 0x5f, 0xa7, 0x93, 0x76, 0x65, 0x7b, 0xce	/* TIO_APIC_get_PCI_irq_vector */
	.byte 0x0b, 0xbf, 0x23, 0xb2, 0x6f, 0x76, 0xee, 0x72, 0x89, 0xfa, 0xa7, 0x71	/* T__pfx_acpi_get_override_irq */
	.byte 0x0b, 0x54, 0x23, 0xb2, 0x6f, 0x76, 0xee, 0x72, 0x89, 0xfa, 0xa7, 0x71	/* Tacpi_get_override_irq */
	.byte 0x09, 0xbf, 0x6d, 0xe2, 0x18, 0xcf, 0xd9, 0x61, 0x70, 0xa3	/* T__pfx_mp_register_ioapic */
	.byte 0x09, 0x54, 0x6d, 0xe2, 0x18, 0xcf, 0xd9, 0x61, 0x70, 0xa3	/* Tmp_register_ioapic */
	.byte 0x0a, 0xbf, 0x6d, 0xe2, 0xd4, 0x18, 0xcf, 0xd9, 0x61, 0x70, 0xa3	/* T__pfx_mp_unregister_ioapic */
	.byte 0x0a, 0x54, 0x6d, 0xe2, 0xd4, 0x18, 0xcf, 0xd9, 0x61, 0x70, 0xa3	/* Tmp_unregister_ioapic */
	.byte 0x0c, 0xbf, 0x6d, 0xe2, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x18, 0x65, 0xf8, 0x64	/* T__pfx_mp_ioapic_registered */
	.byte 0x0c, 0x54, 0x6d, 0xe2, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x18, 0x65, 0xf8, 0x64	/* Tmp_ioapic_registered */
	.byte 0x10, 0xbf, 0x6d, 0xe2, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x89, 0x78	/* T__pfx_mp_irqdomain_ioapic_idx */
	.byte 0x10, 0x54, 0x6d, 0xe2, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0xd9, 0x61, 0x70, 0x69, 0xd5, 0x89, 0x78	/* Tmp_irqdomain_ioapic_idx */
	.byte 0x0d, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0xf0, 0x99, 0x19, 0x20, 0xcb, 0xf0, 0x66, 0x6f	/* t__pfx_x86_init_dev_msi_info */
	.byte 0x0d, 0x74, 0x78, 0x38, 0x36, 0x5f, 0xf0, 0x99, 0x19, 0x20, 0xcb, 0xf0, 0x66, 0x6f	/* tx86_init_dev_msi_info */
	.byte 0x0b, 0x3f, 0xe7, 0x63, 0xcb, 0x20, 0x69, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* T__pfx_pci_msi_prepare */
	.byte 0x0b, 0x54, 0x70, 0x63, 0xcb, 0x20, 0x69, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* Tpci_msi_prepare */
	.byte 0x0c, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0x20, 0x69, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* t__pfx_x86_msi_prepare */
	.byte 0x0c, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x20, 0x69, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* tx86_msi_prepare */
	.byte 0x0d, 0xc6, 0x64, 0xdd, 0x72, 0x5f, 0x20, 0xcb, 0x09, 0x6f, 0x73, 0xfa, 0x20, 0x67	/* t__pfx_dmar_msi_compose_msg */
	.byte 0x0d, 0x74, 0x64, 0xdd, 0x72, 0x5f, 0x20, 0xcb, 0x09, 0x6f, 0x73, 0xfa, 0x20, 0x67	/* tdmar_msi_compose_msg */
	.byte 0x0a, 0xc6, 0xa7, 0x93, 0x20, 0xcb, 0xb9, 0x64, 0xa1, 0x20, 0x67	/* t__pfx_irq_msi_update_msg */
	.byte 0x0a, 0xc2, 0x72, 0x93, 0x20, 0xcb, 0xb9, 0x64, 0xa1, 0x20, 0x67	/* tirq_msi_update_msg */
	.byte 0x09, 0xc6, 0x20, 0x69, 0x1f, 0x61, 0x66, 0x66, 0x8d, 0x79	/* t__pfx_msi_set_affinity */
	.byte 0x09, 0x74, 0x20, 0x69, 0x1f, 0x61, 0x66, 0x66, 0x8d, 0x79	/* tmsi_set_affinity */
	.byte 0x0b, 0xc6, 0x64, 0xdd, 0x72, 0x5f, 0x20, 0xcb, 0x24, 0xfa, 0x20, 0x67	/* t__pfx_dmar_msi_write_msg */
	.byte 0x0b, 0x74, 0x64, 0xdd, 0x72, 0x5f, 0x20, 0xcb, 0x24, 0xfa, 0x20, 0x67	/* tdmar_msi_write_msg */
	.byte 0x08, 0xc6, 0x64, 0xdd, 0x72, 0x5f, 0x20, 0xcb, 0x8d	/* t__pfx_dmar_msi_init */
	.byte 0x08, 0x74, 0x64, 0xdd, 0x72, 0x5f, 0x20, 0xcb, 0x8d	/* tdmar_msi_init */
	.byte 0x17, 0x3f, 0xe7, 0x63, 0xcb, 0x19, 0x68, 0x61, 0xe0, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x20, 0x69, 0xe7, 0x61, 0xf8, 0x6e, 0xf9, 0xa9, 0xdd, 0xf0	/* T__pfx_pci_dev_has_default_msi_parent_domain */
	.byte 0x17, 0x54, 0x70, 0x63, 0xcb, 0x19, 0x68, 0x61, 0xe0, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x20, 0x69, 0xe7, 0x61, 0xf8, 0x6e, 0xf9, 0xa9, 0xdd, 0xf0	/* Tpci_dev_has_default_msi_parent_domain */
	.byte 0x0b, 0xbf, 0x64, 0xdd, 0x72, 0x5f, 0x08, 0xd5, 0x68, 0x77, 0xa7, 0x71	/* T__pfx_dmar_alloc_hwirq */
	.byte 0x0b, 0x54, 0x64, 0xdd, 0x72, 0x5f, 0x08, 0xd5, 0x68, 0x77, 0xa7, 0x71	/* Tdmar_alloc_hwirq */
	.byte 0x0b, 0xbf, 0x64, 0xdd, 0x72, 0x5f, 0x87, 0xfa, 0x68, 0x77, 0xa7, 0x71	/* T__pfx_dmar_free_hwirq */
	.byte 0x0b, 0x54, 0x64, 0xdd, 0x72, 0x5f, 0x87, 0xfa, 0x68, 0x77, 0xa7, 0x71	/* Tdmar_free_hwirq */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0x5f, 0xf8, 0xd6, 0xce, 0xfa, 0x20, 0xcb, 0xa7, 0x71, 0x73	/* T__pfx_arch_restore_msi_irqs */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0x5f, 0xf8, 0xd6, 0xce, 0xfa, 0x20, 0xcb, 0xa7, 0x71, 0x73	/* Tarch_restore_msi_irqs */
	.byte 0x0e, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0x20, 0x72, 0x5f, 0x24, 0x65	/* t__pfx_native_apic_msr_write */
	.byte 0x0e, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0x20, 0x72, 0x5f, 0x24, 0x65	/* tnative_apic_msr_write */
	.byte 0x0f, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0x20, 0x72, 0x5f, 0x65, 0x6f, 0x69	/* t__pfx_native_apic_msr_eoi */
	.byte 0x0f, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0x20, 0x72, 0x5f, 0x65, 0x6f, 0x69	/* tnative_apic_msr_eoi */
	.byte 0x0e, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0x20, 0x72, 0x5f, 0xf8, 0xc7	/* t__pfx_native_apic_msr_read */
	.byte 0x0e, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0x20, 0x72, 0x5f, 0xf8, 0xc7	/* tnative_apic_msr_read */
	.byte 0x0d, 0xbf, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xb2, 0x61, 0x70, 0x69, 0xd5, 0x89	/* T__pfx_x2apic_get_apic_id */
	.byte 0x0d, 0x54, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xb2, 0x61, 0x70, 0x69, 0xd5, 0x89	/* Tx2apic_get_apic_id */
	.byte 0x0f, 0xbf, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xba, 0x6c, 0x66	/* T__pfx_x2apic_send_IPI_self */
	.byte 0x0f, 0x54, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xba, 0x6c, 0x66	/* Tx2apic_send_IPI_self */
	.byte 0x0e, 0xc6, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x66, 0xc7, 0xf9, 0x70, 0x68, 0x79, 0x73	/* t__pfx_x2apic_fadt_phys */
	.byte 0x0e, 0x74, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x66, 0xc7, 0xf9, 0x70, 0x68, 0x79, 0x73	/* tx2apic_fadt_phys */
	.byte 0x0c, 0xc6, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xe7, 0x68, 0x79, 0x73, 0x25, 0x17	/* t__pfx_x2apic_phys_probe */
	.byte 0x0c, 0x74, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xe7, 0x68, 0x79, 0x73, 0x25, 0x17	/* tx2apic_phys_probe */
	.byte 0x11, 0xc6, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x23, 0xdd, 0x64, 0xf9, 0x6f, 0x65, 0xcd, 0x7e, 0x63, 0x6b	/* t__pfx_x2apic_acpi_madt_oem_check */
	.byte 0x11, 0x74, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x23, 0xdd, 0x64, 0xf9, 0x6f, 0x65, 0xcd, 0x7e, 0x63, 0x6b	/* tx2apic_acpi_madt_oem_check */
	.byte 0x10, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0xf8, 0xc7	/* t__pfx_native_x2apic_icr_read */
	.byte 0x10, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0xf8, 0xc7	/* tnative_x2apic_icr_read */
	.byte 0x10, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0x24, 0x65	/* t__pfx_native_x2apic_icr_write */
	.byte 0x10, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0x24, 0x65	/* tnative_x2apic_icr_write */
	.byte 0x10, 0x29, 0x5f, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* t__pfx___x2apic_send_IPI_mask */
	.byte 0x10, 0x74, 0xff, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* t__x2apic_send_IPI_mask */
	.byte 0x17, 0xc6, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* t__pfx_x2apic_send_IPI_mask_allbutself */
	.byte 0x17, 0x74, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* tx2apic_send_IPI_mask_allbutself */
	.byte 0x0f, 0xc6, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* t__pfx_x2apic_send_IPI_mask */
	.byte 0x0f, 0x74, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* tx2apic_send_IPI_mask */
	.byte 0x13, 0x29, 0x5f, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xf6, 0x68, 0xce, 0x15, 0xcc, 0x64	/* t__pfx___x2apic_send_IPI_shorthand */
	.byte 0x13, 0x74, 0xff, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0xf6, 0x68, 0xce, 0x15, 0xcc, 0x64	/* t__x2apic_send_IPI_shorthand */
	.byte 0x0f, 0xbf, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c	/* T__pfx_x2apic_send_IPI_all */
	.byte 0x0f, 0x54, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c	/* Tx2apic_send_IPI_all */
	.byte 0x14, 0xbf, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* T__pfx_x2apic_send_IPI_allbutself */
	.byte 0x14, 0x54, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* Tx2apic_send_IPI_allbutself */
	.byte 0x0c, 0xc6, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49	/* t__pfx_x2apic_send_IPI */
	.byte 0x0c, 0x74, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49	/* tx2apic_send_IPI */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe6, 0xd6	/* T__pfx___x2apic_send_IPI_dest */
	.byte 0x0f, 0x2f, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xe6, 0xd6	/* T__x2apic_send_IPI_dest */
	.byte 0x0e, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0x20, 0x72, 0x5f, 0x24, 0x65	/* t__pfx_native_apic_msr_write */
	.byte 0x0e, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0x20, 0x72, 0x5f, 0x24, 0x65	/* tnative_apic_msr_write */
	.byte 0x0f, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0x20, 0x72, 0x5f, 0x65, 0x6f, 0x69	/* t__pfx_native_apic_msr_eoi */
	.byte 0x0f, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0x20, 0x72, 0x5f, 0x65, 0x6f, 0x69	/* tnative_apic_msr_eoi */
	.byte 0x0e, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0x20, 0x72, 0x5f, 0xf8, 0xc7	/* t__pfx_native_apic_msr_read */
	.byte 0x0e, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0x20, 0x72, 0x5f, 0xf8, 0xc7	/* tnative_apic_msr_read */
	.byte 0x0d, 0xc6, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x28, 0xd5, 0x61, 0x70, 0xa3, 0x89	/* t__pfx_x2apic_calc_apicid */
	.byte 0x0d, 0x74, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x28, 0xd5, 0x61, 0x70, 0xa3, 0x89	/* tx2apic_calc_apicid */
	.byte 0x0a, 0xc6, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xe6, 0x05, 0x92	/* t__pfx_x2apic_dead_cpu */
	.byte 0x0a, 0x74, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xe6, 0x05, 0x92	/* tx2apic_dead_cpu */
	.byte 0x0b, 0xc6, 0xf0, 0x99, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x02, 0x72	/* t__pfx_init_x2apic_ldr */
	.byte 0x0b, 0x74, 0xf0, 0x99, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x02, 0x72	/* tinit_x2apic_ldr */
	.byte 0x0c, 0xc6, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x92	/* t__pfx_x2apic_prepare_cpu */
	.byte 0x0c, 0x74, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x92	/* tx2apic_prepare_cpu */
	.byte 0x0c, 0xc6, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49	/* t__pfx_x2apic_send_IPI */
	.byte 0x0c, 0x74, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49	/* tx2apic_send_IPI */
	.byte 0x10, 0x29, 0x5f, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* t__pfx___x2apic_send_IPI_mask */
	.byte 0x10, 0x74, 0xff, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* t__x2apic_send_IPI_mask */
	.byte 0x17, 0xc6, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* t__pfx_x2apic_send_IPI_mask_allbutself */
	.byte 0x17, 0x74, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* tx2apic_send_IPI_mask_allbutself */
	.byte 0x0f, 0xc6, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* t__pfx_x2apic_send_IPI_mask */
	.byte 0x0f, 0x74, 0x78, 0x32, 0x61, 0x70, 0xa3, 0xf6, 0xe8, 0xe5, 0x49, 0x50, 0x49, 0x5f, 0xdd, 0x16	/* tx2apic_send_IPI_mask */
	.byte 0x0e, 0xc6, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x63, 0x6c, 0x75, 0xd6, 0xee, 0x25, 0x17	/* t__pfx_x2apic_cluster_probe */
	.byte 0x0e, 0x74, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x63, 0x6c, 0x75, 0xd6, 0xee, 0x25, 0x17	/* tx2apic_cluster_probe */
	.byte 0x11, 0xc6, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x23, 0xdd, 0x64, 0xf9, 0x6f, 0x65, 0xcd, 0x7e, 0x63, 0x6b	/* t__pfx_x2apic_acpi_madt_oem_check */
	.byte 0x11, 0x74, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0x23, 0xdd, 0x64, 0xf9, 0x6f, 0x65, 0xcd, 0x7e, 0x63, 0x6b	/* tx2apic_acpi_madt_oem_check */
	.byte 0x10, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0x24, 0x65	/* t__pfx_native_x2apic_icr_write */
	.byte 0x10, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0x24, 0x65	/* tnative_x2apic_icr_write */
	.byte 0x10, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0xf8, 0xc7	/* t__pfx_native_x2apic_icr_read */
	.byte 0x10, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x78, 0x32, 0x61, 0x70, 0x69, 0xd5, 0xa3, 0x72, 0x5f, 0xf8, 0xc7	/* tnative_x2apic_icr_read */
	.byte 0x0d, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0xbd, 0xcd, 0x24, 0x65	/* t__pfx_native_apic_mem_write */
	.byte 0x0d, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0xbd, 0xcd, 0x24, 0x65	/* tnative_apic_mem_write */
	.byte 0x0d, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0xbd, 0xcd, 0xf8, 0xc7	/* t__pfx_native_apic_mem_read */
	.byte 0x0d, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0xbd, 0xcd, 0xf8, 0xc7	/* tnative_apic_mem_read */
	.byte 0x0e, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0xbd, 0xcd, 0x65, 0x6f, 0x69	/* t__pfx_native_apic_mem_eoi */
	.byte 0x0e, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x61, 0x70, 0x69, 0xd5, 0xbd, 0xcd, 0x65, 0x6f, 0x69	/* tnative_apic_mem_eoi */
	.byte 0x0e, 0xa8, 0xe7, 0x68, 0x79, 0x73, 0x66, 0x1b, 0xf9, 0xb2, 0x61, 0x70, 0x69, 0xd5, 0x89	/* t__pfx_physflat_get_apic_id */
	.byte 0x0d, 0x06, 0x68, 0x79, 0x73, 0x66, 0x1b, 0xf9, 0xb2, 0x61, 0x70, 0x69, 0xd5, 0x89	/* tphysflat_get_apic_id */
	.byte 0x0a, 0xa8, 0xe7, 0x68, 0x79, 0x73, 0x66, 0x1b, 0xf9, 0x9b, 0x17	/* t__pfx_physflat_probe */
	.byte 0x09, 0x06, 0x68, 0x79, 0x73, 0x66, 0x1b, 0xf9, 0x9b, 0x17	/* tphysflat_probe */
	.byte 0x12, 0xa8, 0xe7, 0x68, 0x79, 0x73, 0x66, 0x1b, 0xf9, 0x23, 0xdd, 0x64, 0xf9, 0x6f, 0x65, 0xcd, 0x7e, 0x63, 0x6b	/* t__pfx_physflat_acpi_madt_oem_check */
	.byte 0x11, 0x06, 0x68, 0x79, 0x73, 0x66, 0x1b, 0xf9, 0x23, 0xdd, 0x64, 0xf9, 0x6f, 0x65, 0xcd, 0x7e, 0x63, 0x6b	/* tphysflat_acpi_madt_oem_check */
	.byte 0x0a, 0xc6, 0x66, 0xc8, 0x76, 0xee, 0x69, 0x66, 0xc5, 0xfe, 0xe6	/* t__pfx_ftrace_verify_code */
	.byte 0x0a, 0x74, 0x66, 0xc8, 0x76, 0xee, 0x69, 0x66, 0xc5, 0xfe, 0xe6	/* tftrace_verify_code */
	.byte 0x09, 0xc6, 0x10, 0x72, 0x5f, 0x66, 0xde, 0xcd, 0x28, 0x6c	/* t__pfx_addr_from_call */
	.byte 0x0a, 0xdb, 0x64, 0x64, 0x72, 0x5f, 0x66, 0xde, 0xcd, 0x28, 0x6c	/* taddr_from_call */
	.byte 0x13, 0xbf, 0x66, 0xc8, 0xca, 0xd0, 0x5f, 0xfe, 0x64, 0xfa, 0xa5, 0x64, 0x69, 0x66, 0x79, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* T__pfx_ftrace_arch_code_modify_prepare */
	.byte 0x13, 0x54, 0x66, 0xc8, 0xca, 0xd0, 0x5f, 0xfe, 0x64, 0xfa, 0xa5, 0x64, 0x69, 0x66, 0x79, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* Tftrace_arch_code_modify_prepare */
	.byte 0x16, 0xbf, 0x66, 0xc8, 0xca, 0xd0, 0x5f, 0xfe, 0x64, 0xfa, 0xa5, 0x64, 0x69, 0x66, 0x79, 0xe7, 0x6f, 0x73, 0xf9, 0x9b, 0x63, 0x3b, 0x73	/* T__pfx_ftrace_arch_code_modify_post_process */
	.byte 0x16, 0x54, 0x66, 0xc8, 0xca, 0xd0, 0x5f, 0xfe, 0x64, 0xfa, 0xa5, 0x64, 0x69, 0x66, 0x79, 0xe7, 0x6f, 0x73, 0xf9, 0x9b, 0x63, 0x3b, 0x73	/* Tftrace_arch_code_modify_post_process */
	.byte 0x08, 0xbf, 0x66, 0xc8, 0xdd, 0x6b, 0xfa, 0xb6, 0x70	/* T__pfx_ftrace_make_nop */
	.byte 0x08, 0x54, 0x66, 0xc8, 0xdd, 0x6b, 0xfa, 0xb6, 0x70	/* Tftrace_make_nop */
	.byte 0x08, 0xbf, 0x66, 0xc8, 0xdd, 0x6b, 0xfa, 0x28, 0x6c	/* T__pfx_ftrace_make_call */
	.byte 0x08, 0x54, 0x66, 0xc8, 0xdd, 0x6b, 0xfa, 0x28, 0x6c	/* Tftrace_make_call */
	.byte 0x0a, 0xbf, 0x66, 0xc8, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0x28, 0x6c	/* T__pfx_ftrace_modify_call */
	.byte 0x0a, 0x54, 0x66, 0xc8, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0x28, 0x6c	/* Tftrace_modify_call */
	.byte 0x0a, 0xbf, 0x66, 0xc8, 0xb9, 0x64, 0xa1, 0x66, 0xc8, 0x2b, 0x63	/* T__pfx_ftrace_update_ftrace_func */
	.byte 0x0a, 0x54, 0x66, 0xc8, 0xb9, 0x64, 0xa1, 0x66, 0xc8, 0x2b, 0x63	/* Tftrace_update_ftrace_func */
	.byte 0x0a, 0xbf, 0x66, 0xc8, 0xf8, 0x70, 0x6c, 0xeb, 0xfa, 0xfe, 0xe6	/* T__pfx_ftrace_replace_code */
	.byte 0x0a, 0x54, 0x66, 0xc8, 0xf8, 0x70, 0x6c, 0xeb, 0xfa, 0xfe, 0xe6	/* Tftrace_replace_code */
	.byte 0x0b, 0xbf, 0xca, 0xd0, 0x5f, 0x66, 0xc8, 0xb9, 0x64, 0xa1, 0xfe, 0xe6	/* T__pfx_arch_ftrace_update_code */
	.byte 0x0b, 0x54, 0xca, 0xd0, 0x5f, 0x66, 0xc8, 0xb9, 0x64, 0xa1, 0xfe, 0xe6	/* Tarch_ftrace_update_code */
	.byte 0x07, 0x3f, 0x1f, 0x66, 0xc8, 0x81, 0xe0, 0xde	/* T__pfx_set_ftrace_ops_ro */
	.byte 0x08, 0x54, 0xc9, 0xf9, 0x66, 0xc8, 0x81, 0xe0, 0xde	/* Tset_ftrace_ops_ro */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0x66, 0xc8, 0xb9, 0x64, 0xa1, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* T__pfx_arch_ftrace_update_trampoline */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0x66, 0xc8, 0xb9, 0x64, 0xa1, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* Tarch_ftrace_update_trampoline */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0x66, 0xc8, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x2b, 0x63	/* T__pfx_arch_ftrace_trampoline_func */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0x66, 0xc8, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x2b, 0x63	/* Tarch_ftrace_trampoline_func */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0x66, 0xc8, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x87, 0x65	/* T__pfx_arch_ftrace_trampoline_free */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0x66, 0xc8, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x87, 0x65	/* Tarch_ftrace_trampoline_free */
	.byte 0x0c, 0x3f, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x66, 0xc8, 0xf8, 0x74, 0x1d, 0x6e	/* T__pfx_prepare_ftrace_return */
	.byte 0x0c, 0x54, 0x70, 0xf8, 0x70, 0xca, 0xfa, 0x66, 0xc8, 0xf8, 0x74, 0x1d, 0x6e	/* Tprepare_ftrace_return */
	.byte 0x09, 0xbf, 0x66, 0xc8, 0x67, 0xb5, 0x70, 0x5b, 0x2b, 0x63	/* T__pfx_ftrace_graph_func */
	.byte 0x09, 0x54, 0x66, 0xc8, 0x67, 0xb5, 0x70, 0x5b, 0x2b, 0x63	/* Tftrace_graph_func */
	.byte 0x06, 0xbf, 0x66, 0xc8, 0xd6, 0x75, 0x62	/* T__pfx_ftrace_stub */
	.byte 0x06, 0x54, 0x66, 0xc8, 0xd6, 0x75, 0x62	/* Tftrace_stub */
	.byte 0x0a, 0xbf, 0x66, 0xc8, 0xd6, 0x75, 0xdc, 0x67, 0xb5, 0x70, 0x68	/* T__pfx_ftrace_stub_graph */
	.byte 0x0a, 0x54, 0x66, 0xc8, 0xd6, 0x75, 0xdc, 0x67, 0xb5, 0x70, 0x68	/* Tftrace_stub_graph */
	.byte 0x08, 0x3f, 0xff, 0x5f, 0x66, 0xe8, 0xea, 0x79, 0xff	/* T__pfx___fentry__ */
	.byte 0x06, 0x2f, 0x66, 0xe8, 0xea, 0x79, 0xff	/* T__fentry__ */
	.byte 0x06, 0xbf, 0x66, 0xc8, 0x28, 0x6c, 0xee	/* T__pfx_ftrace_caller */
	.byte 0x06, 0x54, 0x66, 0xc8, 0x28, 0x6c, 0xee	/* Tftrace_caller */
	.byte 0x09, 0x54, 0x66, 0xc8, 0x28, 0x6c, 0xcf, 0x81, 0xe7, 0xea	/* Tftrace_caller_op_ptr */
	.byte 0x05, 0x54, 0x66, 0xc8, 0x28, 0x6c	/* Tftrace_call */
	.byte 0x08, 0x54, 0x66, 0xc8, 0x28, 0x6c, 0xcf, 0xe8, 0x64	/* Tftrace_caller_end */
	.byte 0x08, 0xbf, 0x66, 0xc8, 0x9f, 0xe0, 0x28, 0x6c, 0xee	/* T__pfx_ftrace_regs_caller */
	.byte 0x08, 0x54, 0x66, 0xc8, 0x9f, 0xe0, 0x28, 0x6c, 0xee	/* Tftrace_regs_caller */
	.byte 0x0b, 0x54, 0x66, 0xc8, 0x9f, 0xe0, 0x28, 0x6c, 0xcf, 0x81, 0xe7, 0xea	/* Tftrace_regs_caller_op_ptr */
	.byte 0x07, 0x54, 0x66, 0xc8, 0x9f, 0xe0, 0x28, 0x6c	/* Tftrace_regs_call */
	.byte 0x0a, 0x54, 0x66, 0xc8, 0x9f, 0xe0, 0x28, 0x6c, 0xcf, 0x6a, 0xb0	/* Tftrace_regs_caller_jmp */
	.byte 0x0a, 0x54, 0x66, 0xc8, 0x9f, 0xe0, 0x28, 0x6c, 0xcf, 0xe8, 0x64	/* Tftrace_regs_caller_end */
	.byte 0x0e, 0xbf, 0x66, 0xc8, 0xd6, 0x75, 0xdc, 0x64, 0x69, 0xf8, 0x63, 0xf9, 0xea, 0x61, 0xb0	/* T__pfx_ftrace_stub_direct_tramp */
	.byte 0x0e, 0x54, 0x66, 0xc8, 0xd6, 0x75, 0xdc, 0x64, 0x69, 0xf8, 0x63, 0xf9, 0xea, 0x61, 0xb0	/* Tftrace_stub_direct_tramp */
	.byte 0x0c, 0x54, 0xf8, 0x74, 0x1d, 0x7c, 0xac, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Treturn_to_handler */
	.byte 0x0c, 0xbf, 0xc8, 0x63, 0xc0, 0xd8, 0x78, 0x38, 0x36, 0x5f, 0x74, 0x73, 0x63	/* T__pfx_trace_clock_x86_tsc */
	.byte 0x0c, 0x54, 0xc8, 0x63, 0xc0, 0xd8, 0x78, 0x38, 0x36, 0x5f, 0x74, 0x73, 0x63	/* Ttrace_clock_x86_tsc */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0xf8, 0x74, 0xad, 0x6f, 0xd8, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* Tarch_rethook_trampoline */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0x5f, 0xf8, 0x74, 0xad, 0x6f, 0xd8, 0xb8, 0x78, 0x3a, 0xf8, 0x74, 0x1d, 0x6e	/* T__pfx_arch_rethook_fixup_return */
	.byte 0x10, 0x54, 0xca, 0xd0, 0x5f, 0xf8, 0x74, 0xad, 0x6f, 0xd8, 0xb8, 0x78, 0x3a, 0xf8, 0x74, 0x1d, 0x6e	/* Tarch_rethook_fixup_return */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0xf8, 0x74, 0xad, 0x6f, 0x6b, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* T__pfx_arch_rethook_prepare */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0xf8, 0x74, 0xad, 0x6f, 0x6b, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* Tarch_rethook_prepare */
	.byte 0x14, 0xbf, 0xca, 0xd0, 0x5f, 0xf8, 0x74, 0xad, 0x6f, 0xd8, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* T__pfx_arch_rethook_trampoline_callback */
	.byte 0x14, 0x54, 0xca, 0xd0, 0x5f, 0xf8, 0x74, 0xad, 0x6f, 0xd8, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* Tarch_rethook_trampoline_callback */
	.byte 0x12, 0xbf, 0xca, 0xd0, 0x5f, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x61, 0x22, 0x76, 0x6d, 0xfe, 0xf8, 0xf0, 0x66, 0x6f	/* T__pfx_arch_crash_save_vmcoreinfo */
	.byte 0x12, 0x54, 0xca, 0xd0, 0x5f, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x61, 0x22, 0x76, 0x6d, 0xfe, 0xf8, 0xf0, 0x66, 0x6f	/* Tarch_crash_save_vmcoreinfo */
	.byte 0x0b, 0xc6, 0xbd, 0xcd, 0x9f, 0xd9, 0x7c, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_mem_region_callback */
	.byte 0x0b, 0x74, 0xbd, 0xcd, 0x9f, 0xd9, 0x7c, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tmem_region_callback */
	.byte 0x08, 0xc6, 0xe1, 0xc0, 0xe7, 0x67, 0xf9, 0x70, 0x03	/* t__pfx_alloc_pgt_page */
	.byte 0x08, 0x74, 0xe1, 0xc0, 0xe7, 0x67, 0xf9, 0x70, 0x03	/* talloc_pgt_page */
	.byte 0x10, 0xc6, 0x6b, 0xd1, 0x65, 0xd5, 0xdd, 0x72, 0xd8, 0x72, 0xcc, 0xda, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_kexec_mark_range.isra.0 */
	.byte 0x10, 0x74, 0x6b, 0xd1, 0x65, 0xd5, 0xdd, 0x72, 0xd8, 0x72, 0xcc, 0xda, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tkexec_mark_range.isra.0 */
	.byte 0x0e, 0xc6, 0x6b, 0xd1, 0x65, 0xd5, 0xdd, 0x72, 0xd8, 0x63, 0xb5, 0x73, 0x68, 0x6b, 0x3d	/* t__pfx_kexec_mark_crashkres */
	.byte 0x0e, 0x74, 0x6b, 0xd1, 0x65, 0xd5, 0xdd, 0x72, 0xd8, 0x63, 0xb5, 0x73, 0x68, 0x6b, 0x3d	/* tkexec_mark_crashkres */
	.byte 0x0f, 0xbf, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x6b, 0xd1, 0x65, 0x63, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* T__pfx_machine_kexec_prepare */
	.byte 0x0f, 0x54, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x6b, 0xd1, 0x65, 0x63, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* Tmachine_kexec_prepare */
	.byte 0x0e, 0xbf, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x6b, 0xd1, 0x65, 0xd5, 0x63, 0xd3, 0xcc, 0xb9	/* T__pfx_machine_kexec_cleanup */
	.byte 0x0e, 0x54, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x6b, 0xd1, 0x65, 0xd5, 0x63, 0xd3, 0xcc, 0xb9	/* Tmachine_kexec_cleanup */
	.byte 0x0a, 0xbf, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x6b, 0xd1, 0x65, 0x63	/* T__pfx_machine_kexec */
	.byte 0x0a, 0x54, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x6b, 0xd1, 0x65, 0x63	/* Tmachine_kexec */
	.byte 0x14, 0xbf, 0xca, 0xd0, 0x5f, 0x6b, 0xd1, 0x65, 0xd5, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xf8, 0xc0, 0xe9, 0xd9, 0x6e, 0xe0, 0x10	/* T__pfx_arch_kexec_apply_relocations_add */
	.byte 0x14, 0x54, 0xca, 0xd0, 0x5f, 0x6b, 0xd1, 0x65, 0xd5, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xf8, 0xc0, 0xe9, 0xd9, 0x6e, 0xe0, 0x10	/* Tarch_kexec_apply_relocations_add */
	.byte 0x14, 0xbf, 0xca, 0xd0, 0x5f, 0x6b, 0x69, 0xdd, 0x21, 0xb8, 0xb3, 0x70, 0x6f, 0x73, 0xf9, 0xdf, 0x05, 0x63, 0xd3, 0xcc, 0xb9	/* T__pfx_arch_kimage_file_post_load_cleanup */
	.byte 0x14, 0x54, 0xca, 0xd0, 0x5f, 0x6b, 0x69, 0xdd, 0x21, 0xb8, 0xb3, 0x70, 0x6f, 0x73, 0xf9, 0xdf, 0x05, 0x63, 0xd3, 0xcc, 0xb9	/* Tarch_kimage_file_post_load_cleanup */
	.byte 0x12, 0xbf, 0xca, 0xd0, 0x5f, 0x6b, 0xd1, 0x65, 0x63, 0x25, 0x9a, 0x63, 0xf9, 0x63, 0xb5, 0x73, 0x68, 0x6b, 0x3d	/* T__pfx_arch_kexec_protect_crashkres */
	.byte 0x12, 0x54, 0xca, 0xd0, 0x5f, 0x6b, 0xd1, 0x65, 0x63, 0x25, 0x9a, 0x63, 0xf9, 0x63, 0xb5, 0x73, 0x68, 0x6b, 0x3d	/* Tarch_kexec_protect_crashkres */
	.byte 0x13, 0xbf, 0xca, 0xd0, 0x5f, 0x6b, 0xd1, 0x65, 0xd5, 0xd4, 0x9b, 0x9a, 0x63, 0xf9, 0x63, 0xb5, 0x73, 0x68, 0x6b, 0x3d	/* T__pfx_arch_kexec_unprotect_crashkres */
	.byte 0x13, 0x54, 0xca, 0xd0, 0x5f, 0x6b, 0xd1, 0x65, 0xd5, 0xd4, 0x9b, 0x9a, 0x63, 0xf9, 0x63, 0xb5, 0x73, 0x68, 0x6b, 0x3d	/* Tarch_kexec_unprotect_crashkres */
	.byte 0x11, 0xbf, 0xca, 0xd0, 0x5f, 0x6b, 0xd1, 0x65, 0x63, 0xe7, 0x6f, 0x73, 0xf9, 0xe1, 0xc0, 0xe7, 0x03, 0x73	/* T__pfx_arch_kexec_post_alloc_pages */
	.byte 0x11, 0x54, 0xca, 0xd0, 0x5f, 0x6b, 0xd1, 0x65, 0x63, 0xe7, 0x6f, 0x73, 0xf9, 0xe1, 0xc0, 0xe7, 0x03, 0x73	/* Tarch_kexec_post_alloc_pages */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0x5f, 0x6b, 0xd1, 0x65, 0x63, 0xe7, 0x72, 0xfa, 0x87, 0xfa, 0x70, 0x03, 0x73	/* T__pfx_arch_kexec_pre_free_pages */
	.byte 0x10, 0x54, 0xca, 0xd0, 0x5f, 0x6b, 0xd1, 0x65, 0x63, 0xe7, 0x72, 0xfa, 0x87, 0xfa, 0x70, 0x03, 0x73	/* Tarch_kexec_pre_free_pages */
	.byte 0x08, 0x54, 0xf8, 0xc0, 0xa1, 0x6b, 0xee, 0xb4, 0x6c	/* Trelocate_kernel */
	.byte 0x07, 0x54, 0xf8, 0xc0, 0xa1, 0x72, 0xcc, 0xda	/* Trelocate_range */
	.byte 0x09, 0xc2, 0x64, 0x1e, 0xe4, 0xc5, 0x0a, 0x70, 0x65, 0x64	/* tidentity_mapped */
	.byte 0x0b, 0x74, 0x76, 0xa7, 0x74, 0x75, 0xe1, 0x5f, 0x0a, 0x70, 0x65, 0x64	/* tvirtual_mapped */
	.byte 0x07, 0x74, 0x73, 0x13, 0x70, 0xe7, 0x03, 0x73	/* tswap_pages */
	.byte 0x0c, 0xc6, 0x62, 0x7a, 0x49, 0xdd, 0xda, 0x36, 0x5c, 0x63, 0xd3, 0xcc, 0xb9	/* t__pfx_bzImage64_cleanup */
	.byte 0x0c, 0x74, 0x62, 0x7a, 0x49, 0xdd, 0xda, 0x36, 0x5c, 0x63, 0xd3, 0xcc, 0xb9	/* tbzImage64_cleanup */
	.byte 0x0a, 0xc6, 0x62, 0x7a, 0x49, 0xdd, 0xda, 0x36, 0x34, 0x25, 0x17	/* t__pfx_bzImage64_probe */
	.byte 0x0a, 0x74, 0x62, 0x7a, 0x49, 0xdd, 0xda, 0x36, 0x34, 0x25, 0x17	/* tbzImage64_probe */
	.byte 0x0a, 0xc6, 0x62, 0x7a, 0x49, 0xdd, 0xda, 0x36, 0x5c, 0xdf, 0xc7	/* t__pfx_bzImage64_load */
	.byte 0x0a, 0x74, 0x62, 0x7a, 0x49, 0xdd, 0xda, 0x36, 0x5c, 0xdf, 0xc7	/* tbzImage64_load */
	.byte 0x0b, 0x29, 0x5f, 0xfe, 0x70, 0xc5, 0x7f, 0x64, 0xbd, 0x6d, 0xe7, 0x03	/* t__pfx___copy_oldmem_page */
	.byte 0x0b, 0x74, 0xff, 0xfe, 0x70, 0xc5, 0x7f, 0x64, 0xbd, 0x6d, 0xe7, 0x03	/* t__copy_oldmem_page */
	.byte 0x0a, 0xbf, 0xfe, 0x70, 0xc5, 0x7f, 0x64, 0xbd, 0x6d, 0xe7, 0x03	/* T__pfx_copy_oldmem_page */
	.byte 0x0a, 0x54, 0xfe, 0x70, 0xc5, 0x7f, 0x64, 0xbd, 0x6d, 0xe7, 0x03	/* Tcopy_oldmem_page */
	.byte 0x11, 0xbf, 0xfe, 0x70, 0xc5, 0x7f, 0x64, 0xbd, 0x6d, 0xe7, 0x61, 0x21, 0xe8, 0x63, 0x72, 0x27, 0x9a, 0x64	/* T__pfx_copy_oldmem_page_encrypted */
	.byte 0x11, 0x54, 0xfe, 0x70, 0xc5, 0x7f, 0x64, 0xbd, 0x6d, 0xe7, 0x61, 0x21, 0xe8, 0x63, 0x72, 0x27, 0x9a, 0x64	/* Tcopy_oldmem_page_encrypted */
	.byte 0x0c, 0xbf, 0x65, 0x6c, 0x66, 0xfe, 0xf8, 0x68, 0x64, 0x72, 0x5f, 0xf8, 0xc7	/* T__pfx_elfcorehdr_read */
	.byte 0x0c, 0x54, 0x65, 0x6c, 0x66, 0xfe, 0xf8, 0x68, 0x64, 0x72, 0x5f, 0xf8, 0xc7	/* Telfcorehdr_read */
	.byte 0x10, 0xc6, 0xb2, 0x6e, 0x72, 0x5f, 0xb5, 0xcd, 0x72, 0xcc, 0xda, 0xe0, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_get_nr_ram_ranges_callback */
	.byte 0x10, 0x74, 0xb2, 0x6e, 0x72, 0x5f, 0xb5, 0xcd, 0x72, 0xcc, 0xda, 0xe0, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tget_nr_ram_ranges_callback */
	.byte 0x17, 0xa8, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x65, 0x6c, 0x66, 0x36, 0x5c, 0xb5, 0xcd, 0x68, 0x65, 0xc7, 0xee, 0xe0, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_prepare_elf64_ram_headers_callback */
	.byte 0x16, 0x06, 0xf8, 0x70, 0xca, 0xfa, 0x65, 0x6c, 0x66, 0x36, 0x5c, 0xb5, 0xcd, 0x68, 0x65, 0xc7, 0xee, 0xe0, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tprepare_elf64_ram_headers_callback */
	.byte 0x0e, 0xc6, 0x6b, 0x64, 0x75, 0x6d, 0xe2, 0x6e, 0x6d, 0xcb, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_kdump_nmi_callback */
	.byte 0x0e, 0x74, 0x6b, 0x64, 0x75, 0x6d, 0xe2, 0x6e, 0x6d, 0xcb, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tkdump_nmi_callback */
	.byte 0x0e, 0xa8, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x65, 0x6c, 0xa0, 0x68, 0x65, 0xc7, 0xee, 0x73	/* t__pfx_prepare_elf_headers */
	.byte 0x0d, 0x06, 0xf8, 0x70, 0xca, 0xfa, 0x65, 0x6c, 0xa0, 0x68, 0x65, 0xc7, 0xee, 0x73	/* tprepare_elf_headers */
	.byte 0x0c, 0xc6, 0xbd, 0x6d, 0x84, 0xe8, 0xea, 0xc5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_memmap_entry_callback */
	.byte 0x0c, 0x74, 0xbd, 0x6d, 0x84, 0xe8, 0xea, 0xc5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tmemmap_entry_callback */
	.byte 0x12, 0xbf, 0x6b, 0x64, 0x75, 0x6d, 0xe2, 0x6e, 0x6d, 0x69, 0xf6, 0xad, 0x6f, 0x74, 0xa9, 0x77, 0x7c, 0x92, 0x73	/* T__pfx_kdump_nmi_shootdown_cpus */
	.byte 0x12, 0x54, 0x6b, 0x64, 0x75, 0x6d, 0xe2, 0x6e, 0x6d, 0x69, 0xf6, 0xad, 0x6f, 0x74, 0xa9, 0x77, 0x7c, 0x92, 0x73	/* Tkdump_nmi_shootdown_cpus */
	.byte 0x0d, 0xbf, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0xb0, 0xf6, 0xe8, 0x64, 0xf6, 0xac, 0x70	/* T__pfx_crash_smp_send_stop */
	.byte 0x0d, 0x54, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0xb0, 0xf6, 0xe8, 0x64, 0xf6, 0xac, 0x70	/* Tcrash_smp_send_stop */
	.byte 0x14, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* T__pfx_native_machine_crash_shutdown */
	.byte 0x14, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x6d, 0xeb, 0x68, 0xf0, 0xfa, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* Tnative_machine_crash_shutdown */
	.byte 0x0f, 0xbf, 0x63, 0xb5, 0x73, 0x68, 0xba, 0x74, 0x3a, 0xbd, 0x6d, 0x84, 0xe8, 0xea, 0x69, 0x3b	/* T__pfx_crash_setup_memmap_entries */
	.byte 0x0f, 0x54, 0x63, 0xb5, 0x73, 0x68, 0xba, 0x74, 0x3a, 0xbd, 0x6d, 0x84, 0xe8, 0xea, 0x69, 0x3b	/* Tcrash_setup_memmap_entries */
	.byte 0x0c, 0xbf, 0x63, 0xb5, 0x73, 0x5b, 0xdf, 0xc7, 0xba, 0x67, 0x6d, 0x1e, 0x73	/* T__pfx_crash_load_segments */
	.byte 0x0c, 0x54, 0x63, 0xb5, 0x73, 0x5b, 0xdf, 0xc7, 0xba, 0x67, 0x6d, 0x1e, 0x73	/* Tcrash_load_segments */
	.byte 0x12, 0xbf, 0xca, 0xd0, 0x5f, 0x63, 0xb5, 0x73, 0x5b, 0xad, 0x06, 0x6c, 0x75, 0x67, 0xf6, 0xb9, 0x70, 0xce, 0x74	/* T__pfx_arch_crash_hotplug_support */
	.byte 0x12, 0x54, 0xca, 0xd0, 0x5f, 0x63, 0xb5, 0x73, 0x5b, 0xad, 0x06, 0x6c, 0x75, 0x67, 0xf6, 0xb9, 0x70, 0xce, 0x74	/* Tarch_crash_hotplug_support */
	.byte 0x15, 0xbf, 0xca, 0xd0, 0x5f, 0x63, 0xb5, 0x73, 0x5b, 0xb2, 0x65, 0x6c, 0x66, 0xfe, 0xf8, 0x68, 0x64, 0x72, 0xf6, 0x69, 0x7a, 0x65	/* T__pfx_arch_crash_get_elfcorehdr_size */
	.byte 0x15, 0x54, 0xca, 0xd0, 0x5f, 0x63, 0xb5, 0x73, 0x5b, 0xb2, 0x65, 0x6c, 0x66, 0xfe, 0xf8, 0x68, 0x64, 0x72, 0xf6, 0x69, 0x7a, 0x65	/* Tarch_crash_get_elfcorehdr_size */
	.byte 0x13, 0xbf, 0xca, 0xd0, 0x5f, 0x63, 0xb5, 0x73, 0x5b, 0x68, 0xcc, 0x64, 0xb3, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0xbc, 0x1e	/* T__pfx_arch_crash_handle_hotplug_event */
	.byte 0x13, 0x54, 0xca, 0xd0, 0x5f, 0x63, 0xb5, 0x73, 0x5b, 0x68, 0xcc, 0x64, 0xb3, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0xbc, 0x1e	/* Tarch_crash_handle_hotplug_event */
	.byte 0x0d, 0x3f, 0x95, 0x6e, 0x15, 0x3b, 0x69, 0x7a, 0xfa, 0xf8, 0x6c, 0x6a, 0x75, 0xb0	/* T__pfx_synthesize_reljump */
	.byte 0x0d, 0x54, 0xc1, 0x6e, 0x15, 0x3b, 0x69, 0x7a, 0xfa, 0xf8, 0x6c, 0x6a, 0x75, 0xb0	/* Tsynthesize_reljump */
	.byte 0x0c, 0x3f, 0x95, 0x6e, 0x15, 0x3b, 0x69, 0x7a, 0xfa, 0xf8, 0x6c, 0x28, 0x6c	/* T__pfx_synthesize_relcall */
	.byte 0x0c, 0x54, 0xc1, 0x6e, 0x15, 0x3b, 0x69, 0x7a, 0xfa, 0xf8, 0x6c, 0x28, 0x6c	/* Tsynthesize_relcall */
	.byte 0x11, 0xc6, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0x69, 0x66, 0xa5, 0x64, 0x69, 0xb8, 0xee, 0x73	/* t__pfx_kprobe_emulate_ifmodifiers */
	.byte 0x11, 0x74, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0x69, 0x66, 0xa5, 0x64, 0x69, 0xb8, 0xee, 0x73	/* tkprobe_emulate_ifmodifiers */
	.byte 0x0b, 0xc6, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0xf8, 0x74	/* t__pfx_kprobe_emulate_ret */
	.byte 0x0b, 0x74, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0xf8, 0x74	/* tkprobe_emulate_ret */
	.byte 0x0b, 0xc6, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0x28, 0x6c	/* t__pfx_kprobe_emulate_call */
	.byte 0x0b, 0x74, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0x28, 0x6c	/* tkprobe_emulate_call */
	.byte 0x0b, 0xc6, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0x6a, 0xb0	/* t__pfx_kprobe_emulate_jmp */
	.byte 0x0b, 0x74, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0x6a, 0xb0	/* tkprobe_emulate_jmp */
	.byte 0x0c, 0xc6, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0x6a, 0x63, 0x63	/* t__pfx_kprobe_emulate_jcc */
	.byte 0x0c, 0x74, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0x6a, 0x63, 0x63	/* tkprobe_emulate_jcc */
	.byte 0x0b, 0xc6, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0xdf, 0x81	/* t__pfx_kprobe_emulate_loop */
	.byte 0x0b, 0x74, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0xdf, 0x81	/* tkprobe_emulate_loop */
	.byte 0x0d, 0xc6, 0x6b, 0x9b, 0x62, 0xfa, 0x70, 0x6f, 0x73, 0xf9, 0x9b, 0x63, 0x3b, 0x73	/* t__pfx_kprobe_post_process */
	.byte 0x0d, 0x74, 0x6b, 0x9b, 0x62, 0xfa, 0x70, 0x6f, 0x73, 0xf9, 0x9b, 0x63, 0x3b, 0x73	/* tkprobe_post_process */
	.byte 0x0c, 0xc6, 0xf8, 0xb7, 0x6d, 0xfa, 0x73, 0xf0, 0x67, 0xd3, 0xd6, 0x65, 0x70	/* t__pfx_resume_singlestep */
	.byte 0x0c, 0x74, 0xf8, 0xb7, 0x6d, 0xfa, 0x73, 0xf0, 0x67, 0xd3, 0xd6, 0x65, 0x70	/* tresume_singlestep */
	.byte 0x0e, 0xbf, 0x6b, 0x9b, 0x62, 0xfa, 0x66, 0x61, 0x0b, 0xf9, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_kprobe_fault_handler */
	.byte 0x0e, 0x54, 0x6b, 0x9b, 0x62, 0xfa, 0x66, 0x61, 0x0b, 0xf9, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Tkprobe_fault_handler */
	.byte 0x11, 0xc6, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0x6a, 0x6d, 0xe2, 0xf0, 0x64, 0x69, 0xf8, 0x7b	/* t__pfx_kprobe_emulate_jmp_indirect */
	.byte 0x11, 0x74, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0x6a, 0x6d, 0xe2, 0xf0, 0x64, 0x69, 0xf8, 0x7b	/* tkprobe_emulate_jmp_indirect */
	.byte 0x10, 0xc6, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0x28, 0xc3, 0xf0, 0x64, 0x69, 0xf8, 0x7b	/* t__pfx_kprobe_emulate_call_indirect */
	.byte 0x10, 0x74, 0x6b, 0x9b, 0x62, 0xfa, 0x65, 0x6d, 0x0b, 0xa1, 0x28, 0xc3, 0xf0, 0x64, 0x69, 0xf8, 0x7b	/* tkprobe_emulate_call_indirect */
	.byte 0x0b, 0xa8, 0xba, 0x74, 0xb9, 0xf6, 0xf0, 0x67, 0xd3, 0xd6, 0x65, 0x70	/* t__pfx_setup_singlestep */
	.byte 0x0b, 0x74, 0xc9, 0x74, 0xb9, 0xf6, 0xf0, 0x67, 0xd3, 0xd6, 0x65, 0x70	/* tsetup_singlestep */
	.byte 0x07, 0xc6, 0xf8, 0x1e, 0xcf, 0x6b, 0x9b, 0x17	/* t__pfx_reenter_kprobe */
	.byte 0x07, 0x74, 0xf8, 0x1e, 0xcf, 0x6b, 0x9b, 0x17	/* treenter_kprobe */
	.byte 0x0e, 0xbf, 0x6b, 0x9b, 0x62, 0xfa, 0xf0, 0x74, 0x33, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_kprobe_int3_handler */
	.byte 0x0e, 0x54, 0x6b, 0x9b, 0x62, 0xfa, 0xf0, 0x74, 0x33, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Tkprobe_int3_handler */
	.byte 0x08, 0xbf, 0x63, 0xcc, 0x5f, 0x62, 0x6f, 0x6f, 0xd6	/* T__pfx_can_boost */
	.byte 0x08, 0x54, 0x63, 0xcc, 0x5f, 0x62, 0x6f, 0x6f, 0xd6	/* Tcan_boost */
	.byte 0x0e, 0xbf, 0xf8, 0xfc, 0xee, 0x25, 0x17, 0xe5, 0xf0, 0x73, 0xea, 0x75, 0x7b, 0xd9, 0x6e	/* T__pfx_recover_probed_instruction */
	.byte 0x0e, 0x54, 0xf8, 0xfc, 0xee, 0x25, 0x17, 0xe5, 0xf0, 0x73, 0xea, 0x75, 0x7b, 0xd9, 0x6e	/* Trecover_probed_instruction */
	.byte 0x05, 0xc6, 0x63, 0xcc, 0x25, 0x17	/* t__pfx_can_probe */
	.byte 0x04, 0x2d, 0xcc, 0x25, 0x17	/* tcan_probe */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0xc7, 0x6a, 0x5d, 0xf9, 0x6b, 0x9b, 0x62, 0xfa, 0x10, 0x72	/* T__pfx_arch_adjust_kprobe_addr */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0xc7, 0x6a, 0x5d, 0xf9, 0x6b, 0x9b, 0x62, 0xfa, 0x10, 0x72	/* Tarch_adjust_kprobe_addr */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0xfe, 0x70, 0xc5, 0xf0, 0x73, 0xea, 0x75, 0x7b, 0xd9, 0x6e	/* T__pfx___copy_instruction */
	.byte 0x0b, 0x2f, 0xfe, 0x70, 0xc5, 0xf0, 0x73, 0xea, 0x75, 0x7b, 0xd9, 0x6e	/* T__copy_instruction */
	.byte 0x0a, 0xc6, 0xca, 0xd0, 0x5f, 0xfe, 0x70, 0xc5, 0x6b, 0x9b, 0x17	/* t__pfx_arch_copy_kprobe */
	.byte 0x0a, 0xdb, 0x72, 0xd0, 0x5f, 0xfe, 0x70, 0xc5, 0x6b, 0x9b, 0x17	/* tarch_copy_kprobe */
	.byte 0x08, 0xbf, 0x08, 0xd5, 0xf0, 0x73, 0x6e, 0xe7, 0x03	/* T__pfx_alloc_insn_page */
	.byte 0x08, 0x54, 0x08, 0xd5, 0xf0, 0x73, 0x6e, 0xe7, 0x03	/* Talloc_insn_page */
	.byte 0x0b, 0xbf, 0xca, 0xd0, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x6b, 0x9b, 0x17	/* T__pfx_arch_prepare_kprobe */
	.byte 0x0b, 0x54, 0xca, 0xd0, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x6b, 0x9b, 0x17	/* Tarch_prepare_kprobe */
	.byte 0x09, 0xbf, 0xca, 0xd0, 0x5f, 0xca, 0xcd, 0x6b, 0x9b, 0x17	/* T__pfx_arch_arm_kprobe */
	.byte 0x09, 0x54, 0xca, 0xd0, 0x5f, 0xca, 0xcd, 0x6b, 0x9b, 0x17	/* Tarch_arm_kprobe */
	.byte 0x0b, 0xbf, 0xca, 0xd0, 0x5f, 0x64, 0xab, 0xca, 0xcd, 0x6b, 0x9b, 0x17	/* T__pfx_arch_disarm_kprobe */
	.byte 0x0b, 0x54, 0xca, 0xd0, 0x5f, 0x64, 0xab, 0xca, 0xcd, 0x6b, 0x9b, 0x17	/* Tarch_disarm_kprobe */
	.byte 0x0a, 0xbf, 0xca, 0xd0, 0x5f, 0xf8, 0xa5, 0x22, 0x6b, 0x9b, 0x17	/* T__pfx_arch_remove_kprobe */
	.byte 0x0a, 0x54, 0xca, 0xd0, 0x5f, 0xf8, 0xa5, 0x22, 0x6b, 0x9b, 0x17	/* Tarch_remove_kprobe */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0x5f, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x6b, 0x9b, 0x17	/* T__pfx_arch_trampoline_kprobe */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0x5f, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x6b, 0x9b, 0x17	/* Tarch_trampoline_kprobe */
	.byte 0x0e, 0x3f, 0xba, 0x74, 0x3a, 0xe6, 0xac, 0x1d, 0x5f, 0xd1, 0x65, 0x63, 0x5e, 0xd9, 0x6e	/* T__pfx_setup_detour_execution */
	.byte 0x0e, 0x54, 0xc9, 0x74, 0x3a, 0xe6, 0xac, 0x1d, 0x5f, 0xd1, 0x65, 0x63, 0x5e, 0xd9, 0x6e	/* Tsetup_detour_execution */
	.byte 0x0d, 0xc6, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0x65, 0xe5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_optimized_callback */
	.byte 0x0d, 0xac, 0x70, 0xc2, 0x6d, 0x69, 0x7a, 0x65, 0xe5, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* toptimized_callback */
	.byte 0x13, 0xc6, 0xfe, 0x70, 0xc5, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0x65, 0xe5, 0xf0, 0x73, 0xea, 0x75, 0x7b, 0xd9, 0x6e, 0x73	/* t__pfx_copy_optimized_instructions */
	.byte 0x13, 0x74, 0xfe, 0x70, 0xc5, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0x65, 0xe5, 0xf0, 0x73, 0xea, 0x75, 0x7b, 0xd9, 0x6e, 0x73	/* tcopy_optimized_instructions */
	.byte 0x0a, 0xc6, 0x63, 0xcc, 0x5f, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0x65	/* t__pfx_can_optimize */
	.byte 0x09, 0x2d, 0xcc, 0x5f, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0x65	/* tcan_optimize */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0xf8, 0xfc, 0xcf, 0x81, 0x74, 0x9b, 0x17, 0xe5, 0xf0, 0x73, 0x6e	/* T__pfx___recover_optprobed_insn */
	.byte 0x0c, 0x2f, 0xf8, 0xfc, 0xcf, 0x81, 0x74, 0x9b, 0x17, 0xe5, 0xf0, 0x73, 0x6e	/* T__recover_optprobed_insn */
	.byte 0x11, 0xbf, 0xca, 0xd0, 0x5f, 0x7e, 0x63, 0xd8, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0x65, 0xe5, 0x6b, 0x9b, 0x17	/* T__pfx_arch_check_optimized_kprobe */
	.byte 0x11, 0x54, 0xca, 0xd0, 0x5f, 0x7e, 0x63, 0xd8, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0x65, 0xe5, 0x6b, 0x9b, 0x17	/* Tarch_check_optimized_kprobe */
	.byte 0x13, 0xbf, 0xca, 0xd0, 0x5f, 0x77, 0xe4, 0x68, 0xf0, 0x5f, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0x65, 0xe5, 0x6b, 0x9b, 0x17	/* T__pfx_arch_within_optimized_kprobe */
	.byte 0x13, 0x54, 0xca, 0xd0, 0x5f, 0x77, 0xe4, 0x68, 0xf0, 0x5f, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0x65, 0xe5, 0x6b, 0x9b, 0x17	/* Tarch_within_optimized_kprobe */
	.byte 0x11, 0xbf, 0xca, 0xd0, 0x5f, 0xf8, 0xa5, 0x22, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0x65, 0xe5, 0x6b, 0x9b, 0x17	/* T__pfx_arch_remove_optimized_kprobe */
	.byte 0x11, 0x54, 0xca, 0xd0, 0x5f, 0xf8, 0xa5, 0x22, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0x65, 0xe5, 0x6b, 0x9b, 0x17	/* Tarch_remove_optimized_kprobe */
	.byte 0x12, 0xbf, 0xca, 0xd0, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0x65, 0xe5, 0x6b, 0x9b, 0x17	/* T__pfx_arch_prepare_optimized_kprobe */
	.byte 0x12, 0x54, 0xca, 0xd0, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0x65, 0xe5, 0x6b, 0x9b, 0x17	/* Tarch_prepare_optimized_kprobe */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0xfa, 0x6b, 0x9b, 0x62, 0x3b	/* T__pfx_arch_optimize_kprobes */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0xfa, 0x6b, 0x9b, 0x62, 0x3b	/* Tarch_optimize_kprobes */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0xd4, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0xfa, 0x6b, 0x9b, 0x17	/* T__pfx_arch_unoptimize_kprobe */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0xd4, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0xfa, 0x6b, 0x9b, 0x17	/* Tarch_unoptimize_kprobe */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0xd4, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0xfa, 0x6b, 0x9b, 0x62, 0x3b	/* T__pfx_arch_unoptimize_kprobes */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0xd4, 0x81, 0xc2, 0x6d, 0x69, 0x7a, 0xfa, 0x6b, 0x9b, 0x62, 0x3b	/* Tarch_unoptimize_kprobes */
	.byte 0x0c, 0xbf, 0x6b, 0x9b, 0x62, 0xfa, 0x66, 0xc8, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_kprobe_ftrace_handler */
	.byte 0x0c, 0x54, 0x6b, 0x9b, 0x62, 0xfa, 0x66, 0xc8, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Tkprobe_ftrace_handler */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x6b, 0x9b, 0x62, 0xfa, 0x66, 0x01	/* T__pfx_arch_prepare_kprobe_ftrace */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x6b, 0x9b, 0x62, 0xfa, 0x66, 0x01	/* Tarch_prepare_kprobe_ftrace */
	.byte 0x0a, 0xbf, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xf8, 0xc0, 0xa1, 0x10	/* T__pfx_apply_relocate_add */
	.byte 0x0a, 0x54, 0x61, 0x70, 0x70, 0x6c, 0xc5, 0xf8, 0xc0, 0xa1, 0x10	/* Tapply_relocate_add */
	.byte 0x0b, 0xbf, 0xa5, 0x64, 0x75, 0xb3, 0x66, 0xf0, 0xe1, 0x69, 0x7a, 0x65	/* T__pfx_module_finalize */
	.byte 0x0b, 0x54, 0xa5, 0x64, 0x75, 0xb3, 0x66, 0xf0, 0xe1, 0x69, 0x7a, 0x65	/* Tmodule_finalize */
	.byte 0x0c, 0xbf, 0xa5, 0x64, 0x75, 0xb3, 0xca, 0xd0, 0x5f, 0x63, 0xd3, 0xcc, 0xb9	/* T__pfx_module_arch_cleanup */
	.byte 0x0c, 0x54, 0xa5, 0x64, 0x75, 0xb3, 0xca, 0xd0, 0x5f, 0x63, 0xd3, 0xcc, 0xb9	/* Tmodule_arch_cleanup */
	.byte 0x0b, 0xc6, 0x65, 0xca, 0x6c, 0xc5, 0x76, 0x67, 0x61, 0x5f, 0x24, 0x65	/* t__pfx_early_vga_write */
	.byte 0x0a, 0x9a, 0xca, 0x6c, 0xc5, 0x76, 0x67, 0x61, 0x5f, 0x24, 0x65	/* tearly_vga_write */
	.byte 0x08, 0xc6, 0xd9, 0xf6, 0xee, 0x69, 0xe1, 0x5f, 0xf0	/* t__pfx_io_serial_in */
	.byte 0x08, 0x74, 0xd9, 0xf6, 0xee, 0x69, 0xe1, 0x5f, 0xf0	/* tio_serial_in */
	.byte 0x09, 0xc6, 0xd9, 0xf6, 0xee, 0x69, 0xe1, 0x5f, 0x6f, 0x5e	/* t__pfx_io_serial_out */
	.byte 0x09, 0x74, 0xd9, 0xf6, 0xee, 0x69, 0xe1, 0x5f, 0x6f, 0x5e	/* tio_serial_out */
	.byte 0x0c, 0xc6, 0xbd, 0x6d, 0x33, 0x32, 0xf6, 0xee, 0x69, 0xe1, 0x5f, 0x6f, 0x5e	/* t__pfx_mem32_serial_out */
	.byte 0x0c, 0x74, 0xbd, 0x6d, 0x33, 0x32, 0xf6, 0xee, 0x69, 0xe1, 0x5f, 0x6f, 0x5e	/* tmem32_serial_out */
	.byte 0x0b, 0xc6, 0xbd, 0x6d, 0x33, 0x32, 0xf6, 0xee, 0x69, 0xe1, 0x5f, 0xf0	/* t__pfx_mem32_serial_in */
	.byte 0x0b, 0x74, 0xbd, 0x6d, 0x33, 0x32, 0xf6, 0xee, 0x69, 0xe1, 0x5f, 0xf0	/* tmem32_serial_in */
	.byte 0x11, 0xc6, 0x65, 0xca, 0x6c, 0x79, 0xf6, 0xee, 0x69, 0xe1, 0xe7, 0x5e, 0x63, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_early_serial_putc.isra.0 */
	.byte 0x10, 0x9a, 0xca, 0x6c, 0x79, 0xf6, 0xee, 0x69, 0xe1, 0xe7, 0x5e, 0x63, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tearly_serial_putc.isra.0 */
	.byte 0x0c, 0xc6, 0x65, 0xca, 0x6c, 0x79, 0xf6, 0xee, 0x69, 0xe1, 0x5f, 0x24, 0x65	/* t__pfx_early_serial_write */
	.byte 0x0b, 0x9a, 0xca, 0x6c, 0x79, 0xf6, 0xee, 0x69, 0xe1, 0x5f, 0x24, 0x65	/* tearly_serial_write */
	.byte 0x0b, 0xbf, 0x69, 0xe0, 0x68, 0x70, 0x65, 0xf9, 0xe8, 0x80, 0xd3, 0x64	/* T__pfx_is_hpet_enabled */
	.byte 0x0b, 0x54, 0x69, 0xe0, 0x68, 0x70, 0x65, 0xf9, 0xe8, 0x80, 0xd3, 0x64	/* Tis_hpet_enabled */
	.byte 0x0d, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x3d, 0xdb, 0x72, 0xf9, 0xfe, 0xd4, 0x74, 0xee	/* t__pfx_hpet_restart_counter */
	.byte 0x0c, 0x15, 0x70, 0x65, 0xf9, 0x3d, 0xdb, 0x72, 0xf9, 0xfe, 0xd4, 0x74, 0xee	/* thpet_restart_counter */
	.byte 0x0e, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0xe8, 0x80, 0xb3, 0xd3, 0x67, 0xeb, 0xc5, 0xf0, 0x74	/* t__pfx_hpet_enable_legacy_int */
	.byte 0x0d, 0x15, 0x70, 0x65, 0xf9, 0xe8, 0x80, 0xb3, 0xd3, 0x67, 0xeb, 0xc5, 0xf0, 0x74	/* thpet_enable_legacy_int */
	.byte 0x13, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x63, 0x6c, 0x6b, 0xbc, 0xf9, 0xc9, 0xf9, 0xd6, 0xa1, 0x6f, 0xb4, 0x73, 0xad, 0x74	/* t__pfx_hpet_clkevt_set_state_oneshot */
	.byte 0x12, 0x15, 0x70, 0x65, 0xf9, 0x63, 0x6c, 0x6b, 0xbc, 0xf9, 0xc9, 0xf9, 0xd6, 0xa1, 0x6f, 0xb4, 0x73, 0xad, 0x74	/* thpet_clkevt_set_state_oneshot */
	.byte 0x14, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x63, 0x6c, 0x6b, 0xbc, 0xf9, 0xc9, 0xf9, 0xd6, 0xa1, 0x73, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_hpet_clkevt_set_state_shutdown */
	.byte 0x13, 0x15, 0x70, 0x65, 0xf9, 0x63, 0x6c, 0x6b, 0xbc, 0xf9, 0xc9, 0xf9, 0xd6, 0xa1, 0x73, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* thpet_clkevt_set_state_shutdown */
	.byte 0x11, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x63, 0x6c, 0x6b, 0xbc, 0xf9, 0xc9, 0xf9, 0x6e, 0xd1, 0xf9, 0xbc, 0x1e	/* t__pfx_hpet_clkevt_set_next_event */
	.byte 0x10, 0x15, 0x70, 0x65, 0xf9, 0x63, 0x6c, 0x6b, 0xbc, 0xf9, 0xc9, 0xf9, 0x6e, 0xd1, 0xf9, 0xbc, 0x1e	/* thpet_clkevt_set_next_event */
	.byte 0x0b, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0xf0, 0x99, 0x63, 0x3c, 0xbc, 0x1e	/* t__pfx_hpet_init_clockevent */
	.byte 0x0a, 0x15, 0x70, 0x65, 0xf9, 0xf0, 0x99, 0x63, 0x3c, 0xbc, 0x1e	/* thpet_init_clockevent */
	.byte 0x0a, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x20, 0xcb, 0xd4, 0xdd, 0x16	/* t__pfx_hpet_msi_unmask */
	.byte 0x09, 0x15, 0x70, 0x65, 0xf9, 0x20, 0xcb, 0xd4, 0xdd, 0x16	/* thpet_msi_unmask */
	.byte 0x09, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x20, 0xcb, 0xdd, 0x16	/* t__pfx_hpet_msi_mask */
	.byte 0x08, 0x15, 0x70, 0x65, 0xf9, 0x20, 0xcb, 0xdd, 0x16	/* thpet_msi_mask */
	.byte 0x0c, 0xbf, 0x68, 0x70, 0x65, 0xf9, 0x72, 0x74, 0xd5, 0xc2, 0x6d, 0xcf, 0x8d	/* T__pfx_hpet_rtc_timer_init */
	.byte 0x0c, 0x54, 0x68, 0x70, 0x65, 0xf9, 0x72, 0x74, 0xd5, 0xc2, 0x6d, 0xcf, 0x8d	/* Thpet_rtc_timer_init */
	.byte 0x12, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x20, 0xcb, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0xf9, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_hpet_msi_interrupt_handler */
	.byte 0x11, 0x15, 0x70, 0x65, 0xf9, 0x20, 0xcb, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0xf9, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* thpet_msi_interrupt_handler */
	.byte 0x11, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x63, 0x6c, 0x6b, 0xbc, 0xf9, 0xd3, 0x67, 0xeb, 0xc5, 0xf8, 0xb7, 0xbd	/* t__pfx_hpet_clkevt_legacy_resume */
	.byte 0x10, 0x15, 0x70, 0x65, 0xf9, 0x63, 0x6c, 0x6b, 0xbc, 0xf9, 0xd3, 0x67, 0xeb, 0xc5, 0xf8, 0xb7, 0xbd	/* thpet_clkevt_legacy_resume */
	.byte 0x0d, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0xf8, 0xb7, 0x6d, 0xfa, 0xfe, 0xd4, 0x74, 0xee	/* t__pfx_hpet_resume_counter */
	.byte 0x0c, 0x15, 0x70, 0x65, 0xf9, 0xf8, 0xb7, 0x6d, 0xfa, 0xfe, 0xd4, 0x74, 0xee	/* thpet_resume_counter */
	.byte 0x13, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x63, 0x6c, 0x6b, 0xbc, 0xf9, 0xc9, 0xf9, 0xd6, 0xa1, 0x70, 0xee, 0xd9, 0x64, 0xa3	/* t__pfx_hpet_clkevt_set_state_periodic */
	.byte 0x12, 0x15, 0x70, 0x65, 0xf9, 0x63, 0x6c, 0x6b, 0xbc, 0xf9, 0xc9, 0xf9, 0xd6, 0xa1, 0x70, 0xee, 0xd9, 0x64, 0xa3	/* thpet_clkevt_set_state_periodic */
	.byte 0x0a, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x92, 0x68, 0xe2, 0xe6, 0xc7	/* t__pfx_hpet_cpuhp_dead */
	.byte 0x09, 0x15, 0x70, 0x65, 0xf9, 0x92, 0x68, 0xe2, 0xe6, 0xc7	/* thpet_cpuhp_dead */
	.byte 0x0f, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x63, 0x6c, 0x6b, 0xbc, 0xf9, 0x20, 0xcb, 0xf8, 0xb7, 0xbd	/* t__pfx_hpet_clkevt_msi_resume */
	.byte 0x0e, 0x15, 0x70, 0x65, 0xf9, 0x63, 0x6c, 0x6b, 0xbc, 0xf9, 0x20, 0xcb, 0xf8, 0xb7, 0xbd	/* thpet_clkevt_msi_resume */
	.byte 0x09, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x20, 0xcb, 0x87, 0x65	/* t__pfx_hpet_msi_free */
	.byte 0x08, 0x15, 0x70, 0x65, 0xf9, 0x20, 0xcb, 0x87, 0x65	/* thpet_msi_free */
	.byte 0x08, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x20, 0xcb, 0x8d	/* t__pfx_hpet_msi_init */
	.byte 0x07, 0x15, 0x70, 0x65, 0xf9, 0x20, 0xcb, 0x8d	/* thpet_msi_init */
	.byte 0x0e, 0xbf, 0x68, 0x70, 0x65, 0xf9, 0x72, 0x74, 0xd5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* T__pfx_hpet_rtc_interrupt */
	.byte 0x0e, 0x54, 0x68, 0x70, 0x65, 0xf9, 0x72, 0x74, 0xd5, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* Thpet_rtc_interrupt */
	.byte 0x07, 0xc6, 0xf8, 0x05, 0x68, 0x70, 0x65, 0x74	/* t__pfx_read_hpet */
	.byte 0x07, 0x74, 0xf8, 0x05, 0x68, 0x70, 0x65, 0x74	/* tread_hpet */
	.byte 0x0c, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x92, 0x68, 0xe2, 0x6f, 0x6e, 0x88, 0x65	/* t__pfx_hpet_cpuhp_online */
	.byte 0x0b, 0x15, 0x70, 0x65, 0xf9, 0x92, 0x68, 0xe2, 0x6f, 0x6e, 0x88, 0x65	/* thpet_cpuhp_online */
	.byte 0x0b, 0xc6, 0x68, 0x70, 0x65, 0xf9, 0x20, 0xcb, 0x24, 0xfa, 0x20, 0x67	/* t__pfx_hpet_msi_write_msg */
	.byte 0x0a, 0x15, 0x70, 0x65, 0xf9, 0x20, 0xcb, 0x24, 0xfa, 0x20, 0x67	/* thpet_msi_write_msg */
	.byte 0x10, 0xbf, 0x68, 0x70, 0x65, 0xf9, 0x72, 0x74, 0xd5, 0x64, 0xde, 0x70, 0x70, 0x65, 0xe5, 0xa7, 0x71	/* T__pfx_hpet_rtc_dropped_irq */
	.byte 0x10, 0x54, 0x68, 0x70, 0x65, 0xf9, 0x72, 0x74, 0xd5, 0x64, 0xde, 0x70, 0x70, 0x65, 0xe5, 0xa7, 0x71	/* Thpet_rtc_dropped_irq */
	.byte 0x0f, 0xbf, 0x68, 0x70, 0x65, 0xf9, 0xd4, 0x18, 0xcf, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_hpet_unregister_irq_handler */
	.byte 0x0f, 0x54, 0x68, 0x70, 0x65, 0xf9, 0xd4, 0x18, 0xcf, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Thpet_unregister_irq_handler */
	.byte 0x0c, 0xbf, 0x68, 0x70, 0x65, 0xf9, 0xc9, 0xf9, 0xe1, 0xca, 0xcd, 0xc2, 0xbd	/* T__pfx_hpet_set_alarm_time */
	.byte 0x0c, 0x54, 0x68, 0x70, 0x65, 0xf9, 0xc9, 0xf9, 0xe1, 0xca, 0xcd, 0xc2, 0xbd	/* Thpet_set_alarm_time */
	.byte 0x0e, 0xbf, 0x68, 0x70, 0x65, 0xf9, 0x18, 0xcf, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_hpet_register_irq_handler */
	.byte 0x0e, 0x54, 0x68, 0x70, 0x65, 0xf9, 0x18, 0xcf, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Thpet_register_irq_handler */
	.byte 0x0f, 0xbf, 0x68, 0x70, 0x65, 0xf9, 0xc9, 0xf9, 0x70, 0xee, 0xd9, 0x64, 0x69, 0xd5, 0x87, 0x71	/* T__pfx_hpet_set_periodic_freq */
	.byte 0x0f, 0x54, 0x68, 0x70, 0x65, 0xf9, 0xc9, 0xf9, 0x70, 0xee, 0xd9, 0x64, 0x69, 0xd5, 0x87, 0x71	/* Thpet_set_periodic_freq */
	.byte 0x0f, 0xbf, 0x68, 0x70, 0x65, 0xf9, 0xdd, 0x73, 0xd8, 0x72, 0x74, 0xd5, 0xa7, 0x93, 0x62, 0xe4	/* T__pfx_hpet_mask_rtc_irq_bit */
	.byte 0x0f, 0x54, 0x68, 0x70, 0x65, 0xf9, 0xdd, 0x73, 0xd8, 0x72, 0x74, 0xd5, 0xa7, 0x93, 0x62, 0xe4	/* Thpet_mask_rtc_irq_bit */
	.byte 0x0e, 0xbf, 0x68, 0x70, 0x65, 0xf9, 0xc9, 0xf9, 0x72, 0x74, 0xd5, 0xa7, 0x93, 0x62, 0xe4	/* T__pfx_hpet_set_rtc_irq_bit */
	.byte 0x0e, 0x54, 0x68, 0x70, 0x65, 0xf9, 0xc9, 0xf9, 0x72, 0x74, 0xd5, 0xa7, 0x93, 0x62, 0xe4	/* Thpet_set_rtc_irq_bit */
	.byte 0x08, 0xbf, 0x68, 0x70, 0x65, 0xf9, 0xf8, 0xc7, 0x6c	/* T__pfx_hpet_readl */
	.byte 0x08, 0x54, 0x68, 0x70, 0x65, 0xf9, 0xf8, 0xc7, 0x6c	/* Thpet_readl */
	.byte 0x09, 0xbf, 0x68, 0x70, 0x65, 0xf9, 0x64, 0xab, 0x80, 0xd3	/* T__pfx_hpet_disable */
	.byte 0x09, 0x54, 0x68, 0x70, 0x65, 0xf9, 0x64, 0xab, 0x80, 0xd3	/* Thpet_disable */
	.byte 0x09, 0xbf, 0x61, 0x6d, 0xe5, 0x6e, 0xdc, 0x6e, 0x75, 0x6d	/* T__pfx_amd_nb_num */
	.byte 0x09, 0x54, 0x61, 0x6d, 0xe5, 0x6e, 0xdc, 0x6e, 0x75, 0x6d	/* Tamd_nb_num */
	.byte 0x0e, 0xbf, 0x61, 0x6d, 0xe5, 0x6e, 0xdc, 0x68, 0x61, 0xe0, 0x66, 0x65, 0xe9, 0x75, 0xf8	/* T__pfx_amd_nb_has_feature */
	.byte 0x0e, 0x54, 0x61, 0x6d, 0xe5, 0x6e, 0xdc, 0x68, 0x61, 0xe0, 0x66, 0x65, 0xe9, 0x75, 0xf8	/* Tamd_nb_has_feature */
	.byte 0x0b, 0xbf, 0xb6, 0x64, 0xfa, 0xac, 0x5f, 0x61, 0x6d, 0xe5, 0x6e, 0x62	/* T__pfx_node_to_amd_nb */
	.byte 0x0b, 0x54, 0xb6, 0x64, 0xfa, 0xac, 0x5f, 0x61, 0x6d, 0xe5, 0x6e, 0x62	/* Tnode_to_amd_nb */
	.byte 0x0c, 0xbf, 0x61, 0x6d, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0xca, 0x74, 0x73	/* T__pfx_amd_flush_garts */
	.byte 0x0c, 0x54, 0x61, 0x6d, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0xca, 0x74, 0x73	/* Tamd_flush_garts */
	.byte 0x0a, 0x29, 0x5f, 0x61, 0x6d, 0x64, 0xf6, 0x6d, 0x7c, 0x72, 0x77	/* t__pfx___amd_smn_rw */
	.byte 0x0a, 0x74, 0xff, 0x61, 0x6d, 0x64, 0xf6, 0x6d, 0x7c, 0x72, 0x77	/* t__amd_smn_rw */
	.byte 0x09, 0xbf, 0x61, 0x6d, 0x64, 0xf6, 0x6d, 0x7c, 0x24, 0x65	/* T__pfx_amd_smn_write */
	.byte 0x09, 0x54, 0x61, 0x6d, 0x64, 0xf6, 0x6d, 0x7c, 0x24, 0x65	/* Tamd_smn_write */
	.byte 0x09, 0xbf, 0x61, 0x6d, 0x64, 0xf6, 0x6d, 0x7c, 0xf8, 0xc7	/* T__pfx_amd_smn_read */
	.byte 0x09, 0x54, 0x61, 0x6d, 0x64, 0xf6, 0x6d, 0x7c, 0xf8, 0xc7	/* Tamd_smn_read */
	.byte 0x0c, 0x29, 0x5f, 0xb8, 0x1a, 0xee, 0x72, 0xe9, 0x75, 0xcd, 0x36, 0x38, 0x38	/* t__pfx___fix_erratum_688 */
	.byte 0x0c, 0x74, 0xff, 0xb8, 0x1a, 0xee, 0x72, 0xe9, 0x75, 0xcd, 0x36, 0x38, 0x38	/* t__fix_erratum_688 */
	.byte 0x0d, 0xbf, 0x61, 0x6d, 0xe5, 0xb2, 0x6d, 0x6d, 0x98, 0xb8, 0xa6, 0x72, 0xcc, 0xda	/* T__pfx_amd_get_mmconfig_range */
	.byte 0x0d, 0x54, 0x61, 0x6d, 0xe5, 0xb2, 0x6d, 0x6d, 0x98, 0xb8, 0xa6, 0x72, 0xcc, 0xda	/* Tamd_get_mmconfig_range */
	.byte 0x0b, 0xbf, 0x61, 0x6d, 0xe5, 0xb2, 0xb7, 0x62, 0x63, 0xeb, 0x68, 0x3b	/* T__pfx_amd_get_subcaches */
	.byte 0x0b, 0x54, 0x61, 0x6d, 0xe5, 0xb2, 0xb7, 0x62, 0x63, 0xeb, 0x68, 0x3b	/* Tamd_get_subcaches */
	.byte 0x0b, 0xbf, 0x61, 0x6d, 0x64, 0x1f, 0xb7, 0x62, 0x63, 0xeb, 0x68, 0x3b	/* T__pfx_amd_set_subcaches */
	.byte 0x0b, 0x54, 0x61, 0x6d, 0x64, 0x1f, 0xb7, 0x62, 0x63, 0xeb, 0x68, 0x3b	/* Tamd_set_subcaches */
	.byte 0x1a, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x76, 0x65, 0xff, 0x5f, 0x6b, 0x76, 0xcd, 0x76, 0x92, 0x5f, 0xab, 0xe7, 0xf8, 0x65, 0xb0, 0x9a, 0x64	/* T__pfx___raw_callee_save___kvm_vcpu_is_preempted */
	.byte 0x18, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x76, 0x65, 0xff, 0x5f, 0x6b, 0x76, 0xcd, 0x76, 0x92, 0x5f, 0xab, 0xe7, 0xf8, 0x65, 0xb0, 0x9a, 0x64	/* T__raw_callee_save___kvm_vcpu_is_preempted */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72	/* t__pfx_paravirt_write_msr */
	.byte 0x0a, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x24, 0xfa, 0x20, 0x72	/* tparavirt_write_msr */
	.byte 0x08, 0xc6, 0x6b, 0x76, 0xcd, 0x3e, 0xe6, 0x1b, 0x79	/* t__pfx_kvm_io_delay */
	.byte 0x08, 0x74, 0x6b, 0x76, 0xcd, 0x3e, 0xe6, 0x1b, 0x79	/* tkvm_io_delay */
	.byte 0x0a, 0xc6, 0x6b, 0x76, 0x6d, 0xf6, 0x9a, 0xe1, 0x5f, 0x63, 0x3c	/* t__pfx_kvm_steal_clock */
	.byte 0x0a, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0x9a, 0xe1, 0x5f, 0x63, 0x3c	/* tkvm_steal_clock */
	.byte 0x11, 0xc6, 0x6b, 0x76, 0x6d, 0xf6, 0xbc, 0x5f, 0x68, 0x63, 0xe7, 0x61, 0x21, 0xe8, 0x63, 0x2a, 0xe9, 0x5d	/* t__pfx_kvm_sev_hc_page_enc_status */
	.byte 0x11, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0xbc, 0x5f, 0x68, 0x63, 0xe7, 0x61, 0x21, 0xe8, 0x63, 0x2a, 0xe9, 0x5d	/* tkvm_sev_hc_page_enc_status */
	.byte 0x10, 0xc6, 0x6b, 0x76, 0x6d, 0xf6, 0xbc, 0x5f, 0x65, 0xe0, 0x68, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* t__pfx_kvm_sev_es_hcall_finish */
	.byte 0x10, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0xbc, 0x5f, 0x65, 0xe0, 0x68, 0x28, 0xc3, 0x66, 0xf0, 0xab, 0x68	/* tkvm_sev_es_hcall_finish */
	.byte 0x06, 0xc6, 0x6b, 0x76, 0xcd, 0x13, 0xe4	/* t__pfx_kvm_wait */
	.byte 0x06, 0x74, 0x6b, 0x76, 0xcd, 0x13, 0xe4	/* tkvm_wait */
	.byte 0x11, 0xc6, 0x6b, 0x76, 0x6d, 0xf6, 0xbc, 0x5f, 0x65, 0xe0, 0x68, 0x28, 0x6c, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* t__pfx_kvm_sev_es_hcall_prepare */
	.byte 0x11, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0xbc, 0x5f, 0x65, 0xe0, 0x68, 0x28, 0x6c, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* tkvm_sev_es_hcall_prepare */
	.byte 0x14, 0xbf, 0x6b, 0x76, 0xcd, 0x61, 0xc1, 0x6e, 0xd5, 0xef, 0x5f, 0xdb, 0x73, 0xd8, 0x13, 0x99, 0x73, 0x7e, 0x64, 0x75, 0xd3	/* T__pfx_kvm_async_pf_task_wait_schedule */
	.byte 0x14, 0x54, 0x6b, 0x76, 0xcd, 0x61, 0xc1, 0x6e, 0xd5, 0xef, 0x5f, 0xdb, 0x73, 0xd8, 0x13, 0x99, 0x73, 0x7e, 0x64, 0x75, 0xd3	/* Tkvm_async_pf_task_wait_schedule */
	.byte 0x0c, 0xc6, 0x61, 0xef, 0x5f, 0xdb, 0x73, 0xd8, 0x13, 0x6b, 0xfa, 0x6f, 0xb4	/* t__pfx_apf_task_wake_one */
	.byte 0x0b, 0xdb, 0xef, 0x5f, 0xdb, 0x73, 0xd8, 0x13, 0x6b, 0xfa, 0x6f, 0xb4	/* tapf_task_wake_one */
	.byte 0x0c, 0xc6, 0x61, 0xef, 0x5f, 0xdb, 0x73, 0xd8, 0x13, 0x6b, 0xfa, 0xe1, 0x6c	/* t__pfx_apf_task_wake_all */
	.byte 0x0b, 0xdb, 0xef, 0x5f, 0xdb, 0x73, 0xd8, 0x13, 0x6b, 0xfa, 0xe1, 0x6c	/* tapf_task_wake_all */
	.byte 0x0e, 0xc6, 0x6b, 0x76, 0xcd, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* t__pfx_kvm_flush_tlb_multi */
	.byte 0x0e, 0x74, 0x6b, 0x76, 0xcd, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* tkvm_flush_tlb_multi */
	.byte 0x11, 0xc6, 0x6b, 0x76, 0xcd, 0x67, 0x75, 0x3b, 0xf9, 0x61, 0x70, 0x69, 0xd5, 0x65, 0x6f, 0xcb, 0x24, 0x65	/* t__pfx_kvm_guest_apic_eoi_write */
	.byte 0x11, 0x74, 0x6b, 0x76, 0xcd, 0x67, 0x75, 0x3b, 0xf9, 0x61, 0x70, 0x69, 0xd5, 0x65, 0x6f, 0xcb, 0x24, 0x65	/* tkvm_guest_apic_eoi_write */
	.byte 0x10, 0xc6, 0x6b, 0x76, 0x6d, 0xe7, 0x76, 0x5f, 0xf8, 0x62, 0x6f, 0x6f, 0xf9, 0xb6, 0xc2, 0x66, 0x79	/* t__pfx_kvm_pv_reboot_notify */
	.byte 0x10, 0x74, 0x6b, 0x76, 0x6d, 0xe7, 0x76, 0x5f, 0xf8, 0x62, 0x6f, 0x6f, 0xf9, 0xb6, 0xc2, 0x66, 0x79	/* tkvm_pv_reboot_notify */
	.byte 0x0f, 0xbf, 0x6b, 0x76, 0xcd, 0x61, 0xc1, 0x6e, 0xd5, 0xef, 0x5f, 0xdb, 0x73, 0xd8, 0x13, 0x0e	/* T__pfx_kvm_async_pf_task_wake */
	.byte 0x0f, 0x54, 0x6b, 0x76, 0xcd, 0x61, 0xc1, 0x6e, 0xd5, 0xef, 0x5f, 0xdb, 0x73, 0xd8, 0x13, 0x0e	/* Tkvm_async_pf_task_wake */
	.byte 0x0f, 0xc6, 0x6b, 0x76, 0x6d, 0xf6, 0xb0, 0xf6, 0xe8, 0xe5, 0x28, 0xc3, 0x2b, 0xd5, 0x0c, 0x69	/* t__pfx_kvm_smp_send_call_func_ipi */
	.byte 0x0f, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0xb0, 0xf6, 0xe8, 0xe5, 0x28, 0xc3, 0x2b, 0xd5, 0x0c, 0x69	/* tkvm_smp_send_call_func_ipi */
	.byte 0x08, 0xc6, 0x6b, 0x76, 0xcd, 0x6b, 0xa3, 0xd8, 0x92	/* t__pfx_kvm_kick_cpu */
	.byte 0x08, 0x74, 0x6b, 0x76, 0xcd, 0x6b, 0xa3, 0xd8, 0x92	/* tkvm_kick_cpu */
	.byte 0x08, 0x29, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* t__pfx___send_ipi_mask */
	.byte 0x09, 0x74, 0xff, 0x73, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* t__send_ipi_mask */
	.byte 0x13, 0xc6, 0x6b, 0x76, 0x6d, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* t__pfx_kvm_send_ipi_mask_allbutself */
	.byte 0x13, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x73, 0xd8, 0xe1, 0x6c, 0xa2, 0x74, 0xc9, 0x6c, 0x66	/* tkvm_send_ipi_mask_allbutself */
	.byte 0x0b, 0xc6, 0x6b, 0x76, 0x6d, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* t__pfx_kvm_send_ipi_mask */
	.byte 0x0b, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0xe8, 0xe5, 0x69, 0x85, 0xdd, 0x16	/* tkvm_send_ipi_mask */
	.byte 0x0b, 0x29, 0x5f, 0x6b, 0x76, 0xcd, 0x92, 0x69, 0xe5, 0x62, 0x61, 0xc9	/* t__pfx___kvm_cpuid_base */
	.byte 0x0a, 0x74, 0xae, 0x76, 0xcd, 0x92, 0x69, 0xe5, 0x62, 0x61, 0xc9	/* t__kvm_cpuid_base */
	.byte 0x0a, 0xc6, 0x6b, 0x76, 0xcd, 0x92, 0x69, 0xe5, 0x62, 0x61, 0xc9	/* t__pfx_kvm_cpuid_base */
	.byte 0x0a, 0x74, 0x6b, 0x76, 0xcd, 0x92, 0x69, 0xe5, 0x62, 0x61, 0xc9	/* tkvm_cpuid_base */
	.byte 0x0f, 0xbf, 0x6b, 0x76, 0x6d, 0xe7, 0xca, 0x61, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x80, 0xd3	/* T__pfx_kvm_para_available */
	.byte 0x0f, 0x54, 0x6b, 0x76, 0x6d, 0xe7, 0xca, 0x61, 0x5f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x80, 0xd3	/* Tkvm_para_available */
	.byte 0x0e, 0xbf, 0x6b, 0x76, 0xcd, 0xca, 0xd0, 0xe7, 0xca, 0x61, 0x5f, 0x68, 0xf0, 0x74, 0x73	/* T__pfx_kvm_arch_para_hints */
	.byte 0x0e, 0x54, 0x6b, 0x76, 0xcd, 0xca, 0xd0, 0xe7, 0xca, 0x61, 0x5f, 0x68, 0xf0, 0x74, 0x73	/* Tkvm_arch_para_hints */
	.byte 0x0f, 0xc6, 0x6b, 0x76, 0xcd, 0xe8, 0x80, 0xb3, 0xad, 0x73, 0xf9, 0x68, 0xe1, 0x06, 0x7f, 0x6c	/* t__pfx_kvm_enable_host_haltpoll */
	.byte 0x0f, 0x74, 0x6b, 0x76, 0xcd, 0xe8, 0x80, 0xb3, 0xad, 0x73, 0xf9, 0x68, 0xe1, 0x06, 0x7f, 0x6c	/* tkvm_enable_host_haltpoll */
	.byte 0x10, 0xc6, 0x6b, 0x76, 0xcd, 0x64, 0xab, 0x80, 0xb3, 0xad, 0x73, 0xf9, 0x68, 0xe1, 0x06, 0x7f, 0x6c	/* t__pfx_kvm_disable_host_haltpoll */
	.byte 0x10, 0x74, 0x6b, 0x76, 0xcd, 0x64, 0xab, 0x80, 0xb3, 0xad, 0x73, 0xf9, 0x68, 0xe1, 0x06, 0x7f, 0x6c	/* tkvm_disable_host_haltpoll */
	.byte 0x15, 0x29, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x6b, 0x76, 0xcd, 0x61, 0xc1, 0x6e, 0x63, 0xef, 0x5f, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__pfx___sysvec_kvm_asyncpf_interrupt */
	.byte 0x16, 0x74, 0xff, 0xc1, 0x73, 0x76, 0x65, 0xd5, 0x6b, 0x76, 0xcd, 0x61, 0xc1, 0x6e, 0x63, 0xef, 0x5f, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* t__sysvec_kvm_asyncpf_interrupt */
	.byte 0x17, 0xbf, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x6b, 0x76, 0xcd, 0x61, 0xc1, 0x6e, 0x63, 0xef, 0x5f, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* T__pfx_fred_sysvec_kvm_asyncpf_interrupt */
	.byte 0x17, 0x54, 0x87, 0x64, 0x95, 0x73, 0x76, 0x65, 0xd5, 0x6b, 0x76, 0xcd, 0x61, 0xc1, 0x6e, 0x63, 0xef, 0x5f, 0xf0, 0x74, 0xee, 0x72, 0xb9, 0x74	/* Tfred_sysvec_kvm_asyncpf_interrupt */
	.byte 0x0f, 0xbf, 0x6b, 0x76, 0xcd, 0xca, 0xd0, 0xe7, 0xca, 0x61, 0x5f, 0x66, 0x65, 0xe9, 0x75, 0x3d	/* T__pfx_kvm_arch_para_features */
	.byte 0x0f, 0x54, 0x6b, 0x76, 0xcd, 0xca, 0xd0, 0xe7, 0xca, 0x61, 0x5f, 0x66, 0x65, 0xe9, 0x75, 0x3d	/* Tkvm_arch_para_features */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0x5f, 0x68, 0xe1, 0x06, 0x7f, 0xc3, 0x64, 0xab, 0x80, 0xd3	/* T__pfx_arch_haltpoll_disable */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0x5f, 0x68, 0xe1, 0x06, 0x7f, 0xc3, 0x64, 0xab, 0x80, 0xd3	/* Tarch_haltpoll_disable */
	.byte 0x0c, 0xbf, 0xca, 0xd0, 0x5f, 0x68, 0xe1, 0x06, 0x7f, 0xc3, 0xe8, 0x80, 0xd3	/* T__pfx_arch_haltpoll_enable */
	.byte 0x0c, 0x54, 0xca, 0xd0, 0x5f, 0x68, 0xe1, 0x06, 0x7f, 0xc3, 0xe8, 0x80, 0xd3	/* Tarch_haltpoll_enable */
	.byte 0x0f, 0xc6, 0x6b, 0x76, 0xcd, 0x67, 0x75, 0x3b, 0xf9, 0x92, 0x5f, 0x6f, 0x66, 0x66, 0x88, 0x65	/* t__pfx_kvm_guest_cpu_offline */
	.byte 0x0f, 0x74, 0x6b, 0x76, 0xcd, 0x67, 0x75, 0x3b, 0xf9, 0x92, 0x5f, 0x6f, 0x66, 0x66, 0x88, 0x65	/* tkvm_guest_cpu_offline */
	.byte 0x0e, 0xc6, 0x6b, 0x76, 0xcd, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_kvm_crash_shutdown */
	.byte 0x0e, 0x74, 0x6b, 0x76, 0xcd, 0x63, 0xb5, 0x73, 0x68, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* tkvm_crash_shutdown */
	.byte 0x12, 0xc6, 0x6b, 0x76, 0x6d, 0xe7, 0x76, 0x5f, 0x67, 0x75, 0x3b, 0xf9, 0x92, 0x5f, 0xf8, 0x62, 0x6f, 0x6f, 0x74	/* t__pfx_kvm_pv_guest_cpu_reboot */
	.byte 0x12, 0x74, 0x6b, 0x76, 0x6d, 0xe7, 0x76, 0x5f, 0x67, 0x75, 0x3b, 0xf9, 0x92, 0x5f, 0xf8, 0x62, 0x6f, 0x6f, 0x74	/* tkvm_pv_guest_cpu_reboot */
	.byte 0x09, 0xc6, 0x6b, 0x76, 0x6d, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* t__pfx_kvm_suspend */
	.byte 0x09, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0x5d, 0x70, 0xe8, 0x64	/* tkvm_suspend */
	.byte 0x0e, 0xc6, 0x6b, 0x76, 0xcd, 0x92, 0x5f, 0xa9, 0x77, 0x6e, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* t__pfx_kvm_cpu_down_prepare */
	.byte 0x0e, 0x74, 0x6b, 0x76, 0xcd, 0x92, 0x5f, 0xa9, 0x77, 0x6e, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* tkvm_cpu_down_prepare */
	.byte 0x0b, 0xc6, 0x6b, 0x76, 0xcd, 0x67, 0x75, 0x3b, 0xf9, 0x92, 0x5f, 0x8d	/* t__pfx_kvm_guest_cpu_init */
	.byte 0x0b, 0x74, 0x6b, 0x76, 0xcd, 0x67, 0x75, 0x3b, 0xf9, 0x92, 0x5f, 0x8d	/* tkvm_guest_cpu_init */
	.byte 0x0a, 0xc6, 0x6b, 0x76, 0xcd, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* t__pfx_kvm_cpu_online */
	.byte 0x0a, 0x74, 0x6b, 0x76, 0xcd, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* tkvm_cpu_online */
	.byte 0x07, 0xc6, 0x6b, 0x76, 0xcd, 0xf8, 0xb7, 0xbd	/* t__pfx_kvm_resume */
	.byte 0x07, 0x74, 0x6b, 0x76, 0xcd, 0xf8, 0xb7, 0xbd	/* tkvm_resume */
	.byte 0x0a, 0xc6, 0x6b, 0x76, 0x6d, 0x1f, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* t__pfx_kvm_set_wallclock */
	.byte 0x0a, 0x74, 0x6b, 0x76, 0x6d, 0x1f, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* tkvm_set_wallclock */
	.byte 0x09, 0xc6, 0x6b, 0x76, 0xcd, 0x63, 0xe0, 0xe8, 0x80, 0xd3	/* t__pfx_kvm_cs_enable */
	.byte 0x09, 0x74, 0x6b, 0x76, 0xcd, 0x63, 0xe0, 0xe8, 0x80, 0xd3	/* tkvm_cs_enable */
	.byte 0x0e, 0xc6, 0x6b, 0x76, 0x6d, 0xf6, 0x61, 0x22, 0x73, 0x7e, 0xe5, 0x63, 0x3c, 0x2a, 0x86	/* t__pfx_kvm_save_sched_clock_state */
	.byte 0x0e, 0x74, 0x6b, 0x76, 0x6d, 0xf6, 0x61, 0x22, 0x73, 0x7e, 0xe5, 0x63, 0x3c, 0x2a, 0x86	/* tkvm_save_sched_clock_state */
	.byte 0x0c, 0xc6, 0x6b, 0x76, 0x6d, 0x63, 0x3c, 0xba, 0x74, 0xb9, 0xe7, 0xee, 0x92	/* t__pfx_kvmclock_setup_percpu */
	.byte 0x0c, 0x74, 0x6b, 0x76, 0x6d, 0x63, 0x3c, 0xba, 0x74, 0xb9, 0xe7, 0xee, 0x92	/* tkvmclock_setup_percpu */
	.byte 0x09, 0xc6, 0x6b, 0x76, 0xcd, 0x63, 0xc0, 0xd8, 0xf8, 0xc7	/* t__pfx_kvm_clock_read */
	.byte 0x09, 0x74, 0x6b, 0x76, 0xcd, 0x63, 0xc0, 0xd8, 0xf8, 0xc7	/* tkvm_clock_read */
	.byte 0x0d, 0xc6, 0x6b, 0x76, 0xcd, 0x63, 0xc0, 0xd8, 0xb2, 0x63, 0x79, 0x63, 0xd3, 0x73	/* t__pfx_kvm_clock_get_cycles */
	.byte 0x0d, 0x74, 0x6b, 0x76, 0xcd, 0x63, 0xc0, 0xd8, 0xb2, 0x63, 0x79, 0x63, 0xd3, 0x73	/* tkvm_clock_get_cycles */
	.byte 0x0b, 0xc6, 0x6b, 0x76, 0xcd, 0xb2, 0x74, 0x73, 0xd5, 0x6b, 0x68, 0x7a	/* t__pfx_kvm_get_tsc_khz */
	.byte 0x0b, 0x74, 0x6b, 0x76, 0xcd, 0xb2, 0x74, 0x73, 0xd5, 0x6b, 0x68, 0x7a	/* tkvm_get_tsc_khz */
	.byte 0x08, 0xc6, 0x6b, 0x76, 0xcd, 0x18, 0xcf, 0x63, 0x3c	/* t__pfx_kvm_register_clock */
	.byte 0x08, 0x74, 0x6b, 0x76, 0xcd, 0x18, 0xcf, 0x63, 0x3c	/* tkvm_register_clock */
	.byte 0x0e, 0xc6, 0x6b, 0x76, 0x6d, 0xba, 0x74, 0xb9, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x63, 0x3c	/* t__pfx_kvm_setup_secondary_clock */
	.byte 0x0e, 0x74, 0x6b, 0x76, 0x6d, 0xba, 0x74, 0xb9, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x63, 0x3c	/* tkvm_setup_secondary_clock */
	.byte 0x0f, 0xc6, 0x6b, 0x76, 0xcd, 0xf8, 0xd6, 0xce, 0xfa, 0x73, 0x7e, 0xe5, 0x63, 0x3c, 0x2a, 0x86	/* t__pfx_kvm_restore_sched_clock_state */
	.byte 0x0f, 0x74, 0x6b, 0x76, 0xcd, 0xf8, 0xd6, 0xce, 0xfa, 0x73, 0x7e, 0xe5, 0x63, 0x3c, 0x2a, 0x86	/* tkvm_restore_sched_clock_state */
	.byte 0x0a, 0xc6, 0x6b, 0x76, 0xcd, 0xb2, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* t__pfx_kvm_get_wallclock */
	.byte 0x0a, 0x74, 0x6b, 0x76, 0xcd, 0xb2, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* tkvm_get_wallclock */
	.byte 0x16, 0xbf, 0x6b, 0x76, 0xcd, 0x7e, 0x63, 0xd8, 0xcc, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x67, 0x75, 0x3b, 0xf9, 0x70, 0x61, 0x75, 0xc9, 0x64	/* T__pfx_kvm_check_and_clear_guest_paused */
	.byte 0x16, 0x54, 0x6b, 0x76, 0xcd, 0x7e, 0x63, 0xd8, 0xcc, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x67, 0x75, 0x3b, 0xf9, 0x70, 0x61, 0x75, 0xc9, 0x64	/* Tkvm_check_and_clear_guest_paused */
	.byte 0x0b, 0xbf, 0x6b, 0x76, 0x6d, 0x63, 0xc0, 0xd8, 0x64, 0xab, 0x80, 0xd3	/* T__pfx_kvmclock_disable */
	.byte 0x0b, 0x54, 0x6b, 0x76, 0x6d, 0x63, 0xc0, 0xd8, 0x64, 0xab, 0x80, 0xd3	/* Tkvmclock_disable */
	.byte 0x0c, 0x3f, 0xff, 0x70, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x89, 0xbb, 0x36, 0x34	/* T__pfx__paravirt_ident_64 */
	.byte 0x0b, 0x54, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x89, 0xbb, 0x36, 0x34	/* T_paravirt_ident_64 */
	.byte 0x07, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x92, 0x89	/* t__pfx_native_cpuid */
	.byte 0x07, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x92, 0x89	/* tnative_cpuid */
	.byte 0x08, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x68, 0xe1, 0x74	/* t__pfx_native_halt */
	.byte 0x08, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x68, 0xe1, 0x74	/* tnative_halt */
	.byte 0x0a, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xf8, 0x05, 0x63, 0x72, 0x30	/* t__pfx_native_read_cr0 */
	.byte 0x0a, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xf8, 0x05, 0x63, 0x72, 0x30	/* tnative_read_cr0 */
	.byte 0x0b, 0x29, 0x5f, 0x6e, 0xe9, 0x69, 0x22, 0xf8, 0x05, 0x63, 0x72, 0x33	/* t__pfx___native_read_cr3 */
	.byte 0x0b, 0x74, 0xff, 0x6e, 0xe9, 0x69, 0x22, 0xf8, 0x05, 0x63, 0x72, 0x33	/* t__native_read_cr3 */
	.byte 0x0a, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x63, 0x72, 0x33	/* t__pfx_native_write_cr3 */
	.byte 0x0a, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x63, 0x72, 0x33	/* tnative_write_cr3 */
	.byte 0x0a, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xdf, 0xc7, 0xf6, 0x70, 0x30	/* t__pfx_native_load_sp0 */
	.byte 0x0a, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xdf, 0xc7, 0xf6, 0x70, 0x30	/* tnative_load_sp0 */
	.byte 0x09, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0x70, 0x9a	/* t__pfx_native_set_pte */
	.byte 0x09, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0x70, 0x9a	/* tnative_set_pte */
	.byte 0x0a, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0x70, 0x6d, 0x64	/* t__pfx_native_set_pmd */
	.byte 0x0a, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0x70, 0x6d, 0x64	/* tnative_set_pmd */
	.byte 0x09, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0xbe, 0x64	/* t__pfx_native_set_pud */
	.byte 0x09, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0xbe, 0x64	/* tnative_set_pud */
	.byte 0x0f, 0x29, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0x73, 0xdb, 0x72, 0x74	/* t__pfx___ptep_modify_prot_start */
	.byte 0x10, 0x74, 0xff, 0x70, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0x73, 0xdb, 0x72, 0x74	/* t__ptep_modify_prot_start */
	.byte 0x0c, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_native_write_ldt_entry */
	.byte 0x0c, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x02, 0xf9, 0xe8, 0xea, 0x79	/* tnative_write_ldt_entry */
	.byte 0x0a, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xdf, 0x05, 0x67, 0x64, 0x74	/* t__pfx_native_load_gdt */
	.byte 0x0a, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xdf, 0x05, 0x67, 0x64, 0x74	/* tnative_load_gdt */
	.byte 0x09, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xdf, 0x05, 0x89, 0x74	/* t__pfx_native_load_idt */
	.byte 0x09, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xdf, 0x05, 0x89, 0x74	/* tnative_load_idt */
	.byte 0x09, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xd6, 0xce, 0xfa, 0xea	/* t__pfx_native_store_tr */
	.byte 0x09, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xd6, 0xce, 0xfa, 0xea	/* tnative_store_tr */
	.byte 0x0a, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xdf, 0x05, 0x74, 0x6c, 0x73	/* t__pfx_native_load_tls */
	.byte 0x0a, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xdf, 0x05, 0x74, 0x6c, 0x73	/* tnative_load_tls */
	.byte 0x0c, 0x29, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x70, 0x67, 0xe5, 0xe1, 0xc0	/* t__pfx___paravirt_pgd_alloc */
	.byte 0x0d, 0x74, 0xff, 0x70, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x70, 0x67, 0xe5, 0xe1, 0xc0	/* t__paravirt_pgd_alloc */
	.byte 0x11, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x74, 0x73, 0xe0, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0x3e, 0x62, 0xe4, 0x0a	/* t__pfx_native_tss_invalidate_io_bitmap */
	.byte 0x11, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x74, 0x73, 0xe0, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0x3e, 0x62, 0xe4, 0x0a	/* tnative_tss_invalidate_io_bitmap */
	.byte 0x0b, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xd6, 0x65, 0xe1, 0x5f, 0x63, 0x3c	/* t__pfx_native_steal_clock */
	.byte 0x0b, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xd6, 0x65, 0xe1, 0x5f, 0x63, 0x3c	/* tnative_steal_clock */
	.byte 0x0a, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0x70, 0x34, 0x64	/* t__pfx_native_set_p4d */
	.byte 0x0a, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0x70, 0x34, 0x64	/* tnative_set_p4d */
	.byte 0x0a, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xf8, 0xc7, 0xe7, 0x6d, 0x63	/* t__pfx_native_read_pmc */
	.byte 0x0a, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xf8, 0xc7, 0xe7, 0x6d, 0x63	/* tnative_read_pmc */
	.byte 0x0d, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x20, 0x72, 0xf6, 0x61, 0x66, 0x65	/* t__pfx_native_write_msr_safe */
	.byte 0x0d, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x20, 0x72, 0xf6, 0x61, 0x66, 0x65	/* tnative_write_msr_safe */
	.byte 0x09, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x20, 0x72	/* t__pfx_native_write_msr */
	.byte 0x09, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x20, 0x72	/* tnative_write_msr */
	.byte 0x0d, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xf8, 0x05, 0x20, 0x72, 0xf6, 0x61, 0x66, 0x65	/* t__pfx_native_read_msr_safe */
	.byte 0x0d, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xf8, 0x05, 0x20, 0x72, 0xf6, 0x61, 0x66, 0x65	/* tnative_read_msr_safe */
	.byte 0x09, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xf8, 0x05, 0x20, 0x72	/* t__pfx_native_read_msr */
	.byte 0x09, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xf8, 0x05, 0x20, 0x72	/* tnative_read_msr */
	.byte 0x0d, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_native_write_gdt_entry */
	.byte 0x0d, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x67, 0x64, 0xf9, 0xe8, 0xea, 0x79	/* tnative_write_gdt_entry */
	.byte 0x0c, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_native_write_idt_entry */
	.byte 0x0c, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x24, 0xfa, 0x89, 0xf9, 0xe8, 0xea, 0x79	/* tnative_write_idt_entry */
	.byte 0x0c, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xdf, 0x05, 0x67, 0xe0, 0xf0, 0xe6, 0x78	/* t__pfx_native_load_gs_index */
	.byte 0x0c, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xdf, 0x05, 0x67, 0xe0, 0xf0, 0xe6, 0x78	/* tnative_load_gs_index */
	.byte 0x0c, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xdf, 0x05, 0xea, 0x5f, 0xe6, 0x73, 0x63	/* t__pfx_native_load_tr_desc */
	.byte 0x0c, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xdf, 0x05, 0xea, 0x5f, 0xe6, 0x73, 0x63	/* tnative_load_tr_desc */
	.byte 0x0e, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0x74, 0x6c, 0xdc, 0xf8, 0xa5, 0x22, 0xdb, 0x62, 0xd3	/* t__pfx_native_tlb_remove_table */
	.byte 0x0e, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0x74, 0x6c, 0xdc, 0xf8, 0xa5, 0x22, 0xdb, 0x62, 0xd3	/* tnative_tlb_remove_table */
	.byte 0x09, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0x02, 0x74	/* t__pfx_native_set_ldt */
	.byte 0x09, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0x02, 0x74	/* tnative_set_ldt */
	.byte 0x0a, 0xc6, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0x70, 0x67, 0x64	/* t__pfx_native_set_pgd */
	.byte 0x0a, 0x74, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0x70, 0x67, 0x64	/* tnative_set_pgd */
	.byte 0x0f, 0x29, 0xe7, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0xfe, 0x6d, 0x6d, 0xe4	/* t__pfx___ptep_modify_prot_commit */
	.byte 0x10, 0x74, 0xff, 0x70, 0x9a, 0xe2, 0xa5, 0x64, 0x69, 0x66, 0x79, 0x25, 0xf9, 0xfe, 0x6d, 0x6d, 0xe4	/* t__ptep_modify_prot_commit */
	.byte 0x0e, 0x3f, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xc9, 0xf9, 0x73, 0x7e, 0xe5, 0x63, 0x3c	/* T__pfx_paravirt_set_sched_clock */
	.byte 0x0e, 0x54, 0x70, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xc9, 0xf9, 0x73, 0x7e, 0xe5, 0x63, 0x3c	/* Tparavirt_set_sched_clock */
	.byte 0x10, 0x3f, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x64, 0xab, 0x80, 0xb3, 0xd9, 0x73, 0x70, 0xeb, 0x65	/* T__pfx_paravirt_disable_iospace */
	.byte 0x10, 0x54, 0x70, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0x64, 0xab, 0x80, 0xb3, 0xd9, 0x73, 0x70, 0xeb, 0x65	/* Tparavirt_disable_iospace */
	.byte 0x1b, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x76, 0x65, 0xff, 0x5f, 0x6e, 0xe9, 0x69, 0x22, 0x04, 0x75, 0x65, 0x64, 0xf6, 0x70, 0xf0, 0x5f, 0xd4, 0x3c	/* T__pfx___raw_callee_save___native_queued_spin_unlock */
	.byte 0x19, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x76, 0x65, 0xff, 0x5f, 0x6e, 0xe9, 0x69, 0x22, 0x04, 0x75, 0x65, 0x64, 0xf6, 0x70, 0xf0, 0x5f, 0xd4, 0x3c	/* T__raw_callee_save___native_queued_spin_unlock */
	.byte 0x1b, 0x3f, 0xff, 0x5f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x76, 0x65, 0xff, 0x5f, 0x6e, 0xe9, 0x69, 0x22, 0x76, 0x92, 0x5f, 0xab, 0xe7, 0xf8, 0x65, 0xb0, 0x9a, 0x64	/* T__pfx___raw_callee_save___native_vcpu_is_preempted */
	.byte 0x19, 0x2f, 0x1c, 0x28, 0xd3, 0xfa, 0x73, 0x61, 0x76, 0x65, 0xff, 0x5f, 0x6e, 0xe9, 0x69, 0x22, 0x76, 0x92, 0x5f, 0xab, 0xe7, 0xf8, 0x65, 0xb0, 0x9a, 0x64	/* T__raw_callee_save___native_vcpu_is_preempted */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x6e, 0xe9, 0x69, 0x22, 0x04, 0x75, 0x65, 0x64, 0xf6, 0x70, 0xf0, 0x5f, 0xd4, 0x3c	/* T__pfx___native_queued_spin_unlock */
	.byte 0x0f, 0x2f, 0x6e, 0xe9, 0x69, 0x22, 0x04, 0x75, 0x65, 0x64, 0xf6, 0x70, 0xf0, 0x5f, 0xd4, 0x3c	/* T__native_queued_spin_unlock */
	.byte 0x10, 0x3f, 0xe7, 0x76, 0x5f, 0x69, 0xe0, 0x6e, 0xe9, 0x69, 0x22, 0x73, 0x70, 0xf0, 0x5f, 0xd4, 0x3c	/* T__pfx_pv_is_native_spin_unlock */
	.byte 0x10, 0x54, 0x70, 0x76, 0x5f, 0x69, 0xe0, 0x6e, 0xe9, 0x69, 0x22, 0x73, 0x70, 0xf0, 0x5f, 0xd4, 0x3c	/* Tpv_is_native_spin_unlock */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x6e, 0xe9, 0x69, 0x22, 0x76, 0x92, 0x5f, 0xab, 0xe7, 0xf8, 0x65, 0xb0, 0x9a, 0x64	/* T__pfx___native_vcpu_is_preempted */
	.byte 0x0f, 0x2f, 0x6e, 0xe9, 0x69, 0x22, 0x76, 0x92, 0x5f, 0xab, 0xe7, 0xf8, 0x65, 0xb0, 0x9a, 0x64	/* T__native_vcpu_is_preempted */
	.byte 0x14, 0x3f, 0xe7, 0x76, 0x5f, 0x69, 0xe0, 0x6e, 0xe9, 0x69, 0x22, 0x76, 0x92, 0x5f, 0xab, 0xe7, 0xf8, 0x65, 0xb0, 0x9a, 0x64	/* T__pfx_pv_is_native_vcpu_is_preempted */
	.byte 0x14, 0x54, 0x70, 0x76, 0x5f, 0x69, 0xe0, 0x6e, 0xe9, 0x69, 0x22, 0x76, 0x92, 0x5f, 0xab, 0xe7, 0xf8, 0x65, 0xb0, 0x9a, 0x64	/* Tpv_is_native_vcpu_is_preempted */
	.byte 0x10, 0x3f, 0xe7, 0x76, 0x63, 0xc0, 0xd8, 0xb2, 0x70, 0x76, 0x74, 0xcb, 0x92, 0x30, 0x5f, 0x76, 0x61	/* T__pfx_pvclock_get_pvti_cpu0_va */
	.byte 0x10, 0x54, 0x70, 0x76, 0x63, 0xc0, 0xd8, 0xb2, 0x70, 0x76, 0x74, 0xcb, 0x92, 0x30, 0x5f, 0x76, 0x61	/* Tpvclock_get_pvti_cpu0_va */
	.byte 0x0a, 0x3f, 0xe7, 0x76, 0x63, 0x3c, 0x1f, 0x66, 0x1b, 0x67, 0x73	/* T__pfx_pvclock_set_flags */
	.byte 0x0a, 0x54, 0x70, 0x76, 0x63, 0x3c, 0x1f, 0x66, 0x1b, 0x67, 0x73	/* Tpvclock_set_flags */
	.byte 0x0c, 0x3f, 0xe7, 0x76, 0x63, 0xc0, 0xd8, 0x74, 0x73, 0xd5, 0x6b, 0x68, 0x7a	/* T__pfx_pvclock_tsc_khz */
	.byte 0x0c, 0x54, 0x70, 0x76, 0x63, 0xc0, 0xd8, 0x74, 0x73, 0xd5, 0x6b, 0x68, 0x7a	/* Tpvclock_tsc_khz */
	.byte 0x10, 0x3f, 0xe7, 0x76, 0x63, 0xc0, 0xd8, 0xac, 0x75, 0xd0, 0x5f, 0x77, 0xe9, 0xd0, 0xa9, 0x67, 0x73	/* T__pfx_pvclock_touch_watchdogs */
	.byte 0x10, 0x54, 0x70, 0x76, 0x63, 0xc0, 0xd8, 0xac, 0x75, 0xd0, 0x5f, 0x77, 0xe9, 0xd0, 0xa9, 0x67, 0x73	/* Tpvclock_touch_watchdogs */
	.byte 0x09, 0x3f, 0xe7, 0x76, 0x63, 0xc0, 0xd8, 0xf8, 0xb7, 0xbd	/* T__pfx_pvclock_resume */
	.byte 0x09, 0x54, 0x70, 0x76, 0x63, 0xc0, 0xd8, 0xf8, 0xb7, 0xbd	/* Tpvclock_resume */
	.byte 0x0c, 0x3f, 0xe7, 0x76, 0x63, 0xc0, 0xd8, 0xf8, 0x05, 0x66, 0x1b, 0x67, 0x73	/* T__pfx_pvclock_read_flags */
	.byte 0x0c, 0x54, 0x70, 0x76, 0x63, 0xc0, 0xd8, 0xf8, 0x05, 0x66, 0x1b, 0x67, 0x73	/* Tpvclock_read_flags */
	.byte 0x0f, 0x3f, 0xe7, 0x76, 0x63, 0xc0, 0xd8, 0x63, 0x3c, 0x73, 0x6f, 0x1d, 0x63, 0xfa, 0xf8, 0xc7	/* T__pfx_pvclock_clocksource_read */
	.byte 0x0f, 0x54, 0x70, 0x76, 0x63, 0xc0, 0xd8, 0x63, 0x3c, 0x73, 0x6f, 0x1d, 0x63, 0xfa, 0xf8, 0xc7	/* Tpvclock_clocksource_read */
	.byte 0x0d, 0x3f, 0xe7, 0x76, 0x63, 0xc0, 0xd8, 0xf8, 0x05, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* T__pfx_pvclock_read_wallclock */
	.byte 0x0d, 0x54, 0x70, 0x76, 0x63, 0xc0, 0xd8, 0xf8, 0x05, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* Tpvclock_read_wallclock */
	.byte 0x0f, 0x3f, 0xe7, 0x76, 0x63, 0x3c, 0x1f, 0x70, 0x76, 0x74, 0xcb, 0x92, 0x30, 0x5f, 0x76, 0x61	/* T__pfx_pvclock_set_pvti_cpu0_va */
	.byte 0x0f, 0x54, 0x70, 0x76, 0x63, 0x3c, 0x1f, 0x70, 0x76, 0x74, 0xcb, 0x92, 0x30, 0x5f, 0x76, 0x61	/* Tpvclock_set_pvti_cpu0_va */
	.byte 0x05, 0xc6, 0x66, 0x6f, 0xd4, 0x64	/* t__pfx_found */
	.byte 0x05, 0x74, 0x66, 0x6f, 0xd4, 0x64	/* tfound */
	.byte 0x0c, 0xc6, 0x6a, 0x61, 0x69, 0x6c, 0xad, 0x5d, 0xfa, 0xb2, 0x74, 0x73, 0x63	/* t__pfx_jailhouse_get_tsc */
	.byte 0x0c, 0x74, 0x6a, 0x61, 0x69, 0x6c, 0xad, 0x5d, 0xfa, 0xb2, 0x74, 0x73, 0x63	/* tjailhouse_get_tsc */
	.byte 0x0e, 0xc6, 0x6a, 0x61, 0x69, 0x6c, 0xad, 0x5d, 0xfa, 0xb2, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* t__pfx_jailhouse_get_wallclock */
	.byte 0x0e, 0x74, 0x6a, 0x61, 0x69, 0x6c, 0xad, 0x5d, 0xfa, 0xb2, 0x77, 0xe1, 0x6c, 0x63, 0x3c	/* tjailhouse_get_wallclock */
	.byte 0x10, 0xc6, 0x6a, 0x61, 0x69, 0x6c, 0xad, 0x5d, 0xfa, 0x73, 0xee, 0x69, 0xe1, 0x5f, 0xb8, 0x78, 0xb9	/* t__pfx_jailhouse_serial_fixup */
	.byte 0x10, 0x74, 0x6a, 0x61, 0x69, 0x6c, 0xad, 0x5d, 0xfa, 0x73, 0xee, 0x69, 0xe1, 0x5f, 0xb8, 0x78, 0xb9	/* tjailhouse_serial_fixup */
	.byte 0x0e, 0xc6, 0x6a, 0x61, 0x69, 0x6c, 0xad, 0x5d, 0xfa, 0x92, 0x69, 0xe5, 0x62, 0x61, 0xc9	/* t__pfx_jailhouse_cpuid_base */
	.byte 0x0e, 0x74, 0x6a, 0x61, 0x69, 0x6c, 0xad, 0x5d, 0xfa, 0x92, 0x69, 0xe5, 0x62, 0x61, 0xc9	/* tjailhouse_cpuid_base */
	.byte 0x0e, 0xbf, 0x6a, 0x61, 0x69, 0x6c, 0xad, 0x5d, 0xfa, 0x70, 0xca, 0x61, 0x76, 0xa7, 0x74	/* T__pfx_jailhouse_paravirt */
	.byte 0x0e, 0x54, 0x6a, 0x61, 0x69, 0x6c, 0xad, 0x5d, 0xfa, 0x70, 0xca, 0x61, 0x76, 0xa7, 0x74	/* Tjailhouse_paravirt */
	.byte 0x18, 0xa8, 0xf6, 0xdb, 0x72, 0xf9, 0x70, 0xee, 0xd9, 0x64, 0x69, 0xd5, 0x7e, 0x63, 0xd8, 0x66, 0xce, 0x5f, 0xfe, 0x72, 0x72, 0xb9, 0x74, 0xd9, 0x6e	/* t__pfx_start_periodic_check_for_corruption */
	.byte 0x18, 0x74, 0x73, 0xdb, 0x72, 0xf9, 0x70, 0xee, 0xd9, 0x64, 0x69, 0xd5, 0x7e, 0x63, 0xd8, 0x66, 0xce, 0x5f, 0xfe, 0x72, 0x72, 0xb9, 0x74, 0xd9, 0x6e	/* tstart_periodic_check_for_corruption */
	.byte 0x0b, 0xc6, 0x7e, 0x63, 0xd8, 0xfe, 0x72, 0x72, 0xb9, 0x74, 0xd9, 0x6e	/* t__pfx_check_corruption */
	.byte 0x0b, 0x74, 0x7e, 0x63, 0xd8, 0xfe, 0x72, 0x72, 0xb9, 0x74, 0xd9, 0x6e	/* tcheck_corruption */
	.byte 0x10, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0x6f, 0x66, 0xe7, 0x63, 0xcb, 0xa7, 0x93, 0x64, 0xab, 0x80, 0xd3	/* t__pfx_x86_of_pci_irq_disable */
	.byte 0x10, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x6f, 0x66, 0xe7, 0x63, 0xcb, 0xa7, 0x93, 0x64, 0xab, 0x80, 0xd3	/* tx86_of_pci_irq_disable */
	.byte 0x0f, 0xc6, 0x78, 0x38, 0x36, 0x5f, 0x6f, 0x66, 0xe7, 0x63, 0xcb, 0xa7, 0x93, 0xe8, 0x80, 0xd3	/* t__pfx_x86_of_pci_irq_enable */
	.byte 0x0f, 0x74, 0x78, 0x38, 0x36, 0x5f, 0x6f, 0x66, 0xe7, 0x63, 0xcb, 0xa7, 0x93, 0xe8, 0x80, 0xd3	/* tx86_of_pci_irq_enable */
	.byte 0x0b, 0xc6, 0x64, 0xf9, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0xe1, 0xc0	/* t__pfx_dt_irqdomain_alloc */
	.byte 0x0b, 0x74, 0x64, 0xf9, 0xa7, 0x71, 0xa9, 0xdd, 0xf0, 0x5f, 0xe1, 0xc0	/* tdt_irqdomain_alloc */
	.byte 0x0f, 0x3f, 0xe7, 0x63, 0x69, 0x62, 0xd9, 0xe0, 0xb2, 0x70, 0x68, 0xdc, 0x6f, 0xa0, 0xb6, 0xe6	/* T__pfx_pcibios_get_phb_of_node */
	.byte 0x0f, 0x54, 0x70, 0x63, 0x69, 0x62, 0xd9, 0xe0, 0xb2, 0x70, 0x68, 0xdc, 0x6f, 0xa0, 0xb6, 0xe6	/* Tpcibios_get_phb_of_node */
	.byte 0x0b, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x6f, 0x66, 0xe7, 0x63, 0xcb, 0x8d	/* T__pfx_x86_of_pci_init */
	.byte 0x0b, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x6f, 0x66, 0xe7, 0x63, 0xcb, 0x8d	/* Tx86_of_pci_init */
	.byte 0x0d, 0xc6, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x72, 0xfa, 0x78, 0x6f, 0xc3, 0x81	/* t__pfx_default_pre_xol_op */
	.byte 0x0d, 0x74, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x72, 0xfa, 0x78, 0x6f, 0xc3, 0x81	/* tdefault_pre_xol_op */
	.byte 0x0b, 0xc6, 0x65, 0x6d, 0x0b, 0xa1, 0xbe, 0x73, 0x68, 0x2a, 0xeb, 0x6b	/* t__pfx_emulate_push_stack */
	.byte 0x0a, 0x9a, 0x6d, 0x0b, 0xa1, 0xbe, 0x73, 0x68, 0x2a, 0xeb, 0x6b	/* temulate_push_stack */
	.byte 0x09, 0xa8, 0xe7, 0x5d, 0x5b, 0x65, 0x6d, 0x0b, 0xa1, 0x81	/* t__pfx_push_emulate_op */
	.byte 0x09, 0x74, 0xbe, 0x73, 0x5b, 0x65, 0x6d, 0x0b, 0xa1, 0x81	/* tpush_emulate_op */
	.byte 0x0a, 0x29, 0x5f, 0xa9, 0x95, 0xe0, 0x75, 0xf8, 0x74, 0x9b, 0x17	/* t__pfx___do_sys_uretprobe */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x75, 0xf8, 0x74, 0x9b, 0x17	/* T__pfx___ia32_sys_uretprobe */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x75, 0xf8, 0x74, 0x9b, 0x17	/* T__pfx___x64_sys_uretprobe */
	.byte 0x0a, 0x74, 0xff, 0xa9, 0x95, 0xe0, 0x75, 0xf8, 0x74, 0x9b, 0x17	/* t__do_sys_uretprobe */
	.byte 0x0c, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x75, 0xf8, 0x74, 0x9b, 0x17	/* T__ia32_sys_uretprobe */
	.byte 0x0b, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x75, 0xf8, 0x74, 0x9b, 0x17	/* T__x64_sys_uretprobe */
	.byte 0x0d, 0xc6, 0x62, 0x72, 0xcc, 0xd0, 0xe7, 0x6f, 0x73, 0xf9, 0x78, 0x6f, 0xc3, 0x81	/* t__pfx_branch_post_xol_op */
	.byte 0x0d, 0x74, 0x62, 0x72, 0xcc, 0xd0, 0xe7, 0x6f, 0x73, 0xf9, 0x78, 0x6f, 0xc3, 0x81	/* tbranch_post_xol_op */
	.byte 0x0b, 0xc6, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0x65, 0x6d, 0x0b, 0xa1, 0x81	/* t__pfx_branch_emulate_op */
	.byte 0x0b, 0x74, 0x62, 0x72, 0xcc, 0xd0, 0x5f, 0x65, 0x6d, 0x0b, 0xa1, 0x81	/* tbranch_emulate_op */
	.byte 0x0e, 0xc6, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x6f, 0x73, 0xf9, 0x78, 0x6f, 0xc3, 0x81	/* t__pfx_default_post_xol_op */
	.byte 0x0e, 0x74, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x6f, 0x73, 0xf9, 0x78, 0x6f, 0xc3, 0x81	/* tdefault_post_xol_op */
	.byte 0x0a, 0xc6, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x80, 0xce, 0xf9, 0x81	/* t__pfx_default_abort_op */
	.byte 0x0a, 0x74, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0x80, 0xce, 0xf9, 0x81	/* tdefault_abort_op */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* T__pfx_arch_uprobe_trampoline */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* Tarch_uprobe_trampoline */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0xcc, 0xe1, 0x79, 0x7a, 0xfa, 0xf0, 0x73, 0x6e	/* T__pfx_arch_uprobe_analyze_insn */
	.byte 0x10, 0x54, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0xcc, 0xe1, 0x79, 0x7a, 0xfa, 0xf0, 0x73, 0x6e	/* Tarch_uprobe_analyze_insn */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0x70, 0x72, 0xfa, 0x78, 0x7f	/* T__pfx_arch_uprobe_pre_xol */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0x70, 0x72, 0xfa, 0x78, 0x7f	/* Tarch_uprobe_pre_xol */
	.byte 0x13, 0xbf, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0x78, 0x6f, 0xc3, 0x13, 0xe0, 0xea, 0x61, 0x70, 0x70, 0x65, 0x64	/* T__pfx_arch_uprobe_xol_was_trapped */
	.byte 0x13, 0x54, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0x78, 0x6f, 0xc3, 0x13, 0xe0, 0xea, 0x61, 0x70, 0x70, 0x65, 0x64	/* Tarch_uprobe_xol_was_trapped */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0x70, 0x6f, 0x73, 0xf9, 0x78, 0x7f	/* T__pfx_arch_uprobe_post_xol */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0x70, 0x6f, 0x73, 0xf9, 0x78, 0x7f	/* Tarch_uprobe_post_xol */
	.byte 0x13, 0xbf, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x7c, 0xb6, 0xc2, 0x66, 0x79	/* T__pfx_arch_uprobe_exception_notify */
	.byte 0x13, 0x54, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x7c, 0xb6, 0xc2, 0x66, 0x79	/* Tarch_uprobe_exception_notify */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0x80, 0xce, 0xf9, 0x78, 0x7f	/* T__pfx_arch_uprobe_abort_xol */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0x80, 0xce, 0xf9, 0x78, 0x7f	/* Tarch_uprobe_abort_xol */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0x16, 0x0c, 0xf6, 0xd6, 0x65, 0x70	/* T__pfx_arch_uprobe_skip_sstep */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0xb9, 0xde, 0x62, 0xfa, 0x16, 0x0c, 0xf6, 0xd6, 0x65, 0x70	/* Tarch_uprobe_skip_sstep */
	.byte 0x15, 0xbf, 0xca, 0xd0, 0x5f, 0x75, 0xf8, 0x74, 0x9b, 0x62, 0xfa, 0x68, 0x69, 0x6a, 0xeb, 0xd8, 0xf8, 0x74, 0x1d, 0x7c, 0x10, 0x72	/* T__pfx_arch_uretprobe_hijack_return_addr */
	.byte 0x15, 0x54, 0xca, 0xd0, 0x5f, 0x75, 0xf8, 0x74, 0x9b, 0x62, 0xfa, 0x68, 0x69, 0x6a, 0xeb, 0xd8, 0xf8, 0x74, 0x1d, 0x7c, 0x10, 0x72	/* Tarch_uretprobe_hijack_return_addr */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0x5f, 0x75, 0xf8, 0x74, 0x9b, 0x62, 0xfa, 0x69, 0xe0, 0xe1, 0x69, 0x76, 0x65	/* T__pfx_arch_uretprobe_is_alive */
	.byte 0x10, 0x54, 0xca, 0xd0, 0x5f, 0x75, 0xf8, 0x74, 0x9b, 0x62, 0xfa, 0x69, 0xe0, 0xe1, 0x69, 0x76, 0x65	/* Tarch_uretprobe_is_alive */
	.byte 0x0a, 0x3f, 0xe7, 0xee, 0xa0, 0xf8, 0xa6, 0x76, 0xe1, 0x75, 0x65	/* T__pfx_perf_reg_value */
	.byte 0x0a, 0x54, 0x70, 0xee, 0xa0, 0xf8, 0xa6, 0x76, 0xe1, 0x75, 0x65	/* Tperf_reg_value */
	.byte 0x0a, 0x3f, 0xe7, 0xee, 0xa0, 0xf8, 0xa6, 0x76, 0xe1, 0x89, 0x86	/* T__pfx_perf_reg_validate */
	.byte 0x0a, 0x54, 0x70, 0xee, 0xa0, 0xf8, 0xa6, 0x76, 0xe1, 0x89, 0x86	/* Tperf_reg_validate */
	.byte 0x08, 0x3f, 0xe7, 0xee, 0xa0, 0xf8, 0xa6, 0x80, 0x69	/* T__pfx_perf_reg_abi */
	.byte 0x08, 0x54, 0x70, 0xee, 0xa0, 0xf8, 0xa6, 0x80, 0x69	/* Tperf_reg_abi */
	.byte 0x09, 0x3f, 0xe7, 0xee, 0xa0, 0xb2, 0x9f, 0xe0, 0x5d, 0xee	/* T__pfx_perf_get_regs_user */
	.byte 0x09, 0x54, 0x70, 0xee, 0xa0, 0xb2, 0x9f, 0xe0, 0x5d, 0xee	/* Tperf_get_regs_user */
	.byte 0x09, 0xbf, 0xc8, 0x70, 0x03, 0x66, 0x61, 0x0b, 0xf9, 0x9f	/* T__pfx_trace_pagefault_reg */
	.byte 0x09, 0x54, 0xc8, 0x70, 0x03, 0x66, 0x61, 0x0b, 0xf9, 0x9f	/* Ttrace_pagefault_reg */
	.byte 0x0a, 0xbf, 0xc8, 0x70, 0x03, 0x66, 0x61, 0x0b, 0xf9, 0xd4, 0x9f	/* T__pfx_trace_pagefault_unreg */
	.byte 0x0a, 0x54, 0xc8, 0x70, 0x03, 0x66, 0x61, 0x0b, 0xf9, 0xd4, 0x9f	/* Ttrace_pagefault_unreg */
	.byte 0x0f, 0xa8, 0xf6, 0x7e, 0xe5, 0xe4, 0x6d, 0xf9, 0xb9, 0x64, 0xa1, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_sched_itmt_update_handler */
	.byte 0x0f, 0x74, 0x73, 0x7e, 0xe5, 0xe4, 0x6d, 0xf9, 0xb9, 0x64, 0xa1, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* tsched_itmt_update_handler */
	.byte 0x0d, 0x3f, 0xf6, 0x7e, 0x64, 0x1f, 0xe4, 0x6d, 0xf9, 0x73, 0xb9, 0x70, 0xce, 0x74	/* T__pfx_sched_set_itmt_support */
	.byte 0x0d, 0x54, 0x73, 0x7e, 0x64, 0x1f, 0xe4, 0x6d, 0xf9, 0x73, 0xb9, 0x70, 0xce, 0x74	/* Tsched_set_itmt_support */
	.byte 0x10, 0x3f, 0xf6, 0x7e, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0xe4, 0x6d, 0xf9, 0x73, 0xb9, 0x70, 0xce, 0x74	/* T__pfx_sched_clear_itmt_support */
	.byte 0x10, 0x54, 0x73, 0x7e, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0xe4, 0x6d, 0xf9, 0x73, 0xb9, 0x70, 0xce, 0x74	/* Tsched_clear_itmt_support */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0x5f, 0x61, 0xc1, 0xcd, 0x92, 0xe7, 0x72, 0xd9, 0x8a, 0x79	/* T__pfx_arch_asym_cpu_priority */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0x5f, 0x61, 0xc1, 0xcd, 0x92, 0xe7, 0x72, 0xd9, 0x8a, 0x79	/* Tarch_asym_cpu_priority */
	.byte 0x0e, 0x3f, 0xf6, 0x7e, 0x64, 0x1f, 0xe4, 0x6d, 0xf9, 0xfe, 0x72, 0xfa, 0x70, 0x72, 0xd9	/* T__pfx_sched_set_itmt_core_prio */
	.byte 0x0e, 0x54, 0x73, 0x7e, 0x64, 0x1f, 0xe4, 0x6d, 0xf9, 0xfe, 0x72, 0xfa, 0x70, 0x72, 0xd9	/* Tsched_set_itmt_core_prio */
	.byte 0x09, 0xc6, 0x75, 0x6d, 0x0c, 0xe7, 0x72, 0xf0, 0x74, 0x6b	/* t__pfx_umip_printk */
	.byte 0x09, 0x74, 0x75, 0x6d, 0x0c, 0xe7, 0x72, 0xf0, 0x74, 0x6b	/* tumip_printk */
	.byte 0x0f, 0xbf, 0xb8, 0x78, 0x3a, 0x75, 0x6d, 0x69, 0xe2, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e	/* T__pfx_fixup_umip_exception */
	.byte 0x0f, 0x54, 0xb8, 0x78, 0x3a, 0x75, 0x6d, 0x69, 0xe2, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e	/* Tfixup_umip_exception */
	.byte 0x0d, 0xbf, 0xd4, 0x77, 0xf0, 0xe5, 0xb2, 0xf8, 0x74, 0x1d, 0x7c, 0x10, 0x3d, 0x73	/* T__pfx_unwind_get_return_address */
	.byte 0x0d, 0x54, 0xd4, 0x77, 0xf0, 0xe5, 0xb2, 0xf8, 0x74, 0x1d, 0x7c, 0x10, 0x3d, 0x73	/* Tunwind_get_return_address */
	.byte 0x08, 0xc6, 0xd4, 0x77, 0xf0, 0xe5, 0x64, 0x75, 0xb0	/* t__pfx_unwind_dump */
	.byte 0x08, 0x74, 0xd4, 0x77, 0xf0, 0xe5, 0x64, 0x75, 0xb0	/* tunwind_dump */
	.byte 0x09, 0xc6, 0xb9, 0x64, 0xa1, 0xd6, 0xeb, 0x6b, 0x2a, 0x86	/* t__pfx_update_stack_state */
	.byte 0x09, 0x74, 0xb9, 0x64, 0xa1, 0xd6, 0xeb, 0x6b, 0x2a, 0x86	/* tupdate_stack_state */
	.byte 0x0b, 0xbf, 0xd4, 0x77, 0xf0, 0xe5, 0x6e, 0xd1, 0xf9, 0x66, 0xb5, 0xbd	/* T__pfx_unwind_next_frame */
	.byte 0x0b, 0x54, 0xd4, 0x77, 0xf0, 0xe5, 0x6e, 0xd1, 0xf9, 0x66, 0xb5, 0xbd	/* Tunwind_next_frame */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0xd4, 0x77, 0xf0, 0x64, 0xf6, 0xdb, 0x72, 0x74	/* T__pfx___unwind_start */
	.byte 0x09, 0x2f, 0xd4, 0x77, 0xf0, 0x64, 0xf6, 0xdb, 0x72, 0x74	/* T__unwind_start */
	.byte 0x0f, 0xbf, 0xd4, 0x77, 0xf0, 0xe5, 0xb2, 0xf8, 0x74, 0x1d, 0x7c, 0x10, 0x3d, 0x73, 0xe7, 0xea	/* T__pfx_unwind_get_return_address_ptr */
	.byte 0x0f, 0x54, 0xd4, 0x77, 0xf0, 0xe5, 0xb2, 0xf8, 0x74, 0x1d, 0x7c, 0x10, 0x3d, 0x73, 0xe7, 0xea	/* Tunwind_get_return_address_ptr */
	.byte 0x07, 0xa8, 0xf6, 0x6b, 0x69, 0xe2, 0x10, 0x72	/* t__pfx_skip_addr */
	.byte 0x06, 0x74, 0x16, 0x69, 0xe2, 0x10, 0x72	/* tskip_addr */
	.byte 0x06, 0xc6, 0x28, 0xc3, 0xb2, 0xe6, 0xd6	/* t__pfx_call_get_dest */
	.byte 0x06, 0x2d, 0xe1, 0xc3, 0xb2, 0xe6, 0xd6	/* tcall_get_dest */
	.byte 0x07, 0xc6, 0x69, 0xe0, 0xfe, 0xf8, 0x74, 0x97	/* t__pfx_is_coretext */
	.byte 0x06, 0xc2, 0xe0, 0xfe, 0xf8, 0x74, 0x97	/* tis_coretext */
	.byte 0x08, 0xc6, 0x69, 0xe0, 0x28, 0x6c, 0x15, 0xd4, 0x6b	/* t__pfx_is_callthunk */
	.byte 0x07, 0xc2, 0xe0, 0x28, 0x6c, 0x15, 0xd4, 0x6b	/* tis_callthunk */
	.byte 0x07, 0xa8, 0xe7, 0xe9, 0xd0, 0x5f, 0xe6, 0xd6	/* t__pfx_patch_dest */
	.byte 0x06, 0x06, 0xe9, 0xd0, 0x5f, 0xe6, 0xd6	/* tpatch_dest */
	.byte 0x07, 0xa8, 0xe7, 0xe9, 0xd0, 0x5f, 0x28, 0x6c	/* t__pfx_patch_call */
	.byte 0x06, 0x06, 0xe9, 0xd0, 0x5f, 0x28, 0x6c	/* tpatch_call */
	.byte 0x0a, 0xc6, 0x28, 0x6c, 0x15, 0xd4, 0x6b, 0x73, 0xba, 0x74, 0xb9	/* t__pfx_callthunks_setup */
	.byte 0x0a, 0x2d, 0xe1, 0x6c, 0x15, 0xd4, 0x6b, 0x73, 0xba, 0x74, 0xb9	/* tcallthunks_setup */
	.byte 0x10, 0xbf, 0x28, 0x6c, 0x15, 0xd4, 0x6b, 0xe0, 0xea, 0xcc, 0x73, 0x6c, 0xa1, 0x28, 0xc3, 0xe6, 0xd6	/* T__pfx_callthunks_translate_call_dest */
	.byte 0x10, 0x54, 0x28, 0x6c, 0x15, 0xd4, 0x6b, 0xe0, 0xea, 0xcc, 0x73, 0x6c, 0xa1, 0x28, 0xc3, 0xe6, 0xd6	/* Tcallthunks_translate_call_dest */
	.byte 0x14, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x28, 0xc3, 0xe6, 0x70, 0x74, 0x5b, 0x65, 0x6d, 0x99, 0xeb, 0xfe, 0xd4, 0x74, 0xf0, 0x67	/* T__pfx_x86_call_depth_emit_accounting */
	.byte 0x14, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x28, 0xc3, 0xe6, 0x70, 0x74, 0x5b, 0x65, 0x6d, 0x99, 0xeb, 0xfe, 0xd4, 0x74, 0xf0, 0x67	/* Tx86_call_depth_emit_accounting */
	.byte 0x12, 0xbf, 0x28, 0x6c, 0x15, 0xd4, 0x6b, 0x73, 0xe7, 0xe9, 0xd0, 0x5f, 0xa5, 0x64, 0x75, 0xb3, 0x28, 0x6c, 0x73	/* T__pfx_callthunks_patch_module_calls */
	.byte 0x12, 0x54, 0x28, 0x6c, 0x15, 0xd4, 0x6b, 0x73, 0xe7, 0xe9, 0xd0, 0x5f, 0xa5, 0x64, 0x75, 0xb3, 0x28, 0x6c, 0x73	/* Tcallthunks_patch_module_calls */
	.byte 0x0e, 0xbf, 0x61, 0x75, 0x64, 0x99, 0x63, 0x6c, 0x96, 0x73, 0x69, 0x66, 0xc5, 0xca, 0xd0	/* T__pfx_audit_classify_arch */
	.byte 0x0e, 0x54, 0x61, 0x75, 0x64, 0x99, 0x63, 0x6c, 0x96, 0x73, 0x69, 0x66, 0xc5, 0xca, 0xd0	/* Taudit_classify_arch */
	.byte 0x10, 0xbf, 0x61, 0x75, 0x64, 0x99, 0x63, 0x6c, 0x96, 0x73, 0x69, 0x66, 0x79, 0x95, 0x73, 0x28, 0x6c	/* T__pfx_audit_classify_syscall */
	.byte 0x10, 0x54, 0x61, 0x75, 0x64, 0x99, 0x63, 0x6c, 0x96, 0x73, 0x69, 0x66, 0x79, 0x95, 0x73, 0x28, 0x6c	/* Taudit_classify_syscall */
	.byte 0x0e, 0xc6, 0x67, 0xca, 0xf9, 0xd9, 0x6d, 0x6d, 0x75, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* t__pfx_gart_iommu_shutdown */
	.byte 0x0e, 0x74, 0x67, 0xca, 0xf9, 0xd9, 0x6d, 0x6d, 0x75, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x6e	/* tgart_iommu_shutdown */
	.byte 0x07, 0xc6, 0x08, 0xd5, 0xd9, 0x6d, 0x6d, 0x75	/* t__pfx_alloc_iommu */
	.byte 0x07, 0x74, 0x08, 0xd5, 0xd9, 0x6d, 0x6d, 0x75	/* talloc_iommu */
	.byte 0x08, 0x29, 0x5f, 0x64, 0xdd, 0x5f, 0x84, 0x98, 0x74	/* t__pfx___dma_map_cont */
	.byte 0x08, 0x74, 0xff, 0x64, 0xdd, 0x5f, 0x84, 0x98, 0x74	/* t__dma_map_cont */
	.byte 0x08, 0xc6, 0x67, 0xca, 0xf9, 0xd4, 0x0a, 0xe7, 0x03	/* t__pfx_gart_unmap_page */
	.byte 0x08, 0x74, 0x67, 0xca, 0xf9, 0xd4, 0x0a, 0xe7, 0x03	/* tgart_unmap_page */
	.byte 0x08, 0xc6, 0x67, 0xca, 0xf9, 0xd4, 0x0a, 0xf6, 0x67	/* t__pfx_gart_unmap_sg */
	.byte 0x08, 0x74, 0x67, 0xca, 0xf9, 0xd4, 0x0a, 0xf6, 0x67	/* tgart_unmap_sg */
	.byte 0x0c, 0xc6, 0x67, 0xca, 0xf9, 0x87, 0xfa, 0xfe, 0x68, 0x65, 0xf8, 0x6e, 0x74	/* t__pfx_gart_free_coherent */
	.byte 0x0c, 0x74, 0x67, 0xca, 0xf9, 0x87, 0xfa, 0xfe, 0x68, 0x65, 0xf8, 0x6e, 0x74	/* tgart_free_coherent */
	.byte 0x08, 0xc6, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0xca, 0x74	/* t__pfx_flush_gart */
	.byte 0x08, 0x74, 0x66, 0x6c, 0x5d, 0x5b, 0x67, 0xca, 0x74	/* tflush_gart */
	.byte 0x0d, 0xc6, 0x64, 0xdd, 0x5f, 0x84, 0x61, 0xf8, 0x61, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_dma_map_area.isra.0 */
	.byte 0x0d, 0x74, 0x64, 0xdd, 0x5f, 0x84, 0x61, 0xf8, 0x61, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tdma_map_area.isra.0 */
	.byte 0x07, 0xc6, 0x67, 0xca, 0xf9, 0x0a, 0xe7, 0x03	/* t__pfx_gart_map_page */
	.byte 0x07, 0x74, 0x67, 0xca, 0xf9, 0x0a, 0xe7, 0x03	/* tgart_map_page */
	.byte 0x0c, 0xc6, 0x67, 0xca, 0xf9, 0x08, 0xd5, 0xfe, 0x68, 0x65, 0xf8, 0x6e, 0x74	/* t__pfx_gart_alloc_coherent */
	.byte 0x0c, 0x74, 0x67, 0xca, 0xf9, 0x08, 0xd5, 0xfe, 0x68, 0x65, 0xf8, 0x6e, 0x74	/* tgart_alloc_coherent */
	.byte 0x07, 0xc6, 0x67, 0xca, 0xf9, 0x0a, 0xf6, 0x67	/* t__pfx_gart_map_sg */
	.byte 0x07, 0x74, 0x67, 0xca, 0xf9, 0x0a, 0xf6, 0x67	/* tgart_map_sg */
	.byte 0x09, 0x3f, 0x1f, 0x3a, 0x67, 0xca, 0xf9, 0xf8, 0xb7, 0xbd	/* T__pfx_set_up_gart_resume */
	.byte 0x0a, 0x54, 0xc9, 0xf9, 0x3a, 0x67, 0xca, 0xf9, 0xf8, 0xb7, 0xbd	/* Tset_up_gart_resume */
	.byte 0x0e, 0xc6, 0x67, 0xca, 0xf9, 0x7f, 0x64, 0xbd, 0xcd, 0xef, 0x7c, 0x69, 0xe0, 0xb5, 0x6d	/* t__pfx_gart_oldmem_pfn_is_ram */
	.byte 0x0e, 0x74, 0x67, 0xca, 0xf9, 0x7f, 0x64, 0xbd, 0xcd, 0xef, 0x7c, 0x69, 0xe0, 0xb5, 0x6d	/* tgart_oldmem_pfn_is_ram */
	.byte 0x0c, 0xc6, 0x67, 0xca, 0xf9, 0xbd, 0xcd, 0xef, 0x7c, 0x69, 0xe0, 0xb5, 0x6d	/* t__pfx_gart_mem_pfn_is_ram */
	.byte 0x0c, 0x74, 0x67, 0xca, 0xf9, 0xbd, 0xcd, 0xef, 0x7c, 0x69, 0xe0, 0xb5, 0x6d	/* tgart_mem_pfn_is_ram */
	.byte 0x07, 0xc6, 0x63, 0x6d, 0xe2, 0x72, 0xcc, 0xda	/* t__pfx_cmp_range */
	.byte 0x06, 0x2d, 0x6d, 0xe2, 0x72, 0xcc, 0xda	/* tcmp_range */
	.byte 0x12, 0xc6, 0xb2, 0x66, 0x61, 0x6d, 0x31, 0x30, 0x68, 0xe7, 0x63, 0xcb, 0x6d, 0x6d, 0x98, 0xa0, 0x62, 0x61, 0xc9	/* t__pfx_get_fam10h_pci_mmconf_base */
	.byte 0x12, 0x74, 0xb2, 0x66, 0x61, 0x6d, 0x31, 0x30, 0x68, 0xe7, 0x63, 0xcb, 0x6d, 0x6d, 0x98, 0xa0, 0x62, 0x61, 0xc9	/* tget_fam10h_pci_mmconf_base */
	.byte 0x12, 0xbf, 0x66, 0x61, 0x6d, 0x31, 0x30, 0x5b, 0x7e, 0x63, 0xd8, 0xe8, 0x80, 0xb3, 0x6d, 0x6d, 0x63, 0x66, 0x67	/* T__pfx_fam10h_check_enable_mmcfg */
	.byte 0x12, 0x54, 0x66, 0x61, 0x6d, 0x31, 0x30, 0x5b, 0x7e, 0x63, 0xd8, 0xe8, 0x80, 0xb3, 0x6d, 0x6d, 0x63, 0x66, 0x67	/* Tfam10h_check_enable_mmcfg */
	.byte 0x0c, 0xbf, 0x63, 0xeb, 0x68, 0x65, 0xa5, 0xe6, 0x32, 0x9b, 0x74, 0x76, 0xe1	/* T__pfx_cachemode2protval */
	.byte 0x0c, 0x54, 0x63, 0xeb, 0x68, 0x65, 0xa5, 0xe6, 0x32, 0x9b, 0x74, 0x76, 0xe1	/* Tcachemode2protval */
	.byte 0x06, 0xa8, 0xf6, 0x61, 0x22, 0x6d, 0x72	/* t__pfx_save_mr */
	.byte 0x06, 0x74, 0x73, 0x61, 0x22, 0x6d, 0x72	/* tsave_mr */
	.byte 0x0c, 0xbf, 0x78, 0x38, 0x36, 0x5f, 0x68, 0x96, 0xe7, 0x61, 0xf9, 0x77, 0x70	/* T__pfx_x86_has_pat_wp */
	.byte 0x0c, 0x54, 0x78, 0x38, 0x36, 0x5f, 0x68, 0x96, 0xe7, 0x61, 0xf9, 0x77, 0x70	/* Tx86_has_pat_wp */
	.byte 0x0c, 0x3f, 0xe7, 0x67, 0x9b, 0x74, 0x32, 0x63, 0xeb, 0x68, 0x65, 0xa5, 0xe6	/* T__pfx_pgprot2cachemode */
	.byte 0x0c, 0x54, 0x70, 0x67, 0x9b, 0x74, 0x32, 0x63, 0xeb, 0x68, 0x65, 0xa5, 0xe6	/* Tpgprot2cachemode */
	.byte 0x0c, 0xbf, 0xef, 0x7c, 0x72, 0xcc, 0x21, 0x69, 0xe0, 0x0a, 0x70, 0x65, 0x64	/* T__pfx_pfn_range_is_mapped */
	.byte 0x0c, 0x54, 0xef, 0x7c, 0x72, 0xcc, 0x21, 0x69, 0xe0, 0x0a, 0x70, 0x65, 0x64	/* Tpfn_range_is_mapped */
	.byte 0x0a, 0xbf, 0xd2, 0xbd, 0xcd, 0x69, 0xe0, 0x08, 0x77, 0x65, 0x64	/* T__pfx_devmem_is_allowed */
	.byte 0x0a, 0x54, 0xd2, 0xbd, 0xcd, 0x69, 0xe0, 0x08, 0x77, 0x65, 0x64	/* Tdevmem_is_allowed */
	.byte 0x08, 0xbf, 0x87, 0xfa, 0xf0, 0x99, 0x70, 0x03, 0x73	/* T__pfx_free_init_pages */
	.byte 0x08, 0x54, 0x87, 0xfa, 0xf0, 0x99, 0x70, 0x03, 0x73	/* Tfree_init_pages */
	.byte 0x0d, 0xbf, 0x87, 0xfa, 0x6b, 0xee, 0xb4, 0xc3, 0x69, 0xdd, 0x21, 0x70, 0x03, 0x73	/* T__pfx_free_kernel_image_pages */
	.byte 0x0d, 0x54, 0x87, 0xfa, 0x6b, 0xee, 0xb4, 0xc3, 0x69, 0xdd, 0x21, 0x70, 0x03, 0x73	/* Tfree_kernel_image_pages */
	.byte 0x0e, 0xbf, 0xb9, 0x64, 0xa1, 0x63, 0xeb, 0x68, 0xfa, 0xa5, 0x64, 0xfa, 0xe8, 0xea, 0x79	/* T__pfx_update_cache_mode_entry */
	.byte 0x0e, 0x54, 0xb9, 0x64, 0xa1, 0x63, 0xeb, 0x68, 0xfa, 0xa5, 0x64, 0xfa, 0xe8, 0xea, 0x79	/* Tupdate_cache_mode_entry */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0xdd, 0x78, 0xf6, 0x13, 0xef, 0x69, 0xb3, 0x73, 0x69, 0x7a, 0x65	/* T__pfx_arch_max_swapfile_size */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0xdd, 0x78, 0xf6, 0x13, 0xef, 0x69, 0xb3, 0x73, 0x69, 0x7a, 0x65	/* Tarch_max_swapfile_size */
	.byte 0x04, 0x29, 0xe7, 0x67, 0x64	/* t__pfx___pgd */
	.byte 0x05, 0x74, 0xff, 0x70, 0x67, 0x64	/* t__pgd */
	.byte 0x05, 0xa8, 0x1f, 0x70, 0x6d, 0x64	/* t__pfx_set_pmd */
	.byte 0x06, 0x74, 0xc9, 0xf9, 0x70, 0x6d, 0x64	/* tset_pmd */
	.byte 0x04, 0x29, 0xe7, 0x6d, 0x64	/* t__pfx___pmd */
	.byte 0x05, 0x74, 0xff, 0x70, 0x6d, 0x64	/* t__pmd */
	.byte 0x04, 0x29, 0xe7, 0x75, 0x64	/* t__pfx___pud */
	.byte 0x04, 0x74, 0xff, 0xbe, 0x64	/* t__pud */
	.byte 0x06, 0xa8, 0xe7, 0x75, 0xe5, 0x76, 0xe1	/* t__pfx_pud_val */
	.byte 0x05, 0x74, 0xbe, 0xe5, 0x76, 0xe1	/* tpud_val */
	.byte 0x05, 0xa8, 0x1f, 0x70, 0x34, 0x64	/* t__pfx_set_p4d */
	.byte 0x06, 0x74, 0xc9, 0xf9, 0x70, 0x34, 0x64	/* tset_p4d */
	.byte 0x04, 0x29, 0xe7, 0x34, 0x64	/* t__pfx___p4d */
	.byte 0x05, 0x74, 0xff, 0x70, 0x34, 0x64	/* t__p4d */
	.byte 0x06, 0xa8, 0xe7, 0x34, 0xe5, 0x76, 0xe1	/* t__pfx_p4d_val */
	.byte 0x05, 0x06, 0x34, 0xe5, 0x76, 0xe1	/* tp4d_val */
	.byte 0x06, 0xa8, 0xe7, 0x67, 0xe5, 0xb6, 0xb4	/* t__pfx_pgd_none */
	.byte 0x05, 0x06, 0x67, 0xe5, 0xb6, 0xb4	/* tpgd_none */
	.byte 0x10, 0xc6, 0x76, 0xbd, 0x6d, 0x84, 0x66, 0x6c, 0x5d, 0x5b, 0xd4, 0x75, 0xc9, 0x64, 0xe7, 0x6d, 0x64	/* t__pfx_vmemmap_flush_unused_pmd */
	.byte 0x10, 0x74, 0x76, 0xbd, 0x6d, 0x84, 0x66, 0x6c, 0x5d, 0x5b, 0xd4, 0x75, 0xc9, 0x64, 0xe7, 0x6d, 0x64	/* tvmemmap_flush_unused_pmd */
	.byte 0x08, 0xc6, 0x87, 0xfa, 0x70, 0x03, 0xdb, 0x62, 0xd3	/* t__pfx_free_pagetable */
	.byte 0x08, 0x74, 0x87, 0xfa, 0x70, 0x03, 0xdb, 0x62, 0xd3	/* tfree_pagetable */
	.byte 0x09, 0xa8, 0xe7, 0x68, 0x79, 0x73, 0xe7, 0x74, 0xfa, 0x8d	/* t__pfx_phys_pte_init */
	.byte 0x08, 0x06, 0x68, 0x79, 0x73, 0xe7, 0x74, 0xfa, 0x8d	/* tphys_pte_init */
	.byte 0x09, 0xa8, 0xe7, 0x34, 0x64, 0xe7, 0x67, 0xdb, 0x62, 0xd3	/* t__pfx_p4d_pgtable */
	.byte 0x08, 0x06, 0x34, 0x64, 0xe7, 0x67, 0xdb, 0x62, 0xd3	/* tp4d_pgtable */
	.byte 0x06, 0xa8, 0xe7, 0x6d, 0xe5, 0xef, 0x6e	/* t__pfx_pmd_pfn */
	.byte 0x05, 0x06, 0x6d, 0xe5, 0xef, 0x6e	/* tpmd_pfn */
	.byte 0x07, 0xc6, 0x89, 0xbb, 0x70, 0x6d, 0xe5, 0x8d	/* t__pfx_ident_pmd_init */
	.byte 0x07, 0xc2, 0x64, 0xbb, 0x70, 0x6d, 0xe5, 0x8d	/* tident_pmd_init */
	.byte 0x09, 0xa8, 0xe7, 0x75, 0x64, 0xe7, 0x67, 0xdb, 0x62, 0xd3	/* t__pfx_pud_pgtable */
	.byte 0x08, 0x74, 0xbe, 0x64, 0xe7, 0x67, 0xdb, 0x62, 0xd3	/* tpud_pgtable */
	.byte 0x09, 0xa8, 0xe7, 0x34, 0xe5, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* t__pfx_p4d_offset */
	.byte 0x08, 0x06, 0x34, 0xe5, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* tp4d_offset */
	.byte 0x0c, 0xa8, 0x95, 0x6e, 0xd5, 0x67, 0xdf, 0x62, 0xe1, 0xe7, 0x67, 0x64, 0x73	/* t__pfx_sync_global_pgds */
	.byte 0x0c, 0x74, 0xc1, 0x6e, 0xd5, 0x67, 0xdf, 0x62, 0xe1, 0xe7, 0x67, 0x64, 0x73	/* tsync_global_pgds */
	.byte 0x06, 0xc6, 0x89, 0xbb, 0xbe, 0xe5, 0x8d	/* t__pfx_ident_pud_init */
	.byte 0x06, 0xc2, 0x64, 0xbb, 0xbe, 0xe5, 0x8d	/* tident_pud_init */
	.byte 0x07, 0xc6, 0x89, 0xbb, 0x70, 0x34, 0xe5, 0x8d	/* t__pfx_ident_p4d_init */
	.byte 0x07, 0xc2, 0x64, 0xbb, 0x70, 0x34, 0xe5, 0x8d	/* tident_p4d_init */
	.byte 0x14, 0xa8, 0xe7, 0x34, 0x64, 0xe7, 0x6f, 0xbe, 0x6c, 0xa1, 0x73, 0x61, 0x66, 0x65, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_p4d_populate_safe.constprop.0 */
	.byte 0x13, 0x06, 0x34, 0x64, 0xe7, 0x6f, 0xbe, 0x6c, 0xa1, 0x73, 0x61, 0x66, 0x65, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tp4d_populate_safe.constprop.0 */
	.byte 0x09, 0xc6, 0xf8, 0xa5, 0x22, 0x70, 0x03, 0xdb, 0x62, 0xd3	/* t__pfx_remove_pagetable */
	.byte 0x09, 0x74, 0xf8, 0xa5, 0x22, 0x70, 0x03, 0xdb, 0x62, 0xd3	/* tremove_pagetable */
	.byte 0x07, 0xc6, 0xb8, 0x6c, 0x6c, 0xe7, 0x75, 0x64	/* t__pfx_fill_pud */
	.byte 0x07, 0x74, 0xb8, 0x6c, 0x6c, 0xe7, 0x75, 0x64	/* tfill_pud */
	.byte 0x09, 0xa8, 0xe7, 0x68, 0x79, 0x73, 0xe7, 0x6d, 0xe5, 0x8d	/* t__pfx_phys_pmd_init */
	.byte 0x08, 0x06, 0x68, 0x79, 0x73, 0xe7, 0x6d, 0xe5, 0x8d	/* tphys_pmd_init */
	.byte 0x09, 0xa8, 0xe7, 0x68, 0x79, 0x73, 0xe7, 0x75, 0xe5, 0x8d	/* t__pfx_phys_pud_init */
	.byte 0x08, 0x06, 0x68, 0x79, 0x73, 0xe7, 0x75, 0xe5, 0x8d	/* tphys_pud_init */
	.byte 0x09, 0xa8, 0xe7, 0x68, 0x79, 0x73, 0xe7, 0x34, 0xe5, 0x8d	/* t__pfx_phys_p4d_init */
	.byte 0x08, 0x06, 0x68, 0x79, 0x73, 0xe7, 0x34, 0xe5, 0x8d	/* tphys_p4d_init */
	.byte 0x06, 0xc6, 0xb8, 0x6c, 0x6c, 0xe7, 0x9a	/* t__pfx_fill_pte */
	.byte 0x06, 0x74, 0xb8, 0x6c, 0x6c, 0xe7, 0x9a	/* tfill_pte */
	.byte 0x07, 0xc6, 0xb8, 0x6c, 0x6c, 0xe7, 0x6d, 0x64	/* t__pfx_fill_pmd */
	.byte 0x07, 0x74, 0xb8, 0x6c, 0x6c, 0xe7, 0x6d, 0x64	/* tfill_pmd */
	.byte 0x08, 0x29, 0x1f, 0x70, 0x74, 0xfa, 0x76, 0x10, 0x72	/* t__pfx___set_pte_vaddr */
	.byte 0x0a, 0x74, 0xff, 0xc9, 0xf9, 0x70, 0x74, 0xfa, 0x76, 0x10, 0x72	/* t__set_pte_vaddr */
	.byte 0x10, 0xa8, 0xe7, 0x67, 0x64, 0xe7, 0x6f, 0xbe, 0x6c, 0x86, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_pgd_populate.constprop.0 */
	.byte 0x0f, 0x06, 0x67, 0x64, 0xe7, 0x6f, 0xbe, 0x6c, 0x86, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tpgd_populate.constprop.0 */
	.byte 0x12, 0x29, 0x5f, 0x6b, 0xee, 0xb4, 0x6c, 0xe7, 0x68, 0x79, 0x73, 0xa3, 0xe1, 0x5f, 0x0a, 0x70, 0xf0, 0xa6, 0x8d	/* t__pfx___kernel_physical_mapping_init */
	.byte 0x11, 0x74, 0xae, 0xee, 0xb4, 0x6c, 0xe7, 0x68, 0x79, 0x73, 0xa3, 0xe1, 0x5f, 0x0a, 0x70, 0xf0, 0xa6, 0x8d	/* t__kernel_physical_mapping_init */
	.byte 0x0d, 0xbf, 0x6b, 0xee, 0xb4, 0xc3, 0x89, 0xbb, 0x0a, 0x70, 0xf0, 0xa6, 0x87, 0x65	/* T__pfx_kernel_ident_mapping_free */
	.byte 0x0d, 0x54, 0x6b, 0xee, 0xb4, 0xc3, 0x89, 0xbb, 0x0a, 0x70, 0xf0, 0xa6, 0x87, 0x65	/* Tkernel_ident_mapping_free */
	.byte 0x0c, 0xbf, 0x6b, 0xee, 0xb4, 0xc3, 0x89, 0xbb, 0x0a, 0x70, 0xf0, 0xa6, 0x8d	/* T__pfx_kernel_ident_mapping_init */
	.byte 0x0c, 0x54, 0x6b, 0xee, 0xb4, 0xc3, 0x89, 0xbb, 0x0a, 0x70, 0xf0, 0xa6, 0x8d	/* Tkernel_ident_mapping_init */
	.byte 0x0b, 0x3f, 0x1f, 0x70, 0x74, 0xfa, 0x76, 0x10, 0x72, 0xe7, 0x34, 0x64	/* T__pfx_set_pte_vaddr_p4d */
	.byte 0x0c, 0x54, 0xc9, 0xf9, 0x70, 0x74, 0xfa, 0x76, 0x10, 0x72, 0xe7, 0x34, 0x64	/* Tset_pte_vaddr_p4d */
	.byte 0x0b, 0x3f, 0x1f, 0x70, 0x74, 0xfa, 0x76, 0x10, 0x72, 0xe7, 0x75, 0x64	/* T__pfx_set_pte_vaddr_pud */
	.byte 0x0c, 0x54, 0xc9, 0xf9, 0x70, 0x74, 0xfa, 0x76, 0x10, 0x72, 0xe7, 0x75, 0x64	/* Tset_pte_vaddr_pud */
	.byte 0x08, 0x3f, 0x1f, 0x70, 0x74, 0xfa, 0x76, 0x10, 0x72	/* T__pfx_set_pte_vaddr */
	.byte 0x09, 0x54, 0xc9, 0xf9, 0x70, 0x74, 0xfa, 0x76, 0x10, 0x72	/* Tset_pte_vaddr */
	.byte 0x11, 0xbf, 0x6b, 0xee, 0xb4, 0x6c, 0xe7, 0x68, 0x79, 0x73, 0xa3, 0xe1, 0x5f, 0x0a, 0x70, 0xf0, 0xa6, 0x8d	/* T__pfx_kernel_physical_mapping_init */
	.byte 0x11, 0x54, 0x6b, 0xee, 0xb4, 0x6c, 0xe7, 0x68, 0x79, 0x73, 0xa3, 0xe1, 0x5f, 0x0a, 0x70, 0xf0, 0xa6, 0x8d	/* Tkernel_physical_mapping_init */
	.byte 0x13, 0xbf, 0x6b, 0xee, 0xb4, 0x6c, 0xe7, 0x68, 0x79, 0x73, 0xa3, 0xe1, 0x5f, 0x0a, 0x70, 0xf0, 0xa6, 0xd0, 0xcc, 0xda	/* T__pfx_kernel_physical_mapping_change */
	.byte 0x13, 0x54, 0x6b, 0xee, 0xb4, 0x6c, 0xe7, 0x68, 0x79, 0x73, 0xa3, 0xe1, 0x5f, 0x0a, 0x70, 0xf0, 0xa6, 0xd0, 0xcc, 0xda	/* Tkernel_physical_mapping_change */
	.byte 0x05, 0xbf, 0x10, 0xe7, 0x03, 0x73	/* T__pfx_add_pages */
	.byte 0x05, 0x54, 0x10, 0xe7, 0x03, 0x73	/* Tadd_pages */
	.byte 0x0a, 0xbf, 0xca, 0xd0, 0x5f, 0xc7, 0xe5, 0xbd, 0x6d, 0xce, 0x79	/* T__pfx_arch_add_memory */
	.byte 0x0a, 0x54, 0xca, 0xd0, 0x5f, 0xc7, 0xe5, 0xbd, 0x6d, 0xce, 0x79	/* Tarch_add_memory */
	.byte 0x0f, 0xbf, 0xbd, 0x6d, 0xce, 0xc5, 0x62, 0x3c, 0xf6, 0x69, 0x7a, 0xfa, 0x62, 0x79, 0x9a, 0x73	/* T__pfx_memory_block_size_bytes */
	.byte 0x0f, 0x54, 0xbd, 0x6d, 0xce, 0xc5, 0x62, 0x3c, 0xf6, 0x69, 0x7a, 0xfa, 0x62, 0x79, 0x9a, 0x73	/* Tmemory_block_size_bytes */
	.byte 0x09, 0xbf, 0x76, 0xbd, 0x6d, 0x0a, 0x1f, 0x70, 0x6d, 0x64	/* T__pfx_vmemmap_set_pmd */
	.byte 0x09, 0x54, 0x76, 0xbd, 0x6d, 0x0a, 0x1f, 0x70, 0x6d, 0x64	/* Tvmemmap_set_pmd */
	.byte 0x0b, 0xbf, 0x76, 0xbd, 0x6d, 0x84, 0x7e, 0x63, 0x6b, 0xe7, 0x6d, 0x64	/* T__pfx_vmemmap_check_pmd */
	.byte 0x0b, 0x54, 0x76, 0xbd, 0x6d, 0x84, 0x7e, 0x63, 0x6b, 0xe7, 0x6d, 0x64	/* Tvmemmap_check_pmd */
	.byte 0x0a, 0xbf, 0x76, 0xbd, 0x6d, 0x0a, 0xe7, 0x6f, 0xbe, 0x6c, 0x86	/* T__pfx_vmemmap_populate */
	.byte 0x0a, 0x54, 0x76, 0xbd, 0x6d, 0x0a, 0xe7, 0x6f, 0xbe, 0x6c, 0x86	/* Tvmemmap_populate */
	.byte 0x0f, 0xbf, 0x18, 0xee, 0xe7, 0x61, 0x21, 0x62, 0x6f, 0x6f, 0x74, 0xbd, 0xcd, 0xbd, 0x6d, 0x0a	/* T__pfx_register_page_bootmem_memmap */
	.byte 0x0f, 0x54, 0x18, 0xee, 0xe7, 0x61, 0x21, 0x62, 0x6f, 0x6f, 0x74, 0xbd, 0xcd, 0xbd, 0x6d, 0x0a	/* Tregister_page_bootmem_memmap */
	.byte 0x10, 0xbf, 0x76, 0xbd, 0x6d, 0x0a, 0xe7, 0x6f, 0xbe, 0x6c, 0xa1, 0x70, 0x72, 0xf0, 0xf9, 0x1b, 0xd6	/* T__pfx_vmemmap_populate_print_last */
	.byte 0x10, 0x54, 0x76, 0xbd, 0x6d, 0x0a, 0xe7, 0x6f, 0xbe, 0x6c, 0xa1, 0x70, 0x72, 0xf0, 0xf9, 0x1b, 0xd6	/* Tvmemmap_populate_print_last */
	.byte 0x0b, 0x29, 0xe7, 0x6b, 0x72, 0x00, 0x08, 0x77, 0x73, 0xe7, 0x0e, 0x79	/* t__pfx___pkru_allows_pkey */
	.byte 0x0c, 0x74, 0xff, 0x70, 0x6b, 0x72, 0x00, 0x08, 0x77, 0x73, 0xe7, 0x0e, 0x79	/* t__pkru_allows_pkey */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xee, 0xe7, 0x61, 0x21, 0x66, 0x61, 0x0b, 0xf9, 0x5d, 0xee	/* T__pfx___traceiter_page_fault_user */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xee, 0xe7, 0x61, 0x21, 0x66, 0x61, 0x0b, 0xf9, 0x5d, 0xee	/* T__traceiter_page_fault_user */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0x62, 0xe7, 0x61, 0x21, 0x66, 0x61, 0x0b, 0xf9, 0x5d, 0xee	/* T__pfx___probestub_page_fault_user */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0x62, 0xe7, 0x61, 0x21, 0x66, 0x61, 0x0b, 0xf9, 0x5d, 0xee	/* T__probestub_page_fault_user */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xee, 0xe7, 0x61, 0x21, 0x66, 0x61, 0x0b, 0xf9, 0x6b, 0xee, 0xb4, 0x6c	/* T__pfx___traceiter_page_fault_kernel */
	.byte 0x0f, 0x2f, 0x01, 0xe4, 0xee, 0xe7, 0x61, 0x21, 0x66, 0x61, 0x0b, 0xf9, 0x6b, 0xee, 0xb4, 0x6c	/* T__traceiter_page_fault_kernel */
	.byte 0x12, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0x62, 0xe7, 0x61, 0x21, 0x66, 0x61, 0x0b, 0xf9, 0x6b, 0xee, 0xb4, 0x6c	/* T__pfx___probestub_page_fault_kernel */
	.byte 0x11, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0x62, 0xe7, 0x61, 0x21, 0x66, 0x61, 0x0b, 0xf9, 0x6b, 0xee, 0xb4, 0x6c	/* T__probestub_page_fault_kernel */
	.byte 0x12, 0xa8, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x6b, 0xee, 0xb4, 0xc3, 0x66, 0x61, 0x0b, 0xf9, 0x7e, 0x63, 0x6b	/* t__pfx_spurious_kernel_fault_check */
	.byte 0x12, 0x74, 0x73, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x6b, 0xee, 0xb4, 0xc3, 0x66, 0x61, 0x0b, 0xf9, 0x7e, 0x63, 0x6b	/* tspurious_kernel_fault_check */
	.byte 0x11, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0x73	/* t__pfx_perf_trace_x86_exceptions */
	.byte 0x10, 0x06, 0xee, 0xa0, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0x73	/* tperf_trace_x86_exceptions */
	.byte 0x11, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0x38, 0x36, 0x5f, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0x73	/* t__pfx_trace_event_raw_event_x86_exceptions */
	.byte 0x11, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x78, 0x38, 0x36, 0x5f, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0x73	/* ttrace_event_raw_event_x86_exceptions */
	.byte 0x13, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0x38, 0x36, 0x5f, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0x73	/* t__pfx_trace_raw_output_x86_exceptions */
	.byte 0x13, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x78, 0x38, 0x36, 0x5f, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0x73	/* ttrace_raw_output_x86_exceptions */
	.byte 0x10, 0x29, 0x5f, 0x40, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0x73	/* t__pfx___bpf_trace_x86_exceptions */
	.byte 0x10, 0x74, 0xff, 0x40, 0xc8, 0x78, 0x38, 0x36, 0x5f, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0x73	/* t__bpf_trace_x86_exceptions */
	.byte 0x0d, 0xc6, 0xab, 0xe7, 0xf8, 0x66, 0x65, 0x74, 0xd0, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_is_prefetch.isra.0 */
	.byte 0x0d, 0xc2, 0x73, 0xe7, 0xf8, 0x66, 0x65, 0x74, 0xd0, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tis_prefetch.isra.0 */
	.byte 0x08, 0xc6, 0xeb, 0x63, 0x3b, 0xe0, 0xee, 0xde, 0x72	/* t__pfx_access_error */
	.byte 0x08, 0x74, 0xeb, 0x63, 0x3b, 0xe0, 0xee, 0xde, 0x72	/* taccess_error */
	.byte 0x0e, 0xc6, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0x2c, 0x6e, 0xe1, 0xe7, 0xe8, 0x64, 0xf0, 0x67	/* t__pfx_fault_signal_pending */
	.byte 0x0e, 0x74, 0x66, 0x61, 0x0b, 0xf9, 0x73, 0x2c, 0x6e, 0xe1, 0xe7, 0xe8, 0x64, 0xf0, 0x67	/* tfault_signal_pending */
	.byte 0x09, 0xa8, 0xe7, 0x34, 0xe5, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* t__pfx_p4d_offset */
	.byte 0x08, 0x06, 0x34, 0xe5, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* tp4d_offset */
	.byte 0x09, 0xc6, 0x64, 0x75, 0xb0, 0xe7, 0x03, 0xdb, 0x62, 0xd3	/* t__pfx_dump_pagetable */
	.byte 0x09, 0x74, 0x64, 0x75, 0xb0, 0xe7, 0x03, 0xdb, 0x62, 0xd3	/* tdump_pagetable */
	.byte 0x08, 0xa8, 0xe7, 0x67, 0xdb, 0x62, 0xb3, 0x62, 0xc7	/* t__pfx_pgtable_bad */
	.byte 0x07, 0x06, 0x67, 0xdb, 0x62, 0xb3, 0x62, 0xc7	/* tpgtable_bad */
	.byte 0x0b, 0xa8, 0xe7, 0x61, 0x21, 0x66, 0x61, 0x0b, 0xf9, 0x6f, 0x81, 0x73	/* t__pfx_page_fault_oops */
	.byte 0x0a, 0x06, 0x61, 0x21, 0x66, 0x61, 0x0b, 0xf9, 0x6f, 0x81, 0x73	/* tpage_fault_oops */
	.byte 0x15, 0xc6, 0x6b, 0xee, 0xb4, 0x6c, 0xa5, 0x64, 0xfa, 0xb8, 0x78, 0x3a, 0xce, 0x5f, 0x6f, 0x81, 0x73, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_kernelmode_fixup_or_oops.isra.0 */
	.byte 0x15, 0x74, 0x6b, 0xee, 0xb4, 0x6c, 0xa5, 0x64, 0xfa, 0xb8, 0x78, 0x3a, 0xce, 0x5f, 0x6f, 0x81, 0x73, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tkernelmode_fixup_or_oops.isra.0 */
	.byte 0x0d, 0x29, 0x5f, 0x62, 0x05, 0x61, 0xf8, 0x61, 0x5f, 0xb6, 0xc9, 0x0a, 0xad, 0xf8	/* t__pfx___bad_area_nosemaphore */
	.byte 0x0d, 0x74, 0xff, 0x62, 0x05, 0x61, 0xf8, 0x61, 0x5f, 0xb6, 0xc9, 0x0a, 0xad, 0xf8	/* t__bad_area_nosemaphore */
	.byte 0x07, 0x29, 0x5f, 0x62, 0x05, 0x61, 0xf8, 0x61	/* t__pfx___bad_area */
	.byte 0x07, 0x74, 0xff, 0x62, 0x05, 0x61, 0xf8, 0x61	/* t__bad_area */
	.byte 0x0e, 0xc6, 0x62, 0x05, 0x61, 0xf8, 0x61, 0x5f, 0xeb, 0x63, 0x3b, 0xe0, 0xee, 0xde, 0x72	/* t__pfx_bad_area_access_error */
	.byte 0x0e, 0x74, 0x62, 0x05, 0x61, 0xf8, 0x61, 0x5f, 0xeb, 0x63, 0x3b, 0xe0, 0xee, 0xde, 0x72	/* tbad_area_access_error */
	.byte 0x0c, 0xc6, 0x62, 0x05, 0x61, 0xf8, 0x61, 0x5f, 0xb6, 0xc9, 0x0a, 0xad, 0xf8	/* t__pfx_bad_area_nosemaphore */
	.byte 0x0c, 0x74, 0x62, 0x05, 0x61, 0xf8, 0x61, 0x5f, 0xb6, 0xc9, 0x0a, 0xad, 0xf8	/* tbad_area_nosemaphore */
	.byte 0x0c, 0xc6, 0xa9, 0x5f, 0x5d, 0xcf, 0x10, 0x72, 0x5f, 0x66, 0x61, 0x0b, 0x74	/* t__pfx_do_user_addr_fault */
	.byte 0x0c, 0x74, 0xa9, 0x5f, 0x5d, 0xcf, 0x10, 0x72, 0x5f, 0x66, 0x61, 0x0b, 0x74	/* tdo_user_addr_fault */
	.byte 0x0f, 0xa8, 0xf6, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x6b, 0xee, 0xb4, 0xc3, 0x66, 0x61, 0x0b, 0x74	/* t__pfx_spurious_kernel_fault */
	.byte 0x0f, 0x74, 0x73, 0xbe, 0x72, 0xd9, 0x75, 0xe0, 0x6b, 0xee, 0xb4, 0xc3, 0x66, 0x61, 0x0b, 0x74	/* tspurious_kernel_fault */
	.byte 0x0d, 0xc6, 0xa9, 0x5f, 0x6b, 0xee, 0x7c, 0x10, 0x72, 0x5f, 0x66, 0x61, 0x0b, 0x74	/* t__pfx_do_kern_addr_fault */
	.byte 0x0d, 0x74, 0xa9, 0x5f, 0x6b, 0xee, 0x7c, 0x10, 0x72, 0x5f, 0x66, 0x61, 0x0b, 0x74	/* tdo_kern_addr_fault */
	.byte 0x0f, 0xbf, 0x66, 0x61, 0x0b, 0xf9, 0xf0, 0x5f, 0x6b, 0xee, 0xb4, 0x6c, 0xf6, 0x70, 0xeb, 0x65	/* T__pfx_fault_in_kernel_space */
	.byte 0x0f, 0x54, 0x66, 0x61, 0x0b, 0xf9, 0xf0, 0x5f, 0x6b, 0xee, 0xb4, 0x6c, 0xf6, 0x70, 0xeb, 0x65	/* Tfault_in_kernel_space */
	.byte 0x10, 0xc6, 0xbd, 0x6d, 0xf8, 0x0a, 0xf6, 0xad, 0x0b, 0xe5, 0x84, 0xe6, 0x63, 0x72, 0x27, 0x9a, 0x64	/* t__pfx_memremap_should_map_decrypted */
	.byte 0x10, 0x74, 0xbd, 0x6d, 0xf8, 0x0a, 0xf6, 0xad, 0x0b, 0xe5, 0x84, 0xe6, 0x63, 0x72, 0x27, 0x9a, 0x64	/* tmemremap_should_map_decrypted */
	.byte 0x0f, 0x29, 0x5f, 0xd9, 0xf8, 0x84, 0xfe, 0x6c, 0xd3, 0x63, 0xf9, 0x84, 0x66, 0x1b, 0x67, 0x73	/* t__pfx___ioremap_collect_map_flags */
	.byte 0x0f, 0x74, 0xff, 0xd9, 0xf8, 0x84, 0xfe, 0x6c, 0xd3, 0x63, 0xf9, 0x84, 0x66, 0x1b, 0x67, 0x73	/* t__ioremap_collect_map_flags */
	.byte 0x08, 0x29, 0x5f, 0xd9, 0xf8, 0x84, 0x28, 0x6c, 0xee	/* t__pfx___ioremap_caller */
	.byte 0x08, 0x74, 0xff, 0xd9, 0xf8, 0x84, 0x28, 0x6c, 0xee	/* t__ioremap_caller */
	.byte 0x08, 0xbf, 0xd9, 0xf8, 0x84, 0x63, 0xeb, 0x68, 0x65	/* T__pfx_ioremap_cache */
	.byte 0x08, 0x54, 0xd9, 0xf8, 0x84, 0x63, 0xeb, 0x68, 0x65	/* Tioremap_cache */
	.byte 0x0a, 0xbf, 0xd9, 0xf8, 0x84, 0xe8, 0x63, 0x72, 0x27, 0x9a, 0x64	/* T__pfx_ioremap_encrypted */
	.byte 0x0a, 0x54, 0xd9, 0xf8, 0x84, 0xe8, 0x63, 0x72, 0x27, 0x9a, 0x64	/* Tioremap_encrypted */
	.byte 0x06, 0xbf, 0xd9, 0xf8, 0x84, 0x77, 0x74	/* T__pfx_ioremap_wt */
	.byte 0x06, 0x54, 0xd9, 0xf8, 0x84, 0x77, 0x74	/* Tioremap_wt */
	.byte 0x06, 0xbf, 0xd9, 0xf8, 0x84, 0x77, 0x63	/* T__pfx_ioremap_wc */
	.byte 0x06, 0x54, 0xd9, 0xf8, 0x84, 0x77, 0x63	/* Tioremap_wc */
	.byte 0x06, 0xbf, 0xd9, 0xf8, 0x84, 0x75, 0x63	/* T__pfx_ioremap_uc */
	.byte 0x06, 0x54, 0xd9, 0xf8, 0x84, 0x75, 0x63	/* Tioremap_uc */
	.byte 0x04, 0xbf, 0xd9, 0xf8, 0x0a	/* T__pfx_ioremap */
	.byte 0x04, 0x54, 0xd9, 0xf8, 0x0a	/* Tioremap */
	.byte 0x06, 0xbf, 0xd9, 0xf8, 0x0a, 0x25, 0x74	/* T__pfx_ioremap_prot */
	.byte 0x06, 0x54, 0xd9, 0xf8, 0x0a, 0x25, 0x74	/* Tioremap_prot */
	.byte 0x04, 0xbf, 0xd9, 0xd4, 0x0a	/* T__pfx_iounmap */
	.byte 0x04, 0x54, 0xd9, 0xd4, 0x0a	/* Tiounmap */
	.byte 0x11, 0xc6, 0xbd, 0x6d, 0xf8, 0x84, 0x69, 0xe0, 0x65, 0x66, 0xcb, 0x64, 0x0f, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_memremap_is_efi_data.isra.0 */
	.byte 0x11, 0x74, 0xbd, 0x6d, 0xf8, 0x84, 0x69, 0xe0, 0x65, 0x66, 0xcb, 0x64, 0x0f, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tmemremap_is_efi_data.isra.0 */
	.byte 0x09, 0xbf, 0xd9, 0xf8, 0x84, 0xd0, 0xcc, 0x21, 0xe9, 0xea	/* T__pfx_ioremap_change_attr */
	.byte 0x09, 0x54, 0xd9, 0xf8, 0x84, 0xd0, 0xcc, 0x21, 0xe9, 0xea	/* Tioremap_change_attr */
	.byte 0x09, 0xbf, 0x78, 0x6c, 0xa1, 0x19, 0xbd, 0x6d, 0xe7, 0xea	/* T__pfx_xlate_dev_mem_ptr */
	.byte 0x09, 0x54, 0x78, 0x6c, 0xa1, 0x19, 0xbd, 0x6d, 0xe7, 0xea	/* Txlate_dev_mem_ptr */
	.byte 0x0a, 0xbf, 0xd4, 0x78, 0x6c, 0xa1, 0x19, 0xbd, 0x6d, 0xe7, 0xea	/* T__pfx_unxlate_dev_mem_ptr */
	.byte 0x0a, 0x54, 0xd4, 0x78, 0x6c, 0xa1, 0x19, 0xbd, 0x6d, 0xe7, 0xea	/* Tunxlate_dev_mem_ptr */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0xbd, 0x6d, 0xf8, 0x84, 0x63, 0xcc, 0x5f, 0xb5, 0xcd, 0xf8, 0x0a	/* T__pfx_arch_memremap_can_ram_remap */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0xbd, 0x6d, 0xf8, 0x84, 0x63, 0xcc, 0x5f, 0xb5, 0xcd, 0xf8, 0x0a	/* Tarch_memremap_can_ram_remap */
	.byte 0x11, 0x3f, 0xe7, 0x68, 0x79, 0xe0, 0xbd, 0xcd, 0xeb, 0x63, 0x3b, 0xe0, 0xe8, 0x63, 0x72, 0x27, 0x9a, 0x64	/* T__pfx_phys_mem_access_encrypted */
	.byte 0x11, 0x54, 0x70, 0x68, 0x79, 0xe0, 0xbd, 0xcd, 0xeb, 0x63, 0x3b, 0xe0, 0xe8, 0x63, 0x72, 0x27, 0x9a, 0x64	/* Tphys_mem_access_encrypted */
	.byte 0x0c, 0xc6, 0xd1, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0x7a, 0xee, 0x81, 0xc7	/* t__pfx_ex_handler_zeropad */
	.byte 0x0c, 0x74, 0xd1, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0x7a, 0xee, 0x81, 0xc7	/* tex_handler_zeropad */
	.byte 0x12, 0xc6, 0xd1, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0x75, 0xeb, 0x63, 0x3b, 0x73, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_ex_handler_uaccess.isra.0 */
	.byte 0x12, 0x74, 0xd1, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0x75, 0xeb, 0x63, 0x3b, 0x73, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tex_handler_uaccess.isra.0 */
	.byte 0x0f, 0xc6, 0xd1, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0x20, 0x72, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_ex_handler_msr.isra.0 */
	.byte 0x0f, 0x74, 0xd1, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0x20, 0x72, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tex_handler_msr.isra.0 */
	.byte 0x0a, 0xbf, 0xd1, 0x5f, 0xb2, 0xb8, 0x78, 0x3a, 0x74, 0x27, 0x65	/* T__pfx_ex_get_fixup_type */
	.byte 0x0a, 0x54, 0xd1, 0x5f, 0xb2, 0xb8, 0x78, 0x3a, 0x74, 0x27, 0x65	/* Tex_get_fixup_type */
	.byte 0x0b, 0xbf, 0xb8, 0x78, 0x3a, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e	/* T__pfx_fixup_exception */
	.byte 0x0b, 0x54, 0xb8, 0x78, 0x3a, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e	/* Tfixup_exception */
	.byte 0x07, 0xc6, 0xca, 0xd0, 0x5f, 0x72, 0x6e, 0x64	/* t__pfx_arch_rnd */
	.byte 0x07, 0xdb, 0x72, 0xd0, 0x5f, 0x72, 0x6e, 0x64	/* tarch_rnd */
	.byte 0x0b, 0xc6, 0xca, 0xd0, 0xe7, 0xa3, 0xd8, 0x6d, 0x84, 0x62, 0x61, 0xc9	/* t__pfx_arch_pick_mmap_base */
	.byte 0x0b, 0xdb, 0x72, 0xd0, 0xe7, 0xa3, 0xd8, 0x6d, 0x84, 0x62, 0x61, 0xc9	/* tarch_pick_mmap_base */
	.byte 0x0b, 0xbf, 0xdb, 0x16, 0xf6, 0x69, 0x7a, 0xfa, 0x33, 0x32, 0x62, 0xe4	/* T__pfx_task_size_32bit */
	.byte 0x0b, 0x54, 0xdb, 0x16, 0xf6, 0x69, 0x7a, 0xfa, 0x33, 0x32, 0x62, 0xe4	/* Ttask_size_32bit */
	.byte 0x0b, 0xbf, 0xdb, 0x16, 0xf6, 0x69, 0x7a, 0xfa, 0x36, 0x34, 0x62, 0xe4	/* T__pfx_task_size_64bit */
	.byte 0x0b, 0x54, 0xdb, 0x16, 0xf6, 0x69, 0x7a, 0xfa, 0x36, 0x34, 0x62, 0xe4	/* Ttask_size_64bit */
	.byte 0x09, 0xbf, 0xca, 0xd0, 0x5f, 0x6d, 0x84, 0x72, 0x6e, 0x64	/* T__pfx_arch_mmap_rnd */
	.byte 0x09, 0x54, 0xca, 0xd0, 0x5f, 0x6d, 0x84, 0x72, 0x6e, 0x64	/* Tarch_mmap_rnd */
	.byte 0x0c, 0xbf, 0xca, 0xd0, 0xe7, 0xa3, 0xd8, 0x6d, 0x84, 0x1b, 0x79, 0x6f, 0x5e	/* T__pfx_arch_pick_mmap_layout */
	.byte 0x0c, 0x54, 0xca, 0xd0, 0xe7, 0xa3, 0xd8, 0x6d, 0x84, 0x1b, 0x79, 0x6f, 0x5e	/* Tarch_pick_mmap_layout */
	.byte 0x07, 0xbf, 0xb2, 0x6d, 0x84, 0x62, 0x61, 0xc9	/* T__pfx_get_mmap_base */
	.byte 0x07, 0x54, 0xb2, 0x6d, 0x84, 0x62, 0x61, 0xc9	/* Tget_mmap_base */
	.byte 0x0a, 0xbf, 0xca, 0xd0, 0x5f, 0x76, 0xdd, 0x5f, 0x6e, 0x61, 0xbd	/* T__pfx_arch_vma_name */
	.byte 0x0a, 0x54, 0xca, 0xd0, 0x5f, 0x76, 0xdd, 0x5f, 0x6e, 0x61, 0xbd	/* Tarch_vma_name */
	.byte 0x0c, 0xbf, 0x6d, 0x84, 0x10, 0x3d, 0xe0, 0x68, 0xf0, 0xf9, 0x76, 0xe1, 0x89	/* T__pfx_mmap_address_hint_valid */
	.byte 0x0c, 0x54, 0x6d, 0x84, 0x10, 0x3d, 0xe0, 0x68, 0xf0, 0xf9, 0x76, 0xe1, 0x89	/* Tmmap_address_hint_valid */
	.byte 0x0e, 0xbf, 0x76, 0xe1, 0x89, 0xe7, 0x68, 0x79, 0xe0, 0x10, 0x72, 0x5f, 0x72, 0xcc, 0xda	/* T__pfx_valid_phys_addr_range */
	.byte 0x0e, 0x54, 0x76, 0xe1, 0x89, 0xe7, 0x68, 0x79, 0xe0, 0x10, 0x72, 0x5f, 0x72, 0xcc, 0xda	/* Tvalid_phys_addr_range */
	.byte 0x11, 0xbf, 0x76, 0xe1, 0x69, 0xe5, 0x6d, 0x0a, 0xe7, 0x68, 0x79, 0xe0, 0x10, 0x72, 0x5f, 0x72, 0xcc, 0xda	/* T__pfx_valid_mmap_phys_addr_range */
	.byte 0x11, 0x54, 0x76, 0xe1, 0x69, 0xe5, 0x6d, 0x0a, 0xe7, 0x68, 0x79, 0xe0, 0x10, 0x72, 0x5f, 0x72, 0xcc, 0xda	/* Tvalid_mmap_phys_addr_range */
	.byte 0x0c, 0xbf, 0xef, 0x7c, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0x08, 0x77, 0x65, 0x64	/* T__pfx_pfn_modify_allowed */
	.byte 0x0c, 0x54, 0xef, 0x7c, 0xa5, 0x64, 0x69, 0x66, 0xc5, 0x08, 0x77, 0x65, 0x64	/* Tpfn_modify_allowed */
	.byte 0x05, 0xc6, 0xef, 0x6e, 0xe7, 0x9a	/* t__pfx_pfn_pte */
	.byte 0x05, 0x74, 0xef, 0x6e, 0xe7, 0x9a	/* tpfn_pte */
	.byte 0x16, 0xc6, 0x6c, 0x72, 0x75, 0x76, 0x65, 0x63, 0xf6, 0xdb, 0xf9, 0xa5, 0xe5, 0x66, 0x7f, 0xd9, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_lruvec_stat_mod_folio.constprop.0 */
	.byte 0x16, 0x74, 0x6c, 0x72, 0x75, 0x76, 0x65, 0x63, 0xf6, 0xdb, 0xf9, 0xa5, 0xe5, 0x66, 0x7f, 0xd9, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tlruvec_stat_mod_folio.constprop.0 */
	.byte 0x08, 0x3f, 0xe7, 0x74, 0xfa, 0x08, 0xd5, 0x6f, 0xb4	/* T__pfx_pte_alloc_one */
	.byte 0x08, 0x54, 0x70, 0x74, 0xfa, 0x08, 0xd5, 0x6f, 0xb4	/* Tpte_alloc_one */
	.byte 0x0b, 0x3f, 0xff, 0xff, 0x70, 0x74, 0xfa, 0x87, 0xfa, 0x74, 0x6c, 0x62	/* T__pfx____pte_free_tlb */
	.byte 0x09, 0x2f, 0xe7, 0x74, 0xfa, 0x87, 0xfa, 0x74, 0x6c, 0x62	/* T___pte_free_tlb */
	.byte 0x0b, 0x3f, 0xff, 0xff, 0x70, 0x6d, 0xe5, 0x87, 0xfa, 0x74, 0x6c, 0x62	/* T__pfx____pmd_free_tlb */
	.byte 0x09, 0x2f, 0xe7, 0x6d, 0xe5, 0x87, 0xfa, 0x74, 0x6c, 0x62	/* T___pmd_free_tlb */
	.byte 0x0a, 0x3f, 0xff, 0xff, 0xbe, 0xe5, 0x87, 0xfa, 0x74, 0x6c, 0x62	/* T__pfx____pud_free_tlb */
	.byte 0x09, 0x2f, 0xe7, 0x75, 0xe5, 0x87, 0xfa, 0x74, 0x6c, 0x62	/* T___pud_free_tlb */
	.byte 0x0b, 0x3f, 0xff, 0xff, 0x70, 0x34, 0xe5, 0x87, 0xfa, 0x74, 0x6c, 0x62	/* T__pfx____p4d_free_tlb */
	.byte 0x09, 0x2f, 0xe7, 0x34, 0xe5, 0x87, 0xfa, 0x74, 0x6c, 0x62	/* T___p4d_free_tlb */
	.byte 0x0a, 0x3f, 0xe7, 0x67, 0x64, 0xe7, 0x61, 0x21, 0xb2, 0x6d, 0x6d	/* T__pfx_pgd_page_get_mm */
	.byte 0x0a, 0x54, 0x70, 0x67, 0x64, 0xe7, 0x61, 0x21, 0xb2, 0x6d, 0x6d	/* Tpgd_page_get_mm */
	.byte 0x06, 0x3f, 0xe7, 0x67, 0xe5, 0xe1, 0xc0	/* T__pfx_pgd_alloc */
	.byte 0x06, 0x54, 0x70, 0x67, 0xe5, 0xe1, 0xc0	/* Tpgd_alloc */
	.byte 0x06, 0x3f, 0xe7, 0x67, 0xe5, 0x87, 0x65	/* T__pfx_pgd_free */
	.byte 0x06, 0x54, 0x70, 0x67, 0xe5, 0x87, 0x65	/* Tpgd_free */
	.byte 0x0d, 0x3f, 0xe7, 0x9a, 0x70, 0x1f, 0xeb, 0x63, 0x3b, 0xe0, 0x66, 0x1b, 0x67, 0x73	/* T__pfx_ptep_set_access_flags */
	.byte 0x0d, 0x54, 0x70, 0x9a, 0x70, 0x1f, 0xeb, 0x63, 0x3b, 0xe0, 0x66, 0x1b, 0x67, 0x73	/* Tptep_set_access_flags */
	.byte 0x0e, 0x3f, 0xe7, 0x6d, 0x64, 0x70, 0x1f, 0xeb, 0x63, 0x3b, 0xe0, 0x66, 0x1b, 0x67, 0x73	/* T__pfx_pmdp_set_access_flags */
	.byte 0x0e, 0x54, 0x70, 0x6d, 0x64, 0x70, 0x1f, 0xeb, 0x63, 0x3b, 0xe0, 0x66, 0x1b, 0x67, 0x73	/* Tpmdp_set_access_flags */
	.byte 0x0e, 0x3f, 0xe7, 0x75, 0x64, 0x70, 0x1f, 0xeb, 0x63, 0x3b, 0xe0, 0x66, 0x1b, 0x67, 0x73	/* T__pfx_pudp_set_access_flags */
	.byte 0x0d, 0x54, 0xbe, 0x64, 0x70, 0x1f, 0xeb, 0x63, 0x3b, 0xe0, 0x66, 0x1b, 0x67, 0x73	/* Tpudp_set_access_flags */
	.byte 0x11, 0x3f, 0xe7, 0x9a, 0xe2, 0x9a, 0x73, 0xf9, 0xcc, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x79, 0x6f, 0xd4, 0x67	/* T__pfx_ptep_test_and_clear_young */
	.byte 0x11, 0x54, 0x70, 0x9a, 0xe2, 0x9a, 0x73, 0xf9, 0xcc, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x79, 0x6f, 0xd4, 0x67	/* Tptep_test_and_clear_young */
	.byte 0x12, 0x3f, 0xe7, 0x6d, 0x64, 0xe2, 0x9a, 0x73, 0xf9, 0xcc, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x79, 0x6f, 0xd4, 0x67	/* T__pfx_pmdp_test_and_clear_young */
	.byte 0x12, 0x54, 0x70, 0x6d, 0x64, 0xe2, 0x9a, 0x73, 0xf9, 0xcc, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x79, 0x6f, 0xd4, 0x67	/* Tpmdp_test_and_clear_young */
	.byte 0x12, 0x3f, 0xe7, 0x75, 0x64, 0xe2, 0x9a, 0x73, 0xf9, 0xcc, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x79, 0x6f, 0xd4, 0x67	/* T__pfx_pudp_test_and_clear_young */
	.byte 0x11, 0x54, 0xbe, 0x64, 0xe2, 0x9a, 0x73, 0xf9, 0xcc, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x79, 0x6f, 0xd4, 0x67	/* Tpudp_test_and_clear_young */
	.byte 0x10, 0x3f, 0xe7, 0x9a, 0xe2, 0x63, 0xd3, 0xca, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x79, 0x6f, 0xd4, 0x67	/* T__pfx_ptep_clear_flush_young */
	.byte 0x10, 0x54, 0x70, 0x9a, 0xe2, 0x63, 0xd3, 0xca, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x79, 0x6f, 0xd4, 0x67	/* Tptep_clear_flush_young */
	.byte 0x11, 0x3f, 0xe7, 0x6d, 0x64, 0xe2, 0x63, 0xd3, 0xca, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x79, 0x6f, 0xd4, 0x67	/* T__pfx_pmdp_clear_flush_young */
	.byte 0x11, 0x54, 0x70, 0x6d, 0x64, 0xe2, 0x63, 0xd3, 0xca, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x79, 0x6f, 0xd4, 0x67	/* Tpmdp_clear_flush_young */
	.byte 0x0b, 0x3f, 0xe7, 0x6d, 0x64, 0xe2, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0xc7	/* T__pfx_pmdp_invalidate_ad */
	.byte 0x0b, 0x54, 0x70, 0x6d, 0x64, 0xe2, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0xc7	/* Tpmdp_invalidate_ad */
	.byte 0x0a, 0x3f, 0xe7, 0x75, 0x64, 0xe2, 0xf0, 0x76, 0xe1, 0x89, 0x86	/* T__pfx_pudp_invalidate */
	.byte 0x09, 0x54, 0xbe, 0x64, 0xe2, 0xf0, 0x76, 0xe1, 0x89, 0x86	/* Tpudp_invalidate */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0xb8, 0x78, 0x0a	/* T__pfx___native_set_fixmap */
	.byte 0x0a, 0x2f, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0xb8, 0x78, 0x0a	/* T__native_set_fixmap */
	.byte 0x0a, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0xb8, 0x78, 0x0a	/* T__pfx_native_set_fixmap */
	.byte 0x0a, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0xc9, 0xf9, 0xb8, 0x78, 0x0a	/* Tnative_set_fixmap */
	.byte 0x08, 0x3f, 0xe7, 0x34, 0x64, 0x1f, 0x68, 0x75, 0xda	/* T__pfx_p4d_set_huge */
	.byte 0x08, 0x54, 0x70, 0x34, 0x64, 0x1f, 0x68, 0x75, 0xda	/* Tp4d_set_huge */
	.byte 0x0b, 0x3f, 0xe7, 0x34, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x68, 0x75, 0xda	/* T__pfx_p4d_clear_huge */
	.byte 0x0b, 0x54, 0x70, 0x34, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x68, 0x75, 0xda	/* Tp4d_clear_huge */
	.byte 0x08, 0x3f, 0xe7, 0x75, 0x64, 0x1f, 0x68, 0x75, 0xda	/* T__pfx_pud_set_huge */
	.byte 0x07, 0x54, 0xbe, 0x64, 0x1f, 0x68, 0x75, 0xda	/* Tpud_set_huge */
	.byte 0x08, 0x3f, 0xe7, 0x6d, 0x64, 0x1f, 0x68, 0x75, 0xda	/* T__pfx_pmd_set_huge */
	.byte 0x08, 0x54, 0x70, 0x6d, 0x64, 0x1f, 0x68, 0x75, 0xda	/* Tpmd_set_huge */
	.byte 0x0b, 0x3f, 0xe7, 0x75, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x68, 0x75, 0xda	/* T__pfx_pud_clear_huge */
	.byte 0x0a, 0x54, 0xbe, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x68, 0x75, 0xda	/* Tpud_clear_huge */
	.byte 0x0b, 0x3f, 0xe7, 0x6d, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x68, 0x75, 0xda	/* T__pfx_pmd_clear_huge */
	.byte 0x0b, 0x54, 0x70, 0x6d, 0xe5, 0x63, 0xd3, 0xca, 0x5f, 0x68, 0x75, 0xda	/* Tpmd_clear_huge */
	.byte 0x0b, 0x3f, 0xe7, 0x75, 0xe5, 0x87, 0xfa, 0x70, 0x6d, 0x64, 0xe7, 0x03	/* T__pfx_pud_free_pmd_page */
	.byte 0x0a, 0x54, 0xbe, 0xe5, 0x87, 0xfa, 0x70, 0x6d, 0x64, 0xe7, 0x03	/* Tpud_free_pmd_page */
	.byte 0x0b, 0x3f, 0xe7, 0x6d, 0xe5, 0x87, 0xfa, 0x70, 0x74, 0xfa, 0x70, 0x03	/* T__pfx_pmd_free_pte_page */
	.byte 0x0b, 0x54, 0x70, 0x6d, 0xe5, 0x87, 0xfa, 0x70, 0x74, 0xfa, 0x70, 0x03	/* Tpmd_free_pte_page */
	.byte 0x08, 0x3f, 0xe7, 0x74, 0xfa, 0x6d, 0x6b, 0x24, 0x65	/* T__pfx_pte_mkwrite */
	.byte 0x08, 0x54, 0x70, 0x74, 0xfa, 0x6d, 0x6b, 0x24, 0x65	/* Tpte_mkwrite */
	.byte 0x08, 0x3f, 0xe7, 0x6d, 0xe5, 0x6d, 0x6b, 0x24, 0x65	/* T__pfx_pmd_mkwrite */
	.byte 0x08, 0x54, 0x70, 0x6d, 0xe5, 0x6d, 0x6b, 0x24, 0x65	/* Tpmd_mkwrite */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0x7e, 0x63, 0xd8, 0x7a, 0x61, 0x70, 0x70, 0x65, 0x64, 0xe7, 0x9a	/* T__pfx_arch_check_zapped_pte */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0x7e, 0x63, 0xd8, 0x7a, 0x61, 0x70, 0x70, 0x65, 0x64, 0xe7, 0x9a	/* Tarch_check_zapped_pte */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0x5f, 0x7e, 0x63, 0xd8, 0x7a, 0x61, 0x70, 0x70, 0x65, 0x64, 0xe7, 0x6d, 0x64	/* T__pfx_arch_check_zapped_pmd */
	.byte 0x10, 0x54, 0xca, 0xd0, 0x5f, 0x7e, 0x63, 0xd8, 0x7a, 0x61, 0x70, 0x70, 0x65, 0x64, 0xe7, 0x6d, 0x64	/* Tarch_check_zapped_pmd */
	.byte 0x10, 0xbf, 0xca, 0xd0, 0x5f, 0x7e, 0x63, 0xd8, 0x7a, 0x61, 0x70, 0x70, 0x65, 0x64, 0xe7, 0x75, 0x64	/* T__pfx_arch_check_zapped_pud */
	.byte 0x10, 0x54, 0xca, 0xd0, 0x5f, 0x7e, 0x63, 0xd8, 0x7a, 0x61, 0x70, 0x70, 0x65, 0x64, 0xe7, 0x75, 0x64	/* Tarch_check_zapped_pud */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x76, 0xa7, 0xf9, 0x10, 0x72, 0x5f, 0x76, 0xe1, 0x89	/* T__pfx___virt_addr_valid */
	.byte 0x0a, 0x2f, 0x76, 0xa7, 0xf9, 0x10, 0x72, 0x5f, 0x76, 0xe1, 0x89	/* T__virt_addr_valid */
	.byte 0x0a, 0xc6, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0x5d, 0xcf, 0x96, 0x89	/* t__pfx_invalidate_user_asid */
	.byte 0x0a, 0x74, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0x5d, 0xcf, 0x96, 0x89	/* tinvalidate_user_asid */
	.byte 0x0b, 0xc6, 0x74, 0x6c, 0xdc, 0x69, 0xe0, 0xb6, 0xf9, 0x1b, 0x7a, 0x79	/* t__pfx_tlb_is_not_lazy */
	.byte 0x0b, 0x74, 0x74, 0x6c, 0xdc, 0x69, 0xe0, 0xb6, 0xf9, 0x1b, 0x7a, 0x79	/* ttlb_is_not_lazy */
	.byte 0x10, 0xc6, 0x6c, 0x31, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x66, 0xce, 0x63, 0xfa, 0x73, 0x2c, 0xa2, 0x73	/* t__pfx_l1d_flush_force_sigbus */
	.byte 0x10, 0x74, 0x6c, 0x31, 0xe5, 0x66, 0x6c, 0x5d, 0x5b, 0x66, 0xce, 0x63, 0xfa, 0x73, 0x2c, 0xa2, 0x73	/* tl1d_flush_force_sigbus */
	.byte 0x09, 0xc6, 0xc8, 0x74, 0x6c, 0xdc, 0x66, 0x6c, 0x5d, 0x68	/* t__pfx_trace_tlb_flush */
	.byte 0x09, 0x74, 0xc8, 0x74, 0x6c, 0xdc, 0x66, 0x6c, 0x5d, 0x68	/* ttrace_tlb_flush */
	.byte 0x0c, 0xc6, 0x74, 0x6c, 0x62, 0x66, 0x6c, 0x5d, 0x5b, 0x24, 0xfa, 0xb8, 0xd3	/* t__pfx_tlbflush_write_file */
	.byte 0x0c, 0x74, 0x74, 0x6c, 0x62, 0x66, 0x6c, 0x5d, 0x5b, 0x24, 0xfa, 0xb8, 0xd3	/* ttlbflush_write_file */
	.byte 0x0c, 0xc6, 0x74, 0x6c, 0x62, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x05, 0xb8, 0xd3	/* t__pfx_tlbflush_read_file */
	.byte 0x0c, 0x74, 0x74, 0x6c, 0x62, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x05, 0xb8, 0xd3	/* ttlbflush_read_file */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0xe1, 0x6c	/* T__pfx___flush_tlb_all */
	.byte 0x0a, 0x2f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0xe1, 0x6c	/* T__flush_tlb_all */
	.byte 0x0c, 0xc6, 0xa9, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0xe1, 0x6c	/* t__pfx_do_flush_tlb_all */
	.byte 0x0c, 0x74, 0xa9, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0xe1, 0x6c	/* tdo_flush_tlb_all */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0xb2, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x63, 0x72, 0x33, 0x5f, 0x66, 0x61, 0xd6	/* T__pfx___get_current_cr3_fast */
	.byte 0x10, 0x54, 0xfd, 0x65, 0xf9, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x63, 0x72, 0x33, 0x5f, 0x66, 0x61, 0xd6	/* T__get_current_cr3_fast */
	.byte 0x11, 0xc6, 0xdf, 0x05, 0xb4, 0xaa, 0x6d, 0xcd, 0x63, 0x72, 0x33, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_load_new_mm_cr3.constprop.0 */
	.byte 0x11, 0x74, 0xdf, 0x05, 0xb4, 0xaa, 0x6d, 0xcd, 0x63, 0x72, 0x33, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tload_new_mm_cr3.constprop.0 */
	.byte 0x0a, 0xbf, 0x63, 0x72, 0x5c, 0xb9, 0x64, 0xa1, 0x70, 0x63, 0x65	/* T__pfx_cr4_update_pce */
	.byte 0x0a, 0x54, 0x63, 0x72, 0x5c, 0xb9, 0x64, 0xa1, 0x70, 0x63, 0x65	/* Tcr4_update_pce */
	.byte 0x0e, 0x3f, 0xf6, 0x77, 0xe4, 0xd0, 0x5f, 0x6d, 0xcd, 0xa7, 0x71, 0xe0, 0x6f, 0x66, 0x66	/* T__pfx_switch_mm_irqs_off */
	.byte 0x0e, 0x54, 0x73, 0x77, 0xe4, 0xd0, 0x5f, 0x6d, 0xcd, 0xa7, 0x71, 0xe0, 0x6f, 0x66, 0x66	/* Tswitch_mm_irqs_off */
	.byte 0x0a, 0xc6, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x2b, 0x63	/* t__pfx_flush_tlb_func */
	.byte 0x0a, 0x74, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x2b, 0x63	/* tflush_tlb_func */
	.byte 0x08, 0x3f, 0xf6, 0x77, 0xe4, 0xd0, 0x5f, 0x6d, 0x6d	/* T__pfx_switch_mm */
	.byte 0x08, 0x54, 0x73, 0x77, 0xe4, 0xd0, 0x5f, 0x6d, 0x6d	/* Tswitch_mm */
	.byte 0x06, 0xbf, 0xd3, 0x61, 0x22, 0x6d, 0x6d	/* T__pfx_leave_mm */
	.byte 0x06, 0x54, 0xd3, 0x61, 0x22, 0x6d, 0x6d	/* Tleave_mm */
	.byte 0x09, 0xbf, 0x1e, 0xcf, 0x1b, 0x7a, 0xc5, 0x74, 0x6c, 0x62	/* T__pfx_enter_lazy_tlb */
	.byte 0x09, 0x54, 0x1e, 0xcf, 0x1b, 0x7a, 0xc5, 0x74, 0x6c, 0x62	/* Tenter_lazy_tlb */
	.byte 0x12, 0xbf, 0x8d, 0x69, 0xe1, 0x69, 0x7a, 0xfa, 0x74, 0x6c, 0x62, 0xd6, 0xa1, 0xcc, 0xe5, 0x66, 0x6c, 0x5d, 0x68	/* T__pfx_initialize_tlbstate_and_flush */
	.byte 0x12, 0x54, 0x8d, 0x69, 0xe1, 0x69, 0x7a, 0xfa, 0x74, 0x6c, 0x62, 0xd6, 0xa1, 0xcc, 0xe5, 0x66, 0x6c, 0x5d, 0x68	/* Tinitialize_tlbstate_and_flush */
	.byte 0x0f, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* T__pfx_native_flush_tlb_multi */
	.byte 0x0f, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* Tnative_flush_tlb_multi */
	.byte 0x0b, 0xbf, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* T__pfx_flush_tlb_multi */
	.byte 0x0b, 0x54, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0x0b, 0xc2	/* Tflush_tlb_multi */
	.byte 0x0d, 0xbf, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0xcd, 0x72, 0xcc, 0xda	/* T__pfx_flush_tlb_mm_range */
	.byte 0x0d, 0x54, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6d, 0xcd, 0x72, 0xcc, 0xda	/* Tflush_tlb_mm_range */
	.byte 0x0a, 0xbf, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0xe1, 0x6c	/* T__pfx_flush_tlb_all */
	.byte 0x0a, 0x54, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0xe1, 0x6c	/* Tflush_tlb_all */
	.byte 0x0f, 0xbf, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6b, 0xee, 0xb4, 0xc3, 0x72, 0xcc, 0xda	/* T__pfx_flush_tlb_kernel_range */
	.byte 0x0f, 0x54, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6b, 0xee, 0xb4, 0xc3, 0x72, 0xcc, 0xda	/* Tflush_tlb_kernel_range */
	.byte 0x0f, 0xbf, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x6b, 0xee, 0xb4, 0x6c	/* T__pfx_flush_tlb_one_kernel */
	.byte 0x0f, 0x54, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x6b, 0xee, 0xb4, 0x6c	/* Tflush_tlb_one_kernel */
	.byte 0x0e, 0xc6, 0xa9, 0x5f, 0x6b, 0xee, 0xb4, 0xc3, 0x72, 0xcc, 0x21, 0x66, 0x6c, 0x5d, 0x68	/* t__pfx_do_kernel_range_flush */
	.byte 0x0e, 0x74, 0xa9, 0x5f, 0x6b, 0xee, 0xb4, 0xc3, 0x72, 0xcc, 0x21, 0x66, 0x6c, 0x5d, 0x68	/* tdo_kernel_range_flush */
	.byte 0x11, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* T__pfx_native_flush_tlb_one_user */
	.byte 0x11, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* Tnative_flush_tlb_one_user */
	.byte 0x0d, 0xbf, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* T__pfx_flush_tlb_one_user */
	.byte 0x0d, 0x54, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x6f, 0x6e, 0xfa, 0x5d, 0xee	/* Tflush_tlb_one_user */
	.byte 0x10, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x67, 0xdf, 0x62, 0xe1	/* T__pfx_native_flush_tlb_global */
	.byte 0x10, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0x67, 0xdf, 0x62, 0xe1	/* Tnative_flush_tlb_global */
	.byte 0x0e, 0xbf, 0x6e, 0xe9, 0x69, 0x22, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0xc0, 0xe1	/* T__pfx_native_flush_tlb_local */
	.byte 0x0e, 0x54, 0x6e, 0xe9, 0x69, 0x22, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0xc0, 0xe1	/* Tnative_flush_tlb_local */
	.byte 0x0a, 0xbf, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0xc0, 0xe1	/* T__pfx_flush_tlb_local */
	.byte 0x0a, 0x54, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0xdc, 0xc0, 0xe1	/* Tflush_tlb_local */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0x74, 0x6c, 0x62, 0x62, 0xe9, 0xd0, 0x5f, 0x66, 0x6c, 0x5d, 0x68	/* T__pfx_arch_tlbbatch_flush */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0x74, 0x6c, 0x62, 0x62, 0xe9, 0xd0, 0x5f, 0x66, 0x6c, 0x5d, 0x68	/* Tarch_tlbbatch_flush */
	.byte 0x0d, 0xbf, 0x6e, 0x6d, 0xcb, 0x75, 0xeb, 0x63, 0x3b, 0xe0, 0x6f, 0x6b, 0x61, 0x79	/* T__pfx_nmi_uaccess_okay */
	.byte 0x0d, 0x54, 0x6e, 0x6d, 0xcb, 0x75, 0xeb, 0x63, 0x3b, 0xe0, 0x6f, 0x6b, 0x61, 0x79	/* Tnmi_uaccess_okay */
	.byte 0x07, 0xbf, 0x63, 0x65, 0x61, 0x1f, 0x70, 0x9a	/* T__pfx_cea_set_pte */
	.byte 0x07, 0x54, 0x63, 0x65, 0x61, 0x1f, 0x70, 0x9a	/* Tcea_set_pte */
	.byte 0x14, 0xbf, 0xfe, 0x70, 0xc5, 0x66, 0xde, 0xcd, 0x6b, 0xee, 0xb4, 0xc3, 0xb6, 0x66, 0x61, 0x0b, 0xf9, 0x08, 0x77, 0x65, 0x64	/* T__pfx_copy_from_kernel_nofault_allowed */
	.byte 0x14, 0x54, 0xfe, 0x70, 0xc5, 0x66, 0xde, 0xcd, 0x6b, 0xee, 0xb4, 0xc3, 0xb6, 0x66, 0x61, 0x0b, 0xf9, 0x08, 0x77, 0x65, 0x64	/* Tcopy_from_kernel_nofault_allowed */
	.byte 0x09, 0xbf, 0x76, 0xcd, 0xb2, 0x70, 0x61, 0x21, 0x9b, 0x74	/* T__pfx_vm_get_page_prot */
	.byte 0x09, 0x54, 0x76, 0xcd, 0xb2, 0x70, 0x61, 0x21, 0x9b, 0x74	/* Tvm_get_page_prot */
	.byte 0x0e, 0xbf, 0xc7, 0xe5, 0xe8, 0x63, 0x72, 0x27, 0xf9, 0x9b, 0x9a, 0x7b, 0xd9, 0x7c, 0x0a	/* T__pfx_add_encrypt_protection_map */
	.byte 0x0e, 0x54, 0xc7, 0xe5, 0xe8, 0x63, 0x72, 0x27, 0xf9, 0x9b, 0x9a, 0x7b, 0xd9, 0x7c, 0x0a	/* Tadd_encrypt_protection_map */
	.byte 0x05, 0xc6, 0xef, 0x6e, 0xe7, 0x9a	/* t__pfx_pfn_pte */
	.byte 0x05, 0x74, 0xef, 0x6e, 0xe7, 0x9a	/* tpfn_pte */
	.byte 0x09, 0xa8, 0xe7, 0x34, 0xe5, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* t__pfx_p4d_offset */
	.byte 0x08, 0x06, 0x34, 0xe5, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* tp4d_offset */
	.byte 0x08, 0x29, 0x5f, 0x63, 0x70, 0x61, 0x5f, 0x10, 0x72	/* t__pfx___cpa_addr */
	.byte 0x08, 0x74, 0xff, 0x63, 0x70, 0x61, 0x5f, 0x10, 0x72	/* t__cpa_addr */
	.byte 0x10, 0xc6, 0x63, 0x6c, 0x66, 0x6c, 0x5d, 0x5b, 0x63, 0xeb, 0x68, 0xfa, 0x72, 0xcc, 0x21, 0x81, 0x74	/* t__pfx_clflush_cache_range_opt */
	.byte 0x0f, 0x2d, 0x6c, 0x66, 0x6c, 0x5d, 0x5b, 0x63, 0xeb, 0x68, 0xfa, 0x72, 0xcc, 0x21, 0x81, 0x74	/* tclflush_cache_range_opt */
	.byte 0x0e, 0xbf, 0x63, 0x6c, 0x66, 0x6c, 0x5d, 0x5b, 0x63, 0xeb, 0x68, 0xfa, 0x72, 0xcc, 0xda	/* T__pfx_clflush_cache_range */
	.byte 0x0e, 0x54, 0x63, 0x6c, 0x66, 0x6c, 0x5d, 0x5b, 0x63, 0xeb, 0x68, 0xfa, 0x72, 0xcc, 0xda	/* Tclflush_cache_range */
	.byte 0x0c, 0xbf, 0xca, 0xd0, 0x5f, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0x70, 0xbd, 0x6d	/* T__pfx_arch_invalidate_pmem */
	.byte 0x0c, 0x54, 0xca, 0xd0, 0x5f, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0x70, 0xbd, 0x6d	/* Tarch_invalidate_pmem */
	.byte 0x14, 0xbf, 0x92, 0x5f, 0x63, 0xeb, 0x68, 0xfa, 0x68, 0x61, 0xe0, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0xbd, 0x6d, 0x9f, 0xd9, 0x6e	/* T__pfx_cpu_cache_has_invalidate_memregion */
	.byte 0x14, 0x54, 0x92, 0x5f, 0x63, 0xeb, 0x68, 0xfa, 0x68, 0x61, 0xe0, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0xbd, 0x6d, 0x9f, 0xd9, 0x6e	/* Tcpu_cache_has_invalidate_memregion */
	.byte 0x0c, 0x29, 0x5f, 0x63, 0x70, 0x61, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0xe1, 0x6c	/* t__pfx___cpa_flush_all */
	.byte 0x0c, 0x74, 0xff, 0x63, 0x70, 0x61, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0xe1, 0x6c	/* t__cpa_flush_all */
	.byte 0x0c, 0xc6, 0xea, 0xc5, 0xac, 0x5f, 0x87, 0xfa, 0x70, 0x6d, 0x64, 0xe7, 0x03	/* t__pfx_try_to_free_pmd_page */
	.byte 0x0c, 0x74, 0xea, 0xc5, 0xac, 0x5f, 0x87, 0xfa, 0x70, 0x6d, 0x64, 0xe7, 0x03	/* ttry_to_free_pmd_page */
	.byte 0x09, 0xc6, 0x63, 0x70, 0x61, 0xd6, 0xe9, 0x73, 0xf6, 0x26	/* t__pfx_cpastats_show */
	.byte 0x08, 0x2d, 0x70, 0x61, 0xd6, 0xe9, 0x73, 0xf6, 0x26	/* tcpastats_show */
	.byte 0x09, 0xc6, 0x63, 0x70, 0x61, 0xd6, 0xe9, 0xe0, 0x81, 0xe8	/* t__pfx_cpastats_open */
	.byte 0x08, 0x2d, 0x70, 0x61, 0xd6, 0xe9, 0xe0, 0x81, 0xe8	/* tcpastats_open */
	.byte 0x11, 0xbf, 0x92, 0x5f, 0x63, 0xeb, 0x68, 0xfa, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0xbd, 0x6d, 0x9f, 0xd9, 0x6e	/* T__pfx_cpu_cache_invalidate_memregion */
	.byte 0x11, 0x54, 0x92, 0x5f, 0x63, 0xeb, 0x68, 0xfa, 0xf0, 0x76, 0xe1, 0x89, 0xa1, 0xbd, 0x6d, 0x9f, 0xd9, 0x6e	/* Tcpu_cache_invalidate_memregion */
	.byte 0x0b, 0xc6, 0x63, 0x70, 0x61, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0xe1, 0x6c	/* t__pfx_cpa_flush_all */
	.byte 0x0a, 0x2d, 0x70, 0x61, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0xe1, 0x6c	/* tcpa_flush_all */
	.byte 0x0d, 0x29, 0x5f, 0x63, 0x70, 0x61, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0x62	/* t__pfx___cpa_flush_tlb */
	.byte 0x0d, 0x74, 0xff, 0x63, 0x70, 0x61, 0x5f, 0x66, 0x6c, 0x5d, 0x5b, 0x74, 0x6c, 0x62	/* t__cpa_flush_tlb */
	.byte 0x06, 0xa8, 0xe7, 0x6d, 0xe5, 0xef, 0x6e	/* t__pfx_pmd_pfn */
	.byte 0x05, 0x06, 0x6d, 0xe5, 0xef, 0x6e	/* tpmd_pfn */
	.byte 0x0d, 0xa8, 0xe7, 0x6f, 0xbe, 0x6c, 0xa1, 0x70, 0x9a, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_populate_pte.isra.0 */
	.byte 0x0c, 0x06, 0x6f, 0xbe, 0x6c, 0xa1, 0x70, 0x9a, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tpopulate_pte.isra.0 */
	.byte 0x08, 0xc6, 0xe1, 0xc0, 0xe7, 0x74, 0xfa, 0x70, 0x03	/* t__pfx_alloc_pte_page */
	.byte 0x08, 0x74, 0xe1, 0xc0, 0xe7, 0x74, 0xfa, 0x70, 0x03	/* talloc_pte_page */
	.byte 0x08, 0xc6, 0xe1, 0xc0, 0xe7, 0x6d, 0x64, 0xe7, 0x03	/* t__pfx_alloc_pmd_page */
	.byte 0x08, 0x74, 0xe1, 0xc0, 0xe7, 0x6d, 0x64, 0xe7, 0x03	/* talloc_pmd_page */
	.byte 0x06, 0xa8, 0xe7, 0x75, 0xe5, 0xef, 0x6e	/* t__pfx_pud_pfn */
	.byte 0x05, 0x74, 0xbe, 0xe5, 0xef, 0x6e	/* tpud_pfn */
	.byte 0x0a, 0x29, 0x5f, 0xd4, 0x0a, 0xe7, 0x6d, 0xe5, 0x72, 0xcc, 0xda	/* t__pfx___unmap_pmd_range */
	.byte 0x0a, 0x74, 0xff, 0xd4, 0x0a, 0xe7, 0x6d, 0xe5, 0x72, 0xcc, 0xda	/* t__unmap_pmd_range */
	.byte 0x09, 0xc6, 0xd4, 0x0a, 0xe7, 0x6d, 0xe5, 0x72, 0xcc, 0xda	/* t__pfx_unmap_pmd_range */
	.byte 0x09, 0x74, 0xd4, 0x0a, 0xe7, 0x6d, 0xe5, 0x72, 0xcc, 0xda	/* tunmap_pmd_range */
	.byte 0x09, 0xa8, 0xe7, 0x6f, 0xbe, 0x6c, 0xa1, 0x70, 0x6d, 0x64	/* t__pfx_populate_pmd */
	.byte 0x08, 0x06, 0x6f, 0xbe, 0x6c, 0xa1, 0x70, 0x6d, 0x64	/* tpopulate_pmd */
	.byte 0x0d, 0x29, 0x5f, 0x63, 0x70, 0x61, 0x25, 0x63, 0x3b, 0xe0, 0x66, 0x61, 0x0b, 0x74	/* t__pfx___cpa_process_fault */
	.byte 0x0d, 0x74, 0xff, 0x63, 0x70, 0x61, 0x25, 0x63, 0x3b, 0xe0, 0x66, 0x61, 0x0b, 0x74	/* t__cpa_process_fault */
	.byte 0x0a, 0xbf, 0xb9, 0x64, 0xa1, 0x70, 0x61, 0x21, 0xfe, 0xd4, 0x74	/* T__pfx_update_page_count */
	.byte 0x0a, 0x54, 0xb9, 0x64, 0xa1, 0x70, 0x61, 0x21, 0xfe, 0xd4, 0x74	/* Tupdate_page_count */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0x5f, 0xf8, 0x70, 0xce, 0xf9, 0xbd, 0x6d, 0xf0, 0x66, 0x6f	/* T__pfx_arch_report_meminfo */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0x5f, 0xf8, 0x70, 0xce, 0xf9, 0xbd, 0x6d, 0xf0, 0x66, 0x6f	/* Tarch_report_meminfo */
	.byte 0x0e, 0xbf, 0xdf, 0x6f, 0x6b, 0x3a, 0x10, 0x3d, 0xe0, 0xf0, 0xe7, 0x67, 0xe5, 0xe9, 0xea	/* T__pfx_lookup_address_in_pgd_attr */
	.byte 0x0e, 0x54, 0xdf, 0x6f, 0x6b, 0x3a, 0x10, 0x3d, 0xe0, 0xf0, 0xe7, 0x67, 0xe5, 0xe9, 0xea	/* Tlookup_address_in_pgd_attr */
	.byte 0x08, 0xbf, 0xdf, 0x6f, 0x6b, 0x3a, 0x10, 0x3d, 0x73	/* T__pfx_lookup_address */
	.byte 0x08, 0x54, 0xdf, 0x6f, 0x6b, 0x3a, 0x10, 0x3d, 0x73	/* Tlookup_address */
	.byte 0x0c, 0x3f, 0xf6, 0xdf, 0xaa, 0x76, 0xa7, 0xf9, 0xac, 0xe7, 0x68, 0x79, 0x73	/* T__pfx_slow_virt_to_phys */
	.byte 0x0c, 0x54, 0x73, 0xdf, 0xaa, 0x76, 0xa7, 0xf9, 0xac, 0xe7, 0x68, 0x79, 0x73	/* Tslow_virt_to_phys */
	.byte 0x0a, 0xa8, 0x2a, 0xe9, 0xa3, 0x25, 0x9a, 0x7b, 0xd9, 0x6e, 0x73	/* t__pfx_static_protections */
	.byte 0x0a, 0x74, 0xd6, 0xe9, 0xa3, 0x25, 0x9a, 0x7b, 0xd9, 0x6e, 0x73	/* tstatic_protections */
	.byte 0x09, 0xc6, 0x63, 0x70, 0x61, 0x5f, 0x66, 0x6c, 0x5d, 0x68	/* t__pfx_cpa_flush */
	.byte 0x08, 0x2d, 0x70, 0x61, 0x5f, 0x66, 0x6c, 0x5d, 0x68	/* tcpa_flush */
	.byte 0x10, 0x29, 0xdf, 0x6f, 0x6b, 0x3a, 0x10, 0x3d, 0xe0, 0x63, 0x70, 0x61, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx__lookup_address_cpa.isra.0 */
	.byte 0x10, 0xf9, 0xdf, 0x6f, 0x6b, 0x3a, 0x10, 0x3d, 0xe0, 0x63, 0x70, 0x61, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t_lookup_address_cpa.isra.0 */
	.byte 0x0e, 0x29, 0x5f, 0xd0, 0xcc, 0x21, 0x70, 0x61, 0x21, 0xe9, 0xea, 0x1f, 0x63, 0x6c, 0x72	/* t__pfx___change_page_attr_set_clr */
	.byte 0x0e, 0x74, 0xff, 0xd0, 0xcc, 0x21, 0x70, 0x61, 0x21, 0xe9, 0xea, 0x1f, 0x63, 0x6c, 0x72	/* t__change_page_attr_set_clr */
	.byte 0x0a, 0x29, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0xe8, 0xd5, 0xe6, 0x63	/* t__pfx___set_memory_enc_dec */
	.byte 0x0c, 0x74, 0xff, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0xe8, 0xd5, 0xe6, 0x63	/* t__set_memory_enc_dec */
	.byte 0x0c, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0xe6, 0x63, 0x72, 0x27, 0x9a, 0x64	/* T__pfx_set_memory_decrypted */
	.byte 0x0d, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0xe6, 0x63, 0x72, 0x27, 0x9a, 0x64	/* Tset_memory_decrypted */
	.byte 0x0c, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0xe8, 0x63, 0x72, 0x27, 0x9a, 0x64	/* T__pfx_set_memory_encrypted */
	.byte 0x0d, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0xe8, 0x63, 0x72, 0x27, 0x9a, 0x64	/* Tset_memory_encrypted */
	.byte 0x0d, 0xc6, 0xd0, 0xcc, 0x21, 0x70, 0x61, 0x21, 0xe9, 0xea, 0x1f, 0x63, 0x6c, 0x72	/* t__pfx_change_page_attr_set_clr */
	.byte 0x0d, 0x74, 0xd0, 0xcc, 0x21, 0x70, 0x61, 0x21, 0xe9, 0xea, 0x1f, 0x63, 0x6c, 0x72	/* tchange_page_attr_set_clr */
	.byte 0x09, 0x29, 0xc9, 0xf9, 0x70, 0x03, 0xe0, 0xca, 0xb5, 0x79	/* t__pfx__set_pages_array */
	.byte 0x09, 0xf9, 0xc9, 0xf9, 0x70, 0x03, 0xe0, 0xca, 0xb5, 0x79	/* t_set_pages_array */
	.byte 0x0a, 0x3f, 0x1f, 0x70, 0x03, 0xe0, 0xca, 0xb5, 0xc5, 0x77, 0x63	/* T__pfx_set_pages_array_wc */
	.byte 0x0b, 0x54, 0xc9, 0xf9, 0x70, 0x03, 0xe0, 0xca, 0xb5, 0xc5, 0x77, 0x63	/* Tset_pages_array_wc */
	.byte 0x0a, 0x3f, 0x1f, 0x70, 0x03, 0xe0, 0xca, 0xb5, 0xc5, 0x75, 0x63	/* T__pfx_set_pages_array_uc */
	.byte 0x0b, 0x54, 0xc9, 0xf9, 0x70, 0x03, 0xe0, 0xca, 0xb5, 0xc5, 0x75, 0x63	/* Tset_pages_array_uc */
	.byte 0x0a, 0x3f, 0x1f, 0x70, 0x03, 0xe0, 0xca, 0xb5, 0xc5, 0x77, 0x62	/* T__pfx_set_pages_array_wb */
	.byte 0x0b, 0x54, 0xc9, 0xf9, 0x70, 0x03, 0xe0, 0xca, 0xb5, 0xc5, 0x77, 0x62	/* Tset_pages_array_wb */
	.byte 0x0d, 0xbf, 0x63, 0xd3, 0xca, 0x5f, 0x6d, 0x63, 0xfa, 0xb6, 0x73, 0x70, 0x65, 0x63	/* T__pfx_clear_mce_nospec */
	.byte 0x0d, 0x54, 0x63, 0xd3, 0xca, 0x5f, 0x6d, 0x63, 0xfa, 0xb6, 0x73, 0x70, 0x65, 0x63	/* Tclear_mce_nospec */
	.byte 0x08, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x77, 0x62	/* T__pfx_set_memory_wb */
	.byte 0x09, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x77, 0x62	/* Tset_memory_wb */
	.byte 0x07, 0x3f, 0x1f, 0x70, 0x03, 0xe0, 0x77, 0x62	/* T__pfx_set_pages_wb */
	.byte 0x08, 0x54, 0xc9, 0xf9, 0x70, 0x03, 0xe0, 0x77, 0x62	/* Tset_pages_wb */
	.byte 0x0c, 0xbf, 0xdf, 0x6f, 0x6b, 0x3a, 0x10, 0x3d, 0xe0, 0xf0, 0xe7, 0x67, 0x64	/* T__pfx_lookup_address_in_pgd */
	.byte 0x0c, 0x54, 0xdf, 0x6f, 0x6b, 0x3a, 0x10, 0x3d, 0xe0, 0xf0, 0xe7, 0x67, 0x64	/* Tlookup_address_in_pgd */
	.byte 0x0b, 0xbf, 0xdf, 0x6f, 0x6b, 0xb9, 0xe7, 0x6d, 0xe5, 0x10, 0x3d, 0x73	/* T__pfx_lookup_pmd_address */
	.byte 0x0b, 0x54, 0xdf, 0x6f, 0x6b, 0xb9, 0xe7, 0x6d, 0xe5, 0x10, 0x3d, 0x73	/* Tlookup_pmd_address */
	.byte 0x09, 0x3f, 0xff, 0x1f, 0xbd, 0x6d, 0xce, 0x79, 0x25, 0x74	/* T__pfx___set_memory_prot */
	.byte 0x09, 0x2f, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0x79, 0x25, 0x74	/* T__set_memory_prot */
	.byte 0x0a, 0x3f, 0xff, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x75, 0x63	/* T__pfx__set_memory_uc */
	.byte 0x08, 0x54, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x75, 0x63	/* T_set_memory_uc */
	.byte 0x08, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x75, 0x63	/* T__pfx_set_memory_uc */
	.byte 0x09, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x75, 0x63	/* Tset_memory_uc */
	.byte 0x07, 0x3f, 0x1f, 0x70, 0x03, 0xe0, 0x75, 0x63	/* T__pfx_set_pages_uc */
	.byte 0x08, 0x54, 0xc9, 0xf9, 0x70, 0x03, 0xe0, 0x75, 0x63	/* Tset_pages_uc */
	.byte 0x0a, 0x3f, 0xff, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x77, 0x63	/* T__pfx__set_memory_wc */
	.byte 0x08, 0x54, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x77, 0x63	/* T_set_memory_wc */
	.byte 0x08, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x77, 0x63	/* T__pfx_set_memory_wc */
	.byte 0x09, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x77, 0x63	/* Tset_memory_wc */
	.byte 0x0a, 0x3f, 0xff, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x77, 0x74	/* T__pfx__set_memory_wt */
	.byte 0x08, 0x54, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x77, 0x74	/* T_set_memory_wt */
	.byte 0x0a, 0x3f, 0xff, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x77, 0x62	/* T__pfx__set_memory_wb */
	.byte 0x08, 0x54, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x77, 0x62	/* T_set_memory_wb */
	.byte 0x0a, 0x3f, 0x1f, 0x6d, 0x63, 0xfa, 0xb6, 0x73, 0x70, 0x65, 0x63	/* T__pfx_set_mce_nospec */
	.byte 0x0b, 0x54, 0xc9, 0xf9, 0x6d, 0x63, 0xfa, 0xb6, 0x73, 0x70, 0x65, 0x63	/* Tset_mce_nospec */
	.byte 0x07, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x78	/* T__pfx_set_memory_x */
	.byte 0x08, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x78	/* Tset_memory_x */
	.byte 0x08, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x6e, 0x78	/* T__pfx_set_memory_nx */
	.byte 0x09, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x6e, 0x78	/* Tset_memory_nx */
	.byte 0x07, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0xde	/* T__pfx_set_memory_ro */
	.byte 0x08, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0xde	/* Tset_memory_ro */
	.byte 0x08, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0xde, 0x78	/* T__pfx_set_memory_rox */
	.byte 0x09, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0xde, 0x78	/* Tset_memory_rox */
	.byte 0x08, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x72, 0x77	/* T__pfx_set_memory_rw */
	.byte 0x09, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x72, 0x77	/* Tset_memory_rw */
	.byte 0x08, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x6e, 0x70	/* T__pfx_set_memory_np */
	.byte 0x09, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x6e, 0x70	/* Tset_memory_np */
	.byte 0x0c, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x6e, 0xe2, 0xb6, 0xe1, 0x69, 0x96	/* T__pfx_set_memory_np_noalias */
	.byte 0x0d, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x6e, 0xe2, 0xb6, 0xe1, 0x69, 0x96	/* Tset_memory_np_noalias */
	.byte 0x07, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0x79, 0xe7	/* T__pfx_set_memory_p */
	.byte 0x08, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0x79, 0xe7	/* Tset_memory_p */
	.byte 0x08, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x34, 0x6b	/* T__pfx_set_memory_4k */
	.byte 0x09, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x34, 0x6b	/* Tset_memory_4k */
	.byte 0x0c, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0xb6, 0x6e, 0x67, 0xdf, 0x62, 0xe1	/* T__pfx_set_memory_nonglobal */
	.byte 0x0d, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0xb6, 0x6e, 0x67, 0xdf, 0x62, 0xe1	/* Tset_memory_nonglobal */
	.byte 0x0a, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0x67, 0xdf, 0x62, 0xe1	/* T__pfx_set_memory_global */
	.byte 0x0b, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0x67, 0xdf, 0x62, 0xe1	/* Tset_memory_global */
	.byte 0x11, 0x3f, 0x1f, 0xbd, 0x6d, 0xce, 0xc5, 0xe8, 0x63, 0xf6, 0xac, 0xe2, 0x98, 0x76, 0xee, 0x73, 0xd9, 0x6e	/* T__pfx_set_memory_enc_stop_conversion */
	.byte 0x12, 0x54, 0xc9, 0xf9, 0xbd, 0x6d, 0xce, 0xc5, 0xe8, 0x63, 0xf6, 0xac, 0xe2, 0x98, 0x76, 0xee, 0x73, 0xd9, 0x6e	/* Tset_memory_enc_stop_conversion */
	.byte 0x06, 0x3f, 0x1f, 0x70, 0x03, 0xe0, 0xde	/* T__pfx_set_pages_ro */
	.byte 0x07, 0x54, 0xc9, 0xf9, 0x70, 0x03, 0xe0, 0xde	/* Tset_pages_ro */
	.byte 0x07, 0x3f, 0x1f, 0x70, 0x03, 0xe0, 0x72, 0x77	/* T__pfx_set_pages_rw */
	.byte 0x08, 0x54, 0xc9, 0xf9, 0x70, 0x03, 0xe0, 0x72, 0x77	/* Tset_pages_rw */
	.byte 0x12, 0x3f, 0x1f, 0x64, 0x69, 0xf8, 0x63, 0xf9, 0x84, 0xf0, 0x76, 0xe1, 0x69, 0xe5, 0xb6, 0x66, 0x6c, 0x5d, 0x68	/* T__pfx_set_direct_map_invalid_noflush */
	.byte 0x13, 0x54, 0xc9, 0xf9, 0x64, 0x69, 0xf8, 0x63, 0xf9, 0x84, 0xf0, 0x76, 0xe1, 0x69, 0xe5, 0xb6, 0x66, 0x6c, 0x5d, 0x68	/* Tset_direct_map_invalid_noflush */
	.byte 0x12, 0x3f, 0x1f, 0x64, 0x69, 0xf8, 0x63, 0xf9, 0x84, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0xb6, 0x66, 0x6c, 0x5d, 0x68	/* T__pfx_set_direct_map_default_noflush */
	.byte 0x13, 0x54, 0xc9, 0xf9, 0x64, 0x69, 0xf8, 0x63, 0xf9, 0x84, 0xe6, 0x66, 0x61, 0x0b, 0xf9, 0xb6, 0x66, 0x6c, 0x5d, 0x68	/* Tset_direct_map_default_noflush */
	.byte 0x0b, 0xbf, 0x6b, 0xee, 0xb4, 0x6c, 0xe7, 0x61, 0x21, 0x70, 0x3d, 0x1e	/* T__pfx_kernel_page_present */
	.byte 0x0b, 0x54, 0x6b, 0xee, 0xb4, 0x6c, 0xe7, 0x61, 0x21, 0x70, 0x3d, 0x1e	/* Tkernel_page_present */
	.byte 0x08, 0x3f, 0xe7, 0x61, 0xf9, 0xe8, 0x80, 0xd3, 0x64	/* T__pfx_pat_enabled */
	.byte 0x08, 0x54, 0x70, 0x61, 0xf9, 0xe8, 0x80, 0xd3, 0x64	/* Tpat_enabled */
	.byte 0x10, 0xa8, 0xe7, 0x61, 0x67, 0xee, 0xcc, 0x21, 0x69, 0xe0, 0xb5, 0xcd, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_pagerange_is_ram_callback */
	.byte 0x0f, 0x06, 0x61, 0x67, 0xee, 0xcc, 0x21, 0x69, 0xe0, 0xb5, 0xcd, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tpagerange_is_ram_callback */
	.byte 0x0b, 0xc6, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xc9, 0x71, 0xf6, 0xac, 0x70	/* t__pfx_memtype_seq_stop */
	.byte 0x0b, 0x74, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xc9, 0x71, 0xf6, 0xac, 0x70	/* tmemtype_seq_stop */
	.byte 0x0e, 0xa8, 0xe7, 0x61, 0xf9, 0x70, 0x61, 0x67, 0xee, 0xcc, 0x21, 0x69, 0xe0, 0xb5, 0x6d	/* t__pfx_pat_pagerange_is_ram */
	.byte 0x0d, 0x06, 0x61, 0xf9, 0x70, 0x61, 0x67, 0xee, 0xcc, 0x21, 0x69, 0xe0, 0xb5, 0x6d	/* tpat_pagerange_is_ram */
	.byte 0x0a, 0xc6, 0xdf, 0x6f, 0x6b, 0x3a, 0xbd, 0x6d, 0x74, 0x27, 0x65	/* t__pfx_lookup_memtype */
	.byte 0x0a, 0x74, 0xdf, 0x6f, 0x6b, 0x3a, 0xbd, 0x6d, 0x74, 0x27, 0x65	/* tlookup_memtype */
	.byte 0x12, 0x3f, 0xe7, 0x61, 0xf9, 0xef, 0x7c, 0x69, 0x6d, 0x6d, 0xd4, 0xfa, 0xac, 0x5f, 0x75, 0xd5, 0x6d, 0xea, 0x72	/* T__pfx_pat_pfn_immune_to_uc_mtrr */
	.byte 0x12, 0x54, 0x70, 0x61, 0xf9, 0xef, 0x7c, 0x69, 0x6d, 0x6d, 0xd4, 0xfa, 0xac, 0x5f, 0x75, 0xd5, 0x6d, 0xea, 0x72	/* Tpat_pfn_immune_to_uc_mtrr */
	.byte 0x0c, 0x3f, 0xe7, 0x67, 0x9b, 0xf9, 0x24, 0x65, 0x15, 0xde, 0x75, 0x67, 0x68	/* T__pfx_pgprot_writethrough */
	.byte 0x0c, 0x54, 0x70, 0x67, 0x9b, 0xf9, 0x24, 0x65, 0x15, 0xde, 0x75, 0x67, 0x68	/* Tpgprot_writethrough */
	.byte 0x0c, 0x3f, 0xe7, 0x67, 0x9b, 0xf9, 0x24, 0x65, 0xfe, 0x6d, 0x62, 0xf0, 0x65	/* T__pfx_pgprot_writecombine */
	.byte 0x0c, 0x54, 0x70, 0x67, 0x9b, 0xf9, 0x24, 0x65, 0xfe, 0x6d, 0x62, 0xf0, 0x65	/* Tpgprot_writecombine */
	.byte 0x08, 0xc6, 0xb2, 0x70, 0x61, 0xf9, 0xf0, 0x66, 0x6f	/* t__pfx_get_pat_info */
	.byte 0x08, 0x74, 0xb2, 0x70, 0x61, 0xf9, 0xf0, 0x66, 0x6f	/* tget_pat_info */
	.byte 0x0a, 0xc6, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xc9, 0x93, 0x81, 0xe8	/* t__pfx_memtype_seq_open */
	.byte 0x0a, 0x74, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xc9, 0x93, 0x81, 0xe8	/* tmemtype_seq_open */
	.byte 0x0a, 0xc6, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xc9, 0x71, 0xf6, 0x26	/* t__pfx_memtype_seq_show */
	.byte 0x0a, 0x74, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xc9, 0x71, 0xf6, 0x26	/* tmemtype_seq_show */
	.byte 0x09, 0xc6, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xb2, 0x89, 0x78	/* t__pfx_memtype_get_idx */
	.byte 0x09, 0x74, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xb2, 0x89, 0x78	/* tmemtype_get_idx */
	.byte 0x0a, 0xc6, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xc9, 0x93, 0x6e, 0x97	/* t__pfx_memtype_seq_next */
	.byte 0x0a, 0x74, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xc9, 0x93, 0x6e, 0x97	/* tmemtype_seq_next */
	.byte 0x0c, 0xc6, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xc9, 0x71, 0xf6, 0xdb, 0x72, 0x74	/* t__pfx_memtype_seq_start */
	.byte 0x0c, 0x74, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xc9, 0x71, 0xf6, 0xdb, 0x72, 0x74	/* tmemtype_seq_start */
	.byte 0x07, 0x3f, 0xe7, 0x61, 0xf9, 0x92, 0x5f, 0x8d	/* T__pfx_pat_cpu_init */
	.byte 0x07, 0x54, 0x70, 0x61, 0xf9, 0x92, 0x5f, 0x8d	/* Tpat_cpu_init */
	.byte 0x0a, 0xbf, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x3d, 0xee, 0x76, 0x65	/* T__pfx_memtype_reserve */
	.byte 0x0a, 0x54, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x3d, 0xee, 0x76, 0x65	/* Tmemtype_reserve */
	.byte 0x08, 0xbf, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x87, 0x65	/* T__pfx_memtype_free */
	.byte 0x08, 0x54, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x87, 0x65	/* Tmemtype_free */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x5f, 0x3e, 0x87, 0xfa, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x77, 0x63	/* T__pfx_arch_io_free_memtype_wc */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x5f, 0x3e, 0x87, 0xfa, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x77, 0x63	/* Tarch_io_free_memtype_wc */
	.byte 0x09, 0xbf, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x87, 0xfa, 0xd9	/* T__pfx_memtype_free_io */
	.byte 0x09, 0x54, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x87, 0xfa, 0xd9	/* Tmemtype_free_io */
	.byte 0x0d, 0x3f, 0xe7, 0x68, 0x79, 0xe0, 0xbd, 0xcd, 0xeb, 0x63, 0x3b, 0x73, 0x25, 0x74	/* T__pfx_phys_mem_access_prot */
	.byte 0x0d, 0x54, 0x70, 0x68, 0x79, 0xe0, 0xbd, 0xcd, 0xeb, 0x63, 0x3b, 0x73, 0x25, 0x74	/* Tphys_mem_access_prot */
	.byte 0x11, 0x3f, 0xe7, 0x68, 0x79, 0xe0, 0xbd, 0xcd, 0xeb, 0x63, 0x3b, 0x73, 0x25, 0xf9, 0x08, 0x77, 0x65, 0x64	/* T__pfx_phys_mem_access_prot_allowed */
	.byte 0x11, 0x54, 0x70, 0x68, 0x79, 0xe0, 0xbd, 0xcd, 0xeb, 0x63, 0x3b, 0x73, 0x25, 0xf9, 0x08, 0x77, 0x65, 0x64	/* Tphys_mem_access_prot_allowed */
	.byte 0x0e, 0xbf, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x6b, 0xee, 0xb4, 0xc3, 0x0a, 0x95, 0x6e, 0x63	/* T__pfx_memtype_kernel_map_sync */
	.byte 0x0e, 0x54, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x6b, 0xee, 0xb4, 0xc3, 0x0a, 0x95, 0x6e, 0x63	/* Tmemtype_kernel_map_sync */
	.byte 0x09, 0xc6, 0x3d, 0xee, 0x22, 0xef, 0x7c, 0x72, 0xcc, 0xda	/* t__pfx_reserve_pfn_range */
	.byte 0x09, 0x74, 0x3d, 0xee, 0x22, 0xef, 0x7c, 0x72, 0xcc, 0xda	/* treserve_pfn_range */
	.byte 0x0a, 0xbf, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x3d, 0xee, 0x22, 0xd9	/* T__pfx_memtype_reserve_io */
	.byte 0x0a, 0x54, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x3d, 0xee, 0x22, 0xd9	/* Tmemtype_reserve_io */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0x3e, 0x3d, 0xee, 0x22, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x77, 0x63	/* T__pfx_arch_io_reserve_memtype_wc */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0x3e, 0x3d, 0xee, 0x22, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x77, 0x63	/* Tarch_io_reserve_memtype_wc */
	.byte 0x08, 0xbf, 0xd7, 0xd8, 0xef, 0x7c, 0xfe, 0x70, 0x79	/* T__pfx_track_pfn_copy */
	.byte 0x08, 0x54, 0xd7, 0xd8, 0xef, 0x7c, 0xfe, 0x70, 0x79	/* Ttrack_pfn_copy */
	.byte 0x07, 0xbf, 0xd7, 0xd8, 0xef, 0x7c, 0xf8, 0x0a	/* T__pfx_track_pfn_remap */
	.byte 0x07, 0x54, 0xd7, 0xd8, 0xef, 0x7c, 0xf8, 0x0a	/* Ttrack_pfn_remap */
	.byte 0x09, 0xbf, 0xd7, 0xd8, 0xef, 0x7c, 0xf0, 0x73, 0xee, 0x74	/* T__pfx_track_pfn_insert */
	.byte 0x09, 0x54, 0xd7, 0xd8, 0xef, 0x7c, 0xf0, 0x73, 0xee, 0x74	/* Ttrack_pfn_insert */
	.byte 0x06, 0xbf, 0xd4, 0xd7, 0xd8, 0xef, 0x6e	/* T__pfx_untrack_pfn */
	.byte 0x06, 0x54, 0xd4, 0xd7, 0xd8, 0xef, 0x6e	/* Tuntrack_pfn */
	.byte 0x09, 0xbf, 0xd4, 0xd7, 0xd8, 0xef, 0x7c, 0x63, 0xd3, 0xca	/* T__pfx_untrack_pfn_clear */
	.byte 0x09, 0x54, 0xd4, 0xd7, 0xd8, 0xef, 0x7c, 0x63, 0xd3, 0xca	/* Tuntrack_pfn_clear */
	.byte 0x0f, 0xc6, 0xf0, 0x74, 0xee, 0x76, 0xe1, 0x5f, 0x61, 0x75, 0x67, 0x6d, 0xbb, 0xde, 0x74, 0x86	/* t__pfx_interval_augment_rotate */
	.byte 0x0f, 0x74, 0xf0, 0x74, 0xee, 0x76, 0xe1, 0x5f, 0x61, 0x75, 0x67, 0x6d, 0xbb, 0xde, 0x74, 0x86	/* tinterval_augment_rotate */
	.byte 0x0f, 0xc6, 0xf0, 0x74, 0xee, 0x76, 0xe1, 0xf6, 0x75, 0x62, 0x74, 0xf8, 0xfa, 0xc9, 0xca, 0xd0	/* t__pfx_interval_subtree_search */
	.byte 0x0f, 0x74, 0xf0, 0x74, 0xee, 0x76, 0xe1, 0xf6, 0x75, 0x62, 0x74, 0xf8, 0xfa, 0xc9, 0xca, 0xd0	/* tinterval_subtree_search */
	.byte 0x0b, 0xc6, 0xf0, 0x74, 0xee, 0x76, 0xe1, 0x5f, 0xe4, 0xcf, 0x6e, 0x97	/* t__pfx_interval_iter_next */
	.byte 0x0b, 0x74, 0xf0, 0x74, 0xee, 0x76, 0xe1, 0x5f, 0xe4, 0xcf, 0x6e, 0x97	/* tinterval_iter_next */
	.byte 0x13, 0xc6, 0xf0, 0x74, 0xee, 0x76, 0xe1, 0x5f, 0xe4, 0xcf, 0xb8, 0x72, 0xd6, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_interval_iter_first.constprop.0 */
	.byte 0x13, 0x74, 0xf0, 0x74, 0xee, 0x76, 0xe1, 0x5f, 0xe4, 0xcf, 0xb8, 0x72, 0xd6, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tinterval_iter_first.constprop.0 */
	.byte 0x09, 0xc6, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x6d, 0xe9, 0xd0	/* t__pfx_memtype_match */
	.byte 0x09, 0x74, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x6d, 0xe9, 0xd0	/* tmemtype_match */
	.byte 0x12, 0xc6, 0xf0, 0x74, 0xee, 0x76, 0xe1, 0x5f, 0xf0, 0x73, 0xee, 0x74, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_interval_insert.constprop.0 */
	.byte 0x12, 0x74, 0xf0, 0x74, 0xee, 0x76, 0xe1, 0x5f, 0xf0, 0x73, 0xee, 0x74, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tinterval_insert.constprop.0 */
	.byte 0x12, 0xc6, 0xf0, 0x74, 0xee, 0x76, 0xe1, 0x5f, 0xf8, 0xa5, 0x76, 0x65, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_interval_remove.constprop.0 */
	.byte 0x12, 0x74, 0xf0, 0x74, 0xee, 0x76, 0xe1, 0x5f, 0xf8, 0xa5, 0x76, 0x65, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tinterval_remove.constprop.0 */
	.byte 0x0d, 0xbf, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x7e, 0x63, 0xd8, 0xf0, 0x73, 0xee, 0x74	/* T__pfx_memtype_check_insert */
	.byte 0x0d, 0x54, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0x7e, 0x63, 0xd8, 0xf0, 0x73, 0xee, 0x74	/* Tmemtype_check_insert */
	.byte 0x09, 0xbf, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xee, 0x61, 0xc9	/* T__pfx_memtype_erase */
	.byte 0x09, 0x54, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xee, 0x61, 0xc9	/* Tmemtype_erase */
	.byte 0x0a, 0xbf, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xdf, 0x6f, 0x6b, 0xb9	/* T__pfx_memtype_lookup */
	.byte 0x0a, 0x54, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xdf, 0x6f, 0x6b, 0xb9	/* Tmemtype_lookup */
	.byte 0x10, 0xbf, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xfe, 0x70, 0xc5, 0x6e, 0x74, 0x5b, 0x65, 0xd3, 0x6d, 0x1e	/* T__pfx_memtype_copy_nth_element */
	.byte 0x10, 0x54, 0xbd, 0x6d, 0x74, 0x27, 0xfa, 0xfe, 0x70, 0xc5, 0x6e, 0x74, 0x5b, 0x65, 0xd3, 0x6d, 0x1e	/* Tmemtype_copy_nth_element */
	.byte 0x10, 0xbf, 0x68, 0x75, 0xda, 0x74, 0x6c, 0xdc, 0xb2, 0xd4, 0x0a, 0x70, 0x65, 0xe5, 0x61, 0xf8, 0x61	/* T__pfx_hugetlb_get_unmapped_area */
	.byte 0x10, 0x54, 0x68, 0x75, 0xda, 0x74, 0x6c, 0xdc, 0xb2, 0xd4, 0x0a, 0x70, 0x65, 0xe5, 0x61, 0xf8, 0x61	/* Thugetlb_get_unmapped_area */
	.byte 0x08, 0xc6, 0xb2, 0x6b, 0x6d, 0x6d, 0xd9, 0x25, 0x17	/* t__pfx_get_kmmio_probe */
	.byte 0x08, 0x74, 0xb2, 0x6b, 0x6d, 0x6d, 0xd9, 0x25, 0x17	/* tget_kmmio_probe */
	.byte 0x0a, 0xc6, 0x6b, 0x6d, 0x6d, 0xd9, 0xe7, 0x61, 0x21, 0x6c, 0x7d	/* t__pfx_kmmio_page_list */
	.byte 0x0a, 0x74, 0x6b, 0x6d, 0x6d, 0xd9, 0xe7, 0x61, 0x21, 0x6c, 0x7d	/* tkmmio_page_list */
	.byte 0x0c, 0xc6, 0xb2, 0x6b, 0x6d, 0x6d, 0x3e, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x03	/* t__pfx_get_kmmio_fault_page */
	.byte 0x0c, 0x74, 0xb2, 0x6b, 0x6d, 0x6d, 0x3e, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x03	/* tget_kmmio_fault_page */
	.byte 0x11, 0xc6, 0x72, 0x63, 0x00, 0x87, 0xfa, 0x6b, 0x6d, 0x6d, 0x3e, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x03, 0x73	/* t__pfx_rcu_free_kmmio_fault_pages */
	.byte 0x10, 0xea, 0x63, 0x00, 0x87, 0xfa, 0x6b, 0x6d, 0x6d, 0x3e, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x03, 0x73	/* trcu_free_kmmio_fault_pages */
	.byte 0x0c, 0xc6, 0x63, 0xd3, 0xca, 0xe7, 0x61, 0x21, 0x70, 0x3d, 0xe8, 0x63, 0x65	/* t__pfx_clear_page_presence */
	.byte 0x0b, 0x2d, 0xd3, 0xca, 0xe7, 0x61, 0x21, 0x70, 0x3d, 0xe8, 0x63, 0x65	/* tclear_page_presence */
	.byte 0x0f, 0xc6, 0x64, 0xab, 0xca, 0xcd, 0x6b, 0x6d, 0x6d, 0x3e, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x03	/* t__pfx_disarm_kmmio_fault_page */
	.byte 0x0f, 0x74, 0x64, 0xab, 0xca, 0xcd, 0x6b, 0x6d, 0x6d, 0x3e, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x03	/* tdisarm_kmmio_fault_page */
	.byte 0x0a, 0xbf, 0xd4, 0x18, 0xcf, 0x6b, 0x6d, 0x6d, 0xd9, 0x25, 0x17	/* T__pfx_unregister_kmmio_probe */
	.byte 0x0a, 0x54, 0xd4, 0x18, 0xcf, 0x6b, 0x6d, 0x6d, 0xd9, 0x25, 0x17	/* Tunregister_kmmio_probe */
	.byte 0x0d, 0xc6, 0xca, 0xcd, 0x6b, 0x6d, 0x6d, 0x3e, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x03	/* t__pfx_arm_kmmio_fault_page */
	.byte 0x0d, 0xdb, 0x72, 0xcd, 0x6b, 0x6d, 0x6d, 0x3e, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x03	/* tarm_kmmio_fault_page */
	.byte 0x0c, 0xc6, 0x6b, 0x6d, 0x6d, 0x3e, 0x64, 0x69, 0xfa, 0xb6, 0xc2, 0xb8, 0xee	/* t__pfx_kmmio_die_notifier */
	.byte 0x0c, 0x74, 0x6b, 0x6d, 0x6d, 0x3e, 0x64, 0x69, 0xfa, 0xb6, 0xc2, 0xb8, 0xee	/* tkmmio_die_notifier */
	.byte 0x0f, 0xc6, 0xf8, 0xa5, 0x22, 0x6b, 0x6d, 0x6d, 0x3e, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x03, 0x73	/* t__pfx_remove_kmmio_fault_pages */
	.byte 0x0f, 0x74, 0xf8, 0xa5, 0x22, 0x6b, 0x6d, 0x6d, 0x3e, 0x66, 0x61, 0x0b, 0xf9, 0x70, 0x03, 0x73	/* tremove_kmmio_fault_pages */
	.byte 0x09, 0xbf, 0x18, 0xcf, 0x6b, 0x6d, 0x6d, 0xd9, 0x25, 0x17	/* T__pfx_register_kmmio_probe */
	.byte 0x09, 0x54, 0x18, 0xcf, 0x6b, 0x6d, 0x6d, 0xd9, 0x25, 0x17	/* Tregister_kmmio_probe */
	.byte 0x0a, 0xbf, 0x6b, 0x6d, 0x6d, 0x3e, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* T__pfx_kmmio_handler */
	.byte 0x0a, 0x54, 0x6b, 0x6d, 0x6d, 0x3e, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* Tkmmio_handler */
	.byte 0x06, 0xbf, 0x6b, 0x6d, 0x6d, 0x3e, 0x8d	/* T__pfx_kmmio_init */
	.byte 0x06, 0x54, 0x6b, 0x6d, 0x6d, 0x3e, 0x8d	/* Tkmmio_init */
	.byte 0x09, 0xbf, 0x6b, 0x6d, 0x6d, 0x3e, 0x63, 0xd3, 0xcc, 0xb9	/* T__pfx_kmmio_cleanup */
	.byte 0x09, 0x54, 0x6b, 0x6d, 0x6d, 0x3e, 0x63, 0xd3, 0xcc, 0xb9	/* Tkmmio_cleanup */
	.byte 0x08, 0xa8, 0xf6, 0x6b, 0x0c, 0xe7, 0xf8, 0xb8, 0x78	/* t__pfx_skip_prefix */
	.byte 0x07, 0x74, 0x16, 0x0c, 0xe7, 0xf8, 0xb8, 0x78	/* tskip_prefix */
	.byte 0x07, 0xc6, 0xb2, 0xf8, 0xa6, 0x77, 0x33, 0x32	/* t__pfx_get_reg_w32 */
	.byte 0x07, 0x74, 0xb2, 0xf8, 0xa6, 0x77, 0x33, 0x32	/* tget_reg_w32 */
	.byte 0x09, 0xc6, 0xb2, 0xf0, 0xe0, 0xf8, 0xa6, 0x77, 0x89, 0x15	/* t__pfx_get_ins_reg_width */
	.byte 0x09, 0x74, 0xb2, 0xf0, 0xe0, 0xf8, 0xa6, 0x77, 0x89, 0x15	/* tget_ins_reg_width */
	.byte 0x07, 0xbf, 0xb2, 0xf0, 0xe0, 0x74, 0x27, 0x65	/* T__pfx_get_ins_type */
	.byte 0x07, 0x54, 0xb2, 0xf0, 0xe0, 0x74, 0x27, 0x65	/* Tget_ins_type */
	.byte 0x09, 0xbf, 0xb2, 0xf0, 0xe0, 0xbd, 0xcd, 0x77, 0x89, 0x15	/* T__pfx_get_ins_mem_width */
	.byte 0x09, 0x54, 0xb2, 0xf0, 0xe0, 0xbd, 0xcd, 0x77, 0x89, 0x15	/* Tget_ins_mem_width */
	.byte 0x08, 0xbf, 0xb2, 0xf0, 0xe0, 0xf8, 0xa6, 0x76, 0xe1	/* T__pfx_get_ins_reg_val */
	.byte 0x08, 0x54, 0xb2, 0xf0, 0xe0, 0xf8, 0xa6, 0x76, 0xe1	/* Tget_ins_reg_val */
	.byte 0x09, 0xbf, 0xb2, 0xf0, 0xe0, 0x69, 0x6d, 0xcd, 0x76, 0xe1	/* T__pfx_get_ins_imm_val */
	.byte 0x09, 0x54, 0xb2, 0xf0, 0xe0, 0x69, 0x6d, 0xcd, 0x76, 0xe1	/* Tget_ins_imm_val */
	.byte 0x06, 0xa8, 0xe7, 0x74, 0xfa, 0x76, 0xe1	/* t__pfx_pte_val */
	.byte 0x05, 0x06, 0x74, 0xfa, 0x76, 0xe1	/* tpte_val */
	.byte 0x04, 0xa8, 0xe7, 0x6f, 0xd6	/* t__pfx_post */
	.byte 0x03, 0x06, 0x6f, 0xd6	/* tpost */
	.byte 0x03, 0xa8, 0xe7, 0xf8	/* t__pfx_pre */
	.byte 0x02, 0x06, 0xf8	/* tpre */
	.byte 0x0a, 0xbf, 0x6d, 0x6d, 0xd9, 0xc8, 0x70, 0x72, 0xf0, 0x74, 0x6b	/* T__pfx_mmiotrace_printk */
	.byte 0x0a, 0x54, 0x6d, 0x6d, 0xd9, 0xc8, 0x70, 0x72, 0xf0, 0x74, 0x6b	/* Tmmiotrace_printk */
	.byte 0x08, 0xbf, 0x6d, 0x6d, 0xd9, 0xc8, 0xd9, 0xf8, 0x0a	/* T__pfx_mmiotrace_ioremap */
	.byte 0x08, 0x54, 0x6d, 0x6d, 0xd9, 0xc8, 0xd9, 0xf8, 0x0a	/* Tmmiotrace_ioremap */
	.byte 0x08, 0xbf, 0x6d, 0x6d, 0xd9, 0xc8, 0xd9, 0xd4, 0x0a	/* T__pfx_mmiotrace_iounmap */
	.byte 0x08, 0x54, 0x6d, 0x6d, 0xd9, 0xc8, 0xd9, 0xd4, 0x0a	/* Tmmiotrace_iounmap */
	.byte 0x08, 0xbf, 0xe8, 0x80, 0xb3, 0x6d, 0x6d, 0xd9, 0x01	/* T__pfx_enable_mmiotrace */
	.byte 0x08, 0x54, 0xe8, 0x80, 0xb3, 0x6d, 0x6d, 0xd9, 0x01	/* Tenable_mmiotrace */
	.byte 0x09, 0xbf, 0x64, 0xab, 0x80, 0xb3, 0x6d, 0x6d, 0xd9, 0x01	/* T__pfx_disable_mmiotrace */
	.byte 0x09, 0x54, 0x64, 0xab, 0x80, 0xb3, 0x6d, 0x6d, 0xd9, 0x01	/* Tdisable_mmiotrace */
	.byte 0x09, 0xbf, 0x6e, 0x75, 0xdd, 0x5f, 0x92, 0x5f, 0xb6, 0xe6	/* T__pfx_numa_cpu_node */
	.byte 0x09, 0x54, 0x6e, 0x75, 0xdd, 0x5f, 0x92, 0x5f, 0xb6, 0xe6	/* Tnuma_cpu_node */
	.byte 0x07, 0xbf, 0x6e, 0x75, 0xdd, 0x1f, 0xb6, 0xe6	/* T__pfx_numa_set_node */
	.byte 0x07, 0x54, 0x6e, 0x75, 0xdd, 0x1f, 0xb6, 0xe6	/* Tnuma_set_node */
	.byte 0x0b, 0xbf, 0x6e, 0x75, 0xdd, 0x5f, 0x63, 0xd3, 0xca, 0x5f, 0xb6, 0xe6	/* T__pfx_numa_clear_node */
	.byte 0x0b, 0x54, 0x6e, 0x75, 0xdd, 0x5f, 0x63, 0xd3, 0xca, 0x5f, 0xb6, 0xe6	/* Tnuma_clear_node */
	.byte 0x0b, 0xc6, 0xf0, 0x99, 0x70, 0x6b, 0x72, 0x00, 0x24, 0xfa, 0xb8, 0xd3	/* t__pfx_init_pkru_write_file */
	.byte 0x0b, 0x74, 0xf0, 0x99, 0x70, 0x6b, 0x72, 0x00, 0x24, 0xfa, 0xb8, 0xd3	/* tinit_pkru_write_file */
	.byte 0x0b, 0xc6, 0xf0, 0x99, 0x70, 0x6b, 0x72, 0x00, 0xf8, 0x05, 0xb8, 0xd3	/* t__pfx_init_pkru_read_file */
	.byte 0x0b, 0x74, 0xf0, 0x99, 0x70, 0x6b, 0x72, 0x00, 0xf8, 0x05, 0xb8, 0xd3	/* tinit_pkru_read_file */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0xd1, 0x65, 0x63, 0x5e, 0xfa, 0x6f, 0x6e, 0x6c, 0x79, 0xe7, 0x0e, 0x79	/* T__pfx___execute_only_pkey */
	.byte 0x0d, 0x2f, 0xd1, 0x65, 0x63, 0x5e, 0xfa, 0x6f, 0x6e, 0x6c, 0x79, 0xe7, 0x0e, 0x79	/* T__execute_only_pkey */
	.byte 0x14, 0x3f, 0xff, 0x5f, 0xca, 0xd0, 0x5f, 0x6f, 0x76, 0xee, 0x72, 0x89, 0xfa, 0xb0, 0xde, 0x9a, 0x63, 0xf9, 0x70, 0x0e, 0x79	/* T__pfx___arch_override_mprotect_pkey */
	.byte 0x12, 0x2f, 0xca, 0xd0, 0x5f, 0x6f, 0x76, 0xee, 0x72, 0x89, 0xfa, 0xb0, 0xde, 0x9a, 0x63, 0xf9, 0x70, 0x0e, 0x79	/* T__arch_override_mprotect_pkey */
	.byte 0x0d, 0xbf, 0xf0, 0x99, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x6b, 0x96, 0x6c, 0x72	/* T__pfx_init_trampoline_kaslr */
	.byte 0x0d, 0x54, 0xf0, 0x99, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x6b, 0x96, 0x6c, 0x72	/* Tinit_trampoline_kaslr */
	.byte 0x09, 0xa8, 0xe7, 0x34, 0xe5, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* t__pfx_p4d_offset */
	.byte 0x08, 0x06, 0x34, 0xe5, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* tp4d_offset */
	.byte 0x11, 0xa8, 0xe7, 0x74, 0xcb, 0x5d, 0xee, 0xe7, 0x03, 0xdb, 0x62, 0xb3, 0x77, 0xe1, 0x6b, 0xe7, 0x34, 0x64	/* t__pfx_pti_user_pagetable_walk_p4d */
	.byte 0x10, 0x06, 0x74, 0xcb, 0x5d, 0xee, 0xe7, 0x03, 0xdb, 0x62, 0xb3, 0x77, 0xe1, 0x6b, 0xe7, 0x34, 0x64	/* tpti_user_pagetable_walk_p4d */
	.byte 0x11, 0xa8, 0xe7, 0x74, 0xcb, 0x5d, 0xee, 0xe7, 0x03, 0xdb, 0x62, 0xb3, 0x77, 0xe1, 0x6b, 0xe7, 0x6d, 0x64	/* t__pfx_pti_user_pagetable_walk_pmd */
	.byte 0x10, 0x06, 0x74, 0xcb, 0x5d, 0xee, 0xe7, 0x03, 0xdb, 0x62, 0xb3, 0x77, 0xe1, 0x6b, 0xe7, 0x6d, 0x64	/* tpti_user_pagetable_walk_pmd */
	.byte 0x14, 0xa8, 0xe7, 0x74, 0xcb, 0x63, 0xdf, 0x6e, 0xfa, 0x70, 0x67, 0xdb, 0x62, 0xd3, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_pti_clone_pgtable.constprop.0 */
	.byte 0x13, 0x06, 0x74, 0xcb, 0x63, 0xdf, 0x6e, 0xfa, 0x70, 0x67, 0xdb, 0x62, 0xd3, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tpti_clone_pgtable.constprop.0 */
	.byte 0x0c, 0x3f, 0xff, 0xe7, 0xc2, 0x1f, 0x5d, 0xee, 0xe7, 0x67, 0x74, 0x62, 0x6c	/* T__pfx___pti_set_user_pgtbl */
	.byte 0x0b, 0x2f, 0x70, 0xc2, 0x1f, 0x5d, 0xee, 0xe7, 0x67, 0x74, 0x62, 0x6c	/* T__pti_set_user_pgtbl */
	.byte 0x0a, 0x3f, 0xe7, 0x74, 0xcb, 0x66, 0xf0, 0xe1, 0x69, 0x7a, 0x65	/* T__pfx_pti_finalize */
	.byte 0x0a, 0x54, 0x70, 0x74, 0xcb, 0x66, 0xf0, 0xe1, 0x69, 0x7a, 0x65	/* Tpti_finalize */
	.byte 0x0f, 0xbf, 0x66, 0xce, 0x63, 0xfa, 0x64, 0xdd, 0x5f, 0xd4, 0xe8, 0x63, 0x72, 0x27, 0x9a, 0x64	/* T__pfx_force_dma_unencrypted */
	.byte 0x0f, 0x54, 0x66, 0xce, 0x63, 0xfa, 0x64, 0xdd, 0x5f, 0xd4, 0xe8, 0x63, 0x72, 0x27, 0x9a, 0x64	/* Tforce_dma_unencrypted */
	.byte 0x12, 0xc6, 0x61, 0x6d, 0xe5, 0xe8, 0xd5, 0x74, 0x6c, 0xdc, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x8e, 0x69, 0xf8, 0x64	/* t__pfx_amd_enc_tlb_flush_required */
	.byte 0x11, 0xdb, 0x6d, 0xe5, 0xe8, 0xd5, 0x74, 0x6c, 0xdc, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x8e, 0x69, 0xf8, 0x64	/* tamd_enc_tlb_flush_required */
	.byte 0x13, 0xc6, 0x61, 0x6d, 0xe5, 0xe8, 0xd5, 0x63, 0xeb, 0x68, 0xfa, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x8e, 0x69, 0xf8, 0x64	/* t__pfx_amd_enc_cache_flush_required */
	.byte 0x12, 0xdb, 0x6d, 0xe5, 0xe8, 0xd5, 0x63, 0xeb, 0x68, 0xfa, 0x66, 0x6c, 0x5d, 0x5b, 0xf8, 0x8e, 0x69, 0xf8, 0x64	/* tamd_enc_cache_flush_required */
	.byte 0x0b, 0xa8, 0xe7, 0xa6, 0xd3, 0x76, 0x65, 0xc3, 0xac, 0x5f, 0xef, 0x6e	/* t__pfx_pg_level_to_pfn */
	.byte 0x0a, 0x06, 0xa6, 0xd3, 0x76, 0x65, 0xc3, 0xac, 0x5f, 0xef, 0x6e	/* tpg_level_to_pfn */
	.byte 0x0a, 0xc6, 0xe8, 0xd5, 0xe6, 0xd5, 0x68, 0x27, 0xee, 0x28, 0x6c	/* t__pfx_enc_dec_hypercall */
	.byte 0x0a, 0x74, 0xe8, 0xd5, 0xe6, 0xd5, 0x68, 0x27, 0xee, 0x28, 0x6c	/* tenc_dec_hypercall */
	.byte 0x11, 0xc6, 0x61, 0x6d, 0xe5, 0xe8, 0x63, 0x2a, 0xe9, 0x75, 0xe0, 0xd0, 0xcc, 0x21, 0x66, 0xf0, 0xab, 0x68	/* t__pfx_amd_enc_status_change_finish */
	.byte 0x10, 0xdb, 0x6d, 0xe5, 0xe8, 0x63, 0x2a, 0xe9, 0x75, 0xe0, 0xd0, 0xcc, 0x21, 0x66, 0xf0, 0xab, 0x68	/* tamd_enc_status_change_finish */
	.byte 0x12, 0xc6, 0x61, 0x6d, 0xe5, 0xe8, 0x63, 0x2a, 0xe9, 0x75, 0xe0, 0xd0, 0xcc, 0x21, 0x70, 0xf8, 0x70, 0x61, 0xf8	/* t__pfx_amd_enc_status_change_prepare */
	.byte 0x11, 0xdb, 0x6d, 0xe5, 0xe8, 0x63, 0x2a, 0xe9, 0x75, 0xe0, 0xd0, 0xcc, 0x21, 0x70, 0xf8, 0x70, 0x61, 0xf8	/* tamd_enc_status_change_prepare */
	.byte 0x0e, 0x3f, 0xf6, 0x6d, 0xfa, 0xe8, 0x63, 0x72, 0x27, 0xf9, 0xd1, 0x65, 0x63, 0x75, 0x9a	/* T__pfx_sme_encrypt_execute */
	.byte 0x0e, 0x54, 0x73, 0x6d, 0xfa, 0xe8, 0x63, 0x72, 0x27, 0xf9, 0xd1, 0x65, 0x63, 0x75, 0x9a	/* Tsme_encrypt_execute */
	.byte 0x08, 0x3f, 0xff, 0x5f, 0xe8, 0xd5, 0xfe, 0x70, 0x79	/* T__pfx___enc_copy */
	.byte 0x06, 0x2f, 0xe8, 0xd5, 0xfe, 0x70, 0x79	/* T__enc_copy */
	.byte 0x0d, 0xbf, 0x62, 0x1b, 0x0e, 0x32, 0xe0, 0x09, 0x3d, 0x73, 0xf6, 0x73, 0xc9, 0x33	/* T__pfx_blake2s_compress_ssse3 */
	.byte 0x0d, 0x54, 0x62, 0x1b, 0x0e, 0x32, 0xe0, 0x09, 0x3d, 0x73, 0xf6, 0x73, 0xc9, 0x33	/* Tblake2s_compress_ssse3 */
	.byte 0x0f, 0xbf, 0x62, 0x1b, 0x0e, 0x32, 0xe0, 0x09, 0x3d, 0xe0, 0x61, 0x76, 0x78, 0x35, 0x31, 0x32	/* T__pfx_blake2s_compress_avx512 */
	.byte 0x0f, 0x54, 0x62, 0x1b, 0x0e, 0x32, 0xe0, 0x09, 0x3d, 0xe0, 0x61, 0x76, 0x78, 0x35, 0x31, 0x32	/* Tblake2s_compress_avx512 */
	.byte 0x09, 0xbf, 0x62, 0x1b, 0x0e, 0x32, 0xe0, 0x09, 0x3d, 0x73	/* T__pfx_blake2s_compress */
	.byte 0x09, 0x54, 0x62, 0x1b, 0x0e, 0x32, 0xe0, 0x09, 0x3d, 0x73	/* Tblake2s_compress */
	.byte 0x11, 0xbf, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x63, 0x6c, 0x96, 0x73, 0x69, 0x66, 0x79, 0x95, 0x73, 0x28, 0x6c	/* T__pfx_ia32_classify_syscall */
	.byte 0x11, 0x54, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x63, 0x6c, 0x96, 0x73, 0x69, 0x66, 0x79, 0x95, 0x73, 0x28, 0x6c	/* Tia32_classify_syscall */
	.byte 0x0f, 0xbf, 0x65, 0xb8, 0x76, 0xca, 0x5f, 0x3d, 0xee, 0x76, 0x65, 0x64, 0xf6, 0x70, 0xeb, 0x65	/* T__pfx_efivar_reserved_space */
	.byte 0x0f, 0x54, 0x65, 0xb8, 0x76, 0xca, 0x5f, 0x3d, 0xee, 0x76, 0x65, 0x64, 0xf6, 0x70, 0xeb, 0x65	/* Tefivar_reserved_space */
	.byte 0x12, 0xbf, 0x65, 0x66, 0xcb, 0xe6, 0xd3, 0x74, 0xfa, 0x64, 0x75, 0x6d, 0x6d, 0xc5, 0x76, 0xca, 0x69, 0x80, 0xd3	/* T__pfx_efi_delete_dummy_variable */
	.byte 0x12, 0x54, 0x65, 0x66, 0xcb, 0xe6, 0xd3, 0x74, 0xfa, 0x64, 0x75, 0x6d, 0x6d, 0xc5, 0x76, 0xca, 0x69, 0x80, 0xd3	/* Tefi_delete_dummy_variable */
	.byte 0x0f, 0xbf, 0x65, 0x66, 0xcb, 0x8e, 0xee, 0xc5, 0x76, 0xca, 0x69, 0x80, 0xb3, 0xd6, 0x6f, 0xf8	/* T__pfx_efi_query_variable_store */
	.byte 0x0f, 0x54, 0x65, 0x66, 0xcb, 0x8e, 0xee, 0xc5, 0x76, 0xca, 0x69, 0x80, 0xb3, 0xd6, 0x6f, 0xf8	/* Tefi_query_variable_store */
	.byte 0x0e, 0xbf, 0x65, 0x66, 0xcb, 0xf8, 0x62, 0x6f, 0x6f, 0xf9, 0xf8, 0x8e, 0x69, 0xf8, 0x64	/* T__pfx_efi_reboot_required */
	.byte 0x0e, 0x54, 0x65, 0x66, 0xcb, 0xf8, 0x62, 0x6f, 0x6f, 0xf9, 0xf8, 0x8e, 0x69, 0xf8, 0x64	/* Tefi_reboot_required */
	.byte 0x0f, 0xbf, 0x65, 0xb8, 0xe7, 0x6f, 0x77, 0xee, 0x6f, 0x66, 0xa0, 0xf8, 0x8e, 0x69, 0xf8, 0x64	/* T__pfx_efi_poweroff_required */
	.byte 0x0f, 0x54, 0x65, 0xb8, 0xe7, 0x6f, 0x77, 0xee, 0x6f, 0x66, 0xa0, 0xf8, 0x8e, 0x69, 0xf8, 0x64	/* Tefi_poweroff_required */
	.byte 0x19, 0xbf, 0x65, 0x66, 0xcb, 0x63, 0xb5, 0x73, 0x5b, 0x67, 0x72, 0xeb, 0x65, 0x66, 0x0b, 0x6c, 0xc5, 0x6f, 0x6e, 0xe7, 0x61, 0x21, 0x66, 0x61, 0x0b, 0x74	/* T__pfx_efi_crash_gracefully_on_page_fault */
	.byte 0x19, 0x54, 0x65, 0x66, 0xcb, 0x63, 0xb5, 0x73, 0x5b, 0x67, 0x72, 0xeb, 0x65, 0x66, 0x0b, 0x6c, 0xc5, 0x6f, 0x6e, 0xe7, 0x61, 0x21, 0x66, 0x61, 0x0b, 0x74	/* Tefi_crash_gracefully_on_page_fault */
	.byte 0x09, 0xc6, 0x66, 0xaa, 0x76, 0xe8, 0x64, 0xce, 0xf6, 0x26	/* t__pfx_fw_vendor_show */
	.byte 0x09, 0x74, 0x66, 0xaa, 0x76, 0xe8, 0x64, 0xce, 0xf6, 0x26	/* tfw_vendor_show */
	.byte 0x08, 0xc6, 0x72, 0xd4, 0xc2, 0x6d, 0xfa, 0x73, 0x26	/* t__pfx_runtime_show */
	.byte 0x07, 0xea, 0xd4, 0xc2, 0x6d, 0xfa, 0x73, 0x26	/* truntime_show */
	.byte 0x09, 0xc6, 0x98, 0xb8, 0xa6, 0xdb, 0x62, 0xb3, 0x73, 0x26	/* t__pfx_config_table_show */
	.byte 0x09, 0x74, 0x98, 0xb8, 0xa6, 0xdb, 0x62, 0xb3, 0x73, 0x26	/* tconfig_table_show */
	.byte 0x0c, 0xbf, 0x65, 0x66, 0xcb, 0x69, 0xe0, 0xdb, 0x62, 0xb3, 0x10, 0x3d, 0x73	/* T__pfx_efi_is_table_address */
	.byte 0x0c, 0x54, 0x65, 0x66, 0xcb, 0x69, 0xe0, 0xdb, 0x62, 0xb3, 0x10, 0x3d, 0x73	/* Tefi_is_table_address */
	.byte 0x0c, 0xbf, 0x65, 0xb8, 0x95, 0x73, 0xdb, 0x62, 0xf6, 0xad, 0xaa, 0xca, 0xd0	/* T__pfx_efi_systab_show_arch */
	.byte 0x0c, 0x54, 0x65, 0xb8, 0x95, 0x73, 0xdb, 0x62, 0xf6, 0xad, 0xaa, 0xca, 0xd0	/* Tefi_systab_show_arch */
	.byte 0x0e, 0xbf, 0x65, 0x66, 0xcb, 0xe9, 0xea, 0x5f, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* T__pfx_efi_attr_is_visible */
	.byte 0x0e, 0x54, 0x65, 0x66, 0xcb, 0xe9, 0xea, 0x5f, 0x69, 0xe0, 0x76, 0xab, 0x69, 0x62, 0xd3	/* Tefi_attr_is_visible */
	.byte 0x13, 0x3f, 0xff, 0x5f, 0x78, 0x38, 0x36, 0x5f, 0x69, 0xdd, 0x5f, 0x65, 0x66, 0xcb, 0x62, 0x6f, 0x6f, 0xf9, 0xa5, 0xe6	/* T__pfx___x86_ima_efi_boot_mode */
	.byte 0x11, 0x2f, 0x78, 0x38, 0x36, 0x5f, 0x69, 0xdd, 0x5f, 0x65, 0x66, 0xcb, 0x62, 0x6f, 0x6f, 0xf9, 0xa5, 0xe6	/* T__x86_ima_efi_boot_mode */
	.byte 0x09, 0xa8, 0xe7, 0x34, 0xe5, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* t__pfx_p4d_offset */
	.byte 0x08, 0x06, 0x34, 0xe5, 0x6f, 0x66, 0x66, 0xc9, 0x74	/* tp4d_offset */
	.byte 0x11, 0xbf, 0x65, 0xb8, 0x95, 0x6e, 0xd5, 0xdf, 0xaa, 0x6b, 0xee, 0xb4, 0xc3, 0x0a, 0x70, 0xf0, 0x67, 0x73	/* T__pfx_efi_sync_low_kernel_mappings */
	.byte 0x11, 0x54, 0x65, 0xb8, 0x95, 0x6e, 0xd5, 0xdf, 0xaa, 0x6b, 0xee, 0xb4, 0xc3, 0x0a, 0x70, 0xf0, 0x67, 0x73	/* Tefi_sync_low_kernel_mappings */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0x65, 0x66, 0xcb, 0x28, 0xc3, 0x76, 0xa7, 0xf9, 0xc9, 0x74, 0xb9	/* T__pfx_arch_efi_call_virt_setup */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0x65, 0x66, 0xcb, 0x28, 0xc3, 0x76, 0xa7, 0xf9, 0xc9, 0x74, 0xb9	/* Tarch_efi_call_virt_setup */
	.byte 0x11, 0xbf, 0xca, 0xd0, 0x5f, 0x65, 0x66, 0xcb, 0x28, 0xc3, 0x76, 0xa7, 0xf9, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* T__pfx_arch_efi_call_virt_teardown */
	.byte 0x11, 0x54, 0xca, 0xd0, 0x5f, 0x65, 0x66, 0xcb, 0x28, 0xc3, 0x76, 0xa7, 0xf9, 0x9a, 0xca, 0xa9, 0x77, 0x6e	/* Tarch_efi_call_virt_teardown */
	.byte 0x08, 0x3f, 0xff, 0x5f, 0x65, 0x66, 0xcb, 0x28, 0x6c	/* T__pfx___efi_call */
	.byte 0x06, 0x2f, 0x65, 0x66, 0xcb, 0x28, 0x6c	/* T__efi_call */
	.byte 0x06, 0xc6, 0x84, 0xe9, 0xea, 0xf6, 0x26	/* t__pfx_map_attr_show */
	.byte 0x06, 0x74, 0x84, 0xe9, 0xea, 0xf6, 0x26	/* tmap_attr_show */
	.byte 0x09, 0xc6, 0xe9, 0xea, 0x69, 0xa2, 0x74, 0xfa, 0x73, 0x26	/* t__pfx_attribute_show */
	.byte 0x09, 0x74, 0xe9, 0xea, 0x69, 0xa2, 0x74, 0xfa, 0x73, 0x26	/* tattribute_show */
	.byte 0x09, 0xc6, 0x6e, 0x75, 0x6d, 0xe7, 0x03, 0x73, 0xf6, 0x26	/* t__pfx_num_pages_show */
	.byte 0x09, 0x74, 0x6e, 0x75, 0x6d, 0xe7, 0x03, 0x73, 0xf6, 0x26	/* tnum_pages_show */
	.byte 0x08, 0xc6, 0x76, 0xa7, 0xf9, 0x10, 0x72, 0xf6, 0x26	/* t__pfx_virt_addr_show */
	.byte 0x08, 0x74, 0x76, 0xa7, 0xf9, 0x10, 0x72, 0xf6, 0x26	/* tvirt_addr_show */
	.byte 0x09, 0xa8, 0xe7, 0x68, 0x79, 0xe0, 0x10, 0x72, 0xf6, 0x26	/* t__pfx_phys_addr_show */
	.byte 0x08, 0x06, 0x68, 0x79, 0xe0, 0x10, 0x72, 0xf6, 0x26	/* tphys_addr_show */
	.byte 0x06, 0xc6, 0x74, 0x27, 0xfa, 0x73, 0x26	/* t__pfx_type_show */
	.byte 0x06, 0x74, 0x74, 0x27, 0xfa, 0x73, 0x26	/* ttype_show */
	.byte 0x06, 0xc6, 0x84, 0xf8, 0xd3, 0x61, 0xc9	/* t__pfx_map_release */
	.byte 0x06, 0x74, 0x84, 0xf8, 0xd3, 0x61, 0xc9	/* tmap_release */
	.byte 0x0f, 0xbf, 0x65, 0x66, 0xcb, 0xb2, 0x72, 0xd4, 0xc2, 0x6d, 0xfa, 0x0a, 0xf6, 0x69, 0x7a, 0x65	/* T__pfx_efi_get_runtime_map_size */
	.byte 0x0f, 0x54, 0x65, 0x66, 0xcb, 0xb2, 0x72, 0xd4, 0xc2, 0x6d, 0xfa, 0x0a, 0xf6, 0x69, 0x7a, 0x65	/* Tefi_get_runtime_map_size */
	.byte 0x12, 0xbf, 0x65, 0x66, 0xcb, 0xb2, 0x72, 0xd4, 0xc2, 0x6d, 0xfa, 0x84, 0xe6, 0x73, 0x63, 0xf6, 0x69, 0x7a, 0x65	/* T__pfx_efi_get_runtime_map_desc_size */
	.byte 0x12, 0x54, 0x65, 0x66, 0xcb, 0xb2, 0x72, 0xd4, 0xc2, 0x6d, 0xfa, 0x84, 0xe6, 0x73, 0x63, 0xf6, 0x69, 0x7a, 0x65	/* Tefi_get_runtime_map_desc_size */
	.byte 0x0d, 0xbf, 0x65, 0x66, 0xcb, 0x72, 0xd4, 0xc2, 0x6d, 0xfa, 0x84, 0xfe, 0x70, 0x79	/* T__pfx_efi_runtime_map_copy */
	.byte 0x0d, 0x54, 0x65, 0x66, 0xcb, 0x72, 0xd4, 0xc2, 0x6d, 0xfa, 0x84, 0xfe, 0x70, 0x79	/* Tefi_runtime_map_copy */
	.byte 0x0e, 0xbf, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x80, 0xd3	/* T__pfx_iosf_mbi_available */
	.byte 0x0e, 0x54, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x80, 0xd3	/* Tiosf_mbi_available */
	.byte 0x13, 0xbf, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0x96, 0x73, 0xee, 0xf9, 0x70, 0xd4, 0x99, 0xeb, 0x8e, 0x69, 0xf8, 0x64	/* T__pfx_iosf_mbi_assert_punit_acquired */
	.byte 0x13, 0x54, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0x96, 0x73, 0xee, 0xf9, 0x70, 0xd4, 0x99, 0xeb, 0x8e, 0x69, 0xf8, 0x64	/* Tiosf_mbi_assert_punit_acquired */
	.byte 0x0f, 0xc6, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0x69, 0xe7, 0x63, 0xcb, 0x24, 0xfa, 0x6d, 0x64, 0x72	/* t__pfx_iosf_mbi_pci_write_mdr */
	.byte 0x0f, 0x74, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0x69, 0xe7, 0x63, 0xcb, 0x24, 0xfa, 0x6d, 0x64, 0x72	/* tiosf_mbi_pci_write_mdr */
	.byte 0x09, 0xbf, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0x24, 0x65	/* T__pfx_iosf_mbi_write */
	.byte 0x09, 0x54, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0x24, 0x65	/* Tiosf_mbi_write */
	.byte 0x0f, 0xc6, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0x69, 0xe7, 0x63, 0xcb, 0xf8, 0x05, 0x6d, 0x64, 0x72	/* t__pfx_iosf_mbi_pci_read_mdr */
	.byte 0x0f, 0x74, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0x69, 0xe7, 0x63, 0xcb, 0xf8, 0x05, 0x6d, 0x64, 0x72	/* tiosf_mbi_pci_read_mdr */
	.byte 0x0c, 0xbf, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xa5, 0x64, 0x69, 0x66, 0x79	/* T__pfx_iosf_mbi_modify */
	.byte 0x0c, 0x54, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xa5, 0x64, 0x69, 0x66, 0x79	/* Tiosf_mbi_modify */
	.byte 0x09, 0xbf, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xf8, 0xc7	/* T__pfx_iosf_mbi_read */
	.byte 0x09, 0x54, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xf8, 0xc7	/* Tiosf_mbi_read */
	.byte 0x0a, 0xc6, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xb2, 0xc9, 0x6d	/* t__pfx_iosf_mbi_get_sem */
	.byte 0x0a, 0x74, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xb2, 0xc9, 0x6d	/* tiosf_mbi_get_sem */
	.byte 0x0e, 0xbf, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0x69, 0xe7, 0xd4, 0x99, 0xeb, 0x8e, 0x69, 0xf8	/* T__pfx_iosf_mbi_punit_acquire */
	.byte 0x0e, 0x54, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0x69, 0xe7, 0xd4, 0x99, 0xeb, 0x8e, 0x69, 0xf8	/* Tiosf_mbi_punit_acquire */
	.byte 0x0e, 0xbf, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0x69, 0xe7, 0xd4, 0x99, 0xf8, 0xd3, 0x61, 0xc9	/* T__pfx_iosf_mbi_punit_release */
	.byte 0x0e, 0x54, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0x69, 0xe7, 0xd4, 0x99, 0xf8, 0xd3, 0x61, 0xc9	/* Tiosf_mbi_punit_release */
	.byte 0x0e, 0xc6, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xf8, 0xc9, 0xf9, 0xc9, 0x0a, 0xad, 0xf8	/* t__pfx_iosf_mbi_reset_semaphore */
	.byte 0x0e, 0x74, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xf8, 0xc9, 0xf9, 0xc9, 0x0a, 0xad, 0xf8	/* tiosf_mbi_reset_semaphore */
	.byte 0x14, 0xbf, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xd4, 0x62, 0x3c, 0xe7, 0xd4, 0x99, 0x69, 0x32, 0xd5, 0xeb, 0x63, 0x3b, 0x73	/* T__pfx_iosf_mbi_unblock_punit_i2c_access */
	.byte 0x14, 0x54, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xd4, 0x62, 0x3c, 0xe7, 0xd4, 0x99, 0x69, 0x32, 0xd5, 0xeb, 0x63, 0x3b, 0x73	/* Tiosf_mbi_unblock_punit_i2c_access */
	.byte 0x13, 0xbf, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0x62, 0x3c, 0xe7, 0xd4, 0x99, 0x69, 0x32, 0xd5, 0xeb, 0x63, 0x3b, 0x73	/* T__pfx_iosf_mbi_block_punit_i2c_access */
	.byte 0x13, 0x54, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0x62, 0x3c, 0xe7, 0xd4, 0x99, 0x69, 0x32, 0xd5, 0xeb, 0x63, 0x3b, 0x73	/* Tiosf_mbi_block_punit_i2c_access */
	.byte 0x17, 0xbf, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0x18, 0xee, 0xe7, 0x6d, 0x69, 0xd5, 0xa2, 0xe0, 0xeb, 0x63, 0x3b, 0xe0, 0xb6, 0xc2, 0xb8, 0xee	/* T__pfx_iosf_mbi_register_pmic_bus_access_notifier */
	.byte 0x17, 0x54, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0x18, 0xee, 0xe7, 0x6d, 0x69, 0xd5, 0xa2, 0xe0, 0xeb, 0x63, 0x3b, 0xe0, 0xb6, 0xc2, 0xb8, 0xee	/* Tiosf_mbi_register_pmic_bus_access_notifier */
	.byte 0x1c, 0xbf, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xd4, 0x18, 0xee, 0xe7, 0x6d, 0x69, 0xd5, 0xa2, 0xe0, 0xeb, 0x63, 0x3b, 0xe0, 0xb6, 0xc2, 0xb8, 0xcf, 0xd4, 0x3c, 0x65, 0x64	/* T__pfx_iosf_mbi_unregister_pmic_bus_access_notifier_unlocked */
	.byte 0x1c, 0x54, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xd4, 0x18, 0xee, 0xe7, 0x6d, 0x69, 0xd5, 0xa2, 0xe0, 0xeb, 0x63, 0x3b, 0xe0, 0xb6, 0xc2, 0xb8, 0xcf, 0xd4, 0x3c, 0x65, 0x64	/* Tiosf_mbi_unregister_pmic_bus_access_notifier_unlocked */
	.byte 0x18, 0xbf, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xd4, 0x18, 0xee, 0xe7, 0x6d, 0x69, 0xd5, 0xa2, 0xe0, 0xeb, 0x63, 0x3b, 0xe0, 0xb6, 0xc2, 0xb8, 0xee	/* T__pfx_iosf_mbi_unregister_pmic_bus_access_notifier */
	.byte 0x18, 0x54, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0xcb, 0xd4, 0x18, 0xee, 0xe7, 0x6d, 0x69, 0xd5, 0xa2, 0xe0, 0xeb, 0x63, 0x3b, 0xe0, 0xb6, 0xc2, 0xb8, 0xee	/* Tiosf_mbi_unregister_pmic_bus_access_notifier */
	.byte 0x09, 0xc6, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0x69, 0x25, 0x17	/* t__pfx_iosf_mbi_probe */
	.byte 0x09, 0x74, 0xd9, 0x73, 0xa0, 0x6d, 0x62, 0x69, 0x25, 0x17	/* tiosf_mbi_probe */
	.byte 0x09, 0xa8, 0xe7, 0x5d, 0x5b, 0x28, 0xd3, 0xfa, 0x9f, 0x73	/* t__pfx_push_callee_regs */
	.byte 0x09, 0x74, 0xbe, 0x73, 0x5b, 0x28, 0xd3, 0xfa, 0x9f, 0x73	/* tpush_callee_regs */
	.byte 0x09, 0xa8, 0xe7, 0x6f, 0xe2, 0x28, 0xd3, 0xfa, 0x9f, 0x73	/* t__pfx_pop_callee_regs */
	.byte 0x08, 0x06, 0x6f, 0xe2, 0x28, 0xd3, 0xfa, 0x9f, 0x73	/* tpop_callee_regs */
	.byte 0x07, 0xc6, 0x65, 0x6d, 0x99, 0xb6, 0x70, 0x73	/* t__pfx_emit_nops */
	.byte 0x06, 0x9a, 0x6d, 0x99, 0xb6, 0x70, 0x73	/* temit_nops */
	.byte 0x0c, 0xc6, 0x65, 0x6d, 0x99, 0xa5, 0x76, 0x5f, 0x69, 0x6d, 0x6d, 0x33, 0x32	/* t__pfx_emit_mov_imm32 */
	.byte 0x0b, 0x9a, 0x6d, 0x99, 0xa5, 0x76, 0x5f, 0x69, 0x6d, 0x6d, 0x33, 0x32	/* temit_mov_imm32 */
	.byte 0x0c, 0xc6, 0x65, 0x6d, 0x99, 0xa5, 0x76, 0x5f, 0x69, 0x6d, 0x6d, 0x36, 0x34	/* t__pfx_emit_mov_imm64 */
	.byte 0x0b, 0x9a, 0x6d, 0x99, 0xa5, 0x76, 0x5f, 0x69, 0x6d, 0x6d, 0x36, 0x34	/* temit_mov_imm64 */
	.byte 0x08, 0xc6, 0x65, 0x6d, 0x99, 0xa5, 0x76, 0x5f, 0x9f	/* t__pfx_emit_mov_reg */
	.byte 0x07, 0x9a, 0x6d, 0x99, 0xa5, 0x76, 0x5f, 0x9f	/* temit_mov_reg */
	.byte 0x0c, 0xc6, 0x65, 0x6d, 0x99, 0xf0, 0x73, 0x6e, 0xf6, 0x75, 0x66, 0xb8, 0x78	/* t__pfx_emit_insn_suffix */
	.byte 0x0b, 0x9a, 0x6d, 0x99, 0xf0, 0x73, 0x6e, 0xf6, 0x75, 0x66, 0xb8, 0x78	/* temit_insn_suffix */
	.byte 0x0a, 0xc6, 0xdd, 0x79, 0x62, 0xfa, 0x65, 0x6d, 0x99, 0xa5, 0x64	/* t__pfx_maybe_emit_mod */
	.byte 0x0a, 0x74, 0xdd, 0x79, 0x62, 0xfa, 0x65, 0x6d, 0x99, 0xa5, 0x64	/* tmaybe_emit_mod */
	.byte 0x0b, 0xc6, 0xdd, 0x79, 0x62, 0xfa, 0x65, 0x6d, 0x99, 0x31, 0xa5, 0x64	/* t__pfx_maybe_emit_1mod */
	.byte 0x0b, 0x74, 0xdd, 0x79, 0x62, 0xfa, 0x65, 0x6d, 0x99, 0x31, 0xa5, 0x64	/* tmaybe_emit_1mod */
	.byte 0x06, 0xc6, 0x65, 0x6d, 0x99, 0x02, 0x78	/* t__pfx_emit_ldx */
	.byte 0x05, 0x9a, 0x6d, 0x99, 0x02, 0x78	/* temit_ldx */
	.byte 0x06, 0xc6, 0x65, 0x6d, 0x99, 0xd6, 0x78	/* t__pfx_emit_stx */
	.byte 0x05, 0x9a, 0x6d, 0x99, 0xd6, 0x78	/* temit_stx */
	.byte 0x06, 0xc6, 0x63, 0x6d, 0xe2, 0x0c, 0x73	/* t__pfx_cmp_ips */
	.byte 0x05, 0x2d, 0x6d, 0xe2, 0x0c, 0x73	/* tcmp_ips */
	.byte 0x0c, 0xc6, 0x65, 0x6d, 0x99, 0x98, 0xe5, 0xb4, 0xca, 0x5f, 0x6a, 0x75, 0xb0	/* t__pfx_emit_cond_near_jump */
	.byte 0x0b, 0x9a, 0x6d, 0x99, 0x98, 0xe5, 0xb4, 0xca, 0x5f, 0x6a, 0x75, 0xb0	/* temit_cond_near_jump */
	.byte 0x08, 0xc6, 0x65, 0x6d, 0x99, 0xe9, 0x6f, 0x6d, 0xa3	/* t__pfx_emit_atomic */
	.byte 0x07, 0x9a, 0x6d, 0x99, 0xe9, 0x6f, 0x6d, 0xa3	/* temit_atomic */
	.byte 0x07, 0xc6, 0x65, 0x6d, 0x99, 0x70, 0xe9, 0xd0	/* t__pfx_emit_patch */
	.byte 0x06, 0x9a, 0x6d, 0x99, 0x70, 0xe9, 0xd0	/* temit_patch */
	.byte 0x08, 0xc6, 0x65, 0x6d, 0x99, 0xf8, 0x74, 0x1d, 0x6e	/* t__pfx_emit_return */
	.byte 0x07, 0x9a, 0x6d, 0x99, 0xf8, 0x74, 0x1d, 0x6e	/* temit_return */
	.byte 0x0d, 0xc6, 0x65, 0x6d, 0x99, 0xf0, 0x64, 0x69, 0xf8, 0x63, 0xf9, 0x6a, 0x75, 0xb0	/* t__pfx_emit_indirect_jump */
	.byte 0x0c, 0x9a, 0x6d, 0x99, 0xf0, 0x64, 0x69, 0xf8, 0x63, 0xf9, 0x6a, 0x75, 0xb0	/* temit_indirect_jump */
	.byte 0x0c, 0x29, 0x5f, 0x40, 0xca, 0xd0, 0x5f, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x0e	/* t__pfx___bpf_arch_text_poke */
	.byte 0x0c, 0x74, 0xff, 0x40, 0xca, 0xd0, 0x5f, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x0e	/* t__bpf_arch_text_poke */
	.byte 0x08, 0xc6, 0x6a, 0x99, 0xb8, 0x6c, 0xc3, 0xad, 0xd3	/* t__pfx_jit_fill_hole */
	.byte 0x08, 0x74, 0x6a, 0x99, 0xb8, 0x6c, 0xc3, 0xad, 0xd3	/* tjit_fill_hole */
	.byte 0x09, 0xc6, 0x65, 0x6d, 0x99, 0x72, 0x73, 0xdc, 0x28, 0x6c	/* t__pfx_emit_rsb_call */
	.byte 0x08, 0x9a, 0x6d, 0x99, 0x72, 0x73, 0xdc, 0x28, 0x6c	/* temit_rsb_call */
	.byte 0x0e, 0xc6, 0x65, 0x6d, 0x99, 0xe1, 0x2c, 0x6e, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_emit_align.constprop.0 */
	.byte 0x0d, 0x9a, 0x6d, 0x99, 0xe1, 0x2c, 0x6e, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* temit_align.constprop.0 */
	.byte 0x0b, 0xc6, 0x65, 0x6d, 0x99, 0x40, 0x64, 0xab, 0x70, 0xe9, 0xd0, 0xee	/* t__pfx_emit_bpf_dispatcher */
	.byte 0x0a, 0x9a, 0x6d, 0x99, 0x40, 0x64, 0xab, 0x70, 0xe9, 0xd0, 0xee	/* temit_bpf_dispatcher */
	.byte 0x16, 0xc6, 0x65, 0x6d, 0x99, 0xf0, 0x73, 0x6e, 0xf6, 0x75, 0x66, 0xb8, 0x1a, 0x53, 0x49, 0x42, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_emit_insn_suffix_SIB.constprop.0 */
	.byte 0x15, 0x9a, 0x6d, 0x99, 0xf0, 0x73, 0x6e, 0xf6, 0x75, 0x66, 0xb8, 0x1a, 0x53, 0x49, 0x42, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* temit_insn_suffix_SIB.constprop.0 */
	.byte 0x0d, 0xc6, 0x65, 0x6d, 0x99, 0x63, 0xb8, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_emit_cfi.constprop.0 */
	.byte 0x0c, 0x9a, 0x6d, 0x99, 0x63, 0xb8, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* temit_cfi.constprop.0 */
	.byte 0x0d, 0xc6, 0xc7, 0xe5, 0x33, 0xa5, 0x64, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_add_3mod.constprop.0 */
	.byte 0x0d, 0xdb, 0x64, 0xe5, 0x33, 0xa5, 0x64, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tadd_3mod.constprop.0 */
	.byte 0x05, 0xc6, 0xa9, 0x5f, 0x6a, 0xe4	/* t__pfx_do_jit */
	.byte 0x05, 0x74, 0xa9, 0x5f, 0x6a, 0xe4	/* tdo_jit */
	.byte 0x07, 0xc6, 0xf8, 0xd6, 0xce, 0xfa, 0x9f, 0x73	/* t__pfx_restore_regs */
	.byte 0x07, 0x74, 0xf8, 0xd6, 0xce, 0xfa, 0x9f, 0x73	/* trestore_regs */
	.byte 0x07, 0xa8, 0xf6, 0x61, 0x22, 0xca, 0x67, 0x73	/* t__pfx_save_args */
	.byte 0x07, 0x74, 0x73, 0x61, 0x22, 0xca, 0x67, 0x73	/* tsave_args */
	.byte 0x0e, 0xc6, 0xf0, 0x76, 0x6f, 0x6b, 0xfa, 0x91, 0x25, 0x67, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_invoke_bpf_prog.isra.0 */
	.byte 0x0e, 0x74, 0xf0, 0x76, 0x6f, 0x6b, 0xfa, 0x91, 0x25, 0x67, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tinvoke_bpf_prog.isra.0 */
	.byte 0x0c, 0xc6, 0xf0, 0x76, 0x6f, 0x6b, 0xfa, 0x91, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_invoke_bpf.isra.0 */
	.byte 0x0c, 0x74, 0xf0, 0x76, 0x6f, 0x6b, 0xfa, 0x91, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tinvoke_bpf.isra.0 */
	.byte 0x10, 0x29, 0x5f, 0xca, 0xd0, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x40, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* t__pfx___arch_prepare_bpf_trampoline */
	.byte 0x10, 0x74, 0xff, 0xca, 0xd0, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x40, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* t__arch_prepare_bpf_trampoline */
	.byte 0x0d, 0xbf, 0x40, 0xca, 0xd0, 0x5f, 0x74, 0xd1, 0xf9, 0xf0, 0x76, 0xe1, 0x89, 0x86	/* T__pfx_bpf_arch_text_invalidate */
	.byte 0x0d, 0x54, 0x40, 0xca, 0xd0, 0x5f, 0x74, 0xd1, 0xf9, 0xf0, 0x76, 0xe1, 0x89, 0x86	/* Tbpf_arch_text_invalidate */
	.byte 0x0b, 0xbf, 0x40, 0xca, 0xd0, 0x5f, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x0e	/* T__pfx_bpf_arch_text_poke */
	.byte 0x0b, 0x54, 0x40, 0xca, 0xd0, 0x5f, 0x74, 0xd1, 0xf9, 0x70, 0x6f, 0x0e	/* Tbpf_arch_text_poke */
	.byte 0x09, 0xbf, 0xd1, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0x91	/* T__pfx_ex_handler_bpf */
	.byte 0x09, 0x54, 0xd1, 0x5f, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0x91	/* Tex_handler_bpf */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0x5f, 0x08, 0xd5, 0x40, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* T__pfx_arch_alloc_bpf_trampoline */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0x5f, 0x08, 0xd5, 0x40, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* Tarch_alloc_bpf_trampoline */
	.byte 0x0d, 0xbf, 0xca, 0xd0, 0x5f, 0x87, 0xfa, 0x40, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* T__pfx_arch_free_bpf_trampoline */
	.byte 0x0d, 0x54, 0xca, 0xd0, 0x5f, 0x87, 0xfa, 0x40, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* Tarch_free_bpf_trampoline */
	.byte 0x0e, 0xbf, 0xca, 0xd0, 0x25, 0x9a, 0x63, 0xf9, 0x40, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* T__pfx_arch_protect_bpf_trampoline */
	.byte 0x0e, 0x54, 0xca, 0xd0, 0x25, 0x9a, 0x63, 0xf9, 0x40, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* Tarch_protect_bpf_trampoline */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x40, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* T__pfx_arch_prepare_bpf_trampoline */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x40, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0x65	/* Tarch_prepare_bpf_trampoline */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0x5f, 0x40, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x73, 0x69, 0x7a, 0x65	/* T__pfx_arch_bpf_trampoline_size */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0x5f, 0x40, 0xea, 0x61, 0xb0, 0x6f, 0x88, 0xfa, 0x73, 0x69, 0x7a, 0x65	/* Tarch_bpf_trampoline_size */
	.byte 0x0f, 0xbf, 0xca, 0xd0, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x40, 0x64, 0xab, 0x70, 0xe9, 0xd0, 0xee	/* T__pfx_arch_prepare_bpf_dispatcher */
	.byte 0x0f, 0x54, 0xca, 0xd0, 0xe7, 0xf8, 0x70, 0xca, 0xfa, 0x40, 0x64, 0xab, 0x70, 0xe9, 0xd0, 0xee	/* Tarch_prepare_bpf_dispatcher */
	.byte 0x09, 0xbf, 0x40, 0xf0, 0xf9, 0x6a, 0x99, 0x09, 0x69, 0xd3	/* T__pfx_bpf_int_jit_compile */
	.byte 0x09, 0x54, 0x40, 0xf0, 0xf9, 0x6a, 0x99, 0x09, 0x69, 0xd3	/* Tbpf_int_jit_compile */
	.byte 0x0f, 0xbf, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0xe0, 0x6b, 0x2b, 0xd5, 0x28, 0x6c	/* T__pfx_bpf_jit_supports_kfunc_call */
	.byte 0x0f, 0x54, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0xe0, 0x6b, 0x2b, 0xd5, 0x28, 0x6c	/* Tbpf_jit_supports_kfunc_call */
	.byte 0x0b, 0xbf, 0x40, 0xca, 0xd0, 0x5f, 0x74, 0xd1, 0xf9, 0xfe, 0x70, 0x79	/* T__pfx_bpf_arch_text_copy */
	.byte 0x0b, 0x54, 0x40, 0xca, 0xd0, 0x5f, 0x74, 0xd1, 0xf9, 0xfe, 0x70, 0x79	/* Tbpf_arch_text_copy */
	.byte 0x15, 0xbf, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0x73, 0xf6, 0x75, 0x62, 0x9b, 0xa6, 0xdb, 0x69, 0x6c, 0x28, 0x6c, 0x73	/* T__pfx_bpf_jit_supports_subprog_tailcalls */
	.byte 0x15, 0x54, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0x73, 0xf6, 0x75, 0x62, 0x9b, 0xa6, 0xdb, 0x69, 0x6c, 0x28, 0x6c, 0x73	/* Tbpf_jit_supports_subprog_tailcalls */
	.byte 0x11, 0xbf, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0x73, 0xe7, 0xee, 0x92, 0x5f, 0xf0, 0x73, 0x6e	/* T__pfx_bpf_jit_supports_percpu_insn */
	.byte 0x11, 0x54, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0x73, 0xe7, 0xee, 0x92, 0x5f, 0xf0, 0x73, 0x6e	/* Tbpf_jit_supports_percpu_insn */
	.byte 0x06, 0xbf, 0x40, 0x6a, 0x99, 0x87, 0x65	/* T__pfx_bpf_jit_free */
	.byte 0x06, 0x54, 0x40, 0x6a, 0x99, 0x87, 0x65	/* Tbpf_jit_free */
	.byte 0x12, 0xbf, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0xe0, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0x73	/* T__pfx_bpf_jit_supports_exceptions */
	.byte 0x12, 0x54, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0xe0, 0xd1, 0x63, 0x65, 0x70, 0x74, 0xd9, 0x6e, 0x73	/* Tbpf_jit_supports_exceptions */
	.byte 0x0b, 0xbf, 0xca, 0xd0, 0x5f, 0x91, 0x2a, 0xeb, 0xd8, 0x77, 0xe1, 0x6b	/* T__pfx_arch_bpf_stack_walk */
	.byte 0x0b, 0x54, 0xca, 0xd0, 0x5f, 0x91, 0x2a, 0xeb, 0xd8, 0x77, 0xe1, 0x6b	/* Tarch_bpf_stack_walk */
	.byte 0x0e, 0xbf, 0x40, 0xca, 0xd0, 0xe7, 0x6f, 0x6b, 0xfa, 0xe6, 0x73, 0xd5, 0xb9, 0x64, 0x86	/* T__pfx_bpf_arch_poke_desc_update */
	.byte 0x0e, 0x54, 0x40, 0xca, 0xd0, 0xe7, 0x6f, 0x6b, 0xfa, 0xe6, 0x73, 0xd5, 0xb9, 0x64, 0x86	/* Tbpf_arch_poke_desc_update */
	.byte 0x0e, 0xbf, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0xe0, 0x61, 0xf8, 0x6e, 0x61	/* T__pfx_bpf_jit_supports_arena */
	.byte 0x0e, 0x54, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0xe0, 0x61, 0xf8, 0x6e, 0x61	/* Tbpf_jit_supports_arena */
	.byte 0x0d, 0xbf, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0xe0, 0xf0, 0x73, 0x6e	/* T__pfx_bpf_jit_supports_insn */
	.byte 0x0d, 0x54, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0xe0, 0xf0, 0x73, 0x6e	/* Tbpf_jit_supports_insn */
	.byte 0x10, 0xbf, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0x73, 0xe7, 0xea, 0x5f, 0x78, 0xd0, 0x67	/* T__pfx_bpf_jit_supports_ptr_xchg */
	.byte 0x10, 0x54, 0x40, 0x6a, 0x99, 0x73, 0xb9, 0x70, 0xce, 0x74, 0x73, 0xe7, 0xea, 0x5f, 0x78, 0xd0, 0x67	/* Tbpf_jit_supports_ptr_xchg */
	.byte 0x0d, 0xbf, 0x40, 0xca, 0xd0, 0x5f, 0x75, 0x10, 0x3d, 0xe0, 0x6c, 0x69, 0x6d, 0xe4	/* T__pfx_bpf_arch_uaddress_limit */
	.byte 0x0d, 0x54, 0x40, 0xca, 0xd0, 0x5f, 0x75, 0x10, 0x3d, 0xe0, 0x6c, 0x69, 0x6d, 0xe4	/* Tbpf_arch_uaddress_limit */
	.byte 0x0b, 0xa8, 0xe7, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* t__pfx_paravirt_read_msr */
	.byte 0x0a, 0x06, 0xca, 0x61, 0x76, 0xa7, 0xf9, 0xf8, 0x05, 0x20, 0x72	/* tparavirt_read_msr */
	.byte 0x07, 0xc6, 0xb2, 0x72, 0xb0, 0xe8, 0xea, 0x79	/* t__pfx_get_rmpentry */
	.byte 0x07, 0x74, 0xb2, 0x72, 0xb0, 0xe8, 0xea, 0x79	/* tget_rmpentry */
	.byte 0x0d, 0x29, 0xf6, 0x6e, 0xe2, 0xdf, 0x6f, 0x6b, 0x3a, 0x72, 0xb0, 0xe8, 0xea, 0x79	/* t__pfx___snp_lookup_rmpentry */
	.byte 0x0e, 0x74, 0xff, 0x73, 0x6e, 0xe2, 0xdf, 0x6f, 0x6b, 0x3a, 0x72, 0xb0, 0xe8, 0xea, 0x79	/* t__snp_lookup_rmpentry */
	.byte 0x0a, 0xc6, 0x64, 0x75, 0x6d, 0xe2, 0x72, 0xb0, 0xe8, 0xea, 0x79	/* t__pfx_dump_rmpentry */
	.byte 0x0a, 0x74, 0x64, 0x75, 0x6d, 0xe2, 0x72, 0xb0, 0xe8, 0xea, 0x79	/* tdump_rmpentry */
	.byte 0x0d, 0x3f, 0xf6, 0x6e, 0xe2, 0xdf, 0x6f, 0x6b, 0x3a, 0x72, 0xb0, 0xe8, 0xea, 0x79	/* T__pfx_snp_lookup_rmpentry */
	.byte 0x0d, 0x54, 0x73, 0x6e, 0xe2, 0xdf, 0x6f, 0x6b, 0x3a, 0x72, 0xb0, 0xe8, 0xea, 0x79	/* Tsnp_lookup_rmpentry */
	.byte 0x06, 0xc6, 0xef, 0x7c, 0x76, 0xe1, 0x89	/* t__pfx_pfn_valid */
	.byte 0x06, 0x74, 0xef, 0x7c, 0x76, 0xe1, 0x89	/* tpfn_valid */
	.byte 0x06, 0x3f, 0xe7, 0x73, 0xdd, 0x73, 0x68	/* T__pfx_psmash */
	.byte 0x06, 0x54, 0x70, 0x73, 0xdd, 0x73, 0x68	/* Tpsmash */
	.byte 0x07, 0xc6, 0x72, 0x6d, 0xbe, 0x70, 0x64, 0x86	/* t__pfx_rmpupdate */
	.byte 0x06, 0xea, 0x6d, 0xbe, 0x70, 0x64, 0x86	/* trmpupdate */
	.byte 0x0c, 0xbf, 0x72, 0x6d, 0xe2, 0xdd, 0x6b, 0xfa, 0x73, 0x68, 0x61, 0xf8, 0x64	/* T__pfx_rmp_make_shared */
	.byte 0x0c, 0x54, 0x72, 0x6d, 0xe2, 0xdd, 0x6b, 0xfa, 0x73, 0x68, 0x61, 0xf8, 0x64	/* Trmp_make_shared */
	.byte 0x0c, 0xbf, 0x72, 0x6d, 0xe2, 0xdd, 0x6b, 0xfa, 0x70, 0x72, 0x69, 0x76, 0x86	/* T__pfx_rmp_make_private */
	.byte 0x0c, 0x54, 0x72, 0x6d, 0xe2, 0xdd, 0x6b, 0xfa, 0x70, 0x72, 0x69, 0x76, 0x86	/* Trmp_make_private */
	.byte 0x07, 0x29, 0xf6, 0x6e, 0xe2, 0xe8, 0x80, 0xd3	/* t__pfx___snp_enable */
	.byte 0x08, 0x74, 0xff, 0x73, 0x6e, 0xe2, 0xe8, 0x80, 0xd3	/* t__snp_enable */
	.byte 0x0f, 0x3f, 0xf6, 0x6e, 0x70, 0x25, 0x62, 0xfa, 0x72, 0xb0, 0xdb, 0x62, 0xb3, 0xf0, 0x66, 0x6f	/* T__pfx_snp_probe_rmptable_info */
	.byte 0x0f, 0x54, 0x73, 0x6e, 0x70, 0x25, 0x62, 0xfa, 0x72, 0xb0, 0xdb, 0x62, 0xb3, 0xf0, 0x66, 0x6f	/* Tsnp_probe_rmptable_info */
	.byte 0x11, 0x3f, 0xf6, 0x6e, 0xe2, 0x64, 0x75, 0x6d, 0xe2, 0x68, 0x76, 0x61, 0x5f, 0x72, 0xb0, 0xe8, 0xea, 0x79	/* T__pfx_snp_dump_hva_rmpentry */
	.byte 0x11, 0x54, 0x73, 0x6e, 0xe2, 0x64, 0x75, 0x6d, 0xe2, 0x68, 0x76, 0x61, 0x5f, 0x72, 0xb0, 0xe8, 0xea, 0x79	/* Tsnp_dump_hva_rmpentry */
	.byte 0x0d, 0xbf, 0x6b, 0x64, 0x75, 0xb0, 0xf6, 0xbc, 0x5f, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* T__pfx_kdump_sev_callback */
	.byte 0x0d, 0x54, 0x6b, 0x64, 0x75, 0xb0, 0xf6, 0xbc, 0x5f, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* Tkdump_sev_callback */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xdb, 0x73, 0xd8, 0xb4, 0x77, 0xdb, 0x16	/* T__pfx___traceiter_task_newtask */
	.byte 0x0b, 0x2f, 0x01, 0xe4, 0xcf, 0xdb, 0x73, 0xd8, 0xb4, 0x77, 0xdb, 0x16	/* T__traceiter_task_newtask */
	.byte 0x0e, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xdb, 0x73, 0xd8, 0xb4, 0x77, 0xdb, 0x16	/* T__pfx___probestub_task_newtask */
	.byte 0x0d, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xdb, 0x73, 0xd8, 0xb4, 0x77, 0xdb, 0x16	/* T__probestub_task_newtask */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xdb, 0x73, 0xd8, 0xf8, 0x6e, 0x61, 0xbd	/* T__pfx___traceiter_task_rename */
	.byte 0x0b, 0x2f, 0x01, 0xe4, 0xcf, 0xdb, 0x73, 0xd8, 0xf8, 0x6e, 0x61, 0xbd	/* T__traceiter_task_rename */
	.byte 0x0e, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xdb, 0x73, 0xd8, 0xf8, 0x6e, 0x61, 0xbd	/* T__pfx___probestub_task_rename */
	.byte 0x0d, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xdb, 0x73, 0xd8, 0xf8, 0x6e, 0x61, 0xbd	/* T__probestub_task_rename */
	.byte 0x07, 0xbf, 0xb2, 0xdb, 0x73, 0xd8, 0x6d, 0x6d	/* T__pfx_get_task_mm */
	.byte 0x07, 0x54, 0xb2, 0xdb, 0x73, 0xd8, 0x6d, 0x6d	/* Tget_task_mm */
	.byte 0x08, 0xc6, 0x89, 0xb3, 0x64, 0x75, 0x6d, 0x6d, 0x79	/* t__pfx_idle_dummy */
	.byte 0x08, 0xc2, 0x64, 0xb3, 0x64, 0x75, 0x6d, 0x6d, 0x79	/* tidle_dummy */
	.byte 0x0c, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0xdb, 0x73, 0xd8, 0xb4, 0x77, 0xdb, 0x16	/* t__pfx_perf_trace_task_newtask */
	.byte 0x0b, 0x06, 0xee, 0xa0, 0xc8, 0xdb, 0x73, 0xd8, 0xb4, 0x77, 0xdb, 0x16	/* tperf_trace_task_newtask */
	.byte 0x0c, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0xdb, 0x73, 0xd8, 0xb4, 0x77, 0xdb, 0x16	/* t__pfx_trace_event_raw_event_task_newtask */
	.byte 0x0c, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0xdb, 0x73, 0xd8, 0xb4, 0x77, 0xdb, 0x16	/* ttrace_event_raw_event_task_newtask */
	.byte 0x0e, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0xdb, 0x73, 0xd8, 0xf8, 0x6e, 0x61, 0xbd	/* t__pfx_trace_raw_output_task_rename */
	.byte 0x0e, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0xdb, 0x73, 0xd8, 0xf8, 0x6e, 0x61, 0xbd	/* ttrace_raw_output_task_rename */
	.byte 0x0e, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0xdb, 0x73, 0xd8, 0xb4, 0x77, 0xdb, 0x16	/* t__pfx_trace_raw_output_task_newtask */
	.byte 0x0e, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0xdb, 0x73, 0xd8, 0xb4, 0x77, 0xdb, 0x16	/* ttrace_raw_output_task_newtask */
	.byte 0x0c, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0xdb, 0x73, 0xd8, 0xf8, 0x6e, 0x61, 0xbd	/* t__pfx_perf_trace_task_rename */
	.byte 0x0b, 0x06, 0xee, 0xa0, 0xc8, 0xdb, 0x73, 0xd8, 0xf8, 0x6e, 0x61, 0xbd	/* tperf_trace_task_rename */
	.byte 0x0c, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0xdb, 0x73, 0xd8, 0xf8, 0x6e, 0x61, 0xbd	/* t__pfx_trace_event_raw_event_task_rename */
	.byte 0x0c, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0xdb, 0x73, 0xd8, 0xf8, 0x6e, 0x61, 0xbd	/* ttrace_event_raw_event_task_rename */
	.byte 0x0b, 0x29, 0x5f, 0x40, 0xc8, 0xdb, 0x73, 0xd8, 0xf8, 0x6e, 0x61, 0xbd	/* t__pfx___bpf_trace_task_rename */
	.byte 0x0b, 0x74, 0xff, 0x40, 0xc8, 0xdb, 0x73, 0xd8, 0xf8, 0x6e, 0x61, 0xbd	/* t__bpf_trace_task_rename */
	.byte 0x0b, 0x29, 0x5f, 0x40, 0xc8, 0xdb, 0x73, 0xd8, 0xb4, 0x77, 0xdb, 0x16	/* t__pfx___bpf_trace_task_newtask */
	.byte 0x0b, 0x74, 0xff, 0x40, 0xc8, 0xdb, 0x73, 0xd8, 0xb4, 0x77, 0xdb, 0x16	/* t__bpf_trace_task_newtask */
	.byte 0x08, 0xc6, 0x76, 0xdd, 0x5f, 0xc0, 0xd8, 0xe1, 0xc0	/* t__pfx_vma_lock_alloc */
	.byte 0x08, 0x74, 0x76, 0xdd, 0x5f, 0xc0, 0xd8, 0xe1, 0xc0	/* tvma_lock_alloc */
	.byte 0x0c, 0xc6, 0x87, 0xfa, 0x76, 0x6d, 0x2a, 0xeb, 0xd8, 0x63, 0xeb, 0x68, 0x65	/* t__pfx_free_vm_stack_cache */
	.byte 0x0c, 0x74, 0x87, 0xfa, 0x76, 0x6d, 0x2a, 0xeb, 0xd8, 0x63, 0xeb, 0x68, 0x65	/* tfree_vm_stack_cache */
	.byte 0x0c, 0xc6, 0x15, 0xf8, 0xc7, 0x2a, 0xeb, 0xd8, 0x87, 0xfa, 0x72, 0x63, 0x75	/* t__pfx_thread_stack_free_rcu */
	.byte 0x0c, 0x74, 0x15, 0xf8, 0xc7, 0x2a, 0xeb, 0xd8, 0x87, 0xfa, 0x72, 0x63, 0x75	/* tthread_stack_free_rcu */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0x73, 0x1f, 0xc2, 0xe5, 0x10, 0x3d, 0x73	/* T__pfx___ia32_sys_set_tid_address */
	.byte 0x0d, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0x73, 0x1f, 0xc2, 0xe5, 0x10, 0x3d, 0x73	/* T__ia32_sys_set_tid_address */
	.byte 0x0a, 0x29, 0xe7, 0x89, 0x66, 0x64, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* t__pfx___pidfd_prepare */
	.byte 0x0b, 0x74, 0xff, 0x70, 0x89, 0x66, 0x64, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* t__pidfd_prepare */
	.byte 0x08, 0xa8, 0xf6, 0x2c, 0x68, 0xcc, 0xe5, 0x7b, 0xce	/* t__pfx_sighand_ctor */
	.byte 0x08, 0x74, 0x73, 0x2c, 0x68, 0xcc, 0xe5, 0x7b, 0xce	/* tsighand_ctor */
	.byte 0x10, 0xc6, 0xfe, 0x70, 0xc5, 0x63, 0xdf, 0x6e, 0xfa, 0xca, 0x67, 0xe0, 0x66, 0xde, 0xcd, 0x5d, 0xee	/* t__pfx_copy_clone_args_from_user */
	.byte 0x10, 0x74, 0xfe, 0x70, 0xc5, 0x63, 0xdf, 0x6e, 0xfa, 0xca, 0x67, 0xe0, 0x66, 0xde, 0xcd, 0x5d, 0xee	/* tcopy_clone_args_from_user */
	.byte 0x0f, 0xc6, 0xd4, 0x73, 0x68, 0xca, 0xfa, 0x66, 0x64, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_unshare_fd.constprop.0 */
	.byte 0x0f, 0x74, 0xd4, 0x73, 0x68, 0xca, 0xfa, 0x66, 0x64, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tunshare_fd.constprop.0 */
	.byte 0x0c, 0xc6, 0xeb, 0xfe, 0xd4, 0xf9, 0x6b, 0xee, 0xb4, 0x6c, 0x2a, 0xeb, 0x6b	/* t__pfx_account_kernel_stack */
	.byte 0x0c, 0x74, 0xeb, 0xfe, 0xd4, 0xf9, 0x6b, 0xee, 0xb4, 0x6c, 0x2a, 0xeb, 0x6b	/* taccount_kernel_stack */
	.byte 0x0f, 0x29, 0x5f, 0xf8, 0x66, 0xfe, 0xd4, 0xf9, 0x10, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx___refcount_add.constprop.0 */
	.byte 0x0f, 0x74, 0xff, 0xf8, 0x66, 0xfe, 0xd4, 0xf9, 0x10, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__refcount_add.constprop.0 */
	.byte 0x07, 0xc6, 0x6d, 0xcd, 0xf8, 0xd3, 0x61, 0xc9	/* t__pfx_mm_release */
	.byte 0x07, 0x74, 0x6d, 0xcd, 0xf8, 0xd3, 0x61, 0xc9	/* tmm_release */
	.byte 0x0b, 0xc6, 0x87, 0xfa, 0x73, 0x2c, 0x6e, 0xe1, 0xf6, 0xea, 0x75, 0x7b	/* t__pfx_free_signal_struct */
	.byte 0x0b, 0x74, 0x87, 0xfa, 0x73, 0x2c, 0x6e, 0xe1, 0xf6, 0xea, 0x75, 0x7b	/* tfree_signal_struct */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0x73, 0x1f, 0xc2, 0xe5, 0x10, 0x3d, 0x73	/* T__pfx___x64_sys_set_tid_address */
	.byte 0x0c, 0x2f, 0x78, 0x36, 0x34, 0x95, 0x73, 0x1f, 0xc2, 0xe5, 0x10, 0x3d, 0x73	/* T__x64_sys_set_tid_address */
	.byte 0x09, 0xbf, 0x6d, 0x6d, 0xbe, 0xf9, 0x61, 0xc1, 0x6e, 0x63	/* T__pfx_mmput_async */
	.byte 0x09, 0x54, 0x6d, 0x6d, 0xbe, 0xf9, 0x61, 0xc1, 0x6e, 0x63	/* Tmmput_async */
	.byte 0x0f, 0xc6, 0xbd, 0x6d, 0x63, 0xa6, 0xd0, 0xca, 0x21, 0x6b, 0xee, 0xb4, 0x6c, 0x2a, 0xeb, 0x6b	/* t__pfx_memcg_charge_kernel_stack */
	.byte 0x0f, 0x74, 0xbd, 0x6d, 0x63, 0xa6, 0xd0, 0xca, 0x21, 0x6b, 0xee, 0xb4, 0x6c, 0x2a, 0xeb, 0x6b	/* tmemcg_charge_kernel_stack */
	.byte 0x08, 0x3f, 0xff, 0x5f, 0x6d, 0x6d, 0x64, 0xde, 0x70	/* T__pfx___mmdrop */
	.byte 0x06, 0x2f, 0x6d, 0x6d, 0x64, 0xde, 0x70	/* T__mmdrop */
	.byte 0x0c, 0xc6, 0x6d, 0x6d, 0x64, 0xde, 0xe2, 0x61, 0xc1, 0x6e, 0xd5, 0x66, 0x6e	/* t__pfx_mmdrop_async_fn */
	.byte 0x0c, 0x74, 0x6d, 0x6d, 0x64, 0xde, 0xe2, 0x61, 0xc1, 0x6e, 0xd5, 0x66, 0x6e	/* tmmdrop_async_fn */
	.byte 0x04, 0xc6, 0x6d, 0xcd, 0x8d	/* t__pfx_mm_init */
	.byte 0x04, 0x74, 0x6d, 0xcd, 0x8d	/* tmm_init */
	.byte 0x08, 0xbf, 0x6e, 0x72, 0x25, 0x63, 0x3b, 0xc9, 0x73	/* T__pfx_nr_processes */
	.byte 0x08, 0x54, 0x6e, 0x72, 0x25, 0x63, 0x3b, 0xc9, 0x73	/* Tnr_processes */
	.byte 0x05, 0xbf, 0x87, 0xfa, 0xdb, 0x16	/* T__pfx_free_task */
	.byte 0x05, 0x54, 0x87, 0xfa, 0xdb, 0x16	/* Tfree_task */
	.byte 0x0b, 0x29, 0x5f, 0xe6, 0x1b, 0x79, 0x65, 0xe5, 0x87, 0xfa, 0xdb, 0x16	/* t__pfx___delayed_free_task */
	.byte 0x0b, 0x74, 0xff, 0xe6, 0x1b, 0x79, 0x65, 0xe5, 0x87, 0xfa, 0xdb, 0x16	/* t__delayed_free_task */
	.byte 0x0b, 0x3f, 0xff, 0xe7, 0x75, 0xf9, 0xdb, 0x16, 0xf6, 0xea, 0x75, 0x7b	/* T__pfx___put_task_struct */
	.byte 0x09, 0x2f, 0xbe, 0xf9, 0xdb, 0x16, 0xf6, 0xea, 0x75, 0x7b	/* T__put_task_struct */
	.byte 0x11, 0x3f, 0xff, 0xe7, 0x75, 0xf9, 0xdb, 0x16, 0xf6, 0xea, 0x75, 0x63, 0xf9, 0x72, 0x63, 0x00, 0x63, 0x62	/* T__pfx___put_task_struct_rcu_cb */
	.byte 0x0f, 0x2f, 0xbe, 0xf9, 0xdb, 0x16, 0xf6, 0xea, 0x75, 0x63, 0xf9, 0x72, 0x63, 0x00, 0x63, 0x62	/* T__put_task_struct_rcu_cb */
	.byte 0x09, 0xbf, 0x76, 0xcd, 0x61, 0xf8, 0x61, 0x5f, 0xe1, 0xc0	/* T__pfx_vm_area_alloc */
	.byte 0x09, 0x54, 0x76, 0xcd, 0x61, 0xf8, 0x61, 0x5f, 0xe1, 0xc0	/* Tvm_area_alloc */
	.byte 0x09, 0xbf, 0x76, 0xcd, 0x61, 0xf8, 0x61, 0x5f, 0x64, 0xb9	/* T__pfx_vm_area_dup */
	.byte 0x09, 0x54, 0x76, 0xcd, 0x61, 0xf8, 0x61, 0x5f, 0x64, 0xb9	/* Tvm_area_dup */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x76, 0xcd, 0x61, 0xf8, 0x61, 0x5f, 0x87, 0x65	/* T__pfx___vm_area_free */
	.byte 0x09, 0x2f, 0x76, 0xcd, 0x61, 0xf8, 0x61, 0x5f, 0x87, 0x65	/* T__vm_area_free */
	.byte 0x0e, 0xc6, 0x76, 0xcd, 0x61, 0xf8, 0x61, 0x5f, 0x87, 0xfa, 0x72, 0x63, 0x00, 0x63, 0x62	/* t__pfx_vm_area_free_rcu_cb */
	.byte 0x0e, 0x74, 0x76, 0xcd, 0x61, 0xf8, 0x61, 0x5f, 0x87, 0xfa, 0x72, 0x63, 0x00, 0x63, 0x62	/* tvm_area_free_rcu_cb */
	.byte 0x09, 0xbf, 0x76, 0xcd, 0x61, 0xf8, 0x61, 0x5f, 0x87, 0x65	/* T__pfx_vm_area_free */
	.byte 0x09, 0x54, 0x76, 0xcd, 0x61, 0xf8, 0x61, 0x5f, 0x87, 0x65	/* Tvm_area_free */
	.byte 0x0c, 0xbf, 0xd1, 0x99, 0xdb, 0x16, 0x2a, 0xeb, 0xd8, 0xeb, 0xfe, 0xd4, 0x74	/* T__pfx_exit_task_stack_account */
	.byte 0x0c, 0x54, 0xd1, 0x99, 0xdb, 0x16, 0x2a, 0xeb, 0xd8, 0xeb, 0xfe, 0xd4, 0x74	/* Texit_task_stack_account */
	.byte 0x09, 0x3f, 0xe7, 0x75, 0xf9, 0xdb, 0x16, 0x2a, 0xeb, 0x6b	/* T__pfx_put_task_stack */
	.byte 0x08, 0x54, 0xbe, 0xf9, 0xdb, 0x16, 0x2a, 0xeb, 0x6b	/* Tput_task_stack */
	.byte 0x0c, 0x3f, 0x1f, 0xdb, 0x16, 0x2a, 0xeb, 0xd8, 0xe8, 0xe5, 0xdd, 0x67, 0xa3	/* T__pfx_set_task_stack_end_magic */
	.byte 0x0d, 0x54, 0xc9, 0xf9, 0xdb, 0x16, 0x2a, 0xeb, 0xd8, 0xe8, 0xe5, 0xdd, 0x67, 0xa3	/* Tset_task_stack_end_magic */
	.byte 0x05, 0xbf, 0x6d, 0xcd, 0xe1, 0xc0	/* T__pfx_mm_alloc */
	.byte 0x05, 0x54, 0x6d, 0xcd, 0xe1, 0xc0	/* Tmm_alloc */
	.byte 0x08, 0x3f, 0x1f, 0x6d, 0xcd, 0xd1, 0xfa, 0xb8, 0xd3	/* T__pfx_set_mm_exe_file */
	.byte 0x09, 0x54, 0xc9, 0xf9, 0x6d, 0xcd, 0xd1, 0xfa, 0xb8, 0xd3	/* Tset_mm_exe_file */
	.byte 0x06, 0x29, 0x5f, 0x6d, 0x6d, 0xbe, 0x74	/* t__pfx___mmput */
	.byte 0x06, 0x74, 0xff, 0x6d, 0x6d, 0xbe, 0x74	/* t__mmput */
	.byte 0x0b, 0xc6, 0x6d, 0x6d, 0xbe, 0xf9, 0x61, 0xc1, 0x6e, 0xd5, 0x66, 0x6e	/* t__pfx_mmput_async_fn */
	.byte 0x0b, 0x74, 0x6d, 0x6d, 0xbe, 0xf9, 0x61, 0xc1, 0x6e, 0xd5, 0x66, 0x6e	/* tmmput_async_fn */
	.byte 0x05, 0xbf, 0x6d, 0x6d, 0xbe, 0x74	/* T__pfx_mmput */
	.byte 0x05, 0x54, 0x6d, 0x6d, 0xbe, 0x74	/* Tmmput */
	.byte 0x0c, 0xc6, 0x64, 0x3a, 0x6d, 0x6d, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_dup_mm.constprop.0 */
	.byte 0x0c, 0x74, 0x64, 0x3a, 0x6d, 0x6d, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tdup_mm.constprop.0 */
	.byte 0x0c, 0xbf, 0xf8, 0x70, 0x6c, 0xeb, 0xfa, 0x6d, 0xcd, 0xd1, 0xfa, 0xb8, 0xd3	/* T__pfx_replace_mm_exe_file */
	.byte 0x0c, 0x54, 0xf8, 0x70, 0x6c, 0xeb, 0xfa, 0x6d, 0xcd, 0xd1, 0xfa, 0xb8, 0xd3	/* Treplace_mm_exe_file */
	.byte 0x08, 0xbf, 0xb2, 0x6d, 0xcd, 0xd1, 0xfa, 0xb8, 0xd3	/* T__pfx_get_mm_exe_file */
	.byte 0x08, 0x54, 0xb2, 0x6d, 0xcd, 0xd1, 0xfa, 0xb8, 0xd3	/* Tget_mm_exe_file */
	.byte 0x09, 0xbf, 0xb2, 0xdb, 0x73, 0xd8, 0xd1, 0xfa, 0xb8, 0xd3	/* T__pfx_get_task_exe_file */
	.byte 0x09, 0x54, 0xb2, 0xdb, 0x73, 0xd8, 0xd1, 0xfa, 0xb8, 0xd3	/* Tget_task_exe_file */
	.byte 0x07, 0xbf, 0x6d, 0xcd, 0xeb, 0x63, 0x3b, 0x73	/* T__pfx_mm_access */
	.byte 0x07, 0x54, 0x6d, 0xcd, 0xeb, 0x63, 0x3b, 0x73	/* Tmm_access */
	.byte 0x09, 0xbf, 0xd1, 0x99, 0x6d, 0xcd, 0xf8, 0xd3, 0x61, 0xc9	/* T__pfx_exit_mm_release */
	.byte 0x09, 0x54, 0xd1, 0x99, 0x6d, 0xcd, 0xf8, 0xd3, 0x61, 0xc9	/* Texit_mm_release */
	.byte 0x0a, 0xbf, 0xd1, 0x65, 0xd5, 0x6d, 0xcd, 0xf8, 0xd3, 0x61, 0xc9	/* T__pfx_exec_mm_release */
	.byte 0x0a, 0x54, 0xd1, 0x65, 0xd5, 0x6d, 0xcd, 0xf8, 0xd3, 0x61, 0xc9	/* Texec_mm_release */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x63, 0xd3, 0xcc, 0xb9, 0xf6, 0x2c, 0x68, 0xcc, 0x64	/* T__pfx___cleanup_sighand */
	.byte 0x0a, 0x2f, 0x63, 0xd3, 0xcc, 0xb9, 0xf6, 0x2c, 0x68, 0xcc, 0x64	/* T__cleanup_sighand */
	.byte 0x0a, 0x3f, 0xe7, 0x89, 0x66, 0x64, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* T__pfx_pidfd_prepare */
	.byte 0x0a, 0x54, 0x70, 0x89, 0x66, 0x64, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* Tpidfd_prepare */
	.byte 0x08, 0xbf, 0xfe, 0x70, 0x79, 0x25, 0x63, 0x3b, 0x73	/* T__pfx_copy_process */
	.byte 0x08, 0x54, 0xfe, 0x70, 0x79, 0x25, 0x63, 0x3b, 0x73	/* Tcopy_process */
	.byte 0x08, 0xbf, 0x63, 0xf8, 0xa1, 0x3e, 0x15, 0xf8, 0xc7	/* T__pfx_create_io_thread */
	.byte 0x08, 0x54, 0x63, 0xf8, 0xa1, 0x3e, 0x15, 0xf8, 0xc7	/* Tcreate_io_thread */
	.byte 0x08, 0xbf, 0x6b, 0xee, 0xb4, 0xc3, 0x63, 0xdf, 0xb4	/* T__pfx_kernel_clone */
	.byte 0x08, 0x54, 0x6b, 0xee, 0xb4, 0xc3, 0x63, 0xdf, 0xb4	/* Tkernel_clone */
	.byte 0x09, 0x29, 0x5f, 0xa9, 0x95, 0xe0, 0x63, 0xdf, 0xb4, 0x33	/* t__pfx___do_sys_clone3 */
	.byte 0x09, 0x74, 0xff, 0xa9, 0x95, 0xe0, 0x63, 0xdf, 0xb4, 0x33	/* t__do_sys_clone3 */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x63, 0xdf, 0xb4, 0x33	/* T__pfx___ia32_sys_clone3 */
	.byte 0x0b, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x63, 0xdf, 0xb4, 0x33	/* T__ia32_sys_clone3 */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x63, 0xdf, 0xb4, 0x33	/* T__pfx___x64_sys_clone3 */
	.byte 0x0a, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x63, 0xdf, 0xb4, 0x33	/* T__x64_sys_clone3 */
	.byte 0x08, 0x29, 0x5f, 0xa9, 0x95, 0xe0, 0x63, 0xdf, 0xb4	/* t__pfx___do_sys_clone */
	.byte 0x08, 0x74, 0xff, 0xa9, 0x95, 0xe0, 0x63, 0xdf, 0xb4	/* t__do_sys_clone */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x63, 0xdf, 0xb4	/* T__pfx___ia32_sys_clone */
	.byte 0x0a, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x63, 0xdf, 0xb4	/* T__ia32_sys_clone */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x63, 0xdf, 0xb4	/* T__pfx___x64_sys_clone */
	.byte 0x09, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x63, 0xdf, 0xb4	/* T__x64_sys_clone */
	.byte 0x09, 0x29, 0x5f, 0xa9, 0x95, 0xe0, 0x76, 0x66, 0xce, 0x6b	/* t__pfx___do_sys_vfork */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x76, 0x66, 0xce, 0x6b	/* T__pfx___ia32_sys_vfork */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x76, 0x66, 0xce, 0x6b	/* T__pfx___x64_sys_vfork */
	.byte 0x09, 0x74, 0xff, 0xa9, 0x95, 0xe0, 0x76, 0x66, 0xce, 0x6b	/* t__do_sys_vfork */
	.byte 0x0b, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x76, 0x66, 0xce, 0x6b	/* T__ia32_sys_vfork */
	.byte 0x0a, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x76, 0x66, 0xce, 0x6b	/* T__x64_sys_vfork */
	.byte 0x08, 0x29, 0x5f, 0xa9, 0x95, 0xe0, 0x66, 0xce, 0x6b	/* t__pfx___do_sys_fork */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x66, 0xce, 0x6b	/* T__pfx___ia32_sys_fork */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x66, 0xce, 0x6b	/* T__pfx___x64_sys_fork */
	.byte 0x08, 0x74, 0xff, 0xa9, 0x95, 0xe0, 0x66, 0xce, 0x6b	/* t__do_sys_fork */
	.byte 0x0a, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x66, 0xce, 0x6b	/* T__ia32_sys_fork */
	.byte 0x09, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x66, 0xce, 0x6b	/* T__x64_sys_fork */
	.byte 0x08, 0xbf, 0x6b, 0xee, 0xb4, 0xc3, 0x15, 0xf8, 0xc7	/* T__pfx_kernel_thread */
	.byte 0x08, 0x54, 0x6b, 0xee, 0xb4, 0xc3, 0x15, 0xf8, 0xc7	/* Tkernel_thread */
	.byte 0x09, 0xbf, 0x5d, 0xcf, 0xa5, 0x64, 0xfa, 0x15, 0xf8, 0xc7	/* T__pfx_user_mode_thread */
	.byte 0x09, 0x54, 0x5d, 0xcf, 0xa5, 0x64, 0xfa, 0x15, 0xf8, 0xc7	/* Tuser_mode_thread */
	.byte 0x0b, 0xbf, 0x77, 0xe1, 0x6b, 0x25, 0x63, 0x3b, 0xe0, 0x74, 0xf8, 0x65	/* T__pfx_walk_process_tree */
	.byte 0x0b, 0x54, 0x77, 0xe1, 0x6b, 0x25, 0x63, 0x3b, 0xe0, 0x74, 0xf8, 0x65	/* Twalk_process_tree */
	.byte 0x09, 0xbf, 0x6b, 0xc1, 0xe0, 0xd4, 0x73, 0x68, 0x61, 0xf8	/* T__pfx_ksys_unshare */
	.byte 0x09, 0x54, 0x6b, 0xc1, 0xe0, 0xd4, 0x73, 0x68, 0x61, 0xf8	/* Tksys_unshare */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xd4, 0x73, 0x68, 0x61, 0xf8	/* T__pfx___ia32_sys_unshare */
	.byte 0x0c, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xd4, 0x73, 0x68, 0x61, 0xf8	/* T__ia32_sys_unshare */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xd4, 0x73, 0x68, 0x61, 0xf8	/* T__pfx___x64_sys_unshare */
	.byte 0x0b, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xd4, 0x73, 0x68, 0x61, 0xf8	/* T__x64_sys_unshare */
	.byte 0x09, 0xbf, 0xd4, 0x73, 0x68, 0xca, 0xfa, 0xb8, 0xd3, 0x73	/* T__pfx_unshare_files */
	.byte 0x09, 0x54, 0xd4, 0x73, 0x68, 0xca, 0xfa, 0xb8, 0xd3, 0x73	/* Tunshare_files */
	.byte 0x0b, 0x3f, 0x95, 0x73, 0x7b, 0xc3, 0xdd, 0x1a, 0x15, 0xf8, 0xc7, 0x73	/* T__pfx_sysctl_max_threads */
	.byte 0x0b, 0x54, 0xc1, 0x73, 0x7b, 0xc3, 0xdd, 0x1a, 0x15, 0xf8, 0xc7, 0x73	/* Tsysctl_max_threads */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0x73, 0xe7, 0xee, 0x73, 0x6f, 0x6e, 0xe1, 0xe4, 0x79	/* T__pfx___x64_sys_personality */
	.byte 0x0e, 0x2f, 0x78, 0x36, 0x34, 0x95, 0x73, 0xe7, 0xee, 0x73, 0x6f, 0x6e, 0xe1, 0xe4, 0x79	/* T__x64_sys_personality */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0x73, 0xe7, 0xee, 0x73, 0x6f, 0x6e, 0xe1, 0xe4, 0x79	/* T__pfx___ia32_sys_personality */
	.byte 0x0f, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0x73, 0xe7, 0xee, 0x73, 0x6f, 0x6e, 0xe1, 0xe4, 0x79	/* T__ia32_sys_personality */
	.byte 0x0c, 0xc6, 0xd1, 0x65, 0x63, 0xa9, 0xdd, 0xf0, 0x73, 0x25, 0x63, 0xf6, 0x26	/* t__pfx_execdomains_proc_show */
	.byte 0x0c, 0x74, 0xd1, 0x65, 0x63, 0xa9, 0xdd, 0xf0, 0x73, 0x25, 0x63, 0xf6, 0x26	/* texecdomains_proc_show */
	.byte 0x06, 0xc6, 0xb6, 0x5f, 0x62, 0x88, 0x6b	/* t__pfx_no_blink */
	.byte 0x06, 0x74, 0xb6, 0x5f, 0x62, 0x88, 0x6b	/* tno_blink */
	.byte 0x09, 0xc6, 0x77, 0xca, 0x7c, 0xfe, 0xd4, 0xf9, 0x73, 0x26	/* t__pfx_warn_count_show */
	.byte 0x09, 0x74, 0x77, 0xca, 0x7c, 0xfe, 0xd4, 0xf9, 0x73, 0x26	/* twarn_count_show */
	.byte 0x07, 0xbf, 0x9a, 0x73, 0xf9, 0xdb, 0xf0, 0x74	/* T__pfx_test_taint */
	.byte 0x07, 0x54, 0x9a, 0x73, 0xf9, 0xdb, 0xf0, 0x74	/* Ttest_taint */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x77, 0xca, 0x6e, 0xe7, 0x72, 0xf0, 0x74, 0x6b	/* T__pfx___warn_printk */
	.byte 0x09, 0x2f, 0x77, 0xca, 0x6e, 0xe7, 0x72, 0xf0, 0x74, 0x6b	/* T__warn_printk */
	.byte 0x11, 0xc6, 0x63, 0xd3, 0xca, 0x5f, 0x77, 0xca, 0x7c, 0x6f, 0x6e, 0x63, 0xfa, 0x66, 0x81, 0xe0, 0x81, 0xe8	/* t__pfx_clear_warn_once_fops_open */
	.byte 0x10, 0x2d, 0xd3, 0xca, 0x5f, 0x77, 0xca, 0x7c, 0x6f, 0x6e, 0x63, 0xfa, 0x66, 0x81, 0xe0, 0x81, 0xe8	/* tclear_warn_once_fops_open */
	.byte 0x0e, 0xc6, 0x63, 0xd3, 0xca, 0x5f, 0x77, 0xca, 0x7c, 0x6f, 0x6e, 0x63, 0xfa, 0xc9, 0x74	/* t__pfx_clear_warn_once_set */
	.byte 0x0d, 0x2d, 0xd3, 0xca, 0x5f, 0x77, 0xca, 0x7c, 0x6f, 0x6e, 0x63, 0xfa, 0xc9, 0x74	/* tclear_warn_once_set */
	.byte 0x09, 0x29, 0x70, 0x72, 0xf0, 0xf9, 0xdb, 0xf0, 0x9a, 0x64	/* t__pfx__print_tainted */
	.byte 0x09, 0xf9, 0x70, 0x72, 0xf0, 0xf9, 0xdb, 0xf0, 0x9a, 0x64	/* t_print_tainted */
	.byte 0x0a, 0xc6, 0xa9, 0x5f, 0x6f, 0x81, 0xe0, 0x1e, 0xcf, 0xd1, 0xe4	/* t__pfx_do_oops_enter_exit */
	.byte 0x0a, 0x74, 0xa9, 0x5f, 0x6f, 0x81, 0xe0, 0x1e, 0xcf, 0xd1, 0xe4	/* tdo_oops_enter_exit */
	.byte 0x0d, 0x57, 0xec, 0xe7, 0xcc, 0xa3, 0xf6, 0xb0, 0xba, 0x6c, 0x66, 0xf6, 0xac, 0x70	/* W__pfx_panic_smp_self_stop */
	.byte 0x0c, 0x57, 0x70, 0xcc, 0xa3, 0xf6, 0xb0, 0xba, 0x6c, 0x66, 0xf6, 0xac, 0x70	/* Wpanic_smp_self_stop */
	.byte 0x06, 0xbf, 0xc7, 0xe5, 0xdb, 0xf0, 0x74	/* T__pfx_add_taint */
	.byte 0x06, 0x54, 0xc7, 0xe5, 0xdb, 0xf0, 0x74	/* Tadd_taint */
	.byte 0x07, 0xbf, 0x6e, 0x6d, 0x69, 0xe7, 0xcc, 0xa3	/* T__pfx_nmi_panic */
	.byte 0x07, 0x54, 0x6e, 0x6d, 0x69, 0xe7, 0xcc, 0xa3	/* Tnmi_panic */
	.byte 0x0d, 0xbf, 0x7e, 0x63, 0x6b, 0xe7, 0xcc, 0x69, 0xd5, 0x6f, 0x7c, 0x77, 0xca, 0x6e	/* T__pfx_check_panic_on_warn */
	.byte 0x0d, 0x54, 0x7e, 0x63, 0x6b, 0xe7, 0xcc, 0x69, 0xd5, 0x6f, 0x7c, 0x77, 0xca, 0x6e	/* Tcheck_panic_on_warn */
	.byte 0x09, 0x3f, 0xe7, 0x72, 0xf0, 0xf9, 0xdb, 0xf0, 0x9a, 0x64	/* T__pfx_print_tainted */
	.byte 0x09, 0x54, 0x70, 0x72, 0xf0, 0xf9, 0xdb, 0xf0, 0x9a, 0x64	/* Tprint_tainted */
	.byte 0x0e, 0x3f, 0xe7, 0x72, 0xf0, 0xf9, 0xdb, 0xf0, 0x9a, 0xe5, 0x76, 0xee, 0x62, 0x6f, 0xc9	/* T__pfx_print_tainted_verbose */
	.byte 0x0e, 0x54, 0x70, 0x72, 0xf0, 0xf9, 0xdb, 0xf0, 0x9a, 0xe5, 0x76, 0xee, 0x62, 0x6f, 0xc9	/* Tprint_tainted_verbose */
	.byte 0x05, 0xbf, 0xb2, 0xdb, 0xf0, 0x74	/* T__pfx_get_taint */
	.byte 0x05, 0x54, 0xb2, 0xdb, 0xf0, 0x74	/* Tget_taint */
	.byte 0x0a, 0xbf, 0x6f, 0x81, 0xe0, 0xdd, 0x79, 0xe7, 0x72, 0xf0, 0x74	/* T__pfx_oops_may_print */
	.byte 0x0a, 0x54, 0x6f, 0x81, 0xe0, 0xdd, 0x79, 0xe7, 0x72, 0xf0, 0x74	/* Toops_may_print */
	.byte 0x06, 0xbf, 0x6f, 0x81, 0xe0, 0x1e, 0xee	/* T__pfx_oops_enter */
	.byte 0x06, 0x54, 0x6f, 0x81, 0xe0, 0x1e, 0xee	/* Toops_enter */
	.byte 0x06, 0xbf, 0x6f, 0x81, 0xe0, 0xd1, 0xe4	/* T__pfx_oops_exit */
	.byte 0x06, 0x54, 0x6f, 0x81, 0xe0, 0xd1, 0xe4	/* Toops_exit */
	.byte 0x06, 0x3f, 0xff, 0x5f, 0x77, 0xca, 0x6e	/* T__pfx___warn */
	.byte 0x04, 0x2f, 0x77, 0xca, 0x6e	/* T__warn */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* T__pfx___traceiter_cpuhp_enter */
	.byte 0x09, 0x2f, 0x01, 0xe4, 0xcf, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* T__traceiter_cpuhp_enter */
	.byte 0x0c, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* T__pfx___probestub_cpuhp_enter */
	.byte 0x0b, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* T__probestub_cpuhp_enter */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* T__pfx___traceiter_cpuhp_multi_enter */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xcf, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* T__traceiter_cpuhp_multi_enter */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* T__pfx___probestub_cpuhp_multi_enter */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* T__probestub_cpuhp_multi_enter */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* T__pfx___traceiter_cpuhp_exit */
	.byte 0x09, 0x2f, 0x01, 0xe4, 0xcf, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* T__traceiter_cpuhp_exit */
	.byte 0x0c, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* T__pfx___probestub_cpuhp_exit */
	.byte 0x0b, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* T__probestub_cpuhp_exit */
	.byte 0x0c, 0xbf, 0x92, 0xf6, 0x6d, 0xf9, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0xd3	/* T__pfx_cpu_smt_possible */
	.byte 0x0c, 0x54, 0x92, 0xf6, 0x6d, 0xf9, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0xd3	/* Tcpu_smt_possible */
	.byte 0x09, 0xc6, 0x92, 0x68, 0xe2, 0x6e, 0xd1, 0xf9, 0xd6, 0x86	/* t__pfx_cpuhp_next_state */
	.byte 0x09, 0x74, 0x92, 0x68, 0xe2, 0x6e, 0xd1, 0xf9, 0xd6, 0x86	/* tcpuhp_next_state */
	.byte 0x0a, 0xc6, 0x92, 0x68, 0x70, 0xf6, 0xad, 0x0b, 0xe5, 0x72, 0xd4	/* t__pfx_cpuhp_should_run */
	.byte 0x0a, 0x74, 0x92, 0x68, 0x70, 0xf6, 0xad, 0x0b, 0xe5, 0x72, 0xd4	/* tcpuhp_should_run */
	.byte 0x0d, 0xbf, 0x92, 0x5f, 0x6d, 0xe4, 0x2c, 0xe9, 0xd9, 0x6e, 0xe0, 0x6f, 0x66, 0x66	/* T__pfx_cpu_mitigations_off */
	.byte 0x0d, 0x54, 0x92, 0x5f, 0x6d, 0xe4, 0x2c, 0xe9, 0xd9, 0x6e, 0xe0, 0x6f, 0x66, 0x66	/* Tcpu_mitigations_off */
	.byte 0x12, 0xbf, 0x92, 0x5f, 0x6d, 0xe4, 0x2c, 0xe9, 0xd9, 0x6e, 0xe0, 0x61, 0x75, 0xac, 0x5f, 0xb6, 0x73, 0x6d, 0x74	/* T__pfx_cpu_mitigations_auto_nosmt */
	.byte 0x12, 0x54, 0x92, 0x5f, 0x6d, 0xe4, 0x2c, 0xe9, 0xd9, 0x6e, 0xe0, 0x61, 0x75, 0xac, 0x5f, 0xb6, 0x73, 0x6d, 0x74	/* Tcpu_mitigations_auto_nosmt */
	.byte 0x0a, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* t__pfx_perf_trace_cpuhp_exit */
	.byte 0x09, 0x06, 0xee, 0xa0, 0xc8, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* tperf_trace_cpuhp_exit */
	.byte 0x0e, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* t__pfx_perf_trace_cpuhp_multi_enter */
	.byte 0x0d, 0x06, 0xee, 0xa0, 0xc8, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* tperf_trace_cpuhp_multi_enter */
	.byte 0x0a, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* t__pfx_perf_trace_cpuhp_enter */
	.byte 0x09, 0x06, 0xee, 0xa0, 0xc8, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* tperf_trace_cpuhp_enter */
	.byte 0x07, 0xc6, 0xc8, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* t__pfx_trace_cpuhp_exit */
	.byte 0x07, 0x74, 0xc8, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* ttrace_cpuhp_exit */
	.byte 0x0b, 0xc6, 0xc8, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* t__pfx_trace_cpuhp_multi_enter */
	.byte 0x0b, 0x74, 0xc8, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* ttrace_cpuhp_multi_enter */
	.byte 0x07, 0xc6, 0xc8, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* t__pfx_trace_cpuhp_enter */
	.byte 0x07, 0x74, 0xc8, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* ttrace_cpuhp_enter */
	.byte 0x0e, 0xc6, 0x92, 0x68, 0xe2, 0xf0, 0x76, 0x6f, 0x6b, 0xfa, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_cpuhp_invoke_callback */
	.byte 0x0e, 0x74, 0x92, 0x68, 0xe2, 0xf0, 0x76, 0x6f, 0x6b, 0xfa, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tcpuhp_invoke_callback */
	.byte 0x0a, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* t__pfx_trace_event_raw_event_cpuhp_exit */
	.byte 0x0a, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* ttrace_event_raw_event_cpuhp_exit */
	.byte 0x0a, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* t__pfx_trace_event_raw_event_cpuhp_enter */
	.byte 0x0a, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* ttrace_event_raw_event_cpuhp_enter */
	.byte 0x0c, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* t__pfx_trace_raw_output_cpuhp_exit */
	.byte 0x0c, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* ttrace_raw_output_cpuhp_exit */
	.byte 0x10, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* t__pfx_trace_raw_output_cpuhp_multi_enter */
	.byte 0x10, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* ttrace_raw_output_cpuhp_multi_enter */
	.byte 0x0c, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* t__pfx_trace_raw_output_cpuhp_enter */
	.byte 0x0c, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* ttrace_raw_output_cpuhp_enter */
	.byte 0x09, 0x29, 0x5f, 0x40, 0xc8, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* t__pfx___bpf_trace_cpuhp_exit */
	.byte 0x09, 0x74, 0xff, 0x40, 0xc8, 0x92, 0x68, 0xe2, 0xd1, 0xe4	/* t__bpf_trace_cpuhp_exit */
	.byte 0x09, 0x29, 0x5f, 0x40, 0xc8, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* t__pfx___bpf_trace_cpuhp_enter */
	.byte 0x09, 0x74, 0xff, 0x40, 0xc8, 0x92, 0x68, 0xe2, 0x1e, 0xee	/* t__bpf_trace_cpuhp_enter */
	.byte 0x0d, 0x29, 0x5f, 0x40, 0xc8, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* t__pfx___bpf_trace_cpuhp_multi_enter */
	.byte 0x0d, 0x74, 0xff, 0x40, 0xc8, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* t__bpf_trace_cpuhp_multi_enter */
	.byte 0x12, 0x29, 0x5f, 0x92, 0x68, 0xe2, 0xf0, 0x76, 0x6f, 0x6b, 0xfa, 0x28, 0x6c, 0x62, 0xeb, 0xd8, 0x72, 0xcc, 0xda	/* t__pfx___cpuhp_invoke_callback_range */
	.byte 0x12, 0x74, 0xff, 0x92, 0x68, 0xe2, 0xf0, 0x76, 0x6f, 0x6b, 0xfa, 0x28, 0x6c, 0x62, 0xeb, 0xd8, 0x72, 0xcc, 0xda	/* t__cpuhp_invoke_callback_range */
	.byte 0x09, 0xc6, 0xdb, 0x6b, 0xfa, 0x92, 0x5f, 0xa9, 0x77, 0x6e	/* t__pfx_take_cpu_down */
	.byte 0x09, 0x74, 0xdb, 0x6b, 0xfa, 0x92, 0x5f, 0xa9, 0x77, 0x6e	/* ttake_cpu_down */
	.byte 0x06, 0xc6, 0x66, 0xf0, 0xab, 0x5b, 0x92	/* t__pfx_finish_cpu */
	.byte 0x06, 0x74, 0x66, 0xf0, 0xab, 0x5b, 0x92	/* tfinish_cpu */
	.byte 0x0a, 0x29, 0x5f, 0x92, 0x68, 0xe2, 0x6b, 0xa3, 0xd8, 0x61, 0x70	/* t__pfx___cpuhp_kick_ap */
	.byte 0x0a, 0x74, 0xff, 0x92, 0x68, 0xe2, 0x6b, 0xa3, 0xd8, 0x61, 0x70	/* t__cpuhp_kick_ap */
	.byte 0x09, 0xc6, 0x92, 0x68, 0xe2, 0xab, 0xb7, 0xfa, 0x28, 0x6c	/* t__pfx_cpuhp_issue_call */
	.byte 0x09, 0x74, 0x92, 0x68, 0xe2, 0xab, 0xb7, 0xfa, 0x28, 0x6c	/* tcpuhp_issue_call */
	.byte 0x0d, 0xc6, 0x92, 0x68, 0xe2, 0x6b, 0xa3, 0xd8, 0x61, 0xe2, 0xe1, 0x69, 0x76, 0x65	/* t__pfx_cpuhp_kick_ap_alive */
	.byte 0x0d, 0x74, 0x92, 0x68, 0xe2, 0x6b, 0xa3, 0xd8, 0x61, 0xe2, 0xe1, 0x69, 0x76, 0x65	/* tcpuhp_kick_ap_alive */
	.byte 0x0c, 0x29, 0x5f, 0x92, 0x5f, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0xe8, 0x80, 0xd3	/* t__pfx___cpu_hotplug_enable */
	.byte 0x0c, 0x74, 0xff, 0x92, 0x5f, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0xe8, 0x80, 0xd3	/* t__cpu_hotplug_enable */
	.byte 0x0c, 0xc6, 0x92, 0x68, 0xe2, 0x09, 0xd3, 0x74, 0xfa, 0x89, 0xb3, 0xe6, 0xc7	/* t__pfx_cpuhp_complete_idle_dead */
	.byte 0x0c, 0x74, 0x92, 0x68, 0xe2, 0x09, 0xd3, 0x74, 0xfa, 0x89, 0xb3, 0xe6, 0xc7	/* tcpuhp_complete_idle_dead */
	.byte 0x08, 0xc6, 0x92, 0x68, 0xe2, 0x15, 0xf8, 0x05, 0x2b	/* t__pfx_cpuhp_thread_fun */
	.byte 0x08, 0x74, 0x92, 0x68, 0xe2, 0x15, 0xf8, 0x05, 0x2b	/* tcpuhp_thread_fun */
	.byte 0x0e, 0xc6, 0x92, 0x68, 0xe2, 0xde, 0x6c, 0x6c, 0x62, 0xeb, 0xd8, 0xf0, 0xd6, 0xe1, 0x6c	/* t__pfx_cpuhp_rollback_install */
	.byte 0x0e, 0x74, 0x92, 0x68, 0xe2, 0xde, 0x6c, 0x6c, 0x62, 0xeb, 0xd8, 0xf0, 0xd6, 0xe1, 0x6c	/* tcpuhp_rollback_install */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x92, 0x68, 0xe2, 0xf8, 0xa5, 0x22, 0xd6, 0xa1, 0x92, 0x73, 0x3c, 0x65, 0x64	/* T__pfx___cpuhp_remove_state_cpuslocked */
	.byte 0x0e, 0x2f, 0x92, 0x68, 0xe2, 0xf8, 0xa5, 0x22, 0xd6, 0xa1, 0x92, 0x73, 0x3c, 0x65, 0x64	/* T__cpuhp_remove_state_cpuslocked */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x92, 0x68, 0x70, 0xba, 0x74, 0xb9, 0x2a, 0xa1, 0x92, 0x73, 0x3c, 0x65, 0x64	/* T__pfx___cpuhp_setup_state_cpuslocked */
	.byte 0x0e, 0x2f, 0x92, 0x68, 0x70, 0xba, 0x74, 0xb9, 0x2a, 0xa1, 0x92, 0x73, 0x3c, 0x65, 0x64	/* T__cpuhp_setup_state_cpuslocked */
	.byte 0x0b, 0xbf, 0x92, 0x5f, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0xe8, 0x80, 0xd3	/* T__pfx_cpu_hotplug_enable */
	.byte 0x0b, 0x54, 0x92, 0x5f, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0xe8, 0x80, 0xd3	/* Tcpu_hotplug_enable */
	.byte 0x0c, 0xbf, 0x92, 0x5f, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0x64, 0xab, 0x80, 0xd3	/* T__pfx_cpu_hotplug_disable */
	.byte 0x0c, 0x54, 0x92, 0x5f, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0x64, 0xab, 0x80, 0xd3	/* Tcpu_hotplug_disable */
	.byte 0x0f, 0xc6, 0x92, 0x5f, 0xad, 0x06, 0x6c, 0x75, 0x67, 0xe7, 0xcd, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_cpu_hotplug_pm_callback */
	.byte 0x0f, 0x74, 0x92, 0x5f, 0xad, 0x06, 0x6c, 0x75, 0x67, 0xe7, 0xcd, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tcpu_hotplug_pm_callback */
	.byte 0x0b, 0xc6, 0x92, 0x5f, 0xa9, 0x77, 0x7c, 0x0a, 0xe0, 0x3c, 0x65, 0x64	/* t__pfx_cpu_down_maps_locked */
	.byte 0x0b, 0x74, 0x92, 0x5f, 0xa9, 0x77, 0x7c, 0x0a, 0xe0, 0x3c, 0x65, 0x64	/* tcpu_down_maps_locked */
	.byte 0x06, 0xc6, 0x92, 0x5f, 0xa9, 0x77, 0x6e	/* t__pfx_cpu_down */
	.byte 0x06, 0x74, 0x92, 0x5f, 0xa9, 0x77, 0x6e	/* tcpu_down */
	.byte 0x05, 0xbf, 0xf8, 0xa5, 0x22, 0x92	/* T__pfx_remove_cpu */
	.byte 0x05, 0x54, 0xf8, 0xa5, 0x22, 0x92	/* Tremove_cpu */
	.byte 0x04, 0xbf, 0xc7, 0xe5, 0x92	/* T__pfx_add_cpu */
	.byte 0x04, 0x54, 0xc7, 0xe5, 0x92	/* Tadd_cpu */
	.byte 0x08, 0xc6, 0x66, 0x61, 0x69, 0x6c, 0xf6, 0xac, 0xf8	/* t__pfx_fail_store */
	.byte 0x08, 0x74, 0x66, 0x61, 0x69, 0x6c, 0xf6, 0xac, 0xf8	/* tfail_store */
	.byte 0x06, 0xa8, 0x2a, 0x86, 0x73, 0xf6, 0x26	/* t__pfx_states_show */
	.byte 0x06, 0x74, 0xd6, 0x86, 0x73, 0xf6, 0x26	/* tstates_show */
	.byte 0x07, 0xc6, 0x66, 0x61, 0x69, 0x6c, 0xf6, 0x26	/* t__pfx_fail_show */
	.byte 0x07, 0x74, 0x66, 0x61, 0x69, 0x6c, 0xf6, 0x26	/* tfail_show */
	.byte 0x06, 0xc6, 0xdb, 0x72, 0xb2, 0x73, 0x26	/* t__pfx_target_show */
	.byte 0x06, 0x74, 0xdb, 0x72, 0xb2, 0x73, 0x26	/* ttarget_show */
	.byte 0x05, 0xa8, 0x2a, 0xa1, 0x73, 0x26	/* t__pfx_state_show */
	.byte 0x05, 0x74, 0xd6, 0xa1, 0x73, 0x26	/* tstate_show */
	.byte 0x06, 0xc6, 0xeb, 0xc2, 0x22, 0x73, 0x26	/* t__pfx_active_show */
	.byte 0x06, 0x74, 0xeb, 0xc2, 0x22, 0x73, 0x26	/* tactive_show */
	.byte 0x06, 0xc6, 0x98, 0xea, 0x7f, 0xf6, 0x26	/* t__pfx_control_show */
	.byte 0x06, 0x74, 0x98, 0xea, 0x7f, 0xf6, 0x26	/* tcontrol_show */
	.byte 0x08, 0xbf, 0x92, 0xe0, 0xf8, 0x05, 0xea, 0x79, 0x3c	/* T__pfx_cpus_read_trylock */
	.byte 0x08, 0x54, 0x92, 0xe0, 0xf8, 0x05, 0xea, 0x79, 0x3c	/* Tcpus_read_trylock */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0x92, 0x68, 0x70, 0x2a, 0xa1, 0xf8, 0xa5, 0x22, 0xf0, 0x73, 0xdb, 0x6e, 0x63, 0x65	/* T__pfx___cpuhp_state_remove_instance */
	.byte 0x0f, 0x2f, 0x92, 0x68, 0x70, 0x2a, 0xa1, 0xf8, 0xa5, 0x22, 0xf0, 0x73, 0xdb, 0x6e, 0x63, 0x65	/* T__cpuhp_state_remove_instance */
	.byte 0x0e, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* t__pfx_trace_event_raw_event_cpuhp_multi_enter */
	.byte 0x0e, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x92, 0x68, 0xe2, 0x6d, 0x0b, 0x74, 0xcb, 0x1e, 0xee	/* ttrace_event_raw_event_cpuhp_multi_enter */
	.byte 0x06, 0xbf, 0x92, 0xe0, 0xf8, 0x05, 0x3c	/* T__pfx_cpus_read_lock */
	.byte 0x06, 0x54, 0x92, 0xe0, 0xf8, 0x05, 0x3c	/* Tcpus_read_lock */
	.byte 0x07, 0xbf, 0x92, 0xe0, 0xf8, 0x05, 0xd4, 0x3c	/* T__pfx_cpus_read_unlock */
	.byte 0x07, 0x54, 0x92, 0xe0, 0xf8, 0x05, 0xd4, 0x3c	/* Tcpus_read_unlock */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x92, 0x68, 0xe2, 0xf8, 0xa5, 0x22, 0xd6, 0x86	/* T__pfx___cpuhp_remove_state */
	.byte 0x09, 0x2f, 0x92, 0x68, 0xe2, 0xf8, 0xa5, 0x22, 0xd6, 0x86	/* T__cpuhp_remove_state */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x92, 0x68, 0x70, 0xba, 0x74, 0xb9, 0x2a, 0x86	/* T__pfx___cpuhp_setup_state */
	.byte 0x09, 0x2f, 0x92, 0x68, 0x70, 0xba, 0x74, 0xb9, 0x2a, 0x86	/* T__cpuhp_setup_state */
	.byte 0x09, 0xc6, 0x92, 0x68, 0xe2, 0x6b, 0xa3, 0xd8, 0x61, 0x70	/* t__pfx_cpuhp_kick_ap */
	.byte 0x09, 0x74, 0x92, 0x68, 0xe2, 0x6b, 0xa3, 0xd8, 0x61, 0x70	/* tcpuhp_kick_ap */
	.byte 0x0c, 0xc6, 0x92, 0x68, 0xe2, 0x6b, 0xa3, 0xd8, 0x61, 0xe2, 0x77, 0xce, 0x6b	/* t__pfx_cpuhp_kick_ap_work */
	.byte 0x0c, 0x74, 0x92, 0x68, 0xe2, 0x6b, 0xa3, 0xd8, 0x61, 0xe2, 0x77, 0xce, 0x6b	/* tcpuhp_kick_ap_work */
	.byte 0x0d, 0xc6, 0x92, 0x68, 0xe2, 0x13, 0x99, 0x66, 0xce, 0x95, 0x6e, 0x63, 0x2a, 0x86	/* t__pfx_cpuhp_wait_for_sync_state */
	.byte 0x0d, 0x74, 0x92, 0x68, 0xe2, 0x13, 0x99, 0x66, 0xce, 0x95, 0x6e, 0x63, 0x2a, 0x86	/* tcpuhp_wait_for_sync_state */
	.byte 0x0c, 0xbf, 0x92, 0x68, 0xe2, 0x61, 0xe2, 0xf8, 0x70, 0xce, 0xf9, 0xe6, 0xc7	/* T__pfx_cpuhp_ap_report_dead */
	.byte 0x0c, 0x54, 0x92, 0x68, 0xe2, 0x61, 0xe2, 0xf8, 0x70, 0xce, 0xf9, 0xe6, 0xc7	/* Tcpuhp_ap_report_dead */
	.byte 0x07, 0xc6, 0xdb, 0x0e, 0xa9, 0x77, 0x7c, 0x92	/* t__pfx_takedown_cpu */
	.byte 0x07, 0x74, 0xdb, 0x0e, 0xa9, 0x77, 0x7c, 0x92	/* ttakedown_cpu */
	.byte 0x0d, 0xbf, 0x92, 0x68, 0xe2, 0x61, 0x70, 0x95, 0x6e, 0xd5, 0xe1, 0x69, 0x76, 0x65	/* T__pfx_cpuhp_ap_sync_alive */
	.byte 0x0d, 0x54, 0x92, 0x68, 0xe2, 0x61, 0x70, 0x95, 0x6e, 0xd5, 0xe1, 0x69, 0x76, 0x65	/* Tcpuhp_ap_sync_alive */
	.byte 0x0b, 0xc6, 0x92, 0x68, 0xe2, 0x62, 0x72, 0xf0, 0x67, 0x3a, 0x61, 0x70	/* t__pfx_cpuhp_bringup_ap */
	.byte 0x0b, 0x74, 0x92, 0x68, 0xe2, 0x62, 0x72, 0xf0, 0x67, 0x3a, 0x61, 0x70	/* tcpuhp_bringup_ap */
	.byte 0x0b, 0xbf, 0x92, 0x5f, 0x0a, 0xe0, 0xb9, 0x64, 0xa1, 0x17, 0x67, 0xf0	/* T__pfx_cpu_maps_update_begin */
	.byte 0x0b, 0x54, 0x92, 0x5f, 0x0a, 0xe0, 0xb9, 0x64, 0xa1, 0x17, 0x67, 0xf0	/* Tcpu_maps_update_begin */
	.byte 0x0a, 0xbf, 0x92, 0x5f, 0x0a, 0xe0, 0xb9, 0x64, 0xa1, 0xa9, 0xb4	/* T__pfx_cpu_maps_update_done */
	.byte 0x0a, 0x54, 0x92, 0x5f, 0x0a, 0xe0, 0xb9, 0x64, 0xa1, 0xa9, 0xb4	/* Tcpu_maps_update_done */
	.byte 0x06, 0xbf, 0x92, 0xe0, 0x24, 0xfa, 0x3c	/* T__pfx_cpus_write_lock */
	.byte 0x06, 0x54, 0x92, 0xe0, 0x24, 0xfa, 0x3c	/* Tcpus_write_lock */
	.byte 0x07, 0xbf, 0x92, 0xe0, 0x24, 0xfa, 0xd4, 0x3c	/* T__pfx_cpus_write_unlock */
	.byte 0x07, 0x54, 0x92, 0xe0, 0x24, 0xfa, 0xd4, 0x3c	/* Tcpus_write_unlock */
	.byte 0x0d, 0xbf, 0x3c, 0xe6, 0xe2, 0x96, 0x73, 0xee, 0xf9, 0x92, 0xe0, 0x68, 0x65, 0x02	/* T__pfx_lockdep_assert_cpus_held */
	.byte 0x0d, 0x54, 0x3c, 0xe6, 0xe2, 0x96, 0x73, 0xee, 0xf9, 0x92, 0xe0, 0x68, 0x65, 0x02	/* Tlockdep_assert_cpus_held */
	.byte 0x12, 0xbf, 0x92, 0x5f, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0x64, 0xab, 0x80, 0xb3, 0x6f, 0x66, 0x66, 0x88, 0xf0, 0x67	/* T__pfx_cpu_hotplug_disable_offlining */
	.byte 0x12, 0x54, 0x92, 0x5f, 0xad, 0x06, 0x6c, 0x75, 0xa6, 0x64, 0xab, 0x80, 0xb3, 0x6f, 0x66, 0x66, 0x88, 0xf0, 0x67	/* Tcpu_hotplug_disable_offlining */
	.byte 0x04, 0x29, 0x92, 0x5f, 0xb9	/* t__pfx__cpu_up */
	.byte 0x04, 0xf9, 0x92, 0x5f, 0xb9	/* t_cpu_up */
	.byte 0x04, 0xc6, 0x92, 0x5f, 0xb9	/* t__pfx_cpu_up */
	.byte 0x04, 0x74, 0x92, 0x5f, 0xb9	/* tcpu_up */
	.byte 0x07, 0xc6, 0xdb, 0x72, 0xb2, 0xd6, 0x6f, 0xf8	/* t__pfx_target_store */
	.byte 0x07, 0x74, 0xdb, 0x72, 0xb2, 0xd6, 0x6f, 0xf8	/* ttarget_store */
	.byte 0x0c, 0x29, 0x5f, 0x92, 0x5f, 0xa9, 0x77, 0x7c, 0x0a, 0xe0, 0x3c, 0x65, 0x64	/* t__pfx___cpu_down_maps_locked */
	.byte 0x0c, 0x74, 0xff, 0x92, 0x5f, 0xa9, 0x77, 0x7c, 0x0a, 0xe0, 0x3c, 0x65, 0x64	/* t__cpu_down_maps_locked */
	.byte 0x0d, 0xbf, 0x63, 0xd3, 0xca, 0x5f, 0xdb, 0x16, 0xe0, 0x6d, 0xcd, 0x92, 0xdd, 0x16	/* T__pfx_clear_tasks_mm_cpumask */
	.byte 0x0d, 0x54, 0x63, 0xd3, 0xca, 0x5f, 0xdb, 0x16, 0xe0, 0x6d, 0xcd, 0x92, 0xdd, 0x16	/* Tclear_tasks_mm_cpumask */
	.byte 0x0c, 0xbf, 0x92, 0x68, 0xe2, 0xf8, 0x70, 0xce, 0xf9, 0x89, 0xb3, 0xe6, 0xc7	/* T__pfx_cpuhp_report_idle_dead */
	.byte 0x0c, 0x54, 0x92, 0x68, 0xe2, 0xf8, 0x70, 0xce, 0xf9, 0x89, 0xb3, 0xe6, 0xc7	/* Tcpuhp_report_idle_dead */
	.byte 0x08, 0xbf, 0x92, 0x5f, 0x07, 0xfa, 0xa9, 0x77, 0x6e	/* T__pfx_cpu_device_down */
	.byte 0x08, 0x54, 0x92, 0x5f, 0x07, 0xfa, 0xa9, 0x77, 0x6e	/* Tcpu_device_down */
	.byte 0x11, 0x3f, 0xf6, 0xb0, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x7c, 0xb6, 0x6e, 0x62, 0x6f, 0x6f, 0xf9, 0x92, 0x73	/* T__pfx_smp_shutdown_nonboot_cpus */
	.byte 0x11, 0x54, 0x73, 0xb0, 0xf6, 0x68, 0x5e, 0xa9, 0x77, 0x7c, 0xb6, 0x6e, 0x62, 0x6f, 0x6f, 0xf9, 0x92, 0x73	/* Tsmp_shutdown_nonboot_cpus */
	.byte 0x0c, 0xbf, 0xb6, 0xc2, 0x66, 0xc5, 0x92, 0xf6, 0xdb, 0x72, 0x74, 0xf0, 0x67	/* T__pfx_notify_cpu_starting */
	.byte 0x0c, 0x54, 0xb6, 0xc2, 0x66, 0xc5, 0x92, 0xf6, 0xdb, 0x72, 0x74, 0xf0, 0x67	/* Tnotify_cpu_starting */
	.byte 0x0a, 0xbf, 0x92, 0x68, 0xe2, 0x6f, 0x6e, 0x88, 0xfa, 0x89, 0xd3	/* T__pfx_cpuhp_online_idle */
	.byte 0x0a, 0x54, 0x92, 0x68, 0xe2, 0x6f, 0x6e, 0x88, 0xfa, 0x89, 0xd3	/* Tcpuhp_online_idle */
	.byte 0x06, 0xbf, 0x92, 0x5f, 0x07, 0xfa, 0xb9	/* T__pfx_cpu_device_up */
	.byte 0x06, 0x54, 0x92, 0x5f, 0x07, 0xfa, 0xb9	/* Tcpu_device_up */
	.byte 0x0d, 0xbf, 0x62, 0x72, 0xf0, 0x67, 0x3a, 0x68, 0x69, 0x62, 0xee, 0x6e, 0xa1, 0x92	/* T__pfx_bringup_hibernate_cpu */
	.byte 0x0d, 0x54, 0x62, 0x72, 0xf0, 0x67, 0x3a, 0x68, 0x69, 0x62, 0xee, 0x6e, 0xa1, 0x92	/* Tbringup_hibernate_cpu */
	.byte 0x0c, 0xbf, 0x87, 0x65, 0x7a, 0xfa, 0xc9, 0x98, 0x64, 0xca, 0xc5, 0x92, 0x73	/* T__pfx_freeze_secondary_cpus */
	.byte 0x0c, 0x54, 0x87, 0x65, 0x7a, 0xfa, 0xc9, 0x98, 0x64, 0xca, 0xc5, 0x92, 0x73	/* Tfreeze_secondary_cpus */
	.byte 0x0b, 0xbf, 0x15, 0x61, 0x77, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x92, 0x73	/* T__pfx_thaw_secondary_cpus */
	.byte 0x0b, 0x54, 0x15, 0x61, 0x77, 0xba, 0x98, 0x64, 0xca, 0xc5, 0x92, 0x73	/* Tthaw_secondary_cpus */
	.byte 0x15, 0x3f, 0xff, 0x5f, 0x92, 0x68, 0x70, 0x2a, 0xa1, 0xc7, 0xe5, 0xf0, 0x73, 0xdb, 0x6e, 0x63, 0xfa, 0x92, 0x73, 0x3c, 0x65, 0x64	/* T__pfx___cpuhp_state_add_instance_cpuslocked */
	.byte 0x13, 0x2f, 0x92, 0x68, 0x70, 0x2a, 0xa1, 0xc7, 0xe5, 0xf0, 0x73, 0xdb, 0x6e, 0x63, 0xfa, 0x92, 0x73, 0x3c, 0x65, 0x64	/* T__cpuhp_state_add_instance_cpuslocked */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x92, 0x68, 0x70, 0x2a, 0xa1, 0xc7, 0xe5, 0xf0, 0x73, 0xdb, 0x6e, 0x63, 0x65	/* T__pfx___cpuhp_state_add_instance */
	.byte 0x0e, 0x2f, 0x92, 0x68, 0x70, 0x2a, 0xa1, 0xc7, 0xe5, 0xf0, 0x73, 0xdb, 0x6e, 0x63, 0x65	/* T__cpuhp_state_add_instance */
	.byte 0x0b, 0xbf, 0x92, 0x68, 0x70, 0xf6, 0x6d, 0xf9, 0x64, 0xab, 0x80, 0xd3	/* T__pfx_cpuhp_smt_disable */
	.byte 0x0b, 0x54, 0x92, 0x68, 0x70, 0xf6, 0x6d, 0xf9, 0x64, 0xab, 0x80, 0xd3	/* Tcpuhp_smt_disable */
	.byte 0x0a, 0xbf, 0x92, 0x68, 0x70, 0xf6, 0x6d, 0xf9, 0xe8, 0x80, 0xd3	/* T__pfx_cpuhp_smt_enable */
	.byte 0x0a, 0x54, 0x92, 0x68, 0x70, 0xf6, 0x6d, 0xf9, 0xe8, 0x80, 0xd3	/* Tcpuhp_smt_enable */
	.byte 0x07, 0xc6, 0x98, 0xea, 0x7f, 0xf6, 0xac, 0xf8	/* t__pfx_control_store */
	.byte 0x07, 0x74, 0x98, 0xea, 0x7f, 0xf6, 0xac, 0xf8	/* tcontrol_store */
	.byte 0x07, 0xbf, 0xf0, 0x99, 0x92, 0xe7, 0x3d, 0x1e	/* T__pfx_init_cpu_present */
	.byte 0x07, 0x54, 0xf0, 0x99, 0x92, 0xe7, 0x3d, 0x1e	/* Tinit_cpu_present */
	.byte 0x0b, 0xbf, 0xf0, 0x99, 0x92, 0xe7, 0x6f, 0x73, 0x73, 0x69, 0x62, 0xd3	/* T__pfx_init_cpu_possible */
	.byte 0x0b, 0x54, 0xf0, 0x99, 0x92, 0xe7, 0x6f, 0x73, 0x73, 0x69, 0x62, 0xd3	/* Tinit_cpu_possible */
	.byte 0x09, 0xbf, 0xf0, 0x99, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* T__pfx_init_cpu_online */
	.byte 0x09, 0x54, 0xf0, 0x99, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* Tinit_cpu_online */
	.byte 0x08, 0x3f, 0x1f, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* T__pfx_set_cpu_online */
	.byte 0x09, 0x54, 0xc9, 0xf9, 0x92, 0x5f, 0x6f, 0x6e, 0x88, 0x65	/* Tset_cpu_online */
	.byte 0x13, 0xc6, 0x77, 0x69, 0x6c, 0xc3, 0x17, 0xfe, 0x6d, 0xfa, 0xce, 0x70, 0x68, 0xcc, 0x65, 0x64, 0xe7, 0x67, 0x72, 0x70	/* t__pfx_will_become_orphaned_pgrp */
	.byte 0x13, 0x74, 0x77, 0x69, 0x6c, 0xc3, 0x17, 0xfe, 0x6d, 0xfa, 0xce, 0x70, 0x68, 0xcc, 0x65, 0x64, 0xe7, 0x67, 0x72, 0x70	/* twill_become_orphaned_pgrp */
	.byte 0x0a, 0xc6, 0x66, 0xf0, 0xe5, 0xe1, 0x69, 0x22, 0x15, 0xf8, 0xc7	/* t__pfx_find_alive_thread */
	.byte 0x0a, 0x74, 0x66, 0xf0, 0xe5, 0xe1, 0x69, 0x22, 0x15, 0xf8, 0xc7	/* tfind_alive_thread */
	.byte 0x0b, 0xc6, 0xdb, 0x16, 0xf6, 0xac, 0x70, 0x70, 0x65, 0xe5, 0xfe, 0xe6	/* t__pfx_task_stopped_code */
	.byte 0x0b, 0x74, 0xdb, 0x16, 0xf6, 0xac, 0x70, 0x70, 0x65, 0xe5, 0xfe, 0xe6	/* ttask_stopped_code */
	.byte 0x10, 0xc6, 0x69, 0xe0, 0x65, 0x66, 0x66, 0x65, 0x63, 0xc2, 0x76, 0x65, 0x6c, 0xc5, 0xd0, 0x69, 0x02	/* t__pfx_is_effectively_child */
	.byte 0x0f, 0xc2, 0xe0, 0x65, 0x66, 0x66, 0x65, 0x63, 0xc2, 0x76, 0x65, 0x6c, 0xc5, 0xd0, 0x69, 0x02	/* tis_effectively_child */
	.byte 0x09, 0xc6, 0x6f, 0x81, 0xe0, 0xfe, 0xd4, 0xf9, 0x73, 0x26	/* t__pfx_oops_count_show */
	.byte 0x08, 0xac, 0x81, 0xe0, 0xfe, 0xd4, 0xf9, 0x73, 0x26	/* toops_count_show */
	.byte 0x0a, 0xbf, 0x72, 0x63, 0x75, 0x13, 0x99, 0x13, 0x6b, 0xfa, 0xb9	/* T__pfx_rcuwait_wake_up */
	.byte 0x0a, 0x54, 0x72, 0x63, 0x75, 0x13, 0x99, 0x13, 0x6b, 0xfa, 0xb9	/* Trcuwait_wake_up */
	.byte 0x09, 0xc6, 0xea, 0xc5, 0xac, 0x1f, 0x6f, 0x77, 0x6e, 0xee	/* t__pfx_try_to_set_owner */
	.byte 0x09, 0x74, 0xea, 0xc5, 0xac, 0x1f, 0x6f, 0x77, 0x6e, 0xee	/* ttry_to_set_owner */
	.byte 0x0f, 0xc6, 0x6b, 0x69, 0x6c, 0xc3, 0xce, 0x70, 0x68, 0xcc, 0x65, 0x64, 0xe7, 0x67, 0x72, 0x70	/* t__pfx_kill_orphaned_pgrp */
	.byte 0x0f, 0x74, 0x6b, 0x69, 0x6c, 0xc3, 0xce, 0x70, 0x68, 0xcc, 0x65, 0x64, 0xe7, 0x67, 0x72, 0x70	/* tkill_orphaned_pgrp */
	.byte 0x0f, 0xc6, 0xe6, 0x1b, 0x79, 0x65, 0x64, 0xe7, 0x75, 0xf9, 0xdb, 0x16, 0xf6, 0xea, 0x75, 0x7b	/* t__pfx_delayed_put_task_struct */
	.byte 0x0f, 0x74, 0xe6, 0x1b, 0x79, 0x65, 0x64, 0xe7, 0x75, 0xf9, 0xdb, 0x16, 0xf6, 0xea, 0x75, 0x7b	/* tdelayed_put_task_struct */
	.byte 0x10, 0x3f, 0xe7, 0x75, 0xf9, 0xdb, 0x16, 0xf6, 0xea, 0x75, 0x63, 0xf9, 0x72, 0x63, 0x00, 0x5d, 0xee	/* T__pfx_put_task_struct_rcu_user */
	.byte 0x0f, 0x54, 0xbe, 0xf9, 0xdb, 0x16, 0xf6, 0xea, 0x75, 0x63, 0xf9, 0x72, 0x63, 0x00, 0x5d, 0xee	/* Tput_task_struct_rcu_user */
	.byte 0x07, 0xbf, 0xf8, 0xd3, 0x96, 0xfa, 0xdb, 0x16	/* T__pfx_release_task */
	.byte 0x07, 0x54, 0xf8, 0xd3, 0x96, 0xfa, 0xdb, 0x16	/* Trelease_task */
	.byte 0x09, 0xc6, 0x13, 0x99, 0x98, 0x73, 0x89, 0xcf, 0xdb, 0x16	/* t__pfx_wait_consider_task */
	.byte 0x09, 0x74, 0x13, 0x99, 0x98, 0x73, 0x89, 0xcf, 0xdb, 0x16	/* twait_consider_task */
	.byte 0x12, 0xbf, 0x69, 0xe0, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x70, 0x67, 0x72, 0xe2, 0xce, 0x70, 0x68, 0xcc, 0x65, 0x64	/* T__pfx_is_current_pgrp_orphaned */
	.byte 0x12, 0x54, 0x69, 0xe0, 0x63, 0x1d, 0xf8, 0x6e, 0xf9, 0x70, 0x67, 0x72, 0xe2, 0xce, 0x70, 0x68, 0xcc, 0x65, 0x64	/* Tis_current_pgrp_orphaned */
	.byte 0x0d, 0xbf, 0x6d, 0xcd, 0xb9, 0x64, 0xa1, 0x6e, 0xd1, 0xf9, 0x6f, 0x77, 0x6e, 0xee	/* T__pfx_mm_update_next_owner */
	.byte 0x0d, 0x54, 0x6d, 0xcd, 0xb9, 0x64, 0xa1, 0x6e, 0xd1, 0xf9, 0x6f, 0x77, 0x6e, 0xee	/* Tmm_update_next_owner */
	.byte 0x05, 0xbf, 0xa9, 0x5f, 0xd1, 0xe4	/* T__pfx_do_exit */
	.byte 0x05, 0x54, 0xa9, 0x5f, 0xd1, 0xe4	/* Tdo_exit */
	.byte 0x0c, 0x29, 0x5f, 0xa9, 0x95, 0xe0, 0xd1, 0xe4, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx___do_sys_exit.isra.0 */
	.byte 0x0c, 0x74, 0xff, 0xa9, 0x95, 0xe0, 0xd1, 0xe4, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__do_sys_exit.isra.0 */
	.byte 0x0a, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xd1, 0xe4	/* T__pfx___x64_sys_exit */
	.byte 0x08, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xd1, 0xe4	/* T__x64_sys_exit */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xd1, 0xe4	/* T__pfx___ia32_sys_exit */
	.byte 0x09, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xd1, 0xe4	/* T__ia32_sys_exit */
	.byte 0x09, 0xbf, 0xdd, 0x6b, 0xfa, 0xdb, 0x73, 0xd8, 0xe6, 0xc7	/* T__pfx_make_task_dead */
	.byte 0x09, 0x54, 0xdd, 0x6b, 0xfa, 0xdb, 0x73, 0xd8, 0xe6, 0xc7	/* Tmake_task_dead */
	.byte 0x07, 0xbf, 0xa9, 0x5f, 0x0d, 0x3a, 0xd1, 0xe4	/* T__pfx_do_group_exit */
	.byte 0x07, 0x54, 0xa9, 0x5f, 0x0d, 0x3a, 0xd1, 0xe4	/* Tdo_group_exit */
	.byte 0x0e, 0x29, 0x5f, 0xa9, 0x95, 0xe0, 0xd1, 0x99, 0x0d, 0xb9, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx___do_sys_exit_group.isra.0 */
	.byte 0x0e, 0x74, 0xff, 0xa9, 0x95, 0xe0, 0xd1, 0x99, 0x0d, 0xb9, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__do_sys_exit_group.isra.0 */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xd1, 0x99, 0x0d, 0xb9	/* T__pfx___x64_sys_exit_group */
	.byte 0x0a, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0xd1, 0x99, 0x0d, 0xb9	/* T__x64_sys_exit_group */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xd1, 0x99, 0x0d, 0xb9	/* T__pfx___ia32_sys_exit_group */
	.byte 0x0b, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0xd1, 0x99, 0x0d, 0xb9	/* T__ia32_sys_exit_group */
	.byte 0x0d, 0x3f, 0xe7, 0x69, 0xe5, 0xd0, 0x69, 0x02, 0xf6, 0xad, 0x0b, 0xe5, 0x13, 0x0e	/* T__pfx_pid_child_should_wake */
	.byte 0x0d, 0x54, 0x70, 0x69, 0xe5, 0xd0, 0x69, 0x02, 0xf6, 0xad, 0x0b, 0xe5, 0x13, 0x0e	/* Tpid_child_should_wake */
	.byte 0x0c, 0xc6, 0xd0, 0x69, 0x6c, 0xe5, 0x13, 0x99, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* t__pfx_child_wait_callback */
	.byte 0x0c, 0x74, 0xd0, 0x69, 0x6c, 0xe5, 0x13, 0x99, 0x28, 0x6c, 0x62, 0xeb, 0x6b	/* tchild_wait_callback */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x13, 0x6b, 0xfa, 0xb9, 0xe7, 0x61, 0xf8, 0x6e, 0x74	/* T__pfx___wake_up_parent */
	.byte 0x0a, 0x2f, 0x13, 0x6b, 0xfa, 0xb9, 0xe7, 0x61, 0xf8, 0x6e, 0x74	/* T__wake_up_parent */
	.byte 0x07, 0x3f, 0xff, 0x5f, 0xa9, 0x5f, 0x13, 0xe4	/* T__pfx___do_wait */
	.byte 0x05, 0x2f, 0xa9, 0x5f, 0x13, 0xe4	/* T__do_wait */
	.byte 0x05, 0xc6, 0xa9, 0x5f, 0x13, 0xe4	/* t__pfx_do_wait */
	.byte 0x05, 0x74, 0xa9, 0x5f, 0x13, 0xe4	/* tdo_wait */
	.byte 0x0d, 0xbf, 0x6b, 0xee, 0xb4, 0xc3, 0x13, 0xe4, 0x89, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* T__pfx_kernel_waitid_prepare */
	.byte 0x0d, 0x54, 0x6b, 0xee, 0xb4, 0xc3, 0x13, 0xe4, 0x89, 0xe7, 0xf8, 0x70, 0x61, 0xf8	/* Tkernel_waitid_prepare */
	.byte 0x08, 0xc6, 0x6b, 0xee, 0xb4, 0xc3, 0x13, 0xe4, 0x89	/* t__pfx_kernel_waitid */
	.byte 0x08, 0x74, 0x6b, 0xee, 0xb4, 0xc3, 0x13, 0xe4, 0x89	/* tkernel_waitid */
	.byte 0x0c, 0x29, 0x5f, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x13, 0xe4, 0x89	/* t__pfx___do_compat_sys_waitid */
	.byte 0x0c, 0x74, 0xff, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x13, 0xe4, 0x89	/* t__do_compat_sys_waitid */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x13, 0xe4, 0x89	/* T__pfx___ia32_compat_sys_waitid */
	.byte 0x0e, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x13, 0xe4, 0x89	/* T__ia32_compat_sys_waitid */
	.byte 0x08, 0x29, 0x5f, 0xa9, 0x95, 0xe0, 0x13, 0xe4, 0x89	/* t__pfx___do_sys_waitid */
	.byte 0x08, 0x74, 0xff, 0xa9, 0x95, 0xe0, 0x13, 0xe4, 0x89	/* t__do_sys_waitid */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x13, 0xe4, 0x89	/* T__pfx___ia32_sys_waitid */
	.byte 0x0a, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x13, 0xe4, 0x89	/* T__ia32_sys_waitid */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x13, 0xe4, 0x89	/* T__pfx___x64_sys_waitid */
	.byte 0x09, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x13, 0xe4, 0x89	/* T__x64_sys_waitid */
	.byte 0x08, 0xbf, 0x6b, 0xee, 0xb4, 0xc3, 0x13, 0xe4, 0x34	/* T__pfx_kernel_wait4 */
	.byte 0x08, 0x54, 0x6b, 0xee, 0xb4, 0xc3, 0x13, 0xe4, 0x34	/* Tkernel_wait4 */
	.byte 0x0c, 0x29, 0x5f, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x13, 0xe4, 0x34	/* t__pfx___do_compat_sys_wait4 */
	.byte 0x0c, 0x74, 0xff, 0xa9, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x13, 0xe4, 0x34	/* t__do_compat_sys_wait4 */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x13, 0xe4, 0x34	/* T__pfx___ia32_compat_sys_wait4 */
	.byte 0x0e, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0xe0, 0x13, 0xe4, 0x34	/* T__ia32_compat_sys_wait4 */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x13, 0xe4, 0x70, 0x89	/* T__pfx___ia32_sys_waitpid */
	.byte 0x0b, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x13, 0xe4, 0x70, 0x89	/* T__ia32_sys_waitpid */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x13, 0xe4, 0x70, 0x89	/* T__pfx___x64_sys_waitpid */
	.byte 0x0a, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x13, 0xe4, 0x70, 0x89	/* T__x64_sys_waitpid */
	.byte 0x08, 0x29, 0x5f, 0xa9, 0x95, 0xe0, 0x13, 0xe4, 0x34	/* t__pfx___do_sys_wait4 */
	.byte 0x08, 0x74, 0xff, 0xa9, 0x95, 0xe0, 0x13, 0xe4, 0x34	/* t__do_sys_wait4 */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x13, 0xe4, 0x34	/* T__pfx___ia32_sys_wait4 */
	.byte 0x0a, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x13, 0xe4, 0x34	/* T__ia32_sys_wait4 */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x13, 0xe4, 0x34	/* T__pfx___x64_sys_wait4 */
	.byte 0x09, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x13, 0xe4, 0x34	/* T__x64_sys_wait4 */
	.byte 0x07, 0xbf, 0x6b, 0xee, 0xb4, 0xc3, 0x13, 0xe4	/* T__pfx_kernel_wait */
	.byte 0x07, 0x54, 0x6b, 0xee, 0xb4, 0xc3, 0x13, 0xe4	/* Tkernel_wait */
	.byte 0x10, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_irq_handler_entry */
	.byte 0x0e, 0x2f, 0x01, 0xe4, 0xcf, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xe8, 0xea, 0x79	/* T__traceiter_irq_handler_entry */
	.byte 0x11, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xe8, 0xea, 0x79	/* T__pfx___probestub_irq_handler_entry */
	.byte 0x10, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xe8, 0xea, 0x79	/* T__probestub_irq_handler_entry */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xd1, 0xe4	/* T__pfx___traceiter_irq_handler_exit */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xcf, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xd1, 0xe4	/* T__traceiter_irq_handler_exit */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xd1, 0xe4	/* T__pfx___probestub_irq_handler_exit */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xd1, 0xe4	/* T__probestub_irq_handler_exit */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xee, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_softirq_entry */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xee, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xe8, 0xea, 0x79	/* T__traceiter_softirq_entry */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0x62, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xe8, 0xea, 0x79	/* T__pfx___probestub_softirq_entry */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0x62, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xe8, 0xea, 0x79	/* T__probestub_softirq_entry */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xee, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xd1, 0xe4	/* T__pfx___traceiter_softirq_exit */
	.byte 0x0c, 0x2f, 0x01, 0xe4, 0xee, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xd1, 0xe4	/* T__traceiter_softirq_exit */
	.byte 0x0f, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0x62, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xd1, 0xe4	/* T__pfx___probestub_softirq_exit */
	.byte 0x0e, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0x62, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xd1, 0xe4	/* T__probestub_softirq_exit */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xee, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xb5, 0x69, 0xc9	/* T__pfx___traceiter_softirq_raise */
	.byte 0x0d, 0x2f, 0x01, 0xe4, 0xee, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xb5, 0x69, 0xc9	/* T__traceiter_softirq_raise */
	.byte 0x10, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0x62, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xb5, 0x69, 0xc9	/* T__pfx___probestub_softirq_raise */
	.byte 0x0f, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0x62, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xb5, 0x69, 0xc9	/* T__probestub_softirq_raise */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xdb, 0x16, 0xd3, 0xf9, 0xe8, 0xea, 0x79	/* T__pfx___traceiter_tasklet_entry */
	.byte 0x0b, 0x2f, 0x01, 0xe4, 0xcf, 0xdb, 0x16, 0xd3, 0xf9, 0xe8, 0xea, 0x79	/* T__traceiter_tasklet_entry */
	.byte 0x0e, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xdb, 0x16, 0xd3, 0xf9, 0xe8, 0xea, 0x79	/* T__pfx___probestub_tasklet_entry */
	.byte 0x0d, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xdb, 0x16, 0xd3, 0xf9, 0xe8, 0xea, 0x79	/* T__probestub_tasklet_entry */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0x01, 0xe4, 0xcf, 0xdb, 0x16, 0xd3, 0xf9, 0xd1, 0xe4	/* T__pfx___traceiter_tasklet_exit */
	.byte 0x0a, 0x2f, 0x01, 0xe4, 0xcf, 0xdb, 0x16, 0xd3, 0xf9, 0xd1, 0xe4	/* T__traceiter_tasklet_exit */
	.byte 0x0d, 0x3f, 0xff, 0x25, 0x17, 0xd6, 0x75, 0xdc, 0xdb, 0x16, 0xd3, 0xf9, 0xd1, 0xe4	/* T__pfx___probestub_tasklet_exit */
	.byte 0x0c, 0x2f, 0x9b, 0x17, 0xd6, 0x75, 0xdc, 0xdb, 0x16, 0xd3, 0xf9, 0xd1, 0xe4	/* T__probestub_tasklet_exit */
	.byte 0x08, 0xbf, 0xdb, 0x16, 0xd3, 0xf9, 0xc9, 0x74, 0xb9	/* T__pfx_tasklet_setup */
	.byte 0x08, 0x54, 0xdb, 0x16, 0xd3, 0xf9, 0xc9, 0x74, 0xb9	/* Ttasklet_setup */
	.byte 0x06, 0xbf, 0xdb, 0x16, 0xd3, 0xf9, 0x8d	/* T__pfx_tasklet_init */
	.byte 0x06, 0x54, 0xdb, 0x16, 0xd3, 0xf9, 0x8d	/* Ttasklet_init */
	.byte 0x0f, 0xc6, 0x6b, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71, 0x64, 0xf6, 0xad, 0x0b, 0xe5, 0x72, 0xd4	/* t__pfx_ksoftirqd_should_run */
	.byte 0x0f, 0x74, 0x6b, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71, 0x64, 0xf6, 0xad, 0x0b, 0xe5, 0x72, 0xd4	/* tksoftirqd_should_run */
	.byte 0x0d, 0xbf, 0xdb, 0x16, 0xd3, 0xf9, 0xd4, 0x3c, 0xf6, 0x70, 0xf0, 0x5f, 0x13, 0xe4	/* T__pfx_tasklet_unlock_spin_wait */
	.byte 0x0d, 0x54, 0xdb, 0x16, 0xd3, 0xf9, 0xd4, 0x3c, 0xf6, 0x70, 0xf0, 0x5f, 0x13, 0xe4	/* Ttasklet_unlock_spin_wait */
	.byte 0x09, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0xdb, 0x16, 0xd3, 0x74	/* t__pfx_perf_trace_tasklet */
	.byte 0x08, 0x06, 0xee, 0xa0, 0xc8, 0xdb, 0x16, 0xd3, 0x74	/* tperf_trace_tasklet */
	.byte 0x0b, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* t__pfx_perf_trace_softirq */
	.byte 0x0a, 0x06, 0xee, 0xa0, 0xc8, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* tperf_trace_softirq */
	.byte 0x0e, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xd1, 0xe4	/* t__pfx_perf_trace_irq_handler_exit */
	.byte 0x0d, 0x06, 0xee, 0xa0, 0xc8, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xd1, 0xe4	/* tperf_trace_irq_handler_exit */
	.byte 0x0a, 0x3f, 0xff, 0xc0, 0xe1, 0x5f, 0x62, 0x5b, 0xe8, 0x80, 0xd3	/* T__pfx__local_bh_enable */
	.byte 0x0a, 0x54, 0x5f, 0xc0, 0xe1, 0x5f, 0x62, 0x5b, 0xe8, 0x80, 0xd3	/* T_local_bh_enable */
	.byte 0x08, 0xc6, 0xc8, 0xdb, 0x16, 0xd3, 0xf9, 0xd1, 0xe4	/* t__pfx_trace_tasklet_exit */
	.byte 0x08, 0x74, 0xc8, 0xdb, 0x16, 0xd3, 0xf9, 0xd1, 0xe4	/* ttrace_tasklet_exit */
	.byte 0x09, 0xc6, 0xc8, 0xdb, 0x16, 0xd3, 0xf9, 0xe8, 0xea, 0x79	/* t__pfx_trace_tasklet_entry */
	.byte 0x09, 0x74, 0xc8, 0xdb, 0x16, 0xd3, 0xf9, 0xe8, 0xea, 0x79	/* ttrace_tasklet_entry */
	.byte 0x0b, 0xc6, 0xc8, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xb5, 0x69, 0xc9	/* t__pfx_trace_softirq_raise */
	.byte 0x0b, 0x74, 0xc8, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xb5, 0x69, 0xc9	/* ttrace_softirq_raise */
	.byte 0x09, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0xdb, 0x16, 0xd3, 0x74	/* t__pfx_trace_event_raw_event_tasklet */
	.byte 0x09, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0xdb, 0x16, 0xd3, 0x74	/* ttrace_event_raw_event_tasklet */
	.byte 0x0b, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* t__pfx_trace_event_raw_event_softirq */
	.byte 0x0b, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* ttrace_event_raw_event_softirq */
	.byte 0x0b, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0xdb, 0x16, 0xd3, 0x74	/* t__pfx_trace_raw_output_tasklet */
	.byte 0x0b, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0xdb, 0x16, 0xd3, 0x74	/* ttrace_raw_output_tasklet */
	.byte 0x10, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xd1, 0xe4	/* t__pfx_trace_raw_output_irq_handler_exit */
	.byte 0x10, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xd1, 0xe4	/* ttrace_raw_output_irq_handler_exit */
	.byte 0x11, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xe8, 0xea, 0x79	/* t__pfx_trace_raw_output_irq_handler_entry */
	.byte 0x11, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xe8, 0xea, 0x79	/* ttrace_raw_output_irq_handler_entry */
	.byte 0x0d, 0xc6, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* t__pfx_trace_raw_output_softirq */
	.byte 0x0d, 0x74, 0xc8, 0x1c, 0x6f, 0x5e, 0xbe, 0xf9, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* ttrace_raw_output_softirq */
	.byte 0x08, 0x29, 0x5f, 0x40, 0xc8, 0xdb, 0x16, 0xd3, 0x74	/* t__pfx___bpf_trace_tasklet */
	.byte 0x08, 0x74, 0xff, 0x40, 0xc8, 0xdb, 0x16, 0xd3, 0x74	/* t__bpf_trace_tasklet */
	.byte 0x0e, 0x29, 0x5f, 0x40, 0xc8, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xe8, 0xea, 0x79	/* t__pfx___bpf_trace_irq_handler_entry */
	.byte 0x0e, 0x74, 0xff, 0x40, 0xc8, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xe8, 0xea, 0x79	/* t__bpf_trace_irq_handler_entry */
	.byte 0x0d, 0x29, 0x5f, 0x40, 0xc8, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xd1, 0xe4	/* t__pfx___bpf_trace_irq_handler_exit */
	.byte 0x0d, 0x74, 0xff, 0x40, 0xc8, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xd1, 0xe4	/* t__bpf_trace_irq_handler_exit */
	.byte 0x0a, 0x29, 0x5f, 0x40, 0xc8, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* t__pfx___bpf_trace_softirq */
	.byte 0x0a, 0x74, 0xff, 0x40, 0xc8, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* t__bpf_trace_softirq */
	.byte 0x0a, 0xbf, 0xdb, 0x16, 0xd3, 0xf9, 0xd4, 0xc0, 0xd8, 0x13, 0xe4	/* T__pfx_tasklet_unlock_wait */
	.byte 0x0a, 0x54, 0xdb, 0x16, 0xd3, 0xf9, 0xd4, 0xc0, 0xd8, 0x13, 0xe4	/* Ttasklet_unlock_wait */
	.byte 0x07, 0xbf, 0xdb, 0x16, 0xd3, 0xf9, 0xd4, 0x3c	/* T__pfx_tasklet_unlock */
	.byte 0x07, 0x54, 0xdb, 0x16, 0xd3, 0xf9, 0xd4, 0x3c	/* Ttasklet_unlock */
	.byte 0x0b, 0xc6, 0xdb, 0x16, 0xd3, 0xf9, 0x63, 0xd3, 0xca, 0xf6, 0x7e, 0x64	/* t__pfx_tasklet_clear_sched */
	.byte 0x0b, 0x74, 0xdb, 0x16, 0xd3, 0xf9, 0x63, 0xd3, 0xca, 0xf6, 0x7e, 0x64	/* ttasklet_clear_sched */
	.byte 0x09, 0xbf, 0xdb, 0x16, 0xd3, 0xf9, 0x6b, 0x69, 0x6c, 0x6c	/* T__pfx_tasklet_kill */
	.byte 0x09, 0x54, 0xdb, 0x16, 0xd3, 0xf9, 0x6b, 0x69, 0x6c, 0x6c	/* Ttasklet_kill */
	.byte 0x0d, 0xc6, 0xdb, 0x16, 0xd3, 0xf9, 0xeb, 0x74, 0xd9, 0x7c, 0xfe, 0x6d, 0xa5, 0x6e	/* t__pfx_tasklet_action_common */
	.byte 0x0d, 0x74, 0xdb, 0x16, 0xd3, 0xf9, 0xeb, 0x74, 0xd9, 0x7c, 0xfe, 0x6d, 0xa5, 0x6e	/* ttasklet_action_common */
	.byte 0x0b, 0xc6, 0xdb, 0x16, 0xd3, 0xf9, 0x68, 0xcb, 0xeb, 0x74, 0xd9, 0x6e	/* t__pfx_tasklet_hi_action */
	.byte 0x0b, 0x74, 0xdb, 0x16, 0xd3, 0xf9, 0x68, 0xcb, 0xeb, 0x74, 0xd9, 0x6e	/* ttasklet_hi_action */
	.byte 0x09, 0xc6, 0xdb, 0x16, 0xd3, 0xf9, 0xeb, 0x74, 0xd9, 0x6e	/* t__pfx_tasklet_action */
	.byte 0x09, 0x74, 0xdb, 0x16, 0xd3, 0xf9, 0xeb, 0x74, 0xd9, 0x6e	/* ttasklet_action */
	.byte 0x0e, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xd1, 0xe4	/* t__pfx_trace_event_raw_event_irq_handler_exit */
	.byte 0x0e, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xd1, 0xe4	/* ttrace_event_raw_event_irq_handler_exit */
	.byte 0x0f, 0xa8, 0xe7, 0xee, 0xa0, 0xc8, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xe8, 0xea, 0x79	/* t__pfx_perf_trace_irq_handler_entry */
	.byte 0x0e, 0x06, 0xee, 0xa0, 0xc8, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xe8, 0xea, 0x79	/* tperf_trace_irq_handler_entry */
	.byte 0x0f, 0xc6, 0xc8, 0xaf, 0x1c, 0xaf, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xe8, 0xea, 0x79	/* t__pfx_trace_event_raw_event_irq_handler_entry */
	.byte 0x0f, 0x74, 0xc8, 0xaf, 0x1c, 0xaf, 0xa7, 0x93, 0x68, 0xcc, 0x64, 0x6c, 0xcf, 0xe8, 0xea, 0x79	/* ttrace_event_raw_event_irq_handler_entry */
	.byte 0x0c, 0xc6, 0x68, 0xcc, 0x64, 0xb3, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71, 0x73	/* t__pfx_handle_softirqs */
	.byte 0x0b, 0x15, 0xcc, 0x64, 0xb3, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71, 0x73	/* thandle_softirqs */
	.byte 0x09, 0x29, 0x5f, 0xa7, 0x93, 0xd1, 0x99, 0x72, 0x63, 0x75	/* t__pfx___irq_exit_rcu */
	.byte 0x09, 0x74, 0xff, 0xa7, 0x93, 0xd1, 0x99, 0x72, 0x63, 0x75	/* t__irq_exit_rcu */
	.byte 0x0c, 0xc6, 0x72, 0xd4, 0x5f, 0x6b, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71, 0x64	/* t__pfx_run_ksoftirqd */
	.byte 0x0b, 0xea, 0xd4, 0x5f, 0x6b, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71, 0x64	/* trun_ksoftirqd */
	.byte 0x0f, 0x29, 0x5f, 0xdb, 0x16, 0xd3, 0xf9, 0x73, 0x7e, 0x64, 0x75, 0xb3, 0xfe, 0x6d, 0xa5, 0x6e	/* t__pfx___tasklet_schedule_common */
	.byte 0x0f, 0x74, 0xff, 0xdb, 0x16, 0xd3, 0xf9, 0x73, 0x7e, 0x64, 0x75, 0xb3, 0xfe, 0x6d, 0xa5, 0x6e	/* t__tasklet_schedule_common */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0xdb, 0x16, 0xd3, 0xf9, 0x68, 0x69, 0xf6, 0x7e, 0x64, 0x75, 0xd3	/* T__pfx___tasklet_hi_schedule */
	.byte 0x0c, 0x2f, 0xdb, 0x16, 0xd3, 0xf9, 0x68, 0x69, 0xf6, 0x7e, 0x64, 0x75, 0xd3	/* T__tasklet_hi_schedule */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0xdb, 0x16, 0xd3, 0xf9, 0x73, 0x7e, 0x64, 0x75, 0xd3	/* T__pfx___tasklet_schedule */
	.byte 0x0a, 0x2f, 0xdb, 0x16, 0xd3, 0xf9, 0x73, 0x7e, 0x64, 0x75, 0xd3	/* T__tasklet_schedule */
	.byte 0x0b, 0xc6, 0xdb, 0x0e, 0x6f, 0x76, 0xcf, 0xdb, 0x16, 0xd3, 0x74, 0x73	/* t__pfx_takeover_tasklets */
	.byte 0x0b, 0x74, 0xdb, 0x0e, 0x6f, 0x76, 0xcf, 0xdb, 0x16, 0xd3, 0x74, 0x73	/* ttakeover_tasklets */
	.byte 0x08, 0xbf, 0xa9, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* T__pfx_do_softirq */
	.byte 0x08, 0x54, 0xa9, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* Tdo_softirq */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0xc0, 0xe1, 0x5f, 0x62, 0x5b, 0xe8, 0x80, 0xb3, 0x0c	/* T__pfx___local_bh_enable_ip */
	.byte 0x0a, 0x2f, 0xc0, 0xe1, 0x5f, 0x62, 0x5b, 0xe8, 0x80, 0xb3, 0x0c	/* T__local_bh_enable_ip */
	.byte 0x08, 0xbf, 0xa7, 0x93, 0x1e, 0xcf, 0x72, 0x63, 0x75	/* T__pfx_irq_enter_rcu */
	.byte 0x08, 0x54, 0xa7, 0x93, 0x1e, 0xcf, 0x72, 0x63, 0x75	/* Tirq_enter_rcu */
	.byte 0x05, 0xbf, 0xa7, 0x93, 0x1e, 0xee	/* T__pfx_irq_enter */
	.byte 0x05, 0x54, 0xa7, 0x93, 0x1e, 0xee	/* Tirq_enter */
	.byte 0x08, 0xbf, 0xa7, 0x93, 0xd1, 0x99, 0x72, 0x63, 0x75	/* T__pfx_irq_exit_rcu */
	.byte 0x08, 0x54, 0xa7, 0x93, 0xd1, 0x99, 0x72, 0x63, 0x75	/* Tirq_exit_rcu */
	.byte 0x05, 0xbf, 0xa7, 0x93, 0xd1, 0xe4	/* T__pfx_irq_exit */
	.byte 0x05, 0x54, 0xa7, 0x93, 0xd1, 0xe4	/* Tirq_exit */
	.byte 0x0f, 0xbf, 0xb5, 0xab, 0xfa, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xa7, 0x71, 0x6f, 0x66, 0x66	/* T__pfx_raise_softirq_irqoff */
	.byte 0x0f, 0x54, 0xb5, 0xab, 0xfa, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xa7, 0x71, 0x6f, 0x66, 0x66	/* Traise_softirq_irqoff */
	.byte 0x0a, 0xbf, 0xb5, 0xab, 0xfa, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* T__pfx_raise_softirq */
	.byte 0x0a, 0x54, 0xb5, 0xab, 0xfa, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* Traise_softirq */
	.byte 0x11, 0x3f, 0xff, 0x5f, 0xb5, 0xab, 0xfa, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xa7, 0x71, 0x6f, 0x66, 0x66	/* T__pfx___raise_softirq_irqoff */
	.byte 0x0f, 0x2f, 0xb5, 0xab, 0xfa, 0x73, 0x6f, 0x66, 0xc2, 0x72, 0x93, 0xa7, 0x71, 0x6f, 0x66, 0x66	/* T__raise_softirq_irqoff */
	.byte 0x09, 0xbf, 0x81, 0xe8, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* T__pfx_open_softirq */
	.byte 0x09, 0x54, 0x81, 0xe8, 0xf6, 0x6f, 0x66, 0xc2, 0x72, 0x71	/* Topen_softirq */
	.byte 0x06, 0xc6, 0x72, 0xf6, 0xdb, 0x72, 0x74	/* t__pfx_r_start */
	.byte 0x05, 0xea, 0xf6, 0xdb, 0x72, 0x74	/* tr_start */
	.byte 0x05, 0xc6, 0x72, 0x5f, 0x6e, 0x97	/* t__pfx_r_next */
	.byte 0x04, 0xea, 0x5f, 0x6e, 0x97	/* tr_next */
	.byte 0x05, 0xc6, 0x72, 0xf6, 0xac, 0x70	/* t__pfx_r_stop */
	.byte 0x04, 0xea, 0xf6, 0xac, 0x70	/* tr_stop */
	.byte 0x0b, 0x29, 0x5f, 0xf8, 0x8e, 0x3b, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* t__pfx___request_resource */
	.byte 0x0b, 0x74, 0xff, 0xf8, 0x8e, 0x3b, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* t__request_resource */
	.byte 0x0b, 0x29, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* t__pfx___release_resource */
	.byte 0x0b, 0x74, 0xff, 0xf8, 0xd3, 0x96, 0xfa, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* t__release_resource */
	.byte 0x0a, 0xbf, 0xf8, 0xd3, 0x96, 0xfa, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* T__pfx_release_resource */
	.byte 0x0a, 0x54, 0xf8, 0xd3, 0x96, 0xfa, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* Trelease_resource */
	.byte 0x0b, 0xc6, 0x66, 0xf0, 0xe5, 0x6e, 0xd1, 0xf9, 0xd9, 0xbd, 0xcd, 0x3d	/* t__pfx_find_next_iomem_res */
	.byte 0x0b, 0x74, 0x66, 0xf0, 0xe5, 0x6e, 0xd1, 0xf9, 0xd9, 0xbd, 0xcd, 0x3d	/* tfind_next_iomem_res */
	.byte 0x0d, 0x29, 0x5f, 0x77, 0xe1, 0xd8, 0xd9, 0xbd, 0xcd, 0xf8, 0xe0, 0xe6, 0x73, 0x63	/* t__pfx___walk_iomem_res_desc */
	.byte 0x0d, 0x74, 0xff, 0x77, 0xe1, 0xd8, 0xd9, 0xbd, 0xcd, 0xf8, 0xe0, 0xe6, 0x73, 0x63	/* t__walk_iomem_res_desc */
	.byte 0x0c, 0xbf, 0x77, 0xe1, 0xd8, 0xd9, 0xbd, 0xcd, 0xf8, 0xe0, 0xe6, 0x73, 0x63	/* T__pfx_walk_iomem_res_desc */
	.byte 0x0c, 0x54, 0x77, 0xe1, 0xd8, 0xd9, 0xbd, 0xcd, 0xf8, 0xe0, 0xe6, 0x73, 0x63	/* Twalk_iomem_res_desc */
	.byte 0x06, 0x29, 0x5f, 0x69, 0xe0, 0xb5, 0x6d	/* t__pfx___is_ram */
	.byte 0x06, 0x74, 0xff, 0x69, 0xe0, 0xb5, 0x6d	/* t__is_ram */
	.byte 0x09, 0xbf, 0xf8, 0xa5, 0x22, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* T__pfx_remove_resource */
	.byte 0x09, 0x54, 0xf8, 0xa5, 0x22, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* Tremove_resource */
	.byte 0x0b, 0x29, 0x5f, 0xc7, 0x6a, 0x5d, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* t__pfx___adjust_resource */
	.byte 0x0b, 0x74, 0xff, 0xc7, 0x6a, 0x5d, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* t__adjust_resource */
	.byte 0x0a, 0xbf, 0xc7, 0x6a, 0x5d, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* T__pfx_adjust_resource */
	.byte 0x0a, 0x54, 0xc7, 0x6a, 0x5d, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* Tadjust_resource */
	.byte 0x12, 0xa8, 0x95, 0xd6, 0x65, 0xcd, 0xb5, 0xcd, 0x3d, 0x6f, 0x1d, 0x63, 0x65, 0xe0, 0x6d, 0xee, 0xda, 0x80, 0xd3	/* t__pfx_system_ram_resources_mergeable */
	.byte 0x12, 0x74, 0xc1, 0xd6, 0x65, 0xcd, 0xb5, 0xcd, 0x3d, 0x6f, 0x1d, 0x63, 0x65, 0xe0, 0x6d, 0xee, 0xda, 0x80, 0xd3	/* tsystem_ram_resources_mergeable */
	.byte 0x0c, 0xc6, 0xd2, 0xcd, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0xf8, 0xd3, 0x61, 0xc9	/* t__pfx_devm_resource_release */
	.byte 0x0c, 0x74, 0xd2, 0xcd, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0xf8, 0xd3, 0x61, 0xc9	/* tdevm_resource_release */
	.byte 0x0b, 0xc6, 0xd2, 0xcd, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x6d, 0xe9, 0xd0	/* t__pfx_devm_resource_match */
	.byte 0x0b, 0x74, 0xd2, 0xcd, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x6d, 0xe9, 0xd0	/* tdevm_resource_match */
	.byte 0x09, 0xc6, 0xd2, 0xcd, 0x9f, 0xd9, 0x7c, 0x6d, 0xe9, 0xd0	/* t__pfx_devm_region_match */
	.byte 0x09, 0x74, 0xd2, 0xcd, 0x9f, 0xd9, 0x7c, 0x6d, 0xe9, 0xd0	/* tdevm_region_match */
	.byte 0x04, 0xc6, 0x72, 0xf6, 0x26	/* t__pfx_r_show */
	.byte 0x03, 0xea, 0xf6, 0x26	/* tr_show */
	.byte 0x0f, 0x29, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0xd0, 0x69, 0x6c, 0xe5, 0x3d, 0x6f, 0x1d, 0x63, 0x3b	/* t__pfx___release_child_resources */
	.byte 0x0f, 0x74, 0xff, 0xf8, 0xd3, 0x96, 0xfa, 0xd0, 0x69, 0x6c, 0xe5, 0x3d, 0x6f, 0x1d, 0x63, 0x3b	/* t__release_child_resources */
	.byte 0x0b, 0x29, 0x5f, 0xf0, 0x73, 0xee, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* t__pfx___insert_resource */
	.byte 0x0b, 0x74, 0xff, 0xf0, 0x73, 0xee, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* t__insert_resource */
	.byte 0x12, 0xbf, 0xf0, 0x73, 0xee, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0xd1, 0x70, 0xcc, 0xe5, 0xac, 0x5f, 0x66, 0xe4	/* T__pfx_insert_resource_expand_to_fit */
	.byte 0x12, 0x54, 0xf0, 0x73, 0xee, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0xd1, 0x70, 0xcc, 0xe5, 0xac, 0x5f, 0x66, 0xe4	/* Tinsert_resource_expand_to_fit */
	.byte 0x08, 0xc6, 0x87, 0xfa, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* t__pfx_free_resource */
	.byte 0x08, 0x74, 0x87, 0xfa, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* tfree_resource */
	.byte 0x0b, 0xc6, 0xf8, 0xa5, 0x22, 0x87, 0xfa, 0xbd, 0xcd, 0x9f, 0xd9, 0x6e	/* t__pfx_remove_free_mem_region */
	.byte 0x0b, 0x74, 0xf8, 0xa5, 0x22, 0x87, 0xfa, 0xbd, 0xcd, 0x9f, 0xd9, 0x6e	/* tremove_free_mem_region */
	.byte 0x0b, 0xbf, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x6c, 0xab, 0xf9, 0x87, 0x65	/* T__pfx_resource_list_free */
	.byte 0x0b, 0x54, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x6c, 0xab, 0xf9, 0x87, 0x65	/* Tresource_list_free */
	.byte 0x0c, 0x29, 0x5f, 0xf8, 0x8e, 0x3b, 0xf9, 0x9f, 0xd9, 0x7c, 0x3c, 0x65, 0x64	/* t__pfx___request_region_locked */
	.byte 0x0c, 0x74, 0xff, 0xf8, 0x8e, 0x3b, 0xf9, 0x9f, 0xd9, 0x7c, 0x3c, 0x65, 0x64	/* t__request_region_locked */
	.byte 0x0a, 0x3f, 0xff, 0x5f, 0xf8, 0xd3, 0x96, 0xfa, 0x9f, 0xd9, 0x6e	/* T__pfx___release_region */
	.byte 0x08, 0x2f, 0xf8, 0xd3, 0x96, 0xfa, 0x9f, 0xd9, 0x6e	/* T__release_region */
	.byte 0x0a, 0xc6, 0xd2, 0xcd, 0x9f, 0xd9, 0x7c, 0xf8, 0xd3, 0x61, 0xc9	/* t__pfx_devm_region_release */
	.byte 0x0a, 0x74, 0xd2, 0xcd, 0x9f, 0xd9, 0x7c, 0xf8, 0xd3, 0x61, 0xc9	/* tdevm_region_release */
	.byte 0x0c, 0xbf, 0xd2, 0xcd, 0xf8, 0xd3, 0x96, 0xfa, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* T__pfx_devm_release_resource */
	.byte 0x0c, 0x54, 0xd2, 0xcd, 0xf8, 0xd3, 0x96, 0xfa, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* Tdevm_release_resource */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0xd2, 0xcd, 0xf8, 0xd3, 0x96, 0xfa, 0x9f, 0xd9, 0x6e	/* T__pfx___devm_release_region */
	.byte 0x0a, 0x2f, 0xd2, 0xcd, 0xf8, 0xd3, 0x96, 0xfa, 0x9f, 0xd9, 0x6e	/* T__devm_release_region */
	.byte 0x0d, 0xc6, 0xd9, 0xbd, 0xcd, 0x66, 0xe0, 0xf0, 0x99, 0x66, 0xe0, 0x98, 0x74, 0x97	/* t__pfx_iomem_fs_init_fs_context */
	.byte 0x0d, 0x74, 0xd9, 0xbd, 0xcd, 0x66, 0xe0, 0xf0, 0x99, 0x66, 0xe0, 0x98, 0x74, 0x97	/* tiomem_fs_init_fs_context */
	.byte 0x10, 0x29, 0x5f, 0x9f, 0xd9, 0x7c, 0xf0, 0x74, 0xee, 0xc9, 0x7b, 0x73, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx___region_intersects.isra.0 */
	.byte 0x10, 0x74, 0xff, 0x9f, 0xd9, 0x7c, 0xf0, 0x74, 0xee, 0xc9, 0x7b, 0x73, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__region_intersects.isra.0 */
	.byte 0x0a, 0xbf, 0x9f, 0xd9, 0x7c, 0xf0, 0x74, 0xee, 0xc9, 0x7b, 0x73	/* T__pfx_region_intersects */
	.byte 0x0a, 0x54, 0x9f, 0xd9, 0x7c, 0xf0, 0x74, 0xee, 0xc9, 0x7b, 0x73	/* Tregion_intersects */
	.byte 0x0a, 0x3f, 0xff, 0x5f, 0xf8, 0x8e, 0x3b, 0xf9, 0x9f, 0xd9, 0x6e	/* T__pfx___request_region */
	.byte 0x08, 0x2f, 0xf8, 0x8e, 0x3b, 0xf9, 0x9f, 0xd9, 0x6e	/* T__request_region */
	.byte 0x0c, 0x3f, 0xff, 0x5f, 0xd2, 0xcd, 0xf8, 0x8e, 0x3b, 0xf9, 0x9f, 0xd9, 0x6e	/* T__pfx___devm_request_region */
	.byte 0x0a, 0x2f, 0xd2, 0xcd, 0xf8, 0x8e, 0x3b, 0xf9, 0x9f, 0xd9, 0x6e	/* T__devm_request_region */
	.byte 0x09, 0xc6, 0xb2, 0x87, 0xfa, 0xbd, 0xcd, 0x9f, 0xd9, 0x6e	/* t__pfx_get_free_mem_region */
	.byte 0x09, 0x74, 0xb2, 0x87, 0xfa, 0xbd, 0xcd, 0x9f, 0xd9, 0x6e	/* tget_free_mem_region */
	.byte 0x0a, 0xbf, 0x08, 0xd5, 0x87, 0xfa, 0xbd, 0xcd, 0x9f, 0xd9, 0x6e	/* T__pfx_alloc_free_mem_region */
	.byte 0x0a, 0x54, 0x08, 0xd5, 0x87, 0xfa, 0xbd, 0xcd, 0x9f, 0xd9, 0x6e	/* Talloc_free_mem_region */
	.byte 0x0c, 0xbf, 0xf8, 0x8e, 0x3b, 0xf9, 0x87, 0xfa, 0xbd, 0xcd, 0x9f, 0xd9, 0x6e	/* T__pfx_request_free_mem_region */
	.byte 0x0c, 0x54, 0xf8, 0x8e, 0x3b, 0xf9, 0x87, 0xfa, 0xbd, 0xcd, 0x9f, 0xd9, 0x6e	/* Trequest_free_mem_region */
	.byte 0x0e, 0xbf, 0xd2, 0xcd, 0xf8, 0x8e, 0x3b, 0xf9, 0x87, 0xfa, 0xbd, 0xcd, 0x9f, 0xd9, 0x6e	/* T__pfx_devm_request_free_mem_region */
	.byte 0x0e, 0x54, 0xd2, 0xcd, 0xf8, 0x8e, 0x3b, 0xf9, 0x87, 0xfa, 0xbd, 0xcd, 0x9f, 0xd9, 0x6e	/* Tdevm_request_free_mem_region */
	.byte 0x0f, 0xbf, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x6c, 0xab, 0xf9, 0x63, 0xf8, 0xa1, 0xe8, 0xea, 0x79	/* T__pfx_resource_list_create_entry */
	.byte 0x0f, 0x54, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x6c, 0xab, 0xf9, 0x63, 0xf8, 0xa1, 0xe8, 0xea, 0x79	/* Tresource_list_create_entry */
	.byte 0x0e, 0xbf, 0xf8, 0xd3, 0x96, 0xfa, 0xd0, 0x69, 0x6c, 0xe5, 0x3d, 0x6f, 0x1d, 0x63, 0x3b	/* T__pfx_release_child_resources */
	.byte 0x0e, 0x54, 0xf8, 0xd3, 0x96, 0xfa, 0xd0, 0x69, 0x6c, 0xe5, 0x3d, 0x6f, 0x1d, 0x63, 0x3b	/* Trelease_child_resources */
	.byte 0x0f, 0xbf, 0xf8, 0x8e, 0x3b, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x98, 0x66, 0x6c, 0xa3, 0x74	/* T__pfx_request_resource_conflict */
	.byte 0x0f, 0x54, 0xf8, 0x8e, 0x3b, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x98, 0x66, 0x6c, 0xa3, 0x74	/* Trequest_resource_conflict */
	.byte 0x0c, 0xbf, 0xd2, 0xcd, 0xf8, 0x8e, 0x3b, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* T__pfx_devm_request_resource */
	.byte 0x0c, 0x54, 0xd2, 0xcd, 0xf8, 0x8e, 0x3b, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* Tdevm_request_resource */
	.byte 0x0a, 0xbf, 0xf8, 0x8e, 0x3b, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* T__pfx_request_resource */
	.byte 0x0a, 0x54, 0xf8, 0x8e, 0x3b, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* Trequest_resource */
	.byte 0x0b, 0xbf, 0x77, 0xe1, 0x6b, 0x95, 0xd6, 0x65, 0xcd, 0xb5, 0xcd, 0x3d	/* T__pfx_walk_system_ram_res */
	.byte 0x0b, 0x54, 0x77, 0xe1, 0x6b, 0x95, 0xd6, 0x65, 0xcd, 0xb5, 0xcd, 0x3d	/* Twalk_system_ram_res */
	.byte 0x0e, 0xbf, 0x77, 0xe1, 0x6b, 0x95, 0xd6, 0x65, 0xcd, 0xb5, 0xcd, 0xf8, 0xe0, 0xf8, 0x76	/* T__pfx_walk_system_ram_res_rev */
	.byte 0x0e, 0x54, 0x77, 0xe1, 0x6b, 0x95, 0xd6, 0x65, 0xcd, 0xb5, 0xcd, 0xf8, 0xe0, 0xf8, 0x76	/* Twalk_system_ram_res_rev */
	.byte 0x07, 0xbf, 0x77, 0xe1, 0xd8, 0xbd, 0xcd, 0x3d	/* T__pfx_walk_mem_res */
	.byte 0x07, 0x54, 0x77, 0xe1, 0xd8, 0xbd, 0xcd, 0x3d	/* Twalk_mem_res */
	.byte 0x0d, 0xbf, 0x77, 0xe1, 0x6b, 0x95, 0xd6, 0x65, 0xcd, 0xb5, 0xcd, 0x72, 0xcc, 0xda	/* T__pfx_walk_system_ram_range */
	.byte 0x0d, 0x54, 0x77, 0xe1, 0x6b, 0x95, 0xd6, 0x65, 0xcd, 0xb5, 0xcd, 0x72, 0xcc, 0xda	/* Twalk_system_ram_range */
	.byte 0x09, 0x57, 0xec, 0xe7, 0x61, 0x21, 0x69, 0xe0, 0xb5, 0x6d	/* W__pfx_page_is_ram */
	.byte 0x08, 0x57, 0x70, 0x61, 0x21, 0x69, 0xe0, 0xb5, 0x6d	/* Wpage_is_ram */
	.byte 0x0e, 0x29, 0x5f, 0x66, 0xf0, 0xe5, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x73, 0x70, 0xeb, 0x65	/* t__pfx___find_resource_space */
	.byte 0x0e, 0x74, 0xff, 0x66, 0xf0, 0xe5, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x73, 0x70, 0xeb, 0x65	/* t__find_resource_space */
	.byte 0x0a, 0xc6, 0xf8, 0xe1, 0xc0, 0xa1, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* t__pfx_reallocate_resource */
	.byte 0x0a, 0x74, 0xf8, 0xe1, 0xc0, 0xa1, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* treallocate_resource */
	.byte 0x09, 0xbf, 0xe1, 0xc0, 0xa1, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* T__pfx_allocate_resource */
	.byte 0x09, 0x54, 0xe1, 0xc0, 0xa1, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* Tallocate_resource */
	.byte 0x0d, 0xbf, 0x66, 0xf0, 0xe5, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x73, 0x70, 0xeb, 0x65	/* T__pfx_find_resource_space */
	.byte 0x0d, 0x54, 0x66, 0xf0, 0xe5, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x73, 0x70, 0xeb, 0x65	/* Tfind_resource_space */
	.byte 0x0a, 0xbf, 0xdf, 0x6f, 0x6b, 0x3a, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* T__pfx_lookup_resource */
	.byte 0x0a, 0x54, 0xdf, 0x6f, 0x6b, 0x3a, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* Tlookup_resource */
	.byte 0x0f, 0xbf, 0xf0, 0x73, 0xee, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x98, 0x66, 0x6c, 0xa3, 0x74	/* T__pfx_insert_resource_conflict */
	.byte 0x0f, 0x54, 0xf0, 0x73, 0xee, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x98, 0x66, 0x6c, 0xa3, 0x74	/* Tinsert_resource_conflict */
	.byte 0x0a, 0xbf, 0xf0, 0x73, 0xee, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* T__pfx_insert_resource */
	.byte 0x0a, 0x54, 0xf0, 0x73, 0xee, 0xf9, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* Tinsert_resource */
	.byte 0x0b, 0xbf, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0xe1, 0x2c, 0x6e, 0x6d, 0x1e	/* T__pfx_resource_alignment */
	.byte 0x0b, 0x54, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0xe1, 0x2c, 0x6e, 0x6d, 0x1e	/* Tresource_alignment */
	.byte 0x09, 0xbf, 0xd9, 0xbd, 0xcd, 0xb2, 0x0a, 0x70, 0xf0, 0x67	/* T__pfx_iomem_get_mapping */
	.byte 0x09, 0x54, 0xd9, 0xbd, 0xcd, 0xb2, 0x0a, 0x70, 0xf0, 0x67	/* Tiomem_get_mapping */
	.byte 0x10, 0xbf, 0xf8, 0xd3, 0x96, 0xfa, 0xbd, 0xcd, 0x9f, 0xd9, 0x7c, 0xc7, 0x6a, 0x5d, 0xdb, 0x62, 0xd3	/* T__pfx_release_mem_region_adjustable */
	.byte 0x10, 0x54, 0xf8, 0xd3, 0x96, 0xfa, 0xbd, 0xcd, 0x9f, 0xd9, 0x7c, 0xc7, 0x6a, 0x5d, 0xdb, 0x62, 0xd3	/* Trelease_mem_region_adjustable */
	.byte 0x0f, 0xbf, 0x6d, 0xee, 0x21, 0xc1, 0xd6, 0x65, 0xcd, 0xb5, 0xcd, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* T__pfx_merge_system_ram_resource */
	.byte 0x0f, 0x54, 0x6d, 0xee, 0x21, 0xc1, 0xd6, 0x65, 0xcd, 0xb5, 0xcd, 0x3d, 0x6f, 0x1d, 0x63, 0x65	/* Tmerge_system_ram_resource */
	.byte 0x0c, 0xbf, 0xd9, 0xbd, 0xcd, 0x0a, 0xf6, 0xcc, 0xe4, 0xc5, 0x7e, 0x63, 0x6b	/* T__pfx_iomem_map_sanity_check */
	.byte 0x0c, 0x54, 0xd9, 0xbd, 0xcd, 0x0a, 0xf6, 0xcc, 0xe4, 0xc5, 0x7e, 0x63, 0x6b	/* Tiomem_map_sanity_check */
	.byte 0x0f, 0xbf, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x69, 0xe0, 0xd1, 0x63, 0x6c, 0x5d, 0x69, 0x76, 0x65	/* T__pfx_resource_is_exclusive */
	.byte 0x0f, 0x54, 0x3d, 0x6f, 0x1d, 0x63, 0xfa, 0x69, 0xe0, 0xd1, 0x63, 0x6c, 0x5d, 0x69, 0x76, 0x65	/* Tresource_is_exclusive */
	.byte 0x0d, 0xbf, 0xd9, 0xbd, 0xcd, 0x69, 0xe0, 0xd1, 0x63, 0x6c, 0x5d, 0x69, 0x76, 0x65	/* T__pfx_iomem_is_exclusive */
	.byte 0x0d, 0x54, 0xd9, 0xbd, 0xcd, 0x69, 0xe0, 0xd1, 0x63, 0x6c, 0x5d, 0x69, 0x76, 0x65	/* Tiomem_is_exclusive */
	.byte 0x0a, 0xa8, 0x25, 0x63, 0xf6, 0x6b, 0x0c, 0xf6, 0x70, 0xeb, 0x3b	/* t__pfx_proc_skip_spaces */
	.byte 0x0a, 0x74, 0x9b, 0x63, 0xf6, 0x6b, 0x0c, 0xf6, 0x70, 0xeb, 0x3b	/* tproc_skip_spaces */
	.byte 0x0c, 0xc6, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x98, 0x76	/* t__pfx_do_proc_dointvec_conv */
	.byte 0x0c, 0x74, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x98, 0x76	/* tdo_proc_dointvec_conv */
	.byte 0x0d, 0xc6, 0xa9, 0x25, 0xd5, 0xa9, 0x75, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x98, 0x76	/* t__pfx_do_proc_douintvec_conv */
	.byte 0x0d, 0x74, 0xa9, 0x25, 0xd5, 0xa9, 0x75, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x98, 0x76	/* tdo_proc_douintvec_conv */
	.byte 0x11, 0xc6, 0xa9, 0x25, 0xd5, 0xa9, 0x75, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x1a, 0x98, 0x76	/* t__pfx_do_proc_douintvec_minmax_conv */
	.byte 0x11, 0x74, 0xa9, 0x25, 0xd5, 0xa9, 0x75, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x1a, 0x98, 0x76	/* tdo_proc_douintvec_minmax_conv */
	.byte 0x12, 0xc6, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6a, 0x69, 0x66, 0xb8, 0x65, 0xe0, 0x98, 0x76	/* t__pfx_do_proc_dointvec_jiffies_conv */
	.byte 0x12, 0x74, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6a, 0x69, 0x66, 0xb8, 0x65, 0xe0, 0x98, 0x76	/* tdo_proc_dointvec_jiffies_conv */
	.byte 0x09, 0xa8, 0x25, 0x63, 0xe7, 0x75, 0xf9, 0xdf, 0x6e, 0x67	/* t__pfx_proc_put_long */
	.byte 0x09, 0x74, 0x9b, 0x63, 0xe7, 0x75, 0xf9, 0xdf, 0x6e, 0x67	/* tproc_put_long */
	.byte 0x14, 0xc6, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xe0, 0x6a, 0x69, 0x66, 0xb8, 0x65, 0xe0, 0x98, 0x76	/* t__pfx_do_proc_dointvec_ms_jiffies_conv */
	.byte 0x14, 0x74, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xe0, 0x6a, 0x69, 0x66, 0xb8, 0x65, 0xe0, 0x98, 0x76	/* tdo_proc_dointvec_ms_jiffies_conv */
	.byte 0x18, 0xc6, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xe0, 0x6a, 0x69, 0x66, 0xb8, 0x65, 0xe0, 0x6d, 0xf0, 0xdd, 0x1a, 0x98, 0x76	/* t__pfx_do_proc_dointvec_ms_jiffies_minmax_conv */
	.byte 0x18, 0x74, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xe0, 0x6a, 0x69, 0x66, 0xb8, 0x65, 0xe0, 0x6d, 0xf0, 0xdd, 0x1a, 0x98, 0x76	/* tdo_proc_dointvec_ms_jiffies_minmax_conv */
	.byte 0x17, 0xc6, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x5d, 0xee, 0x68, 0x7a, 0x5f, 0x6a, 0x69, 0x66, 0xb8, 0x65, 0xe0, 0x98, 0x76	/* t__pfx_do_proc_dointvec_userhz_jiffies_conv */
	.byte 0x17, 0x74, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x5d, 0xee, 0x68, 0x7a, 0x5f, 0x6a, 0x69, 0x66, 0xb8, 0x65, 0xe0, 0x98, 0x76	/* tdo_proc_dointvec_userhz_jiffies_conv */
	.byte 0x0e, 0xa8, 0x25, 0xd5, 0xb2, 0xdf, 0x6e, 0x67, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* t__pfx_proc_get_long.constprop.0 */
	.byte 0x0e, 0x74, 0x9b, 0xd5, 0xb2, 0xdf, 0x6e, 0x67, 0x2e, 0x98, 0xd6, 0x9b, 0x70, 0x2e, 0x30	/* tproc_get_long.constprop.0 */
	.byte 0x0b, 0x3f, 0x25, 0xd5, 0xa9, 0x5f, 0x6c, 0xca, 0x21, 0x62, 0xe4, 0x0a	/* T__pfx_proc_do_large_bitmap */
	.byte 0x0b, 0x54, 0x9b, 0xd5, 0xa9, 0x5f, 0x6c, 0xca, 0x21, 0x62, 0xe4, 0x0a	/* Tproc_do_large_bitmap */
	.byte 0x18, 0xa8, 0x25, 0xd5, 0xb8, 0x72, 0x73, 0xf9, 0x70, 0x6f, 0xe0, 0xb6, 0x7c, 0x7a, 0xee, 0x6f, 0x5f, 0x2c, 0xb6, 0xf8, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_proc_first_pos_non_zero_ignore.isra.0 */
	.byte 0x18, 0x74, 0x9b, 0xd5, 0xb8, 0x72, 0x73, 0xf9, 0x70, 0x6f, 0xe0, 0xb6, 0x7c, 0x7a, 0xee, 0x6f, 0x5f, 0x2c, 0xb6, 0xf8, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tproc_first_pos_non_zero_ignore.isra.0 */
	.byte 0x0b, 0x29, 0x5f, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0x63	/* t__pfx___do_proc_dointvec */
	.byte 0x0b, 0x74, 0xff, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0x63	/* t__do_proc_dointvec */
	.byte 0x09, 0xa8, 0x25, 0xd5, 0xa9, 0x5f, 0x63, 0xc7, 0xe7, 0x89	/* t__pfx_proc_do_cad_pid */
	.byte 0x09, 0x74, 0x9b, 0xd5, 0xa9, 0x5f, 0x63, 0xc7, 0xe7, 0x89	/* tproc_do_cad_pid */
	.byte 0x10, 0x3f, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xe0, 0x6a, 0x69, 0x66, 0xb8, 0x3b	/* T__pfx_proc_dointvec_ms_jiffies */
	.byte 0x10, 0x54, 0x9b, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xe0, 0x6a, 0x69, 0x66, 0xb8, 0x3b	/* Tproc_dointvec_ms_jiffies */
	.byte 0x13, 0x3f, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x5d, 0xee, 0x68, 0x7a, 0x5f, 0x6a, 0x69, 0x66, 0xb8, 0x3b	/* T__pfx_proc_dointvec_userhz_jiffies */
	.byte 0x13, 0x54, 0x9b, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x5d, 0xee, 0x68, 0x7a, 0x5f, 0x6a, 0x69, 0x66, 0xb8, 0x3b	/* Tproc_dointvec_userhz_jiffies */
	.byte 0x0e, 0x3f, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6a, 0x69, 0x66, 0xb8, 0x3b	/* T__pfx_proc_dointvec_jiffies */
	.byte 0x0e, 0x54, 0x9b, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6a, 0x69, 0x66, 0xb8, 0x3b	/* Tproc_dointvec_jiffies */
	.byte 0x0e, 0xa8, 0x95, 0x73, 0x72, 0x71, 0x95, 0x73, 0x7b, 0xc3, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* t__pfx_sysrq_sysctl_handler */
	.byte 0x0e, 0x74, 0xc1, 0x73, 0x72, 0x71, 0x95, 0x73, 0x7b, 0xc3, 0x68, 0xcc, 0x64, 0x6c, 0xee	/* tsysrq_sysctl_handler */
	.byte 0x0d, 0x3f, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x78	/* T__pfx_proc_dointvec_minmax */
	.byte 0x0d, 0x54, 0x9b, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x78	/* Tproc_dointvec_minmax */
	.byte 0x09, 0x3f, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0x63	/* T__pfx_proc_dointvec */
	.byte 0x09, 0x54, 0x9b, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0x63	/* Tproc_dointvec */
	.byte 0x0c, 0x29, 0x5f, 0xa9, 0x25, 0xd5, 0xa9, 0x75, 0xf0, 0x74, 0x76, 0x65, 0x63	/* t__pfx___do_proc_douintvec */
	.byte 0x0c, 0x74, 0xff, 0xa9, 0x25, 0xd5, 0xa9, 0x75, 0xf0, 0x74, 0x76, 0x65, 0x63	/* t__do_proc_douintvec */
	.byte 0x0d, 0x3f, 0x25, 0xd5, 0xa9, 0x75, 0x38, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x78	/* T__pfx_proc_dou8vec_minmax */
	.byte 0x0d, 0x54, 0x9b, 0xd5, 0xa9, 0x75, 0x38, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x78	/* Tproc_dou8vec_minmax */
	.byte 0x0e, 0x3f, 0x25, 0xd5, 0xa9, 0x75, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x78	/* T__pfx_proc_douintvec_minmax */
	.byte 0x0e, 0x54, 0x9b, 0xd5, 0xa9, 0x75, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x78	/* Tproc_douintvec_minmax */
	.byte 0x0a, 0x3f, 0x25, 0xd5, 0xa9, 0x75, 0xf0, 0x74, 0x76, 0x65, 0x63	/* T__pfx_proc_douintvec */
	.byte 0x0a, 0x54, 0x9b, 0xd5, 0xa9, 0x75, 0xf0, 0x74, 0x76, 0x65, 0x63	/* Tproc_douintvec */
	.byte 0x11, 0x29, 0x5f, 0xa9, 0x25, 0xd5, 0xa9, 0x75, 0xdf, 0x6e, 0x67, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x78	/* t__pfx___do_proc_doulongvec_minmax */
	.byte 0x11, 0x74, 0xff, 0xa9, 0x25, 0xd5, 0xa9, 0x75, 0xdf, 0x6e, 0x67, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x78	/* t__do_proc_doulongvec_minmax */
	.byte 0x17, 0x3f, 0x25, 0xd5, 0xa9, 0x75, 0xdf, 0x6e, 0x67, 0x76, 0x65, 0xd5, 0x6d, 0xe0, 0x6a, 0x69, 0x66, 0xb8, 0x65, 0xe0, 0x6d, 0xf0, 0xdd, 0x78	/* T__pfx_proc_doulongvec_ms_jiffies_minmax */
	.byte 0x17, 0x54, 0x9b, 0xd5, 0xa9, 0x75, 0xdf, 0x6e, 0x67, 0x76, 0x65, 0xd5, 0x6d, 0xe0, 0x6a, 0x69, 0x66, 0xb8, 0x65, 0xe0, 0x6d, 0xf0, 0xdd, 0x78	/* Tproc_doulongvec_ms_jiffies_minmax */
	.byte 0x0f, 0x3f, 0x25, 0xd5, 0xa9, 0x75, 0xdf, 0x6e, 0x67, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x78	/* T__pfx_proc_doulongvec_minmax */
	.byte 0x0f, 0x54, 0x9b, 0xd5, 0xa9, 0x75, 0xdf, 0x6e, 0x67, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x78	/* Tproc_doulongvec_minmax */
	.byte 0x08, 0x3f, 0x25, 0xd5, 0xa9, 0x73, 0xea, 0xf0, 0x67	/* T__pfx_proc_dostring */
	.byte 0x08, 0x54, 0x9b, 0xd5, 0xa9, 0x73, 0xea, 0xf0, 0x67	/* Tproc_dostring */
	.byte 0x07, 0x3f, 0x25, 0xd5, 0xa9, 0x62, 0x6f, 0x7f	/* T__pfx_proc_dobool */
	.byte 0x07, 0x54, 0x9b, 0xd5, 0xa9, 0x62, 0x6f, 0x7f	/* Tproc_dobool */
	.byte 0x06, 0xa8, 0x25, 0xd5, 0xdb, 0xf0, 0x74	/* t__pfx_proc_taint */
	.byte 0x06, 0x74, 0x9b, 0xd5, 0xdb, 0xf0, 0x74	/* tproc_taint */
	.byte 0x10, 0xc6, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x1a, 0x98, 0x76	/* t__pfx_do_proc_dointvec_minmax_conv */
	.byte 0x10, 0x74, 0xa9, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xf0, 0xdd, 0x1a, 0x98, 0x76	/* tdo_proc_dointvec_minmax_conv */
	.byte 0x0b, 0xbf, 0xa9, 0x25, 0xd5, 0xa9, 0x75, 0xf0, 0x74, 0x76, 0x65, 0x63	/* T__pfx_do_proc_douintvec */
	.byte 0x0b, 0x54, 0xa9, 0x25, 0xd5, 0xa9, 0x75, 0xf0, 0x74, 0x76, 0x65, 0x63	/* Tdo_proc_douintvec */
	.byte 0x15, 0x3f, 0x25, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xe0, 0x6a, 0x69, 0x66, 0xb8, 0x65, 0xe0, 0x6d, 0xf0, 0xdd, 0x78	/* T__pfx_proc_dointvec_ms_jiffies_minmax */
	.byte 0x15, 0x54, 0x9b, 0xd5, 0xa9, 0xf0, 0x74, 0x76, 0x65, 0xd5, 0x6d, 0xe0, 0x6a, 0x69, 0x66, 0xb8, 0x65, 0xe0, 0x6d, 0xf0, 0xdd, 0x78	/* Tproc_dointvec_ms_jiffies_minmax */
	.byte 0x0a, 0x3f, 0x25, 0xd5, 0xa9, 0x2a, 0xe9, 0x69, 0xd5, 0x0e, 0x79	/* T__pfx_proc_do_static_key */
	.byte 0x0a, 0x54, 0x9b, 0xd5, 0xa9, 0x2a, 0xe9, 0x69, 0xd5, 0x0e, 0x79	/* Tproc_do_static_key */
	.byte 0x0b, 0xc6, 0x63, 0x61, 0xe2, 0x76, 0xe1, 0x89, 0xa1, 0xdd, 0x67, 0xa3	/* t__pfx_cap_validate_magic */
	.byte 0x0a, 0x2d, 0x61, 0xe2, 0x76, 0xe1, 0x89, 0xa1, 0xdd, 0x67, 0xa3	/* tcap_validate_magic */
	.byte 0x0a, 0x29, 0x5f, 0xa9, 0x95, 0xe0, 0x63, 0x61, 0x70, 0xda, 0x74	/* t__pfx___do_sys_capget */
	.byte 0x0a, 0x74, 0xff, 0xa9, 0x95, 0xe0, 0x63, 0x61, 0x70, 0xda, 0x74	/* t__do_sys_capget */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x63, 0x61, 0x70, 0xda, 0x74	/* T__pfx___ia32_sys_capget */
	.byte 0x0c, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x63, 0x61, 0x70, 0xda, 0x74	/* T__ia32_sys_capget */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x63, 0x61, 0x70, 0xda, 0x74	/* T__pfx___x64_sys_capget */
	.byte 0x0b, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x63, 0x61, 0x70, 0xda, 0x74	/* T__x64_sys_capget */
	.byte 0x0a, 0x29, 0x5f, 0xa9, 0x95, 0xe0, 0x63, 0x61, 0x70, 0xc9, 0x74	/* t__pfx___do_sys_capset */
	.byte 0x0a, 0x74, 0xff, 0xa9, 0x95, 0xe0, 0x63, 0x61, 0x70, 0xc9, 0x74	/* t__do_sys_capset */
	.byte 0x0e, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x63, 0x61, 0x70, 0xc9, 0x74	/* T__pfx___ia32_sys_capset */
	.byte 0x0c, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0xe0, 0x63, 0x61, 0x70, 0xc9, 0x74	/* T__ia32_sys_capset */
	.byte 0x0d, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x63, 0x61, 0x70, 0xc9, 0x74	/* T__pfx___x64_sys_capset */
	.byte 0x0b, 0x2f, 0x78, 0x36, 0x34, 0x95, 0xe0, 0x63, 0x61, 0x70, 0xc9, 0x74	/* T__x64_sys_capset */
	.byte 0x0a, 0xbf, 0xb8, 0xb3, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0xd3	/* T__pfx_file_ns_capable */
	.byte 0x0a, 0x54, 0xb8, 0xb3, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0xd3	/* Tfile_ns_capable */
	.byte 0x0c, 0xc6, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0xb3, 0xfe, 0x6d, 0xa5, 0x6e	/* t__pfx_ns_capable_common */
	.byte 0x0c, 0x74, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0xb3, 0xfe, 0x6d, 0xa5, 0x6e	/* tns_capable_common */
	.byte 0x06, 0xbf, 0x63, 0x61, 0x70, 0x80, 0xd3	/* T__pfx_capable */
	.byte 0x06, 0x54, 0x63, 0x61, 0x70, 0x80, 0xd3	/* Tcapable */
	.byte 0x0b, 0xbf, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0xb3, 0xc9, 0xc2, 0x64	/* T__pfx_ns_capable_setid */
	.byte 0x0b, 0x54, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0xb3, 0xc9, 0xc2, 0x64	/* Tns_capable_setid */
	.byte 0x0d, 0xbf, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0xb3, 0xb6, 0x61, 0x75, 0x64, 0xe4	/* T__pfx_ns_capable_noaudit */
	.byte 0x0d, 0x54, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0xb3, 0xb6, 0x61, 0x75, 0x64, 0xe4	/* Tns_capable_noaudit */
	.byte 0x08, 0xbf, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0xd3	/* T__pfx_ns_capable */
	.byte 0x08, 0x54, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0xd3	/* Tns_capable */
	.byte 0x0e, 0xbf, 0x68, 0x61, 0xe0, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0x69, 0x6c, 0xe4, 0x79	/* T__pfx_has_ns_capability */
	.byte 0x0e, 0x54, 0x68, 0x61, 0xe0, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0x69, 0x6c, 0xe4, 0x79	/* Thas_ns_capability */
	.byte 0x0c, 0xbf, 0x68, 0x61, 0xe0, 0x63, 0x61, 0x70, 0x80, 0x69, 0x6c, 0xe4, 0x79	/* T__pfx_has_capability */
	.byte 0x0c, 0x54, 0x68, 0x61, 0xe0, 0x63, 0x61, 0x70, 0x80, 0x69, 0x6c, 0xe4, 0x79	/* Thas_capability */
	.byte 0x13, 0xbf, 0x68, 0x61, 0xe0, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0x69, 0x6c, 0xe4, 0xc5, 0xb6, 0x61, 0x75, 0x64, 0xe4	/* T__pfx_has_ns_capability_noaudit */
	.byte 0x13, 0x54, 0x68, 0x61, 0xe0, 0x6e, 0xe0, 0x63, 0x61, 0x70, 0x80, 0x69, 0x6c, 0xe4, 0xc5, 0xb6, 0x61, 0x75, 0x64, 0xe4	/* Thas_ns_capability_noaudit */
	.byte 0x11, 0xbf, 0x68, 0x61, 0xe0, 0x63, 0x61, 0x70, 0x80, 0x69, 0x6c, 0xe4, 0xc5, 0xb6, 0x61, 0x75, 0x64, 0xe4	/* T__pfx_has_capability_noaudit */
	.byte 0x11, 0x54, 0x68, 0x61, 0xe0, 0x63, 0x61, 0x70, 0x80, 0x69, 0x6c, 0xe4, 0xc5, 0xb6, 0x61, 0x75, 0x64, 0xe4	/* Thas_capability_noaudit */
	.byte 0x14, 0x3f, 0xe7, 0x72, 0x69, 0x76, 0x69, 0xd3, 0xda, 0xe5, 0x77, 0x72, 0xf9, 0xf0, 0x6f, 0x64, 0xfa, 0x75, 0x89, 0x67, 0x89	/* T__pfx_privileged_wrt_inode_uidgid */
	.byte 0x14, 0x54, 0x70, 0x72, 0x69, 0x76, 0x69, 0xd3, 0xda, 0xe5, 0x77, 0x72, 0xf9, 0xf0, 0x6f, 0x64, 0xfa, 0x75, 0x89, 0x67, 0x89	/* Tprivileged_wrt_inode_uidgid */
	.byte 0x11, 0xbf, 0x63, 0x61, 0x70, 0x80, 0xb3, 0x77, 0x72, 0xf9, 0xf0, 0x6f, 0x64, 0xfa, 0x75, 0x89, 0x67, 0x89	/* T__pfx_capable_wrt_inode_uidgid */
	.byte 0x11, 0x54, 0x63, 0x61, 0x70, 0x80, 0xb3, 0x77, 0x72, 0xf9, 0xf0, 0x6f, 0x64, 0xfa, 0x75, 0x89, 0x67, 0x89	/* Tcapable_wrt_inode_uidgid */
	.byte 0x09, 0x3f, 0xe7, 0xd7, 0xcf, 0x63, 0x61, 0x70, 0x80, 0xd3	/* T__pfx_ptracer_capable */
	.byte 0x09, 0x54, 0x70, 0xd7, 0xcf, 0x63, 0x61, 0x70, 0x80, 0xd3	/* Tptracer_capable */
	.byte 0x09, 0xa8, 0xe7, 0xc8, 0x68, 0x61, 0xe0, 0x63, 0x61, 0x70	/* t__pfx_ptrace_has_cap */
	.byte 0x08, 0x06, 0xc8, 0x68, 0x61, 0xe0, 0x63, 0x61, 0x70	/* tptrace_has_cap */
	.byte 0x09, 0x29, 0xe7, 0xc8, 0xdd, 0xc5, 0xeb, 0x63, 0x3b, 0x73	/* t__pfx___ptrace_may_access */
	.byte 0x0a, 0x74, 0xff, 0x70, 0xc8, 0xdd, 0xc5, 0xeb, 0x63, 0x3b, 0x73	/* t__ptrace_may_access */
	.byte 0x0b, 0xc6, 0x7e, 0x63, 0x6b, 0xe7, 0xc8, 0x81, 0x74, 0xd9, 0x6e, 0x73	/* t__pfx_check_ptrace_options */
	.byte 0x0b, 0x74, 0x7e, 0x63, 0x6b, 0xe7, 0xc8, 0x81, 0x74, 0xd9, 0x6e, 0x73	/* tcheck_ptrace_options */
	.byte 0x0a, 0xa8, 0xe7, 0xc8, 0xc9, 0x74, 0x73, 0x2c, 0xf0, 0x66, 0x6f	/* t__pfx_ptrace_setsiginfo */
	.byte 0x09, 0x06, 0xc8, 0xc9, 0x74, 0x73, 0x2c, 0xf0, 0x66, 0x6f	/* tptrace_setsiginfo */
	.byte 0x0a, 0xa8, 0xe7, 0xc8, 0xda, 0x74, 0x73, 0x2c, 0xf0, 0x66, 0x6f	/* t__pfx_ptrace_getsiginfo */
	.byte 0x09, 0x06, 0xc8, 0xda, 0x74, 0x73, 0x2c, 0xf0, 0x66, 0x6f	/* tptrace_getsiginfo */
	.byte 0x0a, 0xa8, 0xe7, 0xc8, 0xd4, 0x87, 0x65, 0x7a, 0xfa, 0x01, 0x64	/* t__pfx_ptrace_unfreeze_traced */
	.byte 0x09, 0x06, 0xc8, 0xd4, 0x87, 0x65, 0x7a, 0xfa, 0x01, 0x64	/* tptrace_unfreeze_traced */
	.byte 0x0a, 0xa8, 0xe7, 0xc8, 0x7e, 0x63, 0xd8, 0xe9, 0x74, 0xeb, 0x68	/* t__pfx_ptrace_check_attach */
	.byte 0x09, 0x06, 0xc8, 0x7e, 0x63, 0xd8, 0xe9, 0x74, 0xeb, 0x68	/* tptrace_check_attach */
	.byte 0x06, 0xa8, 0xe7, 0xc8, 0x9f, 0xc9, 0x74	/* t__pfx_ptrace_regset */
	.byte 0x05, 0x06, 0xc8, 0x9f, 0xc9, 0x74	/* tptrace_regset */
	.byte 0x14, 0xa8, 0xe7, 0xc8, 0xb2, 0xc1, 0x73, 0x28, 0xc3, 0xf0, 0x66, 0x6f, 0x5f, 0xe8, 0xea, 0x79, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* t__pfx_ptrace_get_syscall_info_entry.isra.0 */
	.byte 0x13, 0x06, 0xc8, 0xb2, 0xc1, 0x73, 0x28, 0xc3, 0xf0, 0x66, 0x6f, 0x5f, 0xe8, 0xea, 0x79, 0x2e, 0xab, 0xb5, 0x2e, 0x30	/* tptrace_get_syscall_info_entry.isra.0 */
	.byte 0x0b, 0xa8, 0xe7, 0xc8, 0xb2, 0xc1, 0x73, 0x28, 0xc3, 0xf0, 0x66, 0x6f	/* t__pfx_ptrace_get_syscall_info */
	.byte 0x0a, 0x06, 0xc8, 0xb2, 0xc1, 0x73, 0x28, 0xc3, 0xf0, 0x66, 0x6f	/* tptrace_get_syscall_info */
	.byte 0x0c, 0xa8, 0xe7, 0xc8, 0x70, 0x65, 0x65, 0x6b, 0xf6, 0x2c, 0xf0, 0x66, 0x6f	/* t__pfx_ptrace_peek_siginfo */
	.byte 0x0b, 0x06, 0xc8, 0x70, 0x65, 0x65, 0x6b, 0xf6, 0x2c, 0xf0, 0x66, 0x6f	/* tptrace_peek_siginfo */
	.byte 0x09, 0x3f, 0xe7, 0xc8, 0xeb, 0x63, 0x3b, 0xe0, 0x76, 0x6d	/* T__pfx_ptrace_access_vm */
	.byte 0x09, 0x54, 0x70, 0xc8, 0xeb, 0x63, 0x3b, 0xe0, 0x76, 0x6d	/* Tptrace_access_vm */
	.byte 0x06, 0x3f, 0xff, 0xe7, 0xc8, 0x88, 0x6b	/* T__pfx___ptrace_link */
	.byte 0x05, 0x2f, 0x70, 0xc8, 0x88, 0x6b	/* T__ptrace_link */
	.byte 0x05, 0xa8, 0xe7, 0xc8, 0x01, 0xbd	/* t__pfx_ptrace_traceme */
	.byte 0x04, 0x06, 0xc8, 0x01, 0xbd	/* tptrace_traceme */
	.byte 0x07, 0xa8, 0xe7, 0xc8, 0xe9, 0x74, 0xeb, 0x68	/* t__pfx_ptrace_attach */
	.byte 0x06, 0x06, 0xc8, 0xe9, 0x74, 0xeb, 0x68	/* tptrace_attach */
	.byte 0x0f, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0x73, 0xe7, 0x01	/* T__pfx___ia32_compat_sys_ptrace */
	.byte 0x0d, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x5f, 0x09, 0x61, 0xf9, 0xc1, 0x73, 0xe7, 0x01	/* T__ia32_compat_sys_ptrace */
	.byte 0x07, 0x29, 0x5f, 0xa9, 0x95, 0x73, 0xe7, 0x01	/* t__pfx___do_sys_ptrace */
	.byte 0x07, 0x74, 0xff, 0xa9, 0x95, 0x73, 0xe7, 0x01	/* t__do_sys_ptrace */
	.byte 0x0b, 0x3f, 0xff, 0x5f, 0x69, 0x61, 0x33, 0x32, 0x95, 0x73, 0xe7, 0x01	/* T__pfx___ia32_sys_ptrace */
	.byte 0x09, 0x2f, 0x69, 0x61, 0x33, 0x32, 0x95, 0x73, 0xe7, 0x01	/* T__ia32_sys_ptrace */
	.byte 0x0a, 0x3f, 0xff, 0x5f, 0x78, 0x36, 0x34, 0x95, 0x73, 0xe7, 0x01	/* T__pfx___x64_sys_ptrace */
	.byte 0x08, 0x2f, 0x78, 0x36, 0x34, 0x95, 0x73, 0xe7, 0x01	/* T__x64_sys_ptrace */
	.byte 0x07, 0x3f, 0xff, 0xe7, 0xc8, 0xd4, 0x88, 0x6b	/* T__pfx___ptrace_unlink */
	.byte 0x06, 0x2f, 0x70, 0xc8, 0xd4, 0x88, 0x6b	/* T__ptrace_unlink */
	.byte 0x07, 0x29, 0xe7, 0xc8, 0xe6, 0x74, 0xeb, 0x68	/* t__pfx___ptrace_detach */
	.byte 0x08, 0x74, 0xff, 0x70, 0xc8, 0xe6, 0x74, 0xeb, 0x68	/* t__ptrace_detach */
	.byte 0x09, 0x3f, 0xe7, 0xc8, 0xdd, 0xc5, 0xeb, 0x63, 0x3b, 0x73	/* T__pfx_ptrace_may_access */
	.byte 0x09, 0x54, 0x70, 0xc8, 0xdd, 0xc5, 0xeb, 0x63, 0x3b, 0x73	/* Tptrace_may_access */
	.byte 0x05, 0xbf, 0xd1, 0x99, 0x70, 0x01	/* T__pfx_exit_ptrace */
	.byte 0x05, 0x54, 0xd1, 0x99, 0x70, 0x01	/* Texit_ptrace */
	.byte 0x06, 0x3f, 0xe7, 0xc8, 0xf8, 0x10, 0x0f	/* T__pfx_ptrace_readdata */
	.byte 0x06, 0x54, 0x70, 0xc8, 0xf8, 0x10, 0x0f	/* Tptrace_readdata */
	.byte 0x07, 0x3f, 0xe7, 0xc8, 0x24, 0x65, 0x64, 0x0f	/* T__pfx_ptrace_writedata */
	.byte 0x07, 0x54, 0x70, 0xc8, 0x24, 0x65, 0x64, 0x0f	/* Tptrace_writedata */
	.byte 0x0d, 0xbf, 0x67, 0xe8, 0xee, 0xa3, 0xe7, 0xc8, 0x70, 0x65, 0x65, 0x6b, 0x64, 0x0f	/* T__pfx_generic_ptrace_peekdata */
	.byte 0x0d, 0x54, 0x67, 0xe8, 0xee, 0xa3, 0xe7, 0xc8, 0x70, 0x65, 0x65, 0x6b, 0x64, 0x0f	/* Tgeneric_ptrace_peekdata */
	.byte 0x06, 0x3f, 0xe7, 0xc8, 0xf8, 0x04, 0xd6	/* T__pfx_ptrace_request */
	.byte 0x06, 0x54, 0x70, 0xc8, 0xf8, 0x04, 0xd6	/* Tptrace_request */
	.byte 0x0c, 0xbf, 0x67, 0xe8, 0xee, 0xa3, 0xe7, 0xc8, 0x70, 0x6f, 0x0e, 0x64, 0x0f	/* T__pfx_generic_ptrace_pokedata */
	.byte 0x0c, 0x54, 0x67, 0xe8, 0xee, 0xa3, 0xe7, 0xc8, 0x70, 0x6f, 0x0e, 0x64, 0x0f	/* Tgeneric_ptrace_pokedata */
	.byte 0x09, 0xbf, 0x09, 0x61, 0xf9, 0x