/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.highgui;

import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.opencv.core.Mat;
import org.opencv.highgui.ImageWindow;

public final class HighGui {
    public static final int WINDOW_NORMAL = 0;
    public static final int WINDOW_AUTOSIZE = 1;
    public static int n_closed_windows = 0;
    public static int pressedKey = -1;
    public static CountDownLatch latch = new CountDownLatch(1);
    public static Map<String, ImageWindow> windows = new HashMap<String, ImageWindow>();

    public static void namedWindow(String string) {
        HighGui.namedWindow(string, 1);
    }

    public static void namedWindow(String string, int n) {
        ImageWindow imageWindow = new ImageWindow(string, n);
        if (windows.get(string) == null) {
            windows.put(string, imageWindow);
        }
    }

    public static void imshow(String string, Mat mat) {
        if (mat.empty()) {
            System.err.println("Error: Empty image in imshow");
            System.exit(-1);
        } else {
            ImageWindow imageWindow = windows.get(string);
            if (imageWindow == null) {
                ImageWindow imageWindow2 = new ImageWindow(string, mat);
                windows.put(string, imageWindow2);
            } else {
                imageWindow.setMat(mat);
            }
        }
    }

    public static Image toBufferedImage(Mat mat) {
        int n = 10;
        if (mat.channels() > 1) {
            n = 5;
        }
        BufferedImage bufferedImage = new BufferedImage(mat.cols(), mat.rows(), n);
        byte[] byArray = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
        mat.get(0, 0, byArray);
        return bufferedImage;
    }

    public static JFrame createJFrame(String string, int n) {
        JFrame jFrame = new JFrame(string);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (++n_closed_windows == windows.size()) {
                    latch.countDown();
                }
            }
        });
        jFrame.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                pressedKey = keyEvent.getKeyCode();
                latch.countDown();
            }
        });
        if (n == 1) {
            jFrame.setResizable(false);
        }
        return jFrame;
    }

    public static void waitKey() {
        HighGui.waitKey(0);
    }

    public static int waitKey(int n) {
        latch = new CountDownLatch(1);
        n_closed_windows = 0;
        pressedKey = -1;
        if (windows.isEmpty()) {
            System.err.println("Error: waitKey must be used after an imshow");
            System.exit(-1);
        }
        Iterator<Map.Entry<String, ImageWindow>> iterator = windows.entrySet().iterator();
        while (iterator.hasNext()) {
            Iterator<ImageWindow> iterator2 = iterator.next();
            ImageWindow imageWindow = (ImageWindow)iterator2.getValue();
            if (!imageWindow.alreadyUsed.booleanValue()) continue;
            iterator.remove();
            imageWindow.frame.dispose();
        }
        for (ImageWindow imageWindow : windows.values()) {
            if (imageWindow.img != null) {
                ImageIcon imageIcon = new ImageIcon(HighGui.toBufferedImage(imageWindow.img));
                if (imageWindow.lbl == null) {
                    JFrame jFrame = HighGui.createJFrame(imageWindow.name, imageWindow.flag);
                    JLabel jLabel = new JLabel(imageIcon);
                    imageWindow.setFrameLabelVisible(jFrame, jLabel);
                    continue;
                }
                imageWindow.lbl.setIcon(imageIcon);
                continue;
            }
            System.err.println("Error: no imshow associated with namedWindow: \"" + imageWindow.name + "\"");
            System.exit(-1);
        }
        try {
            if (n == 0) {
                latch.await();
            } else {
                latch.await(n, TimeUnit.MILLISECONDS);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        for (ImageWindow imageWindow : windows.values()) {
            imageWindow.alreadyUsed = true;
        }
        return pressedKey;
    }

    public static void destroyWindow(String string) {
        ImageWindow imageWindow = windows.get(string);
        if (imageWindow != null) {
            windows.remove(string);
        }
    }

    public static void destroyAllWindows() {
        windows.clear();
    }

    public static void resizeWindow(String string, int n, int n2) {
        ImageWindow imageWindow = windows.get(string);
        if (imageWindow != null) {
            imageWindow.setNewDimension(n, n2);
        }
    }

    public static void moveWindow(String string, int n, int n2) {
        ImageWindow imageWindow = windows.get(string);
        if (imageWindow != null) {
            imageWindow.setNewPosition(n, n2);
        }
    }
}

