/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.dnn;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfInt;
import org.opencv.core.MatOfRect;
import org.opencv.core.MatOfRect2d;
import org.opencv.core.MatOfRotatedRect;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.dnn.Image2BlobParams;
import org.opencv.dnn.Net;
import org.opencv.utils.Converters;

public class Dnn {
    public static final int DNN_BACKEND_DEFAULT = 0;
    public static final int DNN_BACKEND_HALIDE = 1;
    public static final int DNN_BACKEND_INFERENCE_ENGINE = 2;
    public static final int DNN_BACKEND_OPENCV = 3;
    public static final int DNN_BACKEND_VKCOM = 4;
    public static final int DNN_BACKEND_CUDA = 5;
    public static final int DNN_BACKEND_WEBNN = 6;
    public static final int DNN_BACKEND_TIMVX = 7;
    public static final int DNN_BACKEND_CANN = 8;
    public static final int DNN_LAYOUT_UNKNOWN = 0;
    public static final int DNN_LAYOUT_ND = 1;
    public static final int DNN_LAYOUT_NCHW = 2;
    public static final int DNN_LAYOUT_NCDHW = 3;
    public static final int DNN_LAYOUT_NHWC = 4;
    public static final int DNN_LAYOUT_NDHWC = 5;
    public static final int DNN_LAYOUT_PLANAR = 6;
    public static final int DNN_PMODE_NULL = 0;
    public static final int DNN_PMODE_CROP_CENTER = 1;
    public static final int DNN_PMODE_LETTERBOX = 2;
    public static final int SoftNMSMethod_SOFTNMS_LINEAR = 1;
    public static final int SoftNMSMethod_SOFTNMS_GAUSSIAN = 2;
    public static final int DNN_TARGET_CPU = 0;
    public static final int DNN_TARGET_OPENCL = 1;
    public static final int DNN_TARGET_OPENCL_FP16 = 2;
    public static final int DNN_TARGET_MYRIAD = 3;
    public static final int DNN_TARGET_VULKAN = 4;
    public static final int DNN_TARGET_FPGA = 5;
    public static final int DNN_TARGET_CUDA = 6;
    public static final int DNN_TARGET_CUDA_FP16 = 7;
    public static final int DNN_TARGET_HDDL = 8;
    public static final int DNN_TARGET_NPU = 9;
    public static final int DNN_TARGET_CPU_FP16 = 10;

    public static List<Integer> getAvailableTargets(int n) {
        return Dnn.getAvailableTargets_0(n);
    }

    public static Net readNetFromDarknet(String string, String string2) {
        return new Net(Dnn.readNetFromDarknet_0(string, string2));
    }

    public static Net readNetFromDarknet(String string) {
        return new Net(Dnn.readNetFromDarknet_1(string));
    }

    public static Net readNetFromDarknet(MatOfByte matOfByte, MatOfByte matOfByte2) {
        MatOfByte matOfByte3 = matOfByte;
        MatOfByte matOfByte4 = matOfByte2;
        return new Net(Dnn.readNetFromDarknet_2(matOfByte3.nativeObj, matOfByte4.nativeObj));
    }

    public static Net readNetFromDarknet(MatOfByte matOfByte) {
        MatOfByte matOfByte2 = matOfByte;
        return new Net(Dnn.readNetFromDarknet_3(matOfByte2.nativeObj));
    }

    public static Net readNetFromCaffe(String string, String string2) {
        return new Net(Dnn.readNetFromCaffe_0(string, string2));
    }

    public static Net readNetFromCaffe(String string) {
        return new Net(Dnn.readNetFromCaffe_1(string));
    }

    public static Net readNetFromCaffe(MatOfByte matOfByte, MatOfByte matOfByte2) {
        MatOfByte matOfByte3 = matOfByte;
        MatOfByte matOfByte4 = matOfByte2;
        return new Net(Dnn.readNetFromCaffe_2(matOfByte3.nativeObj, matOfByte4.nativeObj));
    }

    public static Net readNetFromCaffe(MatOfByte matOfByte) {
        MatOfByte matOfByte2 = matOfByte;
        return new Net(Dnn.readNetFromCaffe_3(matOfByte2.nativeObj));
    }

    public static Net readNetFromTensorflow(String string, String string2) {
        return new Net(Dnn.readNetFromTensorflow_0(string, string2));
    }

    public static Net readNetFromTensorflow(String string) {
        return new Net(Dnn.readNetFromTensorflow_1(string));
    }

    public static Net readNetFromTensorflow(MatOfByte matOfByte, MatOfByte matOfByte2) {
        MatOfByte matOfByte3 = matOfByte;
        MatOfByte matOfByte4 = matOfByte2;
        return new Net(Dnn.readNetFromTensorflow_2(matOfByte3.nativeObj, matOfByte4.nativeObj));
    }

    public static Net readNetFromTensorflow(MatOfByte matOfByte) {
        MatOfByte matOfByte2 = matOfByte;
        return new Net(Dnn.readNetFromTensorflow_3(matOfByte2.nativeObj));
    }

    public static Net readNetFromTFLite(String string) {
        return new Net(Dnn.readNetFromTFLite_0(string));
    }

    public static Net readNetFromTFLite(MatOfByte matOfByte) {
        MatOfByte matOfByte2 = matOfByte;
        return new Net(Dnn.readNetFromTFLite_1(matOfByte2.nativeObj));
    }

    public static Net readNetFromTorch(String string, boolean bl, boolean bl2) {
        return new Net(Dnn.readNetFromTorch_0(string, bl, bl2));
    }

    public static Net readNetFromTorch(String string, boolean bl) {
        return new Net(Dnn.readNetFromTorch_1(string, bl));
    }

    public static Net readNetFromTorch(String string) {
        return new Net(Dnn.readNetFromTorch_2(string));
    }

    public static Net readNet(String string, String string2, String string3) {
        return new Net(Dnn.readNet_0(string, string2, string3));
    }

    public static Net readNet(String string, String string2) {
        return new Net(Dnn.readNet_1(string, string2));
    }

    public static Net readNet(String string) {
        return new Net(Dnn.readNet_2(string));
    }

    public static Net readNet(String string, MatOfByte matOfByte, MatOfByte matOfByte2) {
        MatOfByte matOfByte3 = matOfByte;
        MatOfByte matOfByte4 = matOfByte2;
        return new Net(Dnn.readNet_3(string, matOfByte3.nativeObj, matOfByte4.nativeObj));
    }

    public static Net readNet(String string, MatOfByte matOfByte) {
        MatOfByte matOfByte2 = matOfByte;
        return new Net(Dnn.readNet_4(string, matOfByte2.nativeObj));
    }

    public static Mat readTorchBlob(String string, boolean bl) {
        return new Mat(Dnn.readTorchBlob_0(string, bl));
    }

    public static Mat readTorchBlob(String string) {
        return new Mat(Dnn.readTorchBlob_1(string));
    }

    public static Net readNetFromModelOptimizer(String string, String string2) {
        return new Net(Dnn.readNetFromModelOptimizer_0(string, string2));
    }

    public static Net readNetFromModelOptimizer(String string) {
        return new Net(Dnn.readNetFromModelOptimizer_1(string));
    }

    public static Net readNetFromModelOptimizer(MatOfByte matOfByte, MatOfByte matOfByte2) {
        MatOfByte matOfByte3 = matOfByte;
        MatOfByte matOfByte4 = matOfByte2;
        return new Net(Dnn.readNetFromModelOptimizer_2(matOfByte3.nativeObj, matOfByte4.nativeObj));
    }

    public static Net readNetFromONNX(String string) {
        return new Net(Dnn.readNetFromONNX_0(string));
    }

    public static Net readNetFromONNX(MatOfByte matOfByte) {
        MatOfByte matOfByte2 = matOfByte;
        return new Net(Dnn.readNetFromONNX_1(matOfByte2.nativeObj));
    }

    public static Mat readTensorFromONNX(String string) {
        return new Mat(Dnn.readTensorFromONNX_0(string));
    }

    public static Mat blobFromImage(Mat mat, double d, Size size, Scalar scalar, boolean bl, boolean bl2, int n) {
        return new Mat(Dnn.blobFromImage_0(mat.nativeObj, d, size.width, size.height, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], bl, bl2, n));
    }

    public static Mat blobFromImage(Mat mat, double d, Size size, Scalar scalar, boolean bl, boolean bl2) {
        return new Mat(Dnn.blobFromImage_1(mat.nativeObj, d, size.width, size.height, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], bl, bl2));
    }

    public static Mat blobFromImage(Mat mat, double d, Size size, Scalar scalar, boolean bl) {
        return new Mat(Dnn.blobFromImage_2(mat.nativeObj, d, size.width, size.height, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], bl));
    }

    public static Mat blobFromImage(Mat mat, double d, Size size, Scalar scalar) {
        return new Mat(Dnn.blobFromImage_3(mat.nativeObj, d, size.width, size.height, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]));
    }

    public static Mat blobFromImage(Mat mat, double d, Size size) {
        return new Mat(Dnn.blobFromImage_4(mat.nativeObj, d, size.width, size.height));
    }

    public static Mat blobFromImage(Mat mat, double d) {
        return new Mat(Dnn.blobFromImage_5(mat.nativeObj, d));
    }

    public static Mat blobFromImage(Mat mat) {
        return new Mat(Dnn.blobFromImage_6(mat.nativeObj));
    }

    public static Mat blobFromImages(List<Mat> list, double d, Size size, Scalar scalar, boolean bl, boolean bl2, int n) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        return new Mat(Dnn.blobFromImages_0(mat.nativeObj, d, size.width, size.height, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], bl, bl2, n));
    }

    public static Mat blobFromImages(List<Mat> list, double d, Size size, Scalar scalar, boolean bl, boolean bl2) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        return new Mat(Dnn.blobFromImages_1(mat.nativeObj, d, size.width, size.height, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], bl, bl2));
    }

    public static Mat blobFromImages(List<Mat> list, double d, Size size, Scalar scalar, boolean bl) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        return new Mat(Dnn.blobFromImages_2(mat.nativeObj, d, size.width, size.height, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], bl));
    }

    public static Mat blobFromImages(List<Mat> list, double d, Size size, Scalar scalar) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        return new Mat(Dnn.blobFromImages_3(mat.nativeObj, d, size.width, size.height, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]));
    }

    public static Mat blobFromImages(List<Mat> list, double d, Size size) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        return new Mat(Dnn.blobFromImages_4(mat.nativeObj, d, size.width, size.height));
    }

    public static Mat blobFromImages(List<Mat> list, double d) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        return new Mat(Dnn.blobFromImages_5(mat.nativeObj, d));
    }

    public static Mat blobFromImages(List<Mat> list) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        return new Mat(Dnn.blobFromImages_6(mat.nativeObj));
    }

    public static Mat blobFromImageWithParams(Mat mat, Image2BlobParams image2BlobParams) {
        return new Mat(Dnn.blobFromImageWithParams_0(mat.nativeObj, image2BlobParams.nativeObj));
    }

    public static Mat blobFromImageWithParams(Mat mat) {
        return new Mat(Dnn.blobFromImageWithParams_1(mat.nativeObj));
    }

    public static void blobFromImageWithParams(Mat mat, Mat mat2, Image2BlobParams image2BlobParams) {
        Dnn.blobFromImageWithParams_2(mat.nativeObj, mat2.nativeObj, image2BlobParams.nativeObj);
    }

    public static void blobFromImageWithParams(Mat mat, Mat mat2) {
        Dnn.blobFromImageWithParams_3(mat.nativeObj, mat2.nativeObj);
    }

    public static Mat blobFromImagesWithParams(List<Mat> list, Image2BlobParams image2BlobParams) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        return new Mat(Dnn.blobFromImagesWithParams_0(mat.nativeObj, image2BlobParams.nativeObj));
    }

    public static Mat blobFromImagesWithParams(List<Mat> list) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        return new Mat(Dnn.blobFromImagesWithParams_1(mat.nativeObj));
    }

    public static void blobFromImagesWithParams(List<Mat> list, Mat mat, Image2BlobParams image2BlobParams) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        Dnn.blobFromImagesWithParams_2(mat2.nativeObj, mat.nativeObj, image2BlobParams.nativeObj);
    }

    public static void blobFromImagesWithParams(List<Mat> list, Mat mat) {
        Mat mat2 = Converters.vector_Mat_to_Mat(list);
        Dnn.blobFromImagesWithParams_3(mat2.nativeObj, mat.nativeObj);
    }

    public static void imagesFromBlob(Mat mat, List<Mat> list) {
        Mat mat2 = new Mat();
        Dnn.imagesFromBlob_0(mat.nativeObj, mat2.nativeObj);
        Converters.Mat_to_vector_Mat(mat2, list);
        mat2.release();
    }

    public static void shrinkCaffeModel(String string, String string2, List<String> list) {
        Dnn.shrinkCaffeModel_0(string, string2, list);
    }

    public static void shrinkCaffeModel(String string, String string2) {
        Dnn.shrinkCaffeModel_1(string, string2);
    }

    public static void writeTextGraph(String string, String string2) {
        Dnn.writeTextGraph_0(string, string2);
    }

    public static void NMSBoxes(MatOfRect2d matOfRect2d, MatOfFloat matOfFloat, float f, float f2, MatOfInt matOfInt, float f3, int n) {
        MatOfRect2d matOfRect2d2 = matOfRect2d;
        MatOfFloat matOfFloat2 = matOfFloat;
        MatOfInt matOfInt2 = matOfInt;
        Dnn.NMSBoxes_0(matOfRect2d2.nativeObj, matOfFloat2.nativeObj, f, f2, matOfInt2.nativeObj, f3, n);
    }

    public static void NMSBoxes(MatOfRect2d matOfRect2d, MatOfFloat matOfFloat, float f, float f2, MatOfInt matOfInt, float f3) {
        MatOfRect2d matOfRect2d2 = matOfRect2d;
        MatOfFloat matOfFloat2 = matOfFloat;
        MatOfInt matOfInt2 = matOfInt;
        Dnn.NMSBoxes_1(matOfRect2d2.nativeObj, matOfFloat2.nativeObj, f, f2, matOfInt2.nativeObj, f3);
    }

    public static void NMSBoxes(MatOfRect2d matOfRect2d, MatOfFloat matOfFloat, float f, float f2, MatOfInt matOfInt) {
        MatOfRect2d matOfRect2d2 = matOfRect2d;
        MatOfFloat matOfFloat2 = matOfFloat;
        MatOfInt matOfInt2 = matOfInt;
        Dnn.NMSBoxes_2(matOfRect2d2.nativeObj, matOfFloat2.nativeObj, f, f2, matOfInt2.nativeObj);
    }

    public static void NMSBoxesRotated(MatOfRotatedRect matOfRotatedRect, MatOfFloat matOfFloat, float f, float f2, MatOfInt matOfInt, float f3, int n) {
        MatOfRotatedRect matOfRotatedRect2 = matOfRotatedRect;
        MatOfFloat matOfFloat2 = matOfFloat;
        MatOfInt matOfInt2 = matOfInt;
        Dnn.NMSBoxesRotated_0(matOfRotatedRect2.nativeObj, matOfFloat2.nativeObj, f, f2, matOfInt2.nativeObj, f3, n);
    }

    public static void NMSBoxesRotated(MatOfRotatedRect matOfRotatedRect, MatOfFloat matOfFloat, float f, float f2, MatOfInt matOfInt, float f3) {
        MatOfRotatedRect matOfRotatedRect2 = matOfRotatedRect;
        MatOfFloat matOfFloat2 = matOfFloat;
        MatOfInt matOfInt2 = matOfInt;
        Dnn.NMSBoxesRotated_1(matOfRotatedRect2.nativeObj, matOfFloat2.nativeObj, f, f2, matOfInt2.nativeObj, f3);
    }

    public static void NMSBoxesRotated(MatOfRotatedRect matOfRotatedRect, MatOfFloat matOfFloat, float f, float f2, MatOfInt matOfInt) {
        MatOfRotatedRect matOfRotatedRect2 = matOfRotatedRect;
        MatOfFloat matOfFloat2 = matOfFloat;
        MatOfInt matOfInt2 = matOfInt;
        Dnn.NMSBoxesRotated_2(matOfRotatedRect2.nativeObj, matOfFloat2.nativeObj, f, f2, matOfInt2.nativeObj);
    }

    public static void NMSBoxesBatched(MatOfRect2d matOfRect2d, MatOfFloat matOfFloat, MatOfInt matOfInt, float f, float f2, MatOfInt matOfInt2, float f3, int n) {
        MatOfRect2d matOfRect2d2 = matOfRect2d;
        MatOfFloat matOfFloat2 = matOfFloat;
        MatOfInt matOfInt3 = matOfInt;
        MatOfInt matOfInt4 = matOfInt2;
        Dnn.NMSBoxesBatched_0(matOfRect2d2.nativeObj, matOfFloat2.nativeObj, matOfInt3.nativeObj, f, f2, matOfInt4.nativeObj, f3, n);
    }

    public static void NMSBoxesBatched(MatOfRect2d matOfRect2d, MatOfFloat matOfFloat, MatOfInt matOfInt, float f, float f2, MatOfInt matOfInt2, float f3) {
        MatOfRect2d matOfRect2d2 = matOfRect2d;
        MatOfFloat matOfFloat2 = matOfFloat;
        MatOfInt matOfInt3 = matOfInt;
        MatOfInt matOfInt4 = matOfInt2;
        Dnn.NMSBoxesBatched_1(matOfRect2d2.nativeObj, matOfFloat2.nativeObj, matOfInt3.nativeObj, f, f2, matOfInt4.nativeObj, f3);
    }

    public static void NMSBoxesBatched(MatOfRect2d matOfRect2d, MatOfFloat matOfFloat, MatOfInt matOfInt, float f, float f2, MatOfInt matOfInt2) {
        MatOfRect2d matOfRect2d2 = matOfRect2d;
        MatOfFloat matOfFloat2 = matOfFloat;
        MatOfInt matOfInt3 = matOfInt;
        MatOfInt matOfInt4 = matOfInt2;
        Dnn.NMSBoxesBatched_2(matOfRect2d2.nativeObj, matOfFloat2.nativeObj, matOfInt3.nativeObj, f, f2, matOfInt4.nativeObj);
    }

    public static void softNMSBoxes(MatOfRect matOfRect, MatOfFloat matOfFloat, MatOfFloat matOfFloat2, float f, float f2, MatOfInt matOfInt, long l, float f3) {
        MatOfRect matOfRect2 = matOfRect;
        MatOfFloat matOfFloat3 = matOfFloat;
        MatOfFloat matOfFloat4 = matOfFloat2;
        MatOfInt matOfInt2 = matOfInt;
        Dnn.softNMSBoxes_0(matOfRect2.nativeObj, matOfFloat3.nativeObj, matOfFloat4.nativeObj, f, f2, matOfInt2.nativeObj, l, f3);
    }

    public static void softNMSBoxes(MatOfRect matOfRect, MatOfFloat matOfFloat, MatOfFloat matOfFloat2, float f, float f2, MatOfInt matOfInt, long l) {
        MatOfRect matOfRect2 = matOfRect;
        MatOfFloat matOfFloat3 = matOfFloat;
        MatOfFloat matOfFloat4 = matOfFloat2;
        MatOfInt matOfInt2 = matOfInt;
        Dnn.softNMSBoxes_2(matOfRect2.nativeObj, matOfFloat3.nativeObj, matOfFloat4.nativeObj, f, f2, matOfInt2.nativeObj, l);
    }

    public static void softNMSBoxes(MatOfRect matOfRect, MatOfFloat matOfFloat, MatOfFloat matOfFloat2, float f, float f2, MatOfInt matOfInt) {
        MatOfRect matOfRect2 = matOfRect;
        MatOfFloat matOfFloat3 = matOfFloat;
        MatOfFloat matOfFloat4 = matOfFloat2;
        MatOfInt matOfInt2 = matOfInt;
        Dnn.softNMSBoxes_3(matOfRect2.nativeObj, matOfFloat3.nativeObj, matOfFloat4.nativeObj, f, f2, matOfInt2.nativeObj);
    }

    @Deprecated
    public static String getInferenceEngineBackendType() {
        return Dnn.getInferenceEngineBackendType_0();
    }

    @Deprecated
    public static String setInferenceEngineBackendType(String string) {
        return Dnn.setInferenceEngineBackendType_0(string);
    }

    public static void resetMyriadDevice() {
        Dnn.resetMyriadDevice_0();
    }

    public static String getInferenceEngineVPUType() {
        return Dnn.getInferenceEngineVPUType_0();
    }

    public static String getInferenceEngineCPUType() {
        return Dnn.getInferenceEngineCPUType_0();
    }

    public static void releaseHDDLPlugin() {
        Dnn.releaseHDDLPlugin_0();
    }

    private static native List<Integer> getAvailableTargets_0(int var0);

    private static native long readNetFromDarknet_0(String var0, String var1);

    private static native long readNetFromDarknet_1(String var0);

    private static native long readNetFromDarknet_2(long var0, long var2);

    private static native long readNetFromDarknet_3(long var0);

    private static native long readNetFromCaffe_0(String var0, String var1);

    private static native long readNetFromCaffe_1(String var0);

    private static native long readNetFromCaffe_2(long var0, long var2);

    private static native long readNetFromCaffe_3(long var0);

    private static native long readNetFromTensorflow_0(String var0, String var1);

    private static native long readNetFromTensorflow_1(String var0);

    private static native long readNetFromTensorflow_2(long var0, long var2);

    private static native long readNetFromTensorflow_3(long var0);

    private static native long readNetFromTFLite_0(String var0);

    private static native long readNetFromTFLite_1(long var0);

    private static native long readNetFromTorch_0(String var0, boolean var1, boolean var2);

    private static native long readNetFromTorch_1(String var0, boolean var1);

    private static native long readNetFromTorch_2(String var0);

    private static native long readNet_0(String var0, String var1, String var2);

    private static native long readNet_1(String var0, String var1);

    private static native long readNet_2(String var0);

    private static native long readNet_3(String var0, long var1, long var3);

    private static native long readNet_4(String var0, long var1);

    private static native long readTorchBlob_0(String var0, boolean var1);

    private static native long readTorchBlob_1(String var0);

    private static native long readNetFromModelOptimizer_0(String var0, String var1);

    private static native long readNetFromModelOptimizer_1(String var0);

    private static native long readNetFromModelOptimizer_2(long var0, long var2);

    private static native long readNetFromONNX_0(String var0);

    private static native long readNetFromONNX_1(long var0);

    private static native long readTensorFromONNX_0(String var0);

    private static native long blobFromImage_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17, int var18);

    private static native long blobFromImage_1(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17);

    private static native long blobFromImage_2(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16);

    private static native long blobFromImage_3(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14);

    private static native long blobFromImage_4(long var0, double var2, double var4, double var6);

    private static native long blobFromImage_5(long var0, double var2);

    private static native long blobFromImage_6(long var0);

    private static native long blobFromImages_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17, int var18);

    private static native long blobFromImages_1(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17);

    private static native long blobFromImages_2(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16);

    private static native long blobFromImages_3(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14);

    private static native long blobFromImages_4(long var0, double var2, double var4, double var6);

    private static native long blobFromImages_5(long var0, double var2);

    private static native long blobFromImages_6(long var0);

    private static native long blobFromImageWithParams_0(long var0, long var2);

    private static native long blobFromImageWithParams_1(long var0);

    private static native void blobFromImageWithParams_2(long var0, long var2, long var4);

    private static native void blobFromImageWithParams_3(long var0, long var2);

    private static native long blobFromImagesWithParams_0(long var0, long var2);

    private static native long blobFromImagesWithParams_1(long var0);

    private static native void blobFromImagesWithParams_2(long var0, long var2, long var4);

    private static native void blobFromImagesWithParams_3(long var0, long var2);

    private static native void imagesFromBlob_0(long var0, long var2);

    private static native void shrinkCaffeModel_0(String var0, String var1, List<String> var2);

    private static native void shrinkCaffeModel_1(String var0, String var1);

    private static native void writeTextGraph_0(String var0, String var1);

    private static native void NMSBoxes_0(long var0, long var2, float var4, float var5, long var6, float var8, int var9);

    private static native void NMSBoxes_1(long var0, long var2, float var4, float var5, long var6, float var8);

    private static native void NMSBoxes_2(long var0, long var2, float var4, float var5, long var6);

    private static native void NMSBoxesRotated_0(long var0, long var2, float var4, float var5, long var6, float var8, int var9);

    private static native void NMSBoxesRotated_1(long var0, long var2, float var4, float var5, long var6, float var8);

    private static native void NMSBoxesRotated_2(long var0, long var2, float var4, float var5, long var6);

    private static native void NMSBoxesBatched_0(long var0, long var2, long var4, float var6, float var7, long var8, float var10, int var11);

    private static native void NMSBoxesBatched_1(long var0, long var2, long var4, float var6, float var7, long var8, float var10);

    private static native void NMSBoxesBatched_2(long var0, long var2, long var4, float var6, float var7, long var8);

    private static native void softNMSBoxes_0(long var0, long var2, long var4, float var6, float var7, long var8, long var10, float var12);

    private static native void softNMSBoxes_2(long var0, long var2, long var4, float var6, float var7, long var8, long var10);

    private static native void softNMSBoxes_3(long var0, long var2, long var4, float var6, float var7, long var8);

    private static native String getInferenceEngineBackendType_0();

    private static native String setInferenceEngineBackendType_0(String var0);

    private static native void resetMyriadDevice_0();

    private static native String getInferenceEngineVPUType_0();

    private static native String getInferenceEngineCPUType_0();

    private static native void releaseHDDLPlugin_0();
}

