/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.core;

public final class CvType {
    public static final int CV_8U = 0;
    public static final int CV_8S = 1;
    public static final int CV_16U = 2;
    public static final int CV_16S = 3;
    public static final int CV_32S = 4;
    public static final int CV_32F = 5;
    public static final int CV_64F = 6;
    public static final int CV_16F = 7;
    @Deprecated
    public static final int CV_USRTYPE1 = 7;
    public static final int CV_8UC1 = CvType.CV_8UC(1);
    public static final int CV_8UC2 = CvType.CV_8UC(2);
    public static final int CV_8UC3 = CvType.CV_8UC(3);
    public static final int CV_8UC4 = CvType.CV_8UC(4);
    public static final int CV_8SC1 = CvType.CV_8SC(1);
    public static final int CV_8SC2 = CvType.CV_8SC(2);
    public static final int CV_8SC3 = CvType.CV_8SC(3);
    public static final int CV_8SC4 = CvType.CV_8SC(4);
    public static final int CV_16UC1 = CvType.CV_16UC(1);
    public static final int CV_16UC2 = CvType.CV_16UC(2);
    public static final int CV_16UC3 = CvType.CV_16UC(3);
    public static final int CV_16UC4 = CvType.CV_16UC(4);
    public static final int CV_16SC1 = CvType.CV_16SC(1);
    public static final int CV_16SC2 = CvType.CV_16SC(2);
    public static final int CV_16SC3 = CvType.CV_16SC(3);
    public static final int CV_16SC4 = CvType.CV_16SC(4);
    public static final int CV_32SC1 = CvType.CV_32SC(1);
    public static final int CV_32SC2 = CvType.CV_32SC(2);
    public static final int CV_32SC3 = CvType.CV_32SC(3);
    public static final int CV_32SC4 = CvType.CV_32SC(4);
    public static final int CV_32FC1 = CvType.CV_32FC(1);
    public static final int CV_32FC2 = CvType.CV_32FC(2);
    public static final int CV_32FC3 = CvType.CV_32FC(3);
    public static final int CV_32FC4 = CvType.CV_32FC(4);
    public static final int CV_64FC1 = CvType.CV_64FC(1);
    public static final int CV_64FC2 = CvType.CV_64FC(2);
    public static final int CV_64FC3 = CvType.CV_64FC(3);
    public static final int CV_64FC4 = CvType.CV_64FC(4);
    public static final int CV_16FC1 = CvType.CV_16FC(1);
    public static final int CV_16FC2 = CvType.CV_16FC(2);
    public static final int CV_16FC3 = CvType.CV_16FC(3);
    public static final int CV_16FC4 = CvType.CV_16FC(4);
    private static final int CV_CN_MAX = 512;
    private static final int CV_CN_SHIFT = 3;
    private static final int CV_DEPTH_MAX = 8;

    public static final int makeType(int n, int n2) {
        if (n2 <= 0 || n2 >= 512) {
            throw new UnsupportedOperationException("Channels count should be 1..511");
        }
        if (n < 0 || n >= 8) {
            throw new UnsupportedOperationException("Data type depth should be 0..7");
        }
        return (n & 7) + (n2 - 1 << 3);
    }

    public static final int CV_8UC(int n) {
        return CvType.makeType(0, n);
    }

    public static final int CV_8SC(int n) {
        return CvType.makeType(1, n);
    }

    public static final int CV_16UC(int n) {
        return CvType.makeType(2, n);
    }

    public static final int CV_16SC(int n) {
        return CvType.makeType(3, n);
    }

    public static final int CV_32SC(int n) {
        return CvType.makeType(4, n);
    }

    public static final int CV_32FC(int n) {
        return CvType.makeType(5, n);
    }

    public static final int CV_64FC(int n) {
        return CvType.makeType(6, n);
    }

    public static final int CV_16FC(int n) {
        return CvType.makeType(7, n);
    }

    public static final int channels(int n) {
        return (n >> 3) + 1;
    }

    public static final int depth(int n) {
        return n & 7;
    }

    public static final boolean isInteger(int n) {
        return CvType.depth(n) < 5;
    }

    public static final int ELEM_SIZE(int n) {
        switch (CvType.depth(n)) {
            case 0: 
            case 1: {
                return CvType.channels(n);
            }
            case 2: 
            case 3: 
            case 7: {
                return 2 * CvType.channels(n);
            }
            case 4: 
            case 5: {
                return 4 * CvType.channels(n);
            }
            case 6: {
                return 8 * CvType.channels(n);
            }
        }
        throw new UnsupportedOperationException("Unsupported CvType value: " + n);
    }

    public static final String typeToString(int n) {
        String string = switch (CvType.depth(n)) {
            case 0 -> "CV_8U";
            case 1 -> "CV_8S";
            case 2 -> "CV_16U";
            case 3 -> "CV_16S";
            case 4 -> "CV_32S";
            case 5 -> "CV_32F";
            case 6 -> "CV_64F";
            case 7 -> "CV_16F";
            default -> throw new UnsupportedOperationException("Unsupported CvType value: " + n);
        };
        int n2 = CvType.channels(n);
        if (n2 <= 4) {
            return string + "C" + n2;
        }
        return string + "C(" + n2 + ")";
    }
}

