/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.objdetect;

import java.util.List;
import org.opencv.core.Algorithm;
import org.opencv.core.Mat;
import org.opencv.objdetect.Board;
import org.opencv.objdetect.DetectorParameters;
import org.opencv.objdetect.Dictionary;
import org.opencv.objdetect.RefineParameters;
import org.opencv.utils.Converters;

public class ArucoDetector
extends Algorithm {
    protected ArucoDetector(long l) {
        super(l);
    }

    public static ArucoDetector __fromPtr__(long l) {
        return new ArucoDetector(l);
    }

    public ArucoDetector(Dictionary dictionary, DetectorParameters detectorParameters, RefineParameters refineParameters) {
        super(ArucoDetector.ArucoDetector_0(dictionary.nativeObj, detectorParameters.nativeObj, refineParameters.nativeObj));
    }

    public ArucoDetector(Dictionary dictionary, DetectorParameters detectorParameters) {
        super(ArucoDetector.ArucoDetector_1(dictionary.nativeObj, detectorParameters.nativeObj));
    }

    public ArucoDetector(Dictionary dictionary) {
        super(ArucoDetector.ArucoDetector_2(dictionary.nativeObj));
    }

    public ArucoDetector() {
        super(ArucoDetector.ArucoDetector_3());
    }

    public void detectMarkers(Mat mat, List<Mat> list, Mat mat2, List<Mat> list2) {
        Mat mat3 = new Mat();
        Mat mat4 = new Mat();
        ArucoDetector.detectMarkers_0(this.nativeObj, mat.nativeObj, mat3.nativeObj, mat2.nativeObj, mat4.nativeObj);
        Converters.Mat_to_vector_Mat(mat3, list);
        mat3.release();
        Converters.Mat_to_vector_Mat(mat4, list2);
        mat4.release();
    }

    public void detectMarkers(Mat mat, List<Mat> list, Mat mat2) {
        Mat mat3 = new Mat();
        ArucoDetector.detectMarkers_1(this.nativeObj, mat.nativeObj, mat3.nativeObj, mat2.nativeObj);
        Converters.Mat_to_vector_Mat(mat3, list);
        mat3.release();
    }

    public void refineDetectedMarkers(Mat mat, Board board, List<Mat> list, Mat mat2, List<Mat> list2, Mat mat3, Mat mat4, Mat mat5) {
        Mat mat6 = Converters.vector_Mat_to_Mat(list);
        Mat mat7 = Converters.vector_Mat_to_Mat(list2);
        ArucoDetector.refineDetectedMarkers_0(this.nativeObj, mat.nativeObj, board.nativeObj, mat6.nativeObj, mat2.nativeObj, mat7.nativeObj, mat3.nativeObj, mat4.nativeObj, mat5.nativeObj);
        Converters.Mat_to_vector_Mat(mat6, list);
        mat6.release();
        Converters.Mat_to_vector_Mat(mat7, list2);
        mat7.release();
    }

    public void refineDetectedMarkers(Mat mat, Board board, List<Mat> list, Mat mat2, List<Mat> list2, Mat mat3, Mat mat4) {
        Mat mat5 = Converters.vector_Mat_to_Mat(list);
        Mat mat6 = Converters.vector_Mat_to_Mat(list2);
        ArucoDetector.refineDetectedMarkers_1(this.nativeObj, mat.nativeObj, board.nativeObj, mat5.nativeObj, mat2.nativeObj, mat6.nativeObj, mat3.nativeObj, mat4.nativeObj);
        Converters.Mat_to_vector_Mat(mat5, list);
        mat5.release();
        Converters.Mat_to_vector_Mat(mat6, list2);
        mat6.release();
    }

    public void refineDetectedMarkers(Mat mat, Board board, List<Mat> list, Mat mat2, List<Mat> list2, Mat mat3) {
        Mat mat4 = Converters.vector_Mat_to_Mat(list);
        Mat mat5 = Converters.vector_Mat_to_Mat(list2);
        ArucoDetector.refineDetectedMarkers_2(this.nativeObj, mat.nativeObj, board.nativeObj, mat4.nativeObj, mat2.nativeObj, mat5.nativeObj, mat3.nativeObj);
        Converters.Mat_to_vector_Mat(mat4, list);
        mat4.release();
        Converters.Mat_to_vector_Mat(mat5, list2);
        mat5.release();
    }

    public void refineDetectedMarkers(Mat mat, Board board, List<Mat> list, Mat mat2, List<Mat> list2) {
        Mat mat3 = Converters.vector_Mat_to_Mat(list);
        Mat mat4 = Converters.vector_Mat_to_Mat(list2);
        ArucoDetector.refineDetectedMarkers_3(this.nativeObj, mat.nativeObj, board.nativeObj, mat3.nativeObj, mat2.nativeObj, mat4.nativeObj);
        Converters.Mat_to_vector_Mat(mat3, list);
        mat3.release();
        Converters.Mat_to_vector_Mat(mat4, list2);
        mat4.release();
    }

    public Dictionary getDictionary() {
        return new Dictionary(ArucoDetector.getDictionary_0(this.nativeObj));
    }

    public void setDictionary(Dictionary dictionary) {
        ArucoDetector.setDictionary_0(this.nativeObj, dictionary.nativeObj);
    }

    public DetectorParameters getDetectorParameters() {
        return new DetectorParameters(ArucoDetector.getDetectorParameters_0(this.nativeObj));
    }

    public void setDetectorParameters(DetectorParameters detectorParameters) {
        ArucoDetector.setDetectorParameters_0(this.nativeObj, detectorParameters.nativeObj);
    }

    public RefineParameters getRefineParameters() {
        return new RefineParameters(ArucoDetector.getRefineParameters_0(this.nativeObj));
    }

    public void setRefineParameters(RefineParameters refineParameters) {
        ArucoDetector.setRefineParameters_0(this.nativeObj, refineParameters.nativeObj);
    }

    @Override
    protected void finalize() throws Throwable {
        ArucoDetector.delete(this.nativeObj);
    }

    private static native long ArucoDetector_0(long var0, long var2, long var4);

    private static native long ArucoDetector_1(long var0, long var2);

    private static native long ArucoDetector_2(long var0);

    private static native long ArucoDetector_3();

    private static native void detectMarkers_0(long var0, long var2, long var4, long var6, long var8);

    private static native void detectMarkers_1(long var0, long var2, long var4, long var6);

    private static native void refineDetectedMarkers_0(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14, long var16);

    private static native void refineDetectedMarkers_1(long var0, long var2, long var4, long var6, long var8, long var10, long var12, long var14);

    private static native void refineDetectedMarkers_2(long var0, long var2, long var4, long var6, long var8, long var10, long var12);

    private static native void refineDetectedMarkers_3(long var0, long var2, long var4, long var6, long var8, long var10);

    private static native long getDictionary_0(long var0);

    private static native void setDictionary_0(long var0, long var2);

    private static native long getDetectorParameters_0(long var0);

    private static native void setDetectorParameters_0(long var0, long var2);

    private static native long getRefineParameters_0(long var0);

    private static native void setRefineParameters_0(long var0, long var2);

    private static native void delete(long var0);
}

