/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.dnn;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.MatOfByte;
import org.opencv.core.MatOfDouble;
import org.opencv.core.MatOfFloat;
import org.opencv.core.MatOfInt;
import org.opencv.core.Scalar;
import org.opencv.dnn.DictValue;
import org.opencv.dnn.Layer;
import org.opencv.utils.Converters;

public class Net {
    protected final long nativeObj;

    protected Net(long l) {
        this.nativeObj = l;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Net __fromPtr__(long l) {
        return new Net(l);
    }

    public Net() {
        this.nativeObj = Net.Net_0();
    }

    public static Net readFromModelOptimizer(String string, String string2) {
        return new Net(Net.readFromModelOptimizer_0(string, string2));
    }

    public static Net readFromModelOptimizer(MatOfByte matOfByte, MatOfByte matOfByte2) {
        MatOfByte matOfByte3 = matOfByte;
        MatOfByte matOfByte4 = matOfByte2;
        return new Net(Net.readFromModelOptimizer_1(matOfByte3.nativeObj, matOfByte4.nativeObj));
    }

    public boolean empty() {
        return Net.empty_0(this.nativeObj);
    }

    public String dump() {
        return Net.dump_0(this.nativeObj);
    }

    public void dumpToFile(String string) {
        Net.dumpToFile_0(this.nativeObj, string);
    }

    public void dumpToPbtxt(String string) {
        Net.dumpToPbtxt_0(this.nativeObj, string);
    }

    public int getLayerId(String string) {
        return Net.getLayerId_0(this.nativeObj, string);
    }

    public List<String> getLayerNames() {
        return Net.getLayerNames_0(this.nativeObj);
    }

    public Layer getLayer(int n) {
        return Layer.__fromPtr__(Net.getLayer_0(this.nativeObj, n));
    }

    @Deprecated
    public Layer getLayer(String string) {
        return Layer.__fromPtr__(Net.getLayer_1(this.nativeObj, string));
    }

    @Deprecated
    public Layer getLayer(DictValue dictValue) {
        return Layer.__fromPtr__(Net.getLayer_2(this.nativeObj, dictValue.getNativeObjAddr()));
    }

    public void connect(String string, String string2) {
        Net.connect_0(this.nativeObj, string, string2);
    }

    public void setInputsNames(List<String> list) {
        Net.setInputsNames_0(this.nativeObj, list);
    }

    public void setInputShape(String string, MatOfInt matOfInt) {
        MatOfInt matOfInt2 = matOfInt;
        Net.setInputShape_0(this.nativeObj, string, matOfInt2.nativeObj);
    }

    public Mat forward(String string) {
        return new Mat(Net.forward_0(this.nativeObj, string));
    }

    public Mat forward() {
        return new Mat(Net.forward_1(this.nativeObj));
    }

    public void forward(List<Mat> list, String string) {
        Mat mat = new Mat();
        Net.forward_2(this.nativeObj, mat.nativeObj, string);
        Converters.Mat_to_vector_Mat(mat, list);
        mat.release();
    }

    public void forward(List<Mat> list) {
        Mat mat = new Mat();
        Net.forward_3(this.nativeObj, mat.nativeObj);
        Converters.Mat_to_vector_Mat(mat, list);
        mat.release();
    }

    public void forward(List<Mat> list, List<String> list2) {
        Mat mat = new Mat();
        Net.forward_4(this.nativeObj, mat.nativeObj, list2);
        Converters.Mat_to_vector_Mat(mat, list);
        mat.release();
    }

    public Net quantize(List<Mat> list, int n, int n2, boolean bl) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        return new Net(Net.quantize_0(this.nativeObj, mat.nativeObj, n, n2, bl));
    }

    public Net quantize(List<Mat> list, int n, int n2) {
        Mat mat = Converters.vector_Mat_to_Mat(list);
        return new Net(Net.quantize_1(this.nativeObj, mat.nativeObj, n, n2));
    }

    public void getInputDetails(MatOfFloat matOfFloat, MatOfInt matOfInt) {
        MatOfFloat matOfFloat2 = matOfFloat;
        MatOfInt matOfInt2 = matOfInt;
        Net.getInputDetails_0(this.nativeObj, matOfFloat2.nativeObj, matOfInt2.nativeObj);
    }

    public void getOutputDetails(MatOfFloat matOfFloat, MatOfInt matOfInt) {
        MatOfFloat matOfFloat2 = matOfFloat;
        MatOfInt matOfInt2 = matOfInt;
        Net.getOutputDetails_0(this.nativeObj, matOfFloat2.nativeObj, matOfInt2.nativeObj);
    }

    public void setHalideScheduler(String string) {
        Net.setHalideScheduler_0(this.nativeObj, string);
    }

    public void setPreferableBackend(int n) {
        Net.setPreferableBackend_0(this.nativeObj, n);
    }

    public void setPreferableTarget(int n) {
        Net.setPreferableTarget_0(this.nativeObj, n);
    }

    public void setInput(Mat mat, String string, double d, Scalar scalar) {
        Net.setInput_0(this.nativeObj, mat.nativeObj, string, d, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public void setInput(Mat mat, String string, double d) {
        Net.setInput_1(this.nativeObj, mat.nativeObj, string, d);
    }

    public void setInput(Mat mat, String string) {
        Net.setInput_2(this.nativeObj, mat.nativeObj, string);
    }

    public void setInput(Mat mat) {
        Net.setInput_3(this.nativeObj, mat.nativeObj);
    }

    public void setParam(int n, int n2, Mat mat) {
        Net.setParam_0(this.nativeObj, n, n2, mat.nativeObj);
    }

    public void setParam(String string, int n, Mat mat) {
        Net.setParam_1(this.nativeObj, string, n, mat.nativeObj);
    }

    public Mat getParam(int n, int n2) {
        return new Mat(Net.getParam_0(this.nativeObj, n, n2));
    }

    public Mat getParam(int n) {
        return new Mat(Net.getParam_1(this.nativeObj, n));
    }

    public Mat getParam(String string, int n) {
        return new Mat(Net.getParam_2(this.nativeObj, string, n));
    }

    public Mat getParam(String string) {
        return new Mat(Net.getParam_3(this.nativeObj, string));
    }

    public MatOfInt getUnconnectedOutLayers() {
        return MatOfInt.fromNativeAddr(Net.getUnconnectedOutLayers_0(this.nativeObj));
    }

    public List<String> getUnconnectedOutLayersNames() {
        return Net.getUnconnectedOutLayersNames_0(this.nativeObj);
    }

    public long getFLOPS(List<MatOfInt> list) {
        return Net.getFLOPS_0(this.nativeObj, list);
    }

    public long getFLOPS(MatOfInt matOfInt) {
        MatOfInt matOfInt2 = matOfInt;
        return Net.getFLOPS_1(this.nativeObj, matOfInt2.nativeObj);
    }

    public long getFLOPS(int n, List<MatOfInt> list) {
        return Net.getFLOPS_2(this.nativeObj, n, list);
    }

    public long getFLOPS(int n, MatOfInt matOfInt) {
        MatOfInt matOfInt2 = matOfInt;
        return Net.getFLOPS_3(this.nativeObj, n, matOfInt2.nativeObj);
    }

    public void getLayerTypes(List<String> list) {
        Net.getLayerTypes_0(this.nativeObj, list);
    }

    public int getLayersCount(String string) {
        return Net.getLayersCount_0(this.nativeObj, string);
    }

    public void getMemoryConsumption(MatOfInt matOfInt, long[] lArray, long[] lArray2) {
        MatOfInt matOfInt2 = matOfInt;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Net.getMemoryConsumption_0(this.nativeObj, matOfInt2.nativeObj, dArray, dArray2);
        if (lArray != null) {
            lArray[0] = (long)dArray[0];
        }
        if (lArray2 != null) {
            lArray2[0] = (long)dArray2[0];
        }
    }

    public void getMemoryConsumption(int n, List<MatOfInt> list, long[] lArray, long[] lArray2) {
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Net.getMemoryConsumption_1(this.nativeObj, n, list, dArray, dArray2);
        if (lArray != null) {
            lArray[0] = (long)dArray[0];
        }
        if (lArray2 != null) {
            lArray2[0] = (long)dArray2[0];
        }
    }

    public void getMemoryConsumption(int n, MatOfInt matOfInt, long[] lArray, long[] lArray2) {
        MatOfInt matOfInt2 = matOfInt;
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        Net.getMemoryConsumption_2(this.nativeObj, n, matOfInt2.nativeObj, dArray, dArray2);
        if (lArray != null) {
            lArray[0] = (long)dArray[0];
        }
        if (lArray2 != null) {
            lArray2[0] = (long)dArray2[0];
        }
    }

    public void enableFusion(boolean bl) {
        Net.enableFusion_0(this.nativeObj, bl);
    }

    public void enableWinograd(boolean bl) {
        Net.enableWinograd_0(this.nativeObj, bl);
    }

    public long getPerfProfile(MatOfDouble matOfDouble) {
        MatOfDouble matOfDouble2 = matOfDouble;
        return Net.getPerfProfile_0(this.nativeObj, matOfDouble2.nativeObj);
    }

    protected void finalize() throws Throwable {
        Net.delete(this.nativeObj);
    }

    private static native long Net_0();

    private static native long readFromModelOptimizer_0(String var0, String var1);

    private static native long readFromModelOptimizer_1(long var0, long var2);

    private static native boolean empty_0(long var0);

    private static native String dump_0(long var0);

    private static native void dumpToFile_0(long var0, String var2);

    private static native void dumpToPbtxt_0(long var0, String var2);

    private static native int getLayerId_0(long var0, String var2);

    private static native List<String> getLayerNames_0(long var0);

    private static native long getLayer_0(long var0, int var2);

    private static native long getLayer_1(long var0, String var2);

    private static native long getLayer_2(long var0, long var2);

    private static native void connect_0(long var0, String var2, String var3);

    private static native void setInputsNames_0(long var0, List<String> var2);

    private static native void setInputShape_0(long var0, String var2, long var3);

    private static native long forward_0(long var0, String var2);

    private static native long forward_1(long var0);

    private static native void forward_2(long var0, long var2, String var4);

    private static native void forward_3(long var0, long var2);

    private static native void forward_4(long var0, long var2, List<String> var4);

    private static native long quantize_0(long var0, long var2, int var4, int var5, boolean var6);

    private static native long quantize_1(long var0, long var2, int var4, int var5);

    private static native void getInputDetails_0(long var0, long var2, long var4);

    private static native void getOutputDetails_0(long var0, long var2, long var4);

    private static native void setHalideScheduler_0(long var0, String var2);

    private static native void setPreferableBackend_0(long var0, int var2);

    private static native void setPreferableTarget_0(long var0, int var2);

    private static native void setInput_0(long var0, long var2, String var4, double var5, double var7, double var9, double var11, double var13);

    private static native void setInput_1(long var0, long var2, String var4, double var5);

    private static native void setInput_2(long var0, long var2, String var4);

    private static native void setInput_3(long var0, long var2);

    private static native void setParam_0(long var0, int var2, int var3, long var4);

    private static native void setParam_1(long var0, String var2, int var3, long var4);

    private static native long getParam_0(long var0, int var2, int var3);

    private static native long getParam_1(long var0, int var2);

    private static native long getParam_2(long var0, String var2, int var3);

    private static native long getParam_3(long var0, String var2);

    private static native long getUnconnectedOutLayers_0(long var0);

    private static native List<String> getUnconnectedOutLayersNames_0(long var0);

    private static native long getFLOPS_0(long var0, List<MatOfInt> var2);

    private static native long getFLOPS_1(long var0, long var2);

    private static native long getFLOPS_2(long var0, int var2, List<MatOfInt> var3);

    private static native long getFLOPS_3(long var0, int var2, long var3);

    private static native void getLayerTypes_0(long var0, List<String> var2);

    private static native int getLayersCount_0(long var0, String var2);

    private static native void getMemoryConsumption_0(long var0, long var2, double[] var4, double[] var5);

    private static native void getMemoryConsumption_1(long var0, int var2, List<MatOfInt> var3, double[] var4, double[] var5);

    private static native void getMemoryConsumption_2(long var0, int var2, long var3, double[] var5, double[] var6);

    private static native void enableFusion_0(long var0, boolean var2);

    private static native void enableWinograd_0(long var0, boolean var2);

    private static native long getPerfProfile_0(long var0, long var2);

    private static native void delete(long var0);
}

