/*
 * Decompiled with CFR 0.152.
 */
package org.opencv.dnn;

import java.util.List;
import org.opencv.core.Mat;
import org.opencv.core.Scalar;
import org.opencv.core.Size;
import org.opencv.dnn.Net;
import org.opencv.utils.Converters;

public class Model {
    protected final long nativeObj;

    protected Model(long l) {
        this.nativeObj = l;
    }

    public long getNativeObjAddr() {
        return this.nativeObj;
    }

    public static Model __fromPtr__(long l) {
        return new Model(l);
    }

    public Model(String string, String string2) {
        this.nativeObj = Model.Model_0(string, string2);
    }

    public Model(String string) {
        this.nativeObj = Model.Model_1(string);
    }

    public Model(Net net) {
        this.nativeObj = Model.Model_2(net.nativeObj);
    }

    public Model setInputSize(Size size) {
        return new Model(Model.setInputSize_0(this.nativeObj, size.width, size.height));
    }

    public Model setInputSize(int n, int n2) {
        return new Model(Model.setInputSize_1(this.nativeObj, n, n2));
    }

    public Model setInputMean(Scalar scalar) {
        return new Model(Model.setInputMean_0(this.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]));
    }

    public Model setInputScale(Scalar scalar) {
        return new Model(Model.setInputScale_0(this.nativeObj, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]));
    }

    public Model setInputCrop(boolean bl) {
        return new Model(Model.setInputCrop_0(this.nativeObj, bl));
    }

    public Model setInputSwapRB(boolean bl) {
        return new Model(Model.setInputSwapRB_0(this.nativeObj, bl));
    }

    public Model setOutputNames(List<String> list) {
        return new Model(Model.setOutputNames_0(this.nativeObj, list));
    }

    public void setInputParams(double d, Size size, Scalar scalar, boolean bl, boolean bl2) {
        Model.setInputParams_0(this.nativeObj, d, size.width, size.height, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], bl, bl2);
    }

    public void setInputParams(double d, Size size, Scalar scalar, boolean bl) {
        Model.setInputParams_1(this.nativeObj, d, size.width, size.height, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3], bl);
    }

    public void setInputParams(double d, Size size, Scalar scalar) {
        Model.setInputParams_2(this.nativeObj, d, size.width, size.height, scalar.val[0], scalar.val[1], scalar.val[2], scalar.val[3]);
    }

    public void setInputParams(double d, Size size) {
        Model.setInputParams_3(this.nativeObj, d, size.width, size.height);
    }

    public void setInputParams(double d) {
        Model.setInputParams_4(this.nativeObj, d);
    }

    public void setInputParams() {
        Model.setInputParams_5(this.nativeObj);
    }

    public void predict(Mat mat, List<Mat> list) {
        Mat mat2 = new Mat();
        Model.predict_0(this.nativeObj, mat.nativeObj, mat2.nativeObj);
        Converters.Mat_to_vector_Mat(mat2, list);
        mat2.release();
    }

    public Model setPreferableBackend(int n) {
        return new Model(Model.setPreferableBackend_0(this.nativeObj, n));
    }

    public Model setPreferableTarget(int n) {
        return new Model(Model.setPreferableTarget_0(this.nativeObj, n));
    }

    public Model enableWinograd(boolean bl) {
        return new Model(Model.enableWinograd_0(this.nativeObj, bl));
    }

    protected void finalize() throws Throwable {
        Model.delete(this.nativeObj);
    }

    private static native long Model_0(String var0, String var1);

    private static native long Model_1(String var0);

    private static native long Model_2(long var0);

    private static native long setInputSize_0(long var0, double var2, double var4);

    private static native long setInputSize_1(long var0, int var2, int var3);

    private static native long setInputMean_0(long var0, double var2, double var4, double var6, double var8);

    private static native long setInputScale_0(long var0, double var2, double var4, double var6, double var8);

    private static native long setInputCrop_0(long var0, boolean var2);

    private static native long setInputSwapRB_0(long var0, boolean var2);

    private static native long setOutputNames_0(long var0, List<String> var2);

    private static native void setInputParams_0(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16, boolean var17);

    private static native void setInputParams_1(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, boolean var16);

    private static native void setInputParams_2(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14);

    private static native void setInputParams_3(long var0, double var2, double var4, double var6);

    private static native void setInputParams_4(long var0, double var2);

    private static native void setInputParams_5(long var0);

    private static native void predict_0(long var0, long var2, long var4);

    private static native long setPreferableBackend_0(long var0, int var2);

    private static native long setPreferableTarget_0(long var0, int var2);

    private static native long enableWinograd_0(long var0, boolean var2);

    private static native void delete(long var0);
}

