package ro.sync.lexer.ant;
import ro.sync.lexer.AbstractLexer;

@SuppressWarnings("unused")
%%

%public 
%class AntPropertyLexer
%extends AbstractLexer
%unicode
%char
%type ro.sync.lexer.Symbol
 
%ignorecase
%scanerror ro.sync.lexer.LexerException

%{
    private static final byte SYM_PROPERTY_NAME      = AntPropertyTokens.PROPERTY_NAME;
    private static final byte SYM_PROPERTY_START     = AntPropertyTokens.PROPERTY_START;
    private static final byte SYM_PROPERTY_END       = AntPropertyTokens.PROPERTY_END;
    private static final byte SYM_COLON              = AntPropertyTokens.COLON;
    private static final byte SYM_REFERENCE          = AntPropertyTokens.REFERENCE;
    private static final byte SYM_TEXT               = AntPropertyTokens.PROPERTY_TEXT;

    /**
     * Create an empty lexer, yyreset will be called later to reset and assign
     * the reader
     */
    public AntPropertyLexer() {
        super();
    }
    
    public String getName() {
      return ANT_LEXER;
    }
%}

%xstate PROPERTY, REFERENCE

GeneralChar = [^$]
NameChar = [^ \t:\}]
WS = [ \t]

%%

<YYINITIAL> 
{
    {GeneralChar}+                 {
                                        cLen += yylength();
                                   }
   "$$"                            {
                                        cLen += 2;
                                   }  
   "${"                            {
                                        if (cLen > 0) {
                                          yypushback(2);
                                          return flush(SYM_TEXT);
                                        } else {
                                          yybegin(PROPERTY);
                                          return symbol(SYM_PROPERTY_START);
                                        }
                                   }
   "$"                             {    cLen++;                             }
                                    
    {WS}+                          {    sLen += yylength();                 }
    <<EOF>>                        {    return flush(SYM_TEXT);             }
}

<PROPERTY>
{
    {NameChar}+                    {   return symbol(SYM_PROPERTY_NAME);    }
    "}"                            {
                                        yybegin(YYINITIAL);   
                                        return symbol(SYM_PROPERTY_END);       
                                   }
    ":"                            {   
                                        yybegin(REFERENCE);
    									                  return symbol(SYM_COLON);    
    							                 }
    {WS}+                          {   
                      									yybegin(YYINITIAL);
                      									return symbol(SYM_TEXT);    
    							                 }							   
    <<EOF>>                        {   
                                        yybegin(YYINITIAL);
                                   }
}

<REFERENCE>
{
    {NameChar}+                    {    return symbol(SYM_REFERENCE);    }
    "}"                            {
                                        yybegin(YYINITIAL);   
                                        return symbol(SYM_PROPERTY_END);       
                                   }
    ":"                            {   
                                        yybegin(YYINITIAL);
                  									    return symbol(SYM_TEXT);    
                  							   }
    {WS}+                          {   
                      									yybegin(YYINITIAL);
                      									return symbol(SYM_TEXT);    
    							                 }							   
    <<EOF>>                        {   
                                        yybegin(YYINITIAL);
                                   }     
}