package ro.sync.lexer.properties;
import ro.sync.lexer.AbstractLexer;

@SuppressWarnings("unused")
%%

%public 
%class PropertiesLexer
%extends AbstractLexer
%unicode
%char
%type ro.sync.lexer.Symbol
 
%ignorecase
%scanerror ro.sync.lexer.LexerException

%{
    private static final byte SYM_PROPERTY           = PropertiesTokens.PROPERTY;
    private static final byte SYM_VALUE              = PropertiesTokens.VALUE;
    private static final byte SYM_EQUAL              = PropertiesTokens.EQUAL;
    private static final byte SYM_TEXT               = PropertiesTokens.TEXT;
    private static final byte SYM_COMMENT            = PropertiesTokens.COMMENT;

    /**
     * Create an empty lexer, yyreset will be called later to reset and assign
     * the reader
     */
    public PropertiesLexer() {
        super();
    }
    
    public String getName() {
      return PROPERTIES_LEXER;
    }
%}

%xstate KEY, VALUE, COMMENT

KeyCharacter = [a-zA-Z0-9._-]
GeneralChar = [^a-zA-Z0-9._-#=] 
WS = [ \t]

%%

<YYINITIAL> 
{
    {KeyCharacter}+                 {
                                        yybegin(KEY);
                                        return symbol(SYM_PROPERTY);
                                    }
    {WS}+                           {   return symbol(SYM_TEXT);    }
    "#"                             { 
                                        yypushback(1);
                                        yybegin(COMMENT);   
                                    }
    "!"                             { 
                                        yypushback(1);
                                        yybegin(COMMENT);   
                                    }
}
<KEY>
{
    "="                             {
                                        yybegin(VALUE);   
                                        return symbol(SYM_EQUAL);       
                                    }
    {WS}+                           {   return symbol(SYM_TEXT);    }
    {GeneralChar}+                  {   return symbol(SYM_TEXT);    }
    <<EOF>>                         {   
                                        yybegin(YYINITIAL);
                                    }
}
<VALUE> 
{
    .                               {   cLen++;                     }
    <<EOF>>                         {   
                                        yybegin(YYINITIAL);
                                        return flush(SYM_VALUE);
                                    }
}
<COMMENT> 
{
    .                               {   cLen++;                     }
    <<EOF>>                         {   
                                        yybegin(YYINITIAL);
                                        return flush(SYM_COMMENT);
                                    }
}
