//////////////////////////////////////////////////////////////
// The following functions are also declared as "window" object
// functions. Because most JS scripts are run inside browser
// these functions are available also directly.
//////////////////////////////////////////////////////////////

 /**
  * Displays an alert box with a message and an OK button.
  *
  * @param msg The message to display.
  */
 function alert(msg){};
 /**
  * Removes focus from the current window. 
  */
 function blur(){};
 /**
  * Clears a timer set with setInterval().
  *
  * @param id_setinterval The id returned by a previously call to setInterval() method.
  */
 function clearInterval(id_setinterval){};
 /**
  * Clears a timer set with setTimeout().
  *
  * @param id_settimeout The id returned by a previously call to setTimeout() method.
  */
 function clearTimeout(id_settimeout){};
 /**
  * Closes the current window. 
  */
 function close(){};
 /**
  * Displays a dialog box with a message and an OK and a Cancel button.
  *
  * @param msg The message to display.
  */
 function confirm(msg){};
 /**
  * Creates a pop-up window.
  *
  * @return The newly created pop-up window.
  */
 function createPopup(){};
 /**
  * Sets focus to the current window. 
  */
 function focus(){};
 /**
  * Moves a window relative to its current position.
  *
  * @param x The movement on X coordinate (as an integer number of pixels) relative to the current position.
  * @param y The movement on Y coordinate (as an integer number of pixels) relative to the current position.
  */
 function moveBy(x, y){};
 /**
  * Moves a window to the specified position.
  *
  * @param x The new X coordinate of the top-left corner of the window. 
  * @param y The new Y coordinate of the top-left corner of the window.
  */
 function moveTo(x, y){};
  /**
  * Opens a new browser window.
  *
  * @param URL   Optional. Specifies the URL of the page to open.
  * @param name  Optional. Specifies the target attribute or the name of the window. 
  *              The following values are supported:
  *                - _blank  - URL is loaded into a new window. This is default.
  *                - _parent - URL is loaded into the parent frame.
  *                - _self   - URL replaces the current page.
  *                - _top    - URL replaces any framesets that may be loaded.
  *                - name    - The name of the window.
  * @param specs Optional. A comma-separated list of items.
  * @param repl  Optional.Specifies whether the URL creates a new entry or replaces 
  *              the current entry in the history list. The following values are supported:
  *                - true    - URL replaces the current document in the history list. 
  *                - false   - URL creates a new entry in the history list. 
  */
 function open(URL, name, specs, repl){};
 /**
  * Prints the content of the current window. 
  */
 function print(){};
 /**
  * Displays a dialog box that prompts the visitor for input.
  *
  * @param msg         Required. The message to display in the dialog box.
  * @param defaultText Optional. The default input value.
  *
  * @return            The string the visitor has entered.
  */
 function prompt(msg, defaultText){};
 /**
  * Resizes the window by the specified numbers of pixels.
  *
  * @param width  Required. A positive or a negative number that specifies how many pixels to resize the width by.
  * @param height Required. A positive or a negative number that specifies how many pixels to resize the height by.
  */
 function resizeBy(width, height){};
 /**
  * Resizes the window to the specified width and height.
  *
  * @param width  Required. Sets the width of the window, in pixels.
  * @param height Required. Sets the height of the window, in pixels.
  */
 function resizeTo(width, height){};
 /**
  * Scrolls the content of the window.  
  */
 function scroll(){};
 /**
  * Scrolls the content by the specified numbers of pixels.
  *
  * @param xnum Required. How many pixels to scroll by, along the x-axis (horizontal).
  * @param ynum Required. How many pixels to scroll by, along the y-axis (vertical).
  */
 function scrollBy(xnum, ynum){};
 /**
  * Scrolls the content to the specified coordinates.
  *
  * @param xpos Required. The coordinate to scroll to, along the x-axis.
  * @param ypos Required. The coordinate to scroll to, along the y-axis.  
  */
 function scrollTo(xpos, ypos){};
 /**
  * Calls a function or evaluates an expression at specified intervals (in milliseconds).
  *
  * @param code   Required. A reference to the function or the code to be executed.
  * @param millis Required. The intervals (in milliseconds) on how often to execute the code.
  * @param lang   Optional. JScript | VBScript | JavaScript.
  *
  * @return       An id (that can be used as the parameter for the clearInterval() method).
  */
 function setInterval(code, millis, lang){};
 /**
  * Calls a function or evaluates an expression after a specified time interval (in milliseconds).
  *
  * @param code   Required. The coordinate to scroll to, along the x-axis.
  * @param millis Required. The number of milliseconds to wait before executing the code.
  * @param lang   Optional. The scripting language: JScript | VBScript | JavaScript.
  *
  * @return       An id (that can be used as the parameter for the clearTimeout() method).   
  */
 function setTimeout(code, millis, lang){}

//////////////////////////////////////////////
// Objects.
//////////////////////////////////////////////


/**
* Represents an open window in a browser.
*/
window.prototype = {
 /**
  * A Boolean value indicating whether a window has been closed, or not.
  */
 closed:0,
 /**
  * The default text in the status bar of a window.
  */
 defaultStatus:0,
 /**
  * The Document object for the window.
  */
 document:0,
 /**
  * An array of all the frames (including iframes) in the current window.
  */
 frames:0,
 /**
  * The History object for the window .
  */
 history:0,
 /**
  * The inner height of a window's content area.
  */
 innerHeight:0,
 /**
  * The inner width of a window's content area.
  */
 innerWidth:0,
 /**
  * The number of frames (including iframes) in a window.  
  */
 length:0,
 /**
  * The Location object for the window.
  */
 location:0,
 /**
  * The name of a window.  
  */
 name:0,
 /**
  * The Navigator object for the window.  
  */
 navigator:0,
 /**
  * A reference to the window that created the window.  
  */
 opener:0,
 /**
  * The outer height of a window, including toolbars/scrollbars.  
  */
 outerHeight:0,
 /**
  * The outer width of a window, including toolbars/scrollbars.  
  */
 outerWidth:0,
 /**
  * The pixels the current document has been scrolled horizontally from 
  * the upper left corner of the window.  
  */
 pageXOffset:0,
 /**
  * The pixels the current document has been scrolled vertically from 
  * the upper left corner of the window.  
  */
 pageYOffset:0,
 /**
  * The parent window of the current window.  
  */
 parent:0,
 /**
  * The Screen object for the window.  
  */
 screen:0,
 /**
  * The x coordinate of the window relative to the screen.  
  */
 screenLeft:0,
 /**
  * The y coordinate of the window relative to the screen.  
  */
 screenTop:0,
 /**
  * The x coordinate of the window relative to the screen.  
  */
 screenX:0,
 /**
  * The y coordinate of the window relative to the screen.  
  */
 screenY:0,
 /**
  * The current window.  
  */
 self:0,
 /**
  * The text in the statusbar of a window.  
  */
 status:0,
 /**
  * The topmost browser window.  
  */
 top:0,
 /**
  * Displays an alert box with a message and an OK button.
  *
  * @param msg The message to display.
  */
 alert:function(msg){},
 /**
  * Removes focus from the current window. 
  */
 blur:function(){},
 /**
  * Clears a timer set with setInterval().
  *
  * @param id_setinterval The id returned by a previously call to setInterval() method.
  */
 clearInterval:function(id_setinterval){},
 /**
  * Clears a timer set with setTimeout().
  *
  * @param id_settimeout The id returned by a previously call to setTimeout() method.
  */
 clearTimeout:function(id_settimeout){},
 /**
  * Closes the current window. 
  */
 close:function(){},
 /**
  * Displays a dialog box with a message and an OK and a Cancel button.
  *
  * @param msg The message to display.
  */
 confirm:function(msg){},
 /**
  * Creates a pop-up window.
  *
  * @return The newly created pop-up window.
  */
 createPopup:function(){},
 /**
  * Sets focus to the current window. 
  */
 focus:function(){},
 /**
  * Moves a window relative to its current position.
  *
  * @param x The movement on X coordinate (as an integer number of pixels) relative to the current position.
  * @param y The movement on Y coordinate (as an integer number of pixels) relative to the current position.
  */
 moveBy:function(x, y){},
 /**
  * Moves a window to the specified position.
  *
  * @param x The new X coordinate of the top-left corner of the window. 
  * @param y The new Y coordinate of the top-left corner of the window.
  */
 moveTo:function(x, y){},
 /**
  * Opens a new browser window.
  *
  * @param URL   Optional. Specifies the URL of the page to open.
  * @param name  Optional. Specifies the target attribute or the name of the window. 
  *              The following values are supported:
  *                - _blank  - URL is loaded into a new window. This is default.
  *                - _parent - URL is loaded into the parent frame.
  *                - _self   - URL replaces the current page.
  *                - _top    - URL replaces any framesets that may be loaded.
  *                - name    - The name of the window.
  * @param specs Optional. A comma-separated list of items.
  * @param repl  Optional.Specifies whether the URL creates a new entry or replaces 
  *              the current entry in the history list. The following values are supported:
  *                - true    - URL replaces the current document in the history list. 
  *                - false   - URL creates a new entry in the history list. 
  */
 open:function(URL, name, specs, repl){},
 /**
  * Prints the content of the current window. 
  */
 print:function(){},
 /**
  * Displays a dialog box that prompts the visitor for input.
  *
  * @param msg         Required. The message to display in the dialog box.
  * @param defaultText Optional. The default input value.
  *
  * @return            The string the visitor has entered.
  */
 prompt:function(msg, defaultText){},
 /**
  * Resizes the window by the specified numbers of pixels.
  *
  * @param width  Required. A positive or a negative number that specifies how many pixels to resize the width by.
  * @param height Required. A positive or a negative number that specifies how many pixels to resize the height by.
  */
 resizeBy:function(width, height){},
 /**
  * Resizes the window to the specified width and height.
  *
  * @param width  Required. Sets the width of the window, in pixels.
  * @param height Required. Sets the height of the window, in pixels.
  */
 resizeTo:function(width, height){},
 /**
  * Scrolls the content of the window.  
  */
 scroll:function(){},
 /**
  * Scrolls the content by the specified numbers of pixels.
  *
  * @param xnum Required. How many pixels to scroll by, along the x-axis (horizontal).
  * @param ynum Required. How many pixels to scroll by, along the y-axis (vertical).
  */
 scrollBy:function(xnum, ynum){},
 /**
  * Scrolls the content to the specified coordinates.
  *
  * @param xpos Required. The coordinate to scroll to, along the x-axis.
  * @param ypos Required. The coordinate to scroll to, along the y-axis.  
  */
 scrollTo:function(xpos, ypos){},
 /**
  * Calls a function or evaluates an expression at specified intervals (in milliseconds).
  *
  * @param code   Required. A reference to the function or the code to be executed.
  * @param millis Required. The intervals (in milliseconds) on how often to execute the code.
  * @param lang   Optional. JScript | VBScript | JavaScript.
  *
  * @return       An id (that can be used as the parameter for the clearInterval() method).
  */
 setInterval:function(code, millis, lang){},
 /**
  * Calls a function or evaluates an expression after a specified time interval (in milliseconds).
  *
  * @param code   Required. The coordinate to scroll to, along the x-axis.
  * @param millis Required. The number of milliseconds to wait before executing the code.
  * @param lang   Optional. The scripting language: JScript | VBScript | JavaScript.
  *
  * @return       An id (that can be used as the parameter for the clearTimeout() method).   
  */
 setTimeout:function(code, millis, lang){}
}


/**
* Contains information about the browser.
*/
navigator.prototype = {
 /**
  * The code name of the browser.
  */
 appCodeName:0,
 /**
  * The name of the browser.
  */
 appName:0,
 /**
  * The version information of the browser.
  */
 appVersion:0,
 /**
  * Determines whether cookies are enabled in the browser, or not. 
  */
 cookieEnabled:0,
 /**
  * Specifies for which platform the browser is compiled.
  */
 platform:0,
 /**
  * The user-agent header sent by the browser to the server.
  */
 userAgent:0,
 /**
  * Specifies whether or not the browser has Java enabled.
  *
  * @return A Boolean value that specifies whether the browser has Java enabled.
  */
 javaEnabled:function(){},
 /**
  * Specifies whether or not the browser has data tainting enabled.
  *
  * @return A Boolean value that specifies whether the browser has data tainting enabled.
  */
 taintEnabled:function(){}
}


/**
* Contains information about the visitor's screen.
*/
screen.prototype = {
 /**
  * The height of the screen (excluding the Windows Taskbar).
  */
 availHeight:0,
 /**
  * The width of the screen (excluding the Windows Taskbar).
  */
 availWidth:0,
 /**
  * The bit depth of the color palette for displaying images.
  */
 colorDepth:0,
 /**
  * The total height of the screen. 
  */
 height:0,
 /**
  * The color resolution (in bits per pixel) of the screen.
  */
 pixelDepth:0,
 /**
  * The total width of the screen.
  */
 width:0
}


/**
* Contains the URLs visited by the user (within a browser window).
*/
history.prototype = {
 /**
  * The number of URLs in the history list.
  */
 length:0,
 /**
  * Loads the previous URL in the history list. 
  */
 back:function(){},
 /**
  * Loads the next URL in the history list. 
  */
 forward:function(){},
 /**
  * Loads a specific URL from the history list.
  *
  * @param toGo can either be a number which goes to the URL within the specific position 
  *             (-1 goes back one page, 1 goes forward one page), or a string. 
  *             The string must be a partial or full URL, and the function will go to the first URL 
  *             that matches the string.
  */
 go:function(toGo){}
}


/**
* Contains the URLs visited by the user (within a browser window).
*/
location.prototype = {
 /**
  * The anchor portion of a URL.
  */
 hash:0,
 /**
  * The hostname and port of a URL.
  */
 host:0,
 /**
  * The hostname of a URL.
  */
 hostname:0,
 /**
  * The entire URL.
  */
 href:0,
 /**
  * The path name of a URL. 
  */
 pathname:0,
 /**
  * The port number the server uses for a URL.
  */
 port:0,
 /**
  * The protocol of a URL.
  */
 protocol:0,
 /**
  * The query portion of a URL.
  */
 search:0,
 /**
  * Loads a new document.
  *
  * @param URL The URL of the new document to load.
  */
 assign:function(URL){},
 /**
  * Reloads the current document. 
  */
 reload:function(){},
 /**
  * Replaces the current document with a new one.
  *
  * @param newURL The URL of the new document to replace the current one.
  */
 replace:function(newURL){}
}