#!/bin/sh
# Oxygen Startup script
# (c) 2006 Syncro Soft Ltd.

oldpwd=`pwd`

# Resolve the location of the oxygen installation.
# This includes resolving any symlinks.
PRG=$0
cd "`dirname "$PRG"`"
PRG=`basename "$PRG"`

while [ -L "$PRG" ]
do
	PRG="`readlink "$PRG"`"
	cd "`dirname "$PRG"`"
	PRG="`basename "$PRG"`"
done

OXYGEN_HOME=`dirname "$PRG"`

# Absolutize dir
cd "${OXYGEN_HOME}"; OXYGEN_HOME=`pwd`
cd "${oldpwd}"; unset oldpwd

# Classpath
CP=$OXYGEN_HOME
CP=$CP:$OXYGEN_HOME/lib/oxygen.jar
CP=$CP:$OXYGEN_HOME/lib/oxygenAuthor.jar
CP=$CP:$OXYGEN_HOME/lib/oxygenDeveloper.jar
CP=$CP:$OXYGEN_HOME/lib/syncroSVNClient.jar
CP=$CP:$OXYGEN_HOME/lib/oxygenXMLDiff.jar
CP=$CP:$OXYGEN_HOME/lib/org.eclipse.wst.xml.xpath2.processor_1.2.0.jar
CP=$CP:$OXYGEN_HOME/lib/xml-apis.jar
CP=$CP:$OXYGEN_HOME/lib/xercesImpl.jar
CP=$CP:$OXYGEN_HOME/classes
CP=$CP:$OXYGEN_HOME/lib/jide.jar
CP=$CP:$OXYGEN_HOME/lib/jh.jar
CP=$CP:$OXYGEN_HOME/lib/editorHelp.jar
CP=$CP:$OXYGEN_HOME/lib/authorHelp.jar
CP=$CP:$OXYGEN_HOME/lib/developerHelp.jar
CP=$CP:$OXYGEN_HOME/lib/svnClientHelp.jar
CP=$CP:$OXYGEN_HOME/lib/diffHelp.jar
CP=$CP:$OXYGEN_HOME/lib/log4j.jar
CP=$CP:$OXYGEN_HOME/lib/commons-httpclient-3.1.jar
CP=$CP:$OXYGEN_HOME/lib/commons-codec-1.3.jar
CP=$CP:$OXYGEN_HOME/lib/commons-logging-1.0.4.jar

OXYGEN_JAVA=java
if [ -f "${JAVA_HOME}/bin/java" ]
then
  OXYGEN_JAVA="${JAVA_HOME}/bin/java"
fi
if [ -f "${OXYGEN_HOME}/.install4j/jre.bundle/Contents/Home/jre/bin/java" ]
then
  OXYGEN_JAVA="${OXYGEN_HOME}/.install4j/jre.bundle/Contents/Home/jre/bin/java"
fi

"${OXYGEN_JAVA}" -Xdock:name="User Manual"\
  -Xdock:icon="$OXYGEN_HOME/User Manual.app/Contents/Resources/UserManual.icns"\
  -Xms20m\
  -Xmx128m\
  -XX:SoftRefLRUPolicyMSPerMB=10\
  -cp "$CP"\
  ro.sync.exml.HelpFrame UserManual_svnClient