/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;

@API(type=APIType.EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class ProxyNamespaceMapping
implements Cloneable {
    private static Logger b = Logger.getLogger((String)ProxyNamespaceMapping.class.getName());
    private List<String> d = new ArrayList<String>(2);
    private List<String> c = new ArrayList<String>(2);

    public ProxyNamespaceMapping(Node node) {
        this.update(node);
    }

    public ProxyNamespaceMapping() {
        this.addMapping("", "");
    }

    private ProxyNamespaceMapping(List<String> list, List<String> list2) {
        this.d.addAll(list);
        this.c.addAll(list2);
    }

    public void update(Node node) {
        this.d.clear();
        this.c.clear();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            NamedNodeMap namedNodeMap;
            if (node2.getNodeType() != 1 || !node2.hasAttributes() || (namedNodeMap = node2.getAttributes()) == null) continue;
            int n2 = namedNodeMap.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Attr attr = (Attr)namedNodeMap.item(i2);
                String string = attr.getNodeName();
                if (!string.startsWith("xmlns")) continue;
                String string2 = string.length() == 5 ? "" : string.substring(6);
                this.d.add(0, string2);
                this.c.add(0, attr.getValue());
            }
        }
        this.d.add(0, "");
        this.c.add(0, "");
    }

    public void addMapping(String string, String string2) {
        if (b.isDebugEnabled()) {
            b.debug((Object)("Add proxy namespace mapping: '" + string + "' - '" + string2 + "'"));
        }
        if (string == null) {
            throw new IllegalArgumentException("Proxy cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Namespace cannot be null");
        }
        this.d.add(string);
        this.c.add(string2);
    }

    public String getNamespaceForAttributePrefix(String string) {
        if (string == null || "".equals(string)) {
            return "";
        }
        return this.getNamespaceForPrefix(string);
    }

    public String getNamespaceForPrefix(String string) {
        if (string == null) {
            string = "";
        }
        if ("xml".equals(string)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if ("xmlns".equals(string)) {
            return "http://www.w3.org/2000/xmlns/";
        }
        int n2 = this.d.size();
        String string2 = null;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (!this.d.get(i2).equals(string)) continue;
            string2 = this.c.get(i2);
            break;
        }
        return string2;
    }

    public String[] getPrefixesForNamespace(String string) {
        return this.c(string, true);
    }

    public String getPrefixForNamespace(String string) {
        return this.b(string, true);
    }

    public String getPrefixForAttributeNamespace(String string) {
        return this.b(string, false);
    }

    protected final String b(String string, boolean bl) {
        if (string == null) {
            string = "";
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return "xml";
        }
        int n2 = this.d.size();
        String string2 = null;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (!this.c.get(i2).equals(string)) continue;
            string2 = this.d.get(i2);
            if (this.d.lastIndexOf(string2) == i2 && (bl || string2 != null && !"".equals(string2))) break;
            string2 = null;
        }
        return string2;
    }

    protected final String[] c(String string, boolean bl) {
        if (string == null) {
            string = "";
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(string)) {
            return new String[]{"xml"};
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = this.d.size();
        String string2 = null;
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (!this.c.get(i2).equals(string)) continue;
            string2 = this.d.get(i2);
            if (bl || string2 != null && !"".equals(string2)) {
                arrayList.add(string2);
            }
            string2 = null;
        }
        return arrayList.toArray(new String[0]);
    }

    public void removeByPrefix(String string) {
        int n2 = this.d.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (!this.d.get(i2).equals(string)) continue;
            this.d.remove(i2);
            this.c.remove(i2);
            break;
        }
    }

    public void removeByNamespace(String string) {
        int n2 = this.d.size();
        for (int i2 = n2 - 1; i2 >= 0; --i2) {
            if (!this.c.get(i2).equals(string)) continue;
            this.d.remove(i2);
            this.c.remove(i2);
            break;
        }
    }

    public void clear() {
        this.c.clear();
        this.d.clear();
        this.addMapping("", "");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.hashCode());
        Iterator<String> iterator = this.d.iterator();
        Iterator<String> iterator2 = this.c.iterator();
        while (iterator.hasNext() && iterator2.hasNext()) {
            String string = iterator.next();
            String string2 = iterator2.next();
            stringBuffer.append("'" + string + "'-'" + string2 + "',  ");
        }
        return stringBuffer.toString();
    }

    public void removeLastMapping() {
        this.c.remove(this.c.size() - 1);
        this.d.remove(this.d.size() - 1);
    }

    public Set<String> getNamespaces() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(this.c);
        linkedHashSet.remove("");
        return linkedHashSet;
    }

    public Object clone() {
        ProxyNamespaceMapping proxyNamespaceMapping = new ProxyNamespaceMapping(this.d, this.c);
        return proxyNamespaceMapping;
    }

    public List<String> getProxies() {
        return this.d;
    }

    public ProxyNamespaceMapping getMappingsFromAncestor(ProxyNamespaceMapping proxyNamespaceMapping) {
        ProxyNamespaceMapping proxyNamespaceMapping2 = new ProxyNamespaceMapping();
        proxyNamespaceMapping2.c.clear();
        proxyNamespaceMapping2.d.clear();
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(this.d);
        for (String string : treeSet) {
            String string2 = this.getNamespaceForPrefix(string);
            String string3 = proxyNamespaceMapping.getNamespaceForPrefix(string);
            boolean bl = string2 == null && string3 == null || string2 != null && string3 != null && string2.equals(string3);
            if (bl) continue;
            proxyNamespaceMapping2.addMapping(string, string2);
        }
        return proxyNamespaceMapping2;
    }

    public void updateNamespaceProxyMapping(String string, String string2) {
        if (this.c.contains(string)) {
            this.removeByNamespace(string);
            this.addMapping(string2, string);
        }
    }
}

