/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.db.nxd.u;
import ro.sync.exml.workspace.b.c.b;
import ro.sync.io.FileSystemUtil;
import ro.sync.util.BasicEqualer;
import ro.sync.util.CorrectURLUtil;
import ro.sync.util.PlatformDetector;
import ro.sync.util.fb;
import ro.sync.util.z;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class URLUtil
extends CorrectURLUtil {
    private static final Logger c = Logger.getLogger((String)URLUtil.class.getName());
    private static b d;

    public static String extractFileName(URL uRL) {
        String[] stringArray = URLUtil.extractPathAndFileName(uRL);
        if (stringArray != null) {
            return stringArray[1];
        }
        return null;
    }

    public static String[] extractPathAndFileName(URL uRL) {
        if (uRL == null) {
            return null;
        }
        String[] stringArray = new String[2];
        String string = uRL.toString();
        int n2 = string.lastIndexOf(47);
        if (uRL.getPath() == "" || n2 + 1 == string.length()) {
            try {
                uRL = new URL(uRL, "index.html");
                string = uRL.toString();
                n2 = string.lastIndexOf(47);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (n2 != -1) {
            stringArray[0] = string.substring(0, n2 + 1);
            stringArray[1] = string.substring(n2 + 1);
            stringArray[1] = URLUtil.removeQueryOrAnchorFromName(stringArray[1]);
        }
        return stringArray;
    }

    public static String[] extractPathAndFileName(String string) {
        if (string == null) {
            return null;
        }
        int n2 = (string = URLUtil.removeQueryOrAnchorFromName(string)).lastIndexOf(47);
        if (n2 == -1) {
            n2 = string.lastIndexOf(92);
        }
        String[] stringArray = new String[2];
        if (n2 != -1) {
            stringArray[0] = string.substring(0, n2 + 1);
            stringArray[1] = string.substring(n2 + 1);
        } else {
            stringArray[0] = string;
            stringArray[1] = "";
        }
        return stringArray;
    }

    public static URL maskUserInfo(URL uRL) {
        try {
            return URLUtil.attachUserInfo(uRL, URLUtil.extractUser(uRL.getUserInfo()), null);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static String getDescription(URL uRL) {
        String string = null;
        if (uRL != null) {
            if (uRL.getProtocol().equals("file")) {
                string = URLUtil.getCanonicalFileFromFileUrl(uRL).toString();
            } else {
                URL uRL2 = URLUtil.maskUserInfo(uRL);
                if (uRL2 != null) {
                    string = URLUtil.uncorrect(uRL2.toString());
                }
            }
        }
        return string;
    }

    public static String getDescription(String string) {
        String string2 = string;
        try {
            string2 = URLUtil.getDescription(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return string2;
    }

    public static String extractFileName(String string) {
        return URLUtil.extractFileName(string, true);
    }

    public static String extractFileName(String string, boolean bl) {
        int n2;
        if (string == null) {
            return null;
        }
        String string2 = null;
        if (bl) {
            string = URLUtil.removeQueryOrAnchorFromName(string);
        }
        if ((n2 = string.lastIndexOf(47)) == -1) {
            n2 = string.lastIndexOf(92);
        }
        string2 = n2 != -1 ? string.substring(n2 + 1) : string;
        return string2;
    }

    public static URL correctFileExtension(URL uRL, String string) {
        int n2;
        String string2 = uRL.toString();
        int n3 = string2.lastIndexOf(47);
        if (n3 == -1) {
            n3 = 0;
        }
        if ((n2 = string2.lastIndexOf(46)) < n3 && !"".equals(string)) {
            string2 = string2 + "." + string;
        }
        try {
            return new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            return uRL;
        }
    }

    public static File correctFileExtension(File file, String string) {
        String string2 = file.getAbsolutePath();
        String string3 = file.getName();
        if (!string3.contains(".")) {
            string2 = string2 + "." + string;
        }
        return new File(string2);
    }

    public static String removeExtension(String string) {
        int n2;
        if (string != null && (n2 = string.lastIndexOf(46)) != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    public static boolean isFromUNCPath(URL uRL) {
        return uRL != null && uRL.toString().startsWith("file:////");
    }

    public static boolean isFromLocalDrive(String string) {
        URL uRL = null;
        try {
            uRL = URLUtil.correct(new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL != null && "file".equals(uRL.getProtocol()) && !URLUtil.isFromUNCPath(uRL);
    }

    public static boolean isFromLocalDrive(URL uRL) {
        return uRL != null && "file".equals(uRL.getProtocol()) && !URLUtil.isFromUNCPath(uRL);
    }

    public static URL getCanonicalURL(URL uRL) {
        try {
            if (URLUtil.isFromLocalDrive(uRL)) {
                File file = URLUtil.getCanonicalFileFromFileUrl(uRL);
                return URLUtil.correct(file);
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public static File computeCanonicalFile(URL uRL, String string) throws IOException {
        boolean bl;
        File file = new File(string);
        boolean bl2 = bl = uRL != null && "file".equals(uRL.getProtocol());
        if (!bl || file.equals(file.getAbsoluteFile())) {
            return file.getCanonicalFile();
        }
        String string2 = null;
        if (uRL != null) {
            string2 = uRL.getPath();
            if (string2.startsWith("/") && !PlatformDetector.isMacOS() && !PlatformDetector.isLinux()) {
                string2 = string2.substring(1);
            }
            string2 = URLUtil.uncorrect(new File(string2).getParentFile().toString());
        }
        return new File(string2, string).getCanonicalFile();
    }

    public static String getExtension(String string) {
        return FileSystemUtil.getExtension(URLUtil.removeQueryOrAnchorFromName(string));
    }

    public static String removeQueryOrAnchorFromName(String string) {
        if (string != null) {
            int n2 = string.indexOf("?");
            if (n2 != -1) {
                string = string.substring(0, n2);
            } else {
                int n3 = string.indexOf("#");
                if (n3 != -1) {
                    string = string.substring(0, n3);
                }
            }
        }
        return string;
    }

    public static URL removeAnchor(URL uRL) {
        String string;
        int n2;
        if (uRL != null && (n2 = (string = uRL.toString()).indexOf("#")) != -1) {
            try {
                uRL = new URL(string.substring(0, n2));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public static URL removeQuery(URL uRL) {
        String string;
        int n2;
        if (uRL != null && (n2 = (string = uRL.toString()).indexOf("?")) != -1) {
            try {
                uRL = new URL(string.substring(0, n2));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    public static String correctDBUrl(String string) {
        return fb.d(string);
    }

    public static String makeRelative(URL uRL, URL uRL2) {
        return URLUtil.makeRelative(uRL, uRL2, true, true);
    }

    public static String makeRelative(URL uRL, URL uRL2, boolean bl, boolean bl2) {
        CharSequence charSequence;
        int n2;
        String string;
        Object object;
        Object object2;
        try {
            if (d != null && (object2 = d.b(uRL.getProtocol())) != null) {
                int n3 = object2.size();
                for (int i2 = 0; i2 < n3; ++i2) {
                    object = object2.get(i2);
                    string = object.makeRelative(uRL, uRL2);
                    if (string == null) continue;
                    return string;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!BasicEqualer.verifyEquals(uRL.getProtocol(), uRL2.getProtocol())) {
            return uRL2.toString();
        }
        if (!BasicEqualer.verifyEquals(uRL.getHost(), uRL2.getHost())) {
            return uRL2.toString();
        }
        if (uRL != null && uRL2 != null && uRL.getPort() != uRL2.getPort()) {
            return uRL2.toString();
        }
        object2 = uRL.getPath();
        String string2 = uRL2.getPath();
        String string3 = null;
        if (bl) {
            string3 = uRL2.getQuery();
        }
        object = null;
        if (bl2) {
            object = uRL2.getRef();
        }
        if (u.f(uRL) && u.f(uRL2)) {
            String string4;
            string = u.b(uRL);
            if (string != null) {
                object2 = string;
            }
            if ((string4 = u.b(uRL2)) != null) {
                string2 = string4;
            }
        }
        int n4 = string2.length();
        int n5 = ((String)object2).length();
        for (n2 = 0; n2 < n4 && n2 < n5 && string2.charAt(n2) == ((String)object2).charAt(n2); ++n2) {
        }
        String string5 = string2.substring(0, n2);
        while (n2 > 0) {
            if (string5.charAt(--n2) != '/') continue;
            ++n2;
            break;
        }
        String string6 = ((String)object2).substring(n2);
        String string7 = string2.substring(n2);
        if (PlatformDetector.isWin32() && n2 == 1 && (((String)object2).length() > 2 && ((String)object2).charAt(2) == ':' || string2.length() > 2 && string2.charAt(2) == ':')) {
            return uRL2.toString();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string6, "/", true);
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>(10);
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            arrayList.add(charSequence);
        }
        charSequence = new StringBuilder();
        int n6 = arrayList.size();
        for (int i3 = 0; i3 < n6; i3 += 2) {
            if (i3 + 1 >= n6 || !((String)arrayList.get(i3 + 1)).equals("/")) continue;
            ((StringBuilder)charSequence).append("..");
            ((StringBuilder)charSequence).append("/");
        }
        String string8 = charSequence + string7;
        if (string8.length() == 0) {
            string8 = ".";
        }
        if (string3 != null && string3.length() > 0) {
            string8 = string8 + "?" + string3;
        }
        if (object != null && ((String)object).length() > 0) {
            string8 = string8 + "#" + (String)object;
        }
        return string8;
    }

    public static String getRelativeLocation(String string, String string2) {
        try {
            return URLUtil.getRelativeLocation(new URL(string), new URL(string2));
        }
        catch (Exception exception) {
            return string2;
        }
    }

    public static String getRelativeLocation(URL uRL, URL uRL2) {
        if (uRL.getProtocol().equals(uRL2.getProtocol())) {
            return URLUtil.getRelativePath(uRL.getPath(), uRL2.getPath());
        }
        return uRL2.toString();
    }

    public static String urlList2String(List list) {
        if (list == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(URLUtil.clearUserInfo((URL)iterator.next()));
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static URL convertToURL(String string) {
        URL uRL = null;
        try {
            uRL = new URL(URLUtil.correct(string, false));
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = URLUtil.correct(new File(string));
            }
            catch (MalformedURLException malformedURLException2) {
                // empty catch block
            }
        }
        return uRL;
    }

    public static boolean isCharAllowedInURLPart(char c2) {
        switch (c2) {
            case '#': 
            case '/': 
            case ':': 
            case '?': 
            case '@': {
                return false;
            }
        }
        return true;
    }

    public static z getURLInfo(URL uRL) throws MalformedURLException {
        return new z(uRL);
    }

    public static URL resolveRelativeSystemIDs(URL uRL, String string) {
        if (string != null) {
            block8: {
                if (uRL != null) break block8;
                return new URL(string);
            }
            try {
                URL uRL2 = null;
                if (u.f(uRL)) {
                    uRL2 = u.e(uRL, string);
                }
                if (uRL2 == null) {
                    uRL2 = new URL(uRL, string);
                }
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                try {
                    return new URL(string);
                }
                catch (MalformedURLException malformedURLException2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static File resolveRelativeSystemID(String string, String string2) {
        try {
            URL uRL = new URL(string2);
            return URLUtil.getCanonicalFileFromFileUrl(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            File file = new File(string2);
            File file2 = null;
            try {
                file2 = URLUtil.getCanonicalFileFromFileUrl(new URL(string));
            }
            catch (MalformedURLException malformedURLException2) {
                // empty catch block
            }
            if (!file.isAbsolute() && file2 != null) {
                file = new File(file2.getParentFile(), string2);
            }
            return file;
        }
    }

    public static boolean isReadOnly(URL uRL) {
        if (uRL != null) {
            File file = URLUtil.getCanonicalFileFromFileUrl(uRL);
            if (file != null && file.exists() && file.isFile() && !file.canWrite()) {
                return true;
            }
            if (u.f(uRL)) {
                return u.d(uRL);
            }
        }
        return false;
    }

    public static File getTopArchive(URL uRL) {
        File file = null;
        if ("zip".equals(uRL.getProtocol())) {
            String string = uRL.getPath();
            try {
                URL uRL2 = new URL(URLUtil.uncorrect(string));
                if ("file".equals(uRL2.getProtocol())) {
                    String string2 = uRL2.getFile();
                    file = URLUtil.getTopArchive(string2);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return file;
    }

    public static File getTopArchive(String string) {
        File file;
        File file2 = null;
        File file3 = new File(string);
        File file4 = file3;
        for (file = file3.getParentFile(); file != null && !file.exists(); file = file.getParentFile()) {
            file4 = file;
        }
        if (file != null) {
            String string2 = file4.getName();
            if (file4.getName().endsWith("!")) {
                string2 = string2.substring(0, string2.length() - 1);
                file2 = new File(file, string2);
            } else {
                file2 = file;
            }
        }
        return file2;
    }

    public static URL addAuthenticationInfo(URL uRL, URL uRL2) {
        String string;
        if (BasicEqualer.verifyEquals(uRL2.getHost(), uRL.getHost()) && URLUtil.getUserInfo(uRL2.toString()) == null && (string = URLUtil.getUserInfo(uRL.toString())) != null) {
            String string2 = URLUtil.extractUser(string);
            String string3 = URLUtil.extractPassword(string);
            try {
                uRL2 = URLUtil.attachUserInfo(uRL2, string2, string3.toCharArray());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL2;
    }

    public static URL addReferenceInfo(URL uRL, URL uRL2) {
        if (uRL.getRef() != null && uRL2.getRef() == null) {
            String string = uRL.getRef();
            try {
                uRL2 = new URL(uRL2.toExternalForm() + "#" + string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL2;
    }

    public static String correctAndMakeRelative(URL uRL, URL uRL2, boolean bl, boolean bl2) {
        try {
            return URLUtil.makeRelative(URLUtil.correct(uRL), URLUtil.correct(uRL2), bl, bl2);
        }
        catch (MalformedURLException malformedURLException) {
            return URLUtil.makeRelative(uRL, uRL2, bl, bl2);
        }
    }

    public static String getInsertStringRepresentation(List<URL> list, URL uRL) {
        URL uRL2 = uRL;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            String string;
            URL uRL3 = list.get(i2);
            URL uRL4 = URLUtil.clearUserInfo(uRL3);
            if (uRL4 != null) {
                uRL3 = uRL4;
            }
            if ((string = URLUtil.makeRelative(uRL2, uRL3)) != null) {
                stringBuilder.append(string);
            }
            if (i2 >= list.size() - 1) continue;
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    public static OutputStream openOutputStream(URL uRL) throws IOException {
        return URLUtil.openOutputStream(uRL.openConnection());
    }

    public static OutputStream openOutputStream(final URLConnection uRLConnection) throws IOException {
        Object object;
        OutputStream outputStream;
        block10: {
            uRLConnection.setDoOutput(true);
            if (uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).setRequestMethod("PUT");
            }
            outputStream = null;
            try {
                uRLConnection.connect();
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (!"file".equals(uRLConnection.getURL().getProtocol()) || ((File)(object = URLUtil.getCanonicalFileFromFileUrl(uRLConnection.getURL()))).exists()) break block10;
                try {
                    outputStream = new FileOutputStream(URLUtil.getCanonicalFileFromFileUrl(uRLConnection.getURL()));
                }
                catch (IOException iOException) {
                    throw fileNotFoundException;
                }
            }
        }
        if (outputStream == null) {
            try {
                outputStream = uRLConnection.getOutputStream();
            }
            catch (UnknownServiceException unknownServiceException) {
                if ("file".equals(uRLConnection.getURL().getProtocol())) {
                    outputStream = new FileOutputStream(URLUtil.getCanonicalFileFromFileUrl(uRLConnection.getURL()));
                }
                throw unknownServiceException;
            }
        }
        final OutputStream outputStream2 = outputStream;
        object = outputStream2;
        if (uRLConnection instanceof HttpURLConnection) {
            object = new FilterOutputStream(outputStream2){

                @Override
                public void write(byte[] byArray, int n2, int n3) throws IOException {
                    outputStream2.write(byArray, n2, n3);
                }

                @Override
                public void close() throws IOException {
                    super.close();
                    int n2 = ((HttpURLConnection)uRLConnection).getResponseCode();
                    if (n2 < 200 || n2 >= 300) {
                        throw new IOException(n2 + " " + ((HttpURLConnection)uRLConnection).getResponseMessage());
                    }
                }
            };
        }
        return object;
    }

    public static void disconnect(URLConnection uRLConnection) {
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    public static String getRelativePath(String string, String string2) {
        return FileSystemUtil.getRelativePath(string, string2, '/');
    }

    public static boolean hasRemoteAccessProtocol(URL uRL) {
        return uRL != null && ("http".equals(uRL.getProtocol()) || "https".equals(uRL.getProtocol()) || "ftp".equals(uRL.getProtocol()) || "sftp".equals(uRL.getProtocol()));
    }

    public static void setRelativeReferencesCustomizersProvider(b b2) {
        d = b2;
    }

    public static String getEditorLocationKey(URL uRL) {
        int n2;
        boolean bl = uRL.getRef() != null;
        String string = uRL.toString();
        try {
            uRL = URLUtil.correct(uRL);
            URL uRL2 = URLUtil.clearUserInfo(uRL);
            if (uRL2 != null) {
                string = uRL2.toString();
            } else {
                System.err.println("Could not clear user info for:" + uRL);
            }
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
        }
        if (bl && (n2 = string.lastIndexOf("#")) != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL copyURL(URL uRL, URL uRL2) throws MalformedURLException, IOException {
        URLConnection uRLConnection = null;
        URLConnection uRLConnection2 = null;
        try {
            uRL = URLUtil.correct(uRL);
            uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            uRL2 = URLUtil.correct(uRL2);
            uRLConnection2 = uRL2.openConnection();
            OutputStream outputStream = null;
            try {
                outputStream = uRLConnection2.getOutputStream();
            }
            catch (UnknownServiceException unknownServiceException) {
                if ("file".equals(uRL2.getProtocol())) {
                    File file = URLUtil.getCanonicalFileFromFileUrl(uRL2);
                    outputStream = new FileOutputStream(file);
                }
                throw unknownServiceException;
            }
            FileSystemUtil.copyInputStreamToOutputStream(inputStream, outputStream, true);
        }
        catch (Throwable throwable) {
            URLUtil.disconnect(uRLConnection);
            URLUtil.disconnect(uRLConnection2);
            throw throwable;
        }
        URLUtil.disconnect(uRLConnection);
        URLUtil.disconnect(uRLConnection2);
        return uRL2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyURLToFile(URL uRL, File file) throws MalformedURLException, IOException {
        URLConnection uRLConnection = null;
        try {
            uRL = URLUtil.correct(uRL);
            uRLConnection = URLUtil.openConnection(uRL);
            InputStream inputStream = uRLConnection.getInputStream();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            FileSystemUtil.copyInputStreamToOutputStream(inputStream, fileOutputStream, true);
        }
        catch (Throwable throwable) {
            URLUtil.disconnect(uRLConnection);
            throw throwable;
        }
        URLUtil.disconnect(uRLConnection);
    }

    public static List<URL> getURLListFromStringList(List list) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            try {
                URL uRL = URLUtil.correct(new URL((String)iterator.next()));
                arrayList.add(uRL);
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return arrayList;
    }

    public static boolean hasCommonProtocol(URL uRL) {
        boolean bl = false;
        if (uRL != null) {
            String string = uRL.getProtocol();
            bl = "file".equals(string) || "ftp".equals(string) || "sftp".equals(string) || "http".equals(string) || "https".equals(string);
        }
        return bl;
    }

    public static URLConnection openConnection(URL uRL) throws IOException {
        if (c.isDebugEnabled()) {
            c.debug((Object)("Open Connection to " + uRL));
        }
        URLConnection uRLConnection = uRL.openConnection();
        try {
            uRLConnection.setUseCaches(false);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        uRLConnection.connect();
        return uRLConnection;
    }

    public static boolean isRelativePath(String string) {
        boolean bl = true;
        if (string != null) {
            if (string.startsWith("urn:") || URLUtil.hasSpecialURIScheme(string)) {
                bl = false;
            } else if (string.contains("://") || string.startsWith("file:/")) {
                try {
                    URI uRI = new URI(string);
                    bl = uRI.getScheme() == null;
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
        }
        return bl;
    }

    public static URL getParentURL(URL uRL) throws MalformedURLException {
        String string = uRL.getPath();
        URL uRL2 = null;
        String string2 = new File(string).getParent();
        if (string2 != null) {
            string2 = string2.replace('\\', '/');
            uRL2 = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string2);
        } else {
            uRL2 = uRL;
        }
        return uRL2;
    }

    public static URL getCommonAncestorURL(URL uRL, URL uRL2) throws MalformedURLException {
        URL uRL3 = null;
        if (uRL.getHost().equals(uRL2.getHost())) {
            URL uRL4 = uRL;
            if (uRL.toExternalForm().equals(uRL2)) {
                uRL3 = uRL;
            } else if (uRL2 != URLUtil.getParentURL(uRL2)) {
                uRL2 = URLUtil.getParentURL(uRL2);
                while (uRL4 != null) {
                    if (uRL2.toExternalForm().contains(uRL4.toExternalForm())) {
                        uRL3 = uRL4;
                        break;
                    }
                    if (!URLUtil.getParentURL(uRL4).equals(uRL4)) {
                        uRL4 = URLUtil.getParentURL(uRL4);
                        continue;
                    }
                    uRL4 = null;
                }
            }
        }
        return uRL3;
    }

    public static String makeAbsolute(String string, String string2) {
        String string3 = null;
        if (URLUtil.isRelativePath(string2)) {
            if (string != null) {
                try {
                    URL uRL = new URL(string);
                    URL uRL2 = new URL(uRL, string2);
                    string3 = uRL2.toString();
                }
                catch (MalformedURLException malformedURLException) {
                    if (c.isDebugEnabled()) {
                        c.debug((Object)malformedURLException, (Throwable)malformedURLException);
                    }
                }
            }
        } else {
            string3 = string2;
        }
        return string3;
    }

    public static boolean isURIWithUnknownURLScheme(String string) {
        block5: {
            if (string != null) {
                try {
                    URI uRI = new URI(string);
                    if (uRI.getScheme() == null) break block5;
                    try {
                        new URL(string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        return true;
                    }
                }
                catch (Exception exception) {
                    if (!c.isDebugEnabled()) break block5;
                    c.debug((Object)exception, (Throwable)exception);
                }
            }
        }
        return false;
    }
}

