/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.util.PlatformDetector;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.NOT_SPECIFIED, methods=SkipLevel.PUBLIC)
public class BasicURLUtil {
    private static final String[] b = new String[]{"aaa://", "aaas://", "acap://", "cap://", "cid:", "crid://", "data:", "dav:", "dict://", "dns://", "fax:", "go://", "gopher://", "h323:", "icap://", "im:", "imap://", "info:", "ipp://", "iris:", "iris.beep:", "iris.xpc:", "iris.xpcs:", "iris.lwz:", "javascript:", "ldap://", "mailto:", "mid:", "modem:", "msrp://", "msrps://", "mtqp://"};

    public static File getCanonicalFileFromFileUrl(URL uRL) {
        return BasicURLUtil.c(uRL, true);
    }

    public static File getAbsoluteFileFromFileUrl(URL uRL) {
        return BasicURLUtil.c(uRL, false);
    }

    private static File c(URL uRL, boolean bl) {
        File file = null;
        if (uRL == null) {
            throw new NullPointerException("The URL cannot be null.");
        }
        if ("file".equals(uRL.getProtocol())) {
            boolean bl2;
            String string = uRL.getHost();
            String string2 = uRL.getFile();
            boolean bl3 = bl2 = string != null && string.length() > 0;
            if (PlatformDetector.isWin32() && bl2) {
                string2 = "//" + string + string2;
            }
            String string3 = BasicURLUtil.uncorrect(string2);
            file = new File(string3);
            if (!string3.startsWith("\\\\") && !string3.startsWith("//")) {
                if (bl) {
                    int n2;
                    boolean bl4 = PlatformDetector.isWin32();
                    if (bl4) {
                        try {
                            file = file.getCanonicalFile();
                        }
                        catch (IOException iOException) {
                            bl4 = false;
                        }
                    }
                    String string4 = file.getAbsolutePath();
                    if (!bl4) {
                        string4 = BasicURLUtil.b(string4);
                        file = new File(string4);
                    }
                    if ((n2 = string4.indexOf(63)) > 0 && !file.exists()) {
                        try {
                            File file2 = new File(string4.substring(0, n2));
                            if (bl4) {
                                file2 = file2.getCanonicalFile();
                            }
                            if (PlatformDetector.isWin32() || file2.exists()) {
                                file = file2;
                            }
                        }
                        catch (IOException iOException) {}
                    }
                } else {
                    file = file.getAbsoluteFile();
                }
            }
        }
        return file;
    }

    private static String b(String string) {
        try {
            StringBuilder stringBuilder = new StringBuilder(string.length());
            int n2 = string.length();
            for (int i2 = 0; i2 < n2; ++i2) {
                char c2 = string.charAt(i2);
                if ('.' == c2) {
                    char c3 = '\uffffffff';
                    if (i2 > 0) {
                        c3 = string.charAt(i2 - 1);
                    }
                    char c4 = '\uffffffff';
                    if (i2 + 1 < n2) {
                        c4 = string.charAt(i2 + 1);
                    }
                    int n3 = -1;
                    if (i2 + 2 < n2) {
                        n3 = string.charAt(i2 + 2);
                    }
                    if (c4 == -1) continue;
                    if (File.separatorChar == c4 && File.separatorChar == c3) {
                        ++i2;
                        continue;
                    }
                    if (c4 == '.' && File.separatorChar == c3) {
                        if (n3 != -1) {
                            char c5 = string.charAt(i2 + 2);
                            if (c5 == File.separatorChar || c5 == '\uffffffff') {
                                i2 += 2;
                                int n4 = stringBuilder.lastIndexOf(File.separator, stringBuilder.length() - 2);
                                if (n4 == -1) continue;
                                stringBuilder.delete(n4 + 1, stringBuilder.length());
                                continue;
                            }
                            stringBuilder.append(c2);
                            continue;
                        }
                        stringBuilder.append(c2);
                        continue;
                    }
                    if (c4 == '\uffffffff') continue;
                    stringBuilder.append(c2);
                    continue;
                }
                stringBuilder.append(c2);
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return string;
        }
    }

    public static String uncorrect(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(37) == -1) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = string.length();
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            n3 = c2;
            switch (n3) {
                case 37: {
                    if (i2 + 2 >= string.length()) break;
                    int n7 = (Character.isDigit((char)(n3 = (int)string.charAt(++i2))) ? n3 - 48 : 10 + Character.toLowerCase((char)n3) - 97) & 0xF;
                    n3 = string.charAt(++i2);
                    int n8 = (Character.isDigit((char)n3) ? n3 - 48 : 10 + Character.toLowerCase((char)n3) - 97) & 0xF;
                    n4 = n7 << 4 | n8;
                    bl = true;
                    break;
                }
                default: {
                    n4 = n3;
                    bl = false;
                }
            }
            if (bl) {
                if ((n4 & 0xC0) == 128) {
                    n5 = n5 << 6 | n4 & 0x3F;
                    if (--n6 != 0) continue;
                    stringBuilder.append((char)n5);
                    continue;
                }
                if ((n4 & 0x80) == 0) {
                    stringBuilder.append((char)n4);
                    continue;
                }
                if ((n4 & 0xE0) == 192) {
                    n5 = n4 & 0x1F;
                    n6 = 1;
                    continue;
                }
                if ((n4 & 0xF0) == 224) {
                    n5 = n4 & 0xF;
                    n6 = 2;
                    continue;
                }
                if ((n4 & 0xF8) == 240) {
                    n5 = n4 & 7;
                    n6 = 3;
                    continue;
                }
                if ((n4 & 0xFC) == 248) {
                    n5 = n4 & 3;
                    n6 = 4;
                    continue;
                }
                n5 = n4 & 1;
                n6 = 5;
                continue;
            }
            stringBuilder.append(c2);
            n6 = -1;
        }
        return stringBuilder.toString();
    }

    public static String[] splitUserAndDomain(String string) {
        String[] stringArray = new String[]{string, ""};
        int n2 = string.indexOf(92);
        if (n2 == -1) {
            n2 = string.indexOf(47);
        }
        if (n2 != -1) {
            stringArray[1] = string.substring(0, n2);
            stringArray[0] = n2 < string.length() - 1 ? string.substring(n2 + 1) : "";
        }
        return stringArray;
    }

    public static String filterPasswords(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf("@") != -1) {
            return string.replaceAll("://([^\\:\\/\\@]*?):([^\\:\\/]*?)@", "://$1:******@");
        }
        return string;
    }

    public static boolean hasSpecialURIScheme(String string) {
        if (string != null) {
            for (int i2 = 0; i2 < b.length; ++i2) {
                if (!string.startsWith(b[i2])) continue;
                return true;
            }
        }
        return false;
    }

    public static File getCanonicalFile(File file) {
        boolean bl = PlatformDetector.isWin32();
        if (bl) {
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                bl = false;
            }
        }
        if (!bl) {
            String string = file.getAbsolutePath();
            string = BasicURLUtil.b(string);
            file = new File(string);
        }
        return file;
    }
}

