/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.svn.trees.wc;

import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.svn.trees.wc.SyncNodeState;
import ro.sync.svn.wc.status.VCItemStatus;
import ro.sync.svn.wc.status.b;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SyncTreeNode
extends DefaultMutableTreeNode
implements Comparable<SyncTreeNode> {
    private static final long serialVersionUID = 5371317289122638742L;
    private static final Logger logger = Logger.getLogger((String)SyncTreeNode.class.getName());
    private VCItemStatus status;
    private SyncNodeState syncNodeFlags;

    private static boolean hasOneOfStatusFlags(SyncNodeState syncNodeState, byte[] byArray) {
        boolean bl = false;
        for (int i2 = 0; i2 < byArray.length && !bl; ++i2) {
            bl = syncNodeState.getStatusProperty(byArray[i2]);
        }
        return bl;
    }

    public SyncTreeNode(VCItemStatus vCItemStatus) {
        this.status = vCItemStatus;
        this.syncNodeFlags = new SyncNodeState();
        this.setAllowsChildren(this.status.isDirectory());
    }

    @Override
    @Deprecated
    public TreeNode[] getPath() {
        logger.error((Object)"Use getPathToRoot() method from model", (Throwable)new Exception());
        return null;
    }

    public TreeNode[] getPathToRoot() {
        return super.getPath();
    }

    public String getAbsoluteFilePath() {
        File file = this.getFile();
        return file == null ? null : file.getAbsolutePath();
    }

    public File getFile() {
        return this.status != null ? this.status.getFile() : null;
    }

    public VCItemStatus getStatus() {
        return this.status;
    }

    public void setStatus(VCItemStatus vCItemStatus) {
        this.status = vCItemStatus;
        this.setAllowsChildren(this.status.isDirectory());
    }

    public boolean getStatusFlag(byte by) {
        return this.syncNodeFlags.getStatusProperty(by);
    }

    public void setStatusFlag(byte by, boolean bl) {
        this.syncNodeFlags.setProperty(by, bl);
    }

    public SyncNodeState getStatusFlags() {
        return this.syncNodeFlags;
    }

    public void setStatusFlags(SyncNodeState syncNodeState) {
        this.syncNodeFlags = syncNodeState;
    }

    public boolean hasOneOfStatusFlags(byte[] byArray) {
        return SyncTreeNode.hasOneOfStatusFlags(this.syncNodeFlags, byArray);
    }

    public boolean hasChildrenWithStatus(byte by) {
        boolean bl = false;
        int n2 = this.getChildCount();
        for (int i2 = 0; i2 < n2 && !bl; ++i2) {
            bl = ((SyncTreeNode)this.getChildAt(i2)).getStatusFlag(by);
        }
        return bl;
    }

    public Vector<SyncTreeNode> getChildren() {
        return this.children;
    }

    @Override
    public void add(MutableTreeNode mutableTreeNode) {
        if (this.children != null && this.children.size() > 0) {
            int n2 = Collections.binarySearch(this.children, mutableTreeNode);
            if (n2 < 0) {
                n2 = -1 * (n2 + 1);
            } else {
                logger.warn((Object)("Child " + mutableTreeNode + " already exists"), (Throwable)new Exception());
            }
            super.insert(mutableTreeNode, n2);
        } else {
            super.add(mutableTreeNode);
        }
    }

    @Override
    public int getIndex(TreeNode treeNode) {
        if (this.children != null && this.children.size() > 0) {
            return Collections.binarySearch(this.children, treeNode);
        }
        return -1;
    }

    public void clearRemoteNodes() {
        if (this.children != null && this.children.size() > 0) {
            SyncTreeNode syncTreeNode = null;
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                syncTreeNode = (SyncTreeNode)iterator.next();
                if (syncTreeNode.getStatus().getLocalFileStatus() == b.s) {
                    iterator.remove();
                    continue;
                }
                syncTreeNode.clearRemoteNodes();
            }
            this.children.trimToSize();
        }
    }

    @Override
    public int compareTo(SyncTreeNode syncTreeNode) {
        return this.status.isDirectory() == syncTreeNode.status.isDirectory() ? this.status.getFile().getAbsolutePath().compareTo(syncTreeNode.status.getFile().getAbsolutePath()) : (this.status.isDirectory() ? -1 : 1);
    }

    public boolean equals(Object object) {
        return object instanceof SyncTreeNode && this.compareTo((SyncTreeNode)object) == 0;
    }

    public int hashCode() {
        int n2 = 1;
        if (this.status == null) {
            logger.error((Object)"Detected a node without status!", (Throwable)new Exception());
        } else if (this.status.getFile() == null) {
            logger.error((Object)"Detected a node status without file information!", (Throwable)new Exception());
        } else {
            n2 = this.status.getFile().hashCode();
        }
        return n2;
    }

    @Override
    public String toString() {
        return this.getAbsoluteFilePath() + " - " + this.status;
    }

    @Override
    public Object clone() {
        SyncTreeNode syncTreeNode = new SyncTreeNode((VCItemStatus)this.status.clone());
        syncTreeNode.syncNodeFlags = (SyncNodeState)this.syncNodeFlags.clone();
        return syncTreeNode;
    }

    public SyncTreeNode deepClone(SyncTreeNode syncTreeNode) {
        SyncTreeNode syncTreeNode2 = (SyncTreeNode)this.clone();
        if (syncTreeNode != null) {
            syncTreeNode.add(syncTreeNode2);
        }
        if (this.children != null && this.children.size() > 0) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                ((SyncTreeNode)iterator.next()).deepClone(syncTreeNode2);
            }
        }
        return syncTreeNode2;
    }

    public String dumpNodeInformation() {
        StringBuilder stringBuilder = new StringBuilder("Path: ").append(this.getAbsoluteFilePath());
        stringBuilder.append("\nFlags: *******");
        if (this.syncNodeFlags != null) {
            stringBuilder.append("\n" + this.syncNodeFlags.dumpInformation());
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append("\nStatus: *******");
        if (this.status != null) {
            stringBuilder.append("\n").append(this.status.dumpInformation());
        } else {
            stringBuilder.append("ERROR! null");
        }
        if (this.children != null) {
            for (Object e2 : this.children) {
                SyncTreeNode syncTreeNode = (SyncTreeNode)e2;
                stringBuilder.append("\n-----------------------------\n");
                stringBuilder.append(syncTreeNode.dumpNodeInformation());
            }
        }
        return stringBuilder.toString();
    }
}

