/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.svn.graph.cache;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.svn.graph.cache.SVNLogEntryPathCache;
import ro.sync.util.Equaler;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class SVNLogEntryCache
implements Serializable {
    public static final long serialVersionUID = 3493675984564936543L;
    private List changedPaths;
    private long revision;
    private String author;
    private String date;
    private String message;
    private final transient SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd kk:mm:ss");

    public SVNLogEntryCache() {
    }

    public SVNLogEntryCache(List<SVNLogEntryPathCache> list, long l2, String string, String string2, String string3) {
        this.changedPaths = new ArrayList<SVNLogEntryPathCache>(list);
        this.revision = l2;
        this.author = string;
        this.date = string2 == null ? null : this.dateFormat.format(string2);
        this.message = string3;
    }

    public SVNLogEntryCache(SVNLogEntry sVNLogEntry) {
        Collection collection = sVNLogEntry.getChangedPaths().values();
        this.changedPaths = new ArrayList(collection.size());
        for (SVNLogEntryPath sVNLogEntryPath : collection) {
            this.changedPaths.add(new SVNLogEntryPathCache(sVNLogEntryPath));
        }
        this.revision = sVNLogEntry.getRevision();
        this.author = sVNLogEntry.getAuthor();
        this.date = sVNLogEntry.getDate() == null ? null : this.dateFormat.format(sVNLogEntry.getDate());
        this.message = sVNLogEntry.getMessage();
    }

    protected Object clone() throws CloneNotSupportedException {
        ArrayList<SVNLogEntryPathCache> arrayList = new ArrayList<SVNLogEntryPathCache>(this.changedPaths.size());
        for (SVNLogEntryPathCache sVNLogEntryPathCache : this.changedPaths) {
            arrayList.add((SVNLogEntryPathCache)sVNLogEntryPathCache.clone());
        }
        return new SVNLogEntryCache(arrayList, this.revision, this.author, this.date, this.message);
    }

    public List<SVNLogEntryPathCache> getChangedPaths() {
        return this.changedPaths;
    }

    public long getRevision() {
        return this.revision;
    }

    public String getAuthor() {
        return this.author;
    }

    public String getDate() {
        return this.date;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean equals(Object object) {
        if (object instanceof SVNLogEntryCache) {
            SVNLogEntryCache sVNLogEntryCache = (SVNLogEntryCache)object;
            return this.revision == sVNLogEntryCache.revision && Equaler.verifyEquals(this.author, sVNLogEntryCache.author) && Equaler.verifyEquals(this.date, sVNLogEntryCache.date) && Equaler.verifyEquals(this.message, sVNLogEntryCache.message) && Equaler.verifyListEquals(this.changedPaths, sVNLogEntryCache.changedPaths);
        }
        return false;
    }

    public int hashCode() {
        int n2 = (int)this.revision;
        if (this.date != null) {
            n2 += this.date.hashCode();
        }
        if (this.author != null) {
            n2 += this.author.hashCode();
        }
        return n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.revision);
        stringBuffer.append('\n');
        stringBuffer.append("author");
        stringBuffer.append('=');
        stringBuffer.append(this.author);
        stringBuffer.append('\n');
        stringBuffer.append("date");
        stringBuffer.append('=');
        stringBuffer.append(this.date);
        stringBuffer.append('\n');
        stringBuffer.append("message");
        stringBuffer.append('=');
        stringBuffer.append(this.message);
        if (this.changedPaths != null && !this.changedPaths.isEmpty()) {
            Iterator iterator = this.changedPaths.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append('\n');
                SVNLogEntryPathCache sVNLogEntryPathCache = (SVNLogEntryPathCache)iterator.next();
                stringBuffer.append(sVNLogEntryPathCache.toString());
            }
        }
        return stringBuffer.toString();
    }
}

