/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.view.graphics;

import java.util.StringTokenizer;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.util.Equaler;
import ro.sync.util.c;
import ro.sync.util.p;

@API(type=APIType.EXTENDABLE, src=SourceType.PRIVATE)
@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class Font {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    private final String name;
    private final int style;
    private final int size;
    private String hash;
    private int hashCode = -1;

    public Font(String string, int n2, int n3) {
        this.name = string;
        this.style = n2;
        this.size = n3;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public String toString() {
        String string = this.isBold() ? (this.isItalic() ? "bolditalic" : "bold") : (this.isItalic() ? "italic" : "plain");
        return this.getClass().getName() + "[name=" + this.name + ",style=" + string + ",size=" + this.size + "]";
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public String hash() {
        if (this.hash == null) {
            this.hash = Font.hash(this.name, this.style, this.size);
        }
        return this.hash;
    }

    public static final String hash(String string, int n2, int n3) {
        return string + "." + n2 + "." + n3;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Font) {
            Font font = (Font)object;
            bl = this.hashCode() == font.hashCode() && Equaler.verifyEquals(this.hash(), font.hash());
        }
        return bl;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.hash().hashCode();
        }
        return this.hashCode;
    }

    public static String encodeFont(Font font) {
        return font.getName() + "," + font.getStyle() + "," + font.getSize();
    }

    public static Font decodeFont(String string) {
        StringTokenizer stringTokenizer;
        Font font = null;
        if (string != null && string.length() > 0 && (stringTokenizer = new StringTokenizer(string, ",", false)).countTokens() == 3) {
            try {
                String string2 = stringTokenizer.nextToken();
                int n2 = c.g(stringTokenizer.nextToken());
                int n3 = c.g(stringTokenizer.nextToken());
                font = new Font(string2, n2, n3);
            }
            catch (p p2) {
                // empty catch block
            }
        }
        return font;
    }
}

