/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xmleditor.transform.dita;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.ecss.conditions.ProfileConditionsSetInfoPO;
import ro.sync.exml.editor.xmleditor.transform.ant.ANTScenario;
import ro.sync.exml.editor.xmleditor.transform.ant.parameter.ANTParameter;
import ro.sync.exml.editor.xmleditor.transform.dita.filters.DITAVALFiltersPO;
import ro.sync.exml.editor.xmleditor.transform.dita.filters.c;
import ro.sync.exml.q.b;
import ro.sync.io.FileSystemUtil;
import ro.sync.options.j;
import ro.sync.util.URLUtil;
import ro.sync.util.bb;
import ro.sync.util.editorvars.EditorVariables;
import ro.sync.xml.transformer.dita.d;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class DITAScenario
extends ANTScenario {
    private static final Logger logger = Logger.getLogger((String)DITAScenario.class.getName());
    private boolean useXEP;
    private boolean useAntennaHouse;
    @PersistentObjectField(hasEditorVariables=true)
    private String baseDir;
    @PersistentObjectField(hasEditorVariables=true)
    private String outputDir;
    @PersistentObjectField(hasEditorVariables=true)
    private String tempDir;
    @PersistentObjectField(hasEditorVariables=false)
    private String transtype;
    private DITAVALFiltersPO filters = new DITAVALFiltersPO();
    private boolean addOxygenJars = true;
    public static final String SKINS_DIR_PATH = "${frameworksDir}/dita/DITA-OT/plugins/com.oxygenxml.webhelp/predefined-skins/dita";
    @PersistentObjectField(hasEditorVariables=true)
    private String skinCssFile;
    @PersistentObjectField(hasEditorVariables=true)
    private String lastCustomSkinCssPath;

    public DITAScenario() {
        this.showConsoleAlways = false;
    }

    public DITAScenario(String string, String string2) {
        super(string);
        this.showConsoleAlways = false;
        this.setType("DITAMAP");
        this.transtype = string2;
    }

    public String getTransformationType() {
        return this.transtype;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String string) {
        this.outputDir = string;
    }

    public String getTempDir() {
        return this.tempDir;
    }

    public void setTempDir(String string) {
        this.tempDir = string;
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String string) {
        this.baseDir = string;
    }

    @Override
    public Object clone() {
        DITAScenario dITAScenario = (DITAScenario)super.clone();
        if (this.filters != null) {
            dITAScenario.filters = (DITAVALFiltersPO)this.filters.clone();
        }
        return dITAScenario;
    }

    public String getOutputFileName(String string, boolean bl) {
        String string2;
        String string3 = this.getTransformationType();
        String string4 = null;
        String string5 = null;
        if ("xhtml".equals(string3) || "html2".equals(string3) || "html5".equals(string3)) {
            String string6;
            if (!bl) {
                string6 = this.getParameterValue("args.xhtml.toc");
                if (string6 != null) {
                    string4 = string6;
                }
                if (string4 == null) {
                    string4 = "index";
                }
            }
            if ((string6 = this.getParameterValue("args.outext")) != null) {
                string5 = string6;
            }
        } else if ("webhelp".equals(string3) || "webhelp-mobile".equals(string3)) {
            String string7;
            if (!bl) {
                string4 = "index";
            }
            if ((string7 = this.getParameterValue("args.outext")) != null) {
                string5 = string7;
            }
        } else if ("tocjs".equals(string3)) {
            String string8 = this.getParameterValue("output.file");
            if (string8 != null) {
                string4 = string8;
                string5 = "";
            }
        } else if ("eclipsehelp".equals(string3)) {
            String string9 = this.getParameterValue("args.eclipsehelp.toc");
            if (string9 != null) {
                string4 = string9;
            }
        } else if ("eclipsecontent".equals(string3)) {
            String string10 = this.getParameterValue("args.eclipsecontent.toc");
            if (string10 != null) {
                string4 = string10;
            }
        } else if ("javahelp".equals(string3) && (string2 = this.getParameterValue("args.javahelp.toc")) != null) {
            string4 = string2;
        }
        if (string4 == null) {
            string4 = string;
        }
        if (string5 == null) {
            string5 = d.c(string3);
        }
        return string4 + (string5 != null && string5.length() > 0 ? "." + string5 : "");
    }

    @Override
    public void checkValid() throws j {
        super.checkValid();
        if (this.outputDir == null) {
            throw new j("The output dir field must be specified for a DITA scenario.");
        }
        if (this.tempDir == null || this.tempDir.length() == 0) {
            this.tempDir = "temp";
        }
        if (this.transtype == null) {
            throw new j("The transformation type must be specified for a DITA scenario.");
        }
    }

    public DITAVALFiltersPO getFilters() {
        return this.filters;
    }

    public void setFilters(DITAVALFiltersPO dITAVALFiltersPO) {
        this.filters = dITAVALFiltersPO;
    }

    public boolean isUseXEP() {
        return this.useXEP;
    }

    public void setUseXEP(boolean bl) {
        this.useXEP = bl;
    }

    public boolean isUseAntennaHouse() {
        return this.useAntennaHouse;
    }

    public void setUseAntennaHouse(boolean bl) {
        this.useAntennaHouse = bl;
    }

    @Override
    public String getInputXMLURL() {
        return this.getParameterValue("args.input");
    }

    public void setAddOxygenJars(boolean bl) {
        this.addOxygenJars = bl;
    }

    public boolean isAddOxygenJars() {
        return this.addOxygenJars;
    }

    public c getDitavalFile(String string, ProfileConditionsSetInfoPO profileConditionsSetInfoPO) {
        return DITAScenario.getDitavalFile(string, this.getFilters(), profileConditionsSetInfoPO);
    }

    public static void computeDitavalFiles(String string, List<ProfileConditionsSetInfoPO> list, List<c> list2) {
        DITAVALFiltersPO dITAVALFiltersPO = new DITAVALFiltersPO();
        dITAVALFiltersPO.setUseCurrentConditionSet(true);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            c c2 = DITAScenario.getDitavalFile(string, dITAVALFiltersPO, list.get(i2));
            if (c2 == null) continue;
            list2.add(c2);
        }
    }

    public static c getDitavalFile(String string, DITAVALFiltersPO dITAVALFiltersPO, ProfileConditionsSetInfoPO profileConditionsSetInfoPO) {
        File file = null;
        String string2 = null;
        if (dITAVALFiltersPO.useDitavalFilePath()) {
            if (dITAVALFiltersPO.getDitavalFilePath() != null && dITAVALFiltersPO.getDitavalFilePath().length() > 0) {
                String string3 = EditorVariables.expandEditorVariablesAsFilePath(dITAVALFiltersPO.getDitavalFilePath(), string);
                file = new File(string3);
            }
        } else {
            String string4 = null;
            if (dITAVALFiltersPO.getAppliedConditionSet() != null || dITAVALFiltersPO.useCurrentConditionSet()) {
                if (profileConditionsSetInfoPO != null) {
                    if (profileConditionsSetInfoPO.useDITAVAL() && profileConditionsSetInfoPO.getDITAVALFile() != null) {
                        file = new File(EditorVariables.expandEditorVariablesAsFilePath(profileConditionsSetInfoPO.getDITAVALFile(), string));
                        string2 = profileConditionsSetInfoPO.getConditionSetName();
                    } else {
                        string4 = DITAVALFiltersPO.createDITAValContent(profileConditionsSetInfoPO);
                        string2 = profileConditionsSetInfoPO.getConditionSetName();
                    }
                }
            } else {
                string4 = DITAVALFiltersPO.serializeSimpleFilters(dITAVALFiltersPO);
                string2 = "Custom filter";
            }
            if (string4 != null && string4.length() > 0) {
                try {
                    file = FileSystemUtil.createTempFile("ditaVal", ".ditaval");
                    file.deleteOnExit();
                    OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8");
                    outputStreamWriter.write(string4);
                    outputStreamWriter.close();
                }
                catch (Exception exception) {
                    logger.error((Object)exception, (Throwable)exception);
                }
            }
        }
        if (file == null) {
            return null;
        }
        return new c(file, string2);
    }

    @Override
    protected List<ANTParameter> getAllPredefinedParameters() {
        return new ArrayList<ANTParameter>(d.b(this.transtype));
    }

    public static URL[] getExtensionsAsURLs(URL uRL, String[] stringArray, String string) {
        ArrayList<Serializable> arrayList = new ArrayList<Serializable>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                String string2;
                Object object;
                Serializable serializable;
                String string3 = stringArray[i2];
                if (string3 != null && string3.contains("${dita.dir.url}")) {
                    serializable = null;
                    if (string != null) {
                        serializable = new File(EditorVariables.expandEditorVariablesAsFilePath(string, uRL != null ? uRL.toString() : null));
                    }
                    Object object2 = object = serializable != null ? URLUtil.correct((File)serializable).toString() : "${frameworks}/dita/DITA-OT";
                    if (((String)object).endsWith("/")) {
                        object = ((String)object).substring(0, ((String)object).length() - 1);
                    }
                    string3 = bb.c(string3, "${dita.dir.url}", (String)object);
                }
                if ((object = URLUtil.getCanonicalFileFromFileUrl((URL)(serializable = new URL(uRL, EditorVariables.expandEditorVariables(string3, uRL != null ? uRL.toString() : null))))) != null && ((File)object).isDirectory() && (string2 = ((URL)serializable).toString()).charAt(string2.length() - 1) != '/') {
                    string2 = string2 + '/';
                    serializable = new URL(string2);
                }
                arrayList.add(serializable);
                continue;
            }
            catch (MalformedURLException malformedURLException) {
                b.c("Could not create URL for extension:" + stringArray[i2]);
            }
        }
        return arrayList.toArray(new URL[0]);
    }

    public void setSkinCSSFile(String string) {
        this.skinCssFile = string;
    }

    public String getSkinCssPath() {
        return this.skinCssFile;
    }

    public void setCustomSkinCssFile(String string) {
        this.lastCustomSkinCssPath = string;
    }

    public String getCustomSkinCssFile() {
        return this.lastCustomSkinCssPath;
    }
}

