/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.xmleditor.transform;

import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.PersistentObject;
import ro.sync.options.j;
import ro.sync.util.Equaler;
import ro.sync.xml.XmlUtil;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class ParamDescriptor
implements PersistentObject {
    @PersistentObjectField(hasEditorVariables=false)
    private String localName;
    @PersistentObjectField(hasEditorVariables=false)
    private String prefix;
    @PersistentObjectField(hasEditorVariables=false)
    private String namespace = null;

    public String getClarkNotation() {
        return this.getNamespace() == null ? this.getLocalName() : "{" + this.getNamespace() + "}" + this.getLocalName();
    }

    public ParamDescriptor() {
    }

    public ParamDescriptor(String string, String string2, String string3) {
        this.localName = string;
        this.namespace = "".equals(string2) ? null : string2;
        this.prefix = string3;
    }

    public ParamDescriptor(String string) {
        String[] stringArray = XmlUtil.detectNamespaceClark(string);
        this.localName = stringArray[1];
        this.namespace = stringArray[0];
        this.prefix = null;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public void checkValid() throws j {
        if (this.localName == null) {
            throw new j("Invalid parameter descriptor");
        }
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Name: ").append(this.localName).append(" Namespace: ");
        stringBuilder.append(this.namespace).append(" prefixu': ").append(this.prefix);
        return stringBuilder.toString();
    }

    public void setName(String string) {
        this.localName = string;
    }

    public void setNamespace(String string) {
        this.namespace = string;
    }

    public boolean equals(Object object) {
        if (object instanceof ParamDescriptor) {
            ParamDescriptor paramDescriptor = (ParamDescriptor)object;
            return Equaler.verifyEquals(this.localName, paramDescriptor.localName) && Equaler.verifyEquals(this.namespace, paramDescriptor.namespace) && Equaler.verifyEquals(this.prefix, paramDescriptor.prefix);
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

