/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.exml.editor.persistance;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import ro.sync.annotations.dt.PersistentObjectField;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.options.PersistentObject;
import ro.sync.options.j;
import ro.sync.util.c;

@SkipObfuscate(classes=SkipLevel.PRIVATE, fields=SkipLevel.PRIVATE, methods=SkipLevel.PRIVATE)
public class DocTypeSchemaPO
implements PersistentObject,
Cloneable {
    public static final String XML_SCHEMA = "XML Schema";
    public static final String XML_SCHEMA_SCH = "XML Schema + Schematron";
    public static final String DTD_SCHEMA = "DTD";
    public static final String RNG_SCHEMA = "RNG Schema";
    public static final String RNG_SCHEMA_SCH = "RNG Schema + Schematron";
    public static final String RNC_SCHEMA = "RNC Schema";
    public static final String NVDL_SCHEMA = "NVDL";
    private static final Map schemaTypeMap = new HashMap();
    private int type = 0;
    @PersistentObjectField(hasEditorVariables=true, isIDTypeVariables=true)
    private String uri;

    public DocTypeSchemaPO() {
    }

    public DocTypeSchemaPO(String string, int n2) {
        this.type = n2;
        this.uri = string;
    }

    public String toString() {
        return "Schema URI:" + this.uri + ", type: " + DocTypeSchemaPO.typeToDescription(this.type);
    }

    public static String typeToDescription(int n2) {
        return String.valueOf(schemaTypeMap.get(c.i(n2)));
    }

    @Override
    public void checkValid() throws j {
        if (this.type == 0) {
            throw new j("Schema type is not defined");
        }
        if (this.uri == null || this.uri.trim().length() == 0) {
            throw new j("Schema URI must be specified");
        }
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
    }

    public int getType() {
        return this.type;
    }

    public String getURI() {
        return this.uri;
    }

    public static int descriptionToType(String string) {
        int n2 = 0;
        Set set = schemaTypeMap.keySet();
        for (Integer n3 : set) {
            if (!string.equals(schemaTypeMap.get(n3))) continue;
            n2 = n3;
            break;
        }
        return n2;
    }

    @Override
    public String[] getNotPersistentFieldNames() {
        return null;
    }

    static {
        schemaTypeMap.put(c.i(1), DTD_SCHEMA);
        schemaTypeMap.put(c.i(2), XML_SCHEMA);
        schemaTypeMap.put(c.i(5), XML_SCHEMA_SCH);
        schemaTypeMap.put(c.i(3), RNC_SCHEMA);
        schemaTypeMap.put(c.i(4), RNG_SCHEMA);
        schemaTypeMap.put(c.i(6), RNG_SCHEMA_SCH);
        schemaTypeMap.put(c.i(9), NVDL_SCHEMA);
    }
}

