/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.spansupport;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class TEITableCellSpanProvider
implements AuthorTableCellSpanProvider {
    @Override
    public Integer getColSpan(AuthorElement authorElement) {
        Integer n2 = null;
        AttrValue attrValue = authorElement.getAttribute("cols");
        if (attrValue != null) {
            try {
                int n3 = Integer.parseInt(attrValue.getValue());
                n2 = Math.max(n3, 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public Integer getRowSpan(AuthorElement authorElement) {
        Integer n2 = null;
        AttrValue attrValue = authorElement.getAttribute("rows");
        if (attrValue != null) {
            try {
                int n3 = Integer.parseInt(attrValue.getValue());
                n2 = Math.max(n3, 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    @Override
    public void init(AuthorElement authorElement) {
    }

    @Override
    public String getDescription() {
        return "Provides cell spanning information about a TEI table.";
    }

    @Override
    public boolean hasColumnSpecifications(AuthorElement authorElement) {
        return true;
    }
}

