/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations.cals;

import java.util.List;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.ContentInterval;
import ro.sync.ecss.extensions.api.node.AttrValue;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.DeleteColumnOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSConstants;
import ro.sync.ecss.extensions.commons.table.operations.cals.CALSDocumentTypeHelper;
import ro.sync.ecss.extensions.commons.table.support.CALSColSpec;
import ro.sync.ecss.extensions.commons.table.support.CALSTableCellInfoProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class DeleteColumnOperation
extends DeleteColumnOperationBase
implements CALSConstants {
    public DeleteColumnOperation() {
        this(new CALSDocumentTypeHelper());
    }

    public DeleteColumnOperation(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    @Override
    public boolean performDeleteColumn(AuthorAccess authorAccess, List<ContentInterval> list, boolean bl) throws AuthorOperationException {
        boolean bl2 = false;
        try {
            CALSTableCellInfoProvider cALSTableCellInfoProvider;
            CALSColSpec cALSColSpec;
            bl2 = super.performDeleteColumn(authorAccess, list, bl);
            if (bl2 && (cALSColSpec = (cALSTableCellInfoProvider = (CALSTableCellInfoProvider)this.tableHelper.getTableCellSpanProvider(this.tableElem)).getColSpec(this.deletedColumnIndex + 1)) != null) {
                List<AuthorNode> list2 = this.tableElem.getContentNodes();
                boolean bl3 = false;
                AuthorElement authorElement = cALSTableCellInfoProvider.getColSpecElement(cALSColSpec);
                for (AuthorNode authorNode : list2) {
                    AttrValue attrValue;
                    if (!this.isElement(authorNode, "colspec")) continue;
                    AuthorElement authorElement2 = (AuthorElement)authorNode;
                    if (authorElement2 == authorElement) {
                        bl3 = true;
                    }
                    if (!bl3 || (attrValue = authorElement2.getAttribute("colnum")) == null || attrValue.getValue() == null) continue;
                    try {
                        int n2 = Integer.parseInt(attrValue.getValue());
                        authorAccess.getDocumentController().setAttribute("colnum", new AttrValue("" + (n2 - 1)), authorElement2);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (authorElement != null) {
                    int n3 = authorAccess.getEditorAccess().getCaretOffset() - (authorElement.getEndOffset() - authorElement.getStartOffset() + 1);
                    authorAccess.getDocumentController().deleteNode(authorElement);
                    authorAccess.getEditorAccess().setCaretPosition(n3);
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return bl2;
    }

    @Override
    protected void updateTableColSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2, int n3) throws AuthorOperationException {
        if (this.deletedColumnIndex + 1 == n2) {
            this.tableHelper.updateTableColSpan(authorAccess, authorTableCellSpanProvider, authorElement, n2 + 1, n3);
        } else if (this.deletedColumnIndex + 1 == n3) {
            this.tableHelper.updateTableColSpan(authorAccess, authorTableCellSpanProvider, authorElement, n2, n3 - 1);
        }
    }
}

