/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.text.BadLocationException;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorOperationStoppedByUserException;
import ro.sync.ecss.extensions.api.AuthorTableCellSpanProvider;
import ro.sync.ecss.extensions.api.SelectionInterpretationMode;
import ro.sync.ecss.extensions.api.node.AuthorDocumentFragment;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.api.table.operations.TableColumnSpecificationInformation;
import ro.sync.ecss.extensions.commons.table.operations.AbstractTableOperation;
import ro.sync.ecss.extensions.commons.table.operations.AuthorTableHelper;
import ro.sync.ecss.extensions.commons.table.operations.InsertRowOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.InsertTableOperationBase;
import ro.sync.ecss.extensions.commons.table.operations.TableOperationsUtil;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class InsertColumnOperationBase
extends AbstractTableOperation {
    public static final String POSITION_ARGUMENT = "insertPosition";
    public static final ArgumentDescriptor POSITION_ARGUMENT_DESCRIPTOR = new ArgumentDescriptor("insertPosition", 3, "The insert position relative to the current column determined by the XPath expression.\nCan be: Before, After.\nNote: If the XPath expression is not defined this argument is ignored.", new String[]{"After", "Before"}, "After");
    private static final ArgumentDescriptor[] ARGUMENTS = new ArgumentDescriptor[]{NAMESPACE_ARGUMENT_DESCRIPTOR, POSITION_ARGUMENT_DESCRIPTOR};

    public InsertColumnOperationBase(AuthorTableHelper authorTableHelper) {
        super(authorTableHelper);
    }

    @Override
    public void doOperation(AuthorAccess authorAccess, ArgumentsMap argumentsMap) throws IllegalArgumentException, AuthorOperationException {
        String string = null;
        Object object = argumentsMap.getArgumentValue("namespace");
        if (object instanceof String) {
            string = (String)object;
        }
        String string2 = "After";
        Object object2 = argumentsMap.getArgumentValue(POSITION_ARGUMENT);
        if (object2 instanceof String) {
            string2 = (String)object2;
        }
        this.performInsertColumn(authorAccess, string, string2, null, null, false, null, null);
    }

    public void performInsertColumn(AuthorAccess authorAccess, String string, AuthorDocumentFragment[] authorDocumentFragmentArray, TableColumnSpecificationInformation tableColumnSpecificationInformation, boolean bl, InsertRowOperationBase insertRowOperationBase, InsertTableOperationBase insertTableOperationBase) throws AuthorOperationException {
        this.performInsertColumn(authorAccess, string, "After", authorDocumentFragmentArray, tableColumnSpecificationInformation, bl, insertRowOperationBase, insertTableOperationBase);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void performInsertColumn(AuthorAccess authorAccess, String string, String string2, AuthorDocumentFragment[] authorDocumentFragmentArray, TableColumnSpecificationInformation tableColumnSpecificationInformation, boolean bl, InsertRowOperationBase insertRowOperationBase, InsertTableOperationBase insertTableOperationBase) throws AuthorOperationException {
        try {
            int n2 = -1;
            int n3 = authorAccess.getEditorAccess().getCaretOffset();
            AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n3);
            AuthorElement authorElement = this.getElementAncestor(authorNode, 2);
            if (authorElement != null) {
                AuthorTableCellSpanProvider authorTableCellSpanProvider = this.tableHelper.getTableCellSpanProvider(authorElement);
                if (this.isTableElement(authorNode, 1)) {
                    n2 = this.findColumnIndex(authorAccess, n3 + 1);
                    if (n2 == -1) {
                        n2 = this.findColumnIndex(authorAccess, n3 - 1);
                        n2 = n2 != -1 ? ++n2 : 0;
                    }
                } else {
                    AuthorElement authorElement2 = this.getElementAncestor(authorNode, 0);
                    if (authorElement2 == null) throw new AuthorOperationException("Cannot find a cell in the table at the current caret position.");
                    int[] nArray = authorAccess.getTableAccess().getTableCellIndex(authorElement2);
                    if (nArray == null) throw new AuthorOperationException("Cannot obtain the index of cell in table. The cell is: " + authorElement2);
                    Integer n4 = authorTableCellSpanProvider.getColSpan(authorElement2);
                    n2 = nArray[1] + ("After".equals(string2) ? (n4 != null ? n4 : 1) : 1);
                }
                if ("Before".equals(string2) && n2 > 0) {
                    --n2;
                }
                int n5 = authorAccess.getTableAccess().getTableNumberOfColumns(authorElement);
                if (authorAccess.getTableAccess().getTableNumberOfColumns(authorElement) == 0 || authorTableCellSpanProvider.hasColumnSpecifications(authorElement)) {
                    this.updateColumnCellsSpan(authorAccess, authorTableCellSpanProvider, authorElement, n2, tableColumnSpecificationInformation, string);
                }
                this.insertNewColumnCells(authorAccess, authorTableCellSpanProvider, authorElement, n2, string, authorDocumentFragmentArray, bl, insertRowOperationBase);
                this.tableHelper.updateTableColumnNumber(authorAccess, authorElement, n5 + 1);
                return;
            } else {
                insertTableOperationBase.insertTable(authorDocumentFragmentArray, bl, authorAccess, string, this.tableHelper);
            }
            return;
        }
        catch (BadLocationException badLocationException) {
            throw new AuthorOperationException("The operation cannot be performed due to: " + badLocationException.getMessage(), badLocationException);
        }
    }

    protected void updateColumnCellsSpan(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2, TableColumnSpecificationInformation tableColumnSpecificationInformation, String string) throws AuthorOperationException {
        int n3 = authorAccess.getTableAccess().getTableRowCount(authorElement);
        if (n2 > 0 && n3 != -1) {
            AuthorElement authorElement2 = null;
            for (int i2 = n3 - 1; i2 >= 0; --i2) {
                AuthorElement authorElement3 = authorAccess.getTableAccess().getTableCellAt(i2, n2, authorElement);
                if (authorElement2 == authorElement3) continue;
                authorElement2 = authorElement3;
                if (authorElement3 == null) continue;
                int[] nArray = authorAccess.getTableAccess().getTableColSpanIndices(authorElement3);
                int n4 = nArray[0];
                int n5 = nArray[1];
                if (n4 >= n2 || n2 > n5) continue;
                this.tableHelper.updateTableColSpan(authorAccess, authorTableCellSpanProvider, authorElement3, n4 + 1, n5 + 2);
            }
        }
    }

    private void insertNewColumnCells(AuthorAccess authorAccess, AuthorTableCellSpanProvider authorTableCellSpanProvider, AuthorElement authorElement, int n2, String string, AuthorDocumentFragment[] authorDocumentFragmentArray, boolean bl, InsertRowOperationBase insertRowOperationBase) throws AuthorOperationException {
        boolean bl2 = false;
        int n3 = authorAccess.getTableAccess().getTableRowCount(authorElement);
        if (n3 != -1) {
            Object object;
            Object object2;
            Object object3;
            int n4;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
            for (n4 = 0; n4 < n3; ++n4) {
                int n5;
                if (n2 > 0) {
                    AuthorElement authorElement2 = authorAccess.getTableAccess().getTableCellAt(n4, n2, authorElement);
                    if (authorElement2 != null) {
                        object3 = authorAccess.getTableAccess().getTableColSpanIndices(authorElement2);
                        object2 = object3[0];
                        object = object3[1];
                        if (object2 < n2 && n2 <= object) {
                            if (bl2) continue;
                            bl2 = this.checkForCompatibility(authorAccess, authorDocumentFragmentArray, n4);
                            continue;
                        }
                    }
                    if ((authorElement2 = authorAccess.getTableAccess().getTableCellAt(n4, n2 - 1, authorElement)) == null) {
                        if (bl2) continue;
                        bl2 = this.checkForCompatibility(authorAccess, authorDocumentFragmentArray, n4);
                        continue;
                    }
                }
                if ((n5 = this.findCellInsertionOffset(authorAccess, authorElement, n4, n2)) != -1) {
                    arrayList2.add(n5);
                    object3 = this.getCellElementName(authorAccess.getTableAccess().getTableRow(n4, authorElement), n2);
                    arrayList.add(object3);
                    if (object3 != null) continue;
                    throw new AuthorOperationException("The table model does not accept a new column at the given position.");
                }
                if (bl2) continue;
                bl2 = this.checkForCompatibility(authorAccess, authorDocumentFragmentArray, n4);
            }
            if (authorDocumentFragmentArray == null) {
                String string2 = this.getDefaultContentForEmptyCells();
                if (string2 != null) {
                    for (int i2 = arrayList2.size() - 1; i2 >= 0; --i2) {
                        object3 = new StringBuilder();
                        ((StringBuilder)object3).append("<").append((String)arrayList.get(i2));
                        if (string != null) {
                            ((StringBuilder)object3).append(" xmlns=\"").append(string).append("\"");
                        }
                        ((StringBuilder)object3).append(">");
                        ((StringBuilder)object3).append(string2);
                        ((StringBuilder)object3).append("</").append((String)arrayList.get(i2)).append(">");
                        authorAccess.getDocumentController().insertXMLFragment(((StringBuilder)object3).toString(), (Integer)arrayList2.get(i2));
                    }
                } else {
                    int[] nArray = new int[arrayList2.size()];
                    for (int i3 = 0; i3 < arrayList2.size(); ++i3) {
                        nArray[i3] = (Integer)arrayList2.get(i3);
                    }
                    authorAccess.getDocumentController().insertMultipleElements(authorElement, arrayList.toArray(new String[0]), nArray, string);
                }
                authorAccess.getEditorAccess().setCaretPosition((Integer)arrayList2.get(0) + 1);
            } else {
                int n6;
                int n7;
                n4 = arrayList2.size();
                int[] nArray = new int[n4];
                object3 = new String[n4];
                for (object2 = 0; object2 < n4; ++object2) {
                    nArray[object2] = (Integer)arrayList2.get((int)object2);
                    object3[object2] = TableOperationsUtil.createCellXMLFragment(authorAccess, authorDocumentFragmentArray, bl, (String)arrayList.get((int)object2), object2, string, this.tableHelper, new String[0]);
                }
                AuthorDocumentFragment[] authorDocumentFragmentArray2 = authorAccess.getDocumentController().createNewDocumentFragmentsInContext((String[])object3, nArray);
                object = false;
                if (insertRowOperationBase != null && n4 <= authorDocumentFragmentArray.length - 1) {
                    n7 = authorAccess.getTableAccess().getTableRowCount(authorElement);
                    AuthorElement authorElement3 = authorAccess.getTableAccess().getTableRow(n7 - 1, authorElement);
                    if (authorElement3 == null) {
                        AuthorOperationException authorOperationException = new AuthorOperationException("The operation failed because the last table row could not be determined.");
                        authorOperationException.setOperationRejectedOnPurpose(true);
                        throw authorOperationException;
                    }
                    n6 = authorElement3.getEndOffset() + 1;
                    object = true;
                    StringBuilder stringBuilder = new StringBuilder();
                    String string3 = insertRowOperationBase.getCellElementName(authorElement, n2);
                    for (int i4 = n4; i4 < authorDocumentFragmentArray.length; ++i4) {
                        try {
                            String string4 = TableOperationsUtil.createCellXMLFragment(authorAccess, authorDocumentFragmentArray, bl, string3, i4, string, this.tableHelper, new String[0]);
                            String string5 = insertRowOperationBase.getRowXMLFragment(authorAccess, authorElement, string, string4, n2);
                            if (string5 == null) {
                                throw new AuthorOperationException("The column cannot be inserted.");
                            }
                            stringBuilder.append(string5);
                            continue;
                        }
                        catch (BadLocationException badLocationException) {
                            throw new AuthorOperationException("The column cannot be inserted.");
                        }
                    }
                    authorDocumentFragmentArray2 = Arrays.copyOf(authorDocumentFragmentArray2, authorDocumentFragmentArray2.length + 1);
                    authorDocumentFragmentArray2[authorDocumentFragmentArray2.length - 1] = authorAccess.getDocumentController().createNewDocumentFragmentInContext(stringBuilder.toString(), n6);
                    nArray = Arrays.copyOf(nArray, nArray.length + 1);
                    nArray[nArray.length - 1] = n6;
                }
                if ((n7 = authorAccess.getDocumentController().insertMultipleFragments(authorElement, authorDocumentFragmentArray2, nArray)) != 0) {
                    int n8 = 0;
                    authorAccess.getEditorAccess().setCaretPosition(nArray[0] + 1);
                    for (n6 = 0; n6 < nArray.length; ++n6) {
                        int n9 = nArray[n6];
                        int n10 = authorDocumentFragmentArray2[n6].getLength();
                        authorAccess.getEditorAccess().getAuthorSelectionModel().addSelection(n9 + n8, n9 + n8 + n10);
                        n8 += n10;
                    }
                    if (object == false) {
                        authorAccess.getEditorAccess().getAuthorSelectionModel().setSelectionInterpretationMode(SelectionInterpretationMode.TABLE_COLUMN);
                    }
                }
            }
        } else {
            throw new AuthorOperationException("Could not obtain the number of rows. Table is invalid.");
        }
    }

    private boolean checkForCompatibility(AuthorAccess authorAccess, AuthorDocumentFragment[] authorDocumentFragmentArray, int n2) throws AuthorOperationException {
        boolean bl = false;
        if (authorDocumentFragmentArray != null && n2 < authorDocumentFragmentArray.length) {
            int n3 = authorAccess.getWorkspaceAccess().showConfirmDialog(authorAccess.getAuthorResourceBundle().getMessage("insert.table.column"), authorAccess.getAuthorResourceBundle().getMessage("handle.paste.column.warning"), new String[]{authorAccess.getAuthorResourceBundle().getMessage("insert.table.column"), authorAccess.getAuthorResourceBundle().getMessage("cancel")}, new int[]{1, 0});
            if (n3 != 1) {
                throw new AuthorOperationStoppedByUserException("Cancelled by user");
            }
            bl = true;
        }
        return bl;
    }

    private int findColumnIndex(AuthorAccess authorAccess, int n2) throws BadLocationException, AuthorOperationException {
        int n3 = -1;
        AuthorNode authorNode = authorAccess.getDocumentController().getNodeAtOffset(n2);
        if (this.isTableElement(authorNode, 0)) {
            int[] nArray = authorAccess.getTableAccess().getTableCellIndex((AuthorElement)authorNode);
            if (nArray != null) {
                n3 = nArray[1];
            } else {
                throw new AuthorOperationException("Cannot obtain the index of cell in table. The cell is: " + authorNode);
            }
        }
        return n3;
    }

    @Override
    public ArgumentDescriptor[] getArguments() {
        return ARGUMENTS;
    }

    @Override
    public String getDescription() {
        return "Insert a table column.";
    }

    protected abstract String getCellElementName(AuthorElement var1, int var2);

    protected String getDefaultContentForEmptyCells() {
        return null;
    }
}

