/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.OutputStream;
import java.util.Map;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileListUtil;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNTranslator;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNExportEditor
implements ISVNEditor {
    private File myRoot;
    private boolean myIsForce;
    private String myEOLStyle;
    private File myCurrentDirectory;
    private File myCurrentFile;
    private File myCurrentTmpFile;
    private String myCurrentPath;
    private Map<String, String> myExternals;
    private SVNProperties myFileProperties;
    private ISVNEventHandler myEventDispatcher;
    private String myURL;
    private String myRepositoryRootUrl;
    private ISVNOptions myOptions;
    private SVNDeltaProcessor myDeltaProcessor;
    private boolean myIsExpandKeywords;
    private String myChecksum;

    public SVNExportEditor(ISVNEventHandler iSVNEventHandler, String string, File file, boolean bl, String string2, boolean bl2, String string3, ISVNOptions iSVNOptions) {
        this.myRoot = file;
        this.myIsForce = bl;
        this.myEOLStyle = string2;
        this.myExternals = new SVNHashMap();
        this.myEventDispatcher = iSVNEventHandler;
        this.myURL = string;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myOptions = iSVNOptions;
        this.myIsExpandKeywords = bl2;
        this.myRepositoryRootUrl = string3;
    }

    public Map<String, String> getCollectedExternals() {
        return this.myExternals;
    }

    public void openRoot(long l2) throws SVNException {
        this.addDir("", null, -1L);
    }

    public void addDir(String string, String string2, long l2) throws SVNException {
        this.myCurrentDirectory = new File(this.myRoot, string);
        this.myCurrentPath = string;
        SVNFileType sVNFileType = SVNFileType.getType((File)this.myCurrentDirectory);
        if (sVNFileType == SVNFileType.FILE || sVNFileType == SVNFileType.SYMLINK) {
            if (!this.myIsForce) {
                SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_NOT_DIRECTORY, (String)"''{0}'' exists and is not a directory", (Object)this.myCurrentDirectory);
                SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
            } else {
                SVNFileUtil.deleteAll((File)this.myCurrentDirectory, (ISVNEventHandler)this.myEventDispatcher);
            }
        } else if (sVNFileType == SVNFileType.DIRECTORY && !this.myIsForce) {
            SVNErrorMessage sVNErrorMessage;
            if (!"".equals(string)) {
                sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_OBSTRUCTED_UPDATE, (String)"''{0}'' already exists", (Object)this.myCurrentDirectory);
                SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
            }
            if ((sVNErrorMessage = SVNFileListUtil.listFiles((File)this.myCurrentDirectory)) != null && ((SVNErrorMessage)sVNErrorMessage).length > 0) {
                SVNErrorMessage sVNErrorMessage2 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_OBSTRUCTED_UPDATE, (String)"''{0}'' already exists", (Object)this.myCurrentDirectory);
                SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage2, (SVNLogType)SVNLogType.WC);
            }
        } else if (sVNFileType == SVNFileType.NONE && !this.myCurrentDirectory.mkdirs()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_NOT_DIRECTORY, (String)"Cannot create directory ''{0}''", (Object)this.myCurrentDirectory);
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
        }
        this.myEventDispatcher.handleEvent(SVNEventFactory.createSVNEvent((File)this.myCurrentDirectory, (SVNNodeKind)SVNNodeKind.DIR, null, (long)-1L, (SVNEventAction)SVNEventAction.UPDATE_ADD, null, null, null), -1.0);
    }

    public void changeDirProperty(String string, SVNPropertyValue sVNPropertyValue) throws SVNException {
        if ("svn:externals".equals(string) && sVNPropertyValue != null) {
            this.myExternals.put(this.myCurrentPath, sVNPropertyValue.getString());
        }
    }

    public void closeDir() throws SVNException {
        this.myCurrentDirectory = this.myCurrentDirectory.getParentFile();
        this.myCurrentPath = SVNPathUtil.removeTail((String)this.myCurrentPath);
    }

    public void addFile(String string, String string2, long l2) throws SVNException {
        File file = new File(this.myRoot, string);
        if (!this.myIsForce && file.exists()) {
            SVNErrorMessage sVNErrorMessage = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.WC_OBSTRUCTED_UPDATE, (String)"File ''{0}'' already exists", (Object)file);
            SVNErrorManager.error((SVNErrorMessage)sVNErrorMessage, (SVNLogType)SVNLogType.WC);
        }
        this.myCurrentFile = file;
        this.myFileProperties = new SVNProperties();
        this.myChecksum = null;
    }

    public void changeFileProperty(String string, String string2, SVNPropertyValue sVNPropertyValue) throws SVNException {
        this.myFileProperties.put(string2, sVNPropertyValue);
    }

    public void applyTextDelta(String string, String string2) throws SVNException {
        String string3 = SVNPathUtil.tail((String)string);
        this.myCurrentTmpFile = SVNFileUtil.createUniqueFile((File)this.myCurrentDirectory, (String)string3, (String)".tmp", (boolean)false);
        this.myDeltaProcessor.applyTextDelta((File)null, this.myCurrentTmpFile, true);
    }

    public OutputStream textDeltaChunk(String string, SVNDiffWindow sVNDiffWindow) throws SVNException {
        return this.myDeltaProcessor.textDeltaChunk(sVNDiffWindow);
    }

    public void textDeltaEnd(String string) throws SVNException {
        this.myChecksum = this.myDeltaProcessor.textDeltaEnd();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeFile(String string, String string2) throws SVNException {
        String string3;
        if (string2 == null) {
            string2 = this.myFileProperties.getStringValue("svn:entry:checksum");
        }
        if (this.myIsForce) {
            this.myCurrentFile.delete();
        }
        String string4 = this.myChecksum != null ? this.myChecksum : SVNFileUtil.computeChecksum((File)this.myCurrentTmpFile);
        this.myChecksum = null;
        if (string2 != null && !string2.equals(string4)) {
            string3 = SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CHECKSUM_MISMATCH, (String)"Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", (Object[])new Object[]{this.myCurrentFile, string2, string4});
            SVNErrorManager.error((SVNErrorMessage)string3, (SVNLogType)SVNLogType.WC);
        }
        try {
            boolean bl;
            Object object;
            String string5;
            string3 = this.myFileProperties.getStringValue("svn:entry:committed-date");
            boolean bl2 = this.myFileProperties.getStringValue("svn:special") != null;
            String string6 = this.myFileProperties.getStringValue("svn:mime-type");
            boolean bl3 = SVNProperty.isBinaryMimeType((String)string6);
            String string7 = this.myIsExpandKeywords ? this.myFileProperties.getStringValue("svn:keywords") : null;
            Map map = null;
            if (string7 != null) {
                string5 = SVNPathUtil.append((String)this.myURL, (String)SVNEncodingUtil.uriEncode((String)this.myCurrentPath));
                string5 = SVNPathUtil.append((String)string5, (String)SVNEncodingUtil.uriEncode((String)this.myCurrentFile.getName()));
                object = this.myFileProperties.getStringValue("svn:entry:last-author");
                String string8 = this.myFileProperties.getStringValue("svn:entry:committed-rev");
                map = SVNTranslator.computeKeywords((String)string7, (String)string5, (String)this.myRepositoryRootUrl, (String)object, (String)string3, (String)string8, (ISVNOptions)this.myOptions);
            }
            string5 = SVNTranslator.getCharset((String)this.myFileProperties.getStringValue("svnkit:charset"), (String)string6, (Object)this.myCurrentFile.getPath(), (ISVNOptions)this.myOptions);
            object = null;
            if ("native".equals(this.myFileProperties.getStringValue("svn:eol-style"))) {
                object = SVNTranslator.getEOL((String)(this.myEOLStyle != null ? this.myEOLStyle : this.myFileProperties.getStringValue("svn:eol-style")), (ISVNOptions)this.myOptions);
            } else if (this.myFileProperties.containsName("svn:eol-style")) {
                object = SVNTranslator.getEOL((String)this.myFileProperties.getStringValue("svn:eol-style"), (ISVNOptions)this.myOptions);
            }
            if (bl3) {
                string5 = null;
                object = null;
                map = null;
            }
            if (string5 != null || object != null || map != null && !map.isEmpty() || bl2) {
                SVNTranslator.translate((File)this.myCurrentTmpFile, (File)this.myCurrentFile, (String)string5, (byte[])object, (Map)map, (boolean)bl2, (boolean)true);
            } else {
                SVNFileUtil.rename((File)this.myCurrentTmpFile, (File)this.myCurrentFile);
            }
            boolean bl4 = bl = this.myFileProperties.getStringValue("svn:executable") != null;
            if (bl) {
                SVNFileUtil.setExecutable((File)this.myCurrentFile, (boolean)true);
            }
            if (!bl2 && string3 != null) {
                SVNFileUtil.setLastModified((File)this.myCurrentFile, (long)SVNDate.parseDate((String)string3).getTime());
            }
            this.myEventDispatcher.handleEvent(SVNEventFactory.createSVNEvent((File)this.myCurrentFile, (SVNNodeKind)SVNNodeKind.FILE, null, (long)-1L, (SVNEventAction)SVNEventAction.UPDATE_ADD, null, null, null), -1.0);
        }
        finally {
            this.myCurrentTmpFile.delete();
        }
    }

    public SVNCommitInfo closeEdit() throws SVNException {
        return null;
    }

    public void targetRevision(long l2) throws SVNException {
    }

    public void deleteEntry(String string, long l2) throws SVNException {
    }

    public void absentDir(String string) throws SVNException {
    }

    public void absentFile(String string) throws SVNException {
    }

    public void openDir(String string, long l2) throws SVNException {
    }

    public void openFile(String string, long l2) throws SVNException {
    }

    public void abortEdit() throws SVNException {
    }
}

