/*
 * Decompiled with CFR 0.152.
 */
package org.ditang.relaxng.defaults;

import com.thaiopensource.relaxng.pattern.DefaultValuesExtractor;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.resolver.Resolver;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.ValidateProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.ditang.relaxng.defaults.OxygenRelaxNGSchemaReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class RelaxNGDefaultValues {
    private ErrorHandler eh;
    private final Resolver resolver;
    private DefaultValuesCollector defaultValuesCollector = null;

    public RelaxNGDefaultValues(Resolver resolver, ErrorHandler errorHandler) {
        this.resolver = resolver;
        this.eh = errorHandler;
    }

    protected abstract SchemaReader getSchemaReader();

    public void update(InputSource inputSource) throws SAXException {
        this.defaultValuesCollector = null;
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        propertyMapBuilder.put(ValidateProperty.RESOLVER, (Object)this.resolver);
        propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, (Object)this.eh);
        PropertyMap propertyMap = propertyMapBuilder.toPropertyMap();
        try {
            OxygenRelaxNGSchemaReader.SchemaWrapper schemaWrapper = (OxygenRelaxNGSchemaReader.SchemaWrapper)this.getSchemaReader().createSchema(inputSource, propertyMap);
            Pattern pattern = schemaWrapper.getStart();
            this.defaultValuesCollector = new DefaultValuesCollector(pattern);
        }
        catch (IncorrectSchemaException incorrectSchemaException) {
            this.eh.warning(new SAXParseException("Error loading defaults: " + incorrectSchemaException.getMessage(), null, (Exception)((Object)incorrectSchemaException)));
        }
        catch (Exception exception) {
            this.eh.warning(new SAXParseException("Error loading defaults: " + exception.getMessage(), null, exception));
        }
        catch (StackOverflowError stackOverflowError) {
            this.eh.warning(new SAXParseException("Error loading defaults: " + stackOverflowError.getMessage(), null, null));
        }
    }

    public List<Attribute> getDefaultAttributes(String string, String string2) {
        if (this.defaultValuesCollector != null) {
            return this.defaultValuesCollector.getDefaultAttributes(string, string2);
        }
        return null;
    }

    class Attribute {
        String localName;
        String namespace;
        String value;

        public Attribute(String string, String string2, String string3) {
            this.localName = string;
            this.namespace = string2;
            this.value = string3;
        }
    }

    class DefaultValuesCollector
    implements DefaultValuesExtractor.DefaultValuesListener {
        private HashMap<String, List<Attribute>> defaults = new HashMap();

        public DefaultValuesCollector(Pattern pattern) {
            new DefaultValuesExtractor(this).parsePattern(pattern);
        }

        private String getKey(String string, String string2) {
            return string + "#" + (string2 == null ? "" : string2);
        }

        private List<Attribute> getDefaultAttributes(String string, String string2) {
            return this.defaults.get(this.getKey(string, string2));
        }

        @Override
        public void defaultValue(String string, String string2, String string3, String string4, String string5) {
            String string6 = this.getKey(string, string2);
            List<Attribute> list = this.defaults.get(string6);
            if (list == null) {
                list = new ArrayList<Attribute>();
                this.defaults.put(string6, list);
            }
            list.add(new Attribute(string3, string4, string5));
        }
    }
}

