/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import javax.imageio.ImageIO;
import javax.imageio.stream.ImageInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlgraphics.image.loader.ImageSessionContext;
import org.apache.xmlgraphics.image.loader.ImageSource;
import org.apache.xmlgraphics.image.loader.util.ImageUtil;
import org.apache.xmlgraphics.image.loader.util.SoftMapCache;

public abstract class AbstractImageSessionContext
implements ImageSessionContext {
    private static Log log = LogFactory.getLog(AbstractImageSessionContext.class);
    private static boolean noSourceReuse = false;
    private SoftMapCache sessionSources = new SoftMapCache(false);

    protected abstract Source resolveURI(String var1);

    public Source newSource(String string) {
        URL uRL;
        Source source = this.resolveURI(string);
        if (source == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("URI could not be resolved: " + string));
            }
            return null;
        }
        if (!(source instanceof StreamSource) && !(source instanceof SAXSource)) {
            return source;
        }
        ImageSource imageSource = null;
        String string2 = source.getSystemId();
        try {
            uRL = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        File file = AbstractImageSessionContext.toFile(uRL);
        if (file != null) {
            boolean bl = true;
            assert (source instanceof StreamSource || source instanceof SAXSource);
            InputStream inputStream = ImageUtil.getInputStream((Source)source);
            if (inputStream == null) {
                try {
                    inputStream = new FileInputStream(file);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    log.error((Object)("Error while opening file. Could not load image from system identifier '" + source.getSystemId() + "' (" + fileNotFoundException.getMessage() + ")"));
                    return null;
                }
            }
            if (inputStream != null) {
                inputStream = ImageUtil.decorateMarkSupported((InputStream)inputStream);
                try {
                    if (ImageUtil.isGZIPCompressed((InputStream)inputStream)) {
                        bl = false;
                    }
                }
                catch (IOException iOException) {
                    log.error((Object)("Error while checking the InputStream for GZIP compression. Could not load image from system identifier '" + source.getSystemId() + "' (" + iOException.getMessage() + ")"));
                    return null;
                }
            }
            if (bl) {
                IOUtils.closeQuietly((InputStream)inputStream);
                try {
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
                    if (imageInputStream == null) {
                        log.error((Object)("Unable to create ImageInputStream for local file " + file + " from system identifier '" + source.getSystemId() + "'"));
                        return null;
                    }
                    imageSource = new ImageSource(imageInputStream, string2, true);
                }
                catch (IOException iOException) {
                    log.error((Object)("Unable to create ImageInputStream for local file from system identifier '" + source.getSystemId() + "' (" + iOException.getMessage() + ")"));
                }
            } else if (source instanceof StreamSource && ImageUtil.hasInputStream((Source)source)) {
                ((StreamSource)source).setInputStream(inputStream);
            }
        }
        if (imageSource == null) {
            if (ImageUtil.hasReader((Source)source) && !ImageUtil.hasInputStream((Source)source)) {
                return source;
            }
            InputStream inputStream = ImageUtil.getInputStream((Source)source);
            if (inputStream == null && uRL != null) {
                try {
                    inputStream = uRL.openStream();
                }
                catch (Exception exception) {
                    log.error((Object)("Unable to obtain stream from system identifier '" + source.getSystemId() + "'"));
                }
            }
            if (inputStream == null) {
                log.error((Object)("The Source that was returned from URI resolution didn't contain an InputStream for URI: " + string));
                return null;
            }
            try {
                inputStream = ImageUtil.autoDecorateInputStream((InputStream)inputStream);
                imageSource = new ImageSource(this.createImageInputStream(inputStream), source.getSystemId(), false);
            }
            catch (IOException iOException) {
                log.error((Object)("Unable to create ImageInputStream for InputStream from system identifier '" + source.getSystemId() + "' (" + iOException.getMessage() + ")"));
            }
        }
        return imageSource;
    }

    protected ImageInputStream createImageInputStream(InputStream inputStream) throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        return (ImageInputStream)Proxy.newProxyInstance(ImageInputStream.class.getClassLoader(), new Class[]{ImageInputStream.class}, (InvocationHandler)new ObservingImageInputStreamInvocationHandler(imageInputStream, inputStream));
    }

    public static File toFile(URL uRL) {
        if (uRL == null || !uRL.getProtocol().equals("file")) {
            return null;
        }
        try {
            String string = "";
            if (uRL.getHost() != null && uRL.getHost().length() > 0) {
                string = string + Character.toString(File.separatorChar) + Character.toString(File.separatorChar) + uRL.getHost();
            }
            string = string + uRL.getFile().replace('/', File.separatorChar);
            File file = new File(string = URLDecoder.decode(string, "UTF-8"));
            if (!file.isFile()) {
                return null;
            }
            return file;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            assert (false);
            return null;
        }
    }

    public Source getSource(String string) {
        return (Source)this.sessionSources.remove((Object)string);
    }

    public Source needSource(String string) throws FileNotFoundException {
        Source source = this.getSource(string);
        if (source == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating new Source for " + string));
            }
            if ((source = this.newSource(string)) == null) {
                throw new FileNotFoundException("Image not found: " + string);
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Reusing Source for " + string));
        }
        return source;
    }

    public void returnSource(String string, Source source) {
        ImageInputStream imageInputStream = ImageUtil.getImageInputStream((Source)source);
        try {
            if (imageInputStream != null && imageInputStream.getStreamPosition() != 0L) {
                throw new IllegalStateException("ImageInputStream is not reset for: " + string);
            }
        }
        catch (IOException iOException) {
            ImageUtil.closeQuietly((Source)source);
        }
        if (this.isReusable(source)) {
            log.debug((Object)("Returning Source for " + string));
            this.sessionSources.put((Object)string, (Object)source);
        } else {
            ImageUtil.closeQuietly((Source)source);
        }
    }

    protected boolean isReusable(Source source) {
        ImageSource imageSource;
        if (noSourceReuse) {
            return false;
        }
        if (source instanceof ImageSource && (imageSource = (ImageSource)source).getImageInputStream() != null) {
            return true;
        }
        return source instanceof DOMSource;
    }

    static {
        String string = System.getProperty(AbstractImageSessionContext.class.getName() + ".no-source-reuse");
        noSourceReuse = Boolean.valueOf(string);
    }

    private static class ObservingImageInputStreamInvocationHandler
    implements InvocationHandler {
        private ImageInputStream iin;
        private InputStream in;

        public ObservingImageInputStreamInvocationHandler(ImageInputStream imageInputStream, InputStream inputStream) {
            this.iin = imageInputStream;
            this.in = inputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if ("close".equals(method.getName())) {
                try {
                    Object object2 = method.invoke((Object)this.iin, objectArray);
                    return object2;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)this.in);
                    this.in = null;
                }
            }
            return method.invoke((Object)this.iin, objectArray);
        }
    }
}

