/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.fop.datatypes.URISpecification;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.Property;
import org.apache.fop.fo.properties.PropertyMaker;
import org.apache.fop.util.CompareUtil;

public class URIProperty
extends Property {
    private URI resolvedURI;

    protected URIProperty(URI uRI) {
        this.resolvedURI = uRI;
    }

    private URIProperty(String string, boolean bl) {
        if (bl && string != null && !"".equals(string)) {
            this.resolvedURI = URI.create(string);
        } else {
            this.setSpecifiedValue(string);
        }
    }

    public String getString() {
        if (this.resolvedURI == null) {
            return this.getSpecifiedValue();
        }
        return this.resolvedURI.toString();
    }

    public String toString() {
        return this.getString();
    }

    public int hashCode() {
        int n2 = 1;
        n2 = 31 * n2 + CompareUtil.getHashCode((Object)this.getSpecifiedValue());
        n2 = 31 * n2 + CompareUtil.getHashCode((Object)this.resolvedURI);
        return n2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof URIProperty)) {
            return false;
        }
        URIProperty uRIProperty = (URIProperty)((Object)object);
        return CompareUtil.equal((Object)this.getSpecifiedValue(), (Object)uRIProperty.getSpecifiedValue()) && CompareUtil.equal((Object)this.resolvedURI, (Object)uRIProperty.resolvedURI);
    }

    public static class Maker
    extends PropertyMaker {
        public Maker(int n2) {
            super(n2);
        }

        public Property make(PropertyList propertyList, String string, FObj fObj) throws PropertyException {
            URIProperty uRIProperty = null;
            if (string.matches("(?s)^(url\\(('|\")?)?data:.*$")) {
                uRIProperty = new URIProperty(string, false);
            } else {
                if (string.indexOf(92) != -1) {
                    string = string.replace('\\', '/');
                }
                try {
                    URI uRI = new URI(URISpecification.escapeURI((String)string));
                    URIProperty uRIProperty2 = (URIProperty)propertyList.get(275, true, false);
                    if (uRIProperty2 == null) {
                        if (this.propId == 275) {
                            uRIProperty = new URIProperty(uRI);
                            uRIProperty.setSpecifiedValue(string);
                        } else {
                            uRIProperty = new URIProperty(string, false);
                        }
                    } else {
                        uRIProperty = new URIProperty(uRIProperty2.resolvedURI.resolve(uRI));
                        uRIProperty.setSpecifiedValue(string);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    uRISyntaxException.printStackTrace();
                    throw new PropertyException("Invalid URI specified");
                }
            }
            return uRIProperty;
        }
    }
}

