/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.trans.XPathException;
import ro.sync.util.URLUtil;

public class StandardOutputResolver
implements OutputURIResolver,
Serializable {
    private static StandardOutputResolver theInstance = new StandardOutputResolver();

    public static StandardOutputResolver getInstance() {
        return theInstance;
    }

    public StandardOutputResolver newInstance() {
        return this;
    }

    public Result resolve(String string, String string2) throws XPathException {
        String string3 = "base";
        try {
            Object object;
            Object object2;
            URI uRI;
            if (string.length() == 0) {
                if (string2 == null) {
                    throw new XPathException("The system identifier of the principal output file is unknown");
                }
                uRI = new URI(string2);
            } else {
                string3 = "relative";
                uRI = new URI(string);
            }
            if (!uRI.isAbsolute()) {
                if (string2 == null) {
                    throw new XPathException("The system identifier of the principal output file is unknown");
                }
                string3 = "base";
                URI uRI2 = new URI(string2);
                string3 = "relative";
                uRI = uRI2.resolve(string);
                try {
                    object2 = uRI2.toURL();
                    if (URLUtil.isFromUNCPath((URL)object2)) {
                        object = URLUtil.resolveRelativeSystemIDs((URL)object2, string);
                        uRI = ((URL)object).toURI();
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            boolean bl = false;
            if ("file".equals(uRI.getScheme())) {
                try {
                    return StandardOutputResolver.makeOutputFile(uRI);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    bl = true;
                }
            }
            if (bl || !"file".equals(uRI.getScheme())) {
                object2 = uRI.toURL().openConnection();
                ((URLConnection)object2).setDoInput(false);
                ((URLConnection)object2).setDoOutput(true);
                ((URLConnection)object2).connect();
                object = ((URLConnection)object2).getOutputStream();
                StreamResult streamResult = new StreamResult((OutputStream)object);
                streamResult.setSystemId(uRI.toASCIIString());
                return streamResult;
            }
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XPathException("Invalid syntax for " + string3 + " URI", (Throwable)uRISyntaxException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XPathException("Invalid " + string3 + " URI syntax", (Throwable)illegalArgumentException);
        }
        catch (MalformedURLException malformedURLException) {
            throw new XPathException("Resolved URL is malformed", (Throwable)malformedURLException);
        }
        catch (UnknownServiceException unknownServiceException) {
            throw new XPathException("Specified protocol does not allow output", (Throwable)unknownServiceException);
        }
        catch (IOException iOException) {
            throw new XPathException("Cannot open connection to specified URL", (Throwable)iOException);
        }
    }

    public static synchronized Result makeOutputFile(URI uRI) throws XPathException {
        try {
            return new StreamResult(new File(uRI));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new XPathException("Cannot write to URI " + uRI + " (" + illegalArgumentException.getMessage() + ")");
        }
    }

    public void close(Result result) throws XPathException {
        if (result instanceof StreamResult) {
            Writer writer;
            OutputStream outputStream = ((StreamResult)result).getOutputStream();
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    throw new XPathException("Failed while closing output file", (Throwable)iOException);
                }
            }
            if ((writer = ((StreamResult)result).getWriter()) != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    throw new XPathException("Failed while closing output file", (Throwable)iOException);
                }
            }
        }
    }
}

