/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.parser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.LocationProvider;
import net.sf.saxon.expr.AndExpression;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.CastToList;
import net.sf.saxon.expr.CastToUnion;
import net.sf.saxon.expr.CastableExpression;
import net.sf.saxon.expr.CastableToUnion;
import net.sf.saxon.expr.Container;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.ForExpression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.LetExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.OrExpression;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.QuantifiedExpression;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.TreatExpression;
import net.sf.saxon.expr.ValueComparison;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.flwor.Clause;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.ForEach;
import net.sf.saxon.expr.instruct.LocationMap;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.instruct.TraceExpression;
import net.sf.saxon.expr.parser.CodeInjector;
import net.sf.saxon.expr.parser.ExpressionLocation;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.functions.CurrentGroup;
import net.sf.saxon.functions.CurrentGroupingKey;
import net.sf.saxon.functions.RegexGroup;
import net.sf.saxon.functions.SystemFunctionCall;
import net.sf.saxon.functions.VendorFunctionLibrary;
import net.sf.saxon.lib.NamespaceConstant;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StandardNames;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyChildNodeTest;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.DocumentNodeTest;
import net.sf.saxon.pattern.LocalNameTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NamespaceTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.query.Annotation;
import net.sf.saxon.query.QueryModule;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.AnySimpleType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ErrorType;
import net.sf.saxon.type.ExternalObjectType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.ListType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Type;
import net.sf.saxon.type.UnionType;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.Int64Value;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntArraySet;
import net.sf.saxon.z.IntSet;

public class ExpressionParser {
    protected Tokenizer t;
    protected StaticContext env;
    protected Stack<Binding> rangeVariables = new Stack();
    protected Container defaultContainer;
    protected NameChecker nameChecker;
    protected boolean allowXPath30Syntax = false;
    protected boolean scanOnly = false;
    protected CodeInjector codeInjector = null;
    protected int language = 0;
    public static final int XPATH = 0;
    public static final int XSLT_PATTERN = 1;
    public static final int SEQUENCE_TYPE = 2;
    public static final int XQUERY = 3;
    protected DecimalValue languageVersion = DecimalValue.TWO;
    protected int catchDepth = 0;

    public void setCodeInjector(CodeInjector codeInjector) {
        this.codeInjector = codeInjector;
    }

    public CodeInjector getCodeInjector() {
        return this.codeInjector;
    }

    public Tokenizer getTokenizer() {
        return this.t;
    }

    public StaticContext getStaticContext() {
        return this.env;
    }

    public void setDefaultContainer(Container container) {
        this.defaultContainer = container;
    }

    public Container getDefaultContainer() {
        return this.defaultContainer;
    }

    public NameChecker getNameChecker() {
        return this.nameChecker;
    }

    public void nextToken() throws XPathException {
        block3: {
            try {
                this.t.next();
                if (this.t.currentToken != 201 && this.t.currentToken != 35 || !this.t.currentTokenValue.startsWith("{")) break block3;
                if (this.allowXPath30Syntax) {
                    this.t.currentTokenValue = this.normalizeEQName(this.t.currentTokenValue);
                    break block3;
                }
                throw new XPathException("The expanded QName syntax \"uri\":local is not allowed in this version of XPath/XQuery");
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage());
            }
        }
    }

    public void expect(int n2) throws XPathException {
        if (this.t.currentToken != n2) {
            this.grumble("expected \"" + Token.tokens[n2] + "\", found " + this.currentTokenDisplay());
        }
    }

    public void grumble(String string) throws XPathException {
        this.grumble(string, this.language == 1 ? "XTSE0340" : "XPST0003");
    }

    public void grumble(String string, String string2) throws XPathException {
        this.grumble(string, new StructuredQName("", "http://www.w3.org/2005/xqt-errors", string2), -1);
    }

    public void grumble(String string, String string2, int n2) throws XPathException {
        this.grumble(string, new StructuredQName("", "http://www.w3.org/2005/xqt-errors", string2), n2);
    }

    protected void grumble(String string, StructuredQName structuredQName, int n2) throws XPathException {
        int n3;
        int n4;
        if (structuredQName == null) {
            structuredQName = new StructuredQName("err", "http://www.w3.org/2005/xqt-errors", "XPST0003");
        }
        String string2 = this.t.recentText(-1);
        if (n2 == -1) {
            n4 = this.t.getLineNumber();
            n3 = this.t.getColumnNumber();
        } else {
            n4 = this.t.getLineNumber(n2);
            n3 = this.t.getColumnNumber(n2);
        }
        String string3 = n4 == 1 ? "" : "on line " + n4 + ' ';
        String string4 = "at char " + n3 + ' ';
        String string5 = this.getLanguage() + " syntax error " + string4 + string3 + (string2.startsWith("...") ? "near" : "in") + ' ' + Err.wrap((CharSequence)string2) + ":\n    ";
        XPathException xPathException = new XPathException(string);
        if (n4 > 1 || n3 > 0) {
            xPathException.setLocator((SourceLocator)new ExpressionLocation(null, n4, n3));
        }
        xPathException.setAdditionalLocationText(string5);
        xPathException.setIsStaticError(true);
        xPathException.setErrorCodeQName(structuredQName);
        throw xPathException;
    }

    protected void warning(String string) throws XPathException {
        String string2 = this.t.recentText(-1);
        int n2 = this.t.getLineNumber();
        String string3 = n2 == 1 ? "" : "on line " + n2 + ' ';
        String string4 = string3 + (string.startsWith("...") ? "near" : "in") + ' ' + Err.wrap((CharSequence)string2) + ":\n    ";
        this.env.issueWarning(string4 + string, null);
    }

    public void setLanguage(int n2, DecimalValue decimalValue) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                if (DecimalValue.TWO_POINT_ONE.equals((Object)decimalValue)) {
                    decimalValue = DecimalValue.THREE;
                }
                if (DecimalValue.TWO.equals((Object)decimalValue) || DecimalValue.THREE.equals((Object)decimalValue)) break;
                throw new IllegalArgumentException("Unsupported language version " + decimalValue);
            }
            case 3: {
                if (DecimalValue.ONE_POINT_ONE.equals((Object)decimalValue)) {
                    decimalValue = DecimalValue.THREE;
                }
                if (DecimalValue.ONE.equals((Object)decimalValue) || DecimalValue.THREE.equals((Object)decimalValue)) break;
                throw new IllegalArgumentException("Unsupported language version " + decimalValue);
            }
            default: {
                throw new IllegalArgumentException("Unknown language " + n2);
            }
        }
        this.language = n2;
        this.languageVersion = decimalValue;
        this.allowXPath30Syntax = DecimalValue.THREE.equals((Object)this.languageVersion);
    }

    protected String getLanguage() {
        switch (this.language) {
            case 0: {
                return "XPath";
            }
            case 1: {
                return "XSLT Pattern";
            }
            case 2: {
                return "SequenceType";
            }
            case 3: {
                return "XQuery";
            }
        }
        return "XPath";
    }

    protected String currentTokenDisplay() {
        if (this.t.currentToken == 201) {
            return "name \"" + this.t.currentTokenValue + '\"';
        }
        if (this.t.currentToken == -1) {
            return "(unknown token)";
        }
        return '\"' + Token.tokens[this.t.currentToken] + '\"';
    }

    public Expression parse(String string, int n2, int n3, int n4, StaticContext staticContext) throws XPathException {
        this.env = staticContext;
        this.nameChecker = staticContext.getConfiguration().getNameChecker();
        this.t = new Tokenizer();
        this.customizeTokenizer(this.t);
        try {
            this.t.tokenize(string, n2, -1, n4);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
        Expression expression = this.parseExpression();
        if (this.t.currentToken != n3) {
            if (this.t.currentToken == 0 && n3 == 215) {
                this.grumble("Missing curly brace after expression in attribute value template", "XTSE0350");
            } else {
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of expression");
            }
        }
        return expression;
    }

    protected void customizeTokenizer(Tokenizer tokenizer) {
    }

    public SequenceType parseSequenceType(String string, StaticContext staticContext) throws XPathException {
        this.env = staticContext;
        this.nameChecker = staticContext.getConfiguration().getNameChecker();
        this.language = 2;
        this.t = new Tokenizer();
        try {
            this.t.tokenize(string, 0, -1, 1);
        }
        catch (XPathException xPathException) {
            this.grumble(xPathException.getMessage());
        }
        SequenceType sequenceType = this.parseSequenceType();
        if (this.t.currentToken != 0) {
            this.grumble("Unexpected token " + this.currentTokenDisplay() + " beyond end of SequenceType");
        }
        return sequenceType;
    }

    public Expression parseExpression() throws XPathException {
        Expression expression = this.parseExprSingle();
        ArrayList<Expression> arrayList = null;
        while (this.t.currentToken == 7) {
            if (arrayList == null) {
                arrayList = new ArrayList<Expression>(10);
                arrayList.add(expression);
            }
            this.nextToken();
            Expression expression2 = this.parseExprSingle();
            this.setLocation(expression2);
            arrayList.add(expression2);
        }
        if (arrayList != null) {
            expression = Block.makeBlock(arrayList);
            this.setLocation(expression);
        }
        return expression;
    }

    public Expression parseExprSingle() throws XPathException {
        switch (this.t.currentToken) {
            case 73: 
            case 74: 
            case 211: 
            case 216: {
                return this.parseFLWORExpression();
            }
            case 32: 
            case 33: {
                return this.parseQuantifiedExpression();
            }
            case 37: {
                return this.parseIfExpression();
            }
            case 66: {
                return this.parseSwitchExpression();
            }
            case 65: {
                return this.parseTypeswitchExpression();
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                return this.parseValidateExpression();
            }
            case 218: {
                return this.parseExtensionExpression();
            }
            case 60: {
                if (this.t.currentTokenValue.equals("try")) {
                    return this.parseTryCatchExpression();
                }
                if (!this.t.currentTokenValue.equals("map")) break;
                return this.parseMapExpression();
            }
        }
        return this.parseBinaryExpression(this.parseUnaryExpression(), 4);
    }

    public Expression parseBinaryExpression(Expression expression, int n2) throws XPathException {
        block4: while (this.getCurrentOperatorPrecedence() >= n2) {
            int n3 = this.t.currentToken;
            int n4 = this.getCurrentOperatorPrecedence();
            switch (n3) {
                case 45: 
                case 47: {
                    this.nextToken();
                    SequenceType sequenceType = this.parseSequenceType();
                    expression = this.makeSequenceTypeExpression(expression, n3, sequenceType);
                    this.setLocation(expression);
                    if (this.getCurrentOperatorPrecedence() < n4) continue block4;
                    this.grumble("Left operand of '" + Token.tokens[this.t.currentToken] + "' needs parentheses");
                    continue block4;
                }
                case 46: 
                case 57: {
                    boolean bl;
                    this.nextToken();
                    this.expect(201);
                    SimpleType simpleType = this.getSimpleType(this.t.currentTokenValue);
                    if (simpleType == BuiltInAtomicType.ANY_ATOMIC) {
                        this.grumble("No value is castable to xs:anyAtomicType", "XPST0080");
                    }
                    if (simpleType == BuiltInAtomicType.NOTATION) {
                        this.grumble("No value is castable to xs:NOTATION", "XPST0080");
                    }
                    this.nextToken();
                    boolean bl2 = bl = this.t.currentToken == 213;
                    if (bl) {
                        this.nextToken();
                    }
                    expression = this.makeSingleTypeExpression(expression, n3, simpleType, bl);
                    this.setLocation(expression);
                    if (this.getCurrentOperatorPrecedence() < n4) continue block4;
                    this.grumble("Left operand of '" + Token.tokens[this.t.currentToken] + "' needs parentheses");
                    continue block4;
                }
            }
            this.nextToken();
            Expression expression2 = this.parseUnaryExpression();
            while (this.getCurrentOperatorPrecedence() > n4) {
                expression2 = this.parseBinaryExpression(expression2, this.getCurrentOperatorPrecedence());
            }
            expression = this.makeBinaryExpression(expression, n3, expression2);
            this.setLocation(expression);
        }
        return expression;
    }

    private int getCurrentOperatorPrecedence() {
        switch (this.t.currentToken) {
            case 9: {
                return 4;
            }
            case 10: {
                return 5;
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 22: 
            case 38: 
            case 39: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return 6;
            }
            case 30: {
                return 7;
            }
            case 29: {
                return 8;
            }
            case 15: 
            case 16: {
                return 9;
            }
            case 17: 
            case 18: 
            case 19: 
            case 56: {
                return 10;
            }
            case 1: {
                return 11;
            }
            case 23: 
            case 24: {
                return 12;
            }
            case 45: {
                return 13;
            }
            case 47: {
                return 14;
            }
            case 57: {
                return 15;
            }
            case 46: {
                return 16;
            }
        }
        return -1;
    }

    private Expression makeBinaryExpression(Expression expression, int n2, Expression expression2) throws XPathException {
        switch (n2) {
            case 9: {
                return new OrExpression(expression, expression2);
            }
            case 10: {
                return new AndExpression(expression, expression2);
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return new ValueComparison(expression, n2, expression2);
            }
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 22: {
                return new GeneralComparison(expression, n2, expression2);
            }
            case 20: 
            case 38: 
            case 39: {
                return new IdentityComparison(expression, n2, expression2);
            }
            case 29: {
                return new RangeExpression(expression, n2, expression2);
            }
            case 30: {
                if (!this.env.getXPathLanguageLevel().equals((Object)DecimalValue.THREE)) {
                    this.grumble("Concatenation operator ('||') requires XPath 3.0 to be enabled");
                }
                FunctionCall functionCall = SystemFunctionCall.makeSystemFunction((String)"concat", (Expression[])new Expression[]{expression, expression2});
                assert (functionCall != null);
                return functionCall;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 56: {
                return new ArithmeticExpression(expression, n2, expression2);
            }
            case 1: 
            case 23: 
            case 24: {
                return new VennExpression(expression, n2, expression2);
            }
        }
        throw new IllegalArgumentException();
    }

    private Expression makeSequenceTypeExpression(Expression expression, int n2, SequenceType sequenceType) {
        switch (n2) {
            case 45: {
                return new InstanceOfExpression(expression, sequenceType);
            }
            case 47: {
                return TreatExpression.make((Expression)expression, (SequenceType)sequenceType);
            }
        }
        throw new IllegalArgumentException();
    }

    private Expression makeSingleTypeExpression(Expression expression, int n2, SimpleType simpleType, boolean bl) throws XPathException {
        if (simpleType instanceof AtomicType) {
            switch (n2) {
                case 57: {
                    CastableExpression castableExpression = new CastableExpression(expression, (AtomicType)simpleType, bl);
                    if (expression instanceof StringLiteral) {
                        castableExpression.setOperandIsStringLiteral(true);
                    }
                    if (simpleType.isNamespaceSensitive()) {
                        castableExpression.setNamespaceResolver((NamespaceResolver)new SavedNamespaceContext(this.env.getNamespaceResolver()));
                    }
                    return castableExpression;
                }
                case 46: {
                    CastExpression castExpression = new CastExpression(expression, (AtomicType)simpleType, bl);
                    if (expression instanceof StringLiteral) {
                        castExpression.setOperandIsStringLiteral(true);
                    }
                    if (simpleType.isNamespaceSensitive()) {
                        castExpression.setNamespaceResolver((NamespaceResolver)new SavedNamespaceContext(this.env.getNamespaceResolver()));
                    }
                    return castExpression;
                }
            }
            throw new IllegalArgumentException();
        }
        switch (n2) {
            case 57: {
                if (simpleType.isUnionType()) {
                    return new CastableToUnion(expression, (UnionType)simpleType, bl);
                }
                if (!simpleType.isListType()) break;
                return this.env.getConfiguration().obtainOptimizer().makeCastableToList(expression, (SchemaType)simpleType, bl);
            }
            case 46: {
                if (simpleType.isUnionType()) {
                    return new CastToUnion(expression, (UnionType)simpleType, bl);
                }
                if (!simpleType.isListType()) break;
                return new CastToList(expression, (ListType)simpleType, bl);
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (simpleType == AnySimpleType.getInstance()) {
            throw new XPathException("Cannot cast to xs:anySimpleType", "XPST0051");
        }
        throw new XPathException("Cannot cast to " + simpleType.getDescription(), "XPST0051");
    }

    protected Expression parseTypeswitchExpression() throws XPathException {
        this.grumble("typeswitch is not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseSwitchExpression() throws XPathException {
        try {
            return this.parseFunctionCall();
        }
        catch (XPathException xPathException) {
            this.grumble("switch expression requires XQuery 3.0");
            return new ErrorExpression();
        }
    }

    protected Expression parseValidateExpression() throws XPathException {
        this.grumble("validate{} expressions are not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseExtensionExpression() throws XPathException {
        this.grumble("extension expressions (#...#) are not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseTypePattern() throws XPathException {
        this.grumble("Type patterns (~ItemType) are not allowed in XPath (only in XSLT 3.0 patterns)");
        return new ErrorExpression();
    }

    protected Expression parseTryCatchExpression() throws XPathException {
        this.grumble("try/catch expressions are not allowed in XPath");
        return new ErrorExpression();
    }

    protected Expression parseFLWORExpression() throws XPathException {
        int n2;
        if (this.t.currentToken == 216 && !this.allowXPath30Syntax) {
            this.grumble("'let' is not permitted in XPath 2.0");
        }
        if (this.t.currentToken == 74 || this.t.currentToken == 73) {
            this.grumble("sliding/tumbling windows can only be used in XQuery");
        }
        int n3 = 0;
        int n4 = this.t.currentToken;
        ForExpression forExpression = null;
        ForExpression forExpression2 = null;
        do {
            ForExpression forExpression3;
            n2 = this.t.currentTokenStartOffset;
            this.nextToken();
            this.expect(21);
            this.nextToken();
            this.expect(201);
            String string = this.t.currentTokenValue;
            if (n4 == 211) {
                forExpression3 = new ForExpression();
                forExpression3.setRequiredType(SequenceType.SINGLE_ITEM);
            } else {
                forExpression3 = new LetExpression();
                forExpression3.setRequiredType(SequenceType.ANY_SEQUENCE);
            }
            ++n3;
            this.setLocation((Expression)forExpression3, n2);
            forExpression3.setVariableQName(this.makeStructuredQName(string, ""));
            this.nextToken();
            this.expect(n4 == 216 ? 58 : 31);
            this.nextToken();
            forExpression3.setSequence(this.parseExprSingle());
            this.declareRangeVariable((Binding)forExpression3);
            if (forExpression2 == null) {
                forExpression = forExpression3;
            } else {
                forExpression2.setAction((Expression)forExpression3);
            }
            forExpression2 = forExpression3;
        } while (this.t.currentToken == 7);
        this.expect(25);
        this.nextToken();
        forExpression2.setAction(this.parseExprSingle());
        for (int i2 = 0; i2 < n3; ++i2) {
            this.undeclareRangeVariable();
        }
        return this.makeTracer(n2, (Expression)forExpression, 2012, forExpression.getVariableQName());
    }

    private Expression parseQuantifiedExpression() throws XPathException {
        int n2;
        int n3 = 0;
        int n4 = this.t.currentToken;
        QuantifiedExpression quantifiedExpression = null;
        QuantifiedExpression quantifiedExpression2 = null;
        int n5 = this.t.currentTokenStartOffset;
        do {
            n2 = this.t.currentTokenStartOffset;
            this.nextToken();
            this.expect(21);
            this.nextToken();
            this.expect(201);
            String string = this.t.currentTokenValue;
            ++n3;
            QuantifiedExpression quantifiedExpression3 = new QuantifiedExpression();
            quantifiedExpression3.setRequiredType(SequenceType.SINGLE_ITEM);
            quantifiedExpression3.setOperator(n4);
            this.setLocation((Expression)quantifiedExpression3, n2);
            quantifiedExpression3.setVariableQName(this.makeStructuredQName(string, ""));
            this.nextToken();
            if (this.t.currentToken == 71 && this.language == 3) {
                this.nextToken();
                SequenceType sequenceType = this.parseSequenceType();
                if (sequenceType.getCardinality() != 16384) {
                    this.warning("Occurrence indicator on singleton range variable has no effect");
                    sequenceType = SequenceType.makeSequenceType((ItemType)sequenceType.getPrimaryType(), (int)16384);
                }
                quantifiedExpression3.setRequiredType(sequenceType);
            }
            this.expect(31);
            this.nextToken();
            quantifiedExpression3.setSequence(this.parseExprSingle());
            this.declareRangeVariable((Binding)quantifiedExpression3);
            if (quantifiedExpression2 != null) {
                quantifiedExpression2.setAction((Expression)quantifiedExpression3);
            } else {
                quantifiedExpression = quantifiedExpression3;
            }
            quantifiedExpression2 = quantifiedExpression3;
        } while (this.t.currentToken == 7);
        this.expect(34);
        this.nextToken();
        quantifiedExpression2.setAction(this.parseExprSingle());
        for (n2 = 0; n2 < n3; ++n2) {
            this.undeclareRangeVariable();
        }
        return this.makeTracer(n5, (Expression)quantifiedExpression, 2012, quantifiedExpression.getVariableQName());
    }

    private Expression parseIfExpression() throws XPathException {
        int n2 = this.t.currentTokenStartOffset;
        this.nextToken();
        Expression expression = this.parseExpression();
        this.expect(204);
        this.nextToken();
        int n3 = this.t.currentTokenStartOffset;
        this.expect(26);
        this.nextToken();
        Expression expression2 = this.makeTracer(n3, this.parseExprSingle(), 2016, null);
        int n4 = this.t.currentTokenStartOffset;
        this.expect(27);
        this.nextToken();
        Expression expression3 = this.makeTracer(n4, this.parseExprSingle(), 2017, null);
        Expression expression4 = Choose.makeConditional((Expression)expression, (Expression)expression2, (Expression)expression3);
        this.setLocation(expression4, n2);
        return this.makeTracer(n2, expression4, 2015, null);
    }

    private ItemType getPlainType(String string) throws XPathException {
        String string2;
        String string3;
        String[] stringArray;
        if (this.scanOnly) {
            return BuiltInAtomicType.STRING;
        }
        if (string.startsWith("{")) {
            stringArray = StructuredQName.fromClarkName((String)string);
            string3 = stringArray.getURI();
            string2 = stringArray.getLocalPart();
        } else {
            try {
                stringArray = this.nameChecker.getQNameParts((CharSequence)string);
                if (stringArray[0].length() == 0) {
                    string3 = this.env.getDefaultElementNamespace();
                } else {
                    try {
                        string3 = this.env.getURIForPrefix(stringArray[0]);
                    }
                    catch (XPathException xPathException) {
                        this.grumble(xPathException.getMessage(), xPathException.getErrorCodeQName(), -1);
                        string3 = "";
                    }
                }
                string2 = stringArray[1];
            }
            catch (QNameException qNameException) {
                this.grumble(qNameException.getMessage());
                return BuiltInAtomicType.ANY_ATOMIC;
            }
        }
        boolean bl = string3.equals("http://www.w3.org/2001/XMLSchema");
        if (bl) {
            ItemType itemType = Type.getBuiltInItemType((String)string3, (String)string2);
            if (itemType == null) {
                this.grumble("Unknown atomic type " + string, "XPST0051");
            }
            if (itemType instanceof BuiltInAtomicType) {
                if (!this.env.isAllowedBuiltInType((BuiltInAtomicType)itemType)) {
                    this.grumble("The type " + string + " is not recognized by a Basic XSLT Processor. ", "XPST0080");
                }
                return itemType;
            }
            if (itemType.isPlainType()) {
                return itemType;
            }
            this.grumble("The type " + string + " is not atomic", "XPST0051");
        } else {
            SchemaType schemaType;
            if (string3.equals("http://saxon.sf.net/java-type")) {
                Class clazz;
                try {
                    String string4 = string2.replace('-', '$');
                    clazz = this.env.getConfiguration().getClass(string4, false, null);
                }
                catch (XPathException xPathException) {
                    this.grumble("Unknown Java class " + string2, "XPST0051");
                    return ExternalObjectType.EXTERNAL_OBJECT_TYPE;
                }
                return new ExternalObjectType(clazz, this.env.getConfiguration());
            }
            if (string3.equals("http://saxon.sf.net/clitype")) {
                return (AtomicType)Configuration.getPlatform().getExternalObjectType(this.env.getConfiguration(), string3, string2);
            }
            int n2 = this.env.getNamePool().getFingerprint(string3, string2);
            if (n2 == -1) {
                this.grumble("Unknown type " + string, "XPST0051");
            }
            if ((schemaType = this.env.getConfiguration().getSchemaType(n2)) == null) {
                this.grumble("Unknown atomic type " + string, "XPST0051");
            } else {
                if (schemaType.isAtomicType()) {
                    if (!this.env.isImportedSchema(string3)) {
                        this.grumble("Atomic type " + string + " exists, but its schema definition has not been imported", "XPST0051");
                    }
                    return (AtomicType)schemaType;
                }
                if (schemaType instanceof ItemType && ((ItemType)schemaType).isPlainType() && DecimalValue.THREE.equals((Object)this.env.getXPathLanguageLevel())) {
                    if (!this.env.isImportedSchema(string3)) {
                        this.grumble("Type " + string + " exists, but its schema definition has not been imported", "XPST0051");
                    }
                    return (ItemType)schemaType;
                }
                if (schemaType.isComplexType()) {
                    this.grumble("Type (" + string + ") is a complex type", "XPST0051");
                    return BuiltInAtomicType.ANY_ATOMIC;
                }
                if (((SimpleType)schemaType).isListType()) {
                    this.grumble("Type (" + string + ") is a list type", "XPST0051");
                    return BuiltInAtomicType.ANY_ATOMIC;
                }
                if (DecimalValue.THREE.equals((Object)this.env.getXPathLanguageLevel())) {
                    this.grumble("Type (" + string + ") is a union type that cannot be used as an item type", "XPST0051");
                    return BuiltInAtomicType.ANY_ATOMIC;
                }
                this.grumble("The union type (" + string + ") cannot be used as an item type unless XPath 3.0 is enabled", "XPST0051");
                return BuiltInAtomicType.ANY_ATOMIC;
            }
        }
        this.grumble("Unknown atomic type " + string, "XPST0051");
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    private SimpleType getSimpleType(String string) throws XPathException {
        SchemaType schemaType;
        String string2;
        String string3;
        String[] stringArray;
        if (this.scanOnly) {
            return BuiltInAtomicType.STRING;
        }
        if (string.startsWith("{")) {
            stringArray = StructuredQName.fromClarkName((String)string);
            string3 = stringArray.getURI();
            string2 = stringArray.getLocalPart();
        } else {
            try {
                stringArray = this.nameChecker.getQNameParts((CharSequence)string);
                if (stringArray[0].length() == 0) {
                    string3 = this.env.getDefaultElementNamespace();
                } else {
                    try {
                        string3 = this.env.getURIForPrefix(stringArray[0]);
                    }
                    catch (XPathException xPathException) {
                        this.grumble(xPathException.getMessage(), xPathException.getErrorCodeQName(), -1);
                        string3 = "";
                    }
                }
                string2 = stringArray[1];
            }
            catch (QNameException qNameException) {
                this.grumble(qNameException.getMessage());
                return BuiltInAtomicType.ANY_ATOMIC;
            }
        }
        boolean bl = string3.equals("http://www.w3.org/2001/XMLSchema");
        if (bl) {
            SimpleType simpleType = Type.getBuiltInSimpleType((String)string3, (String)string2);
            if (simpleType == null) {
                this.grumble("Unknown simple type " + string, "XPST0051");
            }
            if (simpleType instanceof BuiltInAtomicType && !this.env.isAllowedBuiltInType((BuiltInAtomicType)simpleType)) {
                this.grumble("The type " + string + " is not recognized by a Basic XSLT Processor. ", "XPST0080");
            }
            return simpleType;
        }
        if (string3.equals("http://saxon.sf.net/clitype")) {
            return (AtomicType)Configuration.getPlatform().getExternalObjectType(this.env.getConfiguration(), string3, string2);
        }
        int n2 = this.env.getNamePool().getFingerprint(string3, string2);
        if (n2 == -1) {
            this.grumble("Unknown type " + string, "XPST0051");
        }
        if ((schemaType = this.env.getConfiguration().getSchemaType(n2)) == null) {
            this.grumble("Unknown simple type " + string, "XPST0051");
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        if (DecimalValue.THREE.equals((Object)this.env.getXPathLanguageLevel())) {
            if (!this.env.isImportedSchema(string3)) {
                this.grumble("Simple type " + string + " exists, but its target namespace has not been imported in the static context");
            }
            return (SimpleType)schemaType;
        }
        if (schemaType.isAtomicType()) {
            if (!this.env.isImportedSchema(string3)) {
                this.grumble("Atomic type " + string + " exists, but its target namespace has not been imported in the static context");
            }
            return (AtomicType)schemaType;
        }
        if (schemaType.isComplexType()) {
            this.grumble("Cannot cast to a complex type (" + string + ")", "XPST0051");
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        if (((SimpleType)schemaType).isListType()) {
            this.grumble("Casting to a list type (" + string + ") requires XPath 3.0", "XPST0051");
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        this.grumble("casting to a union type (" + string + ") requires XPath 3.0", "XPST0051");
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    public SequenceType parseSequenceType() throws XPathException {
        int n2;
        boolean bl = this.t.currentTokenValue.equals("empty-sequence");
        ItemType itemType = this.parseItemType();
        if (bl) {
            return SequenceType.makeSequenceType((ItemType)itemType, (int)8192);
        }
        switch (this.t.currentToken) {
            case 17: 
            case 207: {
                n2 = 57344;
                this.t.currentToken = 204;
                this.nextToken();
                break;
            }
            case 15: {
                n2 = 49152;
                this.t.currentToken = 204;
                this.nextToken();
                break;
            }
            case 213: {
                n2 = 24576;
                this.t.currentToken = 204;
                this.nextToken();
                break;
            }
            default: {
                n2 = 16384;
            }
        }
        return SequenceType.makeSequenceType((ItemType)itemType, (int)n2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ItemType parseItemType() throws XPathException {
        if (this.t.currentToken == 5) {
            return this.parseParenthesizedItemType();
        }
        if (this.t.currentToken != 201) {
            if (this.t.currentToken == 69) {
                if (this.t.currentTokenValue.equals("item")) {
                    this.nextToken();
                    this.expect(204);
                    this.nextToken();
                    return AnyItemType.getInstance();
                }
                if (this.t.currentTokenValue.equals("function")) {
                    return this.parseFunctionItemType();
                }
                if (this.t.currentTokenValue.equals("map")) {
                    return this.parseMapItemType();
                }
                if (!this.t.currentTokenValue.equals("empty-sequence")) return this.parseKindTest();
                this.nextToken();
                this.expect(204);
                this.nextToken();
                return ErrorType.getInstance();
            }
            if (this.t.currentToken == 98) {
                Map<StructuredQName, Annotation> map = this.parseAnnotations();
                if (this.t.currentTokenValue.equals("function")) {
                    return this.parseFunctionItemType();
                }
                this.grumble("Expected 'function' to follow annotation assertions, found " + Token.tokens[this.t.currentToken]);
                return null;
            }
            this.grumble("Expected type name in SequenceType, found " + Token.tokens[this.t.currentToken]);
            return BuiltInAtomicType.ANY_ATOMIC;
        }
        ItemType itemType = this.getPlainType(this.t.currentTokenValue);
        this.nextToken();
        return itemType;
    }

    protected ItemType parseFunctionItemType() throws XPathException {
        this.grumble("The item type function() is available only when XPath 3.0 is enabled");
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    protected ItemType parseMapItemType() throws XPathException {
        this.grumble("The item type map() is available only when XPath 3.0 is enabled");
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    protected ItemType parseParenthesizedItemType() throws XPathException {
        this.grumble("A parenthesized item type is allowed only when XPath 3.0 is enabled");
        return BuiltInAtomicType.ANY_ATOMIC;
    }

    private Expression parseUnaryExpression() throws XPathException {
        Expression expression;
        switch (this.t.currentToken) {
            case 16: {
                this.nextToken();
                expression = new ArithmeticExpression((Expression)Literal.makeLiteral((GroundedValue)Int64Value.ZERO), 299, this.parseUnaryExpression());
                break;
            }
            case 15: {
                this.nextToken();
                expression = new ArithmeticExpression((Expression)Literal.makeLiteral((GroundedValue)Int64Value.ZERO), 15, this.parseUnaryExpression());
                break;
            }
            case 94: 
            case 95: 
            case 96: 
            case 97: {
                expression = this.parseValidateExpression();
                break;
            }
            case 218: {
                expression = this.parseExtensionExpression();
                break;
            }
            case 48: {
                expression = this.parseTypePattern();
                break;
            }
            case 60: {
                if (this.t.currentTokenValue.equals("validate")) {
                    expression = this.parseValidateExpression();
                    break;
                }
            }
            default: {
                expression = this.parseSimpleMappingExpression();
            }
        }
        this.setLocation(expression);
        return expression;
    }

    protected boolean atStartOfRelativePath() {
        switch (this.t.currentToken) {
            case 3: 
            case 5: 
            case 21: 
            case 35: 
            case 36: 
            case 43: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 69: 
            case 70: 
            case 201: 
            case 202: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 218: {
                return true;
            }
            case 60: {
                return this.t.currentTokenValue.equals("ordered") || this.t.currentTokenValue.equals("unordered");
            }
        }
        return false;
    }

    protected boolean disallowedAtStartOfRelativePath() {
        switch (this.t.currentToken) {
            case 45: 
            case 46: 
            case 47: 
            case 57: {
                return true;
            }
        }
        return false;
    }

    protected Expression parsePathExpression() throws XPathException {
        switch (this.t.currentToken) {
            case 2: {
                this.nextToken();
                RootExpression rootExpression = new RootExpression();
                this.setLocation((Expression)rootExpression);
                if (this.disallowedAtStartOfRelativePath()) {
                    this.grumble("Operator '" + Token.tokens[this.t.currentToken] + "' is not allowed after '/'");
                }
                if (this.atStartOfRelativePath()) {
                    Expression expression = this.parseRemainingPath((Expression)rootExpression);
                    this.setLocation(expression);
                    return expression;
                }
                return rootExpression;
            }
            case 8: {
                this.nextToken();
                RootExpression rootExpression = new RootExpression();
                this.setLocation((Expression)rootExpression);
                AxisExpression axisExpression = new AxisExpression(5, null);
                this.setLocation((Expression)axisExpression);
                Expression expression = ExpressionTool.makePathExpression((Expression)rootExpression, (Expression)axisExpression, (boolean)false);
                this.setLocation(expression);
                Expression expression2 = this.parseRemainingPath(expression);
                this.setLocation(expression2);
                return expression2;
            }
        }
        if (this.t.currentToken == 201 && (this.t.currentTokenValue.equals("true") || this.t.currentTokenValue.equals("false"))) {
            this.warning("The expression is looking for a child element named '" + this.t.currentTokenValue + "' - perhaps " + this.t.currentTokenValue + "() was intended? To avoid this warning, use child::" + this.t.currentTokenValue + " or ./" + this.t.currentTokenValue);
        }
        return this.parseRelativePath();
    }

    protected Expression parseSimpleMappingExpression() throws XPathException {
        Expression expression = this.parsePathExpression();
        while (this.t.currentToken == 40) {
            if (!this.env.getXPathLanguageLevel().equals((Object)DecimalValue.THREE)) {
                this.grumble("XPath '!' operator requires XPath 3.0 to be enabled");
            }
            this.nextToken();
            Expression expression2 = this.parsePathExpression();
            expression = new ForEach(expression, expression2);
        }
        return expression;
    }

    protected Expression parseRelativePath() throws XPathException {
        Expression expression = this.parseStepExpression(this.language == 1);
        while (this.t.currentToken == 2 || this.t.currentToken == 8) {
            int n2 = this.t.currentToken;
            this.nextToken();
            Expression expression2 = this.parseStepExpression(false);
            if (n2 == 2) {
                expression = ExpressionTool.makePathExpression((Expression)expression, (Expression)expression2, (boolean)true);
            } else if (n2 == 8) {
                AxisExpression axisExpression = new AxisExpression(5, null);
                this.setLocation((Expression)axisExpression);
                Expression expression3 = ExpressionTool.makePathExpression((Expression)expression, (Expression)axisExpression, (boolean)false);
                this.setLocation(expression3);
                expression = ExpressionTool.makePathExpression((Expression)expression3, (Expression)expression2, (boolean)true);
            }
            this.setLocation(expression);
        }
        return expression;
    }

    protected Expression parseRemainingPath(Expression expression) throws XPathException {
        Expression expression2 = expression;
        int n2 = 2;
        while (true) {
            Expression expression3 = this.parseStepExpression(false);
            if (n2 == 2) {
                expression2 = ExpressionTool.makePathExpression((Expression)expression2, (Expression)expression3, (boolean)true);
            } else if (n2 == 8) {
                AxisExpression axisExpression = new AxisExpression(5, null);
                this.setLocation((Expression)axisExpression);
                Expression expression4 = ExpressionTool.makePathExpression((Expression)axisExpression, (Expression)expression3, (boolean)false);
                this.setLocation(expression4);
                expression2 = ExpressionTool.makePathExpression((Expression)expression2, (Expression)expression4, (boolean)true);
            } else {
                if (!this.env.getXPathLanguageLevel().equals((Object)DecimalValue.THREE)) {
                    this.grumble("The '!' operator requires XPath 3.0 to be enabled");
                }
                expression2 = new ForEach(expression2, expression3);
            }
            this.setLocation(expression2);
            n2 = this.t.currentToken;
            if (n2 != 2 && n2 != 8 && n2 != 40) break;
            this.nextToken();
        }
        return expression2;
    }

    protected Expression parseStepExpression(boolean bl) throws XPathException {
        boolean bl2;
        Expression expression = this.parseBasicStep(bl);
        boolean bl3 = bl2 = expression instanceof AxisExpression && !AxisInfo.isForwards[((AxisExpression)expression).getAxis()];
        while (true) {
            if (this.t.currentToken == 4) {
                this.nextToken();
                Expression expression2 = this.parsePredicate();
                this.expect(203);
                this.nextToken();
                expression = new FilterExpression(expression, expression2);
                this.setLocation(expression);
                continue;
            }
            if (this.t.currentToken != 5) break;
            expression = this.parseDynamicFunctionCall(expression);
            this.setLocation(expression);
        }
        if (bl2) {
            expression = SystemFunctionCall.makeSystemFunction((String)"reverse", (Expression[])new Expression[]{expression});
            assert (expression != null);
            return expression;
        }
        return expression;
    }

    protected Expression parsePredicate() throws XPathException {
        return this.parseExpression();
    }

    protected Map<StructuredQName, Annotation> parseAnnotations() throws XPathException {
        this.grumble("Function and variable annotations are allowed only in XQuery 3.0");
        return null;
    }

    protected boolean isReservedInQuery(String string) {
        return NamespaceConstant.isReservedInQuery((String)string);
    }

    protected Expression parseBasicStep(boolean bl) throws XPathException {
        switch (this.t.currentToken) {
            case 21: {
                return this.parseVariableReference();
            }
            case 5: {
                this.nextToken();
                if (this.t.currentToken == 204) {
                    this.nextToken();
                    return Literal.makeEmptySequence();
                }
                Expression expression = this.parseExpression();
                this.expect(204);
                this.nextToken();
                return expression;
            }
            case 202: {
                return this.parseStringLiteral();
            }
            case 209: {
                return this.parseNumericLiteral();
            }
            case 35: {
                return this.parseFunctionCall();
            }
            case 205: {
                this.nextToken();
                ContextItemExpression contextItemExpression = new ContextItemExpression();
                this.setLocation((Expression)contextItemExpression);
                return contextItemExpression;
            }
            case 206: {
                this.nextToken();
                ParentNodeExpression parentNodeExpression = new ParentNodeExpression();
                this.setLocation((Expression)parentNodeExpression);
                return parentNodeExpression;
            }
            case 98: {
                Map<StructuredQName, Annotation> map = this.parseAnnotations();
                if (!this.t.currentTokenValue.equals("function")) {
                    this.grumble("Expected 'function' to follow the annotation assertion");
                }
                if (map.containsKey(Annotation.PRIVATE) || map.containsKey(Annotation.PUBLIC)) {
                    this.grumble("Inline functions must not be annotated %private or %public", "XQST0125");
                }
                return this.parseInlineFunction(map);
            }
            case 69: {
                if (this.t.currentTokenValue.equals("function")) {
                    if (this.languageVersion.equals((Object)DecimalValue.THREE)) {
                        return this.parseInlineFunction(null);
                    }
                    return this.parseFunctionCall();
                }
                if (this.t.currentTokenValue.equals("namespace-node") || this.t.currentTokenValue.equals("switch") ? !this.languageVersion.equals((Object)DecimalValue.THREE) : this.t.currentTokenValue.equals("map")) {
                    return this.parseFunctionCall();
                }
            }
            case 70: 
            case 201: 
            case 207: 
            case 208: {
                int n2 = 3;
                if (this.t.currentToken == 69 && (this.t.currentTokenValue.equals("attribute") || this.t.currentTokenValue.equals("schema-attribute"))) {
                    n2 = 2;
                } else if (this.t.currentToken == 69 && this.t.currentTokenValue.equals("namespace-node")) {
                    n2 = 8;
                    this.testPermittedAxis((byte)8);
                } else if (bl && this.t.currentToken == 69 && this.t.currentTokenValue.equals("document-node")) {
                    n2 = 12;
                }
                NodeTest nodeTest = this.parseNodeTest((short)1);
                if (nodeTest instanceof AnyNodeTest) {
                    nodeTest = n2 == 3 ? AnyChildNodeTest.getInstance() : NodeKindTest.ATTRIBUTE;
                }
                AxisExpression axisExpression = new AxisExpression((byte)n2, nodeTest);
                this.setLocation((Expression)axisExpression);
                return axisExpression;
            }
            case 3: {
                this.nextToken();
                switch (this.t.currentToken) {
                    case 69: 
                    case 70: 
                    case 201: 
                    case 207: 
                    case 208: {
                        AxisExpression axisExpression = new AxisExpression(2, this.parseNodeTest((short)2));
                        this.setLocation((Expression)axisExpression);
                        return axisExpression;
                    }
                }
                this.grumble("@ must be followed by a NodeTest");
                break;
            }
            case 36: {
                byte by;
                try {
                    by = AxisInfo.getAxisNumber((String)this.t.currentTokenValue);
                }
                catch (XPathException xPathException) {
                    this.grumble(xPathException.getMessage());
                    by = 3;
                }
                this.testPermittedAxis(by);
                short s2 = AxisInfo.principalNodeType[by];
                this.nextToken();
                switch (this.t.currentToken) {
                    case 69: 
                    case 70: 
                    case 201: 
                    case 207: 
                    case 208: {
                        AxisExpression axisExpression = new AxisExpression(by, this.parseNodeTest(s2));
                        this.setLocation((Expression)axisExpression);
                        return axisExpression;
                    }
                }
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " after axis name");
                break;
            }
            case 60: {
                if (this.t.currentTokenValue.equals("map")) {
                    return this.parseMapExpression();
                }
            }
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 217: {
                return this.parseConstructor();
            }
            case 43: {
                return this.parseLiteralFunctionItem();
            }
            case 48: {
                return this.parseTypePattern();
            }
            default: {
                this.grumble("Unexpected token " + this.currentTokenDisplay() + " in path expression");
            }
        }
        return new ErrorExpression();
    }

    protected void testPermittedAxis(byte by) throws XPathException {
    }

    protected Expression parseNumericLiteral() throws XPathException {
        int n2 = this.t.currentTokenStartOffset;
        NumericValue numericValue = NumericValue.parseNumber((String)this.t.currentTokenValue);
        if (numericValue.isNaN()) {
            this.grumble("Invalid numeric literal " + Err.wrap((CharSequence)this.t.currentTokenValue, (int)4));
        }
        this.nextToken();
        Literal literal = Literal.makeLiteral((GroundedValue)numericValue);
        this.setLocation((Expression)literal);
        return this.makeTracer(n2, (Expression)literal, 0, null);
    }

    protected Expression parseStringLiteral() throws XPathException {
        int n2 = this.t.currentTokenStartOffset;
        Literal literal = this.makeStringLiteral(this.t.currentTokenValue);
        this.nextToken();
        return this.makeTracer(n2, (Expression)literal, 0, null);
    }

    protected Expression parseVariableReference() throws XPathException {
        LocalVariableReference localVariableReference;
        this.nextToken();
        this.expect(201);
        String string = this.t.currentTokenValue;
        this.nextToken();
        if (this.scanOnly) {
            return new ContextItemExpression();
        }
        StructuredQName structuredQName = this.makeStructuredQName(string, "");
        Binding binding = this.findRangeVariable(structuredQName);
        if (binding != null) {
            localVariableReference = new LocalVariableReference(binding);
        } else {
            if (this.catchDepth > 0) {
                for (StructuredQName structuredQName2 : StandardNames.errorVariables) {
                    if (!structuredQName2.getLocalPart().equals(structuredQName.getLocalPart())) continue;
                    VendorFunctionLibrary vendorFunctionLibrary = this.env.getConfiguration().getVendorFunctionLibrary();
                    StructuredQName structuredQName3 = new StructuredQName("saxon", "http://saxon.sf.net/", "dynamic-error-info");
                    Expression[] expressionArray = new Expression[]{new StringLiteral((CharSequence)structuredQName.getLocalPart())};
                    return vendorFunctionLibrary.bind(structuredQName3, 1, expressionArray, this.env, null);
                }
            }
            try {
                localVariableReference = this.env.bindVariable(structuredQName);
            }
            catch (XPathException xPathException) {
                ContextItemExpression contextItemExpression = new ContextItemExpression();
                this.setLocation((Expression)contextItemExpression);
                xPathException.maybeSetLocation((SourceLocator)contextItemExpression);
                throw xPathException;
            }
        }
        this.setLocation((Expression)localVariableReference);
        return localVariableReference;
    }

    protected Literal makeStringLiteral(String string) throws XPathException {
        StringLiteral stringLiteral = new StringLiteral((CharSequence)string);
        this.setLocation((Expression)stringLiteral);
        return stringLiteral;
    }

    protected Expression parseConstructor() throws XPathException {
        this.grumble("Node constructor expressions are allowed only in XQuery, not in XPath");
        return new ErrorExpression();
    }

    protected Expression parseDynamicFunctionCall(Expression expression) throws XPathException {
        this.grumble("Unexpected '(' after primary expression. (Dynamic function calls require XPath 3.0)");
        return new ErrorExpression();
    }

    protected NodeTest parseNodeTest(short s2) throws XPathException {
        int n2 = this.t.currentToken;
        String string = this.t.currentTokenValue;
        switch (n2) {
            case 201: {
                this.nextToken();
                return this.makeNameTest(s2, string, s2 == 1);
            }
            case 208: {
                this.nextToken();
                return this.makeNamespaceTest(s2, string);
            }
            case 70: {
                this.nextToken();
                string = this.t.currentTokenValue;
                this.expect(201);
                this.nextToken();
                return this.makeLocalNameTest(s2, string);
            }
            case 207: {
                this.nextToken();
                return NodeKindTest.makeNodeKindTest((int)s2);
            }
            case 69: {
                return this.parseKindTest();
            }
        }
        this.grumble("Unrecognized node test");
        throw new XPathException("");
    }

    /*
     * Unable to fully structure code
     */
    private NodeTest parseKindTest() throws XPathException {
        var1_1 = this.t.currentTokenValue;
        var2_2 = var1_1.startsWith("schema-");
        var3_3 = this.getSystemType(var1_1);
        var4_4 = -1;
        var6_5 = false;
        this.nextToken();
        if (this.t.currentToken == 204) {
            if (var2_2) {
                this.grumble("schema-element() and schema-attribute() require a name to be supplied");
                return null;
            }
            var6_5 = true;
            this.nextToken();
        }
        switch (var3_3) {
            case 88: {
                this.grumble("item() is not allowed in a path expression");
                return null;
            }
            case 0: {
                if (var6_5) {
                    return AnyNodeTest.getInstance();
                }
                this.grumble("No arguments are allowed in node()");
                return null;
            }
            case 3: {
                if (var6_5) {
                    return NodeKindTest.TEXT;
                }
                this.grumble("No arguments are allowed in text()");
                return null;
            }
            case 8: {
                if (var6_5) {
                    return NodeKindTest.COMMENT;
                }
                this.grumble("No arguments are allowed in comment()");
                return null;
            }
            case 13: {
                if (var6_5) {
                    if (!this.isNamespaceTestAllowed()) {
                        this.grumble("namespace-node() test is not allowed in XPath 2.0/XQuery 1.0");
                    }
                    return NodeKindTest.NAMESPACE;
                }
                this.grumble("No arguments are allowed in namespace-node()");
                return null;
            }
            case 9: {
                if (var6_5) {
                    return NodeKindTest.DOCUMENT;
                }
                try {
                    var7_6 = this.getSystemType(this.t.currentTokenValue);
                }
                catch (XPathException var8_11) {
                    var7_6 = 88;
                }
                if (var7_6 != 1) {
                    this.grumble("Argument to document-node() must be an element type descriptor");
                    return null;
                }
                var8_12 = this.parseKindTest();
                this.expect(204);
                this.nextToken();
                return new DocumentNodeTest(var8_12);
            }
            case 7: {
                if (var6_5) {
                    return NodeKindTest.PROCESSING_INSTRUCTION;
                }
                if (this.t.currentToken != 202) ** GOTO lbl64
                var7_7 = Whitespace.trim((CharSequence)this.t.currentTokenValue);
                if (!this.nameChecker.isValidNCName((CharSequence)var7_7)) {
                    this.grumble("Processing instruction name must be a valid NCName", "XPTY0004");
                } else {
                    var4_4 = this.env.getNamePool().allocate("", "", var7_7);
                }
                ** GOTO lbl76
lbl64:
                // 1 sources

                if (this.t.currentToken != 201) ** GOTO lbl75
                try {
                    var7_8 = this.nameChecker.getQNameParts((CharSequence)this.t.currentTokenValue);
                    if (var7_8[0].length() != 0) ** GOTO lbl70
                    var4_4 = this.makeNameCode(var7_8[1], false);
                    ** GOTO lbl76
lbl70:
                    // 1 sources

                    this.grumble("Processing instruction name must not contain a colon");
                }
                catch (QNameException var7_9) {
                    this.grumble("Invalid processing instruction name. " + var7_9.getMessage());
                }
                ** GOTO lbl76
lbl75:
                // 1 sources

                this.grumble("Processing instruction name must be a QName or a string literal");
lbl76:
                // 6 sources

                this.nextToken();
                this.expect(204);
                this.nextToken();
                return new NameTest(7, var4_4, this.env.getNamePool());
            }
            case 1: 
            case 2: {
                var7_10 = "";
                if (var6_5) {
                    return NodeKindTest.makeNodeKindTest((int)var3_3);
                }
                if (this.t.currentToken == 207 || this.t.currentToken == 17) {
                    if (var2_2) {
                        this.grumble("schema-element() and schema-attribute() must specify an actual name, not '*'");
                        return null;
                    }
                    var4_4 = -1;
                } else if (this.t.currentToken == 201) {
                    var7_10 = this.t.currentTokenValue;
                    var4_4 = this.makeNameCode(this.t.currentTokenValue, var3_3 == 1);
                } else {
                    this.grumble("Unexpected " + Token.tokens[this.t.currentToken] + " after '(' in SequenceType");
                }
                var8_13 = null;
                if (var4_4 != -1) {
                    var8_13 = this.env.getNamePool().getURI(var4_4);
                }
                this.nextToken();
                if (this.t.currentToken == 204) {
                    this.nextToken();
                    if (var4_4 == -1) {
                        return NodeKindTest.makeNodeKindTest((int)var3_3);
                    }
                    if (var3_3 == 2) {
                        if (var2_2) {
                            var10_14 = this.env.getConfiguration().getAttributeDeclaration(var4_4 & 1048575);
                            if (!this.env.isImportedSchema(var8_13)) {
                                this.grumble("No schema has been imported for namespace '" + var8_13 + '\'', "XPST0008");
                            }
                            if (var10_14 == null) {
                                this.grumble("There is no declaration for attribute @" + var7_10 + " in an imported schema", "XPST0008");
                                return null;
                            }
                            return var10_14.makeSchemaNodeTest();
                        }
                        var9_17 = new NameTest(2, var4_4, this.env.getNamePool());
                        return var9_17;
                    }
                    if (var2_2) {
                        if (!this.env.isImportedSchema(var8_13)) {
                            this.grumble("No schema has been imported for namespace '" + var8_13 + '\'', "XPST0008");
                        }
                        if ((var10_15 = this.env.getConfiguration().getElementDeclaration(var4_4 & 1048575)) == null) {
                            this.grumble("There is no declaration for element <" + var7_10 + "> in an imported schema", "XPST0008");
                            return null;
                        }
                        return var10_15.makeSchemaNodeTest();
                    }
                    var9_18 = new NameTest(1, var4_4, this.env.getNamePool());
                    return var9_18;
                }
                if (this.t.currentToken == 7) {
                    if (var2_2) {
                        this.grumble("schema-element() and schema-attribute() must have one argument only");
                        return null;
                    }
                    this.nextToken();
                    if (this.t.currentToken == 207) {
                        this.grumble("'*' is no longer permitted as the second argument of element() and attribute()");
                        return null;
                    }
                    if (this.t.currentToken == 201) {
                        var5_20 = this.makeNameCode(this.t.currentTokenValue, true) & 1048575;
                        var11_21 = this.env.getNamePool().getURI(var5_20);
                        var12_22 = this.env.getNamePool().getLocalName(var5_20);
                        if (var11_21.equals("http://www.w3.org/2001/XMLSchema")) {
                            var10_16 = this.env.getConfiguration().getSchemaType(var5_20);
                        } else {
                            if (!this.env.isImportedSchema(var11_21)) {
                                this.grumble("No schema has been imported for namespace '" + var11_21 + '\'', "XPST0008");
                            }
                            var10_16 = this.env.getConfiguration().getSchemaType(var5_20);
                        }
                        if (var10_16 == null) {
                            this.grumble("Unknown type name " + var12_22, "XPST0008");
                            return null;
                        }
                        if (var3_3 == 2 && var10_16.isComplexType()) {
                            this.warning("An attribute cannot have a complex type");
                        }
                        var13_23 = new ContentTypeTest(var3_3, var10_16, this.env.getConfiguration(), false);
                        if (var4_4 == -1) {
                            var9_19 = var13_23;
                            if (var3_3 == 2) {
                                this.nextToken();
                            } else {
                                this.nextToken();
                                if (this.t.currentToken == 213) {
                                    var13_23.setNillable(true);
                                    this.nextToken();
                                }
                            }
                        } else if (var3_3 == 2) {
                            var14_24 = new NameTest(2, var4_4, this.env.getNamePool());
                            var9_19 = new CombinedNodeTest((NodeTest)var14_24, 23, (NodeTest)var13_23);
                            this.nextToken();
                        } else {
                            var14_25 = new NameTest(1, var4_4, this.env.getNamePool());
                            var9_19 = new CombinedNodeTest((NodeTest)var14_25, 23, (NodeTest)var13_23);
                            this.nextToken();
                            if (this.t.currentToken == 213) {
                                var13_23.setNillable(true);
                                this.nextToken();
                            }
                        }
                    } else {
                        this.grumble("Unexpected " + Token.tokens[this.t.currentToken] + " after ',' in SequenceType");
                        return null;
                    }
                    this.expect(204);
                    this.nextToken();
                    return var9_19;
                }
                this.grumble("Expected ')' or ',' in SequenceType");
                return null;
            }
        }
        this.grumble("Unknown node kind");
        return null;
    }

    protected boolean isNamespaceTestAllowed() {
        return this.allowXPath30Syntax;
    }

    private int getSystemType(String string) throws XPathException {
        if ("item".equals(string)) {
            return 88;
        }
        if ("document-node".equals(string)) {
            return 9;
        }
        if ("element".equals(string)) {
            return 1;
        }
        if ("schema-element".equals(string)) {
            return 1;
        }
        if ("attribute".equals(string)) {
            return 2;
        }
        if ("schema-attribute".equals(string)) {
            return 2;
        }
        if ("text".equals(string)) {
            return 3;
        }
        if ("comment".equals(string)) {
            return 8;
        }
        if ("processing-instruction".equals(string)) {
            return 7;
        }
        if ("namespace-node".equals(string)) {
            return 13;
        }
        if ("node".equals(string)) {
            return 0;
        }
        this.grumble("Unknown type " + string);
        return -1;
    }

    protected Expression parseMapExpression() throws XPathException {
        this.grumble("map expressions require XPath 3.0/XQuery 3.0 to be enabled");
        return new ErrorExpression();
    }

    protected Expression parseFunctionCall() throws XPathException {
        Expression expression;
        Literal literal;
        String string = this.t.currentTokenValue;
        int n2 = this.t.currentTokenStartOffset;
        ArrayList<Literal> arrayList = new ArrayList<Literal>(10);
        StructuredQName structuredQName = this.resolveFunctionName(string);
        IntArraySet intArraySet = null;
        this.nextToken();
        if (this.t.currentToken != 204) {
            while (true) {
                if ((literal = this.parseFunctionArgument()) == null) {
                    if (intArraySet == null) {
                        intArraySet = new IntArraySet();
                    }
                    intArraySet.add(arrayList.size());
                    literal = Literal.makeEmptySequence();
                }
                arrayList.add(literal);
                if (this.t.currentToken != 7) break;
                this.nextToken();
            }
            this.expect(204);
        }
        this.nextToken();
        if (this.scanOnly) {
            return new StringLiteral(StringValue.EMPTY_STRING);
        }
        literal = new Expression[arrayList.size()];
        arrayList.toArray((T[])literal);
        if (intArraySet != null) {
            return this.makeCurriedFunction(n2, structuredQName, (Expression[])literal, (IntSet)intArraySet);
        }
        try {
            expression = this.env.getFunctionLibrary().bind(structuredQName, arrayList.size(), (Expression[])literal, this.env, this.defaultContainer);
        }
        catch (XPathException xPathException) {
            if (xPathException.getErrorCodeQName() == null) {
                xPathException.setErrorCode("XPST0017");
                xPathException.setIsStaticError(true);
            }
            if (structuredQName.isInNamespace("http://www.w3.org/2011/xpath-functions/map")) {
                this.grumble("Saxon currently implements the XSLT 3.0 map functions in namespace http://www.w3.org/2005/xpath-functions/map");
            } else {
                this.grumble(xPathException.getMessage(), xPathException.getErrorCodeQName(), n2);
            }
            return new ErrorExpression();
        }
        if (expression == null) {
            return this.reportMissingFunction(n2, structuredQName, (Expression[])literal);
        }
        if (expression instanceof CastExpression && ((AtomicType)expression.getItemType(this.env.getConfiguration().getTypeHierarchy())).isNamespaceSensitive()) {
            ((CastExpression)expression).setNamespaceResolver((NamespaceResolver)new SavedNamespaceContext(this.env.getNamespaceResolver()));
        }
        if (this.language == 1) {
            if (expression instanceof RegexGroup) {
                return Literal.makeEmptySequence();
            }
            if (expression instanceof CurrentGroup) {
                this.grumble("The current-group() function cannot be used in a pattern", "XTSE1060", n2);
                return new ErrorExpression();
            }
            if (expression instanceof CurrentGroupingKey) {
                this.grumble("The current-grouping-key() function cannot be used in a pattern", "XTSE1070", n2);
                return new ErrorExpression();
            }
        }
        this.setLocation(expression, n2);
        for (Literal literal2 : literal) {
            expression.adoptChildExpression((Expression)literal2);
        }
        return this.makeTracer(n2, expression, 2009, structuredQName);
    }

    public Expression reportMissingFunction(int n2, StructuredQName structuredQName, Expression[] expressionArray) throws XPathException {
        String string = "Cannot find a matching " + expressionArray.length + "-argument function named " + structuredQName.getClarkName() + "()";
        if (this.env.getConfiguration().getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions")) {
            boolean bl = false;
            for (int i2 = 0; i2 < expressionArray.length + 5; ++i2) {
                if (i2 == expressionArray.length || !this.env.getFunctionLibrary().isAvailable(structuredQName, i2)) continue;
                bl = true;
                break;
            }
            if (bl) {
                string = string + ". The namespace URI and local name are recognized, but the number of arguments is wrong";
            } else {
                String string2 = structuredQName.getURI();
                String string3 = NamespaceConstant.findSimilarNamespace((String)string2);
                if (string3 != null) {
                    string = string3.equals(string2) ? (string3.equals("http://saxon.sf.net/") && this.env.getConfiguration().getEditionCode().equals("HE") ? string + ". Saxon extension functions are not available under Saxon-HE" : (string3.equals("http://saxon.sf.net/") && !this.env.getConfiguration().isLicensedFeature(8) ? string + ". Saxon extension functions require a Saxon-PE or Saxon-EE license" : string + ". There is no Saxon extension function with the local name " + structuredQName.getLocalPart())) : string + ". Perhaps the intended namespace was '" + string3 + "'";
                } else if (string2.contains("java")) {
                    string = this.env.getConfiguration().getEditionCode().equals("HE") ? string + ". Note that direct calls to Java methods are not available under Saxon-HE" : string + ". For diagnostics on calls to Java methods, use the -TJ command line option or set the Configuration property FeatureKeys.TRACE_EXTERNAL_FUNCTIONS";
                } else if (string2.startsWith("clitype:")) {
                    string = this.env.getConfiguration().getEditionCode().equals("HE") ? string + ". Note that direct calls to external .NET methods are not available under Saxon-HE" : string + ". For diagnostics on calls to .NET methods, use the -TJ command line option or call processor.SetProperty(\"http://saxon.sf.net/feature/trace-external-functions\", \"true\")";
                }
            }
        } else {
            string = string + ". External function calls have been disabled";
        }
        if (this.env.isInBackwardsCompatibleMode()) {
            XPathException xPathException = new XPathException(string, "XTDE1425");
            ErrorExpression errorExpression = new ErrorExpression(xPathException);
            this.setLocation((Expression)errorExpression);
            return errorExpression;
        }
        this.grumble(string, "XPST0017", n2);
        return new ErrorExpression();
    }

    protected StructuredQName resolveFunctionName(String string) throws XPathException {
        Object object;
        String string2;
        String string3;
        StructuredQName structuredQName;
        int n2 = this.t.currentTokenStartOffset;
        if (string.startsWith("{")) {
            if (!this.allowXPath30Syntax) {
                this.grumble("Expanded QName syntax requires XPath 3.0/XQuery 3.0");
            }
            structuredQName = StructuredQName.fromClarkName((String)string);
            string3 = structuredQName.getURI();
            string2 = structuredQName.getLocalPart();
        } else {
            try {
                object = this.nameChecker.getQNameParts((CharSequence)string);
            }
            catch (QNameException qNameException) {
                this.grumble("Function name is not a valid QName: " + string + "()", "XPST0003", n2);
                throw new XPathException("");
            }
            string2 = object[1];
            if (object[0].length() == 0) {
                string3 = this.env.getDefaultFunctionNamespace();
            } else {
                try {
                    string3 = this.env.getURIForPrefix((String)object[0]);
                }
                catch (XPathException xPathException) {
                    this.grumble(xPathException.getMessage(), "XPST0081", n2);
                    throw xPathException;
                }
            }
            structuredQName = new StructuredQName((String)object[0], string3, string2);
        }
        if (string3.equals("http://www.w3.org/2001/XMLSchema") && (object = Type.getBuiltInItemType((String)string3, (String)string2)) instanceof BuiltInAtomicType && !this.env.isAllowedBuiltInType((BuiltInAtomicType)object)) {
            this.grumble("The type " + string + " is not recognized by a Basic XSLT Processor. ", "XPST0080", n2);
            throw new XPathException("");
        }
        if (string2.equals("serialize") && string3.equals("http://www.w3.org/2005/xpath-functions") && this.env instanceof QueryModule) {
            object = this.allowXPath30Syntax ? "http://www.w3.org/2012/xquery" : "";
            StructuredQName structuredQName2 = this.makeStructuredQName("serialization", (String)object);
            if (((QueryModule)this.env).getFeaturesProhibited().contains(structuredQName2)) {
                this.grumble("The fn:serialize function is not allowed when the serialization feature is disabled (see line number: " + this.getTokenizer().getLineNumber() + ")", "XQST0128");
            }
        }
        return structuredQName;
    }

    public Expression parseFunctionArgument() throws XPathException {
        return this.parseExprSingle();
    }

    protected Expression parseLiteralFunctionItem() throws XPathException {
        this.grumble("Literal function items are allowed only in XPath 3.0 / XQuery 3.0");
        return new ErrorExpression();
    }

    protected Expression parseInlineFunction(Map<StructuredQName, Annotation> map) throws XPathException {
        this.grumble("Inline functions are allowed only in XQuery 3.0");
        return new ErrorExpression();
    }

    protected Expression makeCurriedFunction(int n2, StructuredQName structuredQName, Expression[] expressionArray, IntSet intSet) throws XPathException {
        this.grumble("Partial function application is allowed only in XPath/XQuery 3.0");
        return new ErrorExpression();
    }

    public Stack<Binding> getRangeVariables() {
        return this.rangeVariables;
    }

    public void setRangeVariables(Stack<Binding> stack) {
        this.rangeVariables = stack;
    }

    public void declareRangeVariable(Binding binding) throws XPathException {
        this.rangeVariables.push(binding);
    }

    public void undeclareRangeVariable() {
        this.rangeVariables.pop();
    }

    protected Binding findRangeVariable(StructuredQName structuredQName) {
        for (int i2 = this.rangeVariables.size() - 1; i2 >= 0; --i2) {
            Binding binding = (Binding)this.rangeVariables.elementAt(i2);
            if (!binding.getVariableQName().equals((Object)structuredQName)) continue;
            return binding;
        }
        return null;
    }

    public void setRangeVariableStack(Stack<Binding> stack) {
        this.rangeVariables = stack;
    }

    public final int makeNameCode(String string, boolean bl) throws XPathException {
        if (this.scanOnly) {
            return 386;
        }
        if (string.startsWith("{")) {
            return this.env.getNamePool().allocateClarkName(string);
        }
        try {
            String[] stringArray = this.nameChecker.getQNameParts((CharSequence)string);
            String string2 = stringArray[0];
            if (string2.length() == 0) {
                if (bl) {
                    String string3 = this.env.getDefaultElementNamespace();
                    return this.env.getNamePool().allocate("", string3, string);
                }
                return this.env.getNamePool().allocate("", "", string);
            }
            try {
                String string4 = this.env.getURIForPrefix(string2);
                return this.env.getNamePool().allocate(string2, string4, stringArray[1]);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage(), xPathException.getErrorCodeQName(), -1);
                return -1;
            }
        }
        catch (QNameException qNameException) {
            this.grumble(qNameException.getMessage());
            return -1;
        }
    }

    public final StructuredQName makeStructuredQNameSilently(String string, String string2) throws XPathException, QNameException {
        if (this.scanOnly) {
            return new StructuredQName("", "http://saxon.sf.net/", "dummy");
        }
        String[] stringArray = this.nameChecker.getQNameParts((CharSequence)string);
        String string3 = stringArray[0];
        if (string3.length() == 0) {
            return new StructuredQName("", string2, string);
        }
        String string4 = this.env.getURIForPrefix(string3);
        return new StructuredQName(string3, string4, stringArray[1]);
    }

    public final StructuredQName makeStructuredQName(String string, String string2) throws XPathException {
        if (this.scanOnly) {
            return new StructuredQName("", "http://saxon.sf.net/", "dummy");
        }
        if (string.startsWith("{")) {
            return StructuredQName.fromClarkName((String)string);
        }
        try {
            String[] stringArray = this.nameChecker.getQNameParts((CharSequence)string);
            String string3 = stringArray[0];
            if (string3.length() == 0) {
                return new StructuredQName("", string2, string);
            }
            try {
                String string4 = this.env.getURIForPrefix(string3);
                return new StructuredQName(string3, string4, stringArray[1]);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage(), xPathException.getErrorCodeQName(), -1);
                throw xPathException;
            }
        }
        catch (QNameException qNameException) {
            this.grumble(qNameException.getMessage());
            throw new XPathException((Throwable)qNameException);
        }
    }

    public final NodeName makeNodeName(String string, boolean bl) throws XPathException, QNameException {
        if (this.scanOnly) {
            return new NoNamespaceName("dummy");
        }
        if (string.startsWith("{")) {
            return FingerprintedQName.fromClarkName((String)string);
        }
        String[] stringArray = this.nameChecker.getQNameParts((CharSequence)string);
        String string2 = stringArray[0];
        if (string2.length() == 0) {
            if (bl) {
                String string3 = this.env.getDefaultElementNamespace();
                int n2 = this.env.getNamePool().allocate("", string3, string);
                return new FingerprintedQName("", string3, string, n2);
            }
            int n3 = this.env.getNamePool().allocate("", "", string);
            return new NoNamespaceName(string, n3);
        }
        String string4 = this.env.getURIForPrefix(string2);
        int n4 = this.env.getNamePool().allocate(string2, string4, stringArray[1]);
        return new FingerprintedQName(string2, string4, stringArray[1], n4);
    }

    public NameTest makeNameTest(short s2, String string, boolean bl) throws XPathException {
        int n2 = this.makeNameCode(string, bl);
        return new NameTest((int)s2, n2, this.env.getNamePool());
    }

    public NamespaceTest makeNamespaceTest(short s2, String string) throws XPathException {
        if (this.scanOnly) {
            return new NamespaceTest(this.env.getNamePool(), (int)s2, "http://saxon.sf.net/");
        }
        String string2 = "";
        if (string.charAt(0) == '{') {
            int n2 = string.indexOf(125);
            string2 = string.substring(1, n2);
        } else {
            try {
                string2 = this.env.getURIForPrefix(string);
            }
            catch (XPathException xPathException) {
                this.grumble(xPathException.getMessage(), "XPST0081");
            }
        }
        return new NamespaceTest(this.env.getNamePool(), (int)s2, string2);
    }

    public LocalNameTest makeLocalNameTest(short s2, String string) throws XPathException {
        if (!this.nameChecker.isValidNCName((CharSequence)string)) {
            this.grumble("Local name [" + string + "] contains invalid characters");
        }
        return new LocalNameTest(this.env.getNamePool(), (int)s2, string);
    }

    protected void setLocation(Expression expression) {
        this.setLocation(expression, this.t.currentTokenStartOffset);
    }

    public void setLocation(Expression expression, int n2) {
        if (expression != null) {
            int n3 = this.t.getLineNumber(n2);
            if (expression.getLocationId() == -1) {
                int n4 = this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), n3);
                expression.setLocationId(n4);
            }
            if (expression.getContainer() == null) {
                expression.setContainer(this.defaultContainer);
            }
        }
    }

    public void setLocation(Clause clause, int n2) {
        int n3 = this.t.getLineNumber(n2);
        int n4 = this.env.getLocationMap().allocateLocationId(this.env.getSystemId(), n3);
        clause.setLocationId(n4);
    }

    public Expression makeTracer(int n2, Expression expression, int n3, StructuredQName structuredQName) {
        if (this.codeInjector != null) {
            Expression expression2 = this.codeInjector.inject(expression, this.env, n3, structuredQName);
            if (expression2 instanceof TraceExpression) {
                long l2 = this.t.getLineAndColumn(n2);
                ((TraceExpression)expression2).setProperty("col", (int)(l2 & Integer.MAX_VALUE));
            }
            return expression2;
        }
        return expression;
    }

    protected boolean isKeyword(String string) {
        return this.t.currentToken == 201 && this.t.currentTokenValue.equals(string);
    }

    protected String normalizeEQName(String string) throws XPathException {
        if (!Whitespace.containsWhitespace((CharSequence)string)) {
            return string;
        }
        StructuredQName structuredQName = StructuredQName.fromClarkName((String)string);
        CharSequence charSequence = Whitespace.collapseWhitespace((CharSequence)structuredQName.getURI());
        return "{" + charSequence + "}" + structuredQName.getLocalPart();
    }

    public void setScanOnly(boolean bl) {
        this.scanOnly = bl;
    }

    protected static class TemporaryContainer
    implements Container,
    LocationProvider,
    Serializable {
        private LocationMap map;
        private int locationId;
        private Executable executable;

        public TemporaryContainer(LocationMap locationMap, int n2) {
            this.map = locationMap;
            this.locationId = n2;
        }

        public int getContainerGranularity() {
            return 0;
        }

        public void setExecutable(Executable executable) {
            this.executable = executable;
        }

        public Executable getExecutable() {
            return this.executable;
        }

        public LocationProvider getLocationProvider() {
            return this.map;
        }

        public String getPublicId() {
            return null;
        }

        public String getSystemId() {
            return this.map.getSystemId((long)this.locationId);
        }

        public int getLineNumber() {
            return this.map.getLineNumber((long)this.locationId);
        }

        public int getColumnNumber() {
            return -1;
        }

        public String getSystemId(long l2) {
            return this.getSystemId();
        }

        public int getLineNumber(long l2) {
            return this.getLineNumber();
        }

        public int getColumnNumber(long l2) {
            return this.getColumnNumber();
        }

        public int getHostLanguage() {
            return 54;
        }
    }
}

