/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.StackFrame;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.expr.sort.GroupIterator;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.trace.ContextStackIterator;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.Rule;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.LookaheadIterator;
import net.sf.saxon.value.DateTimeValue;

public class XPathContextMinor
implements XPathContext {
    Controller controller;
    SequenceIterator currentIterator;
    LastValue last = new LastValue(-1);
    SequenceReceiver currentReceiver;
    XPathContext caller = null;
    protected StackFrame stackFrame;
    XPathException currentException;

    protected XPathContextMinor() {
    }

    public XPathContextMajor newContext() {
        return XPathContextMajor.newContext((XPathContextMinor)this);
    }

    public XPathContextMinor newMinorContext() {
        XPathContextMinor xPathContextMinor = new XPathContextMinor();
        xPathContextMinor.controller = this.controller;
        xPathContextMinor.caller = this;
        xPathContextMinor.currentIterator = this.currentIterator;
        xPathContextMinor.currentReceiver = this.currentReceiver;
        xPathContextMinor.last = this.last;
        xPathContextMinor.stackFrame = this.stackFrame;
        xPathContextMinor.currentException = this.currentException;
        return xPathContextMinor;
    }

    public void setCaller(XPathContext xPathContext) {
        this.caller = xPathContext;
    }

    public XPathContextMajor newCleanContext() {
        XPathContextMajor xPathContextMajor = new XPathContextMajor(this.getController());
        xPathContextMajor.setCaller((XPathContext)this);
        return xPathContextMajor;
    }

    public ParameterSet getLocalParameters() {
        return this.getCaller().getLocalParameters();
    }

    public ParameterSet getTunnelParameters() {
        return this.getCaller().getTunnelParameters();
    }

    public final Controller getController() {
        return this.controller;
    }

    public final Configuration getConfiguration() {
        return this.controller.getConfiguration();
    }

    public final NamePool getNamePool() {
        return this.controller.getNamePool();
    }

    public final NameChecker getNameChecker() {
        return this.controller.getConfiguration().getNameChecker();
    }

    public final XPathContext getCaller() {
        return this.caller;
    }

    public void setCurrentIterator(SequenceIterator sequenceIterator) {
        this.currentIterator = sequenceIterator;
        this.last = new LastValue(-1);
    }

    public final SequenceIterator getCurrentIterator() {
        return this.currentIterator;
    }

    public final Item getContextItem() {
        if (this.currentIterator == null) {
            return null;
        }
        return this.currentIterator.current();
    }

    public final int getLast() throws XPathException {
        if (this.currentIterator == null) {
            XPathException xPathException = new XPathException("The context item is absent, so last() is undefined");
            xPathException.setXPathContext((XPathContext)this);
            xPathException.setErrorCode("XPDY0002");
            throw xPathException;
        }
        if (this.last.value >= 0) {
            return this.last.value;
        }
        if ((this.currentIterator.getProperties() & 2) == 0) {
            SequenceIterator sequenceIterator = this.currentIterator.getAnother();
            int n2 = 0;
            while (sequenceIterator.next() != null) {
                ++n2;
            }
            this.last.value = n2;
            return this.last.value;
        }
        this.last.value = ((LastPositionFinder)this.currentIterator).getLength();
        return this.last.value;
    }

    public final boolean isAtLast() throws XPathException {
        if ((this.currentIterator.getProperties() & 4) != 0) {
            return !((LookaheadIterator)this.currentIterator).hasNext();
        }
        return this.currentIterator.position() == this.getLast();
    }

    public final StringCollator getCollation(String string) throws XPathException {
        Object object;
        if (string.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            return CodepointCollator.getInstance();
        }
        StringCollator stringCollator = null;
        if (this.controller != null && (stringCollator = this.controller.getExecutable().getNamedCollation(string)) == null) {
            object = this.controller.getConfiguration();
            stringCollator = object.getCollationURIResolver().resolve(string, null, object);
        }
        if (stringCollator == null) {
            object = new XPathException("Unknown collation " + string);
            object.setErrorCode("FOCH0002");
            object.setXPathContext(this);
            throw object;
        }
        return stringCollator;
    }

    public StackFrame getStackFrame() {
        return this.stackFrame;
    }

    public final Sequence evaluateLocalVariable(int n2) {
        return this.stackFrame.slots[n2];
    }

    public final void setLocalVariable(int n2, Sequence sequence) {
        try {
            this.stackFrame.slots[n2] = sequence;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new AssertionError((Object)("Internal error: invalid slot number for local variable " + (n2 == -999 ? "(No slot allocated)" : "(" + n2 + ")")));
        }
    }

    public synchronized void notifyChildThreads() throws XPathException {
        this.getCaller().notifyChildThreads();
    }

    public void changeOutputDestination(Receiver receiver, ParseOptions parseOptions) throws XPathException {
        PipelineConfiguration pipelineConfiguration = receiver.getPipelineConfiguration();
        ComplexContentOutputter complexContentOutputter = new ComplexContentOutputter(pipelineConfiguration);
        complexContentOutputter.setHostLanguage(pipelineConfiguration.getHostLanguage());
        NamespaceReducer namespaceReducer = new NamespaceReducer(receiver);
        namespaceReducer.setSystemId(receiver.getSystemId());
        receiver = namespaceReducer;
        if (parseOptions != null && parseOptions.getSchemaValidationMode() != 3) {
            Configuration configuration = this.controller.getConfiguration();
            receiver = configuration.getDocumentValidator((Receiver)namespaceReducer, receiver.getSystemId(), parseOptions);
        }
        complexContentOutputter.setReceiver(receiver);
        this.currentReceiver = complexContentOutputter;
    }

    public void setReceiver(SequenceReceiver sequenceReceiver) {
        this.currentReceiver = sequenceReceiver;
    }

    public final SequenceReceiver getReceiver() {
        return this.currentReceiver;
    }

    public boolean isTemporaryOutputState() {
        return this.caller.isTemporaryOutputState();
    }

    public int useLocalParameter(int n2, int n3, boolean bl) throws XPathException {
        return this.getCaller().useLocalParameter(n2, n3, bl);
    }

    public Mode getCurrentMode() {
        return this.getCaller().getCurrentMode();
    }

    public Rule getCurrentTemplateRule() {
        return null;
    }

    public GroupIterator getCurrentGroupIterator() {
        return this.getCaller().getCurrentGroupIterator();
    }

    public RegexIterator getCurrentRegexIterator() {
        return this.getCaller().getCurrentRegexIterator();
    }

    public DateTimeValue getCurrentDateTime() {
        return this.controller.getCurrentDateTime();
    }

    public final int getImplicitTimezone() {
        return this.controller.getImplicitTimezone();
    }

    public Iterator iterateStackFrames() {
        return new ContextStackIterator((XPathContext)this);
    }

    public void setCurrentException(XPathException xPathException) {
        this.currentException = xPathException;
    }

    public XPathException getCurrentException() {
        return this.currentException;
    }

    protected static class LastValue {
        public int value = 0;

        public LastValue(int n2) {
            this.value = n2;
        }
    }
}

