/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.EmptyPattern;
import com.thaiopensource.relaxng.pattern.ErrorPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NameClassVisitor;
import com.thaiopensource.relaxng.pattern.NotAllowedPattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RefPattern;
import com.thaiopensource.relaxng.pattern.TextPattern;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import ro.sync.xml.ProxyNamespaceMapping;

public class OxygenModelExtractorVisitor
implements PatternFunction<VoidValue>,
NameClassVisitor {
    private static int TYPE_NONE = 0;
    private static int TYPE_GROUP = 1;
    private static int TYPE_CHOICE = 2;
    private static int TYPE_INTERLEAVE = 4;
    private static int TYPE_NC_CHOICE = 8;
    private StringBuffer model = new StringBuffer();
    private int type = TYPE_NONE;
    private ProxyNamespaceMapping pnm;
    private boolean elementAllowed;
    private boolean textAllowed;

    public OxygenModelExtractorVisitor(ProxyNamespaceMapping proxyNamespaceMapping) {
        this.pnm = proxyNamespaceMapping;
    }

    public String getModel() {
        return this.model.toString();
    }

    public VoidValue caseEmpty(EmptyPattern emptyPattern) {
        this.model.append("EMPTY");
        return VoidValue.VOID;
    }

    public VoidValue caseNotAllowed(NotAllowedPattern notAllowedPattern) {
        this.model.append("Not allowed");
        return VoidValue.VOID;
    }

    public VoidValue caseError(ErrorPattern errorPattern) {
        this.model.append("Error");
        return VoidValue.VOID;
    }

    public VoidValue caseGroup(GroupPattern groupPattern) {
        if (groupPattern.getOperand1().getContentType() == 0 && groupPattern.getOperand2().getContentType() == 0) {
            if (this.model.length() == 0) {
                this.model.append("EMPTY");
            }
            return VoidValue.VOID;
        }
        if (groupPattern.getOperand1().getContentType() == 0) {
            groupPattern.getOperand2().apply((PatternFunction)this);
            return VoidValue.VOID;
        }
        if (groupPattern.getOperand2().getContentType() == 0) {
            groupPattern.getOperand1().apply((PatternFunction)this);
            return VoidValue.VOID;
        }
        return this.caseBinOp(groupPattern.getOperand1(), groupPattern.getOperand2(), ", ", TYPE_GROUP);
    }

    public VoidValue caseInterleave(InterleavePattern interleavePattern) {
        if (interleavePattern.getOperand1().getContentType() == 0 && interleavePattern.getOperand2().getContentType() == 0) {
            if (this.model.length() == 0) {
                this.model.append("EMPTY");
            }
            return VoidValue.VOID;
        }
        if (interleavePattern.getOperand1().getContentType() == 0) {
            interleavePattern.getOperand2().apply((PatternFunction)this);
            return VoidValue.VOID;
        }
        if (interleavePattern.getOperand2().getContentType() == 0) {
            interleavePattern.getOperand1().apply((PatternFunction)this);
            return VoidValue.VOID;
        }
        return this.caseBinOp(interleavePattern.getOperand1(), interleavePattern.getOperand2(), " ^ ", TYPE_INTERLEAVE);
    }

    public VoidValue caseChoice(ChoicePattern choicePattern) {
        if (choicePattern.getOperand1().getContentType() == 0 && choicePattern.getOperand2().getContentType() == 0) {
            if (this.model.length() == 0) {
                this.model.append("EMPTY");
            }
            return VoidValue.VOID;
        }
        return this.caseBinOp(choicePattern.getOperand1(), choicePattern.getOperand2(), " | ", TYPE_CHOICE);
    }

    private VoidValue caseBinOp(Pattern pattern, Pattern pattern2, String string, int n2) {
        int n3 = this.type;
        if (n2 != n3) {
            this.model.append("(");
            this.type = n2;
        }
        pattern.apply((PatternFunction)this);
        StringBuffer stringBuffer = this.model;
        this.model = new StringBuffer();
        pattern2.apply((PatternFunction)this);
        if (!"".equals(this.model.toString().replaceAll("\\)", ""))) {
            stringBuffer.append(string);
        }
        stringBuffer.append(this.model);
        this.model = stringBuffer;
        if (n2 != n3) {
            this.model.append(")");
        }
        this.type = n3;
        return VoidValue.VOID;
    }

    public VoidValue caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
        this.model.append("(");
        oneOrMorePattern.getOperand().apply((PatternFunction)this);
        this.model.append(")+");
        return VoidValue.VOID;
    }

    public VoidValue caseElement(ElementPattern elementPattern) {
        elementPattern.getNameClass().accept((NameClassVisitor)this);
        this.elementAllowed = true;
        return VoidValue.VOID;
    }

    public VoidValue caseAttribute(AttributePattern attributePattern) {
        this.model.append("@");
        attributePattern.getNameClass().accept((NameClassVisitor)this);
        return VoidValue.VOID;
    }

    public VoidValue caseData(DataPattern dataPattern) {
        this.model.append("data");
        this.textAllowed = true;
        return VoidValue.VOID;
    }

    public VoidValue caseDataExcept(DataExceptPattern dataExceptPattern) {
        this.model.append("data");
        this.textAllowed = true;
        return VoidValue.VOID;
    }

    public VoidValue caseValue(ValuePattern valuePattern) {
        this.model.append("'" + valuePattern.getValue().toString() + "'");
        this.textAllowed = true;
        return VoidValue.VOID;
    }

    public VoidValue caseText(TextPattern textPattern) {
        this.model.append("#text");
        this.textAllowed = true;
        return VoidValue.VOID;
    }

    public VoidValue caseList(ListPattern listPattern) {
        this.model.append("list[");
        listPattern.getOperand().apply((PatternFunction)this);
        this.model.append("]");
        return VoidValue.VOID;
    }

    public VoidValue caseRef(RefPattern refPattern) {
        refPattern.getPattern().apply((PatternFunction)this);
        return VoidValue.VOID;
    }

    public VoidValue caseAfter(AfterPattern afterPattern) {
        afterPattern.getOperand1().apply((PatternFunction)this);
        return VoidValue.VOID;
    }

    public void visitChoice(NameClass nameClass, NameClass nameClass2) {
        int n2 = this.type;
        if (TYPE_NC_CHOICE != n2) {
            this.model.append("(");
            this.type = TYPE_NC_CHOICE;
        }
        nameClass.accept((NameClassVisitor)this);
        this.model.append(" | ");
        nameClass2.accept((NameClassVisitor)this);
        if (TYPE_NC_CHOICE != n2) {
            this.model.append(")");
        }
        this.type = n2;
    }

    public void visitNsName(String string) {
        this.model.append("[ns:" + string + "]");
    }

    public void visitNsNameExcept(String string, NameClass nameClass) {
        this.model.append("[ns:" + string + " \\");
        nameClass.accept((NameClassVisitor)this);
        this.model.append("]");
    }

    public void visitAnyName() {
        this.model.append("[anyName]");
    }

    public void visitAnyNameExcept(NameClass nameClass) {
        this.model.append("[anyName \\");
        nameClass.accept((NameClassVisitor)this);
        this.model.append("]");
    }

    public void visitName(Name name) {
        String string = this.pnm.getPrefixForNamespace(name.getNamespaceUri());
        if (string == null) {
            this.model.append(name.getLocalName() + "#" + name.getNamespaceUri());
        } else {
            if (!"".equals(string)) {
                this.model.append(string + ":");
            }
            this.model.append(name.getLocalName());
        }
    }

    public void visitNull() {
        this.model.append("[null]");
    }

    public boolean isElementAllowed() {
        return this.elementAllowed;
    }

    public boolean isTextAllowed() {
        return this.textAllowed;
    }

    public void visitError() {
    }
}

