/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.EmptyPattern;
import com.thaiopensource.relaxng.pattern.ErrorPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NameClassVisitor;
import com.thaiopensource.relaxng.pattern.NotAllowedPattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RefPattern;
import com.thaiopensource.relaxng.pattern.TextPattern;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ro.sync.xml.parser.ParserCreator;

public class OxygenLogicalPatternModel {
    private final Vector patternList = new Vector();
    private final Hashtable patternTable = new Hashtable();
    private final PatternFunction<VoidValue> patternVisitor = new DumpPatternVisitor();
    private final PatternFunction<VoidValue> groupPatternVisitor = new GroupDumpPatternVisitor();
    private final PatternFunction<VoidValue> choicePatternVisitor = new ChoiceDumpPatternVisitor();
    private final PatternFunction<VoidValue> interleavePatternVisitor = new InterleaveDumpPatternVisitor();
    private final NameClassVisitor nameClassVisitor = new DumpNameClassVisitor();
    private final NameClassVisitor choiceNameClassVisitor = new ChoiceDumpNameClassVisitor();
    private Document doc = ParserCreator.newDocumentBuilder().newDocument();
    private Element currentElement;
    private String currentNameclass;

    public static Document getLogicalModel(Pattern pattern) throws ParserConfigurationException {
        return new OxygenLogicalPatternModel().dump(pattern);
    }

    private OxygenLogicalPatternModel() throws ParserConfigurationException {
    }

    private Document dump(Pattern pattern) {
        this.startElement("grammar");
        this.attribute("xmlns", "http://relaxng.org/ns/structure/1.0");
        this.startElement("start");
        pattern.apply(this.groupPatternVisitor);
        this.endElement();
        for (int i2 = 0; i2 < this.patternList.size(); ++i2) {
            this.startElement("define");
            Pattern pattern2 = (Pattern)this.patternList.elementAt(i2);
            this.attribute("name", this.getName(pattern2));
            pattern2.apply(this.groupPatternVisitor);
            this.endElement();
        }
        this.endElement();
        return this.doc;
    }

    private String getName(Pattern pattern, String string) {
        String string2 = (String)this.patternTable.get(pattern);
        if (string2 == null) {
            string2 = string;
            int n2 = 0;
            while (this.patternTable.containsValue(string2)) {
                string2 = string + n2++;
            }
            this.patternList.addElement(pattern);
            this.patternTable.put(pattern, string2);
        }
        return string2;
    }

    private String getName(Pattern pattern) {
        String string = (String)this.patternTable.get(pattern);
        if (string == null) {
            string = "p" + this.patternList.size();
            this.patternList.addElement(pattern);
            this.patternTable.put(pattern, string);
        }
        return string;
    }

    private void startElement(String string) {
        Element element = this.doc.createElement(string);
        if (this.currentElement == null) {
            this.doc.appendChild(element);
        } else {
            this.currentElement.appendChild(element);
        }
        this.currentElement = element;
    }

    private void attribute(String string, String string2) {
        this.currentElement.setAttribute(string, string2);
    }

    private void data(String string) {
        if (string.length() > 0) {
            this.currentElement.appendChild(this.doc.createTextNode(string));
        }
    }

    private void endElement() {
        Node node = this.currentElement.getParentNode();
        if (node.getNodeType() == 1) {
            this.currentElement = (Element)node;
        }
    }

    class ChoiceDumpNameClassVisitor
    extends DumpNameClassVisitor {
        ChoiceDumpNameClassVisitor() {
        }

        @Override
        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            nameClass.accept((NameClassVisitor)this);
            OxygenLogicalPatternModel.this.currentNameclass = OxygenLogicalPatternModel.this.currentNameclass + "_or_";
            nameClass2.accept((NameClassVisitor)this);
        }
    }

    class DumpNameClassVisitor
    implements NameClassVisitor {
        DumpNameClassVisitor() {
        }

        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            OxygenLogicalPatternModel.this.startElement("choice");
            nameClass.accept(OxygenLogicalPatternModel.this.choiceNameClassVisitor);
            OxygenLogicalPatternModel.this.currentNameclass = OxygenLogicalPatternModel.this.currentNameclass + "_or_";
            nameClass2.accept(OxygenLogicalPatternModel.this.choiceNameClassVisitor);
            OxygenLogicalPatternModel.this.endElement();
        }

        public void visitNsName(String string) {
            OxygenLogicalPatternModel.this.startElement("nsName");
            OxygenLogicalPatternModel.this.attribute("ns", string);
            OxygenLogicalPatternModel.this.endElement();
            OxygenLogicalPatternModel.this.currentNameclass = OxygenLogicalPatternModel.this.currentNameclass + ("_ns_" + string + "_");
        }

        public void visitNsNameExcept(String string, NameClass nameClass) {
            OxygenLogicalPatternModel.this.startElement("nsName");
            OxygenLogicalPatternModel.this.attribute("ns", string);
            OxygenLogicalPatternModel.this.startElement("except");
            OxygenLogicalPatternModel.this.currentNameclass = OxygenLogicalPatternModel.this.currentNameclass + ("_ns_" + string + "_except_");
            nameClass.accept(OxygenLogicalPatternModel.this.choiceNameClassVisitor);
            OxygenLogicalPatternModel.this.endElement();
            OxygenLogicalPatternModel.this.endElement();
        }

        public void visitAnyName() {
            OxygenLogicalPatternModel.this.startElement("anyName");
            OxygenLogicalPatternModel.this.endElement();
            OxygenLogicalPatternModel.this.currentNameclass = OxygenLogicalPatternModel.this.currentNameclass + "_anyName";
        }

        public void visitAnyNameExcept(NameClass nameClass) {
            OxygenLogicalPatternModel.this.startElement("anyName");
            OxygenLogicalPatternModel.this.startElement("except");
            OxygenLogicalPatternModel.this.currentNameclass = OxygenLogicalPatternModel.this.currentNameclass + "_anyName_except_";
            nameClass.accept(OxygenLogicalPatternModel.this.choiceNameClassVisitor);
            OxygenLogicalPatternModel.this.endElement();
            OxygenLogicalPatternModel.this.endElement();
        }

        public void visitName(Name name) {
            String string = OxygenLogicalPatternModel.this.currentElement.getNodeName();
            if ("attribute".equals(string) || "element".equals(string)) {
                OxygenLogicalPatternModel.this.currentElement.setAttribute("name", name.getLocalName());
                OxygenLogicalPatternModel.this.currentElement.setAttribute("ns", name.getNamespaceUri());
            } else {
                OxygenLogicalPatternModel.this.startElement("name");
                OxygenLogicalPatternModel.this.attribute("ns", name.getNamespaceUri());
                OxygenLogicalPatternModel.this.data(name.getLocalName());
                OxygenLogicalPatternModel.this.endElement();
            }
            OxygenLogicalPatternModel.this.currentNameclass = OxygenLogicalPatternModel.this.currentNameclass + name.getLocalName();
        }

        public void visitError() {
            OxygenLogicalPatternModel.this.startElement("error");
            OxygenLogicalPatternModel.this.endElement();
            OxygenLogicalPatternModel.this.currentNameclass = OxygenLogicalPatternModel.this.currentNameclass + "_error";
        }

        public void visitNull() {
            this.visitAnyName();
            OxygenLogicalPatternModel.this.currentNameclass = OxygenLogicalPatternModel.this.currentNameclass + "_null";
        }
    }

    class InterleaveDumpPatternVisitor
    extends DumpPatternVisitor {
        InterleaveDumpPatternVisitor() {
        }

        @Override
        public VoidValue caseInterleave(InterleavePattern interleavePattern) {
            interleavePattern.getOperand1().apply((PatternFunction)this);
            interleavePattern.getOperand2().apply((PatternFunction)this);
            return VoidValue.VOID;
        }
    }

    class ChoiceDumpPatternVisitor
    extends DumpPatternVisitor {
        ChoiceDumpPatternVisitor() {
        }

        @Override
        public VoidValue caseChoice(ChoicePattern choicePattern) {
            choicePattern.getOperand1().apply((PatternFunction)this);
            choicePattern.getOperand2().apply((PatternFunction)this);
            return VoidValue.VOID;
        }
    }

    class GroupDumpPatternVisitor
    extends DumpPatternVisitor {
        GroupDumpPatternVisitor() {
        }

        @Override
        public VoidValue caseGroup(GroupPattern groupPattern) {
            groupPattern.getOperand1().apply((PatternFunction)this);
            groupPattern.getOperand2().apply((PatternFunction)this);
            return VoidValue.VOID;
        }
    }

    class DumpPatternVisitor
    implements PatternFunction<VoidValue> {
        DumpPatternVisitor() {
        }

        public VoidValue caseEmpty(EmptyPattern emptyPattern) {
            OxygenLogicalPatternModel.this.startElement("empty");
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseNotAllowed(NotAllowedPattern notAllowedPattern) {
            OxygenLogicalPatternModel.this.startElement("notAllowed");
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseError(ErrorPattern errorPattern) {
            OxygenLogicalPatternModel.this.startElement("error");
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseGroup(GroupPattern groupPattern) {
            OxygenLogicalPatternModel.this.startElement("group");
            groupPattern.getOperand1().apply(OxygenLogicalPatternModel.this.groupPatternVisitor);
            groupPattern.getOperand2().apply(OxygenLogicalPatternModel.this.groupPatternVisitor);
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseInterleave(InterleavePattern interleavePattern) {
            OxygenLogicalPatternModel.this.startElement("interleave");
            interleavePattern.getOperand1().apply(OxygenLogicalPatternModel.this.interleavePatternVisitor);
            interleavePattern.getOperand2().apply(OxygenLogicalPatternModel.this.interleavePatternVisitor);
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseChoice(ChoicePattern choicePattern) {
            OxygenLogicalPatternModel.this.startElement("choice");
            choicePattern.getOperand1().apply(OxygenLogicalPatternModel.this.choicePatternVisitor);
            choicePattern.getOperand2().apply(OxygenLogicalPatternModel.this.choicePatternVisitor);
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            OxygenLogicalPatternModel.this.startElement("oneOrMore");
            oneOrMorePattern.getOperand().apply(OxygenLogicalPatternModel.this.groupPatternVisitor);
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseElement(ElementPattern elementPattern) {
            OxygenLogicalPatternModel.this.startElement("element");
            OxygenLogicalPatternModel.this.currentNameclass = "";
            elementPattern.getNameClass().accept(OxygenLogicalPatternModel.this.nameClassVisitor);
            OxygenLogicalPatternModel.this.startElement("ref");
            OxygenLogicalPatternModel.this.attribute("name", OxygenLogicalPatternModel.this.getName(elementPattern.getContent(), OxygenLogicalPatternModel.this.currentNameclass + ".content"));
            OxygenLogicalPatternModel.this.endElement();
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseAttribute(AttributePattern attributePattern) {
            OxygenLogicalPatternModel.this.startElement("attribute");
            attributePattern.getNameClass().accept(OxygenLogicalPatternModel.this.nameClassVisitor);
            attributePattern.getContent().apply(OxygenLogicalPatternModel.this.patternVisitor);
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseData(DataPattern dataPattern) {
            OxygenLogicalPatternModel.this.startElement("text");
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseDataExcept(DataExceptPattern dataExceptPattern) {
            OxygenLogicalPatternModel.this.startElement("text");
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseValue(ValuePattern valuePattern) {
            OxygenLogicalPatternModel.this.startElement("value");
            OxygenLogicalPatternModel.this.data(valuePattern.getValue().toString());
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseText(TextPattern textPattern) {
            OxygenLogicalPatternModel.this.startElement("text");
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseList(ListPattern listPattern) {
            OxygenLogicalPatternModel.this.startElement("list");
            listPattern.getOperand().apply(OxygenLogicalPatternModel.this.groupPatternVisitor);
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseAfter(AfterPattern afterPattern) {
            OxygenLogicalPatternModel.this.startElement("after");
            afterPattern.getOperand1().apply(OxygenLogicalPatternModel.this.groupPatternVisitor);
            afterPattern.getOperand2().apply(OxygenLogicalPatternModel.this.groupPatternVisitor);
            OxygenLogicalPatternModel.this.endElement();
            return VoidValue.VOID;
        }

        public VoidValue caseRef(RefPattern refPattern) {
            refPattern.getPattern().apply(OxygenLogicalPatternModel.this.groupPatternVisitor);
            return VoidValue.VOID;
        }
    }
}

