/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.AfterPattern;
import com.thaiopensource.relaxng.pattern.AttributePattern;
import com.thaiopensource.relaxng.pattern.ChoicePattern;
import com.thaiopensource.relaxng.pattern.DataExceptPattern;
import com.thaiopensource.relaxng.pattern.DataPattern;
import com.thaiopensource.relaxng.pattern.ElementPattern;
import com.thaiopensource.relaxng.pattern.EmptyPattern;
import com.thaiopensource.relaxng.pattern.ErrorPattern;
import com.thaiopensource.relaxng.pattern.GroupPattern;
import com.thaiopensource.relaxng.pattern.InterleavePattern;
import com.thaiopensource.relaxng.pattern.ListPattern;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.NameClassVisitor;
import com.thaiopensource.relaxng.pattern.NotAllowedPattern;
import com.thaiopensource.relaxng.pattern.OneOrMorePattern;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RefPattern;
import com.thaiopensource.relaxng.pattern.TextPattern;
import com.thaiopensource.relaxng.pattern.ValuePattern;
import com.thaiopensource.util.VoidValue;
import com.thaiopensource.xml.util.Name;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class DefaultValuesExtractor {
    private DefaultValuesListener listener;
    private final List<Pattern> patternList = new ArrayList<Pattern>();
    private final HashSet<Pattern> patternSet = new HashSet();
    private ElementContentVisitor ecv = new ElementContentVisitor();
    private ElementsVisitor ev = new ElementsVisitor();

    public DefaultValuesExtractor(DefaultValuesListener defaultValuesListener) {
        this.listener = defaultValuesListener;
    }

    public void parsePattern(Pattern pattern) {
        pattern.apply((PatternFunction)this.ecv);
        for (int i2 = 0; i2 < this.patternList.size(); ++i2) {
            Pattern pattern2 = this.patternList.get(i2);
            pattern2.apply((PatternFunction)this.ev);
        }
    }

    private void addPattern(Pattern pattern) {
        if (!this.patternSet.contains(pattern)) {
            this.patternList.add(pattern);
            this.patternSet.add(pattern);
        }
    }

    class AttributesVisitor
    extends BaseVisitor {
        private String defaultValue;
        private List<Name> elements;

        public AttributesVisitor(List<Name> list) {
            this.elements = list;
        }

        @Override
        public VoidValue caseAttribute(AttributePattern attributePattern) {
            this.defaultValue = attributePattern.getDefaultValue();
            if (this.defaultValue != null) {
                attributePattern.getNameClass().accept((NameClassVisitor)this);
            }
            return VoidValue.VOID;
        }

        @Override
        public void visitName(Name name) {
            for (Name name2 : this.elements) {
                DefaultValuesExtractor.this.listener.defaultValue(name2.getLocalName(), name2.getNamespaceUri(), name.getLocalName(), name.getNamespaceUri(), this.defaultValue);
            }
        }
    }

    class ElementsVisitor
    extends BaseVisitor {
        private List<Name> elements;

        ElementsVisitor() {
            this.elements = new ArrayList<Name>();
        }

        @Override
        public VoidValue caseElement(ElementPattern elementPattern) {
            this.elements.clear();
            elementPattern.getNameClass().accept((NameClassVisitor)this);
            if (this.elements.size() > 0) {
                elementPattern.getContent().apply((PatternFunction)new AttributesVisitor(this.elements));
            }
            elementPattern.getContent().apply((PatternFunction)DefaultValuesExtractor.this.ecv);
            return VoidValue.VOID;
        }

        @Override
        public void visitName(Name name) {
            this.elements.add(name);
        }
    }

    class ElementContentVisitor
    extends BaseVisitor {
        ElementContentVisitor() {
        }

        @Override
        public VoidValue caseElement(ElementPattern elementPattern) {
            DefaultValuesExtractor.this.addPattern((Pattern)elementPattern);
            return VoidValue.VOID;
        }
    }

    class BaseVisitor
    implements PatternFunction<VoidValue>,
    NameClassVisitor {
        BaseVisitor() {
        }

        public VoidValue caseElement(ElementPattern elementPattern) {
            return VoidValue.VOID;
        }

        public VoidValue caseAttribute(AttributePattern attributePattern) {
            return VoidValue.VOID;
        }

        public VoidValue caseError(ErrorPattern errorPattern) {
            return VoidValue.VOID;
        }

        public VoidValue caseEmpty(EmptyPattern emptyPattern) {
            return VoidValue.VOID;
        }

        public VoidValue caseNotAllowed(NotAllowedPattern notAllowedPattern) {
            return VoidValue.VOID;
        }

        public VoidValue caseGroup(GroupPattern groupPattern) {
            groupPattern.getOperand1().apply((PatternFunction)this);
            groupPattern.getOperand2().apply((PatternFunction)this);
            return VoidValue.VOID;
        }

        public VoidValue caseInterleave(InterleavePattern interleavePattern) {
            interleavePattern.getOperand1().apply((PatternFunction)this);
            interleavePattern.getOperand2().apply((PatternFunction)this);
            return VoidValue.VOID;
        }

        public VoidValue caseChoice(ChoicePattern choicePattern) {
            choicePattern.getOperand1().apply((PatternFunction)this);
            choicePattern.getOperand2().apply((PatternFunction)this);
            return VoidValue.VOID;
        }

        public VoidValue caseOneOrMore(OneOrMorePattern oneOrMorePattern) {
            oneOrMorePattern.getOperand().apply((PatternFunction)this);
            return VoidValue.VOID;
        }

        public VoidValue caseData(DataPattern dataPattern) {
            return VoidValue.VOID;
        }

        public VoidValue caseDataExcept(DataExceptPattern dataExceptPattern) {
            return VoidValue.VOID;
        }

        public VoidValue caseValue(ValuePattern valuePattern) {
            return VoidValue.VOID;
        }

        public VoidValue caseText(TextPattern textPattern) {
            return VoidValue.VOID;
        }

        public VoidValue caseList(ListPattern listPattern) {
            return VoidValue.VOID;
        }

        public VoidValue caseRef(RefPattern refPattern) {
            refPattern.getPattern().apply((PatternFunction)this);
            return VoidValue.VOID;
        }

        public VoidValue caseAfter(AfterPattern afterPattern) {
            return VoidValue.VOID;
        }

        public void visitName(Name name) {
        }

        public void visitChoice(NameClass nameClass, NameClass nameClass2) {
            nameClass.accept((NameClassVisitor)this);
            nameClass2.accept((NameClassVisitor)this);
        }

        public void visitNsName(String string) {
        }

        public void visitNsNameExcept(String string, NameClass nameClass) {
        }

        public void visitAnyName() {
        }

        public void visitAnyNameExcept(NameClass nameClass) {
        }

        public void visitNull() {
        }

        public void visitError() {
        }
    }

    public static interface DefaultValuesListener {
        public void defaultValue(String var1, String var2, String var3, String var4, String var5);
    }
}

