/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.CallbackThreadInitializer;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.Function;
import com.sun.jna.IntegerType;
import com.sun.jna.LastErrorException;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.Version;
import com.sun.jna.WString;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import ro.sync.util.Resource;

public final class Native
implements Version {
    public static final String DEFAULT_ENCODING = "utf8";
    static final boolean DEBUG_LOAD;
    static final boolean DEBUG_JNA_LOAD;
    static String jnidispatchPath;
    private static Map options;
    private static Map libraries;
    private static final Callback.UncaughtExceptionHandler DEFAULT_HANDLER;
    private static Callback.UncaughtExceptionHandler callbackExceptionHandler;
    public static final int POINTER_SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;
    public static final int SIZE_T_SIZE;
    private static final int TYPE_VOIDP = 0;
    private static final int TYPE_LONG = 1;
    private static final int TYPE_WCHAR_T = 2;
    private static final int TYPE_SIZE_T = 3;
    static final int MAX_ALIGNMENT;
    static final int MAX_PADDING;
    private static final Object finalizer;
    static final String JNA_TMPLIB_PREFIX = "jna";
    private static Map registeredClasses;
    private static Map registeredLibraries;
    private static Object unloader;
    static final int CB_HAS_INITIALIZER = 1;
    private static final int CVT_UNSUPPORTED = -1;
    private static final int CVT_DEFAULT = 0;
    private static final int CVT_POINTER = 1;
    private static final int CVT_STRING = 2;
    private static final int CVT_STRUCTURE = 3;
    private static final int CVT_STRUCTURE_BYVAL = 4;
    private static final int CVT_BUFFER = 5;
    private static final int CVT_ARRAY_BYTE = 6;
    private static final int CVT_ARRAY_SHORT = 7;
    private static final int CVT_ARRAY_CHAR = 8;
    private static final int CVT_ARRAY_INT = 9;
    private static final int CVT_ARRAY_LONG = 10;
    private static final int CVT_ARRAY_FLOAT = 11;
    private static final int CVT_ARRAY_DOUBLE = 12;
    private static final int CVT_ARRAY_BOOLEAN = 13;
    private static final int CVT_BOOLEAN = 14;
    private static final int CVT_CALLBACK = 15;
    private static final int CVT_FLOAT = 16;
    private static final int CVT_NATIVE_MAPPED = 17;
    private static final int CVT_WSTRING = 18;
    private static final int CVT_INTEGER_TYPE = 19;
    private static final int CVT_POINTER_TYPE = 20;
    private static final int CVT_TYPE_MAPPER = 21;
    static final int CB_OPTION_DIRECT = 1;
    static final int CB_OPTION_IN_DLL = 2;
    private static Map nativeThreads;
    private static ThreadLocal nativeThreadTerminationFlag;

    private static void dispose() {
        NativeLibrary.disposeAll();
        jnidispatchPath = null;
    }

    static boolean deleteLibrary(File file) {
        if (file.delete()) {
            return true;
        }
        Native.markTemporaryFile(file);
        return false;
    }

    private Native() {
    }

    private static native void initIDs();

    public static synchronized native void setProtected(boolean var0);

    public static synchronized native boolean isProtected();

    public static void setPreserveLastError(boolean bl) {
    }

    public static boolean getPreserveLastError() {
        return true;
    }

    public static long getWindowID(Window window) throws HeadlessException {
        return AWT.getWindowID(window);
    }

    public static long getComponentID(Component component) throws HeadlessException {
        return AWT.getComponentID(component);
    }

    public static Pointer getWindowPointer(Window window) throws HeadlessException {
        return new Pointer(AWT.getWindowID(window));
    }

    public static Pointer getComponentPointer(Component component) throws HeadlessException {
        return new Pointer(AWT.getComponentID(component));
    }

    static native long getWindowHandle0(Component var0);

    public static Pointer getDirectBufferPointer(Buffer buffer) {
        long l2 = Native._getDirectBufferPointer(buffer);
        return l2 == 0L ? null : new Pointer(l2);
    }

    private static native long _getDirectBufferPointer(Buffer var0);

    public static String toString(byte[] byArray) {
        return Native.toString(byArray, Native.getDefaultStringEncoding());
    }

    public static String toString(byte[] byArray, String string) {
        int n2;
        String string2 = null;
        if (string != null) {
            try {
                string2 = new String(byArray, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("JNA Warning: Encoding '" + string + "' is unsupported");
            }
        }
        if (string2 == null) {
            System.err.println("JNA Warning: Decoding with fallback " + System.getProperty("file.encoding"));
            string2 = new String(byArray);
        }
        if ((n2 = string2.indexOf(0)) != -1) {
            string2 = string2.substring(0, n2);
        }
        return string2;
    }

    public static String toString(char[] cArray) {
        String string = new String(cArray);
        int n2 = string.indexOf(0);
        if (n2 != -1) {
            string = string.substring(0, n2);
        }
        return string;
    }

    public static Object loadLibrary(Class clazz) {
        return Native.loadLibrary(null, clazz);
    }

    public static Object loadLibrary(Class clazz, Map map) {
        return Native.loadLibrary(null, clazz, map);
    }

    public static Object loadLibrary(String string, Class clazz) {
        return Native.loadLibrary(string, clazz, Collections.EMPTY_MAP);
    }

    public static Object loadLibrary(String string, Class clazz, Map map) {
        Library.Handler handler = new Library.Handler(string, clazz, map);
        ClassLoader classLoader = clazz.getClassLoader();
        Library library = (Library)Proxy.newProxyInstance(classLoader, new Class[]{clazz}, (InvocationHandler)handler);
        Native.cacheOptions(clazz, map, library);
        return library;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibraryInstance(Class clazz) {
        Map map = libraries;
        synchronized (map) {
            if (clazz != null && !libraries.containsKey(clazz)) {
                try {
                    Field[] fieldArray = clazz.getFields();
                    for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                        Field field = fieldArray[i2];
                        if (field.getType() != clazz || !Modifier.isStatic(field.getModifiers())) continue;
                        libraries.put(clazz, new WeakReference<Object>(field.get(null)));
                        break;
                    }
                }
                catch (Exception exception) {
                    throw new IllegalArgumentException("Could not access instance of " + clazz + " (" + exception + ")");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class findEnclosingLibraryClass(Class clazz) {
        Class clazz2;
        if (clazz == null) {
            return null;
        }
        Object object = libraries;
        synchronized (object) {
            if (options.containsKey(clazz)) {
                return clazz;
            }
        }
        if (Library.class.isAssignableFrom(clazz)) {
            return clazz;
        }
        if (Callback.class.isAssignableFrom(clazz)) {
            clazz = CallbackReference.findCallbackClass((Class)clazz);
        }
        if ((clazz2 = Native.findEnclosingLibraryClass((Class)(object = clazz.getDeclaringClass()))) != null) {
            return clazz2;
        }
        return Native.findEnclosingLibraryClass(clazz.getSuperclass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLibraryOptions(Class clazz) {
        Object object = libraries;
        synchronized (object) {
            if (options.containsKey(clazz)) {
                return (Map)options.get(clazz);
            }
        }
        object = Native.findEnclosingLibraryClass(clazz);
        if (object != null) {
            Native.loadLibraryInstance((Class)object);
        } else {
            object = clazz;
        }
        Map map = libraries;
        synchronized (map) {
            if (options.containsKey(object)) {
                Map map2 = (Map)options.get(object);
                options.put(clazz, map2);
                return map2;
            }
            Map<String, Object> map3 = null;
            try {
                Field field = ((Class)object).getField("OPTIONS");
                field.setAccessible(true);
                map3 = (Map)field.get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                map3 = Collections.EMPTY_MAP;
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("OPTIONS must be a public field of type java.util.Map (" + exception + "): " + object);
            }
            map3 = new HashMap(map3);
            if (!map3.containsKey("type-mapper")) {
                map3.put("type-mapper", Native.lookupField((Class)object, "TYPE_MAPPER", TypeMapper.class));
            }
            if (!map3.containsKey("structure-alignment")) {
                map3.put("structure-alignment", Native.lookupField((Class)object, "STRUCTURE_ALIGNMENT", Integer.class));
            }
            if (!map3.containsKey("string-encoding")) {
                map3.put("string-encoding", Native.lookupField((Class)object, "STRING_ENCODING", String.class));
            }
            options.put(object, map3);
            if (clazz != object) {
                options.put(clazz, map3);
            }
            return map3;
        }
    }

    private static Object lookupField(Class clazz, String string, Class clazz2) {
        try {
            Field field = clazz.getField(string);
            field.setAccessible(true);
            return field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            return null;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string + " must be a public field of type " + clazz2.getName() + " (" + exception + "): " + clazz);
        }
    }

    public static TypeMapper getTypeMapper(Class clazz) {
        return (TypeMapper)Native.getLibraryOptions(clazz).get("type-mapper");
    }

    public static String getStringEncoding(Class clazz) {
        String string = (String)Native.getLibraryOptions(clazz).get("string-encoding");
        return string != null ? string : Native.getDefaultStringEncoding();
    }

    public static String getDefaultStringEncoding() {
        return System.getProperty("jna.encoding", DEFAULT_ENCODING);
    }

    public static int getStructureAlignment(Class clazz) {
        Integer n2 = (Integer)Native.getLibraryOptions(clazz).get("structure-alignment");
        return n2 == null ? 0 : n2;
    }

    static byte[] getBytes(String string) {
        return Native.getBytes(string, Native.getDefaultStringEncoding());
    }

    static byte[] getBytes(String string, String string2) {
        if (string2 != null) {
            try {
                return string.getBytes(string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                System.err.println("JNA Warning: Encoding '" + string2 + "' is unsupported");
            }
        }
        System.err.println("JNA Warning: Encoding with fallback " + System.getProperty("file.encoding"));
        return string.getBytes();
    }

    public static byte[] toByteArray(String string) {
        return Native.toByteArray(string, Native.getDefaultStringEncoding());
    }

    public static byte[] toByteArray(String string, String string2) {
        byte[] byArray = Native.getBytes(string, string2);
        byte[] byArray2 = new byte[byArray.length + 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    public static char[] toCharArray(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length + 1];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        return cArray2;
    }

    private static void loadNativeDispatchLibrary() {
        String string;
        File file;
        String string2;
        if (!Boolean.getBoolean("jna.nounpack")) {
            try {
                Native.removeTemporaryFiles();
            }
            catch (IOException iOException) {
                System.err.println("JNA Warning: IOException removing temporary files: " + iOException.getMessage());
            }
        }
        if ((string2 = new File(file = Resource.getLibDir(), string = "com/sun/jna/" + Platform.RESOURCE_PREFIX).getAbsolutePath()) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
            while (stringTokenizer.hasMoreTokens()) {
                String string3;
                String string4;
                String string5 = stringTokenizer.nextToken();
                File file2 = new File(new File(string5), System.mapLibraryName("jnidispatch").replace(".dylib", ".jnilib"));
                String string6 = file2.getAbsolutePath();
                if (DEBUG_JNA_LOAD) {
                    System.out.println("Looking in " + string6);
                }
                if (file2.exists()) {
                    try {
                        if (DEBUG_JNA_LOAD) {
                            System.out.println("Trying " + string6);
                        }
                        System.setProperty("jnidispatch.path", string6);
                        System.load(string6);
                        jnidispatchPath = string6;
                        if (DEBUG_JNA_LOAD) {
                            System.out.println("Found jnidispatch at " + string6);
                        }
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        // empty catch block
                    }
                }
                if (!Platform.isMac()) continue;
                if (string6.endsWith("dylib")) {
                    string4 = "dylib";
                    string3 = "jnilib";
                } else {
                    string4 = "jnilib";
                    string3 = "dylib";
                }
                string6 = string6.substring(0, string6.lastIndexOf(string4)) + string3;
                if (DEBUG_JNA_LOAD) {
                    System.out.println("Looking in " + string6);
                }
                if (!new File(string6).exists()) continue;
                try {
                    if (DEBUG_JNA_LOAD) {
                        System.out.println("Trying " + string6);
                    }
                    System.setProperty("jnidispatch.path", string6);
                    System.load(string6);
                    jnidispatchPath = string6;
                    if (DEBUG_JNA_LOAD) {
                        System.out.println("Found jnidispatch at " + string6);
                    }
                    return;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    System.err.println("File found at " + string6 + " but not loadable: " + unsatisfiedLinkError.getMessage());
                }
            }
        }
        if (!Boolean.getBoolean("jna.nosys")) {
            try {
                if (DEBUG_JNA_LOAD) {
                    System.out.println("Trying (via loadLibrary) jnidispatch");
                }
                System.loadLibrary("jnidispatch");
                if (DEBUG_JNA_LOAD) {
                    System.out.println("Found jnidispatch on system path");
                }
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        if (Boolean.getBoolean("jna.noclasspath")) {
            throw new UnsatisfiedLinkError("Unable to locate JNA native support library");
        }
        Native.loadNativeDispatchLibraryFromClasspath();
    }

    private static void loadNativeDispatchLibraryFromClasspath() {
        try {
            String string = "/com/sun/jna/" + Platform.RESOURCE_PREFIX + "/" + System.mapLibraryName("jnidispatch").replace(".dylib", ".jnilib");
            File file = Native.extractFromResourcePath(string, Native.class.getClassLoader());
            if (file == null && file == null) {
                throw new UnsatisfiedLinkError("Could not find JNA native support");
            }
            if (DEBUG_JNA_LOAD) {
                System.out.println("Trying " + file.getAbsolutePath());
            }
            System.setProperty("jnidispatch.path", file.getAbsolutePath());
            System.load(file.getAbsolutePath());
            jnidispatchPath = file.getAbsolutePath();
            if (DEBUG_JNA_LOAD) {
                System.out.println("Found jnidispatch at " + jnidispatchPath);
            }
            if (Native.isUnpacked(file) && !Boolean.getBoolean("jnidispatch.preserve")) {
                Native.deleteLibrary(file);
            }
        }
        catch (IOException iOException) {
            throw new UnsatisfiedLinkError(iOException.getMessage());
        }
    }

    static boolean isUnpacked(File file) {
        return file.getName().startsWith(JNA_TMPLIB_PREFIX);
    }

    public static File extractFromResourcePath(String string) throws IOException {
        return Native.extractFromResourcePath(string, null);
    }

    public static File extractFromResourcePath(String string, ClassLoader classLoader) throws IOException {
        URL uRL;
        String string2;
        boolean bl;
        boolean bl2 = bl = DEBUG_LOAD || DEBUG_JNA_LOAD && string.indexOf("jnidispatch") != -1;
        if (classLoader == null && (classLoader = Thread.currentThread().getContextClassLoader()) == null) {
            classLoader = Native.class.getClassLoader();
        }
        if (bl) {
            System.out.println("Looking in classpath from " + classLoader + " for " + string);
        }
        String string3 = string.startsWith("/") ? string : NativeLibrary.mapSharedLibraryName((String)string);
        String string4 = string2 = string.startsWith("/") ? string : Platform.RESOURCE_PREFIX + "/" + string3;
        if (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if ((uRL = classLoader.getResource(string2)) == null && string2.startsWith(Platform.RESOURCE_PREFIX)) {
            uRL = classLoader.getResource(string3);
        }
        if (uRL == null) {
            String string5 = System.getProperty("java.class.path");
            if (classLoader instanceof URLClassLoader) {
                string5 = Arrays.asList(((URLClassLoader)classLoader).getURLs()).toString();
            }
            throw new IOException("Native library (" + string2 + ") not found in resource path (" + string5 + ")");
        }
        if (bl) {
            System.out.println("Found library resource at " + uRL);
        }
        File file = null;
        if (uRL.getProtocol().toLowerCase().equals("file")) {
            try {
                file = new File(new URI(uRL.toString()));
            }
            catch (URISyntaxException uRISyntaxException) {
                file = new File(uRL.getPath());
            }
            if (bl) {
                System.out.println("Looking in " + file.getAbsolutePath());
            }
            if (!file.exists()) {
                throw new IOException("File URL " + uRL + " could not be properly decoded");
            }
        } else if (!Boolean.getBoolean("jna.nounpack")) {
            InputStream inputStream = classLoader.getResourceAsStream(string2);
            if (inputStream == null) {
                throw new IOException("Can't obtain InputStream for " + string2);
            }
            FileOutputStream fileOutputStream = null;
            try {
                int n2;
                File file2 = Native.getTempDir();
                file = File.createTempFile(JNA_TMPLIB_PREFIX, Platform.isWindows() ? ".dll" : null, file2);
                if (!Boolean.getBoolean("jnidispatch.preserve")) {
                    file.deleteOnExit();
                }
                fileOutputStream = new FileOutputStream(file);
                byte[] byArray = new byte[1024];
                while ((n2 = inputStream.read(byArray, 0, byArray.length)) > 0) {
                    fileOutputStream.write(byArray, 0, n2);
                }
            }
            catch (IOException iOException) {
                throw new IOException("Failed to create temporary file for " + string + " library: " + iOException.getMessage());
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return file;
    }

    private static native int sizeof(int var0);

    private static native String getNativeVersion();

    private static native String getAPIChecksum();

    public static native int getLastError();

    public static native void setLastError(int var0);

    public static Library synchronizedLibrary(final Library library) {
        Class<?> clazz = library.getClass();
        if (!Proxy.isProxyClass(clazz)) {
            throw new IllegalArgumentException("Library must be a proxy class");
        }
        InvocationHandler invocationHandler = Proxy.getInvocationHandler(library);
        if (!(invocationHandler instanceof Library.Handler)) {
            throw new IllegalArgumentException("Unrecognized proxy handler: " + invocationHandler);
        }
        final Library.Handler handler = (Library.Handler)invocationHandler;
        InvocationHandler invocationHandler2 = new InvocationHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
                NativeLibrary nativeLibrary = handler.getNativeLibrary();
                synchronized (nativeLibrary) {
                    return handler.invoke((Object)library, method, objectArray);
                }
            }
        };
        return (Library)Proxy.newProxyInstance(clazz.getClassLoader(), clazz.getInterfaces(), invocationHandler2);
    }

    public static String getWebStartLibraryPath(String string) {
        if (System.getProperty("javawebstart.version") == null) {
            return null;
        }
        try {
            ClassLoader classLoader = Native.class.getClassLoader();
            Method method = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Method method = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
                        method.setAccessible(true);
                        return method;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
            String string2 = (String)method.invoke((Object)classLoader, string);
            if (string2 != null) {
                return new File(string2).getParent();
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static void markTemporaryFile(File file) {
        try {
            File file2 = new File(file.getParentFile(), file.getName() + ".x");
            file2.createNewFile();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static File getTempDir() throws IOException {
        File file;
        String string = System.getProperty("jna.tmpdir");
        if (string != null) {
            file = new File(string);
            file.mkdirs();
        } else {
            File file2 = new File(System.getProperty("java.io.tmpdir"));
            file = new File(file2, "jna-" + System.getProperty("user.name").hashCode());
            file.mkdirs();
            if (!file.exists() || !file.canWrite()) {
                file = file2;
            }
        }
        if (!file.exists()) {
            throw new IOException("JNA temporary directory '" + file + "' does not exist");
        }
        if (!file.canWrite()) {
            throw new IOException("JNA temporary directory '" + file + "' is not writable");
        }
        return file;
    }

    static void removeTemporaryFiles() throws IOException {
        File file = Native.getTempDir();
        FilenameFilter filenameFilter = new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".x") && string.startsWith(Native.JNA_TMPLIB_PREFIX);
            }
        };
        File[] fileArray = file.listFiles(filenameFilter);
        for (int i2 = 0; fileArray != null && i2 < fileArray.length; ++i2) {
            File file2 = fileArray[i2];
            String string = file2.getName();
            string = string.substring(0, string.length() - 2);
            File file3 = new File(file2.getParentFile(), string);
            if (file3.exists() && !file3.delete()) continue;
            file2.delete();
        }
    }

    public static int getNativeSize(Class clazz, Object object) {
        if (clazz.isArray()) {
            int n2 = Array.getLength(object);
            if (n2 > 0) {
                Object object2 = Array.get(object, 0);
                return n2 * Native.getNativeSize(clazz.getComponentType(), object2);
            }
            throw new IllegalArgumentException("Arrays of length zero not allowed: " + clazz);
        }
        if (Structure.class.isAssignableFrom(clazz) && !Structure.ByReference.class.isAssignableFrom(clazz)) {
            return Structure.size((Class)clazz, (Structure)((Structure)object));
        }
        try {
            return Native.getNativeSize(clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("The type \"" + clazz.getName() + "\" is not supported: " + illegalArgumentException.getMessage());
        }
    }

    public static int getNativeSize(Class clazz) {
        if (NativeMapped.class.isAssignableFrom(clazz)) {
            clazz = NativeMappedConverter.getInstance((Class)clazz).nativeType();
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return 4;
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return 1;
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return 2;
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return WCHAR_SIZE;
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return 4;
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return 8;
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return 4;
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return 8;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            if (Structure.ByValue.class.isAssignableFrom(clazz)) {
                return Structure.size((Class)clazz);
            }
            return POINTER_SIZE;
        }
        if (Pointer.class.isAssignableFrom(clazz) || Platform.HAS_BUFFERS && Buffers.isBuffer(clazz) || Callback.class.isAssignableFrom(clazz) || String.class == clazz || WString.class == clazz) {
            return POINTER_SIZE;
        }
        throw new IllegalArgumentException("Native size for type \"" + clazz.getName() + "\" is unknown");
    }

    public static boolean isSupportedNativeType(Class clazz) {
        if (Structure.class.isAssignableFrom(clazz)) {
            return true;
        }
        try {
            return Native.getNativeSize(clazz) != 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    public static void setCallbackExceptionHandler(Callback.UncaughtExceptionHandler uncaughtExceptionHandler) {
        callbackExceptionHandler = uncaughtExceptionHandler == null ? DEFAULT_HANDLER : uncaughtExceptionHandler;
    }

    public static Callback.UncaughtExceptionHandler getCallbackExceptionHandler() {
        return callbackExceptionHandler;
    }

    public static void register(String string) {
        Native.register(Native.findDirectMappedClass(Native.getCallingClass()), string);
    }

    public static void register(NativeLibrary nativeLibrary) {
        Native.register(Native.findDirectMappedClass(Native.getCallingClass()), nativeLibrary);
    }

    static Class findDirectMappedClass(Class clazz) {
        int n2;
        Method[] methodArray = clazz.getDeclaredMethods();
        for (n2 = 0; n2 < methodArray.length; ++n2) {
            if ((methodArray[n2].getModifiers() & 0x100) == 0) continue;
            return clazz;
        }
        n2 = clazz.getName().lastIndexOf("$");
        if (n2 != -1) {
            String string = clazz.getName().substring(0, n2);
            try {
                return Native.findDirectMappedClass(Class.forName(string, true, clazz.getClassLoader()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Can't determine class with native methods from the current context (" + clazz + ")");
    }

    static Class getCallingClass() {
        Class[] classArray = new SecurityManager(){

            public Class[] getClassContext() {
                return super.getClassContext();
            }
        }.getClassContext();
        if (classArray == null) {
            throw new IllegalStateException("The SecurityManager implementation on this platform is broken; you must explicitly provide the class to register");
        }
        if (classArray.length < 4) {
            throw new IllegalStateException("This method must be called from the static initializer of a class");
        }
        return classArray[3];
    }

    public static void setCallbackThreadInitializer(Callback callback, CallbackThreadInitializer callbackThreadInitializer) {
        CallbackReference.setCallbackThreadInitializer((Callback)callback, (CallbackThreadInitializer)callbackThreadInitializer);
    }

    public static void unregister() {
        Native.unregister(Native.findDirectMappedClass(Native.getCallingClass()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Class clazz) {
        Map map = registeredClasses;
        synchronized (map) {
            if (registeredClasses.containsKey(clazz)) {
                Native.unregister(clazz, (long[])registeredClasses.get(clazz));
                registeredClasses.remove(clazz);
                registeredLibraries.remove(clazz);
            }
        }
    }

    private static native void unregister(Class var0, long[] var1);

    private static String getSignature(Class clazz) {
        if (clazz.isArray()) {
            return "[" + Native.getSignature(clazz.getComponentType());
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return "V";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
        }
        return "L" + Native.replace(".", "/", clazz.getName()) + ";";
    }

    static String replace(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder();
        while (true) {
            int n2;
            if ((n2 = string3.indexOf(string)) == -1) break;
            stringBuilder.append(string3.substring(0, n2));
            stringBuilder.append(string2);
            string3 = string3.substring(n2 + string.length());
        }
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    private static int getConversion(Class clazz, TypeMapper typeMapper) {
        if (clazz == Boolean.class) {
            clazz = Boolean.TYPE;
        } else if (clazz == Byte.class) {
            clazz = Byte.TYPE;
        } else if (clazz == Short.class) {
            clazz = Short.TYPE;
        } else if (clazz == Character.class) {
            clazz = Character.TYPE;
        } else if (clazz == Integer.class) {
            clazz = Integer.TYPE;
        } else if (clazz == Long.class) {
            clazz = Long.TYPE;
        } else if (clazz == Float.class) {
            clazz = Float.TYPE;
        } else if (clazz == Double.class) {
            clazz = Double.TYPE;
        } else if (clazz == Void.class) {
            clazz = Void.TYPE;
        }
        if (typeMapper != null && (typeMapper.getFromNativeConverter(clazz) != null || typeMapper.getToNativeConverter(clazz) != null)) {
            return 21;
        }
        if (Pointer.class.isAssignableFrom(clazz)) {
            return 1;
        }
        if (String.class == clazz) {
            return 2;
        }
        if (WString.class.isAssignableFrom(clazz)) {
            return 18;
        }
        if (Platform.HAS_BUFFERS && Buffers.isBuffer(clazz)) {
            return 5;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            if (Structure.ByValue.class.isAssignableFrom(clazz)) {
                return 4;
            }
            return 3;
        }
        if (clazz.isArray()) {
            switch (clazz.getName().charAt(1)) {
                case 'Z': {
                    return 13;
                }
                case 'B': {
                    return 6;
                }
                case 'S': {
                    return 7;
                }
                case 'C': {
                    return 8;
                }
                case 'I': {
                    return 9;
                }
                case 'J': {
                    return 10;
                }
                case 'F': {
                    return 11;
                }
                case 'D': {
                    return 12;
                }
            }
        }
        if (clazz.isPrimitive()) {
            return clazz == Boolean.TYPE ? 14 : 0;
        }
        if (Callback.class.isAssignableFrom(clazz)) {
            return 15;
        }
        if (IntegerType.class.isAssignableFrom(clazz)) {
            return 19;
        }
        if (PointerType.class.isAssignableFrom(clazz)) {
            return 20;
        }
        if (NativeMapped.class.isAssignableFrom(clazz)) {
            return 17;
        }
        return -1;
    }

    public static void register(Class clazz, String string) {
        HashMap<String, ClassLoader> hashMap = new HashMap<String, ClassLoader>();
        hashMap.put("classloader", clazz.getClassLoader());
        Native.register(clazz, NativeLibrary.getInstance((String)string, hashMap));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Class clazz, NativeLibrary nativeLibrary) {
        Method[] methodArray = clazz.getDeclaredMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        TypeMapper typeMapper = (TypeMapper)nativeLibrary.getOptions().get("type-mapper");
        for (int i2 = 0; i2 < methodArray.length; ++i2) {
            if ((methodArray[i2].getModifiers() & 0x100) == 0) continue;
            arrayList.add(methodArray[i2]);
        }
        long[] lArray = new long[arrayList.size()];
        for (int i3 = 0; i3 < lArray.length; ++i3) {
            Class clazz2;
            long l2;
            long l3;
            Method method = (Method)arrayList.get(i3);
            String string = "(";
            Class<?> clazz3 = method.getReturnType();
            Class<?>[] classArray = method.getParameterTypes();
            long[] lArray2 = new long[classArray.length];
            long[] lArray3 = new long[classArray.length];
            int[] nArray = new int[classArray.length];
            ToNativeConverter[] toNativeConverterArray = new ToNativeConverter[classArray.length];
            FromNativeConverter fromNativeConverter = null;
            int n2 = Native.getConversion(clazz3, typeMapper);
            boolean bl = false;
            switch (n2) {
                case -1: {
                    throw new IllegalArgumentException(clazz3 + " is not a supported return type (in method " + method.getName() + " in " + clazz + ")");
                }
                case 21: {
                    fromNativeConverter = typeMapper.getFromNativeConverter(clazz3);
                    l3 = Structure.FFIType.get(clazz3).peer;
                    l2 = Structure.FFIType.get((Object)fromNativeConverter.nativeType()).peer;
                    break;
                }
                case 17: 
                case 19: 
                case 20: {
                    l3 = Structure.FFIType.get(Pointer.class).peer;
                    l2 = Structure.FFIType.get((Object)NativeMappedConverter.getInstance(clazz3).nativeType()).peer;
                    break;
                }
                case 3: {
                    l3 = l2 = Structure.FFIType.get(Pointer.class).peer;
                    break;
                }
                case 4: {
                    l3 = Structure.FFIType.get(Pointer.class).peer;
                    l2 = Structure.FFIType.get(clazz3).peer;
                    break;
                }
                default: {
                    l3 = l2 = Structure.FFIType.get(clazz3).peer;
                }
            }
            block19: for (int i4 = 0; i4 < classArray.length; ++i4) {
                clazz2 = classArray[i4];
                string = string + Native.getSignature(clazz2);
                nArray[i4] = Native.getConversion(clazz2, typeMapper);
                if (nArray[i4] == -1) {
                    throw new IllegalArgumentException(clazz2 + " is not a supported argument type (in method " + method.getName() + " in " + clazz + ")");
                }
                if (nArray[i4] == 17 || nArray[i4] == 19) {
                    clazz2 = NativeMappedConverter.getInstance(clazz2).nativeType();
                } else if (nArray[i4] == 21) {
                    toNativeConverterArray[i4] = typeMapper.getToNativeConverter(clazz2);
                }
                switch (nArray[i4]) {
                    case 4: 
                    case 17: 
                    case 19: 
                    case 20: {
                        lArray2[i4] = Structure.FFIType.get((Object)clazz2).peer;
                        lArray3[i4] = Structure.FFIType.get(Pointer.class).peer;
                        continue block19;
                    }
                    case 21: {
                        lArray3[i4] = clazz2.isPrimitive() ? Structure.FFIType.get((Object)clazz2).peer : Structure.FFIType.get(Pointer.class).peer;
                        lArray2[i4] = Structure.FFIType.get((Object)toNativeConverterArray[i4].nativeType()).peer;
                        continue block19;
                    }
                    case 0: {
                        lArray3[i4] = lArray2[i4] = Structure.FFIType.get((Object)clazz2).peer;
                        continue block19;
                    }
                    default: {
                        lArray3[i4] = lArray2[i4] = Structure.FFIType.get(Pointer.class).peer;
                    }
                }
            }
            string = string + ")";
            string = string + Native.getSignature(clazz3);
            Class<?>[] classArray2 = method.getExceptionTypes();
            for (int i5 = 0; i5 < classArray2.length; ++i5) {
                if (!LastErrorException.class.isAssignableFrom(classArray2[i5])) continue;
                bl = true;
                break;
            }
            clazz2 = nativeLibrary.getFunction(method.getName(), method);
            try {
                lArray[i3] = Native.registerMethod(clazz, method.getName(), string, nArray, lArray3, lArray2, n2, l3, l2, clazz3, ((Function)clazz2).peer, clazz2.getCallingConvention(), bl, toNativeConverterArray, fromNativeConverter, ((Function)clazz2).encoding);
                continue;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                throw new UnsatisfiedLinkError("No method " + method.getName() + " with signature " + string + " in " + clazz);
            }
        }
        Map map = registeredClasses;
        synchronized (map) {
            registeredClasses.put(clazz, lArray);
            registeredLibraries.put(clazz, nativeLibrary);
        }
        Native.cacheOptions(clazz, nativeLibrary.getOptions(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheOptions(Class clazz, Map hashMap, Object object) {
        hashMap = new HashMap(hashMap);
        Map map = libraries;
        synchronized (map) {
            options.put(clazz, hashMap);
            if (object != null) {
                libraries.put(clazz, new WeakReference<Object>(object));
            }
            if (!clazz.isInterface() && Library.class.isAssignableFrom(clazz)) {
                Class<?>[] classArray = clazz.getInterfaces();
                for (int i2 = 0; i2 < classArray.length; ++i2) {
                    if (!Library.class.isAssignableFrom(classArray[i2])) continue;
                    Native.cacheOptions(classArray[i2], hashMap, object);
                    break;
                }
            }
        }
    }

    private static native long registerMethod(Class var0, String var1, String var2, int[] var3, long[] var4, long[] var5, int var6, long var7, long var9, Class var11, long var12, int var14, boolean var15, ToNativeConverter[] var16, FromNativeConverter var17, String var18);

    private static NativeMapped fromNative(Class clazz, Object object) {
        return (NativeMapped)NativeMappedConverter.getInstance((Class)clazz).fromNative(object, new FromNativeContext(clazz));
    }

    private static Class nativeType(Class clazz) {
        return NativeMappedConverter.getInstance((Class)clazz).nativeType();
    }

    private static Object toNative(ToNativeConverter toNativeConverter, Object object) {
        return toNativeConverter.toNative(object, new ToNativeContext());
    }

    private static Object fromNative(FromNativeConverter fromNativeConverter, Object object, Class clazz) {
        return fromNativeConverter.fromNative(object, new FromNativeContext(clazz));
    }

    public static native long ffi_prep_cif(int var0, int var1, long var2, long var4);

    public static native void ffi_call(long var0, long var2, long var4, long var6);

    public static native long ffi_prep_closure(long var0, ffi_callback var2);

    public static native void ffi_free_closure(long var0);

    static native int initialize_ffi_type(long var0);

    public static void main(String[] stringArray) {
        String string;
        String string2;
        Package package_ = Native.class.getPackage();
        String string3 = string2 = package_ != null ? package_.getSpecificationTitle() : "Java Native Access (JNA)";
        if (string2 == null) {
            string2 = "Java Native Access (JNA)";
        }
        String string4 = string = package_ != null ? package_.getSpecificationVersion() : "4.1.0";
        if (string == null) {
            string = "4.1.0";
        }
        string2 = string2 + " API Version " + string;
        System.out.println(string2);
        String string5 = string = package_ != null ? package_.getImplementationVersion() : "4.1.0 (package information missing)";
        if (string == null) {
            string = "4.1.0 (package information missing)";
        }
        System.out.println("Version: " + string);
        System.out.println(" Native: " + Native.getNativeVersion() + " (" + Native.getAPIChecksum() + ")");
        System.out.println(" Prefix: " + Platform.RESOURCE_PREFIX);
    }

    static synchronized native void freeNativeCallback(long var0);

    static synchronized native long createNativeCallback(Callback var0, Method var1, Class[] var2, Class var3, int var4, int var5, String var6);

    static native int invokeInt(long var0, int var2, Object[] var3);

    static native long invokeLong(long var0, int var2, Object[] var3);

    static native void invokeVoid(long var0, int var2, Object[] var3);

    static native float invokeFloat(long var0, int var2, Object[] var3);

    static native double invokeDouble(long var0, int var2, Object[] var3);

    static native long invokePointer(long var0, int var2, Object[] var3);

    private static native void invokeStructure(long var0, int var2, Object[] var3, long var4, long var6);

    static Structure invokeStructure(long l2, int n2, Object[] objectArray, Structure structure) {
        Native.invokeStructure(l2, n2, objectArray, structure.getPointer().peer, structure.getTypeInfo().peer);
        return structure;
    }

    static native Object invokeObject(long var0, int var2, Object[] var3);

    static long open(String string) {
        return Native.open(string, -1);
    }

    static native long open(String var0, int var1);

    static native void close(long var0);

    static native long findSymbol(long var0, String var2);

    static native long indexOf(long var0, byte var2);

    static native void read(long var0, byte[] var2, int var3, int var4);

    static native void read(long var0, short[] var2, int var3, int var4);

    static native void read(long var0, char[] var2, int var3, int var4);

    static native void read(long var0, int[] var2, int var3, int var4);

    static native void read(long var0, long[] var2, int var3, int var4);

    static native void read(long var0, float[] var2, int var3, int var4);

    static native void read(long var0, double[] var2, int var3, int var4);

    static native void write(long var0, byte[] var2, int var3, int var4);

    static native void write(long var0, short[] var2, int var3, int var4);

    static native void write(long var0, char[] var2, int var3, int var4);

    static native void write(long var0, int[] var2, int var3, int var4);

    static native void write(long var0, long[] var2, int var3, int var4);

    static native void write(long var0, float[] var2, int var3, int var4);

    static native void write(long var0, double[] var2, int var3, int var4);

    static native byte getByte(long var0);

    static native char getChar(long var0);

    static native short getShort(long var0);

    static native int getInt(long var0);

    static native long getLong(long var0);

    static native float getFloat(long var0);

    static native double getDouble(long var0);

    static Pointer getPointer(long l2) {
        long l3 = Native._getPointer(l2);
        return l3 == 0L ? null : new Pointer(l3);
    }

    private static native long _getPointer(long var0);

    static native String getWideString(long var0);

    static String getString(long l2) {
        return Native.getString(l2, Native.getDefaultStringEncoding());
    }

    static String getString(long l2, String string) {
        byte[] byArray = Native.getStringBytes(l2);
        if (string != null) {
            try {
                return new String(byArray, string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(byArray);
    }

    static native byte[] getStringBytes(long var0);

    static native void setMemory(long var0, long var2, byte var4);

    static native void setByte(long var0, byte var2);

    static native void setShort(long var0, short var2);

    static native void setChar(long var0, char var2);

    static native void setInt(long var0, int var2);

    static native void setLong(long var0, long var2);

    static native void setFloat(long var0, float var2);

    static native void setDouble(long var0, double var2);

    static native void setPointer(long var0, long var2);

    static native void setWideString(long var0, String var2);

    public static native long malloc(long var0);

    public static native void free(long var0);

    public static native ByteBuffer getDirectByteBuffer(long var0, long var2);

    public static void detach(boolean bl) {
        Thread thread = Thread.currentThread();
        if (bl) {
            nativeThreads.remove(thread);
            Pointer pointer = (Pointer)nativeThreadTerminationFlag.get();
            Native.setDetachState(true, 0L);
        } else if (!nativeThreads.containsKey(thread)) {
            Pointer pointer = (Pointer)nativeThreadTerminationFlag.get();
            nativeThreads.put(thread, pointer);
            Native.setDetachState(false, pointer.peer);
        }
    }

    static Pointer getTerminationFlag(Thread thread) {
        return (Pointer)nativeThreads.get(thread);
    }

    private static native void setDetachState(boolean var0, long var1);

    static {
        String string;
        DEBUG_LOAD = Boolean.getBoolean("jna.debug_load");
        DEBUG_JNA_LOAD = Boolean.getBoolean("jna.debug_load.jna");
        jnidispatchPath = null;
        options = new WeakHashMap();
        libraries = new WeakHashMap();
        callbackExceptionHandler = DEFAULT_HANDLER = new Callback.UncaughtExceptionHandler(){

            public void uncaughtException(Callback callback, Throwable throwable) {
                System.err.println("JNA: Callback " + callback + " threw the following exception:");
                throwable.printStackTrace();
            }
        };
        Native.loadNativeDispatchLibrary();
        POINTER_SIZE = Native.sizeof(0);
        LONG_SIZE = Native.sizeof(1);
        WCHAR_SIZE = Native.sizeof(2);
        SIZE_T_SIZE = Native.sizeof(3);
        Native.initIDs();
        if (Boolean.getBoolean("jna.protected")) {
            Native.setProtected(true);
        }
        if (!"4.0.0".equals(string = Native.getNativeVersion())) {
            String string2 = System.getProperty("line.separator");
            throw new Error(string2 + string2 + "There is an incompatible JNA native library installed on this system" + string2 + (jnidispatchPath != null ? "(at " + jnidispatchPath + ")" : System.getProperty("java.library.path")) + "." + string2 + "To resolve this issue you may do one of the following:" + string2 + " - remove or uninstall the offending library" + string2 + " - set the system property jna.nosys=true" + string2 + " - set jna.boot.library.path to include the path to the version of the " + string2 + "   jnidispatch library included with the JNA jar file you are using" + string2);
        }
        MAX_ALIGNMENT = Platform.isSPARC() || Platform.isWindows() || Platform.isLinux() && (Platform.isARM() || Platform.isPPC()) || Platform.isAIX() || Platform.isAndroid() ? 8 : LONG_SIZE;
        MAX_PADDING = Platform.isMac() && Platform.isPPC() ? 8 : MAX_ALIGNMENT;
        finalizer = new Object(){

            protected void finalize() {
                Native.dispose();
            }
        };
        registeredClasses = new HashMap();
        registeredLibraries = new HashMap();
        unloader = new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() {
                Map map = registeredClasses;
                synchronized (map) {
                    Iterator iterator = registeredClasses.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = iterator.next();
                        Native.unregister((Class)entry.getKey(), (long[])entry.getValue());
                        iterator.remove();
                    }
                }
            }
        };
        nativeThreads = Collections.synchronizedMap(new WeakHashMap());
        nativeThreadTerminationFlag = new ThreadLocal(){

            protected Object initialValue() {
                Memory memory = new Memory(4L);
                memory.clear();
                return memory;
            }
        };
    }

    private static class AWT {
        private AWT() {
        }

        static long getWindowID(Window window) throws HeadlessException {
            return AWT.getComponentID(window);
        }

        static long getComponentID(Object object) throws HeadlessException {
            if (GraphicsEnvironment.isHeadless()) {
                throw new HeadlessException("No native windows when headless");
            }
            Component component = (Component)object;
            if (component.isLightweight()) {
                throw new IllegalArgumentException("Component must be heavyweight");
            }
            if (!component.isDisplayable()) {
                throw new IllegalStateException("Component must be displayable");
            }
            if (Platform.isX11() && System.getProperty("java.version").startsWith("1.4") && !component.isVisible()) {
                throw new IllegalStateException("Component must be visible");
            }
            return Native.getWindowHandle0(component);
        }
    }

    private static class Buffers {
        private Buffers() {
        }

        static boolean isBuffer(Class clazz) {
            return Buffer.class.isAssignableFrom(clazz);
        }
    }

    public static interface ffi_callback {
        public void invoke(long var1, long var3, long var5);
    }
}

