/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.pattern;

import com.icl.saxon.Context;
import com.icl.saxon.expr.ExpressionParser;
import com.icl.saxon.expr.StaticContext;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeInfo;

public abstract class Pattern {
    protected StaticContext staticContext;
    protected String originalText;

    public static Pattern make(String string, StaticContext staticContext) throws XPathException {
        ExpressionParser expressionParser = new ExpressionParser();
        Pattern pattern = expressionParser.parsePattern(string, staticContext).simplify();
        expressionParser.checkPatternFiltersUsesCurrent(pattern);
        pattern.staticContext = staticContext;
        pattern.setOriginalText(string);
        return pattern;
    }

    public void setOriginalText(String string) {
        this.originalText = string;
    }

    public Pattern simplify() throws XPathException {
        return this;
    }

    public final void setStaticContext(StaticContext staticContext) {
        this.staticContext = staticContext;
    }

    public StaticContext getStaticContext() {
        return this.staticContext;
    }

    public abstract boolean matches(NodeInfo var1, Context var2) throws XPathException;

    public short getNodeType() {
        return 0;
    }

    public int getFingerprint() {
        return -1;
    }

    public double getDefaultPriority() {
        return 0.5;
    }

    public String getSystemId() {
        return this.staticContext.getSystemId();
    }

    public int getLineNumber() {
        return this.staticContext.getLineNumber();
    }

    public String toString() {
        return this.originalText;
    }
}

