/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.pattern;

import com.icl.saxon.Context;
import com.icl.saxon.expr.BooleanValue;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.IsLastExpression;
import com.icl.saxon.expr.NumericValue;
import com.icl.saxon.expr.ParentNodeExpression;
import com.icl.saxon.expr.PathExpression;
import com.icl.saxon.expr.Step;
import com.icl.saxon.expr.Value;
import com.icl.saxon.expr.XPathException;
import com.icl.saxon.om.NodeEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.AnyNodeTest;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.pattern.Pattern;

public final class LocationPathPattern
extends Pattern {
    public Pattern parentPattern = null;
    public Pattern ancestorPattern = null;
    public NodeTest nodeTest = AnyNodeTest.getInstance();
    protected Expression[] filters = null;
    protected int numberOfFilters = 0;
    protected Expression equivalentExpr = null;
    protected boolean firstElementPattern = false;
    protected boolean lastElementPattern = false;
    protected boolean specialFilter = false;

    public void addFilter(Expression expression) {
        if (this.filters == null) {
            this.filters = new Expression[3];
        } else if (this.numberOfFilters == this.filters.length) {
            Expression[] expressionArray = new Expression[this.numberOfFilters * 2];
            System.arraycopy(this.filters, 0, expressionArray, 0, this.numberOfFilters);
            this.filters = expressionArray;
        }
        this.filters[this.numberOfFilters++] = expression;
    }

    @Override
    public Pattern simplify() throws XPathException {
        if (this.parentPattern == null && this.ancestorPattern == null && this.filters == null) {
            this.nodeTest.setStaticContext(this.getStaticContext());
            return this.nodeTest;
        }
        if (this.parentPattern != null) {
            this.parentPattern = this.parentPattern.simplify();
        }
        if (this.ancestorPattern != null) {
            this.ancestorPattern = this.ancestorPattern.simplify();
        }
        if (this.filters != null) {
            for (int i2 = this.numberOfFilters - 1; i2 >= 0; --i2) {
                Expression expression;
                this.filters[i2] = expression = this.filters[i2].simplify();
                if (!(expression instanceof BooleanValue) || !((Value)expression).asBoolean() || i2 != this.numberOfFilters - 1) continue;
                --this.numberOfFilters;
            }
        }
        if (this.nodeTest.getNodeType() == 1 && this.numberOfFilters == 1 && this.filters[0] instanceof NumericValue && (int)((NumericValue)this.filters[0]).asNumber() == 1) {
            this.firstElementPattern = true;
            this.specialFilter = true;
            this.numberOfFilters = 0;
            this.filters = null;
        }
        if (this.nodeTest.getNodeType() == 1 && this.numberOfFilters == 1 && this.filters[0] instanceof IsLastExpression && ((IsLastExpression)this.filters[0]).getCondition()) {
            this.lastElementPattern = true;
            this.specialFilter = true;
            this.numberOfFilters = 0;
            this.filters = null;
        }
        if (this.isRelative()) {
            this.makeEquivalentExpression();
            this.specialFilter = true;
        }
        return this;
    }

    private void makeEquivalentExpression() throws XPathException {
        byte by = this.nodeTest.getNodeType() == 2 ? (byte)2 : 3;
        Step step = new Step(by, this.nodeTest);
        step.setFilters(this.filters, this.numberOfFilters);
        this.equivalentExpr = new PathExpression((Expression)new ParentNodeExpression(), step);
    }

    public boolean matchesX(NodeInfo nodeInfo, Context context) throws XPathException {
        System.err.println("Matching node " + nodeInfo + " against LP pattern " + this);
        System.err.println("Node types " + nodeInfo.getNodeType() + " / " + this.getNodeType());
        boolean bl = this.matches(nodeInfo, context);
        System.err.println(bl ? "matches" : "no match");
        return bl;
    }

    @Override
    public boolean matches(NodeInfo nodeInfo, Context context) throws XPathException {
        NodeInfo nodeInfo2;
        if (!this.nodeTest.matches(nodeInfo)) {
            return false;
        }
        if (this.parentPattern != null) {
            nodeInfo2 = nodeInfo.getParent();
            if (nodeInfo2 == null) {
                return false;
            }
            if (!this.parentPattern.matches(nodeInfo2, context)) {
                return false;
            }
        }
        if (this.ancestorPattern != null) {
            nodeInfo2 = nodeInfo.getParent();
            while (!this.ancestorPattern.matches(nodeInfo2, context)) {
                if ((nodeInfo2 = nodeInfo2.getParent()) != null) continue;
                return false;
            }
        }
        if (this.specialFilter) {
            if (this.firstElementPattern) {
                nodeInfo2 = nodeInfo.getEnumeration((byte)11, this.nodeTest);
                return !nodeInfo2.hasMoreElements();
            }
            if (this.lastElementPattern) {
                nodeInfo2 = nodeInfo.getEnumeration((byte)7, this.nodeTest);
                return !nodeInfo2.hasMoreElements();
            }
            if (this.equivalentExpr != null) {
                nodeInfo2 = context.newContext();
                nodeInfo2.setContextNode(nodeInfo);
                nodeInfo2.setPosition(1);
                nodeInfo2.setLast(1);
                NodeEnumeration nodeEnumeration = this.equivalentExpr.enumerate((Context)nodeInfo2, false);
                while (nodeEnumeration.hasMoreElements()) {
                    NodeInfo nodeInfo3 = nodeEnumeration.nextElement();
                    if (!nodeInfo3.isSameNodeInfo(nodeInfo)) continue;
                    return true;
                }
                return false;
            }
        }
        if (this.filters != null) {
            nodeInfo2 = context.newContext();
            nodeInfo2.setContextNode(nodeInfo);
            nodeInfo2.setPosition(1);
            nodeInfo2.setLast(1);
            for (int i2 = 0; i2 < this.numberOfFilters; ++i2) {
                if (this.filters[i2].evaluateAsBoolean((Context)nodeInfo2)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public short getNodeType() {
        return this.nodeTest.getNodeType();
    }

    @Override
    public int getFingerprint() {
        return this.nodeTest.getFingerprint();
    }

    public boolean isRelative() throws XPathException {
        if (this.filters == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.numberOfFilters; ++i2) {
            int n2 = this.filters[i2].getDataType();
            if (n2 == 2 || n2 == -1) {
                return true;
            }
            if ((this.filters[i2].getDependencies() & 0x30) == 0) continue;
            return true;
        }
        return false;
    }

    public Expression[] getFilters() {
        return this.filters;
    }

    public int getNumberOfFilters() {
        return this.numberOfFilters;
    }
}

